(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     57969,       1441]
NotebookOptionsPosition[     52963,       1298]
NotebookOutlinePosition[     55570,       1359]
CellTagsIndexPosition[     55527,       1356]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "LimitOrders\n",
 StyleBox["Empirical Market Microstructure",
  FontSlant->"Italic"],
 " \n\t(2006, Oxford University Press)\nCompanion ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook\n\nJoel Hasbrouck\n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Copyright", " ", "2007"}], ",", " ", 
    RowBox[{"Joel", " ", 
     RowBox[{"Hasbrouck", ".", " ", "All"}], " ", "rights", " ", 
     RowBox[{"reserved", "."}]}]}], TraditionalForm]],
  FontSize->14,
  FontSlant->"Italic"],
 "\n",
 StyleBox["This notebook covers material related to the initial analysis of \
limit orders in Chapter 12, Section 12.1",
  FontSize->14]
}], "Title",
 CellChangeTimes->{{3.3896255910914*^9, 3.3896255932033997`*^9}, {
   3.3897167078988237`*^9, 3.389716768500824*^9}, 3.3897219191158237`*^9, {
   3.3899919263996*^9, 3.3899919275346003`*^9}, {3.3899924133546*^9, 
   3.3899924443206*^9}, {3.39003008487543*^9, 3.3900301039984303`*^9}, {
   3.3900303920914307`*^9, 3.3900304077484303`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Text", "  ", "@", " ", 
  RowBox[{"Style", "[", 
   RowBox[{
    RowBox[{"\"\<Notebook evaluated \>\"", "<>", 
     RowBox[{"DateString", "[", "\"\<DateTime\>\"", "]"}]}], ",", 
    "\"\<Subtitle\>\""}], "]"}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896127180972*^9, 3.3896127205282*^9}, 
   3.389716999411824*^9, {3.3897170351038237`*^9, 3.389717047196824*^9}}],

Cell[BoxData[
 InterpretationBox[Cell[BoxData[
   StyleBox["\<\"Notebook evaluated Tuesday 5 June 2007 07:11:10\"\>", 
    "Subtitle",
    StripOnInput->False]], "Text", "TR"],
  Text[
   Style["Notebook evaluated Tuesday 5 June 2007 07:11:10", 
    "Subtitle"]]]], "Output",
 CellMargins->{{18, Inherited}, {Inherited, 0}},
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896127211071997`*^9, {3.3896127536242*^9, 3.3896127555652*^9}, 
   3.3896128616452*^9, 3.389623031447*^9, 3.3896232934164*^9, 
   3.389716955274824*^9, 3.3897170008718243`*^9, {3.3897170377738237`*^9, 
   3.3897170482808237`*^9}, 3.3899920823416*^9, 3.3899921326345997`*^9, 
   3.3899925422046003`*^9, 3.3900306704554305`*^9},
 Background->RGBColor[0.866667, 0.733333, 1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Initializations", "Section"],

Cell[BoxData[
 RowBox[{"<<", "Notation`"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896332775168*^9, 3.3896332823518*^9}, 
   3.3896333264802*^9}],

Cell["\<\
The following commands define symbolizations that are convenient for labeling \
things.\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["Anything_", "Rule"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";", 
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["Anything_", "Rules"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";"}]], "Input",
 CellLabelAutoDelete->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Limit order submission strategies (section 12.1)", "Section"],

Cell["CARA utility:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["EU", "Rule"], "=", 
  RowBox[{
   RowBox[{"EU", "[", 
    RowBox[{"\[Mu]_", ",", "var_"}], "]"}], "\[RuleDelayed]", 
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"CharacteristicFunction", "[", 
       RowBox[{
        RowBox[{"NormalDistribution", "[", 
         RowBox[{"\[Mu]", ",", 
          SqrtBox["var"]}], "]"}], ",", "t"}], "]"}]}], "/.", 
     RowBox[{"t", "\[Rule]", 
      RowBox[{"I", " ", "\[Alpha]"}]}]}], "]"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"EU", "[", 
   RowBox[{"\[Mu]_", ",", "var_"}], "]"}], "\[RuleDelayed]", 
  RowBox[{"-", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     FractionBox[
      RowBox[{"var", " ", 
       SuperscriptBox["\[Alpha]", "2"]}], "2"], "-", 
     RowBox[{"\[Alpha]", " ", "\[Mu]"}]}]]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896333380962*^9, 3.3900306721074305`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["CE", "Rule"], "=", 
  RowBox[{
   RowBox[{"CE", "[", 
    RowBox[{"\[Mu]_", ",", "var_"}], "]"}], "\[RuleDelayed]", 
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Exponent", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"CharacteristicFunction", "[", 
            RowBox[{
             RowBox[{"NormalDistribution", "[", 
              RowBox[{"\[Mu]", ",", 
               SqrtBox["var"]}], "]"}], ",", "t"}], "]"}]}], "/.", 
          RowBox[{"t", "\[Rule]", 
           RowBox[{"I", " ", "\[Alpha]"}]}]}], ",", "E"}], "]"}]}], "/", 
      "\[Alpha]"}], "//", "Simplify"}], "]"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"CE", "[", 
   RowBox[{"\[Mu]_", ",", "var_"}], "]"}], "\[RuleDelayed]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"var", " ", "\[Alpha]"}], "2"]}], "+", "\[Mu]"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896333381472*^9, 3.39003067219843*^9}]
}, Open  ]],

Cell["Get optimal holdings via f.o.c. of certainty equivalent.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["nOpt", "Rule"], "=", 
  RowBox[{"First", " ", "@", " ", 
   RowBox[{"First", " ", "@", " ", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["\[PartialD]", "n"], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"CE", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"n", " ", 
              SubscriptBox["\[Mu]", "X"]}], "-", 
             RowBox[{"n", " ", "P"}]}], ",", " ", 
            RowBox[{
             SuperscriptBox["n", "2"], 
             SubsuperscriptBox["\[Sigma]", "X", "2"]}]}], "]"}], "/.", 
          SubscriptBox["CE", "Rule"]}], ")"}]}], "\[Equal]", "0"}], ",", 
      "n"}], "]"}]}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"n", "\[Rule]", 
  FractionBox[
   RowBox[{
    RowBox[{"-", "P"}], "+", 
    SubscriptBox["\[Mu]", "X"]}], 
   RowBox[{"\[Alpha]", " ", 
    SubsuperscriptBox["\[Sigma]", "X", "2"]}]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896333381902*^9, 3.3900306722794304`*^9}]
}, Open  ]],

Cell["The expected utility of a limit order strategy is:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["EU", "Limit"], "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["Pr", "Hit"], "[", 
     RowBox[{"L", ",", "\[Lambda]", ",", "\[Theta]"}], "]"}], 
    RowBox[{"EU", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], " ", 
        SubscriptBox["\[Mu]", "X"]}], "-", "L"}], ",", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "2"], 
       SubsuperscriptBox["\[Sigma]", "X", "2"]}]}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{
       SubscriptBox["Pr", "Hit"], "[", 
       RowBox[{"L", ",", "\[Lambda]", ",", "\[Theta]"}], "]"}]}], ")"}], 
    RowBox[{"EU", "[", 
     RowBox[{
      RowBox[{"n", " ", 
       SubscriptBox["\[Mu]", "X"]}], ",", 
      RowBox[{
       SuperscriptBox["n", "2"], 
       SubsuperscriptBox["\[Sigma]", "X", "2"]}]}], "]"}]}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"EU", "[", 
    RowBox[{
     RowBox[{"n", " ", 
      SubscriptBox["\[Mu]", "X"]}], ",", 
     RowBox[{
      SuperscriptBox["n", "2"], " ", 
      SubsuperscriptBox["\[Sigma]", "X", "2"]}]}], "]"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{
      SubscriptBox["Pr", "Hit"], "[", 
      RowBox[{"L", ",", "\[Lambda]", ",", "\[Theta]"}], "]"}]}], ")"}]}], "+",
   
  RowBox[{
   RowBox[{"EU", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "L"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "n"}], ")"}], " ", 
       SubscriptBox["\[Mu]", "X"]}]}], ",", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "n"}], ")"}], "2"], " ", 
      SubsuperscriptBox["\[Sigma]", "X", "2"]}]}], "]"}], " ", 
   RowBox[{
    SubscriptBox["Pr", "Hit"], "[", 
    RowBox[{"L", ",", "\[Lambda]", ",", "\[Theta]"}], "]"}]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896333382232*^9, 3.3900306723664303`*^9}]
}, Open  ]],

Cell["Noting that:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDF", "[", 
  RowBox[{
   RowBox[{"ExponentialDistribution", "[", "\[Lambda]", "]"}], ",", 
   RowBox[{"L", "-", "\[Theta]"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {
     RowBox[{"1", "-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"L", "-", "\[Theta]"}], ")"}]}], " ", "\[Lambda]"}]]}], 
     RowBox[{
      RowBox[{"L", "-", "\[Theta]"}], ">", "0"}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896333382572002`*^9, 3.3900306724514303`*^9}]
}, Open  ]],

Cell["We define an exponential hit probability.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["PrHit", "Rule"], "=", 
  RowBox[{
   RowBox[{
    SubscriptBox["Pr", "Hit"], "[", 
    RowBox[{"L_", ",", "\[Lambda]_", ",", "\[Theta]_"}], "]"}], 
   "\[RuleDelayed]", 
   RowBox[{"Piecewise", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"L", "<", "\[Theta]"}]}], "}"}], "}"}], ",", 
     RowBox[{"CDF", "[", 
      RowBox[{
       RowBox[{"ExponentialDistribution", "[", "\[Lambda]", "]"}], ",", 
       RowBox[{"L", "-", "\[Theta]"}]}], "]"}]}], "]"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["Pr", "Hit"], "[", 
   RowBox[{"L_", ",", "\[Lambda]_", ",", "\[Theta]_"}], "]"}], 
  "\[RuleDelayed]", 
  RowBox[{"\[Piecewise]", GridBox[{
     {"0", 
      RowBox[{"L", "<", "\[Theta]"}]},
     {
      RowBox[{"CDF", "[", 
       RowBox[{
        RowBox[{"ExponentialDistribution", "[", "\[Lambda]", "]"}], ",", 
        RowBox[{"L", "-", "\[Theta]"}]}], "]"}], 
      TagBox["True",
       "PiecewiseDefault",
       AutoDelete->False,
       DeletionWarning->True]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxItemSize->{
     "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.84]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896333382932*^9, 3.39003067254043*^9}]
}, Open  ]],

Cell["Some parameter values:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"params", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Alpha]", "\[Rule]", "1"}], ",", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "X", "2"], "\[Rule]", "1"}], ",", 
     RowBox[{
      SubscriptBox["\[Mu]", "X"], "\[Rule]", "1"}], ",", 
     RowBox[{"\[Theta]", "\[Rule]", "0"}], ",", 
     RowBox[{"\[Lambda]", "\[Rule]", "1"}], ",", 
     RowBox[{"n", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["Pr", "Hit"], "[", 
      RowBox[{"L", ",", "\[Lambda]", ",", "\[Theta]"}], "]"}], "/.", 
     "\[InvisibleSpace]", 
     SubscriptBox["PrHit", "Rule"]}], "/.", "\[InvisibleSpace]", "params"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"L", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"L", ",", 
      SubscriptBox["Pr", "Hit"]}], "}"}]}], ",", 
   RowBox[{"BaseStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896333487472*^9, 3.3896333625982*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd1nk4VV0XAHBDZIxrHq87CJmLqKi9GmiSipA5U4qIQugqISSikRIqlESD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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["L", TraditionalForm], 
    FormBox[
     SubscriptBox["Pr", "Hit"], TraditionalForm]},
  AxesOrigin->{0, 0.6},
  BaseStyle->{FontFamily -> "Times"},
  PlotRange->{{0, 10}, {0.5456050635533405, 0.9999546000609723}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896333644972*^9, 3.3900306727794304`*^9}]
}, Open  ]],

Cell["\<\
Expected utility as a function of limit price L for initial holdings n=-2, \
-1, 0.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Log", "[", 
          RowBox[{"-", 
           SubscriptBox["EU", "Limit"]}], "]"}]}], "/.", "\[InvisibleSpace]", 
        
        SubscriptBox["EU", "Rule"]}], "/.", "\[InvisibleSpace]", 
       SubscriptBox["PrHit", "Rule"]}], "/.", "\[InvisibleSpace]", 
      RowBox[{"n", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", 
         RowBox[{"-", "1"}], ",", "0"}], "}"}]}]}], "/.", "\[InvisibleSpace]",
      "params"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"L", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<Limit price, L\>\"", ",", "\"\<-Log[-EULimit]\>\"", ",", "None", 
      ",", "None"}], "}"}]}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "None", ",", "None", ",", "None"}], "}"}]}], 
   ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Text", "[", 
       RowBox[{"\"\< n=0\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"0.1", ",", 
          RowBox[{"-", "0.3"}]}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\< n=-1\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"0.3", ",", 
          RowBox[{"-", "1.6"}]}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\< n=-2\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"0.8", ",", 
          RowBox[{"-", "3.7"}]}], "}"}]}], "]"}]}], "}"}]}], ",", 
   RowBox[{"BaseStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896333876102*^9, 3.3896335113652*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k4VWsXAHAisY8QTabcqG6GqCiJrLppkExRSCiJTJXpUpFoMKVR3RKF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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k8VO0XAHCkCCmkkEmWkC0vSgpH0aK02Fp+WSoSUpZXWcobKSllifAm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     "]]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k4Vfv3B3CpUIpMdSlTaZZmU8NbyCyELxKZJdeQXEMlSUmGyCxDxuNs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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  Background->GrayLevel[1],
  BaseStyle->{FontFamily -> "Times"},
  Epilog->{
    InsetBox[
     FormBox["\" n=0\"", TraditionalForm], {0.1, -0.3}], 
    InsetBox[
     FormBox["\" n=-1\"", TraditionalForm], {0.3, -1.6}], 
    InsetBox[
     FormBox["\" n=-2\"", TraditionalForm], {0.8, -3.7}]},
  Frame->True,
  FrameLabel->{
    FormBox["\"Limit price, L\"", TraditionalForm], 
    FormBox["\"-Log[-EULimit]\"", TraditionalForm], None, None},
  FrameTicks->{Automatic, None, None, None},
  PlotRange->{{0, 2}, {-3.9999999625340816`, 0.05016661503831972}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896335217742*^9, 3.3900306730834303`*^9}]
}, Open  ]],

Cell["\<\
When the agent is short one share, the optimal limit price is:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMaximize", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["EU", "Limit"], "/.", 
      SubscriptBox["EU", "Rule"]}], "/.", 
     SubscriptBox["PrHit", "Rule"]}], "/.", "params"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"L", ",", "0", ",", "1"}], "}"}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "3.234000033225349`"}], ",", 
   RowBox[{"{", 
    RowBox[{"L", "\[Rule]", "0.75`"}], "}"}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896333386982*^9, 3.3900306734804306`*^9}]
}, Open  ]],

Cell["The probability of execution is:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["Pr", "Hit"], "[", 
   RowBox[{"0.75", ",", "1", ",", "0"}], "]"}], "/.", 
  SubscriptBox["PrHit", "Rule"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData["0.5276334472589853`"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896333387302*^9, 3.39003067355243*^9}]
}, Open  ]],

Cell["\<\
Ask price at which customer is indifferent to doing nothing or paying the \
ask:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"EU", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], " ", 
        SubscriptBox["\[Mu]", "X"]}], "-", "A"}], ",", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "2"], 
       SubsuperscriptBox["\[Sigma]", "X", "2"]}], ",", "\[Alpha]"}], "]"}], 
    "\[Equal]", 
    RowBox[{"EU", "[", 
     RowBox[{
      RowBox[{"n", " ", 
       SubscriptBox["\[Mu]", "X"]}], ",", 
      RowBox[{
       SuperscriptBox["n", "2"], 
       SubsuperscriptBox["\[Sigma]", "X", "2"]}]}], "]"}]}], "/.", 
   SubscriptBox["EU", "Rule"]}], "/.", "params"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"EU", "[", 
   RowBox[{
    RowBox[{"-", "A"}], ",", "0", ",", "1"}], "]"}], "\[Equal]", 
  RowBox[{"-", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"3", "/", "2"}]]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896333387692003`*^9, 3.3900306736284304`*^9}]
}, Open  ]],

Cell["\<\
Ask price at which customer is indifferent to paying the ask or submitting a \
limit order at 0.75:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["EU", "Limit"], "==", 
        RowBox[{"EU", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}], " ", 
            SubscriptBox["\[Mu]", "X"]}], "-", "A"}], ",", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}], "2"], 
           SubsuperscriptBox["\[Sigma]", "X", "2"]}]}], "]"}]}], "/.", 
       SubscriptBox["EU", "Rule"]}], "/.", 
      SubscriptBox["PrHit", "Rule"]}], "/.", "params"}], "/.", 
    RowBox[{"L", "\[Rule]", "0.75"}]}], ",", "A"}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Inverse functions are being used by \\!\\(Solve\\), so \
some solutions may not be found; use Reduce for complete solution \
information. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", ButtonNote -> \
\\\"Solve::ifun\\\"]\\)\"\>"}]], "Message",
 CellChangeTimes->{3.3896333389982*^9, 3.3900306741944304`*^9},
 CellLabel->"During evaluation of In[16]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"A", "\[Rule]", "1.173719771428678`"}], "}"}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896333390151997`*^9, 3.3900306742324305`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{"Log", "[", 
         RowBox[{"-", 
          SubscriptBox["EU", "Limit"]}], "]"}]}], "/.", "\[InvisibleSpace]", 
       SubscriptBox["EU", "Rule"]}], "/.", "\[InvisibleSpace]", 
      SubscriptBox["PrHit", "Rule"]}], "/.", "\[InvisibleSpace]", "params"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"L", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<Limit price, L\>\"", ",", "\"\<-Log[-EULimit]\>\"", ",", "None", 
      ",", "None"}], "}"}]}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "None", ",", "None", ",", "None"}], "}"}]}], 
   ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Text", "[", 
       RowBox[{"\"\<n=0\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"0.1`", ",", 
          RowBox[{"-", "0.3`"}]}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\< n=-1\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"0.3`", ",", 
          RowBox[{"-", "1.6`"}]}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<n=-2\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"0.8`", ",", 
          RowBox[{"-", "3.7`"}]}], "}"}]}], "]"}]}], "}"}]}], ",", 
   RowBox[{"BaseStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896335392232*^9, 3.3896336184972*^9}, {
  3.3896336683462*^9, 3.3896336805741997`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k8VO0XAHCkCCmkkEmWkC0vSgpH0aK02Fp+WSoSUpZXWcobKSllifAm
UkqhbKFe5KFosyQJ2Zcx984Y28yYsc/v6a/7+X4+z3Pvuefee865ymd87c4K
CQgILBMUEPhz3H+W/FFNP2veNXOVx+fzkLClgl+fvBVUTdZ4SSzykOHj1Edv
5B3grfNrBfl5HjrQ2F6cLu8OBqVom+E0Dx1z572/Lx8IikP157wneKhn8y3L
e/I34Nyeo0+o/TyUKXs46o58EjiBneDyDzwUIfpG47b8M3AReXBJ9iYPHT/x
pGBisgRGNaqzkoR5SJwf4bR3PYL44t6FUwlctNF2jPwYUwt10yt9d2zkoqAm
E0jlfAV15Q/bskqn0NoSqV5Bwe+QnNRqp28/hcoGLRu+m7ZA4/2coNXjHPTB
O33dCWYr5HyaffEzkYOm1M1Wvr7QDocp2pGHdnOQ0EzeqnUbO2Gqcqa/mMdG
W/mnyuzzu0ED9N0zytio4YZR0yetPqgRpxnMh7HR9pX1Qglb+mC9YqvnGuyX
/542PmnRB3b1NZp/XWWjyPzYzHHHPqiPGNjjGYrXd5ABchF9sKV9zWL3Zbxe
O32td3sfUCJPn+v3ZaNd9OuFy3b1Q0zOVNrhM2ykFD8ykzPWD+d9JNV+7mOj
qtPXcorZ/QDXXU5TsF0MZU5UTPfDlWxXBc+9bPSobfu7BqEBmLfI5i/uZiM5
yp3L42sGwNw4LdXAko2kczXZRjAA+otIssiMjZbWnmWiuAGgxB1xFTdkoxFe
X+8v/UH4El0ts02JjcrOxX3Yv3UQTH0K55PWs1F4u3k22jEImicPhbIobLTm
bfqFnD2DsNP0q2GBIo7/8sn5q06DsPGL1pPNCmz0kNMmrxY9CL7JXD8bWTba
N9noENA3CCJbDM244mwkczpsG0EdhASHgtaz2L3NOopOjEE4b35eqE2MjQIL
Y4Z2Tw2CXvGPDe+Ws9FjX+sAefEhGHN+4h0pwkbc0dq46q1D0Cvkabp1CRs9
Y1R8k4wdgnslUhor5ljoYsphVe/EIVjWNUBLmGUhY6uhK3WpQzBZ07ZtLfa3
dDHdq1lD8HXRMVF1hoUmj5yIo78bgiqRclVLHguZv+Xa1w4NQf+lgPJ0Ngv9
jvyrJ8SECkcuawnUMFnoqX7dll/mVLiyrnzNcWyfnuOx+lZUsEu/Xz0+wkIC
xuFAHKLCgzpo2oCtzmh64uBOhTrJv1tu01ko8IiPx+Y4KvCUTt4MorGQJOXF
OJVKBdGMmvqafhayOBrZM0SnAvEueJM/dkCca/3gGBWKuUqiythtgnIv+qep
YHLOcd/1PhbKoEW7dEsMg7zgdOv+XhbSK/Ru/Gk0DNcpvaqcLhY6Rd9T0WIy
DAWBmxLzsO+rqOb8MB+GVfIVkW7Y3KSuG9/3DYPoozqytZOFqkJsTOudhqG3
fcnH979Z6KClXt6HG8Ogp+pd+aKdhf65KvZvze1hCLrgtescdmEpLao6dhg6
zeetNbBXaz4+U5U6DJF3xnpetrFQt8QqhfJXw1DqcF2++BfOV9tkdFHrMOyI
0B3q/slCd71KPTLVaNB/kNmd2MxCDIvX0eJaNLgm7xPrir1X7nnu5c00WD0y
3qGNLfQ5acxmOw12dq82+fSdhULUAi/PHKaB2y9rdSFsjz6DKLsrNND3HX6b
3MhCtWVaL9+H0+CuS/zceWyVWJVvmlE00Ij8p2Mndo+ptCQ/ngYRoQYu4w0s
5PBw8kFeNg10K4//a4u907HwuXALDTSD/H8Y1ON867z87NtOAzTXmSuFPb8k
k97ZTYPIjeWUyW8s9K44TreIoEG1FfV7EbbeKt9S5wUaPKTre2zHvkt4tH8R
IqBaM0F8PTajymXGUJQA2eAr+4Wwn184ZCYmQ4DAbV5Sw1cWUqzXrSvTJKDQ
r97JEzv06UZCWY+AiVvlTUew20Moy+8ZEtBEteo0wb6vueKgmzkBQ7KGVSuw
J/jCvk2WBBimP0ye/sJCh9rn402sCbBrfiZKxV4exWxd6UBAhvTL/yqxPZyp
3NATBHAuPJvOwa416pajuRBwdsX+HynY4UP1TpVeBFiophy+hM21yKN6XiPA
Ue1UuDF25bORtKAbBFhunLukhX1dVMc+6jYBJ0vCJinYks2varISCTiuaBa6
DLvVcDS4OJWAC6+u3Jr7zEIPU3T1a9IJEDN5rjCJre6an9H7goC0/ZUtPdjM
D2OOo68I8N+Wx2vFLlbfvGK+iICHnFtPG7CD7/jWir0lYMU6+5+12OZjBVfk
KwmYMVtx5z22sN2EgWYNAR+Hyz6VYX8r1Wds/USAUMKR24XY8fL+T3bXE3Cr
pPNHLvbRsKLjDs0EOFQ4Zj7HVhyYXOn2i4CsZR84mdiDVgaf/TsJ6B9V+v4I
++XLgH/C+wjIr/Ld/C/2RYk3W+Ko+HlUFskmYxv5sZnpdALuqNAiErFnfxo+
ezVGAFVpRWACdrVx4MkKNs53lzozDjsqrUT62zQBpf6GjFhsGz7na8cCAcVT
Bhf/WNptSwQhRIKP38bgP+74dGkbV4QErQEx0T/7M7TKxoVXkOBhNkSJx3aP
5WbLSJPQ5Jf/35/rabG2uqisJWGPs0/Xn3gmHINk/1IkgdqpGPkn3tL/3jaA
Mgmct6jwz/2EUqYjD6mTwHvn4J6ObRGxbYezNglPUrvSn2AvGw5mndcnoVvE
wTkbu2HffzmhW0j49Pr90zzs+69mTt3eTkKxhtzFIuzjq7bLpQIJm5a7obfY
1PbyqFJrEvqVvrDrsHN3zJnVHiLB5MBAWyO23+MdUy32JNh+I6ENe96j0m3C
mQRzq+osEvvDt3kF/hkSumixGSzsaD2zlhWeJNTpWCstYK/mvrfQDiDBPSqs
WAa/f50nFnkmQSQksadqlbAz35sX7LtKgsjbo8462Do3EcUjigTx6Ealvdgs
kt8aGENCc+aAtSP2OxuLu5HxJFiqd864YVutrpnNfIj3qwSOXMcWCxYsLnhM
gp2jjG4idnPXTq+qZySY+t7nZGE7ZX1o78on4dhZbdnP2IEGtSVrPpJw9FHW
Ixn8/XoYbchM+ELC/xyCv2zCPr71aoxEEwmXWnwTLLB3bDc6I/SbhJ6daNYX
W2jXs5VjYyR4Dz7XasPmWArMeXJIOLP+GExiD+92og3NkBAnrDApgevNF+vV
738L02HTrnrtPdhxtje86xToUFXyYAFhh9v3O1psoENjS+xsH3aAo+nOio10
MFe9mSSA69/RE5y1Rfp08N/g8tgSW/G0e92jPXRIEvRb9QM7189qQ2AAHZQV
Tjovx/X2UUCm+HgQHbSryjUNse8FznO9wuigmUqNd8b2Cy5pdI2mg8TJaOMS
bONwtSsHMnB8ui96PJtwPYoTblP5RofZlqbb47jelyWcqkn/Toe7ooIbVHF/
eJlY+UruFx0Sld7bHcOOSQmMlOyn4/mt5l4Ntt1jqv7sFB0+5gadSP/BQn35
tTE/lBmwdvnflgG4HzWPCjMNNBigHZYdno9drbPbJkmHATPKfzuMYGfm1kkc
M2ZA1dhH5NHKQmeyP93rtmGA+7WSZ+64v9HSv8QRQQxI/6qfdRX3w9G7DYkL
jQyYUJA+QOlmod56CY7LTwYwHJqO+GA3iR10qO5gwJS8D7MCOz+6cXXkEAPm
1Q2GnXpwPm40PRCdYYDJb73u57i/c640p8iojUBzFe+3/QALzXm3pm0KHYF+
ChpUInD/2uqcoHdtBDwvmQlfwX4lSIsyvDECN5a6v2jDdknl+ZvFjoBGU1xA
HMlCNXUK+2yfjoCSSO46EQYL3dpwmhP8bQQ6LCTeSI6ykEzbqM0XBSasmmqp
+wfPQz5PLu9qVGKCp7j8SgZ2rQ/fuEWNCd631H87cljo8hIp1W49JvgfDBnX
m8Lzk77RzPguJpwP0VAjuCz0OCb0+drzeL3dr2xfPI9p7xRZ9KhggjNV93e/
IBsV5uZpdFQzIfypS5KHEBsZrT5ia/2JCSWzVcNMbFMi9Zn2Dyb42gzun8Pz
36F7WgcmaExwLLlCUVrGRgG/D6aGSI9CVb1s53U8T/7nn2Rw12sUvkr5u5bL
sNHep8rnitaOQX2HDoOmgc+fKqn+SXEMlqVsDY7SZKMNsXPUTuUxCJULjlLf
xEazIb/OCOuMwRLvS6qeWmz02va2yzGLMVB/oegyqYPnWcFJxwXPMWg1Wt+w
zoCN+lyrrazLxyCnzNak2ZSNgiiuKgNO47D015LiEns20mE6ircfnABPFeth
8yi8f+WEaO3sBDQkZ8cdrWMjYZRWoPpoEvr2bPz6ToSDzhtV/F5+gAW0O7Km
Mcc4KM/6TGYVlwWnh0IMYl7j/5kRhVW0ZDYIxzcUWQpPoVL7vUuSrDjAFPzH
TdJrCl3bd/NxCY0Dy8Yc9qo3TiHlnv0dWTenYIeHcGWyERdtN76RJG/Ahe95
8Wp+uVzktP77jOBPLjzw1NnmSOGhqW/3Bv0ieHBSOEiFkcFDqcIugXZq0yA8
dk3OVnEayfSWPhWqnYZSpvtLubRptDQswsHEfwbK1knxUzRnkECOS8Gg9Czk
nj/XuK5wBgU8LLgn/WEWxv8+k+mzZxa9144Wlbo4B/lBoiuNe2aR1P4AneuS
81ASt8MtwmcOdes2/wypnAdB1zQiTGweFWaAGtVlAd5kf0zenjmPnAu2SlEW
F2AxUXrPuNECCr/5JKI7dxE2zJmUGHcsoNckJU3Shg+jrVOnTAMWka2U5LbP
s3zgeu0Oa1TgoztLhdZ1Y0sy+BUD2LUzUwsT2NY8NDuFvXWw56PCHB9+vjsS
vH4dHym8eX34IrZuW8nfvtiDDgfPyc7z4azXrfNSinwUmHo32W2BD2IXHF0d
KXz0+m54SDB2qE9Nhhc2LTzQ6R52HtegNwz7uJeTylts0Tx152xss+06+WKL
fEhOOHKSh72su76uCNttd/7xf9fzETSjl5+wJciA1NfYwbVvYrqw964266jB
ZrxKs13K5+N+OniMgd0Udr7nOHb0mYvHdijxkUiAa/UF7OLDrimHsS087LOu
Y7fXOba7YRcf2uH1CrvWxv7YXeyRXZttarDPOf8vJRNbzVh1cxt2OdejvQTb
RXut9Ah2rlzI2q/YKUriU3xslY/xx3qw/w/VUjzg
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, -1.9000000000000001`},
  Background->GrayLevel[1],
  BaseStyle->{FontFamily -> "Times"},
  Epilog->{
    InsetBox[
     FormBox["\"n=0\"", TraditionalForm], {0.1, -0.3}], 
    InsetBox[
     FormBox["\" n=-1\"", TraditionalForm], {0.3, -1.6}], 
    InsetBox[
     FormBox["\"n=-2\"", TraditionalForm], {0.8, -3.7}]},
  Frame->True,
  FrameLabel->{
    FormBox["\"Limit price, L\"", TraditionalForm], 
    FormBox["\"-Log[-EULimit]\"", TraditionalForm], None, None},
  FrameTicks->{Automatic, None, None, None},
  PlotRange->{{0, 2}, {-1.9452794476057496`, -1.1737198166514244`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896336810052*^9, 3.3900306743984303`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"EU", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], " ", 
         SubscriptBox["\[Mu]", "X"]}], "-", "A"}], ",", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "2"], 
        SubsuperscriptBox["\[Sigma]", "X", "2"]}]}], "]"}], "/.", 
     SubscriptBox["EU", "Rule"]}], "/.", 
    SubscriptBox["PrHit", "Rule"]}], "/.", "params"}], "/.", 
  RowBox[{"A", "\[Rule]", "1.1"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"-", "3.0041660239464334`"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896333391182003`*^9, 3.3896336888382*^9, 
  3.3900306744504304`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->None,
WindowSize->{1578, 1027},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Visible->True,
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
InputAliases->{"intt" -> RowBox[{"\[Integral]", 
     RowBox[{"\[SelectionPlaceholder]", 
       RowBox[{"\[DifferentialD]", "\[Placeholder]"}]}]}], "dintt" -> 
  RowBox[{
     SubsuperscriptBox[
     "\[Integral]", "\[SelectionPlaceholder]", "\[Placeholder]"], 
     RowBox[{"\[Placeholder]", 
       RowBox[{"\[DifferentialD]", "\[Placeholder]"}]}]}], "sumt" -> RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"\[SelectionPlaceholder]", "=", "\[Placeholder]"}], 
      "\[Placeholder]"], "\[Placeholder]"}], "prodt" -> RowBox[{
     UnderoverscriptBox["\[Product]", 
      RowBox[{"\[SelectionPlaceholder]", "=", "\[Placeholder]"}], 
      "\[Placeholder]"], "\[Placeholder]"}], "dt" -> RowBox[{
     SubscriptBox["\[PartialD]", "\[Placeholder]"], " ", 
     "\[SelectionPlaceholder]"}], "E" -> "\[ScriptCapitalE]", "notation" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], " ", 
       "\[DoubleLongLeftRightArrow]", " ", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "notation>" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], " ", 
       "\[DoubleLongRightArrow]", " ", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "notation<" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], " ", 
       "\[DoubleLongLeftArrow]", " ", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "symb" -> 
  RowBox[{"Symbolize", "[", 
     TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], "]"}], 
  "infixnotation" -> RowBox[{"InfixNotation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], ",", 
       "\[Placeholder]"}], "]"}], "addia" -> RowBox[{"AddInputAlias", "[", 
     RowBox[{"\"\[SelectionPlaceholder]\"", "\[Rule]", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "pattwraper" -> 
  TagBox["\[SelectionPlaceholder]", "NotationPatternTag"], "madeboxeswraper" -> 
  TagBox["\[SelectionPlaceholder]", "NotationMadeBoxesTag"]},
Magnification->1.5,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->"EMMStyle02.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 1010, 26, 430, "Title"],
Cell[CellGroupData[{
Cell[1625, 53, 410, 9, 43, "Input"],
Cell[2038, 64, 750, 16, 51, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2825, 85, 34, 0, 92, "Section"],
Cell[2862, 87, 167, 4, 43, "Input"],
Cell[3032, 93, 111, 3, 32, "Text"],
Cell[3146, 98, 369, 12, 43, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3552, 115, 67, 0, 92, "Section"],
Cell[3622, 117, 29, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[3676, 121, 539, 16, 56, "Input"],
Cell[4218, 139, 424, 12, 54, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4679, 156, 748, 22, 56, "Input"],
Cell[5430, 180, 317, 9, 53, "Output"]
}, Open  ]],
Cell[5762, 192, 72, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[5859, 196, 762, 23, 48, "Input"],
Cell[6624, 221, 313, 9, 61, "Output"]
}, Open  ]],
Cell[6952, 233, 66, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[7043, 237, 1007, 33, 48, "Input"],
Cell[8053, 272, 1038, 34, 44, "Output"]
}, Open  ]],
Cell[9106, 309, 28, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[9159, 313, 197, 5, 43, "Input"],
Cell[9359, 320, 946, 26, 50, "Output"]
}, Open  ]],
Cell[10320, 349, 57, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[10402, 353, 592, 18, 43, "Input"],
Cell[10997, 373, 1157, 33, 55, "Output"]
}, Open  ]],
Cell[12169, 409, 38, 0, 32, "Text"],
Cell[12210, 411, 498, 14, 48, "Input"],
Cell[CellGroupData[{
Cell[12733, 429, 739, 22, 43, "Input"],
Cell[13475, 453, 7336, 129, 356, "Output"]
}, Open  ]],
Cell[20826, 585, 107, 3, 32, "Text"],
Cell[CellGroupData[{
Cell[20958, 592, 2000, 58, 125, "Input"],
Cell[22961, 652, 16928, 291, 397, "Output"]
}, Open  ]],
Cell[39904, 946, 86, 2, 32, "Text"],
Cell[CellGroupData[{
Cell[40015, 952, 374, 12, 43, "Input"],
Cell[40392, 966, 260, 7, 38, "Output"]
}, Open  ]],
Cell[40667, 976, 48, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[40740, 980, 198, 6, 43, "Input"],
Cell[40941, 988, 135, 2, 38, "Output"]
}, Open  ]],
Cell[41091, 993, 104, 3, 32, "Text"],
Cell[CellGroupData[{
Cell[41220, 1000, 754, 25, 48, "Input"],
Cell[41977, 1027, 318, 9, 41, "Output"]
}, Open  ]],
Cell[42310, 1039, 123, 3, 32, "Text"],
Cell[CellGroupData[{
Cell[42458, 1046, 786, 24, 48, "Input"],
Cell[43247, 1072, 550, 11, 32, "Message"],
Cell[43800, 1085, 216, 5, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44053, 1095, 1837, 52, 125, "Input"],
Cell[45893, 1149, 6190, 113, 397, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52120, 1267, 618, 20, 48, "Input"],
Cell[52741, 1289, 182, 4, 38, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
