(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27480,        803]
NotebookOptionsPosition[     22871,        677]
NotebookOutlinePosition[     25937,        755]
CellTagsIndexPosition[     25894,        752]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Trees ",
 StyleBox["package",
  FontSlant->"Italic"],
 "\n",
 StyleBox["Empirical Market Microstructure",
  FontSlant->"Italic"],
 " \n\t(2006, Oxford University Press)\nCompanion ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook\n\nJoel Hasbrouck\n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Copyright", " ", "2007"}], ",", " ", 
    RowBox[{"Joel", " ", 
     RowBox[{"Hasbrouck", ".", " ", "All"}], " ", "rights", " ", 
     RowBox[{"reserved", "."}]}]}], TraditionalForm]],
  FontSize->14,
  FontSlant->"Italic"]
}], "Title",
 CellChangeTimes->{{3.3896255910914*^9, 3.3896255932033997`*^9}, {
   3.3897167078988237`*^9, 3.389716768500824*^9}, 3.3897219191158237`*^9, {
   3.3897220399168243`*^9, 3.3897220640418243`*^9}, {3.389735393500024*^9, 
   3.389735431148024*^9}, 3.389735530878024*^9, 3.3897355723880243`*^9, {
   3.389735664464024*^9, 3.3897356860350237`*^9}, {3.3899891508672*^9, 
   3.3899891819161997`*^9}, 3.3907332510676003`*^9, {3.3907333517376003`*^9, 
   3.3907333534386*^9}, {3.3907334028986*^9, 3.3907334042686*^9}}],

Cell["\<\
This package contains routines useful in working with decision trees (as in \
sequential trade models). The notebook should be stored as as (\".m\") \
package. See \"TreesDemo.nb\" demonstration notebook.\
\>", "Text",
 CellChangeTimes->{
  3.3895520316504*^9, {3.3895520970834*^9, 3.3895521014133997`*^9}, {
   3.3907333672166*^9, 3.3907333850066*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"BeginPackage", "[", "\"\<Trees`\>\"", "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[87]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Tree", "::", "usage"}], "=", 
   "\"\<A Tree object is a multilevel list where the entries are expressions \
corresponding to nodes.\>\""}], ";"}]], "Input",
 CellLabel->"In[88]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ShowTree", "::", "usage"}], "=", 
   "\"\<ShowTree[t] where t is a list structure representing a decision tree. \
ShowTree displays it as a table that more clearly illustrates the branches. \
ShowTree[{t1,t2,...}] displays an array of tree structures. (t1, t2, ... must \
be conformable).\>\""}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[89]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"NodePos", "::", "usage"}], "=", 
   "\"\<NodePos[t,n] where t is a tree (in list form) and n is a list of \
nodes {n1,n2,...,nK}. Returns the positions of nodes matching nK that also \
pass through nodes n1, n2, ...\>\""}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[90]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MarkedTree", "::", "usage"}], "=", 
   "\"\<MarkedTree[t,n] where t is a tree in list form and n is a list of \
nodes {n1, n2, ..., nK}. Displays the tree with the selected nodes marked by \
red stars.\>\""}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[91]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CheckConformance", "::", "usage"}], "=", 
   "\"\<CheckConformance[{t1, t2, ...}] verifies that all of the trees have \
the same list structure.\>\""}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[92]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PrTotal", "::", "usage"}], "=", 
   "\"\<PrTotal[pr] where pr is a tree structure containing the transition \
probabilities. Returns a tree with total probabilities.\>\""}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[93]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BuildTree", "::", "usage"}], "=", 
   "\"\<BuildTree[TreeLabels,TreePrs] returns a list of trees: {labels, \
transition prs, total prs}.\>\""}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[94]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Pr", "::", "usage"}], "=", 
   "\"\<Pr[tree,n] where tree is a Tree structure and n is a list of nodes, \
{n1, n2, ..., nK} returns the probability of terminal nodes nK that pass \
through n1, n2, ...\>\""}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[95]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"Begin", "[", "\"\<`Private`\>\"", "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.388169837601*^9},
 CellLabel->"In[96]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ShowTree", "[", "zz__List", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"z2", "=", 
        RowBox[{"{", "zz", "}"}]}], ",", "t"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"t", " ", "=", " ", 
       RowBox[{"GrowTree", " ", "/@", " ", "z2"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"TableForm", "[", 
        RowBox[{
         RowBox[{"Map", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"Dimensions", "[", "t", "]"}], "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ">", "1"}], " ", "&&", " ", 
               RowBox[{"\[Not]", 
                RowBox[{"And", " ", "@@", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"\"\< \>\"", "===", "#"}], "&"}], " ", "/@", " ", 
                   "#"}], ")"}]}]}]}], ",", 
              RowBox[{"FrameBox", "[", 
               RowBox[{"TableForm", "[", "#", "]"}], "]"}], ",", "#"}], "]"}],
             "&"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Transpose", "[", 
            RowBox[{"t", ",", 
             RowBox[{"{", 
              RowBox[{"3", ",", "1", ",", "2"}], "}"}]}], "]"}], ",", 
           RowBox[{"{", "2", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"TableAlignments", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Left", ",", "Top"}], "}"}]}], ",", 
         RowBox[{"TableSpacing", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{".5", ",", ".5"}], "}"}]}]}], "]"}], "//", 
       "DisplayForm"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[97]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ShowTree", "[", "zz_Tree", "]"}], ":=", 
   RowBox[{"ShowTree", " ", "@@", " ", 
    RowBox[{"List", " ", "@@", " ", "zz"}]}]}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[98]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"NodePos", "[", 
    RowBox[{"t_List", ",", "n__"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"nn", "=", 
        RowBox[{"{", "n", "}"}]}], ",", "k", ",", "j"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"k", "=", 
       RowBox[{"Position", "[", 
        RowBox[{"t", ",", 
         RowBox[{"Last", "[", "nn", "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "nn", "]"}], "===", "1"}], ",", 
        RowBox[{"Return", "[", "k", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"nn", "=", 
       RowBox[{"Drop", "[", 
        RowBox[{"nn", ",", 
         RowBox[{"-", "1"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"j", "=", 
          RowBox[{"Position", "[", 
           RowBox[{"t", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"nn", "[", 
               RowBox[{"[", "i", "]"}], "]"}], ",", "__"}], "}"}]}], "]"}]}], 
         ";", "\[IndentingNewLine]", 
         RowBox[{"k", "=", 
          RowBox[{"Select", "[", 
           RowBox[{"k", ",", 
            RowBox[{
             RowBox[{"MemberQ", "[", 
              RowBox[{"j", ",", 
               RowBox[{"Take", "[", 
                RowBox[{"#", ",", 
                 RowBox[{"Length", "[", 
                  RowBox[{"First", "[", "j", "]"}], "]"}]}], "]"}]}], "]"}], 
             "&"}]}], "]"}]}], ";"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"Length", "[", "nn", "]"}], ",", "1", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "\[IndentingNewLine]", "]"}], ";", 
      "\[IndentingNewLine]", "k"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[99]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MarkedTree", "[", 
    RowBox[{"tree_Tree", ",", "n__"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "t", "}"}], ",", 
     RowBox[{
      RowBox[{"t", "=", 
       RowBox[{"ReplacePart", "[", 
        RowBox[{
         RowBox[{"BlankTree", "[", 
          RowBox[{"tree", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", "\"\<\!\(\*
StyleBox[\"\[FivePointedStar]\[FivePointedStar]\[FivePointedStar]\",
FontSize->16,
FontColor->RGBColor[1, 0, 0]]\)\>\"", ",", 
         RowBox[{"NodePos", "[", 
          RowBox[{
           RowBox[{"tree", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", "n"}], "]"}]}], "]"}]}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"Tree", "[", 
       RowBox[{
        RowBox[{"tree", "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", 
        RowBox[{"tree", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", 
        RowBox[{"tree", "[", 
         RowBox[{"[", "3", "]"}], "]"}], ",", "t"}], "]"}]}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[100]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MarkedTree", "[", 
    RowBox[{"tree_List", ",", "n__"}], "]"}], ":=", 
   RowBox[{"ReplacePart", "[", 
    RowBox[{
     RowBox[{"BlankTree", "[", "tree", "]"}], ",", "\"\<\!\(\*
StyleBox[\"\[FivePointedStar]\[FivePointedStar]\[FivePointedStar]\",
FontSize->16,
FontColor->RGBColor[1, 0, 0]]\)\>\"", ",", 
     RowBox[{"NodePos", "[", 
      RowBox[{"tree", ",", "n"}], "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[101]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CheckConformance", "[", "t__", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"t2", "=", 
        RowBox[{"{", "t", "}"}]}], ",", "tList"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "t2", "]"}], "===", "1"}], ",", 
        RowBox[{
         RowBox[{
         "Print", "[", 
          "\"\<CheckConformance. Only one tree passed. Nothing to check.\>\"",
           "]"}], ";", 
         RowBox[{"Return", "[", "True", "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"tList", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Position", "[", 
          RowBox[{
           RowBox[{"t2", "[", 
            RowBox[{"[", "i", "]"}], "]"}], ",", 
           RowBox[{"{", "__", "}"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "[", "t2", "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"\[Not]", 
           RowBox[{"SameQ", " ", "@@", " ", 
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"tList", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "j"}], "]"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"i", ",", 
                RowBox[{"Length", "[", "t2", "]"}]}], "}"}]}], "]"}]}]}], ",",
           "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Print", "[", 
            RowBox[{
            "\"\<CheckConformance. First list mismatch at \>\"", ",", "j"}], 
            "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"Do", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"Print", "[", 
               RowBox[{"\"\<Tree \>\"", ",", "i", ",", "\"\< \>\"", ",", 
                RowBox[{"tList", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "j"}], "]"}], "]"}]}], "]"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"Print", "[", 
               RowBox[{"Extract", "[", 
                RowBox[{
                 RowBox[{"t2", "[", 
                  RowBox[{"[", "i", "]"}], "]"}], ",", 
                 RowBox[{"Drop", "[", 
                  RowBox[{
                   RowBox[{"tList", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "j"}], "]"}], "]"}], ",", 
                   RowBox[{"-", "1"}]}], "]"}]}], "]"}], "]"}], ";"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"i", ",", 
               RowBox[{"Length", "[", "t2", "]"}]}], "}"}]}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"Abort", "[", "]"}]}]}], "\[IndentingNewLine]", "]"}], ",",
         "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"j", ",", 
          RowBox[{"Max", " ", "@@", " ", 
           RowBox[{"Length", " ", "/@", " ", "tList"}]}]}], "}"}]}], "]"}], 
      ";", "\[IndentingNewLine]", "True"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[102]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PrTotal", "[", "pr_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p", "=", "pr"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"p", "=", 
         RowBox[{"Replace", "[", 
          RowBox[{"p", ",", 
           RowBox[{"a_", "\[RuleDelayed]", 
            RowBox[{
             RowBox[{"Join", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"a", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "}"}], ",", 
               RowBox[{
                RowBox[{"a", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "*", 
                RowBox[{"Drop", "[", 
                 RowBox[{"a", ",", "1"}], "]"}]}]}], "]"}], "/;", 
             RowBox[{"ListQ", "[", "a", "]"}]}]}], ",", 
           RowBox[{"{", "i", "}"}]}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"Depth", "[", "pr", "]"}], ",", "1", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
      "p"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[103]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BuildTree", "[", 
    RowBox[{"TreeLabels_", ",", "TreePrs_", ",", "TreeTotalPrs___"}], "]"}], ":=",
    
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"prt", "=", "TreeTotalPrs"}], "}"}], ",", "\[IndentingNewLine]",
      
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"prt", "\[Equal]", "Null"}], ",", 
        RowBox[{"prt", "=", 
         RowBox[{"PrTotal", "[", "TreePrs", "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CheckConformance", "[", 
       RowBox[{"TreeLabels", ",", "TreePrs", ",", "prt"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Tree", "[", 
       RowBox[{"TreeLabels", ",", "TreePrs", ",", "prt"}], "]"}]}]}], "]"}]}],
   ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[104]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Pr", "[", 
    RowBox[{"tree_Tree", ",", "n__"}], "]"}], ":=", 
   RowBox[{"Total", " ", "@", " ", 
    RowBox[{"Extract", "[", 
     RowBox[{
      RowBox[{"tree", "[", 
       RowBox[{"[", "3", "]"}], "]"}], ",", 
      RowBox[{"NodePos", "[", 
       RowBox[{
        RowBox[{"tree", "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", "n"}], "]"}]}], "]"}]}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[105]:="],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"AddColumn", "[", 
    RowBox[{"m_", ",", 
     RowBox[{"zz_:", "0"}]}], "]"}], ":=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"Transpose", "[", "m", "]"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{"zz", ",", 
        RowBox[{"{", "1", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Dimensions", "[", "m", "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], "}"}]}], "]"}]}], "]"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"AddRow", "[", 
    RowBox[{"m_", ",", 
     RowBox[{"zz_:", "0"}]}], "]"}], ":=", 
   RowBox[{"Join", "[", 
    RowBox[{"m", ",", 
     RowBox[{"Table", "[", 
      RowBox[{"zz", ",", 
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Dimensions", "[", "m", "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}], "}"}]}], "]"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"AddBranches", "[", 
    RowBox[{"m_", ",", "branches_List", ",", "startRow_", ",", "startCol_"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"m2", "=", "m"}], ",", 
       RowBox[{"startRow2", "=", "startRow"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"Dimensions", "[", "m2", "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], "<", "startRow2"}], ",", 
           RowBox[{"m2", "=", 
            RowBox[{"AddRow", "[", 
             RowBox[{"m2", ",", "\"\< \>\""}], "]"}]}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"Dimensions", "[", "m2", "]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}], "<", "startCol"}], ",", 
           RowBox[{"m2", "=", 
            RowBox[{"AddColumn", "[", 
             RowBox[{"m2", ",", "\"\< \>\""}], "]"}]}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Check", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"!", 
               RowBox[{"ListQ", "[", 
                RowBox[{"branches", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], "]"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{
                RowBox[{"m2", "[", 
                 RowBox[{"[", 
                  RowBox[{"startRow2", ",", "startCol"}], "]"}], "]"}], "=", 
                RowBox[{"branches", "[", 
                 RowBox[{"[", "i", "]"}], "]"}]}], ";"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{
                RowBox[{"m2", "[", 
                 RowBox[{"[", 
                  RowBox[{"startRow2", ",", "startCol"}], "]"}], "]"}], "=", 
                RowBox[{"branches", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "1"}], "]"}], "]"}]}], ";", 
               "\[IndentingNewLine]", 
               RowBox[{"m2", "=", 
                RowBox[{"AddBranches", "[", 
                 RowBox[{"m2", ",", " ", 
                  RowBox[{"Drop", "[", 
                   RowBox[{
                    RowBox[{"branches", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], ",", "1"}], "]"}], ",", 
                  "startRow2", ",", 
                  RowBox[{"startCol", "+", "1"}]}], "]"}]}], ";"}]}], 
             "\[IndentingNewLine]", "]"}], ";"}], ",", "\[IndentingNewLine]", 
           
           RowBox[{
            RowBox[{"Print", "[", "\"\<Error in AddBranches\>\"", "]"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"Print", "[", 
             RowBox[{"\"\<m2:\>\"", ",", " ", 
              RowBox[{"TableForm", "[", "m2", "]"}]}], "]"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"Print", "[", 
             RowBox[{"\"\<branches: \>\"", ",", "branches"}], "]"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"Print", "[", 
             RowBox[{"\"\<Length of branches: \>\"", ",", 
              RowBox[{"Length", "[", "branches", "]"}]}], "]"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"Print", "[", 
             RowBox[{"\"\<i: \>\"", ",", "i"}], "]"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"Abort", "[", "]"}], ";"}]}], "\[IndentingNewLine]", 
          "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"startRow2", "=", 
          RowBox[{
           RowBox[{
            RowBox[{"Dimensions", "[", "m2", "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], "+", "1"}]}], ";"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"Length", "[", "branches", "]"}]}], "}"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", "m2"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[106]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GrowTree", "[", "t_", "]"}], ":=", 
   RowBox[{"AddBranches", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"t", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "}"}], "}"}], ",", 
     RowBox[{"Drop", "[", 
      RowBox[{"t", ",", "1"}], "]"}], ",", "1", ",", "2"}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[109]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BlankTree", "[", "t_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"t", "//.", 
     RowBox[{"a_", ":>", 
      RowBox[{"\"\<\>\"", "/;", 
       RowBox[{"FreeQ", "[", 
        RowBox[{"a", ",", "List"}], "]"}]}]}]}], ")"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[110]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"End", "[", "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.38816984715*^9},
 CellLabel->"In[111]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"EndPackage", "[", "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[112]:="]
}, Open  ]]
},
AutoGeneratedPackage->Automatic,
WindowSize->{1578, 1027},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Visible->True,
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
ShowSelection->True,
InputAliases->{"intt" -> RowBox[{"\[Integral]", 
     RowBox[{"\[SelectionPlaceholder]", 
       RowBox[{"\[DifferentialD]", "\[Placeholder]"}]}]}], "dintt" -> 
  RowBox[{
     SubsuperscriptBox[
     "\[Integral]", "\[SelectionPlaceholder]", "\[Placeholder]"], 
     RowBox[{"\[Placeholder]", 
       RowBox[{"\[DifferentialD]", "\[Placeholder]"}]}]}], "sumt" -> RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"\[SelectionPlaceholder]", "=", "\[Placeholder]"}], 
      "\[Placeholder]"], "\[Placeholder]"}], "prodt" -> RowBox[{
     UnderoverscriptBox["\[Product]", 
      RowBox[{"\[SelectionPlaceholder]", "=", "\[Placeholder]"}], 
      "\[Placeholder]"], "\[Placeholder]"}], "dt" -> RowBox[{
     SubscriptBox["\[PartialD]", "\[Placeholder]"], " ", 
     "\[SelectionPlaceholder]"}], "notation" -> RowBox[{"Notation", "[", 
     RowBox[{
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> "NotationTemplateStyle"],
        " ", "\[DoubleLongLeftRightArrow]", " ", 
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> 
        "NotationTemplateStyle"]}], "]"}], "notation>" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> "NotationTemplateStyle"],
        " ", "\[DoubleLongRightArrow]", " ", 
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> 
        "NotationTemplateStyle"]}], "]"}], "notation<" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> "NotationTemplateStyle"],
        " ", "\[DoubleLongLeftArrow]", " ", 
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> 
        "NotationTemplateStyle"]}], "]"}], "symb" -> 
  RowBox[{"Symbolize", "[", 
     TagBox[
     "\[Placeholder]", NotationBoxTag, TagStyle -> "NotationTemplateStyle"], 
     "]"}], "infixnotation" -> RowBox[{"InfixNotation", "[", 
     RowBox[{
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> "NotationTemplateStyle"],
        ",", "\[Placeholder]"}], "]"}], "addia" -> 
  RowBox[{"AddInputAlias", "[", 
     RowBox[{"\"\[Placeholder]\"", "\[Rule]", 
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> 
        "NotationTemplateStyle"]}], "]"}], "pattwraper" -> 
  TagBox["\[Placeholder]", NotationPatternTag, TagStyle -> 
    "NotationPatternWrapperStyle"], "madeboxeswraper" -> 
  TagBox["\[Placeholder]", NotationMadeBoxesTag, TagStyle -> 
    "NotationMadeBoxesWrapperStyle"], "Ex" -> "\[ScriptCapitalE]", "E" -> 
  "\[ScriptCapitalE]"},
Magnification->1.5,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->"EMMStyle02.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 1081, 27, 393, "Title"],
Cell[1674, 52, 363, 7, 32, "Text"],
Cell[2040, 61, 147, 4, 43, "Input",
 InitializationCell->True],
Cell[2190, 67, 228, 6, 43, "Input"],
Cell[2421, 75, 411, 9, 125, "Input",
 InitializationCell->True],
Cell[2835, 86, 338, 8, 98, "Input",
 InitializationCell->True],
Cell[3176, 96, 324, 8, 98, "Input",
 InitializationCell->True],
Cell[3503, 106, 267, 7, 43, "Input",
 InitializationCell->True],
Cell[3773, 115, 291, 8, 71, "Input",
 InitializationCell->True],
Cell[4067, 125, 259, 7, 43, "Input",
 InitializationCell->True],
Cell[4329, 134, 323, 8, 98, "Input",
 InitializationCell->True],
Cell[4655, 144, 182, 5, 43, "Input",
 InitializationCell->True],
Cell[4840, 151, 1930, 51, 206, "Input",
 InitializationCell->True],
Cell[6773, 204, 243, 7, 43, "Input",
 InitializationCell->True],
Cell[7019, 213, 2012, 57, 314, "Input",
 InitializationCell->True],
Cell[9034, 272, 1117, 33, 83, "Input",
 InitializationCell->True],
Cell[10154, 307, 504, 14, 55, "Input",
 InitializationCell->True],
Cell[10661, 323, 3344, 88, 434, "Input",
 InitializationCell->True],
Cell[14008, 413, 1214, 34, 110, "Input",
 InitializationCell->True],
Cell[15225, 449, 852, 25, 137, "Input",
 InitializationCell->True],
Cell[16080, 476, 484, 16, 55, "Input",
 InitializationCell->True],
Cell[16567, 494, 5228, 138, 677, "Input",
 InitializationCell->True],
Cell[21798, 634, 420, 14, 55, "Input",
 InitializationCell->True],
Cell[22221, 650, 341, 11, 55, "Input",
 InitializationCell->True],
Cell[22565, 663, 159, 5, 55, "Input",
 InitializationCell->True],
Cell[22727, 670, 128, 4, 55, "Input",
 InitializationCell->True]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
