(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    129703,       3987]
NotebookOptionsPosition[    118163,       3628]
NotebookOutlinePosition[    120845,       3691]
CellTagsIndexPosition[    120802,       3688]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "LimitBookDepthI\n",
 StyleBox["Empirical Market Microstructure",
  FontSlant->"Italic"],
 " \n\t(2006, Oxford University Press)\nCompanion ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook\n\nJoel Hasbrouck\n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Copyright", " ", "2007"}], ",", " ", 
    RowBox[{"Joel", " ", 
     RowBox[{"Hasbrouck", ".", " ", "All"}], " ", "rights", " ", 
     RowBox[{"reserved", "."}]}]}], TraditionalForm]],
  FontSize->14,
  FontSlant->"Italic"],
 "\n",
 StyleBox["This notebook covers Glosten (1989, 1994) discussed in Chapter 13, \
Sections 13.1-13.3",
  FontSize->14]
}], "Title",
 CellChangeTimes->{{3.3896255910914*^9, 3.3896255932033997`*^9}, {
   3.3897167078988237`*^9, 3.389716768500824*^9}, 3.3897219191158237`*^9, {
   3.3899919263996*^9, 3.3899919275346003`*^9}, {3.3899924133546*^9, 
   3.3899924443206*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Text", "  ", "@", " ", 
  RowBox[{"Style", "[", 
   RowBox[{
    RowBox[{"\"\<Notebook evaluated \>\"", "<>", 
     RowBox[{"DateString", "[", "\"\<DateTime\>\"", "]"}]}], ",", 
    "\"\<Subtitle\>\""}], "]"}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896127180972*^9, 3.3896127205282*^9}, 
   3.389716999411824*^9, {3.3897170351038237`*^9, 3.389717047196824*^9}}],

Cell[BoxData[
 InterpretationBox[Cell[BoxData[
   StyleBox["\<\"Notebook evaluated Monday 4 June 2007 20:35:42\"\>", 
    "Subtitle",
    StripOnInput->False]], "Text", "TR"],
  Text[
   Style["Notebook evaluated Monday 4 June 2007 20:35:42", 
    "Subtitle"]]]], "Output",
 CellMargins->{{18, Inherited}, {Inherited, 0}},
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896127211071997`*^9, {3.3896127536242*^9, 3.3896127555652*^9}, 
   3.3896128616452*^9, 3.389623031447*^9, 3.3896232934164*^9, 
   3.389716955274824*^9, 3.3897170008718243`*^9, {3.3897170377738237`*^9, 
   3.3897170482808237`*^9}, 3.3899920823416*^9, 3.3899921326345997`*^9, 
   3.3899925422046003`*^9},
 Background->RGBColor[0.866667, 0.733333, 1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Preliminaries", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "SetDirectory", "[", 
   "\"\<c:/Active/Empirical Market Microstructure/Mathematica/Spring \
2007\>\"", "]"}], ";"}]], "Input",
 CellAutoOverwrite->False,
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3881708634346*^9, 3.3881708734596*^9}, {
  3.3881710728336*^9, 3.3881711170716*^9}, {3.389524702079319*^9, 
  3.389524702676319*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{"<<", "MVN.m"}], "Input"]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"<<", "Notation`"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896316649161997`*^9, 3.3896316692592*^9}}],

Cell["\<\
The following commands define symbolizations that are convenient for labeling \
things.\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["Anything_", "Rule"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";", 
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["Anything_", "Rules"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3899924650736*^9}],

Cell["\<\
The following command allows the \"expectation\" operator to be entered as \
\[EscapeKey]E\[EscapeKey].\
\>", "Text"],

Cell[BoxData[
 RowBox[{"AddInputAlias", "[", 
  RowBox[{
   TagBox["\[ScriptCapitalE]",
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], ",", "\"\<E\>\""}], "]"}]], "Input",
 CellLabelAutoDelete->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rules related to normal distribution", "Section"],

Cell[CellGroupData[{

Cell["\[Phi][x], \[CapitalPhi][X], etc.", "Subsection"],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"\[Phi]", "[", "x", "]"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"\[CapitalPhi]", "[", "x", "]"}]]],
 " are often used to denote the density and distribution functions for the \
standard normal distribution."
}], "Text"],

Cell[BoxData[
 RowBox[{"\n", 
  RowBox[{
   RowBox[{
    SubscriptBox["Normal", "Rules"], "=", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"\[Phi]", "[", "x_", "]"}], "\[RuleDelayed]", 
       RowBox[{"PDF", "[", 
        RowBox[{
         RowBox[{"NormalDistribution", "[", 
          RowBox[{"0", ",", "1"}], "]"}], ",", "x"}], "]"}]}], ",", 
      RowBox[{
       RowBox[{"\[CapitalPhi]", "[", "x_", "]"}], "\[RuleDelayed]", 
       RowBox[{"CDF", "[", 
        RowBox[{
         RowBox[{"NormalDistribution", "[", 
          RowBox[{"0", ",", "1"}], "]"}], ",", "x"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"\[Phi]", "[", 
        RowBox[{"x_", ",", "\[Mu]_", ",", "var_"}], "]"}], "\[RuleDelayed]", 
       RowBox[{"PDF", "[", 
        RowBox[{
         RowBox[{"NormalDistribution", "[", 
          RowBox[{"\[Mu]", ",", 
           SqrtBox["var"]}], "]"}], ",", "x"}], "]"}]}], ",", 
      RowBox[{
       RowBox[{"\[CapitalPhi]", "[", 
        RowBox[{"x_", ",", "\[Mu]_", ",", "var_"}], "]"}], "\[RuleDelayed]", 
       RowBox[{"CDF", "[", 
        RowBox[{
         RowBox[{"NormalDistribution", "[", 
          RowBox[{"\[Mu]", ",", 
           SqrtBox["var"]}], "]"}], ",", "x"}], "]"}]}]}], "}"}]}], 
   ";"}]}]], "Input",
 CellLabelAutoDelete->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Expectations of truncated normal variates", "Subsection"],

Cell[TextData[{
 "First consider ",
 Cell[BoxData[
  RowBox[{"E", "[", 
   RowBox[{"x", "|", 
    RowBox[{"x", "\[GreaterEqual]", "xLow"}]}], "]"}]]],
 " where ",
 Cell[BoxData["x"]],
 " is normally distributed. In the problems considered here, ",
 Cell[BoxData["x"]],
 " will always be an element of a vector that is distributed as a \
multivariate normal denoted ",
 Cell[BoxData["MVN"]],
 ". (See the ",
 Cell[BoxData[
  RowBox[{"MVN", ".", "m"}]]],
 " package and the ",
 Cell[BoxData[
  RowBox[{"MVN", " ", 
   RowBox[{"Demo", ".", "nb"}]}]]],
 " notebook.) The truncated expectation is:"
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GetMeanTrunc", "[", 
   RowBox[{"m_MVN", ",", "x_", ",", "xLow_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"d", ",", "\[Mu]", ",", "v", ",", "\[Alpha]", ",", "\[Lambda]"}],
      "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"d", "=", 
      RowBox[{"MakeLinearForm", "[", 
       RowBox[{"m", ",", 
        RowBox[{"{", "x", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Mu]", "=", 
      RowBox[{"GetMean", "[", "d", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"v", "=", 
      RowBox[{"GetVariance", "[", "d", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Alpha]", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"xLow", "-", "\[Mu]"}], ")"}], "/", 
       SqrtBox["v"]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Lambda]", "=", 
      FractionBox[
       RowBox[{"\[Phi]", "[", "\[Alpha]", "]"}], 
       RowBox[{"1", "-", 
        RowBox[{"\[CapitalPhi]", "[", "\[Alpha]", "]"}]}]]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"\[Mu]", "+", 
      RowBox[{
       SqrtBox["v"], "\[Lambda]"}]}]}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "where ",
 Cell[BoxData["m"]],
 " is an ",
 Cell[BoxData["MVN"]],
 " that contains variable ",
 Cell[BoxData["x"]],
 ". Example:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mSample", "=", 
  RowBox[{"MVN", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["\[Mu]", "1"], ",", 
      SubscriptBox["\[Mu]", "2"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "1", "2"], ",", 
        SubscriptBox["\[Sigma]", "12"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["\[Sigma]", "12"], ",", 
        SubsuperscriptBox["\[Sigma]", "2", "2"]}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["x", "1"], ",", 
      SubscriptBox["x", "2"]}], "}"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389721047663624*^9, 3.3897210497686243`*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["x", "1"]},
        {
         SubscriptBox["x", "2"]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["\[Mu]", "1"]},
        {
         SubscriptBox["\[Mu]", "2"]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubsuperscriptBox["\[Sigma]", "1", "2"], 
        SubscriptBox["\[Sigma]", "12"]},
       {
        SubscriptBox["\[Sigma]", "12"], 
        SubsuperscriptBox["\[Sigma]", "2", "2"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896317275872*^9, 3.3897007445062237`*^9, 
  3.389719067970624*^9, 3.389721144854824*^9, 3.3899925439446*^9}]
}, Open  ]],

Cell[TextData[{
 "Then ",
 Cell[BoxData[
  RowBox[{"E", "[", 
   RowBox[{
    SubscriptBox["x", "1"], "|", 
    RowBox[{
     SubscriptBox["x", "1"], "\[GreaterEqual]", 
     SubscriptBox["x", "Low"]}]}], "]"}]]],
 " is:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetMeanTrunc", "[", 
  RowBox[{"mSample", ",", 
   SubscriptBox["x", "1"], ",", 
   SubscriptBox["x", "Low"]}], "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389721053422624*^9, 3.3897210545256243`*^9}}],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Mu]", "1"], "+", 
  FractionBox[
   RowBox[{
    SqrtBox[
     SubsuperscriptBox["\[Sigma]", "1", "2"]], " ", 
    RowBox[{"\[Phi]", "[", 
     FractionBox[
      RowBox[{
       SubscriptBox["x", "Low"], "-", 
       SubscriptBox["\[Mu]", "1"]}], 
      SqrtBox[
       SubsuperscriptBox["\[Sigma]", "1", "2"]]], "]"}]}], 
   RowBox[{"1", "-", 
    RowBox[{"\[CapitalPhi]", "[", 
     FractionBox[
      RowBox[{
       SubscriptBox["x", "Low"], "-", 
       SubscriptBox["\[Mu]", "1"]}], 
      SqrtBox[
       SubsuperscriptBox["\[Sigma]", "1", "2"]]], "]"}]}]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896317276252003`*^9, 3.389700744553224*^9, 
  3.389719067998624*^9, 3.389721144882824*^9, 3.3899925440495996`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GetMeanTrunc", "[", 
    RowBox[{"m_MVN", ",", "y_", ",", "x_", ",", "xLow_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "d", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"d", "=", 
       RowBox[{"MVNConditional", "[", 
        RowBox[{"m", ",", "y", ",", "x"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"GetMean", "[", "d", "]"}], "/.", 
       RowBox[{"x", "\[Rule]", 
        RowBox[{"GetMeanTrunc", "[", 
         RowBox[{"m", ",", "x", ",", "xLow"}], "]"}]}]}]}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GetMeanTrunc", "[", 
   RowBox[{
    RowBox[{"StandardMVN", "[", "2", "]"}], ",", 
    SubscriptBox["z", "1"], ",", "0"}], "]"}], "/.", 
  SubscriptBox["Normal", "Rules"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 SqrtBox[
  FractionBox["2", "\[Pi]"]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896317276702003`*^9, 3.389700744680224*^9, 
  3.389719068036624*^9, 3.3897211449168243`*^9, 3.3899925441205997`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GetMeanTrunc", "[", 
    RowBox[{
     RowBox[{"MVN", "[", 
      RowBox[{"2", ",", "9", ",", "z"}], "]"}], ",", "z", ",", "1"}], "]"}], "/.",
    
   SubscriptBox["Normal", "Rules"]}], "//", "N"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData["3.7954708343952186`"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896317277242002`*^9, 3.389700744751224*^9, 
  3.3897190680666237`*^9, 3.389721144947824*^9, 3.3899925441696*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GetMeanTrunc", "[", 
    RowBox[{
     RowBox[{"MVN", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"8", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "3"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", "y", ",", "x", ",", 
     "2"}], "]"}], "/.", 
   SubscriptBox["Normal", "Rules"]}], "//", "N"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData["2.622889727232932`"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896317277882*^9, 3.389700744828224*^9, 
  3.389719068098624*^9, 3.389721144983824*^9, 3.3899925442316*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Setup common to all market variants.", "Section"],

Cell[CellGroupData[{

Cell["Customer's utility", "Subsection"],

Cell["\<\
Certainty equivalent with CARA utility and normally-distributed terminal \
wealth:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["CE", "Rule"], "=", 
  RowBox[{
   RowBox[{"CE", "[", 
    RowBox[{"\[Mu]_", ",", "var_"}], "]"}], "\[RuleDelayed]", 
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Exponent", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"CharacteristicFunction", "[", 
            RowBox[{
             RowBox[{"NormalDistribution", "[", 
              RowBox[{"\[Mu]", ",", 
               SqrtBox["var"]}], "]"}], ",", "t"}], "]"}]}], "/.", 
          RowBox[{"t", "\[Rule]", 
           RowBox[{"I", " ", "\[Rho]"}]}]}], ",", "E"}], "]"}]}], "/", 
      "\[Rho]"}], "//", "Simplify"}], "]"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"CE", "[", 
   RowBox[{"\[Mu]_", ",", "var_"}], "]"}], "\[RuleDelayed]", 
  RowBox[{"\[Mu]", "-", 
   FractionBox[
    RowBox[{"var", " ", "\[Rho]"}], "2"]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896317352022*^9, 3.389700758184224*^9, 
  3.3897190686506243`*^9, 3.389719104800624*^9, 3.3897211519238243`*^9, 
  3.3899925443026*^9}]
}, Open  ]],

Cell[TextData[{
 "The customer is endowed with ",
 Cell[BoxData["n"]],
 " shares; she purchases ",
 Cell[BoxData["q"]],
 " shares, paying ",
 Cell[BoxData[
  RowBox[{"R", "[", "q", "]"}]]],
 " (the dealer's revenue). Her certainty equivalent wealth is:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ce", "=", 
  RowBox[{
   RowBox[{"CE", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"R", "[", "q", "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "+", "q"}], ")"}], "\[ScriptCapitalE]Cond"}]}], ",", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"n", "+", "q"}], ")"}], "2"], "VarCond"}]}], "]"}], "/.", 
   SubscriptBox["CE", "Rule"]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"n", "+", "q"}], ")"}], " ", "\[ScriptCapitalE]Cond"}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"n", "+", "q"}], ")"}], "2"], " ", "VarCond", " ", "\[Rho]"}], 
  "-", 
  RowBox[{"R", "[", "q", "]"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896317352412*^9, 3.389700758221224*^9, 
  3.389719068712624*^9, 3.389721151953824*^9, 3.3899925443536*^9}]
}, Open  ]],

Cell[TextData[{
 "where ",
 Cell[BoxData["\[ScriptCapitalE]Cond"]],
 " and ",
 Cell[BoxData["VarCond"]],
 " are the mean and variance of the security payoff, conditional on the \
customer's signal."
}], "Text"],

Cell["The first-order condition is:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[PartialD]", "q"], " ", "ce"}], "\[Equal]", "0"}], 
     ")"}], ",", 
    RowBox[{
     SuperscriptBox["R", "\[Prime]"], "[", "q", "]"}]}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SuperscriptBox["R", "\[Prime]",
      MultilineFunction->None], "[", "q", "]"}], "\[Rule]", 
    RowBox[{"\[ScriptCapitalE]Cond", "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"n", "+", "q"}], ")"}], " ", "VarCond", " ", "\[Rho]"}]}]}], 
   "}"}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896317352792*^9, 3.389700758298224*^9, 
  3.389719068746624*^9, 3.389721152003824*^9, 3.3899925444356003`*^9}]
}, Open  ]],

Cell[TextData[{
 "Defining the l.h.s. as the marginal revenue ",
 Cell[BoxData["M"]],
 " we have:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["M", "Rule"], "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Take", " ", "@@", " ", 
     RowBox[{"Take", " ", "@@", " ", "%"}]}], "/.", 
    RowBox[{
     RowBox[{
      SuperscriptBox["R", "\[Prime]"], "[", "q", "]"}], "\[Rule]", "M"}]}], "//",
    "Simplify"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"M", "\[Rule]", 
  RowBox[{"\[ScriptCapitalE]Cond", "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"n", "+", "q"}], ")"}], " ", "VarCond", " ", 
    "\[Rho]"}]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896317353252*^9, 3.389700758343224*^9, 
  3.389719068780624*^9, 3.3897211520558243`*^9, 3.3899925444976*^9}]
}, Open  ]],

Cell[TextData[{
 "Given ",
 Cell[BoxData["q"]],
 ", knowing ",
 Cell[BoxData["M"]],
 " is equivalent to knowing ",
 Cell[BoxData["\[Omega]"]],
 " where"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Omega]", "Rule"], "=", 
  RowBox[{"\[Omega]", "\[Rule]", 
   RowBox[{"\[ScriptCapitalE]Cond", "-", 
    RowBox[{"n", " ", "\[Rho]", " ", "VarCond"}]}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"\[Omega]", "\[Rule]", 
  RowBox[{"\[ScriptCapitalE]Cond", "-", 
   RowBox[{"n", " ", "VarCond", " ", "\[Rho]"}]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896317353712*^9, 3.3897007583882236`*^9, 
  3.389719068813624*^9, 3.389721152108824*^9, 3.3899925445495996`*^9}]
}, Open  ]],

Cell[TextData[{
 "Let ",
 Cell[BoxData["x"]],
 ", ",
 Cell[BoxData["\[Epsilon]"]],
 ", and ",
 Cell[BoxData["n"]],
 " denote (respectively) the secuity payoff, the signal observation error, \
and the customer's endowment. Then:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d1", "=", 
  RowBox[{"MVN", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["\[Mu]", "x"], ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "x", "2"], ",", "0", ",", "0"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], ",", "0"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", 
        SubsuperscriptBox["\[Sigma]", "n", "2"]}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "\[Epsilon]", ",", "n"}], "}"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"x"},
        {"\[Epsilon]"},
        {"n"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["\[Mu]", "x"]},
        {"0"},
        {"0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubsuperscriptBox["\[Sigma]", "x", "2"], "0", "0"},
       {"0", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "0"},
       {"0", "0", 
        SubsuperscriptBox["\[Sigma]", "n", "2"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896317354231997`*^9, 3.389700758441224*^9, 
  3.389719068847624*^9, 3.389721152170824*^9, 3.3899925446076*^9}]
}, Open  ]],

Cell[TextData[{
 "Since the signal is ",
 Cell[BoxData[
  RowBox[{"s", "=", 
   RowBox[{"x", "+", "\[Epsilon]"}]}]]],
 ", we may write:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MakeLinearForm", "[", 
  RowBox[{"d1", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"x", "+", "\[Epsilon]"}], ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"x"},
        {
         RowBox[{"x", "+", "\[Epsilon]"}]},
        {"n"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["\[Mu]", "x"]},
        {
         SubscriptBox["\[Mu]", "x"]},
        {"0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubsuperscriptBox["\[Sigma]", "x", "2"], 
        SubsuperscriptBox["\[Sigma]", "x", "2"], "0"},
       {
        SubsuperscriptBox["\[Sigma]", "x", "2"], 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "0"},
       {"0", "0", 
        SubsuperscriptBox["\[Sigma]", "n", "2"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896317354772*^9, 3.389700758495224*^9, 
  3.389719068880624*^9, 3.389721152243824*^9, 3.3899925446666*^9}]
}, Open  ]],

Cell[TextData[{
 "Now we simply label ",
 Cell[BoxData[
  RowBox[{"x", "+", "\[Epsilon]"}]]],
 " as ",
 Cell[BoxData["s"]],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d2", " ", "=", " ", 
  RowBox[{"SetLabel", "[", 
   RowBox[{"%", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "s", ",", "n"}], "}"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"x"},
        {"s"},
        {"n"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["\[Mu]", "x"]},
        {
         SubscriptBox["\[Mu]", "x"]},
        {"0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubsuperscriptBox["\[Sigma]", "x", "2"], 
        SubsuperscriptBox["\[Sigma]", "x", "2"], "0"},
       {
        SubsuperscriptBox["\[Sigma]", "x", "2"], 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "0"},
       {"0", "0", 
        SubsuperscriptBox["\[Sigma]", "n", "2"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896317355382*^9, 3.389700758552224*^9, 
  3.389719068914624*^9, 3.3897211523208237`*^9, 3.3899925447195997`*^9}]
}, Open  ]],

Cell[TextData[{
 "The conditional distribution of ",
 Cell[BoxData[
  RowBox[{"x", "|", "s"}]]],
 " is:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d2Cond", "=", 
  RowBox[{
   RowBox[{"MVNConditional", "[", 
    RowBox[{"d2", ",", "x", ",", "s"}], "]"}], "//", "Simplify"}]}]], "Input",\

 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"x", 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   FractionBox[
    RowBox[{
     RowBox[{"s", " ", 
      SubsuperscriptBox["\[Sigma]", "x", "2"]}], "+", 
     RowBox[{
      SubscriptBox["\[Mu]", "x"], " ", 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}], 
    RowBox[{
     SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
     SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]], ",", 
   FractionBox[
    RowBox[{
     SubsuperscriptBox["\[Sigma]", "x", "2"], " ", 
     SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], 
    RowBox[{
     SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
     SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896317356052*^9, 3.389700758619224*^9, 
  3.3897190689486237`*^9, 3.3897211523988237`*^9, 3.3899925447846003`*^9}]
}, Open  ]],

Cell[TextData[{
 "Substituting the conditional mean and variance into the expression for ",
 Cell[BoxData["\[Omega]"]],
 " gives:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Omega]2", "Rule"], "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["\[Omega]", "Rule"], "/.", 
     RowBox[{"\[ScriptCapitalE]Cond", "\[Rule]", 
      RowBox[{"GetMean", "[", "d2Cond", "]"}]}]}], "/.", 
    RowBox[{"VarCond", "\[Rule]", 
     RowBox[{"GetVariance", "[", "d2Cond", "]"}]}]}], "//", 
   "Simplify"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"\[Omega]", "\[Rule]", 
  FractionBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Mu]", "x"], " ", 
     SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "+", 
    RowBox[{
     SubsuperscriptBox["\[Sigma]", "x", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"s", "-", 
       RowBox[{"n", " ", "\[Rho]", " ", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}], ")"}]}]}], 
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896317356731997`*^9, 3.3897007587012243`*^9, 
  3.389719068987624*^9, 3.3897211524718237`*^9, 3.3899925448585997`*^9}]
}, Open  ]],

Cell["Then", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MakeLinearForm", "[", 
   RowBox[{"d2", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "s", ",", "n", ",", 
      RowBox[{"\[Omega]", "/.", 
       SubscriptBox["\[Omega]2", "Rule"]}]}], "}"}]}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"x"},
        {"s"},
        {"n"},
        {
         FractionBox[
          RowBox[{
           RowBox[{
            SubscriptBox["\[Mu]", "x"], " ", 
            SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "+", 
           RowBox[{
            SubsuperscriptBox["\[Sigma]", "x", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"s", "-", 
              RowBox[{"n", " ", "\[Rho]", " ", 
               SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}], 
             ")"}]}]}], 
          RowBox[{
           SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
           SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["\[Mu]", "x"]},
        {
         SubscriptBox["\[Mu]", "x"]},
        {"0"},
        {
         SubscriptBox["\[Mu]", "x"]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubsuperscriptBox["\[Sigma]", "x", "2"], 
        SubsuperscriptBox["\[Sigma]", "x", "2"], "0", 
        FractionBox[
         SubsuperscriptBox["\[Sigma]", "x", "4"], 
         RowBox[{
          SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
          SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]]},
       {
        SubsuperscriptBox["\[Sigma]", "x", "2"], 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "0", 
        SubsuperscriptBox["\[Sigma]", "x", "2"]},
       {"0", "0", 
        SubsuperscriptBox["\[Sigma]", "n", "2"], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"\[Rho]", " ", 
           SubsuperscriptBox["\[Sigma]", "n", "2"], " ", 
           SubsuperscriptBox["\[Sigma]", "x", "2"], " ", 
           SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], 
          RowBox[{
           SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
           SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]]}]},
       {
        FractionBox[
         SubsuperscriptBox["\[Sigma]", "x", "4"], 
         RowBox[{
          SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
          SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]], 
        SubsuperscriptBox["\[Sigma]", "x", "2"], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"\[Rho]", " ", 
           SubsuperscriptBox["\[Sigma]", "n", "2"], " ", 
           SubsuperscriptBox["\[Sigma]", "x", "2"], " ", 
           SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], 
          RowBox[{
           SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
           SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]]}], 
        FractionBox[
         RowBox[{
          SubsuperscriptBox["\[Sigma]", "x", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
            SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "+", 
            RowBox[{
             SuperscriptBox["\[Rho]", "2"], " ", 
             SubsuperscriptBox["\[Sigma]", "n", "2"], " ", 
             SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "4"]}]}], ")"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
            SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}], "2"]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896317357452*^9, 3.3897007587892237`*^9, 
  3.389719069036624*^9, 3.389721152552824*^9, 3.3899925449666*^9}]
}, Open  ]],

Cell[TextData[{
 "and relabeling the last element as ",
 Cell[BoxData["\[Omega]"]],
 " gives:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d3", "=", 
  RowBox[{"SetLabel", "[", 
   RowBox[{"%", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "s", ",", "n", ",", "\[Omega]"}], "}"}]}], 
   "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"x"},
        {"s"},
        {"n"},
        {"\[Omega]"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["\[Mu]", "x"]},
        {
         SubscriptBox["\[Mu]", "x"]},
        {"0"},
        {
         SubscriptBox["\[Mu]", "x"]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubsuperscriptBox["\[Sigma]", "x", "2"], 
        SubsuperscriptBox["\[Sigma]", "x", "2"], "0", 
        FractionBox[
         SubsuperscriptBox["\[Sigma]", "x", "4"], 
         RowBox[{
          SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
          SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]]},
       {
        SubsuperscriptBox["\[Sigma]", "x", "2"], 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "0", 
        SubsuperscriptBox["\[Sigma]", "x", "2"]},
       {"0", "0", 
        SubsuperscriptBox["\[Sigma]", "n", "2"], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"\[Rho]", " ", 
           SubsuperscriptBox["\[Sigma]", "n", "2"], " ", 
           SubsuperscriptBox["\[Sigma]", "x", "2"], " ", 
           SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], 
          RowBox[{
           SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
           SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]]}]},
       {
        FractionBox[
         SubsuperscriptBox["\[Sigma]", "x", "4"], 
         RowBox[{
          SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
          SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]], 
        SubsuperscriptBox["\[Sigma]", "x", "2"], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"\[Rho]", " ", 
           SubsuperscriptBox["\[Sigma]", "n", "2"], " ", 
           SubsuperscriptBox["\[Sigma]", "x", "2"], " ", 
           SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], 
          RowBox[{
           SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
           SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]]}], 
        FractionBox[
         RowBox[{
          SubsuperscriptBox["\[Sigma]", "x", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
            SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "+", 
            RowBox[{
             SuperscriptBox["\[Rho]", "2"], " ", 
             SubsuperscriptBox["\[Sigma]", "n", "2"], " ", 
             SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "4"]}]}], ")"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
            SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}], "2"]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896317358062*^9, 3.389700758868224*^9, 
  3.3897190690706244`*^9, 3.389721152627824*^9, 3.3899925450355997`*^9}]
}, Open  ]],

Cell[TextData[{
 "The liquidity suppliers will try to estimate ",
 Cell[BoxData[
  RowBox[{"x", "|", "\[Omega]"}]]],
 ". The relevant conditional distribution is:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d3Cond", "=", 
  RowBox[{"MVNConditional", "[", 
   RowBox[{"d3", ",", "x", ",", "\[Omega]"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"x", 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   RowBox[{
    SubscriptBox["\[Mu]", "x"], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"\[Omega]", "-", 
        SubscriptBox["\[Mu]", "x"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}], 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "+", 
      RowBox[{
       SuperscriptBox["\[Rho]", "2"], " ", 
       SubsuperscriptBox["\[Sigma]", "n", "2"], " ", 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "4"]}]}]]}], ",", 
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "x", "2"], "-", 
    FractionBox[
     SubsuperscriptBox["\[Sigma]", "x", "4"], 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "+", 
      RowBox[{
       SuperscriptBox["\[Rho]", "2"], " ", 
       SubsuperscriptBox["\[Sigma]", "n", "2"], " ", 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "4"]}]}]]}], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896317358722*^9, 3.389700758972224*^9, 
  3.389719069114624*^9, 3.389721152696824*^9, 3.3899925451046*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"E", "[", 
   RowBox[{
    RowBox[{"x", "|", "M"}], "=", "m"}], "]"}]]],
 ":"
}], "Subsubsection"],

Cell[TextData[{
 "The expectation of ",
 Cell[BoxData["x"]],
 " given the that the marginal revenue is exactly equal to ",
 Cell[BoxData["m"]],
 "  is"
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ScriptCapitalE]Point", "[", "m_", "]"}], ":=", 
  RowBox[{"Evaluate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"GetMean", "[", "d3Cond", "]"}], "/.", 
     RowBox[{"\[Omega]", "\[Rule]", 
      RowBox[{"m", "+", 
       RowBox[{"q", " ", "\[Rho]", " ", 
        RowBox[{"GetVariance", "[", "d2Cond", "]"}]}]}]}]}], "//", 
    "Simplify"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[ScriptCapitalE]Point", "[", "m", "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "x", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"m", "+", 
      RowBox[{"q", " ", "\[Rho]", " ", 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}], ")"}]}], "+", 
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"m", "+", 
      RowBox[{
       SuperscriptBox["\[Rho]", "2"], " ", 
       SubscriptBox["\[Mu]", "x"], " ", 
       SubsuperscriptBox["\[Sigma]", "n", "2"], " ", 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}], ")"}]}]}], 
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
   SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "+", 
   RowBox[{
    SuperscriptBox["\[Rho]", "2"], " ", 
    SubsuperscriptBox["\[Sigma]", "n", "2"], " ", 
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "4"]}]}]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896317359532003`*^9, 3.3897007590842237`*^9, 
  3.389719069166624*^9, 3.389721152793824*^9, 3.3899925451956*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 " ",
 Cell[BoxData[
  RowBox[{"E", "[", 
   RowBox[{"x", "|", 
    RowBox[{"M", "\[GreaterEqual]", "m"}]}], "]"}]]]
}], "Subsubsection"],

Cell[TextData[{
 "The expectation of ",
 Cell[BoxData["x"]],
 " given that the marginal revenue is greater than or equal to ",
 Cell[BoxData["m"]],
 " is the truncated (\"upper tail\") expectation."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ute", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"GetMeanTrunc", "[", 
     RowBox[{"d3", ",", "x", ",", "\[Omega]", ",", "\[Omega]Low"}], "]"}], "/.",
     
    RowBox[{"\[Omega]Low", "\[Rule]", 
     RowBox[{"m", "+", 
      RowBox[{"q", " ", "\[Rho]", " ", 
       RowBox[{"GetVariance", "[", "d2Cond", "]"}]}]}]}]}], "//", 
   "Simplify"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Mu]", "x"], "-", 
  FractionBox[
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "x", "4"], " ", 
    RowBox[{"\[Phi]", "[", 
     FractionBox[
      RowBox[{"m", "-", 
       SubscriptBox["\[Mu]", "x"], "+", 
       FractionBox[
        RowBox[{"q", " ", "\[Rho]", " ", 
         SubsuperscriptBox["\[Sigma]", "x", "2"], " ", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]]}], 
      SqrtBox[
       FractionBox[
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "x", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
           SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "+", 
           RowBox[{
            SuperscriptBox["\[Rho]", "2"], " ", 
            SubsuperscriptBox["\[Sigma]", "n", "2"], " ", 
            SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "4"]}]}], ")"}]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
           SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}], "2"]]]],
      "]"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}], " ", 
    SqrtBox[
     FractionBox[
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "x", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "+", 
         RowBox[{
          SuperscriptBox["\[Rho]", "2"], " ", 
          SubsuperscriptBox["\[Sigma]", "n", "2"], " ", 
          SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "4"]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}], "2"]]], 
    " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"\[CapitalPhi]", "[", 
       FractionBox[
        RowBox[{"m", "-", 
         SubscriptBox["\[Mu]", "x"], "+", 
         FractionBox[
          RowBox[{"q", " ", "\[Rho]", " ", 
           SubsuperscriptBox["\[Sigma]", "x", "2"], " ", 
           SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], 
          RowBox[{
           SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
           SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]]}], 
        SqrtBox[
         FractionBox[
          RowBox[{
           SubsuperscriptBox["\[Sigma]", "x", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
             SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "+", 
             RowBox[{
              SuperscriptBox["\[Rho]", "2"], " ", 
              SubsuperscriptBox["\[Sigma]", "n", "2"], " ", 
              SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "4"]}]}], ")"}]}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
             SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}], 
           "2"]]]], "]"}]}], ")"}]}]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896317361862*^9, 3.389700759320224*^9, 
  3.389719069383624*^9, 3.389719362792624*^9, 3.389721153335824*^9, 
  3.3899925456996*^9}]
}, Open  ]],

Cell[TextData[{
 "where ",
 Cell[BoxData["\[Phi]"]],
 " and ",
 Cell[BoxData["\[CapitalPhi]"]],
 " are the density and c.d.f. of the standard normal distibution. Writing \
this as a function of ",
 Cell[BoxData["m"]],
 ":"
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ScriptCapitalE]Tail", "[", "m_", "]"}], ":=", 
  RowBox[{"Evaluate", "[", 
   RowBox[{"ute", "/.", 
    SubscriptBox["Normal", "Rules"]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Common parameters used to generate (most) graphs", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CommonParams", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Rho]", "\[Rule]", "1"}], ",", 
     RowBox[{
      SubscriptBox["\[Sigma]", "x"], "\[Rule]", "1"}], ",", 
     RowBox[{
      SubscriptBox["\[Sigma]", "\[Epsilon]"], "\[Rule]", "1"}], ",", 
     RowBox[{
      SubscriptBox["\[Sigma]", "n"], "\[Rule]", "2"}], ",", 
     RowBox[{
      SubscriptBox["\[Mu]", "x"], "\[Rule]", "5"}]}], "}"}]}], ";"}]], "Input",\

 CellLabelAutoDelete->True]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Dealer market: competitive solution with price conjecture (Glosten (1989))\
\>", "Section"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["R", "Rule"], "=", 
   RowBox[{
    RowBox[{"R", "[", "q_", "]"}], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"P", "[", "q", "]"}], " ", "q"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["P", "Conjecture"], "=", 
   RowBox[{
    RowBox[{"P", "[", "q_", "]"}], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["k", "0"], "+", 
     RowBox[{
      SubscriptBox["k", "1"], "q"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"R", "[", "q", "]"}], "/.", 
   SubscriptBox["R", "Rule"]}], "/.", 
  SubscriptBox["P", "Conjecture"]}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"q", " ", 
  RowBox[{"(", 
   RowBox[{
    SubscriptBox["k", "0"], "+", 
    RowBox[{"q", " ", 
     SubscriptBox["k", "1"]}]}], ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896317537492*^9, 3.389719069431624*^9, 
  3.3899925458006*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MarginalCondition", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"P", "[", "q", "]"}], "\[Equal]", 
    RowBox[{"\[ScriptCapitalE]Point", "[", "m", "]"}]}], "/.", 
   RowBox[{"m", "->", 
    RowBox[{
     SubscriptBox["\[PartialD]", "q"], 
     RowBox[{"(", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"R", "[", "q", "]"}], "/.", 
        SubscriptBox["R", "Rule"]}], "/.", 
       SubscriptBox["P", "Conjecture"]}], ")"}]}]}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"P", "[", "q", "]"}], "\[Equal]", 
  FractionBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Sigma]", "x", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["k", "0"], "+", 
       RowBox[{"2", " ", "q", " ", 
        SubscriptBox["k", "1"]}], "+", 
       RowBox[{"q", " ", "\[Rho]", " ", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}], ")"}]}], "+", 
    RowBox[{
     SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["k", "0"], "+", 
       RowBox[{"2", " ", "q", " ", 
        SubscriptBox["k", "1"]}], "+", 
       RowBox[{
        SuperscriptBox["\[Rho]", "2"], " ", 
        SubscriptBox["\[Mu]", "x"], " ", 
        SubsuperscriptBox["\[Sigma]", "n", "2"], " ", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}], ")"}]}]}], 
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "+", 
    RowBox[{
     SuperscriptBox["\[Rho]", "2"], " ", 
     SubsuperscriptBox["\[Sigma]", "n", "2"], " ", 
     SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "4"]}]}]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896317538012*^9, 3.389719069458624*^9, 
  3.3899925458646*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["\[ForAll]", "q"], 
      RowBox[{"(", 
       RowBox[{"MarginalCondition", "/.", 
        SubscriptBox["P", "Conjecture"]}], ")"}]}], "&&", 
     RowBox[{"\[Rho]", "\[NotEqual]", "0"}], " ", "&&", 
     RowBox[{
      SubscriptBox["\[Sigma]", "\[Epsilon]"], "\[NotEqual]", "0"}], "&&", 
     RowBox[{
      SubscriptBox["\[Sigma]", "x"], "\[NotEqual]", "0"}], "&&", 
     RowBox[{
      SubscriptBox["\[Sigma]", "n"], "\[NotEqual]", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["k", "0"], ",", 
      SubscriptBox["k", "1"]}], "}"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["k", "0"], "\[Equal]", 
   SubscriptBox["\[Mu]", "x"]}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     SubsuperscriptBox["\[Sigma]", "x", "2"]}], "-", 
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "+", 
    RowBox[{
     SuperscriptBox["\[Rho]", "2"], " ", 
     SubsuperscriptBox["\[Sigma]", "n", "2"], " ", 
     SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "4"]}]}], "\[NotEqual]", 
   "0"}], "&&", 
  RowBox[{
   SubscriptBox["k", "1"], "\[Equal]", 
   FractionBox[
    RowBox[{"\[Rho]", " ", 
     SubsuperscriptBox["\[Sigma]", "x", "2"], " ", 
     SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], 
    RowBox[{
     RowBox[{"-", 
      SubsuperscriptBox["\[Sigma]", "x", "2"]}], "-", 
     SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "+", 
     RowBox[{
      SuperscriptBox["\[Rho]", "2"], " ", 
      SubsuperscriptBox["\[Sigma]", "n", "2"], " ", 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "4"]}]}]]}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Rho]", " ", 
     SubscriptBox["\[Sigma]", "n"], " ", 
     SubsuperscriptBox["\[Sigma]", "x", "3"], " ", 
     SubscriptBox["\[Sigma]", "\[Epsilon]"]}], "+", 
    RowBox[{"\[Rho]", " ", 
     SubscriptBox["\[Sigma]", "n"], " ", 
     SubscriptBox["\[Sigma]", "x"], " ", 
     SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "3"]}], "+", 
    RowBox[{
     SuperscriptBox["\[Rho]", "3"], " ", 
     SubsuperscriptBox["\[Sigma]", "n", "3"], " ", 
     SubscriptBox["\[Sigma]", "x"], " ", 
     SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "5"]}]}], "\[NotEqual]", 
   "0"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896317539152*^9, 3.3897190695776243`*^9, 
  3.3899925460495996`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["k", "Rules"], "=", 
  RowBox[{"ToRules", "[", 
   RowBox[{
    RowBox[{"r", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "&&", 
    RowBox[{"r", "[", 
     RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["k", "0"], "\[Rule]", 
    SubscriptBox["\[Mu]", "x"]}], ",", 
   RowBox[{
    SubscriptBox["k", "1"], "\[Rule]", 
    FractionBox[
     RowBox[{"\[Rho]", " ", 
      SubsuperscriptBox["\[Sigma]", "x", "2"], " ", 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], 
     RowBox[{
      RowBox[{"-", 
       SubsuperscriptBox["\[Sigma]", "x", "2"]}], "-", 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "+", 
      RowBox[{
       SuperscriptBox["\[Rho]", "2"], " ", 
       SubsuperscriptBox["\[Sigma]", "n", "2"], " ", 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "4"]}]}]]}]}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896317539652*^9, 3.3897190696106243`*^9, 
  3.3899925461396*^9}]
}, Open  ]],

Cell["Sign the derivatives. ", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"#", ",", 
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{
             SubscriptBox["k", "1"], "/.", 
             SubscriptBox["k", "Rules"]}], ",", "#"}], "]"}], ">", "0"}]}], 
        "}"}], "&"}], "/@", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["\[Sigma]", "x"], ",", 
        SubscriptBox["\[Sigma]", "\[Epsilon]"], ",", 
        SubscriptBox["\[Sigma]", "n"], ",", "\[Rho]"}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[Sigma]", "x"], ">", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Sigma]", "n"], ">", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Sigma]", "\[Epsilon]"], ">", "0"}], ",", 
       RowBox[{"\[Rho]", ">", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SubsuperscriptBox["\[Sigma]", "x", "2"]}], "-", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "+", 
         RowBox[{
          SuperscriptBox["\[Rho]", "2"], " ", 
          SubsuperscriptBox["\[Sigma]", "n", "2"], " ", 
          SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "4"]}]}], ">", "0"}]}], 
      "}"}]}], "]"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "Parameter", ",", 
        "\"\<\!\(\*SubscriptBox[\(\[PartialD]\), \
\(Parameter\)]\)\!\(\*SubscriptBox[\(k\), \(1\)]\)>0?\>\""}], "}"}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      StyleBox["\[Null]",
       ShowStringCharacters->False], 
      TagBox["Parameter",
       HoldForm], 
      TagBox["\<\"\\!\\(\\*SubscriptBox[\\(\[PartialD]\\), \
\\(Parameter\\)]\\)\\!\\(\\*SubscriptBox[\\(k\\), \\(1\\)]\\)>0?\"\>",
       HoldForm]},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], 
      SubscriptBox["\[Sigma]", "x"], "True"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], 
      SubscriptBox["\[Sigma]", "\[Epsilon]"], "False"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], 
      SubscriptBox["\[Sigma]", "n"], "False"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], "\[Rho]", "False"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
      "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   TableForm[
   BoxForm`e$, 
    TableHeadings -> {{}, {
      Parameter, 
       "\!\(\*SubscriptBox[\(\[PartialD]\), \
\(Parameter\)]\)\!\(\*SubscriptBox[\(k\), \(1\)]\)>0?"}}]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896317540982*^9, 3.389719069730624*^9, 
  3.3899925464816*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["P", 
   RowBox[{"Comp", " ", "Dealer", " ", "Rule"}]], "=", 
  RowBox[{
   SubscriptBox["P", "Conjecture"], "/.", 
   SubscriptBox["k", "Rules"]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"P", "[", "q_", "]"}], "\[RuleDelayed]", 
  RowBox[{
   SubscriptBox["\[Mu]", "x"], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Rho]", " ", 
       SubsuperscriptBox["\[Sigma]", "x", "2"], " ", 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}], " ", "q"}], 
    
    RowBox[{
     RowBox[{"-", 
      SubsuperscriptBox["\[Sigma]", "x", "2"]}], "-", 
     SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "+", 
     RowBox[{
      SuperscriptBox["\[Rho]", "2"], " ", 
      SubsuperscriptBox["\[Sigma]", "n", "2"], " ", 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "4"]}]}]]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896317541412*^9, 3.389719069767624*^9, 
  3.3899925465656*^9}]
}, Open  ]],

Cell[TextData[{
 "Verify that the solution for ",
 Cell[BoxData[
  SubscriptBox["k", "1"]]],
 " agrees with Glosten solution:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"\[Rho]", " ", 
       SubscriptBox["\[Pi]", "n"], 
       SubscriptBox["\[Pi]", "\[Epsilon]"]}], 
      RowBox[{"N", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "\[Alpha]"}], "-", "1"}], ")"}]}]], "/.", 
     RowBox[{"N", "\[Rule]", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[Rho]", "2"], 
        SubscriptBox["\[Pi]", "x"]}], "+", 
       RowBox[{
        SubscriptBox["\[Pi]", "n"], 
        SubscriptBox["\[Pi]", "\[Epsilon]"], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["\[Pi]", "\[Epsilon]"], "+", 
          SubscriptBox["\[Pi]", "x"]}], ")"}]}]}]}]}], "/.", 
    RowBox[{"\[Alpha]", "\[Rule]", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[Rho]", "2"], 
       SubscriptBox["\[Pi]", "x"]}], 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[Rho]", "2"], 
        SubscriptBox["\[Pi]", "x"]}], "+", 
       RowBox[{
        SubscriptBox["\[Pi]", "n"], 
        SubscriptBox["\[Pi]", "\[Epsilon]"], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["\[Pi]", "\[Epsilon]"], "+", 
          SubscriptBox["\[Pi]", "x"]}], ")"}]}]}]]}]}], "/.", 
   RowBox[{
    SubscriptBox["\[Pi]", "X_"], "\[RuleDelayed]", 
    RowBox[{"1", "/", 
     SubsuperscriptBox["\[Sigma]", "X", "2"]}]}]}], "//", 
  "Simplify"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"\[Rho]", " ", 
    SubsuperscriptBox["\[Sigma]", "x", "2"], " ", 
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], 
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "-", 
    RowBox[{
     SuperscriptBox["\[Rho]", "2"], " ", 
     SubsuperscriptBox["\[Sigma]", "n", "2"], " ", 
     SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "4"]}]}]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896317541962*^9, 3.389719069811624*^9, 
  3.3899925466656*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"P", "[", "q", "]"}], "/.", 
   SubscriptBox["P", 
    RowBox[{"Comp", " ", "Dealer", " ", "Rule"}]]}], "/.", 
  "CommonParams"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"5", "+", 
  FractionBox["q", "2"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896317542342*^9, 3.3897190698416243`*^9, 
  3.3899925467326*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"$TextStyle", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
     RowBox[{"FontSize", "\[Rule]", "12"}], ",", 
     RowBox[{"LineSpacing", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "1"}]}], "}"}]}]}], "}"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"Linestyle", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Thickness", "[", 
      RowBox[{".003", " ", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1", ",", "3"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"P", "[", "q", "]"}], "/.", "\[InvisibleSpace]", 
      SubscriptBox["P", 
       RowBox[{"Comp", " ", "Dealer", " ", "Rule"}]]}], "/.", 
     "\[InvisibleSpace]", "CommonParams"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "0", ",", "8"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Linestyle"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "9"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4.9", ",", "7.5"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", "10", ",", "1"}], "]"}], ",", 
      RowBox[{"Range", "[", 
       RowBox[{"5", ",", "8", ",", "1"}], "]"}], ",", "None", ",", "None"}], 
     "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<Quantity purchased\>\"", ",", "\"\<Price and E[x]\>\"", ",", "None",
       ",", "None"}], "}"}]}], ",", 
   RowBox[{"BaseStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896317811102*^9, 3.3896318864202003`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[0.009000000000000001], 
    LineBox[{{1.6326530612244896`*^-7, 5.000000081632653}, {
     0.002453743364477014, 5.001226871682238}, {0.0049073234636479056`, 
     5.002453661731824}, {0.00981448366198969, 5.004907241830995}, {
     0.019628804058673257`, 5.0098144020293365`}, {0.03925744485204039, 
     5.01962872242602}, {0.07851472643877466, 5.039257363219387}, {
     0.1570292896122432, 5.078514644806122}, {0.32726685668366917`, 
     5.163633428341835}, {0.4862230685612167, 5.243111534280608}, {
     0.6420611905510084, 5.321030595275504}, {0.8111077532652889, 
     5.405553876632644}, {0.9688729607856911, 5.484436480392845}, {
     1.1398466090305823`, 5.569923304515291}, {1.3077021673877174`, 
     5.6538510836938585`}, {1.464276370550974, 5.732138185275487}, {
     1.6340590144387197`, 5.81702950721936}, {1.792560303132587, 
     5.896280151566294}, {1.9479435019386981`, 5.9739717509693495`}, {
     2.1165351414692988`, 6.05826757073465}, {2.273845425806021, 
     6.136922712903011}, {2.444364150867232, 6.222182075433616}, {
     2.6117647860406867`, 6.305882393020344}, {2.7678840660202635`, 
     6.383942033010132}, {2.937211786724329, 6.468605893362165}, {
     3.095258152234516, 6.547629076117258}, {3.266512958469192, 
     6.633256479234596}, {3.434649674816112, 6.717324837408056}, {
     3.591505035969154, 6.795752517984577}, {3.7615688378466845`, 
     6.8807844189233425`}, {3.9203512845303368`, 6.960175642265169}, {
     4.076015641326233, 7.0380078206631165`}, {4.244888438846618, 
     7.1224442194233095`}, {4.402479881173125, 7.201239940586563}, {
     4.573279764224121, 7.286639882112061}, {4.740961557387361, 
     7.370480778693681}, {4.8973619953567225`, 7.448680997678361}, {
     5.000000000000001, 7.5}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 5},
  BaseStyle->{FontFamily -> "Times"},
  Frame->True,
  FrameLabel->{
    FormBox["\"Quantity purchased\"", TraditionalForm], 
    FormBox["\"Price and E[x]\"", TraditionalForm], None, None},
  FrameTicks->{{{0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}, {4, 
      FormBox["4", TraditionalForm]}, {5, 
      FormBox["5", TraditionalForm]}, {6, 
      FormBox["6", TraditionalForm]}, {7, 
      FormBox["7", TraditionalForm]}, {8, 
      FormBox["8", TraditionalForm]}, {9, 
      FormBox["9", TraditionalForm]}, {10, 
      FormBox["10", TraditionalForm]}}, {{5, 
      FormBox["5", TraditionalForm]}, {6, 
      FormBox["6", TraditionalForm]}, {7, 
      FormBox["7", TraditionalForm]}, {8, 
      FormBox["8", TraditionalForm]}}, None, None},
  PlotRange->{{0, 9}, {4.9, 7.5}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896317815102*^9, 3.3896318226322002`*^9}, {
   3.3896318693501997`*^9, 3.3896318869582*^9}, 3.389719069917624*^9, 
   3.3899925468796*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Limit order market (Glosten (1994))", "Section"],

Cell[CellGroupData[{

Cell["Glosten Normalizations", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Rho]", " ", 
    RowBox[{"GetVariance", "[", 
     RowBox[{"MVNConditional", "[", 
      RowBox[{"d3", ",", "x", ",", "s"}], "]"}], "]"}]}], "\[Equal]", "1"}], "//",
   "Simplify"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"\[Rho]", " ", 
    SubsuperscriptBox["\[Sigma]", "x", "2"], " ", 
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], 
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]], "\[Equal]", 
  "1"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896319032662*^9, 3.389719069937624*^9, 
  3.389721261399824*^9, 3.3899925469636*^9}]
}, Open  ]],

Cell[TextData[{
 "Glosten suggest",
 "s",
 ": ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"\[Rho]", " ", 
    SubsuperscriptBox["\[Sigma]", 
     RowBox[{"X", "|", "S"}], "2"]}], "=", "1"}]]],
 "; ",
 Cell[BoxData[
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "w", "2"], "=", 
   RowBox[{"\[Alpha]", "<", "1"}]}]]],
 "; ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Var", "[", 
    SubscriptBox["\[Mu]", 
     RowBox[{"X", "|", "S"}]], "]"}], "=", 
   RowBox[{"1", "-", "\[Alpha]"}]}]]],
 ". Check:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GlostenNormalizations", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Rho]", "  ", 
       RowBox[{"GetVariance", "[", 
        RowBox[{"MVNConditional", "[", 
         RowBox[{"d3", ",", "x", ",", "s"}], "]"}], "]"}]}], "\[Equal]", 
      "1"}], ",", " ", 
     RowBox[{
      FractionBox[
       SubsuperscriptBox["\[Sigma]", "x", "4"], 
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]], "\[Equal]", 
      RowBox[{"1", "-", "\[Alpha]"}]}], ",", " ", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "n", "2"], "\[Equal]", "\[Alpha]"}], ",", 
     
     RowBox[{
      SubscriptBox["\[Mu]", "x"], "\[Equal]", "0"}]}], "}"}], "//", 
   "Simplify"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"\[Rho]", " ", 
      SubsuperscriptBox["\[Sigma]", "x", "2"], " ", 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]], "\[Equal]", "1"}], 
   ",", 
   RowBox[{
    RowBox[{"\[Alpha]", "+", 
     FractionBox[
      SubsuperscriptBox["\[Sigma]", "x", "4"], 
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]]}], "\[Equal]", 
    "1"}], ",", 
   RowBox[{"\[Alpha]", "\[Equal]", 
    SubsuperscriptBox["\[Sigma]", "n", "2"]}], ",", 
   RowBox[{
    SubscriptBox["\[Mu]", "x"], "\[Equal]", "0"}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896319033182*^9, 3.3897190699786243`*^9, 
  3.389721261443824*^9, 3.3899925470615997`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{"GlostenNormalizations", ",", "\[Alpha]"}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Mu]", "x"], "\[Equal]", "0"}], "&&", 
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "n", "2"], "\[Equal]", 
   RowBox[{"1", "-", 
    FractionBox[
     SubsuperscriptBox["\[Sigma]", "x", "4"], 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]]}]}], "&&", 
  RowBox[{
   RowBox[{"\[Rho]", " ", 
    SubsuperscriptBox["\[Sigma]", "x", "2"], " ", 
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "\[Equal]", 
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}], "&&", 
  RowBox[{
   RowBox[{"\[Rho]", " ", 
    SubsuperscriptBox["\[Sigma]", "x", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      FractionBox[
       SubsuperscriptBox["\[Sigma]", "x", "2"], 
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]]}], ")"}]}], 
   "\[Equal]", 
   RowBox[{"-", "1"}]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896319033532*^9, 3.389719070014624*^9, 
  3.389721261480824*^9, 3.3899925472506*^9}]
}, Open  ]],

Cell["solve for some numerical values:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"GlostenNormalizations", "/.", 
      RowBox[{
       SubscriptBox["\[Sigma]", "x"], "\[Rule]", "1"}]}], "/.", 
     RowBox[{
      SubscriptBox["\[Sigma]", "\[Epsilon]"], "\[Rule]", "1.2"}]}], "]"}], "//",
    "N"}], "//", "TableForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"\[Rho]", "\[Rule]", "1.6944444444444444`"}], 
     RowBox[{
      SubscriptBox["\[Mu]", "x"], "\[Rule]", "0.`"}], 
     RowBox[{"\[Alpha]", "\[Rule]", "0.5901639344262295`"}], 
     RowBox[{
      SubscriptBox["\[Sigma]", "n"], "\[Rule]", 
      RowBox[{"-", "0.7682212795973759`"}]}]},
    {
     RowBox[{"\[Rho]", "\[Rule]", "1.6944444444444444`"}], 
     RowBox[{
      SubscriptBox["\[Mu]", "x"], "\[Rule]", "0.`"}], 
     RowBox[{"\[Alpha]", "\[Rule]", "0.5901639344262295`"}], 
     RowBox[{
      SubscriptBox["\[Sigma]", "n"], "\[Rule]", "0.7682212795973759`"}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896319033882*^9, 3.389719070047624*^9, 
  3.389721261521824*^9, 3.3899925473536*^9}]
}, Open  ]],

Cell[TextData[{
 "Verif",
 "y",
 " that ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"\[Omega]", "\[Congruent]", 
     RowBox[{
      SubscriptBox["\[Mu]", 
       RowBox[{"X", "|", "S"}]], "-", 
      RowBox[{
       SuperscriptBox["\[Rho]\[Sigma]", "2"], "W"}]}]}], " ", "\[Implies]", 
    " ", 
    RowBox[{"Var", "[", "\[Omega]", "]"}]}], "=", "1"}]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"Append", "[", 
    RowBox[{"GlostenNormalizations", ",", 
     RowBox[{
      RowBox[{"GetVariance", "[", 
       RowBox[{"MakeLinearForm", "[", 
        RowBox[{"d3", ",", 
         RowBox[{"{", "\[Omega]", "}"}]}], "]"}], "]"}], "\[Equal]", 
      SubsuperscriptBox["\[Sigma]", "\[Omega]", "2"]}]}], "]"}], ",", 
   SubscriptBox["\[Sigma]", "\[Omega]"]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "\[Omega]"], "\[Rule]", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", "\[Omega]"], "\[Rule]", "1"}], "}"}]}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896319034442*^9, 3.3897190700926237`*^9, 
  3.389721261576824*^9, 3.3899925474716*^9}]
}, Open  ]],

Cell[TextData[{
 "Verify that with ",
 Cell[BoxData[
  RowBox[{"GlostenNormalizations", ",", " ", 
   RowBox[{
    RowBox[{"\[ScriptCapitalE]C", "\[Congruent]", 
     RowBox[{"E", "[", 
      RowBox[{
       RowBox[{"X", "|", "\[Omega]"}], "=", "w"}], "]"}]}], "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "\[Alpha]"}], ")"}], "w"}]}]}]]],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"Append", "[", 
    RowBox[{"GlostenNormalizations", ",", 
     RowBox[{
      RowBox[{"GetMean", "[", 
       RowBox[{"MVNConditional", "[", 
        RowBox[{"d3", ",", "x", ",", "\[Omega]"}], "]"}], "]"}], "\[Equal]", 
      "\[ScriptCapitalE]C"}]}], "]"}], ",", "\[ScriptCapitalE]C", ",", 
   SubscriptBox["\[Sigma]", "n"]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\[ScriptCapitalE]C", "\[Rule]", 
    RowBox[{"\[Omega]", "-", 
     RowBox[{"\[Alpha]", " ", "\[Omega]"}]}]}], "}"}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896319035081997`*^9, 3.3897190701436243`*^9, 
  3.3897212616408243`*^9, 3.3899925476096*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General case (not imposing Glosten normalizations)", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData["d3"], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389701032303224*^9, 3.389701032515224*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"x"},
        {"s"},
        {"n"},
        {"\[Omega]"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["\[Mu]", "x"]},
        {
         SubscriptBox["\[Mu]", "x"]},
        {"0"},
        {
         SubscriptBox["\[Mu]", "x"]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubsuperscriptBox["\[Sigma]", "x", "2"], 
        SubsuperscriptBox["\[Sigma]", "x", "2"], "0", 
        FractionBox[
         SubsuperscriptBox["\[Sigma]", "x", "4"], 
         RowBox[{
          SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
          SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]]},
       {
        SubsuperscriptBox["\[Sigma]", "x", "2"], 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "0", 
        SubsuperscriptBox["\[Sigma]", "x", "2"]},
       {"0", "0", 
        SubsuperscriptBox["\[Sigma]", "n", "2"], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"\[Rho]", " ", 
           SubsuperscriptBox["\[Sigma]", "n", "2"], " ", 
           SubsuperscriptBox["\[Sigma]", "x", "2"], " ", 
           SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], 
          RowBox[{
           SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
           SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]]}]},
       {
        FractionBox[
         SubsuperscriptBox["\[Sigma]", "x", "4"], 
         RowBox[{
          SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
          SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]], 
        SubsuperscriptBox["\[Sigma]", "x", "2"], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"\[Rho]", " ", 
           SubsuperscriptBox["\[Sigma]", "n", "2"], " ", 
           SubsuperscriptBox["\[Sigma]", "x", "2"], " ", 
           SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], 
          RowBox[{
           SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
           SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]]}], 
        FractionBox[
         RowBox[{
          SubsuperscriptBox["\[Sigma]", "x", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
            SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "+", 
            RowBox[{
             SuperscriptBox["\[Rho]", "2"], " ", 
             SubsuperscriptBox["\[Sigma]", "n", "2"], " ", 
             SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "4"]}]}], ")"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
            SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}], "2"]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389701033026224*^9, 3.389719070173624*^9, 
  3.389721261691824*^9, 3.3899925477076*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d4", "=", 
  RowBox[{"MVNConditional", "[", 
   RowBox[{"d3", ",", "x", ",", "s"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389701098028224*^9, 3.389701099552224*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"x", 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   RowBox[{
    SubscriptBox["\[Mu]", "x"], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"s", "-", 
        SubscriptBox["\[Mu]", "x"]}], ")"}], " ", 
      SubsuperscriptBox["\[Sigma]", "x", "2"]}], 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]]}], ",", 
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "x", "2"], "-", 
    FractionBox[
     SubsuperscriptBox["\[Sigma]", "x", "4"], 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]]}], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389701066835224*^9, 3.389701099990224*^9, 
  3.389719070204624*^9, 3.389721261743824*^9, 3.3899925477986*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vv", "=", 
  RowBox[{"GetVariance", "[", "d4", "]"}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389701101641224*^9, 3.389701117868224*^9}}],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Sigma]", "x", "2"], "-", 
  FractionBox[
   SubsuperscriptBox["\[Sigma]", "x", "4"], 
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389701110095224*^9, 3.389701122060224*^9}, 
   3.389719070233624*^9, 3.389721261788824*^9, 3.3899925478876*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"V", "=", 
  RowBox[{
   RowBox[{"GetMeanTrunc", "[", 
    RowBox[{"d3", ",", "x", ",", "\[Omega]", ",", 
     RowBox[{"m", "+", 
      RowBox[{"q", " ", "\[Rho]", " ", "vv"}]}]}], "]"}], "//", 
   "FullSimplify"}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389701046339224*^9, 3.389701056100224*^9}, {
  3.3897011331972237`*^9, 3.3897011339332237`*^9}}],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Mu]", "x"], "-", 
  FractionBox[
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "x", "4"], " ", 
    RowBox[{"\[Phi]", "[", 
     FractionBox[
      RowBox[{"m", "-", 
       SubscriptBox["\[Mu]", "x"], "+", 
       FractionBox[
        RowBox[{"q", " ", "\[Rho]", " ", 
         SubsuperscriptBox["\[Sigma]", "x", "2"], " ", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]]}], 
      SqrtBox[
       FractionBox[
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "x", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
           SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "+", 
           RowBox[{
            SuperscriptBox["\[Rho]", "2"], " ", 
            SubsuperscriptBox["\[Sigma]", "n", "2"], " ", 
            SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "4"]}]}], ")"}]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
           SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}], "2"]]]],
      "]"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}], " ", 
    SqrtBox[
     FractionBox[
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "x", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "+", 
         RowBox[{
          SuperscriptBox["\[Rho]", "2"], " ", 
          SubsuperscriptBox["\[Sigma]", "n", "2"], " ", 
          SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "4"]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}], "2"]]], 
    " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"\[CapitalPhi]", "[", 
       FractionBox[
        RowBox[{"m", "-", 
         SubscriptBox["\[Mu]", "x"], "+", 
         FractionBox[
          RowBox[{"q", " ", "\[Rho]", " ", 
           SubsuperscriptBox["\[Sigma]", "x", "2"], " ", 
           SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], 
          RowBox[{
           SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
           SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]]}], 
        SqrtBox[
         FractionBox[
          RowBox[{
           SubsuperscriptBox["\[Sigma]", "x", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
             SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "+", 
             RowBox[{
              SuperscriptBox["\[Rho]", "2"], " ", 
              SubsuperscriptBox["\[Sigma]", "n", "2"], " ", 
              SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "4"]}]}], ")"}]}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
             SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}], 
           "2"]]]], "]"}]}], ")"}]}]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896319064622*^9, 3.389701052254224*^9, 
  3.3897011345392237`*^9, 3.389719073041624*^9, 3.389721264244824*^9, 
  3.3899925539006*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Check: Compare above with Glosten (1994) top of p. 1141.", \
"Subsubsection"],

Cell[TextData[{
 "Verif",
 "y",
 " that under the ",
 Cell[BoxData["GlostenNormalizations"]],
 ", the argument of ",
 Cell[BoxData["\[Phi]"]],
 " reduces to ",
 Cell[BoxData[
  RowBox[{"m", "+", "q"}]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Phi]Arg", "=", 
  RowBox[{"First", "[", 
   RowBox[{"Cases", "[", 
    RowBox[{"V", ",", 
     RowBox[{
      RowBox[{"\[Phi]", "[", "a_", "]"}], "\[Rule]", "a"}], ",", 
     "\[Infinity]"}], "]"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 FractionBox[
  RowBox[{"m", "-", 
   SubscriptBox["\[Mu]", "x"], "+", 
   FractionBox[
    RowBox[{"q", " ", "\[Rho]", " ", 
     SubsuperscriptBox["\[Sigma]", "x", "2"], " ", 
     SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], 
    RowBox[{
     SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
     SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]]}], 
  SqrtBox[
   FractionBox[
    RowBox[{
     SubsuperscriptBox["\[Sigma]", "x", "4"], " ", 
     RowBox[{"(", 
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "+", 
       RowBox[{
        SuperscriptBox["\[Rho]", "2"], " ", 
        SubsuperscriptBox["\[Sigma]", "n", "2"], " ", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "4"]}]}], ")"}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}], 
     "2"]]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896319065442*^9, 3.389719073122624*^9, 
  3.389721264319824*^9, 3.3899925540816*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"Append", "[", 
      RowBox[{"GlostenNormalizations", ",", 
       RowBox[{"k", "\[Equal]", "\[Phi]Arg"}]}], "]"}], ",", "k", ",", 
     SubscriptBox["\[Sigma]", "n"]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"m", ">", "0"}], ",", 
     RowBox[{"q", ">", "0"}]}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"k", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "m"}], "-", "q"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", "\[Rule]", 
     RowBox[{"m", "+", "q"}]}], "}"}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896319067202*^9, 3.3897190732906237`*^9, 
  3.3897212644718237`*^9, 3.3899925544046*^9}]
}, Open  ]],

Cell[TextData[{
 "Verif",
 "y",
 " that under the ",
 Cell[BoxData["GlostenNormalizations"]],
 ", the coefficient of ",
 Cell[BoxData[
  RowBox[{"\[Phi]", "/", 
   RowBox[{"(", 
    RowBox[{"1", "-", "\[CapitalPhi]"}], ")"}]}]]],
 " reduces to ",
 Cell[BoxData[
  RowBox[{"1", "-", "\[Alpha]"}]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"factor", "=", 
  RowBox[{
   RowBox[{"V", "/.", 
    RowBox[{
     RowBox[{"\[Phi]", "[", "_", "]"}], "\[Rule]", "1"}]}], "/.", 
   RowBox[{
    RowBox[{"\[CapitalPhi]", "[", "_", "]"}], "\[Rule]", "0"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Mu]", "x"], "+", 
  FractionBox[
   SubsuperscriptBox["\[Sigma]", "x", "4"], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}], " ", 
    SqrtBox[
     FractionBox[
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "x", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "+", 
         RowBox[{
          SuperscriptBox["\[Rho]", "2"], " ", 
          SubsuperscriptBox["\[Sigma]", "n", "2"], " ", 
          SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "4"]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}], 
       "2"]]]}]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896319067882*^9, 3.3897190733566236`*^9, 
  3.389721264516824*^9, 3.3899925545256*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"Append", "[", 
      RowBox[{"GlostenNormalizations", ",", 
       RowBox[{"k", "\[Equal]", "factor"}]}], "]"}], ",", "k", ",", 
     SubscriptBox["\[Sigma]", "n"]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", "<", "\[Alpha]", "<", "1"}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"k", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Alpha]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", "\[Rule]", 
     RowBox[{"1", "-", "\[Alpha]"}]}], "}"}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896319069432*^9, 3.389719073530624*^9, 
  3.389721264638824*^9, 3.3899925547925997`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numerical examples with common parameters", "Subsubsection"],

Cell["Does competitive solution exist?", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"0", "<", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Rho]", "2"], " ", 
     SubsuperscriptBox["\[Sigma]", "n", "2"], " ", 
     SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "-", 
    RowBox[{"(", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "x", "2"], "+", 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}]}], "/.", 
  "CommonParams"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData["True"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896319070112*^9, 3.389719073594624*^9, 
  3.389721264694824*^9, 3.3899925548996*^9}]
}, Open  ]],

Cell["\<\
In the discriminating limit order book, the price is equal to the upper-tail \
expectation:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"equ", "=", 
  RowBox[{"p", "\[Equal]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"V", "/.", "CommonParams"}], "/.", 
      RowBox[{"m", "\[Rule]", "p"}]}], "/.", 
     SubscriptBox["Normal", "Rules"]}], ")"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"p", "\[Equal]", 
  RowBox[{"5", "-", 
   FractionBox[
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "3"]}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "5"}], "+", "p", "+", 
         FractionBox["q", "2"]}], ")"}], "2"]}]], 
    RowBox[{"2", " ", 
     SqrtBox[
      RowBox[{"3", " ", "\[Pi]"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"Erf", "[", 
           FractionBox[
            RowBox[{
             RowBox[{"-", "5"}], "+", "p", "+", 
             FractionBox["q", "2"]}], 
            SqrtBox["3"]], "]"}]}], ")"}]}]}], ")"}]}]]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896319070802*^9, 3.389719073645624*^9, 
  3.389721264736824*^9, 3.3899925550025997`*^9}]
}, Open  ]],

Cell[TextData[{
 "For example, at ",
 Cell[BoxData[
  RowBox[{"q", "=", "8"}]]],
 ", the price is:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"equ", "/.", 
    RowBox[{"q", "\[Rule]", "8"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"p", "\[Rule]", "7.114363121985387`"}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896319072372*^9, 3.3897190737576237`*^9, 
  3.389721264782824*^9, 3.3899925551286*^9}]
}, Open  ]],

Cell[TextData[{
 "By solving this for a number of ",
 Cell[BoxData["q"]],
 " and interpolating, we may approximate the supply curve."
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["P", "Discrim"], "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"q", ",", 
        RowBox[{"p", "/.", 
         RowBox[{"FindRoot", "[", 
          RowBox[{"equ", ",", 
           RowBox[{"{", 
            RowBox[{"p", ",", "1"}], "}"}], ",", 
           RowBox[{"AccuracyGoal", "\[Rule]", "6"}]}], "]"}]}]}], "}"}], ",", 
      
      RowBox[{"{", 
       RowBox[{"q", ",", "0", ",", "8", ",", ".05"}], "}"}]}], "]"}], "]"}]}],
   ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "Plot the supply curve along with ",
 Cell[BoxData[
  RowBox[{"E", "[", 
   RowBox[{
    RowBox[{"X", "|", "\[Omega]"}], "=", 
    RowBox[{"m", "+", 
     RowBox[{"q", " ", "\[Rho]", " ", 
      SubsuperscriptBox["\[Sigma]", 
       RowBox[{"X", "|", "S"}], "2"]}]}]}], "]"}]]],
 ", i.e., when the incoming quantity just executes the order."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"V", "/.", 
      RowBox[{"m", "\[Rule]", 
       RowBox[{
        SubscriptBox["P", "Discrim"], "[", "q", "]"}]}]}], "/.", 
     "CommonParams"}], "/.", 
    SubscriptBox["Normal", "Rules"]}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "1", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "5.585874989039134`", ",", "5.773463037880655`", ",", "5.976984954988216`", 
   ",", "6.191995730891982`", ",", "6.415218832119814`", ",", 
   "6.644343256581427`"}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896319076052*^9, 3.389719074102624*^9, 
  3.389721265112824*^9, 3.3899925558726*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["P", "Discrim"], "[", "q", "]"}], "/.", "CommonParams"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "1", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "5.585874989039134`", ",", "5.773463037880654`", ",", "5.976984954988216`", 
   ",", "6.191995730891972`", ",", "6.41521883211979`", ",", 
   "6.644343256579484`"}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896319076452*^9, 3.3897190741446238`*^9, 
  3.389721265146824*^9, 3.3899925559646*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["P", "Discrim"], "[", "q", "]"}], ",", 
       RowBox[{
        RowBox[{"\[ScriptCapitalE]Point", "[", "m", "]"}], "/.", 
        "\[InvisibleSpace]", 
        RowBox[{"m", "\[Rule]", 
         RowBox[{
          SubscriptBox["P", "Discrim"], "[", "q", "]"}]}]}]}], "}"}], "/.", 
     "\[InvisibleSpace]", "CommonParams"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "0", ",", "8"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5"}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "9"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4.9", ",", "7.5"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<Quantity purchased, q \>\"", ",", "\"\<Price and E[X]\>\"", ",", 
      "None", ",", "None"}], "}"}]}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", "10", ",", "1"}], "]"}], ",", 
      RowBox[{"Range", "[", 
       RowBox[{"5", ",", "8", ",", "1"}], "]"}], ",", "None", ",", "None"}], 
     "}"}]}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", 
   RowBox[{"BaseStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896319339512*^9, 3.3896320204231997`*^9}, 
   3.389721414690824*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVyns0lHkcx3EGjVLDmJ7nmed5ZswK21osRy3Vpue7smkVChUbaivsaHWR
pNa10EV0WTGbLGLPltuMS+UkIbNKK5IUu5iaZifhuFSTXIb99cfnvM/rnI/5
rv0+ISwdHR0vtE/1CBnoaHiTssbo59rLLWUY6K+lDijIPcyW/icBtuUYLMuT
XKkioxjWikGLc8gbHj2vzCWTmQAWr8dPisG2PRN1F8lMZlBidf+FDIM++5Nr
08kipnWGVzFVhUE+5p16hqxmQkmm0uk2BkmGVUtPk3ImOgSj25sx8A8okI6N
P2W2x8+vlyoxMJpLCnQ3UzARMbK6EC0GVptHBprSVEzQplevHfk4HGlbyUje
v2HImN86Rr7Ggajm9uvqjjI9LxPM3H1wuKlc29q++i0TqSppzD2Iw73wXDpg
+D3zZM1o8vR5HDSfuxiXRUwwnmwft4ZyHFiTJSa01RTjFj5y+Vw7Dk5zO2/6
ls8w+13UNsUjOLQmL29r/nKOsfiuwC1zEQGi80OT10d0wFpVwFy0J2BoQtHf
5cCCoPfh2TJvAooGax9yMvSAltaFDEUSwBH+OapS6YOAGv2ovkTAWfGN0HzL
eeD9h/ls700CPkCJ6qcENrQVzrul+YeAKEd5Nd5kCK2/djZrZghQlMvTOswX
QC7PRGa2hA/T4U9zrI8ZwWfj7V4D6/hg8y17NrR2IRj7vev9RcwH96vmYRUE
B06zi2Wrz/HhiHDHkpeBxhBHDDfXVPLBdniL0XNPEzipNiRquvjAMx4zlE+Z
AFVwJH5gmg/69TlSiytcyJefCrkrImHv8tqe+RtMYeYliFvWkVDy/a78ux9M
Ie5FxqR3BAmaIcpEncUDyaU7XuILJNzwddfLdFsMilXpT2/XkJCwPiWvWr0Y
wrKIzkt9JJj3eXQXpmBQVHO6vEeXglXOyZmkIw4Jetbx/tYUBJq1T+p24uBw
omLcx4sCzcN05YEkAiJshV+lRVMg0Q+O8rHkQ+wD7bjzFQp4/TeusuR88OLN
Nrk2UmAQl+S38iAJsd1j19PfUKBzPViqNKWg2ld72NWYhsjL0nTTexSU8lcX
rVxBQ53NKUPuPhpSSr84lraTBq5HpO1xjgAexEumXFJp6LV73Hn0jgCKO5y6
lktpkP3OWKqCheBSSTWe7KIhSOrEFc4KYdvbMMJ2mobElIKk3mIz+C+PfRG3
FEDZgDCHs1EEDsXDVls9BLCZy1lxf0oElmJOVt8hAZwxYNG9yBa7TTKUyPJJ
jXYMOTPPNPU1spOyr4maFkGzgogeR6aqyrz3Ie+Is9pqECUApZ9nGDYjAsLO
E7dDjpKczdqtFYFuYFtWLHLZ2cSjMcg/FHZnJCGrE6MC07Wf/q9SU5H9xYFL
biHfZU9Gn0d2WWVbvmBWBNU9S7cVIc/r/fuvCmT16AWiFZl5XH+tGXl7UL5x
B3KMvCrtX2SHRVL2M+TB0pzNBnMieLvs0YQCuS1ub58/8vPchd3vkNmROxoi
kJ3NhI8/IkOob+Fx5Hcv7B5okSu9vhGXIsfabaphHxbAkKv9xkbk9bd+lC1E
tnS2sH+GvP/EoWtc5GAbwnQIeexCSj6OnC0y0swhtyizJTTy/xf8JpA=
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwVy3s0lHkcx/FxHZc1mfHM5ZmLMUKncFRbKivPd2lNlBQqNo22XJJVkbam
XWUcLDFWsZrSRXJaclsMzlJGmdK6xbKbPZlRdrKikDODUbG//eNz3uf1x0dw
+ERQlCGJRNqF9n/9o8b7296kex3zi9no8xMGxj7skyN4JLF0Sxb0DPnzW7Lr
9XgSQb6adOpAHgY7ep7X3cDTCOXlNW2nLmGwP3L+wWW8gFBnSNJL8zFQuf3o
I8VLiRBJosJUhkExPTDjIi4n1m7F3/UUYyAxq1+VhSuJTGtPekwdBqFht2tm
3g8STa6pDxVDGFguS8KFtiOE/VDGp46PGDjumRpvz9YQjjHfNwXa0eFM7xZC
pn1DkMhuHTQhHZhyqtrAYJqQl5+OTYyjQ+OoT/czz1nC2+5+Pi2fDo+O3eCE
vdUSlNKuUZdmOuictq6oip8nfss9Ot+vpoOhvsKa47hIfLdQUd5iygD35UON
wdUfCS5/7KWTCwO60zb0PlmzTHgJe+T63Qzg503qy6dIEPVORGBiBkzOj6j/
XGsIvLuWJiU3GVA60dJJyTWCt1LxwXMdDKDwfpnWaIyhUzcb3TDNgJzYhuhi
B1PIuzdN3k9nwhxUaI5eIIPxD9a7v/JiQtJ6pZzRbgb2L/f150cyYaRamd0v
sIAnir2m63KZ8OHYYNHqc5agM7ri6dTEBOcvyUvRLZ/B08Z+dYKKCcISQUwt
kwIiR6dqKzILzvAi7F+FrwCt1tnkgysLXN7utXweYA1Zfpey3ENYYLNixky5
aA050sWU9mQWGCuKalZep8KhV1zFtVIWxG1o+dt8Bw2az0d0KHtZUOF3uLh1
jgYJlRPxHgss0E2yrccKbWDYaIqrtcWhIVhoVLANg/G55usGfjhc2J5+Sz6G
gdTmpuXukzgIVP5Dd9LpEH3YQ/1PIQ4em9IK8PUMEFmI47vbcAi3faY3GGDA
6QOZge//xUHXKR09KWHCgkn3SByNDTJjUVKQAwu8pyiRdh5ssFE3lBgqWcDb
97SW8Q0bTJIlIVsScCCpohKOZLOBVC6qGUU/6mbN1bE6NiReq5HSHrFh7rap
vk3FhgfOmWbU4xwQFIqXX5A5QPVPdEmlcGEme+brNW4cGHbtGxDf50JmgMXP
fWEc+PUm4aAR8WCdc2tRmYQDB2vcqbwlHhgc37extYwDKem3JcP3bOGV3XZf
lwEOVI3ziig7+TC0YXX/74sc2EOlbO5Y5MOUIzm6zZELF00MOcPIAWfWZj1G
Vup1n2aQ/1CHVXYiu4+q2tkf+OA/Uzk7iMyurwo8jqznhlx4gzwaEhBD/8gH
1xt3ZTQnLiTJcgqPfOIDtjm8KxK5KidFfBb5dUDmVCzyWEpSuBR5SCynnkAO
jQ23b0K2x6xCxchbPVyqLZb44Buk0EiRTYe7Htcil2hXLTUiE32KsifI57/d
K7iPfFZZn/0CWbyYuu0h8kRl0R6TZT70hKovdiH3JsepQpEnbAuZL5HJiRFt
8citQqXHa2SIDr6TilybMXtwArlu1xexlcjvfQNLtciT3m47HyJ7PU3u0CM7
bFrp9hfyvYjKiSVkkTOTNom80eqFlfEqLlzhW+qWkYf7zNeZI/8HQ0Aa/w==

     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 5},
  Background->GrayLevel[1],
  BaseStyle->{FontFamily -> "Times"},
  Frame->True,
  FrameLabel->{
    FormBox["\"Quantity purchased, q \"", TraditionalForm], 
    FormBox["\"Price and E[X]\"", TraditionalForm], None, None},
  FrameTicks->{{{0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}, {4, 
      FormBox["4", TraditionalForm]}, {5, 
      FormBox["5", TraditionalForm]}, {6, 
      FormBox["6", TraditionalForm]}, {7, 
      FormBox["7", TraditionalForm]}, {8, 
      FormBox["8", TraditionalForm]}, {9, 
      FormBox["9", TraditionalForm]}, {10, 
      FormBox["10", TraditionalForm]}}, {{5, 
      FormBox["5", TraditionalForm]}, {6, 
      FormBox["6", TraditionalForm]}, {7, 
      FormBox["7", TraditionalForm]}, {8, 
      FormBox["8", TraditionalForm]}}, None, None},
  PlotRange->{{0, 9}, {4.9, 7.5}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896319946991997`*^9, 3.3896320208352003`*^9}, 
   3.389719074208624*^9, 3.389721265826824*^9, 3.389721415668824*^9, 
   3.3899925560856*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->None,
WindowSize->{1578, 1027},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Visible->True,
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
ShowSelection->True,
InputAliases->{"intt" -> RowBox[{"\[Integral]", 
     RowBox[{"\[SelectionPlaceholder]", 
       RowBox[{"\[DifferentialD]", "\[Placeholder]"}]}]}], "dintt" -> 
  RowBox[{
     SubsuperscriptBox[
     "\[Integral]", "\[SelectionPlaceholder]", "\[Placeholder]"], 
     RowBox[{"\[Placeholder]", 
       RowBox[{"\[DifferentialD]", "\[Placeholder]"}]}]}], "sumt" -> RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"\[SelectionPlaceholder]", "=", "\[Placeholder]"}], 
      "\[Placeholder]"], "\[Placeholder]"}], "prodt" -> RowBox[{
     UnderoverscriptBox["\[Product]", 
      RowBox[{"\[SelectionPlaceholder]", "=", "\[Placeholder]"}], 
      "\[Placeholder]"], "\[Placeholder]"}], "dt" -> RowBox[{
     SubscriptBox["\[PartialD]", "\[Placeholder]"], " ", 
     "\[SelectionPlaceholder]"}], "ZZ" -> "\[ScriptCapitalZ]", "zz" -> 
  "\[ScriptZ]", "notation" -> RowBox[{"Notation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], " ", 
       "\[DoubleLongLeftRightArrow]", " ", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "notation>" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], " ", 
       "\[DoubleLongRightArrow]", " ", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "notation<" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], " ", 
       "\[DoubleLongLeftArrow]", " ", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "symb" -> 
  RowBox[{"Symbolize", "[", 
     TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], "]"}], 
  "infixnotation" -> RowBox[{"InfixNotation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], ",", 
       "\[Placeholder]"}], "]"}], "addia" -> RowBox[{"AddInputAlias", "[", 
     RowBox[{"\"\[SelectionPlaceholder]\"", "\[Rule]", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "pattwraper" -> 
  TagBox["\[SelectionPlaceholder]", "NotationPatternTag"], "madeboxeswraper" -> 
  TagBox["\[SelectionPlaceholder]", "NotationMadeBoxesTag"], "E" -> 
  "\[ScriptCapitalE]"},
Magnification->1.5,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->"EMMStyle02.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 893, 25, 430, "Title"],
Cell[CellGroupData[{
Cell[1508, 52, 410, 9, 43, "Input"],
Cell[1921, 63, 724, 16, 51, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2682, 84, 32, 0, 92, "Section"],
Cell[2717, 86, 375, 10, 43, "Input"],
Cell[3095, 98, 99, 3, 43, "Input"],
Cell[3197, 103, 147, 3, 43, "Input"],
Cell[3347, 108, 111, 3, 32, "Text"],
Cell[3461, 113, 404, 13, 43, "Input"],
Cell[3868, 128, 127, 3, 32, "Text"],
Cell[3998, 133, 213, 6, 43, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4248, 144, 55, 0, 92, "Section"],
Cell[CellGroupData[{
Cell[4328, 148, 55, 0, 65, "Subsection"],
Cell[4386, 150, 260, 8, 33, "Text"],
Cell[4649, 160, 1342, 37, 148, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6028, 202, 63, 0, 65, "Subsection"],
Cell[6094, 204, 605, 21, 57, "Text"],
Cell[6702, 227, 1199, 32, 273, "Input"],
Cell[7904, 261, 158, 8, 33, "Text"],
Cell[CellGroupData[{
Cell[8087, 273, 752, 23, 48, "Input"],
Cell[8842, 298, 2514, 74, 67, "Output"]
}, Open  ]],
Cell[11371, 375, 233, 10, 33, "Text"],
Cell[CellGroupData[{
Cell[11629, 389, 248, 6, 43, "Input"],
Cell[11880, 397, 785, 24, 114, "Output"]
}, Open  ]],
Cell[12680, 424, 659, 19, 98, "Input"],
Cell[CellGroupData[{
Cell[13364, 447, 246, 7, 43, "Input"],
Cell[13613, 456, 231, 5, 73, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13881, 466, 283, 9, 43, "Input"],
Cell[14167, 477, 209, 3, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14413, 485, 588, 19, 43, "Input"],
Cell[15004, 506, 202, 3, 38, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15267, 516, 55, 0, 92, "Section"],
Cell[CellGroupData[{
Cell[15347, 520, 40, 0, 65, "Subsection"],
Cell[15390, 522, 106, 3, 32, "Text"],
Cell[CellGroupData[{
Cell[15521, 529, 744, 22, 56, "Input"],
Cell[16268, 553, 391, 10, 53, "Output"]
}, Open  ]],
Cell[16674, 566, 265, 9, 33, "Text"],
Cell[CellGroupData[{
Cell[16964, 579, 476, 16, 48, "Input"],
Cell[17443, 597, 492, 14, 56, "Output"]
}, Open  ]],
Cell[17950, 614, 210, 7, 33, "Text"],
Cell[18163, 623, 45, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[18233, 627, 337, 12, 46, "Input"],
Cell[18573, 641, 510, 14, 38, "Output"]
}, Open  ]],
Cell[19098, 658, 110, 4, 33, "Text"],
Cell[CellGroupData[{
Cell[19233, 666, 338, 11, 43, "Input"],
Cell[19574, 679, 359, 9, 38, "Output"]
}, Open  ]],
Cell[19948, 691, 164, 8, 33, "Text"],
Cell[CellGroupData[{
Cell[20137, 703, 235, 6, 43, "Input"],
Cell[20375, 711, 314, 6, 38, "Output"]
}, Open  ]],
Cell[20704, 720, 240, 9, 33, "Text"],
Cell[CellGroupData[{
Cell[20969, 733, 717, 22, 48, "Input"],
Cell[21689, 757, 2480, 73, 93, "Output"]
}, Open  ]],
Cell[24184, 833, 148, 6, 33, "Text"],
Cell[CellGroupData[{
Cell[24357, 843, 213, 6, 43, "Input"],
Cell[24573, 851, 2705, 79, 93, "Output"]
}, Open  ]],
Cell[27293, 933, 140, 7, 33, "Text"],
Cell[CellGroupData[{
Cell[27458, 944, 208, 6, 43, "Input"],
Cell[27669, 952, 2672, 78, 93, "Output"]
}, Open  ]],
Cell[30356, 1033, 116, 5, 33, "Text"],
Cell[CellGroupData[{
Cell[30497, 1042, 193, 6, 43, "Input"],
Cell[30693, 1050, 975, 28, 67, "Output"]
}, Open  ]],
Cell[31683, 1081, 142, 4, 33, "Text"],
Cell[CellGroupData[{
Cell[31850, 1089, 409, 12, 43, "Input"],
Cell[32262, 1103, 714, 18, 70, "Output"]
}, Open  ]],
Cell[32991, 1124, 20, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[33036, 1128, 298, 9, 43, "Input"],
Cell[33337, 1139, 5342, 143, 181, "Output"]
}, Open  ]],
Cell[38694, 1285, 106, 4, 33, "Text"],
Cell[CellGroupData[{
Cell[38825, 1293, 219, 7, 43, "Input"],
Cell[39047, 1302, 4759, 128, 181, "Output"]
}, Open  ]],
Cell[43821, 1433, 175, 5, 33, "Text"],
Cell[CellGroupData[{
Cell[44021, 1442, 165, 4, 43, "Input"],
Cell[44189, 1448, 1444, 40, 73, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45670, 1493, 139, 6, 45, "Subsubsection"],
Cell[45812, 1501, 163, 6, 33, "Text"],
Cell[45978, 1509, 426, 12, 43, "Input"],
Cell[CellGroupData[{
Cell[46429, 1525, 103, 2, 43, "Input"],
Cell[46535, 1529, 1057, 27, 70, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[47641, 1562, 153, 6, 45, "Subsubsection"],
Cell[47797, 1570, 210, 6, 33, "Text"],
Cell[CellGroupData[{
Cell[48032, 1580, 406, 12, 43, "Input"],
Cell[48441, 1594, 3556, 93, 236, "Output"]
}, Open  ]],
Cell[52012, 1690, 234, 9, 33, "Text"],
Cell[52249, 1701, 222, 6, 43, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52508, 1712, 73, 0, 44, "Subsubsection"],
Cell[52584, 1714, 490, 15, 43, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[53135, 1736, 101, 2, 92, "Section"],
Cell[CellGroupData[{
Cell[53261, 1742, 639, 22, 100, "Input"],
Cell[53903, 1766, 284, 9, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[54224, 1780, 498, 15, 46, "Input"],
Cell[54725, 1797, 1294, 35, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[56056, 1837, 722, 21, 46, "Input"],
Cell[56781, 1860, 1740, 47, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[58558, 1912, 274, 9, 43, "Input"],
Cell[58835, 1923, 808, 23, 67, "Output"]
}, Open  ]],
Cell[59658, 1949, 38, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[59721, 1953, 1679, 50, 77, "Input"],
Cell[61403, 2005, 2041, 58, 111, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[63481, 2068, 227, 7, 45, "Input"],
Cell[63711, 2077, 786, 22, 70, "Output"]
}, Open  ]],
Cell[64512, 2102, 138, 5, 33, "Text"],
Cell[CellGroupData[{
Cell[64675, 2111, 1428, 46, 77, "Input"],
Cell[66106, 2159, 594, 15, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[66737, 2179, 214, 7, 45, "Input"],
Cell[66954, 2188, 186, 5, 53, "Output"]
}, Open  ]],
Cell[67155, 2196, 377, 11, 43, "Input"],
Cell[67535, 2209, 293, 9, 43, "Input"],
Cell[CellGroupData[{
Cell[67853, 2222, 1522, 42, 102, "Input"],
Cell[69378, 2266, 3104, 59, 384, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[72531, 2331, 54, 0, 92, "Section"],
Cell[CellGroupData[{
Cell[72610, 2335, 47, 0, 44, "Subsubsection"],
Cell[CellGroupData[{
Cell[72682, 2339, 269, 8, 43, "Input"],
Cell[72954, 2349, 461, 12, 67, "Output"]
}, Open  ]],
Cell[73430, 2364, 501, 22, 38, "Text"],
Cell[CellGroupData[{
Cell[73956, 2390, 830, 24, 78, "Input"],
Cell[74789, 2416, 946, 26, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[75772, 2447, 140, 3, 43, "Input"],
Cell[75915, 2452, 1222, 34, 67, "Output"]
}, Open  ]],
Cell[77152, 2489, 48, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[77225, 2493, 363, 11, 43, "Input"],
Cell[77591, 2506, 1213, 32, 53, "Output"]
}, Open  ]],
Cell[78819, 2541, 375, 15, 36, "Text"],
Cell[CellGroupData[{
Cell[79219, 2560, 463, 12, 48, "Input"],
Cell[79685, 2574, 422, 13, 38, "Output"]
}, Open  ]],
Cell[80122, 2590, 373, 13, 33, "Text"],
Cell[CellGroupData[{
Cell[80520, 2607, 433, 11, 43, "Input"],
Cell[80956, 2620, 335, 8, 38, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[81340, 2634, 75, 0, 44, "Subsubsection"],
Cell[CellGroupData[{
Cell[81440, 2638, 122, 2, 43, "Input"],
Cell[81565, 2642, 4733, 128, 181, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[86335, 2775, 220, 5, 43, "Input"],
Cell[86558, 2782, 972, 29, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[87567, 2816, 183, 4, 43, "Input"],
Cell[87753, 2822, 427, 10, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[88217, 2837, 397, 10, 43, "Input"],
Cell[88617, 2849, 3558, 93, 236, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[92224, 2948, 83, 1, 44, "Subsubsection"],
Cell[92310, 2951, 214, 10, 33, "Text"],
Cell[CellGroupData[{
Cell[92549, 2965, 271, 8, 43, "Input"],
Cell[92823, 2975, 1141, 31, 119, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[94001, 3011, 439, 13, 43, "Input"],
Cell[94443, 3026, 396, 12, 38, "Output"]
}, Open  ]],
Cell[94854, 3041, 308, 13, 33, "Text"],
Cell[CellGroupData[{
Cell[95187, 3058, 270, 8, 43, "Input"],
Cell[95460, 3068, 1095, 30, 99, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[96592, 3103, 401, 11, 43, "Input"],
Cell[96996, 3116, 410, 12, 38, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[97455, 3134, 66, 0, 44, "Subsubsection"],
Cell[97524, 3136, 48, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[97597, 3140, 445, 13, 48, "Input"],
Cell[98045, 3155, 166, 3, 38, "Output"]
}, Open  ]],
Cell[98226, 3161, 115, 3, 32, "Text"],
Cell[CellGroupData[{
Cell[98366, 3168, 292, 9, 43, "Input"],
Cell[98661, 3179, 968, 31, 98, "Output"]
}, Open  ]],
Cell[99644, 3213, 111, 5, 33, "Text"],
Cell[CellGroupData[{
Cell[99780, 3222, 219, 7, 43, "Input"],
Cell[100002, 3231, 233, 5, 38, "Output"]
}, Open  ]],
Cell[100250, 3239, 145, 4, 33, "Text"],
Cell[100398, 3245, 596, 19, 43, "Input"],
Cell[100997, 3266, 370, 11, 38, "Text"],
Cell[CellGroupData[{
Cell[101392, 3281, 396, 13, 43, "Input"],
Cell[101791, 3296, 361, 8, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[102189, 3309, 269, 9, 43, "Input"],
Cell[102461, 3320, 362, 8, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[102860, 3333, 1745, 50, 98, "Input"],
Cell[104608, 3385, 13503, 237, 384, 4586, 88, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
