(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     59119,       2004]
NotebookOptionsPosition[     50397,       1739]
NotebookOutlinePosition[     54239,       1839]
CellTagsIndexPosition[     53985,       1830]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "MVNDemo\n",
 StyleBox["Empirical Market Microstructure",
  FontSlant->"Italic"],
 " \n\t(2006, Oxford University Press)\nCompanion ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook\n\nJoel Hasbrouck\n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Copyright", " ", "2007"}], ",", " ", 
    RowBox[{"Joel", " ", 
     RowBox[{"Hasbrouck", ".", " ", "All"}], " ", "rights", " ", 
     RowBox[{"reserved", "."}]}]}], TraditionalForm]],
  FontSize->14,
  FontSlant->"Italic"],
 "\n",
 StyleBox["This notebook documents and demonstrates the use of the MVN \
package to work with multivariate normal distributions.",
  FontSize->14]
}], "Title",
 CellChangeTimes->{{3.3896255910914*^9, 3.3896255932033997`*^9}, {
   3.3897167078988237`*^9, 3.389716768500824*^9}, 3.3897219191158237`*^9, {
   3.3897220399168243`*^9, 3.3897220640418243`*^9}, {3.389735393500024*^9, 
   3.389735431148024*^9}, {3.3907335223926*^9, 3.3907335226956*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Text", "  ", "@", " ", 
  RowBox[{"Style", "[", 
   RowBox[{
    RowBox[{"\"\<Notebook evaluated \>\"", "<>", 
     RowBox[{"DateString", "[", "\"\<DateTime\>\"", "]"}]}], ",", 
    "\"\<Subtitle\>\""}], "]"}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896127180972*^9, 3.3896127205282*^9}, 
   3.389716999411824*^9, {3.3897170351038237`*^9, 3.389717047196824*^9}}],

Cell[BoxData[
 InterpretationBox[Cell[BoxData[
   StyleBox["\<\"Notebook evaluated Monday 4 June 2007 20:12:55\"\>", 
    "Subtitle",
    StripOnInput->False]], "Text", "TR"],
  Text[
   Style["Notebook evaluated Monday 4 June 2007 20:12:55", 
    "Subtitle"]]]], "Output",
 CellMargins->{{18, Inherited}, {Inherited, 0}},
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896127211071997`*^9, {3.3896127536242*^9, 3.3896127555652*^9}, 
   3.3896128616452*^9, 3.389623031447*^9, 3.3896232934164*^9, 
   3.389716955274824*^9, 3.3897170008718243`*^9, {3.3897170377738237`*^9, 
   3.3897170482808237`*^9}, 3.389735230721224*^9, 3.3899894613552*^9, 
   3.3899897610886*^9, 3.3899911755866003`*^9},
 Background->RGBColor[0.866667, 0.733333, 1]]
}, Open  ]],

Cell[TextData[{
 "Documents and demonstrates the use of the MVN package to work with \
multivariate normal distributions. The MVN package defines a multivariate \
normal distribution \"object\" (i.e, a representation for variables that are \
multivariate normal), and various routines to work with them. It is not a \
substitute for the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " package ",
 Cell[BoxData["Statistics`MultinormalDistribution`"]],
 ". The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " package has more extensive facilities for working with density functions, \
distribution functions and related distributions. The MVN package has more \
facilities for analyzing linear combinations, joint and conditional \
densities, and for labeling the results (for purposes of documentation and \
clarity)."
}], "Text",
 ShowCellBracket->True,
 CellChangeTimes->{{3.3895518923504*^9, 3.3895518989434*^9}}],

Cell[CellGroupData[{

Cell["Initializations", "Section",
 CellChangeTimes->{{3.389735448510024*^9, 3.389735458196024*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "SetDirectory", "[", 
   "\"\<c:/Active/Empirical Market Microstructure/Mathematica/Spring \
2007\>\"", "]"}], ";"}]], "Input",
 CellAutoOverwrite->False,
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3881708634346*^9, 3.3881708734596*^9}, {
  3.3881710728336*^9, 3.3881711170716*^9}, {3.389524702079319*^9, 
  3.389524702676319*^9}}],

Cell[BoxData[
 RowBox[{"<<", "MVN.m"}]], "Input",
 ShowCellBracket->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Properties of the multivariate normal distribution:", "Section",
 ShowCellBracket->True],

Cell["\<\
The package implements functionality based on the following relations.\
\>", "Text",
 ShowCellBracket->True],

Cell["Consider a multivariate normal distribution:", "Text",
 ShowCellBracket->True],

Cell[TextData[Cell[BoxData[
 RowBox[{
  RowBox[{
   UnderscriptBox["X", 
    RowBox[{"n", "\[Times]", "1"}]], "=", 
   RowBox[{"(", GridBox[{
      {
       SubscriptBox["X", "1"]},
      {
       SubscriptBox["X", "2"]}
     }], ")"}]}], ";", " ", 
  RowBox[{
   RowBox[{"E", "[", "X", "]"}], "=", 
   RowBox[{"\[Mu]", "=", 
    RowBox[{"(", GridBox[{
       {
        SubscriptBox["\[Mu]", "1"]},
       {
        SubscriptBox["\[Mu]", "2"]}
      }], ")"}]}]}], ";", " ", 
  RowBox[{
   RowBox[{"Var", "[", "X", "]"}], "=", 
   RowBox[{"\[CapitalSigma]", "=", 
    RowBox[{"(", GridBox[{
       {
        SubscriptBox["\[CapitalSigma]", "11"], 
        SubscriptBox["\[CapitalSigma]", "12"]},
       {
        SubscriptBox["\[CapitalSigma]", "21"], 
        SubscriptBox["\[CapitalSigma]", "22"]}
      }], ")"}]}]}]}]]]], "NumberedEquation",
 ShowCellBracket->True],

Cell[TextData[{
 "The partitions here must be consistent, but are otherwise arbitrary. Either \
",
 Cell[BoxData[
  SubscriptBox["X", "1"]]],
 " or ",
 Cell[BoxData[
  SubscriptBox["X", "2"]]],
 " or both may be scalars."
}], "Text",
 ShowCellBracket->True],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"X", "~", "MVN"}], 
   RowBox[{"(", 
    RowBox[{"\[Mu]", ",", "\[CapitalSigma]"}], ")"}]}]]],
 ", then"
}], "Text",
 ShowCellBracket->True],

Cell[TextData[Cell[BoxData[
 RowBox[{
  RowBox[{"E", "[", 
   RowBox[{
    SubscriptBox["X", "1"], "|", 
    SubscriptBox["X", "2"]}], "]"}], "=", 
  RowBox[{
   SubscriptBox["\[Mu]", "1"], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["X", "2"], "-", 
      SubscriptBox["\[Mu]", "2"]}], ")"}], 
    SubsuperscriptBox["\[CapitalSigma]", "22", 
     RowBox[{"-", "1"}]], 
    SubscriptBox["\[CapitalSigma]", "21"]}]}]}]]]], "NumberedEquation",
 ShowCellBracket->True],

Cell[TextData[Cell[BoxData[
 RowBox[{
  RowBox[{"Var", "[", 
   RowBox[{
    SubscriptBox["X", "1"], "|", 
    SubscriptBox["X", "2"]}], "]"}], "=", 
  RowBox[{
   SubscriptBox["\[CapitalSigma]", "11"], "-", 
   RowBox[{
    SubscriptBox["\[CapitalSigma]", "12"], 
    SubsuperscriptBox["\[CapitalSigma]", "22", 
     RowBox[{"-", "1"}]], 
    SubscriptBox["\[CapitalSigma]", "21"]}]}]}]]]], "NumberedEquation",
 ShowCellBracket->True],

Cell[TextData[{
 "Consider a linear transform ",
 Cell[BoxData[
  RowBox[{"Y", "=", 
   RowBox[{"AX", "+", "b"}]}]]],
 ", where ",
 Cell[BoxData["A"]],
 " is a rectangular matrix and ",
 Cell[BoxData["b"]],
 " is a column vector. Then:"
}], "Text",
 ShowCellBracket->True],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"Y", "~", "MVN"}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", "\[Mu]"}], "+", "b"}]}]}]]],
 ", ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["A\[CapitalSigma]A", "\[Prime]"], ")"}]]]
}], "NumberedEquation",
 ShowCellBracket->True],

Cell[CellGroupData[{

Cell["The MVN \"object\"", "Subsubsection",
 ShowCellBracket->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "MVN"}]], "Input"],

Cell[BoxData[
 StyleBox["\<\"MVN[\[Mu],\[CapitalSigma],v] is an object that represents a \
multivariate normal distribution with mean vector \[Mu] and covariance matrix \
\[CapitalSigma]. The third parameter, v, is list of Mathematica expressions \
that correspond to the variables. (Typically they are variable names or \
formulas for the variables.)\"\>", "MSG"]], "Print", "PrintUsage",
 CellChangeTimes->{3.3895511507684*^9},
 CellTags->"Info3389536750-5584075"]
}, Open  ]],

Cell[TextData[{
 "Note: ",
 Cell[BoxData[
  RowBox[{"MVN", "[", ".", "]"}]]],
 " is simply a \"wrapper\" for grouping a mean vector, a covariance matrix \
and a set of variable labels. Among other things, it provides a descriptive \
output. The default display form of an ",
 Cell[BoxData["MVN"]],
 " object is:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MVN", "[", 
  RowBox[{"\[Mu]", ",", "\[CapitalSigma]", ",", "v"}], "]"}]], "Input",
 ShowCellBracket->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox["v",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox["\[Mu]",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox["\[CapitalSigma]",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellChangeTimes->{3.388169676367*^9, 3.3895511508794003`*^9}]
}, Open  ]],

Cell[TextData[{
 "An ",
 Cell[BoxData["MVN"]],
 " can be built by explicitly supplying the vector and matrix arguments:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NewDistribution", "=", 
  RowBox[{"MVN", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["\[Mu]", "1"], ",", 
      SubscriptBox["\[Mu]", "2"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["v", "11"], ",", 
        SubscriptBox["v", "12"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["v", "21"], ",", 
        SubscriptBox["v", "22"]}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["x", "1"], ",", 
      SubscriptBox["x", "2"]}], "}"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["x", "1"]},
        {
         SubscriptBox["x", "2"]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["\[Mu]", "1"]},
        {
         SubscriptBox["\[Mu]", "2"]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["v", "11"], 
        SubscriptBox["v", "12"]},
       {
        SubscriptBox["v", "21"], 
        SubscriptBox["v", "22"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellChangeTimes->{3.388169676459*^9, 3.3895511509184*^9}]
}, Open  ]],

Cell[TextData[{
 "The above statement assigns to ",
 Cell[BoxData["NewDistribution"]],
 " the newly defined ",
 Cell[BoxData["MVN"]],
 " object. ",
 Cell[BoxData["NewDistribution"]],
 " may subsequently be used, displayed or passed as an argument to another \
routine."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData["NewDistribution"], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["x", "1"]},
        {
         SubscriptBox["x", "2"]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["\[Mu]", "1"]},
        {
         SubscriptBox["\[Mu]", "2"]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["v", "11"], 
        SubscriptBox["v", "12"]},
       {
        SubscriptBox["v", "21"], 
        SubscriptBox["v", "22"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellChangeTimes->{3.388169676546*^9, 3.3895511509604*^9}]
}, Open  ]],

Cell[TextData[{
 "If the components of ",
 Cell[BoxData["MVN"]],
 " are vectors and/or matrices of length 1, then they are displayed as \
scalars:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MVN", "[", 
  RowBox[{
   RowBox[{"{", 
    SubscriptBox["\[Mu]", "1"], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", "var1", "}"}], "}"}], ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox["x",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   SubscriptBox["\[Mu]", "1"], ",", "var1", ")"}],
  DisplayForm]], "Output",
 CellChangeTimes->{3.388169676624*^9, 3.3895511509994*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "StandardMVN"}]], "Input"],

Cell[BoxData[
 StyleBox["\<\"StandardMVN[n,x] returns an MVN of order n with zero mean and \
a covariance matrix equal to the identity matrix. The variables are labeled \
\\!\\(\\*SubscriptBox[\\\"x\\\", \
\\\"1\\\"]\\),...,\\!\\(\\*SubscriptBox[\\\"x\\\", \\\"n\\\"]\\). If the \
second argument is omitted, the variables are labeled \
\\!\\(\\*SubscriptBox[\\\"z\\\", \
\\\"1\\\"]\\),...,\\!\\(\\*SubscriptBox[\\\"z\\\", \\\"n\\\"]\\)\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellChangeTimes->{3.3895513691874*^9},
 CellTags->"Info3389536969-3839356"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["d", "1"], "=", 
  RowBox[{"StandardMVN", "[", "1", "]"}]}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox["z",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox["1",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellChangeTimes->{3.3881696771549997`*^9, 3.3895511512734003`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["d", "2"], "=", 
  RowBox[{"StandardMVN", "[", "3", "]"}]}]], "Input",
 ShowCellBracket->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["z", "1"]},
        {
         SubscriptBox["z", "2"]},
        {
         SubscriptBox["z", "3"]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"0"},
        {"0"},
        {"0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellChangeTimes->{3.38816967723*^9, 3.3895511513164*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Get/Set routines (to get the parameters, or to reset them)", \
"Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"GetMean", "[", 
    SubscriptBox["d", "1"], "]"}], ",", " ", 
   RowBox[{
    RowBox[{"GetMean", "[", 
     SubscriptBox["d", "2"], "]"}], "//", "MatrixForm"}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"0"},
        {"0"},
        {"0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 CellChangeTimes->{3.388169677304*^9, 3.3895511513674*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"GetVariance", "[", 
    SubscriptBox["d", "1"], "]"}], ",", " ", 
   RowBox[{
    RowBox[{"GetVariance", "[", 
     SubscriptBox["d", "2"], "]"}], "//", "MatrixForm"}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 CellChangeTimes->{3.3881696773780003`*^9, 3.3895511514114*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"GetLabel", "[", 
    SubscriptBox["d", "1"], "]"}], ",", " ", 
   RowBox[{
    RowBox[{"GetLabel", "[", 
     SubscriptBox["d", "2"], "]"}], "//", "MatrixForm"}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["z", "1"]},
        {
         SubscriptBox["z", "2"]},
        {
         SubscriptBox["z", "3"]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 CellChangeTimes->{3.38816967746*^9, 3.3895511514514*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetMean", "[", 
  RowBox[{
   SubscriptBox["d", "1"], ",", "123"}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox["z",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox["123",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox["1",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellChangeTimes->{3.3881696775369997`*^9, 3.3895511514964*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetMean", "[", 
  RowBox[{
   SubscriptBox["d", "2"], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["z", "1"]},
        {
         SubscriptBox["z", "2"]},
        {
         SubscriptBox["z", "3"]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"1"},
        {"2"},
        {"3"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellChangeTimes->{3.388169677633*^9, 3.3895511515453997`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetVariance", "[", 
  RowBox[{
   SubscriptBox["d", "1"], ",", "56"}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox["z",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox["56",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellChangeTimes->{3.388169677708*^9, 3.3895511515854*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetVariance", "[", 
  RowBox[{
   SubscriptBox["d", "2"], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"61", ",", "1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "100", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "99"}], "}"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["z", "1"]},
        {
         SubscriptBox["z", "2"]},
        {
         SubscriptBox["z", "3"]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"0"},
        {"0"},
        {"0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"61", "1", "2"},
       {"1", "100", "0"},
       {"2", "0", "99"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellChangeTimes->{3.3881696778050003`*^9, 3.3895511516354*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetLabel", "[", 
  RowBox[{
   SubscriptBox["d", "1"], ",", "NewVariable"}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox["NewVariable",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox["1",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellChangeTimes->{3.388169677885*^9, 3.3895511516814003`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetLabel", "[", 
  RowBox[{
   SubscriptBox["d", "2"], ",", 
   RowBox[{"{", 
    RowBox[{"Huey", ",", " ", "Dewey", ",", " ", "Louie"}], "}"}]}], 
  "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"Huey"},
        {"Dewey"},
        {"Louie"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"0"},
        {"0"},
        {"0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellChangeTimes->{3.388169677981*^9, 3.3895511517363997`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Routines to construct new variables", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "LinearForm"}]], "Input"],

Cell[BoxData[
 StyleBox["\<\"LinearForm[mvn1,b,c] (where b is a matrix and c is a vector) \
returns an MVN that describes a linear transformation of mvn1. If mvn1=MVN[\
\[Mu],\[CapitalSigma],v] then the return MVN is the distribution of b.v+c. \
LinearForm[mvn1,b] returns an MVN giving the distribution of b.v\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellChangeTimes->{3.3895511519454*^9},
 CellTags->"Info3389536751-9256129"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearForm2", "[", 
  RowBox[{
   SubscriptBox["d", "1"], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "6", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"LinearForm2", "[", 
  RowBox[{
   TagBox[
    RowBox[{
     TagBox["z",
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]], 
     RowBox[{" ", 
      RowBox[{"~", " "}]}], 
     StyleBox["\[ScriptCapitalN]",
      FontSize->16,
      FontWeight->Bold], "(", 
     TagBox["0",
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]], ",", 
     TagBox["1",
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]], ")"}],
    DisplayForm], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "6", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "}"}]}], "]"}]], "Output",
 CellChangeTimes->{3.388169678531*^9, 3.3895511520643997`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1", ",", "0"}], "}"}]}], "}"}]}], ";", 
  RowBox[{"b", "//", "MatrixForm"}]}]], "Input",
 ShowCellBracket->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "2", "3"},
     {"5", "2", "1"},
     {"4", "1", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.3881696786289997`*^9, 3.3895511521264*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "=", 
  RowBox[{"LinearForm", "[", 
   RowBox[{
    RowBox[{"StandardMVN", "[", "3", "]"}], ",", "b"}], "]"}]}]], "Input",
 ShowCellBracket->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         RowBox[{
          SubscriptBox["z", "1"], "+", 
          RowBox[{"2", " ", 
           SubscriptBox["z", "2"]}], "+", 
          RowBox[{"3", " ", 
           SubscriptBox["z", "3"]}]}]},
        {
         RowBox[{
          RowBox[{"5", " ", 
           SubscriptBox["z", "1"]}], "+", 
          RowBox[{"2", " ", 
           SubscriptBox["z", "2"]}], "+", 
          SubscriptBox["z", "3"]}]},
        {
         RowBox[{
          RowBox[{"4", " ", 
           SubscriptBox["z", "1"]}], "+", 
          SubscriptBox["z", "2"]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"0"},
        {"0"},
        {"0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"14", "12", "6"},
       {"12", "30", "22"},
       {"6", "22", "17"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellChangeTimes->{3.388169678766*^9, 3.3895511521944*^9}]
}, Open  ]],

Cell["Often, after we build new variables, we relabel them:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"b", "=", 
  RowBox[{"SetLabel", "[", 
   RowBox[{"a", ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d", ",", "e"}], "}"}]}], "]"}]}]], "Input",
 ShowCellBracket->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"c"},
        {"d"},
        {"e"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"0"},
        {"0"},
        {"0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"14", "12", "6"},
       {"12", "30", "22"},
       {"6", "22", "17"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellChangeTimes->{3.388169678866*^9, 3.3895511522483997`*^9}]
}, Open  ]],

Cell[TextData[{
 "Sometimes, we'd just like to work with the linear expressions themselves \
(without having to construct the coefficient matrix directly). ",
 Cell[BoxData["MakeLinearForm"]],
 " shows how this works."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "MakeLinearForm"}]], "Input"],

Cell[BoxData[
 StyleBox["\<\"MakeLinearForm[MVN0,b] returns an MVN object representing the \
distribution of a set of linear combinations of the variables in MVN0=MVN[\
\[Mu],\[CapitalSigma],v]. b is a list of expressions defining linear \
combinations of v (and a constant, if desired).\"\>", "MSG"]], "Print", \
"PrintUsage",
 CellChangeTimes->{3.3895511524594*^9},
 CellTags->"Info3389536752-4166500"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MakeLinearForm", "[", 
  RowBox[{
   RowBox[{"MVN", "[", 
    RowBox[{"0", ",", "1", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], "+", "3"}], ",", 
     RowBox[{
      RowBox[{"3", " ", "x"}], " ", "+", " ", "10"}]}], "}"}]}], 
  "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         RowBox[{"3", "+", 
          RowBox[{"2", " ", "x"}]}]},
        {
         RowBox[{"10", "+", 
          RowBox[{"3", " ", "x"}]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"3"},
        {"10"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"4", "6"},
       {"6", "9"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellChangeTimes->{3.388169679424*^9, 3.3895511525874*^9}]
}, Open  ]],

Cell[TextData[{
 "(In the above example, since both new variables are linear functions of ",
 Cell[BoxData["x"]],
 ", the covariance matrix is singular.)"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MakeLinearForm", "[", 
  RowBox[{
   RowBox[{"StandardMVN", "[", "2", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", 
       SubscriptBox["z", "1"]}], "+", "3"}], ",", 
     RowBox[{
      RowBox[{"3", 
       SubscriptBox["z", "1"]}], "+", 
      RowBox[{"2", 
       SubscriptBox["z", "2"]}]}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         RowBox[{"3", "+", 
          RowBox[{"2", " ", 
           SubscriptBox["z", "1"]}]}]},
        {
         RowBox[{
          RowBox[{"3", " ", 
           SubscriptBox["z", "1"]}], "+", 
          RowBox[{"2", " ", 
           SubscriptBox["z", "2"]}]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"3"},
        {"0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"4", "6"},
       {"6", "13"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellChangeTimes->{3.3881696795179996`*^9, 3.3895511526364*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Conditional distributions", "Subsubsection"],

Cell[TextData[{
 "A multivariate normal distribution is usually a joint distribution of all \
the component random variables. One of the most common steps in analysis of \
an economic model involves constructing one or more conditional \
distributions.  ",
 Cell[BoxData["MVNConditional"]],
 " does this easily. You just have to specify the conditioning variables, and \
the target variables."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "MVNConditional"}]], "Input"],

Cell[BoxData[
 StyleBox["\<\"MVNConditional[MVN0,v1,v2] returns an MVN object representing \
a conditional multivariate normal distribution. MVN0=MVN0[\[Mu],\
\[CapitalSigma],v] is the joint distribution. v2 is a list of the \
conditioning variables; v1 is a list of the target variables. Both v1 and v2 \
must map to (correspond to) v. MVNConditional[MVN0,v1] returns the \
conditional distribution of v1 conditioned on all variables that are not in \
v1.\"\>", "MSG"]], "Print", "PrintUsage",
 CellChangeTimes->{3.3895511528224*^9},
 CellTags->"Info3389536752-5302578"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MVNConditional", "[", 
  RowBox[{"b", ",", "c", ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e"}], "}"}]}], "]"}]], "Input",
 ShowCellBracket->True],

Cell[BoxData[
 TagBox[
  RowBox[{"c", 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   RowBox[{
    RowBox[{"12", " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox[
        RowBox[{"17", " ", "d"}], "26"], "-", 
       FractionBox[
        RowBox[{"11", " ", "e"}], "13"]}], ")"}]}], "+", 
    RowBox[{"6", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"11", " ", "d"}], "13"]}], "+", 
       FractionBox[
        RowBox[{"15", " ", "e"}], "13"]}], ")"}]}]}], ",", 
   FractionBox["2", "13"], ")"}],
  DisplayForm]], "Output",
 CellChangeTimes->{3.38816968021*^9, 3.3895511529514*^9}]
}, Open  ]],

Cell["\<\
The conditioning set might be a subset of the remaining variables.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MVNConditional", "[", 
  RowBox[{"b", ",", "c", ",", "d"}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"c", 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   FractionBox[
    RowBox[{"2", " ", "d"}], "5"], ",", 
   FractionBox["46", "5"], ")"}],
  DisplayForm]], "Output",
 CellChangeTimes->{3.388169680278*^9, 3.3895511529854*^9}]
}, Open  ]],

Cell["\<\
If you omit the second argument, the conditioning variables are all the \
remaining variables:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MVNConditional", "[", 
  RowBox[{"b", ",", "c"}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"c", 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   RowBox[{
    RowBox[{"12", " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox[
        RowBox[{"17", " ", "d"}], "26"], "-", 
       FractionBox[
        RowBox[{"11", " ", "e"}], "13"]}], ")"}]}], "+", 
    RowBox[{"6", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"11", " ", "d"}], "13"]}], "+", 
       FractionBox[
        RowBox[{"15", " ", "e"}], "13"]}], ")"}]}]}], ",", 
   FractionBox["2", "13"], ")"}],
  DisplayForm]], "Output",
 CellChangeTimes->{3.388169680349*^9, 3.3895511530294*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
ScreenStyleEnvironment->"Working",
WindowSize->{1578, 1027},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Visible->True,
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
ShowSelection->True,
CellLabelAutoDelete->True,
InputAliases->{"intt" -> RowBox[{"\[Integral]", 
     RowBox[{"\[SelectionPlaceholder]", 
       RowBox[{"\[DifferentialD]", "\[Placeholder]"}]}]}], "dintt" -> 
  RowBox[{
     SubsuperscriptBox[
     "\[Integral]", "\[SelectionPlaceholder]", "\[Placeholder]"], 
     RowBox[{"\[Placeholder]", 
       RowBox[{"\[DifferentialD]", "\[Placeholder]"}]}]}], "sumt" -> RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"\[SelectionPlaceholder]", "=", "\[Placeholder]"}], 
      "\[Placeholder]"], "\[Placeholder]"}], "prodt" -> RowBox[{
     UnderoverscriptBox["\[Product]", 
      RowBox[{"\[SelectionPlaceholder]", "=", "\[Placeholder]"}], 
      "\[Placeholder]"], "\[Placeholder]"}], "dt" -> RowBox[{
     SubscriptBox["\[PartialD]", "\[Placeholder]"], " ", 
     "\[SelectionPlaceholder]"}], "notation" -> RowBox[{"Notation", "[", 
     RowBox[{
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> "NotationTemplateStyle"],
        " ", "\[DoubleLongLeftRightArrow]", " ", 
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> 
        "NotationTemplateStyle"]}], "]"}], "notation>" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> "NotationTemplateStyle"],
        " ", "\[DoubleLongRightArrow]", " ", 
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> 
        "NotationTemplateStyle"]}], "]"}], "notation<" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> "NotationTemplateStyle"],
        " ", "\[DoubleLongLeftArrow]", " ", 
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> 
        "NotationTemplateStyle"]}], "]"}], "symb" -> 
  RowBox[{"Symbolize", "[", 
     TagBox[
     "\[Placeholder]", NotationBoxTag, TagStyle -> "NotationTemplateStyle"], 
     "]"}], "infixnotation" -> RowBox[{"InfixNotation", "[", 
     RowBox[{
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> "NotationTemplateStyle"],
        ",", "\[Placeholder]"}], "]"}], "addia" -> 
  RowBox[{"AddInputAlias", "[", 
     RowBox[{"\"\[Placeholder]\"", "\[Rule]", 
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> 
        "NotationTemplateStyle"]}], "]"}], "pattwraper" -> 
  TagBox["\[Placeholder]", NotationPatternTag, TagStyle -> 
    "NotationPatternWrapperStyle"], "madeboxeswraper" -> 
  TagBox["\[Placeholder]", NotationMadeBoxesTag, TagStyle -> 
    "NotationMadeBoxesWrapperStyle"], "FF" -> "\[ScriptCapitalF]", "EE" -> 
  "\[ScriptCapitalE]"},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->"EMMStyle02.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3389536750-5584075"->{
  Cell[7603, 265, 466, 7, 81, "Print",
   CellTags->"Info3389536750-5584075"]},
 "Info3389536969-3839356"->{
  Cell[15812, 548, 554, 10, 81, "Print",
   CellTags->"Info3389536969-3839356"]},
 "Info3389536751-9256129"->{
  Cell[32505, 1132, 428, 7, 81, "Print",
   CellTags->"Info3389536751-9256129"]},
 "Info3389536752-4166500"->{
  Cell[40713, 1407, 404, 7, 81, "Print",
   CellTags->"Info3389536752-4166500"]},
 "Info3389536752-5302578"->{
  Cell[47287, 1621, 571, 9, 110, "Print",
   CellTags->"Info3389536752-5302578"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3389536750-5584075", 53437, 1812},
 {"Info3389536969-3839356", 53546, 1815},
 {"Info3389536751-9256129", 53657, 1818},
 {"Info3389536752-4166500", 53768, 1821},
 {"Info3389536752-5302578", 53879, 1824}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 965, 25, 430, "Title"],
Cell[CellGroupData[{
Cell[1580, 52, 410, 9, 43, "Input"],
Cell[1993, 63, 742, 16, 51, "Output"]
}, Open  ]],
Cell[2750, 82, 929, 20, 102, "Text"],
Cell[CellGroupData[{
Cell[3704, 106, 100, 1, 92, "Section"],
Cell[3807, 109, 375, 10, 43, "Input"],
Cell[4185, 121, 73, 2, 43, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4295, 128, 94, 1, 92, "Section"],
Cell[4392, 131, 118, 3, 32, "Text"],
Cell[4513, 136, 84, 1, 32, "Text"],
Cell[4600, 139, 869, 31, 48, "NumberedEquation"],
Cell[5472, 172, 257, 10, 33, "Text"],
Cell[5732, 184, 201, 9, 33, "Text"],
Cell[5936, 195, 490, 16, 34, "NumberedEquation"],
Cell[6429, 213, 435, 13, 34, "NumberedEquation"],
Cell[6867, 228, 272, 11, 33, "Text"],
Cell[7142, 241, 295, 12, 34, "NumberedEquation"],
Cell[CellGroupData[{
Cell[7462, 257, 67, 1, 44, "Subsubsection"],
Cell[CellGroupData[{
Cell[7554, 262, 46, 1, 43, "Input"],
Cell[7603, 265, 466, 7, 81, "Print",
 CellTags->"Info3389536750-5584075"]
}, Open  ]],
Cell[8084, 275, 324, 9, 56, "Text"],
Cell[CellGroupData[{
Cell[8433, 288, 131, 3, 43, "Input"],
Cell[8567, 293, 495, 18, 38, "Output"]
}, Open  ]],
Cell[9077, 314, 132, 4, 33, "Text"],
Cell[CellGroupData[{
Cell[9234, 322, 618, 21, 43, "Input"],
Cell[9855, 345, 2368, 72, 53, "Output"]
}, Open  ]],
Cell[12238, 420, 281, 9, 33, "Text"],
Cell[CellGroupData[{
Cell[12544, 433, 41, 0, 43, "Input"],
Cell[12588, 435, 2368, 72, 53, "Output"]
}, Open  ]],
Cell[14971, 510, 159, 5, 33, "Text"],
Cell[CellGroupData[{
Cell[15155, 519, 193, 6, 43, "Input"],
Cell[15351, 527, 367, 13, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15755, 545, 54, 1, 43, "Input"],
Cell[15812, 548, 554, 10, 81, "Print",
 CellTags->"Info3389536969-3839356"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16403, 563, 109, 3, 43, "Input"],
Cell[16515, 568, 482, 18, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17034, 591, 133, 4, 43, "Input"],
Cell[17170, 597, 2278, 70, 73, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19497, 673, 85, 1, 44, "Subsubsection"],
Cell[CellGroupData[{
Cell[19607, 678, 231, 7, 43, "Input"],
Cell[19841, 687, 782, 23, 73, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20660, 715, 239, 7, 43, "Input"],
Cell[20902, 724, 760, 21, 73, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21699, 750, 233, 7, 43, "Input"],
Cell[21935, 759, 868, 26, 73, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22840, 790, 108, 3, 43, "Input"],
Cell[22951, 795, 480, 18, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23468, 818, 165, 5, 43, "Input"],
Cell[23636, 825, 2283, 70, 73, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25956, 900, 111, 3, 43, "Input"],
Cell[26070, 905, 474, 18, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26581, 928, 362, 11, 43, "Input"],
Cell[26946, 941, 2288, 70, 73, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29271, 1016, 117, 3, 43, "Input"],
Cell[29391, 1021, 487, 18, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29915, 1044, 190, 6, 43, "Input"],
Cell[30108, 1052, 2207, 67, 73, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[32364, 1125, 60, 0, 44, "Subsubsection"],
Cell[CellGroupData[{
Cell[32449, 1129, 53, 1, 43, "Input"],
Cell[32505, 1132, 428, 7, 81, "Print",
 CellTags->"Info3389536751-9256129"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32970, 1144, 211, 7, 43, "Input"],
Cell[33184, 1153, 672, 24, 43, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33893, 1182, 377, 12, 43, "Input"],
Cell[34273, 1196, 679, 19, 73, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34989, 1220, 174, 5, 43, "Input"],
Cell[35166, 1227, 2709, 83, 73, "Output"]
}, Open  ]],
Cell[37890, 1313, 69, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[37984, 1317, 193, 6, 43, "Input"],
Cell[38180, 1325, 2203, 67, 73, "Output"]
}, Open  ]],
Cell[40398, 1395, 230, 5, 33, "Text"],
Cell[CellGroupData[{
Cell[40653, 1404, 57, 1, 43, "Input"],
Cell[40713, 1407, 404, 7, 81, "Print",
 CellTags->"Info3389536752-4166500"]
}, Open  ]],
Cell[CellGroupData[{
Cell[41154, 1419, 320, 11, 43, "Input"],
Cell[41477, 1432, 2252, 68, 53, "Output"]
}, Open  ]],
Cell[43744, 1503, 166, 4, 33, "Text"],
Cell[CellGroupData[{
Cell[43935, 1511, 377, 13, 43, "Input"],
Cell[44315, 1526, 2380, 72, 53, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[46744, 1604, 50, 0, 44, "Subsubsection"],
Cell[46797, 1606, 405, 8, 56, "Text"],
Cell[CellGroupData[{
Cell[47227, 1618, 57, 1, 43, "Input"],
Cell[47287, 1621, 571, 9, 110, "Print",
 CellTags->"Info3389536752-5302578"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47895, 1635, 173, 5, 43, "Input"],
Cell[48071, 1642, 725, 26, 56, "Output"]
}, Open  ]],
Cell[48811, 1671, 90, 2, 32, "Text"],
Cell[CellGroupData[{
Cell[48926, 1677, 100, 2, 43, "Input"],
Cell[49029, 1681, 339, 12, 56, "Output"]
}, Open  ]],
Cell[49383, 1696, 118, 3, 32, "Text"],
Cell[CellGroupData[{
Cell[49526, 1703, 90, 2, 55, "Input"],
Cell[49619, 1707, 726, 26, 68, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
