function GibbsSimulate01();

%	Test driver program for Gibbs estimates of Roll Model

close all; clc;
format compact;
disp(' ');
disp(['GibbsSimulate01 starting on ' datestr(now)]);

addpath('.\m Files\');


%	Simulate some data in structure array s: s(i): i=1,...,nSegment
%	Each segment corresponds to a time span with no missing observations.
%	Note an observation with q=0 (corresponding to exact observation of m) is okay.
%	Example with 2 segments:
%		Week1				Week 2			Week 3
%		M	T	W	Th	F	... missing ...	M	T	W	Th	F
%	p	1.00	1.01	0.99	1	1.02					1.40	1.41	1.5	1.6	1.6
%	q	?	?	?	0	?					?	?	0	?	?
%	All q's will be simulated except for Th of week 1 and W of week 2.
%	(q=0 corrresponds to the price equal to a quote midpoint
%	for these days, which CRSP would have originally encoded as negative prices.)
%

nSegment = 2;
nObs = 120;	%	Number of observations per segment
par.c = 0.02;	%	effective cost
par.varu = 0.01^2;	%	random walk variance
randn('state',1234567);	%   Initialize random number generators so that runs can be replicated.
rand ('state',5123456);
s = Simulate03(nSegment, nObs, par);

%	Estimation
%	The prior for c is normal with mean=mu, variance=cov, restricted between lower and upper.
Priors.Coeff.mu = 0;
Priors.Coeff.cov = 1;
Priors.Coeff.lower = 0;
Priors.Coeff.upper = inf;
%	The prior for varu is inverted gamma.
Priors.varu.alpha = 1e-12;
Priors.varu.beta = 1e-12;
Prog.Draw_q = true;	%	make draws of q's (only set to false for debugging)
Prog.nDraw=1000;	%	number of sweeps

GetNewStartingValues = true;	%	If this is set to false, the values of q, c and varu
% 							used for simulation will also be used as starting values. 
% 							This is useful for debugging. In an actual estimation, 
% 							these would not be known.
if GetNewStartingValues
	Display = true;
	RollEst = RollEstimate01(s,Display);
	if ~ isnan(RollEst.HalfSpread); par.c=RollEst.HalfSpread;
	else; par.c=0.1; end
	if ~ isnan(RollEst.Variance); par.varu = RollEst.Variance;
	else; par.varu=0.1; end
	%	initialize q's based on trade price changes
	for i=1:length(s)
		dp = [0 diff(s(i).p)];
		dps = sign(dp);
		jZero = find(s(i).q==0);	%	quote midpoints
		s(i).q = dps;
		s(i).q(jZero) = 0;
	end
end

[Draws, Prog]=Gibbs04(Prog, s, par, Priors);

disp(['Elapsed time: ' num2str(Prog.ElapsedTime) ' seconds  (' ...
	datestr(Prog.ElapsedTime/(24*60*60),13) ').']);

%	Summarize simulated parameter posteriors
%	Note: Gibbs04 actually simulates the standard deviation of u.
GibbsStats(Draws,'c');
GibbsStats(Draws,'sdu');