%****m* MUnit-API/Library
%
% NAME
%   MUnit Library
%
% DESCRIPTION
%   The MUnit library is a collection of functions to be used implement test
%   cases and test suites, assert tests, and compile and print test results.
%   The functions in the MUnit library are intended to be use in creating and
%   executing test via the test case and test suite framework and are not
%   indeeded to be called directly from the command line.  Functions in the
%   MUnit library are prefixed by MU_.
%
%   Functions within the MUnit library are categorized as follows:
%     lib.assert      -- Assert functions to compare of actual test results to expected values.
%     lib.tcase       -- Functions for implementing a test case.
%     lib.tsuite      -- Functions for implementing a test suite.
%     lib.report      -- Functions for creating and printing test results and test case/suite summaries.
%
% TOOLBOX
%    munit/munit
%
% CATEGORY
%
%
%***
%****m* Library/lib.assert
%
% NAME
%   lib.assert -- MUnit Library assert functions.
%
% DESCRIPTION
%   Functions in MUnit library used to assert the comparison of actual test 
%   results to expected values.
%***
%****m* Library/lib.tcase
%
% NAME
%   lib.tcase -- MUnit Library tcase functions.
%
% DESCRIPTION
%   Functions in MUnit library used to create, run, summarize and report a test
%   case:
%
%
%***
%****m* Library/lib.tsuite
%
% NAME
%   lib.tsuite -- MUnit Library tsuite functions.
%
% DESCRIPTION
%   Functions in MUnit library used to create, run, summarize and report a test suite.
%***
%****m* Library/lib.report
%
% NAME
%   lib.tresult -- MUnit Library reporting functions.
%
% DESCRIPTION
%   Functions in MUnit library used for creating and print test results and
%   tcase/tsuite summaries.
%***
%****m* Library/lib.utils
%
% NAME
%   lib.utils -- MUnit Library utils functions.
%
% DESCRIPTION
%   Functions in MUnit library used for various utility purposes.
%***

% AUTHOR
%   Charlie Cornish
%
% CREATION DATE
%
%
% COPYRIGHT
%
%
% CREDITS
%
%
% REVISION
%   $Revision: 84 $
%

%   $Id: MUnit_Library.m 84 2005-02-15 01:03:48Z ccornish $
