(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    266431,       7375]
NotebookOptionsPosition[    255806,       7050]
NotebookOutlinePosition[    257237,       7101]
CellTagsIndexPosition[    257107,       7094]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Price discovery in high resolution: \[LineSeparator]computational \
appendix", "Title",
 CellChangeTimes->{{3.7382275364209504`*^9, 3.738227633811231*^9}, {
   3.7498302510339584`*^9, 3.7498302808841352`*^9}, 3.749830361617121*^9, {
   3.7498472894762473`*^9, 3.749847303828884*^9}, {3.7499110693112106`*^9, 
   3.7499110751795177`*^9}}],

Cell["\<\
Joel Hasbrouck*
October 1, 2018\
\>", "Subtitle",
 CellChangeTimes->{{3.7382275364209504`*^9, 3.738227633811231*^9}, {
   3.7498302510339584`*^9, 3.7498302808841352`*^9}, 3.749830361617121*^9, 
   3.7498472960097675`*^9}],

Cell["\<\
*Department of Finance\[LineSeparator]Stern School of Business, NYU\
\[LineSeparator]44 West 4th St.\[LineSeparator]New York, NY 10012\
\[LineSeparator]jhasbrou@stern.nyu.edu\
\>", "Text",
 CellChangeTimes->{
  3.749835208664838*^9, {3.749835412549594*^9, 3.749835427498613*^9}},
 TextJustification->0.],

Cell[CellGroupData[{

Cell["Abstract", "Subtitle",
 CellChangeTimes->{{3.7498304320656705`*^9, 3.7498304336793375`*^9}}],

Cell["\<\
Estimating and forecasting long-lag high-resolution multivariate time series \
models pose computational challenges. This appendix describes several \
techniques used in the paper. Most are based on standard polynomial \
distributed lag (PDL) and sparse matrix methods.  I discuss these in simple \
univariate and bivariate settings, along with extensions relevant to the \
problem at hand. \
\>", "Text",
 CellChangeTimes->{{3.738227642305127*^9, 3.738227753794758*^9}, {
  3.738309181596681*^9, 3.738309310745578*^9}, {3.738572363718932*^9, 
  3.738572601163126*^9}, {3.738582962266144*^9, 3.738583227195177*^9}, {
  3.7498301243150063`*^9, 3.7498302460512896`*^9}, {3.7498304718552065`*^9, 
  3.7498304745440545`*^9}, {3.7498381630747128`*^9, 3.749838191417743*^9}, {
  3.749842221726248*^9, 3.749842243579793*^9}, {3.749855727802844*^9, 
  3.749855737574619*^9}, {3.7498850467334294`*^9, 3.749885066975277*^9}}],

Cell["\<\
This document includes Mathematica code at the end. The Matlab software uses \
additional conventions and will be described in a separate document. There \
are two versions of this appendix: a pdf document (with a 'pdf' extension) \
and a Mathematica notebook (with an 'nb' extension). The latter is executable \
in Mathematica.\
\>", "Text",
 CellChangeTimes->{{3.738227642305127*^9, 3.738227753794758*^9}, {
  3.738309181596681*^9, 3.738309310745578*^9}, {3.738572363718932*^9, 
  3.738572601163126*^9}, {3.738582962266144*^9, 3.738583227195177*^9}, {
  3.7498301243150063`*^9, 3.7498302460512896`*^9}, {3.7498304718552065`*^9, 
  3.7498304745440545`*^9}, {3.7498381630747128`*^9, 3.749838191417743*^9}, {
  3.749842221726248*^9, 3.749842243579793*^9}, {3.749855727802844*^9, 
  3.749855737574619*^9}, {3.7498850587971563`*^9, 3.7498850609174843`*^9}}],

Cell[CellGroupData[{

Cell["A review of polynomial distributed lags (PDLs)", "Section",
 CellChangeTimes->{{3.7382277875585318`*^9, 3.738227866761877*^9}, {
  3.738415518356564*^9, 3.7384155291925693`*^9}}],

Cell[TextData[{
 "For bivariate time series ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "t"], ",", 
     SubscriptBox["y", "t"]}], "}"}], TraditionalForm]]],
 ", consider a standard linear lagged regression model:"
}], "Text",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQA2IQ7W56doHUrdeOWb0vD4FotrZpp0D04WPvwfQVEdXz
INpPopJHGki7fxeQBtEpZ5uUQPS6iGc6IDpePdwIRMuYSViCaA87CSsQLd1s
5QmiF1jnx4HobQLLkkC0mSSE7vodvFgWSJ84MH0FiK4MbVsLoqccKdkEojPP
SG4H0S/4u2+A6Gup6ndB9MtTkx6B6Mh7R14i0wwTNrwF0RcOu74H0ctVTT+D
6Or73apyQNru0ixtED2JZa8eiL5wSdwTRDf8uuILog+lbgoG0cfmyIWC6A/s
2lkg2uF3fCmITmYpqwfRDOzS00F0ymHZ1YdA4bdk/hoQ3SDCeuwykF7iawGm
AQaeuCw=
  "]],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["y", "t"], "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["\[Beta]", "1"], 
       SubscriptBox["x", 
        RowBox[{"t", "-", "1"}]]}], "+", 
      RowBox[{
       SubscriptBox["\[Beta]", "2"], 
       SubscriptBox["x", 
        RowBox[{"t", "-", "2"}]]}], "+"}], "..."}], "+", 
    RowBox[{
     SubscriptBox["\[Beta]", "\[ScriptCapitalL]"], 
     SubscriptBox["x", 
      RowBox[{"t", "-", "\[ScriptCapitalL]"}]]}], "+", 
    SubscriptBox["e", "t"]}]}], TraditionalForm]], "EquationNumbered",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGCQAGIQ7W56doHUrdeOWb0vD4FotrZpp0D04WPvwfQVEdXz
INpPopJHGki7fxeQBtEpZ5uUQPS6iGc6IDpePdwIRMuYSViCaA87CSsQLd1s
5QmiF1jnx4HobQLLkkC0mSSE7vodvFgWSJ84MH0FiK4MbVsLoqccKdkEojPP
SG4H0S/4u2+A6Gup6ndB9MtTkx6B6Mh7R14i0wwTNrwF0RcOu74H0ctVTT+D
6Or73apyQNru0ixtED2JZa8eiL5wSdwTRDf8uuILog+lbgoG0cfmyIWC6A/s
2lkg2uF3fCmITmYpqwerv1M6A0TzTMh/CaKXKk4F04d9wp7KA2m5vULPQPSZ
Y+z1HkC6KcOrCUyvf74QRLMdUVoCogFHick8
  "]],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "t"], "=", 
    SubscriptBox["y", "t"]}], TraditionalForm]]],
 " this is an autoregression. The data sample is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "t"], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["y", "t"], ":", "t"}], "=", "1"}], ",", "...", ",", 
     "\[ScriptCapitalT]"}], "}"}], TraditionalForm]]],
 ". The values can be arranged for estimation as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{
     RowBox[{"X", "\[VeryThinSpace]", "\[Beta]"}], "+", "e"}]}], 
   TraditionalForm]]],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{"(", 
     RowBox[{GridBox[{
        {
         SubscriptBox["y", "1"], 
         RowBox[{
          SubscriptBox["y", "2"], ",", "..."}], 
         RowBox[{
          SubscriptBox["y", "\[ScriptCapitalT]"], ")"}]}
       }], "\[Transpose]"}]}]}], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox["e", TraditionalForm]]],
 " is a ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[ScriptCapitalT]", "\[Times]", "1"}], TraditionalForm]]],
 " vector of errors, and ",
 Cell[BoxData[
  FormBox["X", TraditionalForm]]],
 " is the lagged data matrix, that is a ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[ScriptCapitalT]", "\[Times]", "\[ScriptCapitalL]"}], 
   TraditionalForm]]],
 " matrix of the lagged xs:"
}], "Text",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGCQAGIQ7W56doHUrdeOWb0vD4FotrZpp0D04WPvwfQVEdXz
INpPopJHGki7fxeQBtEpZ5uUQPS6iGc6IDpePdwIRMuYSViCaA87CSsQLd1s
5QmiF1jnx4HobQLLkkC0mSSE7vodvFgWSJ84MH0FiK4MbVsLoqccKdkEojPP
SG4H0S/4u2+A6Gup6ndB9MtTkx6B6Mh7R14i0wwTNrwF0RcOu74H0ctVTT+D
6Or73apyQNru0ixtED2JZa8eiL5wSdwTRDf8uuILog+lbgoG0cfmyIWC6A/s
2lkg2uF3fCmITmYpqwfRGbNuzgXRDMvPbfEA0keYH4DpNVtkzMqAdGDDcjD9
P2Tu2kNA2sSZayuInpe8/vBlIJ12bfEREA0AkfvMuA==
  "]],

Cell[BoxData[
 FormBox[
  RowBox[{"X", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       SubscriptBox["x", "0"], 
       SubscriptBox["x", 
        RowBox[{"-", "1"}]], 
       SubscriptBox["x", 
        RowBox[{"-", "2"}]], "\[CenterEllipsis]", 
       SubscriptBox["x", 
        RowBox[{
         RowBox[{"-", "\[ScriptCapitalL]"}], "+", "1"}]]},
      {
       SubscriptBox["x", "1"], 
       SubscriptBox["x", "0"], 
       SubscriptBox["x", 
        RowBox[{"-", "1"}]], "\[Ellipsis]", 
       SubscriptBox["x", 
        RowBox[{"-", "\[ScriptCapitalL]"}]]},
      {" ", "\[VerticalEllipsis]", " ", " ", " "},
      {
       SubscriptBox["x", "t"], 
       SubscriptBox["x", 
        RowBox[{"t", "-", "1"}]], 
       SubscriptBox["x", 
        RowBox[{"t", "-", "2"}]], "\[CenterEllipsis]", 
       SubscriptBox["x", 
        RowBox[{"t", "-", "\[ScriptCapitalL]", "+", "1"}]]},
      {" ", "\[VerticalEllipsis]", " ", " ", " "},
      {
       SubscriptBox["x", 
        RowBox[{"\[ScriptCapitalT]", "-", "1"}]], 
       SubscriptBox["x", 
        RowBox[{"\[ScriptCapitalT]", "-", "1"}]], 
       SubscriptBox["x", 
        RowBox[{"\[ScriptCapitalT]", "-", "1"}]], "\[CenterEllipsis]", 
       SubscriptBox["x", 
        RowBox[{"\[ScriptCapitalT]", "-", "\[ScriptCapitalL]", "+", "1"}]]}
     }], "\[NoBreak]", ")"}]}], TraditionalForm]], "Equation",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQB2IQ7W56doHUrdeOWb0vD4FotrZpp0D04WPvwfQVEdXz
INpPopJHGki7fxeQBtEpZ5uUQPS6iGc6IDpePdwIRMuYSViCaA87CSsQLd1s
5QmiF1jnx4HobQLLkkC0mSSE7vodvFgWSJ84MH0FiK4MbVsLoqccKdkEojPP
SG4H0S/4u2+A6Gup6ndB9MtTkx6B6Mh7R14i0wwTNrwF0RcOu74H0ctVTT+D
6Or73apyQNru0ixtED2JZa8eiL5wSdwTRDf8uuILog+lbgoG0cfmyIWC6A/s
2lkg2uF3fCmITmYpqwfRSRVWi0C0wqzYEg8g7bMIQk95N6UKRC9pnAqmLx19
ll0GpNOyOXNBNADX9cC/
  "]],

Cell[TextData[{
 "Here, values of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "t"], TraditionalForm]]],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "<", "1"}], TraditionalForm]]],
 " can be handled in various ways. If ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"E", "\[VeryThinSpace]", "x"}], "=", "0"}], TraditionalForm]]],
 " we can set the pre-sample values to zero. Alternatively, we can discard \
rows that contain any pre-sample values; ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]]],
 " is adjusted to be conformable. The OLS estimates of ",
 Cell[BoxData[
  FormBox["\[Beta]", TraditionalForm]]],
 " are ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["\[Beta]", "^"], "=", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"X", "\[Transpose]"}], "X"}], ")"}], 
      RowBox[{"-", "1"}]], 
     RowBox[{"X", "\[Transpose]"}], "y"}]}], TraditionalForm]]],
 ".\nIn the autoregressive case, ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]]],
 " may be forecast subsequent to an initial disturbance ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["e", "0"], TraditionalForm]]],
 " by recursion. The forecasts, denoted ",
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox["y", "t", "*"], TraditionalForm]]],
 ", are:"
}], "Text",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGCQAmIQ7W56doHUrdeOWb0vD4FotrZpp0D04WPvwfQVEdXz
INpPopJHGki7fxeQBtEpZ5uUQPS6iGc6IDpePdwIRMuYSViCaA87CSsQLd1s
5QmiF1jnx4HobQLLkkC0mSSE7vodvFgWSJ84MH0FiK4MbVsLoqccKdkEojPP
SG4H0S/4u2+A6Gup6ndB9MtTkx6B6Mh7R14i0wwTNrwF0RcOu74H0ctVTT+D
6Or73apyQNru0ixtED2JZa8eiL5wSdwTRDf8uuILog+lbgoG0cfmyIWC6A/s
2lkg2uF3fCmITmYpqwfru16wCEQXWR04JA8Kh33LjoPoI8dPHPQA0qvOQ2iN
gvQ9AUBa+/2NfSB6y6ypFmVAOsM+3hpEvzny/0AFkN7uwnYIRD9fe+H/m7ev
HZt4dRjeAmkA70LhHQ==
  "]],

Cell[BoxData[
 FormBox[
  RowBox[{"\t\t\t", 
   RowBox[{
    RowBox[{
     SubsuperscriptBox["y", "1", "*"], "\[AlignmentMarker]", "=", 
     SubscriptBox["e", "0"]}], "\[LineSeparator]", 
    RowBox[{
     SubsuperscriptBox["y", "2", "*"], "\[AlignmentMarker]", "=", 
     RowBox[{
      SubscriptBox["\[Beta]", "1"], 
      SubsuperscriptBox["y", "1", "*"]}]}], "\[IndentingNewLine]", 
    RowBox[{
     SubsuperscriptBox["y", 
      RowBox[{"3", " "}], "*"], "\[AlignmentMarker]", "=", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[Beta]", "1"], 
       SubsuperscriptBox["y", "2", "*"]}], "+", 
      RowBox[{
       SubscriptBox["\[Beta]", "2"], 
       SubsuperscriptBox["y", "1", "*"]}]}]}], "\[IndentingNewLine]", 
    "\[VerticalEllipsis]", "\[IndentingNewLine]", 
    RowBox[{
     SubsuperscriptBox["y", "t", "*"], "\[AlignmentMarker]", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         SubscriptBox["\[Beta]", "1"], 
         SubsuperscriptBox["y", 
          RowBox[{"t", "-", "1"}], "*"]}], "+", 
        RowBox[{
         SubscriptBox["\[Beta]", "2"], 
         SubsuperscriptBox["y", 
          RowBox[{"t", "-", "2"}], "*"]}], "+"}], "..."}], "+", 
      RowBox[{
       SubscriptBox["\[Beta]", "\[ScriptCapitalL]"], 
       SubsuperscriptBox["y", 
        RowBox[{"t", "-", "\[ScriptCapitalL]"}], "*"]}]}]}]}]}], 
  TraditionalForm]], "EquationNumbered",
 CellChangeTimes->{{3.738238616327938*^9, 3.7382387458081436`*^9}, {
   3.738238781193356*^9, 3.7382387840051346`*^9}, {3.7383222817591515`*^9, 
   3.738322282744519*^9}, {3.738323348879408*^9, 3.7383233488864236`*^9}, {
   3.738323572894546*^9, 3.7383236387515235`*^9}, 3.7383248210578184`*^9, {
   3.738338814741947*^9, 3.7383388990369606`*^9}, {3.738347334835335*^9, 
   3.738347335855759*^9}},
 TextAlignment->AlignmentMarker,
 CellTags->"forecast"],

Cell[TextData[{
 "This is the same as the lagged regression model, but since we are \
forecasting, we are recursively calculating the system assuming that all \
disturbances, except ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["e", "0"], TraditionalForm]]],
 ", are zero."
}], "Text",
 CellChangeTimes->{{3.73823885115351*^9, 3.7382389524194565`*^9}}],

Cell[TextData[{
 "In the present applications, both the sample size \[ScriptCapitalT] and the \
number of parameters ",
 Cell[BoxData[
  FormBox["\[ScriptCapitalL]", TraditionalForm]]],
 " are large: ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[ScriptCapitalT]", "\[TildeTilde]", 
    SuperscriptBox["10", "9"]}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[ScriptCapitalL]", "\[TildeTilde]", 
    SuperscriptBox["10", "6"]}], TraditionalForm]]],
 ". This makes direct estimation and forecasting difficult at best and \
infeasible at worst. The following material describes how use of polynomials \
and sparsity can help."
}], "Text",
 CellChangeTimes->{{3.7382361894313474`*^9, 3.7382362734338923`*^9}, {
   3.7382364013383985`*^9, 3.7382364675933795`*^9}, 3.7382366049073277`*^9, {
   3.73823664829661*^9, 3.7382367286525745`*^9}, {3.738236767014456*^9, 
   3.7382370601186104`*^9}, {3.7382371176342554`*^9, 
   3.7382372138712797`*^9}, {3.738237338256327*^9, 3.7382373889403305`*^9}, {
   3.7383389385005026`*^9, 3.73833894465505*^9}, {3.7384206160548067`*^9, 
   3.7384206978132744`*^9}, {3.73857226088281*^9, 3.7385722998526225`*^9}, {
   3.7385723333839936`*^9, 3.7385723442170234`*^9}, {3.7486204200942736`*^9, 
   3.748620528410817*^9}}],

Cell[TextData[{
 "The first device we employ is due to Almon (1965), who suggests \
constraining the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Beta]", "i"], TraditionalForm]]],
 " to lie on polynomials in ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]]],
 ". In the quadratic case, for example, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Beta]", "i"], "=", 
    RowBox[{
     SubscriptBox["\[Gamma]", "0"], "+", 
     RowBox[{
      SubscriptBox["\[Gamma]", "1"], "i"}], "+", 
     RowBox[{
      SubscriptBox["\[Gamma]", "2"], 
      SuperscriptBox["i", "2"]}]}]}], TraditionalForm]]],
 ". In matrix notation, this can be expressed as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Beta]", "=", 
    RowBox[{"D", "\[VeryThinSpace]", "\[Gamma]"}]}], TraditionalForm]]],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Gamma]", "=", 
    RowBox[{"(", GridBox[{
       {
        SubscriptBox["\[Gamma]", "0"], 
        SubscriptBox["\[Gamma]", "1"], 
        RowBox[{
         RowBox[{
          SubscriptBox["\[Gamma]", "2"], ")"}], "\[Transpose]"}]}
      }]}]}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox["D", TraditionalForm]]],
 " is the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"\[ScriptCapitalL]", "\[Times]", "3"}], ")"}], TraditionalForm]]],
 "  design matrix:"
}], "Text",
 CellChangeTimes->{{3.7382361894313474`*^9, 3.7382362734338923`*^9}, {
   3.7382364013383985`*^9, 3.7382364675933795`*^9}, 3.7382366049073277`*^9, {
   3.73823664829661*^9, 3.7382367286525745`*^9}, {3.738236767014456*^9, 
   3.7382370601186104`*^9}, {3.7382371176342554`*^9, 
   3.7382372138712797`*^9}, {3.738237338256327*^9, 3.7382373889403305`*^9}, {
   3.7383389385005026`*^9, 3.73833894465505*^9}, {3.7384206160548067`*^9, 
   3.7384206978132744`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"D", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1", "1", "1"},
      {"1", "2", "4"},
      {"1", "3", "9"},
      {" ", "\[VerticalEllipsis]", " "},
      {"1", "\[ScriptCapitalL]", 
       SuperscriptBox["\[ScriptCapitalL]", "2"]}
     }], "\[NoBreak]", ")"}]}], TraditionalForm]], "EquationNumbered",
 CellChangeTimes->{{3.7382372203343287`*^9, 3.7382373229682837`*^9}, {
  3.7383223786332393`*^9, 3.7383223942315097`*^9}, {3.7383389285839977`*^9, 
  3.7383389301587605`*^9}, {3.738347342766006*^9, 3.738347342766006*^9}}],

Cell["Substituting into the regression equation gives", "Text",
 CellChangeTimes->{{3.7382375059816694`*^9, 3.738237671386837*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"y", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"X", "\[VeryThinSpace]", "\[Beta]"}], "+", "e"}], "=", 
    RowBox[{
     RowBox[{"X", "\[VeryThinSpace]", "D", "\[VeryThinSpace]", "\[Gamma]"}], 
     "+", "e"}]}]}], TraditionalForm]], "Equation",
 CellChangeTimes->{{3.7382376811121783`*^9, 3.73823770948965*^9}, {
  3.7383473594853373`*^9, 3.7383473594853373`*^9}}],

Cell[TextData[{
 "The first term on the right hand side can be grouped as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"X", "(", 
    RowBox[{"D", "\[VeryThinSpace]", "\[Gamma]"}], ")"}], TraditionalForm]]],
 ", which suggests a smoothing of the model parameters (the \[Beta] \
coefficients). Grouping as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"X", "\[VeryThinSpace]", "D"}], ")"}], "\[Gamma]"}], 
   TraditionalForm]]],
 " suggests a transformation or smoothing of the data. This distinction, \
though, is purely a matter of perspective. The mathematics are the same. "
}], "Text",
 CellChangeTimes->{{3.7384166168818717`*^9, 3.7384169377630577`*^9}, {
  3.7384169703050365`*^9, 3.7384169767288556`*^9}}],

Cell[TextData[{
 "A PDL can greatly reduce the dimensionality of the estimation. The \
transformed data matrix, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"X", "\[VeryThinSpace]", "D"}], TraditionalForm]]],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[ScriptCapitalT]", "\[Times]", "3"}], TraditionalForm]]],
 ", and the ",
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]]],
 " may be estimated directly as"
}], "Text",
 CellChangeTimes->{{3.7382377215228243`*^9, 3.7382378761248355`*^9}, {
  3.738417024559987*^9, 3.7384170486894817`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   OverscriptBox["\[Gamma]", "^"], "=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"D", "\[Transpose]"}], 
       RowBox[{"X", "\[Transpose]"}], "X", "\[VeryThinSpace]", "D"}], ")"}], 
     RowBox[{"-", "1"}]], 
    RowBox[{"D", "\[Transpose]"}], 
    RowBox[{"X", "\[Transpose]"}], "y"}]}], 
  TraditionalForm]], "EquationNumbered",
 CellChangeTimes->{{3.7383097411804867`*^9, 3.7383097825189743`*^9}}],

Cell[TextData[{
 "This effectively reduces the size of the cross-product matrix: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"X", "\[Transpose]"}], "X"}], TraditionalForm]]],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[ScriptCapitalL]", "\[Times]", "\[ScriptCapitalL]"}], 
   TraditionalForm]]],
 ", but ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"D", "\[Transpose]"}], 
    RowBox[{"X", "\[Transpose]"}], "X", "\[VeryThinSpace]", "D"}], 
   TraditionalForm]]],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"3", "\[Times]", "3"}], TraditionalForm]]],
 ". "
}], "Text",
 CellChangeTimes->{{3.7382380327165966`*^9, 3.7382381962740326`*^9}, 
   3.7382382845574856`*^9, {3.73834308795516*^9, 3.7383431000254946`*^9}}],

Cell[TextData[{
 "PDLs can also simplify the forecasting computations. Direct application of \
(",
 
 CounterBox["EquationNumbered", "forecast"],
 ") requires ",
 Cell[BoxData[
  FormBox["\[ScriptCapitalL]", TraditionalForm]]],
 " multiplications and ",
 Cell[BoxData[
  FormBox["\[ScriptCapitalL]", TraditionalForm]]],
 " additions at each step. Using the PDL representation for the coefficients,"
}], "Text",
 CellChangeTimes->{{3.738238300119446*^9, 3.738238386886244*^9}, {
  3.7382384226728334`*^9, 3.7382384358912787`*^9}, {3.738238983311084*^9, 
  3.738239006037755*^9}, {3.7382390560896063`*^9, 3.738239096078776*^9}, {
  3.738239132452649*^9, 3.7382391412303605`*^9}, {3.738417075727285*^9, 
  3.7384170794263115`*^9}, {3.7498567640966024`*^9, 3.749856765115877*^9}, {
  3.749857111585595*^9, 3.74985711835349*^9}}],

Cell[BoxData[{
 FormBox[
  RowBox[{
   SubscriptBox["y", "t"], "\[AlignmentMarker]", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[Gamma]", "0"], "+", 
       SubscriptBox["\[Gamma]", "1"], "+", 
       SubscriptBox["\[Gamma]", "2"]}], ")"}], 
     SubscriptBox["y", 
      RowBox[{"t", "-", "1"}]]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[Gamma]", "0"], "+", 
       RowBox[{"2", 
        SubscriptBox["\[Gamma]", "1"]}], "+", 
       RowBox[{"4", 
        SubscriptBox["\[Gamma]", "2"]}]}], ")"}], 
     SubscriptBox["y", 
      RowBox[{"t", "-", "2"}]]}], "+", "\[CenterEllipsis]", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[Gamma]", "0"], "+", 
       SubscriptBox["\[ScriptCapitalL]\[Gamma]", "1"], "+", 
       RowBox[{
        SuperscriptBox["\[ScriptCapitalL]", "2"], 
        SubscriptBox["\[Gamma]", "2"]}]}], ")"}], 
     SubscriptBox["y", 
      RowBox[{"t", "-", "\[ScriptCapitalL]"}]]}]}]}], 
  TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{"\[AlignmentMarker]", 
   RowBox[{"=", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Gamma]", "0"], "(", 
      RowBox[{
       SubscriptBox["y", 
        RowBox[{"t", "-", "1"}]], "+", 
       SubscriptBox["y", 
        RowBox[{"t", "-", "2"}]], "+", 
       SubscriptBox["y", 
        RowBox[{"t", "-", "3"}]], "+", "\[CenterEllipsis]", "+", 
       SubscriptBox["y", 
        RowBox[{"t", "-", "\[ScriptCapitalL]"}]]}], ")"}], "+", 
     RowBox[{
      SubscriptBox["\[Gamma]", "1"], "(", 
      RowBox[{
       SubscriptBox["y", 
        RowBox[{"t", "-", "1"}]], "+", 
       RowBox[{"2", 
        SubscriptBox["y", 
         RowBox[{"t", "-", "2"}]]}], "+", 
       RowBox[{"3", 
        SubscriptBox["y", 
         RowBox[{"t", "-", "3"}]]}], "+", "\[CenterEllipsis]", "+", 
       SubscriptBox["\[ScriptCapitalL]y", 
        RowBox[{"t", "-", "\[ScriptCapitalL]"}]]}], ")"}], "+", 
     RowBox[{
      SubscriptBox["\[Gamma]", "2"], "(", 
      RowBox[{
       SubscriptBox["y", 
        RowBox[{"t", "-", "1"}]], "+", 
       RowBox[{"4", 
        SubscriptBox["y", 
         RowBox[{"t", "-", "2"}]]}], "+", 
       RowBox[{"9", 
        SubscriptBox["y", 
         RowBox[{"t", "-", "3"}]]}], "+", "\[CenterEllipsis]", "+", 
       RowBox[{
        SuperscriptBox["\[ScriptCapitalL]", "2"], 
        SubscriptBox["y", 
         RowBox[{"t", "-", "\[ScriptCapitalL]"}]]}]}], ")"}]}]}]}], 
  TraditionalForm]}], "EquationNumbered",
 CellChangeTimes->{{3.7382384396372547`*^9, 3.73823845412217*^9}, {
  3.73823915889192*^9, 3.7382394689752197`*^9}, {3.7382395135791693`*^9, 
  3.738239581364567*^9}, {3.7383390998750896`*^9, 3.738339127801399*^9}},
 TextAlignment->AlignmentMarker],

Cell["\<\
Now define three state variables that will carry the quantities in the \
parentheses:\
\>", "Text",
 CellChangeTimes->{{3.7382396429947257`*^9, 3.73823970566348*^9}, {
  3.7383390860749493`*^9, 3.7383390876078677`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"S", "(", 
     RowBox[{"t", ",", "d"}], ")"}], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"i", "=", "1"}], "\[ScriptCapitalL]"], 
     RowBox[{
      SuperscriptBox["i", "d"], 
      SubscriptBox["y", 
       RowBox[{"t", "-", "i"}]]}]}]}], ",", " ", 
   RowBox[{
    RowBox[{"for", " ", "d"}], "=", "0"}], ",", "1", ",", "2"}], 
  TraditionalForm]], "Equation",
 CellChangeTimes->{{3.7382397238872986`*^9, 3.738239736841549*^9}, {
  3.73824000891308*^9, 3.7382400315759544`*^9}, {3.7382401299978576`*^9, 
  3.738240214173337*^9}, {3.738339203171912*^9, 3.7383392067553325`*^9}}],

Cell[TextData[{
 "To update ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"S", "(", 
     RowBox[{"t", ",", "d"}], ")"}], "\[Rule]", 
    RowBox[{"S", "(", 
     RowBox[{
      RowBox[{"t", "+", "1"}], ",", "d"}], ")"}]}], TraditionalForm]]],
 ", we first compute ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["y", "t"], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"d", "=", "0"}], "2"], 
     RowBox[{
      SubscriptBox["\[Gamma]", "d"], 
      RowBox[{"S", "(", 
       RowBox[{"t", ",", "d"}], ")"}]}]}]}], TraditionalForm]]],
 ". Then to take ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"S", "(", 
     RowBox[{"t", ",", "0"}], ")"}], "\[Rule]", 
    RowBox[{"S", "(", 
     RowBox[{
      RowBox[{"t", "+", "1"}], ",", "0"}], ")"}]}], TraditionalForm]]],
 ", note that ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["y", 
    RowBox[{"t", "-", "\[ScriptCapitalL]"}]], TraditionalForm]]],
 " leaves the sum and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["y", "t"], TraditionalForm]]],
 " enters:"
}], "Text",
 CellChangeTimes->{{3.738240264647519*^9, 3.7382404192228317`*^9}, {
  3.738240812721128*^9, 3.73824089019361*^9}, {3.7382409815938845`*^9, 
  3.7382410564956374`*^9}, {3.738341910652829*^9, 3.738341915227683*^9}, {
  3.7383422496304955`*^9, 3.7383422722860565`*^9}, {3.7384171425914516`*^9, 
  3.7384172098885717`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"\t\t\t", 
   RowBox[{
    RowBox[{"S", "(", 
     RowBox[{
      RowBox[{"t", "+", "1"}], ",", "0"}], ")"}], "=", 
    RowBox[{
     RowBox[{"S", "(", 
      RowBox[{"t", ",", "0"}], ")"}], "+", 
     SubscriptBox["y", "t"], "-", 
     SubscriptBox["y", 
      RowBox[{"t", "-", "\[ScriptCapitalL]"}]]}]}]}], 
  TraditionalForm]], "EquationNumbered",
 CellChangeTimes->{{3.7382410614464307`*^9, 3.7382410681965337`*^9}, {
  3.7382411516886883`*^9, 3.7382411914880095`*^9}, {3.7382413712192216`*^9, 
  3.7382413744489117`*^9}, {3.738338991108822*^9, 3.7383389911128483`*^9}, {
  3.7383419206530952`*^9, 3.738341922166051*^9}, {3.7383422768932743`*^9, 
  3.7383422791391535`*^9}, {3.7386759820125694`*^9, 3.7386759831275597`*^9}},
 TextAlignment->Left],

Cell["\<\
Similarly, by direct examination of the leaving and entering terms for higher \
orders:\
\>", "Text",
 CellChangeTimes->{{3.7382413894183383`*^9, 3.7382414205420637`*^9}, {
   3.7382456097284994`*^9, 3.738245618692545*^9}, {3.738339056530015*^9, 
   3.738339073660138*^9}, 3.738342294301702*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{"\t\t\t", 
   RowBox[{
    RowBox[{
     RowBox[{"S", "(", 
      RowBox[{
       RowBox[{"t", "+", "1"}], ",", "1"}], ")"}], "\[AlignmentMarker]", "=", 
     RowBox[{
      RowBox[{"S", "(", 
       RowBox[{"t", ",", "1"}], ")"}], "+", 
      RowBox[{"S", "(", 
       RowBox[{
        RowBox[{"t", "+", "1"}], ",", "0"}], ")"}], "-", 
      RowBox[{"\[ScriptCapitalL]", "\[VeryThinSpace]", 
       SubscriptBox["y", 
        RowBox[{"t", "-", "\[ScriptCapitalL]"}]]}]}]}], "\[IndentingNewLine]", 
    RowBox[{"=", 
     RowBox[{
      RowBox[{"S", "(", 
       RowBox[{"t", ",", "1"}], ")"}], "+", 
      RowBox[{"S", "(", 
       RowBox[{"t", ",", "0"}], ")"}], "+", 
      SubscriptBox["y", "t"], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\[ScriptCapitalL]", "+", "1"}], ")"}], 
       SubscriptBox["y", 
        RowBox[{"t", "-", "\[ScriptCapitalL]"}]]}]}]}], "\[LineSeparator]", 
    RowBox[{
     RowBox[{"S", "(", 
      RowBox[{
       RowBox[{"t", "+", "1"}], ",", "2"}], ")"}], "\[AlignmentMarker]", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"S", "(", 
        RowBox[{"t", ",", "2"}], ")"}], "+", 
       RowBox[{"2", 
        RowBox[{"S", "(", 
         RowBox[{
          RowBox[{"t", "+", "1"}], ",", "1"}], ")"}]}], "-", 
       RowBox[{"S", "(", 
        RowBox[{
         RowBox[{"t", "+", "1"}], ",", "0"}], ")"}], "-", 
       RowBox[{
        SuperscriptBox["\[ScriptCapitalL]", "2"], 
        SubscriptBox["y", 
         RowBox[{"t", "-", "\[ScriptCapitalL]"}]]}]}], "\[LineSeparator]", 
      "\[AlignmentMarker]", "=", 
      RowBox[{
       RowBox[{"S", "(", 
        RowBox[{"t", ",", "2"}], ")"}], "+", 
       RowBox[{"2", 
        RowBox[{"S", "(", 
         RowBox[{"t", ",", "1"}], ")"}]}], "+", 
       RowBox[{"S", "(", 
        RowBox[{"t", ",", "0"}], ")"}], "+", 
       SubscriptBox["y", "t"], "-", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", "\[ScriptCapitalL]"}], ")"}], "2"], 
        SubscriptBox["y", 
         RowBox[{"t", "-", "\[ScriptCapitalL]"}]]}]}]}]}]}]}], 
  TraditionalForm]], "EquationNumbered",
 CellChangeTimes->{{3.738241428627984*^9, 3.738241438228286*^9}, {
  3.738244925795091*^9, 3.7382450400541306`*^9}, {3.7382451136251793`*^9, 
  3.7382451483661222`*^9}, {3.738245245226117*^9, 3.7382454041264043`*^9}, {
  3.738338997160643*^9, 3.738339033553356*^9}, {3.7383419485096273`*^9, 
  3.738341972730917*^9}, {3.738342359773552*^9, 3.738342361819502*^9}, {
  3.738342402164548*^9, 3.7383424629271*^9}, {3.7386670042480626`*^9, 
  3.7386671193373375`*^9}, {3.7386671698314104`*^9, 3.7386672282611303`*^9}, {
  3.738667259483615*^9, 3.738667260006242*^9}},
 TextAlignment->AlignmentMarker],

Cell[TextData[{
 "It is still necessary to store all lagged values ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["y", "t"], ",", "...", ",", " ", 
    SubscriptBox["y", 
     RowBox[{"t", "-", "\[ScriptCapitalL]"}]]}], TraditionalForm]]],
 ", but the update calculations are more efficient. (In the Matlab code, see \
the ",
 StyleBox["stateUpdate", "Input"],
 " method in the ",
 StyleBox["polynom", "Input"],
 " class.)"
}], "Text",
 CellChangeTimes->{{3.7382456419021225`*^9, 3.738245759141017*^9}, {
  3.738248768534054*^9, 3.738248775440673*^9}, {3.738339231522151*^9, 
  3.7383392452005997`*^9}, {3.7383431098747497`*^9, 3.738343122041055*^9}, {
  3.7386672428650665`*^9, 3.7386672445176306`*^9}, {3.738668996754066*^9, 
  3.738669033804001*^9}}],

Cell[CellGroupData[{

Cell["Additional notes on PDLs", "Subsection",
 CellChangeTimes->{{3.738416449674872*^9, 3.7384164552060475`*^9}}],

Cell["\<\
The design matrix involves multiple polynomials covering different lagged \
intervals. These polynomials may be of different orders. Consider, for \
example, the design matrix\
\>", "Text",
 CellChangeTimes->{{3.7382456419021225`*^9, 3.738245759141017*^9}, {
  3.738248768534054*^9, 3.738248775440673*^9}, {3.738339231522151*^9, 
  3.7383392452005997`*^9}, {3.7383431098747497`*^9, 3.738343233151621*^9}, {
  3.7383434136203794`*^9, 3.738343436313591*^9}, {3.7383945629244375`*^9, 
  3.738394568015745*^9}, {3.738425700279171*^9, 3.738425708285775*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "1", "0", "0", "0", "0"},
     {"1", "2", "0", "0", "0", "0"},
     {"1", "3", "0", "0", "0", "0"},
     {"1", "4", "0", "0", "0", "0"},
     {"0", "0", "1", "0", "0", "0"},
     {"0", "0", "1", "0", "0", "0"},
     {"0", "0", "1", "0", "0", "0"},
     {"0", "0", "0", "1", "1", "1"},
     {"0", "0", "0", "1", "2", "4"},
     {"0", "0", "0", "1", "3", "9"}
    }], "\[NoBreak]", ")"}], TraditionalForm]], "Equation",
 CellChangeTimes->{{3.7383432900031967`*^9, 3.7383434081554613`*^9}, {
  3.738343596839023*^9, 3.738343605468202*^9}}],

Cell[TextData[{
 "This specifies that: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Beta]", "1"], ",", "...", ",", 
    SubscriptBox["\[Beta]", "4"]}], TraditionalForm]]],
 " lie on a linear segment; ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Beta]", "5"], "=", 
    RowBox[{
     SubscriptBox["\[Beta]", "6"], "=", 
     SubscriptBox["\[Beta]", "7"]}]}], TraditionalForm]]],
 "; and, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Beta]", "8"], TraditionalForm]]],
 " through ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Beta]", "10"], TraditionalForm]]],
 " lie on a quadratic segment. Linear restrictions on the ",
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]]],
 " can be imposed to ensure that the segments join up. Splines can be used to \
give smoothness (continuity of derivatives, see Smith (1979)). Although PDLs \
are usually introduced using the direct polynomial forms used above, most \
estimation software packages use alternative representations that aim to \
control collinearity and errors of numerical precision (Cooper (1972))."
}], "Text",
 CellChangeTimes->{{3.738343427548006*^9, 3.7383435604216533`*^9}, {
  3.7383436106427903`*^9, 3.738343670054345*^9}, {3.7383946101411324`*^9, 
  3.7383946603100147`*^9}, {3.7384160507483225`*^9, 3.7384163958916473`*^9}, {
  3.738583266684637*^9, 3.7385833018453074`*^9}, {3.738583508239934*^9, 
  3.738583520639734*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sparsity", "Section",
 CellChangeTimes->{{3.7382458646056037`*^9, 3.738245866339946*^9}}],

Cell[TextData[{
 "Application of PDL\[CloseCurlyQuote]s greatly reduces the size of the cross \
product matrix, from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[ScriptCapitalL]", "\[Times]", "\[ScriptCapitalL]"}], 
   TraditionalForm]]],
 " to (in the quadratic case) ",
 Cell[BoxData[
  FormBox[
   RowBox[{"3", "\[Times]", "3"}], TraditionalForm]]],
 ". To arrive at that point in the direct way, though, we must compute ",
 Cell[BoxData[
  FormBox[
   RowBox[{"X", "\[VeryThinSpace]", "D"}], TraditionalForm]]],
 " where ",
 Cell[BoxData[
  FormBox["X", TraditionalForm]]],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[ScriptCapitalT]", "\[Times]", "\[ScriptCapitalL]", " "}], 
   TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox["D", TraditionalForm]]],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[ScriptCapitalL]", "\[Times]", "3"}], TraditionalForm]]],
 ". This is still a formidable computation, so we take advantage of the \
sparsity of the data.  Specifically, if ",
 StyleBox["y",
  FontSlant->"Italic"],
 " and ",
 StyleBox["x",
  FontSlant->"Italic"],
 " are ",
 Cell[BoxData[
  FormBox["\[ScriptCapitalT]", TraditionalForm]]],
 "-vectors of price changes, it may well be that the number of non-zero \
elements is on the order of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["10", 
     RowBox[{"-", "6"}]], "\[ScriptCapitalT]"}], TraditionalForm]]],
 ". This is sparsity in the usual sense, wherein a matrix is assumed to be \
primarily zeros, and only the non-zero elements (and their locations) are \
stored. Notationally, we write ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["t", "k"], ",", 
      RowBox[{
       RowBox[{
        SubscriptBox["v", "k"], " ", "for", " ", "k"}], "=", "1"}], ",", "...",
       ",", "K"}], "}"}]}], TraditionalForm]]],
 " where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["t", "k"], " ", "and", " ", 
    SubscriptBox["v", "k"]}], TraditionalForm]]],
 " denote the time and value of the ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["k", "th"], TraditionalForm]]],
 " element. Implicitly, the ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]]],
 " nonzero elements are embedded in a vector of size \[ScriptCapitalT], which \
has zeros (except at the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["t", "k"], TraditionalForm]]],
 " positions). Direct calculation of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"D", "\[Transpose]"}], 
    RowBox[{"X", "\[Transpose]"}], "X", "\[VeryThinSpace]", "D"}], 
   TraditionalForm]]],
 " requires on the order of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[ScriptCapitalT]", "2"], 
    SuperscriptBox["\[ScriptCapitalL]", "4"]}], TraditionalForm]]],
 " multiplications. By taking advantage of sparsity, this can be brought down \
to the order of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["K", "2"], TraditionalForm]]],
 ". "
}], "Text",
 CellChangeTimes->{{3.738245900472229*^9, 3.7382460023261533`*^9}, {
   3.738246057693926*^9, 3.7382464136590424`*^9}, {3.7382464749069614`*^9, 
   3.7382469989921227`*^9}, {3.7382470290532813`*^9, 3.738247040805256*^9}, {
   3.7382470922560854`*^9, 3.738247102261552*^9}, {3.738247160267403*^9, 
   3.738247206561293*^9}, {3.7382472796773643`*^9, 3.7382473518826904`*^9}, {
   3.7382473825302973`*^9, 3.738247889348196*^9}, {3.7383443192966504`*^9, 
   3.738344319390605*^9}, {3.7384048682139606`*^9, 3.7384048689739356`*^9}, {
   3.7384050641880674`*^9, 3.7384050641880674`*^9}, {3.738405126805644*^9, 
   3.7384051268066444`*^9}, {3.7384051976183724`*^9, 3.73840523293894*^9}, {
   3.7384052743302927`*^9, 3.7384055764037223`*^9}, {3.7384056168735857`*^9, 
   3.738405629159723*^9}, 3.7384056654686427`*^9, {3.7384085281793437`*^9, 
   3.7384085403377934`*^9}, 3.7386748362802076`*^9, {3.7498577174441185`*^9, 
   3.7498578233358326`*^9}}],

Cell[TextData[{
 "Define ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[ScriptCapitalI]", "(", "k", ")"}], TraditionalForm]]],
 " as a ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[ScriptCapitalT]", "\[Times]", "\[ScriptCapitalL]", " "}], 
   TraditionalForm]]],
 " matrix of zeros, with an ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[ScriptCapitalL]", "\[Times]", "\[ScriptCapitalL]"}], 
   TraditionalForm]]],
 " identity matrix located with its first element in row ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]]],
 " and column 1. With this definition, the lagged data matrix may be written \
as"
}], "Text",
 CellChangeTimes->{{3.738245900472229*^9, 3.7382460023261533`*^9}, {
   3.738246057693926*^9, 3.7382464136590424`*^9}, {3.7382464749069614`*^9, 
   3.7382469989921227`*^9}, {3.7382470290532813`*^9, 3.738247040805256*^9}, {
   3.7382470922560854`*^9, 3.738247102261552*^9}, {3.738247160267403*^9, 
   3.738247206561293*^9}, {3.7382472796773643`*^9, 3.7382473518826904`*^9}, {
   3.7382473825302973`*^9, 3.738247889348196*^9}, {3.7383443192966504`*^9, 
   3.738344319390605*^9}, {3.7384048682139606`*^9, 3.7384048689739356`*^9}, {
   3.7384050641880674`*^9, 3.7384050641880674`*^9}, {3.738405126805644*^9, 
   3.7384051268066444`*^9}, {3.7384051976183724`*^9, 3.73840523293894*^9}, {
   3.7384052743302927`*^9, 3.7384055764037223`*^9}, {3.7384056168735857`*^9, 
   3.738405629159723*^9}, 3.7384056654686427`*^9, {3.7384085281793437`*^9, 
   3.7384085325256557`*^9}, {3.7498578343613358`*^9, 3.749857836458725*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"X", "=", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "1"}], "K"], 
    RowBox[{
     SubscriptBox["v", "k"], 
     RowBox[{"\[ScriptCapitalI]", "(", 
      RowBox[{
       SubscriptBox["t", "k"], "+", "1"}], ")"}]}]}]}], 
  TraditionalForm]], "Equation",
 CellChangeTimes->{{3.7382479466103196`*^9, 3.738247992216966*^9}, {
  3.738248032473542*^9, 3.7382480519353952`*^9}, {3.7383456432282076`*^9, 
  3.738345643306102*^9}, {3.738347422927492*^9, 3.738347422927492*^9}, {
  3.7384049952534*^9, 3.738405011626628*^9}}],

Cell[TextData[{
 "where the unit offset in ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["t", "k"], "+", "1"}], TraditionalForm]]],
 " imposes a lag relative to the original series. It is understood that any \
terms with row index larger than \[ScriptCapitalT] are discarded. "
}], "Text",
 CellChangeTimes->{{3.7384057859356227`*^9, 3.7384061274137197`*^9}, {
   3.738406179006796*^9, 3.738406181198936*^9}, {3.738406214828034*^9, 
   3.738406216407812*^9}, 3.7384085782095118`*^9}],

Cell[TextData[{
 "For example, suppose that with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[ScriptCapitalT]", "=", "12"}], TraditionalForm]]],
 ", there are three non-zero values of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]]],
 ": ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["x", "1"], "=", "4"}], ",", " ", 
    RowBox[{
     SubscriptBox["x", "3"], "=", "2"}]}], TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "7"], "=", "5"}], TraditionalForm]]],
 ". Specified as a sparse matrix, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "7"}], "}"}], " ", "and", " ", "v"}], "=", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2", ",", "5"}], "}"}]}]}], TraditionalForm]]],
 " The lagged data matrix for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[ScriptCapitalL]", "=", "4"}], TraditionalForm]]],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"X", "=", 
    RowBox[{
     RowBox[{"4", 
      RowBox[{"\[ScriptCapitalI]", "(", "2", ")"}]}], "+", 
     RowBox[{"2", 
      RowBox[{"\[ScriptCapitalI]", "(", "4", ")"}]}], "+", 
     RowBox[{"5", 
      RowBox[{"\[ScriptCapitalI]", "(", "8", ")"}]}]}]}], TraditionalForm]]],
 ". Expressed in full form:"
}], "Text",
 CellChangeTimes->{{3.7384057859356227`*^9, 3.7384061274137197`*^9}, {
  3.738406179006796*^9, 3.738406181198936*^9}, {3.738406214828034*^9, 
  3.738406216407812*^9}, {3.7384086082970777`*^9, 3.7384086094300766`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"X", "=", 
   RowBox[{
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0", "0"},
       {"4", "0", "0", "0"},
       {"0", "4", "0", "0"},
       {"2", "0", "4", "0"},
       {"0", "2", "0", "4"},
       {"0", "0", "2", "0"},
       {"0", "0", "0", "2"},
       {"5", "0", "0", "0"},
       {"0", "5", "0", "0"},
       {"0", "0", "5", "0"},
       {"0", "0", "0", "5"},
       {"0", "0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], "=", 
    RowBox[{
     RowBox[{"4", "\[Times]", 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0", "0"},
          {"1", "0", "0", "0"},
          {"0", "1", "0", "0"},
          {"0", "0", "1", "0"},
          {"0", "0", "0", "1"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]]}], "+", 
     RowBox[{"2", "\[Times]", 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"1", "0", "0", "0"},
          {"0", "1", "0", "0"},
          {"0", "0", "1", "0"},
          {"0", "0", "0", "1"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]]}], "+", 
     RowBox[{"5", "\[Times]", 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"1", "0", "0", "0"},
          {"0", "1", "0", "0"},
          {"0", "0", "1", "0"},
          {"0", "0", "0", "1"},
          {"0", "0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]]}]}]}]}], TraditionalForm]], "Equation",
 CellChangeTimes->{
  3.738344208316518*^9, {3.7383444636928797`*^9, 3.738344475123027*^9}, {
   3.7383445072514553`*^9, 3.738344530870861*^9}, {3.738345263732566*^9, 
   3.7383452655277047`*^9}}],

Cell["", "Text",
 CellChangeTimes->{{3.7382480807962084`*^9, 3.73824824385636*^9}, {
  3.738248813877116*^9, 3.7382488205447545`*^9}, {3.73834460882313*^9, 
  3.73834460882313*^9}}],

Cell[TextData[{
 "It is initially easier to illustrate the calculations when the data are \
assumed to satisfy a non-overlap condition such that the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["t", "k"], TraditionalForm]]],
 " are sufficiently removed from one another that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["t", "k"], "-", 
     SubscriptBox["t", 
      RowBox[{"k", "-", "1"}]]}], "\[GreaterEqual]", " ", 
    "\[ScriptCapitalL]"}], TraditionalForm]]],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"k", "=", "2"}], ",", "...", ",", "K"}], TraditionalForm]]],
 ". In this case, the blocks of lagged variables are distinct. The example \
given above does not satisfy this condition. (Rows 4 and 5 contain overlapped \
lagged values.) A lagged data matrix that ",
 StyleBox["does",
  FontSlant->"Italic"],
 " satisfy the non-overlap condition can be constructed for nonzero values ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["x", "1"], "=", "4"}], ",", " ", 
    RowBox[{
     SubscriptBox["x", 
      RowBox[{"4", " "}]], "=", "2"}], ",", " ", 
    RowBox[{
     SubscriptBox["x", "7"], "=", "5"}]}], TraditionalForm]]],
 ", with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[ScriptCapitalT]", "=", "10"}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[ScriptCapitalL]", "=", "3"}], TraditionalForm]]],
 ":"
}], "Text",
 CellChangeTimes->{{3.7382480807962084`*^9, 3.73824824385636*^9}, {
  3.738248813877116*^9, 3.7382488205447545`*^9}, {3.738344733996539*^9, 
  3.7383448015932236`*^9}, {3.7383448521782913`*^9, 3.738345022416602*^9}, {
  3.7383450909508705`*^9, 3.7383451776926064`*^9}, {3.738406268820695*^9, 
  3.7384063990485563`*^9}, {3.738406472145181*^9, 3.738406493418311*^9}, {
  3.738406666874607*^9, 3.738406666874607*^9}, {3.7384086418663373`*^9, 
  3.738408644180234*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"X", "=", 
   RowBox[{
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"0", "0", "0"},
        {"4", "0", "0"},
        {"0", "4", "0"},
        {"0", "0", "4"},
        {"2", "0", "0"},
        {"0", "2", "0"},
        {"0", "0", "2"},
        {"5", "0", "0"},
        {"0", "5", "0"},
        {"0", "0", "5"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]], "=", 
    RowBox[{
     RowBox[{"4", "\[Times]", 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"1", "0", "0"},
          {"0", "1", "0"},
          {"0", "0", "1"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]]}], "+", 
     RowBox[{"2", "\[Times]", 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"1", "0", "0"},
          {"0", "1", "0"},
          {"0", "0", "1"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]]}], "+", 
     RowBox[{"5", "\[Times]", 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"1", "0", "0"},
          {"0", "1", "0"},
          {"0", "0", "1"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]]}]}]}]}], TraditionalForm]], "Equation",
 CellChangeTimes->{{3.7384066508524895`*^9, 3.7384067197692504`*^9}}],

Cell["The cross product required for the OLS estimates is then:", "Text",
 CellChangeTimes->{{3.7382480807962084`*^9, 3.73824824385636*^9}, {
   3.738248813877116*^9, 3.7382488205447545`*^9}, {3.738344733996539*^9, 
   3.7383447487603397`*^9}, {3.7384086900924473`*^9, 3.7384087331264043`*^9}, 
   3.7386748376146393`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{"\t\t\t", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"D", "\[Transpose]"}], 
      RowBox[{"X", "\[Transpose]"}], "X", "\[VeryThinSpace]\[VeryThinSpace]", 
      "D"}], "\[AlignmentMarker]", "=", 
     RowBox[{
      RowBox[{"D", "\[Transpose]"}], 
      RowBox[{"(", 
       RowBox[{
        UnderscriptBox["\[Sum]", "k"], 
        RowBox[{
         SubscriptBox["v", "k"], 
         RowBox[{
          RowBox[{"\[ScriptCapitalI]", "(", 
           RowBox[{
            SubscriptBox["t", "k"], "+", "1"}], ")"}], "\[Transpose]"}]}]}], 
       ")"}], 
      RowBox[{"(", 
       RowBox[{
        UnderscriptBox["\[Sum]", "j"], 
        RowBox[{
         SubscriptBox["v", "j"], 
         RowBox[{"\[ScriptCapitalI]", "(", 
          RowBox[{
           SubscriptBox["t", "j"], "+", "1"}], ")"}]}]}], ")"}], "D"}]}], 
    "\[LineSeparator]", "\[AlignmentMarker]", 
    RowBox[{"=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        UnderscriptBox["\[Sum]", "k"], 
        RowBox[{
         SubscriptBox["v", "k"], 
         RowBox[{"D", "\[Transpose]"}], 
         RowBox[{
          RowBox[{"\[ScriptCapitalI]", "(", 
           RowBox[{
            SubscriptBox["t", "k"], "+", "1"}], ")"}], "\[Transpose]"}]}]}], 
       ")"}], 
      RowBox[{"(", 
       RowBox[{
        UnderscriptBox["\[Sum]", "j"], 
        RowBox[{
         SubscriptBox["v", "j"], 
         RowBox[{"\[ScriptCapitalI]", "(", 
          RowBox[{
           SubscriptBox["t", "j"], "+", "1"}], ")"}], "\[VeryThinSpace]", 
         "D"}]}], ")"}]}]}], "\[LineSeparator]", "\[AlignmentMarker]", 
    RowBox[{"=", 
     RowBox[{
      UnderscriptBox["\[Sum]", 
       RowBox[{"k", ",", "j"}]], 
      RowBox[{
       SubscriptBox["v", "j"], 
       SubscriptBox["v", "k"], 
       RowBox[{"D", "\[Transpose]"}], 
       RowBox[{
        RowBox[{"\[ScriptCapitalI]", "(", 
         RowBox[{
          SubscriptBox["t", "k"], "+", "1"}], ")"}], "\[Transpose]"}], 
       RowBox[{"\[ScriptCapitalI]", "(", 
        RowBox[{
         SubscriptBox["t", "j"], "+", "1"}], ")"}], "\[VeryThinSpace]", 
       "D"}]}]}], "\[LineSeparator]", "\[AlignmentMarker] ", 
    RowBox[{"=", 
     RowBox[{
      UnderscriptBox["\[Sum]", "k"], 
      RowBox[{
       SubsuperscriptBox["v", "k", "2"], 
       RowBox[{"D", "\[Transpose]"}], 
       RowBox[{
        RowBox[{"\[ScriptCapitalI]", "(", 
         RowBox[{
          SubscriptBox["t", "k"], "+", "1"}], ")"}], "\[Transpose]"}], 
       RowBox[{"\[ScriptCapitalI]", "(", 
        RowBox[{
         SubscriptBox["t", "k"], "+", "1"}], ")"}], "\[VeryThinSpace]", 
       "D"}]}]}]}]}], TraditionalForm]], "EquationNumbered",
 CellChangeTimes->{{3.7382482594896173`*^9, 3.7382484626853046`*^9}, {
  3.738248508401737*^9, 3.7382487328714943`*^9}, {3.738249021870596*^9, 
  3.738249022979949*^9}, {3.738345660506298*^9, 3.738345687053503*^9}, {
  3.7383457483903866`*^9, 3.738345748455804*^9}, {3.738345823232979*^9, 
  3.738345839603389*^9}, {3.738406751125345*^9, 3.738406820248557*^9}, {
  3.738408743214445*^9, 3.7384087741237726`*^9}, {3.738408811514855*^9, 
  3.7384088301260953`*^9}},
 TextAlignment->AlignmentMarker],

Cell[TextData[{
 "The last equality relies on the non-overlap condition. Since ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"\[ScriptCapitalI]", "(", 
      RowBox[{
       SubscriptBox["t", "k"], "+", "1"}], ")"}], "\[Transpose]"}], 
    RowBox[{"\[ScriptCapitalI]", "(", 
     RowBox[{
      SubscriptBox["t", "k"], "+", "1"}], ")"}]}], TraditionalForm]]],
 " is an identity matrix of order ",
 Cell[BoxData[
  FormBox["\[ScriptCapitalL]", TraditionalForm]]],
 ", the inner term of the last summation is equal to the product ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"D", "\[Transpose]"}], "D"}], TraditionalForm]]],
 ", is a constant ",
 Cell[BoxData[
  FormBox[
   RowBox[{"3", "\[Times]", "3"}], TraditionalForm]]],
 " matrix. Since we only need to compute it once, direct calculation is \
straightforward.  Of course, in this case, it might be pointed out that with \
the non-overlap condition, we could view the problem as consisting of ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]]],
 " disjoint samples. Cumulating over these samples is the obvious thing to \
do, with no particular need to embed the data in the length-\[ScriptCapitalT] \
time frame."
}], "Text",
 CellChangeTimes->{{3.738250069436581*^9, 3.738250070417838*^9}, {
   3.738250101699358*^9, 3.7382501969220333`*^9}, {3.738250269591139*^9, 
   3.7382502743418627`*^9}, {3.738250309503453*^9, 3.738250470577914*^9}, {
   3.7382505790643578`*^9, 3.7382505805625396`*^9}, {3.7382506422371025`*^9, 
   3.7382506468441277`*^9}, 3.7382506827998486`*^9, {3.7382515195062103`*^9, 
   3.738251529157593*^9}, {3.7382516371333356`*^9, 3.738251648025353*^9}, {
   3.7383458661947527`*^9, 3.738345962438097*^9}, {3.738346022762704*^9, 
   3.738346026631396*^9}, 3.7383460592784615`*^9, {3.7383462800182014`*^9, 
   3.738346282713277*^9}, {3.738406842623741*^9, 3.738406849294942*^9}, {
   3.7384068913764105`*^9, 3.7384069294865603`*^9}, {3.7384088594876094`*^9, 
   3.73840889659437*^9}, {3.7498861953724327`*^9, 3.749886282445878*^9}}],

Cell[TextData[{
 "We now drop the non-overlap assumption. We also consider a more general \
bivariate cross product situation similar to those that arise in multivariate \
VARs. Suppose that both ",
 StyleBox["x",
  FontSlant->"Italic"],
 " and ",
 StyleBox["y",
  FontSlant->"Italic"],
 " are sparse time series. The lagged data matrix corresponding to ",
 StyleBox["x",
  FontSlant->"Italic"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"X", ",", " ", 
    RowBox[{Cell["a"], " ", "\[ScriptCapitalT]", "\[Times]", 
     SubscriptBox["\[ScriptCapitalL]", "x"]}]}], TraditionalForm]]],
 " matrix, where ",
 Cell[BoxData[
  FormBox["\[ScriptCapitalL]", TraditionalForm]]],
 " denotes the number of lags on ",
 StyleBox["x",
  FontSlant->"Italic"],
 ". Similarly, the lagged data matrix for ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]]],
 " is ",
 Cell[BoxData[
  FormBox["Y", TraditionalForm]]],
 ", a ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[ScriptCapitalT]", "\[Times]", 
    SubscriptBox["L", "y"]}], TraditionalForm]]],
 " matrix. The corresponding PDL design matrices are ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["D", "x"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["D", "y"], TraditionalForm]]],
 ". ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["D", "x"], TraditionalForm]]],
 " has ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[ScriptCapitalL]", "x"], TraditionalForm]]],
 " rows, and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["D", "y"], TraditionalForm]]],
 " has ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[ScriptCapitalL]", "y"], TraditionalForm]]],
 " rows. The orders of the polynomials (equal to the numbers of columns) may \
also differ.  The desired cross product matrix is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["D", "x"], "\[Transpose]"}], 
    RowBox[{"X", "\[Transpose]"}], "Y", "\[VeryThinSpace]", 
    SubscriptBox["D", "y"]}], TraditionalForm]]],
 ". The sparse representation of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]]],
 " involves time and value vectors ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["t", "k"], " ", "and", " ", 
      SubscriptBox["v", "k"], " ", "for", " ", "k"}], "=", "1"}], ",", 
    RowBox[{
     RowBox[{"...", "K"}], "\[LessLess]", "\[ScriptCapitalT]"}]}], 
   TraditionalForm]]],
 "; that of ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]]],
 " has time and value vectors ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["s", "j"], " ", "and", " ", 
      SubscriptBox["u", "j"], " ", "for", " ", "j"}], "=", "1"}], ",", "...", 
    ",", 
    RowBox[{"J", "\[LessLess]", "\[ScriptCapitalT]"}]}], TraditionalForm]]],
 ". The lagged data matrices are represented as:"
}], "Text",
 CellChangeTimes->{{3.738250069436581*^9, 3.738250070417838*^9}, {
   3.738250101699358*^9, 3.7382501969220333`*^9}, {3.738250269591139*^9, 
   3.7382502743418627`*^9}, {3.738250309503453*^9, 3.738250470577914*^9}, {
   3.7382505790643578`*^9, 3.7382505805625396`*^9}, {3.7382506422371025`*^9, 
   3.7382506468441277`*^9}, 3.7382506827998486`*^9, {3.7382515195062103`*^9, 
   3.738251529157593*^9}, {3.7382516371333356`*^9, 3.738251648025353*^9}, {
   3.7383458661947527`*^9, 3.738345962438097*^9}, {3.738346022762704*^9, 
   3.738346025566208*^9}, {3.738346301765339*^9, 3.738346306345454*^9}, {
   3.738347450734866*^9, 3.738348075814984*^9}, {3.7383485357300005`*^9, 
   3.7383491017714167`*^9}, {3.7384037412836027`*^9, 3.738403743168565*^9}, {
   3.738674839037902*^9, 3.738674840225687*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"X", "=", 
   RowBox[{
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "1"}], "K"], 
     RowBox[{
      SubscriptBox["v", "k"], 
      RowBox[{"\[ScriptCapitalI]", "(", 
       RowBox[{
        SubscriptBox["t", "k"], "+", "1"}], ")"}], " ", "and", " ", "Y"}]}], 
    "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"j", "=", "1"}], "J"], 
     RowBox[{
      SubscriptBox["u", "j"], 
      RowBox[{"\[ScriptCapitalJ]", "(", 
       RowBox[{
        SubscriptBox["s", "j"], "+", "1"}], ")"}]}]}]}]}], 
  TraditionalForm]], "Equation",
 CellChangeTimes->{{3.7383491156473117`*^9, 3.7383492681602607`*^9}, {
  3.7384069447826385`*^9, 3.73840695104889*^9}}],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[ScriptCapitalI]", "(", "t", ")"}], TraditionalForm]]],
 " is (as above) a ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[ScriptCapitalT]", "\[Times]", 
    SubscriptBox["\[ScriptCapitalL]", "x"]}], TraditionalForm]]],
 " matrix of zeros, with an identity matrix of order ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[ScriptCapitalL]", "x"], TraditionalForm]]],
 " positioned with its leading element in the first column of row ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[ScriptCapitalJ]", "(", "s", ")"}], TraditionalForm]]],
 " is similarly defined as a ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[ScriptCapitalT]", "\[Times]", 
    SubscriptBox["\[ScriptCapitalL]", "y"]}], TraditionalForm]]],
 " matrix of zeros, with an identity matrix of order ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[ScriptCapitalL]", "y"], TraditionalForm]]],
 " positioned at ",
 Cell[BoxData[
  FormBox["s", TraditionalForm]]],
 ". With these definitions,"
}], "Text",
 CellChangeTimes->{{3.738250069436581*^9, 3.738250070417838*^9}, {
   3.738250101699358*^9, 3.7382501969220333`*^9}, {3.738250269591139*^9, 
   3.7382502743418627`*^9}, {3.738250309503453*^9, 3.738250470577914*^9}, {
   3.7382505790643578`*^9, 3.7382505805625396`*^9}, {3.7382506422371025`*^9, 
   3.7382506468441277`*^9}, 3.7382506827998486`*^9, {3.7382515195062103`*^9, 
   3.738251529157593*^9}, {3.7382516371333356`*^9, 3.738251648025353*^9}, {
   3.7383492765833406`*^9, 3.738349282291523*^9}, {3.7383493178747606`*^9, 
   3.738349558032795*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["D", "x"], "\[Transpose]"}], 
    RowBox[{"X", "\[Transpose]"}], "Y", "\[VeryThinSpace]", 
    SubscriptBox["D", "y"]}], "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["D", "x"], "\[Transpose]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"k", "=", "1"}], "K"], 
       RowBox[{
        SubscriptBox["v", "k"], 
        RowBox[{"\[ScriptCapitalI]", "(", 
         RowBox[{
          SubscriptBox["t", "k"], "+", "1"}], ")"}]}]}], ")"}], 
     "\[Transpose]"}], 
    RowBox[{"(", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"j", "=", "1"}], "J"], 
      RowBox[{
       SubscriptBox["u", "j"], 
       RowBox[{"\[ScriptCapitalJ]", "(", 
        RowBox[{
         SubscriptBox["s", "j"], "+", "1"}], ")"}]}]}], ")"}], 
    SubscriptBox["D", "y"]}]}], TraditionalForm]], "Equation",
 CellChangeTimes->{{3.7383495738479567`*^9, 3.73834962809895*^9}, 
   3.7383944013792505`*^9, {3.738403987981079*^9, 3.7384040009554234`*^9}, {
   3.7384069641249304`*^9, 3.7384069695145607`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"=", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "1"}], "K"], 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"j", "=", "1"}], "J"], 
     RowBox[{
      SubscriptBox["v", "k"], 
      SubscriptBox["u", "j"], 
      RowBox[{
       SubscriptBox["D", "x"], "\[Transpose]"}], 
      RowBox[{
       RowBox[{"\[ScriptCapitalI]", "(", 
        RowBox[{
         SubscriptBox["t", "k"], "+", "1"}], ")"}], "\[Transpose]"}], 
      RowBox[{"\[ScriptCapitalJ]", "(", 
       RowBox[{
        SubscriptBox["s", "j"], "+", "1"}], ")"}], 
      SubscriptBox["D", "y"]}]}]}]}], TraditionalForm]], "Equation",
 CellChangeTimes->{{3.7383495738479567`*^9, 3.73834962809895*^9}, 
   3.7383944013792505`*^9, {3.738403987981079*^9, 3.7384040393926315`*^9}, {
   3.7384040832493877`*^9, 3.7384041504427595`*^9}, {3.7384069741252303`*^9, 
   3.7384069791029205`*^9}, {3.7384091089457164`*^9, 3.738409109137209*^9}}],

Cell[TextData[{
 "For convenience, define ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[ScriptCapitalI]\[ScriptCapitalJ]", "(", 
     RowBox[{"t", ",", "s"}], ")"}], "\[Congruent]", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"\[ScriptCapitalI]", "(", "t", ")"}], " ", "\[Transpose]"}], 
     RowBox[{"\[ScriptCapitalJ]", "(", "s", ")"}]}]}], TraditionalForm]]],
 ", a matrix of size ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[ScriptCapitalL]", "x"], "\[Times]", 
    SubscriptBox["\[ScriptCapitalL]", "y"]}], TraditionalForm]]],
 ", and with elements are to zero or one. ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[ScriptCapitalI]\[ScriptCapitalJ]", 
    RowBox[{"(", 
     RowBox[{"t", ",", "s"}], ")"}]}], TraditionalForm]]],
 " indicates the overlap between the two lagged structures. Suppose, for \
example, that with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[ScriptCapitalT]", "=", "10"}], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[ScriptCapitalL]", "x"], "=", "3"}], ",", " ", 
    RowBox[{
     SubscriptBox["\[ScriptCapitalL]", "y"], "=", "4"}], ",", " ", 
    RowBox[{
     SubscriptBox["t", "1"], "=", "2"}], ",", " ", 
    RowBox[{
     RowBox[{"and", " ", 
      SubscriptBox["s", "1"]}], "=", "3"}]}], TraditionalForm]]],
 ". Then"
}], "Text",
 CellChangeTimes->{{3.738403756428109*^9, 3.738403934955905*^9}, {
   3.7384039656309*^9, 3.738403973791005*^9}, {3.7384042077386274`*^9, 
   3.738404289571849*^9}, {3.7384043197421694`*^9, 3.7384043308365517`*^9}, {
   3.7384043670756683`*^9, 3.738404505243317*^9}, {3.73840456266879*^9, 
   3.7384046765293674`*^9}, 3.738404776760418*^9, {3.7384069959179726`*^9, 
   3.738407124055436*^9}, {3.7384089360250425`*^9, 3.738409036075529*^9}, {
   3.738409077297295*^9, 3.738409082339857*^9}, {3.738409114608552*^9, 
   3.7384091486455603`*^9}, {3.7384091829039893`*^9, 
   3.7384092661166058`*^9}, {3.7384093040850554`*^9, 
   3.7384093623971767`*^9}, {3.7384096666278315`*^9, 
   3.7384096904511876`*^9}, {3.738409963159136*^9, 3.738409992665266*^9}, {
   3.7384104106278887`*^9, 3.7384104173968277`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"\[ScriptCapitalI]", "(", "2", ")"}], "=", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"0", "0", "0"},
        {"1", "0", "0"},
        {"0", "1", "0"},
        {"0", "0", "1"},
        {"0", "0", "0"},
        {"0", "0", "0"},
        {"0", "0", "0"},
        {"0", "0", "0"},
        {"0", "0", "0"},
        {"0", "0", "0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}], ",", 
   TagBox[
    RowBox[{
     RowBox[{"\[ScriptCapitalJ]", "(", "3", ")"}], "=", 
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"0", "0", "0", "0"},
        {"0", "0", "0", "0"},
        {"1", "0", "0", "0"},
        {"0", "1", "0", "0"},
        {"0", "0", "1", "0"},
        {"0", "0", "0", "1"},
        {"0", "0", "0", "0"},
        {"0", "0", "0", "0"},
        {"0", "0", "0", "0"},
        {"0", "0", "0", "0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", " ", 
   RowBox[{
    RowBox[{"and", " ", 
     RowBox[{"\[ScriptCapitalI]\[ScriptCapitalJ]", "(", 
      RowBox[{"2", ",", "3"}], ")"}]}], "=", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"0", "0", "0", "0"},
        {"1", "0", "0", "0"},
        {"0", "1", "0", "0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}]}], TraditionalForm]], "Equation",
 CellChangeTimes->{{3.738250069436581*^9, 3.738250070417838*^9}, {
   3.738250101699358*^9, 3.7382501969220333`*^9}, {3.738250269591139*^9, 
   3.7382502743418627`*^9}, {3.738250309503453*^9, 3.738250470577914*^9}, {
   3.7382505790643578`*^9, 3.7382505805625396`*^9}, {3.7382506422371025`*^9, 
   3.7382506468441277`*^9}, 3.7382506827998486`*^9, {3.7382515195062103`*^9, 
   3.738251529157593*^9}, {3.7382516371333356`*^9, 3.738251648025353*^9}, {
   3.738349276735537*^9, 3.7383492767511587`*^9}, {3.738409738318181*^9, 
   3.7384097383222046`*^9}, {3.738410004598415*^9, 3.7384100981133375`*^9}, {
   3.7384124466896095`*^9, 3.7384124486712627`*^9}}],

Cell[TextData[{
 "These representations can greatly simplify the cross product calculation. \
Initially suppose that each of the PDL design matrices contains only a \
constant term: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["D", "x"], "=", 
    RowBox[{
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"1", "1", "1"}
       }], "\[NoBreak]", ")"}], "\[Transpose]"}]}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["D", "y"], "=", 
    RowBox[{
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"1", "1", "1", "1"}
       }], "\[NoBreak]", ")"}], "\[Transpose]"}]}], TraditionalForm]]],
 ". Then the contribution to the cross product is"
}], "Text",
 CellChangeTimes->{{3.7384102691022635`*^9, 3.7384103588174276`*^9}, {
  3.738410431280678*^9, 3.738410440236762*^9}, {3.7384104989677362`*^9, 
  3.7384105111222715`*^9}, {3.738410542529316*^9, 3.7384105918983784`*^9}, {
  3.7384107017356796`*^9, 3.7384107217571774`*^9}, {3.7384107557014008`*^9, 
  3.7384107766344395`*^9}, {3.738410842609069*^9, 3.738410847730377*^9}, {
  3.7384108916110706`*^9, 3.7384111872277946`*^9}, {3.7384112204838915`*^9, 
  3.738411274348901*^9}, {3.7384113140607734`*^9, 3.7384114252016506`*^9}, {
  3.7384114694792833`*^9, 3.7384115289662375`*^9}, {3.7384115978600874`*^9, 
  3.73841162200055*^9}, {3.7384118755447216`*^9, 3.7384118782814045`*^9}, {
  3.738674841497259*^9, 3.738674843171809*^9}, {3.7486222580556192`*^9, 
  3.7486222930052204`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["v", "1"], 
    RowBox[{
     SubscriptBox["u", "1"], "(", "\[NoBreak]", GridBox[{
       {"1", "1", "1"}
      }], "\[NoBreak]", ")"}], 
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0", "0"},
       {"1", "0", "0", "0"},
       {"0", "1", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1"},
       {"1"},
       {"1"},
       {"1"}
      }], "\[NoBreak]", ")"}]}], "=", 
   RowBox[{
    SubscriptBox["v", "1"], 
    SubscriptBox["u", "1"], "\[Times]", "2"}]}], TraditionalForm]], "Equation",
 InitializationCell->True,
 CellChangeTimes->{{3.738411631333598*^9, 3.738411640840149*^9}, {
  3.7384116828119707`*^9, 3.7384117293824515`*^9}, {3.7384117692429695`*^9, 
  3.7384117921057677`*^9}}],

Cell["\<\
If the PDL design matrices contain constant and linear terms,\
\>", "Text",
 CellChangeTimes->{{3.738411891411319*^9, 3.7384119203280253`*^9}, 
   3.7384122125228677`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     TagBox[
      RowBox[{
       RowBox[{
        SubscriptBox["D", "x"], "\[Transpose]"}], "=", 
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"1", "1", "1"},
          {"1", "2", "3"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]], "and", " ", 
     RowBox[{
      SubscriptBox["D", "y"], "\[Transpose]"}]}], "=", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"1", "1", "1", "1"},
        {"1", "2", "3", "4"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}], ","}], TraditionalForm]], "Equation",
 CellChangeTimes->{{3.7384122193506107`*^9, 3.7384122639444237`*^9}, 
   3.738412350511014*^9, {3.7384123844612603`*^9, 3.7384124578477297`*^9}, {
   3.738412488458933*^9, 3.738412499127455*^9}}],

Cell["and the contribution to the cross product is:", "Text",
 CellChangeTimes->{{3.738412319830022*^9, 3.738412361808774*^9}, 
   3.7384125057008*^9, 3.738674844519221*^9}],

Cell[BoxData[
 FormBox["", TraditionalForm]], "Equation"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["v", "1"], 
    RowBox[{
     SubscriptBox["u", "1"], "(", "\[NoBreak]", GridBox[{
       {"1", "1", "1"},
       {"1", "2", "3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0", "0"},
       {"1", "0", "0", "0"},
       {"0", "1", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"1", "1"},
        {"1", "2"},
        {"1", "3"},
        {"1", "4"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}], "=", 
   RowBox[{
    SubscriptBox["v", "1"], 
    SubscriptBox["u", "1"], 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"2", "3"},
        {"5", "8"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}]}], TraditionalForm]], "Equation",
 CellChangeTimes->{
  3.7384125589494486`*^9, {3.7384126056924896`*^9, 3.7384126105824175`*^9}, {
   3.7384126781433396`*^9, 3.7384126824577494`*^9}, 3.7384127538638906`*^9}],

Cell["\<\
With quadratic PDL design matrices the cross product contribution is\
\>", "Text",
 CellChangeTimes->{{3.7384132505490885`*^9, 3.7384132971864347`*^9}, 
   3.7384133484074574`*^9, 3.7386748457030473`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["v", "1"], 
    SubscriptBox["u", "1"], 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"1", "1", "1"},
        {"1", "2", "3"},
        {"1", "4", "9"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]], 
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0", "0"},
       {"1", "0", "0", "0"},
       {"0", "1", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"1", "1", "1"},
        {"1", "2", "4"},
        {"1", "3", "9"},
        {"1", "4", "16"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}], "=", 
   RowBox[{
    SubscriptBox["v", "1"], 
    RowBox[{
     SubscriptBox["u", "1"], "(", "\[NoBreak]", GridBox[{
       {"2", "3", "5"},
       {"5", "8", "14"},
       {"13", "22", "40"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}]}], 
  TraditionalForm]], "Equation",
 CellChangeTimes->{
  3.7384125589494486`*^9, {3.7384126056924896`*^9, 3.7384126105824175`*^9}, {
   3.7384126781433396`*^9, 3.7384126824577494`*^9}, 3.7384127538638906`*^9, {
   3.7384134652850094`*^9, 3.7384134993400016`*^9}, 3.738413541447484*^9}],

Cell[TextData[{
 "In general, the entries in the last matrix are double partial sums of \
offset finite geometric series, for which compact closed-form expressions are \
readily available. (It is not necessary to construct and multiply the \
matrices on the left hand sides of these expressions. See the Mathematica \
section on ",
 ButtonBox["lagged polynomial cross products of sparse vectors.) ",
  BaseStyle->"Hyperlink",
  ButtonData->"polyCross"],
 "Taking advantage of these closed-form expressions, define ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", 
     RowBox[{"t", ",", "s", ",", 
      SubscriptBox["\[ScriptCapitalL]", "x"], ",", 
      SubscriptBox["\[ScriptCapitalL]", "y"], ",", 
      SubscriptBox["d", "x"], ",", 
      SubscriptBox["d", "y"]}], ")"}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["D", "x"], "\[Transpose]"}], " ", 
     RowBox[{"\[ScriptCapitalI]", "(", "t", ")"}], 
     RowBox[{"\[ScriptCapitalJ]", "(", "s", ")"}], 
     SubscriptBox["D", "y"]}]}], TraditionalForm]]],
 ", where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["D", "x"], TraditionalForm]]],
 " is the PDL design matrix for ",
 StyleBox["x",
  FontSlant->"Italic"],
 ", with maximum degree ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["d", "x"], TraditionalForm]]],
 " and lag length ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[ScriptCapitalL]", "x"], TraditionalForm]]],
 ". ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["D", "y"], TraditionalForm]]],
 " is defined similarly. "
}], "Text",
 CellChangeTimes->{{3.7384127603295975`*^9, 3.7384127841139903`*^9}, {
   3.738412815979829*^9, 3.738412943146845*^9}, {3.7384129781004057`*^9, 
   3.738412985864704*^9}, {3.738413075190851*^9, 3.7384132070184727`*^9}, {
   3.7384136253869734`*^9, 3.738413827039815*^9}, {3.738413878582018*^9, 
   3.7384139535196857`*^9}, {3.738413983765912*^9, 3.7384142299896774`*^9}, {
   3.738414283842638*^9, 3.738414315080159*^9}, {3.7384143460702763`*^9, 
   3.7384143497334833`*^9}, {3.738414381942379*^9, 3.7384144021045227`*^9}, {
   3.7384149742371535`*^9, 3.738414981956535*^9}, {3.73867498726443*^9, 
   3.738675002027956*^9}, {3.738675133273035*^9, 3.7386751552782297`*^9}, 
   3.738675313776405*^9, {3.7386754271732025`*^9, 3.738675452791704*^9}, {
   3.73867567717076*^9, 3.7386756771717577`*^9}, {3.738675884164253*^9, 
   3.7386758988628664`*^9}, {3.749885459350609*^9, 3.7498854603599167`*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["D", "x"], "\[Transpose]"}], 
    RowBox[{"X", "\[Transpose]"}], "Y", "\[VeryThinSpace]", 
    SubscriptBox["D", "y"]}], "=", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "1"}], "K"], 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"j", "=", "1"}], "J"], 
     RowBox[{
      SubscriptBox["v", "k"], 
      SubscriptBox["u", "j"], 
      RowBox[{"f", "(", 
       RowBox[{
        RowBox[{
         SubscriptBox["t", "k"], "+", "1"}], ",", 
        RowBox[{
         SubscriptBox["s", "j"], "+", "1"}], ",", 
        SubscriptBox["\[ScriptCapitalL]", "x"], ",", 
        SubscriptBox["\[ScriptCapitalL]", "y"], ",", 
        SubscriptBox["d", "x"], ",", 
        SubscriptBox["d", "y"]}], ")"}]}]}]}]}], TraditionalForm]], "Equation",
 CellChangeTimes->{{3.738412369249919*^9, 3.7384123706631155`*^9}, {
  3.738414445098624*^9, 3.7384145341744156`*^9}}],

Cell[TextData[{
 "Direct computation of the left-hand side involves something on the order of \
",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     SuperscriptBox["\[ScriptCapitalL]", "2"], "x"], "\[Times]", 
    SuperscriptBox["\[ScriptCapitalT]", "2"], "\[Times]", 
    SubscriptBox[
     SuperscriptBox["\[ScriptCapitalL]", "2"], "y"]}], TraditionalForm]]],
 " operations. Evaluation of ",
 Cell[BoxData[
  FormBox[Cell[TextData[Cell[BoxData[
    FormBox["f", TraditionalForm]]]]], TraditionalForm]]],
 "involves (at most) several hundred operations. The double sum is only over \
the nonzero values of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]]],
 ". If we sort the entries in the sparse matrices by time (of the nonzero \
elements), we can realize greater efficiencies. For a given ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]]],
 ", the values of ",
 Cell[BoxData[
  FormBox["j", TraditionalForm]]],
 " that make nonzero contributions to the crossproduct (that is, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[ScriptCapitalI]\[ScriptCapitalJ]", "(", 
     RowBox[{
      RowBox[{
       SubscriptBox["t", "k"], "+", "1"}], ",", 
      RowBox[{
       SubscriptBox["s", "j"], "+", "1"}]}], ")"}], "\[NotEqual]", "0"}], 
   TraditionalForm]]],
 ") can be determined before the start of the inner loop."
}], "Text",
 CellChangeTimes->{{3.7384146030953436`*^9, 3.738414910957342*^9}, {
  3.7384149890375805`*^9, 3.738415474506775*^9}, {3.749830038347947*^9, 
  3.749830038347947*^9}, {3.749855857409075*^9, 3.749856043166085*^9}, {
  3.749885719124646*^9, 3.7498857512497044`*^9}, {3.7499112271399655`*^9, 
  3.7499112275142775`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["References", "Section",
 CellChangeTimes->{{3.7384157544005365`*^9, 3.738415757004603*^9}}],

Cell[TextData[{
 "Almon, Shirley, 1965, The Distributed Lag Between Capital Appropriations \
and Expenditures, ",
 StyleBox["Econometrica",
  FontSlant->"Italic"],
 " 33, 178-196."
}], "Text",
 CellChangeTimes->{
  3.7384158999175105`*^9, {3.7384159546551766`*^9, 3.7384159546551766`*^9}, {
   3.7385834923225174`*^9, 3.7385834923225174`*^9}}],

Cell["\<\
Cooper, J. Phillip, 1972, Two Approaches to Polynomial Distributed Lags \
Estimation: An Expository Note and Comment, The American Statistician 26, \
32-35.\
\>", "Text",
 CellChangeTimes->{
  3.7384158999175105`*^9, {3.7384159546551766`*^9, 3.7384159546551766`*^9}, {
   3.7385834961218185`*^9, 3.7385834975012407`*^9}}],

Cell[TextData[{
 "Smith, Patricia L., 1979, Splines as a useful and convenient statistical \
tool, ",
 StyleBox["American Statistician",
  FontSlant->"Italic"],
 " 33, 57-62."
}], "Text",
 CellChangeTimes->{3.7384158999175105`*^9, 3.7384159566648026`*^9, 
  3.738583500141159*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mathematica Code", "Title",
 CellChangeTimes->{{3.738583557067975*^9, 3.7385835632275295`*^9}}],

Cell[CellGroupData[{

Cell["Polynomial update verifications", "Section",
 CellChangeTimes->{{3.698103799646291*^9, 3.6981038160119095`*^9}, {
  3.6995563190096254`*^9, 3.6995563322620487`*^9}, {3.738343722786723*^9, 
  3.738343728304172*^9}, {3.7384165303880625`*^9, 3.7384165384724503`*^9}, {
  3.738424283614358*^9, 3.7384242882071276`*^9}, {3.7385836900318313`*^9, 
  3.7385836929215193`*^9}, {3.738665902470992*^9, 3.7386659048496294`*^9}, {
  3.738669067989624*^9, 3.7386690701508217`*^9}},
 CellTags->"polyUp"],

Cell["This section may be evaluated.", "Text",
 CellChangeTimes->{{3.7383393542659893`*^9, 3.738339376080755*^9}, {
  3.7385837791121044`*^9, 3.7385838197475357`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"y", ",", "S", ",", "t", ",", "n", ",", "d"}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.6981040424437275`*^9, 3.6981040452744565`*^9}, {
   3.738339320876251*^9, 3.738339345488536*^9}, {3.7383396861328487`*^9, 
   3.7383396864689093`*^9}, {3.7383416791640973`*^9, 
   3.7383416804107637`*^9}, {3.738341727924319*^9, 3.738341732767446*^9}, 
   3.738341861640897*^9, {3.73842081024472*^9, 3.7384208113058395`*^9}, {
   3.738424269862085*^9, 3.7384242777420206`*^9}, {3.738583813884901*^9, 
   3.7385838153648214`*^9}}],

Cell[TextData[{
 "The PDL state variables are as follows. ",
 StyleBox["t", "Input"],
 " is the current time index; ",
 StyleBox["n", "Input"],
 " is the max lag; ",
 StyleBox["d", "Input"],
 " is the degree."
}], "Text",
 CellChangeTimes->{{3.6995564245138855`*^9, 3.6995564494621687`*^9}, {
  3.699809076592886*^9, 3.699809082505589*^9}, {3.7383397929731903`*^9, 
  3.7383398270062094`*^9}, {3.738341869303372*^9, 3.7383418718366*^9}, {
  3.7385838504332876`*^9, 3.738584070745285*^9}, {3.7386673045112543`*^9, 
  3.738667313615879*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"S", "[", 
   RowBox[{
    RowBox[{"t_:", "t"}], ",", 
    RowBox[{"n_:", "n"}], ",", 
    RowBox[{"d_:", "0"}]}], "]"}], ":=", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["y", 
      RowBox[{"t", "-", "i"}]], 
     SuperscriptBox["i", "d"]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6998089176557446`*^9, 3.699809069605767*^9}, {
   3.699809105036391*^9, 3.6998091263073406`*^9}, {3.6998091925836163`*^9, 
   3.6998091995099216`*^9}, {3.7383392973142476`*^9, 3.738339297997497*^9}, {
   3.738339383583656*^9, 3.7383393936796627`*^9}, {3.738339425019862*^9, 
   3.7383395220205646`*^9}, {3.7383395720189085`*^9, 3.738339608797548*^9}, {
   3.73833963927208*^9, 3.738339707531601*^9}, {3.738339952257455*^9, 
   3.73834001381684*^9}, {3.7383400559521646`*^9, 3.738340237573635*^9}, 
   3.7383416815217466`*^9, {3.7384209004515305`*^9, 3.7384209695378833`*^9}, {
   3.73842100422922*^9, 3.738421010700837*^9}, {3.738655465076092*^9, 
   3.7386554707220035`*^9}, {3.738665955895183*^9, 3.7386660082072725`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"S", "[", 
      RowBox[{"t", ",", "n", ",", "#"}], "]"}], "&"}], "/@", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2"}], "}"}]}], "}"}], "//", 
  "TableForm"}]], "Input",
 CellChangeTimes->{{3.73865547472034*^9, 3.738655495974478*^9}, {
  3.7386660564612513`*^9, 3.7386660894271097`*^9}, {3.73866734453728*^9, 
  3.73866734816949*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"i", "=", "1"}], "n"], 
      SubscriptBox["y", 
       RowBox[{
        RowBox[{"-", "i"}], "+", "t"}]]}], 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"i", "=", "1"}], "n"], 
      RowBox[{"i", " ", 
       SubscriptBox["y", 
        RowBox[{
         RowBox[{"-", "i"}], "+", "t"}]]}]}], 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"i", "=", "1"}], "n"], 
      RowBox[{
       SuperscriptBox["i", "2"], " ", 
       SubscriptBox["y", 
        RowBox[{
         RowBox[{"-", "i"}], "+", "t"}]]}]}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.738655481987872*^9, 3.7386554966636324`*^9}, 
   3.7386659162013197`*^9, 3.738666012975596*^9, {3.73866607870702*^9, 
   3.7386660899689302`*^9}, 3.738667348706236*^9, 3.7498554891433125`*^9}]
}, Open  ]],

Cell[TextData[{
 "Verify the degree 0 update expression for various values of ",
 StyleBox["n", "Input"],
 ":"
}], "Text",
 CellChangeTimes->{{3.7384224247017717`*^9, 3.738422430230991*^9}, {
  3.7386673566039762`*^9, 3.7386673631454515`*^9}, {3.7386673981947713`*^9, 
  3.738667419613469*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{
        RowBox[{"t", "+", "1"}], ",", "n", ",", "0"}], "]"}], "==", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"S", "[", 
         RowBox[{"t", ",", "n", ",", "0"}], "]"}], "+", 
        SubscriptBox["y", "t"], "-", 
        SubscriptBox["y", 
         RowBox[{"t", "-", "n"}]]}], ")"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "5", ",", "20", ",", "5"}], "}"}]}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellChangeTimes->{{3.7386657616156087`*^9, 3.7386657863984256`*^9}, {
  3.7386658462263775`*^9, 3.7386658616641026`*^9}, {3.738666313610695*^9, 
  3.738666320044483*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{
  3.7386657988191338`*^9, {3.738665853408555*^9, 3.738665862147806*^9}, 
   3.7386663204347377`*^9, 3.7498554891861224`*^9}]
}, Open  ]],

Cell[TextData[{
 "Verify the degree 1 update expression for various values of ",
 StyleBox["n", "Input"],
 "."
}], "Text",
 CellChangeTimes->{{3.7384224407678556`*^9, 3.738422445490238*^9}, {
  3.7385841205101748`*^9, 3.738584164381714*^9}, {3.738667439130275*^9, 
  3.738667461472537*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"S", "[", 
     RowBox[{
      RowBox[{"t", "+", "1"}], ",", "n", ",", "1"}], "]"}], "==", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"t", ",", "n", ",", "1"}], "]"}], "+", 
      RowBox[{"S", "[", 
       RowBox[{
        RowBox[{"t", "+", "1"}], ",", "n", ",", "0"}], "]"}], "-", 
      RowBox[{"n", " ", 
       SubscriptBox["y", 
        RowBox[{"t", "-", "n"}]]}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "5", ",", "20", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7384238265442452`*^9, 3.7384239652773685`*^9}, {
  3.738655389678729*^9, 3.7386553899260273`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{{3.738423896407528*^9, 3.7384239659365773`*^9}, 
   3.738666345257432*^9, 3.749855489206068*^9}]
}, Open  ]],

Cell["Alternatively, the expression used in the Matlab code is:", "Text",
 CellChangeTimes->{{3.7386664701102552`*^9, 3.7386664744067545`*^9}, {
  3.738669074464297*^9, 3.7386690836975965`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"S", "[", 
     RowBox[{"t", ",", "n", ",", "1"}], "]"}], "+", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"t", ",", "n", ",", "0"}], "]"}], "+", 
      SubscriptBox["y", "t"], "-", 
      SubscriptBox["y", 
       RowBox[{"t", "-", "n"}]]}], ")"}], "-", 
    RowBox[{"n", " ", 
     SubscriptBox["y", 
      RowBox[{"t", "-", "n"}]]}]}], ")"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.7386664265666647`*^9, 3.7386664396826077`*^9}}],

Cell[BoxData[
 RowBox[{
  SubscriptBox["y", "t"], "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "n"}], ")"}], " ", 
   SubscriptBox["y", 
    RowBox[{
     RowBox[{"-", "n"}], "+", "t"}]]}], "+", 
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"i", "=", "1"}], "n"], 
   SubscriptBox["y", 
    RowBox[{
     RowBox[{"-", "i"}], "+", "t"}]]}], "+", 
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"i", "=", "1"}], "n"], 
   RowBox[{"i", " ", 
    SubscriptBox["y", 
     RowBox[{
      RowBox[{"-", "i"}], "+", "t"}]]}]}]}]], "Output",
 CellChangeTimes->{3.7386664401872454`*^9, 3.7498554892479577`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"S", "[", 
     RowBox[{
      RowBox[{"t", "+", "1"}], ",", "n", ",", "1"}], "]"}], "==", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"t", ",", "n", ",", "1"}], "]"}], "+", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"S", "[", 
         RowBox[{"t", ",", "n", ",", "0"}], "]"}], "+", 
        SubscriptBox["y", "t"]}], ")"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], " ", 
       SubscriptBox["y", 
        RowBox[{"t", "-", "n"}]]}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "5", ",", "20", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7384238265442452`*^9, 3.7384239652773685`*^9}, {
  3.738655389678729*^9, 3.7386553899260273`*^9}, {3.7386663694882812`*^9, 
  3.738666402041275*^9}, {3.7386666812257576`*^9, 3.7386666911631937`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{{3.738423896407528*^9, 3.7384239659365773`*^9}, 
   3.7386664051938105`*^9, 3.738666692142568*^9, 3.7498554892669067`*^9}]
}, Open  ]],

Cell[TextData[{
 "Verify the degree 2 update expression for various values of ",
 StyleBox["n", "Input"],
 "."
}], "Text",
 CellChangeTimes->{{3.7384239773102007`*^9, 3.7384239801685266`*^9}, {
  3.738584170645599*^9, 3.7385841858709335`*^9}, {3.7386674684947643`*^9, 
  3.7386674827596455`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"S", "[", 
      RowBox[{
       RowBox[{"t", "+", "1"}], ",", "n", ",", "2"}], "]"}], "==", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"t", ",", "n", ",", "2"}], "]"}], "+", 
      RowBox[{"2", 
       RowBox[{"S", "[", 
        RowBox[{
         RowBox[{"t", "+", "1"}], ",", "n", ",", "1"}], "]"}]}], "-", 
      RowBox[{"S", "[", 
       RowBox[{
        RowBox[{"t", "+", "1"}], ",", "n", ",", "0"}], "]"}], "-", 
      RowBox[{
       SuperscriptBox["n", "2"], 
       SubscriptBox["y", 
        RowBox[{"t", "-", "n"}]]}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "5", ",", "20", ",", "5"}], "}"}]}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellChangeTimes->{{3.7384239879746594`*^9, 3.7384240152736797`*^9}, {
  3.7384241162368097`*^9, 3.7384242002182646`*^9}, {3.7386667610463333`*^9, 
  3.738666764373439*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{{3.7384241461597805`*^9, 3.738424163238124*^9}, {
   3.7384241942443533`*^9, 3.73842420151081*^9}, 3.7386667657367935`*^9, 
   3.7498554893068*^9}]
}, Open  ]],

Cell["Alternatively, the expression used in the Matlab code is:", "Text",
 CellChangeTimes->{{3.738667504609197*^9, 3.7386675073300056`*^9}, {
  3.7386690902291346`*^9, 3.7386691001516433`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{"t", ",", "n", ",", "2"}], "]"}], "+", 
   RowBox[{"2", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"t", ",", "n", ",", "1"}], "]"}], "+", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"S", "[", 
         RowBox[{"t", ",", "n", ",", "0"}], "]"}], "+", 
        SubscriptBox["y", "t"]}], ")"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], " ", 
       SubscriptBox["y", 
        RowBox[{"t", "-", "n"}]]}]}], ")"}]}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"S", "[", 
      RowBox[{"t", ",", "n", ",", "0"}], "]"}], "+", 
     SubscriptBox["y", "t"], "-", 
     SubscriptBox["y", 
      RowBox[{"t", "-", "n"}]]}], ")"}], "-", 
   RowBox[{
    SuperscriptBox["n", "2"], 
    SubscriptBox["y", 
     RowBox[{"t", "-", "n"}]]}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.7386668252516613`*^9, 3.738666836890576*^9}}],

Cell[BoxData[
 RowBox[{
  SubscriptBox["y", "t"], "-", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "n"}], ")"}], "2"], " ", 
   SubscriptBox["y", 
    RowBox[{
     RowBox[{"-", "n"}], "+", "t"}]]}], "+", 
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"i", "=", "1"}], "n"], 
   SubscriptBox["y", 
    RowBox[{
     RowBox[{"-", "i"}], "+", "t"}]]}], "+", 
  RowBox[{"2", " ", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"i", "=", "1"}], "n"], 
    RowBox[{"i", " ", 
     SubscriptBox["y", 
      RowBox[{
       RowBox[{"-", "i"}], "+", "t"}]]}]}]}], "+", 
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"i", "=", "1"}], "n"], 
   RowBox[{
    SuperscriptBox["i", "2"], " ", 
    SubscriptBox["y", 
     RowBox[{
      RowBox[{"-", "i"}], "+", "t"}]]}]}]}]], "Output",
 CellChangeTimes->{3.738666837585718*^9, 3.7498554893616533`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"S", "[", 
      RowBox[{
       RowBox[{"t", "+", "1"}], ",", "n", ",", "2"}], "]"}], "==", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"t", ",", "n", ",", "2"}], "]"}], "+", 
      RowBox[{"2", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"S", "[", 
          RowBox[{"t", ",", "n", ",", "1"}], "]"}], "+", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"S", "[", 
            RowBox[{"t", ",", "n", ",", "0"}], "]"}], "+", 
           SubscriptBox["y", "t"]}], ")"}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}], " ", 
          SubscriptBox["y", 
           RowBox[{"t", "-", "n"}]]}]}], ")"}]}], "-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"S", "[", 
         RowBox[{"t", ",", "n", ",", "0"}], "]"}], "+", 
        SubscriptBox["y", "t"], "-", 
        SubscriptBox["y", 
         RowBox[{"t", "-", "n"}]]}], ")"}], "-", 
      RowBox[{
       SuperscriptBox["n", "2"], 
       SubscriptBox["y", 
        RowBox[{"t", "-", "n"}]]}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "5", ",", "20", ",", "5"}], "}"}]}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellChangeTimes->{{3.7384239879746594`*^9, 3.7384240152736797`*^9}, {
   3.7384241162368097`*^9, 3.7384242002182646`*^9}, 3.7386665815871706`*^9, 
   3.73866661782827*^9, {3.738666716569333*^9, 3.7386667495680265`*^9}, {
   3.7386667813959403`*^9, 3.738666794526848*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.738666798278864*^9, 3.7498554893798475`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Lagged polynomial cross products of sparse vectors", "Section",
 CellChangeTimes->{{3.7008973590570135`*^9, 3.7008973626901226`*^9}, {
   3.7385837028067274`*^9, 3.738583752279063*^9}, 3.73867504280792*^9},
 CellTags->"polyCross"],

Cell[CellGroupData[{

Cell["Matrix construction", "Subsubsubsection",
 CellChangeTimes->{{3.738676173746882*^9, 3.738676176621197*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"X", ",", "Y", ",", "\[ScriptCapitalD]", ",", "tSum"}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.7005045007499976`*^9, 3.7005045041041503`*^9}, {
   3.700560235486764*^9, 3.7005602360866547`*^9}, {3.700560813022603*^9, 
   3.7005608198761835`*^9}, {3.7005614038650665`*^9, 
   3.7005614057132874`*^9}, {3.700592391240039*^9, 3.7005923935076685`*^9}, 
   3.738425341319806*^9, {3.7385844607158847`*^9, 3.738584461349695*^9}}],

Cell[TextData[{
 StyleBox["\[ScriptCapitalD]", "Code"],
 " denotes the coefficient (design) matrix for polynomials. (\
\[OpenCurlyDoubleQuote]D\[CloseCurlyDoubleQuote] is reserved in Mathematica \
for derivatives.)"
}], "Text",
 CellChangeTimes->{{3.7005924032064533`*^9, 3.700592411975373*^9}, {
  3.7383381461714754`*^9, 3.73833816448144*^9}, {3.738338201429666*^9, 
  3.7383382272875395`*^9}, {3.7486230040485363`*^9, 3.7486230246704264`*^9}, {
  3.7486230589627852`*^9, 3.748623066615343*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[ScriptCapitalD]", "[", 
    RowBox[{"n_", ",", "d_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      SuperscriptBox["i", "dd"], ",", 
      RowBox[{"{", 
       RowBox[{"dd", ",", "0", ",", "d"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}], "\[Transpose]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[ScriptCapitalD]", "[", 
   RowBox[{"4", ",", "2"}], "]"}], "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.700389961222083*^9, 3.7003900730443525`*^9}, {
  3.7003901287348814`*^9, 3.700390131266711*^9}, {3.7005014141302767`*^9, 
  3.700501414621386*^9}, {3.7005015654746847`*^9, 3.7005015655218015`*^9}, {
  3.700504450449894*^9, 3.700504533762871*^9}, {3.7005599891444373`*^9, 
  3.700560004862541*^9}, {3.7005602767940836`*^9, 3.7005602827990417`*^9}, {
  3.7005625704239063`*^9, 3.7005626034113226`*^9}, {3.701425790154955*^9, 
  3.7014258002916822`*^9}, {3.7384245256782937`*^9, 3.7384245266675997`*^9}, {
  3.7384253413357773`*^9, 3.738425341338732*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "1", "1"},
     {"1", "2", "4"},
     {"1", "3", "9"},
     {"1", "4", "16"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.700390030587242*^9, 3.700390047979124*^9}, {
   3.700390121650955*^9, 3.7003901321128535`*^9}, 3.700418118621559*^9, 
   3.7005012824697943`*^9, 3.7005013535366898`*^9, {3.7005014156747127`*^9, 
   3.7005014234576716`*^9}, {3.700501568127533*^9, 3.7005015798435507`*^9}, {
   3.700504496350236*^9, 3.7005045344311495`*^9}, 3.7005602543994007`*^9, 
   3.7005602904026117`*^9, 3.7005614126628156`*^9, 3.700561446593836*^9, {
   3.7005625816094947`*^9, 3.7005626038227005`*^9}, 3.700564284688489*^9, 
   3.700640008429888*^9, 3.700835049487897*^9, 3.7008351268468924`*^9, 
   3.701365889423476*^9, 3.701425801091937*^9, 3.701444796159536*^9, 
   3.7014478844321566`*^9, 3.738411935612152*^9, {3.738424515682934*^9, 
   3.738424529187826*^9}, 3.738584517527355*^9, 3.738669705987754*^9, 
   3.7386810863420534`*^9, 3.7498554894145117`*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["X[i,t]", "Input"],
 " is a matrix with \[ScriptCapitalT] rows, ",
 StyleBox["n", "Input"],
 " columns and an identity matrix starting in row ",
 StyleBox["i", "Input"],
 ". It represents a lag matrix, where a variable that appears in position ",
 Cell[BoxData[
  FormBox[
   RowBox[{"i", ",", "1"}], TraditionalForm]]],
 " also appears in position ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"i", "-", "1"}], ",", "2"}], TraditionalForm]]],
 ", position ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"i", "-", "2"}], ",", "3"}], TraditionalForm]]],
 ", ... position ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"i", "-", "n", "+", "1"}], ",", "n"}], TraditionalForm]]],
 ". (The Mathematica ",
 StyleBox["Block", "Input"],
 " construct is used to localize the assignment ",
 StyleBox["\[ScriptCapitalT]=8", "Code"],
 ".)"
}], "Text",
 CellChangeTimes->{{3.7005924371562705`*^9, 3.7005924618303566`*^9}, {
   3.7008971269207706`*^9, 3.7008972925116124`*^9}, 3.7383385716418376`*^9, {
   3.738599830219225*^9, 3.7385998924807763`*^9}, {3.738667597733204*^9, 
   3.738667606403023*^9}, {3.7486231500304227`*^9, 3.74862327053799*^9}, {
   3.7486233197695274`*^9, 3.748623326868555*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"X", "[", 
    RowBox[{"i_", ",", "n_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "x", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"x", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"0", ",", 
         RowBox[{"{", "\[ScriptCapitalT]", "}"}], ",", 
         RowBox[{"{", "n", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"i", "+", "n", "-", "1"}], ">", "\[ScriptCapitalT]"}], ",", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{
          "\"\<X[i,n]: i+n-1>\[ScriptCapitalT] (i=\>\"", ",", "i", ",", 
           "\"\<; n=\>\"", ",", "n", ",", "\"\<; \[ScriptCapitalT]=\>\"", ",",
            "\[ScriptCapitalT]", ",", "\"\<)\>\""}], "]"}], ";", 
         RowBox[{"Return", "[", "Null", "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"x", "[", 
        RowBox[{"[", 
         RowBox[{"i", ";;", 
          RowBox[{"i", "+", "n", "-", "1"}]}], "]"}], "]"}], "=", 
       RowBox[{"IdentityMatrix", "[", "n", "]"}]}], ";", 
      "\[IndentingNewLine]", "x"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\[ScriptCapitalT]", "=", "8"}], "}"}], ",", 
    RowBox[{"X", "[", 
     RowBox[{"3", ",", "4"}], "]"}]}], "]"}], "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.7005042827422953`*^9, 3.700504332657745*^9}, {
   3.7005044016104527`*^9, 3.700504414908393*^9}, {3.7005600256315794`*^9, 
   3.700560027180806*^9}, 3.7005626206930823`*^9, {3.7005635724877605`*^9, 
   3.700563602792641*^9}, {3.700563927498418*^9, 3.7005640429697943`*^9}, {
   3.7006402193638287`*^9, 3.7006402418573446`*^9}, {3.7006404139978247`*^9, 
   3.7006404146667147`*^9}, {3.7008348616624813`*^9, 3.700834862793013*^9}, {
   3.7008350149863777`*^9, 3.700835065056046*^9}, {3.700835106911061*^9, 
   3.700835119695188*^9}, {3.7014446131282454`*^9, 3.701444613159667*^9}, {
   3.7014446500080404`*^9, 3.7014447559648175`*^9}, {3.7014461610634212`*^9, 
   3.7014462102795973`*^9}, {3.701446333958753*^9, 3.7014463365753117`*^9}, {
   3.7383385737761655`*^9, 3.7383385814407234`*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "0", "0", "0"},
     {"0", "0", "0", "0"},
     {"1", "0", "0", "0"},
     {"0", "1", "0", "0"},
     {"0", "0", "1", "0"},
     {"0", "0", "0", "1"},
     {"0", "0", "0", "0"},
     {"0", "0", "0", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.700640245210099*^9, {3.7008350495412846`*^9, 3.700835110335779*^9}, 
   3.70136588942848*^9, 3.7014446182445006`*^9, {3.701444735697794*^9, 
   3.7014447566646585`*^9}, 3.701446211363533*^9, 3.7014463393909674`*^9, 
   3.701447884463422*^9, 3.7383440824518747`*^9, 3.7384065399808426`*^9, 
   3.738584532909972*^9, 3.7386697060076656`*^9, 3.738681086358051*^9, 
   3.74985548944144*^9}]
}, Open  ]],

Cell[TextData[{
 "Define ",
 Cell[BoxData[
  FormBox["Y", TraditionalForm]],
  FormatType->"TraditionalForm"],
 " similarly:"
}], "Text",
 CellChangeTimes->{{3.738584416390865*^9, 3.738584429216914*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Y", "[", 
   RowBox[{"i_", ",", "n_"}], "]"}], ":=", 
  RowBox[{"X", "[", 
   RowBox[{"i", ",", "n"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.738584432890863*^9, 3.738584451807982*^9}}],

Cell["and", "Text",
 CellChangeTimes->{{3.738681202467577*^9, 3.738681202800665*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Ones", ":=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "\[ScriptCapitalT]", "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\[ScriptCapitalT]", "=", "8"}], "}"}], ",", "Ones"}], "]"}], "//",
   "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.738681209466841*^9, 3.7386812822123337`*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1"},
     {"1"},
     {"1"},
     {"1"},
     {"1"},
     {"1"},
     {"1"},
     {"1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.7386812700957313`*^9, 3.7386812828177953`*^9}, 
   3.749855489476347*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Matrices used in text examples:", "Subsubsubsection",
 CellChangeTimes->{{3.738424484435489*^9, 3.7384244920511427`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[ScriptCapitalT]", "=", "12"}], ",", 
     RowBox[{"\[ScriptCapitalL]", "=", "4"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"x1", "=", 
     RowBox[{"X", "[", 
      RowBox[{"2", ",", "\[ScriptCapitalL]"}], "]"}]}], ";", 
    RowBox[{"x2", "=", 
     RowBox[{"X", "[", 
      RowBox[{"4", ",", "\[ScriptCapitalL]"}], "]"}]}], ";", 
    RowBox[{"x3", "=", 
     RowBox[{"X", "[", 
      RowBox[{"8", ",", "\[ScriptCapitalL]"}], "]"}]}], ";", 
    RowBox[{"r", "=", 
     RowBox[{
      RowBox[{"4", "*", "x1"}], "+", 
      RowBox[{"2", "*", "x2"}], "+", 
      RowBox[{"5", "*", "x3"}]}]}], ";", 
    RowBox[{"MatrixForm", "/@", 
     RowBox[{"{", 
      RowBox[{"x1", ",", "x2", ",", "x3", ",", "r"}], "}"}]}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7383438971473975`*^9, 3.738344077905445*^9}, {
  3.738344124663262*^9, 3.7383441529498672`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0", "0"},
       {"1", "0", "0", "0"},
       {"0", "1", "0", "0"},
       {"0", "0", "1", "0"},
       {"0", "0", "0", "1"},
       {"0", "0", "0", "0"},
       {"0", "0", "0", "0"},
       {"0", "0", "0", "0"},
       {"0", "0", "0", "0"},
       {"0", "0", "0", "0"},
       {"0", "0", "0", "0"},
       {"0", "0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0", "0"},
       {"0", "0", "0", "0"},
       {"0", "0", "0", "0"},
       {"1", "0", "0", "0"},
       {"0", "1", "0", "0"},
       {"0", "0", "1", "0"},
       {"0", "0", "0", "1"},
       {"0", "0", "0", "0"},
       {"0", "0", "0", "0"},
       {"0", "0", "0", "0"},
       {"0", "0", "0", "0"},
       {"0", "0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0", "0"},
       {"0", "0", "0", "0"},
       {"0", "0", "0", "0"},
       {"0", "0", "0", "0"},
       {"0", "0", "0", "0"},
       {"0", "0", "0", "0"},
       {"0", "0", "0", "0"},
       {"1", "0", "0", "0"},
       {"0", "1", "0", "0"},
       {"0", "0", "1", "0"},
       {"0", "0", "0", "1"},
       {"0", "0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0", "0"},
       {"4", "0", "0", "0"},
       {"0", "4", "0", "0"},
       {"2", "0", "4", "0"},
       {"0", "2", "0", "4"},
       {"0", "0", "2", "0"},
       {"0", "0", "0", "2"},
       {"5", "0", "0", "0"},
       {"0", "5", "0", "0"},
       {"0", "0", "5", "0"},
       {"0", "0", "0", "5"},
       {"0", "0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 CellChangeTimes->{3.738344087470518*^9, 3.7383441539031887`*^9, 
  3.738669706051589*^9, 3.749855489585056*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[ScriptCapitalT]", "=", "10"}], ",", 
     RowBox[{"\[ScriptCapitalL]", "=", "3"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"x1", "=", 
     RowBox[{"X", "[", 
      RowBox[{"2", ",", "\[ScriptCapitalL]"}], "]"}]}], ";", 
    RowBox[{"x2", "=", 
     RowBox[{"X", "[", 
      RowBox[{"5", ",", "\[ScriptCapitalL]"}], "]"}]}], ";", 
    RowBox[{"x3", "=", 
     RowBox[{"X", "[", 
      RowBox[{"8", ",", "\[ScriptCapitalL]"}], "]"}]}], ";", 
    RowBox[{"r", "=", 
     RowBox[{
      RowBox[{"4", "*", "x1"}], "+", 
      RowBox[{"2", "*", "x2"}], "+", 
      RowBox[{"5", "*", "x3"}]}]}], ";", 
    RowBox[{"MatrixForm", "/@", 
     RowBox[{"{", 
      RowBox[{"r", ",", "x1", ",", "x2", ",", "x3"}], "}"}]}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7383438971473975`*^9, 3.738344077905445*^9}, {
  3.738344124663262*^9, 3.7383441529498672`*^9}, {3.738344645110588*^9, 
  3.738344676139532*^9}, {3.738345054133832*^9, 3.738345057308191*^9}, {
  3.7384065146645136`*^9, 3.738406515685772*^9}, {3.738406577955296*^9, 
  3.7384065970931363`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"4", "0", "0"},
       {"0", "4", "0"},
       {"0", "0", "4"},
       {"2", "0", "0"},
       {"0", "2", "0"},
       {"0", "0", "2"},
       {"5", "0", "0"},
       {"0", "5", "0"},
       {"0", "0", "5"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"1", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "1"},
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"1", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "1"},
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"1", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 CellChangeTimes->{{3.738344646141681*^9, 3.7383446766538353`*^9}, 
   3.73834505930647*^9, {3.738406525205329*^9, 3.7384065476483164`*^9}, {
   3.7384065816793528`*^9, 3.7384065996622815`*^9}, 3.738669706076482*^9, 
   3.7498554896089907`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[ScriptCapitalT]", "=", "10"}], "}"}], ",", 
   RowBox[{
    RowBox[{"x", "=", 
     RowBox[{"X", "[", 
      RowBox[{"2", ",", "3"}], "]"}]}], ";", 
    RowBox[{"y", "=", 
     RowBox[{"X", "[", 
      RowBox[{"3", ",", "4"}], "]"}]}], ";", 
    RowBox[{"xty", "=", 
     RowBox[{
      RowBox[{"x", "\[Transpose]"}], ".", "y"}]}], ";", 
    RowBox[{"MatrixForm", "/@", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "xty"}], "}"}]}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7383438971473975`*^9, 3.738344077905445*^9}, {
  3.738344124663262*^9, 3.7383441529498672`*^9}, {3.738344645110588*^9, 
  3.738344676139532*^9}, {3.738345054133832*^9, 3.738345057308191*^9}, {
  3.7384065146645136`*^9, 3.738406515685772*^9}, {3.738406577955296*^9, 
  3.7384065970931363`*^9}, {3.738409455152173*^9, 3.7384095809080677`*^9}, {
  3.7384097734264064`*^9, 3.7384097757511916`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"1", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "1"},
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0", "0"},
       {"0", "0", "0", "0"},
       {"1", "0", "0", "0"},
       {"0", "1", "0", "0"},
       {"0", "0", "1", "0"},
       {"0", "0", "0", "1"},
       {"0", "0", "0", "0"},
       {"0", "0", "0", "0"},
       {"0", "0", "0", "0"},
       {"0", "0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0", "0"},
       {"1", "0", "0", "0"},
       {"0", "1", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 CellChangeTimes->{3.738409582951538*^9, 3.738409827949641*^9, 
  3.7386697061014557`*^9, 3.749855489632928*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[ScriptCapitalD]", "[", 
     RowBox[{"3", ",", "1"}], "]"}], ",", 
    RowBox[{"\[ScriptCapitalD]", "[", 
     RowBox[{"4", ",", "1"}], "]"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"\[ScriptCapitalD]", "[", 
       RowBox[{"3", ",", "1"}], "]"}], "\[Transpose]"}], ".", 
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"0", "0", "0", "0"},
        {"1", "0", "0", "0"},
        {"0", "1", "0", "0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], ".", 
     RowBox[{"\[ScriptCapitalD]", "[", 
      RowBox[{"4", ",", "1"}], "]"}]}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.738412018639199*^9, 3.738412112460361*^9}, {
  3.7384245639010277`*^9, 3.738424567777701*^9}, {3.7384253413566923`*^9, 
  3.738425341361701*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "1"},
       {"1", "2"},
       {"1", "3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "1"},
       {"1", "2"},
       {"1", "3"},
       {"1", "4"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2", "3"},
       {"5", "8"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 CellChangeTimes->{3.7384121133041053`*^9, 3.7384245695778522`*^9, 
  3.738669706127429*^9, 3.7498554896558657`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[ScriptCapitalD]", "[", 
     RowBox[{"3", ",", "2"}], "]"}], ",", 
    RowBox[{"\[ScriptCapitalD]", "[", 
     RowBox[{"4", ",", "2"}], "]"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"\[ScriptCapitalD]", "[", 
       RowBox[{"3", ",", "2"}], "]"}], "\[Transpose]"}], ".", 
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"0", "0", "0", "0"},
        {"1", "0", "0", "0"},
        {"0", "1", "0", "0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], ".", 
     RowBox[{"\[ScriptCapitalD]", "[", 
      RowBox[{"4", ",", "2"}], "]"}]}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.738412018639199*^9, 3.738412112460361*^9}, {
  3.7384133919929843`*^9, 3.738413404053698*^9}, {3.738424595296132*^9, 
  3.738424599348301*^9}, {3.7384253414055977`*^9, 3.7384253414125347`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "1", "1"},
       {"1", "2", "4"},
       {"1", "3", "9"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "1", "1"},
       {"1", "2", "4"},
       {"1", "3", "9"},
       {"1", "4", "16"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2", "3", "5"},
       {"5", "8", "14"},
       {"13", "22", "40"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 CellChangeTimes->{3.7384121133041053`*^9, 3.738413406117182*^9, 
  3.7384246011883574`*^9, 3.7386697061493444`*^9, 3.749855489677806*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Continuation", "Subsubsubsection",
 CellChangeTimes->{{3.7384246397961707`*^9, 3.7384246425467944`*^9}, {
  3.7385843178475857`*^9, 3.7385843231885195`*^9}, {3.7386688079087043`*^9, 
  3.7386688142048707`*^9}}],

Cell[TextData[{
 "The result matrix is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[ScriptCapitalD]", "x"], "\[Transpose]"}], ".", 
    RowBox[{"X", "\[Transpose]"}], ".", "Y", ".", 
    SubscriptBox["\[ScriptCapitalD]", "y"]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ". The following depicts the pieces and final result in the case of fixed \
values for ",
 StyleBox["\[ScriptCapitalT]", "Input"],
 ", ",
 StyleBox["\[ScriptCapitalL]x", "Input"],
 ", and ",
 StyleBox["\[ScriptCapitalL]y", "Input"],
 "; for ",
 StyleBox["X[5,\[ScriptCapitalL]x]", "Input"],
 " and ",
 StyleBox["Y[j,\[ScriptCapitalL]y]", "Input"],
 " where ",
 StyleBox["j", "Input"],
 " goes from 2 to 9."
}], "Text",
 CellChangeTimes->{{3.700592517928095*^9, 3.7005925387056727`*^9}, {
   3.738425242541812*^9, 3.7384252457881327`*^9}, 3.738425341534209*^9, {
   3.738425372018715*^9, 3.7384253761496706`*^9}, {3.738584565976985*^9, 
   3.7385846494114466`*^9}, {3.738585572297617*^9, 3.7385857863077435`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[ScriptCapitalT]", "=", "12"}], ",", 
      RowBox[{"\[ScriptCapitalL]x", "=", "4"}], ",", 
      RowBox[{"\[ScriptCapitalL]y", "=", "3"}]}], "}"}], ",", "\n", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"j", ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"X", "[", 
            RowBox[{"5", ",", "\[ScriptCapitalL]x"}], "]"}], "//", 
           "MatrixForm"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Y", "[", 
            RowBox[{"j", ",", "\[ScriptCapitalL]y"}], "]"}], "//", 
           "MatrixForm"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"X", "[", 
              RowBox[{"5", ",", "\[ScriptCapitalL]x"}], "]"}], 
             "\[Transpose]"}], ".", 
            RowBox[{"Y", "[", 
             RowBox[{"j", ",", "\[ScriptCapitalL]y"}], "]"}]}], "//", 
           "MatrixForm"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"\[ScriptCapitalD]", "[", 
              RowBox[{"\[ScriptCapitalL]x", ",", "2"}], "]"}], 
             "\[Transpose]"}], ".", 
            RowBox[{
             RowBox[{"X", "[", 
              RowBox[{"5", ",", "\[ScriptCapitalL]x"}], "]"}], 
             "\[Transpose]"}], ".", 
            RowBox[{"X", "[", 
             RowBox[{"j", ",", "\[ScriptCapitalL]y"}], "]"}], ".", 
            RowBox[{"\[ScriptCapitalD]", "[", 
             RowBox[{"\[ScriptCapitalL]y", ",", "2"}], "]"}]}], "//", 
           "MatrixForm"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "2", ",", "9"}], "}"}]}], "]"}], "//", 
      "Transpose"}], "//", "TableForm"}]}], "]"}], "//", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{"#", ",", 
     RowBox[{"FontSize", "\[Rule]", "9"}]}], "]"}], "&"}]}]], "Input",
 CellChangeTimes->{{3.7005046270755134`*^9, 3.7005046302892895`*^9}, 
   3.7005601069945297`*^9, {3.7005602999406877`*^9, 3.7005603147630186`*^9}, {
   3.7008352554128923`*^9, 3.700835309445223*^9}, {3.700835472991358*^9, 
   3.7008354777213354`*^9}, {3.7014447761150436`*^9, 3.7014447853152046`*^9}, 
   3.7383385825337625`*^9, {3.7384247364886465`*^9, 3.738424745336994*^9}, {
   3.7384253408330836`*^9, 3.7384253408391247`*^9}, 3.7385843817744465`*^9, {
   3.738584656213047*^9, 3.7385846726749077`*^9}, {3.738584722846404*^9, 
   3.738584725057638*^9}, {3.7385847573174033`*^9, 3.738584774638065*^9}, {
   3.738584836601948*^9, 3.7385848793902483`*^9}, {3.7385849103002424`*^9, 
   3.738584912635271*^9}, {3.7385849546175385`*^9, 3.738584956837777*^9}, {
   3.7385850006741486`*^9, 3.7385850673373933`*^9}, {3.738585319660596*^9, 
   3.7385854520586357`*^9}, {3.738585509299018*^9, 3.738585543617815*^9}, {
   3.73860059772311*^9, 3.7386006181015882`*^9}}],

Cell[BoxData[
 StyleBox[
  TagBox[GridBox[{
     {"2", "3", "4", "5", "6", "7", "8", "9"},
     {
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"1", "0", "0", "0"},
          {"0", "1", "0", "0"},
          {"0", "0", "1", "0"},
          {"0", "0", "0", "1"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"1", "0", "0", "0"},
          {"0", "1", "0", "0"},
          {"0", "0", "1", "0"},
          {"0", "0", "0", "1"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"1", "0", "0", "0"},
          {"0", "1", "0", "0"},
          {"0", "0", "1", "0"},
          {"0", "0", "0", "1"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"1", "0", "0", "0"},
          {"0", "1", "0", "0"},
          {"0", "0", "1", "0"},
          {"0", "0", "0", "1"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"1", "0", "0", "0"},
          {"0", "1", "0", "0"},
          {"0", "0", "1", "0"},
          {"0", "0", "0", "1"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"1", "0", "0", "0"},
          {"0", "1", "0", "0"},
          {"0", "0", "1", "0"},
          {"0", "0", "0", "1"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"1", "0", "0", "0"},
          {"0", "1", "0", "0"},
          {"0", "0", "1", "0"},
          {"0", "0", "0", "1"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"1", "0", "0", "0"},
          {"0", "1", "0", "0"},
          {"0", "0", "1", "0"},
          {"0", "0", "0", "1"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"},
          {"0", "0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]]},
     {
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"1", "0", "0"},
          {"0", "1", "0"},
          {"0", "0", "1"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"1", "0", "0"},
          {"0", "1", "0"},
          {"0", "0", "1"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"1", "0", "0"},
          {"0", "1", "0"},
          {"0", "0", "1"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"1", "0", "0"},
          {"0", "1", "0"},
          {"0", "0", "1"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"1", "0", "0"},
          {"0", "1", "0"},
          {"0", "0", "1"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"1", "0", "0"},
          {"0", "1", "0"},
          {"0", "0", "1"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"1", "0", "0"},
          {"0", "1", "0"},
          {"0", "0", "1"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"1", "0", "0"},
          {"0", "1", "0"},
          {"0", "0", "1"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]]},
     {
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "1"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "1", "0"},
          {"0", "0", "1"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"1", "0", "0"},
          {"0", "1", "0"},
          {"0", "0", "1"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"1", "0", "0"},
          {"0", "1", "0"},
          {"0", "0", "1"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"1", "0", "0"},
          {"0", "1", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"1", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]]},
     {
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"1", "3", "9"},
          {"1", "3", "9"},
          {"1", "3", "9"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"2", "5", "13"},
          {"3", "8", "22"},
          {"5", "14", "40"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"3", "6", "14"},
          {"6", "14", "36"},
          {"14", "36", "98"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"3", "6", "14"},
          {"9", "20", "50"},
          {"29", "70", "184"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"2", "3", "5"},
          {"7", "11", "19"},
          {"25", "41", "73"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"1", "1", "1"},
          {"4", "4", "4"},
          {"16", "16", "16"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[2.0999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Function[BoxForm`e$, 
    TableForm[BoxForm`e$]]],
  StripOnInput->False,
  FontSize->9]], "Output",
 CellChangeTimes->{
  3.7005601164405994`*^9, 3.700560254446298*^9, {3.700560290435871*^9, 
   3.7005603201760836`*^9}, 3.70056141270258*^9, 3.7005614466476526`*^9, 
   3.7005642847347736`*^9, 3.700640008477354*^9, {3.7008352840675554`*^9, 
   3.700835309976467*^9}, 3.701365889459738*^9, {3.701444788961384*^9, 
   3.701444799298194*^9}, 3.7014478845011654`*^9, 3.7384247495986433`*^9, 
   3.738585073207594*^9, {3.7385853863851714`*^9, 3.738585396419026*^9}, {
   3.738585438344816*^9, 3.7385854531756935`*^9}, {3.738585525565342*^9, 
   3.7385855444973454`*^9}, 3.7386006193383102`*^9, 3.738669706188219*^9, 
   3.7498554897476215`*^9}]
}, Open  ]],

Cell["\<\
Depending on the relative offset between the X and Y matrices, the X\
\[Transpose]Y product is a diagonal band of ones that moves from top/right to \
bottom/left.\
\>", "Text",
 CellChangeTimes->{{3.738585886839026*^9, 3.738585977497529*^9}, {
  3.748624659304101*^9, 3.7486246601538477`*^9}}],

Cell[TextData[{
 "Here is an alternative calculation. ",
 StyleBox["i", "Input"],
 " indicates the location of the identity matrix in ",
 StyleBox["X", "Input"],
 ", and ",
 StyleBox["j", "Input"],
 " indicates the location for ",
 StyleBox["Y", "Input"],
 "."
}], "Text",
 CellChangeTimes->{{3.7008361500474014`*^9, 3.7008361621132603`*^9}, {
   3.738586009184319*^9, 3.7385860643622494`*^9}, {3.7385861028731594`*^9, 
   3.738586107619934*^9}, {3.7385862983486166`*^9, 3.7385863024469433`*^9}, {
   3.738588566027667*^9, 3.738588609446912*^9}, {3.7385953921754065`*^9, 
   3.7385954026294556`*^9}, 3.7385954361358643`*^9, {3.738673430180328*^9, 
   3.7386734467809024`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"CP0", "[", 
    RowBox[{
    "i_", ",", "j_", ",", "\[ScriptCapitalL]x_", ",", "\[ScriptCapitalL]y_"}],
     "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"k", ",", "ka", ",", "kb", ",", "z"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"z", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"0", ",", 
         RowBox[{"{", "3", "}"}], ",", 
         RowBox[{"{", "3", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"k", "=", 
       RowBox[{"j", "-", "i"}]}], ";", " ", 
      RowBox[{"(*", "offset", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"ka", "=", 
       RowBox[{"Max", "[", 
        RowBox[{"1", ",", 
         RowBox[{"k", "+", "1"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"kb", "=", 
       RowBox[{"Min", "[", 
        RowBox[{"\[ScriptCapitalL]x", ",", 
         RowBox[{"\[ScriptCapitalL]y", "+", "k"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"ka", ">", "kb"}], ",", 
        RowBox[{"Return", "[", "z", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{
           SuperscriptBox["ii", "d1"], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"ii", "-", "k"}], ")"}], "d2"]}], ",", 
          RowBox[{"{", 
           RowBox[{"ii", ",", "ka", ",", "kb"}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"d1", ",", "0", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"d2", ",", "0", ",", "2"}], "}"}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"j", ",", 
        RowBox[{
         RowBox[{"CP0", "[", 
          RowBox[{"5", ",", "j", ",", "4", ",", "3"}], "]"}], "//", 
         "MatrixForm"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "2", ",", "9"}], "}"}]}], "]"}], "//", "Transpose"}],
    "//", "TableForm"}], "//", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{"#", ",", 
     RowBox[{"FontSize", "\[Rule]", "10"}]}], "]"}], "&"}]}]}], "Input",
 CellChangeTimes->{{3.7008356934298296`*^9, 3.7008357490046463`*^9}, {
  3.7008357922433014`*^9, 3.7008361293026695`*^9}, {3.7385861696921034`*^9, 
  3.7385862006682253`*^9}, {3.738586242930647*^9, 3.7385862549392366`*^9}, {
  3.738595378286542*^9, 3.7385953841179495`*^9}, {3.7386006391303616`*^9, 
  3.738600653027214*^9}, {3.749856136511363*^9, 3.7498561524357605`*^9}}],

Cell[BoxData[
 StyleBox[
  TagBox[GridBox[{
     {"2", "3", "4", "5", "6", "7", "8", "9"},
     {
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"1", "3", "9"},
          {"1", "3", "9"},
          {"1", "3", "9"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"2", "5", "13"},
          {"3", "8", "22"},
          {"5", "14", "40"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"3", "6", "14"},
          {"6", "14", "36"},
          {"14", "36", "98"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"3", "6", "14"},
          {"9", "20", "50"},
          {"29", "70", "184"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"2", "3", "5"},
          {"7", "11", "19"},
          {"25", "41", "73"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"1", "1", "1"},
          {"4", "4", "4"},
          {"16", "16", "16"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[2.0999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Function[BoxForm`e$, 
    TableForm[BoxForm`e$]]],
  StripOnInput->False,
  FontSize->10]], "Output",
 CellChangeTimes->{{3.70083591451462*^9, 3.7008359922010193`*^9}, {
   3.7008360694404273`*^9, 3.700836131402504*^9}, 3.701365889506612*^9, 
   3.7014448339433184`*^9, 3.701447884563691*^9, 3.7384247655669374`*^9, 
   3.7385862572728944`*^9, 3.7386006540415215`*^9, 3.7386697062111216`*^9, 
   3.7498554898004794`*^9, {3.7498561442835693`*^9, 3.749856154592989*^9}}]
}, Open  ]],

Cell[TextData[{
 "In ",
 StyleBox["CP0 ", "Input"],
 "the geometric sums in the matrix given by "
}], "Text",
 CellChangeTimes->{{3.7385863344855022`*^9, 3.73858636212938*^9}, {
  3.7385863980427446`*^9, 3.738586461656946*^9}, {3.7385884763069143`*^9, 
  3.7385885402287607`*^9}, {3.738668372304158*^9, 3.738668494290269*^9}, {
  3.7386685282424774`*^9, 3.7386685932815747`*^9}}],

Cell[TextData[Cell[BoxData[
 StyleBox[
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{
       SuperscriptBox["ii", "d1"], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"ii", "-", "k"}], ")"}], "d2"]}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "ka", ",", "kb"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"d1", ",", "0", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"d2", ",", "0", ",", "2"}], "}"}]}], "]"}], "Input"]],
 CellChangeTimes->{{3.7008356934298296`*^9, 3.7008357490046463`*^9}, {
  3.7008357922433014`*^9, 3.7008361293026695`*^9}, {3.7385861696921034`*^9, 
  3.7385862006682253`*^9}, {3.738586242930647*^9, 3.7385862549392366`*^9}, {
  3.738595378286542*^9, 3.7385953841179495`*^9}, {3.7386006391303616`*^9, 
  3.738600653027214*^9}}]], "Text",
 CellChangeTimes->{{3.7385863344855022`*^9, 3.73858636212938*^9}, {
  3.7385863980427446`*^9, 3.738586461656946*^9}, {3.7385884763069143`*^9, 
  3.7385885402287607`*^9}, {3.738668372304158*^9, 3.738668494290269*^9}, {
  3.7386685282424774`*^9, 3.738668579332946*^9}},
 TextAlignment->Center],

Cell[TextData[{
 "are evaluated in full form (with the number of iterations approximately \
equal to ",
 StyleBox["Min[\[ScriptCapitalL]x, \[ScriptCapitalL]y])", "Input"],
 ". It is very useful to have closed-form representations for these sums. \
Below is a grid with rows indexed by ",
 StyleBox["d1", "Input"],
 " and columns indexed by ",
 StyleBox["d2", "Input"],
 "."
}], "Text",
 CellChangeTimes->{{3.7385863344855022`*^9, 3.73858636212938*^9}, {
  3.7385863980427446`*^9, 3.738586461656946*^9}, {3.7385884763069143`*^9, 
  3.7385885402287607`*^9}, {3.738668372304158*^9, 3.738668494290269*^9}, {
  3.7386685282424774`*^9, 3.7386685664433346`*^9}, {3.738668599458069*^9, 
  3.7386686315313096`*^9}, {3.7386686854521303`*^9, 3.738668685953796*^9}, {
  3.7486234552195587`*^9, 3.7486235004167776`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"i", ",", "k", ",", "ka", ",", "kb", ",", "ia", ",", "ib"}], "]"}],
   ";"}]], "Input",
 CellChangeTimes->{{3.7008469610184755`*^9, 3.7008469713669806`*^9}, {
  3.700847039784319*^9, 3.7008470410311346`*^9}, {3.700856807385998*^9, 
  3.700856809650346*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        SuperscriptBox["i", "d1"], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"i", "-", "k"}], ")"}], "d2"]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "ia", ",", "ib"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"d1", ",", "0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d2", ",", "0", ",", "2"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.7008468999679585`*^9, 3.700846954468771*^9}, {
   3.7008470038197594`*^9, 3.7008470321160307`*^9}, {3.700847062668159*^9, 
   3.700847133845333*^9}, {3.7008477510133386`*^9, 3.7008477674785724`*^9}, {
   3.700856815033611*^9, 3.7008568222329345`*^9}, {3.701448278190287*^9, 
   3.7014482937567434`*^9}, {3.701448520224619*^9, 3.7014485323536425`*^9}, {
   3.7386677461184635`*^9, 3.7386677522061768`*^9}, {3.73866792229539*^9, 
   3.738667924268116*^9}, 3.738668199958974*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"t", ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"ItemStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"FontSize", "\[Rule]", "12"}], "}"}]}], ",", 
   RowBox[{"ItemSize", "\[Rule]", "13"}], ",", 
   RowBox[{"Alignment", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Center", ",", "Center"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7386679306829987`*^9, 3.7386679550379243`*^9}, {
  3.738668013595273*^9, 3.738668042301526*^9}, {3.738668072824988*^9, 
  3.7386681125427084`*^9}, {3.738668170102832*^9, 3.7386681891808343`*^9}, {
  3.7386682721819096`*^9, 3.73866829987982*^9}, {3.749855519719472*^9, 
  3.7498555246013775`*^9}, {3.7498556376499443`*^9, 3.7498556397832365`*^9}, {
  3.749856558527005*^9, 3.7498565688434067`*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"1", "-", "ia", "+", "ib"}], 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "ia", "-", "ib"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"ia", "+", "ib", "-", 
        RowBox[{"2", " ", "k"}]}], ")"}]}], 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "6"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "ia", "-", "ib"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "ia"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["ia", "2"]}], "+", "ib", "+", 
        RowBox[{"2", " ", "ia", " ", "ib"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["ib", "2"]}], "-", 
        RowBox[{"6", " ", "ia", " ", "k"}], "-", 
        RowBox[{"6", " ", "ib", " ", "k"}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["k", "2"]}]}], ")"}]}]},
    {
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "ia", "-", "ib"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"ia", "+", "ib"}], ")"}]}], 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "6"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "ia", "-", "ib"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "ia"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["ia", "2"]}], "+", "ib", "+", 
        RowBox[{"2", " ", "ia", " ", "ib"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["ib", "2"]}], "-", 
        RowBox[{"3", " ", "ia", " ", "k"}], "-", 
        RowBox[{"3", " ", "ib", " ", "k"}]}], ")"}]}], 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "12"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "ia", "-", "ib"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         SuperscriptBox["ia", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["ia", "3"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["ia", "2"], " ", "ib"}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["ib", "2"]}], "+", 
        RowBox[{"3", " ", "ia", " ", 
         SuperscriptBox["ib", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["ib", "3"]}], "+", 
        RowBox[{"4", " ", "ia", " ", "k"}], "-", 
        RowBox[{"8", " ", 
         SuperscriptBox["ia", "2"], " ", "k"}], "-", 
        RowBox[{"4", " ", "ib", " ", "k"}], "-", 
        RowBox[{"8", " ", "ia", " ", "ib", " ", "k"}], "-", 
        RowBox[{"8", " ", 
         SuperscriptBox["ib", "2"], " ", "k"}], "+", 
        RowBox[{"6", " ", "ia", " ", 
         SuperscriptBox["k", "2"]}], "+", 
        RowBox[{"6", " ", "ib", " ", 
         SuperscriptBox["k", "2"]}]}], ")"}]}]},
    {
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "6"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "ia", "-", "ib"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "ia"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["ia", "2"]}], "+", "ib", "+", 
        RowBox[{"2", " ", "ia", " ", "ib"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["ib", "2"]}]}], ")"}]}], 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "12"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "ia", "-", "ib"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         SuperscriptBox["ia", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["ia", "3"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["ia", "2"], " ", "ib"}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["ib", "2"]}], "+", 
        RowBox[{"3", " ", "ia", " ", 
         SuperscriptBox["ib", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["ib", "3"]}], "+", 
        RowBox[{"2", " ", "ia", " ", "k"}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["ia", "2"], " ", "k"}], "-", 
        RowBox[{"2", " ", "ib", " ", "k"}], "-", 
        RowBox[{"4", " ", "ia", " ", "ib", " ", "k"}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["ib", "2"], " ", "k"}]}], ")"}]}], 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "30"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "ia", "-", "ib"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"ia", "+", 
        SuperscriptBox["ia", "2"], "-", 
        RowBox[{"9", " ", 
         SuperscriptBox["ia", "3"]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["ia", "4"]}], "-", "ib", "-", 
        RowBox[{"2", " ", "ia", " ", "ib"}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["ia", "2"], " ", "ib"}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["ia", "3"], " ", "ib"}], "+", 
        SuperscriptBox["ib", "2"], "+", 
        RowBox[{"3", " ", "ia", " ", 
         SuperscriptBox["ib", "2"]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["ia", "2"], " ", 
         SuperscriptBox["ib", "2"]}], "+", 
        RowBox[{"9", " ", 
         SuperscriptBox["ib", "3"]}], "+", 
        RowBox[{"6", " ", "ia", " ", 
         SuperscriptBox["ib", "3"]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["ib", "4"]}], "+", 
        RowBox[{"15", " ", 
         SuperscriptBox["ia", "2"], " ", "k"}], "-", 
        RowBox[{"15", " ", 
         SuperscriptBox["ia", "3"], " ", "k"}], "-", 
        RowBox[{"15", " ", 
         SuperscriptBox["ia", "2"], " ", "ib", " ", "k"}], "-", 
        RowBox[{"15", " ", 
         SuperscriptBox["ib", "2"], " ", "k"}], "-", 
        RowBox[{"15", " ", "ia", " ", 
         SuperscriptBox["ib", "2"], " ", "k"}], "-", 
        RowBox[{"15", " ", 
         SuperscriptBox["ib", "3"], " ", "k"}], "-", 
        RowBox[{"5", " ", "ia", " ", 
         SuperscriptBox["k", "2"]}], "+", 
        RowBox[{"10", " ", 
         SuperscriptBox["ia", "2"], " ", 
         SuperscriptBox["k", "2"]}], "+", 
        RowBox[{"5", " ", "ib", " ", 
         SuperscriptBox["k", "2"]}], "+", 
        RowBox[{"10", " ", "ia", " ", "ib", " ", 
         SuperscriptBox["k", "2"]}], "+", 
        RowBox[{"10", " ", 
         SuperscriptBox["ib", "2"], " ", 
         SuperscriptBox["k", "2"]}]}], ")"}]}]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {{13}}},
   GridBoxItemStyle->{"Columns" -> {{FontSize -> 12}}}],
  "Grid"]], "Output",
 CellChangeTimes->{
  3.738667949445796*^9, {3.7386680183166485`*^9, 3.7386680427752523`*^9}, {
   3.738668090591401*^9, 3.7386681047395716`*^9}, {3.738668175687897*^9, 
   3.738668189978697*^9}, {3.7386682864637127`*^9, 3.7386683008093195`*^9}, 
   3.7386697062700443`*^9, 3.7498554899530706`*^9, 3.7498555264075456`*^9, 
   3.7498556416931276`*^9, {3.749856560111783*^9, 3.7498565696053677`*^9}}]
}, Open  ]],

Cell[TextData[{
 "(In the Matlab code, these calculations are implemented in the ",
 StyleBox["pSum", "Input"],
 " method of the ",
 StyleBox["polynom", "Input"],
 " class.)"
}], "Text",
 CellChangeTimes->{{3.738668874868967*^9, 3.738668957912918*^9}, {
  3.7486236161066365`*^9, 3.7486236576166315`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Modifications and extensions used in Matlab code", "Subsection",
 CellChangeTimes->{{3.7008361824743657`*^9, 3.700836374551659*^9}, 
   3.7008473648375354`*^9, {3.701448882205756*^9, 3.7014488878045692`*^9}, {
   3.7384248602588177`*^9, 3.738424860349538*^9}, {3.7386692960318947`*^9, 
   3.7386693349807158`*^9}, {3.7498561740729027`*^9, 3.7498561817323837`*^9}}],

Cell[CellGroupData[{

Cell[TextData[{
 "Adjusting the lagged data matrix to conform to ",
 StyleBox["[firstValid, lastValid]", "Input"]
}], "Subsubsection",
 CellChangeTimes->{{3.7386702898585668`*^9, 3.738670314155601*^9}, {
  3.7386748540267143`*^9, 3.738674859459155*^9}}],

Cell[TextData[{
 "In the Matlab programing, the data vectors are implicitly defined on ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"i", "=", "1"}], ",", "...", ",", "\[ScriptCapitalT]"}], 
   TraditionalForm]]],
 ".  The lagged data matrix ",
 Cell[BoxData[
  FormBox["X", TraditionalForm]]],
 " is assumed to have \[ScriptCapitalT] rows. (In the VAR applications, \
\[ScriptCapitalT] is the number of time units per day, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"3600", "\[Times]", "24"}], "=", "86"}], ",", "400"}], 
   TraditionalForm]]],
 " if the time units are seconds, and  86,400,000 if the time units are \
milliseconds.) Due to lags and incomplete data, though, not all rows of ",
 Cell[BoxData[
  FormBox["X", TraditionalForm]]],
 " are valid. The valid range is indicated as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "<", 
    StyleBox["firstValid",
     FontSlant->"Italic"], "<", 
    StyleBox["lastValid",
     FontSlant->"Italic"], "\[LessEqual]", " ", "\[ScriptCapitalT]"}], 
   TraditionalForm]]],
 ". All routines are adjusted to confine calculations to these rows. This \
section uses the following conventions."
}], "Text",
 CellChangeTimes->{{3.7385954984901667`*^9, 3.7385957505302453`*^9}, {
   3.738595792589793*^9, 3.7385960015820127`*^9}, 3.7385960419699883`*^9, {
   3.7385996218064775`*^9, 3.7385996394203825`*^9}, {3.738669414242786*^9, 
   3.7386694414310894`*^9}}],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["i", "Input"],
 " is the original position in the sparse data vector corresponding to ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],
  FormatType->"TraditionalForm"],
 " (i.e., at lag zero)."
}], "Subitem",
 CellChangeTimes->{{3.7008361824743657`*^9, 3.700836374551659*^9}, {
  3.7008473735378003`*^9, 3.7008473991270556`*^9}, {3.738669455719925*^9, 
  3.7386694660033884`*^9}, {3.7386695140439377`*^9, 3.7386695322552795`*^9}}],

Cell[TextData[{
 StyleBox["a", "Input"],
 " is an offset relative to ",
 StyleBox["i", "Input"],
 ", where the PDL starts."
}], "Subitem",
 CellChangeTimes->{{3.7008361824743657`*^9, 3.700836374551659*^9}, {
  3.7008473735378003`*^9, 3.7008474048839655`*^9}, {3.7384248220150104`*^9, 
  3.738424823036304*^9}, {3.738669478808153*^9, 3.7386694813433933`*^9}}],

Cell[TextData[{
 "Similarly, ",
 StyleBox["j", "Input"],
 " and ",
 StyleBox["b", "Input"],
 " are the original position for ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]]],
 " and the offset for the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]]],
 " PDL."
}], "Subitem",
 CellChangeTimes->{{3.7008361824743657`*^9, 3.700836374551659*^9}, {
  3.7008473735378003`*^9, 3.7008474037265606`*^9}, {3.738669539826999*^9, 
  3.7386696112590055`*^9}, {3.7386829987138543`*^9, 3.7386829987167654`*^9}}]
}, Open  ]],

Cell[TextData[{
 StyleBox["vTrim", "Input"],
 " removes all rows from ",
 StyleBox["X", "Input"],
 " that are outside of ",
 StyleBox["[firstValid, lastValid]", "Input"],
 "."
}], "Text",
 CellChangeTimes->{{3.738425417269764*^9, 3.7384254320462437`*^9}, {
  3.738596094341999*^9, 3.738596149956254*^9}, {3.738669348439764*^9, 
  3.7386694092810526`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vTrim", "[", "X_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "d", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"d", "=", 
       RowBox[{"Dimensions", "[", "X", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Not", "[", 
          RowBox[{"MatrixQ", "[", "X", "]"}], "]"}], " ", "||", " ", 
         RowBox[{"lastValid", ">", 
          RowBox[{"d", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], " ", "||", " ", 
         RowBox[{"firstValid", "<", "1"}], "||", 
         RowBox[{"firstValid", ">", "lastValid"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Print", "[", "\"\<vTrim error.\>\"", "]"}], ";", 
         RowBox[{"Return", "[", "Null", "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"X", "[", 
       RowBox[{"[", 
        RowBox[{"firstValid", ";;", "lastValid"}], "]"}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[ScriptCapitalT]", "=", "10"}], ",", 
     RowBox[{"firstValid", "=", "2"}], ",", 
     RowBox[{"lastValid", "=", "8"}]}], "}"}], ",", 
   RowBox[{"MatrixForm", "/@", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"X", "[", 
       RowBox[{"3", ",", "4"}], "]"}], ",", 
      RowBox[{"vTrim", "[", 
       RowBox[{"X", "[", 
        RowBox[{"3", ",", "4"}], "]"}], "]"}]}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.7008365906114693`*^9, 3.700836669901738*^9}, {
   3.700836716137018*^9, 3.7008367635480385`*^9}, {3.701444871620672*^9, 
   3.7014449186675544`*^9}, {3.7014450173295374`*^9, 3.701445034357279*^9}, {
   3.7014452087639337`*^9, 3.7014453857154045`*^9}, {3.701445422911507*^9, 
   3.7014455272313643`*^9}, {3.701445752761948*^9, 3.7014457539145484`*^9}, 
   3.738338437583252*^9, {3.73842502449372*^9, 3.738425104959611*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0", "0"},
       {"0", "0", "0", "0"},
       {"1", "0", "0", "0"},
       {"0", "1", "0", "0"},
       {"0", "0", "1", "0"},
       {"0", "0", "0", "1"},
       {"0", "0", "0", "0"},
       {"0", "0", "0", "0"},
       {"0", "0", "0", "0"},
       {"0", "0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0", "0"},
       {"1", "0", "0", "0"},
       {"0", "1", "0", "0"},
       {"0", "0", "1", "0"},
       {"0", "0", "0", "1"},
       {"0", "0", "0", "0"},
       {"0", "0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 CellChangeTimes->{{3.701445518932743*^9, 3.701445527633406*^9}, 
   3.7014457581981597`*^9, 3.7014478846014695`*^9, {3.7384250608625607`*^9, 
   3.7384251057265944`*^9}, {3.7386696836584215`*^9, 3.738669706294896*^9}, 
   3.7498554899819937`*^9}]
}, Open  ]],

Cell[TextData[{
 "Here is a cross product calculation that uses ",
 StyleBox["vTrim", "Input"],
 " to adjust the range."
}], "Text",
 CellChangeTimes->{{3.7386703336514993`*^9, 3.738670375525511*^9}, 
   3.7386748470165086`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[ScriptCapitalT]", "=", "20"}], ",", 
      RowBox[{"firstValid", "=", "8"}], ",", 
      RowBox[{"lastValid", "=", "10"}], ",", 
      RowBox[{"j", "=", "10"}], ",", 
      RowBox[{"a", "=", "0"}], ",", 
      RowBox[{"b", "=", "0"}], ",", 
      RowBox[{"\[ScriptCapitalL]x", "=", "4"}], ",", 
      RowBox[{"\[ScriptCapitalL]y", "=", "3"}]}], "}"}], ",", "\n", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{"i", ",", "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{
             RowBox[{"X", "[", 
              RowBox[{
               RowBox[{"i", "+", "a"}], ",", "\[ScriptCapitalL]x"}], "]"}], "//",
              "MatrixForm"}], ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"Y", "[", 
              RowBox[{
               RowBox[{"j", "+", "b"}], ",", "\[ScriptCapitalL]y"}], "]"}], "//",
              "MatrixForm"}], ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"vTrim", "[", 
              RowBox[{"X", "[", 
               RowBox[{
                RowBox[{"i", "+", "a"}], ",", "\[ScriptCapitalL]x"}], "]"}], 
              "]"}], "//", "MatrixForm"}], ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"vTrim", "[", 
              RowBox[{"Y", "[", 
               RowBox[{
                RowBox[{"j", "+", "b"}], ",", "\[ScriptCapitalL]y"}], "]"}], 
              "]"}], "//", "MatrixForm"}], ","}], "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"X", "[", 
              RowBox[{
               RowBox[{"i", "+", "a"}], ",", "\[ScriptCapitalL]x"}], "]"}], 
             "\[Transpose]"}], ".", 
            RowBox[{"Y", "[", 
             RowBox[{
              RowBox[{"j", "+", "b"}], ",", "\[ScriptCapitalL]y"}], "]"}]}], "//",
            "MatrixForm"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"vTrim", "[", " ", 
              RowBox[{"X", "[", 
               RowBox[{
                RowBox[{"i", "+", "a"}], ",", "\[ScriptCapitalL]x"}], "]"}], 
              " ", "]"}], "\[Transpose]"}], ".", 
            RowBox[{"vTrim", "[", " ", 
             RowBox[{"Y", "[", 
              RowBox[{
               RowBox[{"j", "+", "b"}], ",", "\[ScriptCapitalL]y"}], "]"}], 
             " ", "]"}]}], "//", "MatrixForm"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"\[ScriptCapitalD]", "[", 
              RowBox[{"\[ScriptCapitalL]x", ",", "2"}], "]"}], 
             "\[Transpose]"}], ".", 
            RowBox[{
             RowBox[{"vTrim", "[", 
              RowBox[{"X", "[", 
               RowBox[{
                RowBox[{"i", "+", "a"}], ",", "\[ScriptCapitalL]x"}], "]"}], 
              "]"}], "\[Transpose]"}], ".", 
            RowBox[{"vTrim", "[", 
             RowBox[{"Y", "[", 
              RowBox[{
               RowBox[{"j", "+", "b"}], ",", "\[ScriptCapitalL]y"}], "]"}], 
             "]"}], ".", 
            RowBox[{"\[ScriptCapitalD]", "[", 
             RowBox[{"\[ScriptCapitalL]y", ",", "2"}], "]"}]}], "//", 
           "MatrixForm"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "6", ",", "13"}], "}"}]}], "]"}], "//", 
      "Transpose"}], "//", "TableForm"}]}], "]"}], "//", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{"#", ",", 
     RowBox[{"FontSize", "\[Rule]", "9"}]}], "]"}], "&"}]}]], "Input",
 CellChangeTimes->{{3.7005046270755134`*^9, 3.7005046302892895`*^9}, 
   3.7005601069945297`*^9, {3.7005602999406877`*^9, 3.7005603147630186`*^9}, {
   3.7008352554128923`*^9, 3.700835309445223*^9}, {3.700835472991358*^9, 
   3.7008354777213354`*^9}, {3.7008368333394384`*^9, 
   3.7008368700667267`*^9}, {3.700836906013949*^9, 3.700836935843815*^9}, {
   3.7008369685187855`*^9, 3.70083699111464*^9}, {3.7008370795562916`*^9, 
   3.7008371007339153`*^9}, {3.7008371592860665`*^9, 3.700837185571196*^9}, {
   3.7008372491332254`*^9, 3.700837259963071*^9}, {3.7008372929410973`*^9, 
   3.700837319938339*^9}, {3.7008373780261307`*^9, 3.7008374201235576`*^9}, {
   3.700837459746147*^9, 3.7008374662160816`*^9}, {3.700837952716564*^9, 
   3.7008379713189163`*^9}, {3.700838009175889*^9, 3.700838009942936*^9}, {
   3.7008380619509044`*^9, 3.7008380750033474`*^9}, {3.700838132099033*^9, 
   3.700838137460992*^9}, {3.7008389905536013`*^9, 3.7008391085761137`*^9}, {
   3.700839152195801*^9, 3.7008392097654405`*^9}, {3.7008406901614733`*^9, 
   3.7008407195614996`*^9}, {3.7008407967412987`*^9, 3.700840819715869*^9}, {
   3.700840991219449*^9, 3.7008409918983707`*^9}, {3.7008410352629366`*^9, 
   3.7008410926997185`*^9}, {3.700841220086285*^9, 3.7008412319011464`*^9}, {
   3.7008412650350914`*^9, 3.7008413580000343`*^9}, {3.7008414839415045`*^9, 
   3.700841504394816*^9}, {3.700841819866496*^9, 3.7008418236583853`*^9}, {
   3.700841910544131*^9, 3.700841977972734*^9}, {3.700842075609977*^9, 
   3.70084207668857*^9}, {3.7014455641877394`*^9, 3.701445570340804*^9}, 
   3.73833846528818*^9, {3.7384251407299848`*^9, 3.738425164794736*^9}, {
   3.738425340859071*^9, 3.7384253408620787`*^9}, {3.7386696481334095`*^9, 
   3.738669673670165*^9}, {3.73867040593229*^9, 3.738670427306142*^9}, {
   3.738670457487398*^9, 3.738670594894997*^9}, {3.7386706763661237`*^9, 
   3.7386707753714457`*^9}, {3.7386708673285675`*^9, 
   3.7386709732583065`*^9}, {3.738671431320791*^9, 3.73867145191875*^9}, 
   3.738672948817352*^9}],

Cell[BoxData[
 StyleBox[
  TagBox[GridBox[{
     {"6", "7", "8", "9", "10", "11", "12", "13"},
     {
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"1", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"1", "0", "0"},
          {"0", "1", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"1", "0", "0"},
          {"0", "1", "0"},
          {"0", "0", "1"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"1", "0", "0"},
          {"0", "1", "0"},
          {"0", "0", "1"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "1", "0"},
          {"0", "0", "1"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "1"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]]},
     {
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"1", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"1", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"1", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"1", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]]},
     {
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"1", "1", "1"},
          {"4", "4", "4"},
          {"16", "16", "16"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"1", "1", "1"},
          {"3", "3", "3"},
          {"9", "9", "9"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"1", "1", "1"},
          {"2", "2", "2"},
          {"4", "4", "4"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"1", "1", "1"},
          {"1", "1", "1"},
          {"1", "1", "1"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[2.0999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Function[BoxForm`e$, 
    TableForm[BoxForm`e$]]],
  StripOnInput->False,
  FontSize->9]], "Output",
 CellChangeTimes->{
  3.700837421307763*^9, {3.7008374610011673`*^9, 3.7008374680312576`*^9}, {
   3.7008379642663727`*^9, 3.7008379721668653`*^9}, 3.700838010790059*^9, 
   3.700838088702428*^9, 3.700838139560747*^9, 3.700839109845454*^9, 
   3.7008391565490417`*^9, 3.7008392122120423`*^9, {3.700840693730369*^9, 
   3.7008407200813775`*^9}, {3.7008407979326763`*^9, 3.7008408209843855`*^9}, 
   3.7008409930828695`*^9, {3.7008410370852127`*^9, 3.700841093331386*^9}, 
   3.700841233385785*^9, 3.70084136086677*^9, 3.7008418256064963`*^9, {
   3.700841968474556*^9, 3.700841981009236*^9}, 3.700842078309326*^9, 
   3.701365889560003*^9, 3.7014455716714478`*^9, 3.7014457746419373`*^9, 
   3.7014478846483517`*^9, {3.7384251495344486`*^9, 3.7384251698202176`*^9}, {
   3.738669676815753*^9, 3.7386697063378196`*^9}, {3.7386704226285906`*^9, 
   3.738670428973748*^9}, {3.7386704706591425`*^9, 3.7386705427295227`*^9}, 
   3.738670597385339*^9, 3.73867077891601*^9, 3.738670898614907*^9, 
   3.7386709415391693`*^9, 3.738670975719713*^9, {3.7386714354447665`*^9, 
   3.7386714528971014`*^9}, 3.7498554900378447`*^9}]
}, Open  ]],

Cell["\<\
The code used in Matlab adjusts the starting and ending values of the loop to \
conform to firstValid and lastValid:\
\>", "Text",
 CellChangeTimes->{{3.7008467914581556`*^9, 3.700846796661046*^9}, {
  3.738425522539327*^9, 3.7384255415714955`*^9}, {3.7386700751586404`*^9, 
  3.738670149940709*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"CP1", "[", 
    RowBox[{
    "i_", ",", "j_", ",", "a_", ",", "b_", ",", "n_", ",", "m_", ",", "dx_", 
     ",", "dy_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"k", ",", "ka", ",", "kb", ",", "z"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"z", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"0", ",", 
         RowBox[{"{", 
          RowBox[{"dx", "+", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"dy", "+", "1"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"k", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"j", "+", "b"}], ")"}], "-", 
        RowBox[{"(", 
         RowBox[{"i", "+", "a"}], ")"}]}]}], ";", " ", 
      RowBox[{"(*", "offset", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"ka", "=", 
       RowBox[{"Max", "[", 
        RowBox[{"1", ",", 
         RowBox[{"k", "+", "1"}], ",", 
         RowBox[{"firstValid", "-", 
          RowBox[{"(", 
           RowBox[{"i", "+", "a"}], ")"}], "+", "1"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"kb", "=", 
       RowBox[{"Min", "[", 
        RowBox[{"n", ",", 
         RowBox[{"m", "+", "k"}], ",", 
         RowBox[{"lastValid", "-", 
          RowBox[{"(", 
           RowBox[{"j", "+", "b"}], ")"}], "+", "1", "+", "k"}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"ka", ">", "kb"}], ",", 
        RowBox[{"Return", "[", "z", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{
           SuperscriptBox["ii", "d1"], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"ii", "-", "k"}], ")"}], "d2"]}], ",", 
          RowBox[{"{", 
           RowBox[{"ii", ",", "ka", ",", "kb"}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"d1", ",", "0", ",", "dx"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"d2", ",", "0", ",", "dy"}], "}"}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[ScriptCapitalT]", "=", "20"}], ",", 
      RowBox[{"firstValid", "=", "8"}], ",", 
      RowBox[{"lastValid", "=", "10"}], ",", 
      RowBox[{"j", "=", "10"}], ",", 
      RowBox[{"a", "=", "0"}], ",", 
      RowBox[{"b", "=", "0"}], ",", 
      RowBox[{"\[ScriptCapitalL]x", "=", "4"}], ",", 
      RowBox[{"\[ScriptCapitalL]y", "=", "3"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{
           RowBox[{"CP1", "[", 
            RowBox[{
            "i", ",", "j", ",", "a", ",", "b", ",", "\[ScriptCapitalL]x", ",",
              "\[ScriptCapitalL]y", ",", "2", ",", "2"}], "]"}], "//", 
           "MatrixForm"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"j", "-", "4"}], ",", 
          RowBox[{"j", "+", "3"}]}], "}"}]}], "]"}], "//", "Transpose"}], "//",
      "TableForm"}]}], "]"}], "//", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{"#", ",", 
     RowBox[{"FontSize", "\[Rule]", "9"}]}], "]"}], "&"}]}]}], "Input",
 CellChangeTimes->{{3.7008356934298296`*^9, 3.7008357490046463`*^9}, {
   3.7008357922433014`*^9, 3.7008361293026695`*^9}, {3.7008375362218657`*^9, 
   3.7008375414903135`*^9}, {3.700837599606666*^9, 3.700837632401971*^9}, {
   3.700837693460322*^9, 3.7008377090575852`*^9}, {3.7008377611407022`*^9, 
   3.700837773222535*^9}, {3.7008378687519784`*^9, 3.700837870962264*^9}, 
   3.700838213513548*^9, {3.7008395357581654`*^9, 3.7008395821504583`*^9}, {
   3.700839617763837*^9, 3.7008396426019135`*^9}, {3.700839679935186*^9, 
   3.70083968038822*^9}, {3.700839951638729*^9, 3.700839974319476*^9}, {
   3.7008400370141487`*^9, 3.700840130368082*^9}, {3.7008401635882263`*^9, 
   3.7008401982346787`*^9}, {3.7008402708693314`*^9, 3.700840310611271*^9}, {
   3.7008403877409*^9, 3.7008403946742983`*^9}, {3.700840476274161*^9, 
   3.7008404939894047`*^9}, {3.7008405842822275`*^9, 
   3.7008406121855383`*^9}, {3.7008406511006155`*^9, 
   3.7008406690627356`*^9}, {3.700840898343337*^9, 3.7008409247970047`*^9}, {
   3.7008410042813053`*^9, 3.70084102243151*^9}, {3.700841053134447*^9, 
   3.700841054232459*^9}, {3.700841101083024*^9, 3.700841104359669*^9}, {
   3.7008411444096155`*^9, 3.700841145042924*^9}, {3.7008415779714274`*^9, 
   3.700841715802747*^9}, {3.700841758184939*^9, 3.7008417582852335`*^9}, {
   3.7008418565571074`*^9, 3.7008418590875425`*^9}, {3.7008419966105037`*^9, 
   3.700842069371857*^9}, {3.700842606794547*^9, 3.700842610795727*^9}, {
   3.7008426443108044`*^9, 3.700842686468752*^9}, {3.700843079457863*^9, 
   3.700843125699993*^9}, {3.700843175715454*^9, 3.700843177467827*^9}, {
   3.7008457749400387`*^9, 3.700845784017988*^9}, {3.700845833285446*^9, 
   3.7008458334033995`*^9}, {3.7008464486466103`*^9, 3.700846469204111*^9}, {
   3.700846595565031*^9, 3.700846658135244*^9}, {3.701445862804519*^9, 
   3.7014458820751753`*^9}, 3.7383384975110855`*^9, {3.738670066896764*^9, 
   3.738670066989497*^9}, 3.7386701837702665`*^9, {3.7386717779848804`*^9, 
   3.738671795661699*^9}}],

Cell[BoxData[
 StyleBox[
  TagBox[GridBox[{
     {"6", "7", "8", "9", "10", "11", "12", "13"},
     {
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"1", "1", "1"},
          {"4", "4", "4"},
          {"16", "16", "16"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"1", "1", "1"},
          {"3", "3", "3"},
          {"9", "9", "9"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"1", "1", "1"},
          {"2", "2", "2"},
          {"4", "4", "4"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"1", "1", "1"},
          {"1", "1", "1"},
          {"1", "1", "1"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", "0", "0"},
          {"0", "0", "0"},
          {"0", "0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[2.0999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Function[BoxForm`e$, 
    TableForm[BoxForm`e$]]],
  StripOnInput->False,
  FontSize->9]], "Output",
 CellChangeTimes->{3.700842611794958*^9, 3.700842687731343*^9, 
  3.700843126753789*^9, 3.700843178783782*^9, 3.700846420142357*^9, 
  3.7008464826411915`*^9, 3.700846601397785*^9, 3.7008466345849504`*^9, 
  3.701365889707142*^9, 3.701445883038991*^9, 3.701447884833159*^9, 
  3.7386697065571957`*^9, 3.738670155536716*^9, 3.738670186567745*^9, 
  3.738671804414217*^9, 3.7498554900617805`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Verify equivalence of calculation methods for a range of values ...\
\>", "Subsubsection",
 CellChangeTimes->{{3.7008433667299223`*^9, 3.7008433755821357`*^9}, {
  3.7386731157589464`*^9, 3.738673129390498*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"kStep", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\[ScriptCapitalT]", "=", "30"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Block", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"firstValid", "=", "kfv"}], ",", 
          RowBox[{"lastValid", "=", "klv"}], ",", 
          RowBox[{"i", "=", "ki"}], ",", 
          RowBox[{"j", "=", "kj"}], ",", 
          RowBox[{"a", "=", "kka"}], ",", 
          RowBox[{"b", "=", "kkb"}], ",", 
          RowBox[{"dx", "=", "2"}], ",", 
          RowBox[{"dy", "=", "1"}], ",", 
          RowBox[{"n", "=", "4"}], ",", 
          RowBox[{"m", "=", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"kStep", " ", "=", " ", 
          RowBox[{"kStep", "+", "1"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Mod", "[", 
             RowBox[{"kStep", ",", "2500"}], "]"}], "\[Equal]", "0"}], " ", 
           ",", 
           RowBox[{"Print", "[", 
            RowBox[{
            "kStep", ",", "\"\< \>\"", ",", "kfv", ",", " ", "\"\< \>\"", ",",
              " ", "klv", ",", "\"\< \>\"", ",", "ki", ",", "\"\< \>\"", ",", 
             "kj", ",", "\"\< \>\"", ",", "kka"}], "]"}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"kStep", ">", "15000"}], ",", 
           RowBox[{"Break", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"z1", "=", 
          RowBox[{"CP1", "[", 
           RowBox[{
           "i", ",", "j", ",", "a", ",", "b", ",", "n", ",", "m", ",", "dx", 
            ",", "dy"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"z2", "=", 
          RowBox[{
           RowBox[{
            RowBox[{"\[ScriptCapitalD]", "[", 
             RowBox[{"n", ",", "dx"}], "]"}], "\[Transpose]"}], ".", 
           RowBox[{
            RowBox[{"vTrim", "[", 
             RowBox[{"X", "[", 
              RowBox[{
               RowBox[{"i", "+", "a"}], ",", "n"}], "]"}], "]"}], 
            "\[Transpose]"}], ".", 
           RowBox[{"vTrim", "[", 
            RowBox[{"X", "[", 
             RowBox[{
              RowBox[{"j", "+", "b"}], ",", "m"}], "]"}], "]"}], ".", 
           RowBox[{"\[ScriptCapitalD]", "[", 
            RowBox[{"m", ",", "dy"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{"z2", "=", "123"}], ";"}], "*)"}], "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"z1", "===", "z2"}], ",", 
           RowBox[{"Continue", "[", "]"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"Print", "[", "\"\<Whoops\>\"", "]"}], 
             RowBox[{"Print", "[", 
              RowBox[{
               RowBox[{"z1", "//", "MatrixForm"}], ",", 
               RowBox[{"z2", "//", "MatrixForm"}]}], "]"}]}], ";", 
            RowBox[{"Break", "[", "]"}], ";"}]}], "]"}], ";"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"kfv", ",", "5", ",", "15", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"klv", ",", 
        RowBox[{"kfv", "+", "10"}], ",", 
        RowBox[{"\[ScriptCapitalT]", "-", "5"}], ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ki", ",", 
        RowBox[{"Max", "[", 
         RowBox[{"1", ",", 
          RowBox[{"kfv", "-", "5"}]}], "]"}], ",", 
        RowBox[{"\[ScriptCapitalT]", "-", "8"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"kj", ",", 
        RowBox[{"Max", "[", 
         RowBox[{"1", ",", 
          RowBox[{"kfv", "-", "5"}]}], "]"}], ",", 
        RowBox[{"\[ScriptCapitalT]", "-", "8"}], ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"kka", ",", "0", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"kkb", ",", "0", ",", "2"}], "}"}]}], "]"}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.700843833145831*^9, 3.7008438554998884`*^9}, {
   3.7008438888678274`*^9, 3.7008439732341566`*^9}, {3.700844265881452*^9, 
   3.7008444140632324`*^9}, {3.700844452265601*^9, 3.7008444635138545`*^9}, {
   3.7008444946816654`*^9, 3.7008445170132675`*^9}, 3.7008445474027553`*^9, {
   3.7008445891703186`*^9, 3.700844707641695*^9}, {3.700844747465198*^9, 
   3.700844754622762*^9}, {3.7008448045259905`*^9, 3.7008449123185067`*^9}, {
   3.7008449466543303`*^9, 3.700845062016201*^9}, {3.7008451447283263`*^9, 
   3.7008451447630825`*^9}, {3.7008451754485455`*^9, 3.700845259320263*^9}, {
   3.700845292940489*^9, 3.700845295145935*^9}, 3.700845336205659*^9, {
   3.7008453683048544`*^9, 3.7008453802582855`*^9}, {3.700845439511136*^9, 
   3.7008454490797276`*^9}, {3.7008455109891376`*^9, 
   3.7008455548138685`*^9}, {3.7008456149596386`*^9, 
   3.7008456806361628`*^9}, {3.700845919171728*^9, 3.700845939141307*^9}, {
   3.7008460437767754`*^9, 3.7008460772522926`*^9}, {3.700846154895485*^9, 
   3.700846283670503*^9}, {3.7008463295478277`*^9, 3.7008463546664267`*^9}, {
   3.7008465130726767`*^9, 3.7008465794115868`*^9}, {3.700846702136767*^9, 
   3.7008467520244865`*^9}, {3.701366298578313*^9, 3.701366337301283*^9}, {
   3.7013663833459654`*^9, 3.701366384018143*^9}, {3.701366419520019*^9, 
   3.701366419567894*^9}, {3.7014459476981845`*^9, 3.701445975793882*^9}, {
   3.7014460455833683`*^9, 3.7014460645513487`*^9}, {3.701446369464923*^9, 
   3.70144639949142*^9}, {3.7014464514426603`*^9, 3.701446459218932*^9}, {
   3.7014467087547874`*^9, 3.7014467109820094`*^9}, {3.701447137446838*^9, 
   3.7014471448004723`*^9}, {3.7014472335700274`*^9, 3.701447253469304*^9}, {
   3.7014472834806337`*^9, 3.701447283529152*^9}, {3.701447315218335*^9, 
   3.7014474055559464`*^9}, {3.701447977223403*^9, 3.7014480331483994`*^9}, {
   3.7014481056963015`*^9, 3.7014482126345153`*^9}, {3.7383385036346416`*^9, 
   3.7383385182536354`*^9}, {3.7384253408979445`*^9, 
   3.7384253408999386`*^9}, {3.7386731921945715`*^9, 3.738673196538957*^9}, 
   3.73867323913011*^9, 3.7386732753722057`*^9, {3.738673357994299*^9, 
   3.738673390268998*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "2500", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "2"}],
  SequenceForm[2500, " ", 5, " ", 20, " ", 4, " ", 5, " ", 2],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7014480381165104`*^9, {3.7014481678899326`*^9, 3.7014482135878105`*^9}, 
   3.738669706731781*^9, {3.7386731441530256`*^9, 3.738673150863085*^9}, 
   3.7386731980249825`*^9, 3.738673240192247*^9, 3.7386732774476223`*^9, {
   3.738673364038097*^9, 3.738673391589465*^9}, 3.7498554903619776`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "5000", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm[5000, " ", 5, " ", 25, " ", 7, " ", 11, " ", 1],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7014480381165104`*^9, {3.7014481678899326`*^9, 3.7014482135878105`*^9}, 
   3.738669706731781*^9, {3.7386731441530256`*^9, 3.738673150863085*^9}, 
   3.7386731980249825`*^9, 3.738673240192247*^9, 3.7386732774476223`*^9, {
   3.738673364038097*^9, 3.738673391589465*^9}, 3.7498554906372404`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "7500", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "21", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm[7500, " ", 10, " ", 20, " ", 16, " ", 21, " ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7014480381165104`*^9, {3.7014481678899326`*^9, 3.7014482135878105`*^9}, 
   3.738669706731781*^9, {3.7386731441530256`*^9, 3.738673150863085*^9}, 
   3.7386731980249825`*^9, 3.738673240192247*^9, 3.7386732774476223`*^9, {
   3.738673364038097*^9, 3.738673391589465*^9}, 3.749855490920483*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "10000", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm[10000, " ", 15, " ", 25, " ", 18, " ", 20, " ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7014480381165104`*^9, {3.7014481678899326`*^9, 3.7014482135878105`*^9}, 
   3.738669706731781*^9, {3.7386731441530256`*^9, 3.738673150863085*^9}, 
   3.7386731980249825`*^9, 3.738673240192247*^9, 3.7386732774476223`*^9, {
   3.738673364038097*^9, 3.738673391589465*^9}, 3.7498554912147245`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Non-sparse data series", "Subsubsection",
 CellChangeTimes->{{3.7386763670859327`*^9, 3.738676375883437*^9}}],

Cell["\<\
The sparse data vectors discussed to this point have all been sparse (like \
price changes). A price discovery VECM will also often include a constant \
term and/or a cointegration vector. These require special handling.\
\>", "Text",
 CellChangeTimes->{{3.738676402499321*^9, 3.738676506045385*^9}, {
  3.7386765544948683`*^9, 3.7386767719265137`*^9}}],

Cell[CellGroupData[{

Cell["Constant terms", "Subsubsubsection",
 CellChangeTimes->{{3.7386767795630527`*^9, 3.7386767816544886`*^9}}],

Cell[TextData[{
 "Many models will include constant terms. In the data matrix, this is \
usually represented as a column of ones. The constant crossed with itself is \
simply the number of observations, ",
 Cell[BoxData[
  FormBox["N", TraditionalForm]],
  FormatType->"TraditionalForm"],
 ". We might have ",
 Cell[BoxData[
  FormBox[
   RowBox[{"N", "=", "\[ScriptCapitalT]"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", the length of the implicit data matrix. More generally, though, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"N", "=", 
    RowBox[{
     StyleBox["lastValid",
      FontSlant->"Italic"], "-", 
     StyleBox["firstValid",
      FontSlant->"Italic"], "+", "1"}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", where ",
 StyleBox["firstValid",
  FontSlant->"Italic"],
 " and ",
 StyleBox["lastValid",
  FontSlant->"Italic"],
 " are (as described earlier) pointers in ",
 StyleBox["X.",
  FontSlant->"Italic"],
 " "
}], "Text",
 CellChangeTimes->{{3.738676402499321*^9, 3.738676506045385*^9}, {
  3.7386765544948683`*^9, 3.7386766810634212`*^9}, {3.738676785532133*^9, 
  3.738676921562375*^9}, {3.738676952440813*^9, 3.738676952440813*^9}}],

Cell["\<\
The cross product of the constant vector and a sparse data vector is the sum \
of the nonzero values.\
\>", "Text",
 CellChangeTimes->{{3.738676402499321*^9, 3.738676506045385*^9}, {
  3.7386765544948683`*^9, 3.7386766810634212`*^9}, {3.738676785532133*^9, 
  3.738676921562375*^9}, {3.738676953058176*^9, 3.7386770042642727`*^9}}],

Cell[TextData[{
 "Letting ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Iota]", "l"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " denote a column vector of ",
 Cell[BoxData[
  FormBox["l", TraditionalForm]],
  FormatType->"TraditionalForm"],
 " ones, the cross product of the constant vector and a quadratic PDL on a \
sparse data vector is:"
}], "Text",
 CellChangeTimes->{{3.7386770103589506`*^9, 3.738677026801995*^9}, {
  3.738680323176264*^9, 3.7386803302243767`*^9}, {3.7386815361294513`*^9, 
  3.738681650652226*^9}, {3.7386817193894143`*^9, 3.738681721998435*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["D", "x"], "\[Transpose]"}], 
    RowBox[{"X", "\[Transpose]"}], 
    SubscriptBox["\[Iota]", "\[ScriptCapitalT]"]}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["D", "x"], "\[Transpose]"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        UnderoverscriptBox["\[Sum]", 
         RowBox[{"k", "=", "1"}], "K"], 
        RowBox[{
         SubscriptBox["v", "k"], 
         RowBox[{"\[ScriptCapitalI]", "(", 
          RowBox[{
           SubscriptBox["t", "k"], "+", "1"}], ")"}]}]}], ")"}], 
      "\[Transpose]"}], 
     SubscriptBox["\[Iota]", "\[ScriptCapitalT]"]}], "=", 
    RowBox[{
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"k", "=", "1"}], "K"], 
      RowBox[{
       SubscriptBox["v", "k"], 
       RowBox[{
        SubscriptBox["D", "x"], "\[Transpose]"}], 
       RowBox[{
        RowBox[{"\[ScriptCapitalI]", "(", 
         RowBox[{
          SubscriptBox["t", "k"], "+", "1"}], ")"}], "\[Transpose]"}], 
       SubscriptBox["\[Iota]", "\[ScriptCapitalT]"]}]}], "=", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"k", "=", "1"}], "K"], 
      RowBox[{
       SubscriptBox["v", "k"], 
       RowBox[{
        SubscriptBox["D", "x"], "\[Transpose]"}], 
       SubscriptBox["\[Iota]", 
        RowBox[{"\[ScriptCapitalL]", "\[VeryThinSpace]"}]]}]}]}]}]}], 
  TraditionalForm]], "Equation",
 CellChangeTimes->{{3.7383495738479567`*^9, 3.73834962809895*^9}, 
   3.7383944013792505`*^9, {3.738403987981079*^9, 3.7384040009554234`*^9}, {
   3.7384069641249304`*^9, 3.7384069695145607`*^9}, {3.7386808730028133`*^9, 
   3.738680911340311*^9}, {3.738681658766588*^9, 3.7386816746470823`*^9}, {
   3.738681708099598*^9, 3.7386817129596853`*^9}, {3.738681745139567*^9, 
   3.7386817770951366`*^9}, {3.7386818092402043`*^9, 3.738681809635168*^9}}],

Cell[TextData[{
 "where \[ScriptCapitalL] is the length of the PDL. The ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["D", "x"], "\[Transpose]"}], 
    SubscriptBox["\[Iota]", 
     RowBox[{"\[ScriptCapitalL]", "\[VeryThinSpace]"}]]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " term is the sum (across columns) of the elements of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[ScriptCapitalD]", "x"], "\[Transpose]"}], 
   TraditionalForm]],
  FormatType->"TraditionalForm"],
 "."
}], "Text",
 CellChangeTimes->{{3.738681798891918*^9, 3.738681938435727*^9}, {
  3.7386820076825743`*^9, 3.7386820347801523`*^9}, {3.738682190815919*^9, 
  3.738682214502612*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[ScriptCapitalT]", "=", "10"}], ",", 
      RowBox[{"\[ScriptCapitalL]x", "=", "4"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"MatrixForm", "[", "#", "]"}], "&"}], "/@", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"X", "[", 
         RowBox[{"5", ",", "\[ScriptCapitalL]x"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"X", "[", 
           RowBox[{"5", ",", "\[ScriptCapitalL]x"}], "]"}], "\[Transpose]"}], 
         ".", "Ones"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"\[ScriptCapitalD]", "[", 
          RowBox[{"\[ScriptCapitalL]x", ",", "2"}], "]"}], "\[Transpose]"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"\[ScriptCapitalD]", "[", 
           RowBox[{"\[ScriptCapitalL]x", ",", "2"}], "]"}], "\[Transpose]"}], 
         ".", 
         RowBox[{
          RowBox[{"X", "[", 
           RowBox[{"5", ",", "\[ScriptCapitalL]x"}], "]"}], "\[Transpose]"}], 
         ".", "Ones"}]}], "}"}]}], "}"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellChangeTimes->{{3.7386810003679876`*^9, 3.7386810665280485`*^9}, {
  3.738681111934622*^9, 3.7386811712390556`*^9}, {3.73868129034459*^9, 
  3.738681291684012*^9}, {3.73868134443199*^9, 3.738681391786448*^9}, {
  3.738682048161386*^9, 3.738682180147438*^9}, {3.7386822225450754`*^9, 
  3.7386822232731285`*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0", "0", "0", "0"},
         {"0", "0", "0", "0"},
         {"0", "0", "0", "0"},
         {"0", "0", "0", "0"},
         {"1", "0", "0", "0"},
         {"0", "1", "0", "0"},
         {"0", "0", "1", "0"},
         {"0", "0", "0", "1"},
         {"0", "0", "0", "0"},
         {"0", "0", "0", "0"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]], 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"1"},
         {"1"},
         {"1"},
         {"1"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]], 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"1", "1", "1", "1"},
         {"1", "2", "3", "4"},
         {"1", "4", "9", "16"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]], 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"4"},
         {"10"},
         {"30"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.73868114813287*^9, 3.738681157246467*^9}, 
   3.7386812931550884`*^9, 3.7386813921683693`*^9, {3.7386820599059677`*^9, 
   3.738682067465761*^9}, {3.738682108462146*^9, 3.7386821395550013`*^9}, 
   3.73868218096729*^9, 3.7386822242296066`*^9, 3.7498554913074474`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sparse levels", "Subsubsubsection",
 CellChangeTimes->{{3.7386822508603673`*^9, 3.738682253674842*^9}}],

Cell[TextData[{
 "Cointegrating vectors are not sparse in the usual sense (of having a small \
number of nonzero values). The difference between two price series ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[CapitalDelta]", "t"], "=", 
    RowBox[{
     SubscriptBox["p", 
      RowBox[{"1", "t"}]], "-", 
     SubscriptBox["p", 
      RowBox[{"2", "t"}]]}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " is not sparse, even if the price changes of component prices are sparse. ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[CapitalDelta]", "t"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " is sparse in a different sense, sometimes called piecewise sparse or level \
sparse. Its entries consist of constant levels that persist in time until one \
of component prices changes. The cross product calculations are adjusted \
accordingly."
}], "Text",
 CellChangeTimes->{{3.7386822616385717`*^9, 3.73868265991566*^9}, {
  3.7386829587706103`*^9, 3.7386829640435095`*^9}, {3.738683414131033*^9, 
  3.738683447157791*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Matlab notes", "Subsubsubsection",
 CellChangeTimes->{{3.73868291367918*^9, 3.738682916548502*^9}}],

Cell[TextData[{
 "The Matlab code has two sparse matrix classes. ",
 StyleBox["spd", "Input"],
 " matrices, used for price differences, are sparse in the usual sense. ",
 StyleBox["spl", "Input"],
 " matrices are level sparse."
}], "Text",
 CellChangeTimes->{{3.7386822616385717`*^9, 3.738682727176875*^9}, {
  3.738682925986231*^9, 3.738682925986231*^9}}],

Cell["A VECM analysis involves four types of data series: ", "Text",
 CellChangeTimes->{{3.7386822616385717`*^9, 3.738682727176875*^9}, {
  3.7386829282293224`*^9, 3.738682946479439*^9}, {3.7386830388723984`*^9, 
  3.7386830800313463`*^9}}],

Cell[CellGroupData[{

Cell["constant vectors", "Item1",
 CellChangeTimes->{{3.7386830915715146`*^9, 3.73868309582614*^9}}],

Cell[TextData[{
 StyleBox["spd", "Input"],
 " vectors (like price changes)"
}], "Item1",
 CellChangeTimes->{{3.7386830915715146`*^9, 3.738683106350972*^9}}],

Cell[TextData[{
 StyleBox["spl", "Input"],
 " vectors (like cointegrating vectors)"
}], "Item1",
 CellChangeTimes->{{3.7386830915715146`*^9, 3.738683145897266*^9}}],

Cell[TextData[{
 StyleBox["spd", "Input"],
 " vectors operated on by PDLs"
}], "Item1",
 CellChangeTimes->{{3.7386830915715146`*^9, 3.7386831572189875`*^9}, {
  3.738683234274936*^9, 3.738683253768817*^9}}]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["Crossproduct", "Input"],
 " class has static methods (functions) to compute crossproducts involving \
all pairwise combinations of these types."
}], "Text",
 CellChangeTimes->{{3.738683160424416*^9, 3.738683223862805*^9}, {
  3.7386832600250793`*^9, 3.7386832658116455`*^9}, {3.7386833928329782`*^9, 
  3.7386834045666227`*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
ScreenStyleEnvironment->"Printout",
WindowSize->{1904, 1022},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{612, 792},
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->{{54, 54}, {72, 72}}},
FontSize->15,
Magnification->1.25,
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (September 21, 2016)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> 
     FrontEnd`FileName[{"Article"}, "JournalArticle.nb", CharacterEncoding -> 
       "UTF-8"]]], 
   Cell[
    StyleData["Text", "Printout"], FontSize -> 14]}, Visible -> False, 
  FrontEndVersion -> 
  "11.0 for Microsoft Windows (64-bit) (September 21, 2016)", 
  StyleDefinitions -> "PrivateStylesheetFormatting.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "forecast"->{
  Cell[10809, 309, 1860, 48, 143, "EquationNumbered",
   CellTags->"forecast"]},
 "polyUp"->{
  Cell[87613, 2473, 494, 7, 56, "Section",
   CellTags->"polyUp"]},
 "polyCross"->{
  Cell[102974, 2943, 236, 3, 56, "Section",
   CellTags->"polyCross"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"forecast", 256834, 7082},
 {"polyUp", 256928, 7085},
 {"polyCross", 257012, 7088}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 343, 5, 134, "Title"],
Cell[926, 29, 231, 6, 60, "Subtitle"],
Cell[1160, 37, 313, 7, 116, "Text"],
Cell[CellGroupData[{
Cell[1498, 48, 98, 1, 32, "Subtitle"],
Cell[1599, 51, 925, 14, 94, "Text"],
Cell[2527, 67, 864, 13, 71, "Text"],
Cell[CellGroupData[{
Cell[3416, 84, 184, 2, 56, "Section"],
Cell[3603, 88, 682, 18, 27, "Text"],
Cell[4288, 108, 1026, 28, 35, "EquationNumbered"],
Cell[5317, 138, 1886, 62, 73, "Text"],
Cell[7206, 202, 1801, 48, 164, "Equation"],
Cell[9010, 252, 1796, 55, 117, "Text"],
Cell[10809, 309, 1860, 48, 143, "EquationNumbered",
 CellTags->"forecast"],
Cell[12672, 359, 351, 9, 49, "Text"],
Cell[13026, 370, 1269, 27, 72, "Text"],
Cell[14298, 399, 1796, 54, 73, "Text"],
Cell[16097, 455, 570, 13, 136, "EquationNumbered"],
Cell[16670, 470, 131, 1, 27, "Text"],
Cell[16804, 473, 401, 10, 33, "Equation"],
Cell[17208, 485, 733, 18, 71, "Text"],
Cell[17944, 505, 547, 16, 49, "Text"],
Cell[18494, 523, 477, 14, 33, "EquationNumbered"],
Cell[18974, 539, 738, 25, 27, "Text"],
Cell[19715, 566, 824, 18, 49, "Text"],
Cell[20542, 586, 2777, 81, 93, "EquationNumbered"],
Cell[23322, 669, 229, 5, 27, "Text"],
Cell[23554, 676, 664, 18, 70, "Equation"],
Cell[24221, 696, 1386, 46, 51, "Text"],
Cell[25610, 744, 785, 19, 35, "EquationNumbered"],
Cell[26398, 765, 305, 6, 27, "Text"],
Cell[26706, 773, 2751, 73, 118, "EquationNumbered"],
Cell[29460, 848, 764, 19, 50, "Text"],
Cell[CellGroupData[{
Cell[30249, 871, 114, 1, 39, "Subsection"],
Cell[30366, 874, 563, 9, 49, "Text"],
Cell[30932, 885, 610, 15, 262, "Equation"],
Cell[31545, 902, 1429, 36, 116, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[33023, 944, 95, 1, 56, "Section"],
Cell[33121, 947, 3900, 110, 206, "Text"],
Cell[37024, 1059, 1521, 32, 49, "Text"],
Cell[38548, 1093, 578, 15, 70, "Equation"],
Cell[39129, 1110, 495, 11, 49, "Text"],
Cell[39627, 1123, 1538, 50, 71, "Text"],
Cell[41168, 1175, 4215, 116, 313, "Equation"],
Cell[45386, 1293, 181, 3, 27, "Text"],
Cell[45570, 1298, 1889, 52, 116, "Text"],
Cell[47462, 1352, 3731, 108, 262, "Equation"],
Cell[51196, 1462, 322, 4, 27, "Text"],
Cell[51521, 1468, 3185, 89, 258, "EquationNumbered"],
Cell[54709, 1559, 2036, 43, 116, "Text"],
Cell[56748, 1604, 3604, 107, 168, "Text"],
Cell[60355, 1713, 733, 23, 72, "Equation"],
Cell[61091, 1738, 1627, 42, 74, "Text"],
Cell[62721, 1782, 1137, 34, 73, "Equation"],
Cell[63861, 1818, 971, 25, 72, "Equation"],
Cell[64835, 1845, 2150, 54, 77, "Text"],
Cell[66988, 1901, 3375, 87, 262, "Equation"],
Cell[70366, 1990, 1489, 33, 74, "Text"],
Cell[71858, 2025, 1233, 36, 109, "Equation",
 InitializationCell->True],
Cell[73094, 2063, 181, 4, 27, "Text"],
Cell[73278, 2069, 1752, 46, 58, "Equation"],
Cell[75033, 2117, 173, 2, 27, "Text"],
Cell[75209, 2121, 57, 1, 33, "Equation"],
Cell[75269, 2124, 2772, 76, 109, "Equation"],
Cell[78044, 2202, 214, 4, 27, "Text"],
Cell[78261, 2208, 2935, 80, 109, "Equation"],
Cell[81199, 2290, 2421, 57, 121, "Text"],
Cell[83623, 2349, 971, 28, 72, "Equation"],
Cell[84597, 2379, 1732, 46, 121, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[86366, 2430, 97, 1, 56, "Section"],
Cell[86466, 2433, 343, 9, 27, "Text"],
Cell[86812, 2444, 331, 7, 49, "Text"],
Cell[87146, 2453, 280, 8, 27, "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[87487, 2468, 101, 1, 88, "Title"],
Cell[CellGroupData[{
Cell[87613, 2473, 494, 7, 56, "Section",
 CellTags->"polyUp"],
Cell[88110, 2482, 167, 2, 27, "Text"],
Cell[88280, 2486, 584, 11, 40, "Input"],
Cell[88867, 2499, 539, 13, 28, "Text"],
Cell[89409, 2514, 1139, 24, 46, "Input"],
Cell[CellGroupData[{
Cell[90573, 2542, 423, 12, 40, "Input"],
Cell[90999, 2556, 1334, 39, 43, "Output"]
}, Open  ]],
Cell[92348, 2598, 294, 7, 28, "Text"],
Cell[CellGroupData[{
Cell[92667, 2609, 748, 21, 69, "Input"],
Cell[93418, 2632, 250, 5, 40, "Output"]
}, Open  ]],
Cell[93683, 2640, 290, 7, 28, "Text"],
Cell[CellGroupData[{
Cell[93998, 2651, 703, 20, 40, "Input"],
Cell[94704, 2673, 221, 4, 40, "Output"]
}, Open  ]],
Cell[94940, 2680, 194, 2, 27, "Text"],
Cell[CellGroupData[{
Cell[95159, 2686, 538, 16, 40, "Input"],
Cell[95700, 2704, 630, 22, 76, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[96367, 2731, 919, 25, 69, "Input"],
Cell[97289, 2758, 247, 4, 40, "Output"]
}, Open  ]],
Cell[97551, 2765, 296, 7, 28, "Text"],
Cell[CellGroupData[{
Cell[97872, 2776, 930, 27, 77, "Input"],
Cell[98805, 2805, 272, 5, 40, "Output"]
}, Open  ]],
Cell[99092, 2813, 194, 2, 27, "Text"],
Cell[CellGroupData[{
Cell[99311, 2819, 978, 31, 69, "Input"],
Cell[100292, 2852, 899, 32, 76, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[101228, 2889, 1523, 43, 103, "Input"],
Cell[102754, 2934, 171, 3, 40, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[102974, 2943, 236, 3, 56, "Section",
 CellTags->"polyCross"],
Cell[CellGroupData[{
Cell[103235, 2950, 113, 1, 28, "Subsubsubsection"],
Cell[103351, 2953, 492, 9, 40, "Input"],
Cell[103846, 2964, 497, 9, 27, "Text"],
Cell[CellGroupData[{
Cell[104368, 2977, 1108, 24, 74, "Input"],
Cell[105479, 3003, 1498, 31, 111, "Output"]
}, Open  ]],
Cell[106992, 3037, 1233, 35, 73, "Text"],
Cell[CellGroupData[{
Cell[108250, 3076, 2277, 50, 234, "Input"],
Cell[110530, 3128, 1178, 30, 209, "Output"]
}, Open  ]],
Cell[111723, 3161, 203, 7, 27, "Text"],
Cell[111929, 3170, 222, 6, 42, "Input"],
Cell[112154, 3178, 85, 1, 27, "Text"],
Cell[CellGroupData[{
Cell[112264, 3183, 459, 14, 69, "Input"],
Cell[112726, 3199, 743, 25, 209, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[113518, 3230, 127, 1, 28, "Subsubsubsection"],
Cell[CellGroupData[{
Cell[113670, 3235, 947, 27, 151, "Input"],
Cell[114620, 3264, 3810, 112, 307, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[118467, 3381, 1144, 30, 151, "Input"],
Cell[119614, 3413, 3510, 106, 258, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[123161, 3524, 960, 23, 124, "Input"],
Cell[124124, 3549, 2472, 72, 258, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[126633, 3626, 1232, 31, 86, "Input"],
Cell[127868, 3659, 2030, 58, 111, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[129935, 3722, 1280, 31, 86, "Input"],
Cell[131218, 3755, 2126, 59, 111, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[133393, 3820, 216, 3, 28, "Subsubsubsection"],
Cell[133612, 3825, 1025, 28, 53, "Text"],
Cell[CellGroupData[{
Cell[134662, 3857, 2972, 66, 206, "Input"],
Cell[137637, 3925, 27778, 760, 513, "Output"]
}, Open  ]],
Cell[165430, 4688, 303, 6, 49, "Text"],
Cell[165736, 4696, 676, 16, 28, "Text"],
Cell[CellGroupData[{
Cell[166437, 4716, 2672, 73, 270, "Input"],
Cell[169112, 4791, 6485, 168, 83, "Output"]
}, Open  ]],
Cell[175612, 4962, 379, 8, 28, "Text"],
Cell[175994, 4972, 1140, 26, 33, "Text"],
Cell[177137, 5000, 807, 16, 51, "Text"],
Cell[177947, 5018, 317, 7, 40, "Input"],
Cell[178267, 5027, 1037, 24, 46, "Input"],
Cell[CellGroupData[{
Cell[179329, 5055, 806, 16, 69, "Input"],
Cell[180138, 5073, 7194, 197, 479, "Output"]
}, Open  ]],
Cell[187347, 5273, 305, 8, 28, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[187689, 5286, 370, 4, 39, "Subsection"],
Cell[CellGroupData[{
Cell[188084, 5294, 253, 5, 28, "Subsubsection"],
Cell[188340, 5301, 1434, 37, 116, "Text"],
Cell[CellGroupData[{
Cell[189799, 5342, 459, 10, 29, "Subitem"],
Cell[190261, 5354, 358, 8, 29, "Subitem"],
Cell[190622, 5364, 502, 15, 29, "Subitem"]
}, Open  ]],
Cell[191139, 5382, 355, 10, 28, "Text"],
Cell[CellGroupData[{
Cell[191519, 5396, 1987, 49, 234, "Input"],
Cell[193509, 5447, 1920, 53, 258, "Output"]
}, Open  ]],
Cell[195444, 5503, 228, 6, 28, "Text"],
Cell[CellGroupData[{
Cell[195697, 5513, 5728, 123, 371, "Input"],
Cell[201428, 5638, 18606, 485, 203, "Output"]
}, Open  ]],
Cell[220049, 6126, 310, 6, 27, "Text"],
Cell[CellGroupData[{
Cell[220384, 6136, 5411, 127, 324, "Input"],
Cell[225798, 6265, 6494, 169, 78, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[232341, 6440, 221, 4, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[232587, 6448, 6284, 134, 453, "Input"],
Cell[CellGroupData[{
Cell[238896, 6586, 785, 14, 31, "Print"],
Cell[239684, 6602, 787, 14, 31, "Print"],
Cell[240474, 6618, 789, 14, 31, "Print"],
Cell[241266, 6634, 793, 14, 31, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[242120, 6655, 115, 1, 27, "Subsubsection"],
Cell[242238, 6658, 363, 6, 49, "Text"],
Cell[CellGroupData[{
Cell[242626, 6668, 112, 1, 28, "Subsubsubsection"],
Cell[242741, 6671, 1182, 35, 94, "Text"],
Cell[243926, 6708, 341, 6, 27, "Text"],
Cell[244270, 6716, 586, 15, 49, "Text"],
Cell[244859, 6733, 1898, 52, 70, "Equation"],
Cell[246760, 6787, 714, 21, 27, "Text"],
Cell[CellGroupData[{
Cell[247499, 6812, 1571, 40, 151, "Input"],
Cell[249073, 6854, 3668, 99, 258, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[252790, 6959, 109, 1, 28, "Subsubsubsection"],
Cell[252902, 6962, 1057, 25, 94, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[253996, 6992, 105, 1, 28, "Subsubsubsection"],
Cell[254104, 6995, 356, 8, 50, "Text"],
Cell[254463, 7005, 240, 3, 27, "Text"],
Cell[CellGroupData[{
Cell[254728, 7012, 100, 1, 23, "Item1"],
Cell[254831, 7015, 156, 4, 24, "Item1"],
Cell[254990, 7021, 164, 4, 24, "Item1"],
Cell[255157, 7027, 206, 5, 24, "Item1"]
}, Open  ]],
Cell[255378, 7035, 364, 8, 50, "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

