*	takes two currencies in any order and returns the 'standard' pair;
%macro getPair(b,s);
length pair $ 7;
pair = "";
length cBase cQuote c1 c2 $ 3;
cBase = "";
cQuote = "";
%macro setPair(a);
	if &b=&a then do;
		pair = &a || '/' || &s;
		goto gotPair;
	end;
	else if &s=&a then do;
		pair = &a || '/' || &b;
		goto gotPair;
	end;
%mend setPair;
if (&b^="   ") and (&s^="   ") then do;
%setPair('EUR');
%setPair('GBP');
%setPair('AUD');
%setPair('NZD');
%setPair('USD');
%setPair('CAD');
%setPair('CHF');
if &b in ('SEK','NOK') and &s in('SEK','NOK') then pair='NOK/SEK';
end;
gotPair:
if pair^="" then do;
	cBase = substr(pair,1,3);
	cQuote = substr(pair,5,3);
	validPair = 1;
end;
else do;
	c1 = &b;
	c2 = &s;
	if &s<&b then do;
		c1 = &s;
		c2 = &b;
	end;
	pair=c1 || '.' || c2;
	validPair = 0;
end;
drop c1 c2;
%mend getPair;
