x 'cd c:\Active\CointProgs02';
title "Build01";
*
	Build01 takes as input a binary data file (bdata.dat).  
	Each record in the file can be read with the statement:

	input symbol2 $8. date ib4. price rb8. time pibr4.

	Build01 produces two output datasets:
	Prices		Each observation is: symbol time price
	PriceMap	One observation per day.  Each observation contains
				pointers within the Prices dataset;

libname this ".\Sas Datasets";
options nocenter;

data this.Prices;
	infile 'bdata.dat' recfm=n;
	input symbol2 $8. date ib4. price rb8. time pibr4.;
	length default=4 symbol $ 4;
	symbol2 = compress(symbol2,'.');
	symbol = substr(symbol2,1,4);
	yy = floor(date/10000);
	mm = floor( mod(date,10000)/100);
	dd = mod(date,100);
	date = mdy(mm,dd,yy);
	format date date.;
	format time time.;
	drop yy mm dd symbol2;
	if symbol = 'SPY' then price=10*price;
	run;
proc sort data=this.Prices;
	by date symbol time;
proc freq data=this.Prices;
	tables date / out=this.PriceMap (drop=percent);
data this.PriceMap;
	set this.PriceMap;
	retain n 0;
	First = n+1;
	Last = First + Count - 1;
	output;
	n = n + Count;
	drop n;
	format First comma10. Last comma10. Count comma10.;
proc print data=this.PriceMap;
	run;
proc contents data=this.Prices;
proc print data=this.Prices (obs=10);
proc tabulate data=this.Prices format=comma8. noseps;
	class symbol date;
	table (all date),symbol;
	run;