function LoadMfile(FilePath)
%	Affiche le script selectionne dans une fenetre de visualisation
%	Display a M script in a browsing figure
%	
%	LoadMfile(FileName)

%	MaD@ESIGETEL, 1999.
fig = findobj('Tag', 'LoadMfile');
if isempty(fig)
   load LoadMfile

h0 = figure('Units','points', ...
	'CloseRequestFcn','MHclosereq', ...
	'Color',[0.7529411764705882 0.7529411764705882 0.7529411764705882], ...
	'IntegerHandle','off', ...
	'Interruptible','off', ...
	'MenuBar','none', ...
	'Name','M File Browser', ...
	'NumberTitle','off', ...
	'Position',[54.75 273 344.25 261.75], ...
	'Tag','LoadMfile');
h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[1 1 1], ...
	'FontName','Courier', ...
	'FontSize',10, ...
	'Interruptible','off', ...
	'Max',2, ...
	'Position',[0.75 30 344.25 231], ...
   'String', ' ', ...
	'Style','listbox', ...
	'Tag','MfileContent', ...
	'Value',1);
h2 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'Callback',mat2, ...
	'FontSize',10, ...
	'FontWeight','bold', ...
	'ListboxTop',0, ...
	'Position',[54.75 6.75 226.5 19.5], ...
	'String','Delete selected line', ...
	'Tag','Pushbutton1');
h3 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[0.752941176470588 0.752941176470588 0.752941176470588], ...
	'ListboxTop',0, ...
	'Position',[285.75 8.25 53.25 17.25], ...
	'String','Bakup File', ...
	'Style','checkbox', ...
	'Tag','BackUp');
else
   h1 = findobj('Tag', 'MfileContent');
end
fp = fopen(FilePath, 'r');
if fp~=-1,
   Text = '';
   i = 0;
   while ~feof(fp),
      Line = fgetl(fp);
      Text = strvcat(Text, Line);
      i = i + 1;
   end
   fclose(fp);
else
   error('Cannot find specified file');
end
set(h1, 'Value', 1);
set(h1, 'String', Text);
return
% ========== EOF =============
