(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    166483,       5833]*)
(*NotebookOutlinePosition[    173177,       6016]*)
(*  CellTagsIndexPosition[    172315,       5989]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["\<\
Markov Chain Monte Carlo Algorithms for Bayesian Estimation of Microstructure \
Models\
\>", "Subtitle"],

Cell["\<\
Computational Appendix to \"Liquidity in the futures pits:
    Inferring market dynamics from incomplete data\"\
\>", "Subtitle"],

Cell["\<\
Joel Hasbrouck
May, 2002\
\>", "Subtitle"],

Cell[CellGroupData[{

Cell["Introduction", "Section"],

Cell["\<\
This appendix describes the Markov Chain Monte Carlo (MCMC) estimation of \
microstructure models with bid/ask spreads, discreteness, clustering and \
trade impacts. In all cases, the data are presumed to consist solely of trade \
prices and (optionally) trade volumes. The exposition discusses models of \
increasing complexity. The appendix is distributed in two forms: a text \
document, and a Mathematica notebook in which derivations are interspersed \
with the text.\
\>", "Text"],

Cell["\<\
The appendix presumes some exposure to Bayesian MCMC techniques. Textbook \
level discussions are given in Carlin and Louis (1996), Tanner (1996), \
Gamerman (1997), and Kim and Nelson (2000). Casella and George (1992), Chib \
and Greenberg (1995), and Chib and Greenberg (1996) also provide useful \
expositions.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "(",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " initializations)"
}], "Section",
  CellFrameLabels->{{None, Inherited}, {Inherited, Inherited}},
  TextAlignment->Right,
  CounterIncrements->"None"],

Cell["Evaluate this section first.", "Text"],

Cell[CellGroupData[{

Cell["Miscellaneous intializations", "Subsection"],

Cell["Standard packages", "Text"],

Cell[BoxData[{
    \(\(Needs["\<Statistics`ContinuousDistributions`\>"];\)\), "\n", 
    \(\(Needs["\<Algebra`InequalitySolve`\>"];\)\)}], "InputOnly",
  CellLabel->"In[1]:="],

Cell["Turn off spelling warnings.", "Text"],

Cell[BoxData[{
    \(\(Off[General::spell1];\)\ \), "\[IndentingNewLine]", 
    \(\(Off[General::spell];\)\)}], "InputOnly",
  CellLabel->"In[3]:="],

Cell[TextData[{
  "The following defines a transormation that formats \"",
  Cell[BoxData[
      \(TraditionalForm\` \[Rule] \)]],
  "\" as \"=\". (It just reworks the rule into a more familiar notation.)"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(RuleToEquals = 
        Rule[a_, b_] :> 
          HoldForm[
            HoldForm[a] "\<=\>"\ HoldForm[b]];\)\[IndentingNewLine] (*\ 
      For\ \(\(example\)\(:\)\)\ *) \), "\[IndentingNewLine]", 
    \({c \[Rule] 4, d \[Rule] 3} /. RuleToEquals // TableForm\)}], "Input",
  CellLabel->"In[5]:="],

Cell[BoxData[
    FormBox[
      InterpretationBox[GridBox[{
            {
              TagBox[
                RowBox[{
                  TagBox["c",
                    HoldForm], " ", "\<\"=\"\>", " ", 
                  TagBox["4",
                    HoldForm]}],
                HoldForm]},
            {
              TagBox[
                RowBox[{
                  TagBox["d",
                    HoldForm], " ", "\<\"=\"\>", " ", 
                  TagBox["3",
                    HoldForm]}],
                HoldForm]}
            },
          RowSpacings->1,
          ColumnSpacings->3,
          RowAlignments->Baseline,
          ColumnAlignments->{Left}],
        TableForm[ {
          HoldForm[ 
            Times[ 
              HoldForm[ c], "=", 
              HoldForm[ 4]]], 
          HoldForm[ 
            Times[ 
              HoldForm[ d], "=", 
              HoldForm[ 3]]]}]], TraditionalForm]], "Output",
  CellLabel->"Out[6]//TableForm="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Normal density and distribution functions", "Subsection"],

Cell[TextData[{
  "The expression ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi][\[Mu], \[Sigma], x]\)]],
  " denotes the normal density function for random variable x, with mean \
\[Mu] and standard deviation ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\)]],
  ". The following rule expands this definition."
}], "Text"],

Cell[BoxData[
    \(\(\[Phi]Def = \[Phi][\[Mu]_, \[Sigma]_, x_] :> 
          PDF[NormalDistribution[\[Mu], \[Sigma]], x];\)\)], "InputOnly",
  CellLabel->"In[7]:="],

Cell["For example, ", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Phi][m, s, z] /. \[Phi]Def\)], "Input",
  CellLabel->"In[8]:="],

Cell[BoxData[
    \(TraditionalForm\`\[ExponentialE]\^\(-\(\((z - m)\)\^2\/\(2\ \
s\^2\)\)\)\/\(\@\(2\ \[Pi]\)\ s\)\)], "Output",
  CellLabel->"Out[8]="]
}, Open  ]],

Cell[TextData[{
  "Similarly, the expression ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi][\[Mu], \[Sigma], a, 
          b] \[Congruent] \[Integral]\_a\%b \[Phi][\[Mu], \[Sigma], 
              x] \[DifferentialD]x\)]],
  " , i.e., the cumulative normal distribution function evaluated between ",
  Cell[BoxData[
      \(TraditionalForm\`a\ and\ b\)]],
  ". The following rule replaces this with the formula:"
}], "Text"],

Cell[BoxData[
    \(\(\[CapitalPhi]Def = \[CapitalPhi][\[Mu]_, \[Sigma]_, a_, b_] :> 
          CDF[NormalDistribution[\[Mu], \[Sigma]], b] - 
            CDF[NormalDistribution[\[Mu], \[Sigma]], a];\)\)], "InputOnly",
  CellLabel->"In[9]:="],

Cell["For example,", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CapitalPhi][2, 1, 1.5, 1.8] /. \[CapitalPhi]Def\)], "Input",
  CellLabel->"In[10]:="],

Cell[BoxData[
    \(TraditionalForm\`0.11220275183491013`\)], "Output",
  CellLabel->"Out[10]="]
}, Open  ]],

Cell[TextData[{
  "The following rule is useful to tell ",
  "Mathematica",
  " that ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\_u\)]],
  " is a real, positive number."
}], "Text"],

Cell[BoxData[
    \(\(\[Sigma]uAssumptions = {Re[\[Sigma]\_u\%2] > 0, 
          RealQ[\[Sigma]\_u], \[Sigma]\_u > 0};\)\)], "InputOnly",
  CellLabel->"In[11]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell["Finding the parameters of a normal density.", "Subsection"],

Cell[TextData[{
  "Sometimes we have a density that we know is proportional to a normal \
density, but working out the exact correspondence is algebraically tedious. \
In such situations, the following function (GetNormalForm) is useful.  That \
is, given a random variable ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  " and its density function ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " (which is assumed proportional to a normal density), GetNormalForm finds \
\[Mu] and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\)]],
  " such that ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  " is normal with mean \[Mu] and standard deviation \[Sigma]. Traditionally, \
this is done by \"completing the square\" of the exponent of ",
  Cell[BoxData[
      \(TraditionalForm\`e\)]],
  ".  Mathematica's symbolic equation solving makes the process easier."
}], "Text"],

Cell[BoxData[
    \(GetNormalForm[f_, 
        x_, \[Mu]Symbol_:  \[Mu]New, \[Sigma]Symbol_:  \[Sigma]New] := 
      Module[{h, fexp, e, 
          r}, \[IndentingNewLine]h = \[Kappa]New - \((x - \[Mu]New)\)\^2/\((2\
\ \[Sigma]New\^2)\); \[IndentingNewLine] (*\ 
          Find\ the\ exponent\ of\ E\ in\ the\ supplied\ function\ \
*) \[IndentingNewLine]fexp\  = \ \(Cases[DummyFactor*f, E^a_ \[Rule] a, 
              Infinity]\)[\([1]\)]; \[IndentingNewLine]e\  = \ 
          MapThread[
            Equal, {CoefficientList[fexp, x], 
              CoefficientList[h, x]}]; \[IndentingNewLine]r = 
          Simplify[
            Solve[e, {\[Mu]New, \[Sigma]New, \[Kappa]New}]]; \
\[IndentingNewLine] (*\ 
          Verify\ that\ the\ random\ variable\ does\ not\ appear\ in\ \(\(\
\[Kappa]New\)\(.\)\)\ *) \[IndentingNewLine]If[FreeQ[\[Kappa]New /. r, x], , 
          Print["\<Error in GetNormalForm.\>"]]; \[IndentingNewLine] (*\ 
          Eliminate\ references\ to\ \[Kappa]New\ *) \[IndentingNewLine]r = \
\(Select[#, FreeQ[#, \[Kappa]New] &] &\)\  /@ \ r; \[IndentingNewLine] (*\ 
          Eliminate\ solutions\ with\ negative\ \[Sigma]New\ \
*) \[IndentingNewLine]r = 
          Select[r, 
              FreeQ[#, \[Sigma]New \[Rule] Times[\(-1\), _]]\  && \ 
                  FreeQ[#, \[Sigma]New \[Rule] \(-1\)] &] // 
            Flatten; \[IndentingNewLine]r /. {\[Mu]New \[Rule] \[Mu]Symbol, \
\[Sigma]New \[Rule] \[Sigma]Symbol}]\)], "InputOnly",
  CellLabel->"In[12]:="],

Cell[TextData[{
  "For example suppose we know that a density ",
  Cell[BoxData[
      \(TraditionalForm\`f(z)\)]],
  " is normal and proportional to ",
  Cell[BoxData[
      \(TraditionalForm\`e\^\(\(-z\^2\)\/10 + z\/3\)\)]],
  ". Then"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GetNormalForm[E\^\(\(-z\^2\)\/10 + z\/3\), z]\)], "Input",
  CellLabel->"In[13]:="],

Cell[BoxData[
    \(TraditionalForm\`{\[Mu]New \[Rule] 
        5\/3, \[Sigma]New \[Rule] \@5}\)], "Output",
  CellLabel->"Out[13]="]
}, Open  ]],

Cell["or", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GetNormalForm[E\^\(\(-z\^2\)\/10 + z\/3\), z, MyMean, MySD]\)], "Input",\

  CellLabel->"In[14]:="],

Cell[BoxData[
    \(TraditionalForm\`{MyMean \[Rule] 5\/3, MySD \[Rule] \@5}\)], "Output",
  CellLabel->"Out[14]="]
}, Open  ]],

Cell["\<\
gives the mean and standard deviation for the distribution.  The implied \
density is\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\[Phi][MyMean, MySD, z] /. \[Phi]Def\) /. %\)], "Input",
  CellLabel->"In[15]:="],

Cell[BoxData[
    \(TraditionalForm\`\[ExponentialE]\^\(\(-\(1\/10\)\)\ \((z - 5\/3)\)\^2\)\
\/\@\(10\ \[Pi]\)\)], "Output",
  CellLabel->"Out[15]="]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Notation and conventions", "Section"],

Cell[TextData[{
  "A time-series variable written without a time subscript denotes the full \
sample, e.g., ",
  Cell[BoxData[
      \(TraditionalForm\`q = {q\_1, q\_2,  ... , q\_T}\)]],
  ". The subscript \"",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\\\)\(t\)\)\)]],
  "\" indicates the full sample except for the observation at time ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ", e.g., ",
  Cell[BoxData[
      \(TraditionalForm\`q\_\(\(\\\)\(t\)\) = {q\_1,  ... , q\_\(t - 1\), 
          q\_\(t + 1\),  ... , q\_T}\)]],
  ". "
}], "Text"],

Cell[TextData[{
  "\"Draw ",
  Cell[BoxData[
      \(TraditionalForm\`x | y, z\)]],
  "\" is shorthand for \"draw ",
  Cell[BoxData[
      FormBox[
        RowBox[{"x", Cell[""]}], TraditionalForm]]],
  " from ",
  Cell[BoxData[
      \(TraditionalForm\`f(x | y, z)\)]],
  ".\""
}], "Text"],

Cell[TextData[{
  "The expression ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi][\[Mu], \[Sigma], x]\)]],
  " denotes the normal density function for random variable x, with mean \
\[Mu] and standard deviation ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\)]],
  ". For example, we denote the normal density for a random variable ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  " with mean ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  " and standard deviation ",
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  " as ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi](m, \ s, \ z)\)]],
  ". Fully expanded,"
}], "Text"],

Cell[TextData[{
  " \t",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Phi](m, s, z)\), "=", 
          
          StyleBox[\(\[ExponentialE]\^\(-\(\((z - m)\)\^2\/\(2\ \
s\^2\)\)\)\/\(\@\(2\ \[Pi]\)\ s\)\),
            ScriptLevel->0]}], TraditionalForm]]]
}], "Text"],

Cell[TextData[{
  "Similarly, the expression ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi][\[Mu], \[Sigma], a, 
          b] \[Congruent] \[Integral]\_a\%b \[Phi][\[Mu], \[Sigma], 
              x] \[DifferentialD]x\)]],
  " , i.e., the cumulative normal distribution function evaluated between ",
  Cell[BoxData[
      \(TraditionalForm\`a\ and\ b\)]],
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Basic Roll model", "Section"],

Cell[CellGroupData[{

Cell["Model description", "Subsection"],

Cell["The basic Roll model is:", "Text"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`m\_t = m\_\(t - 1\) + u\_t\)]],
  " where ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(u\_t\), " ", "is", " ", "distributed", " ", "as", " ", "N", 
          Cell[TextData[{
            "(0,",
            Cell[BoxData[
                \(TraditionalForm\`\[Sigma]\_u\%2\)]],
            ")"
          }]]}], TraditionalForm]]],
  "\n",
  Cell[BoxData[
      \(TraditionalForm\`p\_t = m\_t + c\ q\_t\)]]
}], "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`m\_t\)]],
  " is the log efficient price, ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t\)]],
  " is the buy/sell (trade direction) indicator variable, ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t \[Element] {\(-1\), \(+1\)}\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  " is the is the half-spread, and ",
  Cell[BoxData[
      \(TraditionalForm\`p\_t\)]],
  " is the log transaction price. The increment to the log efficient price, \
",
  Cell[BoxData[
      \(TraditionalForm\`u\_t~\(N(0, \[Sigma]\_u\%2)\)\)]],
  "; ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\_u\%2\)]],
  " are constant parameters. The ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t\)]],
  " are independent of ",
  Cell[BoxData[
      \(TraditionalForm\`u\_t = \[CapitalDelta]\[VeryThinSpace]m\_t\)]],
  ", so trade directions are not informative.\n\tThe data consist of a sample \
of (log) transaction prices ",
  Cell[BoxData[
      \(TraditionalForm\`p = {p\_1,  ... , p\_T}\)]],
  ". The Gibbs sampler iterates over parameter draws and latent data draws. \
There are two parameters in the model, ",
  Cell[BoxData[
      \(TraditionalForm\`{\[Sigma]\_u, c}\)]],
  ". There are ",
  Cell[BoxData[
      \(TraditionalForm\`2  T\)]],
  " latent data items, ",
  Cell[BoxData[
      \(TraditionalForm\`{q, m}\)]],
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Moment estimates", "Subsection"],

Cell["The price difference is", "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\[VeryThinSpace]p\_t = 
        u\_t + c\[VeryThinSpace]\[CapitalDelta]\[VeryThinSpace]q\_t\)]]
}], "Text"],

Cell["The variance and first-order autocovariance are:", "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\_0 \[Congruent] 
          Var(\[CapitalDelta]\[VeryThinSpace]p\_t) = \(\[Sigma]\_u\%2 + \
\(c\^2\) \(Var(\[CapitalDelta]\[VeryThinSpace]q\_t)\) = \[Sigma]\_u\%2 + 
            2  c\^2\)\)]],
  "\n\t",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\_1 \[Congruent] 
          Cov(\[CapitalDelta]\[VeryThinSpace]p\_t, \[CapitalDelta]\
\[VeryThinSpace]p\_\(t - 1\)) = \(\(c\^2\) 
            E\[CapitalDelta]\[VeryThinSpace]\(q\_t\) \[CapitalDelta]\
\[VeryThinSpace]q\_\(t - 1\) = \(-c\^2\)\)\)]]
}], "Text"],

Cell["Solving:", "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\_u\%2 = \[Gamma]\_0 + 2  \[Gamma]\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`c = \@\(-\[Gamma]\_1\)\)]]
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  "(",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " code)"
}], "MathGroup"],

Cell["Note that Mathematica returns complex solutions", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MomentSolutions = 
      Solve[{\[Gamma]\_0 \[Equal] \[Sigma]\_u\%2 + 
              2  c\^2, \[Gamma]\_1 \[Equal] \(-c\^2\)}, {c, \[Sigma]\_u}]\)], \
"Input",
  CellLabel->"In[16]:="],

Cell[BoxData[
    \(TraditionalForm\`{{\[Sigma]\_u \[Rule] \(-\@\(\[Gamma]\_0 + 2\ \[Gamma]\
\_1\)\), c \[Rule] \(-\[ImaginaryI]\)\ \@\[Gamma]\_1}, {\[Sigma]\_u \[Rule] \
\(-\@\(\[Gamma]\_0 + 2\ \[Gamma]\_1\)\), 
        c \[Rule] \[ImaginaryI]\ \@\[Gamma]\_1}, {\[Sigma]\_u \[Rule] \@\(\
\[Gamma]\_0 + 2\ \[Gamma]\_1\), 
        c \[Rule] \(-\[ImaginaryI]\)\ \@\[Gamma]\_1}, {\[Sigma]\_u \[Rule] \@\
\(\[Gamma]\_0 + 2\ \[Gamma]\_1\), 
        c \[Rule] \[ImaginaryI]\ \@\[Gamma]\_1}}\)], "Output",
  CellLabel->"Out[16]="]
}, Open  ]],

Cell[TextData[{
  "Here are the solutions for ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\_u\%2\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Union[
      Simplify[{\[Sigma]\_u\%2, c} /. 
          MomentSolutions, {\[Gamma]\_1 \[Element] Reals, \[Gamma]\_1 < 0, 
          c \[Element] Reals}]]\)], "Input",
  CellLabel->"In[17]:="],

Cell[BoxData[
    FormBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(\[Gamma]\_0 + 2\ \[Gamma]\_1\), \(\@\(-\[Gamma]\_1\)\)},
            {\(\[Gamma]\_0 + 
                2\ \[Gamma]\_1\), \(\[ImaginaryI]\ \@\[Gamma]\_1\)}
            }], "\[NoBreak]", ")"}], TraditionalForm]], "Output",
  CellLabel->"Out[17]="]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Overview of the Bayesian sampler", "Subsection"],

Cell[TextData[{
  "In the Gibbs sampler, we start with any feasible set of values (a sample \
path) for ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  ". We then iterate over"
}], "Text"],

Cell[TextData[{
  "1. Parameter draw. Generate a random draw of ",
  Cell[BoxData[
      \(TraditionalForm\`c, \[Sigma]\_u | p, m, q\)]],
  "."
}], "Text"],

Cell[TextData[{
  "2. Latent data draw. Generate a random draw of ",
  Cell[BoxData[
      \(TraditionalForm\`m, q | c, \[Sigma]\_u, p\)]],
  "."
}], "Text"],

Cell["\<\
In the parameter draw, we condition on the most-recently drawn values of the \
latent data; in the latent data draw, we condition on the most recent \
parameter draw. We now discuss each of these draws in greater detail.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Parameter draws", "Subsection"],

Cell["\<\
The prior and posterior densities for the parameters are standard Bayesian \
results covered in most basic treatments, such as Carlin and Louis (1997), \
Tanner (1997).  Kim and Nelson (2000) discuss these results in a state-space \
context.\
\>", "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  "The draw for ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  ".\[VeryThinSpace]"
}], "Subsubsection"],

Cell[TextData[{
  "Given all of the other parameters and latent data ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\[VeryThinSpace]p\_t = \
\[CapitalDelta]\[VeryThinSpace]m\_t + 
          c\[VeryThinSpace]\[CapitalDelta]\[VeryThinSpace]q\_t\)]],
  ". Therefore, ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  " can be interpreted as the coefficient in the regression specification"
}], "Text"],

Cell[TextData[{
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\[VeryThinSpace]p\_t = 
        c\[VeryThinSpace]\[CapitalDelta]\[VeryThinSpace]q\_t + u\_t\)]],
  ". "
}], "NumberedEquation",
  CellTags->"cRegression"],

Cell["The classic Bayesian regression model is ", "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`y = X\[Beta] + u\)]],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`E\[VeryThinSpace]u\[VeryThinSpace]u\^\[Prime] = \
\[CapitalOmega]\_u\)]],
  ". "
}], "Text"],

Cell[TextData[{
  "If the prior distribution on the coefficients is normal: ",
  Cell[BoxData[
      \(TraditionalForm\`\[Beta]~\(N(\[Mu]\_\[Beta]\%Prior, \[CapitalOmega]\_\
\[Beta]\%Prior)\)\)]],
  ", then the posterior distribution for the coefficients is ",
  Cell[BoxData[
      \(TraditionalForm\`\[Beta] | 
        y~\(N(\[Mu]\_\[Beta]\%Posterior, \[CapitalOmega]\_\[Beta]\%Posterior)\
\)\)]],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`\[Mu]\_\[Beta]\%Posterior = D\[VeryThinSpace]d\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega]\_\[Beta]\%Posterior = D\^\(-1\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`D\^\(-1\) = \(X\^\[Prime]\) \
\(\[CapitalOmega]\_u\%\(-1\)\) 
            X + \((\[CapitalOmega]\_\[Beta]\%Prior)\)\^\(-1\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`d = \(X\^\[Prime]\) \(\[CapitalOmega]\_u\%\(-1\)\) 
            y + \(\((\[CapitalOmega]\_\[Beta]\%\(P  rior\))\)\^\(-1\)\) \[Mu]\
\_\[Beta]\%Prior\)]],
  ". "
}], "Text"],

Cell[TextData[{
  "In the present case, ",
  Cell[BoxData[
      \(TraditionalForm\`y = \([\[CapitalDelta]\[VeryThinSpace]p\_t]\)\)]],
  ", the column vector of price changes, ",
  Cell[BoxData[
      \(TraditionalForm\`X = \([\[CapitalDelta]\[VeryThinSpace]q\_t]\)\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega] = \[Sigma]\_u\%2\)]],
  ". We might take ",
  Cell[BoxData[
      \(TraditionalForm\`\[Mu]\_\[Beta]\%Prior = 0\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\[CapitalOmega]\_\[Beta]\%Prior\)\(=\)\)\)]],
  "some large number like ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(10\^6\)\(.\)\)\)]],
  " We would then compute ",
  Cell[BoxData[
      \(TraditionalForm\`\[Mu]\_\[Beta]\%Posterior\ and\ \[CapitalOmega]\_\
\[Beta]\%Posterior\)]],
  ", and make a random draw from the coefficient posterior."
}], "Text"],

Cell[TextData[{
  "On economic grounds, it is sensible to impose a non-negativity restriction \
on ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  ". The easiest way to do this is to let the prior be ",
  Cell[BoxData[
      \(TraditionalForm\`c~\(\(N\^+\)(0, \[CapitalOmega]\_c\%Prior)\)\)]],
  ", where the \"+\" superscript denotes restriction of the density to ",
  Cell[BoxData[
      \(TraditionalForm\`\(\([0, \(+\[Infinity]\)\)\()\)\)\)]],
  ". The posterior is then ",
  Cell[BoxData[
      \(TraditionalForm\`\(N\^+\)(\[Mu]\_c\%Posterior, \
\[CapitalOmega]\_c\%Posterior)\)]],
  ", where the parameters are computed exactly as in the unrestricted case."
}], "Text"],

Cell[TextData[{
  "(The nonnegativity restriction on ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  " is attractive from an economic perspective. It is also necessary for \
identification. The regression in eq. (",
  
  CounterBox["None"],
  ") is observationally equivalent if ",
  Cell[BoxData[
      FormBox[
        RowBox[{Cell[TextData[StyleBox["c",
            FontSlant->"Italic"]]], "  ", "and", "  ", "q", Cell[""]}], 
        TraditionalForm]]],
  " are replaced with ",
  Cell[BoxData[
      \(TraditionalForm\`\(-c\)\ and\  - q\)]],
  ".)"
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "The draw for ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\_u\)]]
}], "Subsubsection"],

Cell[TextData[{
  "With normal ",
  Cell[BoxData[
      \(TraditionalForm\`u\_t\)]],
  ", a natural prior for ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\_u\%2\)]],
  " is the inverted gamma distribution, denoted ",
  Cell[BoxData[
      \(TraditionalForm\`IG[\[Alpha]\^Prior, \[Beta]\^Prior]\)]],
  ". Then, given ",
  Cell[BoxData[
      \(TraditionalForm\`u = {u\_1,  ... , u\_T}\)]],
  ", the posterior is ",
  Cell[BoxData[
      \(TraditionalForm\`IG[\[Alpha]\^Posterior, \[Beta]\^Posterior]\)]],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha]\^Posterior = \[Alpha]\^Prior + T/2\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Beta]\^Posterior = \[Beta]\^Prior + \
\[CapitalSigma]\[VeryThinSpace]u\_t\%2/2\)]],
  "."
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Latent data draws", "Subsection"],

Cell[TextData[{
  "There are two latent series, ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  ", but one of these is redundant. (The ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " are known, and ",
  Cell[BoxData[
      \(TraditionalForm\`p = m + c\[VeryThinSpace]q\)]],
  ".) It suffices therefore to draw ",
  Cell[BoxData[
      \(TraditionalForm\`q | p, c, \[Sigma]\_u\)]],
  ". At this stage, ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\_u\)]],
  " are known, so for notational economy, these parameters will be dropped \
from the explicit conditioning set. To set up the draw:"
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{\(Pr(q | p)\), "=", 
        RowBox[{\(f(p | q)\), "\[Times]", \(Pr(q)\), "\[Times]", 
          StyleBox[\(1\/\(f(p)\)\),
            ScriptLevel->0]}]}], TraditionalForm]]]], "NumberedEquation",
  CellTags->"RollBayes0"],

Cell[TextData[{
  "Since the ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " are discrete random variables and the ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " are continuous, the joint distribution is written as ",
  Cell[BoxData[
      \(TraditionalForm\`\(f(p | q)\)\[Times]\((Pr(q)\)\)]],
  " to avoid writing an improper density function like \"",
  Cell[BoxData[
      \(TraditionalForm\`f(p, q)\)]],
  "\". In eq. (",
  
  CounterBox["NumberedEquation", "RollBayes0"],
  ") the last factor does not depend on ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  ". Furthermore, since buys and sells are unconditionally equally probable, \
",
  Cell[BoxData[
      \(TraditionalForm\`Pr(q) = \((1/2)\)\^T\)]],
  ". Therefore:"
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(Pr(q | p)\), "\[Proportional]", 
          RowBox[{\(f(p | q)\), Cell[""]}]}], 
        "=", \(\(f(m)\)\( | \_\(m = p - c\[VeryThinSpace]q\)\)\)}], 
      TraditionalForm]]]], "NumberedEquation",
  CellTags->"qCondp"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`f(m)\)]],
  " is the unconditional distribution of the ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  ". From the structure of the model, ",
  Cell[BoxData[
      \(TraditionalForm\`f(
          m) = \(f(m\_1)\) \(\[Product]\+\(t = 2\)\%T f(u\_t)\)\)]],
  " where ",
  Cell[BoxData[
      \(TraditionalForm\`u\_t = \[CapitalDelta]\[VeryThinSpace]m\_t\)]],
  ". The distribution of the initial realization of ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  " is taken as uniform in the region of interest, so this can be impounded \
into the constant of proportionality."
}], "Text"],

Cell[TextData[{
  "The direct approach to making the draw would be to enumerate all possible \
sample paths for ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  ", compute the unnormalized (i.e., up to the factor of proportionality) \
probabilities; normalize. Finally, we'd make the draw on the resulting \
discrete probability space. Given that the number of sample paths is ",
  Cell[BoxData[
      \(TraditionalForm\`2\^T\)]],
  ", the direct approach is not feasible."
}], "Text"],

Cell[TextData[{
  "Fortunately, it is not necessary to fully characterize ",
  Cell[BoxData[
      \(TraditionalForm\`Pr(q | p)\)]],
  " to make the draw. The next section describes a Gibbs sampler approach to \
the problem.\t"
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Gibbs sampler", "Subsection"],

Cell[TextData[{
  "At this stage, we assume that ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\_u\)]],
  " are known, so for notational economy, these parameters will be dropped \
from the explicit conditioning set. Furthermore, since the ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " are known, given ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  ", the ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  " are redundant. In the Gibbs sampler, ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t\)]],
  " draws are made sequentially. To distinguish the newly drawn ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t\)]],
  " from those left over from the previous draw, I denote the newly drawn \
values ",
  Cell[BoxData[
      \(TraditionalForm\`\(q\_t\%*\)\)]],
  ". The steps are then:"
}], "Text"],

Cell[TextData[{
  "1. ",
  Cell[BoxData[
      \(TraditionalForm\`Draw\ \(q\_1\%*\) 
        from\ \(Pr(q\_1 | p, q\_2, q\_3,  ... , q\_T)\)\)]]
}], "Text"],

Cell[TextData[{
  "2. ",
  Cell[BoxData[
      \(TraditionalForm\`Draw\ \(q\_2\%*\) 
        from\ \(Pr(q\_2 | p, \(q\_1\%*\), q\_3,  ... , q\_T)\)\)]]
}], "Text"],

Cell["\t\[VerticalEllipsis]", "Text"],

Cell[TextData[{
  "3. ",
  Cell[BoxData[
      \(TraditionalForm\`Draw\ \(q\_T\%*\)\ from\ \(Pr(
          q\_T | p, \(q\_1\%*\), \(q\_2\%*\),  ... , \(q\_\(T - 
                1\)\%*\))\)\)]]
}], "Text"],

Cell[TextData[{
  "Note that at each step, we use the fresh ",
  Cell[BoxData[
      \(TraditionalForm\`\(q\_t\%*\)\)]],
  " as they become available. The individual draws all follow a similar \
pattern. We will first consider the general case, the draw for ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t | p, q\_\(\(\\\)\(t\)\)\)]],
  " for ",
  Cell[BoxData[
      \(TraditionalForm\`1 < t < \(\(T\)\(.\)\)\)]],
  " The endpoint draws (at ",
  Cell[BoxData[
      \(TraditionalForm\`t = 1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`t = T\)]],
  ") follow as simple modifications. "
}], "Text"],

Cell[TextData[{
  "Given the structure of the model, ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(Pr(q\_t | p, q\_\(\(\\\)\(t\)\)) = 
            Pr(q\_t | p\_t, m\_\(t - 1\), m\_\(t + 1\))\),
          ScriptSizeMultipliers->0.71], TraditionalForm]]],
  ". That is, once we know ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(p\_t, m\_\(t - 1\), and\ m\_\(t + 1\)\),
          ScriptSizeMultipliers->0.71], TraditionalForm]]],
  ", the additional variables in the full conditioning set are not \
informative. To analyze ",
  Cell[BoxData[
      \(TraditionalForm\`Pr(q\_t | p\_t, m\_\(t - 1\), m\_\(t + 1\))\)]],
  ", note that by conventional conditional probability calculations"
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{\(Pr(q\_t | p\_t, m\_\(t - 1\), m\_\(t + 1\))\), "=", 
        StyleBox[\(\(\(f(p\_t | q\_t, \ m\_\(t - 1\), \ 
                  m\_\(t + 1\))\)\ \[Times]\(Pr(q\_t | m\_\(t - 1\), 
                  m\_\(t + 1\))\)\)\/\(f(p\_t | m\_\(t - 1\), 
                m\_\(t + 1\))\)\),
          ScriptLevel->0]}], TraditionalForm]]]], "NumberedEquation",
  CellTags->"RollBayes"],

Cell[TextData[{
  "When we actually need to evaluate this, ",
  Cell[BoxData[
      \(TraditionalForm\`p\_t\)]],
  " is known, so the denominator can be treated as a proportionality \
constant. Next, because the trade directions are independent of the efficient \
price evolution, ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(Pr(q\_t | m\_\(t - 1\), m\_\(t + 1\))\), "=", 
          RowBox[{\(Pr(q\_t)\), "=", 
            RowBox[{\(1/2\), Cell[""]}]}]}], TraditionalForm]]],
  ". Therefore, "
}], "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`Pr(q\_t | p\_t, m\_\(t - 1\), 
          m\_\(t + 1\)) \[Proportional] 
        f(p\_t | q\_t, m\_\(t - 1\), m\_\(t + 1\))\)]],
  ". "
}], "Text"],

Cell["To evaluate the r.h.s., note that ", "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`f(m\_t | m\_\(t - 1\), 
            m\_\(t + 1\)) \[Proportional] \(f(m\_\(t + 1\) | m\_t)\) \(f(
              m\_t | m\_\(t - 1\))\) = \(\[Phi](0, \[Sigma]\_u, 
            m\_t - m\_\(t - 1\))\)\ \(\[Phi](0, \[Sigma]\_u, 
            m\_\(t + 1\) - m\_t)\)\)]]
}], "Text"],

Cell["The last expression is:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ff = \(\[Phi][0, \[Sigma]\_u, u\_t] \[Phi][0, \[Sigma]\_u, 
              u\_\(t + 1\)] /. 
          u\_t_ \[Rule] m\_t - m\_\(t - 1\)\) /. \[Phi]Def\)], "Input",
  CellLabel->"In[18]:="],

Cell[BoxData[
    \(TraditionalForm\`\[ExponentialE]\^\(\(-\(\((m\_t - m\_\(t - 1\))\)\^2\/\
\(2\ \[Sigma]\_u\%2\)\)\) - \((m\_\(t + 1\) - m\_t)\)\^2\/\(2\ \[Sigma]\_u\%2\
\)\)\/\(2\ \[Pi]\ \[Sigma]\_u\%2\)\)], "Output",
  CellLabel->"Out[18]="]
}, Open  ]],

Cell["This implies ", "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`f(m\_t | m\_\(t - 1\), 
        m\_\(t + 1\)) = \[Phi](\[Mu]\_t, \[Sigma]\_t, 
        m\_t)\)]]], "NumberedEquation",
  CellTags->"RollDensity"],

Cell["where", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(mParams = 
        GetNormalForm[ff, 
          m\_t, \[Mu]\_t, \[Sigma]\_t];\)\), "\[IndentingNewLine]", 
    \(mParams /. RuleToEquals // TableForm\)}], "Input",
  CellLabel->"In[19]:="],

Cell[BoxData[
    FormBox[
      InterpretationBox[GridBox[{
            {
              TagBox[
                RowBox[{
                  TagBox[\(\[Mu]\_t\),
                    HoldForm], " ", "\<\"=\"\>", " ", 
                  RowBox[{"(", 
                    TagBox[\(1\/2\ \((m\_\(t - 1\) + m\_\(t + 1\))\)\),
                      HoldForm], ")"}]}],
                HoldForm]},
            {
              TagBox[
                RowBox[{
                  TagBox[\(\[Sigma]\_t\),
                    HoldForm], " ", "\<\"=\"\>", " ", 
                  TagBox[\(\[Sigma]\_u\/\@2\),
                    HoldForm]}],
                HoldForm]}
            },
          RowSpacings->1,
          ColumnSpacings->3,
          RowAlignments->Baseline,
          ColumnAlignments->{Left}],
        TableForm[ {
          HoldForm[ 
            Times[ 
              HoldForm[ 
                Subscript[ \[Mu], t]], "=", 
              HoldForm[ 
                Times[ 
                  Rational[ 1, 2], 
                  Plus[ 
                    Subscript[ m, 
                      Plus[ -1, t]], 
                    Subscript[ m, 
                      Plus[ 1, t]]]]]]], 
          HoldForm[ 
            Times[ 
              HoldForm[ 
                Subscript[ \[Sigma], t]], "=", 
              HoldForm[ 
                Times[ 
                  Power[ 2, 
                    Rational[ -1, 2]], 
                  Subscript[ \[Sigma], u]]]]]}]], TraditionalForm]], "Output",\

  CellLabel->"Out[20]//TableForm="]
}, Open  ]],

Cell[TextData[{
  "Since ",
  Cell[BoxData[
      \(TraditionalForm\`p\_t = m\_t + c\[VeryThinSpace]q\_t\)]],
  ", "
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      StyleBox[\(f(p\_t | q\_t, m\_\(t - 1\), 
            m\_\(t + 1\)) = \[Phi](\[Mu]\_t, \[Sigma]\_t, 
            p\_t - c\[VeryThinSpace]q\_t)\),
        "Caption"], TraditionalForm]]]], "NumberedEquation",
  CellTags->"Rollfm"],

Cell[CellGroupData[{

Cell[TextData[{
  "The unnormalized probabilities of a buy and a sell are given by evaluating \
the above quantity at ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t = \(+1\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t = \(-1\)\)]],
  " respectively. The normalized probability of a buy is therefore"
}], "TextGroup"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(PQ = \[Phi][\[Mu]\_t, \[Sigma]\_t, p\_t - c\ q\_t] /. 
          mParams;\)\), "\[IndentingNewLine]", 
    \(\(PQ /. q\_t \[Rule] \(+1\)\)\/\(\((PQ /. q\_t \[Rule] \(+1\))\) + \
\((PQ /. q\_t \[Rule] \(-1\))\)\)\)}], "Input",
  CellLabel->"In[21]:="],

Cell[BoxData[
    \(TraditionalForm\`\(\[Phi](1\/2\ \((m\_\(t - 1\) + m\_\(t + 1\))\), \
\[Sigma]\_u\/\@2, p\_t - c)\)\/\(\[Phi](1\/2\ \((m\_\(t - 1\) + m\_\(t + 1\))\
\), \[Sigma]\_u\/\@2, p\_t - c) + \[Phi](1\/2\ \((m\_\(t - 1\) + m\_\(t + \
1\))\), \[Sigma]\_u\/\@2, c + p\_t)\)\)], "Output",
  CellLabel->"Out[22]="]
}, Open  ]],

Cell["This simplifies to", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(% /. \[Phi]Def // Simplify\)], "Input",
  CellLabel->"In[23]:="],

Cell[BoxData[
    \(TraditionalForm\`\[ExponentialE]\^\(\(4\ c\ \
p\_t\)\/\[Sigma]\_u\%2\)\/\(\[ExponentialE]\^\(\(2\ c\ \((m\_\(t - 1\) + \
m\_\(t + 1\))\)\)\/\[Sigma]\_u\%2\) + \[ExponentialE]\^\(\(4\ c\ p\_t\)\/\
\[Sigma]\_u\%2\)\)\)], "Output",
  CellLabel->"Out[23]="]
}, Open  ]],

Cell[TextData[{
  "Given ",
  Cell[BoxData[
      \(TraditionalForm\`p\_t, \ m\_\(t - 1\), \ m\_\(t + 1\), \ 
      c\ and\ \[Sigma]\_u\%2, \ 
      we\ can\ compute\ this\ and\ make\ the\ \(\(draw\)\(.\)\)\)]],
  " For example, with ",
  Cell[BoxData[
      \(TraditionalForm\`{m\_\(t - 1\) = 5, m\_\(t + 1\) = 5.1`, p\_t = 5.2`, 
        c = 0.2, \[Sigma]\_u = 0.4`}\)], "Caption"],
  ", the probability of a buy is 0.679. Intuitively, we can rationalize this \
value in the following way.  Given that ",
  Cell[BoxData[
      \(TraditionalForm\`m\_\(t - 1\) = 5\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`m\_\(t + 1\) = 5.1\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`E\[VeryThinSpace]m\_t = 5.05\)]],
  ". That the transaction price lies above this makes it more likely that the \
trade was a \"buy\". "
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "(",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " code)"
}], "MathGroup"],

Cell[CellGroupData[{

Cell[BoxData[
    \(%\  /. \ {m\_\(t - 1\) \[Rule] 5, m\_\(t + 1\) \[Rule] 5.1, 
        p\_t \[Rule] 5.20, c \[Rule] 0.2, \[Sigma]\_u \[Rule] 0.4}\)], "Input",\

  CellLabel->"In[24]:="],

Cell[BoxData[
    \(TraditionalForm\`0.6791786991753931`\)], "Output",
  CellLabel->"Out[24]="]
}, Open  ]],

Cell[TextData[{
  "We now consider the endpoint draws, ",
  Cell[BoxData[
      \(TraditionalForm\`\((t = \(1\ and\ t = T\))\)\)]],
  ", which are slightly different."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`t = 1\)]]], "Subsubsection"],

Cell[TextData[{
  "At ",
  Cell[BoxData[
      \(TraditionalForm\`t = 1\)]],
  ", the relevant conditional density is ",
  Cell[BoxData[
      \(TraditionalForm\`f(m\_1 | m\_2)\)]],
  ", which is proportional to ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{\(f(m\_2 | m\_1)\), Cell[""]}], 
          "=", \(\[Phi](0, \[Sigma]\_u, m\_2 - m\_1)\)}], TraditionalForm]]],
  ". Substituting in for ",
  Cell[BoxData[
      \(TraditionalForm\`m\_1\)]],
  " gives ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi](0, \[Sigma]\_u, m\_2 - p\_1 + c\ q\_1)\)], 
    "Caption"],
  ". The unnormalized probabilities for a buy and sell are given by \
evaluating this at ",
  Cell[BoxData[
      \(TraditionalForm\`q\_1 = \(+1\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`q\_1 = \(-1\)\)]],
  ". The normalized probability of a buy is:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Clear[u, \[Sigma], m, c, p, q];\)\), "\[IndentingNewLine]", 
    \(\(PQ = \(\[Phi][0, \[Sigma]\_u, u\_2] /. u\_2 \[Rule] m\_2 - m\_1\) /. 
          m\_1 \[Rule] p\_1 - c\ q\_1;\)\), "\[IndentingNewLine]", 
    \(\(PQ /. q\_1 \[Rule] \(+1\)\)\/\(\((PQ /. q\_1 \[Rule] \(+1\))\) + \
\((PQ /. q\_1 \[Rule] \(-1\))\)\)\)}], "Input",
  CellLabel->"In[25]:="],

Cell[BoxData[
    \(TraditionalForm\`\(\[Phi](0, \[Sigma]\_u, c + m\_2 - \
p\_1)\)\/\(\[Phi](0, \[Sigma]\_u, \(-c\) + m\_2 - p\_1) + \[Phi](0, \
\[Sigma]\_u, c + m\_2 - p\_1)\)\)], "Output",
  CellLabel->"Out[27]="]
}, Open  ]],

Cell["This simplifies to:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(% /. \[Phi]Def // Simplify\)], "Input",
  CellLabel->"In[28]:="],

Cell[BoxData[
    \(TraditionalForm\`\[ExponentialE]\^\(\(2\ c\ \
p\_1\)\/\[Sigma]\_u\%2\)\/\(\[ExponentialE]\^\(\(2\ c\ m\_2\)\/\[Sigma]\_u\%2\
\) + \[ExponentialE]\^\(\(2\ c\ p\_1\)\/\[Sigma]\_u\%2\)\)\)], "Output",
  CellLabel->"Out[28]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`t = T\)]]], "Subsubsection"],

Cell[TextData[{
  "At time ",
  Cell[BoxData[
      \(TraditionalForm\`T\)]],
  " we have ",
  Cell[BoxData[
      \(TraditionalForm\`f(m\_T | m\_\(T - 1\)) = \[Phi](0, \[Sigma]\_u, 
          m\_T - m\_\(T - 1\))\)], "Caption"],
  ". Evaluated at ",
  Cell[BoxData[
      \(TraditionalForm\`m\_T = p\_T - c\[VeryThinSpace]q\_T\)], "Caption"],
  ",",
  " this becomes  ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi](
        0, \[Sigma]\_u, \(-m\_\(T - 1\)\) + p\_T - c\ q\_T)\)], "Caption"],
  ". The (unnormalized) probabilities for a buy and sell are given by \
evaluating this at ",
  Cell[BoxData[
      \(TraditionalForm\`q\_T = \(+1\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`q\_T = \(-1\)\)]],
  ". The normalized probability of a buy is:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(PQ = \(\[Phi][0, \[Sigma]\_u, u\_T] /. 
            u\_T \[Rule] m\_T - m\_\(T - 1\)\) /. 
          m\_T \[Rule] p\_T - c\ q\_T;\)\), "\[IndentingNewLine]", 
    \(\(PQ /. q\_T \[Rule] \(+1\)\)\/\(\((PQ /. q\_T \[Rule] \(+1\))\) + \
\((PQ /. q\_T \[Rule] \(-1\))\)\)\)}], "Input",
  CellLabel->"In[29]:="],

Cell[BoxData[
    \(TraditionalForm\`\(\[Phi](0, \[Sigma]\_u, \(-c\) - m\_\(T - 1\) + p\_T)\
\)\/\(\[Phi](0, \[Sigma]\_u, \(-c\) - m\_\(T - 1\) + p\_T) + \[Phi](0, \
\[Sigma]\_u, c - m\_\(T - 1\) + p\_T)\)\)], "Output",
  CellLabel->"Out[30]="]
}, Open  ]],

Cell["This evaluates and simplies to:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(% /. \[Phi]Def // Simplify\)], "Input",
  CellLabel->"In[31]:="],

Cell[BoxData[
    \(TraditionalForm\`\[ExponentialE]\^\(\(2\ c\ \
p\_T\)\/\[Sigma]\_u\%2\)\/\(\[ExponentialE]\^\(\(2\ c\ m\_\(T - 1\)\)\/\
\[Sigma]\_u\%2\) + \[ExponentialE]\^\(\(2\ c\ p\_T\)\/\[Sigma]\_u\%2\)\)\)], \
"Output",
  CellLabel->"Out[31]="]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Contemporaneous trade impacts on the efficient price", "Section"],

Cell[CellGroupData[{

Cell["Description", "Subsection"],

Cell["\<\
This model incorporates trade impacts on the efficient price, which are \
presumed to reflect the informationcontent of the trades.  The evolution of \
the efficient price is:\
\>", "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`m\_t = 
      m\_\(t - 1\) + \(q\_t\) \(V\_t\) \[Lambda] + 
        u\_t\)]]], "NumberedEquation",
  CellTags->"InformativeTradeModel"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`V\_t\)]],
  " is the volume of the trade, \[Lambda] is the impact coefficient, and ",
  Cell[BoxData[
      \(TraditionalForm\`p\_t\)]],
  " is the observed log transaction price. The quantity ",
  Cell[BoxData[
      \(TraditionalForm\`\(V\_t\) \[Lambda]\)]],
  " can be interpeted as a product of scalars, or a vector product, as in: ",
  Cell[BoxData[
      \(TraditionalForm\`V\_t = \([1\(\(\ \)\(\ \)\) 
            Vol\_t\ \ \  \@Vol\_t]\)\)]],
  " and \[Lambda] a 3\[Times]1 vector of coefficients. As in the basic model, \
",
  Cell[BoxData[
      \(TraditionalForm\`q\_t\)]],
  " is the trade direction indicator, +1 for a buy and ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)]],
  " for a sell.  Thus ",
  Cell[BoxData[
      \(TraditionalForm\`\(q\_t\) V\_t\)]],
  " is the signed volume. The disturbance ",
  Cell[BoxData[
      \(TraditionalForm\`u\_t\)]],
  " is public information, and ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(u\_t\)\(~\)\)\)]],
  Cell[BoxData[
      FormBox[
        RowBox[{"N", Cell[TextData[{
            "(0,",
            Cell[BoxData[
                \(TraditionalForm\`\[Sigma]\_u\%2\)]],
            ")"
          }]]}], TraditionalForm]]],
  ". The mapping to the observed price is the same as in the Roll model:"
}], "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`p\_t = m\_t + c\ q\_t\)]]
}], "Text"],

Cell[TextData[{
  "Relative to the basic Roll case discussed in the last section, this model \
is complicated by an additional parameter, \[Lambda], and dependence of the \
",
  Cell[BoxData[
      \(TraditionalForm\`m\_t\)]],
  " on ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t\)]],
  ". "
}], "Text"],

Cell["\<\
The parameter draw is relatively straightforward, as the model implies\
\>", "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`\[CapitalDelta]\[VeryThinSpace]p\_t = \
\(\[CapitalDelta]\[VeryThinSpace]m\_t + 
          c\[VeryThinSpace]\[CapitalDelta]\[VeryThinSpace]q\_t = \[Lambda]\
\[VeryThinSpace]\(q\_t\) V\_t + 
          c\[VeryThinSpace]\[CapitalDelta]\[VeryThinSpace]q\_t + 
          u\_t\)\)]]], "NumberedEquation"],

Cell[TextData[{
  "At the parameter draw stage, ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t\[VeryThinSpace]V\_t\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\[VeryThinSpace]q\_t\)]],
  " are known. This specification therefore fits in the regression framework, \
and \[Lambda] and ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  " may be drawn from the regression coefficient posterior. "
}], "Text"],

Cell["\<\
The latent data draws are more complicated. Given the structure of the model, \
\
\>", "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`Pr[q\_t | m\_\(\(\\\)\(t\)\), q\_\(\(\\\)\(t\)\), 
          p\_t] = Pr[q\_t | m\_\(t - 1\), m\_\(t + 1\), q\_\(t + 1\), 
          p\_t]\)]],
  ". "
}], "Text"],

Cell[TextData[{
  "Analogous to eq. (",
  
  CounterBox["NumberedEquation", "RollBayes"],
  "),"
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{\(Pr(q\_t | p\_t, m\_\(t - 1\), m\_\(t + 1\), q\_\(t + 1\))\), 
        "=", 
        StyleBox[\(\(\(f(p\_t | q\_t, m\_\(t - 1\), m\_\(t + 1\), 
                  q\_\(t + 1\))\)\ \[Times]\(Pr(q\_t | m\_\(t - 1\), 
                  m\_\(t + 1\), \ q\_\(t + 1\))\)\)\/\(f(p\_t | m\_\(t - 1\), 
                m\_\(t + 1\), q\_\(t + 1\))\)\),
          ScriptLevel->0]}], TraditionalForm]]]], "NumberedEquation",
  CellTags->"BayesContemporaneousImpact"],

Cell[TextData[{
  "As in the simple case, when we need to evaluate this, ",
  Cell[BoxData[
      \(TraditionalForm\`p\_t\)]],
  " is known, and so the denominator can be treated as a proportionality \
factor. Here, however, and in contrast with the Roll case, ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(q\_t | m\_\(t - 1\), m\_\(t + 1\)) \[NotEqual] f(q\_t)\), 
          "=", 
          RowBox[{\(1/2\), Cell[""]}]}], TraditionalForm]]],
  ". Intuitively, if ",
  Cell[BoxData[
      \(TraditionalForm\`m\_\(t + 1\)\)]],
  "is relatively high, this implies that ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t\)]],
  " is more likely to be +1 (a buy). Therefore, we need to compute both of \
the factors in the numerator of eq. (",
  
  CounterBox["NumberedEquation", "BayesContemporaneousImpact"],
  ")."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`Pr(q\_t | m\_\(t - 1\), m\_\(t + 1\), 
      q\_\(t + 1\))\)]]], "Subsection"],

Cell[TextData[{
  "The joint distribution of ",
  Cell[BoxData[
      \(TraditionalForm\`u\_t\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\(t + 1\)\)]],
  "is ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[Phi](0, \[Sigma]\_u, u\_t)\)\ \(\[Phi](
          0, \[Sigma]\_u, u\_\(t + 1\))\)\)], "Caption"],
  ". Substituting from (",
  
  CounterBox["NumberedEquation", "InformativeTradeModel"],
  ") gives: "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TD = \[Phi][0, \[Sigma]\_u, u\_t] \[Phi][0, \[Sigma]\_u, u\_\(t + 1\)] /. 
        u\_t_ \[Rule] 
          m\_t - \((m\_\(t - 1\) + q\_t\ \[Lambda]\ V\_t)\)\)], "Input",
  CellLabel->"In[32]:="],

Cell[BoxData[
    \(TraditionalForm\`\(\[Phi](
        0, \[Sigma]\_u, \(-m\_\(t - 1\)\) + 
          m\_t - \[Lambda]\ q\_t\ V\_t)\)\ \(\[Phi](
        0, \[Sigma]\_u, \(-m\_t\) + 
          m\_\(t + 1\) - \[Lambda]\ q\_\(t + 1\)\ V\_\(t + 1\))\)\)], "Output",\

  CellLabel->"Out[32]="]
}, Open  ]],

Cell[TextData[{
  "To compute ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(Pr(q\_t | m\_\(t - 1\), m\_\(t + 1\), 
        q\_\(t + 1\))\)\(\ \)\)\)]],
  ", the dependence on ",
  Cell[BoxData[
      \(TraditionalForm\`m\_t\)]],
  " must be eliminated, which we do by integrating over ",
  Cell[BoxData[
      \(TraditionalForm\`m\_t\)]],
  ". That is, "
}], "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`Pr(q\_t | m\_\(t - 1\), m\_\(t + 1\), 
          q\_\(t + 1\)) \[Proportional] \[Integral]\_\(-\[Infinity]\)\%\(+\
\[Infinity]\)\(\[Phi](
              0, \[Sigma]\_u, \(-m\_\(t - 1\)\) + 
                m\_t - \[Lambda]\ q\_t\ V\_t)\)\ \(\[Phi](
              0, \[Sigma]\_u, \(-m\_t\) + 
                m\_\(t + 1\) - \[Lambda]\ q\_\(t + 1\)\ V\_\(t + 1\))\) \
\[DifferentialD]m\_t \[Congruent] Pr(q\_t)\)]]
}], "Text"],

Cell[TextData[{
  "Evaluating the integral gives ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(Pr(q\_t)\)\(\[Congruent]\)\)\)]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(fI = 
      Integrate[TD /. \[Phi]Def, {m\_t, \(-\[Infinity]\), \(+\[Infinity]\)}, 
        Assumptions \[Rule] \[Sigma]uAssumptions]\)], "Input",
  CellLabel->"In[33]:="],

Cell[BoxData[
    \(TraditionalForm\`\[ExponentialE]\^\(-\(\((m\_\(t - 1\) - m\_\(t + 1\) + \
\[Lambda]\ q\_t\ V\_t + \[Lambda]\ q\_\(t + 1\)\ V\_\(t + 1\))\)\^2\/\(4\ \
\[Sigma]\_u\%2\)\)\)\/\(2\ \@\[Pi]\ \[Sigma]\_u\)\)], "Output",
  CellLabel->"Out[33]="]
}, Open  ]],

Cell["Performing the final normalization:", "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`Pr(q\_t | m\_\(t - 1\), m\_\(t + 1\), 
          q\_\(t + 1\))\  = \(Pr(q\_t)\)\/\(Pr(\(+1\)) + Pr(\(-1\))\)\)]]
}], "Text"],

Cell[TextData[{
  "Therefore, ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(Pr(q\_t = 1 | m\_\(t - 1\), m\_\(t + 1\), 
          q\_\(t + 1\))\)\(=\)\)\)]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrBuy = Pr[1]\/\(Pr[\(+1\)] + Pr[\(-1\)]\) // Simplify\)], "Input",
  CellLabel->"In[34]:="],

Cell[BoxData[
    \(TraditionalForm\`\(Pr(1)\)\/\(Pr(\(-1\)) + Pr(1)\)\)], "Output",
  CellLabel->"Out[34]="]
}, Open  ]],

Cell["For example, at the values", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(TrialValues = {m\_\(t - 1\) \[Rule] 5, m\_\(t + 1\) \[Rule] 5.2, 
          V\_t \[Rule] 1, q\_\(t + 1\) -> 1, 
          V\_\(t + 1\) \[Rule] 2, \[Lambda] \[Rule] 0.01, \[Sigma]\_u \[Rule] 
            0.05};\)\), "\[IndentingNewLine]", 
    \(TrialValues /. RuleToEquals\)}], "Input",
  CellLabel->"In[35]:="],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          TagBox[
            RowBox[{
              TagBox[\(m\_\(t - 1\)\),
                HoldForm], " ", "\<\"=\"\>", " ", 
              TagBox["5",
                HoldForm]}],
            HoldForm], ",", 
          TagBox[
            RowBox[{
              TagBox[\(m\_\(t + 1\)\),
                HoldForm], " ", "\<\"=\"\>", " ", 
              TagBox["5.2`",
                HoldForm]}],
            HoldForm], ",", 
          TagBox[
            RowBox[{
              TagBox[\(V\_t\),
                HoldForm], " ", "\<\"=\"\>", " ", 
              TagBox["1",
                HoldForm]}],
            HoldForm], ",", 
          TagBox[
            RowBox[{
              TagBox[\(q\_\(t + 1\)\),
                HoldForm], " ", "\<\"=\"\>", " ", 
              TagBox["1",
                HoldForm]}],
            HoldForm], ",", 
          TagBox[
            RowBox[{
              TagBox[\(V\_\(t + 1\)\),
                HoldForm], " ", "\<\"=\"\>", " ", 
              TagBox["2",
                HoldForm]}],
            HoldForm], ",", 
          TagBox[
            RowBox[{
              TagBox["\[Lambda]",
                HoldForm], " ", "\<\"=\"\>", " ", 
              TagBox["0.01`",
                HoldForm]}],
            HoldForm], ",", 
          TagBox[
            RowBox[{
              TagBox[\(\[Sigma]\_u\),
                HoldForm], " ", "\<\"=\"\>", " ", 
              TagBox["0.05`",
                HoldForm]}],
            HoldForm]}], "}"}], TraditionalForm]], "Output",
  CellLabel->"Out[36]="]
}, Open  ]],

Cell[TextData[{
  "the probability of a buy is 0.673. Intuitively, given the increase in the \
efficient price between ",
  Cell[BoxData[
      \(TraditionalForm\`m\_\(t - 1\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`m\_\(t + 1\)\)]],
  ", it is more likely that the trade at time ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " was a buy."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  "(",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " code)"
}], "MathGroup"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrqBuy1 = PrBuy /. TrialValues\)], "Input",
  CellLabel->"In[37]:="],

Cell[BoxData[
    \(TraditionalForm\`\(Pr(1)\)\/\(Pr(\(-1\)) + Pr(1)\)\)], "Output",
  CellLabel->"Out[37]="]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`f(p\_t | m\_\(t - 1\), q\_t, m\_\(t + 1\), 
      m\_\(t + 1\), q\_\(t + 1\))\)]]], "Subsection"],

Cell["As indicated above, the transition density is ", "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`\(\[Phi](
          0, \[Sigma]\_u, \(-m\_\(t - 1\)\) + 
            m\_t - \[Lambda]\ q\_t\ V\_t)\)\ \(\[Phi](
          0, \[Sigma]\_u, \(-m\_t\) + 
            m\_\(t + 1\) - \[Lambda]\ q\_\(t + 1\)\ V\_\(t + 1\))\)\)]],
  ". "
}], "Text"],

Cell["Expanding the normal densities and simplifying gives:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TD2 = TD /. \[Phi]Def // Simplify\)], "Input",
  CellLabel->"In[38]:="],

Cell[BoxData[
    \(TraditionalForm\`\[ExponentialE]\^\(-\(\(\((m\_\(t - 1\) - m\_t + \
\[Lambda]\ q\_t\ V\_t)\)\^2 + \((m\_t - m\_\(t + 1\) + \[Lambda]\ q\_\(t + \
1\)\ V\_\(t + 1\))\)\^2\)\/\(2\ \[Sigma]\_u\%2\)\)\)\/\(2\ \[Pi]\ \[Sigma]\_u\
\%2\)\)], "Output",
  CellLabel->"Out[38]="]
}, Open  ]],

Cell[TextData[{
  "Therefore, ",
  Cell[BoxData[
      \(TraditionalForm\`m\_t\)]],
  " is normal:  ",
  Cell[BoxData[
      \(TraditionalForm\`f(m\_t | m\_\(t - 1\), m\_\(t + 1\), q\_t, 
          q\_\(t + 1\)) = \[Phi](\[Mu]\_t, \[Sigma]\_t, m\_t)\)]],
  " with parameters"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(mParams = 
        GetNormalForm[TD2, 
          m\_t, \[Mu]\_t, \[Sigma]\_t];\)\), "\[IndentingNewLine]", 
    \(mParams /. RuleToEquals // TableForm\)}], "Input",
  CellLabel->"In[39]:="],

Cell[BoxData[
    FormBox[
      InterpretationBox[GridBox[{
            {
              TagBox[
                RowBox[{
                  TagBox[\(\[Mu]\_t\),
                    HoldForm], " ", "\<\"=\"\>", " ", 
                  RowBox[{"(", 
                    
                    TagBox[\(1\/2\ \((m\_\(t - 1\) + 
                            m\_\(t + 1\) + \[Lambda]\ q\_t\ V\_t - \[Lambda]\ \
q\_\(t + 1\)\ V\_\(t + 1\))\)\),
                      HoldForm], ")"}]}],
                HoldForm]},
            {
              TagBox[
                RowBox[{
                  TagBox[\(\[Sigma]\_t\),
                    HoldForm], " ", "\<\"=\"\>", " ", 
                  TagBox[\(\[Sigma]\_u\/\@2\),
                    HoldForm]}],
                HoldForm]}
            },
          RowSpacings->1,
          ColumnSpacings->3,
          RowAlignments->Baseline,
          ColumnAlignments->{Left}],
        TableForm[ {
          HoldForm[ 
            Times[ 
              HoldForm[ 
                Subscript[ \[Mu], t]], "=", 
              HoldForm[ 
                Times[ 
                  Rational[ 1, 2], 
                  Plus[ 
                    Subscript[ m, 
                      Plus[ -1, t]], 
                    Subscript[ m, 
                      Plus[ 1, t]], 
                    Times[ \[Lambda], 
                      Subscript[ q, t], 
                      Subscript[ V, t]], 
                    Times[ -1, \[Lambda], 
                      Subscript[ q, 
                        Plus[ 1, t]], 
                      Subscript[ V, 
                        Plus[ 1, t]]]]]]]], 
          HoldForm[ 
            Times[ 
              HoldForm[ 
                Subscript[ \[Sigma], t]], "=", 
              HoldForm[ 
                Times[ 
                  Power[ 2, 
                    Rational[ -1, 2]], 
                  Subscript[ \[Sigma], u]]]]]}]], TraditionalForm]], "Output",
  CellLabel->"Out[40]//TableForm="]
}, Open  ]],

Cell[TextData[{
  "Substituting in for ",
  Cell[BoxData[
      \(TraditionalForm\`m\_t\)]],
  " gives"
}], "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`f(p\_t | m\_\(t - 1\), m\_\(t + 1\), q\_t, 
          q\_\(t + 1\)) = \[Phi](\[Mu]\_t, \[Sigma]\_t, 
          p\_t - c\[VeryThinSpace]q\_t)\)]]
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Summary", "Subsection"],

Cell["The draw is made in the following steps.", "Text"],

Cell[TextData[{
  "1. Compute the normalized probabilities ",
  Cell[BoxData[
      \(TraditionalForm\`Pr(q\_t | m\_\(t - 1\), m\_\(t + 1\), 
        q\_\(t + 1\))\)]],
  " for ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t = \(\(-1\)\ and\ q\_t = \(+1\)\)\)]],
  "."
}], "Text"],

Cell[TextData[{
  "2. Compute ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[Phi](\[Mu]\_t, \[Sigma]\_t, 
          p\_t - c\[VeryThinSpace]q\_t)\) \(Pr(q\_t | m\_\(t - 1\), 
          m\_\(t + 1\), q\_\(t + 1\))\)\)]],
  " for ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t = \(\(-1\)\ and\ q\_t = \(+1\)\)\)]],
  "."
}], "Text"],

Cell["3. Normalize the probabilities from step 2.", "Text"],

Cell["4. Make the draw.", "Text"],

Cell["\<\
Note that the overall calculation requires two normalizations, at step 1 \
(done, above, for the trial values) and step 3.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Endpoint modifications", "Subsection"],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`t = 1\)]]], "Subsubsection"],

Cell[TextData[{
  "At ",
  Cell[BoxData[
      \(TraditionalForm\`t = 1\)]],
  ", "
}], "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`Pr(q\_1 | m\_\\1, q\_\\1, p\_1)\[IndentingNewLine] = 
        Pr(q\_1 | m\_2, q\_2, 
            p\_1)\[IndentingNewLine] \[Proportional] \(f(p\_1 | m\_2, q\_2, 
              q\_1)\)\[Times]\(Pr(q\_1 | m\_2, q\_2)\)\)]],
  ". "
}], "Text"],

Cell[TextData[{
  "Here, however, ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(Pr(q\_1 | m\_2, q\_2)\), "=", 
          RowBox[{\(Pr(q\_1)\), "=", 
            RowBox[{\(1/2\), Cell[""]}]}]}], TraditionalForm]]],
  ". To compute the first term on the r.h.s., the relevant density is ",
  Cell[BoxData[
      \(TraditionalForm\`f(u\_2) = \[Phi](0, \[Sigma]\_u, u\_2)\)]],
  ". Substituting in for ",
  Cell[BoxData[
      \(TraditionalForm\`u\_2\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`m\_1\)]],
  "and solving indicates"
}], "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`f(m\_1 | m\_2, q\_2, 
          q\_1) = \(f(m\_1 | m\_2, q\_2) = \[Phi](\[Mu]\_1, \[Sigma]\_1, 
            m\_1)\)\)]]
}], "Text"],

Cell["where", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(m1Params = 
        GetNormalForm[\(\[Phi][0, \[Sigma]\_u, u\_2] /. 
              u\_2 \[Rule] 
                m\_2 - \((m\_1 + 
                      q\_2\ \[Lambda]\[VeryThinSpace]V\_2)\)\) /. \[Phi]Def, 
          m\_1, \[Mu]\_1, \[Sigma]\_1];\)\), "\[IndentingNewLine]", 
    \(m1Params /. RuleToEquals // TableForm\)}], "Input",
  CellLabel->"In[41]:="],

Cell[BoxData[
    FormBox[
      InterpretationBox[GridBox[{
            {
              TagBox[
                RowBox[{
                  TagBox[\(\[Mu]\_1\),
                    HoldForm], " ", "\<\"=\"\>", " ", 
                  RowBox[{"(", 
                    TagBox[\(m\_2 - \[Lambda]\ q\_2\ V\_2\),
                      HoldForm], ")"}]}],
                HoldForm]},
            {
              TagBox[
                RowBox[{
                  TagBox[\(\[Sigma]\_1\),
                    HoldForm], " ", "\<\"=\"\>", " ", 
                  TagBox[\(\[Sigma]\_u\),
                    HoldForm]}],
                HoldForm]}
            },
          RowSpacings->1,
          ColumnSpacings->3,
          RowAlignments->Baseline,
          ColumnAlignments->{Left}],
        TableForm[ {
          HoldForm[ 
            Times[ 
              HoldForm[ 
                Subscript[ \[Mu], 1]], "=", 
              HoldForm[ 
                Plus[ 
                  Subscript[ m, 2], 
                  Times[ -1, \[Lambda], 
                    Subscript[ q, 2], 
                    Subscript[ V, 2]]]]]], 
          HoldForm[ 
            Times[ 
              HoldForm[ 
                Subscript[ \[Sigma], 1]], "=", 
              HoldForm[ 
                Subscript[ \[Sigma], u]]]]}]], TraditionalForm]], "Output",
  CellLabel->"Out[42]//TableForm="]
}, Open  ]],

Cell["Thus,", "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`f(p\_1 | m\_2, q\_2, 
          q\_1) = \[Phi](\[Mu]\_1, \[Sigma]\_1, 
          p\_1 - c\[VeryThinSpace]q\_1)\)]]
}], "Text"],

Cell[TextData[{
  "We evaluate this. for ",
  Cell[BoxData[
      \(TraditionalForm\`q\_1 = \(\[PlusMinus]1\)\)]],
  ", normalize, and make the draw of ",
  Cell[BoxData[
      \(TraditionalForm\`q\_1\)]],
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`t = T\)]]], "Subsubsection"],

Cell[TextData[{
  "At ",
  Cell[BoxData[
      \(TraditionalForm\`t = T\)]],
  ", "
}], "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`Pr(q\_T | m\_\(\(\\\)\(T\)\), q\_\(\(\\\)\(T\)\), 
          p\_T)\[IndentingNewLine] = 
        Pr(q\_T | m\_\(T - 1\), q\_\(T - 1\), 
            p\_T)\[IndentingNewLine] \[Proportional] \(f(p\_T | m\_\(T - 1\), 
              q\_\(T - 1\), q\_T)\)\[Times]\(Pr(q\_T | m\_\(T - 1\), 
              q\_\(T - 1\))\)\)]],
  ". "
}], "Text"],

Cell[TextData[{
  "Again, ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(Pr(q\_T | m\_\(T - 1\), q\_\(T - 1\))\), "=", 
          RowBox[{\(Pr(q\_\(T - 1\))\), "=", 
            RowBox[{\(1/2\), Cell[""]}]}]}], TraditionalForm]]],
  ". To compute the first term on the r.h.s., the relevant density is ",
  Cell[BoxData[
      \(TraditionalForm\`f(u\_T) = \[Phi](0, \[Sigma]\_u, u\_T)\)]],
  ". Substituting in for ",
  Cell[BoxData[
      \(TraditionalForm\`u\_T\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`m\_T\)]],
  " gives:"
}], "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`f(m\_T | m\_\(T - 1\), q\_\(T - 1\), 
          q\_T) = \[Phi](\[Mu]\_T, \[Sigma]\_T, m\_T)\)]]
}], "Text"],

Cell["where", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(mTParams = 
        GetNormalForm[\(\[Phi][0, \[Sigma]\_u, u\_T] /. 
              u\_T \[Rule] 
                m\_T - \((m\_\(T - 1\) + \(q\_T\) \[Lambda]\ V\_T)\)\) /. \
\[Phi]Def, m\_T, \[Mu]\_T, \[Sigma]\_T];\)\), "\[IndentingNewLine]", 
    \(mTParams /. RuleToEquals // TableForm\)}], "Input",
  CellLabel->"In[43]:="],

Cell[BoxData[
    FormBox[
      InterpretationBox[GridBox[{
            {
              TagBox[
                RowBox[{
                  TagBox[\(\[Mu]\_T\),
                    HoldForm], " ", "\<\"=\"\>", " ", 
                  RowBox[{"(", 
                    TagBox[\(m\_\(T - 1\) + \[Lambda]\ q\_T\ V\_T\),
                      HoldForm], ")"}]}],
                HoldForm]},
            {
              TagBox[
                RowBox[{
                  TagBox[\(\[Sigma]\_T\),
                    HoldForm], " ", "\<\"=\"\>", " ", 
                  TagBox[\(\[Sigma]\_u\),
                    HoldForm]}],
                HoldForm]}
            },
          RowSpacings->1,
          ColumnSpacings->3,
          RowAlignments->Baseline,
          ColumnAlignments->{Left}],
        TableForm[ {
          HoldForm[ 
            Times[ 
              HoldForm[ 
                Subscript[ \[Mu], T]], "=", 
              HoldForm[ 
                Plus[ 
                  Subscript[ m, 
                    Plus[ -1, T]], 
                  Times[ \[Lambda], 
                    Subscript[ q, T], 
                    Subscript[ V, T]]]]]], 
          HoldForm[ 
            Times[ 
              HoldForm[ 
                Subscript[ \[Sigma], T]], "=", 
              HoldForm[ 
                Subscript[ \[Sigma], u]]]]}]], TraditionalForm]], "Output",
  CellLabel->"Out[44]//TableForm="]
}, Open  ]],

Cell["We normalize and make the draw.", "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Discrete prices", "Section",
  CellTags->"Discrete Prices"],

Cell[CellGroupData[{

Cell["Model Description", "Subsection"],

Cell["\<\
This model is a Roll model with price discreteness. The evolution of the \
(log) efficient price is:\
\>", "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`m\_t = m\_\(t - 1\) + u\_t\)]],
  " where ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(u\_t\), " ", "is", " ", "distributed", " ", "as", " ", "N", 
          Cell[TextData[{
            "(0,",
            Cell[BoxData[
                \(TraditionalForm\`\[Sigma]\_u\%2\)]],
            ")"
          }]]}], TraditionalForm]]]
}], "Text"],

Cell[TextData[{
  "The (level) efficient price is therefore ",
  Cell[BoxData[
      \(TraditionalForm\`M\_t = e\^m\_t\)]],
  ". (The units here are \"dollars.\") The half-spread in levels is ",
  "C.",
  " The bid and ask quotes are:"
}], "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`B\_t = Floor(M\_t - C)\)]],
  "\n\t",
  Cell[BoxData[
      \(TraditionalForm\`A\_t = Ceiling(M\_t + C)\)]]
}], "Text"],

Cell["\<\
Note that the rounding is asymmetric.  The bid is rounded down to the next \
available increment; the ask is rounded up. It is assumed that the variables \
are scaled so that the tick size is unity.  The buy/sell indicator is\
\>", "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      FormBox[
        RowBox[{\(q\_t\), "=", 
          RowBox[{"{", GridBox[{
                {
                  RowBox[{\(+1\), ",", " ", 
                    RowBox[{
                      StyleBox["a",
                        FontSlant->"Plain"], 
                      StyleBox[" ",
                        FontSlant->"Plain"], "buy"}], ",", 
                    " ", \(with\ probability\ 1/2\)}]},
                {
                  RowBox[{\(-1\), ",", " ", 
                    RowBox[{
                      StyleBox["a",
                        FontSlant->"Plain"], 
                      StyleBox[" ",
                        FontSlant->"Plain"], "sell"}], ",", 
                    " ", \(with\ probability\ 1/2\)}]}
                }]}]}], TraditionalForm]]],
  "\nThe obseved transaction price is"
}], "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      FormBox[
        RowBox[{\(P\_t\), "=", 
          RowBox[{"{", GridBox[{
                {\(\(A\_t\) if\ q\_t = \(+1\)\)},
                {\(\(B\_t\) if\ q\_t = \(-1\)\)}
                }]}]}], TraditionalForm]]]
}], "Text"],

Cell[TextData[{
  "In the model without discreteness, the cost parameter (here, ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  ") can be estimated from the regression specification eq. (",
  
  CounterBox["NumberedEquation", "cRegression"],
  "). With the rounding transformations in the present case, there is no \
corresponding regression. We discuss the draw of ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  " below. "
}], "Text"],

Cell[TextData[{
  "The latent data draw is also complicated. Without discreteness, ",
  Cell[BoxData[
      \(TraditionalForm\`p\_t = m\_t + c\ q\_t\)]],
  ", so (given ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  ") any variable in ",
  Cell[BoxData[
      \(TraditionalForm\`{p\_t, m\_t, q\_t}\)]],
  " is determined by the other two. This is not the case here: ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`m\_t\)]],
  " must be drawn separately. The steps are:"
}], "Text"],

Cell[TextData[{
  "\t1. Draw ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t | m\_\(\(\\\)\(t\)\), q\_\(\(\\\)\(t\)\), 
      P\_t\)]]
}], "Text"],

Cell[TextData[{
  "\t2. Draw ",
  Cell[BoxData[
      \(TraditionalForm\`m\_t | m\_\(\(\\\)\(t\)\), q, P\_t\)]]
}], "Text"],

Cell[TextData[{
  "Note that the conditioning set at step 2 includes ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t\)]],
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Drawing  ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t | m\_\(\(\\\)\(t\)\), q\_\(\(\\\)\(t\)\), 
      P\_t\)]]
}], "Subsection"],

Cell["From the properties of conditional probabilities:", "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{\(Pr(q\_t | m\_\(t - 1\), m\_\(t + 1\), P\_t)\), 
        "\[IndentingNewLine]", "=", 
        RowBox[{
          RowBox[{
            
            StyleBox[\(\(\(Pr(P\_t | m\_\(t - 1\), m\_\(t + 1\), 
                      q\_t)\)\ \[Times]\(Pr(q\_t, \(\(|\)\(m\_\(t - 1\)\)\), 
                      m\_\(t + 1\))\)\[Times]\(f(m\_\(t - 1\), 
                      m\_\(t + 1\))\)\)\/\(\(Pr(P\_t | m\_\(t - 1\), 
                      m\_\(t + 1\))\) \(f(m\_\(t - 1\), m\_\(t + 1\))\)\)\),
              ScriptLevel->0], "\[IndentingNewLine]", 
            "\[Proportional]", \(\(Pr(P\_t | m\_\(t - 1\), m\_\(t + 1\), 
                q\_t)\)\ \[Times]\(Pr(q\_t, \(\(|\)\(m\_\(t - 1\)\)\), 
                m\_\(t + 1\))\)\)}], "\[IndentingNewLine]", "   ", 
          "=", \(\(Pr(P\_t | m\_\(t - 1\), m\_\(t + 1\), 
              q\_t)\)\ \[Times]\(Pr(q\_t)\)\)}]}], 
      TraditionalForm]]]], "NumberedEquation"],

Cell[TextData[{
  "where we have used the fact that the denominator will be a constant of \
proportionality. The last equality follows from the fact that ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t\)]],
  " is independent of the evolution of ",
  Cell[BoxData[
      \(TraditionalForm\`m\_t\)]],
  ". Next,"
}], "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`Pr(P\_t | m\_\(t - 1\), m\_\(t + 1\), 
        q\_t) = \[Integral]\_\(m\+_\)\%\(m\&_\)\(f(m\_t | m\_\(t - 1\), 
            m\_\(t + 1\))\) \[DifferentialD]m\_t\)]]], "NumberedEquation",
  CellTags->"DiscretenessPr"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`m\+_\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`m\&_\)]],
  " are the limits established by ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t\)]],
  " and the Floor and Ceiling rounding functions (see below). ",
  Cell[BoxData[
      \(TraditionalForm\`f(m\_t | m\_\(t - 1\), m\_\(t + 1\))\)]],
  " is given in eq. (",
  
  CounterBox["NumberedEquation", "RollDensity"],
  "). Using (",
  
  CounterBox["NumberedEquation"],
  "), we compute unnormalized probabilities for ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t = \(\(+1\)\ and\ q\_t = \(-1\)\)\)]],
  ". We normalize these probabilities and draw ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t\)]],
  ". We then proceed to the ",
  Cell[BoxData[
      \(TraditionalForm\`m\_t\)]],
  " draw. "
}], "Text"],

Cell[TextData[{
  "The limits of integration in eq. (",
  
  CounterBox["NumberedEquation"],
  ") are computed as follows. From the definition of the Floor and Ceiling \
functions, "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MBidLimits = 
      InequalitySolve[B\_t < M\_t - C < B\_t + 1, M\_t]\)], "Input",
  CellLabel->"In[45]:="],

Cell[BoxData[
    \(TraditionalForm\`C + B\_t < M\_t < C + B\_t + 1\)], "Output",
  CellLabel->"Out[45]="]
}, Open  ]],

Cell["and", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MAskLimits = 
      InequalitySolve[A\_t - 1 < M\_t + C < A\_t, M\_t]\)], "Input",
  CellLabel->"In[46]:="],

Cell[BoxData[
    \(TraditionalForm\`\(-C\) + A\_t - 1 < M\_t < A\_t - C\)], "Output",
  CellLabel->"Out[46]="]
}, Open  ]],

Cell[TextData[{
  "When ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t = \(-1\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`P\_t = B\_t\)]],
  " and:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MBidLimits = MBidLimits /. B\_t \[Rule] P\_t\)], "Input",
  CellLabel->"In[47]:="],

Cell[BoxData[
    \(TraditionalForm\`C + P\_t < M\_t < C + P\_t + 1\)], "Output",
  CellLabel->"Out[47]="]
}, Open  ]],

Cell[TextData[{
  "When ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t = \(+1\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`P\_t = A\_t\)]],
  " and:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MAskLimits = MAskLimits /. A\_t \[Rule] P\_t\)], "Input",
  CellLabel->"In[48]:="],

Cell[BoxData[
    \(TraditionalForm\`\(-C\) + P\_t - 1 < M\_t < P\_t - C\)], "Output",
  CellLabel->"Out[48]="]
}, Open  ]],

Cell[TextData[{
  "As long as ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t \[Element] {\(-1\), \(+1\)}\)]],
  ", the lower and upper limits may be expressed as functions:"
}], "Text"],

Cell[TextData[{
  StyleBox[Cell[BoxData[
      FormBox[
        TagBox[
          RowBox[{
            TagBox[
              TagBox[\(\(M\+_\)(q\_t)\),
                HoldForm],
              HoldForm], " ", "\<\"=\"\>", " ", 
            RowBox[{"(", 
              TagBox[\(1\/2\ \((2\ P\_t - 2\ C\ q\_t - q\_t - 1)\)\),
                HoldForm], ")"}]}],
          HoldForm], TraditionalForm]], "TextStripped"], "TextStripped"],
  " \nand \n",
  StyleBox[Cell[BoxData[
      FormBox[
        TagBox[
          RowBox[{
            TagBox[
              TagBox[\(\(M\&_\)(q\_t)\),
                HoldForm],
              HoldForm], " ", "\<\"=\"\>", " ", 
            RowBox[{"(", 
              TagBox[\(P\_t - 1\/2\ \((2\ C + 1)\)\ q\_t + 1\/2\),
                HoldForm], ")"}]}],
          HoldForm], TraditionalForm]], "TextStripped"], "TextStripped"]
}], "NumberedEquation",
  CellTags->"MLimits"],

Cell[TextData[{
  "The limits on the log efficient price are then ",
  Cell[BoxData[
      \(TraditionalForm\`\(m\+_\)(q\_t) = log[\(M\+_\)(q\_t)]\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\(m\&_\)(q\_t) = log[\(M\&_\)(q\_t)]\)]],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  "(",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " details)"
}], "MathGroup"],

Cell[CellGroupData[{

Cell[BoxData[
    \({MBidLimits[\([1]\)] \[Equal] a + b\ q\_t /. q\_t \[Rule] \(-1\), 
      MAskLimits[\([1]\)] \[Equal] a + b\ q\_t /. 
        q\_t \[Rule] \(+1\)}\)], "Input",
  CellLabel->"In[49]:="],

Cell[BoxData[
    \(TraditionalForm\`{C + P\_t == a - b, \(-C\) + P\_t - 1 == 
        a + b}\)], "Output",
  CellLabel->"Out[49]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Flatten[Solve[%, {a, b}] // Simplify]\)], "Input",
  CellLabel->"In[50]:="],

Cell[BoxData[
    \(TraditionalForm\`{a \[Rule] P\_t - 1\/2, 
      b \[Rule] \(-C\) - 1\/2}\)], "Output",
  CellLabel->"Out[50]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(M\+_[q_] := Evaluate[a + b\ q\  /. % // FullSimplify]; 
    HoldForm[M\+_[\[VeryThinSpace]q\_t\[VeryThinSpace]]] \[Rule] M\+_[q\_t] /. 
      RuleToEquals\)], "Input",
  CellLabel->"In[51]:="],

Cell[BoxData[
    FormBox[
      TagBox[
        RowBox[{
          TagBox[
            TagBox[\(\(M\+_\)(q\_t)\),
              HoldForm],
            HoldForm], " ", "\<\"=\"\>", " ", 
          RowBox[{"(", 
            TagBox[\(1\/2\ \((2\ P\_t - 2\ C\ q\_t - q\_t - 1)\)\),
              HoldForm], ")"}]}],
        HoldForm], TraditionalForm]], "Output",
  CellLabel->"Out[51]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(M\+_[q\_t] /. q\_t \[Rule] {1, \(-1\)} // Simplify\)], "Input",
  CellLabel->"In[52]:="],

Cell[BoxData[
    \(TraditionalForm\`{\(-C\) + P\_t - 1, C + P\_t}\)], "Output",
  CellLabel->"Out[52]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \({MBidLimits[\([5]\)] \[Equal] a + b\ q\_t /. q\_t \[Rule] \(-1\), 
      MAskLimits[\([5]\)] \[Equal] a + b\ q\_t /. 
        q\_t \[Rule] \(+1\)}\)], "Input",
  CellLabel->"In[53]:="],

Cell[BoxData[
    \(TraditionalForm\`{C + P\_t + 1 == a - b, P\_t - C == a + b}\)], "Output",\

  CellLabel->"Out[53]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Flatten[Solve[%, {a, b}] // Simplify]\)], "Input",
  CellLabel->"In[54]:="],

Cell[BoxData[
    \(TraditionalForm\`{a \[Rule] P\_t + 1\/2, 
      b \[Rule] \(-C\) - 1\/2}\)], "Output",
  CellLabel->"Out[54]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(M\&_[q_] := Evaluate[a + b\ q\  /. % // FullSimplify]; 
    HoldForm[M\&_[\[VeryThinSpace]q\_t\[VeryThinSpace]]] \[Rule] M\&_[q\_t] /. 
      RuleToEquals\)], "Input",
  CellLabel->"In[55]:="],

Cell[BoxData[
    FormBox[
      TagBox[
        RowBox[{
          TagBox[
            TagBox[\(\(M\&_\)(q\_t)\),
              HoldForm],
            HoldForm], " ", "\<\"=\"\>", " ", 
          RowBox[{"(", 
            TagBox[\(P\_t - 1\/2\ \((2\ C + 1)\)\ q\_t + 1\/2\),
              HoldForm], ")"}]}],
        HoldForm], TraditionalForm]], "Output",
  CellLabel->"Out[55]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(M\&_[q\_t]\)], "Input",
  CellLabel->"In[56]:="],

Cell[BoxData[
    \(TraditionalForm\`P\_t - 1\/2\ \((2\ C + 1)\)\ q\_t + 1\/2\)], "Output",
  CellLabel->"Out[56]="]
}, Open  ]],

Cell[BoxData[
    \(m\+_[q_] := Log[M\+_[q]]; m\&_[q_] := Log[M\&_[q]]\)], "InputOnly",
  CellLabel->"In[57]:="]
}, Closed]],

Cell[CellGroupData[{

Cell["Recall that ", "TextGroup"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`\(\(f(m\_t | m\_\(t - 1\), 
          m\_\(t + 1\))\)\(=\)\)\)]],
  Cell[BoxData[
      \(TraditionalForm\`\[Phi][\[Mu]\_m, \[Sigma]\_m, m\_t]\)]],
  " with ",
  Cell[BoxData[
      \(TraditionalForm\`{\[Mu]\_m = \ \((m\_\(t - 1\) + m\_\(t + 1\))\)/
            2, \[Sigma]\_m = \[Sigma]\_u/\@2}\)], "Caption"],
  ". "
}], "Text"],

Cell[TextData[{
  "From eq. (",
  
  CounterBox["NumberedEquation", "DiscretenessPr"],
  "), ",
  Cell[BoxData[
      \(TraditionalForm\`Pr(q\_t | m\_\(t - 1\), m\_\(t + 1\), P\_t)\)]],
  Cell[BoxData[
      \(TraditionalForm\`\(\(\[Proportional]\)\(\ \)\(\[CapitalPhi][\[Mu]\_m, \
\[Sigma]\_m, \(m\+_\)(q\_t), \(m\&_\)(q\_t)]\)\)\)]],
  " for ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t = \(\[PlusMinus]1\)\)]],
  ". Therefore, the normalized probability of a buy is:"
}], "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(\[CapitalPhi](\[Mu]\_m, \[Sigma]\_m, \(m\+_\)(\(+1\)), \
\(m\&_\)(\(+1\)))\)\/\(\[CapitalPhi](\[Mu]\_m, \[Sigma]\_m, \(m\+_\)(\(-1\)), \
\(m\&_\)(\(-1\))) + \[CapitalPhi](\[Mu]\_m, \[Sigma]\_m, \(m\+_\)(\(+1\)), \
\(m\&_\)(\(+1\)))\)\),
          ScriptLevel->0], TraditionalForm]], "Caption"]
}], "Text"],

Cell[TextData[{
  "At the values ",
  StyleBox[Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            TagBox[
              RowBox[{
                TagBox[\(m\_\(t - 1\)\),
                  HoldForm], " ", "\<\"=\"\>", " ", 
                TagBox[\(log(100)\),
                  HoldForm]}],
              HoldForm], ",", 
            TagBox[
              RowBox[{
                TagBox[\(m\_\(t + 1\)\),
                  HoldForm], " ", "\<\"=\"\>", " ", 
                TagBox[\(log(104)\),
                  HoldForm]}],
              HoldForm], ",", 
            TagBox[
              RowBox[{
                TagBox[\(P\_t\),
                  HoldForm], " ", "\<\"=\"\>", " ", 
                TagBox["101",
                  HoldForm]}],
              HoldForm], ",", 
            TagBox[
              RowBox[{
                TagBox["C",
                  HoldForm], " ", "\<\"=\"\>", " ", 
                TagBox["0.2`",
                  HoldForm]}],
              HoldForm], ",", 
            TagBox[
              RowBox[{
                TagBox[\(\[Sigma]\_u\),
                  HoldForm], " ", "\<\"=\"\>", " ", 
                TagBox["0.01`",
                  HoldForm]}],
              HoldForm]}], "}"}], TraditionalForm]], "TextStripped"], 
    "TextStripped"],
  " this becomes ",
  Cell[BoxData[
      \(TraditionalForm\`0.092\)], "Caption"],
  ". Intuitively, given the locations of ",
  Cell[BoxData[
      \(TraditionalForm\`m\_\(t - 1\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`m\_\(t + 1\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`E\[VeryThinSpace]m\_t \[TildeTilde] 102\)]],
  ". Since ",
  Cell[BoxData[
      \(TraditionalForm\`P\_t\)]],
  " lies below this, it is more likely that the transaction was a sale, and \
the buy probability is below one-half."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "(",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " details)"
}], "MathGroup"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Pr = 
      HoldForm[\[CapitalPhi][\[Mu]\_m, \[Sigma]\_m, m\+_[\(+1\)], \
m\&_[\(+1\)]]\/\(\[CapitalPhi][\[Mu]\_m, \[Sigma]\_m, m\+_[\(+1\)], m\&_[\(+1\
\)]] + \[CapitalPhi][\[Mu]\_m, \[Sigma]\_m, m\+_[\(-1\)], \
m\&_[\(-1\)]]\)]\)], "Input",
  CellLabel->"In[58]:="],

Cell[BoxData[
    FormBox[
      TagBox[\(\(\[CapitalPhi](\[Mu]\_m, \[Sigma]\_m, \(m\+_\)(\(+1\)), \
\(m\&_\)(\(+1\)))\)\/\(\[CapitalPhi](\[Mu]\_m, \[Sigma]\_m, \(m\+_\)(\(-1\)), \
\(m\&_\)(\(-1\))) + \[CapitalPhi](\[Mu]\_m, \[Sigma]\_m, \(m\+_\)(\(+1\)), \
\(m\&_\)(\(+1\)))\)\),
        HoldForm], TraditionalForm]], "Output",
  CellLabel->"Out[58]="]
}, Open  ]],

Cell[BoxData[
    \(\(mParameters = {\[Mu]\_m \[Rule] 
            1\/2\ \((m\_\(t - 1\) + 
                  m\_\(t + 1\))\), \[Sigma]\_m \[Rule] \
\[Sigma]\_u\/\@2};\)\)], "Input",
  CellLabel->"In[59]:="],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(TrialValues = {m\_\(t - 1\) \[Rule] Log[100], 
          m\_\(t + 1\) \[Rule] Log[104], P\_t \[Rule] 101, 
          C \[Rule]  .2, \[Sigma]\_u \[Rule]  .01};\)\), \
"\[IndentingNewLine]", 
    \(TrialValues /. RuleToEquals\)}], "Input",
  CellLabel->"In[60]:="],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          TagBox[
            RowBox[{
              TagBox[\(m\_\(t - 1\)\),
                HoldForm], " ", "\<\"=\"\>", " ", 
              TagBox[\(log(100)\),
                HoldForm]}],
            HoldForm], ",", 
          TagBox[
            RowBox[{
              TagBox[\(m\_\(t + 1\)\),
                HoldForm], " ", "\<\"=\"\>", " ", 
              TagBox[\(log(104)\),
                HoldForm]}],
            HoldForm], ",", 
          TagBox[
            RowBox[{
              TagBox[\(P\_t\),
                HoldForm], " ", "\<\"=\"\>", " ", 
              TagBox["101",
                HoldForm]}],
            HoldForm], ",", 
          TagBox[
            RowBox[{
              TagBox["C",
                HoldForm], " ", "\<\"=\"\>", " ", 
              TagBox["0.2`",
                HoldForm]}],
            HoldForm], ",", 
          TagBox[
            RowBox[{
              TagBox[\(\[Sigma]\_u\),
                HoldForm], " ", "\<\"=\"\>", " ", 
              TagBox["0.01`",
                HoldForm]}],
            HoldForm]}], "}"}], TraditionalForm]], "Output",
  CellLabel->"Out[61]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(ReleaseHold[Pr] /. mParameters\) /. 
        TrialValues\) /. \[CapitalPhi]Def\)], "Input",
  CellLabel->"In[62]:="],

Cell[BoxData[
    \(TraditionalForm\`0.09198927957304893`\)], "Output",
  CellLabel->"Out[62]="]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Drawing ",
  Cell[BoxData[
      \(TraditionalForm\`m\_t | m\_\(\(\\\)\(t\)\), q, P\_t\)]]
}], "Subsection"],

Cell[TextData[{
  "As noted, ",
  Cell[BoxData[
      \(TraditionalForm\`f(m\_t | m\_\(t - 1\), 
          m\_\(t + 1\)) = \[Phi][\[Mu]\_m, \[Sigma]\_m, m\_t]\)]],
  " where ",
  Cell[BoxData[
      \(TraditionalForm\`\[Mu]\_m\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\_m\)]],
  " are given above. Conditioning on ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`P\_t\)]],
  " merely restricts the range of the distribution. Therefore, the draw is \
from the normal distribution ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi][\[Mu]\_m, \[Sigma]\_m, m\_t]\)]],
  " truncated to the range ",
  Cell[BoxData[
      \(TraditionalForm\`\((m\+_[q\_t], m\&_[q\_t])\)\)]],
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Drawing ",
  Cell[BoxData[
      \(TraditionalForm\`C | P, m, q\)]]
}], "Subsection"],

Cell[TextData[{
  "The upper and lower bounds on ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  ", given everything else, can be computed in a fashion similar to that used \
above for ",
  Cell[BoxData[
      \(TraditionalForm\`M\_t\)]],
  ". If ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t = \(-1\)\)]],
  ","
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CBidLimits = 
      InequalitySolve[B\_t < M\_t - C < B\_t + 1, C] /. 
        B\_t \[Rule] P\_t\)], "Input",
  CellLabel->"In[63]:="],

Cell[BoxData[
    \(TraditionalForm\`M\_t - P\_t - 1 < C < M\_t - P\_t\)], "Output",
  CellLabel->"Out[63]="]
}, Open  ]],

Cell[TextData[{
  "If  ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t = \(+1\)\)]],
  ","
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CAskLimits = 
      InequalitySolve[A\_t - 1 < M\_t + C < A\_t, C] /. 
        A\_t \[Rule] P\_t\)], "Input",
  CellLabel->"In[64]:="],

Cell[BoxData[
    \(TraditionalForm\`\(-M\_t\) + P\_t - 1 < C < P\_t - M\_t\)], "Output",
  CellLabel->"Out[64]="]
}, Open  ]],

Cell[TextData[{
  "Written as a linear function of ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t\)]],
  ", the lower and upper bounds on ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  " are:"
}], "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`"\!\(\(C\_t\)\+_\) =(-\!\(M\_t\)+\!\(P\_t\)-\!\(1\/2\
\)) \!\(q\_t\)-\!\(1\/2\)"\)], "Caption"],
  "\nand\n\t",
  Cell[BoxData[
      \(TraditionalForm\`"\!\(\(C\_t\)\&_\) =(-\!\(M\_t\)+\!\(P\_t\)+\!\(1\/2\
\)) \!\(q\_t\)-\!\(1\/2\)"\)]]
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  "(",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " details)"
}], "MathGroup"],

Cell[CellGroupData[{

Cell[BoxData[
    \({CBidLimits[\([5]\)] \[Equal] a + b\ q\_t /. q\_t \[Rule] \(-1\), 
      CAskLimits[\([1]\)] \[Equal] a + b\ q\_t /. 
        q\_t \[Rule] \(+1\)}\)], "Input",
  CellLabel->"In[65]:="],

Cell[BoxData[
    \(TraditionalForm\`{M\_t - P\_t == a - b, \(-M\_t\) + P\_t - 1 == 
        a + b}\)], "Output",
  CellLabel->"Out[65]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Flatten[Solve[%, {a, b}] // Simplify]\)], "Input",
  CellLabel->"In[66]:="],

Cell[BoxData[
    \(TraditionalForm\`{a \[Rule] \(-\(1\/2\)\), 
      b \[Rule] \(-M\_t\) + P\_t - 1\/2}\)], "Output",
  CellLabel->"Out[66]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(C\+_ = Evaluate[a + b\ q\_t\ ] /. %\)], "Input",
  CellLabel->"In[67]:="],

Cell[BoxData[
    \(TraditionalForm\`\((\(-M\_t\) + P\_t - 1\/2)\)\ q\_t - 1\/2\)], "Output",\

  CellLabel->"Out[67]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \({CBidLimits[\([1]\)] \[Equal] a + b\ q\_t /. q\_t \[Rule] \(-1\), 
      CAskLimits[\([5]\)] \[Equal] a + b\ q\_t /. 
        q\_t \[Rule] \(+1\)}\)], "Input",
  CellLabel->"In[68]:="],

Cell[BoxData[
    \(TraditionalForm\`{M\_t - P\_t - 1 == a - b, 
      P\_t - M\_t == a + b}\)], "Output",
  CellLabel->"Out[68]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Flatten[Solve[%, {a, b}] // Simplify]\)], "Input",
  CellLabel->"In[69]:="],

Cell[BoxData[
    \(TraditionalForm\`{a \[Rule] \(-\(1\/2\)\), 
      b \[Rule] \(-M\_t\) + P\_t + 1\/2}\)], "Output",
  CellLabel->"Out[69]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(C\&_ = Evaluate[a + b\ q\_t\  /. %]\)], "Input",
  CellLabel->"In[70]:="],

Cell[BoxData[
    \(TraditionalForm\`\((\(-M\_t\) + P\_t + 1\/2)\)\ q\_t - 1\/2\)], "Output",\

  CellLabel->"Out[70]="]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "These bounds cause difficulty because, if we are taking ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`M\)]],
  " as fixed when we make the ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  " draw, then the new value ",
  Cell[BoxData[
      \(TraditionalForm\`\(C\^*\)\)]],
  " is bounded by:"
}], "TextGroup"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`Max\+t\ \(C\_t\)\+_ \[LessEqual] \(C\^*\) \
\[LessEqual] \(Min\+t\) \(C\_t\)\&_\)]]
}], "Text"],

Cell[TextData[{
  "As the maxima and minima are over the full sample, these bounds are likely \
to be extremely confining. This is likely to prevent the ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  " draws from mixing well."
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Alternative approach: A joint draw of  ",
  Cell[BoxData[
      \(TraditionalForm\`C, m | P, q\)]]
}], "Subsection"],

Cell[TextData[{
  "The preceding discussion demonstrated the difficulty of drawing ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  " from its full conditional distribution. One way of viewing the problem is \
to note that if a hypothetical new draw of ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  " were to move more than a very small step away from the present value, it \
would be likely that for some observation in the sample, the existing value \
of ",
  Cell[BoxData[
      \(TraditionalForm\`m\_t\)]],
  " lie outside of the ",
  Cell[BoxData[
      \(TraditionalForm\`\((\(m\_t\)\+_, m\&_\_t)\)\)]],
  " bounds implied by the newly drawn ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  ", i.e., that the new draw would not be feasible. This suggests that a new \
draw of ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  " would have greater latitude if new ",
  Cell[BoxData[
      \(TraditionalForm\`m\_t\)]],
  " were also drawn as well."
}], "Text"],

Cell[TextData[{
  "This is feasible. An overview of the procedure is as follows. We start \
with the current values of ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  ". Suppose for the moment that we have some new candidate draw ",
  Cell[BoxData[
      \(TraditionalForm\`\(C\^*\)\)]],
  ". We assume only that ",
  Cell[BoxData[
      \(TraditionalForm\`\(C\^*\) > 0\)]],
  ". It might be the case that ",
  Cell[BoxData[
      \(TraditionalForm\`\(C\^*\)\)]],
  " implies infeasibility for some or all elements of the current ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  ". A simple way of generating new feasible ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  " is via a deterministic shift. Consider the upper and lower bounds for the \
level efficient price given in eq. (",
  
  CounterBox["NumberedEquation", "MLimits"],
  "), holding ",
  Cell[BoxData[
      \(TraditionalForm\`P\_t\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t\)]],
  " fixed. In moving from ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`\(C\^*\)\)]],
  ", these bounds shift from ",
  Cell[BoxData[
      \(TraditionalForm\`\((\(M\_t\)\+_, \(M\_t\)\&_)\)\)]],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`\((\(M\_t\%*\)\+_, \(M\_t\%*\)\&_)\)\)]],
  ". The shifts in bounds are identical: ",
  Cell[BoxData[
      \(TraditionalForm\`\(M\_t\%*\)\+_ - \(M\_t\)\+_ = \(M\_t\%*\)\&_ - \
\(M\_t\)\&_\)]],
  ". This suggests setting the new value"
}], "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      FormBox[
        RowBox[{\(M\_t\%*\), "=", 
          RowBox[{\(\(M\_t\%*\)\+_\), "+", 
            RowBox[{\((M\_t - \(M\_t\)\+_)\), Cell[""]}]}]}], 
        TraditionalForm]]]
}], "Text"],

Cell[TextData[{
  "(and setting ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(m\_t\%*\), "=", 
          RowBox[{\(log(\(M\_t\%*\))\), Cell[""]}]}], TraditionalForm]]],
  "). In doing this, we are keeping the relative position of the efficient \
price the same within the new set of bounds.\n\nThere are two remaining \
problems. First, how should the ",
  Cell[BoxData[
      FormBox[Cell[TextData[Cell[BoxData[
            \(TraditionalForm\`\(C\^*\)\)]]]], TraditionalForm]]],
  " be generated? Second, how can this procedure be integrated into the Gibbs \
sweep in a valid manner?"
}], "Text"],

Cell[TextData[{
  "The first issue is straightforward. In the basic Roll model, the new draws \
for the cost parameter ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  " arose from the linear regression ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\[VeryThinSpace]p\_t = 
        c\[VeryThinSpace]\[CapitalDelta]\[VeryThinSpace]q\_t + u\_t\)]],
  " (where the variables in the model were in logs). This equation doesn't \
hold in the present case due to the discreteness transformations. It does \
suggest, however, a way for generating new values of ",
  "C",
  ". We could randomly generated ",
  Cell[BoxData[
      \(TraditionalForm\`U\_t~\(N(0, \[Sigma]\_U\%2)\)\)]],
  ", and then set up the regression:"
}], "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`\((C\[VeryThinSpace]\[CapitalDelta]\[VeryThinSpace]q\
\_t + U\_t)\) = \(C\^*\)\[VeryThinSpace]\[CapitalDelta]\[VeryThinSpace]q\_t + 
          U\_t\)]]
}], "NumberedEquation",
  CellTags->"SimulatedCRegression"],

Cell[TextData[{
  "That is, we use the current value ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  " to simulate a dependent variable, regress it against the ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\[VeryThinSpace]q\_t\)]],
  ", and draw ",
  Cell[BoxData[
      \(TraditionalForm\`\(C\^*\)\)]],
  " from the coefficient posterior. Obviously, this regression loosely \
corresponds to the one used in the basic model."
}], "Text"],

Cell[TextData[{
  "This procedure defines what is generally termed a candidate or proposal \
distribution for generating a new parameter value from an existing one. It \
defines a conditional distribution ",
  Cell[BoxData[
      \(TraditionalForm\`g(\(C\^*\) | C)\)]],
  ". The convention, however, is to write this as ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(g(C, \(C\^*\))\), Cell[""]}], TraditionalForm]]],
  ", where ",
  "g",
  " is a transition density in a Markov chain. Since a new value ",
  Cell[BoxData[
      \(TraditionalForm\`\(C\^*\)\)]],
  " implies new values ",
  Cell[BoxData[
      \(TraditionalForm\`\(m\^*\)\)]],
  ", this candidate/proposal/transition density is more properly written ",
  Cell[BoxData[
      \(TraditionalForm\`g(C, m, \(C\^*\), \(m\^*\))\)]],
  ". (In this case, though, once we've chosen the new value ",
  Cell[BoxData[
      \(TraditionalForm\`\(C\^*\)\)]],
  ", however, the new ",
  Cell[BoxData[
      \(TraditionalForm\`\(m\^*\)\)]],
  "are automatically determined.)"
}], "Text"],

Cell[TextData[{
  "We now turn to the second question, viz., how to use this candidate \
density. The Gibbs sampler turns out to be a special case of a more general \
sampling scheme called the Metropolis-Hastings sampler. The program for this \
sampler can be described as follows. Suppose that we enter sweep ",
  Cell[BoxData[
      \(TraditionalForm\`j + 1\)]],
  " with values ",
  Cell[BoxData[
      \(TraditionalForm\`C\^\((j)\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`m\^\((j)\)\)]],
  ". Then:"
}], "Text"],

Cell[TextData[{
  "1. Draw ",
  Cell[BoxData[
      \(TraditionalForm\`\(C\^*\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\(m\^*\)\)]],
  " from the candidate density ",
  Cell[BoxData[
      \(TraditionalForm\`g(C, m, \(C\^*\), \(m\^*\))\)]]
}], "Text"],

Cell["2. Compute", "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Alpha]", "=", 
          RowBox[{"Min", "(", 
            RowBox[{"1", ",", 
              StyleBox[
                
                FractionBox[\(\(f(\(C\^*\), \(m\^*\))\) \(g(\(C\^*\), \
\(m\^*\), C\^\((j)\), m\^\((j)\))\)\), 
                  RowBox[{\(f(C\^\((j)\), m\^\((j)\))\), 
                    RowBox[{"g", "(", 
                      RowBox[{\(C\^\((j)\)\), ",", 
                        RowBox[{\(m\^\((j)\)\), Cell[""]}], ",", \(C\^*\), 
                        ",", \(m\^*\)}], ")"}]}]],
                ScriptLevel->0]}], ")"}]}], TraditionalForm]]]
}], "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`f(\(C\^*\), \(m\^*\))\)]],
  " is the true (\"target\") density evaluated at the proposal draws, ",
  Cell[BoxData[
      \(TraditionalForm\`f(C\^\((j)\), m\^\((j)\))\)]],
  " is the true density evaluated at the sweep-",
  Cell[BoxData[
      \(TraditionalForm\`j\)]],
  " values, ",
  Cell[BoxData[
      FormBox[
        RowBox[{"g", "(", 
          RowBox[{\(C\^\((j)\)\), ",", 
            RowBox[{\(m\^\((j)\)\), Cell[""]}], ",", \(C\^*\), 
            ",", \(m\^*\)}], ")"}], TraditionalForm]]],
  " is the transition probability associated with generating the new values \
(conditional on the old ones), and ",
  Cell[BoxData[
      \(TraditionalForm\`g(\(C\^*\), \(m\^*\), C\^\((j)\), m\^\((j)\))\)]],
  " is the reverse transition probability (i.e., the probability of \
generating the old values if we'd started with the new ones)."
}], "Text"],

Cell[TextData[{
  "3. Generate ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  " a uniform random number between zero and one."
}], "Text"],

Cell[TextData[{
  "4. If ",
  Cell[BoxData[
      \(TraditionalForm\`z < \[Alpha]\)]],
  ", \"accept the proposal\". That is, set ",
  Cell[BoxData[
      \(TraditionalForm\`C\^\((j + 1)\) = \(C\^*\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`m\^\((j + 1)\) = \(m\^*\)\)]],
  ".\nIf ",
  Cell[BoxData[
      \(TraditionalForm\`z \[GreaterEqual] \[Alpha]\)]],
  ", \"reject the proposal\". That is, set ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(C\^\((j + 1)\)\)\(=\)\(C\^\((j)\)\)\(\ \)\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`m\^\((j + 1)\) = m\^\((j)\)\)]],
  "."
}], "Text"],

Cell[TextData[{
  "As with the Gibbs sampler, in the limit as ",
  Cell[BoxData[
      \(TraditionalForm\`j \[Rule] \[Infinity]\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\((C\^\((j)\), m\^\((j)\))\)\)]],
  " are random numbers distributed in accordance with the target density ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  "."
}], "Text"],

Cell[TextData[{
  "In the present case, the target density is the conditional density ",
  Cell[BoxData[
      \(TraditionalForm\`f(C, m | \[Sigma]\_u, q, P)\)]],
  ", i.e., the full conditional density given the observed data, the latent \
data and remaining parameter. "
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{\(f(C, m | \[Sigma]\_u, q, P)\), "=", 
        StyleBox[\(\(\(Pr(P | m, q, C, \[Sigma]\_u)\) \(f(m | q, 
                  C, \[Sigma]\_u)\) \(Pr(q | C, \[Sigma]\_u)\) \(f(
                  C, \[Sigma]\_u)\)\)\/\(\(Pr(P, 
                  q | \[Sigma]\_u)\) \(f(\[Sigma]\_u)\)\)\),
          ScriptLevel->0]}], TraditionalForm]]]], "NumberedEquation"],

Cell[TextData[{
  "Since the mapping from ",
  Cell[BoxData[
      \(TraditionalForm\`m, q, \ and\ C\)]],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " is nonstochastic, ",
  Cell[BoxData[
      \(TraditionalForm\`Pr(P | m, q, C, \[Sigma]\_u) = 1\)]],
  ". From the assumed independence of the prior distributions,"
}], "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`\(Pr(q | C, \[Sigma]\_u)\) \(f(
          C, \[Sigma]\_u)\) = \(Pr(q)\) \(f(
          C)\) \(f(\[Sigma]\_u)\)\)]]], "NumberedEquation"],

Cell["Therefore", "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`f(C, m | \[Sigma]\_u, q, 
          P) \[Proportional] \(f(m | q, C, \[Sigma]\_u)\) \(f(C)\) = \(f(
          m | \[Sigma]\_u)\) \(f(C)\)\)]]], "NumberedEquation"],

Cell[TextData[{
  "(since ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " are independent of ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  "). These two quantities are simple to evaluate for the existing and \
proposed draws."
}], "Text"],

Cell[TextData[{
  "In drawing from the proposal density, it is not really necessary to \
simulate the ",
  Cell[BoxData[
      \(TraditionalForm\`U\_t\)]],
  " and actually run the regression given in eq. (",
  
  CounterBox["NumberedEquation", "SimulatedCRegression"],
  "). Suppose that the prior for ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  " is ",
  Cell[BoxData[
      \(TraditionalForm\`\(N\^+\)(0, \[CapitalOmega]\_C\%Prior)\)]],
  ". Using the classic Bayesian regression results from section ",
  
  CounterBox["None"],
  ".",
  
  CounterBox["None"],
  ", if we simulated and ran the regression, the posterior would be ",
  Cell[BoxData[
      \(TraditionalForm\`\(N\^+\)(\[Mu]\_C\%Posterior, \
\[CapitalOmega]\_C\%Posterior)\)]],
  " with"
}], "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Mu]\_C\%Posterior\), "=", 
          RowBox[{
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{
                  
                  StyleBox[\(\(\[Sum]\+t \
\[CapitalDelta]\[VeryThinSpace]q\_t\%2\)\/\[Sigma]\_U\%2\),
                    ScriptLevel->0], "+", 
                  StyleBox[\(1\/\[CapitalOmega]\_C\%Prior\),
                    ScriptLevel->0]}], ")"}], \(-1\)], 
            RowBox[{"(", 
              
              StyleBox[\(\(\[Sum]\+t \
\[CapitalDelta]\[VeryThinSpace]\(\(q\_t\)(
                          C\[VeryThinSpace]\[CapitalDelta]\[VeryThinSpace]q\_\
t + U\_t)\)\)\/\[Sigma]\_U\%2\),
                ScriptLevel->0], ")"}]}]}], TraditionalForm]]]
}], "Text"],

Cell["and", "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[CapitalOmega]\_C\%Posterior\), "=", 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{
                
                StyleBox[\(\(\[Sum]\+t \[CapitalDelta]\[VeryThinSpace]q\_t\%2\
\)\/\[Sigma]\_U\%2\),
                  ScriptLevel->0], "+", 
                StyleBox[\(1\/\[CapitalOmega]\_C\%Prior\),
                  ScriptLevel->0]}], ")"}], \(-1\)]}], TraditionalForm]]],
  "\n"
}], "Text"],

Cell["A sensible expedient is to take", "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Mu]\_C\%Posterior\), "=", 
          RowBox[{
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{
                  
                  StyleBox[\(\(\[Sum]\+t \
\[CapitalDelta]\[VeryThinSpace]q\_t\%2\)\/\[Sigma]\_U\%2\),
                    ScriptLevel->0], "+", 
                  StyleBox[\(1\/\[CapitalOmega]\_C\%Prior\),
                    ScriptLevel->0]}], ")"}], \(-1\)], 
            RowBox[{"(", 
              
              StyleBox[\(\(C \(\[Sum]\+t \
\[CapitalDelta]\[VeryThinSpace]q\_t\%2\)\)\/\[Sigma]\_U\%2\),
                ScriptLevel->0], ")"}]}]}], TraditionalForm]]]
}], "Text"],

Cell[TextData[{
  "Since ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  " is a cost parameter in levels (rather than logs), ",
  Cell[BoxData[
      \(TraditionalForm\`U\_t\)]],
  " is also a level disturbance. A logical choice for ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\_U\%2\)]],
  " is ",
  Cell[BoxData[
      \(TraditionalForm\`\(P\&_\) \[Sigma]\_u\%2\)]],
  " where ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\_u\)]],
  " is the current draw of this parameter and ",
  Cell[BoxData[
      \(TraditionalForm\`P\&_\)]],
  " is the average price level over the sample. In taking these shortcuts, we \
are departing from the full conditional distribution. This is permissible \
because ",
  Cell[BoxData[
      \(TraditionalForm\`g( ... )\)]],
  " is only a proposal density."
}], "Text"],

Cell[TextData[{
  "Although this draw is joint over both ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  ", it does not replace the ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  " draw described above. The reason is that this joint draw cannot generate \
all values of ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  "; it only shifts the values in a rather limited fashion."
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Clustered prices", "Section",
  CellTags->"Clustered prices"],

Cell[CellGroupData[{

Cell["Model description", "Subsection"],

Cell["\<\
This is an extension of the simple discreteness model. The evolution of the \
(log) efficient price is:\
\>", "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`m\_t = m\_\(t - 1\) + u\_t\)]],
  " where ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(u\_t\ ~N\), Cell[TextData[{
            "(0,",
            Cell[BoxData[
                \(TraditionalForm\`\[Sigma]\_u\%2\)]],
            ")"
          }]]}], TraditionalForm]]]
}], "Text"],

Cell[TextData[{
  "The (level) efficient price is therefore ",
  Cell[BoxData[
      \(TraditionalForm\`M\_t = e\^m\_t\)]],
  ". (The units here are \"dollars.\") The half-spread in levels is ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  ". The bid and ask quotes are:"
}], "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`B\_t = Floor(M\_t - C, K\_t)\)]],
  "\n\t",
  Cell[BoxData[
      \(TraditionalForm\`A\_t = Ceiling(M\_t + C, K\_t)\)]]
}], "Text"],

Cell[TextData[{
  "The rounding functions here round down or up to the nearest ",
  Cell[BoxData[
      \(TraditionalForm\`K\)]],
  "-multiple of the \"official\" tick size. It is assumed that the variables \
are scaled so that the minimum tick size is unity. The ",
  Cell[BoxData[
      \(TraditionalForm\`K\_t\)]],
  " are then i.i.d. Bernoulli variates:"
}], "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`\(\(K\_t\)\(=\)\)\)]],
  Cell[BoxData[
      FormBox[
        RowBox[{"{", GridBox[{
              {\(1, \ with\ probability\ \((1 - k)\)\)},
              {\(\[Kappa], \ \(\(with\)\(\ \)\(probability\)\(\ \)\(k\)\(\ \ \
\ \ \ \ \ \ \ \ \ \)\)\)}
              }]}], TraditionalForm]]]
}], "Text"],

Cell[TextData[{
  "\[Kappa] is a \"natural multiple\" of the basic tick size, like 2, 5 or \
10. ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " is the clustering probability. The buy/sell indicator is"
}], "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      FormBox[
        RowBox[{\(q\_t\), "=", 
          RowBox[{"{", GridBox[{
                {
                  RowBox[{\(+1\), ",", " ", 
                    RowBox[{
                      StyleBox["a",
                        FontSlant->"Plain"], " ", "buy"}], ",", 
                    " ", \(with\ probability\ 1\/2\)}]},
                {
                  RowBox[{\(-1\), ",", " ", 
                    RowBox[{
                      StyleBox["a",
                        FontSlant->"Plain"], " ", "sell"}], ",", 
                    " ", \(with\ probability\ 1\/2\)}]}
                }]}]}], TraditionalForm]]],
  "\nThe obseved transaction price is"
}], "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      FormBox[
        RowBox[{\(P\_t\), "=", 
          RowBox[{"{", GridBox[{
                {\(\(A\_t\) if\ q\_t = \(+1\)\)},
                {\(\(B\_t\) if\ q\_t = \(-1\)\)}
                }], "]"}]}], TraditionalForm]]]
}], "Text"],

Cell[TextData[{
  "In the latent data draw, at each time ",
  "t",
  ", we need to draw ",
  Cell[BoxData[
      \(TraditionalForm\`m\_t, q\_t, K\_t | m\_\(\(\\\)\(t\)\), 
      q\_\(\(\\\)\(t\)\), P\_t\)]],
  ". The draw is made in two steps:"
}], "Text"],

Cell[TextData[{
  "1. Draw ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t, K\_t | m\_\(t - 1\), m\_\(t + 1\), P\_t\)]],
  "."
}], "Text"],

Cell[TextData[{
  "2. Draw ",
  Cell[BoxData[
      \(TraditionalForm\`m\_t | m\_\(t - 1\), m\_\(t + 1\), q\_t, K\_t, 
      P\_t\)]],
  "."
}], "Text"],

Cell[TextData[{
  "The parameter draw for ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  " proceeds exactly as in discreteness model. (That is, we make a joint draw \
of ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  ". See section ",
  
  CounterBox["Section", "Discrete Prices"],
  ".) There is also an additional parameter draw, ",
  Cell[BoxData[
      \(TraditionalForm\`k | K\)]],
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "The draw for ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t, K\_t | m\_\(t - 1\), m\_\(t + 1\), P\_t\)]]
}], "Subsection"],

Cell["We have:", "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{\(Pr(q\_t, K\_t | m\_\(t - 1\), m\_\(t + 1\), P\_t)\), 
        "\[IndentingNewLine]", "=", 
        RowBox[{
          RowBox[{
            
            StyleBox[\(\(\(Pr(P\_t | m\_\(t - 1\), m\_\(t + 1\), q\_t, 
                      K\_t)\)\ \[Times]\(Pr(q\_t, K\_t | m\_\(t - 1\), 
                      m\_\(t + 1\))\)\[Times]\(f(m\_\(t - 1\), 
                      m\_\(t + 1\))\)\)\/\(\(Pr(P\_t | m\_\(t - 1\), 
                      m\_\(t + 1\))\) \(f(m\_\(t - 1\), m\_\(t + 1\))\)\)\),
              ScriptLevel->0], "\[IndentingNewLine]", 
            "\[Proportional]", \(\(Pr(P\_t | m\_\(t - 1\), m\_\(t + 1\), 
                q\_t, K\_t)\)\ \[Times]\(Pr(q\_t, K\_t | m\_\(t - 1\), 
                m\_\(t + 1\))\)\)}], "\[IndentingNewLine]", "   ", 
          "=", \(\(Pr(P\_t | m\_\(t - 1\), m\_\(t + 1\), q\_t, 
              K\_t)\)\ \[Times]\(Pr(q\_t)\) \(Pr(K\_t)\)\)}]}], 
      TraditionalForm]]]], "NumberedEquation",
  CellTags->"ClusterBayes"],

Cell[TextData[{
  "The last equality follows from the fact that ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`K\_t\)]],
  " are mutually independent and also independent of the evolution of ",
  Cell[BoxData[
      \(TraditionalForm\`m\_t\)]],
  ". Next,"
}], "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`Pr(P\_t | m\_\(t - 1\), m\_\(t + 1\), q\_t, 
          K\_t) = \[Integral]\_\(m\+_\)\%\(m\&_\)\(f(m\_t | m\_\(t - 1\), 
              m\_\(t + 1\))\) \[DifferentialD]m\_t\)]]
}], "Text"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`m\+_\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`m\&_\)]],
  " are the limits established by ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`K\_t\)]],
  " (see below). The general plan is as follows. Using (",
  
  CounterBox["NumberedEquation", "ClusterBayes"],
  "), we compute unnormalized probabilities for the four possible \
combinations of ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`K\_t\)]],
  ". We normalize these probabilities and make the draw of the ",
  Cell[BoxData[
      \(TraditionalForm\`{q\_t, K\_t}\)]],
  " pair. We then proceed to the ",
  Cell[BoxData[
      \(TraditionalForm\`m\_t\)]],
  " draw. We turn now to the details."
}], "Text"],

Cell["The floor and ceiling functions in the model imply ", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MBidLimits = 
      InequalitySolve[B\_t < M\_t - C < B\_t + K\_t, M\_t]\)], "Input",
  CellLabel->"In[71]:="],

Cell[BoxData[
    \(TraditionalForm\`C + B\_t < M\_t < C + B\_t + K\_t\)], "Output",
  CellLabel->"Out[71]="]
}, Open  ]],

Cell["and", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MAskLimits = 
      InequalitySolve[A\_t - K\_t < M\_t + C < A\_t, M\_t]\)], "Input",
  CellLabel->"In[72]:="],

Cell[BoxData[
    \(TraditionalForm\`\(-C\) + A\_t - K\_t < M\_t < A\_t - C\)], "Output",
  CellLabel->"Out[72]="]
}, Open  ]],

Cell[TextData[{
  "When ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t = \(-1\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`B\_t = P\_t\)]],
  ", and"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MBidLimits = MBidLimits /. B\_t \[Rule] P\_t\)], "Input",
  CellLabel->"In[73]:="],

Cell[BoxData[
    \(TraditionalForm\`C + P\_t < M\_t < C + K\_t + P\_t\)], "Output",
  CellLabel->"Out[73]="]
}, Open  ]],

Cell[TextData[{
  "When ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t = \(+1\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`A\_t = P\_t\)]],
  ", and"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MAskLimits = MAskLimits /. A\_t \[Rule] P\_t\)], "Input",
  CellLabel->"In[74]:="],

Cell[BoxData[
    \(TraditionalForm\`\(-C\) - K\_t + P\_t < M\_t < P\_t - C\)], "Output",
  CellLabel->"Out[74]="]
}, Open  ]],

Cell[TextData[{
  "The lower and upper limit functions for ",
  Cell[BoxData[
      \(TraditionalForm\`M\)]],
  " are:"
}], "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`\(M\+_\)(q\_t, K\_t) = 
        1\/2\ \((\(-q\_t\)\ K\_t - K\_t + 2\ P\_t - 2\ C\ q\_t)\)\)]],
  " \nand \n\t",
  Cell[BoxData[
      \(TraditionalForm\`\(M\&_\)(q\_t, K\_t) = 
        P\_t + \(\(1\/2\)\(\ \)\((K\_t - \((2\ C + 
                      K\_t)\)\ q\_t)\)\(\ \)\)\)]]
}], "Text"],

Cell[TextData[{
  "The limits on the log efficient price are then ",
  Cell[BoxData[
      \(TraditionalForm\`m\+_[q\_t, K\_t] = log[\(M\+_\)(q\_t, K\_t)]\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`m\&_[q\_t, K\_t] = log[\(M\&_\)(q\_t, K\_t)]\)]],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  "(",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " code)"
}], "MathGroup"],

Cell[CellGroupData[{

Cell[BoxData[
    \({MBidLimits[\([1]\)] \[Equal] a + b\ q\_t /. 
        q\_t \[Rule] \(-1\), \[IndentingNewLine]MAskLimits[\([1]\)] \[Equal] 
          a + b\ q\_t /. q\_t \[Rule] \(+1\)}\)], "Input",
  CellLabel->"In[75]:="],

Cell[BoxData[
    \(TraditionalForm\`{C + P\_t == a - b, \(-C\) - K\_t + P\_t == 
        a + b}\)], "Output",
  CellLabel->"Out[75]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Flatten[Solve[%, {a, b}] // Simplify]\)], "Input",
  CellLabel->"In[76]:="],

Cell[BoxData[
    \(TraditionalForm\`{a \[Rule] P\_t - K\_t\/2, 
      b \[Rule] 1\/2\ \((\(-2\)\ C - K\_t)\)}\)], "Output",
  CellLabel->"Out[76]="]
}, Open  ]],

Cell[BoxData[
    \(M\+_[q_, K_] := 
      Evaluate[\(a + b\ q\  /. %\)\  /. K\_t \[Rule] K // 
          FullSimplify]\)], "InputOnly",
  CellLabel->"In[77]:="],

Cell[CellGroupData[{

Cell[BoxData[
    \(M\+_[q\_t, K\_t]\)], "Input",
  CellLabel->"In[78]:="],

Cell[BoxData[
    \(TraditionalForm\`1\/2\ \((\(-q\_t\)\ K\_t - K\_t + 2\ P\_t - 
          2\ C\ q\_t)\)\)], "Output",
  CellLabel->"Out[78]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \({MBidLimits[\([5]\)] \[Equal] a + b\ q\_t /. q\_t \[Rule] \(-1\), 
      MAskLimits[\([5]\)] \[Equal] a + b\ q\_t /. 
        q\_t \[Rule] \(+1\)}\)], "Input",
  CellLabel->"In[79]:="],

Cell[BoxData[
    \(TraditionalForm\`{C + K\_t + P\_t == a - b, 
      P\_t - C == a + b}\)], "Output",
  CellLabel->"Out[79]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Flatten[Solve[%, {a, b}] // Simplify]\)], "Input",
  CellLabel->"In[80]:="],

Cell[BoxData[
    \(TraditionalForm\`{a \[Rule] K\_t\/2 + P\_t, 
      b \[Rule] 1\/2\ \((\(-2\)\ C - K\_t)\)}\)], "Output",
  CellLabel->"Out[80]="]
}, Open  ]],

Cell[BoxData[
    \(M\&_[q_, K_] := 
      Evaluate[\(a + b\ q\  /. %\) /. K\_t \[Rule] K // 
          FullSimplify]\)], "InputOnly",
  CellLabel->"In[81]:="],

Cell[CellGroupData[{

Cell[BoxData[
    \(M\&_[q\_t, K\_t]\)], "Input",
  CellLabel->"In[82]:="],

Cell[BoxData[
    \(TraditionalForm\`P\_t + 
      1\/2\ \((K\_t - \((2\ C + K\_t)\)\ q\_t)\)\)], "Output",
  CellLabel->"Out[82]="]
}, Open  ]],

Cell[BoxData[
    \(m\+_[q_, K_] := Log[M\+_[q, K]]; 
    m\&_[q_, K_] := Log[M\&_[q, K]]\)], "InputOnly",
  CellLabel->"In[83]:="]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "From eq. (",
  
  CounterBox["NumberedEquation", "ClusterBayes"],
  "), and using the fact that ",
  Cell[BoxData[
      \(TraditionalForm\`Pr(q\_t) = 1/2\)]],
  ", "
}], "TextGroup"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`Pr(q\_t, K\_t | m\_\(t - 1\), m\_\(t + 1\), 
        P\_t)\)]],
  Cell[BoxData[
      \(TraditionalForm\`\(\(\[Proportional]\)\(\(Pr(P\_t | m\_\(t - 1\), 
            m\_\(t + 1\), q\_t, K\_t)\)\ \[Times]\(Pr(K\_t)\)\)\)\)]]
}], "NumberedEquation"],

Cell[TextData[{
  "Recall that ",
  Cell[BoxData[
      \(TraditionalForm\`f(m\_t | m\_\(t - 1\), 
          m\_\(t + 1\)) = \[Phi](\[Mu]\_m, \[Sigma]\_m, m\_t)\)]],
  " with ",
  Cell[BoxData[
      \(TraditionalForm\`\[Mu]\_m = \(\((m\_\(t - 1\) + m\_\(t + 1\))\)/
              2\ \ and\ \ \[Sigma]\_m = \[Sigma]\_u/\@2\)\)], "TextGroup"],
  ". Thus,"
}], "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`Pr(q\_t, K\_t | m\_\(t - 1\), m\_\(t + 1\), 
          P\_t) \[Proportional] \ \[CapitalPhi][\[Mu]\_m, \[Sigma]\_m, \(m\+_\
\)(q\_t, K\_t), \(m\&_\)(q\_t, K\_t)] \(Pr(K\_t)\)\)]],
  " "
}], "Text"],

Cell[TextData[{
  "for ",
  Cell[BoxData[
      \(TraditionalForm\`\((q\_t, 
          K\_t)\) \[Element] {\(+1\), \(-1\)}\[Times]{1, \[Kappa]}\)]],
  ". Let ",
  Cell[BoxData[
      \(TraditionalForm\`i\)]],
  " index the four possible combinations of ",
  Cell[BoxData[
      \(TraditionalForm\`\((q\_t, K\_t)\)\)]],
  ", and let "
}], "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`Z\_i = \ \[CapitalPhi][\[Mu]\_m, \[Sigma]\_m, \(m\+_\
\)(q\_t, K\_t), \(m\&_\)(q\_t, K\_t)] \(Pr(K\_t)\)\)]],
  " "
}], "Text"],

Cell[TextData[{
  "evaluated at the the ",
  Cell[BoxData[
      \(TraditionalForm\`i\)]],
  "th values. Then the normalized probability of outcome ",
  Cell[BoxData[
      \(TraditionalForm\`i\)]],
  " is ",
  Cell[BoxData[
      \(TraditionalForm\`Z\_i/\[CapitalSigma]Z\_i\)]],
  "."
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "The draw for ",
  Cell[BoxData[
      \(TraditionalForm\`m\_t | m\_\(t - 1\), m\_\(t + 1\), q\_t, K\_t, 
      P\_t\)]]
}], "Subsection"],

Cell[TextData[{
  "This is simply a draw from ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(m\_t | m\_\(t - 1\), m\_\(t + 1\))\), Cell[""]}], 
        TraditionalForm]]],
  "truncated to ",
  Cell[BoxData[
      \(TraditionalForm\`\((m\+_, m\&_)\)\)]],
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "The parameter draw for ",
  Cell[BoxData[
      \(TraditionalForm\`k | K\)]]
}], "Subsection"],

Cell[TextData[{
  "The clustering variables are defined by ",
  Cell[BoxData[
      \(TraditionalForm\`K = {K\_1,  ... , K\_T}\)]],
  ", where each ",
  Cell[BoxData[
      \(TraditionalForm\`K\_t \[Element] {1, \[Kappa]}\)]],
  ". Let ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " be the number of ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " for which ",
  Cell[BoxData[
      \(TraditionalForm\`K\_t = \[Kappa]\)]],
  ". If the probability of ",
  Cell[BoxData[
      \(TraditionalForm\`K\_t = \[Kappa]\)]],
  " is ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  ", then ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " is a binomial random variable. The beta distribution is conjugate to the \
binomal (Tanner, 1996), so ",
  Cell[BoxData[
      \(TraditionalForm\`Beta[a, b]\)]],
  " is a convenient prior for ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  ". We let ",
  Cell[BoxData[
      \(TraditionalForm\`a\^Prior = \(b\^Prior = 1/2\)\)]],
  ", for which the Beta density is uniform on the unit interval. The \
posterior for ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " is then ",
  Cell[BoxData[
      \(TraditionalForm\`Beta[a\^Posterior, b\^Posterior]\)]],
  " where ",
  Cell[BoxData[
      \(TraditionalForm\`a\^Posterior = a\^Prior + n\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`b\^Posterior = b\^Prior + T - n\)]],
  "."
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Lagged trade dependencies", "Section",
  CellTags->"LaggedTradeDependencies"],

Cell[CellGroupData[{

Cell["Model description", "Subsection"],

Cell["\<\
In this extension of the informative trade model, the evolution of the \
efficient price is allowed to depend on lagged signed trades (as well as the \
contemporaneous one).\
\>", "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`m\_t = 
      m\_\(t - 1\) + \[CapitalLambda]\_t + u\_t\)]]], "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalLambda]\_t\)]],
  " is the impact term:"
}], "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalLambda]\_t = \[Sum]\+\(j = 0\)\%\(Min(J, t \
- 1)\)\(q\_\(t - j\)\) \(\[Lambda]\_j\) V\_\(t - j\)\)]]
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`J\)]],
  " is the order of the lagged dependence. The upper limit of the sum \
indicates that the lags do not extend before the beginning of the sample. The \
observed price is:"
}], "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`p\_t = m\_t + c\[VeryThinSpace]q\_t\)]]
}], "Text"],

Cell[TextData[{
  "The parameter draw for ",
  Cell[BoxData[
      \(TraditionalForm\`{\[Lambda]\_0,  ... , \[Lambda]\_J, 
        c, \[Sigma]\_u}\)]],
  " is (mostly) straightforward. Given the observed and latent data,"
}], "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`\[CapitalDelta]\[VeryThinSpace]p\_t = \
\(\[CapitalDelta]\[VeryThinSpace]m\_t + 
          c\[VeryThinSpace]\[CapitalDelta]\[VeryThinSpace]q\_t = \(\
\[CapitalLambda]\_t + c\[VeryThinSpace]\[CapitalDelta]\[VeryThinSpace]q\_t + 
            u\_t = \[VeryThinSpace]\[Sum]\+\(j = 0\)\%\(Min(J, t - 1)\)\(\(\(\
\[Lambda]\)\(\[VeryThinSpace]\)\)\_j\) \(q\_\(t - j\)\) V\_\(t - j\) + 
            c\[VeryThinSpace]\[CapitalDelta]\[VeryThinSpace]q\_t + 
            u\_t\)\)\)]]], "NumberedEquation",
  CellTags->"LaggedTradeDepRegression"],

Cell[TextData[{
  "This fits into the Bayesian multiple regression framework (with ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  " and the ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda]\_j\)]],
  " the coefficients). "
}], "Text"],

Cell[TextData[{
  "There is the potential for multicollinearity here, however. Suppose that \
",
  Cell[BoxData[
      \(TraditionalForm\`J = 1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`V\_t = 1\)]],
  ". Then "
}], "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\[VeryThinSpace]p\_t = \(\[Lambda]\_0\
\) q\_t + \(\[Lambda]\_1\) q\_\(t - 1\) + 
          c\[VeryThinSpace]\[CapitalDelta]\[VeryThinSpace]q\_t + u\_t\)]]
}], "Text"],

Cell[TextData[{
  "In economic terms, the impact of a trade on the efficient price depends \
only on the direction of the trade, and not its size. Since ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\[VeryThinSpace]q\_t = 
        q\_t - q\_\(t - 1\)\)]],
  ", however, the cross-product matrix is singular. Some sort of additional \
structure is needed. (One possibility is to simply let ",
  Cell[BoxData[
      \(TraditionalForm\`V\_t = Vol\_t\)]],
  ".)"
}], "Text"],

Cell[TextData[{
  "The latent data draw is of  ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t | m\_\(\(\\\)\(t\)\), p\_t, 
      q\_\(\(\\\)\(t\)\)\)]],
  ". This follows the design of the draw for the contemporaneous impact \
model, but the lagged structure extends the ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t\)]],
  " dependencies. From the structure of the sum, it is clear that ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t\)]],
  " influences ",
  Cell[BoxData[
      \(TraditionalForm\`m\_t,  ... , m\_\(t + P\)\)]],
  ".  Therefore ",
  Cell[BoxData[
      \(TraditionalForm\`Pr(q\_t | m\_\(\(\\\)\(t\)\), 
        q\_\(\(\\\)\(t\)\))\)]],
  " depends on ",
  Cell[BoxData[
      \(TraditionalForm\`\[Product]\+\(s = 0\)\%J f(u\_\(t + s\))\)]],
  ".  From inspection of these terms, "
}], "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`Pr(q\_t | m\_\(\(\\\)\(t\)\), p\_t, 
          q\_\(\(\\\)\(t\)\)) = 
        Pr(q\_t | m\_\(t - 1\), m\_\(t + 1\), \(\(...\) \(m\_\(t + P\)\)\), 
          p\_t, q\_\(t - P\),  ... , q\_\(t - 1\), q\_\(t + 1\),  ... , 
          q\_\(t + P\))\)]],
  ". "
}], "Text"],

Cell["\<\
For notational simplicity, however, the conditioning set indicated on the \
l.h.s. will be used below.\
\>", "Text"],

Cell[TextData[{
  "Analogous to eq. (",
  
  CounterBox["NumberedEquation", "BayesContemporaneousImpact"],
  "),"
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{\(Pr(q\_t | m\_\(\(\\\)\(t\)\), p\_t, q\_\(\(\\\)\(t\)\))\), 
        "=", 
        StyleBox[\(\(\(f(p\_t | m\_\(\(\\\)\(t\)\), q\_\(\(\\\)\(t\)\), 
                  q\_t)\)\[Times]\(Pr(q\_t | m\_\(\(\\\)\(t\)\), 
                  q\_\(\(\\\)\(t\)\))\)\)\/\(f(p\_t | m\_\(\(\\\)\(t\)\), 
                q\_\(\(\\\)\(t\)\))\)\),
          ScriptLevel->0]}], TraditionalForm]]]], "NumberedEquation",
  CellTags->"LaggedInformativeModelBayes"],

Cell[TextData[{
  "Since ",
  Cell[BoxData[
      \(TraditionalForm\`q = {q\_\(\(\\\)\(t\)\), q\_t}\)]],
  ", the first term in the numerator could have been written more concisely \
(but less clearly) as ",
  Cell[BoxData[
      \(TraditionalForm\`f(p\_t | m\_\(\(\\\)\(t\)\), q)\)]],
  ". The denominator can be treated as a proportionality factor. The two \
terms in the numerator must be evaluated separately."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Evaluation of ",
  Cell[BoxData[
      \(TraditionalForm\`Pr(q\_t | m\_\(\(\\\)\(t\)\), \ 
        q\_\(\(\\\)\(t\)\))\)]]
}], "Subsection",
  CellTags->"LaggedTradeImpact1"],

Cell[TextData[{
  "This probability is derived from the joint density of ",
  Cell[BoxData[
      \(TraditionalForm\`u\_t,  ... , u\_\(Min(t + J, T)\)\)]],
  ", which is ",
  Cell[BoxData[
      \(TraditionalForm\`\[Product]\+\(s = 0\)\%\(Min(J, T - t)\)f(
          u\_\(t + s\))\)]],
  ". When ",
  Cell[BoxData[
      \(TraditionalForm\`t < T\)]],
  ", it is convenient to write this as:"
}], "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`\[Product]\+\(s = 0\)\%\(Min(J, T - t)\)f(
          u\_\(t + s\)) = \((\[Product]\+\(s = t + 2\)\%\(J + t\)\[Phi](
              0, \[Sigma]\_u, u\_s))\)\ \(\[Phi](0, \[Sigma]\_u, 
          u\_t)\)\ \(\[Phi](0, \[Sigma]\_u, 
          u\_\(t + 1\))\)\)]]], "NumberedEquation",
  CellTags->"Prodfu"],

Cell[TextData[{
  "Here, we've pulled out the two terms that depend on ",
  Cell[BoxData[
      \(TraditionalForm\`m\_t\)]],
  ". Substituting in for ",
  Cell[BoxData[
      \(TraditionalForm\`u\_t\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\(t + 1\)\)]],
  ", these terms are:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(uDef[t_] := 
        u\_t \[Rule] 
          m\_t - \((m\_\(t - 1\) + \[CapitalLambda]\_t)\);\)\), "\n", 
    \(f1 = \(\[Phi][0, \[Sigma]\_u, u\_t] \[Phi][0, \[Sigma]\_u, 
              u\_\(t + 1\)] /. uDef[t]\) /. uDef[t + 1]\)}], "Input",
  CellLabel->"In[84]:="],

Cell[BoxData[
    \(TraditionalForm\`\(\[Phi](
        0, \[Sigma]\_u, \(-m\_\(t - 1\)\) + 
          m\_t - \[CapitalLambda]\_t)\)\ \(\[Phi](
        0, \[Sigma]\_u, \(-m\_t\) + 
          m\_\(t + 1\) - \[CapitalLambda]\_\(t + 1\))\)\)], "Output",
  CellLabel->"Out[85]="]
}, Open  ]],

Cell[TextData[{
  "Integrating out ",
  Cell[BoxData[
      \(TraditionalForm\`m\_t\)]],
  " gives:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(fI = 
      Integrate[f1 /. \[Phi]Def, {m\_t, \(-\[Infinity]\), \[Infinity]}, 
        Assumptions \[Rule] \[Sigma]uAssumptions]\)], "Input",
  CellLabel->"In[86]:="],

Cell[BoxData[
    \(TraditionalForm\`\[ExponentialE]\^\(-\(\((m\_\(t - 1\) - m\_\(t + 1\) + \
\[CapitalLambda]\_t + \[CapitalLambda]\_\(t + 1\))\)\^2\/\(4\ \
\[Sigma]\_u\%2\)\)\)\/\(2\ \@\[Pi]\ \[Sigma]\_u\)\)], "Output",
  CellLabel->"Out[86]="]
}, Open  ]],

Cell[TextData[{
  "Replacing this in the joint density gives ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(Pr(q\_t | m\_\(\(\\\)\(t\)\), 
          q\_\(\(\\\)\(t\)\))\)\(\[Proportional]\)\)\)]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrUnnor = 
      fI \((\[Product]\+\(s = t + 2\)\%\(Min[t + J, T]\)\[Phi][
              0, \[Sigma]\_u, u\_s])\)\)], "Input",
  CellLabel->"In[87]:="],

Cell[BoxData[
    \(TraditionalForm\`\(\[ExponentialE]\^\(-\(\((m\_\(t - 1\) - m\_\(t + 1\) \
+ \[CapitalLambda]\_t + \[CapitalLambda]\_\(t + 1\))\)\^2\/\(4\ \
\[Sigma]\_u\%2\)\)\)\ \(\[Product]\+\(s = t + 2\)\%\(Min(J + t, T)\)\[Phi](0, \
\[Sigma]\_u, u\_s)\)\)\/\(2\ \@\[Pi]\ \[Sigma]\_u\)\)], "Output",
  CellLabel->"Out[87]="]
}, Open  ]],

Cell[TextData[{
  "We evaluate this for ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t = \(\[PlusMinus]1\)\)]],
  ", normalize and make the draw."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  "(",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " code)"
}], "MathGroup"],

Cell["\<\
The following intermediate calculations are used in the C++ code:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Log[fI] // PowerExpand\)], "Input",
  CellLabel->"In[88]:="],

Cell[BoxData[
    \(TraditionalForm\`\(-\(\((m\_\(t - 1\) - m\_\(t + 1\) + \[CapitalLambda]\
\_t + \[CapitalLambda]\_\(t + 1\))\)\^2\/\(4\ \[Sigma]\_u\%2\)\)\) - 
      log(\[Sigma]\_u) - \(log(\[Pi])\)\/2 - log(2)\)], "Output",
  CellLabel->"Out[88]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Log[\[Phi][0, \[Sigma]\_u, u\_s] /. \[Phi]Def] // 
      PowerExpand\)], "Input",
  CellLabel->"In[89]:="],

Cell[BoxData[
    \(TraditionalForm\`\(-\(u\_s\%2\/\(2\ \[Sigma]\_u\%2\)\)\) - 
      log(\[Sigma]\_u) + 1\/2\ \((\(-\(log(2)\)\) - log(\[Pi]))\)\)], "Output",\

  CellLabel->"Out[89]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(-\((u\_t + u\_\(t + 1\))\)\) /. uDef[t]\) /. uDef[t + 1]\)], "Input",\

  CellLabel->"In[90]:="],

Cell[BoxData[
    \(TraditionalForm\`m\_\(t - 1\) - 
      m\_\(t + 1\) + \[CapitalLambda]\_t + \[CapitalLambda]\_\(t + 1\)\)], \
"Output",
  CellLabel->"Out[90]="]
}, Open  ]],

Cell[TextData[{
  "We evaluate this expression for ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t = \(\[PlusMinus]1\)\)]],
  " (recognizing that the ",
  Cell[BoxData[
      \(TraditionalForm\`u\_s\ for\ t + 2 \[LessEqual] s \[LessEqual] 
        t + P\)]],
  " also depend on ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t\)]],
  "), and normalize. We now turn to the first component in the numerator of \
(",
  
  CounterBox["None"],
  ")."
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Evaluation of ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(f(p\_t | \ m\_\(\(\\\)\(t\)\), \ 
        q)\)\(\ \)\)\)]]
}], "Subsection"],

Cell[TextData[{
  "Consider again from the joint density for ",
  Cell[BoxData[
      \(TraditionalForm\`u\_t,  ... , u\_\(t + P\)\)]],
  " in eq. (",
  
  CounterBox["NumberedEquation", "Prodfu"],
  "). The first two terms are: "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f1 = \(\[Phi][0, \[Sigma]\_u, u\_t] \[Phi][0, \[Sigma]\_u, 
              u\_\(t + 1\)] /. uDef[t]\) /. uDef[t + 1]\)], "Input",
  CellLabel->"In[91]:="],

Cell[BoxData[
    \(TraditionalForm\`\(\[Phi](
        0, \[Sigma]\_u, \(-m\_\(t - 1\)\) + 
          m\_t - \[CapitalLambda]\_t)\)\ \(\[Phi](
        0, \[Sigma]\_u, \(-m\_t\) + 
          m\_\(t + 1\) - \[CapitalLambda]\_\(t + 1\))\)\)], "Output",
  CellLabel->"Out[91]="]
}, Open  ]],

Cell["\<\
Using the definition for the normal density and simplifying gives:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f2 = f1 /. \[Phi]Def // Simplify\)], "Input",
  CellLabel->"In[92]:="],

Cell[BoxData[
    \(TraditionalForm\`\[ExponentialE]\^\(-\(\(\((m\_\(t - 1\) - m\_t + \
\[CapitalLambda]\_t)\)\^2 + \((m\_t - m\_\(t + 1\) + \[CapitalLambda]\_\(t + \
1\))\)\^2\)\/\(2\ \[Sigma]\_u\%2\)\)\)\/\(2\ \[Pi]\ \[Sigma]\_u\%2\)\)], \
"Output",
  CellLabel->"Out[92]="]
}, Open  ]],

Cell[TextData[{
  "This is proportional to ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi](\[Mu]\_t, \[Sigma]\_t, m\_t)\)]],
  " where"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(mParam = 
        GetNormalForm[f2, m\_t, \[Mu]\_t, \[Sigma]\_t] // 
          Simplify;\)\), "\[IndentingNewLine]", 
    \(mParam /. RuleToEquals // TableForm\)}], "Input",
  CellLabel->"In[93]:="],

Cell[BoxData[
    FormBox[
      InterpretationBox[GridBox[{
            {
              TagBox[
                RowBox[{
                  TagBox[\(\[Mu]\_t\),
                    HoldForm], " ", "\<\"=\"\>", " ", 
                  RowBox[{"(", 
                    
                    TagBox[\(1\/2\ \((m\_\(t - 1\) + 
                            m\_\(t + 1\) + \[CapitalLambda]\_t - \
\[CapitalLambda]\_\(t + 1\))\)\),
                      HoldForm], ")"}]}],
                HoldForm]},
            {
              TagBox[
                RowBox[{
                  TagBox[\(\[Sigma]\_t\),
                    HoldForm], " ", "\<\"=\"\>", " ", 
                  TagBox[\(\[Sigma]\_u\/\@2\),
                    HoldForm]}],
                HoldForm]}
            },
          RowSpacings->1,
          ColumnSpacings->3,
          RowAlignments->Baseline,
          ColumnAlignments->{Left}],
        TableForm[ {
          HoldForm[ 
            Times[ 
              HoldForm[ 
                Subscript[ \[Mu], t]], "=", 
              HoldForm[ 
                Times[ 
                  Rational[ 1, 2], 
                  Plus[ 
                    Subscript[ m, 
                      Plus[ -1, t]], 
                    Subscript[ m, 
                      Plus[ 1, t]], 
                    Subscript[ \[CapitalLambda], t], 
                    Times[ -1, 
                      Subscript[ \[CapitalLambda], 
                        Plus[ 1, t]]]]]]]], 
          HoldForm[ 
            Times[ 
              HoldForm[ 
                Subscript[ \[Sigma], t]], "=", 
              HoldForm[ 
                Times[ 
                  Power[ 2, 
                    Rational[ -1, 2]], 
                  Subscript[ \[Sigma], u]]]]]}]], TraditionalForm]], "Output",\

  CellLabel->"Out[94]//TableForm="]
}, Open  ]],

Cell["Thus,", "Text"],

Cell[TextData[{
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(f(m\_t | m\_\(\(\\\)\(t\)\), q\_\(\(\\\)\(t\)\), 
          q\_t)\)\(\[Proportional]\)\)\)]]
}], "NumberedEquation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Phi][\[Mu]\_t, \[Sigma]\_t, 
        m\_t] \((\[Product]\+\(s = t + 2\)\%\(P + t\)\[Phi][0, \[Sigma]\_u, 
            u\_s])\)\)], "Input",
  CellLabel->"In[95]:="],

Cell[BoxData[
    \(TraditionalForm\`\((\[Product]\+\(s = t + 2\)\%\(P + t\)\[Phi](
            0, \[Sigma]\_u, u\_s))\)\ \(\[Phi](\[Mu]\_t, \[Sigma]\_t, 
        m\_t)\)\)], "Output",
  CellLabel->"Out[95]="]
}, Open  ]],

Cell[TextData[{
  "Substituting in for ",
  Cell[BoxData[
      \(TraditionalForm\`m\_t\)]],
  " gives ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(f(p\_t | m\_\(\(\\\)\(t\)\), q\_\(\(\\\)\(t\)\), 
          q\_t)\)\(=\)\)\)]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(% /. m\_t \[Rule] p\_t - c\ q\_t\)], "Input",
  CellLabel->"In[96]:="],

Cell[BoxData[
    \(TraditionalForm\`\((\[Product]\+\(s = t + 2\)\%\(P + t\)\[Phi](
            0, \[Sigma]\_u, u\_s))\)\ \(\[Phi](\[Mu]\_t, \[Sigma]\_t, 
        p\_t - c\ q\_t)\)\)], "Output",
  CellLabel->"Out[96]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Summary", "Subsection"],

Cell[TextData[{
  "To draw ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t | m\_\(\(\\\)\(t\)\), q\_\(\(\\\)\(t\)\), 
      p\_t\)]],
  ", the steps are:"
}], "Text"],

Cell[TextData[{
  "1. Compute the normalized ",
  Cell[BoxData[
      \(TraditionalForm\`Pr(q\_t = \(-1\) | m\_\(\(\\\)\(t\)\), 
        q\_\(\(\\\)\(t\)\))\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`Pr(q\_t = \(+1\) | m\_\(\(\\\)\(t\)\), 
        q\_\(\(\\\)\(t\)\))\)]]
}], "Text"],

Cell[TextData[{
  "2. Compute ",
  Cell[BoxData[
      \(TraditionalForm\`f(p\_t | m\_\(\(\\\)\(t\)\), q\_\(\(\\\)\(t\)\), 
        q\_t = \(-1\))\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`f(p\_t | m\_\(\(\\\)\(t\)\), q\_\(\(\\\)\(t\)\), 
        q\_t = \(+1\))\)]]
}], "Text"],

Cell[TextData[{
  "3. Compute the unnormalized probabilities ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi](\(-1\)) = \(Pr(
            q\_t = \(-1\) | m\_\(\(\\\)\(t\)\), q\_\(\(\\\)\(t\)\))\) \(f(
            p\_t | m\_\(\(\\\)\(t\)\), q\_\(\(\\\)\(t\)\), 
            q\_t = \(-1\))\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi](\(+1\)) = \(Pr(
            q\_t = \(+1\) | m\_\(\(\\\)\(t\)\), q\_\(\(\\\)\(t\)\))\) \(f(
            p\_t | m\_\(\(\\\)\(t\)\), q\_\(\(\\\)\(t\)\), 
            q\_t = \(+1\))\)\)]],
  "."
}], "Text"],

Cell[TextData[{
  "4. The normalized probability of a buy is ",
  Cell[BoxData[
      \(TraditionalForm\`Pr(q\_t = \(+1\) | m\_\(\(\\\)\(t\)\), 
          q\_\(\(\\\)\(t\)\), 
          p\_t) = \(\[Pi](\(+1\))\)\/\(\[Pi](\(+1\)) + \[Pi](\(-1\))\)\)]]
}], "Text"],

Cell["5. Use this probability to make the Bernoulli draw.", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Endpoint modifications", "Subsection"],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`t = 1\)]]], "Subsubsection"],

Cell[TextData[{
  "At ",
  Cell[BoxData[
      \(TraditionalForm\`t = 1\)]],
  ", the relevant joint density is ",
  Cell[BoxData[
      \(TraditionalForm\`\((\[Product]\+\(s = 3\)\%J \[Phi](0, \[Sigma]\_u, 
              u\_s))\)\ \(\[Phi](0, \[Sigma]\_u, u\_2)\)\)], "TextStripped"],
  ". (",
  "The product term is dropped when ",
  Cell[BoxData[
      \(TraditionalForm\`J < 3\)]],
  ".) Consider the ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi](0, \[Sigma]\_u, u\_2)\)]],
  " term. Substituting in for ",
  Cell[BoxData[
      \(TraditionalForm\`u\_2\)]],
  " gives:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f = \[Phi][0, \[Sigma]\_u, u\_2] /. uDef[2]\)], "Input",
  CellLabel->"In[97]:="],

Cell[BoxData[
    \(TraditionalForm\`\[Phi](
      0, \[Sigma]\_u, \(-m\_1\) + m\_2 - \[CapitalLambda]\_2)\)], "Output",
  CellLabel->"Out[97]="]
}, Open  ]],

Cell[TextData[{
  "Integrating over ",
  Cell[BoxData[
      \(TraditionalForm\`m\_1\)]],
  "gives 1. Therefore ",
  Cell[BoxData[
      \(TraditionalForm\`Pr(q\_1 | m\_\\1, 
          q\_\\1) \[Proportional] \[Product]\+\(s = 3\)\%J \[Phi](
            0, \[Sigma]\_u, u\_s)\)]],
  ". Compute the r.h.s for ",
  Cell[BoxData[
      \(TraditionalForm\`q\_1 = \(\[PlusMinus]1\)\)]],
  "and normalize. If ",
  Cell[BoxData[
      \(TraditionalForm\`J < 3\)]],
  ", then ",
  Cell[BoxData[
      \(TraditionalForm\`Pr(q\_1) = 1/2\)]],
  ". "
}], "Text"],

Cell[TextData[{
  "The function above is equivalent to ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi](\[Mu]\_1, \[Sigma]\_1, m\_1)\)]],
  " with"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GetNormalForm[f /. \[Phi]Def, m\_1, \[Mu]\_1, \[Sigma]\_1] /. 
        RuleToEquals // TableForm\)], "Input",
  CellLabel->"In[98]:="],

Cell[BoxData[
    FormBox[
      InterpretationBox[GridBox[{
            {
              TagBox[
                RowBox[{
                  TagBox[\(\[Mu]\_1\),
                    HoldForm], " ", "\<\"=\"\>", " ", 
                  RowBox[{"(", 
                    TagBox[\(m\_2 - \[CapitalLambda]\_2\),
                      HoldForm], ")"}]}],
                HoldForm]},
            {
              TagBox[
                RowBox[{
                  TagBox[\(\[Sigma]\_1\),
                    HoldForm], " ", "\<\"=\"\>", " ", 
                  TagBox[\(\[Sigma]\_u\),
                    HoldForm]}],
                HoldForm]}
            },
          RowSpacings->1,
          ColumnSpacings->3,
          RowAlignments->Baseline,
          ColumnAlignments->{Left}],
        TableForm[ {
          HoldForm[ 
            Times[ 
              HoldForm[ 
                Subscript[ \[Mu], 1]], "=", 
              HoldForm[ 
                Plus[ 
                  Subscript[ m, 2], 
                  Times[ -1, 
                    Subscript[ \[CapitalLambda], 2]]]]]], 
          HoldForm[ 
            Times[ 
              HoldForm[ 
                Subscript[ \[Sigma], 1]], "=", 
              HoldForm[ 
                Subscript[ \[Sigma], u]]]]}]], TraditionalForm]], "Output",
  CellLabel->"Out[98]//TableForm="]
}, Open  ]],

Cell[TextData[{
  "Therefore ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(f(m\_1 | m\_\\1, q\_\\1, q\_1)\)\(=\)\)\)]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Phi][\[Mu]\_1, \[Sigma]\_1, 
        m\_1] \((\[Product]\+\(s = 3\)\%P \[Phi][0, \[Sigma]\_u, 
            u\_s])\)\)], "Input",
  CellLabel->"In[99]:="],

Cell[BoxData[
    \(TraditionalForm\`\((\[Product]\+\(s = 3\)\%P \[Phi](0, \[Sigma]\_u, 
            u\_s))\)\ \(\[Phi](\[Mu]\_1, \[Sigma]\_1, m\_1)\)\)], "Output",
  CellLabel->"Out[99]="]
}, Open  ]],

Cell[TextData[{
  "Or, ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(f(p\_1 | m\_\\1, q\_\\1, q\_1)\)\(=\)\)\)]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(% /. m\_1 \[Rule] p\_1 - c\ q\_1\)], "Input",
  CellLabel->"In[100]:="],

Cell[BoxData[
    \(TraditionalForm\`\((\[Product]\+\(s = 3\)\%P \[Phi](0, \[Sigma]\_u, 
            u\_s))\)\ \(\[Phi](\[Mu]\_1, \[Sigma]\_1, 
        p\_1 - c\ q\_1)\)\)], "Output",
  CellLabel->"Out[100]="]
}, Open  ]],

Cell[TextData[{
  "Since ",
  Cell[BoxData[
      \(TraditionalForm\`Pr(q\_1 | m\_\\1, q\_\\1, 
          p\_1) \[Proportional] \(f(p\_1 | m\_\\1, q)\) \(Pr(q\_1 | m\_\\1, 
            q\_\\1)\)\)]],
  ", we may compute the r.h.s., normalize and make the draw."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`t = T\)]]], "Subsubsection"],

Cell[TextData[{
  "For ",
  Cell[BoxData[
      \(TraditionalForm\`t = T\)]],
  ", the relevant joint density is ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi](0, \[Sigma]\_u, u\_T)\)], "TextStripped"],
  ". Substituting for ",
  Cell[BoxData[
      \(TraditionalForm\`u\_T\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f = \[Phi][0, \[Sigma]\_u, u\_T] /. uDef[T]\)], "Input",
  CellLabel->"In[101]:="],

Cell[BoxData[
    \(TraditionalForm\`\[Phi](
      0, \[Sigma]\_u, \(-m\_\(T - 1\)\) + 
        m\_T - \[CapitalLambda]\_T)\)], "Output",
  CellLabel->"Out[101]="]
}, Open  ]],

Cell[TextData[{
  "Integrating out ",
  Cell[BoxData[
      \(TraditionalForm\`m\_T\)]],
  " gives 1, so ",
  Cell[BoxData[
      \(TraditionalForm\`Pr(q\_T | m\_\(\(\\\)\(T\)\), q\_\(\(\\\)\(T\)\)) = 
        1/2\)]],
  ". From the above expression, ",
  Cell[BoxData[
      \(TraditionalForm\`f(m\_T | m\_\(\(\\\)\(T\)\), q\_\(\(\\\)\(T\)\), 
          q\_T) = \[Phi](\[Mu]\_T, \[Sigma]\_T, m\_T)\)]],
  " with"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GetNormalForm[f /. \[Phi]Def, m\_T, \[Mu]\_T, \[Sigma]\_T] /. 
        RuleToEquals // TableForm\)], "Input",
  CellLabel->"In[102]:="],

Cell[BoxData[
    FormBox[
      InterpretationBox[GridBox[{
            {
              TagBox[
                RowBox[{
                  TagBox[\(\[Mu]\_T\),
                    HoldForm], " ", "\<\"=\"\>", " ", 
                  RowBox[{"(", 
                    TagBox[\(m\_\(T - 1\) + \[CapitalLambda]\_T\),
                      HoldForm], ")"}]}],
                HoldForm]},
            {
              TagBox[
                RowBox[{
                  TagBox[\(\[Sigma]\_T\),
                    HoldForm], " ", "\<\"=\"\>", " ", 
                  TagBox[\(\[Sigma]\_u\),
                    HoldForm]}],
                HoldForm]}
            },
          RowSpacings->1,
          ColumnSpacings->3,
          RowAlignments->Baseline,
          ColumnAlignments->{Left}],
        TableForm[ {
          HoldForm[ 
            Times[ 
              HoldForm[ 
                Subscript[ \[Mu], T]], "=", 
              HoldForm[ 
                Plus[ 
                  Subscript[ m, 
                    Plus[ -1, T]], 
                  Subscript[ \[CapitalLambda], T]]]]], 
          HoldForm[ 
            Times[ 
              HoldForm[ 
                Subscript[ \[Sigma], T]], "=", 
              HoldForm[ 
                Subscript[ \[Sigma], u]]]]}]], TraditionalForm]], "Output",
  CellLabel->"Out[102]//TableForm="]
}, Open  ]],

Cell[TextData[{
  "Therefore ",
  Cell[BoxData[
      \(TraditionalForm\`f(p\_T | m\_\(\(\\\)\(T\)\), q\_\(\(\\\)\(T\)\), 
          q\_T) = \[Phi](\[Mu]\_T, \[Sigma]\_T, 
          p\_T - c\[VeryThinSpace]q\_T)\)]],
  "."
}], "Text"],

Cell[TextData[{
  "Using these results, compute ",
  Cell[BoxData[
      \(TraditionalForm\`f(p\_T | m\_\(\(\\\)\(T\)\), q\_\(\(\\\)\(T\)\), 
        q\_T)\)]],
  " at ",
  Cell[BoxData[
      \(TraditionalForm\`q\_T = \(\[PlusMinus]1\)\)]],
  " and normalize. (This is the ",
  "first",
  " normalization.) Make the draw for ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(q\_T\)\(.\)\)\)]]
}], "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Combined model I: Trade dependencies, discreteness and clustering\
\>", "Section"],

Cell[CellGroupData[{

Cell["Model description", "Subsection"],

Cell["\<\
This model combines the features considered separately in earlier sections. \
The efficient price evolution reflects a contemporaneous trade impact:\
\>", "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`m\_t = 
      m\_\(t - 1\) + \(q\_t\) \[Lambda]\[VeryThinSpace]V\_t + 
        u\_t\)]]], "NumberedEquation",
  CellTags->"mCombinedModelI"],

Cell["\<\
The mapping to observed prices follows the discreteness/clustering model. The \
bid and ask quotes are:\
\>", "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`B\_t = Floor(M\_t - C, K\_t)\)]],
  "\n\t",
  Cell[BoxData[
      \(TraditionalForm\`A\_t = Ceiling(M\_t + C, K\_t)\)]]
}], "Text"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`M\_t = e\^m\_t\)]],
  "; ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  " is the half-spread; the rounding functions here round down or up to the \
nearest ",
  Cell[BoxData[
      \(TraditionalForm\`K\)]],
  "-multiple of the \"official\" tick size. The clustering multiple is ",
  Cell[BoxData[
      \(TraditionalForm\`K\_t\)]],
  " , an i.i.d. Bernoulli variate:"
}], "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`\(\(K\_t\)\(=\)\)\)]],
  Cell[BoxData[
      FormBox[
        RowBox[{"{", GridBox[{
              {\(1, \ with\ probability\ \((1 - k)\)\)},
              {\(\[Kappa], \ \(\(with\)\(\ \)\(probability\)\(\ \)\(k\)\(\ \ \
\ \ \ \ \ \ \ \ \ \)\)\)}
              }]}], TraditionalForm]]]
}], "Text"],

Cell[TextData[{
  "\[Kappa] is a \"natural multiple\" of the basic tick size, like 2, 5 or \
10. ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " is the clustering probability.\nThe buy/sell indicator is"
}], "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      FormBox[
        RowBox[{\(q\_t\), "=", 
          RowBox[{"{", GridBox[{
                {\(\(+1\), \ a\ buy, \ with\ probability\ 1\/2\)},
                {\(\(-1\), \ a\ sell, \ with\ probability\ 1\/2\)}
                }]}]}], TraditionalForm]]],
  "\nThe obseved transaction price is"
}], "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      FormBox[
        RowBox[{\(P\_t\), "=", 
          RowBox[{"{", GridBox[{
                {\(\(A\_t\) if\ q\_t = \(+1\)\)},
                {\(\(B\_t\) if\ q\_t = \(-1\)\)}
                }]}]}], TraditionalForm]]]
}], "Text"],

Cell[TextData[{
  "The parameter draws are minor modifications of those given above. That is, \
",
  Cell[BoxData[
      \(TraditionalForm\`{\[Lambda], \[Sigma]\_u}\)]],
  " are modeled in the regression:"
}], "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`\[CapitalDelta]\[VeryThinSpace]m\_t = \[Lambda]\
\[VeryThinSpace]q\_t + u\_t\)]]], "NumberedEquation"],

Cell[TextData[{
  "The clustering parameter ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " is modeled in the beta/binomial framework. ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  " is drawn using the Metropolis-Hastings algorithm described in section ",
  
  CounterBox["Section", "Discrete Prices"],
  "."
}], "Text"],

Cell[TextData[{
  "In the latent data draw, at each time ",
  "t",
  ", we need to draw ",
  Cell[BoxData[
      \(TraditionalForm\`m\_t, q\_t, K\_t | m\_\(\(\\\)\(t\)\), 
      q\_\(\(\\\)\(t\)\), P\_t\)]],
  ". The draw is made in two steps:"
}], "Text"],

Cell[TextData[{
  "1. Draw ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t, K\_t | m\_\(\(\\\)\(t\)\), q\_\(\(\\\)\(t\)\), 
      P\_t\)]],
  "."
}], "Text"],

Cell[TextData[{
  "2. Draw ",
  Cell[BoxData[
      \(TraditionalForm\`m\_t | m\_\(\(\\\)\(t\)\), q, K\_t, P\_t\)]],
  "."
}], "Text"],

Cell[TextData[{
  "Given the structure of the model, ",
  Cell[BoxData[
      \(TraditionalForm\`Pr(q\_t, K\_t | m\_\(\(\\\)\(t\)\), 
          q\_\(\(\\\)\(t\)\), K\_\(\(\\\)\(t\)\), P) = 
        Pr(q\_t, K\_t | m\_\(t - 1\), m\_\(t + 1\), q\_\(t + 1\), P\_t)\)]],
  ". Analogous to eq. (",
  
  CounterBox["NumberedEquation", "ClusterBayes"],
  "),"
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{\(Pr(q\_t, K\_t | m\_\(t - 1\), m\_\(t + 1\), q\_\(t + 1\), 
          P\_t)\), "\[IndentingNewLine]", "\[IndentingNewLine]", "=", 
        RowBox[{
          
          StyleBox[\(\(\(Pr(P\_t | m\_\(t - 1\), m\_\(t + 1\), q\_\(t + 1\), 
                    q\_t, K\_t)\)\ \[Times]\(Pr(q\_t, K\_t | m\_\(t - 1\), 
                    m\_\(t + 1\), \ q\_\(t + 1\))\)\)\/\(Pr(
                  P\_t | m\_\(t - 1\), m\_\(t + 1\), q\_\(t + 1\))\)\),
            ScriptLevel->0], "\[IndentingNewLine]", "\[IndentingNewLine]", 
          "\[Proportional]", \(\(Pr(P\_t | m\_\(t - 1\), m\_\(t + 1\), 
              q\_\(t + 1\), q\_t, K\_t)\)\ \[Times]\(Pr(q\_t | m\_\(t - 1\), 
              m\_\(t + 1\), \ q\_\(t + 1\))\)\[Times]\(Pr(K\_t)\)\)}]}], 
      TraditionalForm]]]], "NumberedEquation",
  CellTags->"AsyInfoClusterBayes"],

Cell[TextData[{
  "The denominator is subsumed into the proportionality constant; ",
  Cell[BoxData[
      \(TraditionalForm\`K\_t\)]],
  " is independent of the other variables. The first two terms must be \
evaluated separately."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`Pr(q\_t | m\_\(t - 1\), m\_\(t + 1\), 
      q\_\(t + 1\))\)]]], "Subsection"],

Cell[TextData[{
  "This development is identical to the one given for the asymmetric \
information model above. The joint distribution of ",
  Cell[BoxData[
      \(TraditionalForm\`u\_t\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\(t + 1\)\)]],
  "is ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[Phi](0, \[Sigma]\_u, u\_t)\)\ \(\[Phi](
          0, \[Sigma]\_u, u\_\(t + 1\))\)\)], "Caption"],
  ". Substituting from (",
  
  CounterBox["NumberedEquation", "mCombinedModelI"],
  ") gives: "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TD = \[Phi][0, \[Sigma]\_u, u\_t] \[Phi][0, \[Sigma]\_u, u\_\(t + 1\)] /. 
        u\_t_ \[Rule] 
          m\_t - \((m\_\(t - 1\) + q\_t\ \[Lambda]\ V\_t)\)\)], "Input",
  CellLabel->"In[103]:="],

Cell[BoxData[
    \(TraditionalForm\`\(\[Phi](
        0, \[Sigma]\_u, \(-m\_\(t - 1\)\) + 
          m\_t - \[Lambda]\ q\_t\ V\_t)\)\ \(\[Phi](
        0, \[Sigma]\_u, \(-m\_t\) + 
          m\_\(t + 1\) - \[Lambda]\ q\_\(t + 1\)\ V\_\(t + 1\))\)\)], "Output",\

  CellLabel->"Out[103]="]
}, Open  ]],

Cell[TextData[{
  "Integrating out ",
  Cell[BoxData[
      \(TraditionalForm\`m\_t\)]],
  " gives: "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(fI = 
      Integrate[TD /. \[Phi]Def, {m\_t, \(-\[Infinity]\), \(+\[Infinity]\)}, 
        Assumptions \[Rule] \[Sigma]uAssumptions]\)], "Input",
  CellLabel->"In[104]:="],

Cell[BoxData[
    \(TraditionalForm\`\[ExponentialE]\^\(-\(\((m\_\(t - 1\) - m\_\(t + 1\) + \
\[Lambda]\ q\_t\ V\_t + \[Lambda]\ q\_\(t + 1\)\ V\_\(t + 1\))\)\^2\/\(4\ \
\[Sigma]\_u\%2\)\)\)\/\(2\ \@\[Pi]\ \[Sigma]\_u\)\)], "Output",
  CellLabel->"Out[104]="]
}, Open  ]],

Cell[TextData[{
  "Evaluating this at ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t = \(+1\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t = \(-1\)\)]],
  " and normalizing gives ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(Pr(q\_t = \(+1\) | m\_\(t - 1\), m\_\(t + 1\), 
          q\_\(t + 1\))\)\(=\)\)\)]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrBuy = \((fI /. q\_t \[Rule] \(+1\))\)\/\(\((fI /. q\_t \[Rule] \
\(+1\))\) + \((fI /. q\_t \[Rule] \(-1\))\)\) // Simplify\)], "Input",
  CellLabel->"In[105]:="],

Cell[BoxData[
    \(TraditionalForm\`\[ExponentialE]\^\(\(\[Lambda]\ m\_\(t + 1\)\ V\_t\)\/\
\[Sigma]\_u\%2\)\/\(\[ExponentialE]\^\(\(\[Lambda]\ m\_\(t + 1\)\ V\_t\)\/\
\[Sigma]\_u\%2\) + \[ExponentialE]\^\(\(\[Lambda]\ V\_t\ \((m\_\(t - 1\) + \
\[Lambda]\ q\_\(t + 1\)\ V\_\(t + 1\))\)\)\/\[Sigma]\_u\%2\)\)\)], "Output",
  CellLabel->"Out[105]="]
}, Open  ]],

Cell[TextData[{
  "We combine this with the fact that ",
  Cell[BoxData[
      \(TraditionalForm\`Pr(K\_t = \[Kappa]) = k\)]],
  " to obtain the full set of ",
  Cell[BoxData[
      \(TraditionalForm\`Pr(q\_t, K\_t | m\_\(t - 1\), m\_\(t + 1\), 
        q\_\(t + 1\))\)]],
  " for ",
  Cell[BoxData[
      \(TraditionalForm\`\((q\_t, 
          K\_t)\) \[Element] {\(-1\), \(+1\)}\[Times]{1, \[Kappa]}\)]],
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`Pr(P\_t | m\_\(t - 1\), m\_\(t + 1\), q\_\(t + 1\), 
      q\_t, K\_t)\)]]], "Subsection"],

Cell[TextData[{
  "This is obtained by integrating ",
  Cell[BoxData[
      \(TraditionalForm\`f(m\_t | q\_t, K\_t, m\_\(t - 1\), m\_\(t + 1\), 
        q\_\(t + 1\))\)]],
  " over the range implied by ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`K\_t\)]],
  ":"
}], "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`Pr(P\_t | m\_\(t - 1\), m\_\(t + 1\), q\_\(t + 1\), 
        q\_t, K\_t) = \ \[Integral]\_\(m\+_\)\%\(m\&_\)\(f(m\_t | q\_t, K\_t, 
            m\_\(t - 1\), m\_\(t + 1\), 
            q\_\(t + 1\))\) \[DifferentialD]m\_t\)]]], "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`m\+_ = \(m\+_\)(q\_t, K\_t)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`m\&_ = \(m\&_\)(q\_t, K\_t)\)]],
  " are the bounding functions derived for the clustering model. The \
integrand is:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TD\)], "Input",
  CellLabel->"In[106]:="],

Cell[BoxData[
    \(TraditionalForm\`\(\[Phi](
        0, \[Sigma]\_u, \(-m\_\(t - 1\)\) + 
          m\_t - \[Lambda]\ q\_t\ V\_t)\)\ \(\[Phi](
        0, \[Sigma]\_u, \(-m\_t\) + 
          m\_\(t + 1\) - \[Lambda]\ q\_\(t + 1\)\ V\_\(t + 1\))\)\)], "Output",\

  CellLabel->"Out[106]="]
}, Open  ]],

Cell[TextData[{
  "This can be reworked as the normal density ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi](\[Mu]\_m, \[Sigma]\_m, m\_t)\)]],
  " where the parameters are:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GetNormalForm[TD /. \[Phi]Def, m\_t, \[Mu]\_m, \[Sigma]\_m] /. 
        RuleToEquals // TableForm\)], "Input",
  CellLabel->"In[107]:="],

Cell[BoxData[
    FormBox[
      InterpretationBox[GridBox[{
            {
              TagBox[
                RowBox[{
                  TagBox[\(\[Mu]\_m\),
                    HoldForm], " ", "\<\"=\"\>", " ", 
                  RowBox[{"(", 
                    
                    TagBox[\(1\/2\ \((m\_\(t - 1\) + 
                            m\_\(t + 1\) + \[Lambda]\ q\_t\ V\_t - \[Lambda]\ \
q\_\(t + 1\)\ V\_\(t + 1\))\)\),
                      HoldForm], ")"}]}],
                HoldForm]},
            {
              TagBox[
                RowBox[{
                  TagBox[\(\[Sigma]\_m\),
                    HoldForm], " ", "\<\"=\"\>", " ", 
                  TagBox[\(\[Sigma]\_u\/\@2\),
                    HoldForm]}],
                HoldForm]}
            },
          RowSpacings->1,
          ColumnSpacings->3,
          RowAlignments->Baseline,
          ColumnAlignments->{Left}],
        TableForm[ {
          HoldForm[ 
            Times[ 
              HoldForm[ 
                Subscript[ \[Mu], m]], "=", 
              HoldForm[ 
                Times[ 
                  Rational[ 1, 2], 
                  Plus[ 
                    Subscript[ m, 
                      Plus[ -1, t]], 
                    Subscript[ m, 
                      Plus[ 1, t]], 
                    Times[ \[Lambda], 
                      Subscript[ q, t], 
                      Subscript[ V, t]], 
                    Times[ -1, \[Lambda], 
                      Subscript[ q, 
                        Plus[ 1, t]], 
                      Subscript[ V, 
                        Plus[ 1, t]]]]]]]], 
          HoldForm[ 
            Times[ 
              HoldForm[ 
                Subscript[ \[Sigma], m]], "=", 
              HoldForm[ 
                Times[ 
                  Power[ 2, 
                    Rational[ -1, 2]], 
                  Subscript[ \[Sigma], u]]]]]}]], TraditionalForm]], "Output",
  CellLabel->"Out[107]//TableForm="]
}, Open  ]],

Cell[TextData[{
  "We now use the result from eq. (",
  
  CounterBox["NumberedEquation", "AsyInfoClusterBayes"],
  ") that"
}], "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`Pr(q\_t, K\_t | m\_\(t - 1\), m\_\(t + 1\), 
        q\_\(t + 1\), 
        P\_t) \[Proportional] \(Pr(P\_t | m\_\(t - 1\), m\_\(t + 1\), 
          q\_\(t + 1\), q\_t, K\_t)\)\ \[Times]\(Pr(q\_t | m\_\(t - 1\), 
          m\_\(t + 1\), \ q\_\(t + 1\))\)\[Times]\(Pr(
          K\_t)\)\)]]], "NumberedEquation"],

Cell[TextData[{
  "We compute the r.h.s. for all values of ",
  Cell[BoxData[
      \(TraditionalForm\`{q\_t, K\_t}\)]],
  ", normalize and make the draw."
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Combined model II: Lagged trade dependencies, discreteness and clustering\
\>", "Section"],

Cell["\<\
This is the richest model estimated in the paper, involving all of the \
features considered to this point. The model is closest to the one considered \
in the last section. In this version, the efficient price evolution reflects \
lagged trade impacts:\
\>", "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`m\_t = 
      m\_\(t - 1\) + \[CapitalLambda]\_t + u\_t\)]]], "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalLambda]\_t\)]],
  " is the impact term:"
}], "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalLambda]\_t = \[Sum]\+\(j = 0\)\%\(Min(J, t \
- 1)\)\(q\_\(t - j\)\) \(\[Lambda]\_j\) V\_\(t - j\)\)]]
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`J\)]],
  " is the order of the lagged dependence. The mapping to observed prices is \
the same as in the previous section."
}], "Text"],

Cell["\<\
The draw strategies are minor modifications of those encountered earlier.\
\>", "Text"],

Cell[TextData[{
  "For the parameter draws, ",
  Cell[BoxData[
      \(TraditionalForm\`{\[Lambda]\_j, \[Sigma]\_u}\)]],
  " are modeled in the regression:"
}], "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`\[CapitalDelta]\[VeryThinSpace]m\_t = \[Sum]\+\(j = \
0\)\%\(Min(J, t - 1)\)\(\(\(\[Lambda]\)\(\[VeryThinSpace]\)\)\_j\) \(q\_\(t - 
                  j\)\) V\_\(t - j\) + u\_t\)]]], "NumberedEquation",
  CellTags->"mCombinedModelII"],

Cell[TextData[{
  "In discussing the corresponding regression for the lagged trade impact \
model without discreteness or clustering (cf. Section ",
  
  CounterBox["Section", "LaggedTradeDependencies"],
  "), the potential for multicollinearity was noted. This arose from the \
presence (in eq. (",
  
  CounterBox["NumberedEquation", "LaggedTradeDepRegression"],
  ")) of a c\[VeryThinSpace]",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\[VeryThinSpace]q\_t\)]],
  " term. This term is absent in eq. (",
  
  CounterBox["NumberedEquation", "mCombinedModelII"],
  "). This alleviates the problem of multicollinearity in the regression. The \
problem persists in the broader model, however, if the tick size is small \
relative to the price changes."
}], "Text"],

Cell[TextData[{
  "The clustering parameter ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " is modeled in the beta/binomial framework. ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  " is drawn using the Metropolis-Hastings algorithm."
}], "Text"],

Cell[TextData[{
  "In the latent data draw, at each time ",
  "t",
  ", we need to draw ",
  Cell[BoxData[
      \(TraditionalForm\`m\_t, q\_t, K\_t | m\_\(\(\\\)\(t\)\), 
      q\_\(\(\\\)\(t\)\), P\_t\)]],
  ". The draw is made in two steps:"
}], "Text"],

Cell[TextData[{
  "1. Draw ",
  Cell[BoxData[
      \(TraditionalForm\`q\_t, K\_t | m\_\(\(\\\)\(t\)\), q\_\(\(\\\)\(t\)\), 
      P\_t\)]],
  "."
}], "Text"],

Cell[TextData[{
  "2. Draw ",
  Cell[BoxData[
      \(TraditionalForm\`m\_t | m\_\(\(\\\)\(t\)\), q, K\_t, P\_t\)]],
  "."
}], "Text"],

Cell["To derive the probabilities for the first draw, note: ", "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{\(Pr(q\_t, K\_t | m\_\(\(\\\)\(t\)\), q\_\(\(\\\)\(t\)\), 
          P\_t)\), "\[IndentingNewLine]", "\[IndentingNewLine]", "=", 
        RowBox[{
          
          StyleBox[\(\(\(Pr(P\_t | m\_\(\(\\\)\(t\)\), q\_\(\(\\\)\(t\)\), 
                    q\_t, K\_t)\)\ \[Times]\(Pr(q\_t, 
                    K\_t | m\_\(\(\\\)\(t\)\), \ 
                    q\_\(\(\\\)\(t\)\))\)\)\/\(Pr(P\_t | m\_\(\(\\\)\(t\)\), 
                  q\_\(\(\\\)\(t\)\))\)\),
            ScriptLevel->0], "\[IndentingNewLine]", "\[IndentingNewLine]", 
          "\[Proportional]", \(\(Pr(P\_t | m\_\(\(\\\)\(t\)\), 
              q\_\(\(\\\)\(t\)\), q\_t, K\_t)\)\ \[Times]\(Pr(
              q\_t | m\_\(\(\\\)\(t\)\), q\_\(\(\\\)\(t\)\))\)\[Times]\(Pr(
              K\_t)\)\)}]}], TraditionalForm]]]], "NumberedEquation"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`Pr(q\_t | m\_\(\(\\\)\(t\)\), 
        q\_\(\(\\\)\(t\)\))\)]],
  " is the same as in the lagged trade impact model (see section ",
  
  CounterBox["Section", "LaggedTradeDependencies"],
  "), since the results of this analysis do not involve the clustering or \
discreteness effects."
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`\(\(Pr(P\_t | m\_\(\(\\\)\(t\)\), 
        q\_\(\(\\\)\(t\)\), q\_t, K\_t)\)\(\ \)\)\)]],
  "is computed as:"
}], "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`Pr(P\_t | m\_\(\(\\\)\(t\)\), q\_\(\(\\\)\(t\)\), 
          q\_t, K\_t) = \[Integral]\_\(m\+_\)\%\(m\&_\)\(f(
              m\_t | m\_\(\(\\\)\(t\)\), q\_\(\(\\\)\(t\)\), 
              q\_t)\) \[DifferentialD]m\_t\)]]
}], "Text"],

Cell[TextData[{
  "where the limits of the integral are the clustering limits discussed in \
section ",
  
  CounterBox["Section", "ClusterBayes"],
  ". The integrand is the ",
  Cell[BoxData[
      \(TraditionalForm\`m\_t\)]],
  " density for the lagged trade impact model."
}], "Text"],

Cell[TextData[{
  "To summarize, compute the r.h.s. of eq. (",
  
  CounterBox["NumberedEquation"],
  ") for the four possible values of ",
  Cell[BoxData[
      \(TraditionalForm\`{q\_t, K\_t}\)]],
  ". Normalize and make the draw. Finally, draw ",
  Cell[BoxData[
      \(TraditionalForm\`m\_t\)]],
  " from ",
  Cell[BoxData[
      \(TraditionalForm\`f(m\_t | m\_\(\(\\\)\(t\)\), q\_\(\(\\\)\(t\)\), 
        q\_t)\)]],
  " restricted to the range ",
  Cell[BoxData[
      \(TraditionalForm\`\((m\+_, m\&_)\)\)]],
  " implied by the (just-drawn) ",
  Cell[BoxData[
      \(TraditionalForm\`{q\_t, K\_t}\)]],
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["References", "Section"],

Cell["\<\
Carlin, B.P., and T.A. Louis, 1996. Bayes and Empirical Bayes Methods for \
Data Analysis.  (London: Chapman and Hall).
Casella, G., George, E. I., 1992. Explaining the Gibbs sampler. The American \
Statistician 46, 167-190.
Chib, S., Greenberg, E., 1995. Understanding the Metropolis-Hastings \
algorithm. The American Statistician 49, 327-335.
Chib, S., Greenberg, E., 1996. Markov chain Monte Carlo simulation methods in \
econometrics. Econometric Theory 12, 409-431.
Gamerman, D., 1997. Markov Chain Monte Carlo. Chapman and Hall, New York.
Kim, C.-J., Nelson, C. R., 2000. State-space models with regime switching. \
MIT Press, Cambridge, Massachusetts.
Tanner, M.A., 1996. Tools for Statistical Inference.  Third ed., (New York: \
Springer-Verlag).\
\>", "Text"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
AutoGeneratedPackage->None,
ScreenStyleEnvironment->"Working",
PrintingStyleEnvironment->"PrintClean",
WindowToolbars->"EditBar",
WindowSize->{1014, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Visible->True,
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{None, Inherited, Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"]}, {None, Inherited, Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"]}},
PrintingOptions->{"PrintingMargins"->{{54, 54}, {72, 72}},
"PrintCellBrackets"->False,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False,
"FirstPageHeader"->False,
"FacingPages"->True},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->True,
InputAliases->{"notation"->RowBox[ {"Notation", "[", 
        RowBox[ {
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"], " ", "\[DoubleLongLeftRightArrow]", " ",
           
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"]}], "]"}], 
    "notation>"->RowBox[ {"Notation", "[", 
        RowBox[ {
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"], " ", "\[DoubleLongRightArrow]", " ", 
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"]}], "]"}], 
    "notation<"->RowBox[ {"Notation", "[", 
        RowBox[ {
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"], " ", "\[DoubleLongLeftArrow]", " ", 
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"]}], "]"}], 
    "symb"->RowBox[ {"Symbolize", "[", 
        TagBox[ 
        "\[Placeholder]", NotationBoxTag, TagStyle -> 
          "NotationTemplateStyle"], "]"}], 
    "infixnotation"->RowBox[ {"InfixNotation", "[", 
        RowBox[ {
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"], ",", "\[Placeholder]"}], "]"}], 
    "addia"->RowBox[ {"AddInputAlias", "[", 
        RowBox[ {
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"], ",", "\[Placeholder]"}], "]"}], 
    "pattwraper"->TagBox[ 
      "\[Placeholder]", NotationPatternTag, TagStyle -> 
        "NotationPatternWrapperStyle"], 
    "madeboxeswraper"->TagBox[ 
      "\[Placeholder]", NotationMadeBoxesTag, TagStyle -> 
        "NotationMadeBoxesWrapperStyle"]},
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
Magnification->1.25,
StyleDefinitions -> "AppendixStyle01.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "cRegression"->{
    Cell[20336, 699, 233, 7, 48, "NumberedEquation",
      CellTags->"cRegression"]},
  "RollBayes0"->{
    Cell[25762, 881, 277, 6, 66, "NumberedEquation",
      CellTags->"RollBayes0"]},
  "qCondp"->{
    Cell[26806, 915, 291, 7, 52, "NumberedEquation",
      CellTags->"qCondp"]},
  "RollBayes"->{
    Cell[31358, 1064, 429, 8, 67, "NumberedEquation",
      CellTags->"RollBayes"]},
  "RollDensity"->{
    Cell[33482, 1129, 196, 4, 46, "NumberedEquation",
      CellTags->"RollDensity"]},
  "Rollfm"->{
    Cell[35624, 1204, 274, 6, 46, "NumberedEquation",
      CellTags->"Rollfm"]},
  "InformativeTradeModel"->{
    Cell[43174, 1462, 186, 4, 46, "NumberedEquation",
      CellTags->"InformativeTradeModel"]},
  "BayesContemporaneousImpact"->{
    Cell[46466, 1574, 509, 9, 67, "NumberedEquation",
      CellTags->"BayesContemporaneousImpact"]},
  "Discrete Prices"->{
    Cell[65706, 2250, 65, 1, 78, "Section",
      CellTags->"Discrete Prices"]},
  "DiscretenessPr"->{
    Cell[71185, 2435, 267, 4, 53, "NumberedEquation",
      CellTags->"DiscretenessPr"]},
  "MLimits"->{
    Cell[74120, 2555, 909, 27, 96, "NumberedEquation",
      CellTags->"MLimits"]},
  "SimulatedCRegression"->{
    Cell[94394, 3304, 276, 7, 48, "NumberedEquation",
      CellTags->"SimulatedCRegression"]},
  "Clustered prices"->{
    Cell[105713, 3671, 67, 1, 78, "Section",
      CellTags->"Clustered prices"]},
  "ClusterBayes"->{
    Cell[110021, 3838, 1024, 19, 134, "NumberedEquation",
      CellTags->"ClusterBayes"]},
  "LaggedTradeDependencies"->{
    Cell[121343, 4278, 83, 1, 78, "Section",
      CellTags->"LaggedTradeDependencies"]},
  "LaggedTradeDepRegression"->{
    Cell[122756, 4331, 584, 9, 52, "NumberedEquation",
      CellTags->"LaggedTradeDepRegression"]},
  "LaggedInformativeModelBayes"->{
    Cell[125979, 4432, 498, 9, 67, "NumberedEquation",
      CellTags->"LaggedInformativeModelBayes"]},
  "LaggedTradeImpact1"->{
    Cell[126943, 4458, 193, 6, 66, "Subsection",
      CellTags->"LaggedTradeImpact1"]},
  "Prodfu"->{
    Cell[127545, 4480, 351, 6, 51, "NumberedEquation",
      CellTags->"Prodfu"]},
  "mCombinedModelI"->{
    Cell[146997, 5191, 191, 4, 46, "NumberedEquation",
      CellTags->"mCombinedModelI"]},
  "AsyInfoClusterBayes"->{
    Cell[150831, 5334, 883, 15, 155, "NumberedEquation",
      CellTags->"AsyInfoClusterBayes"]},
  "mCombinedModelII"->{
    Cell[161028, 5669, 285, 4, 52, "NumberedEquation",
      CellTags->"mCombinedModelII"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"cRegression", 169820, 5919},
  {"RollBayes0", 169924, 5922},
  {"qCondp", 170023, 5925},
  {"RollBayes", 170121, 5928},
  {"RollDensity", 170225, 5931},
  {"Rollfm", 170326, 5934},
  {"InformativeTradeModel", 170437, 5937},
  {"BayesContemporaneousImpact", 170568, 5940},
  {"Discrete Prices", 170693, 5943},
  {"DiscretenessPr", 170796, 5946},
  {"MLimits", 170901, 5949},
  {"SimulatedCRegression", 171013, 5952},
  {"Clustered prices", 171133, 5955},
  {"ClusterBayes", 171236, 5958},
  {"LaggedTradeDependencies", 171359, 5961},
  {"LaggedTradeDepRegression", 171481, 5964},
  {"LaggedInformativeModelBayes", 171617, 5967},
  {"LaggedTradeImpact1", 171747, 5970},
  {"Prodfu", 171850, 5973},
  {"mCombinedModelI", 171956, 5976},
  {"AsyInfoClusterBayes", 172075, 5979},
  {"mCombinedModelII", 172197, 5982}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 114, 3, 29, "Subtitle"],
Cell[1856, 56, 139, 3, 46, "Subtitle"],
Cell[1998, 61, 52, 3, 46, "Subtitle"],

Cell[CellGroupData[{
Cell[2075, 68, 31, 0, 61, "Section"],
Cell[2109, 70, 496, 8, 75, "Text"],
Cell[2608, 80, 337, 6, 75, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2982, 91, 228, 8, 62, "Section",
  CounterIncrements->"None"],
Cell[3213, 101, 44, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[3282, 105, 50, 0, 49, "Subsection"],
Cell[3335, 107, 33, 0, 33, "Text"],
Cell[3371, 109, 175, 3, 76, "InputOnly"],
Cell[3549, 114, 43, 0, 33, "Text"],
Cell[3595, 116, 148, 3, 76, "InputOnly"],
Cell[3746, 121, 217, 5, 33, "Text"],

Cell[CellGroupData[{
Cell[3988, 130, 320, 7, 95, "Input"],
Cell[4311, 139, 974, 33, 88, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[5334, 178, 63, 0, 49, "Subsection"],
Cell[5400, 180, 333, 9, 54, "Text"],
Cell[5736, 191, 165, 3, 55, "InputOnly"],
Cell[5904, 196, 29, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[5958, 200, 85, 2, 53, "Input"],
Cell[6046, 204, 153, 3, 68, "Output"]
}, Open  ]],
Cell[6214, 210, 434, 10, 57, "Text"],
Cell[6651, 222, 242, 4, 55, "InputOnly"],
Cell[6896, 228, 28, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[6949, 232, 107, 2, 53, "Input"],
Cell[7059, 236, 96, 2, 53, "Output"]
}, Open  ]],
Cell[7170, 241, 190, 7, 33, "Text"],
Cell[7363, 250, 162, 3, 56, "InputOnly"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7562, 258, 65, 0, 49, "Subsection"],
Cell[7630, 260, 893, 22, 96, "Text"],
Cell[8526, 284, 1488, 27, 308, "InputOnly"],
Cell[10017, 313, 249, 8, 37, "Text"],

Cell[CellGroupData[{
Cell[10291, 325, 103, 2, 66, "Input"],
Cell[10397, 329, 133, 3, 61, "Output"]
}, Open  ]],
Cell[10545, 335, 18, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[10588, 339, 119, 3, 66, "Input"],
Cell[10710, 344, 115, 2, 61, "Output"]
}, Open  ]],
Cell[10840, 349, 109, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[10974, 356, 103, 2, 53, "Input"],
Cell[11080, 360, 149, 3, 76, "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[11290, 370, 43, 0, 28, "Section"],
Cell[11336, 372, 556, 16, 54, "Text"],
Cell[11895, 390, 290, 12, 35, "Text"],
Cell[12188, 404, 644, 21, 54, "Text"],
Cell[12835, 427, 274, 9, 70, "Text"],
Cell[13112, 438, 383, 10, 34, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13532, 453, 35, 0, 61, "Section"],

Cell[CellGroupData[{
Cell[13592, 457, 39, 0, 49, "Subsection"],
Cell[13634, 459, 40, 0, 33, "Text"],
Cell[13677, 461, 489, 16, 52, "NumberedEquation"],
Cell[14169, 479, 1466, 47, 117, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15672, 531, 38, 0, 49, "Subsection"],
Cell[15713, 533, 39, 0, 33, "Text"],
Cell[15755, 535, 187, 5, 33, "Text"],
Cell[15945, 542, 64, 0, 33, "Text"],
Cell[16012, 544, 583, 14, 54, "Text"],
Cell[16598, 560, 24, 0, 33, "Text"],
Cell[16625, 562, 206, 7, 34, "Text"],

Cell[CellGroupData[{
Cell[16856, 573, 102, 5, 40, "MathGroup"],
Cell[16961, 580, 63, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[17049, 584, 204, 5, 54, "Input"],
Cell[17256, 591, 523, 9, 58, "Output"]
}, Open  ]],
Cell[17794, 603, 186, 8, 33, "Text"],

Cell[CellGroupData[{
Cell[18005, 615, 211, 5, 54, "Input"],
Cell[18219, 622, 330, 7, 81, "Output"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[18610, 636, 54, 0, 49, "Subsection"],
Cell[18667, 638, 193, 6, 33, "Text"],
Cell[18863, 646, 155, 5, 33, "Text"],
Cell[19021, 653, 157, 5, 33, "Text"],
Cell[19181, 660, 244, 4, 54, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19462, 669, 37, 0, 49, "Subsection"],
Cell[19502, 671, 265, 5, 54, "Text"],

Cell[CellGroupData[{
Cell[19792, 680, 125, 5, 39, "Subsubsection"],
Cell[19920, 687, 413, 10, 33, "Text"],
Cell[20336, 699, 233, 7, 48, "NumberedEquation",
  CellTags->"cRegression"],
Cell[20572, 708, 57, 0, 33, "Text"],
Cell[20632, 710, 234, 9, 33, "Text"],
Cell[20869, 721, 1010, 27, 56, "Text"],
Cell[21882, 750, 870, 24, 56, "Text"],
Cell[22755, 776, 680, 16, 75, "Text"],
Cell[23438, 794, 570, 18, 56, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24045, 817, 112, 4, 39, "Subsubsection"],
Cell[24160, 823, 771, 24, 54, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[24980, 853, 39, 0, 49, "Subsection"],
Cell[25022, 855, 737, 24, 54, "Text"],
Cell[25762, 881, 277, 6, 66, "NumberedEquation",
  CellTags->"RollBayes0"],
Cell[26042, 889, 761, 24, 75, "Text"],
Cell[26806, 915, 291, 7, 52, "NumberedEquation",
  CellTags->"qCondp"],
Cell[27100, 924, 662, 19, 54, "Text"],
Cell[27765, 945, 489, 11, 75, "Text"],
Cell[28257, 958, 239, 6, 33, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28533, 969, 39, 0, 49, "Subsection"],
Cell[28575, 971, 882, 28, 75, "Text"],
Cell[29460, 1001, 156, 5, 33, "Text"],
Cell[29619, 1008, 163, 5, 33, "Text"],
Cell[29785, 1015, 37, 0, 33, "Text"],
Cell[29825, 1017, 205, 6, 33, "Text"],
Cell[30033, 1025, 611, 18, 54, "Text"],
Cell[30647, 1045, 708, 17, 54, "Text"],
Cell[31358, 1064, 429, 8, 67, "NumberedEquation",
  CellTags->"RollBayes"],
Cell[31790, 1074, 512, 13, 56, "Text"],
Cell[32305, 1089, 211, 7, 33, "Text"],
Cell[32519, 1098, 50, 0, 33, "Text"],
Cell[32572, 1100, 340, 8, 33, "Text"],
Cell[32915, 1110, 39, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[32979, 1114, 208, 4, 54, "Input"],
Cell[33190, 1120, 245, 4, 92, "Output"]
}, Open  ]],
Cell[33450, 1127, 29, 0, 33, "Text"],
Cell[33482, 1129, 196, 4, 46, "NumberedEquation",
  CellTags->"RollDensity"],
Cell[33681, 1135, 21, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[33727, 1139, 211, 5, 74, "Input"],
Cell[33941, 1146, 1537, 48, 110, "Output"]
}, Open  ]],
Cell[35493, 1197, 128, 5, 33, "Text"],
Cell[35624, 1204, 274, 6, 46, "NumberedEquation",
  CellTags->"Rollfm"],

Cell[CellGroupData[{
Cell[35923, 1214, 336, 9, 58, "TextGroup"],

Cell[CellGroupData[{
Cell[36284, 1227, 273, 5, 94, "Input"],
Cell[36560, 1234, 320, 5, 95, "Output"]
}, Open  ]],
Cell[36895, 1242, 34, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[36954, 1246, 84, 2, 53, "Input"],
Cell[37041, 1250, 273, 5, 103, "Output"]
}, Open  ]],
Cell[37329, 1258, 843, 22, 75, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[38209, 1285, 102, 5, 40, "MathGroup"],

Cell[CellGroupData[{
Cell[38336, 1294, 187, 4, 53, "Input"],
Cell[38526, 1300, 95, 2, 53, "Output"]
}, Open  ]],
Cell[38636, 1305, 179, 5, 33, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[38852, 1315, 79, 1, 26, "Subsubsection"],
Cell[38934, 1318, 872, 28, 77, "Text"],

Cell[CellGroupData[{
Cell[39831, 1350, 377, 6, 115, "Input"],
Cell[40211, 1358, 215, 4, 66, "Output"]
}, Open  ]],
Cell[40441, 1365, 35, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[40501, 1369, 84, 2, 53, "Input"],
Cell[40588, 1373, 242, 4, 104, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[40879, 1383, 79, 1, 37, "Subsubsection"],
Cell[40961, 1386, 779, 24, 54, "Text"],

Cell[CellGroupData[{
Cell[41765, 1414, 329, 6, 94, "Input"],
Cell[42097, 1422, 244, 4, 66, "Output"]
}, Open  ]],
Cell[42356, 1429, 47, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[42428, 1433, 84, 2, 53, "Input"],
Cell[42515, 1437, 252, 5, 104, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[42840, 1450, 71, 0, 61, "Section"],

Cell[CellGroupData[{
Cell[42936, 1454, 33, 0, 49, "Subsection"],
Cell[42972, 1456, 199, 4, 54, "Text"],
Cell[43174, 1462, 186, 4, 46, "NumberedEquation",
  CellTags->"InformativeTradeModel"],
Cell[43363, 1468, 1350, 39, 99, "Text"],
Cell[44716, 1509, 102, 4, 33, "Text"],
Cell[44821, 1515, 306, 10, 33, "Text"],
Cell[45130, 1527, 94, 2, 33, "Text"],
Cell[45227, 1531, 349, 6, 29, "NumberedEquation"],
Cell[45579, 1539, 437, 12, 54, "Text"],
Cell[46019, 1553, 104, 3, 33, "Text"],
Cell[46126, 1558, 226, 7, 33, "Text"],
Cell[46355, 1567, 108, 5, 33, "Text"],
Cell[46466, 1574, 509, 9, 67, "NumberedEquation",
  CellTags->"BayesContemporaneousImpact"],
Cell[46978, 1585, 831, 22, 77, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[47846, 1612, 129, 2, 48, "Subsection"],
Cell[47978, 1616, 435, 15, 33, "Text"],

Cell[CellGroupData[{
Cell[48438, 1635, 215, 4, 54, "Input"],
Cell[48656, 1641, 288, 7, 53, "Output"]
}, Open  ]],
Cell[48959, 1651, 368, 12, 33, "Text"],
Cell[49330, 1665, 488, 11, 33, "Text"],
Cell[49821, 1678, 141, 4, 33, "Text"],

Cell[CellGroupData[{
Cell[49987, 1686, 191, 4, 53, "Input"],
Cell[50181, 1692, 258, 4, 92, "Output"]
}, Open  ]],
Cell[50454, 1699, 51, 0, 33, "Text"],
Cell[50508, 1701, 189, 5, 39, "Text"],
Cell[50700, 1708, 169, 5, 33, "Text"],

Cell[CellGroupData[{
Cell[50894, 1717, 112, 2, 70, "Input"],
Cell[51009, 1721, 109, 2, 62, "Output"]
}, Open  ]],
Cell[51133, 1726, 42, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[51200, 1730, 334, 6, 74, "Input"],
Cell[51537, 1738, 1608, 53, 53, "Output"]
}, Open  ]],
Cell[53160, 1794, 375, 12, 33, "Text"],

Cell[CellGroupData[{
Cell[53560, 1810, 102, 5, 40, "MathGroup"],

Cell[CellGroupData[{
Cell[53687, 1819, 88, 2, 53, "Input"],
Cell[53778, 1823, 109, 2, 62, "Output"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[53948, 1832, 148, 2, 48, "Subsection"],
Cell[54099, 1836, 62, 0, 33, "Text"],
Cell[54164, 1838, 307, 9, 33, "Text"],
Cell[54474, 1849, 69, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[54568, 1853, 91, 2, 53, "Input"],
Cell[54662, 1857, 288, 5, 92, "Output"]
}, Open  ]],
Cell[54965, 1865, 287, 9, 33, "Text"],

Cell[CellGroupData[{
Cell[55277, 1878, 212, 5, 74, "Input"],
Cell[55492, 1885, 1969, 58, 110, "Output"]
}, Open  ]],
Cell[57476, 1946, 115, 5, 33, "Text"],
Cell[57594, 1953, 221, 6, 33, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[57852, 1964, 29, 0, 49, "Subsection"],
Cell[57884, 1966, 56, 0, 33, "Text"],
Cell[57943, 1968, 281, 9, 33, "Text"],
Cell[58227, 1979, 333, 10, 33, "Text"],
Cell[58563, 1991, 59, 0, 33, "Text"],
Cell[58625, 1993, 33, 0, 33, "Text"],
Cell[58661, 1995, 146, 3, 33, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[58844, 2003, 44, 0, 49, "Subsection"],

Cell[CellGroupData[{
Cell[58913, 2007, 79, 1, 37, "Subsubsection"],
Cell[58995, 2010, 95, 5, 33, "Text"],
Cell[59093, 2017, 305, 8, 73, "Text"],
Cell[59401, 2027, 556, 17, 56, "Text"],
Cell[59960, 2046, 196, 6, 33, "Text"],
Cell[60159, 2054, 21, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[60205, 2058, 383, 8, 74, "Input"],
Cell[60591, 2068, 1372, 42, 88, "Output"]
}, Open  ]],
Cell[61978, 2113, 21, 0, 33, "Text"],
Cell[62002, 2115, 191, 6, 33, "Text"],
Cell[62196, 2123, 223, 8, 33, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[62456, 2136, 79, 1, 37, "Subsubsection"],
Cell[62538, 2139, 95, 5, 33, "Text"],
Cell[62636, 2146, 403, 10, 73, "Text"],
Cell[63042, 2158, 558, 17, 56, "Text"],
Cell[63603, 2177, 172, 5, 33, "Text"],
Cell[63778, 2184, 21, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[63824, 2188, 348, 7, 74, "Input"],
Cell[64175, 2197, 1408, 43, 88, "Output"]
}, Open  ]],
Cell[65598, 2243, 47, 0, 33, "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[65706, 2250, 65, 1, 78, "Section",
  CellTags->"Discrete Prices"],

Cell[CellGroupData[{
Cell[65796, 2255, 39, 0, 49, "Subsection"],
Cell[65838, 2257, 124, 3, 33, "Text"],
Cell[65965, 2262, 409, 14, 35, "Text"],
Cell[66377, 2278, 247, 7, 33, "Text"],
Cell[66627, 2287, 184, 7, 54, "Text"],
Cell[66814, 2296, 249, 4, 54, "Text"],
Cell[67066, 2302, 866, 24, 68, "Text"],
Cell[67935, 2328, 273, 9, 47, "Text"],
Cell[68211, 2339, 446, 12, 54, "Text"],
Cell[68660, 2353, 545, 17, 54, "Text"],
Cell[69208, 2372, 147, 5, 33, "Text"],
Cell[69358, 2379, 123, 4, 33, "Text"],
Cell[69484, 2385, 140, 5, 33, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[69661, 2395, 152, 5, 49, "Subsection"],
Cell[69816, 2402, 65, 0, 33, "Text"],
Cell[69884, 2404, 971, 18, 117, "NumberedEquation"],
Cell[70858, 2424, 324, 9, 54, "Text"],
Cell[71185, 2435, 267, 4, 53, "NumberedEquation",
  CellTags->"DiscretenessPr"],
Cell[71455, 2441, 847, 29, 54, "Text"],
Cell[72305, 2472, 194, 6, 33, "Text"],

Cell[CellGroupData[{
Cell[72524, 2482, 127, 3, 53, "Input"],
Cell[72654, 2487, 106, 2, 53, "Output"]
}, Open  ]],
Cell[72775, 2492, 19, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[72819, 2496, 127, 3, 53, "Input"],
Cell[72949, 2501, 111, 2, 53, "Output"]
}, Open  ]],
Cell[73075, 2506, 174, 8, 33, "Text"],

Cell[CellGroupData[{
Cell[73274, 2518, 102, 2, 53, "Input"],
Cell[73379, 2522, 106, 2, 53, "Output"]
}, Open  ]],
Cell[73500, 2527, 174, 8, 33, "Text"],

Cell[CellGroupData[{
Cell[73699, 2539, 102, 2, 53, "Input"],
Cell[73804, 2543, 111, 2, 53, "Output"]
}, Open  ]],
Cell[73930, 2548, 187, 5, 33, "Text"],
Cell[74120, 2555, 909, 27, 96, "NumberedEquation",
  CellTags->"MLimits"],
Cell[75032, 2584, 263, 8, 33, "Text"],

Cell[CellGroupData[{
Cell[75320, 2596, 105, 5, 40, "MathGroup"],

Cell[CellGroupData[{
Cell[75450, 2605, 204, 4, 53, "Input"],
Cell[75657, 2611, 132, 3, 53, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[75826, 2619, 95, 2, 53, "Input"],
Cell[75924, 2623, 131, 3, 60, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[76092, 2631, 212, 4, 74, "Input"],
Cell[76307, 2637, 385, 12, 60, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[76729, 2654, 108, 2, 53, "Input"],
Cell[76840, 2658, 105, 2, 53, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[76982, 2665, 204, 4, 53, "Input"],
Cell[77189, 2671, 120, 3, 53, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[77346, 2679, 95, 2, 53, "Input"],
Cell[77444, 2683, 131, 3, 60, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[77612, 2691, 212, 4, 74, "Input"],
Cell[77827, 2697, 382, 12, 60, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[78246, 2714, 68, 2, 53, "Input"],
Cell[78317, 2718, 116, 2, 58, "Output"]
}, Open  ]],
Cell[78448, 2723, 112, 2, 55, "InputOnly"]
}, Closed]],

Cell[CellGroupData[{
Cell[78597, 2730, 33, 0, 28, "TextGroup"],
Cell[78633, 2732, 395, 12, 34, "Text"],
Cell[79031, 2746, 486, 14, 33, "Text"],
Cell[79520, 2762, 381, 9, 50, "Text"],
Cell[79904, 2773, 1862, 59, 54, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[81803, 2837, 105, 5, 40, "MathGroup"],

Cell[CellGroupData[{
Cell[81933, 2846, 287, 6, 70, "Input"],
Cell[82223, 2854, 353, 7, 66, "Output"]
}, Open  ]],
Cell[82591, 2864, 207, 5, 74, "Input"],

Cell[CellGroupData[{
Cell[82823, 2873, 285, 6, 74, "Input"],
Cell[83111, 2881, 1190, 39, 53, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[84338, 2925, 140, 3, 53, "Input"],
Cell[84481, 2930, 96, 2, 53, "Output"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[84638, 2939, 127, 4, 49, "Subsection"],
Cell[84768, 2945, 767, 25, 54, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[85572, 2975, 104, 4, 49, "Subsection"],
Cell[85679, 2981, 332, 12, 33, "Text"],

Cell[CellGroupData[{
Cell[86036, 2997, 154, 4, 53, "Input"],
Cell[86193, 3003, 109, 2, 53, "Output"]
}, Open  ]],
Cell[86317, 3008, 103, 5, 33, "Text"],

Cell[CellGroupData[{
Cell[86445, 3017, 154, 4, 53, "Input"],
Cell[86602, 3023, 114, 2, 53, "Output"]
}, Open  ]],
Cell[86731, 3028, 212, 8, 33, "Text"],
Cell[86946, 3038, 314, 9, 81, "Text"],

Cell[CellGroupData[{
Cell[87285, 3051, 105, 5, 40, "MathGroup"],

Cell[CellGroupData[{
Cell[87415, 3060, 204, 4, 53, "Input"],
Cell[87622, 3066, 138, 3, 53, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[87797, 3074, 95, 2, 53, "Input"],
Cell[87895, 3078, 143, 3, 60, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[88075, 3086, 93, 2, 53, "Input"],
Cell[88171, 3090, 120, 3, 60, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[88328, 3098, 204, 4, 53, "Input"],
Cell[88535, 3104, 131, 3, 53, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[88703, 3112, 95, 2, 53, "Input"],
Cell[88801, 3116, 143, 3, 58, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[88981, 3124, 93, 2, 53, "Input"],
Cell[89077, 3128, 120, 3, 58, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[89246, 3137, 389, 14, 28, "TextGroup"],
Cell[89638, 3153, 160, 5, 39, "Text"],
Cell[89801, 3160, 244, 6, 33, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[90094, 3172, 135, 4, 49, "Subsection"],
Cell[90232, 3178, 982, 27, 96, "Text"],
Cell[91217, 3207, 1587, 50, 118, "Text"],
Cell[92807, 3259, 235, 8, 35, "Text"],
Cell[93045, 3269, 603, 14, 98, "Text"],
Cell[93651, 3285, 740, 17, 75, "Text"],
Cell[94394, 3304, 276, 7, 48, "NumberedEquation",
  CellTags->"SimulatedCRegression"],
Cell[94673, 3313, 455, 12, 54, "Text"],
Cell[95131, 3327, 1041, 28, 98, "Text"],
Cell[96175, 3357, 533, 14, 75, "Text"],
Cell[96711, 3373, 269, 10, 33, "Text"],
Cell[96983, 3385, 26, 0, 33, "Text"],
Cell[97012, 3387, 666, 17, 63, "NumberedEquation"],
Cell[97681, 3406, 924, 23, 79, "Text"],
Cell[98608, 3431, 144, 5, 33, "Text"],
Cell[98755, 3438, 615, 20, 54, "Text"],
Cell[99373, 3460, 357, 11, 33, "Text"],
Cell[99733, 3473, 284, 6, 54, "Text"],
Cell[100020, 3481, 408, 7, 50, "NumberedEquation"],
Cell[100431, 3490, 343, 11, 33, "Text"],
Cell[100777, 3503, 187, 3, 29, "NumberedEquation"],
Cell[100967, 3508, 25, 0, 33, "Text"],
Cell[100995, 3510, 214, 3, 29, "NumberedEquation"],
Cell[101212, 3515, 311, 12, 33, "Text"],
Cell[101526, 3529, 774, 25, 75, "Text"],
Cell[102303, 3556, 793, 22, 57, "Text"],
Cell[103099, 3580, 19, 0, 33, "Text"],
Cell[103121, 3582, 498, 15, 78, "Text"],
Cell[103622, 3599, 47, 0, 33, "Text"],
Cell[103672, 3601, 704, 20, 57, "Text"],
Cell[104379, 3623, 819, 25, 75, "Text"],
Cell[105201, 3650, 463, 15, 54, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[105713, 3671, 67, 1, 78, "Section",
  CellTags->"Clustered prices"],

Cell[CellGroupData[{
Cell[105805, 3676, 39, 0, 49, "Subsection"],
Cell[105847, 3678, 127, 3, 33, "Text"],
Cell[105977, 3683, 350, 13, 35, "Text"],
Cell[106330, 3698, 288, 8, 33, "Text"],
Cell[106621, 3708, 196, 7, 54, "Text"],
Cell[106820, 3717, 370, 9, 54, "Text"],
Cell[107193, 3728, 362, 11, 47, "Text"],
Cell[107558, 3741, 221, 6, 33, "Text"],
Cell[107782, 3749, 714, 20, 88, "Text"],
Cell[108499, 3771, 278, 9, 47, "Text"],
Cell[108780, 3782, 256, 8, 33, "Text"],
Cell[109039, 3792, 139, 5, 33, "Text"],
Cell[109181, 3799, 152, 6, 33, "Text"],
Cell[109336, 3807, 475, 18, 54, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[109848, 3830, 143, 4, 49, "Subsection"],
Cell[109994, 3836, 24, 0, 33, "Text"],
Cell[110021, 3838, 1024, 19, 134, "NumberedEquation",
  CellTags->"ClusterBayes"],
Cell[111048, 3859, 327, 11, 33, "Text"],
Cell[111378, 3872, 251, 6, 37, "Text"],
Cell[111632, 3880, 865, 30, 75, "Text"],
Cell[112500, 3912, 67, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[112592, 3916, 130, 3, 53, "Input"],
Cell[112725, 3921, 109, 2, 53, "Output"]
}, Open  ]],
Cell[112849, 3926, 19, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[112893, 3930, 130, 3, 53, "Input"],
Cell[113026, 3935, 114, 2, 53, "Output"]
}, Open  ]],
Cell[113155, 3940, 174, 8, 33, "Text"],

Cell[CellGroupData[{
Cell[113354, 3952, 102, 2, 53, "Input"],
Cell[113459, 3956, 109, 2, 53, "Output"]
}, Open  ]],
Cell[113583, 3961, 174, 8, 33, "Text"],

Cell[CellGroupData[{
Cell[113782, 3973, 102, 2, 53, "Input"],
Cell[113887, 3977, 114, 2, 53, "Output"]
}, Open  ]],
Cell[114016, 3982, 131, 5, 33, "Text"],
Cell[114150, 3989, 356, 10, 81, "Text"],
Cell[114509, 4001, 279, 8, 33, "Text"],

Cell[CellGroupData[{
Cell[114813, 4013, 102, 5, 40, "MathGroup"],

Cell[CellGroupData[{
Cell[114940, 4022, 227, 4, 74, "Input"],
Cell[115170, 4028, 135, 3, 53, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[115342, 4036, 95, 2, 53, "Input"],
Cell[115440, 4040, 149, 3, 61, "Output"]
}, Open  ]],
Cell[115604, 4046, 161, 4, 55, "InputOnly"],

Cell[CellGroupData[{
Cell[115790, 4054, 74, 2, 53, "Input"],
Cell[115867, 4058, 144, 3, 60, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[116048, 4066, 204, 4, 53, "Input"],
Cell[116255, 4072, 128, 3, 53, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[116420, 4080, 95, 2, 53, "Input"],
Cell[116518, 4084, 149, 3, 58, "Output"]
}, Open  ]],
Cell[116682, 4090, 159, 4, 55, "InputOnly"],

Cell[CellGroupData[{
Cell[116866, 4098, 74, 2, 53, "Input"],
Cell[116943, 4102, 132, 3, 58, "Output"]
}, Open  ]],
Cell[117090, 4108, 131, 3, 55, "InputOnly"]
}, Closed]],

Cell[CellGroupData[{
Cell[117258, 4116, 202, 8, 28, "TextGroup"],
Cell[117463, 4126, 305, 7, 29, "NumberedEquation"],
Cell[117771, 4135, 366, 10, 34, "Text"],
Cell[118140, 4147, 262, 7, 33, "Text"],
Cell[118405, 4156, 345, 12, 33, "Text"],
Cell[118753, 4170, 192, 6, 33, "Text"],
Cell[118948, 4178, 297, 11, 33, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[119294, 4195, 156, 5, 49, "Subsection"],
Cell[119453, 4202, 278, 10, 35, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[119768, 4217, 113, 4, 49, "Subsection"],
Cell[119884, 4223, 1410, 49, 96, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[121343, 4278, 83, 1, 78, "Section",
  CellTags->"LaggedTradeDependencies"],

Cell[CellGroupData[{
Cell[121451, 4283, 39, 0, 49, "Subsection"],
Cell[121493, 4285, 197, 4, 54, "Text"],
Cell[121693, 4291, 132, 2, 29, "NumberedEquation"],
Cell[121828, 4295, 130, 5, 33, "Text"],
Cell[121961, 4302, 187, 5, 35, "Text"],
Cell[122151, 4309, 247, 6, 54, "Text"],
Cell[122401, 4317, 116, 4, 33, "Text"],
Cell[122520, 4323, 233, 6, 33, "Text"],
Cell[122756, 4331, 584, 9, 52, "NumberedEquation",
  CellTags->"LaggedTradeDepRegression"],
Cell[123343, 4342, 244, 8, 33, "Text"],
Cell[123590, 4352, 238, 9, 33, "Text"],
Cell[123831, 4363, 247, 6, 33, "Text"],
Cell[124081, 4371, 483, 11, 54, "Text"],
Cell[124567, 4384, 817, 23, 75, "Text"],
Cell[125387, 4409, 332, 9, 33, "Text"],
Cell[125722, 4420, 126, 3, 33, "Text"],
Cell[125851, 4425, 125, 5, 33, "Text"],
Cell[125979, 4432, 498, 9, 67, "NumberedEquation",
  CellTags->"LaggedInformativeModelBayes"],
Cell[126480, 4443, 426, 10, 54, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[126943, 4458, 193, 6, 66, "Subsection",
  CellTags->"LaggedTradeImpact1"],
Cell[127139, 4466, 403, 12, 34, "Text"],
Cell[127545, 4480, 351, 6, 51, "NumberedEquation",
  CellTags->"Prodfu"],
Cell[127899, 4488, 308, 11, 33, "Text"],

Cell[CellGroupData[{
Cell[128232, 4503, 289, 6, 74, "Input"],
Cell[128524, 4511, 274, 6, 53, "Output"]
}, Open  ]],
Cell[128813, 4520, 112, 5, 33, "Text"],

Cell[CellGroupData[{
Cell[128950, 4529, 186, 4, 53, "Input"],
Cell[129139, 4535, 246, 4, 92, "Output"]
}, Open  ]],
Cell[129400, 4542, 208, 5, 33, "Text"],

Cell[CellGroupData[{
Cell[129633, 4551, 171, 4, 84, "Input"],
Cell[129807, 4557, 330, 5, 97, "Output"]
}, Open  ]],
Cell[130152, 4565, 160, 5, 33, "Text"],

Cell[CellGroupData[{
Cell[130337, 4574, 102, 5, 40, "MathGroup"],
Cell[130442, 4581, 89, 2, 33, "Text"],

Cell[CellGroupData[{
Cell[130556, 4587, 80, 2, 53, "Input"],
Cell[130639, 4591, 253, 4, 71, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[130929, 4600, 126, 3, 53, "Input"],
Cell[131058, 4605, 186, 4, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[131281, 4614, 120, 3, 53, "Input"],
Cell[131404, 4619, 164, 4, 53, "Output"]
}, Open  ]],
Cell[131583, 4626, 458, 16, 54, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[132090, 4648, 157, 5, 49, "Subsection"],
Cell[132250, 4655, 242, 8, 33, "Text"],

Cell[CellGroupData[{
Cell[132517, 4667, 173, 3, 53, "Input"],
Cell[132693, 4672, 274, 6, 53, "Output"]
}, Open  ]],
Cell[132982, 4681, 90, 2, 33, "Text"],

Cell[CellGroupData[{
Cell[133097, 4687, 90, 2, 53, "Input"],
Cell[133190, 4691, 276, 5, 92, "Output"]
}, Open  ]],
Cell[133481, 4699, 150, 5, 33, "Text"],

Cell[CellGroupData[{
Cell[133656, 4708, 221, 5, 74, "Input"],
Cell[133880, 4715, 1819, 55, 110, "Output"]
}, Open  ]],
Cell[135714, 4773, 21, 0, 33, "Text"],
Cell[135738, 4775, 184, 5, 31, "NumberedEquation"],

Cell[CellGroupData[{
Cell[135947, 4784, 186, 4, 83, "Input"],
Cell[136136, 4790, 209, 4, 57, "Output"]
}, Open  ]],
Cell[136360, 4797, 241, 8, 33, "Text"],

Cell[CellGroupData[{
Cell[136626, 4809, 90, 2, 53, "Input"],
Cell[136719, 4813, 219, 4, 57, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[136987, 4823, 29, 0, 49, "Subsection"],
Cell[137019, 4825, 167, 6, 33, "Text"],
Cell[137189, 4833, 297, 9, 33, "Text"],
Cell[137489, 4844, 292, 9, 33, "Text"],
Cell[137784, 4855, 556, 14, 33, "Text"],
Cell[138343, 4871, 262, 6, 38, "Text"],
Cell[138608, 4879, 67, 0, 33, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[138712, 4884, 44, 0, 49, "Subsection"],

Cell[CellGroupData[{
Cell[138781, 4888, 79, 1, 37, "Subsubsection"],
Cell[138863, 4891, 590, 19, 54, "Text"],

Cell[CellGroupData[{
Cell[139478, 4914, 101, 2, 53, "Input"],
Cell[139582, 4918, 145, 3, 53, "Output"]
}, Open  ]],
Cell[139742, 4924, 550, 19, 33, "Text"],
Cell[140295, 4945, 161, 5, 33, "Text"],

Cell[CellGroupData[{
Cell[140481, 4954, 154, 3, 53, "Input"],
Cell[140638, 4959, 1335, 41, 88, "Output"]
}, Open  ]],
Cell[141988, 5003, 132, 4, 33, "Text"],

Cell[CellGroupData[{
Cell[142145, 5011, 175, 4, 83, "Input"],
Cell[142323, 5017, 189, 3, 55, "Output"]
}, Open  ]],
Cell[142527, 5023, 126, 4, 33, "Text"],

Cell[CellGroupData[{
Cell[142678, 5031, 91, 2, 53, "Input"],
Cell[142772, 5035, 209, 4, 55, "Output"]
}, Open  ]],
Cell[142996, 5042, 273, 7, 33, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[143306, 5054, 79, 1, 37, "Subsubsection"],
Cell[143388, 5057, 300, 11, 33, "Text"],

Cell[CellGroupData[{
Cell[143713, 5072, 102, 2, 53, "Input"],
Cell[143818, 5076, 163, 4, 53, "Output"]
}, Open  ]],
Cell[143996, 5083, 425, 13, 33, "Text"],

Cell[CellGroupData[{
Cell[144446, 5100, 155, 3, 53, "Input"],
Cell[144604, 5105, 1343, 41, 88, "Output"]
}, Open  ]],
Cell[145962, 5149, 234, 7, 33, "Text"],
Cell[146199, 5158, 403, 13, 33, "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[146663, 5178, 92, 2, 61, "Section"],

Cell[CellGroupData[{
Cell[146780, 5184, 39, 0, 49, "Subsection"],
Cell[146822, 5186, 172, 3, 33, "Text"],
Cell[146997, 5191, 191, 4, 46, "NumberedEquation",
  CellTags->"mCombinedModelI"],
Cell[147191, 5197, 127, 3, 33, "Text"],
Cell[147321, 5202, 196, 7, 54, "Text"],
Cell[147520, 5211, 454, 15, 54, "Text"],
Cell[147977, 5228, 362, 11, 47, "Text"],
Cell[148342, 5241, 222, 6, 54, "Text"],
Cell[148567, 5249, 348, 10, 88, "Text"],
Cell[148918, 5261, 273, 9, 47, "Text"],
Cell[149194, 5272, 217, 6, 33, "Text"],
Cell[149414, 5280, 153, 2, 29, "NumberedEquation"],
Cell[149570, 5284, 334, 11, 33, "Text"],
Cell[149907, 5297, 256, 8, 33, "Text"],
Cell[150166, 5307, 158, 6, 33, "Text"],
Cell[150327, 5315, 134, 5, 33, "Text"],
Cell[150464, 5322, 364, 10, 33, "Text"],
Cell[150831, 5334, 883, 15, 155, "NumberedEquation",
  CellTags->"AsyInfoClusterBayes"],
Cell[151717, 5351, 243, 6, 33, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[151997, 5362, 129, 2, 48, "Subsection"],
Cell[152129, 5366, 522, 16, 54, "Text"],

Cell[CellGroupData[{
Cell[152676, 5386, 216, 4, 54, "Input"],
Cell[152895, 5392, 289, 7, 53, "Output"]
}, Open  ]],
Cell[153199, 5402, 113, 5, 33, "Text"],

Cell[CellGroupData[{
Cell[153337, 5411, 192, 4, 53, "Input"],
Cell[153532, 5417, 259, 4, 92, "Output"]
}, Open  ]],
Cell[153806, 5424, 342, 11, 33, "Text"],

Cell[CellGroupData[{
Cell[154173, 5439, 183, 3, 71, "Input"],
Cell[154359, 5444, 348, 5, 106, "Output"]
}, Open  ]],
Cell[154722, 5452, 424, 13, 33, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[155183, 5470, 141, 2, 48, "Subsection"],
Cell[155327, 5474, 335, 12, 33, "Text"],
Cell[155665, 5488, 298, 4, 36, "NumberedEquation"],
Cell[155966, 5494, 284, 9, 33, "Text"],

Cell[CellGroupData[{
Cell[156275, 5507, 61, 2, 53, "Input"],
Cell[156339, 5511, 289, 7, 53, "Output"]
}, Open  ]],
Cell[156643, 5521, 189, 5, 33, "Text"],

Cell[CellGroupData[{
Cell[156857, 5530, 156, 3, 53, "Input"],
Cell[157016, 5535, 1970, 58, 110, "Output"]
}, Open  ]],
Cell[159001, 5596, 136, 5, 33, "Text"],
Cell[159140, 5603, 362, 6, 29, "NumberedEquation"],
Cell[159505, 5611, 167, 5, 33, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[159721, 5622, 100, 2, 61, "Section"],
Cell[159824, 5626, 277, 5, 54, "Text"],
Cell[160104, 5633, 132, 2, 29, "NumberedEquation"],
Cell[160239, 5637, 130, 5, 33, "Text"],
Cell[160372, 5644, 187, 5, 35, "Text"],
Cell[160562, 5651, 192, 5, 33, "Text"],
Cell[160757, 5658, 97, 2, 33, "Text"],
Cell[160857, 5662, 168, 5, 33, "Text"],
Cell[161028, 5669, 285, 4, 52, "NumberedEquation",
  CellTags->"mCombinedModelII"],
Cell[161316, 5675, 775, 18, 75, "Text"],
Cell[162094, 5695, 259, 8, 33, "Text"],
Cell[162356, 5705, 256, 8, 33, "Text"],
Cell[162615, 5715, 158, 6, 33, "Text"],
Cell[162776, 5723, 134, 5, 33, "Text"],
Cell[162913, 5730, 70, 0, 33, "Text"],
Cell[162986, 5732, 863, 15, 138, "NumberedEquation"],
Cell[163852, 5749, 354, 9, 54, "Text"],
Cell[164209, 5760, 178, 5, 33, "Text"],
Cell[164390, 5767, 296, 7, 37, "Text"],
Cell[164689, 5776, 287, 9, 33, "Text"],
Cell[164979, 5787, 628, 21, 54, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[165644, 5813, 29, 0, 61, "Section"],
Cell[165676, 5815, 779, 14, 159, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

