function d=AsyInfoCLusterSimulate(nDay, n, par)

disp('Simulation values:');
disp(par);
disp('lambda:');
disp(par.lambda)

for i=1:nDay
   d(i) = Simulated(n, par);
end

function d=Simulated(T, par)
x = randn(1,T);
q = sign(x);
x = abs(x);
u = sqrt(par.varu)*randn(1,T);
m = zeros(1,T);
m(1)=log(par.MStart);
for t=2:T
   Impact = 0;
   for j=0:par.J;
      if (t-j<1); break; end;
      Impact = Impact + q(t-j)*(par.lambda(j+1,1) + par.lambda(j+1,2)*x(t-j));
   end;
   m(t) = m(t-1)+Impact+u(t);
end
k = rand(1,T)<par.ClusterProb;
K = ~k + par.ClusterMult * k;
bid=FloorGeneral(exp(m)-par.C, K);
ask= CeilGeneral(exp(m)+par.C, K);
AtAsk = q==1;
d.q = q;
d.m = m;
d.x = x;
d.P = AtAsk.*ask + (~AtAsk).*bid;
d.K = K;
