function RollFixedcGraphs

addpath('.\m Files\', '.\m Files\General', '.\m Files\Special', '.\m Files\Statistics', '.\Roll Fixed c');

diary RollFixedcGraphs.lst;

close all;

UsePath = '.\Roll Fixed c\10KDraws\';

Analyses=struct('Symbol', {'PB','EC','NB','SP'}, ...
   'PAvg', {2313, 10622, 8037, 13317}, ...
   'Contract', {'Pork Bellies' 'Euro' 'UK' 'S&P 500'});

set(gcf,'DefaultAxesFontSize',12);
set(gcf,'DefaultAxesYTick',[]);
VarLabels={'\sigma_{\itu}\times10,000' '\itc\times10,000' '\itC (ticks)'};

kPlot = 0;

for i=1:length(Analyses)
   disp(Analyses(i).Symbol);
	
   SaveFile = [UsePath Analyses(i).Symbol '\Draws'];
   load(SaveFile);
   
	sdu = 10000*sqrt(GetDrawVector(Draws,'par.varu'));
	c = GetDrawVector(Draws,'par.c');
	C=(exp(c)-1)*Analyses(i).PAvg;
   c = 10000*c;	%rescale
   
   PG = [sdu c C];
   GibbsSummary(PG, .2, {'sd_u x 10,000' 'c x 10,000' 'C'});
   
   nDrop = floor(.2*size(PG,1));
   nUse = size(PG,1)-nDrop;
   PG = PG(nDrop+1:end,:);
   
   for j=1:3
      kPlot = kPlot+1;
      subplot(4,3,kPlot);
      
      p = get(gca,'Position');
      p = [p(1) p(2) .9*p(3), .9*p(4)];
      set(gca,'Position',p);
      
	   [nb,xout]=hist(PG(:,j),20);
   	nb = nb/nUse;
      bar(xout,nb);
      if i==length(Analyses)
         xlabel(VarLabels{j});
      end
      box off;
      
      if j==1;
         position(i,:) = get(gca,'Position');
      end;
      
   end;
end

h = axes('Position',[0 0 1 1], 'Visible', 'off');
set(gcf,'currentaxes',h);
for i=1:4
   text(.01,position(i,2)+position(i,4),Analyses(i).Contract,'FontSize',12);
end;

saveas(gcf,  'RollFixedcPost.fig');
diary off;