


*******************************************************************
******************* TABLE 6, 8, and 10: extensive - Exit **********
*******************************************************************
* The commented code was used to create the analysis dataset form the original ones (originals not included)

/*
clear all
set matsize 11000
set maxvar 20000
cd "/Users/dp2239/Documents/Academic/Data/Peru/SUB_PRIME"
use growth_temp_hc4.dta, clear  	

	

egen pd = group(part country_code )
egen fpd=group(ruc part country_code )

* Filling in the zeroes 
fillin fpd etime
foreach var of varlist ruc part country_code firmSUB_2006 firmSUB50p_2006 firmSUB50p_07 fexposure* wexposure* {
	sort fpd `var'
	by fpd: replace `var'=`var'[1]
}
foreach var of varlist saldotot nbanks frac_dollartot {
	sort ruc etime `var'
	by ruc etime: replace `var'=`var'[1]
}
foreach var of varlist fob peso paycash_WFOB transair_WFOB {
	replace `var'=0 if _fillin==1
}
drop continues enters exits continuesB continuesA 
tsset fpd etime


*Does not export today (conditional on exporting yesterday) 
gen byte exit = fob==0 if l.fob>0  
*Does not export tomorrow (conditional on exporting today) 
gen byte exit2 = f.fob==0 if fob>0  


*Flow cuts (have to be done before dropping Observations)
tsset fpd etime 
*Flow size
egen g10_fobflow=cut(l.fob) , group(10)
gen Lfob=l.fob
*Fraction of flow paid in cash
egen g10_cash=cut( l.paycash_WFOB) , group(10)
gen Lpaycash_WFOB=l.paycash_WFOB
*Fraction shipped by air
egen g10_air=cut( l.transair_WFOB) , group(10)
gen Ltransair_WFOB=l.transair_WFOB

drop if etime==1 | etime==4

*Note 2: this has all the firms that export at any time in the sample period (over 11K firms) --> larger than intensive margin
*To reduce the numebr we keep only those with positive debt (this leaves 5051 firms)
egen minsaldo_byruc=min(saldotot), by(ruc)
drop if minsaldo_byruc==0
drop pd fpd
egen pd = group(part country_code )
egen fpd=group(ruc part country_code )
egen pdt=group(part country_code  etime)

foreach var of varlist fob peso  saldotot  {
	gen l`var'=ln(`var')
	gen l`var'_continuesA=ln(`var'_continuesA)
	gen l`var'_continuesB=ln(`var'_continuesB)
	gen l`var'_Lexits=ln(`var'_Lexits)
}
gen post=etime==3
foreach var of varlist firmSUB50p_2006 fexposure_2006 wexposure1_2006 wexposure2_2006 wexposure3_2006 {
gen `var'_post=`var'*post
}

bysort pdt: gen faketime=_n
egen iruc=group(ruc)
xtset pdt faketime

*cleaning up before running regressions
drop wexposure_dollar- wexposure8
compress

rename part part4
sort part4
merge m:1 part4 using "C:\Users\dp2239\Documents\Academic\Data\Peru\concordance\homogeneous_part4.dta"
drop  rauchconservative rauchliberal
drop if _merge==2
drop _merge

sort  part4
merge m:1 part4 using "C:\Users\dp2239\Documents\Academic\Data\Peru\concordance\externaldep_avg_part4.dta", keepusing(extfin tang tcred)
drop if _merge==2
drop _merge
rename part4 part

replace ruc=iruc

save "C:\Users\dp2239\Documents\Academic\Data\Peru\Data_RESTUD\data_exit_1y_HS4.dta", replace
*/


use "data_exit_1y_HS4.dta", clear

xtset pdt

*OLS (Table 6, column 1)
areg exit2 lsaldotot i.iruc, r cl(pd) a(pdt)

*Main result (Table 6, column 2)	

xtivreg exit2 i.iruc (lsaldotot = fexposure_2006_post), fe

*Robustness alternate instrument (Table 8)	

xtivreg exit2 i.iruc (lsaldotot = wexposure1_2006_post wexposure2_2006_post wexposure3_2006_post), fe


*Robustness: with controls (Table 8)
egen pesototal=sum(peso) if post==0, by(ruc post)
gen byte fob2_dum=fob>0 if fob<.
egen mc=max(fob2_dum) if post==0, by(ruc country_code post)
egen mp=max(fob2_dum) if post==0, by(ruc part post)
egen byte tag_fct=tag(ruc country_code post)  if post==0
egen byte tag_fpt=tag(ruc part post)  if post==0
egen ncount=sum(mc*tag_fct) if post==0 , by(ruc post)
egen npart=sum(mp*tag_fpt) if post==0 , by(ruc post)
drop mc mp fob2_dum tag_fct tag_fpt
gen unitprice=fob/peso if post==0
foreach var of varlist pesototal  ncount npart {
	sum `var'
	sort ruc `var'
	by ruc: replace `var'=`var'[1]
}
sort fpd unitprice
by fpd: replace unitprice=unitprice[1]
gen unitprice_post=unitprice*post
foreach var of varlist pesototal  ncount npart  {
	gen l`var'_post=ln(`var')*post
}
gen frac_dollartot_post=frac_dollartot*post

xtivreg exit2 lpesototal_post lnpart_post lncount_post frac_dollartot_post unitprice unitprice_post i.iruc (lsaldotot = fexposure_2006_post), fe


*Robustness: Homogeneous only (Table 8)
xtivreg exit2  i.iruc (lsaldotot = fexposure_2006_post) if homogen_rc==0, fe


*With Instrument created using Dec 2007 exposures (Table 8)
gen fexposure_07_post=fexposure_07*post
xtivreg exit2 i.iruc (lsaldotot = fexposure_07_post ), fe


*By EXTERNAL FINANCE DEPENDENCE (Table 10)
egen tag_ft=tag(ruc etime)
egen fob_tot=sum(fob), by(ruc etime)
sum extfin
gen Nextfin=(extfin-r(mean))/r(sd)
foreach var of varlist lsaldotot fexposure_2006 {
	gen `var'_Nextfin=`var'*Nextfin
	gen `var'_Nextfin_post=`var'*Nextfin*post
}
xtivreg exit2  i.iruc (lsaldotot lsaldotot_Nextfin= fexposure_2006_post fexposure_2006_Nextfin_post), fe


	

