/*
 * Card.java
 *
 * Created on November 7, 2006, 2:00 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package blackjacksimulator;

/**
 *
 * @author 511412
 */
public class Card {
    
    private static String[] suitName = {"Hearts", "Diaminds", "Spades", "Clubs"};
    
    private static String[] cardName = {"Ace", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine", "Ten", "Jack", "Queen", "King"};
    
    private int myNum;
    /** Creates a new instance of Card */
    public Card(int i) {
        //I should ensure than i is between 0 and 51
        
        myNum = i;
        
    }
    
    public String getSuit() {
        return suitName[(int)Math.floor(myNum/cardName.length)];
    }
    
    public String getName() {
        return cardName[myNum%cardName.length];
    }
    
    public String toString() {
        return this.getName() + " of " + this.getSuit();
    }
    
    public int getValue() {
        int v = myNum%cardName.length;
        
        if(v == 0) {
            return 11;
        }
        else if(v>10) {
            return 10;
        }
        else {
            return v+1;
        }
    }
    
    public boolean isAce() {
        if(this.getValue() == 11) {
            return true;
        } else {
            return false;
        }
    }
    
    public boolean isTen() {
        if(this.getValue() == 10) {
            return true;
        } else {
            return false;
        }
    }
}
