/*
 * Game.java
 *
 * Created on November 9, 2006, 2:15 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package blackjacksimulator;

import java.util.Vector;
/**
 *
 * @author 511412
 */
public class Game {
    
    private int numDecks = 6; // Number of decks in the Shoe
    private Dealer myDealer; // The dealer to be used
    private Vector myPlayers = new Vector();
    private int numMatches = 0;  //Keeps track of the number of matches
    private Shoe myShoe;
    private int rounds = 0;
    private double winPayout = 2;
    private double BJPayout = 2.5;
    
    //I may want to put something in here for game stats.
    
    /** Creates a new instance of Game */
    public Game() {
    }
    
    public void setDecks(int i) {
        numDecks = i;
    }
    
    public void setNumberOfRounds(int r) {
        rounds = r;
    }
    
    public void addDealer(Dealer d) {
        myDealer = d;
    }
    
    public void addPlayer(Player p) {
        myPlayers.add(p);
        System.out.println("Player added");
        System.out.println("Size of Players is "+myPlayers.size());
    }
    
    public void addPlayers(Vector vP) {
        myPlayers.addAll(vP);
    }
    
    public void pushForBlackjack(Vector players) {
        int size = players.size();
        for(int i=0;i<size;i++) {
            Player p = (Player) players.get(i);
            if(p.hasBlackJack()) {
                System.out.println("Both the dealer and the player have blackjack");
                p.push();
            }
        }
    }
    
    private void runHitStayDoubleSplitAll(Vector players) {
        int size = players.size();
        for(int i = 0; i < size; i++) {
            Player p = (Player) myPlayers.get(i);
            runHitStayDoubleSplit(p);
        }
    }
    
    private void runHitStayDoubleSplit(Player p) {
        if(p.getMove() == Player.SPLIT) {
            //Do the split thing
        }
        if(p.getMove() == Player.DOUBLEDOWN) {
            System.out.println("Doubledown");
            p.doubledown();
            p.addCard(myShoe.getCard());
        } else {
            while((p.getMove() == Player.HIT)) {
                p.addCard(myShoe.getCard());
            }
        }
    }
    
    private void payPlayers(Dealer d, Vector players) {
        int size = players.size();
        for(int i = 0;i < size; i++) {
            Player p = (Player) players.get(i);
            if(!p.isBusted()) {
                if(d.isBusted()) {
                    if(p.hasBlackJack()) {
                        System.out.println("Player Wins:  Dealer Buser & Blackjack");
                        p.winBlackjack();
                    } else {
                        System.out.println("Player Wins:  Dealer Busted");
                        p.winRegular();
                    }
                } else {
                    int dHand = d.getHandValue();
                    int pHand = p.getHandValue();
                    if(pHand > dHand) {
                        System.out.println("Player Wins:  Beats Dealer#1");
                        p.winRegular();
                    }
                    if(pHand == dHand) {
                        System.out.println("Player and Dealer Tie");
                        p.push();
                    }
                }
            }
        }
    }
    
    public void runGame() {
        
        //Add the dealer to the players
        int numberOfPlayers = myPlayers.size();
        for(int i = 0;i<numberOfPlayers;i++) {
            Player p = (Player) myPlayers.get(i);
            p.addDealer(myDealer);
        }
        //Create a new Shoe;
        myShoe = new Shoe(numDecks);
        //Play until the number of rounds is complete
        for(int games=1;games<rounds+1;games++) {
            
            //Print the amount for each player
            String output = "";
            for(int i = 0; i<numberOfPlayers;i++) {
                Player p = (Player) myPlayers.get(i);
                output += p.getMoney() + "\t";
            }
            System.out.println(games + "\t"+output);
            
            //Check to see if we need to redeal the Shoe
            //System.out.println("Shoe Size is: " + myShoe.getSize());
            if(myShoe.getSize() < 52) {//I may want to have a more robust redeal rule.
                myShoe = new Shoe(numDecks);
            }
            
            //Reset the Dealer
            myDealer.newHand();
            
            //Get the bets from the players
            for(int i = 0; i<numberOfPlayers; i++){
                Player p = (Player) myPlayers.get(i);
                p.newHand();
                p.makeBet();
            }
            
            //Deal two cards to the dealer
            myDealer.addFirstTwoCards(myShoe.getCard(),myShoe.getCard());
            
            //Deal two cards to every player
            for(int i = 0; i<numberOfPlayers; i++) {
                Player p = (Player) myPlayers.get(i);
                p.addFirstTwoCards(myShoe.getCard(),myShoe.getCard());
            }
            //Check if dealer has blackjack
            if(myDealer.hasBlackJack()) {
                System.out.println("Dealer has Blackjack");
                this.pushForBlackjack(myPlayers);
            } else {
                this.runHitStayDoubleSplitAll(myPlayers);
                for(int i = 0;i<numberOfPlayers;i++) {
                    String handOutput = ((Player) myPlayers.get(i)).getHand();
                    System.out.println("Player["+i+"]: "+handOutput);
                }
                this.runHitStayDoubleSplit(myDealer);
                String dealerHandOutput = myDealer.getHand();
                System.out.println("Dealer: "+dealerHandOutput);
                this.payPlayers(myDealer,myPlayers);
            }
        }
    }
}
