/*
 * Hand.java
 *
 * Created on December 5, 2006, 12:27 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package blackjacksimulator;
import java.util.Vector;
/**
 *
 * @author 511412
 */
public class Hand {
    
    private Vector cards;
    private boolean isBlackjack;
    private Card firstCard;
    private Card secondCard;
    
    /** Creates a new instance of Hand */
    public Hand() {
        cards = new Vector();
    }
    
    public void addCard(Card c) {
        cards.add(c);
    }
    
    public void addFirstTwoCards(Card c1, Card c2) {
        this.addCard(c1);
        this.addCard(c2);
        if((c1.isAce()&&c2.isTen())||(c1.isTen()&&c2.isAce())) {
            isBlackjack = true;
        }
        firstCard = c1;
        secondCard = c2;
    }
    
    public Card getFirstCard() {
        return firstCard;
    }
    
    public Card getSecondCard() {
        return secondCard;
    }
    
    public int getlength() {
        return cards.size();
    }
    
    public int getValue() {
        int total = 0;
        int numberOfAces = 0;
        int value;
        int size = cards.size();
        for(int i = 0; i < size; i++) {
            value = ((Card) cards.get(i)).getValue();
            if(value == 11) {
                numberOfAces++;
            }
            total += value;
        }
        while((total > 21) && (numberOfAces>0)) {
            numberOfAces--;
            total -= 10;
        }
        return total;
    }
    
    public String getHand() {
        String output = "";
        int size = cards.size();
        output += "(" + this.getValue() +")";
        for(int i = 0; i < size; i++) {
            Card c = (Card) cards.get(i);
            output += ", " + c.toString();
        }
        return output;
    }
}
