/*
 * Player.java
 *
 * Created on November 7, 2006, 3:36 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package blackjacksimulator;

import java.util.Vector;

/**
 *
 * @author 511412
 */
public class Player {
    
    public static int HIT = 1;
    public static int STAY = 2;
    public static int SPLIT = 4; //This should be =3;
    public static int DOUBLEDOWN = 4;
    public static int BASICBET = 10;
    
    protected Vector hand = new Vector();
    
    protected Dealer myDealer;
    private int money;
    private boolean hasBlackjack = false;
    private boolean aceSomething = false;
    private boolean doubles = false;
    private String name = "";
    private Shoe myShoe;
    private int currentBet = 0;
    
    
    /** Creates a new instance of Player */
    public Player() {
        money = 1000;
    }
    
    public void setName(String n) {
        name = n;
    }
    
    public String getName() {
        return name;
    }
    
    public Player(int m) {
        money = m;
    }
    
    public int getMoney() {
        return money;
    }
    
    public int makeBet() {
        if(money < BASICBET) {
            currentBet = 0;
        } else {
            currentBet = BASICBET;
        }
        money -= currentBet;
        return currentBet;
    }
    
    public void doubledown() {
        money -= currentBet;
        currentBet += currentBet;
    }
    
    public void push() {
        money += currentBet;
    }
    
    public void winRegular() {
        money += 2*currentBet;
    }
    
    public void winBlackjack() {
        money += (int) 2.5*currentBet;
    }
    
    public void addShoe(Shoe s) {
        myShoe = s;
    }
    
    public int getMove(){
        //This is where I implement the strategy.
        if(this.getHandValue()<17) {
            return Player.HIT;
        } else {
            return Player.STAY;
        }
    }
    
    public void addDealer(Dealer d){
        //This is a refernce back to the dealer so you can
        //see what his hand is
        myDealer = d;
    }
    
    public int getHandValue(){
        //Need to upgrade to deal with aces.
        int total = 0;
        int numberOfAces = 0;
        int value;
        int size = hand.size();
        for(int i=0;i<size;i++) {
            value = ((Card)hand.get(i)).getValue();
            if(value == 11) {
                numberOfAces++;
            }
            total += value;
        }
        while((total > 21) && (numberOfAces>0)) {
            numberOfAces--;
            total -= 10;
        }
        return total;
    }
    
    public String getHand() {
        String output = "";
        int size = hand.size();
        output += "(" + this.getHandValue() +")";
        for(int i=0;i<size;i++) {
            Card c = (Card) hand.get(i);
            output += ", " + c.toString();
        }
        return output;
    }
    public boolean isBusted() {
        if(this.getHandValue()>21) {
            return true;
        }
        return false;
    }
    
    public void addCard(Card c) {
        hand.add(c);
    }
    
    public int numOfCards() {
        return hand.size();
    }
    
    public void addFirstTwoCards(Card c1, Card c2) {
        //Here is where I can see if I have blackjack on the 1st two cards
        this.addCard(c1);
        this.addCard(c2);
        if((c1.isAce()&&c2.isTen())||(c1.isTen()&&c2.isAce())) {
            hasBlackjack = true;
            aceSomething = true;
        }
        if(c1.isAce() || c2.isAce()) {
            aceSomething = true;
        }
        if(c1.getValue() == c2.getValue()) {
            doubles = true;
        }
    }
    
    public boolean aceSomething() {
        return aceSomething;
    }
    
    public boolean doubles() {
        return doubles;
    }
    
    public void newHand() {
        hand.removeAllElements();
        hasBlackjack = false;
        aceSomething = false;
        doubles = false;
        currentBet = 0;
    }
    
    public boolean hasBlackJack() {
        return hasBlackjack;
    }
}
