/*
 * newPlayer.java
 *
 * Created on December 5, 2006, 12:48 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package blackjacksimulator;
import java.util.Vector;
/**
 *
 * @author 511412
 */
public class newPlayer {
    
    public static int HIT = 1;
    public static int STAY = 2;
    public static int DOUBLEDOWN = 3;
    public static int SPLIT = 4;
    
    public static int BASICBET = 10;
    
    private Vector hands;
    private Shoe myShoe;
    
    private int money;
    
    /** Creates a new instance of newPlayer */
    public newPlayer() {
        hands;
        money = 1000;
    }
    
    public int getMoney() {
        return money;
    }
    
    public void addShoe(Shoe s) {
        myShoe = s;
    }
    
    public int getMove(PlayerHand h) {
        if(h.getValue() < 17) {
            return newPlayer.HIT;
        } else {
            return newPlayer.STAY;
        }
    }
    
    public void runRound() {
        hands = new Vector();
        PlayerHand mainHand = new PlayerHand();
        mainHand.addFirstTwoCards(myShoe.getCard(),myShoe.getCard());
        mainHand.addBet(newPlayer.BASICBET);
        money -= newPlayer.BASICBET;
        hands.add(mainHand);
        runHelper(mainHand);
    }
    
    public void runHelper(PlayerHand h) {
        int move = getMove(h);
        if(move == newPlayer.SPLIT) {
            //Do the split thing
            Card c1 = h.getFirstCard();
            Card c2 = h.getSecondCard();
            int bet = h.getBet();
            PlayerHand newHand1 = new PlayerHand();
            PlayerHand newHand2 = new PlayerHand();
            newHand1.addFirstTwoCards(c1,myShoe.getCard());
            newHand2.addFirstTwoCards(c2,myShoe.getCard());
            newHand1.addBet(bet);
            newHand2.addBet(bet);
            money -= bet;
            h=newHand1;
            hands.add(newHand2);
            runHelper(newHand1);
            runHelper(newHand2);
        }
        if(move == newPlayer.DOUBLEDOWN) {
            int bet = h.getBet();
            h.addCard(myShoe.getCard());
            h.addBet(2*bet);
            money -= bet;
        }
        if(move == newPlayer.HIT) {
            while(move == newPlayer.HIT) {
                h.addCard(myShoe.getCard());
                move = getMove(h);
            }
        }
    }
    
    public void payout(newDealer d) {
        int numberOfHands = hands.size();
        for(int i = 0; i < numberOfHands; i++) {
            makePayout(d,(PlayerHand)hands.get(i));
        }
    }
    
    private void makePayout(newDealer d, PlayerHand h) {
        int bet = h.getBet();
        if(!h.isBusted()) {
            if(d.isBusted()) {
                if(h.hasBlackJack()) {
                    money += (int) 2.5*bet;
                } else {
                    money += 2*bet;
                }
            } else {
                int dHand = d.getHandValue();
                int pHand = h.getValue();
                if(pHand > dHand) {
                    System.out.println("Player Wins:  Beats Dealer#1");
                    money += 2*bet;
                }
                if(pHand == dHand) {
                    money += bet;
                }
            }
        }
    }
}
