(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    297118,       7365]
NotebookOptionsPosition[    283524,       6963]
NotebookOutlinePosition[    286121,       7024]
CellTagsIndexPosition[    286078,       7021]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["EquilibriumLimitOrders", "Title"],

Cell[TextData[{
 "Empirical Market Microstructure\nCompanion ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebooks\n\nJoel Hasbrouck\nJanuary, 2007"
}], "Subtitle"],

Cell["\<\
This notebook covers the Parlour (1998) model, discussed in section 12.2.\
\>", "Subtitle"],

Cell[CellGroupData[{

Cell["Initializations", "Section"],

Cell[BoxData[
 RowBox[{"<<", "BarCharts`"}]], "Input",
 CellChangeTimes->{{3.3896343569012003`*^9, 3.3896343625341997`*^9}},
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"<<", "Notation`"}]], "Input",
 CellChangeTimes->{{3.3896337686252003`*^9, 3.3896337713002*^9}},
 CellLabel->"In[2]:="],

Cell["\<\
The following commands define symbolizations that are convenient for labeling \
things.\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["Anything_", "Rule"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";", 
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["Anything_", "Rules"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["Anything_", "Solution"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";", 
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["Anything_", "Solutions"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";"}]}], "Input",
 CellLabel->"In[3]:="],

Cell[CellGroupData[{

Cell["Notations specific to this notebook", "Subsection"],

Cell["These conform to Parlour's usage as much as possible.", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SuperscriptBox["n", "B"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SuperscriptBox["n", "A"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubsuperscriptBox["n", "t", "B"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubsuperscriptBox["n", "t", "A"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubsuperscriptBox["n", 
     RowBox[{"t", "+", "1"}], "B"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubsuperscriptBox["n", 
     RowBox[{"t", "+", "1"}], "A"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubsuperscriptBox["n", 
     RowBox[{"t", "-", "1"}], "B"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubsuperscriptBox["n", 
     RowBox[{"t", "-", "1"}], "A"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SuperscriptBox["N", "b"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SuperscriptBox["N", "s"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";"}]}], "Input",
 CellLabel->"In[5]:="],

Cell["\<\
Probability that between t and T there will be at least Nb market buy orders \
(or Ns market sell orders):\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Notation", "[", 
   RowBox[{
    TagBox[
     RowBox[{
      SuperscriptBox["r", "b"], "[", 
      RowBox[{"t_", ",", "nB_", ",", "nA_", ",", "Nb_"}], "]"}],
     NotationBoxTag,
     BaseStyle->"NotationTemplateStyle"], " ", "\[DoubleLongLeftRightArrow]", 
    " ", 
    TagBox[
     RowBox[{"rb", "[", 
      RowBox[{"t_", ",", "nB_", ",", "nA_", ",", "Nb_"}], "]"}],
     NotationBoxTag,
     BaseStyle->"NotationTemplateStyle"]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Notation", "[", 
   RowBox[{
    TagBox[
     RowBox[{
      SuperscriptBox["r", "s"], "[", 
      RowBox[{"t_", ",", "nB_", ",", "nA_", ",", "Ns_"}], "]"}],
     NotationBoxTag,
     BaseStyle->"NotationTemplateStyle"], " ", "\[DoubleLongLeftRightArrow]", 
    " ", 
    TagBox[
     RowBox[{"rs", "[", 
      RowBox[{"t_", ",", "nB_", ",", "nA_", ",", "Ns_"}], "]"}],
     NotationBoxTag,
     BaseStyle->"NotationTemplateStyle"]}], "]"}], ";"}]}], "Input",
 CellLabel->"In[15]:="],

Cell["\<\
Probability that a limit buy order added at time t will execute.\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Notation", "[", 
   RowBox[{
    TagBox[
     RowBox[{
      SuperscriptBox["p", "b"], "[", 
      RowBox[{"t_", ",", "nB_", ",", "nA_"}], "]"}],
     NotationBoxTag,
     BaseStyle->"NotationTemplateStyle"], " ", "\[DoubleLongLeftRightArrow]", 
    " ", 
    TagBox[
     RowBox[{"pb", "[", 
      RowBox[{"t_", ",", "nB_", ",", "nA_"}], "]"}],
     NotationBoxTag,
     BaseStyle->"NotationTemplateStyle"]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Notation", "[", 
   RowBox[{
    TagBox[
     RowBox[{
      SuperscriptBox["p", "s"], "[", 
      RowBox[{"t_", ",", "nB_", ",", "nA_"}], "]"}],
     NotationBoxTag,
     BaseStyle->"NotationTemplateStyle"], " ", "\[DoubleLongLeftRightArrow]", 
    " ", 
    TagBox[
     RowBox[{"ps", "[", 
      RowBox[{"t_", ",", "nB_", ",", "nA_"}], "]"}],
     NotationBoxTag,
     BaseStyle->"NotationTemplateStyle"]}], "]"}], ";"}]}], "Input",
 CellLabel->"In[17]:="],

Cell["Other constants and functions", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    OverscriptBox["\[Beta]", "_"],
    "NotationTemplateTag"], "]"}], ";", 
  RowBox[{"Symbolize", "[", 
   TagBox[
    UnderscriptBox["\[Beta]", "_"],
    "NotationTemplateTag"], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.389694197401224*^9, 3.389694252133224*^9}},
 CellLabel->"In[19]:="],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Notation", "[", 
   RowBox[{
    TagBox[
     RowBox[{
      SubscriptBox["F", "\[Beta]"], "[", "\[Beta]_", "]"}],
     NotationBoxTag,
     BaseStyle->"NotationTemplateStyle"], " ", "\[DoubleLongLeftRightArrow]", 
    " ", 
    TagBox[
     RowBox[{"F\[Beta]", "[", "\[Beta]_", "]"}],
     NotationBoxTag,
     BaseStyle->"NotationTemplateStyle"]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["F", 
     RowBox[{"\[Beta]", " ", "Rule"}]],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.3896942641502237`*^9, 3.389694265445224*^9}},
 CellLabel->"In[20]:="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\[Beta] Distributions", "Section"],

Cell["\<\
This section defines the \[Beta] distributions. Parlour uses only the \
uniform; the presentation also uses triangular and inverse triangular (\"wing\
\") distributions\
\>", "Text"],

Cell[CellGroupData[{

Cell["Uniform", "Subsubsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"d", "=", "1"}], ";", 
  RowBox[{
   UnderscriptBox["\[Beta]", "_"], "=", 
   RowBox[{"1", "-", "d"}]}], ";", 
  RowBox[{
   OverscriptBox["\[Beta]", "_"], "=", 
   RowBox[{"1", "+", "d"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["F", 
    RowBox[{"\[Beta]", " ", "Uniform"}]], "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["F", "\[Beta]"], "[", "\[Beta]_", "]"}], "\[RuleDelayed]", 
    RowBox[{"CDF", "[", 
     RowBox[{
      RowBox[{"UniformDistribution", "[", 
       RowBox[{"{", 
        RowBox[{
         UnderscriptBox["\[Beta]", "_"], ",", 
         OverscriptBox["\[Beta]", "_"]}], "}"}], "]"}], ",", "\[Beta]"}], 
     "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.3896338724952*^9, 3.3896338755722*^9}},
 CellLabel->"In[22]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inverse Triangular (\"Wing\")", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   UnderscriptBox["\[Beta]", "_"], "=", "0"}], ";", 
  RowBox[{
   OverscriptBox["\[Beta]", "_"], "=", "2"}], ";"}]], "Input",
 CellLabel->"In[24]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"x", "-", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[25]:="],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw11Xs01OkfB3Dj8ktpJ+RyxqUyYQuhsvyo9j3Fpgsi0lRC5BIqa6eNdjdD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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 2}, {0., 0.9999999591836735}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.3896338013272*^9, 3.3896344132268*^9, 3.3896352758606*^9,
   3.3896354107860003`*^9, 3.389635547362*^9, 3.389659019419424*^9, 
  3.389659064108424*^9, 3.3896940438742237`*^9, 3.389694303104024*^9},
 CellLabel->"Out[25]=",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"x", "-", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "X"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"X", ">", "0"}], ",", 
      RowBox[{"X", "<", "2"}], ",", 
      RowBox[{"X", "\[Element]", "Reals"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[26]:="],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "X"}], "-", 
        SuperscriptBox["X", "2"]}], ")"}]}], 
     RowBox[{"0", "<", "X", "\[LessEqual]", "1"}]},
    {
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"2", "-", 
        RowBox[{"2", " ", "X"}], "+", 
        SuperscriptBox["X", "2"]}], ")"}]}], 
     TagBox["True",
      "PiecewiseDefault",
      AutoDelete->False,
      DeletionWarning->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output",
 CellChangeTimes->{3.3896338017192*^9, 3.3896344136387997`*^9, 
  3.3896352762876*^9, 3.389635411177*^9, 3.389635547767*^9, 
  3.389659021474424*^9, 3.389659064464424*^9, 3.389694044555224*^9, 
  3.389694303493024*^9},
 CellLabel->"Out[26]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["F", 
    RowBox[{"\[Beta]", " ", "Wing"}]], "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["F", "\[Beta]"], "[", "\[Beta]_", "]"}], "\[RuleDelayed]", 
    RowBox[{"Which", "[", 
     RowBox[{
      RowBox[{"\[Beta]", "\[LessEqual]", "0"}], ",", "0", ",", 
      RowBox[{"0", "<", "\[Beta]", "\[LessEqual]", "1"}], ",", 
      RowBox[{"\[Beta]", "-", 
       RowBox[{
        SuperscriptBox["\[Beta]", "2"], "/", "2"}]}], ",", 
      RowBox[{"1", "<", "\[Beta]", "<", "2"}], ",", 
      RowBox[{"1", "-", "\[Beta]", "+", 
       RowBox[{
        SuperscriptBox["\[Beta]", "2"], "/", "2"}]}], ",", 
      RowBox[{"\[Beta]", "\[GreaterEqual]", "2"}], ",", "1"}], "]"}]}]}], 
  ";"}]], "Input",
 CellLabel->"In[27]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["F", "\[Beta]"], "[", "x", "]"}], "/.", 
     "\[InvisibleSpace]", 
     SubscriptBox["F", 
      RowBox[{"\[Beta]", " ", "Wing"}]]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[28]:="],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nk4VV0bBnA0EEVkiAYZk5SS0ujuldKk8kUkQ0miJKRXlKgoMqSSCCWk
QmQoUaIMlTKlNHH2znRM5+x9CJm/9f61rt+117X3utfzXGsvFYeT/zsiIiQk
NEtYSOi/cfuRjrqSziOG44+OVv43Tt6k5E4pGkPI6qbDjtnGWHEvJj5X0Rym
V3ddC5U3x46qbzkJio5Q3iWaajrLEZaOg0U3FL1gO0Upp3e6F5p0r2wKVwzE
I4nINaZCgUiU2335qmIU1BzVA8S5N3FBLHdhiGIKZqxTWRSSlwyr/fezWEEe
oowcIm7L50Fi4oKNyfxi5HlzeUpri6Bhxu8oDS3DqL7+eGLbW3hXr0HMnw+o
9jSt7fjfOyjkSXOEhWvwI22zSyk+4nnzpk816z+jsN2et8ykBm+PJczZ3/MF
/jZaP98H1KFfc4PUkxPfEL9hTmurWj1EhtJnztH4CYfitXvGqr5g1cTB53sz
G7H777s0lX8a8ClQv7pCm0LpcOoqoahvUI7sHnrMp5G/YKL/Gfc7ugcpztdl
zWD76uLcxX8ipetlpWREC3yjjh3q1/oFyXkPmdbWVtgcEzq5RaMRYS7PnBLV
23Fss6Z54UAjBjamtzr7c3HOPft5VlETXqV0x3kHcjGsotttV9KEi2I6ey+H
cGH51vXy9NImSNZmvEm+yUVGzUKBw/smaNpn3uU85OL13ITbo5+bsM8v28q8
louQgECtFm4TnhXkf4JKBwrdtlj7zeTAS68sT760A8Ft0WNtNhw46S9IvP6+
A/Z1C7Pt7TmwWnUudHp1B/r2rAz8doiDdWv1HUR+dMBcoiL4jRMHIkYpUnx+
B/66vpbwd+fgmlngsXKlTlS2iA/du8RBmrvxAi/PTty+J+Ph84iDeM9ECca7
E8qTVsnmp3EQ7jU64OLXCcfhrw29GRy4n8mrsg/uxMKU0ELHbA4MAtTP7rjb
ieutVSPLCzkouza5QbWyE/zZmUc8P3JAZZaF1ql0oWZ3U8PVHg5qeZN79BZ2
oTpQWvYSn4MSnc07o3S6YMnOvujDcpCYVj7d0qAL4sfvswf/cOCQWhHeuLML
DD9GQWmUg/aE99e43l0oWKYavlKCAi/s082xqi7sik+Ql9aiwPk4/Y9dfReS
kla71SyiUC1ual7yvQsXqNSB0MUUMoOrZC+1dIEzOho7sZSCe2D1LbGhLsyu
uKZdt5LCn7O1t2epdyPixu5T8zZRGDn2JW6RbzfOzFqdbG1DwXyV7fWl/t2I
C74yq9yWQoZw++UVgd14O/6SXWJPwS5m0GNDRDeU+fWC4UMU3pQrbTVL6sbM
H8WSF49SuLLg0J8zld2ooq7kGntSmNXA2/leqQe5T78/irtMwfX+v0ZVyj1w
3vL+Wf0VCmWuEwaf1Xug2hSvKx5C4d9J0mqNS3uQPKPfxTOUwo9l+kOMUQ8a
fQ8N6UZSuBfq+0DheA+0L2tfso+lsPgf0XGnlz3QO+hnFJlG4Wla+sLvJT3g
VVg3p6dT0JfdY7atogcmlbaPyjMorOfGpCyu68GP1C+pfZkUdoVr72Dbe3A6
P+jEmlwKnj9MY3xkeLi2ql/F9SWFAaPeN10KPOCojvqxVxTOZkR3H5hHnuuH
7HQqohDoTxkaavEw/UGu1P5iCtEaHm0ihjz4N3201yqlUOARpRfmwsOWjGkL
3SopGP5abTPmxkNP6p3QXR8pvDVuCnLz4mG5oZn8kk8UKhU0f+zx5yHWSPdu
axWFxqJ8f7lbPDQnZXpvqKMgJP7r090SHva9KTSL/kbBJEnlaLYCH8WnxZJa
m0neGEnNirl8WBvpt51vobAgYqT1pwofD76Yhiq0Uhj2+eowWYePbdu3Cxm3
UXhiFmJnuZGPKh/n8BAuqZewwGLMmY+3nWv033WT7w02ycq48WEpbZRq0kOh
p6eyXvMUH3HjBmcriCu+p5jt8eNjhTbPtJhHweeplWnydT4Sys9FJzAUKPsS
422FfBycsTxveh+FTxZPJtkV88Fck7M4Rfxix523nmV8LPnOtfpOfMPAa2N8
NR8vCixCEv5Q2CyltZ5p5mPam33hsgMU9KbIjUzq4EPO4/FmN+L5I8KFs3l8
1LZ3Hqwg/tv+y8BokA8LNf0Sj0EK6a+vrbglweAOzVN59pdCTN653sczGai+
zhQID5H6pblkv5ZjYH3IVt2U2C56k26HMoMffy/lcIil3Qa11+kzkHYd8OAP
Uxg/3Nq5ew0DeW+N/UtHKHTtr3vkaMjgo4lRsitx2eZ0zYitDIzXbj7YSuw9
z171tw0D98PufiWjFBz2LNvXeIjBfLt0/17iXZeEr35zYvA+qPWP6hgFzc5k
QZU7A0kbs9X+xDJzT2t8OM3gsXjQ1HTisV1b9pf5MkD7c5OvxF/yOkoKAxnY
qsupaYxTKOEW/HkWwqDt8j9F24nTlUK1siMYOMu7VroRXwxYEvkwhoH9q5cb
cojdcsdLkxIY1H+mk+uI97fXDCYkMTCSn+zHEC/b6WkflcFARn1zsOYEhbn+
m25ey2Zwiu9QCGLRHNl3V58zqG47b29J3NvaNhz0koGGeKz3CWKOQv7SCyUM
vA9ki1wkrtwe7HCunEHZj3dCt4if+e2P9q5kMD2o0SOVOPGpdqVnDYM9tozF
c+KwlpGxE18YRDgIPSkjPiNftdzlB4N3UVLedcSHt9094shhMNo3N6+ReNe5
k7H2LQx0ArQc24nXZm2ssu5gsG+N3hU+sWaztPA+HoNzymvn9RNLy7Xom/Uy
SNDbqDlMPGqS57xzkEGhp3HSGHGHb1C8ySiDOmrL9Qnirn2Lne8LsZDcZDNV
SIjGQXaWiPIkFsFUY9x/bggZjYufwuLSEc6gMPEOtbaVSmIsRL4eVJpMXPKq
qua2OPFSx0mixKv2PXeRm8EiyL0jR5w4g7k76aYUi9B4npYUsWrIlYSZMixm
5Zw6Iksco+puECHLYl62r7MSseQrqzoJBRZpsSJ6KsSBFv8cD1FkUXBc4q0W
8RB/0RTRuSx2LLw1ezmxW7DMvcD5LOw/3Vu5lrhVZWS1iAqLAevFisbEteaf
XMc0yPv0y1dYE2/h5009q8XivX/9MSfiV1cSEv9qs3DOc3A+Rfyw0O1Lny6L
ZT8n5V8jnmtu6eahx8Lqo5zYPeIbPIgx+iRv6iPlLOLzC6TXd61hSV+YJdUR
/ykY+np0PQupLKcZrcTH9jafbDNkUao7ZjhIbHE5N5nexCKXl9GvLExDp8dC
4pspi8wDCtm+xC/MdxZf3cNCTUvH/RbxpiKjU4Z7WTBR1OxsYusI3V8PrFiE
71Zd2E0csmxautdhFs1bFQyOidCQjZ2w03JiITNbZVMYcaLwgEyjM4vYKx9W
ZxG/+Nzsu8mNxROTAXqQuN3r1XYZHxa8HcXqUZNoeDbljJefZfF93mu/IuKx
zY9zfM6zUIo8UMIlllWIVvp9iUWyhacIJpP1FZzsyopgUeMo5fuXOHFM9app
CouQm6IGt6eSfE6KhsIPWXQeYxfVEOdXS/XmPWZxv9l7qpgojep7o/vnZrGQ
z3U4d4547J+GRd0FLBS/PzzgLkbyXg75EFzD4oIey70kTtbL9/db/5mFpVSp
VyWxh+W/y9kvLALD9LulJWgEax2OtfzJou1oX1Qy8fPK9S6abSxKkuhfddNp
zJJixcqGWTRo+RhYS9H4XHT1yrYxFsInnqY+Jr7hqjG1ZoLs923r30PEMpXW
k35OFkAmSbQgfiZxUPkYIymAx5UyQbc0jZkjd3rnqAkQHf0h+Kks6bfHKz3u
awjQukU3a7ocjUirWkZTS4D+JtH7LsRSz6fwli8RwKZEmqshT/rdw51rYiDA
5n3Bow8VaEznbm48tUMAvwoh089KND7doq2HTAXgN0dpr5tDI8z47I/zewRQ
aY+rTyGWSHraEGIhQFWiSLDvXBritnPq7tkLAK6er+58GmL1bPnHUwJcfTE/
sFiFxuTiuCy1eAFeu6otPbOIxs/1xlupuwKIvBQ9OUWbRlZhD33nvgBpLty7
N4mtn2+QkXkowKKOmI85i2lkP6G8hHJIPpcyq9ElNOzi1dY2vRNga8AGo1d6
pL980sui+wT48DffjFlPI2Jwr+3/BgRI3yvmeWcDjcOnR/tnDAnQK2l+YYvh
f/lNFwaNC5CV2uR6HzSOODMhp6b1os26wNvBiOy35Yrde5R7gYYbNtJbaRzX
f/lj2o5eZMyudlA1J+dP7deMF6a9SAsTe8YlljvB+h/d04tikVjeEwsaxQ80
NMsterG4/6X0BktSf4VIz4CDvZDqm6bpZE3j5ZCjxODpXkzbW3G+5SDZz2LJ
Da2JvShKLmGvutFI3+aQ+HqgF9rBLxvCwmjo66gYYqgXpTPYSN9wGq8l6V/F
I72oW3VllksEqX+9rcIboT5sPdXksTWSnAe2+yNKxfuQemvRzZlRNAw995x7
P78PGgEbnSviyPw7hlaft/RhcY+zzft0Gv3dSjPbo/tgvSDFVaOaRlQC9118
bB+Sdzrdtq2hsWJ3nv/e+D48uFP3JLqW9H+OKVNyvw9f45ITJOpp8M4EVMdl
9KFFb2WI0HcabVPaw8ze9iE/VzJSvpnGV+XsaUW8PmwQirPpG6DxbK/JpCjj
P6gsmy04qfYb/luD7uW1/8F1bjJtFfAbKk3bvycH9UPP59H9Zu5vrDUIjFLU
G4DxNlepZU7NsJlfMyRcP4DRHWewoLMZ/ZXhze4XBrH1aUL//qAWxEy28/qf
+l+8vi3TmaLeilmcZ0kiZX/xN29ry+GqVkzxu2C+xmMIgUWPCi7caIPQY7us
ZplhsCGfHmRbtsPzTla4zNthqHLnrviwjouixcFi0m4jSMkUid6p3QHp7Z46
FyVH8X1b/LFauU40Lqmt93k1ikT/bayDWhee3oV6q90YqvdtCTii0w3brFXS
88bH8HTFTIXc9T0ICLp/oTFtHB1G586pevLwpGNenOTOCRROecibnMiHmbTk
6nfDE1gd56Ae2c/g6hSROY3E/z4tbSwgLhvqH2OJ75oeuNVCvKq5qVRpZAKZ
yktFDQYYKOU+2e1GXKHqwGsibjY3PSo3OgE6ZVLZ4r8MvGLCog+PTaAsRufO
u2EGT8ICfM4Qb0232y8gbg/wsgknfrH53ew5IwysXGxU84nNZdbHuBFvWKuT
KT4+gaviebFy5L8+tfFjeTYx/W9T6uExcq+qLX5UQSwudsYlnPhMWW7oL+K5
Ktt08om7MuLMpkxMQKg7Ikd8nNx7/I43WRG/bXr0JptY1NO+5ASxYeZg0C/i
jU57ky8SJ0312z5lgkHOrnUuGcTauxd/sSLuNtLd+YZ4J8xjLxKrG6jpNhBb
5+faZRDbLVaQ6SY2z9+m3kB8W1mif4J4FeS7Joj/D0kv89I=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.3896338017622004`*^9, 3.3896344136868*^9, 
  3.3896352763346*^9, 3.389635411224*^9, 3.3896355478450003`*^9, 
  3.389659021617424*^9, 3.389659064504424*^9, 3.389694044655224*^9, 
  3.389694303540024*^9},
 CellLabel->"Out[28]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Triangular", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   UnderscriptBox["\[Beta]", "_"], "=", "0"}], ";", 
  RowBox[{
   OverscriptBox["\[Beta]", "_"], "=", "2"}], ";"}]], "Input",
 CellLabel->"In[29]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{"Abs", "[", 
     RowBox[{"x", "-", "1"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[30]:="],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxF1Xk0lHsYwPGxRSmMQiMSScrcKKJFPUJNlhYM0dWQyFIkdyo5pxpFsrQj
J6op3XsTcmXIRZkyUbInylozkybb++oaGma4RnPe94/f+Tzfc54/n3N+hgHH
3IPkCQRCzMyT6hwkaGZ/D9o6M7ZIVXTQjewlOQLB8ZeW9zKyikhUIDB/6VLf
/vQOKRAIMvcFjj+/QaIDQ2a3eYLDZVIcsGUytfZcTCKlYsaqFK1MJD0Ehkxv
n/sF6AgLU3U61peytBJUZK5wGxZUJXPAWOapho2QMfoWomXqsIg9cnKNsFhm
CdehrtG2BfNV2J0lPoOtmEKTLer54e0wKlNelKuxZEUHpvW0f4nHky7Mujir
hurVvZgG1wZEOcOfMQfGe3s+WHAxH/aX16pd4WGq6f+N8Pl8zJTQ4sNM4z7M
Mbtcfsi5b5j0dRyWdpUAs/cJJ7nZsB9zMqw1c1XMAKbZNuWpw+WDmJQHhsGF
OsOYVhlqJtV6uMuuTPI7DHEnTn8IUCTj5rsl0vbZ4S6UG/GUhOD2+rEdncpw
6zzzFWiVuKUut19FcXBv2NDtshpwt6ub2iJc3NwXVy3TVBHMU/p+Rl98cQP2
Wnh1HcTdfUEuqf0wrsn37JH6SNxWloBdFodr4Rrll5qHq3fO4ebVQlzlp4tq
kkpwe3SerYll46bwJiXhrbjR2vVrQz/hHnK6GxTYg7upwK5+vwDXhEuU8xrC
JWrxrNx+4IoprBDXcVxBTHwWRYzb72UWcp+AAtk9x/z5FAL+6EJ5AwUU7Aw+
Tr4UIdCWKM7MUkKBOjjnTfUoAi7Lv67XVUEh7N/1qe8QBNgV9Y235qHAuBjo
39SPgLVXSajWAhRSPW6SP3xFwCgx4Y6GJgoVQyinpxOBDKNImyuLUGgqM7jO
a0NArcK7WVUHBX7C7gOCZgREw6uUlPVQUDPKE47UINBErTsqWYGCv1ewiRIL
AfKgp2r7LhQeraR+dwtEoJTqWpm0F4VrXsGx/TQEHJ7b/7HVA4WY+BjSBR8E
9l8x7/zTGwVXHtOJtRuBRIu5ufRDKAzfHcrR3ohAH73CWfM0ClbaCWGdCxBg
SoySdj1Ega1YNhD4bOYu1VEVzgQKHV8Mhk/NGwbFysyC5Vkj8DP2DbO0ZhCO
WJV/muvyA1bfSnQdDB2AXKcA5ouxH/D46ObK85r9IBzQ1ehL/w+0TWt7LVsE
UOxBUUh1HIV07+Oi9pPf4NzO+HusvlGQPyZkp6/rA8Nu54/Z8UJ4sT1sT+ko
HzbZxKWS1o1ByvXxtrpMHvgubRTJvR+DnVUH54t9uCCsvcyNjB0H7TD+pqWS
z5ChSKO7G/8E5lDCmpKIXljYU/xAnvMTWAmmJ4RIFyidiaVuPC6CQdWJfN3N
HUDIoRVwNSeA4Btvf4LVDlG3Cy5rvpqADenb3haPt8Jzs0sqxIhJmO/W211O
aQGicxT5vJoYogvCs4aTG6Hrt6b3pyvEsOz62YNr9Wrhn7tgzKdJgDFPoadH
5TUcKLAm6k9JYHG880kddTYw4u/Hdj2eAsKjb19t3IshX6CfqeY6Df799lnk
s3+BG1FtQ83ENBAqymoMeFRIUpJf0iXtj9/Hb16lAkcklKDSRhebqthSwZrb
XaU7OdOmpy6hqR6gW5S/J0LaGZZOL3e4A5e6K1hLLN33TntN3QP0jJT0Q5KZ
9rfNdOE5Qn4K43S0tDNuT1raOkIfg+57WdpNP3/XS3MA71Bfo2fStivWG9ph
D1s2kZ/Mm5ppC19bfU+AOV3vXhdKmwn22TwrgKbKR9XS1hDL09MsIZpTlNwp
bUZplSNlHfTnZbopTc80OyCpztMcGs4c6faWtt2Oa+58Y1CO8mOHS3tZJXGU
YgR2hz2yz0ubEGlits8Anu7eHJonbYYHufDrIhiwN3d9OdtJNIGPOhjbLDdv
m92PCIwQKALNTEdzYLYftAqGRrfeMlAVTs/2r//4fxJD3go=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 2}, {0., 0.9998460703741947}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.3896338017802*^9, 3.3896344137088003`*^9, 
  3.3896352763626003`*^9, 3.3896354112530003`*^9, 3.3896355478859997`*^9, 
  3.389659021650424*^9, 3.389659064565424*^9, 3.3896940447152243`*^9, 
  3.389694303563024*^9},
 CellLabel->"Out[30]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{"Abs", "[", 
     RowBox[{"x", "-", "1"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "X"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"X", ">", "0"}], ",", 
      RowBox[{"X", "<", "2"}], ",", 
      RowBox[{"X", "\[Element]", "Reals"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[31]:="],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {
     FractionBox[
      SuperscriptBox["X", "2"], "2"], 
     RowBox[{"0", "<", "X", "\[LessEqual]", "1"}]},
    {
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", 
        RowBox[{"4", " ", "X"}], "-", 
        SuperscriptBox["X", "2"]}], ")"}]}], 
     TagBox["True",
      "PiecewiseDefault",
      AutoDelete->False,
      DeletionWarning->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output",
 CellChangeTimes->{3.3896338019532003`*^9, 3.3896344139038*^9, 
  3.3896352765396*^9, 3.389635411433*^9, 3.389635548084*^9, 
  3.3896590218454237`*^9, 3.3896590648384237`*^9, 3.389694044938224*^9, 
  3.3896943037370243`*^9},
 CellLabel->"Out[31]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["F", 
    RowBox[{"\[Beta]", " ", "Triangular"}]], "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["F", "\[Beta]"], "[", "\[Beta]_", "]"}], "\[RuleDelayed]", 
    RowBox[{"Which", "[", 
     RowBox[{
      RowBox[{"\[Beta]", "\[LessEqual]", "0"}], ",", "0", ",", 
      RowBox[{"0", "<", "\[Beta]", "\[LessEqual]", "1"}], ",", 
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], "/", "2"}], ",", 
      RowBox[{"1", "<", "\[Beta]", "\[LessEqual]", "2"}], ",", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"2", "\[Beta]"}], "-", 
       RowBox[{
        SuperscriptBox["\[Beta]", "2"], "/", "2"}]}], ",", 
      RowBox[{"\[Beta]", ">", "2"}], ",", "1"}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[32]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["F", "\[Beta]"], "[", "x", "]"}], "/.", 
     "\[InvisibleSpace]", 
     SubscriptBox["F", 
      RowBox[{"\[Beta]", " ", "Triangular"}]]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[33]:="],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1Xk4VtsXB3BTGa8h3DI1GZokt6SRL1GZKgolMpQpFSpDE1JJiaIrufiJ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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.3896338019952*^9, 3.3896344139488*^9, 3.3896352765846*^9,
   3.389635411486*^9, 3.389635548137*^9, 3.389659021893424*^9, 
  3.389659064916424*^9, 3.3896940449912243`*^9, 3.389694303788024*^9},
 CellLabel->"Out[33]="]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Procedures to compute and analyze equilibria", "Section"],

Cell[CellGroupData[{

Cell["Compute equilibrium", "Subsection"],

Cell[BoxData[
 RowBox[{"pSetup", ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{
      "Print", "[", 
       "\"\<Clearing and resetting definitions for \
\!\(\*SuperscriptBox[\(p\), \(s\)]\) and \!\(\*SuperscriptBox[\(p\), \
\(b\)]\)...\>\"", "]"}], ";"}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ClearAll", "[", 
      RowBox[{"pb", ",", "ps"}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       SuperscriptBox["p", "s"], "[", 
       RowBox[{"t_", ",", 
        RowBox[{
         SuperscriptBox["n", "B"], ":", "_"}], ",", 
        RowBox[{
         SuperscriptBox["n", "A"], ":", "_"}]}], "]"}], ":=", 
      RowBox[{
       RowBox[{
        SuperscriptBox["p", "s"], "[", 
        RowBox[{"t", ",", 
         SuperscriptBox["n", "B"], ",", 
         SuperscriptBox["n", "A"]}], "]"}], "=", 
       RowBox[{
        SuperscriptBox["r", "b"], "[", 
        RowBox[{
         RowBox[{"t", "+", "1"}], ",", 
         SuperscriptBox["n", "B"], ",", 
         RowBox[{
          SuperscriptBox["n", "A"], "+", "1"}], ",", 
         RowBox[{
          SuperscriptBox["n", "A"], "+", "1"}]}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       SuperscriptBox["p", "b"], "[", 
       RowBox[{"t_", ",", 
        RowBox[{
         SuperscriptBox["n", "B"], ":", "_"}], ",", 
        RowBox[{
         SuperscriptBox["n", "A"], ":", "_"}]}], "]"}], ":=", 
      RowBox[{
       RowBox[{
        SuperscriptBox["p", "b"], "[", 
        RowBox[{"t", ",", 
         SuperscriptBox["n", "B"], ",", 
         SuperscriptBox["n", "A"]}], "]"}], "=", 
       RowBox[{
        SuperscriptBox["r", "s"], "[", 
        RowBox[{
         RowBox[{"t", "+", "1"}], ",", 
         RowBox[{
          SuperscriptBox["n", "B"], "+", "1"}], ",", 
         SuperscriptBox["n", "A"], ",", 
         RowBox[{
          SuperscriptBox["n", "B"], "+", "1"}]}], "]"}]}]}], ";"}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellLabel->"In[34]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Beta]Setup", ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{
       "Print", "[", 
        "\"\<Clearing and resetting definitions for \[Beta]'s...\>\"", "]"}], 
       ";"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ClearAll", "[", 
       RowBox[{
       "\[Beta]LmtSellLow", ",", "\[Beta]LmtBuyHigh", ",", 
        "\[Beta]LmtSellHigh", ",", "\[Beta]LmtBuyLow"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"\[Beta]LmtSellLow", "[", 
        RowBox[{"t_", ",", 
         RowBox[{
          SuperscriptBox["n", "B"], ":", "_"}], ",", 
         RowBox[{
          SuperscriptBox["n", "A"], ":", "_"}]}], "]"}], ":=", 
       RowBox[{
        RowBox[{"\[Beta]LmtSellLow", "[", 
         RowBox[{"t", ",", 
          SuperscriptBox["n", "B"], ",", 
          SuperscriptBox["n", "A"]}], "]"}], "=", 
        RowBox[{"Max", "[", 
         RowBox[{
          RowBox[{
           FractionBox["1", "V"], 
           RowBox[{"(", 
            RowBox[{"A", "-", 
             FractionBox["1", 
              RowBox[{"1", "-", 
               RowBox[{
                SuperscriptBox["p", "s"], "[", 
                RowBox[{"t", ",", 
                 SuperscriptBox["n", "B"], ",", 
                 SuperscriptBox["n", "A"]}], "]"}]}]]}], ")"}]}], ",", 
          UnderscriptBox["\[Beta]", "_"]}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"\[Beta]LmtBuyHigh", "[", 
        RowBox[{"t_", ",", 
         RowBox[{
          SuperscriptBox["n", "B"], ":", "_"}], ",", 
         RowBox[{
          SuperscriptBox["n", "A"], ":", "_"}]}], "]"}], ":=", 
       RowBox[{
        RowBox[{"\[Beta]LmtBuyHigh", "[", 
         RowBox[{"t", ",", 
          SuperscriptBox["n", "B"], ",", 
          SuperscriptBox["n", "A"]}], "]"}], "=", 
        RowBox[{"Min", "[", 
         RowBox[{
          RowBox[{
           FractionBox["1", "V"], 
           RowBox[{"(", 
            RowBox[{"B", "+", 
             FractionBox["1", 
              RowBox[{"1", "-", 
               RowBox[{
                SuperscriptBox["p", "b"], "[", 
                RowBox[{"t", ",", 
                 SuperscriptBox["n", "B"], ",", 
                 SuperscriptBox["n", "A"]}], "]"}]}]]}], ")"}]}], ",", 
          OverscriptBox["\[Beta]", "_"]}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"\[Beta]LmtSellHigh", "[", 
        RowBox[{"t_", ",", 
         RowBox[{
          SuperscriptBox["n", "B"], ":", "_"}], ",", 
         RowBox[{
          SuperscriptBox["n", "A"], ":", "_"}]}], "]"}], ":=", 
       RowBox[{
        RowBox[{"\[Beta]LmtSellHigh", "[", 
         RowBox[{"t", ",", 
          SuperscriptBox["n", "B"], ",", 
          SuperscriptBox["n", "A"]}], "]"}], "=", 
        RowBox[{
         FractionBox["1", "V"], 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "s"], "[", 
             RowBox[{"t", ",", 
              SuperscriptBox["n", "B"], ",", 
              SuperscriptBox["n", "A"]}], "]"}], "\[Equal]", "0"}], ",", "B", 
           ",", "A"}], "]"}]}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"\[Beta]LmtBuyLow", "[", 
        RowBox[{"t_", ",", 
         RowBox[{
          SuperscriptBox["n", "B"], ":", "_"}], ",", 
         RowBox[{
          SuperscriptBox["n", "A"], ":", "_"}]}], "]"}], ":=", 
       RowBox[{
        RowBox[{"\[Beta]LmtBuyLow", "[", 
         RowBox[{"t", ",", 
          SuperscriptBox["n", "B"], ",", 
          SuperscriptBox["n", "A"]}], "]"}], "=", 
        RowBox[{
         FractionBox["1", "V"], 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "b"], "[", 
             RowBox[{"t", ",", 
              SuperscriptBox["n", "B"], ",", 
              SuperscriptBox["n", "A"]}], "]"}], "\[Equal]", " ", "0"}], ",", 
           "A", ",", "B"}], "]"}]}]}]}], ";"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[35]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"PSetup", ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{
       "Print", "[", "\"\<Clearing and resetting definitions for P...\>\"", 
        "]"}], ";"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ClearAll", "[", "P", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"P", "[", 
        RowBox[{"t_", ",", 
         RowBox[{
          SuperscriptBox["n", "B"], ":", "_"}], ",", 
         RowBox[{
          SuperscriptBox["n", "A"], ":", "_"}], ",", "SellMkt"}], "]"}], ":=",
        
       RowBox[{
        RowBox[{"P", "[", 
         RowBox[{"t", ",", 
          SuperscriptBox["n", "B"], ",", 
          SuperscriptBox["n", "A"], ",", "SellMkt"}], "]"}], "=", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "/", "2"}], ")"}], 
         RowBox[{"Evaluate", "[", 
          RowBox[{
           RowBox[{
            SubscriptBox["F", "\[Beta]"], "[", 
            RowBox[{"\[Beta]LmtSellLow", "[", 
             RowBox[{"t", ",", 
              SuperscriptBox["n", "B"], ",", 
              SuperscriptBox["n", "A"]}], "]"}], "]"}], "/.", 
           SubscriptBox["F", 
            RowBox[{"\[Beta]", " ", "Rule"}]]}], "]"}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"P", "[", 
        RowBox[{"t_", ",", 
         RowBox[{
          SuperscriptBox["n", "B"], ":", "_"}], ",", 
         RowBox[{
          SuperscriptBox["n", "A"], ":", "_"}], ",", "SellLmt"}], "]"}], ":=",
        
       RowBox[{
        RowBox[{"P", "[", 
         RowBox[{"t", ",", 
          SuperscriptBox["n", "B"], ",", 
          SuperscriptBox["n", "A"], ",", "SellLmt"}], "]"}], "=", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "/", "2"}], ")"}], 
         RowBox[{"Evaluate", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             SubscriptBox["F", "\[Beta]"], "[", 
             RowBox[{"\[Beta]LmtSellHigh", "[", 
              RowBox[{"t", ",", 
               SuperscriptBox["n", "B"], ",", 
               SuperscriptBox["n", "A"]}], "]"}], "]"}], "-", 
            RowBox[{
             SubscriptBox["F", "\[Beta]"], "[", 
             RowBox[{"\[Beta]LmtSellLow", "[", 
              RowBox[{"t", ",", 
               SuperscriptBox["n", "B"], ",", 
               SuperscriptBox["n", "A"]}], "]"}], "]"}]}], "/.", 
           SubscriptBox["F", 
            RowBox[{"\[Beta]", " ", "Rule"}]]}], "]"}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"P", "[", 
        RowBox[{"t_", ",", 
         RowBox[{
          SuperscriptBox["n", "B"], ":", "_"}], ",", 
         RowBox[{
          SuperscriptBox["n", "A"], ":", "_"}], ",", "SellOut"}], "]"}], ":=",
        
       RowBox[{
        RowBox[{"P", "[", 
         RowBox[{"t", ",", 
          SuperscriptBox["n", "B"], ",", 
          SuperscriptBox["n", "A"], ",", "SellOut"}], "]"}], "=", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "/", "2"}], ")"}], 
         RowBox[{"Evaluate", "[", 
          RowBox[{
           RowBox[{"1", "-", 
            RowBox[{
             SubscriptBox["F", "\[Beta]"], "[", 
             RowBox[{"\[Beta]LmtSellHigh", "[", 
              RowBox[{"t", ",", 
               SuperscriptBox["n", "B"], ",", 
               SuperscriptBox["n", "A"]}], "]"}], "]"}]}], "/.", 
           SubscriptBox["F", 
            RowBox[{"\[Beta]", " ", "Rule"}]]}], "]"}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"P", "[", 
        RowBox[{"t_", ",", 
         RowBox[{
          SuperscriptBox["n", "B"], ":", "_"}], ",", 
         RowBox[{
          SuperscriptBox["n", "A"], ":", "_"}], ",", "BuyOut"}], "]"}], ":=", 
       
       RowBox[{
        RowBox[{"P", "[", 
         RowBox[{"t", ",", 
          SuperscriptBox["n", "B"], ",", 
          SuperscriptBox["n", "A"], ",", "BuyOut"}], "]"}], "=", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "/", "2"}], ")"}], 
         RowBox[{"Evaluate", "[", 
          RowBox[{
           RowBox[{
            SubscriptBox["F", "\[Beta]"], "[", 
            RowBox[{"\[Beta]LmtBuyLow", "[", 
             RowBox[{"t", ",", 
              SuperscriptBox["n", "B"], ",", 
              SuperscriptBox["n", "A"]}], "]"}], "]"}], "/.", 
           SubscriptBox["F", 
            RowBox[{"\[Beta]", " ", "Rule"}]]}], "]"}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"P", "[", 
        RowBox[{"t_", ",", 
         RowBox[{
          SuperscriptBox["n", "B"], ":", "_"}], ",", 
         RowBox[{
          SuperscriptBox["n", "A"], ":", "_"}], ",", "BuyLmt"}], "]"}], ":=", 
       
       RowBox[{
        RowBox[{"P", "[", 
         RowBox[{"t", ",", 
          SuperscriptBox["n", "B"], ",", 
          SuperscriptBox["n", "A"], ",", "BuyLmt"}], "]"}], "=", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "/", "2"}], ")"}], 
         RowBox[{"Evaluate", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             SubscriptBox["F", "\[Beta]"], "[", 
             RowBox[{"\[Beta]LmtBuyHigh", "[", 
              RowBox[{"t", ",", 
               SuperscriptBox["n", "B"], ",", 
               SuperscriptBox["n", "A"]}], "]"}], "]"}], "-", 
            RowBox[{
             SubscriptBox["F", "\[Beta]"], "[", 
             RowBox[{"\[Beta]LmtBuyLow", "[", 
              RowBox[{"t", ",", 
               SuperscriptBox["n", "B"], ",", 
               SuperscriptBox["n", "A"]}], "]"}], "]"}]}], "/.", 
           SubscriptBox["F", 
            RowBox[{"\[Beta]", " ", "Rule"}]]}], "]"}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"P", "[", 
        RowBox[{"t_", ",", 
         RowBox[{
          SuperscriptBox["n", "B"], ":", "_"}], ",", 
         RowBox[{
          SuperscriptBox["n", "A"], ":", "_"}], ",", "BuyMkt"}], "]"}], ":=", 
       
       RowBox[{
        RowBox[{"P", "[", 
         RowBox[{"t", ",", 
          SuperscriptBox["n", "B"], ",", 
          SuperscriptBox["n", "A"], ",", "BuyMkt"}], "]"}], "=", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "/", "2"}], ")"}], 
         RowBox[{"Evaluate", "[", 
          RowBox[{
           RowBox[{"1", "-", 
            RowBox[{
             SubscriptBox["F", "\[Beta]"], "[", 
             RowBox[{"\[Beta]LmtBuyHigh", "[", 
              RowBox[{"t", ",", 
               SuperscriptBox["n", "B"], ",", 
               SuperscriptBox["n", "A"]}], "]"}], "]"}]}], "/.", 
           SubscriptBox["F", 
            RowBox[{"\[Beta]", " ", "Rule"}]]}], "]"}]}]}]}], ";"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellLabel->"In[36]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"rSetup", ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{
       "Print", "[", 
        "\"\<Clearing and resetting definitions for \
\!\(\*SuperscriptBox[\(r\), \(s\)]\) and \!\(\*SuperscriptBox[\(r\), \
\(b\)]\)...\>\"", "]"}], ";"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ClearAll", "[", 
       RowBox[{"rb", ",", "rs"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        SuperscriptBox["r", "b"], "[", 
        RowBox[{"t_", ",", 
         RowBox[{
          SuperscriptBox["n", "B"], ":", "_"}], ",", 
         RowBox[{
          SuperscriptBox["n", "A"], ":", "_"}], ",", 
         RowBox[{
          SuperscriptBox["N", "b"], ":", "_"}]}], "]"}], ":=", 
       RowBox[{
        RowBox[{
         SuperscriptBox["r", "b"], "[", 
         RowBox[{"t", ",", 
          SuperscriptBox["n", "B"], ",", 
          SuperscriptBox["n", "A"], ",", 
          SuperscriptBox["N", "b"]}], "]"}], "=", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Which", "[", 
          RowBox[{
           RowBox[{
            SuperscriptBox["N", "b"], "\[LessEqual]", "0"}], ",", "1", ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"t", "\[Equal]", "T"}], ")"}], "&&", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["N", "b"], "\[Equal]", "1"}], ")"}]}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{
                SubscriptBox["F", "\[Beta]"], "[", 
                RowBox[{"A", "/", "V"}], "]"}]}], ")"}], "/", "2"}], "/.", 
            SubscriptBox["F", 
             RowBox[{"\[Beta]", " ", "Rule"}]]}], ",", "\[IndentingNewLine]", 
           
           RowBox[{
            SuperscriptBox["N", "b"], ">", 
            RowBox[{"T", "-", "t", "+", "1"}]}], ",", "0", ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            SuperscriptBox["N", "b"], "\[LessEqual]", "0"}], ",", "1", ",", 
           "\[IndentingNewLine]", "True", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"P", "[", 
              RowBox[{"t", ",", 
               SuperscriptBox["n", "B"], ",", 
               SuperscriptBox["n", "A"], ",", "SellMkt"}], "]"}], 
             RowBox[{
              SuperscriptBox["r", "b"], "[", 
              RowBox[{
               RowBox[{"t", "+", "1"}], ",", 
               RowBox[{"Max", "[", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["n", "B"], "-", "1"}], ",", "0"}], "]"}], 
               ",", 
               SuperscriptBox["n", "A"], ",", 
               SuperscriptBox["N", "b"]}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"P", "[", 
              RowBox[{"t", ",", 
               SuperscriptBox["n", "B"], ",", 
               SuperscriptBox["n", "A"], ",", "SellLmt"}], "]"}], 
             RowBox[{
              SuperscriptBox["r", "b"], "[", 
              RowBox[{
               RowBox[{"t", "+", "1"}], ",", 
               SuperscriptBox["n", "B"], ",", 
               RowBox[{
                SuperscriptBox["n", "A"], "+", "1"}], ",", 
               SuperscriptBox["N", "b"]}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"P", "[", 
              RowBox[{"t", ",", 
               SuperscriptBox["n", "B"], ",", 
               SuperscriptBox["n", "A"], ",", "SellOut"}], "]"}], 
             RowBox[{
              SuperscriptBox["r", "b"], "[", 
              RowBox[{
               RowBox[{"t", "+", "1"}], ",", 
               SuperscriptBox["n", "B"], ",", " ", 
               SuperscriptBox["n", "A"], ",", 
               SuperscriptBox["N", "b"]}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"P", "[", 
              RowBox[{"t", ",", 
               SuperscriptBox["n", "B"], ",", 
               SuperscriptBox["n", "A"], ",", "BuyOut"}], "]"}], "   ", 
             RowBox[{
              SuperscriptBox["r", "b"], "[", 
              RowBox[{
               RowBox[{"t", "+", "1"}], ",", 
               SuperscriptBox["n", "B"], ",", 
               SuperscriptBox["n", "A"], ",", 
               SuperscriptBox["N", "b"]}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"P", "[", 
              RowBox[{"t", ",", 
               SuperscriptBox["n", "B"], ",", 
               SuperscriptBox["n", "A"], ",", "BuyLmt"}], "]"}], "   ", 
             RowBox[{
              SuperscriptBox["r", "b"], "[", 
              RowBox[{
               RowBox[{"t", "+", "1"}], ",", 
               RowBox[{
                SuperscriptBox["n", "B"], "+", "1"}], ",", 
               SuperscriptBox["n", "A"], ",", 
               SuperscriptBox["N", "b"]}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"P", "[", 
              RowBox[{"t", ",", 
               SuperscriptBox["n", "B"], ",", 
               SuperscriptBox["n", "A"], ",", "BuyMkt"}], "]"}], "   ", 
             RowBox[{
              SuperscriptBox["r", "b"], "[", 
              RowBox[{
               RowBox[{"t", "+", "1"}], ",", 
               SuperscriptBox["n", "B"], ",", 
               RowBox[{"Max", "[", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["n", "A"], "-", "1"}], ",", "0"}], "]"}], 
               ",", 
               RowBox[{
                SuperscriptBox["N", "b"], "-", "1"}]}], "]"}]}]}]}], "]"}], "//",
          "N"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        SuperscriptBox["r", "s"], "[", 
        RowBox[{"t_", ",", 
         RowBox[{
          SuperscriptBox["n", "B"], ":", "_"}], ",", 
         RowBox[{
          SuperscriptBox["n", "A"], ":", "_"}], ",", 
         RowBox[{
          SuperscriptBox["N", "s"], ":", "_"}]}], "]"}], ":=", 
       RowBox[{
        RowBox[{
         SuperscriptBox["r", "s"], "[", 
         RowBox[{"t", ",", 
          SuperscriptBox["n", "B"], ",", 
          SuperscriptBox["n", "A"], ",", 
          SuperscriptBox["N", "s"]}], "]"}], "=", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Which", "[", 
          RowBox[{
           RowBox[{
            SuperscriptBox["N", "s"], "\[LessEqual]", "0"}], ",", "1", ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"t", "\[Equal]", "T"}], ")"}], "&&", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["N", "s"], "\[Equal]", "1"}], ")"}]}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{
              SubscriptBox["F", "\[Beta]"], "[", 
              RowBox[{"B", "/", "V"}], "]"}], "/", "2"}], "/.", 
            SubscriptBox["F", 
             RowBox[{"\[Beta]", " ", "Rule"}]]}], ",", "\[IndentingNewLine]", 
           
           RowBox[{
            SuperscriptBox["N", "s"], ">", 
            RowBox[{"T", "-", "t", "+", "1"}]}], ",", "0", ",", 
           "\[IndentingNewLine]", "True", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"P", "[", 
              RowBox[{"t", ",", 
               SuperscriptBox["n", "B"], ",", 
               SuperscriptBox["n", "A"], ",", "SellMkt"}], "]"}], 
             RowBox[{
              SuperscriptBox["r", "s"], "[", 
              RowBox[{
               RowBox[{"t", "+", "1"}], ",", 
               RowBox[{"Max", "[", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["n", "B"], "-", "1"}], ",", "0"}], "]"}], 
               ",", 
               SuperscriptBox["n", "A"], ",", 
               RowBox[{
                SuperscriptBox["N", "s"], "-", "1"}]}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"P", "[", 
              RowBox[{"t", ",", 
               SuperscriptBox["n", "B"], ",", 
               SuperscriptBox["n", "A"], ",", "SellLmt"}], "]"}], 
             RowBox[{
              SuperscriptBox["r", "s"], "[", 
              RowBox[{
               RowBox[{"t", "+", "1"}], ",", 
               SuperscriptBox["n", "B"], ",", 
               RowBox[{
                SuperscriptBox["n", "A"], "+", "1"}], ",", 
               SuperscriptBox["N", "s"]}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"P", "[", 
              RowBox[{"t", ",", 
               SuperscriptBox["n", "B"], ",", 
               SuperscriptBox["n", "A"], ",", "SellOut"}], "]"}], 
             RowBox[{
              SuperscriptBox["r", "s"], "[", 
              RowBox[{
               RowBox[{"t", "+", "1"}], ",", 
               SuperscriptBox["n", "B"], ",", " ", 
               SuperscriptBox["n", "A"], ",", 
               SuperscriptBox["N", "s"]}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"P", "[", 
              RowBox[{"t", ",", 
               SuperscriptBox["n", "B"], ",", 
               SuperscriptBox["n", "A"], ",", "BuyOut"}], "]"}], "   ", 
             RowBox[{
              SuperscriptBox["r", "s"], "[", 
              RowBox[{
               RowBox[{"t", "+", "1"}], ",", 
               SuperscriptBox["n", "B"], ",", " ", 
               SuperscriptBox["n", "A"], ",", 
               SuperscriptBox["N", "s"]}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"P", "[", 
              RowBox[{"t", ",", 
               SuperscriptBox["n", "B"], ",", 
               SuperscriptBox["n", "A"], ",", "BuyLmt"}], "]"}], "   ", 
             RowBox[{
              SuperscriptBox["r", "s"], "[", 
              RowBox[{
               RowBox[{"t", "+", "1"}], ",", 
               RowBox[{
                SuperscriptBox["n", "B"], "+", "1"}], ",", 
               SuperscriptBox["n", "A"], ",", 
               SuperscriptBox["N", "s"]}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"P", "[", 
              RowBox[{"t", ",", 
               SuperscriptBox["n", "B"], ",", 
               SuperscriptBox["n", "A"], ",", "BuyMkt"}], "]"}], "   ", 
             RowBox[{
              SuperscriptBox["r", "s"], "[", 
              RowBox[{
               RowBox[{"t", "+", "1"}], ",", 
               SuperscriptBox["n", "B"], ",", 
               RowBox[{"Max", "[", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["n", "A"], "-", "1"}], ",", "0"}], "]"}], 
               ",", " ", 
               SuperscriptBox["N", "s"]}], "]"}]}]}]}], "]"}], "//", 
         "N"}]}]}], ";"}]}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.3896351791244*^9, 3.3896352359294*^9}},
 CellLabel->"In[37]:="],

Cell["Transition probabilities:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PrSetup", ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{
       "Print", "[", "\"\<Clearing and resetting definitions for Pr...\>\"", 
        "]"}], ";"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ClearAll", "[", "Pr", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Pr", "[", 
        RowBox[{"t_", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SubsuperscriptBox["n", "t", "B"], ":", "_"}], ",", 
           RowBox[{
            SubsuperscriptBox["n", "t", "A"], ":", "_"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SubsuperscriptBox["n", 
             RowBox[{"t", "+", "1"}], "B"], ":", "_"}], ",", 
           RowBox[{
            SubsuperscriptBox["n", 
             RowBox[{"t", "+", "1"}], "A"], ":", "_"}]}], "}"}]}], "]"}], ":=",
        
       RowBox[{
        RowBox[{"Pr", "[", 
         RowBox[{"t", ",", 
          RowBox[{"{", 
           RowBox[{
            SubsuperscriptBox["n", "t", "B"], ",", 
            SubsuperscriptBox["n", "t", "A"]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubsuperscriptBox["n", 
             RowBox[{"t", "+", "1"}], "B"], ",", 
            SubsuperscriptBox["n", 
             RowBox[{"t", "+", "1"}], "A"]}], "}"}]}], "]"}], "=", 
        "\[IndentingNewLine]", 
        RowBox[{"Which", "[", "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SubsuperscriptBox["n", "t", "B"], ">", "MaxDepth"}], ")"}], " ",
             "||", " ", 
            RowBox[{"(", 
             RowBox[{
              SubsuperscriptBox["n", "t", "A"], ">", "MaxDepth"}], ")"}], " ",
             "||", " ", 
            RowBox[{"(", 
             RowBox[{
              SubsuperscriptBox["n", 
               RowBox[{"t", "+", "1"}], "B"], ">", "MaxDepth"}], ")"}], " ", "||",
             
            RowBox[{"(", " ", 
             RowBox[{
              SubsuperscriptBox["n", 
               RowBox[{"t", "+", "1"}], "A"], ">", "MaxDepth"}], ")"}]}], " ",
            ",", "0", ","}], "*)"}], "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{
            SubsuperscriptBox["n", "t", "B"], "\[Equal]", "0"}], " ", "&&", 
           " ", 
           RowBox[{
            SubsuperscriptBox["n", 
             RowBox[{"t", "+", "1"}], "B"], "\[Equal]", "0"}], " ", "&&", " ",
            
           RowBox[{
            SubsuperscriptBox["n", "t", "A"], "\[Equal]", "0"}], " ", "&&", 
           " ", 
           RowBox[{
            SubsuperscriptBox["n", 
             RowBox[{"t", "+", "1"}], "A"], "\[Equal]", "0"}]}], ",", 
          RowBox[{
           RowBox[{"P", "[", 
            RowBox[{"t", ",", 
             SubsuperscriptBox["n", "t", "B"], ",", 
             SubsuperscriptBox["n", "t", "A"], ",", "BuyOut"}], "]"}], "+", 
           RowBox[{"P", "[", 
            RowBox[{"t", ",", 
             SubsuperscriptBox["n", "t", "B"], ",", 
             SubsuperscriptBox["n", "t", "A"], ",", "SellOut"}], "]"}], "+", 
           RowBox[{"P", "[", 
            RowBox[{"t", ",", 
             SubsuperscriptBox["n", "t", "B"], ",", 
             SubsuperscriptBox["n", "t", "A"], ",", "SellMkt"}], "]"}], "+", 
           RowBox[{"P", "[", 
            RowBox[{"t", ",", 
             SubsuperscriptBox["n", "t", "B"], ",", 
             SubsuperscriptBox["n", "t", "A"], ",", "BuyMkt"}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            SubsuperscriptBox["n", "t", "B"], "\[Equal]", "0"}], " ", "&&", 
           " ", 
           RowBox[{
            SubsuperscriptBox["n", 
             RowBox[{"t", "+", "1"}], "B"], "\[Equal]", "0"}], " ", "&&", " ",
            
           RowBox[{
            SubsuperscriptBox["n", "t", "A"], "\[Equal]", 
            SubsuperscriptBox["n", 
             RowBox[{"t", "+", "1"}], "A"]}]}], ",", 
          RowBox[{
           RowBox[{"P", "[", 
            RowBox[{"t", ",", 
             SubsuperscriptBox["n", "t", "B"], ",", 
             SubsuperscriptBox["n", "t", "A"], ",", "BuyOut"}], "]"}], "+", 
           RowBox[{"P", "[", 
            RowBox[{"t", ",", 
             SubsuperscriptBox["n", "t", "B"], ",", 
             SubsuperscriptBox["n", "t", "A"], ",", "SellOut"}], "]"}], "+", 
           RowBox[{"P", "[", 
            RowBox[{"t", ",", 
             SubsuperscriptBox["n", "t", "B"], ",", 
             SubsuperscriptBox["n", "t", "A"], ",", "SellMkt"}], "]"}]}], ",",
           "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            SubsuperscriptBox["n", "t", "B"], "\[Equal]", 
            SubsuperscriptBox["n", 
             RowBox[{"t", "+", "1"}], "B"]}], " ", "&&", " ", 
           RowBox[{
            SubsuperscriptBox["n", "t", "A"], "\[Equal]", "0"}], " ", "&&", 
           " ", 
           RowBox[{
            SubsuperscriptBox["n", 
             RowBox[{"t", "+", "1"}], "A"], "\[Equal]", "0"}]}], ",", 
          RowBox[{
           RowBox[{"P", "[", 
            RowBox[{"t", ",", 
             SubsuperscriptBox["n", "t", "B"], ",", 
             SubsuperscriptBox["n", "t", "A"], ",", "BuyOut"}], "]"}], "+", 
           RowBox[{"P", "[", 
            RowBox[{"t", ",", 
             SubsuperscriptBox["n", "t", "B"], ",", 
             SubsuperscriptBox["n", "t", "A"], ",", "SellOut"}], "]"}], "+", 
           RowBox[{"P", "[", 
            RowBox[{"t", ",", 
             SubsuperscriptBox["n", "t", "B"], ",", 
             SubsuperscriptBox["n", "t", "A"], ",", "BuyMkt"}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            SubsuperscriptBox["n", "t", "A"], "\[Equal]", 
            SubsuperscriptBox["n", 
             RowBox[{"t", "+", "1"}], "A"]}], " ", "&&", " ", 
           RowBox[{
            SubsuperscriptBox["n", "t", "B"], "\[Equal]", 
            SubsuperscriptBox["n", 
             RowBox[{"t", "+", "1"}], "B"]}]}], ",", 
          RowBox[{
           RowBox[{"P", "[", 
            RowBox[{"t", ",", 
             SubsuperscriptBox["n", "t", "B"], ",", 
             SubsuperscriptBox["n", "t", "A"], ",", "BuyOut"}], "]"}], "+", 
           RowBox[{"P", "[", 
            RowBox[{"t", ",", 
             SubsuperscriptBox["n", "t", "B"], ",", 
             SubsuperscriptBox["n", "t", "A"], ",", "SellOut"}], "]"}]}], ",",
           "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            SubsuperscriptBox["n", 
             RowBox[{"t", "+", "1"}], "B"], "\[Equal]", 
            RowBox[{
             SubsuperscriptBox["n", "t", "B"], "+", "1"}]}], "&&", " ", 
           RowBox[{
            SubsuperscriptBox["n", "t", "A"], "\[Equal]", 
            SubsuperscriptBox["n", 
             RowBox[{"t", "+", "1"}], "A"]}]}], ",", 
          RowBox[{"P", "[", 
           RowBox[{"t", ",", 
            SubsuperscriptBox["n", "t", "B"], ",", 
            SubsuperscriptBox["n", "t", "A"], ",", "BuyLmt"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            SubsuperscriptBox["n", "t", "B"], "\[Equal]", 
            SubsuperscriptBox["n", 
             RowBox[{"t", "+", "1"}], "B"]}], "&&", " ", 
           RowBox[{
            SubsuperscriptBox["n", 
             RowBox[{"t", "+", "1"}], "A"], "\[Equal]", 
            RowBox[{
             SubsuperscriptBox["n", "t", "A"], "+", "1"}]}]}], ",", 
          RowBox[{"P", "[", 
           RowBox[{"t", ",", 
            SubsuperscriptBox["n", "t", "B"], ",", 
            SubsuperscriptBox["n", "t", "A"], ",", "SellLmt"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            SubsuperscriptBox["n", 
             RowBox[{"t", "+", "1"}], "B"], "\[Equal]", 
            RowBox[{
             SubsuperscriptBox["n", "t", "B"], "-", "1"}]}], " ", "&&", " ", 
           RowBox[{
            SubsuperscriptBox["n", "t", "A"], "\[Equal]", 
            SubsuperscriptBox["n", 
             RowBox[{"t", "+", "1"}], "A"]}]}], ",", 
          RowBox[{"P", "[", 
           RowBox[{"t", ",", 
            SubsuperscriptBox["n", "t", "B"], ",", 
            SubsuperscriptBox["n", "t", "A"], ",", "SellMkt"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            SubsuperscriptBox["n", 
             RowBox[{"t", "+", "1"}], "B"], "\[Equal]", 
            SubsuperscriptBox["n", "t", "B"]}], " ", "&&", " ", 
           RowBox[{
            SubsuperscriptBox["n", 
             RowBox[{"t", "+", "1"}], "A"], "\[Equal]", 
            RowBox[{
             SubsuperscriptBox["n", "t", "A"], "-", "1"}]}]}], ",", 
          RowBox[{"P", "[", 
           RowBox[{"t", ",", 
            SubsuperscriptBox["n", "t", "B"], ",", 
            SubsuperscriptBox["n", "t", "A"], ",", "BuyMkt"}], "]"}], ",", 
          "\[IndentingNewLine]", "True", ",", "0"}], "]"}]}]}], ";"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.3896352953986*^9, 3.3896353072556*^9}},
 CellLabel->"In[38]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"PrStateSetup", ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{
       "Print", "[", 
        "\"\<Clearing and resetting definitions for PrState...\>\"", "]"}], 
       ";"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ClearAll", "[", "PrState", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"PrState", "[", 
        RowBox[{"t_", ",", 
         RowBox[{
          SuperscriptBox["n", "B"], ":", "_"}], ",", 
         RowBox[{
          SuperscriptBox["n", "A"], ":", "_"}]}], "]"}], ":=", 
       RowBox[{
        RowBox[{"PrState", "[", 
         RowBox[{"t", ",", 
          SuperscriptBox["n", "A"], ",", 
          SuperscriptBox["n", "B"]}], "]"}], "=", 
        RowBox[{"Which", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"t", "\[Equal]", "1"}], " ", "&&", " ", 
           RowBox[{
            SuperscriptBox["n", "A"], "\[Equal]", "0"}], " ", "&&", " ", 
           RowBox[{
            SuperscriptBox["n", "B"], "\[Equal]", "0"}]}], ",", "1", ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"1", "<", "t"}], " ", "&&", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["n", "A"], ">", 
              RowBox[{"t", "-", "1"}]}], " ", "||", " ", 
             RowBox[{
              SuperscriptBox["n", "B"], ">", 
              RowBox[{"t", "-", "1"}]}]}], ")"}]}], ",", "0", ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["n", "B"], ">", "MaxDepth"}], " ", "||", " ", 
           RowBox[{
            SuperscriptBox["n", "A"], ">", "MaxDepth"}]}], " ", ",", "0", ",",
           "\[IndentingNewLine]", "True", ",", "\[IndentingNewLine]", 
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"PrState", "[", 
              RowBox[{
               RowBox[{"t", "-", "1"}], ",", 
               SubsuperscriptBox["n", 
                RowBox[{"t", "-", "1"}], "B"], ",", 
               SubsuperscriptBox["n", 
                RowBox[{"t", "-", "1"}], "A"]}], "]"}], 
             RowBox[{"Pr", "[", 
              RowBox[{
               RowBox[{"t", "-", "1"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 SubsuperscriptBox["n", 
                  RowBox[{"t", "-", "1"}], "B"], ",", 
                 SubsuperscriptBox["n", 
                  RowBox[{"t", "-", "1"}], "A"]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 SuperscriptBox["n", "B"], ",", 
                 SuperscriptBox["n", "A"]}], "}"}]}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              SubsuperscriptBox["n", 
               RowBox[{"t", "-", "1"}], "B"], ",", 
              RowBox[{"Max", "[", 
               RowBox[{"0", ",", 
                RowBox[{
                 SuperscriptBox["n", "B"], "-", "1"}]}], "]"}], ",", 
              RowBox[{"Min", "[", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["n", "B"], "+", "1"}], ",", 
                RowBox[{"t", "-", "1"}]}], "]"}]}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              SubsuperscriptBox["n", 
               RowBox[{"t", "-", "1"}], "A"], ",", 
              RowBox[{"Max", "[", 
               RowBox[{"0", ",", 
                RowBox[{
                 SuperscriptBox["n", "A"], "-", "1"}]}], "]"}], ",", 
              RowBox[{"Min", "[", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["n", "A"], "+", "1"}], ",", 
                RowBox[{"t", "-", "1"}]}], "]"}]}], "}"}]}], "]"}]}], 
         "\[IndentingNewLine]", "]"}]}]}], ";"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[39]:="],

Cell[BoxData[
 RowBox[{"Off", "[", 
  RowBox[{
   RowBox[{"General", "::", "\"\<spell1\>\""}], ",", " ", 
   RowBox[{"General", "::", "\"\<spell\>\""}]}], "]"}]], "Input",
 CellLabel->"In[40]:="],

Cell[BoxData[
 RowBox[{"Off", "[", 
  RowBox[{"Optional", "::", "\"\<opdef\>\""}], "]"}]], "Input",
 CellLabel->"In[41]:="],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "InitializeAll", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"InitializeAll", "[", 
    RowBox[{
     RowBox[{"T0_:", "3"}], ",", 
     RowBox[{"F\[Beta]Rule_:", 
      SubscriptBox["F", 
       RowBox[{"\[Beta]", " ", "Uniform"}]]}], ",", 
     RowBox[{"\[Beta]Low_:", "0"}], ",", 
     RowBox[{"\[Beta]High_:", "2"}], ",", 
     RowBox[{"V0_:", 
      RowBox[{"11", "/", "2"}]}], ",", 
     RowBox[{"B0_:", "5"}], ",", 
     RowBox[{"A0_:", "6"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
      "Print", "[", "\"\<Initializing all probabilities and rules.\>\"", 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"T", "=", "T0"}], ";", 
      RowBox[{"V", "=", 
       RowBox[{"V0", "//", "N"}]}], ";", 
      RowBox[{"B", "=", 
       RowBox[{"B0", "//", "N"}]}], ";", 
      RowBox[{"A", "=", 
       RowBox[{"A0", "//", "N"}]}], ";", 
      RowBox[{
       SubscriptBox["F", 
        RowBox[{"\[Beta]", " ", "Rule"}]], "=", "F\[Beta]Rule"}], ";", 
      RowBox[{
       UnderscriptBox["\[Beta]", "_"], "=", "\[Beta]Low"}], ";", 
      RowBox[{
       OverscriptBox["\[Beta]", "_"], "=", "\[Beta]High"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{
       "\"\<T=\>\"", " ", ",", "T", ",", 
        "\"\< \!\(\*SubscriptBox[\(F\), \(\[Beta]\\\ Rule\)]\)=\>\"", ",", 
        SubscriptBox["F", 
         RowBox[{"\[Beta]", " ", "Rule"}]], ",", 
        "\"\< \!\(\*UnderscriptBox[\(\[Beta]\), \(_\)]\)=\>\"", ",", 
        UnderscriptBox["\[Beta]", "_"], ",", 
        "\"\< \!\(\*OverscriptBox[\(\[Beta]\), \(_\)]\)=\>\"", ",", 
        OverscriptBox["\[Beta]", "_"], ",", "\"\< V=\>\"", ",", "V", ",", 
        "\"\< B=\>\"", ",", "B", ",", "\"\< A=\>\"", ",", "A"}], "]"}], ";", 
      "\[IndentingNewLine]", "pSetup", ";", "\[IndentingNewLine]", 
      "\[Beta]Setup", ";", "\[IndentingNewLine]", "PSetup", ";", 
      "\[IndentingNewLine]", "rSetup", ";", "\[IndentingNewLine]", "PrSetup", 
      ";", "\[IndentingNewLine]", "PrStateSetup", ";"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.3896353546415997`*^9, 3.3896353609486*^9}},
 CellLabel->"In[42]:="],

Cell[BoxData[
 RowBox[{"On", "[", 
  RowBox[{"Optional", "::", "\"\<opdef\>\""}], "]"}]], "Input",
 CellLabel->"In[44]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InitializeAll", "[", "]"}]], "Input",
 CellLabel->"In[45]:="],

Cell[BoxData["\<\"Initializing all probabilities and rules.\"\>"], "Print",
 CellChangeTimes->{3.3896338333912*^9, 3.3896344205178003`*^9, 
  3.3896353195916*^9, 3.389635442579*^9, 3.389635548256*^9, 
  3.3896590220434237`*^9, 3.389659064984424*^9, 3.389694392175024*^9},
 CellLabel->"During evaluation of In[45]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"T=\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" \\!\\(\\*SubscriptBox[\\(F\\), \\(\[Beta]\\\\ \
Rule\\)]\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SubscriptBox["F", "\[Beta]"], "[", "\[Beta]_", "]"}], "\[RuleDelayed]", 
    RowBox[{"CDF", "[", 
     RowBox[{
      RowBox[{"UniformDistribution", "[", 
       RowBox[{"{", 
        RowBox[{
         UnderscriptBox["\[Beta]", "_"], ",", 
         OverscriptBox["\[Beta]", "_"]}], "}"}], "]"}], ",", "\[Beta]"}], 
     "]"}]}], "\[InvisibleSpace]", "\<\" \
\\!\\(\\*UnderscriptBox[\\(\[Beta]\\), \\(_\\)]\\)=\"\>", "\[InvisibleSpace]",
    "0", "\[InvisibleSpace]", "\<\" \\!\\(\\*OverscriptBox[\\(\[Beta]\\), \
\\(_\\)]\\)=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" V=\"\>", "\[InvisibleSpace]", "5.5`", 
   "\[InvisibleSpace]", "\<\" B=\"\>", "\[InvisibleSpace]", "5.`", 
   "\[InvisibleSpace]", "\<\" A=\"\>", "\[InvisibleSpace]", "6.`"}],
  SequenceForm[
  "T=", 3, " \!\(\*SubscriptBox[\(F\), \(\[Beta]\\ Rule\)]\)=", \
$CellContext`F\[Beta][
     Pattern[$CellContext`\[Beta], 
      Blank[]]] :> CDF[
     UniformDistribution[{$CellContext`\[Beta]\[UnderBracket]Underscript\
\[UnderBracket]Underscore, $CellContext`\[Beta]\[UnderBracket]Overscript\
\[UnderBracket]Underscore}], $CellContext`\[Beta]], 
   " \!\(\*UnderscriptBox[\(\[Beta]\), \(_\)]\)=", 0, 
   " \!\(\*OverscriptBox[\(\[Beta]\), \(_\)]\)=", 2, " V=", 5.5, " B=", 5., 
   " A=", 6.],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896338333912*^9, 3.3896344205178003`*^9, 
  3.3896353195916*^9, 3.389635442579*^9, 3.389635548256*^9, 
  3.3896590220434237`*^9, 3.389659064984424*^9, 3.3896943921790237`*^9},
 CellLabel->"During evaluation of In[45]:="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Calculate", "[", 
    RowBox[{"MaxDepth0_:", "4"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"MaxDepth", "=", "MaxDepth0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"Do", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"P", "[", 
             RowBox[{"t", ",", 
              SuperscriptBox["n", "B"], ",", 
              SuperscriptBox["n", "A"], ",", "SellMkt"}], "]"}], ",", 
            RowBox[{"P", "[", 
             RowBox[{"t", ",", 
              SuperscriptBox["n", "B"], ",", 
              SuperscriptBox["n", "A"], ",", "SellLmt"}], "]"}], ",", 
            RowBox[{"P", "[", 
             RowBox[{"t", ",", 
              SuperscriptBox["n", "B"], ",", 
              SuperscriptBox["n", "A"], ",", "SellOut"}], "]"}], ",", 
            RowBox[{"P", "[", 
             RowBox[{"t", ",", 
              SuperscriptBox["n", "B"], ",", 
              SuperscriptBox["n", "A"], ",", "BuyOut"}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"P", "[", 
             RowBox[{"t", ",", 
              SuperscriptBox["n", "B"], ",", 
              SuperscriptBox["n", "A"], ",", "BuyLmt"}], "]"}], ",", 
            RowBox[{"P", "[", 
             RowBox[{"t", ",", 
              SuperscriptBox["n", "B"], ",", 
              SuperscriptBox["n", "A"], ",", "BuyMkt"}], "]"}]}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"t", ",", "T", ",", "1", ",", 
            RowBox[{"-", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            SuperscriptBox["n", "B"], ",", "0", ",", 
            RowBox[{"Min", "[", 
             RowBox[{"MaxDepth", ",", 
              RowBox[{"t", "-", "1"}]}], "]"}]}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            SuperscriptBox["n", "A"], ",", "0", ",", 
            RowBox[{"Min", "[", 
             RowBox[{"MaxDepth", ",", 
              RowBox[{"t", "-", "1"}]}], "]"}]}], "}"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Do", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Pr", "[", 
           RowBox[{"t", ",", 
            RowBox[{"{", 
             RowBox[{
              SubsuperscriptBox["n", "t", "B"], ",", 
              SubsuperscriptBox["n", "t", "A"]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              SubsuperscriptBox["n", 
               RowBox[{"t", "+", "1"}], "B"], ",", 
              SubsuperscriptBox["n", 
               RowBox[{"t", "+", "1"}], "A"]}], "}"}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"t", ",", "1", ",", 
            RowBox[{"T", "-", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            SubsuperscriptBox["n", "t", "B"], ",", "0", ",", 
            RowBox[{"Min", "[", 
             RowBox[{"MaxDepth", ",", 
              RowBox[{"t", "-", "1"}]}], "]"}]}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            SubsuperscriptBox["n", "t", "A"], ",", "0", ",", 
            RowBox[{"Min", "[", 
             RowBox[{"MaxDepth", ",", 
              RowBox[{"t", "-", "1"}]}], "]"}]}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            SubsuperscriptBox["n", 
             RowBox[{"t", "+", "1"}], "B"], ",", 
            RowBox[{"Max", "[", 
             RowBox[{
              RowBox[{
               SubsuperscriptBox["n", "t", "B"], "-", "1"}], ",", "0"}], 
             "]"}], ",", 
            RowBox[{
             SubsuperscriptBox["n", "t", "B"], "+", "1"}]}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            SubsuperscriptBox["n", 
             RowBox[{"t", "+", "1"}], "A"], ",", 
            RowBox[{"Max", "[", 
             RowBox[{
              RowBox[{
               SubsuperscriptBox["n", "t", "A"], "-", "1"}], ",", "0"}], 
             "]"}], ",", 
            RowBox[{
             SubsuperscriptBox["n", "t", "A"], "+", "1"}]}], "}"}]}], "]"}], 
        ";"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"PrState", "[", 
         RowBox[{"t", ",", 
          SuperscriptBox["n", "B"], ",", 
          SuperscriptBox["n", "A"]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"t", ",", "1", ",", "T"}], "}"}], ",", "\[IndentingNewLine]",
         
        RowBox[{"{", 
         RowBox[{
          SuperscriptBox["n", "B"], ",", "0", ",", 
          RowBox[{"Min", "[", 
           RowBox[{"MaxDepth", ",", 
            RowBox[{"t", "-", "1"}]}], "]"}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          SuperscriptBox["n", "A"], ",", "0", ",", 
          RowBox[{"Min", "[", 
           RowBox[{"MaxDepth", ",", 
            RowBox[{"t", "-", "1"}]}], "]"}]}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"d", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{"Pr", "[", 
             RowBox[{"t", ",", 
              RowBox[{"{", 
               RowBox[{
                SubsuperscriptBox["n", "t", "B"], ",", 
                SubsuperscriptBox["n", "t", "A"]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                SubsuperscriptBox["n", 
                 RowBox[{"t", "+", "1"}], "B"], ",", 
                SubsuperscriptBox["n", 
                 RowBox[{"t", "+", "1"}], "A"]}], "}"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              SubsuperscriptBox["n", 
               RowBox[{"t", "+", "1"}], "B"], ",", "0", ",", "t"}], "}"}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              SubsuperscriptBox["n", 
               RowBox[{"t", "+", "1"}], "A"], ",", "0", ",", "t"}], "}"}]}], 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"t", ",", "1", ",", 
            RowBox[{"T", "-", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            SubsuperscriptBox["n", "t", "B"], ",", "0", ",", 
            RowBox[{"Min", "[", 
             RowBox[{"MaxDepth", ",", 
              RowBox[{"t", "-", "1"}]}], "]"}]}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            SubsuperscriptBox["n", "t", "A"], ",", "0", ",", 
            RowBox[{"Min", "[", 
             RowBox[{"MaxDepth", ",", 
              RowBox[{"t", "-", "1"}]}], "]"}]}], "}"}]}], 
         "\[IndentingNewLine]", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Max discrepancy in transition probabilities=\>\"", ",", 
        RowBox[{"Max", "[", 
         RowBox[{"Abs", "[", 
          RowBox[{"d", "-", "1"}], "]"}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"d", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{"PrState", "[", 
             RowBox[{"t", ",", 
              SuperscriptBox["n", "B"], ",", 
              SuperscriptBox["n", "A"]}], "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              SuperscriptBox["n", "B"], ",", "0", ",", 
              RowBox[{"Min", "[", 
               RowBox[{
                RowBox[{"t", "-", "1"}], ",", "MaxDepth"}], "]"}]}], "}"}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              SuperscriptBox["n", "A"], ",", "0", ",", 
              RowBox[{"Min", "[", 
               RowBox[{
                RowBox[{"t", "-", "1"}], ",", "MaxDepth"}], "]"}]}], "}"}]}], 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"t", ",", "1", ",", "T"}], "}"}]}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Max discrepancy in state probabilities=\>\"", ",", 
        RowBox[{"Max", "[", 
         RowBox[{"Abs", "[", 
          RowBox[{"d", "-", "1"}], "]"}], "]"}]}], "]"}], ";"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellLabel->"In[46]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"InitializeAll", "[", "6", "]"}], ";", 
   RowBox[{"Calculate", "[", "3", "]"}], ";"}], "]"}]], "Input",
 CellLabel->"In[47]:="],

Cell[BoxData["\<\"Initializing all probabilities and rules.\"\>"], "Print",
 CellChangeTimes->{3.3896338334421997`*^9, 3.3896338862042*^9, 
  3.3896344205688*^9, 3.3896353196446*^9, 3.38963544266*^9, 3.389635548302*^9,
   3.3896590220884237`*^9, 3.3896590650544243`*^9, 3.3896944087920237`*^9},
 CellLabel->"During evaluation of In[47]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"T=\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" \\!\\(\\*SubscriptBox[\\(F\\), \\(\[Beta]\\\\ \
Rule\\)]\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SubscriptBox["F", "\[Beta]"], "[", "\[Beta]_", "]"}], "\[RuleDelayed]", 
    RowBox[{"CDF", "[", 
     RowBox[{
      RowBox[{"UniformDistribution", "[", 
       RowBox[{"{", 
        RowBox[{
         UnderscriptBox["\[Beta]", "_"], ",", 
         OverscriptBox["\[Beta]", "_"]}], "}"}], "]"}], ",", "\[Beta]"}], 
     "]"}]}], "\[InvisibleSpace]", "\<\" \
\\!\\(\\*UnderscriptBox[\\(\[Beta]\\), \\(_\\)]\\)=\"\>", "\[InvisibleSpace]",
    "0", "\[InvisibleSpace]", "\<\" \\!\\(\\*OverscriptBox[\\(\[Beta]\\), \
\\(_\\)]\\)=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" V=\"\>", "\[InvisibleSpace]", "5.5`", 
   "\[InvisibleSpace]", "\<\" B=\"\>", "\[InvisibleSpace]", "5.`", 
   "\[InvisibleSpace]", "\<\" A=\"\>", "\[InvisibleSpace]", "6.`"}],
  SequenceForm[
  "T=", 6, " \!\(\*SubscriptBox[\(F\), \(\[Beta]\\ Rule\)]\)=", \
$CellContext`F\[Beta][
     Pattern[$CellContext`\[Beta], 
      Blank[]]] :> CDF[
     UniformDistribution[{$CellContext`\[Beta]\[UnderBracket]Underscript\
\[UnderBracket]Underscore, $CellContext`\[Beta]\[UnderBracket]Overscript\
\[UnderBracket]Underscore}], $CellContext`\[Beta]], 
   " \!\(\*UnderscriptBox[\(\[Beta]\), \(_\)]\)=", 0, 
   " \!\(\*OverscriptBox[\(\[Beta]\), \(_\)]\)=", 2, " V=", 5.5, " B=", 5., 
   " A=", 6.],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896338334421997`*^9, 3.3896338862042*^9, 
  3.3896344205688*^9, 3.3896353196446*^9, 3.38963544266*^9, 3.389635548302*^9,
   3.3896590220884237`*^9, 3.3896590650544243`*^9, 3.3896944087960243`*^9},
 CellLabel->"During evaluation of In[47]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Max discrepancy in transition probabilities=\"\>", 
   "\[InvisibleSpace]", "1.1102230246251565`*^-16"}],
  SequenceForm[
  "Max discrepancy in transition probabilities=", 1.1102230246251565`*^-16],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896338334421997`*^9, 3.3896338862042*^9, 
  3.3896344205688*^9, 3.3896353196446*^9, 3.38963544266*^9, 3.389635548302*^9,
   3.3896590220884237`*^9, 3.3896590650544243`*^9, 3.3896944089870243`*^9},
 CellLabel->"During evaluation of In[47]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Max discrepancy in state probabilities=\"\>", 
   "\[InvisibleSpace]", "4.440892098500626`*^-16"}],
  SequenceForm[
  "Max discrepancy in state probabilities=", 4.440892098500626*^-16],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896338334421997`*^9, 3.3896338862042*^9, 
  3.3896344205688*^9, 3.3896353196446*^9, 3.38963544266*^9, 3.389635548302*^9,
   3.3896590220884237`*^9, 3.3896590650544243`*^9, 3.389694409070024*^9},
 CellLabel->"During evaluation of In[47]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.2650000000000001`", ",", "Null"}], "}"}]], "Output",
 CellChangeTimes->{3.3896338339062*^9, 3.3896338865002003`*^9, 
  3.3896344208468*^9, 3.3896353199266*^9, 3.389635442933*^9, 
  3.389635548586*^9, 3.389659022589424*^9, 3.389659065325424*^9, 
  3.3896944090720243`*^9},
 CellLabel->"Out[47]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Analyze and summarize properties of equilibrium", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"InitializeAll", "[", "3", "]"}], ";", 
   RowBox[{"Calculate", "[", "]"}], ";"}], "]"}]], "Input",
 CellLabel->"In[48]:="],

Cell[BoxData["\<\"Initializing all probabilities and rules.\"\>"], "Print",
 CellChangeTimes->{3.3896338926912003`*^9, 3.3896344208798*^9, 
  3.389635467619*^9, 3.389635548618*^9, 3.389659022663424*^9, 
  3.389659065354424*^9, 3.389694415793024*^9},
 CellLabel->"During evaluation of In[48]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"T=\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" \\!\\(\\*SubscriptBox[\\(F\\), \\(\[Beta]\\\\ \
Rule\\)]\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SubscriptBox["F", "\[Beta]"], "[", "\[Beta]_", "]"}], "\[RuleDelayed]", 
    RowBox[{"CDF", "[", 
     RowBox[{
      RowBox[{"UniformDistribution", "[", 
       RowBox[{"{", 
        RowBox[{
         UnderscriptBox["\[Beta]", "_"], ",", 
         OverscriptBox["\[Beta]", "_"]}], "}"}], "]"}], ",", "\[Beta]"}], 
     "]"}]}], "\[InvisibleSpace]", "\<\" \
\\!\\(\\*UnderscriptBox[\\(\[Beta]\\), \\(_\\)]\\)=\"\>", "\[InvisibleSpace]",
    "0", "\[InvisibleSpace]", "\<\" \\!\\(\\*OverscriptBox[\\(\[Beta]\\), \
\\(_\\)]\\)=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" V=\"\>", "\[InvisibleSpace]", "5.5`", 
   "\[InvisibleSpace]", "\<\" B=\"\>", "\[InvisibleSpace]", "5.`", 
   "\[InvisibleSpace]", "\<\" A=\"\>", "\[InvisibleSpace]", "6.`"}],
  SequenceForm[
  "T=", 3, " \!\(\*SubscriptBox[\(F\), \(\[Beta]\\ Rule\)]\)=", \
$CellContext`F\[Beta][
     Pattern[$CellContext`\[Beta], 
      Blank[]]] :> CDF[
     UniformDistribution[{$CellContext`\[Beta]\[UnderBracket]Underscript\
\[UnderBracket]Underscore, $CellContext`\[Beta]\[UnderBracket]Overscript\
\[UnderBracket]Underscore}], $CellContext`\[Beta]], 
   " \!\(\*UnderscriptBox[\(\[Beta]\), \(_\)]\)=", 0, 
   " \!\(\*OverscriptBox[\(\[Beta]\), \(_\)]\)=", 2, " V=", 5.5, " B=", 5., 
   " A=", 6.],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896338926912003`*^9, 3.3896344208798*^9, 
  3.389635467619*^9, 3.389635548618*^9, 3.389659022663424*^9, 
  3.389659065354424*^9, 3.389694415797024*^9},
 CellLabel->"During evaluation of In[48]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Max discrepancy in transition probabilities=\"\>", 
   "\[InvisibleSpace]", "0.`"}],
  SequenceForm["Max discrepancy in transition probabilities=", 0.],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896338926912003`*^9, 3.3896344208798*^9, 
  3.389635467619*^9, 3.389635548618*^9, 3.389659022663424*^9, 
  3.389659065354424*^9, 3.389694415800024*^9},
 CellLabel->"During evaluation of In[48]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Max discrepancy in state probabilities=\"\>", 
   "\[InvisibleSpace]", "1.1102230246251565`*^-16"}],
  SequenceForm[
  "Max discrepancy in state probabilities=", 1.1102230246251565`*^-16],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896338926912003`*^9, 3.3896344208798*^9, 
  3.389635467619*^9, 3.389635548618*^9, 3.389659022663424*^9, 
  3.389659065354424*^9, 3.389694415802024*^9},
 CellLabel->"During evaluation of In[48]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.01599999999999992`", ",", "Null"}], "}"}]], "Output",
 CellChangeTimes->{3.3896338928262*^9, 3.3896344209138002`*^9, 
  3.389635467631*^9, 3.389635548653*^9, 3.3896590226724243`*^9, 
  3.3896590653774242`*^9, 3.3896944158040237`*^9},
 CellLabel->"Out[48]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"DepthDistribution", ":=", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{"PrState", "[", 
         RowBox[{"t", ",", 
          SuperscriptBox["n", "B"], ",", 
          SuperscriptBox["n", "A"]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SuperscriptBox["n", "B"], ",", "0", ",", 
          RowBox[{"Min", "[", 
           RowBox[{"MaxDepth", ",", "t"}], "]"}]}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SuperscriptBox["n", "A"], ",", "0", ",", "MaxDepth"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "1", ",", "T"}], "}"}]}], "]"}], "//", "Chop"}]}], 
  ";"}]], "Input",
 CellLabel->"In[49]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DepthDistribution", "//", "TableForm"}]], "Input",
 CellLabel->"In[50]:="],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "0.9251700680272108`", "0.8867547018807522`"},
    {"0", "0.07482993197278912`", "0.11324529811924765`"},
    {"0", "0", "0"},
    {"0", "0", "0"},
    {"0", "0", "0"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.3896339022202*^9, 3.3896344209578*^9, 3.389635548699*^9, 
  3.3896590228644238`*^9, 3.389659065409424*^9, 3.389694415878024*^9},
 CellLabel->"Out[50]//TableForm="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"PrintDepthDistribution", ":=", 
  RowBox[{"NumberForm", "[", 
   RowBox[{
    RowBox[{"TableForm", "[", 
     RowBox[{
      RowBox[{"Prepend", "[", 
       RowBox[{"DepthDistribution", ",", 
        RowBox[{"Range", "[", "T", "]"}]}], "]"}], ",", "\[IndentingNewLine]",
       
      RowBox[{"TableSpacing", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], ",", 
      RowBox[{"TableHeadings", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Prepend", "[", 
         RowBox[{
          RowBox[{"Range", "[", 
           RowBox[{"0", ",", "MaxDepth"}], "]"}], ",", "\"\<d\\\\t:\>\""}], 
         "]"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[51]:="],

Cell[CellGroupData[{

Cell[BoxData["PrintDepthDistribution"], "Input",
 CellLabel->"In[52]:="],

Cell[BoxData[
 TagBox[
  TagBox[
   TagBox[GridBox[{
      {
       TagBox["\<\"d\\\\t:\"\>",
        HoldForm], 
       InterpretationBox["\<\"1.000\"\>",
        1,
        Editable->False], 
       InterpretationBox["\<\"2.000\"\>",
        2,
        Editable->False], 
       InterpretationBox["\<\"3.000\"\>",
        3,
        Editable->False]},
      {
       TagBox[
        InterpretationBox["\<\"0.000\"\>",
         0,
         Editable->False],
        HoldForm], 
       InterpretationBox["\<\"1.000\"\>",
        1,
        Editable->False], 
       InterpretationBox["\<\"0.925\"\>",
        0.9251700680272108,
        AutoDelete->True], 
       InterpretationBox["\<\"0.887\"\>",
        0.8867547018807522,
        AutoDelete->True]},
      {
       TagBox[
        InterpretationBox["\<\"1.000\"\>",
         1,
         Editable->False],
        HoldForm], 
       InterpretationBox["\<\"0.000\"\>",
        0,
        Editable->False], 
       InterpretationBox["\<\"0.075\"\>",
        0.07482993197278912,
        AutoDelete->True], 
       InterpretationBox["\<\"0.113\"\>",
        0.11324529811924765`,
        AutoDelete->True]},
      {
       TagBox[
        InterpretationBox["\<\"2.000\"\>",
         2,
         Editable->False],
        HoldForm], 
       InterpretationBox["\<\"0.000\"\>",
        0,
        Editable->False], 
       InterpretationBox["\<\"0.000\"\>",
        0,
        Editable->False], 
       InterpretationBox["\<\"0.000\"\>",
        0,
        Editable->False]},
      {
       TagBox[
        InterpretationBox["\<\"3.000\"\>",
         3,
         Editable->False],
        HoldForm], 
       InterpretationBox["\<\"0.000\"\>",
        0,
        Editable->False], 
       InterpretationBox["\<\"0.000\"\>",
        0,
        Editable->False], 
       InterpretationBox["\<\"0.000\"\>",
        0,
        Editable->False]},
      {
       TagBox[
        InterpretationBox["\<\"4.000\"\>",
         4,
         Editable->False],
        HoldForm], 
       InterpretationBox["\<\"0.000\"\>",
        0,
        Editable->False], 
       InterpretationBox["\<\"0.000\"\>",
        0,
        Editable->False], 
       InterpretationBox["\<\"0.000\"\>",
        0,
        Editable->False]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxDividers->{
      "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
       "Rows" -> {{False}}, "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    {OutputFormsDump`HeadedRows, None}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, TableSpacing -> {1, 1}, 
     TableHeadings -> {{"d\\t:", 0, 1, 2, 3, 4}}]]],
  NumberForm[#, {5, 3}]& ]], "Output",
 CellChangeTimes->{3.3896339119902*^9, 3.3896344209978*^9, 
  3.3896355487390003`*^9, 3.389659022934424*^9, 3.389659065453424*^9, 
  3.389694415934024*^9},
 CellLabel->"Out[52]//NumberForm="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"ExpectedDepth", ":=", 
  RowBox[{
   RowBox[{"Transpose", "[", "DepthDistribution", "]"}], ".", 
   RowBox[{"Range", "[", 
    RowBox[{"0", ",", "MaxDepth"}], "]"}]}]}]], "Input",
 CellLabel->"In[53]:="],

Cell[BoxData[
 RowBox[{"PrintExpectedDepth", ":=", 
  RowBox[{"NumberForm", "[", 
   RowBox[{
    RowBox[{"TableForm", "[", 
     RowBox[{
      RowBox[{"Prepend", "[", 
       RowBox[{
        RowBox[{"{", "ExpectedDepth", "}"}], ",", 
        RowBox[{"Range", "[", "T", "]"}]}], "]"}], ",", "\[IndentingNewLine]",
       
      RowBox[{"TableSpacing", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], ",", 
      RowBox[{"TableHeadings", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"\"\<t\>\"", ",", "\"\<E[Depth]\>\""}], "}"}], "}"}]}]}], 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[54]:="],

Cell[CellGroupData[{

Cell[BoxData["PrintExpectedDepth"], "Input",
 CellLabel->"In[55]:="],

Cell[BoxData[
 TagBox[
  TagBox[
   TagBox[GridBox[{
      {
       TagBox["\<\"t\"\>",
        HoldForm], 
       InterpretationBox["\<\"1.000\"\>",
        1,
        Editable->False], 
       InterpretationBox["\<\"2.000\"\>",
        2,
        Editable->False], 
       InterpretationBox["\<\"3.000\"\>",
        3,
        Editable->False]},
      {
       TagBox["\<\"E[Depth]\"\>",
        HoldForm], 
       InterpretationBox["\<\"0.000\"\>",
        0.,
        AutoDelete->True], 
       InterpretationBox["\<\"0.075\"\>",
        0.07482993197278912,
        AutoDelete->True], 
       InterpretationBox["\<\"0.113\"\>",
        0.11324529811924765`,
        AutoDelete->True]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxDividers->{
      "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
       "Rows" -> {{False}}, "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    {OutputFormsDump`HeadedRows, None}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, TableSpacing -> {1, 1}, 
     TableHeadings -> {{"t", "E[Depth]"}}]]],
  NumberForm[#, {5, 3}]& ]], "Output",
 CellChangeTimes->{3.3896339292662*^9, 3.3896344210438004`*^9, 
  3.389635548784*^9, 3.389659023023424*^9, 3.389659065492424*^9, 
  3.389694415982024*^9},
 CellLabel->"Out[55]//NumberForm="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"EventProb", "[", "event_", "]"}], ":=", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"P", "[", 
         RowBox[{"t", ",", 
          SuperscriptBox["n", "B"], ",", 
          SuperscriptBox["n", "A"], ",", "event"}], "]"}], 
        RowBox[{"PrState", "[", 
         RowBox[{"t", ",", 
          SuperscriptBox["n", "B"], ",", 
          SuperscriptBox["n", "A"]}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["n", "B"], ",", "0", ",", 
         RowBox[{"Min", "[", 
          RowBox[{"MaxDepth", ",", "t"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["n", "A"], ",", "0", ",", 
         RowBox[{"Min", "[", 
          RowBox[{"MaxDepth", ",", "t"}], "]"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "1", ",", "T"}], "}"}]}], "]"}], "//", 
   "N"}]}]], "Input",
 CellLabel->"In[56]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EventProb", "[", "SellMkt", "]"}]], "Input",
 CellLabel->"In[57]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.1978973407544836`", ",", "0.21490414347557207`", ",", 
   "0.22727272727272727`"}], "}"}]], "Output",
 CellChangeTimes->{3.3896339293142*^9, 3.3896344210928*^9, 3.389635548854*^9, 
  3.3896590230624237`*^9, 3.389659065531424*^9, 3.389694416032024*^9},
 CellLabel->"Out[57]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"events", "=", 
   RowBox[{"{", 
    RowBox[{
    "SellMkt", ",", "SellLmt", ",", "SellOut", ",", "BuyOut", ",", "BuyLmt", 
     ",", "BuyMkt"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[58]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "SellMkt", ",", "SellLmt", ",", "SellOut", ",", "BuyOut", ",", "BuyLmt", 
    ",", "BuyMkt"}], "]"}], ";"}]], "Input",
 CellLabel->"In[59]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"PrintEventProbs", ":=", 
   RowBox[{"NumberForm", "[", 
    RowBox[{
     RowBox[{"TableForm", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"EventProb", "[", "#", "]"}], "&"}], "/@", "events"}], ",", 
       RowBox[{"TableHeadings", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"events", ",", 
          RowBox[{"Range", "[", "T", "]"}]}], "}"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "3"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[60]:="],

Cell[CellGroupData[{

Cell[BoxData["PrintEventProbs"], "Input",
 CellLabel->"In[61]:="],

Cell[BoxData[
 TagBox[
  TagBox[
   TagBox[GridBox[{
      {
       StyleBox["\[Null]",
        ShowStringCharacters->False], 
       TagBox[
        InterpretationBox["\<\"1.000\"\>",
         1,
         Editable->False],
        HoldForm], 
       TagBox[
        InterpretationBox["\<\"2.000\"\>",
         2,
         Editable->False],
        HoldForm], 
       TagBox[
        InterpretationBox["\<\"3.000\"\>",
         3,
         Editable->False],
        HoldForm]},
      {
       TagBox["SellMkt",
        HoldForm], 
       InterpretationBox["\<\"0.198\"\>",
        0.1978973407544836,
        AutoDelete->True], 
       InterpretationBox["\<\"0.215\"\>",
        0.21490414347557207`,
        AutoDelete->True], 
       InterpretationBox["\<\"0.227\"\>",
        0.22727272727272727`,
        AutoDelete->True]},
      {
       TagBox["SellLmt",
        HoldForm], 
       InterpretationBox["\<\"0.075\"\>",
        0.07482993197278912,
        AutoDelete->True], 
       InterpretationBox["\<\"0.054\"\>",
        0.05442176870748295,
        AutoDelete->True], 
       InterpretationBox["\<\"0.000\"\>",
        0.,
        AutoDelete->True]},
      {
       TagBox["SellOut",
        HoldForm], 
       InterpretationBox["\<\"0.227\"\>",
        0.2272727272727273,
        AutoDelete->True], 
       InterpretationBox["\<\"0.231\"\>",
        0.23067408781694496`,
        AutoDelete->True], 
       InterpretationBox["\<\"0.273\"\>",
        0.27272727272727265`,
        AutoDelete->True]},
      {
       TagBox["BuyOut",
        HoldForm], 
       InterpretationBox["\<\"0.227\"\>",
        0.2272727272727273,
        AutoDelete->True], 
       InterpretationBox["\<\"0.231\"\>",
        0.23067408781694496`,
        AutoDelete->True], 
       InterpretationBox["\<\"0.273\"\>",
        0.27272727272727265`,
        AutoDelete->True]},
      {
       TagBox["BuyLmt",
        HoldForm], 
       InterpretationBox["\<\"0.075\"\>",
        0.07482993197278914,
        AutoDelete->True], 
       InterpretationBox["\<\"0.054\"\>",
        0.05442176870748295,
        AutoDelete->True], 
       InterpretationBox["\<\"0.000\"\>",
        0.,
        AutoDelete->True]},
      {
       TagBox["BuyMkt",
        HoldForm], 
       InterpretationBox["\<\"0.198\"\>",
        0.19789734075448356`,
        AutoDelete->True], 
       InterpretationBox["\<\"0.215\"\>",
        0.21490414347557205`,
        AutoDelete->True], 
       InterpretationBox["\<\"0.227\"\>",
        0.22727272727272727`,
        AutoDelete->True]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxDividers->{
      "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
       "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, 
     TableHeadings -> {{$CellContext`SellMkt, $CellContext`SellLmt, \
$CellContext`SellOut, $CellContext`BuyOut, $CellContext`BuyLmt, \
$CellContext`BuyMkt}, {1, 2, 3}}]]],
  NumberForm[#, {5, 3}]& ]], "Output",
 CellChangeTimes->{3.3896339293761997`*^9, 3.3896344211507998`*^9, 
  3.389635548917*^9, 3.389659023123424*^9, 3.389659065585424*^9, 
  3.3896944160930243`*^9},
 CellLabel->"Out[61]//NumberForm="]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Analyzes and graphs used in book", "Section"],

Cell[CellGroupData[{

Cell["Time profile with uniform distribution", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"InitializeAll", "[", "3", "]"}], ";", 
   RowBox[{"Calculate", "[", "]"}], ";"}], "]"}]], "Input",
 CellLabel->"In[65]:="],

Cell[BoxData["\<\"Initializing all probabilities and rules.\"\>"], "Print",
 CellChangeTimes->{
  3.3896339397482*^9, 3.3896344450797997`*^9, 3.389635484049*^9, {
   3.3896355531289997`*^9, 3.389635559856*^9}},
 CellLabel->"During evaluation of In[65]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"T=\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" \\!\\(\\*SubscriptBox[\\(F\\), \\(\[Beta]\\\\ \
Rule\\)]\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SubscriptBox["F", "\[Beta]"], "[", "\[Beta]_", "]"}], "\[RuleDelayed]", 
    RowBox[{"CDF", "[", 
     RowBox[{
      RowBox[{"UniformDistribution", "[", 
       RowBox[{"{", 
        RowBox[{
         UnderscriptBox["\[Beta]", "_"], ",", 
         OverscriptBox["\[Beta]", "_"]}], "}"}], "]"}], ",", "\[Beta]"}], 
     "]"}]}], "\[InvisibleSpace]", "\<\" \
\\!\\(\\*UnderscriptBox[\\(\[Beta]\\), \\(_\\)]\\)=\"\>", "\[InvisibleSpace]",
    "0", "\[InvisibleSpace]", "\<\" \\!\\(\\*OverscriptBox[\\(\[Beta]\\), \
\\(_\\)]\\)=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" V=\"\>", "\[InvisibleSpace]", "5.5`", 
   "\[InvisibleSpace]", "\<\" B=\"\>", "\[InvisibleSpace]", "5.`", 
   "\[InvisibleSpace]", "\<\" A=\"\>", "\[InvisibleSpace]", "6.`"}],
  SequenceForm[
  "T=", 3, " \!\(\*SubscriptBox[\(F\), \(\[Beta]\\ Rule\)]\)=", \
$CellContext`F\[Beta][
     Pattern[$CellContext`\[Beta], 
      Blank[]]] :> CDF[
     UniformDistribution[{$CellContext`\[Beta]\[UnderBracket]Underscript\
\[UnderBracket]Underscore, $CellContext`\[Beta]\[UnderBracket]Overscript\
\[UnderBracket]Underscore}], $CellContext`\[Beta]], 
   " \!\(\*UnderscriptBox[\(\[Beta]\), \(_\)]\)=", 0, 
   " \!\(\*OverscriptBox[\(\[Beta]\), \(_\)]\)=", 2, " V=", 5.5, " B=", 5., 
   " A=", 6.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.3896339397482*^9, 3.3896344450797997`*^9, 3.389635484049*^9, {
   3.3896355531289997`*^9, 3.389635559861*^9}},
 CellLabel->"During evaluation of In[65]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Max discrepancy in transition probabilities=\"\>", 
   "\[InvisibleSpace]", "0.`"}],
  SequenceForm["Max discrepancy in transition probabilities=", 0.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.3896339397482*^9, 3.3896344450797997`*^9, 3.389635484049*^9, {
   3.3896355531289997`*^9, 3.389635559887*^9}},
 CellLabel->"During evaluation of In[65]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Max discrepancy in state probabilities=\"\>", 
   "\[InvisibleSpace]", "1.1102230246251565`*^-16"}],
  SequenceForm[
  "Max discrepancy in state probabilities=", 1.1102230246251565`*^-16],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.3896339397482*^9, 3.3896344450797997`*^9, 3.389635484049*^9, {
   3.3896355531289997`*^9, 3.389635559891*^9}},
 CellLabel->"During evaluation of In[65]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.0310000000000001`", ",", "Null"}], "}"}]], "Output",
 CellChangeTimes->{
  3.3896339397872*^9, 3.3896344452288*^9, 3.389635484071*^9, {
   3.389635553148*^9, 3.389635559894*^9}},
 CellLabel->"Out[65]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["PrintExpectedDepth"], "Input",
 CellLabel->"In[66]:="],

Cell[BoxData[
 TagBox[
  TagBox[
   TagBox[GridBox[{
      {
       TagBox["\<\"t\"\>",
        HoldForm], 
       InterpretationBox["\<\"1.000\"\>",
        1,
        Editable->False], 
       InterpretationBox["\<\"2.000\"\>",
        2,
        Editable->False], 
       InterpretationBox["\<\"3.000\"\>",
        3,
        Editable->False]},
      {
       TagBox["\<\"E[Depth]\"\>",
        HoldForm], 
       InterpretationBox["\<\"0.000\"\>",
        0.,
        AutoDelete->True], 
       InterpretationBox["\<\"0.075\"\>",
        0.07482993197278912,
        AutoDelete->True], 
       InterpretationBox["\<\"0.113\"\>",
        0.11324529811924765`,
        AutoDelete->True]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxDividers->{
      "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
       "Rows" -> {{False}}, "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    {OutputFormsDump`HeadedRows, None}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, TableSpacing -> {1, 1}, 
     TableHeadings -> {{"t", "E[Depth]"}}]]],
  NumberForm[#, {5, 3}]& ]], "Output",
 CellChangeTimes->{3.3896339398482*^9, 3.3896344452988*^9, 3.389635484132*^9, 
  3.389635559959*^9},
 CellLabel->"Out[66]//NumberForm="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpectedDepthT3", "=", "ExpectedDepth"}], ";"}]], "Input",
 CellLabel->"In[67]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"InitializeAll", "[", "5", "]"}], ";", 
   RowBox[{"Calculate", "[", "]"}], ";"}], "]"}]], "Input",
 CellLabel->"In[68]:="],

Cell[BoxData["\<\"Initializing all probabilities and rules.\"\>"], "Print",
 CellChangeTimes->{3.3896339398922*^9, 3.3896344453398*^9, 3.389635484207*^9, 
  3.389635560001*^9},
 CellLabel->"During evaluation of In[68]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"T=\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" \\!\\(\\*SubscriptBox[\\(F\\), \\(\[Beta]\\\\ \
Rule\\)]\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SubscriptBox["F", "\[Beta]"], "[", "\[Beta]_", "]"}], "\[RuleDelayed]", 
    RowBox[{"CDF", "[", 
     RowBox[{
      RowBox[{"UniformDistribution", "[", 
       RowBox[{"{", 
        RowBox[{
         UnderscriptBox["\[Beta]", "_"], ",", 
         OverscriptBox["\[Beta]", "_"]}], "}"}], "]"}], ",", "\[Beta]"}], 
     "]"}]}], "\[InvisibleSpace]", "\<\" \
\\!\\(\\*UnderscriptBox[\\(\[Beta]\\), \\(_\\)]\\)=\"\>", "\[InvisibleSpace]",
    "0", "\[InvisibleSpace]", "\<\" \\!\\(\\*OverscriptBox[\\(\[Beta]\\), \
\\(_\\)]\\)=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" V=\"\>", "\[InvisibleSpace]", "5.5`", 
   "\[InvisibleSpace]", "\<\" B=\"\>", "\[InvisibleSpace]", "5.`", 
   "\[InvisibleSpace]", "\<\" A=\"\>", "\[InvisibleSpace]", "6.`"}],
  SequenceForm[
  "T=", 5, " \!\(\*SubscriptBox[\(F\), \(\[Beta]\\ Rule\)]\)=", \
$CellContext`F\[Beta][
     Pattern[$CellContext`\[Beta], 
      Blank[]]] :> CDF[
     UniformDistribution[{$CellContext`\[Beta]\[UnderBracket]Underscript\
\[UnderBracket]Underscore, $CellContext`\[Beta]\[UnderBracket]Overscript\
\[UnderBracket]Underscore}], $CellContext`\[Beta]], 
   " \!\(\*UnderscriptBox[\(\[Beta]\), \(_\)]\)=", 0, 
   " \!\(\*OverscriptBox[\(\[Beta]\), \(_\)]\)=", 2, " V=", 5.5, " B=", 5., 
   " A=", 6.],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896339398922*^9, 3.3896344453398*^9, 3.389635484207*^9, 
  3.389635560023*^9},
 CellLabel->"During evaluation of In[68]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Max discrepancy in transition probabilities=\"\>", 
   "\[InvisibleSpace]", "1.1102230246251565`*^-16"}],
  SequenceForm[
  "Max discrepancy in transition probabilities=", 1.1102230246251565`*^-16],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896339398922*^9, 3.3896344453398*^9, 3.389635484207*^9, 
  3.389635560127*^9},
 CellLabel->"During evaluation of In[68]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Max discrepancy in state probabilities=\"\>", 
   "\[InvisibleSpace]", "1.1102230246251565`*^-16"}],
  SequenceForm[
  "Max discrepancy in state probabilities=", 1.1102230246251565`*^-16],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896339398922*^9, 3.3896344453398*^9, 3.389635484207*^9, 
  3.389635560164*^9},
 CellLabel->"During evaluation of In[68]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.09400000000000001`", ",", "Null"}], "}"}]], "Output",
 CellChangeTimes->{3.3896339400942*^9, 3.3896344455118*^9, 
  3.3896354843719997`*^9, 3.3896355602019997`*^9},
 CellLabel->"Out[68]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpectedDepthT5", "=", "ExpectedDepth"}], ";"}]], "Input",
 CellLabel->"In[69]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"InitializeAll", "[", "7", "]"}], ";", 
   RowBox[{"Calculate", "[", "]"}], ";"}], "]"}]], "Input",
 CellLabel->"In[70]:="],

Cell[BoxData["\<\"Initializing all probabilities and rules.\"\>"], "Print",
 CellChangeTimes->{3.3896339401572*^9, 3.3896344455758*^9, 3.389635484417*^9, 
  3.38963556027*^9},
 CellLabel->"During evaluation of In[70]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"T=\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" \\!\\(\\*SubscriptBox[\\(F\\), \\(\[Beta]\\\\ \
Rule\\)]\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SubscriptBox["F", "\[Beta]"], "[", "\[Beta]_", "]"}], "\[RuleDelayed]", 
    RowBox[{"CDF", "[", 
     RowBox[{
      RowBox[{"UniformDistribution", "[", 
       RowBox[{"{", 
        RowBox[{
         UnderscriptBox["\[Beta]", "_"], ",", 
         OverscriptBox["\[Beta]", "_"]}], "}"}], "]"}], ",", "\[Beta]"}], 
     "]"}]}], "\[InvisibleSpace]", "\<\" \
\\!\\(\\*UnderscriptBox[\\(\[Beta]\\), \\(_\\)]\\)=\"\>", "\[InvisibleSpace]",
    "0", "\[InvisibleSpace]", "\<\" \\!\\(\\*OverscriptBox[\\(\[Beta]\\), \
\\(_\\)]\\)=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" V=\"\>", "\[InvisibleSpace]", "5.5`", 
   "\[InvisibleSpace]", "\<\" B=\"\>", "\[InvisibleSpace]", "5.`", 
   "\[InvisibleSpace]", "\<\" A=\"\>", "\[InvisibleSpace]", "6.`"}],
  SequenceForm[
  "T=", 7, " \!\(\*SubscriptBox[\(F\), \(\[Beta]\\ Rule\)]\)=", \
$CellContext`F\[Beta][
     Pattern[$CellContext`\[Beta], 
      Blank[]]] :> CDF[
     UniformDistribution[{$CellContext`\[Beta]\[UnderBracket]Underscript\
\[UnderBracket]Underscore, $CellContext`\[Beta]\[UnderBracket]Overscript\
\[UnderBracket]Underscore}], $CellContext`\[Beta]], 
   " \!\(\*UnderscriptBox[\(\[Beta]\), \(_\)]\)=", 0, 
   " \!\(\*OverscriptBox[\(\[Beta]\), \(_\)]\)=", 2, " V=", 5.5, " B=", 5., 
   " A=", 6.],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896339401572*^9, 3.3896344455758*^9, 3.389635484417*^9, 
  3.389635560293*^9},
 CellLabel->"During evaluation of In[70]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Max discrepancy in transition probabilities=\"\>", 
   "\[InvisibleSpace]", "1.1102230246251565`*^-16"}],
  SequenceForm[
  "Max discrepancy in transition probabilities=", 1.1102230246251565`*^-16],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896339401572*^9, 3.3896344455758*^9, 3.389635484417*^9, 
  3.3896355612279997`*^9},
 CellLabel->"During evaluation of In[70]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Max discrepancy in state probabilities=\"\>", 
   "\[InvisibleSpace]", "3.3306690738754696`*^-16"}],
  SequenceForm[
  "Max discrepancy in state probabilities=", 3.3306690738754696`*^-16],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896339401572*^9, 3.3896344455758*^9, 3.389635484417*^9, 
  3.389635561863*^9},
 CellLabel->"During evaluation of In[70]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.4669999999999999`", ",", "Null"}], "}"}]], "Output",
 CellChangeTimes->{3.3896339417942*^9, 3.3896344471938*^9, 3.389635486016*^9, 
  3.389635561898*^9},
 CellLabel->"Out[70]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpectedDepthT7", "=", "ExpectedDepth"}], ";"}]], "Input",
 CellLabel->"In[71]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"InitializeAll", "[", "9", "]"}], ";", 
   RowBox[{"Calculate", "[", "3", "]"}], ";"}], "]"}]], "Input",
 CellLabel->"In[72]:="],

Cell[BoxData["\<\"Initializing all probabilities and rules.\"\>"], "Print",
 CellChangeTimes->{3.3896339424882*^9, 3.3896344478998003`*^9, 
  3.389635486097*^9, 3.389635562601*^9},
 CellLabel->"During evaluation of In[72]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"T=\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" \\!\\(\\*SubscriptBox[\\(F\\), \\(\[Beta]\\\\ \
Rule\\)]\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SubscriptBox["F", "\[Beta]"], "[", "\[Beta]_", "]"}], "\[RuleDelayed]", 
    RowBox[{"CDF", "[", 
     RowBox[{
      RowBox[{"UniformDistribution", "[", 
       RowBox[{"{", 
        RowBox[{
         UnderscriptBox["\[Beta]", "_"], ",", 
         OverscriptBox["\[Beta]", "_"]}], "}"}], "]"}], ",", "\[Beta]"}], 
     "]"}]}], "\[InvisibleSpace]", "\<\" \
\\!\\(\\*UnderscriptBox[\\(\[Beta]\\), \\(_\\)]\\)=\"\>", "\[InvisibleSpace]",
    "0", "\[InvisibleSpace]", "\<\" \\!\\(\\*OverscriptBox[\\(\[Beta]\\), \
\\(_\\)]\\)=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" V=\"\>", "\[InvisibleSpace]", "5.5`", 
   "\[InvisibleSpace]", "\<\" B=\"\>", "\[InvisibleSpace]", "5.`", 
   "\[InvisibleSpace]", "\<\" A=\"\>", "\[InvisibleSpace]", "6.`"}],
  SequenceForm[
  "T=", 9, " \!\(\*SubscriptBox[\(F\), \(\[Beta]\\ Rule\)]\)=", \
$CellContext`F\[Beta][
     Pattern[$CellContext`\[Beta], 
      Blank[]]] :> CDF[
     UniformDistribution[{$CellContext`\[Beta]\[UnderBracket]Underscript\
\[UnderBracket]Underscore, $CellContext`\[Beta]\[UnderBracket]Overscript\
\[UnderBracket]Underscore}], $CellContext`\[Beta]], 
   " \!\(\*UnderscriptBox[\(\[Beta]\), \(_\)]\)=", 0, 
   " \!\(\*OverscriptBox[\(\[Beta]\), \(_\)]\)=", 2, " V=", 5.5, " B=", 5., 
   " A=", 6.],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896339424882*^9, 3.3896344478998003`*^9, 
  3.389635486097*^9, 3.389635562623*^9},
 CellLabel->"During evaluation of In[72]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Max discrepancy in transition probabilities=\"\>", 
   "\[InvisibleSpace]", "1.1102230246251565`*^-16"}],
  SequenceForm[
  "Max discrepancy in transition probabilities=", 1.1102230246251565`*^-16],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896339424882*^9, 3.3896344478998003`*^9, 
  3.389635486097*^9, 3.389635572466*^9},
 CellLabel->"During evaluation of In[72]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Max discrepancy in state probabilities=\"\>", 
   "\[InvisibleSpace]", "0.00026136240265939303`"}],
  SequenceForm[
  "Max discrepancy in state probabilities=", 0.00026136240265939303`],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896339424882*^9, 3.3896344478998003`*^9, 
  3.389635486097*^9, 3.389635579869*^9},
 CellLabel->"During evaluation of In[72]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"17.222`", ",", "Null"}], "}"}]], "Output",
 CellChangeTimes->{3.3896339596302*^9, 3.3896344650558*^9, 3.389635503355*^9, 
  3.389635579907*^9},
 CellLabel->"Out[72]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpectedDepthT9", "=", "ExpectedDepth"}], ";"}]], "Input",
 CellLabel->"In[73]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "ExpectedDepthT3", ",", "ExpectedDepthT5", ",", "ExpectedDepthT7", ",", 
     "ExpectedDepthT9"}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Dashing", "[", 
        RowBox[{"{", "}"}], "]"}], ",", 
       RowBox[{"{", "4", "}"}]}], "]"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<Trading period,t\>\"", ",", 
      "\"\<Expected ask depth, E[\!\(\*SubsuperscriptBox[\(n\), \(t\), \(A\)]\
\)] (shares)\>\""}], "}"}]}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Range", "[", "9", "]"}], ",", 
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", "4", ",", "0.1`"}], "]"}], ",", "None", ",", 
      "None"}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.9`", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0.6`"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ",", 
   RowBox[{"BaseStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.3896341222012*^9, {3.3896341578792*^9, 3.3896342519662*^9}},
 CellLabel->"In[74]:="],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Dashing[{}], 
    LineBox[{{1., 0.}, {2., 0.07482993197278912}, {3., 
     0.11324529811924765`}}]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Dashing[{}], 
    LineBox[{{1., 0.}, {2., 0.1136926625096096}, {3., 0.1828312403287828}, {
     4., 0.21737605070019123`}, {5., 0.21994910411841384`}}]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], Dashing[{}], 
    LineBox[{{1., 0.}, {2., 0.1566941007784104}, {3., 0.26459701866486596`}, {
     4., 0.32452751933892504`}, {5., 0.3496236240637034}, {6., 
     0.3500402744780992}, {7., 0.32335509339143303`}}]}, 
   {Hue[0.37820393249936934`, 0.6, 0.6], Dashing[{}], 
    LineBox[{{1., 0.}, {2., 0.19539564255728636`}, {3., 0.3518137752355958}, {
     4., 0.4477214324059716}, {5., 0.4954513923404329}, {6., 
     0.5090505703612467}, {7., 0.500086499339648}, {8., 0.4732538921990255}, {
     9., 0.42333183976754996`}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Times"},
  Frame->True,
  FrameLabel->{
    FormBox["\"Trading period,t\"", TraditionalForm], 
    FormBox[
    "\"Expected ask depth, E[\\!\\(\\*SubsuperscriptBox[\\(n\\), \\(t\\), \
\\(A\\)]\\)] (shares)\"", TraditionalForm]},
  FrameTicks->{{{1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}, {4, 
      FormBox["4", TraditionalForm]}, {5, 
      FormBox["5", TraditionalForm]}, {6, 
      FormBox["6", TraditionalForm]}, {7, 
      FormBox["7", TraditionalForm]}, {8, 
      FormBox["8", TraditionalForm]}, {9, 
      FormBox["9", TraditionalForm]}}, {{0., 
      FormBox["0.`", TraditionalForm]}, {0.1, 
      FormBox["0.1`", TraditionalForm]}, {0.2, 
      FormBox["0.2`", TraditionalForm]}, {0.30000000000000004`, 
      FormBox["0.30000000000000004`", TraditionalForm]}, {0.4, 
      FormBox["0.4`", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {0.6000000000000001, 
      FormBox["0.6000000000000001`", TraditionalForm]}, {0.7000000000000001, 
      FormBox["0.7000000000000001`", TraditionalForm]}, {0.8, 
      FormBox["0.8`", TraditionalForm]}, {0.9, 
      FormBox["0.9`", TraditionalForm]}, {1., 
      FormBox["1.`", TraditionalForm]}, {1.1, 
      FormBox["1.1`", TraditionalForm]}, {1.2000000000000002`, 
      FormBox["1.2000000000000002`", TraditionalForm]}, {1.3, 
      FormBox["1.3`", TraditionalForm]}, {1.4000000000000001`, 
      FormBox["1.4000000000000001`", TraditionalForm]}, {1.5, 
      FormBox["1.5`", TraditionalForm]}, {1.6, 
      FormBox["1.6`", TraditionalForm]}, {1.7000000000000002`, 
      FormBox["1.7000000000000002`", TraditionalForm]}, {1.8, 
      FormBox["1.8`", TraditionalForm]}, {1.9000000000000001`, 
      FormBox["1.9000000000000001`", TraditionalForm]}, {2., 
      FormBox["2.`", TraditionalForm]}, {2.1, 
      FormBox["2.1`", TraditionalForm]}, {2.2, 
      FormBox["2.2`", TraditionalForm]}, {2.3000000000000003`, 
      FormBox["2.3000000000000003`", TraditionalForm]}, {
     2.4000000000000004`, 
      FormBox["2.4000000000000004`", TraditionalForm]}, {2.5, 
      FormBox["2.5`", TraditionalForm]}, {2.6, 
      FormBox["2.6`", TraditionalForm]}, {2.7, 
      FormBox["2.7`", TraditionalForm]}, {2.8000000000000003`, 
      FormBox["2.8000000000000003`", TraditionalForm]}, {
     2.9000000000000004`, 
      FormBox["2.9000000000000004`", TraditionalForm]}, {3., 
      FormBox["3.`", TraditionalForm]}, {3.1, 
      FormBox["3.1`", TraditionalForm]}, {3.2, 
      FormBox["3.2`", TraditionalForm]}, {3.3000000000000003`, 
      FormBox["3.3000000000000003`", TraditionalForm]}, {
     3.4000000000000004`, 
      FormBox["3.4000000000000004`", TraditionalForm]}, {3.5, 
      FormBox["3.5`", TraditionalForm]}, {3.6, 
      FormBox["3.6`", TraditionalForm]}, {3.7, 
      FormBox["3.7`", TraditionalForm]}, {3.8000000000000003`, 
      FormBox["3.8000000000000003`", TraditionalForm]}, {
     3.9000000000000004`, 
      FormBox["3.9000000000000004`", TraditionalForm]}, {4., 
      FormBox["4.`", TraditionalForm]}}, None, None},
  PlotRange->{{0.9, 10}, {0, 0.6}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.3896342525452003`*^9, 3.3896344724737997`*^9, 
  3.389635503462*^9, 3.3896355874309998`*^9},
 CellLabel->"Out[74]=",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Order types", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"InitializeAll", "[", "5", "]"}], ";", 
   RowBox[{"Calculate", "[", "]"}], ";"}], "]"}]], "Input",
 CellLabel->"In[75]:="],

Cell[BoxData["\<\"Initializing all probabilities and rules.\"\>"], "Print",
 CellChangeTimes->{3.3896342798292*^9, 3.3896344779688*^9, 3.389635601726*^9},
 
 CellLabel->"During evaluation of In[75]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"T=\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" \\!\\(\\*SubscriptBox[\\(F\\), \\(\[Beta]\\\\ \
Rule\\)]\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SubscriptBox["F", "\[Beta]"], "[", "\[Beta]_", "]"}], "\[RuleDelayed]", 
    RowBox[{"CDF", "[", 
     RowBox[{
      RowBox[{"UniformDistribution", "[", 
       RowBox[{"{", 
        RowBox[{
         UnderscriptBox["\[Beta]", "_"], ",", 
         OverscriptBox["\[Beta]", "_"]}], "}"}], "]"}], ",", "\[Beta]"}], 
     "]"}]}], "\[InvisibleSpace]", "\<\" \
\\!\\(\\*UnderscriptBox[\\(\[Beta]\\), \\(_\\)]\\)=\"\>", "\[InvisibleSpace]",
    "0", "\[InvisibleSpace]", "\<\" \\!\\(\\*OverscriptBox[\\(\[Beta]\\), \
\\(_\\)]\\)=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" V=\"\>", "\[InvisibleSpace]", "5.5`", 
   "\[InvisibleSpace]", "\<\" B=\"\>", "\[InvisibleSpace]", "5.`", 
   "\[InvisibleSpace]", "\<\" A=\"\>", "\[InvisibleSpace]", "6.`"}],
  SequenceForm[
  "T=", 5, " \!\(\*SubscriptBox[\(F\), \(\[Beta]\\ Rule\)]\)=", \
$CellContext`F\[Beta][
     Pattern[$CellContext`\[Beta], 
      Blank[]]] :> CDF[
     UniformDistribution[{$CellContext`\[Beta]\[UnderBracket]Underscript\
\[UnderBracket]Underscore, $CellContext`\[Beta]\[UnderBracket]Overscript\
\[UnderBracket]Underscore}], $CellContext`\[Beta]], 
   " \!\(\*UnderscriptBox[\(\[Beta]\), \(_\)]\)=", 0, 
   " \!\(\*OverscriptBox[\(\[Beta]\), \(_\)]\)=", 2, " V=", 5.5, " B=", 5., 
   " A=", 6.],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896342798292*^9, 3.3896344779688*^9, 3.389635601731*^9},
 
 CellLabel->"During evaluation of In[75]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Max discrepancy in transition probabilities=\"\>", 
   "\[InvisibleSpace]", "1.1102230246251565`*^-16"}],
  SequenceForm[
  "Max discrepancy in transition probabilities=", 1.1102230246251565`*^-16],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896342798292*^9, 3.3896344779688*^9, 3.389635601829*^9},
 
 CellLabel->"During evaluation of In[75]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Max discrepancy in state probabilities=\"\>", 
   "\[InvisibleSpace]", "1.1102230246251565`*^-16"}],
  SequenceForm[
  "Max discrepancy in state probabilities=", 1.1102230246251565`*^-16],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896342798292*^9, 3.3896344779688*^9, 3.389635601859*^9},
 
 CellLabel->"During evaluation of In[75]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.10899999999999967`", ",", "Null"}], "}"}]], "Output",
 CellChangeTimes->{3.3896342799622*^9, 3.3896344781428003`*^9, 
  3.389635601861*^9},
 CellLabel->"Out[75]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ep", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"EventProb", "[", "#", "]"}], "&"}], "/@", "events"}]}]], "Input",\

 CellLabel->"In[76]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.1590346102176631`", ",", "0.183690437188319`", ",", 
     "0.20249501105512288`", ",", "0.21663766390515188`", ",", 
     "0.2272727272727273`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.1136926625096096`", ",", "0.0890368355389537`", ",", 
     "0.06996639481698481`", ",", "0.0467942788173318`", ",", "0.`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
    "0.2272727272727273`", ",", "0.2272727272727273`", ",", 
     "0.22753859412789224`", ",", "0.23656805727751629`", ",", 
     "0.2727272727272727`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.2272727272727273`", ",", "0.2272727272727273`", ",", 
     "0.22753859412789224`", ",", "0.23656805727751629`", ",", 
     "0.2727272727272727`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.11369266250960963`", ",", "0.08903683553895374`", ",", 
     "0.06996639481698486`", ",", "0.0467942788173318`", ",", "0.`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
    "0.15903461021766307`", ",", "0.18369043718831893`", ",", 
     "0.20249501105512285`", ",", "0.21663766390515188`", ",", 
     "0.2272727272727273`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.3896342801722*^9, 3.3896344783578*^9, 3.389635602067*^9},
 
 CellLabel->"Out[76]="]
}, Open  ]],

Cell["Unadorned graph:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Apply", "[", 
   RowBox[{"PercentileBarChart", ",", "ep"}], "]"}], ";"}]], "Input",
 CellLabel->"In[77]:="],

Cell["Adorned graph:", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"d1", "=", ".4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"Range", "[", 
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{"d1", "*", 
       RowBox[{"2", "/", "3"}]}]}], ",", "1", ",", 
     RowBox[{"d1", "/", "3"}]}], "]"}]}], ";", 
  RowBox[{"g", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"g", ",", 
     RowBox[{"Reverse", "[", "g", "]"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[78]:="],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"d1", "=", ".55"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"PercentileBarChart", "[", 
  RowBox[{"ep", ",", 
   RowBox[{"BarSpacing", "\[Rule]", "0.05"}], ",", 
   RowBox[{"BarEdges", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
   RowBox[{"BarStyle", "\[Rule]", 
    RowBox[{"GrayLevel", " ", "/@", " ", "g"}]}], ",", " ", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Trading period,\!\(\*
StyleBox[\" \",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"t\",
FontSlant->\"Italic\"]\)\>\"", ",", 
      "\"\<Cumulative event probabilities\>\""}], "}"}]}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Range", "[", "5", "]"}], ",", 
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", "1", ",", ".1"}], "]"}], ",", "None", ",", "None"}], 
     "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.49", ",", "5.55"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", ".02"}], ",", "1.01"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ",", 
   RowBox[{"Axes", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "None"}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", ".5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5.5", ",", ".5"}], "}"}]}], "}"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"Market\",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\" \",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"Sell\",
FontSlant->\"Italic\"]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"d1", ",", ".1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"Limit\",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\" \",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"Sell\",
FontSlant->\"Italic\"]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"d1", ",", ".22"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"No\",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\" \",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"order\",
FontSlant->\"Italic\"]\)\\n\!\(\*
StyleBox[\"(\",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"seller\",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\")\",
FontSlant->\"Italic\"]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"d1", ",", ".4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"No\",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\" \",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"order\",
FontSlant->\"Italic\"]\)\\n\!\(\*
StyleBox[\"(\",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"buyer\",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\")\",
FontSlant->\"Italic\"]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"d1", ",", ".63"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"Limit\",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\" \",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"Buy\",
FontSlant->\"Italic\"]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"d1", ",", ".78"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"Market\",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\" \",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"Buy\",
FontSlant->\"Italic\"]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"d1", ",", ".9"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "]"}]}], 
     "\[IndentingNewLine]", "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.389635618281*^9, 3.389635640705*^9}},
 CellLabel->"In[82]:="],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0.7333333333333334], EdgeForm[None], 
    RectangleBox[{0.525, 0}, {1.475, 0.1590346102176631}]}, 
   {GrayLevel[0.7333333333333334], EdgeForm[None], 
    RectangleBox[{1.525, 0}, {2.4749999999999996`, 0.183690437188319}]}, 
   {GrayLevel[0.7333333333333334], EdgeForm[None], 
    RectangleBox[{2.525, 0}, {3.4749999999999996`, 0.20249501105512288`}]}, 
   {GrayLevel[0.7333333333333334], EdgeForm[None], 
    RectangleBox[{3.525, 0}, {4.475, 0.21663766390515188`}]}, 
   {GrayLevel[0.7333333333333334], EdgeForm[None], 
    RectangleBox[{4.525, 0}, {5.4750000000000005`, 0.2272727272727273}]}, 
   {GrayLevel[0.8666666666666667], EdgeForm[None], 
    RectangleBox[{0.525, 0.1590346102176631}, {1.475, 0.2727272727272727}]}, 
   {GrayLevel[0.8666666666666667], EdgeForm[None], 
    RectangleBox[{1.525, 0.183690437188319}, \
{2.4749999999999996`, 0.2727272727272727}]}, 
   {GrayLevel[0.8666666666666667], EdgeForm[None], 
    RectangleBox[{2.525, 0.20249501105512288`}, \
{3.4749999999999996`, 0.2724614058721077}]}, 
   {GrayLevel[0.8666666666666667], EdgeForm[None], 
    RectangleBox[{3.525, 0.21663766390515188`}, \
{4.475, 0.26343194272248366`}]}, 
   {GrayLevel[0.8666666666666667], EdgeForm[None], 
    RectangleBox[{4.525, 0.2272727272727273}, \
{5.4750000000000005`, 0.2272727272727273}]}, 
   {GrayLevel[1.], EdgeForm[None], 
    RectangleBox[{0.525, 0.2727272727272727}, {1.475, 0.5}]}, 
   {GrayLevel[1.], EdgeForm[None], 
    RectangleBox[{1.525, 0.2727272727272727}, {2.4749999999999996`, 0.5}]}, 
   {GrayLevel[1.], EdgeForm[None], 
    RectangleBox[{2.525, 0.2724614058721077}, \
{3.4749999999999996`, 0.49999999999999994`}]}, 
   {GrayLevel[1.], EdgeForm[None], 
    RectangleBox[{3.525, 0.26343194272248366`}, \
{4.475, 0.49999999999999994`}]}, 
   {GrayLevel[1.], EdgeForm[None], 
    RectangleBox[{4.525, 0.2272727272727273}, {5.4750000000000005`, 0.5}]}, 
   {GrayLevel[1.], EdgeForm[None], 
    RectangleBox[{0.525, 0.5}, {1.475, 0.7272727272727273}]}, 
   {GrayLevel[1.], EdgeForm[None], 
    RectangleBox[{1.525, 0.5}, {2.4749999999999996`, 0.7272727272727273}]}, 
   {GrayLevel[1.], EdgeForm[None], 
    RectangleBox[{2.525, 0.49999999999999994`}, \
{3.4749999999999996`, 0.7275385941278922}]}, 
   {GrayLevel[1.], EdgeForm[None], 
    RectangleBox[{3.525, 0.49999999999999994`}, \
{4.475, 0.7365680572775162}]}, 
   {GrayLevel[1.], EdgeForm[None], 
    RectangleBox[{4.525, 0.5}, {5.4750000000000005`, 0.7727272727272727}]}, 
   {GrayLevel[0.8666666666666667], EdgeForm[None], 
    RectangleBox[{0.525, 0.7272727272727273}, {1.475, 0.8409653897823369}]}, 
   {GrayLevel[0.8666666666666667], EdgeForm[None], 
    RectangleBox[{1.525, 0.7272727272727273}, \
{2.4749999999999996`, 0.816309562811681}]}, 
   {GrayLevel[0.8666666666666667], EdgeForm[None], 
    RectangleBox[{2.525, 0.7275385941278922}, \
{3.4749999999999996`, 0.7975049889448771}]}, 
   {GrayLevel[0.8666666666666667], EdgeForm[None], 
    RectangleBox[{3.525, 0.7365680572775162}, {4.475, 0.783362336094848}]}, 
   {GrayLevel[0.8666666666666667], EdgeForm[None], 
    RectangleBox[{4.525, 0.7727272727272727}, \
{5.4750000000000005`, 0.7727272727272727}]}, 
   {GrayLevel[0.7333333333333334], EdgeForm[None], 
    RectangleBox[{0.525, 0.8409653897823369}, {1.475, 1.}]}, 
   {GrayLevel[0.7333333333333334], EdgeForm[None], 
    RectangleBox[{1.525, 0.816309562811681}, \
{2.4749999999999996`, 0.9999999999999999}]}, 
   {GrayLevel[0.7333333333333334], EdgeForm[None], 
    RectangleBox[{2.525, 0.7975049889448771}, {3.4749999999999996`, 1.}]}, 
   {GrayLevel[0.7333333333333334], EdgeForm[None], 
    RectangleBox[{3.525, 0.783362336094848}, {4.475, 0.9999999999999998}]}, 
   {GrayLevel[0.7333333333333334], EdgeForm[None], 
    RectangleBox[{4.525, 0.7727272727272727}, {5.4750000000000005`, 1.}]}},
  AlignmentPoint->Center,
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{None, None},
  AxesLabel->None,
  AxesOrigin->{0, 0},
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DisplayFunction:>$DisplayFunction,
  Epilog->{
    LineBox[{{0, 0.5}, {5.5, 0.5}}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"Market\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\\
!\\(\\*\\nStyleBox[\\\" \
\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[\\\"Sell\\\",\\\
nFontSlant->\\\"Italic\\\"]\\)\"", TraditionalForm], {0.55, 0.1}, {-1, 0}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"Limit\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\
\\(\\*\\nStyleBox[\\\" \
\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[\\\"Sell\\\",\\\
nFontSlant->\\\"Italic\\\"]\\)\"", TraditionalForm], {0.55, 0.22}, {-1, 0}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"No\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\
\\*\\nStyleBox[\\\" \
\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[\\\"order\\\",\\\
nFontSlant->\\\"Italic\\\"]\\)\\n\\!\\(\\*\\nStyleBox[\\\"(\\\",\\nFontSlant->\
\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[\\\"seller\\\",\\nFontSlant->\\\"\
Italic\\\"]\\)\\!\\(\\*\\nStyleBox[\\\")\\\",\\nFontSlant->\\\"Italic\\\"]\\)\
\"", TraditionalForm], {0.55, 0.4}, {-1, 0}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"No\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\
\\*\\nStyleBox[\\\" \
\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[\\\"order\\\",\\\
nFontSlant->\\\"Italic\\\"]\\)\\n\\!\\(\\*\\nStyleBox[\\\"(\\\",\\nFontSlant->\
\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[\\\"buyer\\\",\\nFontSlant->\\\"Italic\
\\\"]\\)\\!\\(\\*\\nStyleBox[\\\")\\\",\\nFontSlant->\\\"Italic\\\"]\\)\"", 
      TraditionalForm], {0.55, 0.63}, {-1, 0}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"Limit\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\
\\(\\*\\nStyleBox[\\\" \
\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[\\\"Buy\\\",\\\
nFontSlant->\\\"Italic\\\"]\\)\"", TraditionalForm], {0.55, 0.78}, {-1, 0}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"Market\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\\
!\\(\\*\\nStyleBox[\\\" \
\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[\\\"Buy\\\",\\\
nFontSlant->\\\"Italic\\\"]\\)\"", TraditionalForm], {0.55, 0.9}, {-1, 0}]},
  FormatType:>TraditionalForm,
  Frame->True,
  FrameLabel->{
    FormBox[
    "\"Trading period,\\!\\(\\*\\nStyleBox[\\\" \\\",\\nFontSlant->\\\"Italic\
\\\"]\\)\\!\\(\\*\\nStyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]\\)\"", 
     TraditionalForm], 
    FormBox["\"Cumulative event probabilities\"", TraditionalForm]},
  FrameStyle->{},
  FrameTicks->{{{1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}, {4, 
      FormBox["4", TraditionalForm]}, {5, 
      FormBox["5", TraditionalForm]}}, {{0., 
      FormBox["0.`", TraditionalForm]}, {0.1, 
      FormBox["0.1`", TraditionalForm]}, {0.2, 
      FormBox["0.2`", TraditionalForm]}, {0.30000000000000004`, 
      FormBox["0.30000000000000004`", TraditionalForm]}, {0.4, 
      FormBox["0.4`", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {0.6000000000000001, 
      FormBox["0.6000000000000001`", TraditionalForm]}, {0.7000000000000001, 
      FormBox["0.7000000000000001`", TraditionalForm]}, {0.8, 
      FormBox["0.8`", TraditionalForm]}, {0.9, 
      FormBox["0.9`", TraditionalForm]}, {1., 
      FormBox["1.`", TraditionalForm]}}, None, None},
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->{{0.49, 5.55}, {-0.02, 1.01}},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  PreserveImageOptions->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->{{{1, 
      FormBox["1", TraditionalForm], 0}, {2, 
      FormBox["2", TraditionalForm], 0}, {3, 
      FormBox["3", TraditionalForm], 0}, {4, 
      FormBox["4", TraditionalForm], 0}, {5, 
      FormBox["5", TraditionalForm], 0}}, {{0., 
      FormBox["\"0%\"", TraditionalForm]}, {0.1, 
      FormBox["\"10%\"", TraditionalForm]}, {0.2, 
      FormBox["\"20%\"", TraditionalForm]}, {0.30000000000000004`, 
      FormBox["\"30%\"", TraditionalForm]}, {0.4, 
      FormBox["\"40%\"", TraditionalForm]}, {0.5, 
      FormBox["\"50%\"", TraditionalForm]}, {0.6000000000000001, 
      FormBox["\"60%\"", TraditionalForm]}, {0.7000000000000001, 
      FormBox["\"70%\"", TraditionalForm]}, {0.8, 
      FormBox["\"80%\"", TraditionalForm]}, {0.9, 
      FormBox["\"90%\"", TraditionalForm]}, {1., 
      FormBox["\"100%\"", TraditionalForm]}}},
  TicksStyle->{}]], "Output",
 CellChangeTimes->{3.389635641824*^9},
 CellLabel->"Out[83]=",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Effects of different distributions", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"InitializeAll", "[", 
    RowBox[{"5", ",", 
     SubscriptBox["F", 
      RowBox[{"\[Beta]", " ", "Wing"}]]}], "]"}], ";", 
   RowBox[{"Calculate", "[", "]"}], ";"}], "]"}]], "Input",
 CellLabel->"In[84]:="],

Cell[BoxData["\<\"Initializing all probabilities and rules.\"\>"], "Print",
 CellChangeTimes->{3.389635848966*^9},
 CellLabel->"During evaluation of In[84]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"T=\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" \\!\\(\\*SubscriptBox[\\(F\\), \\(\[Beta]\\\\ \
Rule\\)]\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SubscriptBox["F", "\[Beta]"], "[", "\[Beta]_", "]"}], "\[RuleDelayed]", 
    RowBox[{"Which", "[", 
     RowBox[{
      RowBox[{"\[Beta]", "\[LessEqual]", "0"}], ",", "0", ",", 
      RowBox[{"0", "<", "\[Beta]", "\[LessEqual]", "1"}], ",", 
      RowBox[{"\[Beta]", "-", 
       FractionBox[
        SuperscriptBox["\[Beta]", "2"], "2"]}], ",", 
      RowBox[{"1", "<", "\[Beta]", "<", "2"}], ",", 
      RowBox[{"1", "-", "\[Beta]", "+", 
       FractionBox[
        SuperscriptBox["\[Beta]", "2"], "2"]}], ",", 
      RowBox[{"\[Beta]", "\[GreaterEqual]", "2"}], ",", "1"}], "]"}]}], 
   "\[InvisibleSpace]", "\<\" \\!\\(\\*UnderscriptBox[\\(\[Beta]\\), \\(_\\)]\
\\)=\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\" \\!\\(\\*OverscriptBox[\\(\[Beta]\\), \
\\(_\\)]\\)=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" V=\"\>", "\[InvisibleSpace]", "5.5`", 
   "\[InvisibleSpace]", "\<\" B=\"\>", "\[InvisibleSpace]", "5.`", 
   "\[InvisibleSpace]", "\<\" A=\"\>", "\[InvisibleSpace]", "6.`"}],
  SequenceForm[
  "T=", 5, " \!\(\*SubscriptBox[\(F\), \(\[Beta]\\ Rule\)]\)=", \
$CellContext`F\[Beta][
     Pattern[$CellContext`\[Beta], 
      Blank[]]] :> Which[$CellContext`\[Beta] <= 0, 0, 
     Inequality[
     0, Less, $CellContext`\[Beta], LessEqual, 
      1], $CellContext`\[Beta] - $CellContext`\[Beta]^2/2, 
     1 < $CellContext`\[Beta] < 2, 
     1 - $CellContext`\[Beta] + $CellContext`\[Beta]^2/
      2, $CellContext`\[Beta] >= 2, 1], 
   " \!\(\*UnderscriptBox[\(\[Beta]\), \(_\)]\)=", 0, 
   " \!\(\*OverscriptBox[\(\[Beta]\), \(_\)]\)=", 2, " V=", 5.5, " B=", 5., 
   " A=", 6.],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896358489969997`*^9},
 CellLabel->"During evaluation of In[84]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Max discrepancy in transition probabilities=\"\>", 
   "\[InvisibleSpace]", "1.1102230246251565`*^-16"}],
  SequenceForm[
  "Max discrepancy in transition probabilities=", 1.1102230246251565`*^-16],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896358490480003`*^9},
 CellLabel->"During evaluation of In[84]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Max discrepancy in state probabilities=\"\>", 
   "\[InvisibleSpace]", "1.1102230246251565`*^-16"}],
  SequenceForm[
  "Max discrepancy in state probabilities=", 1.1102230246251565`*^-16],
  Editable->False]], "Print",
 CellChangeTimes->{3.389635849099*^9},
 CellLabel->"During evaluation of In[84]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.1090000000000011`", ",", "Null"}], "}"}]], "Output",
 CellChangeTimes->{3.389635849139*^9},
 CellLabel->"Out[84]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedDepthWing", "=", "ExpectedDepth"}]], "Input",
 CellLabel->"In[85]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.`", ",", "0.05227084182808278`", ",", "0.06853063943424784`", ",", 
   "0.06681967791490985`", ",", "0.05785769920854977`"}], "}"}]], "Output",
 CellChangeTimes->{3.38963584924*^9},
 CellLabel->"Out[85]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"InitializeAll", "[", 
    RowBox[{"5", ",", 
     SubscriptBox["F", 
      RowBox[{"\[Beta]", " ", "Triangular"}]]}], "]"}], ";", 
   RowBox[{"Calculate", "[", "]"}], ";"}], "]"}]], "Input",
 CellLabel->"In[86]:="],

Cell[BoxData["\<\"Initializing all probabilities and rules.\"\>"], "Print",
 CellChangeTimes->{3.389635849283*^9},
 CellLabel->"During evaluation of In[86]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"T=\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" \\!\\(\\*SubscriptBox[\\(F\\), \\(\[Beta]\\\\ \
Rule\\)]\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SubscriptBox["F", "\[Beta]"], "[", "\[Beta]_", "]"}], "\[RuleDelayed]", 
    RowBox[{"Which", "[", 
     RowBox[{
      RowBox[{"\[Beta]", "\[LessEqual]", "0"}], ",", "0", ",", 
      RowBox[{"0", "<", "\[Beta]", "\[LessEqual]", "1"}], ",", 
      FractionBox[
       SuperscriptBox["\[Beta]", "2"], "2"], ",", 
      RowBox[{"1", "<", "\[Beta]", "\[LessEqual]", "2"}], ",", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"2", " ", "\[Beta]"}], "-", 
       FractionBox[
        SuperscriptBox["\[Beta]", "2"], "2"]}], ",", 
      RowBox[{"\[Beta]", ">", "2"}], ",", "1"}], "]"}]}], 
   "\[InvisibleSpace]", "\<\" \\!\\(\\*UnderscriptBox[\\(\[Beta]\\), \\(_\\)]\
\\)=\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\" \\!\\(\\*OverscriptBox[\\(\[Beta]\\), \
\\(_\\)]\\)=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" V=\"\>", "\[InvisibleSpace]", "5.5`", 
   "\[InvisibleSpace]", "\<\" B=\"\>", "\[InvisibleSpace]", "5.`", 
   "\[InvisibleSpace]", "\<\" A=\"\>", "\[InvisibleSpace]", "6.`"}],
  SequenceForm[
  "T=", 5, " \!\(\*SubscriptBox[\(F\), \(\[Beta]\\ Rule\)]\)=", \
$CellContext`F\[Beta][
     Pattern[$CellContext`\[Beta], 
      Blank[]]] :> Which[$CellContext`\[Beta] <= 0, 0, 
     Inequality[
     0, Less, $CellContext`\[Beta], LessEqual, 1], $CellContext`\[Beta]^2/2, 
     Inequality[1, Less, $CellContext`\[Beta], LessEqual, 2], -1 + 
     2 $CellContext`\[Beta] - $CellContext`\[Beta]^2/2, $CellContext`\[Beta] > 
     2, 1], " \!\(\*UnderscriptBox[\(\[Beta]\), \(_\)]\)=", 0, 
   " \!\(\*OverscriptBox[\(\[Beta]\), \(_\)]\)=", 2, " V=", 5.5, " B=", 5., 
   " A=", 6.],
  Editable->False]], "Print",
 CellChangeTimes->{3.389635849302*^9},
 CellLabel->"During evaluation of In[86]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Max discrepancy in transition probabilities=\"\>", 
   "\[InvisibleSpace]", "0.`"}],
  SequenceForm["Max discrepancy in transition probabilities=", 0.],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896358493780003`*^9},
 CellLabel->"During evaluation of In[86]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Max discrepancy in state probabilities=\"\>", 
   "\[InvisibleSpace]", "1.1102230246251565`*^-16"}],
  SequenceForm[
  "Max discrepancy in state probabilities=", 1.1102230246251565`*^-16],
  Editable->False]], "Print",
 CellChangeTimes->{3.38963584942*^9},
 CellLabel->"During evaluation of In[86]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.07800000000000042`", ",", "Null"}], "}"}]], "Output",
 CellChangeTimes->{3.389635849461*^9},
 CellLabel->"Out[86]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedDepthTriangular", "=", "ExpectedDepth"}]], "Input",
 CellLabel->"In[87]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.`", ",", "0.17172593298040745`", ",", "0.2917803672703723`", ",", 
   "0.3630597683077595`", ",", "0.3732359802993849`"}], "}"}]], "Output",
 CellChangeTimes->{3.389635849533*^9},
 CellLabel->"Out[87]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"InitializeAll", "[", 
    RowBox[{"5", ",", 
     SubscriptBox["F", 
      RowBox[{"\[Beta]", " ", "Uniform"}]]}], "]"}], ";", 
   RowBox[{"Calculate", "[", "]"}], ";"}], "]"}]], "Input",
 CellLabel->"In[88]:="],

Cell[BoxData["\<\"Initializing all probabilities and rules.\"\>"], "Print",
 CellChangeTimes->{3.3896358495810003`*^9},
 CellLabel->"During evaluation of In[88]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"T=\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" \\!\\(\\*SubscriptBox[\\(F\\), \\(\[Beta]\\\\ \
Rule\\)]\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SubscriptBox["F", "\[Beta]"], "[", "\[Beta]_", "]"}], "\[RuleDelayed]", 
    RowBox[{"CDF", "[", 
     RowBox[{
      RowBox[{"UniformDistribution", "[", 
       RowBox[{"{", 
        RowBox[{
         UnderscriptBox["\[Beta]", "_"], ",", 
         OverscriptBox["\[Beta]", "_"]}], "}"}], "]"}], ",", "\[Beta]"}], 
     "]"}]}], "\[InvisibleSpace]", "\<\" \
\\!\\(\\*UnderscriptBox[\\(\[Beta]\\), \\(_\\)]\\)=\"\>", "\[InvisibleSpace]",
    "0", "\[InvisibleSpace]", "\<\" \\!\\(\\*OverscriptBox[\\(\[Beta]\\), \
\\(_\\)]\\)=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" V=\"\>", "\[InvisibleSpace]", "5.5`", 
   "\[InvisibleSpace]", "\<\" B=\"\>", "\[InvisibleSpace]", "5.`", 
   "\[InvisibleSpace]", "\<\" A=\"\>", "\[InvisibleSpace]", "6.`"}],
  SequenceForm[
  "T=", 5, " \!\(\*SubscriptBox[\(F\), \(\[Beta]\\ Rule\)]\)=", \
$CellContext`F\[Beta][
     Pattern[$CellContext`\[Beta], 
      Blank[]]] :> CDF[
     UniformDistribution[{$CellContext`\[Beta]\[UnderBracket]Underscript\
\[UnderBracket]Underscore, $CellContext`\[Beta]\[UnderBracket]Overscript\
\[UnderBracket]Underscore}], $CellContext`\[Beta]], 
   " \!\(\*UnderscriptBox[\(\[Beta]\), \(_\)]\)=", 0, 
   " \!\(\*OverscriptBox[\(\[Beta]\), \(_\)]\)=", 2, " V=", 5.5, " B=", 5., 
   " A=", 6.],
  Editable->False]], "Print",
 CellChangeTimes->{3.389635849601*^9},
 CellLabel->"During evaluation of In[88]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Max discrepancy in transition probabilities=\"\>", 
   "\[InvisibleSpace]", "1.1102230246251565`*^-16"}],
  SequenceForm[
  "Max discrepancy in transition probabilities=", 1.1102230246251565`*^-16],
  Editable->False]], "Print",
 CellChangeTimes->{3.389635849692*^9},
 CellLabel->"During evaluation of In[88]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Max discrepancy in state probabilities=\"\>", 
   "\[InvisibleSpace]", "1.1102230246251565`*^-16"}],
  SequenceForm[
  "Max discrepancy in state probabilities=", 1.1102230246251565`*^-16],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896358497320004`*^9},
 CellLabel->"During evaluation of In[88]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.07800000000000099`", ",", "Null"}], "}"}]], "Output",
 CellChangeTimes->{3.389635849781*^9},
 CellLabel->"Out[88]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedDepthUniform", "=", "ExpectedDepth"}]], "Input",
 CellLabel->"In[89]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.`", ",", "0.1136926625096096`", ",", "0.1828312403287828`", ",", 
   "0.21737605070019123`", ",", "0.21994910411841384`"}], "}"}]], "Output",
 CellChangeTimes->{3.38963584985*^9},
 CellLabel->"Out[89]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "ExpectedDepthUniform", ",", "ExpectedDepthWing", ",", 
     "ExpectedDepthTriangular"}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<t, Trading period\>\"", ",", "\"\<Depth\>\""}], "}"}]}], 
   ",", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Range", "[", "5", "]"}], ",", 
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", "4", ",", "0.1`"}], "]"}], ",", "None", ",", 
      "None"}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0.5`"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Text", "[", 
       RowBox[{"\"\<High immediacy\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "0.05"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.1`"}], ",", "0"}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<Uniform\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "0.22"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.1`"}], ",", "0"}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<Low immediacy\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "0.37"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.1`"}], ",", "0"}], "}"}]}], "]"}]}], "}"}]}], ",", 
   RowBox[{"BaseStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.389635686076*^9, 3.389635824672*^9}, {3.389635857408*^9,
   3.38963593387*^9}},
 CellLabel->"In[92]:="],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1., 0.}, {2., 0.1136926625096096}, {3., 0.1828312403287828}, {
     4., 0.21737605070019123`}, {5., 0.21994910411841384`}}]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], 
    LineBox[{{1., 0.}, {2., 0.05227084182808278}, {3., 0.06853063943424784}, {
     4., 0.06681967791490985}, {5., 0.05785769920854977}}]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], 
    LineBox[{{1., 0.}, {2., 0.17172593298040745`}, {3., 0.2917803672703723}, {
     4., 0.3630597683077595}, {5., 0.3732359802993849}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Times"},
  Epilog->{
    InsetBox[
     FormBox["\"High immediacy\"", TraditionalForm], {5, 0.05}, {-1.1, 0}], 
    InsetBox[
     FormBox["\"Uniform\"", TraditionalForm], {5, 0.22}, {-1.1, 0}], 
    InsetBox[
     FormBox["\"Low immediacy\"", TraditionalForm], {5, 0.37}, {-1.1, 0}]},
  Frame->True,
  FrameLabel->{
    FormBox["\"t, Trading period\"", TraditionalForm], 
    FormBox["\"Depth\"", TraditionalForm]},
  FrameTicks->{{{1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}, {4, 
      FormBox["4", TraditionalForm]}, {5, 
      FormBox["5", TraditionalForm]}}, {{0., 
      FormBox["0.`", TraditionalForm]}, {0.1, 
      FormBox["0.1`", TraditionalForm]}, {0.2, 
      FormBox["0.2`", TraditionalForm]}, {0.30000000000000004`, 
      FormBox["0.30000000000000004`", TraditionalForm]}, {0.4, 
      FormBox["0.4`", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {0.6000000000000001, 
      FormBox["0.6000000000000001`", TraditionalForm]}, {0.7000000000000001, 
      FormBox["0.7000000000000001`", TraditionalForm]}, {0.8, 
      FormBox["0.8`", TraditionalForm]}, {0.9, 
      FormBox["0.9`", TraditionalForm]}, {1., 
      FormBox["1.`", TraditionalForm]}, {1.1, 
      FormBox["1.1`", TraditionalForm]}, {1.2000000000000002`, 
      FormBox["1.2000000000000002`", TraditionalForm]}, {1.3, 
      FormBox["1.3`", TraditionalForm]}, {1.4000000000000001`, 
      FormBox["1.4000000000000001`", TraditionalForm]}, {1.5, 
      FormBox["1.5`", TraditionalForm]}, {1.6, 
      FormBox["1.6`", TraditionalForm]}, {1.7000000000000002`, 
      FormBox["1.7000000000000002`", TraditionalForm]}, {1.8, 
      FormBox["1.8`", TraditionalForm]}, {1.9000000000000001`, 
      FormBox["1.9000000000000001`", TraditionalForm]}, {2., 
      FormBox["2.`", TraditionalForm]}, {2.1, 
      FormBox["2.1`", TraditionalForm]}, {2.2, 
      FormBox["2.2`", TraditionalForm]}, {2.3000000000000003`, 
      FormBox["2.3000000000000003`", TraditionalForm]}, {
     2.4000000000000004`, 
      FormBox["2.4000000000000004`", TraditionalForm]}, {2.5, 
      FormBox["2.5`", TraditionalForm]}, {2.6, 
      FormBox["2.6`", TraditionalForm]}, {2.7, 
      FormBox["2.7`", TraditionalForm]}, {2.8000000000000003`, 
      FormBox["2.8000000000000003`", TraditionalForm]}, {
     2.9000000000000004`, 
      FormBox["2.9000000000000004`", TraditionalForm]}, {3., 
      FormBox["3.`", TraditionalForm]}, {3.1, 
      FormBox["3.1`", TraditionalForm]}, {3.2, 
      FormBox["3.2`", TraditionalForm]}, {3.3000000000000003`, 
      FormBox["3.3000000000000003`", TraditionalForm]}, {
     3.4000000000000004`, 
      FormBox["3.4000000000000004`", TraditionalForm]}, {3.5, 
      FormBox["3.5`", TraditionalForm]}, {3.6, 
      FormBox["3.6`", TraditionalForm]}, {3.7, 
      FormBox["3.7`", TraditionalForm]}, {3.8000000000000003`, 
      FormBox["3.8000000000000003`", TraditionalForm]}, {
     3.9000000000000004`, 
      FormBox["3.9000000000000004`", TraditionalForm]}, {4., 
      FormBox["4.`", TraditionalForm]}}, None, None},
  PlotRange->{{1, 8}, {0, 0.5}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.38963590106*^9, 3.3896359343190002`*^9},
 CellLabel->"Out[92]="]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\[Beta] Distributions", "Subsection"],

Cell[CellGroupData[{

Cell["Set base styles for screen or tiff (file) output.", "Subsubsection",
 CellChangeTimes->{{3.389694771684024*^9, 3.3896947911270237`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"nominalFigureWidth", "=", "4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tiffResolution", "=", "400"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nominalFontSize", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"imageSize", "=", 
   RowBox[{"nominalFigureWidth", "*", "tiffResolution", "*", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0.625"}], "}"}]}]}], ";"}], "\n", 
 RowBox[{"bStyleOut", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
    RowBox[{"FontSize", "\[Rule]", 
     RowBox[{"Floor", "[", 
      RowBox[{"nominalFontSize", "*", 
       RowBox[{"tiffResolution", "/", "72"}]}], "]"}]}]}], "}"}]}]}], "Input",\

 CellChangeTimes->{{3.389693803509224*^9, 3.389693853312224*^9}, {
  3.389693953768224*^9, 3.389693983226224*^9}, {3.3896947528760242`*^9, 
  3.389694761261024*^9}, {3.3896949052770243`*^9, 3.389694906897024*^9}},
 CellLabel->"In[404]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"FontFamily", "\[Rule]", "\<\"Times\"\>"}], ",", 
   RowBox[{"FontSize", "\[Rule]", "55"}]}], "}"}]], "Output",
 CellChangeTimes->{3.389694847846024*^9, 3.389694995088024*^9, 
  3.3896950613880243`*^9, 3.3896951332110243`*^9, 3.3896952355280237`*^9, 
  3.389695357727024*^9, 3.3896954295460243`*^9, 3.389695472099024*^9, 
  3.389695540317024*^9, 3.3896956854470243`*^9, 3.389695729465024*^9, 
  3.3896957633040237`*^9, 3.389695842184024*^9, 3.389695944401024*^9},
 CellLabel->"Out[408]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"bStyleOut", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
     RowBox[{"FontSize", "\[Rule]", "40"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.389653291417*^9, 3.38965331144*^9}, {
  3.3896534889110003`*^9, 3.389653489744*^9}, {3.389653614168*^9, 
  3.3896536152679996`*^9}, {3.3896594408714237`*^9, 3.389659442798424*^9}, {
  3.389659518947424*^9, 3.389659521123424*^9}, {3.3896595556394243`*^9, 
  3.389659556704424*^9}, {3.3896596355874243`*^9, 3.389659636964424*^9}, {
  3.389659681725424*^9, 3.3896596828704243`*^9}, {3.389694055879224*^9, 
  3.3896940563742237`*^9}, {3.389694765074024*^9, 3.389694766353024*^9}, {
  3.3896951228370237`*^9, 3.389695128764024*^9}, {3.389695224565024*^9, 
  3.389695254406024*^9}, {3.3896953345390244`*^9, 3.389695352769024*^9}, {
  3.389695423194024*^9, 3.3896954234760237`*^9}, {3.389695718573024*^9, 
  3.389695720150024*^9}, {3.3896957562120237`*^9, 3.389695757420024*^9}, {
  3.389695826394024*^9, 3.389695828033024*^9}, {3.3896959292300243`*^9, 
  3.3896959366450243`*^9}},
 CellLabel->"In[409]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"bStyleScreen", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
     RowBox[{"FontSize", "\[Rule]", "12"}], ",", 
     RowBox[{"LineSpacing", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "3"}]}], "}"}]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.389653291417*^9, 3.38965331144*^9}, {
  3.3896534889110003`*^9, 3.389653489744*^9}, {3.389653614168*^9, 
  3.3896536152679996`*^9}, {3.3896594408714237`*^9, 3.389659442798424*^9}, {
  3.389659518947424*^9, 3.389659521123424*^9}, {3.3896595556394243`*^9, 
  3.389659556704424*^9}, {3.3896596355874243`*^9, 3.389659636964424*^9}, {
  3.389659681725424*^9, 3.3896596828704243`*^9}, {3.389694055879224*^9, 
  3.3896940563742237`*^9}, {3.389694765074024*^9, 3.389694766353024*^9}, {
  3.3896954473840237`*^9, 3.389695456479024*^9}, {3.389695529239024*^9, 
  3.3896955293550243`*^9}},
 CellLabel->"In[410]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"bStyle", "=", "bStyleOut"}], ";"}]], "Input",
 CellChangeTimes->{{3.389694794639024*^9, 3.389694802448024*^9}, {
  3.389694987880024*^9, 3.389694990133024*^9}, {3.389695035924024*^9, 
  3.3896950374350243`*^9}, {3.389695459883024*^9, 3.3896954617450237`*^9}, {
  3.3896956615340242`*^9, 3.3896956636530237`*^9}},
 CellLabel->"In[411]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell["Uniform", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InitializeAll", "[", "7", "]"}], ";", 
  RowBox[{"Calculate", "[", "]"}], ";"}]], "Input",
 CellLabel->"In[412]:="],

Cell[BoxData["\<\"Initializing all probabilities and rules.\"\>"], "Print",
 CellChangeTimes->{3.389694437394024*^9, 3.3896948479210243`*^9, 
  3.389694999132024*^9, 3.389695061437024*^9, 3.389695133266024*^9, 
  3.389695235582024*^9, 3.389695357788024*^9, 3.3896954721530237`*^9, 
  3.389695544341024*^9, 3.389695685505024*^9, 3.389695729524024*^9, 
  3.389695763360024*^9, 3.389695842240024*^9, 3.389695944458024*^9},
 CellLabel->"During evaluation of In[412]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"T=\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" \\!\\(\\*SubscriptBox[\\(F\\), \\(\[Beta]\\\\ \
Rule\\)]\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SubscriptBox["F", "\[Beta]"], "[", "\[Beta]_", "]"}], "\[RuleDelayed]", 
    RowBox[{"CDF", "[", 
     RowBox[{
      RowBox[{"UniformDistribution", "[", 
       RowBox[{"{", 
        RowBox[{
         UnderscriptBox["\[Beta]", "_"], ",", 
         OverscriptBox["\[Beta]", "_"]}], "}"}], "]"}], ",", "\[Beta]"}], 
     "]"}]}], "\[InvisibleSpace]", "\<\" \
\\!\\(\\*UnderscriptBox[\\(\[Beta]\\), \\(_\\)]\\)=\"\>", "\[InvisibleSpace]",
    "0", "\[InvisibleSpace]", "\<\" \\!\\(\\*OverscriptBox[\\(\[Beta]\\), \
\\(_\\)]\\)=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" V=\"\>", "\[InvisibleSpace]", "5.5`", 
   "\[InvisibleSpace]", "\<\" B=\"\>", "\[InvisibleSpace]", "5.`", 
   "\[InvisibleSpace]", "\<\" A=\"\>", "\[InvisibleSpace]", "6.`"}],
  SequenceForm[
  "T=", 7, " \!\(\*SubscriptBox[\(F\), \(\[Beta]\\ Rule\)]\)=", \
$CellContext`F\[Beta][
     Pattern[$CellContext`\[Beta], 
      Blank[]]] :> CDF[
     UniformDistribution[{$CellContext`\[Beta]\[UnderBracket]Underscript\
\[UnderBracket]Underscore, $CellContext`\[Beta]\[UnderBracket]Overscript\
\[UnderBracket]Underscore}], $CellContext`\[Beta]], 
   " \!\(\*UnderscriptBox[\(\[Beta]\), \(_\)]\)=", 0, 
   " \!\(\*OverscriptBox[\(\[Beta]\), \(_\)]\)=", 2, " V=", 5.5, " B=", 5., 
   " A=", 6.],
  Editable->False]], "Print",
 CellChangeTimes->{3.389694437394024*^9, 3.3896948479210243`*^9, 
  3.389694999132024*^9, 3.389695061437024*^9, 3.389695133266024*^9, 
  3.389695235582024*^9, 3.389695357788024*^9, 3.3896954721530237`*^9, 
  3.389695544341024*^9, 3.389695685505024*^9, 3.389695729524024*^9, 
  3.389695763360024*^9, 3.389695842240024*^9, 3.3896959444620237`*^9},
 CellLabel->"During evaluation of In[412]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Max discrepancy in transition probabilities=\"\>", 
   "\[InvisibleSpace]", "1.1102230246251565`*^-16"}],
  SequenceForm[
  "Max discrepancy in transition probabilities=", 1.1102230246251565`*^-16],
  Editable->False]], "Print",
 CellChangeTimes->{3.389694437394024*^9, 3.3896948479210243`*^9, 
  3.389694999132024*^9, 3.389695061437024*^9, 3.389695133266024*^9, 
  3.389695235582024*^9, 3.389695357788024*^9, 3.3896954721530237`*^9, 
  3.389695544341024*^9, 3.389695685505024*^9, 3.389695729524024*^9, 
  3.389695763360024*^9, 3.389695842240024*^9, 3.389695945408024*^9},
 CellLabel->"During evaluation of In[412]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Max discrepancy in state probabilities=\"\>", 
   "\[InvisibleSpace]", "3.3306690738754696`*^-16"}],
  SequenceForm[
  "Max discrepancy in state probabilities=", 3.3306690738754696`*^-16],
  Editable->False]], "Print",
 CellChangeTimes->{3.389694437394024*^9, 3.3896948479210243`*^9, 
  3.389694999132024*^9, 3.389695061437024*^9, 3.389695133266024*^9, 
  3.389695235582024*^9, 3.389695357788024*^9, 3.3896954721530237`*^9, 
  3.389695544341024*^9, 3.389695685505024*^9, 3.389695729524024*^9, 
  3.389695763360024*^9, 3.389695842240024*^9, 3.389695946048024*^9},
 CellLabel->"During evaluation of In[412]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["PrintExpectedDepth"], "Input",
 CellLabel->"In[413]:="],

Cell[BoxData[
 TagBox[
  TagBox[
   TagBox[GridBox[{
      {
       TagBox["\<\"t\"\>",
        HoldForm], 
       InterpretationBox["\<\"1.000\"\>",
        1,
        Editable->False], 
       InterpretationBox["\<\"2.000\"\>",
        2,
        Editable->False], 
       InterpretationBox["\<\"3.000\"\>",
        3,
        Editable->False], 
       InterpretationBox["\<\"4.000\"\>",
        4,
        Editable->False], 
       InterpretationBox["\<\"5.000\"\>",
        5,
        Editable->False], 
       InterpretationBox["\<\"6.000\"\>",
        6,
        Editable->False], 
       InterpretationBox["\<\"7.000\"\>",
        7,
        Editable->False]},
      {
       TagBox["\<\"E[Depth]\"\>",
        HoldForm], 
       InterpretationBox["\<\"0.000\"\>",
        0.,
        AutoDelete->True], 
       InterpretationBox["\<\"0.157\"\>",
        0.1566941007784104,
        AutoDelete->True], 
       InterpretationBox["\<\"0.265\"\>",
        0.26459701866486596`,
        AutoDelete->True], 
       InterpretationBox["\<\"0.325\"\>",
        0.32452751933892504`,
        AutoDelete->True], 
       InterpretationBox["\<\"0.350\"\>",
        0.3496236240637034,
        AutoDelete->True], 
       InterpretationBox["\<\"0.350\"\>",
        0.3500402744780992,
        AutoDelete->True], 
       InterpretationBox["\<\"0.323\"\>",
        0.32335509339143303`,
        AutoDelete->True]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxDividers->{
      "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
       "Rows" -> {{False}}, "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    {OutputFormsDump`HeadedRows, None}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, TableSpacing -> {1, 1}, 
     TableHeadings -> {{"t", "E[Depth]"}}]]],
  NumberForm[#, {5, 3}]& ]], "Output",
 CellChangeTimes->{3.389635987782*^9, 3.3896378901*^9, 3.389638667508*^9, 
  3.389638708094*^9, 3.3896533424370003`*^9, 3.3896534969440002`*^9, 
  3.389659093167424*^9, 3.389659452624424*^9, 3.3896595281614237`*^9, 
  3.389659562586424*^9, 3.389659644288424*^9, 3.3896596902794237`*^9, 
  3.389694063795224*^9, 3.3896944396270237`*^9, 3.3896948502260237`*^9, 
  3.389695001413024*^9, 3.3896950637120237`*^9, 3.389695135537024*^9, 
  3.389695237852024*^9, 3.389695360045024*^9, 3.3896954744800243`*^9, 
  3.3896955466710243`*^9, 3.389695687797024*^9, 3.3896957318110237`*^9, 
  3.389695765648024*^9, 3.389695844533024*^9, 3.389695946757024*^9},
 CellLabel->"Out[413]//NumberForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Beta]C", "=", 
  RowBox[{"Round", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Apply", "[", 
        RowBox[{"#", ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "0", ",", "0"}], "}"}]}], "]"}], "&"}], " ", 
      ")"}], "/@", " ", 
     RowBox[{"{", 
      RowBox[{
      "\[Beta]LmtSellLow", ",", "\[Beta]LmtSellHigh", ",", "\[Beta]LmtBuyLow",
        ",", "\[Beta]LmtBuyHigh"}], "}"}]}], ",", "0.01"}], "]"}]}]], "Input",\

 CellChangeTimes->{{3.3896378554309998`*^9, 3.3896378697980003`*^9}, {
  3.389637900823*^9, 3.389637905808*^9}, {3.3896382188789997`*^9, 
  3.389638221144*^9}, {3.389638251953*^9, 3.38963826856*^9}},
 CellLabel->"In[414]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.64`", ",", "1.09`", ",", "0.91`", ",", "1.36`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.389635996112*^9, {3.389637870264*^9, 3.3896379065*^9}, {3.389638256168*^9,
    3.3896382690769997`*^9}, 3.3896386675480003`*^9, 3.389638708135*^9, 
   3.389653342479*^9, 3.389653496986*^9, 3.389659093200424*^9, 
   3.389659452662424*^9, 3.389659528196424*^9, 3.3896595626274242`*^9, 
   3.389659644342424*^9, 3.389659690342424*^9, 3.389694063828224*^9, 
   3.3896944396590242`*^9, 3.389694850266024*^9, 3.389695001452024*^9, 
   3.3896950637510242`*^9, 3.389695135567024*^9, 3.389695237882024*^9, 
   3.389695360076024*^9, 3.389695474522024*^9, 3.389695546709024*^9, 
   3.3896956878370237`*^9, 3.3896957318510237`*^9, 3.3896957656780243`*^9, 
   3.389695844573024*^9, 3.389695946795024*^9},
 CellLabel->"Out[414]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"d", "=", "0.005`"}], ";"}], "\n", 
 RowBox[{"p1", "=", 
  RowBox[{"Graphics", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"GrayLevel", "[", "0.9`", "]"}], ",", 
      RowBox[{"Rectangle", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"3", " ", "d"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
          "\[Beta]C", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
          ",", 
          RowBox[{"1", "-", "d"}]}], "}"}]}], "]"}], ",", 
      RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"Market\",
FontSlant->\"Italic\"]\)\\n\!\(\*
StyleBox[\"Sell\",
FontSlant->\"Italic\"]\) \>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
           "\[Beta]C", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
            "-", "0.1`"}], ",", 
          RowBox[{"0.9`", "\[InvisibleSpace]", "-", "d"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
      RowBox[{"GrayLevel", "[", "0.7`", "]"}], ",", 
      RowBox[{"Rectangle", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
          "\[Beta]C", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
          ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
          "\[Beta]C", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
          ",", 
          RowBox[{"1", "-", "d"}]}], "}"}]}], "]"}], ",", 
      RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\< \!\(\*
StyleBox[\"Limit\",
FontSlant->\"Italic\"]\)\\nS\!\(\*
StyleBox[\"ell\",
FontSlant->\"Italic\"]\) \>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
           "\[Beta]C", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
            "-", "0.1`"}], ",", 
          RowBox[{"0.9`", "\[InvisibleSpace]", "-", "d"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\< \!\(\*
StyleBox[\"Seller\",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\" \",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"does\",
FontSlant->\"Italic\"]\)\\n\!\(\*
StyleBox[\"nothing\",
FontSlant->\"Italic\"]\) \>\"", ",", 
        RowBox[{"{", 
         RowBox[{"1.5`", ",", 
          RowBox[{"0.9`", "\[InvisibleSpace]", "-", "d"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", 
      RowBox[{"GrayLevel", "[", "0.`", "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0.5`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "0.5`"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
           "\[Beta]C", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
            ",", 
           TagBox[
            RowBox[{"\[Beta]C", "\[LeftDoubleBracket]", 
             InterpretationBox["\"\<  1.00\>\"",
              1,
              Editable->False], "\[RightDoubleBracket]"}],
            PaddedForm[#, {4, 2}]& ]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
           "\[Beta]C", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
            ",", 
           TagBox[
            RowBox[{"\[Beta]C", "\[LeftDoubleBracket]", 
             InterpretationBox["\"\<  2.00\>\"",
              2,
              Editable->False], "\[RightDoubleBracket]"}],
            PaddedForm[#, {4, 2}]& ]}], "}"}], ",", "2"}], "}"}], ",", 
       RowBox[{"Range", "[", 
        RowBox[{"0", ",", "1", ",", "0.2`"}], "]"}], ",", "None", ",", 
       "None"}], "}"}]}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Immediacy preference, \[Beta]\>\"", ",", "\"\<Probability\>\"", 
       ",", "\"\<A. Uniform\>\"", ",", "None"}], "}"}]}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"BaseStyle", "\[Rule]", "bStyle"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.389636019046*^9, 3.389636139874*^9}, {3.38963768479*^9, 
  3.389637706119*^9}, {3.389638694277*^9, 3.389638697723*^9}, {
  3.3896533209519997`*^9, 3.389653324251*^9}, {3.389659863392424*^9, 
  3.389659863829424*^9}, {3.389694834338024*^9, 3.389694873132024*^9}, {
  3.389695020682024*^9, 3.389695021500024*^9}},
 CellLabel->"In[415]:="],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0.9], RectangleBox[{0.015, 0.005}, {0.64, 0.995}]}, 
   {GrayLevel[0], 
    InsetBox["\<\"\\!\\(\\*\\nStyleBox[\\\"Market\\\",\\nFontSlant->\\\"\
Italic\\\"]\\)\\n\\!\\(\\*\\nStyleBox[\\\"Sell\\\",\\nFontSlant->\\\"Italic\\\
\"]\\) \"\>", {0.54, 0.895}, {1, 1}]}, 
   {GrayLevel[0.7], RectangleBox[{0.64, 0.005}, {1.09, 0.995}]}, 
   {GrayLevel[0], 
    InsetBox["\<\" \
\\!\\(\\*\\nStyleBox[\\\"Limit\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\nS\\!\\(\
\\*\\nStyleBox[\\\"ell\\\",\\nFontSlant->\\\"Italic\\\"]\\) \"\>", \
{0.9900000000000001, 0.895}, {1, 1}], 
    InsetBox["\<\" \
\\!\\(\\*\\nStyleBox[\\\"Seller\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\
\\nStyleBox[\\\" \\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[\\\
\"does\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\n\\!\\(\\*\\nStyleBox[\\\"\
nothing\\\",\\nFontSlant->\\\"Italic\\\"]\\) \"\>", {1.5, 0.895}, {0, 1}]}, 
   {GrayLevel[0.], 
    StyleBox[LineBox[{{0, 0.5}, {2, 0.5}}],
     FontColor->GrayLevel[0.]]}},
  BaseStyle->{FontFamily -> "Times", FontSize -> 40},
  Frame->True,
  FrameLabel->{
    FormBox["\"Immediacy preference, \[Beta]\"", TraditionalForm], 
    FormBox["\"Probability\"", TraditionalForm], 
    FormBox["\"A. Uniform\"", TraditionalForm], None},
  FrameTicks->{{{0, 
      FormBox["0", TraditionalForm]}, {0.64, 
      FormBox["0.64`", TraditionalForm]}, {1.09, 
      FormBox["1.09`", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}}, {{0., 
      FormBox["0.`", TraditionalForm]}, {0.2, 
      FormBox["0.2`", TraditionalForm]}, {0.4, 
      FormBox["0.4`", TraditionalForm]}, {0.6000000000000001, 
      FormBox["0.6000000000000001`", TraditionalForm]}, {0.8, 
      FormBox["0.8`", TraditionalForm]}, {1., 
      FormBox["1.`", TraditionalForm]}}, None, None},
  PlotRange->{{0, 2}, {0, 1}}]], "Output",
 CellChangeTimes->{{3.3896361206400003`*^9, 3.3896361402980003`*^9}, {
   3.389637688041*^9, 3.389637707266*^9}, {3.389637875376*^9, 
   3.389637909884*^9}, {3.389638291227*^9, 3.3896383186219997`*^9}, 
   3.389638667632*^9, 3.38963870823*^9, {3.389653326457*^9, 
   3.389653342566*^9}, 3.3896534970889997`*^9, {3.389659093704424*^9, 
   3.389659114567424*^9}, 3.389659452774424*^9, 3.389659528303424*^9, 
   3.389659562730424*^9, 3.389659644457424*^9, 3.389659690517424*^9, 
   3.389659864550424*^9, 3.389694063945224*^9, 3.389694439742024*^9, 
   3.389694850359024*^9, {3.389695001503024*^9, 3.389695022071024*^9}, 
   3.389695063801024*^9, 3.3896951356080236`*^9, 3.389695237924024*^9, 
   3.389695360121024*^9, 3.389695474580024*^9, 3.389695546762024*^9, 
   3.389695687891024*^9, 3.3896957319020243`*^9, 3.3896957657190237`*^9, 
   3.3896958446260242`*^9, 3.389695946848024*^9},
 CellLabel->"Out[416]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Triangular", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InitializeAll", "[", 
   RowBox[{"7", ",", 
    SubscriptBox["F", 
     RowBox[{"\[Beta]", " ", "Triangular"}]]}], "]"}], ";", 
  RowBox[{"Calculate", "[", "]"}], ";"}]], "Input",
 CellLabel->"In[417]:="],

Cell[BoxData["\<\"Initializing all probabilities and rules.\"\>"], "Print",
 CellChangeTimes->{3.3896944507520237`*^9, 3.3896948504020243`*^9, 
  3.389695063841024*^9, 3.389695135636024*^9, 3.389695237956024*^9, 
  3.3896953601520243`*^9, 3.3896954746190243`*^9, 3.3896956879280243`*^9, 
  3.389695731951024*^9, 3.3896957657330236`*^9, 3.3896958446930237`*^9, 
  3.389695946916024*^9},
 CellLabel->"During evaluation of In[417]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"T=\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" \\!\\(\\*SubscriptBox[\\(F\\), \\(\[Beta]\\\\ \
Rule\\)]\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SubscriptBox["F", "\[Beta]"], "[", "\[Beta]_", "]"}], "\[RuleDelayed]", 
    RowBox[{"Which", "[", 
     RowBox[{
      RowBox[{"\[Beta]", "\[LessEqual]", "0"}], ",", "0", ",", 
      RowBox[{"0", "<", "\[Beta]", "\[LessEqual]", "1"}], ",", 
      FractionBox[
       SuperscriptBox["\[Beta]", "2"], "2"], ",", 
      RowBox[{"1", "<", "\[Beta]", "\[LessEqual]", "2"}], ",", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"2", " ", "\[Beta]"}], "-", 
       FractionBox[
        SuperscriptBox["\[Beta]", "2"], "2"]}], ",", 
      RowBox[{"\[Beta]", ">", "2"}], ",", "1"}], "]"}]}], 
   "\[InvisibleSpace]", "\<\" \\!\\(\\*UnderscriptBox[\\(\[Beta]\\), \\(_\\)]\
\\)=\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\" \\!\\(\\*OverscriptBox[\\(\[Beta]\\), \
\\(_\\)]\\)=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" V=\"\>", "\[InvisibleSpace]", "5.5`", 
   "\[InvisibleSpace]", "\<\" B=\"\>", "\[InvisibleSpace]", "5.`", 
   "\[InvisibleSpace]", "\<\" A=\"\>", "\[InvisibleSpace]", "6.`"}],
  SequenceForm[
  "T=", 7, " \!\(\*SubscriptBox[\(F\), \(\[Beta]\\ Rule\)]\)=", \
$CellContext`F\[Beta][
     Pattern[$CellContext`\[Beta], 
      Blank[]]] :> Which[$CellContext`\[Beta] <= 0, 0, 
     Inequality[
     0, Less, $CellContext`\[Beta], LessEqual, 1], $CellContext`\[Beta]^2/2, 
     Inequality[1, Less, $CellContext`\[Beta], LessEqual, 2], -1 + 
     2 $CellContext`\[Beta] - $CellContext`\[Beta]^2/2, $CellContext`\[Beta] > 
     2, 1], " \!\(\*UnderscriptBox[\(\[Beta]\), \(_\)]\)=", 0, 
   " \!\(\*OverscriptBox[\(\[Beta]\), \(_\)]\)=", 2, " V=", 5.5, " B=", 5., 
   " A=", 6.],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896944507520237`*^9, 3.3896948504020243`*^9, 
  3.389695063841024*^9, 3.389695135636024*^9, 3.389695237956024*^9, 
  3.3896953601520243`*^9, 3.3896954746190243`*^9, 3.3896956879280243`*^9, 
  3.389695731951024*^9, 3.3896957657330236`*^9, 3.3896958446930237`*^9, 
  3.389695946937024*^9},
 CellLabel->"During evaluation of In[417]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Max discrepancy in transition probabilities=\"\>", 
   "\[InvisibleSpace]", "2.220446049250313`*^-16"}],
  SequenceForm[
  "Max discrepancy in transition probabilities=", 2.220446049250313*^-16],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896944507520237`*^9, 3.3896948504020243`*^9, 
  3.389695063841024*^9, 3.389695135636024*^9, 3.389695237956024*^9, 
  3.3896953601520243`*^9, 3.3896954746190243`*^9, 3.3896956879280243`*^9, 
  3.389695731951024*^9, 3.3896957657330236`*^9, 3.3896958446930237`*^9, 
  3.389695947859024*^9},
 CellLabel->"During evaluation of In[417]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Max discrepancy in state probabilities=\"\>", 
   "\[InvisibleSpace]", "2.220446049250313`*^-16"}],
  SequenceForm[
  "Max discrepancy in state probabilities=", 2.220446049250313*^-16],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896944507520237`*^9, 3.3896948504020243`*^9, 
  3.389695063841024*^9, 3.389695135636024*^9, 3.389695237956024*^9, 
  3.3896953601520243`*^9, 3.3896954746190243`*^9, 3.3896956879280243`*^9, 
  3.389695731951024*^9, 3.3896957657330236`*^9, 3.3896958446930237`*^9, 
  3.389695948508024*^9},
 CellLabel->"During evaluation of In[417]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["PrintExpectedDepth"], "Input",
 CellLabel->"In[418]:="],

Cell[BoxData[
 TagBox[
  TagBox[
   TagBox[GridBox[{
      {
       TagBox["\<\"t\"\>",
        HoldForm], 
       InterpretationBox["\<\"1.000\"\>",
        1,
        Editable->False], 
       InterpretationBox["\<\"2.000\"\>",
        2,
        Editable->False], 
       InterpretationBox["\<\"3.000\"\>",
        3,
        Editable->False], 
       InterpretationBox["\<\"4.000\"\>",
        4,
        Editable->False], 
       InterpretationBox["\<\"5.000\"\>",
        5,
        Editable->False], 
       InterpretationBox["\<\"6.000\"\>",
        6,
        Editable->False], 
       InterpretationBox["\<\"7.000\"\>",
        7,
        Editable->False]},
      {
       TagBox["\<\"E[Depth]\"\>",
        HoldForm], 
       InterpretationBox["\<\"0.000\"\>",
        0.,
        AutoDelete->True], 
       InterpretationBox["\<\"0.208\"\>",
        0.2077993719996045,
        AutoDelete->True], 
       InterpretationBox["\<\"0.370\"\>",
        0.3695738904452156,
        AutoDelete->True], 
       InterpretationBox["\<\"0.477\"\>",
        0.47683093794831827`,
        AutoDelete->True], 
       InterpretationBox["\<\"0.540\"\>",
        0.5402118348066597,
        AutoDelete->True], 
       InterpretationBox["\<\"0.565\"\>",
        0.5646705116766586,
        AutoDelete->True], 
       InterpretationBox["\<\"0.534\"\>",
        0.5338537174432197,
        AutoDelete->True]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxDividers->{
      "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
       "Rows" -> {{False}}, "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    {OutputFormsDump`HeadedRows, None}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, TableSpacing -> {1, 1}, 
     TableHeadings -> {{"t", "E[Depth]"}}]]],
  NumberForm[#, {5, 3}]& ]], "Output",
 CellChangeTimes->{3.3896363535360003`*^9, 3.389638375309*^9, 
  3.389653366889*^9, 3.389653499579*^9, 3.389659121666424*^9, 
  3.389659455208424*^9, 3.3896595306984243`*^9, 3.3896595652054243`*^9, 
  3.3896596470954237`*^9, 3.389659693277424*^9, 3.389694064009224*^9, 
  3.3896944529610243`*^9, 3.3896948527000237`*^9, 3.389695066111024*^9, 
  3.389695137871024*^9, 3.389695240190024*^9, 3.389695362401024*^9, 
  3.3896954769350243`*^9, 3.389695690225024*^9, 3.389695734248024*^9, 
  3.389695768048024*^9, 3.389695846951024*^9, 3.389695949215024*^9},
 CellLabel->"Out[418]//NumberForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"d", "=", "0.01"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"h", "=", "0.25"}], ";"}], "\n", 
 RowBox[{"\[Beta]C", "=", 
  RowBox[{"Round", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Apply", "[", 
        RowBox[{"#", ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "0", ",", "0"}], "}"}]}], "]"}], "&"}], " ", 
      ")"}], "/@", " ", 
     RowBox[{"{", 
      RowBox[{
      "\[Beta]LmtSellLow", ",", "\[Beta]LmtSellHigh", ",", "\[Beta]LmtBuyLow",
        ",", "\[Beta]LmtBuyHigh"}], "}"}]}], ",", "0.01"}], "]"}]}]}], "Input",\

 CellChangeTimes->{{3.389638358659*^9, 3.3896383671940002`*^9}},
 CellLabel->"In[419]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.7000000000000001`", ",", "1.09`", ",", "0.91`", ",", "1.3`"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.389636358528*^9, 3.389638375349*^9, 3.389653366947*^9, 
  3.3896534996359997`*^9, 3.389659121708424*^9, 3.389659455249424*^9, 
  3.389659530740424*^9, 3.3896595652454243`*^9, 3.3896596471394243`*^9, 
  3.389659693339424*^9, 3.389694064060224*^9, 3.3896944529950237`*^9, 
  3.389694852748024*^9, 3.389695066148024*^9, 3.3896951379030237`*^9, 
  3.389695240220024*^9, 3.389695362430024*^9, 3.389695476975024*^9, 
  3.389695690268024*^9, 3.3896957342840242`*^9, 3.389695768091024*^9, 
  3.389695846990024*^9, 3.389695949254024*^9},
 CellLabel->"Out[421]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p2", "=", 
  RowBox[{"Graphics", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"GrayLevel", "[", "0.9`", "]"}], ",", 
      RowBox[{"Rectangle", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"3", " ", "d"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
          "\[Beta]C", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
          ",", 
          RowBox[{"1", "-", "d"}]}], "}"}]}], "]"}], ",", 
      RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"Market\",
FontSlant->\"Italic\"]\)\\n\!\(\*
StyleBox[\"Sell\",
FontSlant->\"Italic\"]\) \>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
           "\[Beta]C", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
            "-", "0.1`"}], ",", 
          RowBox[{"0.9`", "\[InvisibleSpace]", "-", "d"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
      RowBox[{"GrayLevel", "[", "0.7`", "]"}], ",", 
      RowBox[{"Rectangle", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
          "\[Beta]C", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
          ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
          "\[Beta]C", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
          ",", 
          RowBox[{"1", "-", "d"}]}], "}"}]}], "]"}], ",", 
      RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"Limit\",
FontSlant->\"Italic\"]\)\\n\!\(\*
StyleBox[\"Sell\",
FontSlant->\"Italic\"]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
           "\[Beta]C", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
            "-", "0.1`"}], ",", 
          RowBox[{"0.9`", "\[InvisibleSpace]", "-", "d"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\< \!\(\*
StyleBox[\"Seller\",
FontSlant->\"Italic\"]\)\\n\!\(\*
StyleBox[\"does\",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\" \",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"nothing\",
FontSlant->\"Italic\"]\) \>\"", ",", 
        RowBox[{"{", 
         RowBox[{"1.5`", ",", 
          RowBox[{"0.9`", "\[InvisibleSpace]", "-", "d"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", 
      RowBox[{"GrayLevel", "[", "0.`", "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0.5`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "0.5`"}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"GrayLevel", "[", "0.`", "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
           "\[Beta]C", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
            ",", 
           TagBox[
            RowBox[{"\[Beta]C", "\[LeftDoubleBracket]", 
             InterpretationBox["\"\<  1.00\>\"",
              1,
              Editable->False], "\[RightDoubleBracket]"}],
            PaddedForm[#, {4, 2}]& ]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
           "\[Beta]C", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
            ",", 
           TagBox[
            RowBox[{"\[Beta]C", "\[LeftDoubleBracket]", 
             InterpretationBox["\"\<  2.00\>\"",
              2,
              Editable->False], "\[RightDoubleBracket]"}],
            PaddedForm[#, {4, 2}]& ]}], "}"}], ",", "2"}], "}"}], ",", 
       RowBox[{"Range", "[", 
        RowBox[{"0", ",", "1", ",", "0.2`"}], "]"}], ",", "None", ",", 
       "None"}], "}"}]}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Immediacy preference \[Beta] \>\"", ",", "\"\<Probability\>\"", 
       ",", "\"\<B. Triangular\>\"", ",", "None"}], "}"}]}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"BaseStyle", "\[Rule]", "bStyle"}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.389636277293*^9, {3.389636331094*^9, 3.389636339473*^9}, {
   3.389636374564*^9, 3.3896364010629997`*^9}, {3.389638392086*^9, 
   3.3896384511219997`*^9}, {3.389638482649*^9, 3.389638485825*^9}, {
   3.3896533530290003`*^9, 3.3896533560559998`*^9}},
 CellLabel->"In[422]:="],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0.9], RectangleBox[{0.03, 0.01}, {0.7000000000000001, 0.99}]}, 
   {GrayLevel[0], 
    InsetBox["\<\"\\!\\(\\*\\nStyleBox[\\\"Market\\\",\\nFontSlant->\\\"\
Italic\\\"]\\)\\n\\!\\(\\*\\nStyleBox[\\\"Sell\\\",\\nFontSlant->\\\"Italic\\\
\"]\\) \"\>", {0.6000000000000001, 0.89}, {1, 1}]}, 
   {GrayLevel[0.7], RectangleBox[{0.7000000000000001, 0.01}, {1.09, 0.99}]}, 
   {GrayLevel[0], 
    InsetBox["\<\"\\!\\(\\*\\nStyleBox[\\\"Limit\\\",\\nFontSlant->\\\"Italic\
\\\"]\\)\\n\\!\\(\\*\\nStyleBox[\\\"Sell\\\",\\nFontSlant->\\\"Italic\\\"]\\)\
\"\>", {0.9900000000000001, 0.89}, {1, 1}], 
    InsetBox["\<\" \
\\!\\(\\*\\nStyleBox[\\\"Seller\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\n\\!\\(\
\\*\\nStyleBox[\\\"does\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\\
nStyleBox[\\\" \
\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[\\\"nothing\\\",\\\
nFontSlant->\\\"Italic\\\"]\\) \"\>", {1.5, 0.89}, {0, 1}]}, 
   {GrayLevel[0.], 
    StyleBox[LineBox[{{0, 0.5}, {2, 0.5}}],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], 
    StyleBox[LineBox[{{0, 0}, {1, 1}, {2, 0}}],
     FontColor->GrayLevel[0.]]}},
  BaseStyle->{FontFamily -> "Times", FontSize -> 40},
  Frame->True,
  FrameLabel->{
    FormBox["\"Immediacy preference \[Beta] \"", TraditionalForm], 
    FormBox["\"Probability\"", TraditionalForm], 
    FormBox["\"B. Triangular\"", TraditionalForm], None},
  FrameTicks->{{{0, 
      FormBox["0", TraditionalForm]}, {0.7000000000000001, 
      FormBox["0.7000000000000001`", TraditionalForm]}, {1.09, 
      FormBox["1.09`", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}}, {{0., 
      FormBox["0.`", TraditionalForm]}, {0.2, 
      FormBox["0.2`", TraditionalForm]}, {0.4, 
      FormBox["0.4`", TraditionalForm]}, {0.6000000000000001, 
      FormBox["0.6000000000000001`", TraditionalForm]}, {0.8, 
      FormBox["0.8`", TraditionalForm]}, {1., 
      FormBox["1.`", TraditionalForm]}}, None, None},
  PlotRange->{{0, 2}, {0, 1}}]], "Output",
 CellChangeTimes->{
  3.389636363311*^9, 3.389636401832*^9, {3.389638425472*^9, 3.38963848645*^9},
    3.389653366998*^9, 3.389653499708*^9, 3.389659121762424*^9, 
   3.3896594553114243`*^9, 3.389659530792424*^9, 3.389659565306424*^9, 
   3.389659647203424*^9, 3.3896596934154243`*^9, 3.389694064129224*^9, 
   3.3896944530420237`*^9, 3.389694852808024*^9, 3.3896950662000237`*^9, 
   3.389695137948024*^9, 3.3896952402630243`*^9, 3.3896953624690237`*^9, 
   3.3896954770340242`*^9, 3.389695690323024*^9, 3.389695734342024*^9, 
   3.3896957681380243`*^9, 3.389695847049024*^9, 3.3896959493110237`*^9},
 CellLabel->"Out[422]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inverted triangular", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InitializeAll", "[", 
   RowBox[{"7", ",", 
    SubscriptBox["F", 
     RowBox[{"\[Beta]", " ", "Wing"}]]}], "]"}], ";", 
  RowBox[{"Calculate", "[", "]"}], ";"}]], "Input",
 CellLabel->"In[423]:="],

Cell[BoxData["\<\"Initializing all probabilities and rules.\"\>"], "Print",
 CellChangeTimes->{3.389694464118024*^9, 3.389694852850024*^9, 
  3.389695066239024*^9, 3.3896951379610243`*^9, 3.3896952402770243`*^9, 
  3.389695362482024*^9, 3.389695477074024*^9, 3.389695690361024*^9, 
  3.389695734385024*^9, 3.3896957681520243`*^9, 3.389695847091024*^9, 
  3.389695949348024*^9},
 CellLabel->"During evaluation of In[423]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"T=\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" \\!\\(\\*SubscriptBox[\\(F\\), \\(\[Beta]\\\\ \
Rule\\)]\\)=\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SubscriptBox["F", "\[Beta]"], "[", "\[Beta]_", "]"}], "\[RuleDelayed]", 
    RowBox[{"Which", "[", 
     RowBox[{
      RowBox[{"\[Beta]", "\[LessEqual]", "0"}], ",", "0", ",", 
      RowBox[{"0", "<", "\[Beta]", "\[LessEqual]", "1"}], ",", 
      RowBox[{"\[Beta]", "-", 
       FractionBox[
        SuperscriptBox["\[Beta]", "2"], "2"]}], ",", 
      RowBox[{"1", "<", "\[Beta]", "<", "2"}], ",", 
      RowBox[{"1", "-", "\[Beta]", "+", 
       FractionBox[
        SuperscriptBox["\[Beta]", "2"], "2"]}], ",", 
      RowBox[{"\[Beta]", "\[GreaterEqual]", "2"}], ",", "1"}], "]"}]}], 
   "\[InvisibleSpace]", "\<\" \\!\\(\\*UnderscriptBox[\\(\[Beta]\\), \\(_\\)]\
\\)=\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\" \\!\\(\\*OverscriptBox[\\(\[Beta]\\), \
\\(_\\)]\\)=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" V=\"\>", "\[InvisibleSpace]", "5.5`", 
   "\[InvisibleSpace]", "\<\" B=\"\>", "\[InvisibleSpace]", "5.`", 
   "\[InvisibleSpace]", "\<\" A=\"\>", "\[InvisibleSpace]", "6.`"}],
  SequenceForm[
  "T=", 7, " \!\(\*SubscriptBox[\(F\), \(\[Beta]\\ Rule\)]\)=", \
$CellContext`F\[Beta][
     Pattern[$CellContext`\[Beta], 
      Blank[]]] :> Which[$CellContext`\[Beta] <= 0, 0, 
     Inequality[
     0, Less, $CellContext`\[Beta], LessEqual, 
      1], $CellContext`\[Beta] - $CellContext`\[Beta]^2/2, 
     1 < $CellContext`\[Beta] < 2, 
     1 - $CellContext`\[Beta] + $CellContext`\[Beta]^2/
      2, $CellContext`\[Beta] >= 2, 1], 
   " \!\(\*UnderscriptBox[\(\[Beta]\), \(_\)]\)=", 0, 
   " \!\(\*OverscriptBox[\(\[Beta]\), \(_\)]\)=", 2, " V=", 5.5, " B=", 5., 
   " A=", 6.],
  Editable->False]], "Print",
 CellChangeTimes->{3.389694464118024*^9, 3.389694852850024*^9, 
  3.389695066239024*^9, 3.3896951379610243`*^9, 3.3896952402770243`*^9, 
  3.389695362482024*^9, 3.389695477074024*^9, 3.389695690361024*^9, 
  3.389695734385024*^9, 3.3896957681520243`*^9, 3.389695847091024*^9, 
  3.3896959493690243`*^9},
 CellLabel->"During evaluation of In[423]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Max discrepancy in transition probabilities=\"\>", 
   "\[InvisibleSpace]", "1.1102230246251565`*^-16"}],
  SequenceForm[
  "Max discrepancy in transition probabilities=", 1.1102230246251565`*^-16],
  Editable->False]], "Print",
 CellChangeTimes->{3.389694464118024*^9, 3.389694852850024*^9, 
  3.389695066239024*^9, 3.3896951379610243`*^9, 3.3896952402770243`*^9, 
  3.389695362482024*^9, 3.389695477074024*^9, 3.389695690361024*^9, 
  3.389695734385024*^9, 3.3896957681520243`*^9, 3.389695847091024*^9, 
  3.389695950287024*^9},
 CellLabel->"During evaluation of In[423]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Max discrepancy in state probabilities=\"\>", 
   "\[InvisibleSpace]", "4.440892098500626`*^-16"}],
  SequenceForm[
  "Max discrepancy in state probabilities=", 4.440892098500626*^-16],
  Editable->False]], "Print",
 CellChangeTimes->{3.389694464118024*^9, 3.389694852850024*^9, 
  3.389695066239024*^9, 3.3896951379610243`*^9, 3.3896952402770243`*^9, 
  3.389695362482024*^9, 3.389695477074024*^9, 3.389695690361024*^9, 
  3.389695734385024*^9, 3.3896957681520243`*^9, 3.389695847091024*^9, 
  3.3896959509350243`*^9},
 CellLabel->"During evaluation of In[423]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["PrintExpectedDepth"], "Input",
 CellLabel->"In[424]:="],

Cell[BoxData[
 TagBox[
  TagBox[
   TagBox[GridBox[{
      {
       TagBox["\<\"t\"\>",
        HoldForm], 
       InterpretationBox["\<\"1.000\"\>",
        1,
        Editable->False], 
       InterpretationBox["\<\"2.000\"\>",
        2,
        Editable->False], 
       InterpretationBox["\<\"3.000\"\>",
        3,
        Editable->False], 
       InterpretationBox["\<\"4.000\"\>",
        4,
        Editable->False], 
       InterpretationBox["\<\"5.000\"\>",
        5,
        Editable->False], 
       InterpretationBox["\<\"6.000\"\>",
        6,
        Editable->False], 
       InterpretationBox["\<\"7.000\"\>",
        7,
        Editable->False]},
      {
       TagBox["\<\"E[Depth]\"\>",
        HoldForm], 
       InterpretationBox["\<\"0.000\"\>",
        0.,
        AutoDelete->True], 
       InterpretationBox["\<\"0.126\"\>",
        0.12593826985864823`,
        AutoDelete->True], 
       InterpretationBox["\<\"0.187\"\>",
        0.1865135605255104,
        AutoDelete->True], 
       InterpretationBox["\<\"0.194\"\>",
        0.19403880391439768`,
        AutoDelete->True], 
       InterpretationBox["\<\"0.176\"\>",
        0.175507575086325,
        AutoDelete->True], 
       InterpretationBox["\<\"0.148\"\>",
        0.14777742439599936`,
        AutoDelete->True], 
       InterpretationBox["\<\"0.119\"\>",
        0.11899545392265028`,
        AutoDelete->True]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxDividers->{
      "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
       "Rows" -> {{False}}, "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    {OutputFormsDump`HeadedRows, None}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, TableSpacing -> {1, 1}, 
     TableHeadings -> {{"t", "E[Depth]"}}]]],
  NumberForm[#, {5, 3}]& ]], "Output",
 CellChangeTimes->{3.3896364935699997`*^9, 3.3896385134049997`*^9, 
  3.3896533870620003`*^9, 3.389653502171*^9, 3.3896591335214243`*^9, 
  3.3896594577904243`*^9, 3.389659533196424*^9, 3.389659567782424*^9, 
  3.3896596498454237`*^9, 3.389659696197424*^9, 3.3896940642012243`*^9, 
  3.389694466342024*^9, 3.389694855125024*^9, 3.389695068516024*^9, 
  3.389695140198024*^9, 3.389695242514024*^9, 3.389695364656024*^9, 
  3.3896954793840237`*^9, 3.389695692658024*^9, 3.3896957366780243`*^9, 
  3.389695770460024*^9, 3.389695849401024*^9, 3.3896959516460238`*^9},
 CellLabel->"Out[424]//NumberForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"d", "=", "0.005"}], ";"}], "\n", 
 RowBox[{"\[Beta]C", "=", 
  RowBox[{"Round", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Apply", "[", 
        RowBox[{"#", ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "0", ",", "0"}], "}"}]}], "]"}], "&"}], " ", 
      ")"}], "/@", " ", 
     RowBox[{"{", 
      RowBox[{
      "\[Beta]LmtSellLow", ",", "\[Beta]LmtSellHigh", ",", "\[Beta]LmtBuyLow",
        ",", "\[Beta]LmtBuyHigh"}], "}"}]}], ",", "0.01"}], "]"}]}]}], "Input",\

 CellChangeTimes->{{3.389638497736*^9, 3.389638504374*^9}},
 CellLabel->"In[425]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.55`", ",", "1.09`", ",", "0.91`", ",", "1.45`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.3896364969639997`*^9, {3.389638504972*^9, 3.3896385134440002`*^9}, 
   3.389653387105*^9, 3.389653502215*^9, 3.389659133559424*^9, 
   3.3896594578304243`*^9, 3.389659533237424*^9, 3.389659567822424*^9, 
   3.3896596499034243`*^9, 3.389659696240424*^9, 3.389694064251224*^9, 
   3.389694466375024*^9, 3.389694855165024*^9, 3.389695068555024*^9, 
   3.389695140228024*^9, 3.389695242543024*^9, 3.3896953646860237`*^9, 
   3.3896954794280243`*^9, 3.389695692696024*^9, 3.389695736715024*^9, 
   3.3896957705010242`*^9, 3.3896958494430237`*^9, 3.389695951684024*^9},
 CellLabel->"Out[426]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p3", "=", 
  RowBox[{"Graphics", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"GrayLevel", "[", "0.9`", "]"}], ",", 
      RowBox[{"Rectangle", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"3", " ", "d"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
          "\[Beta]C", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
          ",", 
          RowBox[{"1", "-", "d"}]}], "}"}]}], "]"}], ",", 
      RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"Market\",
FontSlant->\"Italic\"]\)\\n\!\(\*
StyleBox[\"Sell\",
FontSlant->\"Italic\"]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
           "\[Beta]C", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
            "-", "0.1`"}], ",", 
          RowBox[{"0.9`", "\[InvisibleSpace]", "-", "d"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
      RowBox[{"GrayLevel", "[", "0.7`", "]"}], ",", 
      RowBox[{"Rectangle", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
          "\[Beta]C", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
          ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
          "\[Beta]C", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
          ",", 
          RowBox[{"1", "-", "d"}]}], "}"}]}], "]"}], ",", 
      RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"Limit\",
FontSlant->\"Italic\"]\)\\n\!\(\*
StyleBox[\"Sell\",
FontSlant->\"Italic\"]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
           "\[Beta]C", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
            "-", "0.1`"}], ",", 
          RowBox[{"0.9`", "\[InvisibleSpace]", "-", "d"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"Seller\",
FontSlant->\"Italic\"]\)\\n\!\(\*
StyleBox[\"does\",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\" \",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"nothing\",
FontSlant->\"Italic\"]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"1.5`", ",", 
          RowBox[{"0.9`", "\[InvisibleSpace]", "-", "d"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", 
      RowBox[{"GrayLevel", "[", "0.`", "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0.5`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "0.5`"}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"GrayLevel", "[", "0.`", "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
           "\[Beta]C", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
            ",", 
           TagBox[
            RowBox[{"\[Beta]C", "\[LeftDoubleBracket]", 
             InterpretationBox["\"\<  1.00\>\"",
              1,
              Editable->False], "\[RightDoubleBracket]"}],
            PaddedForm[#, {4, 2}]& ]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
           "\[Beta]C", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
            ",", 
           TagBox[
            RowBox[{"\[Beta]C", "\[LeftDoubleBracket]", 
             InterpretationBox["\"\<  2.00\>\"",
              2,
              Editable->False], "\[RightDoubleBracket]"}],
            PaddedForm[#, {4, 2}]& ]}], "}"}], ",", "2"}], "}"}], ",", 
       RowBox[{"Range", "[", 
        RowBox[{"0", ",", "1", ",", "0.2`"}], "]"}], ",", "None", ",", 
       "None"}], "}"}]}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Immediacy preference, \[Beta] \>\"", ",", "\"\<Probability\>\"", 
       ",", "\"\<C. Inverted Triangular\>\"", ",", "None"}], "}"}]}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"BaseStyle", "\[Rule]", "bStyle"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.389636447546*^9, 3.389636465791*^9}, {3.389636503633*^9,
    3.3896365139969997`*^9}, {3.3896385205620003`*^9, 3.389638548502*^9}, {
   3.389653376284*^9, 3.3896533806809998`*^9}, 3.389694080159224*^9, {
   3.389694668642024*^9, 3.3896946691340237`*^9}, {3.389694825911024*^9, 
   3.389694826254024*^9}},
 CellLabel->"In[427]:="],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0.9], RectangleBox[{0.015, 0.005}, {0.55, 0.995}]}, 
   {GrayLevel[0], 
    InsetBox["\<\"\\!\\(\\*\\nStyleBox[\\\"Market\\\",\\nFontSlant->\\\"\
Italic\\\"]\\)\\n\\!\\(\\*\\nStyleBox[\\\"Sell\\\",\\nFontSlant->\\\"Italic\\\
\"]\\)\"\>", {0.45000000000000007`, 0.895}, {1, 1}]}, 
   {GrayLevel[0.7], RectangleBox[{0.55, 0.005}, {1.09, 0.995}]}, 
   {GrayLevel[0], 
    InsetBox["\<\"\\!\\(\\*\\nStyleBox[\\\"Limit\\\",\\nFontSlant->\\\"Italic\
\\\"]\\)\\n\\!\\(\\*\\nStyleBox[\\\"Sell\\\",\\nFontSlant->\\\"Italic\\\"]\\)\
\"\>", {0.9900000000000001, 0.895}, {1, 1}], 
    InsetBox["\<\"\\!\\(\\*\\nStyleBox[\\\"Seller\\\",\\nFontSlant->\\\"\
Italic\\\"]\\)\\n\\!\\(\\*\\nStyleBox[\\\"does\\\",\\nFontSlant->\\\"Italic\\\
\"]\\)\\!\\(\\*\\nStyleBox[\\\" \
\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[\\\"nothing\\\",\\\
nFontSlant->\\\"Italic\\\"]\\)\"\>", {1.5, 0.895}, {0, 1}]}, 
   {GrayLevel[0.], 
    StyleBox[LineBox[{{0, 0.5}, {2, 0.5}}],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], 
    StyleBox[LineBox[{{0, 1}, {1, 0}, {2, 1}}],
     FontColor->GrayLevel[0.]]}},
  BaseStyle->{FontFamily -> "Times", FontSize -> 40},
  Frame->True,
  FrameLabel->{
    FormBox["\"Immediacy preference, \[Beta] \"", TraditionalForm], 
    FormBox["\"Probability\"", TraditionalForm], 
    FormBox["\"C. Inverted Triangular\"", TraditionalForm], None},
  FrameTicks->{{{0, 
      FormBox["0", TraditionalForm]}, {0.55, 
      FormBox["0.55`", TraditionalForm]}, {1.09, 
      FormBox["1.09`", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}}, {{0., 
      FormBox["0.`", TraditionalForm]}, {0.2, 
      FormBox["0.2`", TraditionalForm]}, {0.4, 
      FormBox["0.4`", TraditionalForm]}, {0.6000000000000001, 
      FormBox["0.6000000000000001`", TraditionalForm]}, {0.8, 
      FormBox["0.8`", TraditionalForm]}, {1., 
      FormBox["1.`", TraditionalForm]}}, None, None}]], "Output",
 CellChangeTimes->{{3.3896364996400003`*^9, 3.3896365144300003`*^9}, 
   3.3896385492539997`*^9, 3.389638587451*^9, 3.389653387166*^9, 
   3.3896535022869997`*^9, 3.389659133612424*^9, 3.389659457891424*^9, 
   3.389659533299424*^9, 3.389659567886424*^9, 3.389659649986424*^9, 
   3.389659696313424*^9, {3.389694064331224*^9, 3.389694081765224*^9}, 
   3.3896944664170237`*^9, 3.389694670455024*^9, 3.389694855224024*^9, 
   3.389695068614024*^9, 3.389695140272024*^9, 3.389695242584024*^9, 
   3.3896953647260237`*^9, 3.389695479486024*^9, 3.389695692754024*^9, 
   3.3896957367710238`*^9, 3.389695770555024*^9, 3.3896958495020237`*^9, 
   3.389695951741024*^9},
 CellLabel->"Out[427]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Output to graphics file", "Subsubsection",
 CellChangeTimes->{{3.3896937059922237`*^9, 3.3896937140102243`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "=", 
  RowBox[{"GraphicsGrid", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"p1", ",", "SpanFromLeft"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"p2", ",", "p3"}], "}"}]}], "}"}], ",", 
    RowBox[{"Background", "\[Rule]", 
     RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", 
    RowBox[{"BaseStyle", "\[Rule]", "bStyle"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.389648084875*^9, 3.389648099487*^9}, {3.389652924525*^9,
    3.389652927538*^9}, {3.3896530902469997`*^9, 3.389653109565*^9}, {
   3.389653163973*^9, 3.389653195495*^9}, {3.389653435987*^9, 
   3.389653479348*^9}, {3.389659150860424*^9, 3.389659156629424*^9}, {
   3.389659268808424*^9, 3.389659278749424*^9}, {3.3896598781864243`*^9, 
   3.389659913717424*^9}, {3.389693921196224*^9, 3.389693929427224*^9}, {
   3.389694823176024*^9, 3.3896948235010242`*^9}, 3.389695049514024*^9},
 CellLabel->"In[428]:="],

Cell[BoxData[
 GraphicsBox[{{{
     {GrayLevel[1], RectangleBox[{384., -240.}, {768., -480.}]}, 
     {GrayLevel[1], RectangleBox[{0, -240.}, {384., -480.}]}}, {
     {GrayLevel[1], RectangleBox[{384., 0}, {768., -240.}]}, 
     {GrayLevel[1], RectangleBox[{0, 0}, {768., -240.}]}}}, {{InsetBox[
      GraphicsBox[{
        {GrayLevel[0.9], RectangleBox[{0.015, 0.005}, {0.64, 0.995}]}, 
        {GrayLevel[0], 
         InsetBox["\<\"\\!\\(\\*\\nStyleBox[\\\"Market\\\",\\nFontSlant->\\\"\
Italic\\\"]\\)\\n\\!\\(\\*\\nStyleBox[\\\"Sell\\\",\\nFontSlant->\\\"Italic\\\
\"]\\) \"\>", {0.54, 0.895}, {1, 1}]}, 
        {GrayLevel[0.7], RectangleBox[{0.64, 0.005}, {1.09, 0.995}]}, 
        {GrayLevel[0], 
         InsetBox["\<\" \
\\!\\(\\*\\nStyleBox[\\\"Limit\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\nS\\!\\(\
\\*\\nStyleBox[\\\"ell\\\",\\nFontSlant->\\\"Italic\\\"]\\) \"\>", \
{0.9900000000000001, 0.895}, {1, 1}], 
         InsetBox["\<\" \
\\!\\(\\*\\nStyleBox[\\\"Seller\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\
\\nStyleBox[\\\" \\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[\\\
\"does\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\n\\!\\(\\*\\nStyleBox[\\\"\
nothing\\\",\\nFontSlant->\\\"Italic\\\"]\\) \"\>", {1.5, 0.895}, {0, 1}]}, 
        {GrayLevel[0.], 
         StyleBox[LineBox[{{0, 0.5}, {2, 0.5}}],
          FontColor->GrayLevel[0.]]}},
       BaseStyle->{FontFamily -> "Times", FontSize -> 40},
       Frame->True,
       FrameLabel->{
         FormBox["\"Immediacy preference, \[Beta]\"", TraditionalForm], 
         FormBox["\"Probability\"", TraditionalForm], 
         FormBox["\"A. Uniform\"", TraditionalForm], None},
       FrameTicks->{{{0, 
           FormBox["0", TraditionalForm]}, {0.64, 
           FormBox["0.64`", TraditionalForm]}, {1.09, 
           FormBox["1.09`", TraditionalForm]}, {2, 
           FormBox["2", TraditionalForm]}}, {{0., 
           FormBox["0.`", TraditionalForm]}, {0.2, 
           FormBox["0.2`", TraditionalForm]}, {0.4, 
           FormBox["0.4`", TraditionalForm]}, {0.6000000000000001, 
           FormBox["0.6000000000000001`", TraditionalForm]}, {0.8, 
           FormBox["0.8`", TraditionalForm]}, {1., 
           FormBox["1.`", TraditionalForm]}}, None, None},
       PlotRange->{{0, 2}, {0, 1}}], {384., -120.}, ImageScaled[{0.5, 0.5}], {744., 225.},
      
      Background->GrayLevel[1]], {}}, {InsetBox[
      GraphicsBox[{
        {GrayLevel[0.9], 
         RectangleBox[{0.03, 0.01}, {0.7000000000000001, 0.99}]}, 
        {GrayLevel[0], 
         InsetBox["\<\"\\!\\(\\*\\nStyleBox[\\\"Market\\\",\\nFontSlant->\\\"\
Italic\\\"]\\)\\n\\!\\(\\*\\nStyleBox[\\\"Sell\\\",\\nFontSlant->\\\"Italic\\\
\"]\\) \"\>", {0.6000000000000001, 0.89}, {1, 1}]}, 
        {GrayLevel[0.7], 
         RectangleBox[{0.7000000000000001, 0.01}, {1.09, 0.99}]}, 
        {GrayLevel[0], 
         InsetBox["\<\"\\!\\(\\*\\nStyleBox[\\\"Limit\\\",\\nFontSlant->\\\"\
Italic\\\"]\\)\\n\\!\\(\\*\\nStyleBox[\\\"Sell\\\",\\nFontSlant->\\\"Italic\\\
\"]\\)\"\>", {0.9900000000000001, 0.89}, {1, 1}], 
         InsetBox["\<\" \
\\!\\(\\*\\nStyleBox[\\\"Seller\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\n\\!\\(\
\\*\\nStyleBox[\\\"does\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\\
nStyleBox[\\\" \
\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[\\\"nothing\\\",\\\
nFontSlant->\\\"Italic\\\"]\\) \"\>", {1.5, 0.89}, {0, 1}]}, 
        {GrayLevel[0.], 
         StyleBox[LineBox[{{0, 0.5}, {2, 0.5}}],
          FontColor->GrayLevel[0.]]}, 
        {GrayLevel[0.], 
         StyleBox[LineBox[{{0, 0}, {1, 1}, {2, 0}}],
          FontColor->GrayLevel[0.]]}},
       BaseStyle->{FontFamily -> "Times", FontSize -> 40},
       Frame->True,
       FrameLabel->{
         FormBox["\"Immediacy preference \[Beta] \"", TraditionalForm], 
         FormBox["\"Probability\"", TraditionalForm], 
         FormBox["\"B. Triangular\"", TraditionalForm], None},
       FrameTicks->{{{0, 
           FormBox["0", TraditionalForm]}, {0.7000000000000001, 
           FormBox["0.7000000000000001`", TraditionalForm]}, {1.09, 
           FormBox["1.09`", TraditionalForm]}, {2, 
           FormBox["2", TraditionalForm]}}, {{0., 
           FormBox["0.`", TraditionalForm]}, {0.2, 
           FormBox["0.2`", TraditionalForm]}, {0.4, 
           FormBox["0.4`", TraditionalForm]}, {0.6000000000000001, 
           FormBox["0.6000000000000001`", TraditionalForm]}, {0.8, 
           FormBox["0.8`", TraditionalForm]}, {1., 
           FormBox["1.`", TraditionalForm]}}, None, None},
       PlotRange->{{0, 2}, {0, 1}}], {192., -360.}, ImageScaled[{0.5, 0.5}], {360., 225.},
      
      Background->GrayLevel[1]], InsetBox[
      GraphicsBox[{
        {GrayLevel[0.9], RectangleBox[{0.015, 0.005}, {0.55, 0.995}]}, 
        {GrayLevel[0], 
         InsetBox["\<\"\\!\\(\\*\\nStyleBox[\\\"Market\\\",\\nFontSlant->\\\"\
Italic\\\"]\\)\\n\\!\\(\\*\\nStyleBox[\\\"Sell\\\",\\nFontSlant->\\\"Italic\\\
\"]\\)\"\>", {0.45000000000000007`, 0.895}, {1, 1}]}, 
        {GrayLevel[0.7], RectangleBox[{0.55, 0.005}, {1.09, 0.995}]}, 
        {GrayLevel[0], 
         InsetBox["\<\"\\!\\(\\*\\nStyleBox[\\\"Limit\\\",\\nFontSlant->\\\"\
Italic\\\"]\\)\\n\\!\\(\\*\\nStyleBox[\\\"Sell\\\",\\nFontSlant->\\\"Italic\\\
\"]\\)\"\>", {0.9900000000000001, 0.895}, {1, 1}], 
         InsetBox["\<\"\\!\\(\\*\\nStyleBox[\\\"Seller\\\",\\nFontSlant->\\\"\
Italic\\\"]\\)\\n\\!\\(\\*\\nStyleBox[\\\"does\\\",\\nFontSlant->\\\"Italic\\\
\"]\\)\\!\\(\\*\\nStyleBox[\\\" \
\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[\\\"nothing\\\",\\\
nFontSlant->\\\"Italic\\\"]\\)\"\>", {1.5, 0.895}, {0, 1}]}, 
        {GrayLevel[0.], 
         StyleBox[LineBox[{{0, 0.5}, {2, 0.5}}],
          FontColor->GrayLevel[0.]]}, 
        {GrayLevel[0.], 
         StyleBox[LineBox[{{0, 1}, {1, 0}, {2, 1}}],
          FontColor->GrayLevel[0.]]}},
       BaseStyle->{FontFamily -> "Times", FontSize -> 40},
       Frame->True,
       FrameLabel->{
         FormBox["\"Immediacy preference, \[Beta] \"", TraditionalForm], 
         FormBox["\"Probability\"", TraditionalForm], 
         FormBox["\"C. Inverted Triangular\"", TraditionalForm], None},
       FrameTicks->{{{0, 
           FormBox["0", TraditionalForm]}, {0.55, 
           FormBox["0.55`", TraditionalForm]}, {1.09, 
           FormBox["1.09`", TraditionalForm]}, {2, 
           FormBox["2", TraditionalForm]}}, {{0., 
           FormBox["0.`", TraditionalForm]}, {0.2, 
           FormBox["0.2`", TraditionalForm]}, {0.4, 
           FormBox["0.4`", TraditionalForm]}, {0.6000000000000001, 
           FormBox["0.6000000000000001`", TraditionalForm]}, {0.8, 
           FormBox["0.8`", TraditionalForm]}, {1., 
           FormBox["1.`", TraditionalForm]}}, None, None}], {576., -360.}, 
      ImageScaled[{0.5, 0.5}], {360., 225.},
      Background->GrayLevel[1]]}}, {}},
  BaseStyle->{FontFamily -> "Times", FontSize -> 40},
  ContentSelectable->True,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{3.389695068696024*^9, 3.389695140327024*^9, 
  3.389695242642024*^9, 3.389695364780024*^9, 3.3896954795860243`*^9, 
  3.3896955957000237`*^9, 3.389695692832024*^9, 3.389695736853024*^9, 
  3.389695770635024*^9, 3.389695849584024*^9, 3.389695951820024*^9},
 CellLabel->"Out[428]=",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "SetDirectory", "[", 
   "\"\<c:/Active/Empirical Market Microstructure/Mathematica/Spring \
2007\>\"", "]"}], ";"}]], "Input",
 CellAutoOverwrite->False,
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3881708634346*^9, 3.3881708734596*^9}, {
  3.3881710728336*^9, 3.3881711170716*^9}, {3.389524702079319*^9, 
  3.389524702676319*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<Figure124.tiff\>\"", ",", "g", ",", "\"\<TIFF\>\"", ",", 
    RowBox[{"ImageSize", "\[Rule]", "imageSize"}], ",", 
    RowBox[{"ColorSpace", "\[Rule]", "GrayLevel"}], ",", 
    RowBox[{"ImageResolution", "\[Rule]", "tiffResolution"}]}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.389648430644*^9, 3.389648455574*^9}, {3.389648492177*^9,
   3.389648494311*^9}, {3.389648603407*^9, 3.389648606415*^9}, {
  3.389648842217*^9, 3.389648849666*^9}, {3.389648930434*^9, 
  3.389648930494*^9}, {3.389649005645*^9, 3.389649015264*^9}, {
  3.389649079592*^9, 3.389649080668*^9}, {3.389649122667*^9, 
  3.38964912359*^9}, {3.389649931959*^9, 3.389649984863*^9}, {
  3.389650101283*^9, 3.389650165151*^9}, {3.389650234523*^9, 
  3.3896503012720003`*^9}, {3.389650344803*^9, 3.389650346986*^9}, {
  3.3896505228120003`*^9, 3.389650576788*^9}, {3.389650621005*^9, 
  3.389650633855*^9}, {3.3896522842200003`*^9, 3.3896522957139997`*^9}, {
  3.3896523301*^9, 3.38965243783*^9}, {3.3896525233059998`*^9, 
  3.3896525873389997`*^9}, {3.3896529475769997`*^9, 3.38965294875*^9}, {
  3.3896532218789997`*^9, 3.389653223825*^9}, {3.389653259998*^9, 
  3.389653261913*^9}, {3.389653412618*^9, 3.3896534160369997`*^9}, {
  3.389653523041*^9, 3.389653575538*^9}, {3.389659161318424*^9, 
  3.389659165792424*^9}, {3.389659230493424*^9, 3.389659233743424*^9}, {
  3.389659361600424*^9, 3.389659425089424*^9}, {3.389659479500424*^9, 
  3.389659479631424*^9}, {3.3896595799894238`*^9, 3.3896596262714243`*^9}, {
  3.389693940850224*^9, 3.3896939436312237`*^9}, {3.3896939915252237`*^9, 
  3.389694006313224*^9}, {3.389695623044024*^9, 3.389695639889024*^9}},
 CellLabel->"In[430]:="]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->None,
WindowSize->{1578, 1027},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Visible->True,
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
ShowSelection->True,
InputAliases->{"intt" -> RowBox[{"\[Integral]", 
     RowBox[{"\[SelectionPlaceholder]", 
       RowBox[{"\[DifferentialD]", "\[Placeholder]"}]}]}], "dintt" -> 
  RowBox[{
     SubsuperscriptBox[
     "\[Integral]", "\[SelectionPlaceholder]", "\[Placeholder]"], 
     RowBox[{"\[Placeholder]", 
       RowBox[{"\[DifferentialD]", "\[Placeholder]"}]}]}], "sumt" -> RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"\[SelectionPlaceholder]", "=", "\[Placeholder]"}], 
      "\[Placeholder]"], "\[Placeholder]"}], "prodt" -> RowBox[{
     UnderoverscriptBox["\[Product]", 
      RowBox[{"\[SelectionPlaceholder]", "=", "\[Placeholder]"}], 
      "\[Placeholder]"], "\[Placeholder]"}], "dt" -> RowBox[{
     SubscriptBox["\[PartialD]", "\[Placeholder]"], " ", 
     "\[SelectionPlaceholder]"}], "notation" -> RowBox[{"Notation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], " ", 
       "\[DoubleLongLeftRightArrow]", " ", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "notation>" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], " ", 
       "\[DoubleLongRightArrow]", " ", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "notation<" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], " ", 
       "\[DoubleLongLeftArrow]", " ", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "symb" -> 
  RowBox[{"Symbolize", "[", 
     TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], "]"}], 
  "infixnotation" -> RowBox[{"InfixNotation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], ",", 
       "\[Placeholder]"}], "]"}], "addia" -> RowBox[{"AddInputAlias", "[", 
     RowBox[{"\"\[SelectionPlaceholder]\"", "\[Rule]", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "pattwraper" -> 
  TagBox["\[SelectionPlaceholder]", "NotationPatternTag"], "madeboxeswraper" -> 
  TagBox["\[SelectionPlaceholder]", "NotationMadeBoxesTag"]},
Magnification->1.5,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->"EMMStyle02.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 39, 0, 89, "Title"],
Cell[632, 25, 175, 5, 194, "Subtitle"],
Cell[810, 32, 101, 2, 70, "Subtitle"],
Cell[CellGroupData[{
Cell[936, 38, 34, 0, 98, "Section"],
Cell[973, 40, 147, 3, 55, "Input"],
Cell[1123, 45, 142, 3, 55, "Input"],
Cell[1268, 50, 111, 3, 32, "Text"],
Cell[1382, 55, 719, 24, 83, "Input"],
Cell[CellGroupData[{
Cell[2126, 83, 57, 0, 71, "Subsection"],
Cell[2186, 85, 69, 0, 32, "Text"],
Cell[2258, 87, 1813, 65, 317, "Input"],
Cell[4074, 154, 130, 3, 32, "Text"],
Cell[4207, 159, 996, 31, 87, "Input"],
Cell[5206, 192, 88, 2, 32, "Text"],
Cell[5297, 196, 948, 31, 87, "Input"],
Cell[6248, 229, 45, 0, 32, "Text"],
Cell[6296, 231, 357, 11, 62, "Input"],
Cell[6656, 244, 698, 22, 83, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7403, 272, 40, 0, 98, "Section"],
Cell[7446, 274, 192, 4, 32, "Text"],
Cell[CellGroupData[{
Cell[7663, 282, 32, 0, 44, "Subsubsection"],
Cell[7698, 284, 813, 25, 94, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8548, 314, 54, 0, 44, "Subsubsection"],
Cell[8605, 316, 185, 6, 62, "Input"],
Cell[CellGroupData[{
Cell[8815, 326, 219, 7, 55, "Input"],
Cell[9037, 335, 9630, 165, 365, 2838, 52, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18704, 505, 429, 13, 55, "Input"],
Cell[19136, 520, 1337, 39, 91, "Output"]
}, Open  ]],
Cell[20488, 562, 768, 21, 60, "Input"],
Cell[CellGroupData[{
Cell[21281, 587, 426, 13, 58, "Input"],
Cell[21710, 602, 6031, 104, 358, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27790, 712, 35, 0, 44, "Subsubsection"],
Cell[27828, 714, 185, 6, 62, "Input"],
Cell[CellGroupData[{
Cell[28038, 724, 245, 8, 55, "Input"],
Cell[28286, 734, 2605, 49, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30928, 788, 455, 14, 55, "Input"],
Cell[31386, 804, 1254, 36, 70, "Output"]
}, Open  ]],
Cell[32655, 843, 779, 21, 60, "Input"],
Cell[CellGroupData[{
Cell[33459, 868, 432, 13, 58, "Input"],
Cell[33894, 883, 6005, 103, 70, "Output"]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[39960, 993, 63, 0, 98, "Section"],
Cell[CellGroupData[{
Cell[40048, 997, 41, 0, 71, "Subsection"],
Cell[40092, 999, 2092, 63, 201, "Input"],
Cell[42187, 1064, 4200, 119, 408, "Input"],
Cell[46390, 1185, 6991, 197, 489, "Input"],
Cell[53384, 1384, 10678, 274, 570, "Input"],
Cell[64065, 1660, 41, 0, 32, "Text"],
Cell[64109, 1662, 9306, 232, 489, "Input"],
Cell[73418, 1896, 4036, 105, 396, "Input"],
Cell[77457, 2003, 195, 5, 55, "Input"],
Cell[77655, 2010, 123, 3, 55, "Input"],
Cell[77781, 2015, 2305, 56, 367, "Input"],
Cell[80089, 2073, 122, 3, 55, "Input"],
Cell[CellGroupData[{
Cell[80236, 2080, 85, 2, 55, "Input"],
Cell[80324, 2084, 316, 4, 32, "Print"],
Cell[80643, 2090, 1784, 37, 37, "Print"]
}, Open  ]],
Cell[82442, 2130, 8775, 223, 1030, "Input"],
Cell[CellGroupData[{
Cell[91242, 2357, 189, 5, 55, "Input"],
Cell[91434, 2364, 339, 4, 32, "Print"],
Cell[91776, 2370, 1805, 37, 37, "Print"],
Cell[93584, 2409, 541, 10, 35, "Print"],
Cell[94128, 2421, 526, 10, 35, "Print"],
Cell[94657, 2433, 337, 7, 50, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[95043, 2446, 69, 0, 71, "Subsection"],
Cell[CellGroupData[{
Cell[95137, 2450, 184, 5, 55, "Input"],
Cell[95324, 2457, 294, 4, 32, "Print"],
Cell[95621, 2463, 1760, 37, 37, "Print"],
Cell[97384, 2502, 450, 9, 32, "Print"],
Cell[97837, 2513, 486, 10, 35, "Print"],
Cell[98326, 2525, 299, 6, 50, "Output"]
}, Open  ]],
Cell[98640, 2534, 760, 23, 58, "Input"],
Cell[CellGroupData[{
Cell[99425, 2561, 98, 2, 55, "Input"],
Cell[99526, 2565, 850, 22, 123, "Output"]
}, Open  ]],
Cell[100391, 2590, 778, 22, 83, "Input"],
Cell[CellGroupData[{
Cell[101194, 2616, 72, 1, 55, "Input"],
Cell[101269, 2619, 3222, 114, 143, "Output"]
}, Open  ]],
Cell[104506, 2736, 227, 6, 55, "Input"],
Cell[104736, 2744, 714, 21, 83, "Input"],
Cell[CellGroupData[{
Cell[105475, 2769, 68, 1, 55, "Input"],
Cell[105546, 2772, 1651, 51, 65, "Output"]
}, Open  ]],
Cell[107212, 2826, 999, 30, 85, "Input"],
Cell[CellGroupData[{
Cell[108236, 2860, 92, 2, 55, "Input"],
Cell[108331, 2864, 320, 7, 50, "Output"]
}, Open  ]],
Cell[108666, 2874, 229, 7, 55, "Input"],
Cell[108898, 2883, 206, 6, 55, "Input"],
Cell[109107, 2891, 539, 16, 55, "Input"],
Cell[CellGroupData[{
Cell[109671, 2911, 65, 1, 55, "Input"],
Cell[109739, 2914, 3661, 119, 161, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[113461, 3040, 51, 0, 98, "Section"],
Cell[CellGroupData[{
Cell[113537, 3044, 63, 0, 44, "Subsubsection"],
Cell[CellGroupData[{
Cell[113625, 3048, 184, 5, 55, "Input"],
Cell[113812, 3055, 255, 4, 32, "Print"],
Cell[114070, 3061, 1721, 37, 37, "Print"],
Cell[115794, 3100, 411, 9, 32, "Print"],
Cell[116208, 3111, 447, 10, 35, "Print"],
Cell[116658, 3123, 244, 6, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[116939, 3134, 68, 1, 55, "Input"],
Cell[117010, 3137, 1597, 50, 65, "Output"]
}, Open  ]],
Cell[118622, 3190, 117, 3, 55, "Input"],
Cell[CellGroupData[{
Cell[118764, 3197, 184, 5, 55, "Input"],
Cell[118951, 3204, 221, 3, 32, "Print"],
Cell[119175, 3209, 1687, 36, 37, "Print"],
Cell[120865, 3247, 423, 9, 35, "Print"],
Cell[121291, 3258, 413, 9, 35, "Print"],
Cell[121707, 3269, 230, 5, 50, "Output"]
}, Open  ]],
Cell[121952, 3277, 117, 3, 55, "Input"],
Cell[CellGroupData[{
Cell[122094, 3284, 184, 5, 55, "Input"],
Cell[122281, 3291, 220, 3, 32, "Print"],
Cell[122504, 3296, 1687, 36, 37, "Print"],
Cell[124194, 3334, 428, 9, 35, "Print"],
Cell[124625, 3345, 413, 9, 35, "Print"],
Cell[125041, 3356, 219, 5, 50, "Output"]
}, Open  ]],
Cell[125275, 3364, 117, 3, 55, "Input"],
Cell[CellGroupData[{
Cell[125417, 3371, 189, 5, 55, "Input"],
Cell[125609, 3378, 225, 3, 32, "Print"],
Cell[125837, 3383, 1691, 36, 37, "Print"],
Cell[127531, 3421, 427, 9, 35, "Print"],
Cell[127961, 3432, 415, 9, 32, "Print"],
Cell[128379, 3443, 207, 5, 50, "Output"]
}, Open  ]],
Cell[128601, 3451, 117, 3, 55, "Input"],
Cell[CellGroupData[{
Cell[128743, 3458, 1554, 45, 143, "Input"],
Cell[130300, 3505, 16669, 290, 382, 4264, 84, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[147018, 3801, 36, 0, 30, "Subsubsection"],
Cell[CellGroupData[{
Cell[147079, 3805, 184, 5, 55, "Input"],
Cell[147266, 3812, 201, 3, 32, "Print"],
Cell[147470, 3817, 1667, 36, 37, "Print"],
Cell[149140, 3855, 403, 9, 35, "Print"],
Cell[149546, 3866, 393, 9, 35, "Print"],
Cell[149942, 3877, 205, 5, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[150184, 3887, 162, 6, 55, "Input"],
Cell[150349, 3895, 1311, 35, 101, "Output"]
}, Open  ]],
Cell[151675, 3933, 32, 0, 32, "Text"],
Cell[151710, 3935, 142, 4, 55, "Input"],
Cell[151855, 3941, 30, 0, 32, "Text"],
Cell[151888, 3943, 467, 15, 83, "Input"],
Cell[CellGroupData[{
Cell[152380, 3962, 4593, 147, 380, "Input"],
Cell[156976, 4111, 19358, 365, 400, 8805, 189, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[176383, 4482, 59, 0, 30, "Subsubsection"],
Cell[CellGroupData[{
Cell[176467, 4486, 270, 8, 58, "Input"],
Cell[176740, 4496, 159, 2, 32, "Print"],
Cell[176902, 4500, 1981, 43, 55, "Print"],
Cell[178886, 4545, 366, 8, 35, "Print"],
Cell[179255, 4555, 351, 8, 35, "Print"],
Cell[179609, 4565, 157, 4, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[179803, 4574, 101, 2, 55, "Input"],
Cell[179907, 4578, 250, 6, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[180194, 4589, 276, 8, 58, "Input"],
Cell[180473, 4599, 159, 2, 32, "Print"],
Cell[180635, 4603, 1983, 42, 55, "Print"],
Cell[182621, 4647, 320, 7, 32, "Print"],
Cell[182944, 4656, 350, 8, 35, "Print"],
Cell[183297, 4666, 158, 4, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[183492, 4675, 107, 2, 55, "Input"],
Cell[183602, 4679, 248, 6, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[183887, 4690, 273, 8, 55, "Input"],
Cell[184163, 4700, 164, 2, 32, "Print"],
Cell[184330, 4704, 1625, 35, 37, "Print"],
Cell[185958, 4741, 361, 8, 35, "Print"],
Cell[186322, 4751, 356, 8, 35, "Print"],
Cell[186681, 4761, 158, 4, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[186876, 4770, 104, 2, 55, "Input"],
Cell[186983, 4774, 248, 6, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[187268, 4785, 2079, 60, 164, "Input"],
Cell[189350, 4847, 4004, 81, 395, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[193403, 4934, 43, 0, 45, "Subsection"],
Cell[CellGroupData[{
Cell[193471, 4938, 142, 1, 44, "Subsubsection"],
Cell[CellGroupData[{
Cell[193638, 4943, 984, 24, 164, "Input"],
Cell[194625, 4969, 539, 10, 50, "Output"]
}, Open  ]],
Cell[195179, 4982, 1139, 20, 55, "Input"],
Cell[196321, 5004, 977, 20, 55, "Input"],
Cell[197301, 5026, 372, 7, 55, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[197710, 5038, 32, 0, 44, "Subsubsection"],
Cell[CellGroupData[{
Cell[197767, 5042, 150, 4, 55, "Input"],
Cell[197920, 5048, 465, 6, 32, "Print"],
Cell[198388, 5056, 1933, 39, 37, "Print"],
Cell[200324, 5097, 667, 12, 35, "Print"],
Cell[200994, 5111, 657, 12, 35, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[201688, 5128, 69, 1, 55, "Input"],
Cell[201760, 5131, 2856, 81, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[204653, 5217, 722, 20, 55, "Input"],
Cell[205378, 5239, 853, 15, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[206268, 5259, 4954, 138, 245, "Input"],
Cell[211225, 5399, 2769, 52, 396, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[214043, 5457, 35, 0, 44, "Subsubsection"],
Cell[CellGroupData[{
Cell[214103, 5461, 239, 7, 58, "Input"],
Cell[214345, 5470, 431, 6, 32, "Print"],
Cell[214779, 5478, 2255, 46, 55, "Print"],
Cell[217037, 5526, 630, 12, 35, "Print"],
Cell[217670, 5540, 620, 12, 35, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[218327, 5557, 69, 1, 55, "Input"],
Cell[218399, 5560, 2760, 80, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[221196, 5645, 697, 22, 110, "Input"],
Cell[221896, 5669, 700, 12, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[222633, 5686, 5184, 146, 218, "Input"],
Cell[227820, 5834, 2652, 51, 396, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[230521, 5891, 44, 0, 44, "Subsubsection"],
Cell[CellGroupData[{
Cell[230590, 5895, 233, 7, 58, "Input"],
Cell[230826, 5904, 423, 6, 32, "Print"],
Cell[231252, 5912, 2242, 47, 55, "Print"],
Cell[233497, 5961, 625, 12, 35, "Print"],
Cell[234125, 5975, 614, 12, 35, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[234776, 5992, 69, 1, 55, "Input"],
Cell[234848, 5995, 2777, 80, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[237662, 6080, 639, 20, 83, "Input"],
Cell[238304, 6102, 725, 13, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[239066, 6120, 5028, 139, 191, "Input"],
Cell[244097, 6261, 2642, 50, 400, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[246788, 6317, 118, 1, 44, "Subsubsection"],
Cell[CellGroupData[{
Cell[246931, 6322, 950, 20, 55, "Input"],
Cell[247884, 6344, 33468, 570, 370, 6977, 134, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[281367, 6917, 375, 10, 55, "Input"],
Cell[281745, 6929, 1727, 28, 55, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
