(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14986,        590]
NotebookOptionsPosition[     12771,        511]
NotebookOutlinePosition[     13115,        526]
CellTagsIndexPosition[     13072,        523]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "HowToReadMathematica\n",
 StyleBox["Empirical Market Microstructure",
  FontSlant->"Italic"],
 " \n\t(2006, Oxford University Press)\nCompanion ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook\n\nJoel Hasbrouck\n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Copyright", " ", "2007"}], ",", " ", 
    RowBox[{"Joel", " ", 
     RowBox[{"Hasbrouck", ".", " ", "All"}], " ", "rights", " ", 
     RowBox[{"reserved", "."}]}]}], TraditionalForm]],
  FontSize->14,
  FontSlant->"Italic"],
 "\n",
 StyleBox["This notebook is a primer for reading ",
  FontSize->14],
 StyleBox["Mathematica",
  FontSize->14,
  FontSlant->"Italic"],
 StyleBox[" notebooks.",
  FontSize->14]
}], "Title",
 CellChangeTimes->{{3.3896255910914*^9, 3.3896255932033997`*^9}, {
   3.3897167078988237`*^9, 3.389716768500824*^9}, 3.3897219191158237`*^9, {
   3.3899919263996*^9, 3.3899919275346003`*^9}, {3.3899924133546*^9, 
   3.3899924443206*^9}, {3.39003008487543*^9, 3.3900301039984303`*^9}, {
   3.3900303920914307`*^9, 3.3900304077484303`*^9}, {3.3901548212418003`*^9, 
   3.3901548300118*^9}, {3.3901548727668*^9, 3.3901548926888*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Text", "  ", "@", " ", 
  RowBox[{"Style", "[", 
   RowBox[{
    RowBox[{"\"\<Notebook evaluated \>\"", "<>", 
     RowBox[{"DateString", "[", "\"\<DateTime\>\"", "]"}]}], ",", 
    "\"\<Subtitle\>\""}], "]"}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896127180972*^9, 3.3896127205282*^9}, 
   3.389716999411824*^9, {3.3897170351038237`*^9, 3.389717047196824*^9}}],

Cell[BoxData[
 InterpretationBox[Cell[BoxData[
   StyleBox["\<\"Notebook evaluated Wednesday 6 June 2007 17:41:37\"\>", 
    "Subtitle",
    StripOnInput->False]], "Text", "TR"],
  Text[
   Style["Notebook evaluated Wednesday 6 June 2007 17:41:37", 
    "Subtitle"]]]], "Output",
 CellMargins->{{18, Inherited}, {Inherited, 0}},
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896127211071997`*^9, {3.3896127536242*^9, 3.3896127555652*^9}, 
   3.3896128616452*^9, 3.389623031447*^9, 3.3896232934164*^9, 
   3.389716955274824*^9, 3.3897170008718243`*^9, {3.3897170377738237`*^9, 
   3.3897170482808237`*^9}, 3.3899920823416*^9, 3.3899921326345997`*^9, 
   3.3899925422046003`*^9, 3.3900306704554305`*^9, 3.3901548994927998`*^9},
 Background->RGBColor[0.866667, 0.733333, 1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rules", "Section"],

Cell[TextData[{
 "Most ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notation mimics normal usage. The major difference is the equals sign. \
Suppose that we encounter the following two equations in text:"
}], "Text"],

Cell[TextData[{
 "\t",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["m", "t"], "=", 
   RowBox[{
    SubscriptBox["m", 
     RowBox[{"t", "-", "1"}]], "+", 
    SubscriptBox["u", "t"]}]}]]],
 "\t\t\t(1)"
}], "Text"],

Cell[TextData[{
 "\t",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["p", "t"], "=", 
   RowBox[{
    SubscriptBox["m", "t"], "+", 
    RowBox[{"c", " ", 
     SubscriptBox["q", "t"]}]}]}]]],
 "\t\t\t(2)"
}], "Text"],

Cell[TextData[{
 "Intuitively, we know that these are describing dynamics of some \
time-subscripted variables. These equations are really \"rules\" for \
generating successive realizations of ",
 Cell[BoxData[
  SubscriptBox["m", "t"]]],
 " and ",
 Cell[BoxData[
  SubscriptBox["p", "t"]]],
 ". ",
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", equation (1) would be written as;"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["m", "t_"], "\[RuleDelayed]", 
  RowBox[{
   SubscriptBox["m", 
    RowBox[{"t", "-", "1"}]], "+", 
   SubscriptBox["u", "t"]}]}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{
  SubscriptBox["m", "t_"], "\[RuleDelayed]", 
  RowBox[{
   SubscriptBox["m", 
    RowBox[{"t", "-", "1"}]], "+", 
   SubscriptBox["u", "t"]}]}]], "Output",
 CellChangeTimes->{3.3901548996018*^9},
 CellLabel->"Out[2]="]
}, Open  ]],

Cell[TextData[{
 "The blue background signals that this line is input to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", rather than simply text. The beige background identifies ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " output. The notation ",
 Cell[BoxData["\[RuleDelayed]"]],
 " (or sometimes ",
 Cell[BoxData["\[Rule]"]],
 ") means \"replace the left-hand side with the right-hand side\". The ",
 Cell[BoxData["t_"]],
 " on the left-hand side of the rule is a pattern (template) that allows use \
to apply the rule to ",
 Cell[BoxData[
  SubscriptBox["m", 
   RowBox[{"t", "+", "5"}]]]],
 ", ",
 Cell[BoxData[
  SubscriptBox["m", "xyz"]]],
 " or ",
 Cell[BoxData[
  SubscriptBox["m", "whatever"]]],
 ", not just ",
 Cell[BoxData[
  SubscriptBox["m", "t"]]],
 ". To apply the rule, we use the notation \"",
 Cell[BoxData["/."]],
 "\". For example:"
}], "Text",
 CellChangeTimes->{{3.3901549144547997`*^9, 3.3901549625888*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["m", "t"], "/.", 
  RowBox[{
   SubscriptBox["m", "t_"], "\[RuleDelayed]", 
   RowBox[{
    SubscriptBox["m", 
     RowBox[{"t", "-", "1"}]], "+", 
    SubscriptBox["u", "t"]}]}]}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{
  SubscriptBox["m", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "t"}]], "+", 
  SubscriptBox["u", "t"]}]], "Output",
 CellChangeTimes->{3.3901548996368*^9},
 CellLabel->"Out[3]="]
}, Open  ]],

Cell[TextData[{
 "Note that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " writes expressions with numbers before variables: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"-", "1"}], "+", "t"}]]],
 " rather than ",
 Cell[BoxData[
  RowBox[{"t", "-", "1"}]]],
 ". Similarly:"
}], "Text",
 CellChangeTimes->{3.3901549495168*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["m", 
   RowBox[{"t", "+", "5"}]], "/.", 
  RowBox[{
   SubscriptBox["m", "t_"], "\[RuleDelayed]", 
   RowBox[{
    SubscriptBox["m", 
     RowBox[{"t", "-", "1"}]], "+", 
    SubscriptBox["u", "t"]}]}]}]], "Input",
 CellLabel->"In[4]:="],

Cell[BoxData[
 RowBox[{
  SubscriptBox["m", 
   RowBox[{"4", "+", "t"}]], "+", 
  SubscriptBox["u", 
   RowBox[{"5", "+", "t"}]]}]], "Output",
 CellChangeTimes->{3.3901548996878*^9},
 CellLabel->"Out[4]="]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " doesn't really know that ",
 Cell[BoxData["t"]],
 " indexes time, of course:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["m", "whatever"], "/.", 
  RowBox[{
   SubscriptBox["m", "t_"], "\[RuleDelayed]", 
   RowBox[{
    SubscriptBox["m", 
     RowBox[{"t", "-", "1"}]], "+", 
    SubscriptBox["u", "t"]}]}]}]], "Input",
 CellLabel->"In[5]:="],

Cell[BoxData[
 RowBox[{
  SubscriptBox["m", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "whatever"}]], "+", 
  SubscriptBox["u", "whatever"]}]], "Output",
 CellChangeTimes->{3.3901548997418003`*^9},
 CellLabel->"Out[5]="]
}, Open  ]],

Cell[TextData[{
 "The text expression for ",
 Cell[BoxData[
  SubscriptBox["m", "t"]]],
 " has a label \"(1)\" that allows us to subsequently refer to the rule. In \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", we assign the rule to a variable:"
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["m", "Rule"], "=", 
   RowBox[{
    SubscriptBox["m", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", 
      RowBox[{"t", "-", "1"}]], "+", 
     SubscriptBox["u", "t"]}]}]}], ";"}]], "Input",
 CellLabel->"In[6]:="],

Cell[TextData[{
 "The semicolon at the end of the line suppresses output. Now a reference to \
",
 Cell[BoxData[
  SubscriptBox["m", "Rule"]]],
 " invokes the rule we just defined. E.g.:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["m", "t"], "/.", 
  SubscriptBox["m", "Rule"]}]], "Input",
 CellLabel->"In[7]:="],

Cell[BoxData[
 RowBox[{
  SubscriptBox["m", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "t"}]], "+", 
  SubscriptBox["u", "t"]}]], "Output",
 CellChangeTimes->{3.3901548997938004`*^9},
 CellLabel->"Out[7]="]
}, Open  ]],

Cell["We can apply the rule repeatedly:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SubscriptBox["m", "t"], "/.", 
    SubscriptBox["m", "Rule"]}], "/.", 
   SubscriptBox["m", "Rule"]}], "/.", 
  SubscriptBox["m", "Rule"]}]], "Input",
 CellLabel->"In[8]:="],

Cell[BoxData[
 RowBox[{
  SubscriptBox["m", 
   RowBox[{
    RowBox[{"-", "3"}], "+", "t"}]], "+", 
  SubscriptBox["u", 
   RowBox[{
    RowBox[{"-", "2"}], "+", "t"}]], "+", 
  SubscriptBox["u", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "t"}]], "+", 
  SubscriptBox["u", "t"]}]], "Output",
 CellChangeTimes->{3.3901548998618*^9},
 CellLabel->"Out[8]="]
}, Open  ]],

Cell["And so forth. Here's another rule", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["p", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", "t"], "+", 
     RowBox[{"c", " ", 
      SubscriptBox["q", "t"]}]}]}]}], ";"}]], "Input",
 CellLabel->"In[10]:="],

Cell["Applying the rules in succession:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["p", "t"], "/.", 
   SubscriptBox["p", "Rule"]}], "/.", 
  SubscriptBox["m", "Rule"]}]], "Input",
 CellLabel->"In[11]:="],

Cell[BoxData[
 RowBox[{
  SubscriptBox["m", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "t"}]], "+", 
  RowBox[{"c", " ", 
   SubscriptBox["q", "t"]}], "+", 
  SubscriptBox["u", "t"]}]], "Output",
 CellChangeTimes->{3.3901548999848003`*^9},
 CellLabel->"Out[11]="]
}, Open  ]],

Cell["\<\
We can use rules in defining other rules. Here's an expression for the first \
difference:\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["\[CapitalDelta]p", "t_"], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["p", "t"], "/.", "\[InvisibleSpace]", 
        SubscriptBox["p", "Rule"]}], "/.", "\[InvisibleSpace]", 
       SubscriptBox["m", "Rule"]}], ")"}], "-", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["p", 
        RowBox[{"t", "-", "1"}]], "/.", "\[InvisibleSpace]", 
       SubscriptBox["p", "Rule"]}], ")"}]}]}]}], ";"}]], "Input",
 CellLabel->"In[12]:="],

Cell["For example:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[CapitalDelta]p", "t"], "/.", 
  SubscriptBox["\[CapitalDelta]p", "Rule"]}]], "Input",
 CellLabel->"In[13]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "c"}], " ", 
   SubscriptBox["q", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "t"}]]}], "+", 
  RowBox[{"c", " ", 
   SubscriptBox["q", "t"]}], "+", 
  SubscriptBox["u", "t"]}]], "Output",
 CellChangeTimes->{3.3901549000608*^9},
 CellLabel->"Out[13]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Equations and \"",
 Cell[BoxData["=="]],
 "\""
}], "Section"],

Cell[TextData[{
 "We also use equal signs to set up equations. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the double-equal sign in this context. For example:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     RowBox[{"a", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"b", " ", "x"}], " ", "+", "c"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[14]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "b"}], "+", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
      RowBox[{"2", " ", "a"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"b", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
       RowBox[{"2", " ", "a"}]]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.3901549001598*^9},
 CellLabel->"Out[14]="]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1392, 934},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->"EMMStyle02.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 1149, 31, 430, "Title"],
Cell[CellGroupData[{
Cell[1764, 58, 410, 9, 43, "Input"],
Cell[2177, 69, 778, 16, 51, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2992, 90, 24, 0, 92, "Section"],
Cell[3019, 92, 226, 6, 32, "Text"],
Cell[3248, 100, 212, 10, 33, "Text"],
Cell[3463, 112, 212, 10, 33, "Text"],
Cell[3678, 124, 406, 14, 56, "Text"],
Cell[CellGroupData[{
Cell[4109, 142, 202, 7, 45, "Input"],
Cell[4314, 151, 243, 8, 38, "Output"]
}, Open  ]],
Cell[4572, 162, 949, 31, 83, "Text"],
Cell[CellGroupData[{
Cell[5546, 197, 253, 9, 45, "Input"],
Cell[5802, 208, 201, 7, 38, "Output"]
}, Open  ]],
Cell[6018, 218, 328, 13, 33, "Text"],
Cell[CellGroupData[{
Cell[6371, 235, 277, 10, 45, "Input"],
Cell[6651, 247, 205, 7, 38, "Output"]
}, Open  ]],
Cell[6871, 257, 157, 6, 33, "Text"],
Cell[CellGroupData[{
Cell[7053, 267, 260, 9, 45, "Input"],
Cell[7316, 278, 219, 7, 38, "Output"]
}, Open  ]],
Cell[7550, 288, 268, 9, 33, "Text"],
Cell[7821, 299, 280, 10, 45, "Input"],
Cell[8104, 311, 199, 6, 33, "Text"],
Cell[CellGroupData[{
Cell[8328, 321, 120, 4, 43, "Input"],
Cell[8451, 327, 205, 7, 38, "Output"]
}, Open  ]],
Cell[8671, 337, 49, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[8745, 341, 224, 8, 43, "Input"],
Cell[8972, 351, 353, 13, 38, "Output"]
}, Open  ]],
Cell[9340, 367, 49, 0, 32, "Text"],
Cell[9392, 369, 281, 10, 45, "Input"],
Cell[9676, 381, 49, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[9750, 385, 172, 6, 43, "Input"],
Cell[9925, 393, 262, 9, 38, "Output"]
}, Open  ]],
Cell[10202, 405, 114, 3, 32, "Text"],
Cell[10319, 410, 609, 18, 46, "Input"],
Cell[10931, 430, 28, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[10984, 434, 151, 4, 43, "Input"],
Cell[11138, 440, 303, 11, 38, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11490, 457, 79, 4, 92, "Section"],
Cell[11572, 463, 187, 5, 32, "Text"],
Cell[CellGroupData[{
Cell[11784, 472, 256, 8, 48, "Input"],
Cell[12043, 482, 688, 24, 66, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
