(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     84881,       2268]
NotebookOptionsPosition[     77732,       2052]
NotebookOutlinePosition[     80520,       2122]
CellTagsIndexPosition[     80426,       2116]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "LimitBookDepthII\n",
 StyleBox["Empirical Market Microstructure",
  FontSlant->"Italic"],
 " \n\t(2006, Oxford University Press)\nCompanion ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook\n\nJoel Hasbrouck\n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Copyright", " ", "2007"}], ",", " ", 
    RowBox[{"Joel", " ", 
     RowBox[{"Hasbrouck", ".", " ", "All"}], " ", "rights", " ", 
     RowBox[{"reserved", "."}]}]}], TraditionalForm]],
  FontSize->14,
  FontSlant->"Italic"],
 "\n",
 StyleBox["This notebook covers Seppi (1997) and Sandas (2001), discussed in \
Chapter 13, Section 13.4",
  FontSize->14]
}], "Title",
 CellChangeTimes->{{3.3896255910914*^9, 3.3896255932033997`*^9}, {
   3.3897167078988237`*^9, 3.389716768500824*^9}, 3.3897219191158237`*^9, {
   3.3899919263996*^9, 3.3899919275346003`*^9}, {3.3899924133546*^9, 
   3.3899924443206*^9}, {3.39003008487543*^9, 3.3900301039984303`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Text", "  ", "@", " ", 
  RowBox[{"Style", "[", 
   RowBox[{
    RowBox[{"\"\<Notebook evaluated \>\"", "<>", 
     RowBox[{"DateString", "[", "\"\<DateTime\>\"", "]"}]}], ",", 
    "\"\<Subtitle\>\""}], "]"}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896127180972*^9, 3.3896127205282*^9}, 
   3.389716999411824*^9, {3.3897170351038237`*^9, 3.389717047196824*^9}}],

Cell[BoxData[
 InterpretationBox[Cell[BoxData[
   StyleBox["\<\"Notebook evaluated Monday 4 June 2007 20:35:42\"\>", 
    "Subtitle",
    StripOnInput->False]], "Text", "TR"],
  Text[
   Style["Notebook evaluated Monday 4 June 2007 20:35:42", 
    "Subtitle"]]]], "Output",
 CellMargins->{{18, Inherited}, {Inherited, 0}},
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896127211071997`*^9, {3.3896127536242*^9, 3.3896127555652*^9}, 
   3.3896128616452*^9, 3.389623031447*^9, 3.3896232934164*^9, 
   3.389716955274824*^9, 3.3897170008718243`*^9, {3.3897170377738237`*^9, 
   3.3897170482808237`*^9}, 3.3899920823416*^9, 3.3899921326345997`*^9, 
   3.3899925422046003`*^9},
 Background->RGBColor[0.866667, 0.733333, 1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Initializations", "Section"],

Cell[BoxData[
 RowBox[{"<<", "Notation`"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896320663532*^9, 3.3896320701432*^9}}],

Cell["\<\
The following commands define symbolizations that are convenient for labeling \
things.\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["Anything_", "Rule"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";", 
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["Anything_", "Rules"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";"}]], "Input",
 CellLabelAutoDelete->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Equililibrium in a limit order book, Sandas (2001)", "Section"],

Cell[CellGroupData[{

Cell["Exponential distribution (for incoming orders);", "Subsection",
 CellTags->"c:147"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    SubscriptBox["f", "Buy"], "[", "m_", "]"}], ":=", 
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"ExponentialDistribution", "[", 
      FractionBox["1", "\[Lambda]"], "]"}], ",", "m"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["f", "Buy"], "[", "m", "]"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox["m", "\[Lambda]"]}]], "\[Lambda]"]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896324254332*^9, 3.3896324644614*^9}]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Lambda]", "=", "5"}], TraditionalForm]]],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"s1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{
        SubscriptBox["f", "Buy"], "[", "m", "]"}], "/.", "\[InvisibleSpace]", 
       
       RowBox[{"\[Lambda]", "\[Rule]", "5"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"m", ",", "10", ",", "20"}], "}"}], ",", 
     RowBox[{"DisplayFunction", "\[Rule]", "Identity"}], ",", 
     RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"s2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{
        SubscriptBox["f", "Buy"], "[", "m", "]"}], "/.", "\[InvisibleSpace]", 
       
       RowBox[{"\[Lambda]", "\[Rule]", "5"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"m", ",", "0", ",", "20"}], "}"}], ",", 
     RowBox[{"DisplayFunction", "\[Rule]", "Identity"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"Show", "[", 
  RowBox[{"s1", ",", "s2", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "20"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0.2"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"DisplayFunction", "\[Rule]", "$DisplayFunction"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\< m(Order size)\>\"", ",", "\"\<Probability\>\""}], "}"}]}], 
   ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", "20", ",", "5"}], "]"}], ",", "Automatic"}], "}"}]}],
    ",", 
   RowBox[{"BaseStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], "}"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]}], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896322412771997`*^9, {3.3896324900284*^9, 3.3896325454834003`*^9}, {
   3.3896326090074*^9, 3.3896326165884*^9}}],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJw1lHs0FFgcx2coND3E0hnFWtt4hGEeW6oTv582zxSpTdqsaIRkYjzGoyKm
zEoeYxiZyk4bs5Vn2lqkaPVaJCMWdTwKdahGm5VtVXv3D3/cc8/n3O/3c+7v
3HOuWfAh3xANCoWyjaz/942L+rQoFAbCrQP+wutysEm5W5HCY6BnlyrSp6wY
jm55uj+mk4Gj1T4xizNPw/svzj6wczBH6d6J1h0ni8DvHGfrRLE5ugaEWzvJ
ZWAmmhxZoW2BtJVtTdaKQtAL9jc3OGiB4S0fOkybCyBCPi5M7bPAML8nv9F7
pVBR5PPq9SZLrJptED6czQfD7CDayouW+Hg8vTV4bT68GChe32ZohRYefk4v
IyQwaJli4JhshRyL/uU1V/Pg5jdrl1YNWGHsqqSXH7XzQPus0ZcFnqvQ3aGm
beGOXIj/WNq9sWoV/tFh8nd1SA741O0u4RlbY6Mg8CAsywa9dSOZGRnWqBae
YeX0Z8FMNf0rwYQ1TjkeMu68dRI8RHH3HvnZoIMzdyLwdCY0eR+hv79hg52D
m9wleT+CIr4iOc/aFieKYoadUsRwIOgKhVloiz+fj1yz/EgG+G8Kts/9YItm
tz1iBwpOwJW09VGhoUzsdck35ZYeB3Zd426tdiZSgl3mZbWLQFZrGFrGssPU
/QnObhoiCF1QeLz+jB1+Wzh644RdOgT4NW8ppNrjv288u1VRadBIMbQa49uj
NpXSc/jyMZjPd2Q49Nuj2q2y797bVKgP1xm1NGVhedVPTMHmVLDw1HLmf8fC
jyaa1RkbUqC0rC+aLiYcCz1sraNAD5Fxf69jIa1Jpndp+DDgtvBPSjUL3Zew
jVTVyZBct/TcpBkbo4z1uxpLkiDCu801ZhcbIy8rdKXpicAPCmjxP8nGGeVs
96QoAXjdvSpsZOPQkHqtWioEXWHYeNA7Nr6IH3w6XRwP7dL2njFzDl7XSaFr
NsQBDrm2le7hoMveij/pqlhQnrrkGyLhYFhld/74dAyYXX9eIW7hoLgxSkPG
iQGfJWz9sQ8cfBM/fXPdfgFIhrdvVjK5WDDa93lFVTTcXxZkGB7IRa+KNt9j
GtFQm5j2klfAxQadziPlW6OgZldibss9Ltorc5zMvz8EvBCR8w+fSH+kJ029
kA+Difmznz9zMeNB8+OvNfhw7Y53P3AY2O6vbs5iyuG8eqGpPTl3PxF3R0eb
D7Nh0klTIwaGCriRNgI5pFu7V98lvkcHsmmHF/Ch6WrHKRnJ69PEtQXz+FBS
f+3fnEUM1I9/V9IglcOU21iChOQdBF5Nv9L4wFZF7txH8q/PGq3pmM8HHxn7
TithukuT4x5NPkQ9d6O6azHQqvWgjkGZHMp3rg5IIP1yw5kSX3L/8aEb6z1I
ngV2sxFafNApS71YQ1h3mvZ+hvSLxM+GRgknjSkzbpH5+oRL5zE0Gegljtze
UikHnYE93hHEp1xG1VMQn2vYiO0Gkp/JithbT3w85i/yC4QvcJ7vcCPzTOnS
unoJZ7ZtebaY+DdQG978RViV+5AZTfxLbsfOl1AZeOHJp6MmtXK4poi6zyP+
wX0qj/vEP2UzU7qa5BdN9UiGiV//bYPBOcKDNGMRn/jPd5l4qQgHxr/WXU38
4y0PQ18Rrr+o2F1E/NmOyrh/CIvkdlRPwgqjQO0FAg4mG1S6DSfFwtx/N8dz
7zvH/wFipEWR
    "], {{
      {Hue[0.67, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
       GraphicsGroupBox[
        PolygonBox[{{51, 81, 79, 43, 44, 45, 46, 47, 48, 49, 50, 73, 67, 62, 
         58, 55, 53, 74, 68, 63, 59, 56, 75, 69, 64, 60, 76, 70, 65, 77, 71, 
         78}},
         VertexColors->None]]}, 
      {Hue[0.67, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
       GraphicsGroupBox[
        PolygonBox[{{1, 80, 79, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 
         31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 
         14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 52, 54, 57, 61, 66, 72}},
         
         VertexColors->None]]}, {}, {}}, {{}, {}, 
      {Hue[0.67, 0.6, 0.6], 
       LineBox[{1, 72, 66, 61, 57, 54, 52, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12,
         13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 
        30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 79, 43, 44, 45, 
        46, 47, 48, 49, 50, 73, 67, 62, 58, 55, 53, 74, 68, 63, 59, 56, 75, 
        69, 64, 60, 76, 70, 65, 77, 71, 78, 51}]}}}], {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV038803kcB/D5sXGoDem6nDZu0ZZfs3pUd+n9Qb+Q1clyppJxuqRvFG5+
lBKPmU6GXQ2tpUtLF+VOd80x8iObFkU1Tl1dmTrlkZLrlOw+/fF6vB7Pf17/
vVyFe8O/NSeRSDycj604KKRw4itXaWck6eXlOujoZ2yIZGTAeAv/iLREB6br
miMMhgRWnGtyKpToQNFaRCczysGynKPNy9BBkn/anrf0GhBMK8LkUTrof/+d
bJyuBtnBHPay+TqwGnrsMUbXgSZ4pZqn0EJVtzLlOX0QGkyrtzZe6IK6S5Kh
JO9RePds5YigqRN2wu3yF/smgLvpVe6Xjh1AGFlPGuqm4PzQUfKHkjawcc3z
eLichMRckq6Wdg2O0W6wq3ZYoBimdY6isAWEQxEtFnoKaks+ZUWZbIKUzjzh
Xg8b5FfKIQWeboT6ZLvN84JnIbuXb/ZPn7oKVVm7R30jaWhLetmgSfEb5Cqn
v37zwh4tb3f6YXC4AUj9j1BTpiM65is+Tub/Cu6pCaIIthOSGVJzxzvqYXjy
xBbb5rmINX3rw2DSZQgxJh4oTZmHCmqhbBe7DnjD0sULFsxH69wnTALNzzDa
LjykrXVGby9Q9dY1NeBtf88lKMYFybL2JHWUqcAGJmPvTyxAllFUBktXDevG
BG/d+Awk4GgCM00/wUBbvJnA0xUZMg9XXBKegSsFHdsZk65IVSvqU5lOQwI5
7VFPjxtas940YFihhLh9WVfsKr5AY4kOl5sNJ8Fn5+KeDbFMdPcOhzZQVwG9
Dp62aSsWomejFZtb8+XwR11upaeFO6IFFU84XjgOWWbsTfoH7siHHOzi3isD
m/uZ64kGD2RGJ8+o3crAeM5VpsxehKjhlEr/X0pAtugzSzWfhVrVVGQMkIK0
IqErlsFG2eq7ogCbYyCQbeuxe8pGUBmVQdEfhf9WV08pNYuRWJa5NqJIAk+M
gaI2sSc676D3pyrFcMaf43wz1gtRZmZ7R9bnQ21+mv1OL2/Eyo+42mWdB2J+
XKjFpDeqDp3Ksy/IhaX3q2rEN31QeYHOO8LqMMhZlbU3Q33RxcYlqhFRDuS0
FslD1b7IEFPlsG04G8Kc+dXdTA5yye01lkozIYDoiraXcFB0CQstlIpA+bmQ
qZ/kINpDSepsaTow21XHedF+6EFfSHudIRWkXm3sPo0f6s698ax0/X5ImLC8
rWNzUcxwtkOAOgWE9a8ZkmIueho57tUfmwzabusjTdNclLqsTdTiREBS0N9S
HfastbyxZGxak/rUPewD8SqhG/Y3tYmN49iHtK0b8+cQ8LRY/4r5gYvyXhdz
Qx0JoPClO4qwqe8UrgYaAUEPP121fYaLmpcmnnhpS8BI5Hjobmy6n2xhFXbh
LW2UCHvv+8KGcOy+axlppdhFL/66c8WGAOHZoYvXsTfOZtCzPyHg0C6ls4+J
iwKzyX9aWxHAfPw9ayU2hL1PbaQQoBVsWhaMrdU105KwaRvMNsdhezSfD+kl
E6D0jis8gS0Pn6v90ZKAQNVX8rPY4jUpu9Zhj9DnnKvHDumX205ZEPgPnddu
YJv/Hha+FbtPougd+LhvPfTvLOx08/QHRmzq2JKTLeYEzM/iPX+N3RkbHZiC
rZlwnzJhd8fz/nHD/h/MZjlI
      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\" m(Order size)\"", TraditionalForm], 
    FormBox["\"Probability\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction->Identity,
  Method->{"AxesInFront" -> True},
  PlotRange->{{0, 20}, {0, 0.2}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{{{0, 
      FormBox["0", TraditionalForm]}, {5, 
      FormBox["5", TraditionalForm]}, {10, 
      FormBox["10", TraditionalForm]}, {15, 
      FormBox["15", TraditionalForm]}, {20, 
      FormBox["20", TraditionalForm]}}, Automatic}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896326171354*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "If we could condition on the size of the order, we'd impose a zero-expected \
profit condition for all ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]]],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"p", "-", 
     SubscriptBox["X", "t"], "-", "\[Gamma]", "-", 
     RowBox[{"\[Alpha]", " ", "m"}]}], "\[Equal]", "0"}], ",", "m"}], 
  "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"m", "\[Rule]", 
    FractionBox[
     RowBox[{"p", "-", "\[Gamma]", "-", 
      SubscriptBox["X", "t"]}], "\[Alpha]"]}], "}"}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896324255832*^9, 3.3896324646314*^9, 3.3896326618344*^9}
  ]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "A sell limit order placed at ",
 Cell[BoxData[
  SubscriptBox["p", "1"]]]
}], "Subsection"],

Cell["My expected profit conditional on execution is ", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["E\[Pi]", "1"], "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", "q", "\[Infinity]"], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["p", "1"], "-", 
        SubscriptBox["X", "t"], "-", "\[Gamma]", "-", 
        RowBox[{"\[Alpha]", " ", "m"}]}], ")"}], " ", 
      RowBox[{
       SubscriptBox["f", "Buy"], "[", "m", "]"}], 
      RowBox[{"\[DifferentialD]", "m"}]}]}], ",", 
    RowBox[{
     RowBox[{"Re", "[", "\[Lambda]", "]"}], ">", "0"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox["q", "\[Lambda]"]}]]}], " ", 
  RowBox[{"(", 
   RowBox[{"\[Gamma]", "+", 
    RowBox[{"\[Alpha]", " ", 
     RowBox[{"(", 
      RowBox[{"q", "+", "\[Lambda]"}], ")"}]}], "-", 
    SubscriptBox["p", "1"], "+", 
    SubscriptBox["X", "t"]}], ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896324284082003`*^9, 3.3896324674764*^9, 
  3.3896326672964*^9}]
}, Open  ]],

Cell[TextData[{
 "I will be indifferent to adding my order to the queue at this price when ",
 Cell[BoxData[
  FormBox[
   RowBox[{"q", "=", 
    SubscriptBox["Q", "1"]}], TraditionalForm]]],
 " where"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["E\[Pi]", "1"], "\[Equal]", "0"}], ",", "q"}], "]"}], "/.", 
  "\[InvisibleSpace]", 
  RowBox[{"q", "\[Rule]", 
   SubscriptBox["Q", "1"]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["Q", "1"], "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "\[Gamma]"}], "-", 
      RowBox[{"\[Alpha]", " ", "\[Lambda]"}], "+", 
      SubscriptBox["p", "1"], "-", 
      SubscriptBox["X", "t"]}], "\[Alpha]"]}], "}"}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896324284862003`*^9, 3.3896324675704*^9, 
  3.3896326708073997`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "A sell limit order placed at ",
 Cell[BoxData[
  SubscriptBox["p", "2"]]]
}], "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["E\[Pi]", "2"], "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{
       SubscriptBox["Q", "1"], "+", "q"}], "\[Infinity]"], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["p", "2"], "-", 
        SubscriptBox["X", "t"], "-", "\[Gamma]", "-", 
        RowBox[{"\[Alpha]", " ", "m"}]}], ")"}], " ", 
      RowBox[{
       SubscriptBox["f", "Buy"], "[", "m", "]"}], 
      RowBox[{"\[DifferentialD]", "m"}]}]}], ",", 
    RowBox[{
     RowBox[{"Re", "[", "\[Lambda]", "]"}], ">", "0"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"q", "+", 
       SubscriptBox["Q", "1"]}], "\[Lambda]"]}]]}], " ", 
  RowBox[{"(", 
   RowBox[{"\[Gamma]", "+", 
    RowBox[{"\[Alpha]", " ", 
     RowBox[{"(", 
      RowBox[{"q", "+", "\[Lambda]"}], ")"}]}], "-", 
    SubscriptBox["p", "2"], "+", 
    RowBox[{"\[Alpha]", " ", 
     SubscriptBox["Q", "1"]}], "+", 
    SubscriptBox["X", "t"]}], ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896324304072*^9, 3.3896324693264*^9, 3.3896326756524*^9}
  ]
}, Open  ]],

Cell["Which implies:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["E\[Pi]", "2"], "\[Equal]", "0"}], ",", "q"}], "]"}], "/.", 
  "\[InvisibleSpace]", 
  RowBox[{"q", "\[Rule]", 
   SubscriptBox["Q", "2"]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["Q", "2"], "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "\[Gamma]"}], "-", 
      RowBox[{"\[Alpha]", " ", "\[Lambda]"}], "+", 
      SubscriptBox["p", "2"], "-", 
      RowBox[{"\[Alpha]", " ", 
       SubscriptBox["Q", "1"]}], "-", 
      SubscriptBox["X", "t"]}], "\[Alpha]"]}], "}"}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896324304561996`*^9, 3.3896324693794003`*^9, 
  3.3896326842363997`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "A sell limit order placed at ",
 Cell[BoxData[
  SubscriptBox["p", "3"]]]
}], "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["E\[Pi]", "3"], "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{
       SubscriptBox["Q", "1"], "+", 
       SubscriptBox["Q", "2"], "+", "q"}], "\[Infinity]"], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["p", "3"], "-", 
        SubscriptBox["X", "t"], "-", "\[Gamma]", "-", 
        RowBox[{"\[Alpha]", " ", "m"}]}], ")"}], " ", 
      RowBox[{
       SubscriptBox["f", "Buy"], "[", "m", "]"}], 
      RowBox[{"\[DifferentialD]", "m"}]}]}], ",", 
    RowBox[{
     RowBox[{"Re", "[", "\[Lambda]", "]"}], ">", "0"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"q", "+", 
       SubscriptBox["Q", "1"], "+", 
       SubscriptBox["Q", "2"]}], "\[Lambda]"]}]]}], " ", 
  RowBox[{"(", 
   RowBox[{"\[Gamma]", "+", 
    RowBox[{"\[Alpha]", " ", 
     RowBox[{"(", 
      RowBox[{"q", "+", "\[Lambda]"}], ")"}]}], "-", 
    SubscriptBox["p", "3"], "+", 
    RowBox[{"\[Alpha]", " ", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["Q", "1"], "+", 
       SubscriptBox["Q", "2"]}], ")"}]}], "+", 
    SubscriptBox["X", "t"]}], ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896324327832003`*^9, 3.3896324714904003`*^9, 
  3.3896326894754*^9}]
}, Open  ]],

Cell["and:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["E\[Pi]", "3"], "\[Equal]", "0"}], ",", "q"}], "]"}], "/.", 
  "\[InvisibleSpace]", 
  RowBox[{"q", "\[Rule]", 
   SubscriptBox["Q", "3"]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["Q", "3"], "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "\[Gamma]"}], "-", 
      RowBox[{"\[Alpha]", " ", "\[Lambda]"}], "+", 
      SubscriptBox["p", "3"], "-", 
      RowBox[{"\[Alpha]", " ", 
       SubscriptBox["Q", "1"]}], "-", 
      RowBox[{"\[Alpha]", " ", 
       SubscriptBox["Q", "2"]}], "-", 
      SubscriptBox["X", "t"]}], "\[Alpha]"]}], "}"}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896324328322*^9, 3.3896324715434*^9, 
  3.3896326895243998`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General solution", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["Q", "Rule"], "=", 
   RowBox[{
    SubscriptBox["Q", "k_"], "\[RuleDelayed]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"k", "<", 
       RowBox[{
        RowBox[{"Floor", "[", 
         SubscriptBox["X", "t"], "]"}], "+", "1"}]}], ",", "0", ",", 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"-", 
          SubscriptBox["X", "t"]}], "-", "\[Gamma]", "+", 
         SubscriptBox["p", "k"]}], "\[Alpha]"], "-", "\[Lambda]", "-", 
       RowBox[{
        UnderoverscriptBox["\[Sum]", 
         RowBox[{"j", "=", 
          RowBox[{
           RowBox[{"Floor", "[", 
            SubscriptBox["X", "t"], "]"}], "+", "1"}]}], 
         RowBox[{"k", "-", "1"}]], 
        SubscriptBox["Q", "j"]}]}]}], "]"}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "The floor of ",
 Cell[BoxData[
  FormBox["X", TraditionalForm]]],
 " is the largest integer less than or equal to ",
 Cell[BoxData[
  FormBox["X", TraditionalForm]]],
 "."
}], "Text"],

Cell[TextData[{
 "Normalize the price grid so that the tick size is unity: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["p", "k"], "=", "k"}], TraditionalForm]]],
 "."
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["p", "k_"], "\[RuleDelayed]", "k"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell["As an example, consider the numerical values:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"InitialValues", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["X", "t"], "\[Rule]", "0"}], ",", 
     RowBox[{"\[Alpha]", "\[Rule]", ".1"}], ",", 
     RowBox[{"\[Gamma]", "\[Rule]", "0"}], ",", 
     RowBox[{"\[Lambda]", "\[Rule]", "5"}]}], "}"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QTable", "[", "ModelParms_", "]"}], ":=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SubscriptBox["Q", "k"], "//.", "\[InvisibleSpace]", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["Q", "Rule"], "/.", "\[InvisibleSpace]", 
            "ModelParms"}], ")"}]}], "/.", "\[InvisibleSpace]", 
         SubscriptBox["p", "Rule"]}], ",", "k"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", 
        RowBox[{
         RowBox[{"Floor", "[", 
          RowBox[{
           SubscriptBox["X", "t"], "/.", "\[InvisibleSpace]", "ModelParms"}], 
          "]"}], "+", "1"}], ",", "5"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "[", 
   RowBox[{"x_", ",", "QTable_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "k", "}"}], ",", 
    RowBox[{
     RowBox[{"k", "=", 
      RowBox[{"Flatten", "[", 
       RowBox[{"Position", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"x", "<", "#1"}], "&"}], ")"}], "/@", 
          RowBox[{"Drop", "[", 
           RowBox[{
            RowBox[{"FoldList", "[", 
             RowBox[{"Plus", ",", "0", ",", 
              RowBox[{
              "QTable", "\[LeftDoubleBracket]", "1", 
               "\[RightDoubleBracket]"}]}], "]"}], ",", "1"}], "]"}]}], ",", 
         "True"}], "]"}], "]"}]}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", "k", "]"}], ">", "0"}], ",", 
       RowBox[{
        RowBox[{"k", "=", 
         RowBox[{"First", "[", "k", "]"}]}], ";", 
        RowBox[{"QTable", "\[LeftDoubleBracket]", 
         RowBox[{"2", ",", "k"}], "\[RightDoubleBracket]"}]}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell["Here are the book schedule and value revision function:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"QTableInitial", "=", 
  RowBox[{"QTable", "[", "InitialValues", "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5.`", ",", "10.`", ",", "10.`", ",", "10.`", ",", "10.`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}]}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896324328862*^9, 3.3896324716244*^9, 3.3896326949774*^9}
  ]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"p", "[", 
      RowBox[{"x", ",", "QTableInitial"}], "]"}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["X", "t"], "+", 
       RowBox[{"\[Alpha]", " ", "x"}]}], "/.", "\[InvisibleSpace]", 
      "InitialValues"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "40"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "5"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Thickness", "[", "0.005`", "]"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Dashing", "[", 
        RowBox[{"{", "0.01`", "}"}], "]"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"BaseStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[0.005], LineBox[CompressedData["
1:eJxFyglM0wcYBfC/Kw65slY65Ci0HCvQFhSnG4rQIoSBKCqjkgFjtCgo24qg
GA6FrUKRRAGRCcq0qYqirt0YR8IKlACKYmnVZTjTMlQoG0cFxKIYFHWB73vJ
y8svea7C9Og9HxAEse9d3++5fOGHfruvBxH/Z4prrnviaaQ/5C5Z1ivNGKeP
ghW/lui+830FTuXeOzORSeItWWTwHmpUWIAtXQs9B/3JYHW1p3eHmgIuJd9h
yZJswQFy25jYKvR/EQlHbDRoaobCXKlDc6uJir2j6DRVNM3uBfr0yKXLXWbU
RRO8iXURShcGOuSoUZsTgD7fmu82Uod+afooK9ruY7B871pH9jRaqItRkdR2
4LS7E+UtOfbgjBuFwnRPR3D9fusv7SOcwbK8b8fWxDLAYun8zucTrmDiz0e8
1lx3MPNgSnYM6xPwsKlql1UbE7zFkHakIsMLHDVcznZxYYHHuoQ/3JKzwcfT
aNoiCQfsS+l3DvnGB/+zX4X1n0TX6gdE+7rRYi2d1DCATuoUVM3Pou25mfNR
r9FapVggI/kuegVP4n/q5owFOqjpIjuMjJYruk1jNDStzqAq80afOmAkN5ei
LbkmgX4GrT7O96JoV4O/MMa9cOOvAf/duXtZHMcP3HSsO5FhQqcsz3qk0awF
J2fmNVmf/RS8OpWt2SpYB9au5FhlbVgPVirENRzSZ+C8Zawd6gG0pT43XNT4
OTg7OOqpxN4fbLjsWik9jN5RTJ8y/I5uTXXeyhlF97qfW2WaRD8YpA21zaL/
adOHu71CD9f8rJC8Ro/nJFDHiQ2LJvOexdJyt5uhbe46UR5T0F7hTnWZdHSi
v2P/TxvRlV4OZi18dMVj1R4bJbr8bEqPgLERHFf5tcb6X/TL0No5aXsAeMiw
ObuzeBP4QqCfU58gECwvyqKk+gSBi/nJkSQTer1edrW4jwuu9q6R90XywAUd
J6ojW9Aj30+7WE2itznxa3s9gsGWv01H6wPRPaGlxNNdaGZZwoNDyejChyzF
Qjq64c1Jh9BD6Cfuc4XHDqN9jfelDvno3OZf/rhWgL5ZIPkr4MclU3krI5Km
1GL0NZ0tc7IIHSzqiaeUoPffoHaIVGgpTeihNqE9uq6cjorfDC736WTdb0en
zJjdu80KAQvrnzFKytC3elccbZ1HhwyuCkp8g26fYc4tLKDfAsYTnHw=
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Dashing[{0.01}], 
    LineBox[CompressedData["
1:eJwVx384E3gcwPFt5kcsM3flxrFhkfmVfoni+2E9Tz+GFE5JymgiCQ8l6kIk
aeXp2VMiDSmp2Dlz9ziSH0vSkHSlx6TW/AjVwhLJ7nt/vJ/387LkHd11kEQg
EPxw/7/4d56OS+Q9T+7Bsd7mD8me0j6mTzAzF5E5pvFD9ECkaW86w2ReQ2tE
Bddr6ZGouFnA0GZWIm7Xqz+L6Uko1iP5yCyjHgVHzj64TM9Cfd8PCVWMJ0ju
nMMR0IVId0Bh+5HxGpUs23H2PL0clXaKEiYYH1CGXq1tLl2CqsW5A7FO82j3
nlKx6osURaHea5OJWkDRZIRusehBccN27yXVS2DFzk9jbXkvkL5llu3QBiM4
3u2GCmZeo4tGT9mlB34CEwntDZE4hHgDgQ+1ZMuhTsGR9WxSoIRHWbyjtqbQ
ElNstmdSiWriKQG/bDOHGRsPatWRUVSadnh8VTATSHP3jMxWjKNM0cLOmUlL
cNUc+CugehIR+t5CY6o1dGWt7W5nf0Y2SfyUQPYKYORPzFV+UiGl+upvBg9s
YHx26M2/q6bQ9uGYU5cTVkLZeEOn4cVp5KfMt7ewYAPFvOKzUjmDxtt46R1V
9nAuuo5fwvqKnGgvzTn7HWEK7ikPnZ5F+kgdLp92gqOrpZLlbd/Qlo8hs1ZB
q6C/WprXazmP+lsjiSEOLjAT86LILvU7qjsnDWOqXcDKS3eR37CA+NrJb7u7
V4NHmWVUjckiikhMq6MUroFY8/1W70I1yDnKvtsnfC3YTAYZvPIlQI+xg0Gy
2zqgUFV60nkCNFRnFjlorYeFpiKx9XUipBHZ/rLB9RCxtuH1Ei4J9OWpW+Mk
rlC2jVfS9JUEw7cthaKTG2BiwtRo5IoWCFfSyfVBbnA3YIuWcDMZ8gv5j8OZ
7pC0NVskGSFDiHBfN2XUHZYNbu+/ma0N3zbfmhM1bQRH1ywhfbUOvB/2TmnN
2QT+Fj1zxD4dKPNwMesK94CxToEiPkMXqrKTaVGOnpBHDkvaxdKDnKAIrpba
E3Te1JWRpHqwTl5amdOF4NvJjEC3hCVQYFdU1cUFmLkTJlYY68PpZkEBtx7g
YKFYYNyqD75mQbc6WV4gtj+nR4szAK+4x3tpuV5A2p7okGlIAdGvPJZM7QUy
x2d9JxopwGqruOK31xtKbiCWMmwp5Du2sp83eYOveD3NfHEp8KfJvU/YHIjP
Ls2Q3zUEXs0UM/cSB4rHzIsMfajQ0al3pnGBA0Az3PB4ngqxnHf5T7BTtUlm
cmyjxvobL7Elc+ofKuzdVTH/qLBtFYNtpt+pMHpJ9oX1gwOU2qodcdg6QfkH
BNivAn2jli1QgTNk4hm2yIHYggtXIn5QYSRYxT2MXX4h/UQK9vlnHXtSsAfT
k0IF2M9bTiRfxvaPDrX6G5tXPnC/HdvV3aFaf5EK6dEiM2cNBwjyp49qsFmK
43absN2fPbzTjt0R4u+6DTtJWps3gG3kQwyIwB69X7RTW0MFkVPE+avYslOH
B3dje1dsLCjHJifubz6CPcL4+XYNtgc/4GYmthPtUctT7D/8Nkbfx36eW9zT
jz3u7ezTgn2MdGxwGJvlau38Ets0zW9iCnufvYnxBHbTtM2cBvsqw0Ctwf4P
5z0+XQ==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Times"},
  PlotRange->{{0., 39.99999918367347}, {0, 5}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896324329332*^9, 3.3896329183993998`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"QTableInitial", "=", 
   RowBox[{"QTable", "[", "InitialValues", "]"}]}], ";", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"p", "[", 
       RowBox[{"x", ",", "QTableInitial"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        SubscriptBox["X", "t"], "+", 
        RowBox[{"\[Alpha]", " ", "x"}]}], "/.", "\[InvisibleSpace]", 
       "InitialValues"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "14"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "2.5`"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Thickness", "[", "0.005`", "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Dashing", "[", 
         RowBox[{"{", "0.01", "}"}], "]"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Size of incoming buy order,b\>\"", ",", "\"\< Price and EX\>\"", 
       ",", "None", ",", "None"}], "}"}]}], ",", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Range", "[", 
        RowBox[{"0", ",", "14", ",", "2"}], "]"}], ",", 
       RowBox[{"Range", "[", 
        RowBox[{"0", ",", "2.5`", ",", "0.5`"}], "]"}], ",", "None", ",", 
       "None"}], "}"}]}], ",", 
    RowBox[{"Background", "\[Rule]", 
     RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", 
    RowBox[{"BaseStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896327667284*^9, 3.3896328332604*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[0.005], LineBox[CompressedData["
1:eJxF0GlIkwEcBvB3K1seYfPIZc5jznMxoljlss3mFDN7551vZIdUtOayGU5U
OpxUBtMIbeaXhrHwqkglB24hRpQfXMw8ysBpJRYm1UteaboO8v9/4OHh9/UJ
yStIP8UkCEL2p3+3IafVXLm1RkL8y3fp9ParIsrQI121ptHKzDH0g4XCh/Xt
GR/Agm76/CXxFzDjul11YJEGN9em73LpnAMbLiruvQ9eAnf3ae+rppxg1dOo
BRvJjFs1R5elnr+8FvyxxPCoeHwdOHWsVnqD4wreMaOeUSe4g0WxR4qaGzaA
R2hWonbIE0yqT9IpAWzw2Zj2tKQkL/B4aW9W9CD6kNVBeRz3Bmsr8kWfW9GG
5MWNz+fR6yM6XpX/QpeuyddLGT7/TcRNj/GTl13QR62jLIsbWlakqNjpgw4X
9qy0cdFfjabZpm3oJ+zKaWM8Wj5LvqtSogff+vaW3USXPQse8OP6gnkPBI6O
FrSTk3K4bnQTuG6UOjPhxgETVGLgYuhm8IJ6r9iS6Q/uifFekWu2gBNyhzN2
VwaAKX+T55tOLlhSnXpB0h8IHrFV3G1iBIM1RHbfZB26sNqPdOWHgMVKh45h
RauMte6O/TxwSfm+3G+DaMXjHyeGVaHgKvHtroYFdA079oXsFh/MlL8O6w0K
A5O8Y6SuFZ13kI7yig8HOwYKqWt2NK/x5x67MgIcH178iSQiwTZiYrJNjw6K
zK6f4kfhHy1mI6sDrRnxLKAk0WB7ppq+MoS+I+h6qc8TgCMUHmnnltCnXSyh
5mW0yaKcczrRvwHQkgj9
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Dashing[{0.01}], 
    LineBox[CompressedData["
1:eJwV0X8003scx/EvV3W7lGK0S4r9oJnrnnKFVXt/alFqLVEyKVLcWLv5UU2o
K6UU1SFN3ZxcpbNwhYoV+kEJXe6dUHbGKEsribGWGLuf+8frPM/j75dD+AH/
CGOCIHh4/7cgqESa7nKRnRfsnSkp3cUunLBOvSGOBdYzmsyTthI2ZcxgHBUf
h7KSzoOTVC5cb0/WR4mzIHqxa2M3NQRaRJ6RYeICWMcPjmml7oc3vtZXd4gr
wP3wyLMGajJ8WpbmzhfXQenJFcN11EyIldQaB4nbQG262+QJNQ9cXUuv3Al4
Cyrf9SFS/1JgPtbEHGMNArXFySmiqRKMTssEGyc04G56r7fkaS0U5fh7zKjS
QQ3nUKgHsx7ERzdff2M/CQl7zSrf322Axy2Hbwo+GqDlxrhdYHozCB4yxlt5
xsji5yLH/g2tQE7dJvz6uwlK/Kf4bGikDPqPiG+L+maiqpySDJdNL8GvNwfO
kGcjxC02/GnZAW5aoVbobYqeMjKe0to6wX1lyKGigjkoS2yddfrea5BrZvkc
7jRHt7X5bVkiOfCEezXchfPRgrfttklhCoj2urNl/XoLJPryoTIe9cD2WiXf
LMwS0Sem6i2JXujosmpKukBC89Yp9zfH9QHlL6bybrEVqjxTWxGy7Q0YyNzg
3B5rZLCMSerd8BZye/j7VD+QkU8FaejDin4g+D6LJqg/ol/WeZKbFqpgXLiK
VbPVBjXSljZdmvcO6rwsp9fG2iKjyVtLPbTvwHvnqwDP9IXIUzWfE9Y+AHyb
QvPXVXaIZOUnT2h4D+zzfvHstkXoMnsOI0KiBnnriWu3jOxRfVn+FMr7ALFE
YMtArj1Su1ETCzM/Qtz5BbzZNAckLaeXK/YPAitKmWpU64CcD01FG4d9AkF+
jqnSl4K8l23t1a8ZgiPHV+8c7qCgEOO8yWMOn2Fz+djuVwIqIts8yBuxGIZz
rEvVBeNUlOy87au7dhguzl/5fE0WDXFW7xG4HxwB47Uv6U2L6ehqlELqNTAC
PEooL7WEjuJsuV1GgRoI36RhWHAckW2sU83qfzWgbI/jn5I5IjKnPlGARoEi
+bZCFuWE1Pcb9WY1o8BxFL3nEUvQ8vsN/nFuY9BKqAYqMpegLrcTaXU3xmDx
ksArH2kMxA0oSUy304K8WJo/6y4DkYazuV4XtBArNz/AZzujHaT40dJpLci2
CjUpnc7oYM/D4D9EX+Ays7oxM5yJ+ihN+THqL+C02WzLb5NMZG+2SvIoXAdd
zwpyU7D7vrP1acU+y/JQZmNfnxxXKbA/08MFUmz64D3KN+wqvTSN0DORywuX
a257dOBTvKc6Gxt/eukWduSMGqp0ion8TfSp2Xt1QE7yi27GJunlDgXYL0be
lSuwO8ekT8qwXbvnsYlpJgrqj59uwdbdiQzyxQ6tHzwyK0IHaWEW5xTYghRF
TDL28leS9iFsl4QH5hnY6o2rbAgDEw0dyL19BZvrsU9Cw44JDfhUhU2a+6hO
iC1i//2rBvv5iYDvU7A9lxfNJCJ1kPBNzcvGnvjp9M252N0qy+4q7KN2nH4m
9vngIkozNlg5pLKwkYwdpcAm5hjsfbFHvTvKhrDrTXoeb8curInSGbBP6qt3
RWL/B5yNVVQ=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  Background->GrayLevel[1],
  BaseStyle->{FontFamily -> "Times"},
  Frame->True,
  FrameLabel->{
    FormBox["\"Size of incoming buy order,b\"", TraditionalForm], 
    FormBox["\" Price and EX\"", TraditionalForm], None, None},
  FrameTicks->{{{0, 
      FormBox["0", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {4, 
      FormBox["4", TraditionalForm]}, {6, 
      FormBox["6", TraditionalForm]}, {8, 
      FormBox["8", TraditionalForm]}, {10, 
      FormBox["10", TraditionalForm]}, {12, 
      FormBox["12", TraditionalForm]}, {14, 
      FormBox["14", TraditionalForm]}}, {{0., 
      FormBox["0.`", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {1., 
      FormBox["1.`", TraditionalForm]}, {1.5, 
      FormBox["1.5`", TraditionalForm]}, {2., 
      FormBox["2.`", TraditionalForm]}, {2.5, 
      FormBox["2.5`", TraditionalForm]}}, None, None},
  PlotRange->{{0., 13.999999714285714`}, {0, 2.5}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896328360684*^9}]
}, Open  ]],

Cell["\<\
Notice that the limit order book price schedule lies entirely above the \
expectation revision function. This means that if my order is the last one to \
execute, I realize a profit.
Suppose that the initial valuation was slightly above zero:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OtherValues", "=", 
  RowBox[{"Join", "[", 
   RowBox[{
    RowBox[{"Drop", "[", 
     RowBox[{"InitialValues", ",", "1"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["X", "t"], "\[Rule]", ".1"}], "}"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Alpha]", "\[Rule]", "0.1`"}], ",", 
   RowBox[{"\[Gamma]", "\[Rule]", "0"}], ",", 
   RowBox[{"\[Lambda]", "\[Rule]", "5"}], ",", 
   RowBox[{
    SubscriptBox["X", "t"], "\[Rule]", "0.1`"}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896324329842*^9, 3.3896324717614*^9, 3.3896326950984*^9,
   3.3896329417454*^9}]
}, Open  ]],

Cell["Then:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"QTableOther", "=", 
   RowBox[{"QTable", "[", "OtherValues", "]"}]}], ";", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"p", "[", 
       RowBox[{"x", ",", "QTableOther"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        SubscriptBox["X", "t"], "+", 
        RowBox[{"x", " ", "\[Alpha]"}]}], "/.", "\[InvisibleSpace]", 
       "OtherValues"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "30"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "5"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Thickness", "[", "0.005", "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Dashing", "[", 
         RowBox[{"{", "0.01`", "}"}], "]"}], "}"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896328559124002`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[0.005], LineBox[CompressedData["
1:eJxFxwswEwAcx/Ed3dl0W/OKEC0zmrcyZpa5PJqly6ta5W3V6UG4U7or3Ipq
OUnI1cKtS61rKldJZw4n6prI5dQlDNfVYWsey5Iep///d/e9331oqZkxIiMC
gXDgT39/frink35JtpXwb5rgcPrXT9rB/uD//jHof00zOAbu2HZH1levA9t/
bp5MdV8CWx5NumeyzZj33+U+4S0744lglqiFu+GxKXio2rtNSyWDv4SOP2UJ
KWC9pkpxum4NOP9g6U7xK/TPj+IpiQ6duLpASlxFXTGBp2zgdkVS0BvCDVMS
G3SB+plV70a0kVDRNChAi1W3Y0dy0SXN5Ve0XehLsrO9RuvMwNE3HroL9puD
rSvUF67etAAXx/G39s9bgXPYdUk9RTbg0JnF/ONqW3BhUHSKbcB6cOCD601n
lI7gI3ptQTeZBta7UYc94jeCOfL7tZWVTmCNeWTy7nY6WC1J3p1twgBvn8nj
T7BcwN/SiDlNZ13BYXRro+L2TWC53qHbTsgEm71hlDbOoAcM3b+iQ9zAlcwj
mbpy9ELIC5fOFvReIXmkYhztfYtG6ZlGkyb8gpb06HkTXqz1L/QYMzLDx9h9
xUSeKiquUEBEP89KrBaR0Rk/z8++oaHtShS7WCz0kDC3UaZCV7mxqRaHPMA9
tiF+uiueYLZ9e5nXey8wxbg+N6XIG+xQ6BgkZPiASc4HnsS8RHty1ynyEnzB
2cPmHZGEzeAZnSSeX42O8Oqq4XtsAbfqOIYFFfq4u++HPpEfmDudPiAkscBh
dJsocj3ateDiyXZ/f/Dd76N2syVopoitdP6Abt0nkUvV6Jhdn6usp9D2r4mU
AS16MsxXXDaPFhhHKKf16Ma2/Ys7DGjLM1l+8iX0Kc65LBIhYMVUXi3DjW8w
R3eb9dGmnNFrv9i/eytAi1oPi5tOoMsV0tn+DrSydiBda8UGzzYsL3g9Rac5
y0k1UYFgLfMq65EG/UxmGJ0r4YD3hTrxOA5BYLtjxc2ebWgr06MPo/ZwwZ7e
lzttDehJlVPC5SW09NjzueVl9G+nyGaX
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Dashing[{0.01}], 
    LineBox[CompressedData["
1:eJwVyn88E3gcx/Exslw5PxtTnMwsbDKZzcz3Qyb0oNXhHnPVRO66y49S6deV
qC5RupCLx6Me4zzi6iROLZVEJNlZDbelKClJZT9k1Py47/3xfrwez8fj7ZKY
viHZmEAgROP9X/1gZxs1vzJo5x8FkrLSRtR70X5/sCoHJY2+83/b14jATp5o
rypEsQyB3Nf6FsoUXlYSVRUoQGqYleXdQlbj5MLPynpk3LXt+/mDt9GLO9Hp
n5StqFgXsmTr5iYURh0b0CoV6JnE0F5y9h76rPQ/p1G+QnPqWl5CXBu6v7qq
8knFBHosPy4MzpGhpS8aRxK9ZtEiGnlFi5UC2aaIL5utJkKoq0MsV96HCn3C
bkfHkiCk5ck51cBT9PT8yntay8VwoGZC5l41gPIrs+TGDlYQuOyHRfKXLxG5
ePhk0QUbCFv9zizz9St0IiYiSKG3gxTL8rnd7a/RLm65uDPHHvSMhiwz+QgK
VX85kDZMgQs6g0F7fRRlB67fQuEsg+6S/qjwojEUcLW04XCzMyTm23qwSj+g
7dPaIw8Xu4C1+1Gj3b+Mo2lPy0FG7HIoPnmpjhqqQbwrf0lKSlwhSR0XJRBo
kcY6MiGulQot1eUjVn46NHwqIS7DjAZCc4qAzp1A4eq9EW/Y7pDa7FU+5vkJ
vU8i7WrIokPT0tRWPWsSCahk4xOtK0Dxbl83x0+PrP6hFVxTe8Aec2cVjTaF
HHNrhWy2F0T26C5t9pxGv3tyLW1+ZECNOmFXiPNn1EkJ9ps4y4S+g2UeGy2+
IO7S1t+8//UG5jWjqmYrA7IgVuzekrMSyByii5w4g5yynQNFNB/w2cZKoJvP
ooVuG29s6PCBr0mMPOlXc4jJd6jdu4kFhw0tdTrDHMoYtL4fSfCFM2tD5DwC
AdQTp2IjzvsC7f6O0N79BFjj/aAsgrEKJDqTWjMtAe5O8AxT3auApfeeEWcY
QZoXq/9Jsh+ccqWHW7w3Av741l7RQjbMUaWZQ6nGIKDaRy2uYANHaFNpPmoM
9CN5+1r9/SHGt+9Bt5gIHsncZrd+f8gdY8ikQ0RIvrvtWMNODhzv+vaxPt4E
miW9W7V2XCg9YimNHzSBT9XzU95SLpz9yCoSiU0hye3KwrKoABAeW552VWkK
Wo8idr0mAOjqak96/AK4WWkYmszlQcfRmbdTPQsgPtQVeE6BEPH4emniWjNw
TD3RyLwXCMMaU6ZOZgZ25il1Ud/xQcBzbVEKSMBcebqNYuBDs0jJfvWQBNQ3
60VM7DGhxZAWm1K2ZDwY2y5ckG/USQJTEwn5J+zt7L9ffIP9XFn/sxSbbHMm
V4ydl6WyjJnhQ7osrP859ki366bTs3xwRjcOKR/h/9FRrQQ7kv3R/S22glPz
awP2HgZVocduqmBfe4bd5VhIW9JFguLMCKLHHB/2TqfKY7BDnNL/fIAtr3Nz
UWBzenyD+rG/VG/sGsJm5k4rPmK7SYr2aLEddNkztvN8OFhg9MhSRgJNe/G6
JGz37QMZ67BHDoheZ2JvSLRdJsZ+7u20Pw/7kGhtRxp2R2lVRR12z5pGxwLs
O9Ep/u3Ys0Ga9gvY9UQfmQp7Bdt9Rw129c3JhA/YMYzNlCbsi6m3Juexs6jn
2mTY/wEdFT+1
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 29.999999387755103`}, {0, 5}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896329443364*^9}]
}, Open  ]],

Cell[TextData[{
 "The apparent difference is that the quantities get reduced.\nDoes the book \
always start at the next higher tick above ",
 Cell[BoxData[
  FormBox["X", TraditionalForm]]],
 "? Consider:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OtherValues", "=", 
  RowBox[{"Join", "[", 
   RowBox[{
    RowBox[{"Drop", "[", 
     RowBox[{"InitialValues", ",", "1"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["X", "t"], "\[Rule]", ".8"}], "}"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Alpha]", "\[Rule]", "0.1`"}], ",", 
   RowBox[{"\[Gamma]", "\[Rule]", "0"}], ",", 
   RowBox[{"\[Lambda]", "\[Rule]", "5"}], ",", 
   RowBox[{
    SubscriptBox["X", "t"], "\[Rule]", "0.8`"}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896324330472*^9, 3.3896324718374*^9, 3.3896326951604*^9,
   3.3896329599424*^9}]
}, Open  ]],

Cell["In this case:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"QTableOther", "=", 
   RowBox[{"QTable", "[", "OtherValues", "]"}]}], ";", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"p", "[", 
       RowBox[{"x", ",", "QTableOther"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        SubscriptBox["X", "t"], "+", 
        RowBox[{"\[Alpha]", " ", "x"}]}], "/.", "\[InvisibleSpace]", 
       "OtherValues"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "30"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "5"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Thickness", "[", "0.005`", "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Dashing", "[", 
         RowBox[{"{", "0.01`", "}"}], "]"}], "}"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[0.005], LineBox[CompressedData["
1:eJxNznssFAAcB/DL1Tzm5C1HdDmX552uHHceXTvUWRqiwnE6SVtoSlFaYi3y
mkdJ16jsNokSWYShOynrNXWlrLS8slTndp3zCNXS79dv++27zx+/734U0eHQ
eC0CgSD4vX9yeqivh5ov8SX8HW4A9csH5cDLLf88O+BxcWpgGCzj1Uj6q1Vg
64/3x0UuC2DTROFNbR6R+8+lGwPad4brgN9VuHUrDUngfEnmCy1LI7DFhZHz
ZZUm4Jwwvu/LaTPwUfZ1YV/2GrDAdOc3q7uWYD/F3MnkETL4a+tDDZFuBS7L
Lk69nI4+8FnNHK1Ec3ZEKekytGSxMFj+Gm3Q2N1wYgLN04sUPlWi0+NUBrbz
6FsdBZ0pK62XrcMdNqMl95DQzNr2BEU1Oss7ZB/Zcy045pg672mGDZhz+3Lz
6S5b8KEZ5ZnHJAp4xtlwyDV8Pdirrv5aebkdeMo4MHa3lAoeKYjdfUSbBt6u
SOOPsTaAJ+N0jjZnOoD9qRZaOVJHsNEzWtEdhRPYKrchmMVyAV9yZhuaJLiC
+8hb3VUldDDbWlrMeMMAX8zNqupguYENiNWp+7LRpaKsA8I6tLk0dm+0HP02
JTjk/QRaTOEGRi38d28R4zi5hM4jndLJ0Nq4bENuNlH8WW8VOmO2pVesjU4c
U51t00cL+hm8QSO0T21Nl6U12ibL1juChjZ95TP7+jha115wL/QRmu5j2ZAW
zQQfGTKWBRI2gRWqgnB+BXobo1fMd90M7lR5zWueo5NdmIP98e743/f98ghd
FtifuiaIVI12OJOXLvXwADvFs7vsB9HxnQfPNqd4gruuyfcrzdjgHzeWNIwW
dJx9na44iIN9DrbraFfRSqcyVtMUujv5+65UNbqoiZ/CmkMfC9NkXvqJFkxL
imYW0byK0MqIFV7LNuU6cQj1bUR074N7474ktIifRJGZo6/sHSx/4oiWJ2zT
l3ujA85RNKMidKtk/pM6F30+dXVJxSt0pJ8d18vGG2yVlHOf3o0200tsDNrj
A6a7FfaQ59Hjz+2iCxfQVUlt6qUl9C8tKlgr
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Dashing[{0.01}], 
    LineBox[CompressedData["
1:eJwVz300E3ocBvBltBG7hMbKunlPM6E2w/y+esW9Xk9veiPMpbwkN6+dvORE
U92SFN0rpKNEtKsXEmuVXecopdWWSimcO+VlNmxecn/3j+c853PO88+zKiIx
hKdFIBACcP7vqb7Op9aF1V5v3NNaSkvlSFJulu4ty0XJ1yL9rSrlCEy7I8xk
RchIP/Bz3Q05SgmqlRJlVSjgo81i4X05MhqlFmmkAiTOeh089EaOPrUGJKqk
ItT8lCl3WTqMtlgPf1RIe1B5wCC1iz+MNFL2xXHpFxQdEXL0R+Y39GRjTfWr
KiXa05vfMnVyBK341DwUwZhHcRrFzJbEMWQSF1ZL2kgE7WPpBYtqxlGR85aH
AdvJkHetZtfNWgV6d3mtUGFoAEX0w7bzf06gwuqsbi1zI+jxjm4uu6ZE1OKv
py78ZQxvJXbshOsqlL/N16tnyhQOPjwhGLk4iZI5lWGduWbA9DNQ3iubQpvG
ZjISvtIgl+HszDg7jXI8gw/Q3Cyg7PjPu6XH1Mj9dmnT8faVMJDG9enK0qBD
akX2PwaroLVD5RqfNIPUawz7HLdbgrj13cDO1FnkcauuoqTECkos+dlpaXNo
fKlf+A6RNajeS8w3x8yjr6fDdxwh2cIJrn/anrgfyGcs1XeQZQcVE2ESi7AF
9C2SnNyUZQ9qu5czJq4E2GxN1coXrYZcylsCq4kARs9tzzaOOYCEflOnnrEI
lhc0BLFYDPAiGo/4NCyCS2s4hsa/OcJhI7/X7qu1oJPmvV55ngl50qHb4got
4KwQnXN66wSNSbT4dEsiUIhVvx/IXQvX1y93yLlCBHrOSs9QW2cQPBd01tO1
Qddm770QsTNUWjTuP3pVG5hc84bUfS6w61LGRBFVB470LX3iR3AF+8H3MW9K
dWBMeXq772VXEO7V64s3XgxbnTrKfB3Xgfvpcp9K/mJoU3rMTr9YB11/dF7U
LCFBAsOl9xVvPdg+etxfk0cC7miUJFSXBZfbggwzSWT838zfoIoFPfI6bnUO
Geyz+WkiNhtGuxLCYzRkcOBx2m162WCZJ+YFZ+oCry0mrynJDei8kdhzKl1o
r5BEKUw54EKrDVKl6oHqxsK0030OOOR3MZRqPYi0uaVb5u8OwxatJJ+kJaBw
uMASjLuDqGDDs8fKJfCgerZ/ssADwi1Kcs7H68PuTVbgQfeEL7GBrnMD+rA8
Pr+ZKfSEY/yr4sJoAzDVi7vjv5MLfZLW3UmfDIC59sxT2iwXdikPv8yMoID1
YHAoEztvuCajEJtWtmzUG/t2f5/1FWwd7QpqLLb2y1/TW7A/SAUH72M31tlb
arD5WTLDbXNcIEd/Tk6JpMDQC6t9Z+a58EAWSE2KwvsT/yoqsAe6Tz7Oxu5x
qz/ZhE0RPzp0DvtRFavxPXbU3TXCBuziFF+iww8uGBaRYkexN9ATb3Zgx/zS
3nKIRwG3165evdjFG6aiMrGZBeqeEew2juNPhdjmEzlzJgtcMLG/ElmLPf6s
ODASW6idqi/HHsoIHUjB/j5bf0+N/cGJns7HXqYcCCdHU0BcWlN1BzuuP+Su
HXZrQBz7GXaJ7FQYG1tAdO6SYYu6hbpbsW88mAz/jj3aMf33Duzy+JbJBWyz
Nub+aOz/ANzkPNE=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 29.999999387755103`}, {0, 5}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896329900034*^9, 3.3896329922664003`*^9}}]
}, Open  ]],

Cell[TextData[{
 "Consider next the evolution of the book. Suppose that (starting from {\
\[Alpha]  =  0.1, \[Gamma]  =  0, \[Lambda]  =  5, X  =  0}) we get a small \
order of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "=", "1"}], TraditionalForm]]],
 ". The new value of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"X", "=", 
    RowBox[{
     RowBox[{"\[Alpha]", " ", "m"}], " ", "=", " ", "0.1"}]}], 
   TraditionalForm]]],
 ", so the full set of parameters is now:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"RevisedValues", "=", "InitialValues"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
   "RevisedValues", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
   "=", 
   RowBox[{
    SubscriptBox["X", "t"], "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"\[Alpha]", " ", "m"}], "/.", "\[InvisibleSpace]", 
       RowBox[{"m", "\[Rule]", "1"}]}], "/.", "\[InvisibleSpace]", 
      "InitialValues"}], ")"}]}]}], ";", "RevisedValues"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["X", "t"], "\[Rule]", "0.1`"}], ",", 
   RowBox[{"\[Alpha]", "\[Rule]", "0.1`"}], ",", 
   RowBox[{"\[Gamma]", "\[Rule]", "0"}], ",", 
   RowBox[{"\[Lambda]", "\[Rule]", "5"}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896324331132*^9, 3.3896324719154*^9, 3.3896326952204*^9,
   3.3896329957174*^9}]
}, Open  ]],

Cell["And:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"QTableRevised", "=", 
   RowBox[{"QTable", "[", "RevisedValues", "]"}]}], ";", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"p", "[", 
       RowBox[{"x", ",", "QTableInitial"}], "]"}], ",", 
      RowBox[{
       RowBox[{"\[Alpha]", " ", "x"}], "/.", "\[InvisibleSpace]", 
       "InitialValues"}], ",", 
      RowBox[{"p", "[", 
       RowBox[{"x", ",", "QTableRevised"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        SubscriptBox["X", "t"], "+", 
        RowBox[{"\[Alpha]", " ", "x"}]}], "/.", "\[InvisibleSpace]", 
       "RevisedValues"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "25"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "5"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Thickness", "[", "0.005`", "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Dashing", "[", 
         RowBox[{"{", "0.01`", "}"}], "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Thickness", "[", "0.01`", "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Dashing", "[", 
         RowBox[{"{", "0.01`", "}"}], "]"}], "}"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[0.005], LineBox[CompressedData["
1:eJxFxw0s1AEcxvG/XE7FHHJ52+Xl0F10Dkkv191sR5LX3tAu5vU45Z1I8rI6
VBTr1Vxk8tIWXWllnaFi3WZeppqXLTFJsryf0blexu/3bN89+5iHxvlHbCII
wudv/96iWFkloVUeJv5vhiu/NZTwPaqbu+GjMrL3t6gv4C5t5y0kwQzYtZjf
WuOzDI5grWiztQnehr0YEbNUdxJY2n8p5YOLJvigHrOBdFkLHLVaUl4dQAFP
hciEzOO64LiOCccGLz1wqojVmPsRnUlJsz0l0AcTYw9+cCvReU0ttYxxdD8r
b+TxNJpe725IX0In07V8K9fQ7yQ9Yhp5+7oJXkRpoMLQEK2RPxqpz0AfSVjg
a3qiC4M0rJSx6CVKG/9ujAE4rPNiJFtIBbeRjfxEgYZgtm72nclkY3DwPMfW
O9YUXCF5b6q4QQNLiw4M9fmbgZOaOb7lx8zBLfLquYIzFmCh+35ZdIAluKyW
3SSKoYNvzsty4tOswOP1KanCRGvwW7eSe7m5NmDCZ3C0OHsXWMV7qVaRzgCL
dyi8+sRMcFxQWLsibzd4JMcpnHvbFpyxNephuIkdWL/0/mBBJbrjkaiotxV9
QcpxNRpB+zVbm8p+oZntOkshKrQZqfCnh/qedWvyqG6kMQcyWis/a8BkG1pd
vtxN0kHPeE2/+URFD/d+rauloXmzV3RdBOhqCjO9swwtbaMHp1mywK2JO/k2
T9ASswpTzgl7sCxzhRD2oM09yb8tT7PBL7oZ1wb60dc71uzNBA7g0qTJmJBh
dKYBTcci0BFcx9gsTx5BayyoGbWddQLX2D/LkkygGaH13spze8FDHq+lJ6fQ
fVUZdtwkZ/Dyc79DFnNo1avEpqvn94E97d34mYvoTgErWpTkAhYr5VVTq2jj
z+Vdi0r008Z4hUqF/gOo5jIa
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Dashing[{0.01}], 
    LineBox[CompressedData["
1:eJwVy30wFHgcBvBdi9xgwpUSZ5fU2vW2m2J70fc7NYq8pOK8NCqr7Hp/a4tQ
Lsptl1vJVTJsKqnuUNIVE3m5yOalcNVZDSl6se4WbQpr79cfzzzzmWceK378
zgNaFArFl+RbW0vUV0osSzcWH+XrcvdHb7ynx6LHCo9Bay/DO5DhCU0plVdt
hRKgtjVkMRjB0MpJFOgKpSBtzKXrMCLh8ekeD5WgCmLdRLHT9FRoX5dVqxA8
hL5ZYYGSLgbZGXnie0E36MmHmeP0QthWv8B3VDAIl2XSxDH6Deg0dPlOO1QJ
VVVieYxjHWySuDeWb/8CQnhWqEhqgQNOM4ZcQwrGj7De1FS2gw/rwITpVm3U
t8pmDvKeQnVfhqidp4cSoyfs0n29sN6EXaV9zADD5f4PaR3PQTCbX1wWZIRJ
j7L58cx+iG9951zlY4LVCQa7lnq+glMhuivUMYvwclr0R07gEIS3pUVwhaaY
JZ3b8UnxGpoWmO2IDl6K1N4hfHDkDXCNM899OLgMbQ9GpPizR2DvlJu9b4wF
jqrO/6hfPwqXSh5ZTOdaos9IVEZ+4nuo/nWdvGcnA/3e5tlZWn6E5Do3v2Jv
K1S08DMfV4xBg6xsUrzbGjnGz3/YvHcchFvX1kcGLUdDUIUNTP0LRde5d6Oj
bNBzPGTaOkAJeVP1PyUcXoH9zfupIfYTMHJTdEiYtBLv/fzXHoZqAlq25F84
fpyJkTqioa6uSaBs7x+WZNqiICntrsHFKdDgn9RLqSx0Fth1eYd9gpwl0z49
OWzsNbHXF61VQXxIePN0lh02Vh4vsqd9hqGfVu+H3+wxk8r263j1Gb4/W9gv
LnVAo4EjHnE101BmxE5tK3LEsWtWBdL0L9CYRHdn/u6EF23NtGsDvkIJ45KF
mz8Hz1+MaAtjzEB9+gxF+JSD/ILQLoN3M2DltWBueSAXtdzLvkobZqGmm/XL
P31cHB/ZlNKcMwenW+c5jNBVWOHGNe8MU8PZ5A9R+wZW4f0TImOBwzykL7Zc
aB3sjAUB4V401TzcYOnIDg4546aB0hs5nRrQ/UQ1a9qzGqWsoopOLwqWc24f
LXm3Gk825l7wqqUgi3/TVx27Bv3NA8pkNlSUe9ZWB4ytQc+4tt3GYir2XDni
AMkueN2Cb9OhouKXOzs2WE+6oENL+Tnf3VqouZ9092ScKxY6NLN7GrTQi7PF
PV3livFT2s/a2TRsC3WKjE7mYcztSYZYQsMctezK2CwPe2V6WQ/maOhfYKaa
JT68+XVeOzHDTrjFYI6Hyx7UljwnrgvS+WBPzK+IqlMSK+6AYxyxUtIxYaOm
oV9UzX0lsWFA3r5c4mUvijtVah56DC7ZuGeehqOxCkvdeR4qApVe0cR3tNcn
mBLnPX0cnELsveqliSvxi6ZUUT7xsVyToBTiiKvyP1qJ327OGZ4hzo6Umjtp
aHir/29nfQ0PmcOHWRuIMxJtTpgTPwnxc/UkNpU2MTcQm3hTd4UTe87MxmQQ
lzqGnzr/bT+zrSGX2L18/YWrxMPMwoUlxO/pi67dJk4PcKluIOYYP2p6Quyh
yKZ1E/eJi7tfEi/O6vUfJE7ROvRq5NvfzPraf8QWab5jk8SVtxKmNcQPp1Z+
1RD/D6bgRXg=
     "]]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], Thickness[0.01], 
    LineBox[CompressedData["
1:eJxF0H0s1AEcBvDf1XnNeU/hdp3zesrL5TV1uVk075zIS2ReukNFDs1bUmJK
VJZp5m3owpaXcr3YmVLESJNNXlbWJkovOoxwXS/j+322Z88+/z4GUYnc2G0E
QZz423/LKJHWVdFqDxP/s+A8cHPy3Bxv2HnLHmIFn0+8D+Ahir0SOXwB7FLi
2i30XQXHWq1RWBSCs2VvZuxPnaNkcPtodmq/oyI4bTFAczZMGXxQ07yFnKMC
jtzB5JZdo4DzyGbLpuWqYJ1cYW8STQ3cKDUpf1KPfj2VP+jZi5Z0fiLez6Kv
NOvoC1fRRd51eo/J6psmOIGunUIqBU1jv7XN3Yl2odrEaTmgeeu3KhuC0fOR
Yr55gAY4sXfWpsVbE3w1VN5YelobHN2XeYrF1wE/U9D1TwjZDWZpXCz7nKIH
PrnI3udzmgquqXpJXblOA7cXO02OcOlgwVO2X6WXAbhroEFSGMYA848eEMcF
G4Ir7rE6EuKNwDcWxblJ543BM02pafxkE3CP263yS5dMwYTvxMeSi2ZgGUdE
qklnggt2rXiPFJiD1x0tFGfk9uJfodHPVy6jI3IqRfS7aK/6sSb3V+ge0ZJR
xDjaqV+jOvkLOo1Ln9qQoNsmLXUL1tE+dJHDoAz9NYYdpEHet2lFztXGFylB
imiz756lFSposmN35jc/9HSubYzzbXSGMq86Rt8CrFV6Z6KwFt2gbp7eV2EJ
7k7e42rabAWuotdQ2cesweKsNYL/Bm3gqbBheJwFfjjMvDY+ii7q/W1ND98P
LhV8jo+cQmftpKkxQmzAjUy5gZRptPwSSfdZhC1YaN12oWoWzYxq8pGesQNP
uj9pD5xHj9RlWDgL7MGrD/wPMSRo2ePkjvyzDvhHyolsUjva09rNNWsZLUqP
7Ur4hWb05DmESdHveNpLXBm6WKW+1YPkuGl1zpE2mzMu29FrgT1MJzn0yByJ
qktBN2VyVFe10aG1YkmHEVqpz2lMYIvma9rV/AhA94VbxSUI0EKL7PzmR+gC
6UDd/Dpab6xyaFmKvt+atCKTof8AyHpfcQ==
     "]]}, 
   {Hue[0.37820393249936934`, 0.6, 0.6], Dashing[{0.01}], 
    LineBox[CompressedData["
1:eJwVy3k4FHgcBvCRCbtbm8TkCqODSWKYGEnf79ocXcRmk0ztVprJUQw6rFDK
rHIk51QzWHSoVUu1DY2rxZqyWtXa6JAkUypyjJ0x7K8/3ud9Ps/7vPSd+/1D
ZlAoFB+Sz22ZqS4RmxWvbqPXxJwVSuB3HYZ5BC8R3LuZ3l33JNBwqKLUmpcJ
t3IumRhPSaDZPoqrxSuEQu28RuHOavgzrcN7jHsNot5H6gptaqB1ZbJkkFsH
+pIlV/Old0CW1R01wG2H4E1nXuW8rIN1Um2ffu4LOFDHutyifxfaZjt9QeUM
QWlp1krNvlZwz/Sov+g7AcZavlVPzR9AiJ1yNnM2Bc22qjrr3R7CRkbIMM2L
inzB23SPwn+g8tGR2Fa2Do4fYGZptzwBV72l16iJs1D2Tc3iUIdnwFWdEZUF
6uJgbmzfW88e2N/8xvHaRj1MC5ME13W+hJNBWovV4fr4uEK8YPfJV7Cr5ac9
TB4Nb3XYnbCyeA0N2kZ+YVsNkaWlH/Px135gzk3Kk8cY47aLwisCzgDsGHFb
5hNuikaMe6mrh+RQJG4yVaSbYZKh+HpT6TuozFjZ3eFvgcnz/9ju5/ceoqvd
Nok20NFckVul6vkAtbKyT6nbLNHhl+PWrmuHgOflIt0buBAtXHJkgnnDcO4S
82ZY6CJ8lTJ6+s6HYTg9Ij0aeXAxxgRPnR1p+gSvy2MP8PhL0M9y+4QkYwTu
ep4pOHbMCjULv47j8UaB4tvVm5lkjRqzDHwvOI7BNN7SKDrMwDZKE7dfOQaC
+YqNHYKlGHG1qfTrh+OwP2hXoyLZBoO8TVc0n1dAz1HWbshdhsbn7spDDk7A
vGxhV2qxLZbH6vdq+/wHZbpLD7ecW44nsMbWhaaEer65h9UVO2Q1Vor8PypB
bFFk6rbZHpksyo8qiQqk8UoK74E9TtoquBeSJoG+Xnty4RYmnn++OtslUA03
2hmnnjxioiDx6dxg+hSkNU/ZW3Ac0KtTdmOPagqyo+WhPzx1QH/zOVcoLdMQ
b2A2x3KrI+YfTOD7eFHwMmOmLKbHET9Ui4pPV1FQa1TDqGE7C8PHuXFnDTXw
ov1vCeI3LPwuPSjEMEUDGTvLfdQRK5A+QOfnD2tg91pJZcC7FUhzzbF+HjAD
O0ribCHaCWPly4cLGmfgRJXfKstPTqjMjNllYq2J07f5N1P2OeMeZYZCfEoT
19t7esSPOeOq+r9FeQpNbOHY7Q2LZqNLQt37gGAqCtSykncqNhblP/ZNbaXi
5hyjMRXxGt0KTh6xhQ3Pc9YkG9/8nBJWQlwdOFO+jNguzlkgJR6sguX7iKXB
wtph4k2hN24PEXfRObZBMioad4raxtRsNLja96XNPSr2RwyaaU2xUbJIasgm
rqK6RtKIOaLcJR7EGxz+1XMmLs3wdN9BnJiuF3iI2DHq0uFs4r5vBb1KYj+n
8AEV8fWux45fTbNxtGLNuM59Kh6JWnTChLjAagGVRkwrbLBaRfzC8C9ze+K1
SlX4EeJ9Krstuz/vWetq04n1YnRCooh7rYRzxMQ3B3v4CcTxAU6VtcTqZ1kZ
BcTeg8c124mLvw89X0ZskPxw8wtij3b38srPfyPLCx+J5V4mt+uIK65HKqaJ
0+pHmu4T/w9V7kSh
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 24.99999948979592}, {0, 5}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896330059203997`*^9}]
}, Open  ]],

Cell[TextData[{
 "Now suppose that the first order was ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "=", "8"}], TraditionalForm]]],
 ", leading to revised parameters:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"RevisedValues", "=", "InitialValues"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
   "RevisedValues", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
   "=", 
   RowBox[{
    SubscriptBox["X", "t"], "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"\[Alpha]", " ", "m"}], "/.", "\[InvisibleSpace]", 
       RowBox[{"m", "\[Rule]", "8"}]}], "/.", "\[InvisibleSpace]", 
      "InitialValues"}], ")"}]}]}], ";", "RevisedValues"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["X", "t"], "\[Rule]", "0.8`"}], ",", 
   RowBox[{"\[Alpha]", "\[Rule]", "0.1`"}], ",", 
   RowBox[{"\[Gamma]", "\[Rule]", "0"}], ",", 
   RowBox[{"\[Lambda]", "\[Rule]", "5"}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896324331882*^9, 3.3896324720053997`*^9, 
  3.3896326952944*^9, 3.3896330237204*^9}]
}, Open  ]],

Cell["and:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"QTableRevised", "=", 
   RowBox[{"QTable", "[", "RevisedValues", "]"}]}], ";", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"p", "[", 
       RowBox[{"x", ",", "QTableInitial"}], "]"}], ",", 
      RowBox[{
       RowBox[{"\[Alpha]", " ", "x"}], "/.", "\[InvisibleSpace]", 
       "InitialValues"}], ",", 
      RowBox[{"p", "[", 
       RowBox[{"x", ",", "QTableRevised"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        SubscriptBox["X", "t"], "+", 
        RowBox[{"\[Alpha]", " ", "x"}]}], "/.", "\[InvisibleSpace]", 
       "RevisedValues"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "25"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "5"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Thickness", "[", "0.005`", "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Dashing", "[", 
         RowBox[{"{", "0.01`", "}"}], "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Thickness", "[", "0.01`", "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Dashing", "[", 
         RowBox[{"{", "0.01`", "}"}], "]"}], "}"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[0.005], LineBox[CompressedData["
1:eJxFxw0s1AEcxvG/XE7FHHJ52+Xl0F10Dkkv191sR5LX3tAu5vU45Z1I8rI6
VBTr1Vxk8tIWXWllnaFi3WZeppqXLTFJsryf0blexu/3bN89+5iHxvlHbCII
wudv/96iWFkloVUeJv5vhiu/NZTwPaqbu+GjMrL3t6gv4C5t5y0kwQzYtZjf
WuOzDI5grWiztQnehr0YEbNUdxJY2n8p5YOLJvigHrOBdFkLHLVaUl4dQAFP
hciEzOO64LiOCccGLz1wqojVmPsRnUlJsz0l0AcTYw9+cCvReU0ttYxxdD8r
b+TxNJpe725IX0In07V8K9fQ7yQ9Yhp5+7oJXkRpoMLQEK2RPxqpz0AfSVjg
a3qiC4M0rJSx6CVKG/9ujAE4rPNiJFtIBbeRjfxEgYZgtm72nclkY3DwPMfW
O9YUXCF5b6q4QQNLiw4M9fmbgZOaOb7lx8zBLfLquYIzFmCh+35ZdIAluKyW
3SSKoYNvzsty4tOswOP1KanCRGvwW7eSe7m5NmDCZ3C0OHsXWMV7qVaRzgCL
dyi8+sRMcFxQWLsibzd4JMcpnHvbFpyxNephuIkdWL/0/mBBJbrjkaiotxV9
QcpxNRpB+zVbm8p+oZntOkshKrQZqfCnh/qedWvyqG6kMQcyWis/a8BkG1pd
vtxN0kHPeE2/+URFD/d+rauloXmzV3RdBOhqCjO9swwtbaMHp1mywK2JO/k2
T9ASswpTzgl7sCxzhRD2oM09yb8tT7PBL7oZ1wb60dc71uzNBA7g0qTJmJBh
dKYBTcci0BFcx9gsTx5BayyoGbWddQLX2D/LkkygGaH13spze8FDHq+lJ6fQ
fVUZdtwkZ/Dyc79DFnNo1avEpqvn94E97d34mYvoTgErWpTkAhYr5VVTq2jj
z+Vdi0r008Z4hUqF/gOo5jIa
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Dashing[{0.01}], 
    LineBox[CompressedData["
1:eJwVy30wFHgcBvBdi9xgwpUSZ5fU2vW2m2J70fc7NYq8pOK8NCqr7Hp/a4tQ
Lsptl1vJVTJsKqnuUNIVE3m5yOalcNVZDSl6se4WbQpr79cfzzzzmWceK378
zgNaFArFl+RbW0vUV0osSzcWH+XrcvdHb7ynx6LHCo9Bay/DO5DhCU0plVdt
hRKgtjVkMRjB0MpJFOgKpSBtzKXrMCLh8ekeD5WgCmLdRLHT9FRoX5dVqxA8
hL5ZYYGSLgbZGXnie0E36MmHmeP0QthWv8B3VDAIl2XSxDH6Deg0dPlOO1QJ
VVVieYxjHWySuDeWb/8CQnhWqEhqgQNOM4ZcQwrGj7De1FS2gw/rwITpVm3U
t8pmDvKeQnVfhqidp4cSoyfs0n29sN6EXaV9zADD5f4PaR3PQTCbX1wWZIRJ
j7L58cx+iG9951zlY4LVCQa7lnq+glMhuivUMYvwclr0R07gEIS3pUVwhaaY
JZ3b8UnxGpoWmO2IDl6K1N4hfHDkDXCNM899OLgMbQ9GpPizR2DvlJu9b4wF
jqrO/6hfPwqXSh5ZTOdaos9IVEZ+4nuo/nWdvGcnA/3e5tlZWn6E5Do3v2Jv
K1S08DMfV4xBg6xsUrzbGjnGz3/YvHcchFvX1kcGLUdDUIUNTP0LRde5d6Oj
bNBzPGTaOkAJeVP1PyUcXoH9zfupIfYTMHJTdEiYtBLv/fzXHoZqAlq25F84
fpyJkTqioa6uSaBs7x+WZNqiICntrsHFKdDgn9RLqSx0Fth1eYd9gpwl0z49
OWzsNbHXF61VQXxIePN0lh02Vh4vsqd9hqGfVu+H3+wxk8r263j1Gb4/W9gv
LnVAo4EjHnE101BmxE5tK3LEsWtWBdL0L9CYRHdn/u6EF23NtGsDvkIJ45KF
mz8Hz1+MaAtjzEB9+gxF+JSD/ILQLoN3M2DltWBueSAXtdzLvkobZqGmm/XL
P31cHB/ZlNKcMwenW+c5jNBVWOHGNe8MU8PZ5A9R+wZW4f0TImOBwzykL7Zc
aB3sjAUB4V401TzcYOnIDg4546aB0hs5nRrQ/UQ1a9qzGqWsoopOLwqWc24f
LXm3Gk825l7wqqUgi3/TVx27Bv3NA8pkNlSUe9ZWB4ytQc+4tt3GYir2XDni
AMkueN2Cb9OhouKXOzs2WE+6oENL+Tnf3VqouZ9092ScKxY6NLN7GrTQi7PF
PV3livFT2s/a2TRsC3WKjE7mYcztSYZYQsMctezK2CwPe2V6WQ/maOhfYKaa
JT68+XVeOzHDTrjFYI6Hyx7UljwnrgvS+WBPzK+IqlMSK+6AYxyxUtIxYaOm
oV9UzX0lsWFA3r5c4mUvijtVah56DC7ZuGeehqOxCkvdeR4qApVe0cR3tNcn
mBLnPX0cnELsveqliSvxi6ZUUT7xsVyToBTiiKvyP1qJ327OGZ4hzo6Umjtp
aHir/29nfQ0PmcOHWRuIMxJtTpgTPwnxc/UkNpU2MTcQm3hTd4UTe87MxmQQ
lzqGnzr/bT+zrSGX2L18/YWrxMPMwoUlxO/pi67dJk4PcKluIOYYP2p6Quyh
yKZ1E/eJi7tfEi/O6vUfJE7ROvRq5NvfzPraf8QWab5jk8SVtxKmNcQPp1Z+
1RD/D6bgRXg=
     "]]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], Thickness[0.01], 
    LineBox[CompressedData["
1:eJxFznssFAAcB/BjOtfqlsiJPE/SHXKXZ+Vxa3nkcbj14EpC8gy5oxF5tOUR
rhhj5mKS0uakND1OHsPcEsOmaPNaHrNRJ85wd9Xi9/tu3333+e9rEpbAiVAl
EAh+f/tvqQJ5ndCw1oXwPyzJ44nbC5GDrrv2Equz5yInwQNk+71qwT/BZwVu
HQ1+G+AI600yk0xg7dqXFvGL4qEGbhnNSO53JIHPaNJFapn7wZFbJdX1gRrg
hN55G5GvJriASzSTxx0Ch/fdvcmMooA71XUDYoMOg1MLP/Pokbpg5sGs8kW+
Hvhj/sqHLinaUzVkuirxCLi4ncLPE6FH074Qk5fRwUlmlZx19Fx0ugVDgY4P
HRGTifo7JrFkgXT/JTKa5PmV/8wArefwoDLUCu2kPTMz5oMOWXW2ZMehCf3Z
T6kZBuAaYY++rMgQ3FJ8emKYYwzmvXf2r/YxAbdL6qX5V6jgKI9T4uhAU3DV
c2ZrbMxR8KNVcXbiHTPwj8bklKikY+Bu95KKnBxz/Oc3PiPIOg5Wst6q1KTS
wLk6Mt/hXDo4gRveJbtvAZ7Ktr3hWmYJ1iqtHM+vtQLXa9BT+6pOgDuSjNzM
X1qDhcY1+s4XGOAm9kAxpwQtTt8kRA2hCyhXs1yn0ZeaxUqKFN1PKZ/0WUc7
ZcR/ytlEpzRzRdXbaNGs+5M2BXqBYiMYITB3rMGiehllLquiSTpDLtx96JXZ
LEWPFjpP55ycb4c28VbfNr2Mjimq6FaUod8M0h5+G0UX9ioYxsEnwaW8xZjr
39Hp2oYHqEE24Be0PRL+FJr4W0W385otuIHx6p5wHk0La2TLb9mBJ86/a7m4
hB6uS7Ny5dmDN14HOFGlaGVbUuuDeAewN8PdLX0N3RdsHR3LcwTnyiV1S1to
vbHqgTU5uqk5UaZUov8ACscpkQ==
     "]]}, 
   {Hue[0.37820393249936934`, 0.6, 0.6], Dashing[{0.01}], 
    LineBox[CompressedData["
1:eJwVy384E3gcB/CxH1hUVFjnYRZmJNtollrfTzo/KlQeFTnXXdJWfhWKioQu
pRgVcR4jP/p1VzRL0XFWHdE55bhL6xGeu7Kso5hpbO7bH+/n/bye9/O235sQ
Em1IIBCCcb40Q6yrltheXV/ZpZOVlirRfWOWXZwoA/Vcja0brlAieeqdGmeR
GOlTFTdZ15SonX1YSBFVoAhmk6RJqkRPL/QGqIV1aNnp5LMDz5So0zu7SSX8
FZ0TjEXQ9ErUVag4PCrsQYn1Lw1L975Hm1uMgt8K36Cvixu2lbiOoW4zngkp
cgIV9FBXC9+okI/Yt+361hmUrDRrCz36H4p215pxzAhwwoR7oNpwAgWxoj9a
+pNgcf/tYpJiAkn70o908o3hY0GGlbrmI1pr4VJHyjCFa8SqX7ozPiHh7MXy
2rDF4KKPq72xcxIltL/zqAuyAO2oeNjCbgrl7qY46mKXgiTX0Cd6ZgpFdZzY
zxFZQr7NM7XfYzWSG9G2x4RbQzBP8MEldxpxzE8VK5OXwzCFYKL5XoP2TApW
BsfaQFuHdWqI6wyqlPxmo8mzhWSUtaCY/BlJ870VvSF0UK8vGlEoPqOkZsG2
8kB7eLxKb3q3Wotau2o/nYtgQHT//Yj4tFkk8l/TciBsBYTGduia/eZQ2Q3O
vZiDDmDZzHwybq9DBZMtmYdSHOG6mPOH02cd+vfWkaOiRCc4vaPQ9YNcjx77
XSzJymICr3fD7bKyeUTY+mpEfMoZfrRzkMd6EGAeGg0qj7GAsDyt2/QKAXKs
NEG9OS7wPGFujE40gITdUY802a7Q3sKUzQkNYCjTcx8qWglOwhP5gf0GsORS
6atzV90gvq86txwMoXaxy7GOslXwek0Ku7HGENoS7XyZP7mDTJs46mNOBAm9
0kYQygZpA23zlaNEaEnTEkTP2VDCLupWDRDBfovR3IpdHBg1XhPV6EsCWQ/r
/EAfByIHcqr8b5HgQrueTY/kgoA8PxloRYZLScqD373mgg/LfpyWToa0ZbaL
GOEewDa3Nh0dIsNNFrkrecgDzoZ6rXUJogBlyoAm/9YTKAUGSz2lFLjOvntS
8s4TVE5T+rt2RsDaeytYF7camjMfLuCcNwLFpibpjrHVUN/n9ihl3Ah6q4+7
oSQeLMx+msv9xhhmGravY3ziwWXWQp1MbgzzDxLvnYn3AsJl50K+owlsYfv5
pqm94K/wGC92oQl0RLofiEniQ69VeM642gRydF3VY7N88OYkKBlRVAi9TFPP
Yg/e9Ne4Y9NdRX6mc3w4xaCTBdjNYWTlSuynS17Qd2GrGtCqeOyd09yw89jb
DsoeTGAnP5xun8Re/nd5t1rHhzu+J2ue7KPC2ziVLUXPh5DWndIX2A2ktYcs
sad57m2D2IHclxZe2OudhxQz2Bl5FmGp2L9TfZa4RVPhn405I1rs9z3krCLs
+lf9Hgvm+ZAfMCiuwk4/7PDDV9hceWN5HbZlhZy5DjtVKmzqxN6knY1NxzYu
6pzQfdkLN7fmYf9sVqWn7qfCCLN0kQQ7+MxxU2vstB08aSt2cYqrMxc7QHWa
2IPtPUHkIexl2X+GvsEeFL3eGPjlT2NcG8fOGpZtD8e+U39IM4/ttDtvz37s
/wE05zBP
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 24.99999948979592}, {0, 5}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896330258834*^9}]
}, Open  ]],

Cell[TextData[{
 "Originally, there were 10 shares available at a price of 2. The initial \
order of 8 shares left 7 shares at this price. In the new equilibrium, no \
additional shares were added.\nSuppose we have an execution that leaves \
quantity ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]]],
 " at the best price ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]]],
 ". The book is said to \"backfill\" when, subsequent to the execution, \
additional limit orders arrive at ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]]],
 " or better.\nConjecture 1: \"backfilling\" does not occur in this model.\n\
Conjecture 2: \"backfilling\" might occur if we introduced event \
uncertainty."
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Introduction of a dealer/specialist, Seppi (1997)", "Section",
 CellTags->"c:149"],

Cell["\<\
Most markets (including US equity markets) are hybrids of electronic limit \
order books and dealers. Dealers in this context are defined by two features: \
(1) They can condition their trades on the total size of the incoming order; \
(2) They must yield to customer orders at the same price. Seppi (1997) \
suggests analysis on the follow lines. To illustrate the situation, we'll \
take as a point of departure the ask side of the book from the Sandas model.\
\>", "Text",
 CellChangeTimes->{{3.39003017711843*^9, 3.3900301780414305`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"InitialValues", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["X", "t"], "\[Rule]", "0"}], ",", 
     RowBox[{"\[Alpha]", "\[Rule]", ".1"}], ",", 
     RowBox[{"\[Gamma]", "\[Rule]", "0"}], ",", 
     RowBox[{"\[Lambda]", "\[Rule]", "5"}]}], "}"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"QTableInitial", "=", 
   RowBox[{"QTable", "[", "InitialValues", "]"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"MoreStuff", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
     RowBox[{"Point", "[", 
      RowBox[{"{", 
       RowBox[{"8", ",", "2"}], "}"}], "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"A\",
FontSlant->\"Italic\"]\)\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "2.2"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]",
      
     RowBox[{"Dashing", "[", 
      RowBox[{"{", ".01", "}"}], "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0.8"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"8", ",", "0.8"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"8", ",", "2"}], "}"}]}], "}"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"P\",
FontSlant->\"Italic\"]\)(\!\(\*
StyleBox[\"b\",
FontSlant->\"Italic\"]\))\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1.2"}], "}"}]}], "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<E[\!\(\*
StyleBox[\"X\",
FontSlant->\"Italic\"]\)|\!\(\*
StyleBox[\"b\",
FontSlant->\"Italic\"]\)]\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "0.8"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"GrayLevel", "[", "0.5", "]"}], ",", 
     RowBox[{"Rectangle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "0.8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "1"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
    "}"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"QTableInitial", "=", 
   RowBox[{"QTable", "[", "InitialValues", "]"}]}], ";", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"p", "[", 
       RowBox[{"x", ",", "QTableInitial"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        SubscriptBox["X", "t"], "+", 
        RowBox[{"\[Alpha]", " ", "x"}]}], "/.", "\[InvisibleSpace]", 
       "InitialValues"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "14"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "2.5`"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Size of incoming buy order, b\>\"", ",", "\"\<Price and E[X]\>\"", 
       ",", "None", ",", "None"}], "}"}]}], ",", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Range", "[", 
        RowBox[{"0", ",", "14", ",", "2"}], "]"}], ",", 
       RowBox[{"Range", "[", 
        RowBox[{"0", ",", "2.5`", ",", "0.5`"}], "]"}], ",", "None", ",", 
       "None"}], "}"}]}], ",", 
    RowBox[{"Background", "\[Rule]", 
     RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Thickness", "[", "0.005`", "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Dashing", "[", 
         RowBox[{"{", "0.01`", "}"}], "]"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"Epilog", "\[Rule]", "MoreStuff"}], ",", 
    RowBox[{"BaseStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896330614793997`*^9, 3.3896330787384*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[0.005], LineBox[CompressedData["
1:eJxF0GlIkwEcBvB3K1seYfPIZc5jznMxoljlss3mFDN7551vZIdUtOayGU5U
OpxUBtMIbeaXhrHwqkglB24hRpQfXMw8ysBpJRYm1UteaboO8v9/4OHh9/UJ
yStIP8UkCEL2p3+3IafVXLm1RkL8y3fp9ParIsrQI121ptHKzDH0g4XCh/Xt
GR/Agm76/CXxFzDjul11YJEGN9em73LpnAMbLiruvQ9eAnf3ae+rppxg1dOo
BRvJjFs1R5elnr+8FvyxxPCoeHwdOHWsVnqD4wreMaOeUSe4g0WxR4qaGzaA
R2hWonbIE0yqT9IpAWzw2Zj2tKQkL/B4aW9W9CD6kNVBeRz3Bmsr8kWfW9GG
5MWNz+fR6yM6XpX/QpeuyddLGT7/TcRNj/GTl13QR62jLIsbWlakqNjpgw4X
9qy0cdFfjabZpm3oJ+zKaWM8Wj5LvqtSogff+vaW3USXPQse8OP6gnkPBI6O
FrSTk3K4bnQTuG6UOjPhxgETVGLgYuhm8IJ6r9iS6Q/uifFekWu2gBNyhzN2
VwaAKX+T55tOLlhSnXpB0h8IHrFV3G1iBIM1RHbfZB26sNqPdOWHgMVKh45h
RauMte6O/TxwSfm+3G+DaMXjHyeGVaHgKvHtroYFdA079oXsFh/MlL8O6w0K
A5O8Y6SuFZ13kI7yig8HOwYKqWt2NK/x5x67MgIcH178iSQiwTZiYrJNjw6K
zK6f4kfhHy1mI6sDrRnxLKAk0WB7ppq+MoS+I+h6qc8TgCMUHmnnltCnXSyh
5mW0yaKcczrRvwHQkgj9
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Dashing[{0.01}], 
    LineBox[CompressedData["
1:eJwV0X8003scx/EvV3W7lGK0S4r9oJnrnnKFVXt/alFqLVEyKVLcWLv5UU2o
K6UU1SFN3ZxcpbNwhYoV+kEJXe6dUHbGKEsribGWGLuf+8frPM/j75dD+AH/
CGOCIHh4/7cgqESa7nKRnRfsnSkp3cUunLBOvSGOBdYzmsyTthI2ZcxgHBUf
h7KSzoOTVC5cb0/WR4mzIHqxa2M3NQRaRJ6RYeICWMcPjmml7oc3vtZXd4gr
wP3wyLMGajJ8WpbmzhfXQenJFcN11EyIldQaB4nbQG262+QJNQ9cXUuv3Al4
Cyrf9SFS/1JgPtbEHGMNArXFySmiqRKMTssEGyc04G56r7fkaS0U5fh7zKjS
QQ3nUKgHsx7ERzdff2M/CQl7zSrf322Axy2Hbwo+GqDlxrhdYHozCB4yxlt5
xsji5yLH/g2tQE7dJvz6uwlK/Kf4bGikDPqPiG+L+maiqpySDJdNL8GvNwfO
kGcjxC02/GnZAW5aoVbobYqeMjKe0to6wX1lyKGigjkoS2yddfrea5BrZvkc
7jRHt7X5bVkiOfCEezXchfPRgrfttklhCoj2urNl/XoLJPryoTIe9cD2WiXf
LMwS0Sem6i2JXujosmpKukBC89Yp9zfH9QHlL6bybrEVqjxTWxGy7Q0YyNzg
3B5rZLCMSerd8BZye/j7VD+QkU8FaejDin4g+D6LJqg/ol/WeZKbFqpgXLiK
VbPVBjXSljZdmvcO6rwsp9fG2iKjyVtLPbTvwHvnqwDP9IXIUzWfE9Y+AHyb
QvPXVXaIZOUnT2h4D+zzfvHstkXoMnsOI0KiBnnriWu3jOxRfVn+FMr7ALFE
YMtArj1Su1ETCzM/Qtz5BbzZNAckLaeXK/YPAitKmWpU64CcD01FG4d9AkF+
jqnSl4K8l23t1a8ZgiPHV+8c7qCgEOO8yWMOn2Fz+djuVwIqIts8yBuxGIZz
rEvVBeNUlOy87au7dhguzl/5fE0WDXFW7xG4HxwB47Uv6U2L6ehqlELqNTAC
PEooL7WEjuJsuV1GgRoI36RhWHAckW2sU83qfzWgbI/jn5I5IjKnPlGARoEi
+bZCFuWE1Pcb9WY1o8BxFL3nEUvQ8vsN/nFuY9BKqAYqMpegLrcTaXU3xmDx
ksArH2kMxA0oSUy304K8WJo/6y4DkYazuV4XtBArNz/AZzujHaT40dJpLci2
CjUpnc7oYM/D4D9EX+Ays7oxM5yJ+ihN+THqL+C02WzLb5NMZG+2SvIoXAdd
zwpyU7D7vrP1acU+y/JQZmNfnxxXKbA/08MFUmz64D3KN+wqvTSN0DORywuX
a257dOBTvKc6Gxt/eukWduSMGqp0ion8TfSp2Xt1QE7yi27GJunlDgXYL0be
lSuwO8ekT8qwXbvnsYlpJgrqj59uwdbdiQzyxQ6tHzwyK0IHaWEW5xTYghRF
TDL28leS9iFsl4QH5hnY6o2rbAgDEw0dyL19BZvrsU9Cw44JDfhUhU2a+6hO
iC1i//2rBvv5iYDvU7A9lxfNJCJ1kPBNzcvGnvjp9M252N0qy+4q7KN2nH4m
9vngIkozNlg5pLKwkYwdpcAm5hjsfbFHvTvKhrDrTXoeb8curInSGbBP6qt3
RWL/B5yNVVQ=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  Background->GrayLevel[1],
  BaseStyle->{FontFamily -> "Times"},
  Epilog->{
    PointSize[0.02], 
    PointBox[{8, 2}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"A\\\",\\nFontSlant->\\\"Italic\\\"]\\)\"", 
      TraditionalForm], {8, 2.2}], 
    Dashing[{0.01}], 
    LineBox[{{0, 0.8}, {8, 0.8}, {8, 2}}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"P\\\",\\nFontSlant->\\\"Italic\\\"]\\)(\\!\\(\
\\*\\nStyleBox[\\\"b\\\",\\nFontSlant->\\\"Italic\\\"]\\))\"", 
      TraditionalForm], {1, 1.2}], 
    InsetBox[
     FormBox[
     "\"E[\\!\\(\\*\\nStyleBox[\\\"X\\\",\\nFontSlant->\\\"Italic\\\"]\\)|\\!\
\\(\\*\\nStyleBox[\\\"b\\\",\\nFontSlant->\\\"Italic\\\"]\\)]\"", 
      TraditionalForm], {12, 0.8}], 
    GrayLevel[0.5], 
    RectangleBox[{5, 0.8}, {8, 1}]},
  Frame->True,
  FrameLabel->{
    FormBox["\"Size of incoming buy order, b\"", TraditionalForm], 
    FormBox["\"Price and E[X]\"", TraditionalForm], None, None},
  FrameTicks->{{{0, 
      FormBox["0", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {4, 
      FormBox["4", TraditionalForm]}, {6, 
      FormBox["6", TraditionalForm]}, {8, 
      FormBox["8", TraditionalForm]}, {10, 
      FormBox["10", TraditionalForm]}, {12, 
      FormBox["12", TraditionalForm]}, {14, 
      FormBox["14", TraditionalForm]}}, {{0., 
      FormBox["0.`", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {1., 
      FormBox["1.`", TraditionalForm]}, {1.5, 
      FormBox["1.5`", TraditionalForm]}, {2., 
      FormBox["2.`", TraditionalForm]}, {2.5, 
      FormBox["2.5`", TraditionalForm]}}, None, None},
  PlotRange->{{0., 13.999999714285714`}, {0, 2.5}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896330826034*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1578, 1027},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Visible->True,
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
InputAliases->{"intt" -> RowBox[{"\[Integral]", 
     RowBox[{"\[SelectionPlaceholder]", 
       RowBox[{"\[DifferentialD]", "\[Placeholder]"}]}]}], "dintt" -> 
  RowBox[{
     SubsuperscriptBox[
     "\[Integral]", "\[SelectionPlaceholder]", "\[Placeholder]"], 
     RowBox[{"\[Placeholder]", 
       RowBox[{"\[DifferentialD]", "\[Placeholder]"}]}]}], "sumt" -> RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"\[SelectionPlaceholder]", "=", "\[Placeholder]"}], 
      "\[Placeholder]"], "\[Placeholder]"}], "prodt" -> RowBox[{
     UnderoverscriptBox["\[Product]", 
      RowBox[{"\[SelectionPlaceholder]", "=", "\[Placeholder]"}], 
      "\[Placeholder]"], "\[Placeholder]"}], "dt" -> RowBox[{
     SubscriptBox["\[PartialD]", "\[Placeholder]"], " ", 
     "\[SelectionPlaceholder]"}], "E" -> "\[ScriptCapitalE]", "notation" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], " ", 
       "\[DoubleLongLeftRightArrow]", " ", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "notation>" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], " ", 
       "\[DoubleLongRightArrow]", " ", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "notation<" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], " ", 
       "\[DoubleLongLeftArrow]", " ", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "symb" -> 
  RowBox[{"Symbolize", "[", 
     TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], "]"}], 
  "infixnotation" -> RowBox[{"InfixNotation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], ",", 
       "\[Placeholder]"}], "]"}], "addia" -> RowBox[{"AddInputAlias", "[", 
     RowBox[{"\"\[SelectionPlaceholder]\"", "\[Rule]", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "pattwraper" -> 
  TagBox["\[SelectionPlaceholder]", "NotationPatternTag"], "madeboxeswraper" -> 
  TagBox["\[SelectionPlaceholder]", "NotationMadeBoxesTag"]},
Magnification->1.5,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->"EMMStyle02.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:147"->{
  Cell[3532, 117, 89, 1, 65, "Subsection",
   CellTags->"c:147"]},
 "c:149"->{
  Cell[68315, 1806, 88, 1, 92, "Section",
   CellTags->"c:149"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:147", 80258, 2107},
 {"c:149", 80337, 2110}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 946, 25, 430, "Title"],
Cell[CellGroupData[{
Cell[1561, 52, 410, 9, 43, "Input"],
Cell[1974, 63, 724, 16, 51, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2735, 84, 34, 0, 92, "Section"],
Cell[2772, 86, 143, 3, 43, "Input"],
Cell[2918, 91, 111, 3, 32, "Text"],
Cell[3032, 96, 369, 12, 43, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3438, 113, 69, 0, 92, "Section"],
Cell[CellGroupData[{
Cell[3532, 117, 89, 1, 65, "Subsection",
 CellTags->"c:147"],
Cell[CellGroupData[{
Cell[3646, 122, 378, 12, 98, "Input"],
Cell[4027, 136, 232, 6, 67, "Output"]
}, Open  ]],
Cell[4274, 145, 124, 6, 32, "Text"],
Cell[CellGroupData[{
Cell[4423, 155, 2009, 58, 129, "Input"],
Cell[6435, 215, 10142, 182, 309, 5302, 100, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[16592, 400, 190, 6, 32, "Text"],
Cell[CellGroupData[{
Cell[16807, 410, 253, 8, 43, "Input"],
Cell[17063, 420, 313, 9, 55, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17425, 435, 109, 4, 66, "Subsection"],
Cell[17537, 441, 63, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[17625, 445, 606, 18, 68, "Input"],
Cell[18234, 465, 489, 15, 47, "Output"]
}, Open  ]],
Cell[18738, 483, 213, 7, 32, "Text"],
Cell[CellGroupData[{
Cell[18976, 494, 272, 9, 43, "Input"],
Cell[19251, 505, 445, 13, 56, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19745, 524, 109, 4, 66, "Subsection"],
Cell[CellGroupData[{
Cell[19879, 532, 660, 20, 69, "Input"],
Cell[20542, 554, 606, 19, 51, "Output"]
}, Open  ]],
Cell[21163, 576, 30, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[21218, 580, 272, 9, 43, "Input"],
Cell[21493, 591, 520, 15, 56, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22062, 612, 109, 4, 66, "Subsection"],
Cell[CellGroupData[{
Cell[22196, 620, 697, 21, 69, "Input"],
Cell[22896, 643, 733, 23, 51, "Output"]
}, Open  ]],
Cell[23644, 669, 20, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[23689, 673, 272, 9, 43, "Input"],
Cell[23964, 684, 583, 17, 56, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24596, 707, 38, 0, 65, "Subsection"],
Cell[24637, 709, 839, 26, 83, "Input"],
Cell[25479, 737, 201, 8, 32, "Text"],
Cell[25683, 747, 192, 7, 32, "Text"],
Cell[25878, 756, 183, 6, 45, "Input"],
Cell[26064, 764, 61, 0, 32, "Text"],
Cell[26128, 766, 353, 10, 43, "Input"],
Cell[26484, 778, 840, 25, 43, "Input"],
Cell[27327, 805, 1125, 34, 71, "Input"],
Cell[28455, 841, 71, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[28551, 845, 134, 3, 43, "Input"],
Cell[28688, 850, 364, 11, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29089, 866, 1005, 31, 71, "Input"],
Cell[30097, 899, 3456, 64, 385, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33590, 968, 1834, 51, 152, "Input"],
Cell[35427, 1021, 3892, 78, 383, "Output"]
}, Open  ]],
Cell[39334, 1102, 266, 5, 55, "Text"],
Cell[CellGroupData[{
Cell[39625, 1111, 297, 9, 43, "Input"],
Cell[39925, 1122, 396, 10, 38, "Output"]
}, Open  ]],
Cell[40336, 1135, 21, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[40382, 1139, 1044, 32, 71, "Input"],
Cell[41429, 1173, 3254, 61, 383, "Output"]
}, Open  ]],
Cell[44698, 1237, 217, 6, 55, "Text"],
Cell[CellGroupData[{
Cell[44940, 1247, 297, 9, 43, "Input"],
Cell[45240, 1258, 396, 10, 38, "Output"]
}, Open  ]],
Cell[45651, 1271, 29, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[45705, 1275, 1001, 31, 71, "Input"],
Cell[46709, 1308, 3288, 61, 383, "Output"]
}, Open  ]],
Cell[50012, 1372, 480, 15, 32, "Text"],
Cell[CellGroupData[{
Cell[50517, 1391, 541, 16, 71, "Input"],
Cell[51061, 1409, 396, 10, 38, "Output"]
}, Open  ]],
Cell[51472, 1422, 20, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[51517, 1426, 1401, 41, 98, "Input"],
Cell[52921, 1469, 6068, 111, 383, "Output"]
}, Open  ]],
Cell[59004, 1583, 179, 6, 32, "Text"],
Cell[CellGroupData[{
Cell[59208, 1593, 541, 16, 71, "Input"],
Cell[59752, 1611, 400, 10, 38, "Output"]
}, Open  ]],
Cell[60167, 1624, 20, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[60212, 1628, 1401, 41, 98, "Input"],
Cell[61616, 1671, 5926, 109, 383, "Output"]
}, Open  ]],
Cell[67557, 1783, 709, 17, 101, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[68315, 1806, 88, 1, 92, "Section",
 CellTags->"c:149"],
Cell[68406, 1809, 552, 8, 78, "Text"],
Cell[68961, 1819, 353, 10, 43, "Input"],
Cell[69317, 1831, 153, 4, 43, "Input"],
Cell[69473, 1837, 1661, 53, 152, "Input"],
Cell[CellGroupData[{
Cell[71159, 1894, 1895, 52, 152, "Input"],
Cell[73057, 1948, 4635, 99, 383, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
