(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28513,        907]
NotebookOptionsPosition[     22117,        722]
NotebookOutlinePosition[     25225,        801]
CellTagsIndexPosition[     25182,        798]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "MVN ",
 StyleBox["package",
  FontSlant->"Italic"],
 "\n",
 StyleBox["Empirical Market Microstructure",
  FontSlant->"Italic"],
 " \n\t(2006, Oxford University Press)\nCompanion ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook\n\nJoel Hasbrouck\n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Copyright", " ", "2007"}], ",", " ", 
    RowBox[{"Joel", " ", 
     RowBox[{"Hasbrouck", ".", " ", "All"}], " ", "rights", " ", 
     RowBox[{"reserved", "."}]}]}], TraditionalForm]],
  FontSize->14,
  FontSlant->"Italic"]
}], "Title",
 CellChangeTimes->{{3.3896255910914*^9, 3.3896255932033997`*^9}, {
   3.3897167078988237`*^9, 3.389716768500824*^9}, 3.3897219191158237`*^9, {
   3.3897220399168243`*^9, 3.3897220640418243`*^9}, {3.389735393500024*^9, 
   3.389735431148024*^9}, 3.389735530878024*^9, 3.3897355723880243`*^9, {
   3.389735664464024*^9, 3.3897356860350237`*^9}, {3.3899891508672*^9, 
   3.3899891819161997`*^9}, 3.3907332510676003`*^9, {3.3907334440025997`*^9, 
   3.3907334450355997`*^9}}],

Cell["\<\
This package defines a multivariate normal distribution \"object\" (i.e, a \
representation for variables that are multivariate normal), and various \
routines to work with them. The notebook should be stored as a package.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Properties of the multivariate normal distribution:", "Section"],

Cell["\<\
The package implements functionality based on the following relations.\
\>", "Text"],

Cell["Consider a multivariate normal distribution:", "Text"],

Cell[TextData[Cell[BoxData[
 RowBox[{
  RowBox[{
   UnderscriptBox["X", 
    RowBox[{"n", "\[Times]", "1"}]], "=", 
   RowBox[{"(", GridBox[{
      {
       SubscriptBox["X", "1"]},
      {
       SubscriptBox["X", "2"]}
     }], ")"}]}], ";", " ", 
  RowBox[{
   RowBox[{"E", "[", "X", "]"}], "=", 
   RowBox[{"\[Mu]", "=", 
    RowBox[{"(", GridBox[{
       {
        SubscriptBox["\[Mu]", "1"]},
       {
        SubscriptBox["\[Mu]", "2"]}
      }], ")"}]}]}], ";", " ", 
  RowBox[{
   RowBox[{"Var", "[", "X", "]"}], "=", 
   RowBox[{"\[CapitalSigma]", "=", 
    RowBox[{"(", GridBox[{
       {
        SubscriptBox["\[CapitalSigma]", "11"], 
        SubscriptBox["\[CapitalSigma]", "12"]},
       {
        SubscriptBox["\[CapitalSigma]", "21"], 
        SubscriptBox["\[CapitalSigma]", "22"]}
      }], ")"}]}]}]}]]]], "NumberedEquation"],

Cell[TextData[{
 "The partitions here must be consistent, but are otherwise arbitrary. Either \
",
 Cell[BoxData[
  SubscriptBox["X", "1"]]],
 " or ",
 Cell[BoxData[
  SubscriptBox["X", "2"]]],
 " or both may be scalars."
}], "Text"],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"X", "~", "MVN"}], 
   RowBox[{"(", 
    RowBox[{"\[Mu]", ",", "\[CapitalSigma]"}], ")"}]}]]],
 ", then"
}], "Text"],

Cell[TextData[Cell[BoxData[
 RowBox[{
  RowBox[{"E", "[", 
   RowBox[{
    SubscriptBox["X", "1"], "|", 
    SubscriptBox["X", "2"]}], "]"}], "=", 
  RowBox[{
   SubscriptBox["\[Mu]", "1"], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["X", "2"], "-", 
      SubscriptBox["\[Mu]", "2"]}], ")"}], 
    SubsuperscriptBox["\[CapitalSigma]", "22", 
     RowBox[{"-", "1"}]], 
    SubscriptBox["\[CapitalSigma]", "21"]}]}]}]]]], "NumberedEquation"],

Cell[TextData[Cell[BoxData[
 RowBox[{
  RowBox[{"Var", "[", 
   RowBox[{
    SubscriptBox["X", "1"], "|", 
    SubscriptBox["X", "2"]}], "]"}], "=", 
  RowBox[{
   SubscriptBox["\[CapitalSigma]", "11"], "-", 
   RowBox[{
    SubscriptBox["\[CapitalSigma]", "12"], 
    SubsuperscriptBox["\[CapitalSigma]", "22", 
     RowBox[{"-", "1"}]], 
    SubscriptBox["\[CapitalSigma]", "21"]}]}]}]]]], "NumberedEquation"],

Cell[TextData[{
 "Consider a linear transform ",
 Cell[BoxData[
  RowBox[{"Y", "=", 
   RowBox[{"AX", "+", "b"}]}]]],
 ", where ",
 Cell[BoxData["A"]],
 " is a rectangular matrix and ",
 Cell[BoxData["b"]],
 " is a column vector. Then:"
}], "Text"],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"Y", "~", "MVN"}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", "\[Mu]"}], "+", "b"}]}]}]]],
 ", ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["A\[CapitalSigma]A", "\[Prime]"], ")"}]]]
}], "NumberedEquation"],

Cell[BoxData[
 RowBox[{
  RowBox[{"BeginPackage", "[", "\"\<MVN`\>\"", "]"}], ";"}]], "Input",
 InitializationCell->True],

Cell[CellGroupData[{

Cell["The MVN \"object\"", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MVN", "::", "usage"}], "=", 
   "\"\<MVN[\[Mu],\[CapitalSigma],v] is an object that represents a \
multivariate normal distribution with mean vector \[Mu] and covariance matrix \
\[CapitalSigma]. The third parameter, v, is list of Mathematica expressions \
that correspond to the variables. (Typically they are variable names or \
formulas for the variables.)\>\""}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GetMean", "::", "usage"}], "=", 
   "\"\<GetMean[mvn] where mvn is an MVN object returns the mean vector of \
mvn.\>\""}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SetMean", "::", "usage"}], "=", 
   "\"\<SetMean[mvn,\[Mu]New] where mvn is an MVN object returns mvn with the \
mean vector set to \[Mu]New.\>\""}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GetVariance", "::", "usage"}], "=", 
   "\"\<GetVariance[mvn] where mvn is an MVN object returns the variance \
matrix of mvn.\>\""}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SetVariance", "::", "usage"}], "=", 
   "\"\<SetVariance[mvn,\[CapitalSigma]New] where mvn is an MVN object \
returns mvn with the variance matrix set to \[CapitalSigma]New.\>\""}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GetLabel", "::", "usage"}], "=", 
   "\"\<GetLabel[mvn] where mvn is an MVN object returns the label vector of \
mvn.\>\""}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SetLabel", "::", "usage"}], "=", 
   "\"\<SetLabel[MVN,v2] returns an MVN object in which the vector of \
variable expressions is replaced by v2.\>\""}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"StandardMVN", "::", "usage"}], "=", 
   "\"\<StandardMVN[n,x] returns an MVN of order n with zero mean and a \
covariance matrix equal to the identity matrix. The variables are labeled \
\!\(\*SubscriptBox[\(x\), \(1\)]\),...,\!\(\*SubscriptBox[\(x\), \(n\)]\). If \
the second argument is omitted, the variables are labeled \!\(\*SubscriptBox[\
\(z\), \(1\)]\),...,\!\(\*SubscriptBox[\(z\), \(n\)]\)\>\""}], ";"}]], "Input",\

 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LinearForm", "::", "usage"}], "=", 
   "\"\<LinearForm[mvn1,b,c] (where b is a matrix and c is a vector) returns \
an MVN that describes a linear transformation of mvn1. If mvn1=MVN[\[Mu],\
\[CapitalSigma],v] then the return MVN is the distribution of b.v+c. \
LinearForm[mvn1,b] returns an MVN giving the distribution of b.v\>\""}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MakeLinearForm", "::", "usage"}], "=", 
   "\"\<MakeLinearForm[MVN0,b] returns an MVN object representing the \
distribution of a set of linear combinations of the variables in MVN0=MVN[\
\[Mu],\[CapitalSigma],v]. b is a list of expressions defining linear \
combinations of v (and a constant, if desired).\>\""}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MVNConditional", "::", "usage"}], "=", 
   "\"\<MVNConditional[MVN0,v1,v2] returns an MVN object representing a \
conditional multivariate normal distribution. \
MVN0=MVN0[\[Mu],\[CapitalSigma],v] is the joint distribution. v2 is a list of \
the conditioning variables; v1 is a list of the target variables. Both v1 and \
v2 must map to (correspond to) v. MVNConditional[MVN0,v1] returns the \
conditional distribution of v1 conditioned on all variables that are not in \
v1.\>\""}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"Format", "[", 
   RowBox[{"MVN", "[", 
    RowBox[{"\[Mu]Local_", ",", "\[CapitalSigma]Local_", ",", "vLocal_"}], 
    "]"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"mpForm", "[", "vLocal", "]"}], ",", "\"\< ~ \>\"", ",", 
      RowBox[{"StyleBox", "[", 
       RowBox[{"\[ScriptCapitalN]", ",", 
        RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
        RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}], ",", "\"\<(\>\"", 
      ",", "\[IndentingNewLine]", 
      RowBox[{"mpForm", "[", "\[Mu]Local", "]"}], ",", "\"\<,\>\"", ",", 
      RowBox[{"mpForm", "[", "\[CapitalSigma]Local", "]"}], ",", 
      "\"\<)\>\""}], "}"}], "]"}], "//", "DisplayForm"}]}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"Begin", "[", "\"\<`Private`\>\"", "]"}], ";"}]], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["DisplayForm formatting of MVN objects", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"spell\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Possible spelling error: new symbol name \\\"\\!\\(Bold\\)\
\\\" is similar to existing symbols \\!\\({Fold, Hold}\\). \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"General::spell\\\"]\\)\"\>"}]], \
"Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Getting and setting parameters", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GetMean", "[", 
    RowBox[{"MVN", "[", 
     RowBox[{"\[Mu]_", ",", "\[CapitalSigma]_", ",", "v_"}], "]"}], "]"}], ":=",
    
   RowBox[{"GetElement", "[", "\[Mu]", "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SetMean", "[", 
   RowBox[{
    RowBox[{"MVN", "[", 
     RowBox[{"\[Mu]_", ",", "\[CapitalSigma]_", ",", "v_"}], "]"}], ",", 
    "\[Mu]New_"}], "]"}], ":=", 
  RowBox[{"MVN", "[", 
   RowBox[{"\[Mu]New", ",", "\[CapitalSigma]", ",", "v"}], "]"}]}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"spell1\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Possible spelling error: new symbol name \\\"\\!\\(SetMean\
\\)\\\" is similar to existing symbol \\\"\\!\\(GetMean\\)\\\". \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], \
"Message"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"GetVariance", "[", 
   RowBox[{"MVN", "[", 
    RowBox[{"\[Mu]_", ",", "\[CapitalSigma]_", ",", "v_"}], "]"}], "]"}], ":=",
   
  RowBox[{"GetElement", "[", "\[CapitalSigma]", "]"}]}]], "Input",
 InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SetVariance", "[", 
   RowBox[{
    RowBox[{"MVN", "[", 
     RowBox[{"\[Mu]_", ",", "\[CapitalSigma]_", ",", "v_"}], "]"}], ",", 
    "\[CapitalSigma]New_"}], "]"}], ":=", 
  RowBox[{"MVN", "[", 
   RowBox[{"\[Mu]", ",", "\[CapitalSigma]New", ",", "v"}], "]"}]}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"spell1\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Possible spelling error: new symbol name \
\\\"\\!\\(SetVariance\\)\\\" is similar to existing symbol \
\\\"\\!\\(GetVariance\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GetLabel", "[", 
    RowBox[{"MVN", "[", 
     RowBox[{"\[Mu]_", ",", "\[CapitalSigma]_", ",", "v_"}], "]"}], "]"}], ":=",
    
   RowBox[{"GetElement", "[", "v", "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SetLabel", "[", 
   RowBox[{
    RowBox[{"MVN", "[", 
     RowBox[{"\[Mu]_", ",", "\[CapitalSigma]_", ",", "v_"}], "]"}], ",", 
    "v2_"}], "]"}], ":=", 
  RowBox[{"MVN", "[", 
   RowBox[{"\[Mu]", ",", "\[CapitalSigma]", ",", "v2"}], "]"}]}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"spell1\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Possible spelling error: new symbol name \
\\\"\\!\\(SetLabel\\)\\\" is similar to existing symbol \\\"\\!\\(GetLabel\\)\
\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Constructing and transforming MVN's", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"StandardMVN", "[", 
   RowBox[{"1", ",", 
    RowBox[{"v_:", "Global`z"}]}], "]"}], ":=", 
  RowBox[{"MVN", "[", 
   RowBox[{"0", ",", "1", ",", "v"}], "]"}]}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"StandardMVN", "[", 
   RowBox[{"n_", ",", 
    RowBox[{"v_:", "Global`z"}]}], "]"}], ":=", 
  RowBox[{"MVN", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{"0", ",", 
      RowBox[{"{", "n", "}"}]}], "]"}], ",", 
    RowBox[{"IdentityMatrix", "[", "n", "]"}], ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      SubscriptBox["v", "i"], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}], "]"}]}]], "Input",\

 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"LinearForm", "[", 
   RowBox[{
    RowBox[{"MVN", "[", 
     RowBox[{"\[Mu]_", ",", "\[CapitalSigma]_", ",", "v_"}], "]"}], ",", "b_",
     ",", 
    RowBox[{"c_:", "0"}]}], "]"}], ":=", 
  RowBox[{"MVN", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"b", ".", 
      RowBox[{"ToVector", "[", "\[Mu]", "]"}]}], "+", "c"}], ",", 
    RowBox[{"b", ".", 
     RowBox[{"ToMatrix", "[", "\[CapitalSigma]", "]"}], ".", 
     RowBox[{"Transpose", "[", "b", "]"}]}], ",", 
    RowBox[{
     RowBox[{"b", ".", 
      RowBox[{"ToVector", "[", "v", "]"}]}], "+", "c"}]}], "]"}]}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"MakeLinearForm", "[", 
   RowBox[{
    RowBox[{"MVN", "[", 
     RowBox[{"\[Mu]_", ",", "\[CapitalSigma]_", ",", "v_"}], "]"}], ",", 
    "vNew_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"b", ",", "b0"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"b", "=", 
      RowBox[{"Transpose", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Coefficient", "[", 
          RowBox[{
           RowBox[{"ToVector", "[", "vNew", "]"}], ",", "#", ",", "1"}], 
          "]"}], "&"}], "/@", " ", 
        RowBox[{"ToVector", "[", "v", "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"b0", " ", "=", " ", 
      RowBox[{
       RowBox[{"ToVector", "[", "vNew", "]"}], "-", 
       RowBox[{"b", ".", 
        RowBox[{"ToVector", "[", "v", "]"}]}]}]}], ";", "\[IndentingNewLine]",
      
     RowBox[{"LinearForm", "[", 
      RowBox[{
       RowBox[{"MVN", "[", 
        RowBox[{"\[Mu]", ",", "\[CapitalSigma]", ",", "v"}], "]"}], ",", "b", 
       ",", "b0"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Conditional distributions", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MVNConditional", "[", 
   RowBox[{
    RowBox[{"MVN", "[", 
     RowBox[{"\[Mu]_", ",", "\[CapitalSigma]_", ",", "v_"}], "]"}], ",", 
    "v1a_", ",", 
    RowBox[{"v2a_:", "0"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"v1", ",", "v2", ",", "i1", ",", "i2"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"v1", "=", 
      RowBox[{"ToVector", "[", "v1a", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"i1", "=", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Position", "[", 
          RowBox[{"v", ",", "#"}], "]"}], "&"}], "/@", "v1"}], " ", "//", " ",
        "Flatten"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"i2", "=", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"v2a", "=!=", "0"}], ",", "\[IndentingNewLine]", "\t", 
        RowBox[{
         RowBox[{"v2", "=", 
          RowBox[{"ToVector", "[", "v2a", "]"}]}], ";", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"Position", "[", 
             RowBox[{"v", ",", "#"}], "]"}], "&"}], "/@", "v2"}], " ", "//", 
          "Flatten"}]}], ",", "\[IndentingNewLine]", "\t", 
        RowBox[{"Complement", "[", 
         RowBox[{
          RowBox[{"Range", "[", 
           RowBox[{"Length", "[", 
            RowBox[{"ToVector", "[", "v", "]"}], "]"}], "]"}], ",", "i1"}], 
         "]"}]}], "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"MVN", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Mu]", "[", 
         RowBox[{"[", "i1", "]"}], "]"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"v", "[", 
            RowBox[{"[", "i2", "]"}], "]"}], "-", 
           RowBox[{"\[Mu]", "[", 
            RowBox[{"[", "i2", "]"}], "]"}]}], ")"}], ".", 
         RowBox[{"Inverse", "[", 
          RowBox[{"\[CapitalSigma]", "[", 
           RowBox[{"[", 
            RowBox[{"i2", ",", "i2"}], "]"}], "]"}], "]"}], ".", 
         RowBox[{"\[CapitalSigma]", "[", 
          RowBox[{"[", 
           RowBox[{"i2", ",", "i1"}], "]"}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"\[CapitalSigma]", "[", 
         RowBox[{"[", 
          RowBox[{"i1", ",", "i1"}], "]"}], "]"}], "-", 
        RowBox[{
         RowBox[{"\[CapitalSigma]", "[", 
          RowBox[{"[", 
           RowBox[{"i1", ",", "i2"}], "]"}], "]"}], ".", 
         RowBox[{"Inverse", "[", 
          RowBox[{"\[CapitalSigma]", "[", 
           RowBox[{"[", 
            RowBox[{"i2", ",", "i2"}], "]"}], "]"}], "]"}], ".", 
         RowBox[{"\[CapitalSigma]", "[", 
          RowBox[{"[", 
           RowBox[{"i2", ",", "i1"}], "]"}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"v", "[", 
        RowBox[{"[", "i1", "]"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"spell1\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Possible spelling error: new symbol name \
\\\"\\!\\(vRange\\)\\\" is similar to existing symbol \\\"\\!\\(Range\\)\\\". \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], \
"Message"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Helper functions", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"mpForm", "[", "x_", "]"}], ":=", 
   RowBox[{"Which", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"MatrixQ", "[", "x", "]"}], "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Times", " ", "@@", " ", 
          RowBox[{"Dimensions", " ", "@", " ", "x"}]}], ")"}], "==", "1"}], 
       ")"}]}], ",", 
     RowBox[{"x", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"VectorQ", "[", "x", "]"}], "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Length", "[", "x", "]"}], "\[Equal]", "1"}], ")"}]}], ",", 
     RowBox[{"x", "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", "True", ",", 
     RowBox[{"MatrixForm", "[", "x", "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GetElement", "[", "x_", "]"}], ":=", 
   RowBox[{"Which", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"MatrixQ", "[", "x", "]"}], "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Times", " ", "@@", " ", 
          RowBox[{"Dimensions", " ", "@", " ", "x"}]}], ")"}], "==", "1"}], 
       ")"}]}], ",", 
     RowBox[{"x", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"VectorQ", "[", "x", "]"}], "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Length", "[", "x", "]"}], "\[Equal]", "1"}], ")"}]}], ",", 
     RowBox[{"x", "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", "True", ",", "x"}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ToVector", "[", "x_", "]"}], ":=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"{", "x", "}"}], "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ToMatrix", "[", "x_", "]"}], ":=", 
   RowBox[{"Which", "[", 
    RowBox[{
     RowBox[{"MatrixQ", "[", "x", "]"}], ",", "x", ",", 
     RowBox[{"VectorQ", "[", "x", "]"}], ",", 
     RowBox[{"{", "x", "}"}], ",", "True", ",", 
     RowBox[{"{", 
      RowBox[{"{", "x", "}"}], "}"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"End", "[", "]"}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{"EndPackage", "[", "]"}]], "Input",
 InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->Automatic,
ScreenStyleEnvironment->"Working",
WindowSize->{1578, 1027},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Visible->True,
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
CellLabelAutoDelete->True,
InputAliases->{"intt" -> RowBox[{"\[Integral]", 
     RowBox[{"\[SelectionPlaceholder]", 
       RowBox[{"\[DifferentialD]", "\[Placeholder]"}]}]}], "dintt" -> 
  RowBox[{
     SubsuperscriptBox[
     "\[Integral]", "\[SelectionPlaceholder]", "\[Placeholder]"], 
     RowBox[{"\[Placeholder]", 
       RowBox[{"\[DifferentialD]", "\[Placeholder]"}]}]}], "sumt" -> RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"\[SelectionPlaceholder]", "=", "\[Placeholder]"}], 
      "\[Placeholder]"], "\[Placeholder]"}], "prodt" -> RowBox[{
     UnderoverscriptBox["\[Product]", 
      RowBox[{"\[SelectionPlaceholder]", "=", "\[Placeholder]"}], 
      "\[Placeholder]"], "\[Placeholder]"}], "dt" -> RowBox[{
     SubscriptBox["\[PartialD]", "\[Placeholder]"], " ", 
     "\[SelectionPlaceholder]"}], "notation" -> RowBox[{"Notation", "[", 
     RowBox[{
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> "NotationTemplateStyle"],
        " ", "\[DoubleLongLeftRightArrow]", " ", 
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> 
        "NotationTemplateStyle"]}], "]"}], "notation>" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> "NotationTemplateStyle"],
        " ", "\[DoubleLongRightArrow]", " ", 
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> 
        "NotationTemplateStyle"]}], "]"}], "notation<" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> "NotationTemplateStyle"],
        " ", "\[DoubleLongLeftArrow]", " ", 
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> 
        "NotationTemplateStyle"]}], "]"}], "symb" -> 
  RowBox[{"Symbolize", "[", 
     TagBox[
     "\[Placeholder]", NotationBoxTag, TagStyle -> "NotationTemplateStyle"], 
     "]"}], "infixnotation" -> RowBox[{"InfixNotation", "[", 
     RowBox[{
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> "NotationTemplateStyle"],
        ",", "\[Placeholder]"}], "]"}], "addia" -> 
  RowBox[{"AddInputAlias", "[", 
     RowBox[{"\"\[Placeholder]\"", "\[Rule]", 
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> 
        "NotationTemplateStyle"]}], "]"}], "pattwraper" -> 
  TagBox["\[Placeholder]", NotationPatternTag, TagStyle -> 
    "NotationPatternWrapperStyle"], "madeboxeswraper" -> 
  TagBox["\[Placeholder]", NotationMadeBoxesTag, TagStyle -> 
    "NotationMadeBoxesWrapperStyle"], "FF" -> "\[ScriptCapitalF]", "EE" -> 
  "\[ScriptCapitalE]"},
Magnification->1.5,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->"EMMStyle02.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 1041, 27, 393, "Title"],
Cell[1634, 52, 246, 4, 55, "Text"],
Cell[CellGroupData[{
Cell[1905, 60, 70, 0, 92, "Section"],
Cell[1978, 62, 94, 2, 32, "Text"],
Cell[2075, 66, 60, 0, 32, "Text"],
Cell[2138, 68, 845, 30, 48, "NumberedEquation"],
Cell[2986, 100, 233, 9, 33, "Text"],
Cell[3222, 111, 177, 8, 33, "Text"],
Cell[3402, 121, 466, 15, 34, "NumberedEquation"],
Cell[3871, 138, 411, 12, 34, "NumberedEquation"],
Cell[4285, 152, 248, 10, 33, "Text"],
Cell[4536, 164, 271, 11, 34, "NumberedEquation"],
Cell[4810, 177, 121, 3, 43, "Input",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[4956, 184, 43, 0, 44, "Subsubsection"],
Cell[5002, 186, 458, 9, 125, "Input",
 InitializationCell->True],
Cell[5463, 197, 213, 6, 43, "Input",
 InitializationCell->True],
Cell[5679, 205, 240, 6, 43, "Input",
 InitializationCell->True],
Cell[5922, 213, 225, 6, 43, "Input",
 InitializationCell->True],
Cell[6150, 221, 275, 7, 43, "Input",
 InitializationCell->True],
Cell[6428, 230, 216, 6, 43, "Input",
 InitializationCell->True],
Cell[6647, 238, 244, 6, 43, "Input",
 InitializationCell->True],
Cell[6894, 246, 501, 10, 98, "Input",
 InitializationCell->True],
Cell[7398, 258, 427, 9, 125, "Input",
 InitializationCell->True],
Cell[7828, 269, 405, 8, 140, "Input",
 InitializationCell->True],
Cell[8236, 279, 574, 11, 167, "Input",
 InitializationCell->True],
Cell[8813, 292, 794, 19, 86, "Input",
 InitializationCell->True],
Cell[9610, 313, 119, 3, 58, "Input",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[9766, 321, 62, 0, 60, "Subsubsection"],
Cell[9831, 323, 386, 8, 43, "Message"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10254, 336, 55, 0, 60, "Subsubsection"],
Cell[10312, 338, 265, 8, 58, "Input",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[10602, 350, 322, 9, 58, "Input",
 InitializationCell->True],
Cell[10927, 361, 393, 8, 43, "Message"]
}, Open  ]],
Cell[11335, 372, 256, 7, 58, "Input",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[11616, 383, 336, 9, 58, "Input",
 InitializationCell->True],
Cell[11955, 394, 401, 8, 43, "Message"]
}, Open  ]],
Cell[12371, 405, 262, 8, 58, "Input",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[12658, 417, 315, 9, 58, "Input",
 InitializationCell->True],
Cell[12976, 428, 395, 8, 43, "Message"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13420, 442, 60, 0, 60, "Subsubsection"],
Cell[13483, 444, 232, 7, 58, "Input",
 InitializationCell->True],
Cell[13718, 453, 516, 17, 58, "Input",
 InitializationCell->True],
Cell[14237, 472, 639, 19, 58, "Input",
 InitializationCell->True],
Cell[14879, 493, 1151, 33, 167, "Input",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[16067, 531, 50, 0, 60, "Subsubsection"],
Cell[CellGroupData[{
Cell[16142, 535, 2994, 82, 383, "Input",
 InitializationCell->True],
Cell[19139, 619, 390, 8, 43, "Message"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19578, 633, 41, 0, 60, "Subsubsection"],
Cell[19622, 635, 857, 25, 86, "Input",
 InitializationCell->True],
Cell[20482, 662, 824, 25, 86, "Input",
 InitializationCell->True],
Cell[21309, 689, 192, 6, 58, "Input",
 InitializationCell->True],
Cell[21504, 697, 386, 11, 58, "Input",
 InitializationCell->True],
Cell[21893, 710, 96, 3, 58, "Input",
 InitializationCell->True],
Cell[21992, 715, 85, 2, 58, "Input",
 InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
