(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    338487,      10970]
NotebookOptionsPosition[    312408,      10148]
NotebookOutlinePosition[    315826,      10232]
CellTagsIndexPosition[    315654,      10224]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "MultivariateMicrostructureModels\n",
 StyleBox["Empirical Market Microstructure",
  FontSlant->"Italic"],
 " \n\t(2006, Oxford University Press)\nCompanion ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook\n\nJoel Hasbrouck\n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Copyright", " ", "2007"}], ",", " ", 
    RowBox[{"Joel", " ", 
     RowBox[{"Hasbrouck", ".", " ", "All"}], " ", "rights", " ", 
     RowBox[{"reserved", "."}]}]}], TraditionalForm]],
  FontSize->14,
  FontSlant->"Italic"],
 "\n",
 StyleBox["This notebook covers material in Chapters 9 and 10",
  FontSize->14]
}], "Title",
 CellChangeTimes->{{3.3896255910914*^9, 3.3896255932033997`*^9}, {
   3.3897167078988237`*^9, 3.389716768500824*^9}, 3.3897219191158237`*^9, {
   3.3899919263996*^9, 3.3899919275346003`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Text", "  ", "@", " ", 
  RowBox[{"Style", "[", 
   RowBox[{
    RowBox[{"\"\<Notebook evaluated \>\"", "<>", 
     RowBox[{"DateString", "[", "\"\<DateTime\>\"", "]"}]}], ",", 
    "\"\<Subtitle\>\""}], "]"}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896127180972*^9, 3.3896127205282*^9}, 
   3.389716999411824*^9, {3.3897170351038237`*^9, 3.389717047196824*^9}}],

Cell[BoxData[
 InterpretationBox[Cell[BoxData[
   StyleBox["\<\"Notebook evaluated Monday 4 June 2007 20:28:52\"\>", 
    "Subtitle",
    StripOnInput->False]], "Text", "TR"],
  Text[
   Style["Notebook evaluated Monday 4 June 2007 20:28:52", 
    "Subtitle"]]]], "Output",
 CellMargins->{{18, Inherited}, {Inherited, 0}},
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896127211071997`*^9, {3.3896127536242*^9, 3.3896127555652*^9}, 
   3.3896128616452*^9, 3.389623031447*^9, 3.3896232934164*^9, 
   3.389716955274824*^9, 3.3897170008718243`*^9, {3.3897170377738237`*^9, 
   3.3897170482808237`*^9}, 3.3899920823416*^9, 3.3899921326345997`*^9},
 Background->RGBColor[0.866667, 0.733333, 1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Preliminaries", "Section"],

Cell[CellGroupData[{

Cell["Notations", "Subsection"],

Cell[BoxData[
 RowBox[{"<<", "Notation`"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896256042084*^9, 3.3896256118254004`*^9}}],

Cell["\<\
The following commands define symbolizations that are convenient for labeling \
things.\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["Anything_", "Rule"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";", 
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["Anything_", "Rules"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["Anything_", "Solution"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";", 
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["Anything_", "Solutions"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"Symbolize", "[", 
  TagBox[
   SubsuperscriptBox["\[Sigma]", "_", "2"],
   "NotationTemplateTag"], "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896306831308002`*^9, 3.3896306865838003`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Additional initializations specific to this notebook", "Subsection"],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"c", ",", "Constant"}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell["Permutation routine", "Subsubsection"],

Cell["\<\
The following routine is useful for permuting the order of variables in \
coefficient and covariance matrices.\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Permute", "[", 
   RowBox[{"m_", ",", "i_"}], "]"}], ":=", 
  RowBox[{"Transpose", "[", 
   RowBox[{
    RowBox[{"Transpose", "[", 
     RowBox[{"m", "[", 
      RowBox[{"[", "i", "]"}], "]"}], "]"}], "[", 
    RowBox[{"[", "i", "]"}], "]"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell["For example:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"vTest", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      SubscriptBox["\[Sigma]", 
       RowBox[{
        RowBox[{"Min", "[", 
         RowBox[{"i", ",", "j"}], "]"}], ",", 
        RowBox[{"Max", "[", 
         RowBox[{"i", ",", "j"}], "]"}]}]], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "4"}], "}"}]}], "]"}]}], ")"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "1"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "2"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "3"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "4"}]]},
     {
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "2"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"2", ",", "2"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"2", ",", "3"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"2", ",", "4"}]]},
     {
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "3"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"2", ",", "3"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"3", ",", "3"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"3", ",", "4"}]]},
     {
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "4"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"2", ",", "4"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"3", ",", "4"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"4", ",", "4"}]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896257247552*^9, 3.3896275665558*^9, 3.389630915309*^9, {
   3.389706841877224*^9, 3.3897068592892237`*^9}, 3.389717084125824*^9, 
   3.3899920836516*^9, 3.3899921343356*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Permute", "[", 
   RowBox[{"vTest", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4", ",", "1", ",", "3"}], "}"}]}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SubscriptBox["\[Sigma]", 
       RowBox[{"2", ",", "2"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"2", ",", "4"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "2"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"2", ",", "3"}]]},
     {
      SubscriptBox["\[Sigma]", 
       RowBox[{"2", ",", "4"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"4", ",", "4"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "4"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"3", ",", "4"}]]},
     {
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "2"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "4"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "1"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "3"}]]},
     {
      SubscriptBox["\[Sigma]", 
       RowBox[{"2", ",", "3"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"3", ",", "4"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "3"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"3", ",", "3"}]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896257248042*^9, 3.3896275666048*^9, 3.3896309153570004`*^9, {
   3.389706841908224*^9, 3.389706859337224*^9}, 3.389717084152824*^9, 
   3.3899920837195997`*^9, 3.3899921343866*^9}]
}, Closed]],

Cell["This reverses the permutation:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Permute", "[", 
   RowBox[{"%", ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "4", ",", "2"}], "}"}]}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "1"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "2"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "3"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "4"}]]},
     {
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "2"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"2", ",", "2"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"2", ",", "3"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"2", ",", "4"}]]},
     {
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "3"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"2", ",", "3"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"3", ",", "3"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"3", ",", "4"}]]},
     {
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "4"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"2", ",", "4"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"3", ",", "4"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"4", ",", "4"}]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896257248431997`*^9, 3.3896275666398*^9, 3.3896309153929996`*^9, {
   3.3897068419442244`*^9, 3.389706859375224*^9}, 3.389717084184824*^9, 
   3.3899920837855997`*^9, 3.3899921344435997`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"vTest", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      SubscriptBox["\[Sigma]", 
       RowBox[{
        RowBox[{"Min", "[", 
         RowBox[{"i", ",", "j"}], "]"}], ",", 
        RowBox[{"Max", "[", 
         RowBox[{"i", ",", "j"}], "]"}]}]], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "3"}], "}"}]}], "]"}]}], ")"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "1"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "2"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "3"}]]},
     {
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "2"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"2", ",", "2"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"2", ",", "3"}]]},
     {
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "3"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"2", ",", "3"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"3", ",", "3"}]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896257248752003`*^9, 3.3896275666738*^9, 3.389630915426*^9, {
   3.389706841982224*^9, 3.3897068594252243`*^9}, 3.389717084219824*^9, 
   3.3899920838536*^9, 3.3899921344966*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Permute", "[", 
   RowBox[{"%", ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "2"}], "}"}]}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SubscriptBox["\[Sigma]", 
       RowBox[{"3", ",", "3"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "3"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"2", ",", "3"}]]},
     {
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "3"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "1"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "2"}]]},
     {
      SubscriptBox["\[Sigma]", 
       RowBox[{"2", ",", "3"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "2"}]], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"2", ",", "2"}]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896257249112*^9, 3.3896275667078*^9, 3.389630915458*^9, {
   3.3897068420172243`*^9, 3.389706859476224*^9}, 3.389717084251824*^9, 
   3.3899920839206*^9, 3.3899921345516*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Matrix polynomial formatting routines", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PolyForm", "[", 
    RowBox[{"m_", ",", 
     RowBox[{"L_:", "L"}]}], "]"}], ":=", " ", 
   RowBox[{"Plus", " ", "@@", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"MatrixForm", "[", 
        RowBox[{"Coefficient", "[", 
         RowBox[{"m", ",", "L", ",", "i"}], "]"}], "]"}], 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"i", "=!=", "0"}], ",", 
         SuperscriptBox["L", "i"], ",", "\"\<\>\""}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"-", 
         RowBox[{"Max", "[", 
          RowBox[{"Exponent", "[", 
           RowBox[{
            RowBox[{"Flatten", "[", 
             RowBox[{"m", "/.", "\[InvisibleSpace]", 
              RowBox[{"L", "\[Rule]", 
               FractionBox["1", "L"]}]}], "]"}], ",", "L"}], "]"}], "]"}]}], 
        ",", 
        RowBox[{"Max", "[", 
         RowBox[{"Exponent", "[", 
          RowBox[{
           RowBox[{"Flatten", "[", "m", "]"}], ",", "L"}], "]"}], "]"}]}], 
       "}"}]}], "]"}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389707724607224*^9, 3.3897077565762243`*^9}, 
   3.389707822397224*^9, {3.389707853843224*^9, 3.389707883044224*^9}, {
   3.3897079315322237`*^9, 3.389707977218224*^9}, {3.389708013139224*^9, 
   3.3897080923672237`*^9}, {3.389708138101224*^9, 3.389708149603224*^9}, {
   3.3897082102632236`*^9, 3.389708275688224*^9}, {3.389708315735224*^9, 
   3.389708329416224*^9}, {3.389708402981224*^9, 3.389708420765224*^9}, {
   3.389708499729224*^9, 3.389708512778224*^9}, {3.389709392698224*^9, 
   3.3897094393222237`*^9}, {3.389709469771224*^9, 3.389709530969224*^9}, {
   3.389709646472224*^9, 3.3897096563082237`*^9}, {3.389709690603224*^9, 
   3.389709693663224*^9}, {3.389709724152224*^9, 3.3897097716562243`*^9}, {
   3.389709832111224*^9, 3.389709833692224*^9}, {3.389709905363224*^9, 
   3.389709907284224*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Vector autocovariance generating function (from VMA representation);\
\>", "Subsubsection"],

Cell[TextData[{
 "In the following, ",
 Cell[BoxData["\[Theta]"]],
 " is assumed to be a matrix polynomial in ",
 Cell[BoxData["L"]],
 "; ",
 Cell[BoxData["\[CapitalOmega]"]],
 " is the covariance matrix. For more detail, see the last section of this \
notebook."
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"G", "[", 
    RowBox[{"\[Theta]_", ",", "\[CapitalOmega]_", ",", "z_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\[Theta]", "/.", 
      RowBox[{"L", "\[Rule]", "z"}]}], ")"}], ".", "\[CapitalOmega]", ".", 
    RowBox[{"Transpose", "[", 
     RowBox[{"\[Theta]", "/.", 
      RowBox[{"L", "\[Rule]", 
       SuperscriptBox["z", 
        RowBox[{"-", "1"}]]}]}], "]"}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Extended example with autocorrelated trades (Chapter 9)", "Section",
 CellTags->"c:116"],

Cell[CellGroupData[{

Cell["Structural Model (Section 9.2)", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["q", "Rule"], "=", 
   RowBox[{
    SubscriptBox["q", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["v", "t"], "+", 
     RowBox[{"\[Beta]", " ", 
      SubscriptBox["v", 
       RowBox[{"t", "-", "1"}]]}]}]}]}], ";", " ", 
  RowBox[{
   SubscriptBox["m", "Rule"], "=", 
   RowBox[{
    SubscriptBox["m", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", 
      RowBox[{"t", "-", "1"}]], "+", 
     SubscriptBox["w", "t"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["w", "Rule"], "=", 
   RowBox[{
    SubscriptBox["w", "t_"], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"\[Lambda]", " ", 
      SubscriptBox["v", "t"]}], "+", 
     SubscriptBox["u", "t"]}]}]}], ";", " ", 
  RowBox[{
   SubscriptBox["p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["p", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", "t"], "+", 
     RowBox[{"c", " ", 
      SubscriptBox["q", "t"]}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"TableForm", " ", "@", " ", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["q", "Rule"], ",", " ", 
    SubscriptBox["m", "Rule"], ",", " ", 
    SubscriptBox["w", "Rule"], ",", " ", 
    SubscriptBox["p", "Rule"]}], "}"}]}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{
       SubscriptBox["q", "t_"], "\[RuleDelayed]", 
       RowBox[{
        SubscriptBox["v", "t"], "+", 
        RowBox[{"\[Beta]", " ", 
         SubscriptBox["v", 
          RowBox[{"t", "-", "1"}]]}]}]}]},
     {
      RowBox[{
       SubscriptBox["m", "t_"], "\[RuleDelayed]", 
       RowBox[{
        SubscriptBox["m", 
         RowBox[{"t", "-", "1"}]], "+", 
        SubscriptBox["w", "t"]}]}]},
     {
      RowBox[{
       SubscriptBox["w", "t_"], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"\[Lambda]", " ", 
         SubscriptBox["v", "t"]}], "+", 
        SubscriptBox["u", "t"]}]}]},
     {
      RowBox[{
       SubscriptBox["p", "t_"], "\[RuleDelayed]", 
       RowBox[{
        SubscriptBox["m", "t"], "+", 
        RowBox[{"c", " ", 
         SubscriptBox["q", "t"]}]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257416012*^9, 3.389630928302*^9, 
  3.389706866768224*^9, 3.3897170947408237`*^9, 3.3899920851345997`*^9, 
  3.3899921346496*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["\[CapitalDelta]p", "t_"], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          SubscriptBox["p", "t"], "/.", "\[InvisibleSpace]", 
          SubscriptBox["p", "Rule"]}], "/.", "\[InvisibleSpace]", 
         SubscriptBox["m", "Rule"]}], "/.", "\[InvisibleSpace]", 
        SubscriptBox["w", "Rule"]}], "/.", "\[InvisibleSpace]", 
       SubscriptBox["q", "Rule"]}], ")"}], "-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["p", 
         RowBox[{"t", "-", "1"}]], "/.", "\[InvisibleSpace]", 
        SubscriptBox["p", "Rule"]}], "/.", "\[InvisibleSpace]", 
       SubscriptBox["q", "Rule"]}], ")"}]}]}]}], ";", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    SubscriptBox["\[CapitalDelta]p", "t"], "/.", "\[InvisibleSpace]", 
    SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubscriptBox["u", "t"], "-", 
  RowBox[{"c", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"\[Beta]", " ", 
      SubscriptBox["v", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "t"}]]}], "+", 
     SubscriptBox["v", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "t"}]]}], ")"}]}], "+", 
  RowBox[{"\[Lambda]", " ", 
   SubscriptBox["v", "t"]}], "+", 
  RowBox[{"c", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"\[Beta]", " ", 
      SubscriptBox["v", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "t"}]]}], "+", 
     SubscriptBox["v", "t"]}], ")"}]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257416521997`*^9, 3.3896309283710003`*^9, 
  3.389706866835224*^9, 3.389717094803824*^9, 3.3899920852676*^9, 
  3.3899921347176*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nValues", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Sigma]", "v", "2"], "\[Rule]", ".8738"}], ",", " ", 
    
    RowBox[{"\[Beta]", "\[Rule]", "0.381"}], ",", " ", 
    RowBox[{"c", "\[Rule]", "1"}], ",", " ", 
    RowBox[{"\[Lambda]", "\[Rule]", "2"}]}], "}"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "v", "2"], "\[Rule]", "0.8738`"}], ",", 
   RowBox[{"\[Beta]", "\[Rule]", "0.381`"}], ",", 
   RowBox[{"c", "\[Rule]", "1"}], ",", 
   RowBox[{"\[Lambda]", "\[Rule]", "2"}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257416842003`*^9, 3.389630928433*^9, 
  3.389706866879224*^9, 3.389717094854824*^9, 3.3899920853356*^9, 
  3.3899921347736*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["VMA (not normalized) ", "Subsubsection"],

Cell[TextData[{
 "The coefficients of current and lagged ",
 Cell[BoxData[
  SubscriptBox["v", "t"]]],
 " in ",
 Cell[BoxData[
  SubscriptBox["\[CapitalDelta]p", "t"]]],
 " may be tabulated as:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Coefficient", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[CapitalDelta]p", "t"], "/.", 
      SubscriptBox["\[CapitalDelta]p", "Rule"]}], ",", 
     SubscriptBox["v", 
      RowBox[{"t", "-", "#"}]]}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"0", ",", "1", ",", "2"}], "}"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"c", "+", "\[Lambda]"}], ",", 
   RowBox[{
    RowBox[{"-", "c"}], "+", 
    RowBox[{"c", " ", "\[Beta]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "c"}], " ", "\[Beta]"}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257417172003`*^9, 3.389630928481*^9, 
  3.389706866924224*^9, 3.389717094899824*^9, 3.3899920854006*^9, 
  3.3899921348286*^9}]
}, Closed]],

Cell[TextData[{
 "This enables us to write: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", GridBox[{
      {
       SubscriptBox["\[CapitalDelta]p", "t"]},
      {
       SubscriptBox["q", "t"]}
     }], ")"}], "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["B", "0"], 
     RowBox[{"(", GridBox[{
        {
         SubscriptBox["u", "t"]},
        {
         SubscriptBox["v", "t"]}
       }], ")"}]}], "+", 
    RowBox[{
     SubscriptBox["B", "1"], 
     RowBox[{"(", GridBox[{
        {
         SubscriptBox["u", 
          RowBox[{"t", "-", "1"}]]},
        {
         SubscriptBox["v", 
          RowBox[{"t", "-", "1"}]]}
       }], ")"}]}], "+", 
    RowBox[{
     SubscriptBox["B", "2"], 
     RowBox[{"(", GridBox[{
        {
         SubscriptBox["u", 
          RowBox[{"t", "-", "2"}]]},
        {
         SubscriptBox["v", 
          RowBox[{"t", "-", "2"}]]}
       }], ")"}]}]}]}]]],
 " where"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["B", "Rules"], " ", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["B", "0"], "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"\[Lambda]", "+", "c"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", " ", 
     RowBox[{
      SubscriptBox["B", "1"], "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"c", 
           RowBox[{"(", 
            RowBox[{"\[Beta]", "-", "1"}], ")"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "\[Beta]"}], "}"}]}], "}"}]}], ",", 
     RowBox[{
      SubscriptBox["B", "2"], "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{
           RowBox[{"-", "c"}], " ", "\[Beta]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"{", 
  RowBox[{"Map", "[", 
   RowBox[{"MatrixForm", ",", 
    SubscriptBox["B", "Rules"], ",", 
    RowBox[{"{", "2", "}"}]}], "]"}], "}"}]}], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3897069017422237`*^9, 3.389706903411224*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     TagBox[
      SubscriptBox["B", "0"],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]], "\[Rule]", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"1", 
          RowBox[{"c", "+", "\[Lambda]"}]},
         {"0", "1"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}], ",", 
    RowBox[{
     TagBox[
      SubscriptBox["B", "1"],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]], "\[Rule]", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0", 
          RowBox[{"c", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "\[Beta]"}], ")"}]}]},
         {"0", "\[Beta]"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}], ",", 
    RowBox[{
     TagBox[
      SubscriptBox["B", "2"],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]], "\[Rule]", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0", 
          RowBox[{
           RowBox[{"-", "c"}], " ", "\[Beta]"}]},
         {"0", "0"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}]}], "}"}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257417672*^9, 3.389630928538*^9, 
  3.389706866982224*^9, 3.389706904184224*^9, 3.389717094952824*^9, 
  3.3899920854756002`*^9, 3.3899921348996*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
VMA (normalized so that the coefficient of the leading disturbance is the \
identity matrix)\
\>", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"B0i", "=", 
    RowBox[{"Inverse", "[", 
     RowBox[{
      SubscriptBox["B", "0"], "/.", 
      SubscriptBox["B", "Rules"]}], "]"}]}], ")"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", 
      RowBox[{
       RowBox[{"-", "c"}], "-", "\[Lambda]"}]},
     {"0", "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257418171997`*^9, 3.389630928586*^9, 
  3.389706867038224*^9, 3.389717094998824*^9, 3.3899920855376*^9, 
  3.3899921349546003`*^9}]
}, Closed]],

Cell["Coefficients:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["\[Theta]", "Rules"], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Theta]", "i"], "\[Rule]", 
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["B", "i"], "/.", 
          SubscriptBox["B", "Rules"]}], ")"}], ".", "B0i"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "2"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"{", 
  RowBox[{"Map", "[", 
   RowBox[{"MatrixForm", ",", "  ", 
    SubscriptBox["\[Theta]", "Rules"], ",", "2"}], "]"}], "}"}]}], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389706927712224*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    TagBox[
     RowBox[{
      TagBox[
       SubscriptBox["\[Theta]", "0"],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], "\[Rule]", 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"1", "0"},
          {"0", "1"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]]}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]], ",", 
    TagBox[
     RowBox[{
      TagBox[
       SubscriptBox["\[Theta]", "1"],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], "\[Rule]", 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", 
           RowBox[{"c", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Beta]"}], ")"}]}]},
          {"0", "\[Beta]"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]]}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]], ",", 
    TagBox[
     RowBox[{
      TagBox[
       SubscriptBox["\[Theta]", "2"],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], "\[Rule]", 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"0", 
           RowBox[{
            RowBox[{"-", "c"}], " ", "\[Beta]"}]},
          {"0", "0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]]}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}], "}"}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257418682003`*^9, 3.389630928639*^9, 
  3.389706867099224*^9, 3.389706928387224*^9, 3.389717095052824*^9, 
  3.3899920856106*^9, 3.3899921350256*^9}]
}, Closed]],

Cell[TextData[{
 "NOTE: There is a typo in the first printing of the book. The correct \
expression for ",
 Cell[BoxData[
  SubscriptBox["\[Theta]", "1"]]],
 " is the one given above."
}], "Text",
 CellChangeTimes->{{3.3897047953482237`*^9, 3.389704798566224*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Theta]", "[", "L_", "]"}], ":=", 
   RowBox[{
    SubscriptBox["\[Theta]", "0"], "+", 
    RowBox[{
     SubscriptBox["\[Theta]", "1"], "L"}], " ", "+", 
    RowBox[{
     SubscriptBox["\[Theta]", "2"], 
     SuperscriptBox["L", "2"]}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell["Disturbances:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["\[Epsilon]", "Rule"], "=", 
   RowBox[{
    SubscriptBox["\[Epsilon]", "t_"], "\[RuleDelayed]", 
    RowBox[{"Evaluate", "[", 
     RowBox[{
      RowBox[{
       SubscriptBox["B", "0"], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          SubscriptBox["u", "t"], "}"}], ",", 
         RowBox[{"{", 
          SubscriptBox["v", "t"], "}"}]}], "}"}]}], "/.", 
      SubscriptBox["B", "Rules"]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Map", "[", 
  RowBox[{"MatrixForm", ",", "  ", 
   SubscriptBox["\[Epsilon]", "Rule"], ",", "1"}], "]"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  TagBox[
   SubscriptBox["\[Epsilon]", "t_"],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], "\[RuleDelayed]", 
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       RowBox[{
        SubscriptBox["u", "t"], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"c", "+", "\[Lambda]"}], ")"}], " ", 
         SubscriptBox["v", "t"]}]}]},
      {
       SubscriptBox["v", "t"]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257419231997`*^9, 3.3896309286949997`*^9, 
  3.389706867158224*^9, 3.389717095108824*^9, 3.3899920856886*^9, 
  3.3899921351036*^9}]
}, Closed]],

Cell["Covariance matrix:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalOmega]", "Rule"], "=", 
   RowBox[{
    RowBox[{"\[CapitalOmega]", "\[Rule]", 
     RowBox[{
      RowBox[{"Simplify", " ", "/@", " ", 
       SubscriptBox["B", "0"]}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubsuperscriptBox["\[Sigma]", "u", "2"], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          SubsuperscriptBox["\[Sigma]", "v", "2"]}], "}"}]}], "}"}], ".", 
      RowBox[{"Transpose", "[", 
       SubscriptBox["B", "0"], "]"}]}]}], "/.", 
    SubscriptBox["B", "Rules"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalOmega]", "/.", 
   SubscriptBox["\[CapitalOmega]", "Rule"]}], "//", "MatrixForm"}]}], "Input",\

 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", "\[Lambda]"}], ")"}], "2"], " ", 
        SubsuperscriptBox["\[Sigma]", "v", "2"]}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", "\[Lambda]"}], ")"}], " ", 
       SubsuperscriptBox["\[Sigma]", "v", "2"]}]},
     {
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", "\[Lambda]"}], ")"}], " ", 
       SubsuperscriptBox["\[Sigma]", "v", "2"]}], 
      SubsuperscriptBox["\[Sigma]", "v", "2"]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257419832*^9, 3.389630928763*^9, 
  3.389706867210224*^9, 3.389717095167824*^9, 3.3899920857646*^9, 
  3.3899921351716003`*^9}]
}, Closed]],

Cell["Random walk variance is in the upper left hand corner of", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\[Theta]", "[", "1", "]"}], ".", "\[CapitalOmega]", ".", 
       RowBox[{"Transpose", "[", 
        RowBox[{"\[Theta]", "[", "1", "]"}], "]"}]}], ")"}], "/.", 
     SubscriptBox["\[CapitalOmega]", "Rule"]}], "/.", 
    SubscriptBox["\[Theta]", "Rules"]}], "//", "Simplify"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
       RowBox[{
        SuperscriptBox["\[Lambda]", "2"], " ", 
        SubsuperscriptBox["\[Sigma]", "v", "2"]}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", "\[Lambda]", " ", 
       SubsuperscriptBox["\[Sigma]", "v", "2"]}]},
     {
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", "\[Lambda]", " ", 
       SubsuperscriptBox["\[Sigma]", "v", "2"]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Beta]"}], ")"}], "2"], " ", 
       SubsuperscriptBox["\[Sigma]", "v", "2"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257420341997`*^9, 3.389630928811*^9, 
  3.389706867258224*^9, 3.389717095218824*^9, 3.3899920858366003`*^9, 
  3.3899921352186003`*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["VAR:", "Subsubsection"],

Cell[TextData[{
 "Starting from the VMA ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", GridBox[{
      {
       SubscriptBox["\[CapitalDelta]p", "t"]},
      {
       SubscriptBox["q", "t"]}
     }], ")"}], "=", 
   RowBox[{"\[Theta]", 
    RowBox[{"(", "L", ")"}], 
    SubscriptBox["\[Epsilon]", "t"]}]}]]],
 ", compute the VAR by inversion, i.e., ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"\[Theta]", 
    SuperscriptBox[
     RowBox[{"(", "L", ")"}], 
     RowBox[{"-", "1"}]], 
    RowBox[{"(", GridBox[{
       {
        SubscriptBox["\[CapitalDelta]p", "t"]},
       {
        SubscriptBox["q", "t"]}
      }], ")"}]}], "=", 
   SubscriptBox["\[Epsilon]", "t"]}]]],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Theta]Inv", "=", 
   RowBox[{
    RowBox[{"Inverse", "[", 
     RowBox[{
      RowBox[{"\[Theta]", "[", "L", "]"}], "/.", 
      SubscriptBox["\[Theta]", "Rules"]}], "]"}], "//", "Simplify"}]}], ";", 
  RowBox[{"\[Theta]Inv", " ", "//", "MatrixForm"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", 
      FractionBox[
       RowBox[{"c", " ", "L", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", "\[Beta]"}]}], 
         ")"}]}], 
       RowBox[{"1", "+", 
        RowBox[{"L", " ", "\[Beta]"}]}]]},
     {"0", 
      FractionBox["1", 
       RowBox[{"1", "+", 
        RowBox[{"L", " ", "\[Beta]"}]}]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257420922003`*^9, 3.389630928866*^9, 
  3.389706867318224*^9, 3.389717095274824*^9, 3.3899920859116*^9, 
  3.3899921352896*^9}]
}, Closed]],

Cell["Series expansion to the fourth order:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"s", "=", 
   RowBox[{"Series", " ", "[", 
    RowBox[{"\[Theta]Inv", ",", 
     RowBox[{"{", 
      RowBox[{"L", ",", "0", ",", "4"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"s", "//", "MatrixForm"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", 
      InterpretationBox[
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"c", "-", 
           RowBox[{"c", " ", "\[Beta]"}]}], ")"}], " ", "L"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["\[Beta]", "2"], " ", 
         SuperscriptBox["L", "2"]}], "-", 
        RowBox[{"c", " ", 
         SuperscriptBox["\[Beta]", "3"], " ", 
         SuperscriptBox["L", "3"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["\[Beta]", "4"], " ", 
         SuperscriptBox["L", "4"]}], "+", 
        InterpretationBox[
         SuperscriptBox[
          RowBox[{"O", "[", "L", "]"}], "5"],
         SeriesData[$CellContext`L, 0, {}, 1, 5, 1],
         Editable->False]}],
       SeriesData[$CellContext`L, 
        0, {$CellContext`c - $CellContext`c $CellContext`\[Beta], \
$CellContext`c $CellContext`\[Beta]^2, -$CellContext`c \
$CellContext`\[Beta]^3, $CellContext`c $CellContext`\[Beta]^4}, 1, 5, 1],
       Editable->False]},
     {"0", 
      InterpretationBox[
       RowBox[{"1", "-", 
        RowBox[{"\[Beta]", " ", "L"}], "+", 
        RowBox[{
         SuperscriptBox["\[Beta]", "2"], " ", 
         SuperscriptBox["L", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["\[Beta]", "3"], " ", 
         SuperscriptBox["L", "3"]}], "+", 
        RowBox[{
         SuperscriptBox["\[Beta]", "4"], " ", 
         SuperscriptBox["L", "4"]}], "+", 
        InterpretationBox[
         SuperscriptBox[
          RowBox[{"O", "[", "L", "]"}], "5"],
         SeriesData[$CellContext`L, 0, {}, 0, 5, 1],
         Editable->False]}],
       SeriesData[$CellContext`L, 0, {
        1, -$CellContext`\[Beta], $CellContext`\[Beta]^2, -$CellContext`\
\[Beta]^3, $CellContext`\[Beta]^4}, 0, 5, 1],
       Editable->False]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257422542*^9, 3.389630928953*^9, 
  3.389706867529224*^9, 3.389717095361824*^9, 3.3899920860306*^9, 
  3.3899921354126*^9}]
}, Closed]],

Cell["\<\

 Rules for VAR coefficient matrices:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["\[CurlyPhi]", "Rules"], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[CurlyPhi]", "i"], "\[Rule]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"Coefficient", "[", 
          RowBox[{"#", ",", "L", ",", "i"}], "]"}], "&"}], " ", "/@", " ", 
        RowBox[{"Normal", "[", "s", "]"}]}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "4"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"{", 
  RowBox[{"Map", "[", 
   RowBox[{"MatrixForm", ",", 
    SubscriptBox["\[CurlyPhi]", "Rules"], ",", 
    RowBox[{"{", "2", "}"}]}], "]"}], "}"}]}], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389706952018224*^9, 3.389706953759224*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     TagBox[
      SubscriptBox["\[CurlyPhi]", "0"],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]], "\[Rule]", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"1", "0"},
         {"0", "1"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}], ",", 
    RowBox[{
     TagBox[
      SubscriptBox["\[CurlyPhi]", "1"],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]], "\[Rule]", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0", 
          RowBox[{"c", "-", 
           RowBox[{"c", " ", "\[Beta]"}]}]},
         {"0", 
          RowBox[{"-", "\[Beta]"}]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}], ",", 
    RowBox[{
     TagBox[
      SubscriptBox["\[CurlyPhi]", "2"],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]], "\[Rule]", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0", 
          RowBox[{"c", " ", 
           SuperscriptBox["\[Beta]", "2"]}]},
         {"0", 
          SuperscriptBox["\[Beta]", "2"]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}], ",", 
    RowBox[{
     TagBox[
      SubscriptBox["\[CurlyPhi]", "3"],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]], "\[Rule]", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0", 
          RowBox[{
           RowBox[{"-", "c"}], " ", 
           SuperscriptBox["\[Beta]", "3"]}]},
         {"0", 
          RowBox[{"-", 
           SuperscriptBox["\[Beta]", "3"]}]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}], ",", 
    RowBox[{
     TagBox[
      SubscriptBox["\[CurlyPhi]", "4"],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]], "\[Rule]", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0", 
          RowBox[{"c", " ", 
           SuperscriptBox["\[Beta]", "4"]}]},
         {"0", 
          SuperscriptBox["\[Beta]", "4"]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}]}], "}"}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257423212*^9, 3.38963092901*^9, 3.389706867599224*^9,
   3.3897069562892237`*^9, 3.389717095414824*^9, 3.3899920861336*^9, 
  3.3899921354906*^9}]
}, Closed]],

Cell[TextData[{
 "This VAR is of the form ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"I", "+", 
       RowBox[{
        SubscriptBox["\[CurlyPhi]", "1"], "L"}], "+", 
       RowBox[{
        SubscriptBox["\[CurlyPhi]", "2"], 
        SuperscriptBox["L", "2"]}], "+"}], "..."}], ")"}], 
    RowBox[{"(", GridBox[{
       {
        SubscriptBox["\[CapitalDelta]p", "t"]},
       {
        SubscriptBox["q", "t"]}
      }], ")"}]}], "=", 
   SubscriptBox["\[Epsilon]", "t"]}]]],
 ". Alternatively, ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["y", "t"], "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["\[Phi]", "1"], 
       SubscriptBox["y", 
        RowBox[{"t", "-", "1"}]]}], "+", 
      RowBox[{
       SubscriptBox["\[Phi]", "2"], 
       SubscriptBox["y", 
        RowBox[{"t", "-", "2"}]]}], "+"}], "..."}], "+", 
    SubscriptBox["\[Epsilon]", "t"]}]}]]],
 " where ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["y", "t"], "\[Congruent]", 
   RowBox[{"(", GridBox[{
      {
       SubscriptBox["\[CapitalDelta]p", "t"]},
      {
       SubscriptBox["q", "t"]}
     }], ")"}]}]]],
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["\[Phi]", "Rules"], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["\[Phi]", "i"], "\[Rule]", 
       RowBox[{"-", 
        SubscriptBox["\[CurlyPhi]", "i"]}]}], "/.", 
      SubscriptBox["\[CurlyPhi]", "Rules"]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"{", 
  RowBox[{"Map", "[", 
   RowBox[{"MatrixForm", ",", 
    SubscriptBox["\[Phi]", "Rules"], ",", 
    RowBox[{"{", "2", "}"}]}], "]"}], "}"}]}], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389706973174224*^9, 3.3897069748192244`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     TagBox[
      SubscriptBox["\[Phi]", "1"],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]], "\[Rule]", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0", 
          RowBox[{
           RowBox[{"-", "c"}], "+", 
           RowBox[{"c", " ", "\[Beta]"}]}]},
         {"0", "\[Beta]"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}], ",", 
    RowBox[{
     TagBox[
      SubscriptBox["\[Phi]", "2"],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]], "\[Rule]", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0", 
          RowBox[{
           RowBox[{"-", "c"}], " ", 
           SuperscriptBox["\[Beta]", "2"]}]},
         {"0", 
          RowBox[{"-", 
           SuperscriptBox["\[Beta]", "2"]}]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}], ",", 
    RowBox[{
     TagBox[
      SubscriptBox["\[Phi]", "3"],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]], "\[Rule]", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0", 
          RowBox[{"c", " ", 
           SuperscriptBox["\[Beta]", "3"]}]},
         {"0", 
          SuperscriptBox["\[Beta]", "3"]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}], ",", 
    RowBox[{
     TagBox[
      SubscriptBox["\[Phi]", "4"],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]], "\[Rule]", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0", 
          RowBox[{
           RowBox[{"-", "c"}], " ", 
           SuperscriptBox["\[Beta]", "4"]}]},
         {"0", 
          RowBox[{"-", 
           SuperscriptBox["\[Beta]", "4"]}]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}]}], "}"}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257423852*^9, 3.389630929074*^9, 
  3.389706867667224*^9, 3.389706975442224*^9, 3.389717095477824*^9, 
  3.3899920862106*^9, 3.3899921355566*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Map", "[", 
   RowBox[{"MatrixForm", ",", 
    RowBox[{
     SubscriptBox["\[Phi]", "Rules"], "/.", "nValues"}], ",", 
    RowBox[{"{", "2", "}"}]}], "]"}], "}"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389706985655224*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     TagBox[
      SubscriptBox["\[Phi]", "1"],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]], "\[Rule]", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0", 
          RowBox[{"-", "0.619`"}]},
         {"0", "0.381`"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}], ",", 
    RowBox[{
     TagBox[
      SubscriptBox["\[Phi]", "2"],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]], "\[Rule]", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0", 
          RowBox[{"-", "0.145161`"}]},
         {"0", 
          RowBox[{"-", "0.145161`"}]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}], ",", 
    RowBox[{
     TagBox[
      SubscriptBox["\[Phi]", "3"],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]], "\[Rule]", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0", "0.055306341`"},
         {"0", "0.055306341`"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}], ",", 
    RowBox[{
     TagBox[
      SubscriptBox["\[Phi]", "4"],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]], "\[Rule]", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0", 
          RowBox[{"-", "0.021071715921`"}]},
         {"0", 
          RowBox[{"-", "0.021071715921`"}]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}]}], "}"}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257424432*^9, 3.389630929132*^9, 
  3.389706867724224*^9, 3.389706986042224*^9, 3.389717095540824*^9, 
  3.3899920863375998`*^9, 3.3899921356146*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Impulse response functions", "Subsubsection"],

Cell["\<\
The VAR is of infinite order. We'll only be looking at the leading four \
terms:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["VAR", "Rule"], "=", 
   RowBox[{
    SubscriptBox["y", "t_"], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"k", "=", "1"}], "4"], 
      RowBox[{
       SubscriptBox["\[Phi]", "k"], ".", 
       SubscriptBox["y", 
        RowBox[{"t", "-", "k"}]]}]}], "+", 
     SubscriptBox["\[Epsilon]", "t"]}]}]}], ";", " ", 
  RowBox[{
   SubscriptBox["y", "t"], "/.", 
   SubscriptBox["VAR", "Rule"]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Phi]", "1"], ".", 
   SubscriptBox["y", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "t"}]]}], "+", 
  RowBox[{
   SubscriptBox["\[Phi]", "2"], ".", 
   SubscriptBox["y", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "t"}]]}], "+", 
  RowBox[{
   SubscriptBox["\[Phi]", "3"], ".", 
   SubscriptBox["y", 
    RowBox[{
     RowBox[{"-", "3"}], "+", "t"}]]}], "+", 
  RowBox[{
   SubscriptBox["\[Phi]", "4"], ".", 
   SubscriptBox["y", 
    RowBox[{
     RowBox[{"-", "4"}], "+", "t"}]]}], "+", 
  SubscriptBox["\[Epsilon]", "t"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257424962*^9, 3.38963092919*^9, 3.389706867779224*^9,
   3.3897170956038237`*^9, 3.3899920864046*^9, 3.3899921356786003`*^9}]
}, Closed]],

Cell[TextData[{
 "(The \".\" indicates matrix multiplication.) \nThe following rules set ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Epsilon]", "t"], "=", "0"}]]],
 " for ",
 Cell[BoxData[
  RowBox[{"t", "\[NotEqual]", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["y", "t"], "=", "0"}]]],
 " for ",
 Cell[BoxData[
  RowBox[{"t", "<", "0"}]]],
 ", and zero out matrix products involving zero."
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["Cleanup", "Rules"], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["y", "0"], "\[Rule]", 
      SubscriptBox["\[Epsilon]", "0"]}], ",", 
     RowBox[{
      SubscriptBox["y", "k_"], "\[RuleDelayed]", 
      RowBox[{"0", "/;", 
       RowBox[{"k", "<", "0"}]}]}], ",", 
     RowBox[{
      SubscriptBox["\[Epsilon]", "k_"], "\[RuleDelayed]", 
      RowBox[{"0", "/;", 
       RowBox[{"k", "\[NotEqual]", "0"}]}]}], ",", 
     RowBox[{
      RowBox[{"Dot", "[", 
       RowBox[{"_", ",", "0"}], "]"}], "\[RuleDelayed]", " ", "0"}]}], 
    "}"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "Subsequent to an initial disturbance of ",
 Cell[BoxData[
  SubscriptBox["\[Epsilon]", "0"]]],
 ", the initial realization of ",
 Cell[BoxData["y"]],
 " is:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["y", "0"], "//.", 
  SubscriptBox["Cleanup", "Rules"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 SubscriptBox["\[Epsilon]", "0"]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257425542*^9, 3.389630929249*^9, 
  3.389706867847224*^9, 3.3897170956698236`*^9, 3.3899920864806004`*^9, 
  3.3899921357436*^9}]
}, Closed]],

Cell["One period later ...", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["y", "1"], "/.", 
   SubscriptBox["VAR", "Rule"]}], "//.", 
  SubscriptBox["Cleanup", "Rules"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Phi]", "1"], ".", 
  SubscriptBox["\[Epsilon]", "0"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257425942*^9, 3.389630929289*^9, 
  3.389706867886224*^9, 3.389717095712824*^9, 3.3899920865425997`*^9, 
  3.3899921357936*^9}]
}, Closed]],

Cell["Two periods later ...", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SubscriptBox["y", "2"], "/.", 
    SubscriptBox["VAR", "Rule"]}], "/.", 
   SubscriptBox["VAR", "Rule"]}], "//.", 
  SubscriptBox["Cleanup", "Rules"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Phi]", "2"], ".", 
   SubscriptBox["\[Epsilon]", "0"]}], "+", 
  RowBox[{
   SubscriptBox["\[Phi]", "1"], ".", 
   SubscriptBox["\[Phi]", "1"], ".", 
   SubscriptBox["\[Epsilon]", "0"]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257426302*^9, 3.389630929324*^9, 
  3.389706867924224*^9, 3.389717095755824*^9, 3.3899920866036*^9, 
  3.3899921358526*^9}]
}, Closed]],

Cell["\<\
The following rule obtains the impulse response function by automating the \
recursion\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Psi]", "Rule"], "=", 
   RowBox[{
    SubscriptBox["\[Psi]", "t_"], "\[RuleDelayed]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"FixedPoint", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"#", "/.", 
          SubscriptBox["VAR", "Rule"]}], "&"}], ",", 
        SubscriptBox["y", "t"], ",", "t"}], "]"}], "//.", 
      SubscriptBox["Cleanup", "Rules"]}], ")"}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Psi]", "2"], "/.", 
  SubscriptBox["\[Psi]", "Rule"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Phi]", "2"], ".", 
   SubscriptBox["\[Epsilon]", "0"]}], "+", 
  RowBox[{
   SubscriptBox["\[Phi]", "1"], ".", 
   SubscriptBox["\[Phi]", "1"], ".", 
   SubscriptBox["\[Epsilon]", "0"]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257426842003`*^9, 3.389630929377*^9, 
  3.389706867968224*^9, 3.389717095818824*^9, 3.3899920866786003`*^9, 
  3.3899921359196*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["\[Psi]", "2"], "/.", 
     SubscriptBox["\[Psi]", "Rule"]}], "/.", 
    SubscriptBox["\[Phi]", "Rules"]}], "/.", 
   SubscriptBox["\[Epsilon]", "Rule"]}], "//", "Simplify"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "c"}], " ", "\[Beta]", " ", 
     SubscriptBox["v", "0"]}], "}"}], ",", 
   RowBox[{"{", "0", "}"}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257427212*^9, 3.389630929413*^9, 
  3.3897068680102243`*^9, 3.3897170958658237`*^9, 3.3899920867436*^9, 
  3.3899921359666*^9}]
}, Closed]],

Cell["The cumulative IR function is:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalPsi]", "Rule"], "=", 
   RowBox[{
    SubscriptBox["\[CapitalPsi]", "t_"], "\[RuleDelayed]", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"i", "=", "0"}], "t"], 
     SubscriptBox["\[Psi]", "i"]}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "If we substitute in the \"correct\" structural specification for ",
 Cell[BoxData[
  SubscriptBox["\[Epsilon]", "0"]]],
 ", we get the \"correct\" long-run price change."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["\[CapitalPsi]", "2"], "/.", 
       SubscriptBox["\[CapitalPsi]", "Rule"]}], "/.", 
      SubscriptBox["\[Psi]", "Rule"]}], "/.", 
     SubscriptBox["\[Phi]", "Rules"]}], "/.", 
    SubscriptBox["\[Epsilon]", "Rule"]}], "//", "Simplify"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       SubscriptBox["u", "0"], "+", 
       RowBox[{"\[Lambda]", " ", 
        SubscriptBox["v", "0"]}]}]},
     {
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
       SubscriptBox["v", "0"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257427672*^9, 3.3896309294630003`*^9, 
  3.3897068680642242`*^9, 3.389717095920824*^9, 3.3899920868216*^9, 
  3.3899921360495996`*^9}]
}, Closed]],

Cell[TextData[{
 "In practice, we can't identify ",
 Cell[BoxData[
  SubscriptBox["u", "0"]]],
 " and ",
 Cell[BoxData[
  SubscriptBox["v", "0"]]],
 ", we we're left with:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Epsilon]Statistical", "Rule"], "=", 
   RowBox[{
    SubscriptBox["\[Epsilon]", "t_"], "\[RuleDelayed]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       SubscriptBox["\[Epsilon]", 
        RowBox[{"\[CapitalDelta]p", ",", "t"}]], "}"}], ",", 
      RowBox[{"{", 
       SubscriptBox["\[Epsilon]", 
        RowBox[{"q", ",", "t"}]], "}"}]}], "}"}]}]}], ";", " ", 
  RowBox[{
   RowBox[{
    SubscriptBox["\[Epsilon]", "0"], "/.", 
    SubscriptBox["\[Epsilon]Statistical", "Rule"]}], "//", 
   "MatrixForm"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SubscriptBox["\[Epsilon]", 
       RowBox[{"\[CapitalDelta]p", ",", "0"}]]},
     {
      SubscriptBox["\[Epsilon]", 
       RowBox[{"q", ",", "0"}]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257428142*^9, 3.389630929508*^9, 
  3.389706868115224*^9, 3.389717095968824*^9, 3.3899920868906*^9, 
  3.3899921361205997`*^9}]
}, Closed]],

Cell["And the cumulative impluse response function becomes:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["\[CapitalPsi]", "2"], "/.", 
       SubscriptBox["\[CapitalPsi]", "Rule"]}], "/.", 
      SubscriptBox["\[Psi]", "Rule"]}], "/.", 
     SubscriptBox["\[Phi]", "Rules"]}], "/.", 
    SubscriptBox["\[Epsilon]Statistical", "Rule"]}], "//", "Simplify"}], "//",
   "MatrixForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{
        RowBox[{"-", "c"}], " ", 
        SubscriptBox["\[Epsilon]", 
         RowBox[{"q", ",", "0"}]]}], "+", 
       SubscriptBox["\[Epsilon]", 
        RowBox[{"\[CapitalDelta]p", ",", "0"}]]}]},
     {
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
       SubscriptBox["\[Epsilon]", 
        RowBox[{"q", ",", "0"}]]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257428532*^9, 3.38963092955*^9, 3.389706868159224*^9,
   3.389717096021824*^9, 3.3899920869546003`*^9, 3.3899921361776*^9}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Contemporaneous effects and Cholesky decompositions (Section 9.4)\
\>", "Subsection"],

Cell[TextData[{
 "A note on notation and conventions. For a symmetric positive definite \
matrix ",
 Cell[BoxData["V"]],
 ", the Cholesky decomposition is usually expressed as ",
 Cell[BoxData[
  RowBox[{"V", "=", 
   RowBox[{"L", " ", 
    SuperscriptBox["L", "\[Prime]"]}]}]]],
 " where ",
 Cell[BoxData["L"]],
 " is lower triangular. In some references, though, and in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", the convention is ",
 Cell[BoxData[
  RowBox[{"V", "=", 
   RowBox[{
    SuperscriptBox["U", "\[Prime]"], "U"}]}]]],
 " where ",
 Cell[BoxData["U"]],
 " is upper triangular. The book follows the latter (",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ") convention."
}], "Text"],

Cell[TextData[{
 "As an example, here's a ",
 Cell[BoxData[
  RowBox[{"2", "x2"}]]],
 " covariance matrix"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"V", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "1", "2"], ",", 
       SubscriptBox["\[Sigma]", "12"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", "12"], ",", 
       SubsuperscriptBox["\[Sigma]", "2", "2"]}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"V", "//", "MatrixForm"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SubsuperscriptBox["\[Sigma]", "1", "2"], 
      SubscriptBox["\[Sigma]", "12"]},
     {
      SubscriptBox["\[Sigma]", "12"], 
      SubsuperscriptBox["\[Sigma]", "2", "2"]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257627841997`*^9, 3.3896309295950003`*^9, 
  3.3897068682092237`*^9, 3.389717096075824*^9, 3.3899920870266*^9, 
  3.3899921362426*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"F", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"CholeskyDecomposition", "[", "V", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "1", "2"], ">", "0"}], ",", 
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "2", "2"], ">", "0"}], ",", 
       RowBox[{
        RowBox[{"-", 
         SqrtBox[
          RowBox[{
           SubsuperscriptBox["\[Sigma]", "1", "2"], 
           SubsuperscriptBox["\[Sigma]", "2", "2"]}]]}], "<", 
        SubscriptBox["\[Sigma]", "12"], "<", 
        SqrtBox[
         RowBox[{
          SubsuperscriptBox["\[Sigma]", "1", "2"], 
          SubsuperscriptBox["\[Sigma]", "2", "2"]}]]}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"F", "//", "MatrixForm"}]}], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896258103602*^9, 3.3896258296042*^9}, {
  3.3896309732720003`*^9, 3.3896309780889997`*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SqrtBox[
       SubsuperscriptBox["\[Sigma]", "1", "2"]], 
      FractionBox[
       SubscriptBox["\[Sigma]", "12"], 
       SqrtBox[
        SubsuperscriptBox["\[Sigma]", "1", "2"]]]},
     {"0", 
      SqrtBox[
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "2", "2"], "-", 
        FractionBox[
         SubsuperscriptBox["\[Sigma]", "12", "2"], 
         SubsuperscriptBox["\[Sigma]", "1", "2"]]}]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896258305942*^9, 3.389630929675*^9, 3.389630978666*^9, 
  3.389706868427224*^9, 3.389717096175824*^9, 3.3899920872316*^9, 
  3.3899921364086*^9}]
}, Closed]],

Cell["Verify that this recreates the original covariance matrix:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Transpose", "[", "F", "]"}], ".", "F"}], "//", "Simplify"}], "//",
   "MatrixForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SubsuperscriptBox["\[Sigma]", "1", "2"], 
      SubscriptBox["\[Sigma]", "12"]},
     {
      SubscriptBox["\[Sigma]", "12"], 
      SubsuperscriptBox["\[Sigma]", "2", "2"]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257630382*^9, 3.3896258426731997`*^9, 
  3.389630929725*^9, 3.3896309881619997`*^9, 3.389706868472224*^9, 
  3.3897170962208242`*^9, 3.3899920873136*^9, 3.3899921364866*^9}]
}, Closed]],

Cell["Here is the structural covariance matrix:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"MatrixForm", ",", 
   SubscriptBox["\[CapitalOmega]", "Rule"], ",", "1"}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  TagBox["\[CapitalOmega]",
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], "\[Rule]", 
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"c", "+", "\[Lambda]"}], ")"}], "2"], " ", 
         SubsuperscriptBox["\[Sigma]", "v", "2"]}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c", "+", "\[Lambda]"}], ")"}], " ", 
        SubsuperscriptBox["\[Sigma]", "v", "2"]}]},
      {
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c", "+", "\[Lambda]"}], ")"}], " ", 
        SubsuperscriptBox["\[Sigma]", "v", "2"]}], 
       SubsuperscriptBox["\[Sigma]", "v", "2"]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257630852003`*^9, 3.389630929763*^9, 
  3.389630990568*^9, 3.389706868520224*^9, 3.389717096269824*^9, 
  3.3899920873786*^9, 3.3899921365366*^9}]
}, Closed]],

Cell["Its Cholesky decomposition with price changes \"first\" is:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"F", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"CholeskyDecomposition", "[", 
      RowBox[{"\[CapitalOmega]", "/.", 
       SubscriptBox["\[CapitalOmega]", "Rule"]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"c", ">", "0"}], ",", 
       RowBox[{"\[Lambda]", ">", "0"}], ",", 
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "u", "2"], ">", "0"}], ",", 
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "v", "2"], ">", "0"}]}], "}"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Transpose", "[", "F", "]"}], "//", "MatrixForm"}]}], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896258531282*^9, 3.3896258567072*^9}, {
  3.3896309497650003`*^9, 3.389630960947*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SqrtBox[
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"c", "+", "\[Lambda]"}], ")"}], "2"], " ", 
         SubsuperscriptBox["\[Sigma]", "v", "2"]}]}]], "0"},
     {
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c", "+", "\[Lambda]"}], ")"}], " ", 
        SubsuperscriptBox["\[Sigma]", "v", "2"]}], 
       SqrtBox[
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"c", "+", "\[Lambda]"}], ")"}], "2"], " ", 
          SubsuperscriptBox["\[Sigma]", "v", "2"]}]}]]], 
      SqrtBox[
       FractionBox[
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
         SubsuperscriptBox["\[Sigma]", "v", "2"]}], 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"c", "+", "\[Lambda]"}], ")"}], "2"], " ", 
          SubsuperscriptBox["\[Sigma]", "v", "2"]}]}]]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257632651997`*^9, 3.3896258574802*^9, 
  3.389630929914*^9, 3.3896309617130003`*^9, 3.389630993796*^9, 
  3.389706868661224*^9, 3.389717096411824*^9, 3.3899920876586*^9, 
  3.3899921368066*^9}]
}, Closed]],

Cell[TextData[{
 "This implies that a one unit shock to ",
 Cell[BoxData[
  SubscriptBox["\[Epsilon]", 
   RowBox[{"\[CapitalDelta]p", ",", "t"}]]]],
 " will have a contemporaneous effect on trades. This is inconsistent with \
the structural model. If we compute the Cholesky decomposition with \
\"trades\" first (by permutation) we have:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"F", "=", 
   RowBox[{"Permute", "[", 
    RowBox[{
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"CholeskyDecomposition", "[", 
        RowBox[{"Permute", "[", 
         RowBox[{
          RowBox[{"\[CapitalOmega]", "/.", 
           SubscriptBox["\[CapitalOmega]", "Rule"]}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "1"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"c", ">", "0"}], ",", 
         RowBox[{"\[Lambda]", ">", "0"}], ",", 
         RowBox[{
          SubsuperscriptBox["\[Sigma]", "u", "2"], ">", "0"}], ",", 
         RowBox[{
          SubsuperscriptBox["\[Sigma]", "v", "2"], ">", "0"}]}], "}"}]}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}]}], "]"}]}], ";", 
  RowBox[{
   RowBox[{"Transpose", "[", "F", "]"}], "//", "MatrixForm"}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896258622572002`*^9, 3.3896258690542*^9}, {
  3.3896309978050003`*^9, 3.389631000549*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SqrtBox[
       SubsuperscriptBox["\[Sigma]", "u", "2"]], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", "\[Lambda]"}], ")"}], " ", 
       SqrtBox[
        SubsuperscriptBox["\[Sigma]", "v", "2"]]}]},
     {"0", 
      SqrtBox[
       SubsuperscriptBox["\[Sigma]", "v", "2"]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257633282003`*^9, 3.3896258701382*^9, 
  3.389630929975*^9, 3.3896310019300003`*^9, 3.389706868710224*^9, 
  3.3897170964648237`*^9, 3.3899920877326*^9, 3.3899921368705997`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Transpose", "[", "F", "]"}], ".", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "0", "}"}], ",", 
     RowBox[{"{", "1", "}"}]}], "}"}]}], "//", "MatrixForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", "\[Lambda]"}], ")"}], " ", 
       SqrtBox[
        SubsuperscriptBox["\[Sigma]", "v", "2"]]}]},
     {
      SqrtBox[
       SubsuperscriptBox["\[Sigma]", "v", "2"]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257633952*^9, 3.3896258739122*^9, 3.389630930014*^9, 
  3.3897068687492237`*^9, 3.389717096510824*^9, 3.3899920877986*^9, 
  3.3899921369216003`*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Random-walk variance", "Subsection"],

Cell[TextData[{
 "Starting from the VMA ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", GridBox[{
      {
       SubscriptBox["\[CapitalDelta]p", "t"]},
      {
       SubscriptBox["q", "t"]}
     }], ")"}], "=", 
   RowBox[{"\[Theta]", 
    RowBox[{"(", "L", ")"}], 
    SubscriptBox["\[Epsilon]", "t"]}]}]]],
 ", compute the VAR by inversion, i.e., ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"\[Theta]", 
    SuperscriptBox[
     RowBox[{"(", "L", ")"}], 
     RowBox[{"-", "1"}]], 
    RowBox[{"(", GridBox[{
       {
        SubscriptBox["\[CapitalDelta]p", "t"]},
       {
        SubscriptBox["q", "t"]}
      }], ")"}]}], "=", 
   SubscriptBox["\[Epsilon]", "t"]}]]],
 ":"
}], "Text"],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", GridBox[{
      {
       SubsuperscriptBox["\[Sigma]", "w", "2"], "..."},
      {"\[VerticalEllipsis]", "\[Placeholder]"}
     }], ")"}], "=", 
   RowBox[{"\[Theta]", 
    RowBox[{"(", "1", ")"}], "\[CapitalOmega]", " ", "\[Theta]", 
    RowBox[{
     RowBox[{"(", "1", ")"}], "'"}]}]}]]],
 "\n",
 Cell[BoxData["\[Theta]"]],
 " is identified (or get ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"\[Theta]", 
    RowBox[{"(", "1", ")"}]}], "=", 
   RowBox[{"\[CurlyPhi]", 
    SuperscriptBox[
     RowBox[{"(", "1", ")"}], 
     RowBox[{"-", "1"}]]}]}]]],
 ")."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"\[Theta]", "[", "1", "]"}], "/.", 
    SubscriptBox["\[Theta]", "Rules"]}], "//", "Simplify"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", 
      RowBox[{"-", "c"}]},
     {"0", 
      RowBox[{"1", "+", "\[Beta]"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257679662*^9, 3.3896258935452003`*^9, 
  3.3896309300699997`*^9, 3.389631019207*^9, 3.3897068687892237`*^9, 
  3.389717096558824*^9, 3.3899920878626003`*^9, 3.3899921369746*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", " ", 
       RowBox[{"-", "c"}]}], "}"}], "}"}], ".", 
    RowBox[{"(", 
     RowBox[{"\[CapitalOmega]", "/.", 
      SubscriptBox["\[CapitalOmega]", "Rule"]}], ")"}], ".", 
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1", ",", " ", 
        RowBox[{"-", "c"}]}], "}"}], "}"}], "]"}]}], "//", "Simplify"}], "//",
   "MatrixForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
       RowBox[{
        SuperscriptBox["\[Lambda]", "2"], " ", 
        SubsuperscriptBox["\[Sigma]", "v", "2"]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257680132*^9, 3.3896258935931997`*^9, 
  3.3896309301099997`*^9, 3.3896310192539997`*^9, 3.389706868832224*^9, 
  3.389717096605824*^9, 3.3899920879276*^9, 3.3899921370406*^9}]
}, Closed]],

Cell["\<\
In practice, we'd be working from an estimated covariance matrix:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", " ", 
       RowBox[{"-", "c"}]}], "}"}], "}"}], ".", "V", ".", 
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1", ",", " ", 
        RowBox[{"-", "c"}]}], "}"}], "}"}], "]"}]}], "//", "Simplify"}], "//",
   "MatrixForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "1", "2"], "+", 
       RowBox[{
        SuperscriptBox["c", "2"], " ", 
        SubsuperscriptBox["\[Sigma]", "2", "2"]}], "-", 
       RowBox[{"2", " ", "c", " ", 
        SubscriptBox["\[Sigma]", "12"]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257680542*^9, 3.3896258936322002`*^9, 
  3.389630930152*^9, 3.389631019304*^9, 3.3897068688732243`*^9, 
  3.3897170966548243`*^9, 3.3899920879946003`*^9, 3.3899921370996*^9}]
}, Closed]],

Cell["\<\
Resolve contemporaneous effects with Cholesky decompositions.\
\>", "Text"],

Cell[CellGroupData[{

Cell["\"Prices first\"", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"F", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"CholeskyDecomposition", "[", 
      RowBox[{"\[CapitalOmega]", "/.", 
       SubscriptBox["\[CapitalOmega]", "Rule"]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"c", ">", "0"}], ",", 
       RowBox[{"\[Lambda]", ">", "0"}], ",", 
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "u", "2"], ">", "0"}], ",", 
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "v", "2"], ">", "0"}]}], "}"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Transpose", "[", "F", "]"}], "//", "MatrixForm"}]}], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896258870572*^9, 3.3896258896851997`*^9}, {
  3.389631011135*^9, 3.389631015303*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SqrtBox[
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"c", "+", "\[Lambda]"}], ")"}], "2"], " ", 
         SubsuperscriptBox["\[Sigma]", "v", "2"]}]}]], "0"},
     {
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c", "+", "\[Lambda]"}], ")"}], " ", 
        SubsuperscriptBox["\[Sigma]", "v", "2"]}], 
       SqrtBox[
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"c", "+", "\[Lambda]"}], ")"}], "2"], " ", 
          SubsuperscriptBox["\[Sigma]", "v", "2"]}]}]]], 
      SqrtBox[
       FractionBox[
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
         SubsuperscriptBox["\[Sigma]", "v", "2"]}], 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"c", "+", "\[Lambda]"}], ")"}], "2"], " ", 
          SubsuperscriptBox["\[Sigma]", "v", "2"]}]}]]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257681122*^9, 3.3896258936772003`*^9, 
  3.389630930201*^9, 3.389631019369*^9, 3.3897068689392242`*^9, 
  3.389717096718824*^9, 3.3899920881076*^9, 3.3899921371876*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"First", " ", "@", " ", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1", ",", " ", 
        RowBox[{"-", "c"}]}], "}"}], "}"}]}], ".", 
    RowBox[{"Transpose", "[", "F", "]"}]}], "//", "Simplify"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
     RowBox[{"\[Lambda]", " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", "\[Lambda]"}], ")"}], " ", 
      SubsuperscriptBox["\[Sigma]", "v", "2"]}]}], 
    SqrtBox[
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", "+", "\[Lambda]"}], ")"}], "2"], " ", 
       SubsuperscriptBox["\[Sigma]", "v", "2"]}]}]]], ",", 
   RowBox[{
    RowBox[{"-", "c"}], " ", 
    SqrtBox[
     FractionBox[
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
       SubsuperscriptBox["\[Sigma]", "v", "2"]}], 
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", "\[Lambda]"}], ")"}], "2"], " ", 
        SubsuperscriptBox["\[Sigma]", "v", "2"]}]}]]]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257681792*^9, 3.3896258937212*^9, 3.389630930303*^9, 
  3.389631019428*^9, 3.389706869003224*^9, 3.389717096788824*^9, 
  3.3899920882326*^9, 3.3899921372925997`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", " ", "@@", " ", 
   RowBox[{"(", 
    RowBox[{"d", "^", "2"}], ")"}]}], "//", "Simplify"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
  RowBox[{
   SuperscriptBox["\[Lambda]", "2"], " ", 
   SubsuperscriptBox["\[Sigma]", "v", "2"]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896257682352*^9, 3.3896258937692003`*^9, 
  3.389630930381*^9, 3.38963101948*^9, 3.389706869045224*^9, 
  3.3897170968328238`*^9, 3.3899920883006*^9, 3.3899921373406*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Trades \"first\"", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"F", "=", 
   RowBox[{"Permute", "[", 
    RowBox[{
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"CholeskyDecomposition", "[", 
        RowBox[{"Permute", "[", 
         RowBox[{
          RowBox[{"\[CapitalOmega]", "/.", 
           SubscriptBox["\[CapitalOmega]", "Rule"]}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "1"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"c", ">", "0"}], ",", 
         RowBox[{"\[Lambda]", ">", "0"}], ",", 
         RowBox[{
          SubsuperscriptBox["\[Sigma]", "u", "2"], ">", "0"}], ",", 
         RowBox[{
          SubsuperscriptBox["\[Sigma]", "v", "2"], ">", "0"}]}], "}"}]}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}]}], "]"}]}], ";", 
  RowBox[{
   RowBox[{"Transpose", "[", "F", "]"}], "//", "MatrixForm"}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896258984852*^9, 3.3896259007771997`*^9}, {
  3.389631025097*^9, 3.389631028914*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SqrtBox[
       SubsuperscriptBox["\[Sigma]", "u", "2"]], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", "\[Lambda]"}], ")"}], " ", 
       SqrtBox[
        SubsuperscriptBox["\[Sigma]", "v", "2"]]}]},
     {"0", 
      SqrtBox[
       SubsuperscriptBox["\[Sigma]", "v", "2"]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896257682762003`*^9, {3.3896258938222*^9, 3.3896259015182*^9}, 
   3.389630930433*^9, {3.3896310195290003`*^9, 3.389631029651*^9}, 
   3.3897068690902243`*^9, 3.389717096893824*^9, 3.3899920883796*^9, 
   3.3899921373986*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"First", " ", "@", " ", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1", ",", " ", 
        RowBox[{"-", "c"}]}], "}"}], "}"}]}], ".", 
    RowBox[{"Transpose", "[", "F", "]"}]}], "//", "Simplify"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SqrtBox[
    SubsuperscriptBox["\[Sigma]", "u", "2"]], ",", 
   RowBox[{"\[Lambda]", " ", 
    SqrtBox[
     SubsuperscriptBox["\[Sigma]", "v", "2"]]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896257683162003`*^9, {3.3896258938752003`*^9, 3.3896259040341997`*^9}, 
   3.389630930477*^9, {3.3896310195889997`*^9, 3.389631032174*^9}, 
   3.3897068691312237`*^9, 3.3897170969388237`*^9, 3.3899920884435997`*^9, 
   3.3899921374526*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", " ", "@@", " ", 
   RowBox[{"(", 
    RowBox[{"d", "^", "2"}], ")"}]}], "//", "Simplify"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
  RowBox[{
   SuperscriptBox["\[Lambda]", "2"], " ", 
   SubsuperscriptBox["\[Sigma]", "v", "2"]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896257683552*^9, {3.3896258939252*^9, 3.3896259059351997`*^9}, 
   3.389630930524*^9, {3.3896310196429996`*^9, 3.389631034883*^9}, 
   3.389706869172224*^9, 3.389717096985824*^9, 3.3899920885066*^9, 
   3.3899921375106*^9}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Pricing error", "Subsection"],

Cell["Structural model:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["p", "t"], "-", 
   SubscriptBox["m", "t"]}], "/.", 
  SubscriptBox["p", "Rule"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"c", " ", 
  SubscriptBox["q", "t"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259124231997`*^9, 3.389630930564*^9, 
  3.389631046526*^9, 3.389706869213224*^9, 3.389717097033824*^9, 
  3.3899920885685997`*^9, 3.3899921375615997`*^9}]
}, Closed]],

Cell[TextData[{
 "\[Implies] ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Var", 
    RowBox[{"(", 
     SubscriptBox["s", "t"], ")"}]}], " ", "=", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["c", "2"], " ", "Var", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["q", "t"], Cell[""]}], ")"}]}], "=", 
    RowBox[{
     SuperscriptBox["c", "2"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "\[Beta]"}], ")"}], "2"], 
     SubsuperscriptBox["\[Sigma]", "v", "2"], Cell[""]}]}]}]]]
}], "Text"],

Cell["Lower bound", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"b", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"]}], ")"}], "+", 
   SubscriptBox["\[Theta]", "2"]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Theta]", "1"], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["\[Theta]", "2"]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259124572*^9, 3.389630930605*^9, 3.389631046572*^9, 
  3.3897068692562237`*^9, 3.3897170970818243`*^9, 3.3899920886345997`*^9, 
  3.3899921376136*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"b", "/.", 
    SubscriptBox["\[Theta]", "Rules"]}], "//", "Simplify"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", 
      RowBox[{
       RowBox[{"-", "c"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}]}]},
     {"0", "\[Beta]"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259124872*^9, 3.389630930645*^9, 3.389631046608*^9, 
  3.3897068693002243`*^9, 3.389717097128824*^9, 3.3899920886996*^9, 
  3.3899921376696*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"sv", "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"b", ".", "\[CapitalOmega]", ".", 
        RowBox[{"Transpose", "[", "b", "]"}]}], "/.", 
       SubscriptBox["\[CapitalOmega]", "Rule"]}], "/.", 
      SubscriptBox["\[Theta]", "Rules"]}], "//", "Simplify"}]}], ")"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"c", " ", "\[Beta]"}]}], ")"}], "2"], " ", 
       SubsuperscriptBox["\[Sigma]", "v", "2"]}], 
      RowBox[{
       RowBox[{"-", "c"}], " ", "\[Beta]", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
       SubsuperscriptBox["\[Sigma]", "v", "2"]}]},
     {
      RowBox[{
       RowBox[{"-", "c"}], " ", "\[Beta]", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
       SubsuperscriptBox["\[Sigma]", "v", "2"]}], 
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       SubsuperscriptBox["\[Sigma]", "v", "2"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259125222*^9, 3.389630930689*^9, 3.389631046658*^9, 
  3.389706869342224*^9, 3.389717097179824*^9, 3.3899920887736*^9, 
  3.3899921377226*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"sv", "/.", "nValues"}], "//", "MatrixForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1.6664772818000002`", 
      RowBox[{"-", "0.45975948180000004`"}]},
     {
      RowBox[{"-", "0.45975948180000004`"}], "0.12684168180000002`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259125532*^9, 3.389630930729*^9, 3.389631046705*^9, 
  3.3897068693882236`*^9, 3.389717097224824*^9, 3.3899920888375998`*^9, 
  3.3899921377736*^9}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems", "Section"],

Cell[CellGroupData[{

Cell["Exercise 9.1 (Glosten and Harris)", "Subsection",
 CellTags->"ExGlostenHarris"],

Cell["Definitions:", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["m", "Rule"], "=", 
   RowBox[{
    SubscriptBox["m", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", 
      RowBox[{"t", "-", "1"}]], "+", 
     SubscriptBox["w", "t"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["w", "Rule"], "=", 
   RowBox[{
    SubscriptBox["w", "t_"], "\[RuleDelayed]", " ", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Lambda]", "0"], " ", 
      SubscriptBox["q", "t"]}], "+", 
     RowBox[{
      SubscriptBox["\[Lambda]", "1"], " ", 
      SubscriptBox["Q", "t"]}], "+", 
     SubscriptBox["u", "t"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["p", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", "t"], "+", 
     RowBox[{
      SubscriptBox["c", "1"], " ", 
      SubscriptBox["q", "t"]}], "+", 
     RowBox[{
      SubscriptBox["c", "2"], " ", 
      SubscriptBox["Q", "t"]}]}]}]}], ";"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "With these definitions, ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["m", "t"], ",", " ", 
   SubscriptBox["w", "t"]}]]],
 " and ",
 Cell[BoxData[
  SubscriptBox["p", "t"]]],
 " are (respectively):"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"{", " ", 
   RowBox[{
    RowBox[{
     SubscriptBox["m", "t"], "/.", 
     SubscriptBox["m", "Rule"]}], ",", 
    RowBox[{
     SubscriptBox["w", "t"], "/.", 
     SubscriptBox["w", "Rule"]}], ",", 
    RowBox[{
     SubscriptBox["p", "t"], "/.", 
     SubscriptBox["p", "Rule"]}]}], "}"}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{
       SubscriptBox["m", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "t"}]], "+", 
       SubscriptBox["w", "t"]}]},
     {
      RowBox[{
       SubscriptBox["u", "t"], "+", 
       RowBox[{
        SubscriptBox["q", "t"], " ", 
        SubscriptBox["\[Lambda]", "0"]}], "+", 
       RowBox[{
        SubscriptBox["Q", "t"], " ", 
        SubscriptBox["\[Lambda]", "1"]}]}]},
     {
      RowBox[{
       SubscriptBox["m", "t"], "+", 
       RowBox[{
        SubscriptBox["c", "1"], " ", 
        SubscriptBox["q", "t"]}], "+", 
       RowBox[{
        SubscriptBox["c", "2"], " ", 
        SubscriptBox["Q", "t"]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259196912003`*^9, 3.389717125565824*^9, 
  3.3897171564058237`*^9, 3.389717222104824*^9, 3.3899920889396*^9, 
  3.3899921378416*^9}]
}, Closed]],

Cell[TextData[{
 "The price change at time ",
 Cell[BoxData["t"]],
 " is ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "t"], "="}]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["\[CapitalDelta]p", "t_"], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         SubscriptBox["p", "t"], "/.", "\[InvisibleSpace]", 
         SubscriptBox["p", "Rule"]}], "/.", "\[InvisibleSpace]", 
        SubscriptBox["m", "Rule"]}], "/.", "\[InvisibleSpace]", 
       SubscriptBox["w", "Rule"]}], ")"}], "-", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["p", 
        RowBox[{"t", "-", "1"}]], "/.", "\[InvisibleSpace]", 
       SubscriptBox["p", "Rule"]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "t"], "/.", "\[InvisibleSpace]", 
   SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["c", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["q", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "t"}]]}], "+", 
     SubscriptBox["q", "t"]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["c", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["Q", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "t"}]]}], "+", 
     SubscriptBox["Q", "t"]}], ")"}]}], "+", 
  SubscriptBox["u", "t"], "+", 
  RowBox[{
   SubscriptBox["q", "t"], " ", 
   SubscriptBox["\[Lambda]", "0"]}], "+", 
  RowBox[{
   SubscriptBox["Q", "t"], " ", 
   SubscriptBox["\[Lambda]", "1"]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259197352*^9, 3.389717125604824*^9, 
  3.389717156442824*^9, 3.389717222145824*^9, 3.3899920889896*^9, 
  3.3899921379116*^9}]
}, Closed]],

Cell["The vector of variables is:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["y", "Rule"], "=", 
   RowBox[{
    SubscriptBox["y", "t_"], "\[RuleDelayed]", 
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["\[CapitalDelta]p", "t"], ",", 
        SubscriptBox["q", "t"], ",", 
        SubscriptBox["Q", "t"]}], "}"}], "}"}], "]"}]}]}], ";", 
  RowBox[{"MatrixForm", "[", 
   RowBox[{
    SubscriptBox["y", "t"], "/.", 
    SubscriptBox["y", "Rule"]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SubscriptBox["\[CapitalDelta]p", "t"]},
     {
      SubscriptBox["q", "t"]},
     {
      SubscriptBox["Q", "t"]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259197782*^9, 3.389717125639824*^9, 
  3.389717156476824*^9, 3.3897172221878242`*^9, 3.3899920890656*^9, 
  3.3899921379716*^9}]
}, Closed]],

Cell[TextData[{
 "and the disturbances are ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Epsilon]", "t"], "="}]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Epsilon]", "Rule"], "=", 
   RowBox[{
    SubscriptBox["\[Epsilon]", "t_"], "\[RuleDelayed]", 
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["u", "t"], ",", 
        SubscriptBox["q", "t"], ",", 
        SubscriptBox["Q", "t"]}], "}"}], "}"}], "]"}]}]}], ";", 
  RowBox[{"MatrixForm", "[", 
   RowBox[{
    SubscriptBox["\[Epsilon]", "t"], "/.", 
    SubscriptBox["\[Epsilon]", "Rule"]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SubscriptBox["u", "t"]},
     {
      SubscriptBox["q", "t"]},
     {
      SubscriptBox["Q", "t"]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259198132*^9, 3.3897171256958237`*^9, 
  3.389717156520824*^9, 3.389717222231824*^9, 3.3899920891236*^9, 
  3.3899921380126*^9}]
}, Closed]],

Cell["With substitutions, the vector of system variables is:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["y", "t"], "/.", 
      SubscriptBox["y", "Rule"]}], "/.", 
     SubscriptBox["\[CapitalDelta]p", "Rule"]}], ")"}], "//", "MatrixForm"}], 
  "//", "Simplify"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{
        SubscriptBox["c", "1"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["q", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "t"}]]}], "+", 
          SubscriptBox["q", "t"]}], ")"}]}], "+", 
       RowBox[{
        SubscriptBox["c", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["Q", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "t"}]]}], "+", 
          SubscriptBox["Q", "t"]}], ")"}]}], "+", 
       SubscriptBox["u", "t"], "+", 
       RowBox[{
        SubscriptBox["q", "t"], " ", 
        SubscriptBox["\[Lambda]", "0"]}], "+", 
       RowBox[{
        SubscriptBox["Q", "t"], " ", 
        SubscriptBox["\[Lambda]", "1"]}]}]},
     {
      SubscriptBox["q", "t"]},
     {
      SubscriptBox["Q", "t"]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259198522*^9, 3.3897171257408237`*^9, 
  3.389717156567824*^9, 3.3897172222738237`*^9, 3.3899920891736*^9, 
  3.3899921380736*^9}]
}, Closed]],

Cell[TextData[{
 "The MA model is ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["y", "t"], "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Theta]", "0"], 
     SubscriptBox["\[Epsilon]", "t"]}], "+", 
    RowBox[{
     SubscriptBox["\[Theta]", "1"], 
     SubscriptBox["\[Epsilon]", 
      RowBox[{"t", "-", "1"}]]}]}]}]]],
 " where the coefficient matrices are:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\[Theta]", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["\[Theta]", "Rules"], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Rule", "[", 
      RowBox[{
       SubscriptBox["\[Theta]", "s"], ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Coefficient", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SubscriptBox["y", "t"], "/.", 
               SubscriptBox["y", "Rule"]}], "/.", 
              SubscriptBox["\[CapitalDelta]p", "Rule"]}], ")"}], "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["\[Epsilon]", 
               RowBox[{"t", "-", "s"}]], "/.", 
              SubscriptBox["\[Epsilon]", "Rule"]}], ")"}], "[", 
            RowBox[{"[", 
             RowBox[{"j", ",", "1"}], "]"}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "3"}], "}"}]}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"{", 
  RowBox[{"Map", "[", 
   RowBox[{"MatrixForm", ",", 
    SubscriptBox["\[Theta]", "Rules"], ",", 
    RowBox[{"{", "2", "}"}]}], "]"}], "}"}]}], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389717133358824*^9, 3.389717135035824*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     TagBox[
      SubscriptBox["\[Theta]", "0"],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]], "\[Rule]", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"1", 
          RowBox[{
           SubscriptBox["c", "1"], "+", 
           SubscriptBox["\[Lambda]", "0"]}], 
          RowBox[{
           SubscriptBox["c", "2"], "+", 
           SubscriptBox["\[Lambda]", "1"]}]},
         {"0", "1", "0"},
         {"0", "0", "1"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}], ",", 
    RowBox[{
     TagBox[
      SubscriptBox["\[Theta]", "1"],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]], "\[Rule]", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0", 
          RowBox[{"-", 
           SubscriptBox["c", "1"]}], 
          RowBox[{"-", 
           SubscriptBox["c", "2"]}]},
         {"0", "0", "0"},
         {"0", "0", "0"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}]}], "}"}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896259199012003`*^9, {3.3897171257878237`*^9, 3.389717156617824*^9}, 
   3.389717222326824*^9, 3.3899920897816*^9, 3.3899921381466*^9}]
}, Closed]],

Cell[TextData[{
 "To build the covariance matrix, we need to work out ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Cov", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["q", "t"], ",", 
      SubscriptBox["Q", "t"]}], ")"}]}], "=", 
   RowBox[{
    RowBox[{"E", "[", 
     RowBox[{
      SubscriptBox["Q", "t"], "Sign", 
      RowBox[{"(", 
       SubscriptBox["Q", "t"], ")"}]}], "]"}], "=", 
    RowBox[{"E", "|", 
     SubscriptBox["Q", "t"], "|"}]}]}]]]
}], "Text"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\[CapitalOmega]", "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  SubscriptBox["Q", "t"]]],
 " ~ ",
 Cell[BoxData[
  RowBox[{"N", 
   RowBox[{"(", 
    RowBox[{"0", ",", 
     SubsuperscriptBox["\[Sigma]", "Q", "2"]}], ")"}], Cell[""]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"E", "[", 
    RowBox[{"|", "Q", "|"}], "]"}], "="}]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
    RowBox[{
     RowBox[{"Abs", "[", "x", "]"}], " ", 
     RowBox[{"PDF", "[", 
      RowBox[{
       RowBox[{"NormalDistribution", "[", 
        RowBox[{"0", ",", 
         SubscriptBox["\[Sigma]", "Q"]}], "]"}], ",", "x"}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Sigma]", "Q"], "\[Element]", "Reals"}], ",", 
     RowBox[{
      RowBox[{"Re", "[", 
       SuperscriptBox[
        RowBox[{"(", 
         SubscriptBox["\[Sigma]", "Q"], ")"}], "2"], "]"}], ">", "0"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   FractionBox["2", "\[Pi]"]], " ", 
  SubscriptBox["\[Sigma]", "Q"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896259214952*^9, {3.389717127160824*^9, 3.389717157068824*^9}, 
   3.389717222795824*^9, 3.3899920926766*^9, 3.3899921405376*^9}]
}, Closed]],

Cell["So the disturbance covariance matrix is:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalOmega]", "Rule"], "=", 
   RowBox[{"\[CapitalOmega]", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubsuperscriptBox["\[Sigma]", "u", "2"], ",", "0", ",", "0"}], 
         "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1", ",", 
          SubscriptBox["\[Sigma]", 
           RowBox[{"q", ",", "Q"}]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          SubscriptBox["\[Sigma]", 
           RowBox[{"q", ",", "Q"}]], ",", 
          SubsuperscriptBox["\[Sigma]", "Q", "2"]}], "}"}]}], "}"}], "/.", 
      RowBox[{
       SubscriptBox["\[Sigma]", 
        RowBox[{"q", ",", "Q"}]], "\[Rule]", 
       SqrtBox[
        RowBox[{"2", 
         RowBox[{
          SubsuperscriptBox["\[Sigma]", "Q", "2"], "/", "\[Pi]"}]}]]}]}], 
     ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Map", "[", 
  RowBox[{"MatrixForm", ",", 
   SubscriptBox["\[CapitalOmega]", "Rule"], ",", "1"}], "]"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  TagBox["\[CapitalOmega]",
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], "\[Rule]", 
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       SubsuperscriptBox["\[Sigma]", "u", "2"], "0", "0"},
      {"0", "1", 
       RowBox[{
        SqrtBox[
         FractionBox["2", "\[Pi]"]], " ", 
        SqrtBox[
         SubsuperscriptBox["\[Sigma]", "Q", "2"]]}]},
      {"0", 
       RowBox[{
        SqrtBox[
         FractionBox["2", "\[Pi]"]], " ", 
        SqrtBox[
         SubsuperscriptBox["\[Sigma]", "Q", "2"]]}], 
       SubsuperscriptBox["\[Sigma]", "Q", "2"]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896259215572*^9, {3.389717127224824*^9, 3.389717157112824*^9}, 
   3.389717222834824*^9, 3.3899920927785997`*^9, 3.3899921406446*^9}]
}, Closed]],

Cell[TextData[{
 "The random-walk variance is ",
 Cell[BoxData[
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "w", "2"], "="}]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[Theta]", "0"], "+", 
         SubscriptBox["\[Theta]", "1"]}], ")"}], ".", "\[CapitalOmega]", ".", 
       
       RowBox[{"Transpose", "[", 
        RowBox[{
         SubscriptBox["\[Theta]", "0"], "+", 
         SubscriptBox["\[Theta]", "1"]}], "]"}]}], "/.", 
      SubscriptBox["\[Theta]", "Rules"]}], "/.", 
     SubscriptBox["\[CapitalOmega]", "Rule"]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[Sigma]", "Q"], ">", "0"}], ",", 
      RowBox[{
       SubscriptBox["\[Sigma]", "_"], "\[Element]", "Reals"}]}], "}"}]}], 
   "]"}], "[", 
  RowBox[{"[", 
   RowBox[{"1", ",", "1"}], "]"}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
  SubsuperscriptBox["\[Lambda]", "0", "2"], "+", 
  RowBox[{"2", " ", 
   SqrtBox[
    FractionBox["2", "\[Pi]"]], " ", 
   SqrtBox[
    SubsuperscriptBox["\[Sigma]", "Q", "2"]], " ", 
   SubscriptBox["\[Lambda]", "0"], " ", 
   SubscriptBox["\[Lambda]", "1"]}], "+", 
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "Q", "2"], " ", 
   SubsuperscriptBox["\[Lambda]", "1", "2"]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896259216322002`*^9, {3.3897171272918243`*^9, 3.389717157151824*^9}, 
   3.389717222878824*^9, 3.3899920928316*^9, 3.3899921407586*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Decomposition with ",
 Cell[BoxData[
  SubscriptBox["q", "t"]]],
 " first:"
}], "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"F1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Permute", "[", 
      RowBox[{
       RowBox[{"CholeskyDecomposition", "[", 
        RowBox[{"Permute", "[", 
         RowBox[{
          RowBox[{"\[CapitalOmega]", "/.", 
           SubscriptBox["\[CapitalOmega]", "Rule"]}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "3", ",", "1"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "1", ",", "2"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "Q", "2"], ">", "0"}], ",", 
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "u", "2"], ">", "0"}]}], "}"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"F1", "//", "MatrixForm"}]}], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3897172031878242`*^9, 3.389717216267824*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SqrtBox[
       SubsuperscriptBox["\[Sigma]", "u", "2"]], "0", "0"},
     {"0", "1", 
      RowBox[{
       SqrtBox[
        FractionBox["2", "\[Pi]"]], " ", 
       SqrtBox[
        SubsuperscriptBox["\[Sigma]", "Q", "2"]]}]},
     {"0", "0", 
      RowBox[{
       SqrtBox[
        FractionBox[
         RowBox[{
          RowBox[{"-", "2"}], "+", "\[Pi]"}], "\[Pi]"]], " ", 
       SqrtBox[
        SubsuperscriptBox["\[Sigma]", "Q", "2"]]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896259217052*^9, {3.389717127342824*^9, 3.389717157193824*^9}, 
   3.389717222934824*^9, 3.3899920929126*^9, 3.3899921408426*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VarDecomp1", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[Theta]", "0"], "+", 
         SubscriptBox["\[Theta]", "1"]}], ")"}], ".", 
       RowBox[{"Transpose", "[", "F1", "]"}]}], "/.", 
      SubscriptBox["\[Theta]", "Rules"]}], "//", "Simplify"}], ")"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SqrtBox[
    SubsuperscriptBox["\[Sigma]", "u", "2"]], ",", 
   RowBox[{
    SubscriptBox["\[Lambda]", "0"], "+", 
    RowBox[{
     SqrtBox[
      FractionBox["2", "\[Pi]"]], " ", 
     SqrtBox[
      SubsuperscriptBox["\[Sigma]", "Q", "2"]], " ", 
     SubscriptBox["\[Lambda]", "1"]}]}], ",", 
   RowBox[{
    SqrtBox[
     FractionBox[
      RowBox[{
       RowBox[{"-", "2"}], "+", "\[Pi]"}], "\[Pi]"]], " ", 
    SqrtBox[
     SubsuperscriptBox["\[Sigma]", "Q", "2"]], " ", 
    SubscriptBox["\[Lambda]", "1"]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896259217522*^9, {3.389717127402824*^9, 3.389717157233824*^9}, 
   3.389717222980824*^9, 3.3899920929616003`*^9, 3.3899921409306*^9}]
}, Closed]],

Cell[TextData[{
 "The variance components corresponding to ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["u", "t"], ",", " ", 
   SubscriptBox["q", "t"]}]]],
 " and ",
 Cell[BoxData[
  SubscriptBox["Q", "t"]]],
 " are:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    SuperscriptBox["VarDecomp1", "2"], "//", "Simplify"}], "}"}], "//", 
  "TableForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[GridBox[{
    {
     SubsuperscriptBox["\[Sigma]", "u", "2"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["\[Lambda]", "0"], "+", 
        RowBox[{
         SqrtBox[
          FractionBox["2", "\[Pi]"]], " ", 
         SqrtBox[
          SubsuperscriptBox["\[Sigma]", "Q", "2"]], " ", 
         SubscriptBox["\[Lambda]", "1"]}]}], ")"}], "2"], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "\[Pi]"}], ")"}], " ", 
       SubsuperscriptBox["\[Sigma]", "Q", "2"], " ", 
       SubsuperscriptBox["\[Lambda]", "1", "2"]}], "\[Pi]"]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896259219032*^9, {3.389717127450824*^9, 3.3897171572738237`*^9}, 
   3.389717223021824*^9, 3.3899920930226*^9, 3.3899921409955997`*^9}]
}, Closed]],

Cell[TextData[{
 "Verify that they add up to the correct ",
 Cell[BoxData[
  SubsuperscriptBox["\[Sigma]", "w", "2"]]],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", " ", "@@", " ", 
   SuperscriptBox["VarDecomp1", "2"]}], "//", "Simplify"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
  SubsuperscriptBox["\[Lambda]", "0", "2"], "+", 
  RowBox[{"2", " ", 
   SqrtBox[
    FractionBox["2", "\[Pi]"]], " ", 
   SqrtBox[
    SubsuperscriptBox["\[Sigma]", "Q", "2"]], " ", 
   SubscriptBox["\[Lambda]", "0"], " ", 
   SubscriptBox["\[Lambda]", "1"]}], "+", 
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "Q", "2"], " ", 
   SubsuperscriptBox["\[Lambda]", "1", "2"]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896259219482*^9, {3.389717127524824*^9, 3.3897171573128242`*^9}, 
   3.389717223064824*^9, 3.3899920930726*^9, 3.3899921410816*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Decomposition with ",
 Cell[BoxData[
  SubscriptBox["Q", "t"]]],
 " first:"
}], "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"F2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Permute", "[", 
      RowBox[{
       RowBox[{"CholeskyDecomposition", "[", 
        RowBox[{"Permute", "[", 
         RowBox[{
          RowBox[{"\[CapitalOmega]", "/.", 
           SubscriptBox["\[CapitalOmega]", "Rule"]}], ",", 
          RowBox[{"{", 
           RowBox[{"3", ",", "2", ",", "1"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2", ",", "1"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[Sigma]", "Q"], ">", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Sigma]", "u"], ">", "0"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"F2", "//", "MatrixForm"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SqrtBox[
       SubsuperscriptBox["\[Sigma]", "u", "2"]], "0", "0"},
     {"0", 
      SqrtBox[
       FractionBox[
        RowBox[{
         RowBox[{"-", "2"}], "+", "\[Pi]"}], "\[Pi]"]], "0"},
     {"0", 
      SqrtBox[
       FractionBox["2", "\[Pi]"]], 
      SqrtBox[
       SubsuperscriptBox["\[Sigma]", "Q", "2"]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896259219912*^9, {3.389717127567824*^9, 3.389717157355824*^9}, 
   3.389717223105824*^9, 3.3899920931356*^9, 3.3899921411566*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VarDecomp2", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[Theta]", "0"], "+", 
         SubscriptBox["\[Theta]", "1"]}], ")"}], ".", 
       RowBox[{"Transpose", "[", "F2", "]"}]}], "/.", 
      SubscriptBox["\[Theta]", "Rules"]}], "//", "Simplify"}], ")"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SqrtBox[
    SubsuperscriptBox["\[Sigma]", "u", "2"]], ",", 
   RowBox[{
    SqrtBox[
     FractionBox[
      RowBox[{
       RowBox[{"-", "2"}], "+", "\[Pi]"}], "\[Pi]"]], " ", 
    SubscriptBox["\[Lambda]", "0"]}], ",", 
   RowBox[{
    RowBox[{
     SqrtBox[
      FractionBox["2", "\[Pi]"]], " ", 
     SubscriptBox["\[Lambda]", "0"]}], "+", 
    RowBox[{
     SqrtBox[
      SubsuperscriptBox["\[Sigma]", "Q", "2"]], " ", 
     SubscriptBox["\[Lambda]", "1"]}]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896259220462*^9, {3.3897171276228237`*^9, 3.389717157395824*^9}, 
   3.389717223151824*^9, 3.3899920931846*^9, 3.3899921412256002`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    SuperscriptBox["VarDecomp2", "2"], "}"}], "//", "Simplify"}], "//", 
  "TableForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[GridBox[{
    {
     SubsuperscriptBox["\[Sigma]", "u", "2"], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "\[Pi]"}], ")"}], " ", 
       SubsuperscriptBox["\[Lambda]", "0", "2"]}], "\[Pi]"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SqrtBox[
          FractionBox["2", "\[Pi]"]], " ", 
         SubscriptBox["\[Lambda]", "0"]}], "+", 
        RowBox[{
         SqrtBox[
          SubsuperscriptBox["\[Sigma]", "Q", "2"]], " ", 
         SubscriptBox["\[Lambda]", "1"]}]}], ")"}], "2"]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896259220952*^9, {3.389717127661824*^9, 3.3897171574378242`*^9}, 
   3.389717223194824*^9, 3.3899920932346*^9, 3.3899921412816*^9}]
}, Closed]],

Cell["... and verify:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", " ", "@@", " ", 
   SuperscriptBox["VarDecomp2", "2"]}], "//", "Simplify"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
  SubsuperscriptBox["\[Lambda]", "0", "2"], "+", 
  RowBox[{"2", " ", 
   SqrtBox[
    FractionBox["2", "\[Pi]"]], " ", 
   SqrtBox[
    SubsuperscriptBox["\[Sigma]", "Q", "2"]], " ", 
   SubscriptBox["\[Lambda]", "0"], " ", 
   SubscriptBox["\[Lambda]", "1"]}], "+", 
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "Q", "2"], " ", 
   SubsuperscriptBox["\[Lambda]", "1", "2"]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896259221412*^9, {3.389717127709824*^9, 3.3897171574828243`*^9}, 
   3.3897172232328243`*^9, 3.3899920932836*^9, 3.3899921413426*^9}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Exercise 9.2 (Madhavan, Richardson and Roomans)", "Subsection",
 CellTags->"ExMRR"],

Cell["The model is:", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["q", "Rule"], "=", 
   RowBox[{
    SubscriptBox["q", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["v", "t"], "+", 
     RowBox[{"\[Beta]", " ", 
      SubscriptBox["q", 
       RowBox[{"t", "-", "1"}]]}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["m", "Rule"], "=", 
   RowBox[{
    SubscriptBox["m", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", 
      RowBox[{"t", "-", "1"}]], "+", 
     SubscriptBox["w", "t"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["w", "Rule"], "=", 
   RowBox[{
    SubscriptBox["w", "t_"], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"\[Lambda]", " ", 
      SubscriptBox["v", "t"]}], "+", 
     SubscriptBox["u", "t"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["p", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", "t"], "+", 
     RowBox[{"c", " ", 
      SubscriptBox["q", "t"]}]}]}]}], ";"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "With these rules, ",
 Cell[BoxData[
  SubscriptBox["q", "t"]]],
 ", ",
 Cell[BoxData[
  SubscriptBox["m", "t"]]],
 ", ",
 Cell[BoxData[
  SubscriptBox["w", "t"]]],
 ", and ",
 Cell[BoxData[
  SubscriptBox["p", "t"]]],
 " are:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["q", "t"], "/.", 
     SubscriptBox["q", "Rule"]}], ",", " ", 
    RowBox[{
     SubscriptBox["m", "t"], "/.", 
     SubscriptBox["m", "Rule"]}], ",", " ", 
    RowBox[{
     SubscriptBox["w", "t"], "/.", 
     SubscriptBox["w", "Rule"]}], ",", " ", 
    RowBox[{
     SubscriptBox["p", "t"], "/.", 
     SubscriptBox["p", "Rule"]}]}], "}"}], "//", "TableForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{
       RowBox[{"\[Beta]", " ", 
        SubscriptBox["q", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "t"}]]}], "+", 
       SubscriptBox["v", "t"]}]},
     {
      RowBox[{
       SubscriptBox["m", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "t"}]], "+", 
       SubscriptBox["w", "t"]}]},
     {
      RowBox[{
       SubscriptBox["u", "t"], "+", 
       RowBox[{"\[Lambda]", " ", 
        SubscriptBox["v", "t"]}]}]},
     {
      RowBox[{
       SubscriptBox["m", "t"], "+", 
       RowBox[{"c", " ", 
        SubscriptBox["q", "t"]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259221921997`*^9, 3.389717127757824*^9, 
  3.389717244586824*^9, 3.3899920933886003`*^9, 3.3899921414096003`*^9}]
}, Closed]],

Cell[TextData[{
 "The price change is ",
 Cell[BoxData[
  SubscriptBox["\[CapitalDelta]p", "t"]]],
 "="
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["\[CapitalDelta]p", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["\[CapitalDelta]p", "t"], "\[Rule]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{
          SubscriptBox["p", "t"], "/.", 
          SubscriptBox["p", "Rule"]}], "/.", 
         SubscriptBox["m", "Rule"]}], "/.", 
        SubscriptBox["w", "Rule"]}], ")"}], "-", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["p", 
         RowBox[{"t", "-", "1"}]], "/.", 
        SubscriptBox["p", "Rule"]}], ")"}]}]}]}]}], ";"}], "\n", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "t"], "/.", "\[InvisibleSpace]", 
   SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[CapitalDelta]p", "t"], "\[Rule]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "c"}], " ", 
    SubscriptBox["q", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "t"}]]}], "+", 
   RowBox[{"c", " ", 
    SubscriptBox["q", "t"]}], "+", 
   SubscriptBox["u", "t"], "+", 
   RowBox[{"\[Lambda]", " ", 
    SubscriptBox["v", "t"]}]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259222332*^9, 3.3897171277988243`*^9, 
  3.389717244631824*^9, 3.3899920934386*^9, 3.3899921414686003`*^9}]
}, Closed]],

Cell[TextData[{
 "The system variables are ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["y", "t"], "="}]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["y", "Rule"], "=", 
   RowBox[{
    SubscriptBox["y", "t_"], "\[RuleDelayed]", 
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["\[CapitalDelta]p", "t"], ",", 
        SubscriptBox["q", "t"]}], "}"}], "}"}], "]"}]}]}], ";", 
  RowBox[{
   RowBox[{
    SubscriptBox["y", "t"], "/.", 
    SubscriptBox["y", "Rule"]}], "//", "MatrixForm"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SubscriptBox["\[CapitalDelta]p", "t"]},
     {
      SubscriptBox["q", "t"]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259222742*^9, 3.389717127840824*^9, 
  3.3897172446748238`*^9, 3.3899920934936*^9, 3.3899921415296*^9}]
}, Closed]],

Cell["The vector of disturbances is:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Epsilon]", "Rule"], "=", 
   RowBox[{
    SubscriptBox["\[Epsilon]", "t_"], "\[RuleDelayed]", 
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["u", "t"], ",", 
        SubscriptBox["v", "t"]}], "}"}], "}"}], "]"}]}]}], ";", 
  RowBox[{
   RowBox[{
    SubscriptBox["\[Epsilon]", "t"], "/.", 
    SubscriptBox["\[Epsilon]", "Rule"]}], "//", "MatrixForm"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SubscriptBox["u", "t"]},
     {
      SubscriptBox["v", "t"]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259223162003`*^9, 3.389717127881824*^9, 
  3.389717244717824*^9, 3.3899920935446*^9, 3.3899921415696*^9}]
}, Closed]],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\[Theta]", "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "With substitutions, the vector of system variables becomes ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["y", "t"], "="}]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        SubscriptBox["\[CapitalDelta]p", "t"], "}"}], ",", 
       RowBox[{"{", 
        SubscriptBox["q", "t"], "}"}]}], "}"}], "/.", 
     RowBox[{
      SubscriptBox["\[CapitalDelta]p", "t"], "\[Rule]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           SubscriptBox["p", "t"], "/.", 
           SubscriptBox["p", "Rule"]}], "/.", 
          SubscriptBox["m", "Rule"]}], "/.", 
         SubscriptBox["w", "Rule"]}], ")"}], "-", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["p", 
          RowBox[{"t", "-", "1"}]], "/.", 
         SubscriptBox["p", "Rule"]}], ")"}]}]}]}], "/.", 
    RowBox[{
     SubscriptBox["q", "t"], "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["q", "t"], "/.", 
       SubscriptBox["q", "Rule"]}], ")"}]}]}], "//", "Simplify"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"c", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Beta]"}], ")"}], " ", 
        SubscriptBox["q", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "t"}]]}], "+", 
       SubscriptBox["u", "t"], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c", "+", "\[Lambda]"}], ")"}], " ", 
        SubscriptBox["v", "t"]}]}]},
     {
      RowBox[{
       RowBox[{"\[Beta]", " ", 
        SubscriptBox["q", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "t"}]]}], "+", 
       SubscriptBox["v", "t"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259223682003`*^9, 3.389717127933824*^9, 
  3.3897172447658243`*^9, 3.3899920936076*^9, 3.3899921416526003`*^9}]
}, Closed]],

Cell[TextData[{
 "This is a first-order vector autoregressive process: ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["y", "t"], "=", 
   RowBox[{
    RowBox[{"\[Phi]", " ", 
     SubscriptBox["y", 
      RowBox[{"t", "-", "1"}]]}], "+", 
    RowBox[{"\[Theta]", " ", 
     SubscriptBox["\[Epsilon]", "t"]}]}]}]]],
 " where "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Phi]", "Rule"], "=", 
   RowBox[{"\[Phi]", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"c", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "\[Beta]"}], ")"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "\[Beta]"}], "}"}]}], "}"}]}]}], ";", 
  RowBox[{"MatrixForm", " ", "/@", " ", 
   SubscriptBox["\[Phi]", "Rule"]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  TagBox["\[Phi]",
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], "\[Rule]", 
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", 
       RowBox[{"c", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Beta]"}], ")"}]}]},
      {"0", "\[Beta]"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259224112*^9, 3.3897171279758244`*^9, 
  3.389717244809824*^9, 3.3899920936605997`*^9, 3.3899921417096*^9}]
}, Closed]],

Cell["and", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Theta]", "Rule"], "=", 
   RowBox[{"\[Theta]", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"(", 
         RowBox[{"c", "+", "\[Lambda]"}], ")"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], ";", 
  RowBox[{"MatrixForm", " ", "/@", " ", 
   SubscriptBox["\[Theta]", "Rule"]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  TagBox["\[Theta]",
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], "\[Rule]", 
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1", 
       RowBox[{"c", "+", "\[Lambda]"}]},
      {"0", "1"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259224592*^9, 3.389717128019824*^9, 
  3.3897172448508244`*^9, 3.3899920937176*^9, 3.3899921417726*^9}]
}, Closed]],

Cell[TextData[{
 "It may be put in vector moving average (VMA) form as: ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["y", "t"], "=", 
   RowBox[{
    UnderscriptBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"I", "-", "\[Phi]L"}], ")"}], 
       RowBox[{"-", "1"}]], "\[Theta]"}], 
     UnderscriptBox["\[UnderBrace]", 
      RowBox[{"VMA", " ", "coefficients"}]]], 
    SubscriptBox["\[Epsilon]", "t"]}]}]]],
 ". We could obtain the VMA coefficient matrices by doing the series \
expansion. Here, though, to compute the random-walk variance, we just need \
the sum of the moving average coefficients, and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"I", "-", "\[Phi]"}], ")"}], 
     RowBox[{"-", "1"}]], "\[Theta]"}], "="}]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"maSum", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Inverse", "[", 
      RowBox[{
       RowBox[{"IdentityMatrix", "[", "2", "]"}], "-", 
       RowBox[{"(", 
        RowBox[{"\[Phi]", "/.", 
         SubscriptBox["\[Phi]", "Rule"]}], ")"}]}], "]"}], ".", 
     RowBox[{"(", 
      RowBox[{"\[Theta]", "/.", 
       SubscriptBox["\[Theta]", "Rule"]}], ")"}]}], "//", "Simplify"}]}], ";",
   " ", 
  RowBox[{"maSum", "//", "MatrixForm"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "\[Lambda]"},
     {"0", 
      FractionBox["1", 
       RowBox[{"1", "-", "\[Beta]"}]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259225032*^9, 3.389717128059824*^9, 
  3.389717244896824*^9, 3.3899920938166*^9, 3.3899921418266*^9}]
}, Closed]],

Cell[TextData[{
 "To compute the random-walk variance ",
 Cell[BoxData[
  SubsuperscriptBox["\[Sigma]", "w", "2"]]],
 ", take the upper left hand entry of ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"[", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"I", "-", "\[Phi]"}], ")"}], 
      RowBox[{"-", "1"}]], "\[Theta]"}], "]"}], 
   SuperscriptBox[
    RowBox[{"\[CapitalOmega]", "[", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"I", "-", "\[Phi]"}], ")"}], 
       RowBox[{"-", "1"}]], "\[Theta]"}], "]"}], "\[Prime]"]}]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"maSum", ".", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "u", "2"], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        SubsuperscriptBox["\[Sigma]", "v", "2"]}], "}"}]}], "}"}], ".", 
    RowBox[{"Transpose", "[", "maSum", "]"}]}], "//", "Simplify"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
       RowBox[{
        SuperscriptBox["\[Lambda]", "2"], " ", 
        SubsuperscriptBox["\[Sigma]", "v", "2"]}]}], 
      FractionBox[
       RowBox[{"\[Lambda]", " ", 
        SubsuperscriptBox["\[Sigma]", "v", "2"]}], 
       RowBox[{"1", "-", "\[Beta]"}]]},
     {
      FractionBox[
       RowBox[{"\[Lambda]", " ", 
        SubsuperscriptBox["\[Sigma]", "v", "2"]}], 
       RowBox[{"1", "-", "\[Beta]"}]], 
      FractionBox[
       SubsuperscriptBox["\[Sigma]", "v", "2"], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Beta]"}], ")"}], "2"]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259225442*^9, 3.389717128104824*^9, 
  3.389717244941824*^9, 3.3899920938756*^9, 3.3899921418886003`*^9}]
}, Closed]],

Cell[TextData[{
 "The quantity ",
 Cell[BoxData[
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
   RowBox[{
    SuperscriptBox["\[Lambda]", "2"], 
    SubsuperscriptBox["\[Sigma]", "v", "2"]}]}]]],
 " summarizes the public information and trade-related components of the \
random-walk."
}], "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Multiple Securities (Chapter 10)", "Section"],

Cell[CellGroupData[{

Cell["\<\
Two securities in a Roll model, not cointegrated, prices only. (Chapter 10, \
Section 10.1)\
\>", "Subsection"],

Cell[CellGroupData[{

Cell["Model", "Subsubsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["p", "Rule"], " ", "=", " ", 
   RowBox[{
    SubscriptBox["p", 
     RowBox[{"i_", ",", "t_"}]], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", 
      RowBox[{"i", ",", "t"}]], "+", 
     RowBox[{"c", " ", 
      SubscriptBox["q", 
       RowBox[{"i", ",", "t"}]]}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["m", "Rule"], "=", 
   RowBox[{
    SubscriptBox["m", 
     RowBox[{"i_", ",", "t_"}]], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", 
      RowBox[{"i", ",", 
       RowBox[{"t", "-", "1"}]}]], "+", 
     SubscriptBox["w", 
      RowBox[{"i", ",", "t"}]]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["w", "Rule"], "=", 
   RowBox[{
    SubscriptBox["w", 
     RowBox[{"i_", ",", "t_"}]], "\[RuleDelayed]", 
    SubscriptBox["u", 
     RowBox[{"i", ",", "t"}]]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["\[CapitalDelta]p", 
     RowBox[{"i_", ",", "t_"}]], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         SubscriptBox["p", 
          RowBox[{"i", ",", "t"}]], "/.", 
         SubscriptBox["p", "Rule"]}], "/.", 
        SubscriptBox["m", "Rule"]}], "/.", 
       SubscriptBox["w", "Rule"]}], ")"}], "-", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["p", 
        RowBox[{"i", ",", 
         RowBox[{"t", "-", "1"}]}]], "/.", 
       SubscriptBox["p", "Rule"]}], ")"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "t_"], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      SubscriptBox["\[CapitalDelta]p", 
       RowBox[{"1", ",", "t"}]], "}"}], ",", 
     RowBox[{"{", 
      SubscriptBox["\[CapitalDelta]p", 
       RowBox[{"2", ",", "t"}]], "}"}]}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[118]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[CapitalDelta]p", "t"], "/.", 
  SubscriptBox["\[CapitalDelta]p", "Rule"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "c"}], " ", 
      SubscriptBox["q", 
       RowBox[{"1", ",", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "t"}]}]]}], "+", 
     RowBox[{"c", " ", 
      SubscriptBox["q", 
       RowBox[{"1", ",", "t"}]]}], "+", 
     SubscriptBox["u", 
      RowBox[{"1", ",", "t"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "c"}], " ", 
      SubscriptBox["q", 
       RowBox[{"2", ",", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "t"}]}]]}], "+", 
     RowBox[{"c", " ", 
      SubscriptBox["q", 
       RowBox[{"2", ",", "t"}]]}], "+", 
     SubscriptBox["u", 
      RowBox[{"2", ",", "t"}]]}], "}"}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259408602*^9, 3.3896276280088*^9, 
  3.3896310595959997`*^9, 3.389631159269*^9, 3.389707129382224*^9, 
  3.389717262019824*^9, 3.3899920940495996`*^9, 3.3899921419596*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Compute autocovariances", "Subsubsection"],

Cell[TextData[{
 "We will obtain ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[CapitalGamma]", "k"], "=", 
   RowBox[{
    SubscriptBox["E\[CapitalDelta]p", "t"], 
    SubscriptBox["\[CapitalDelta]p", 
     RowBox[{"t", "-", "k"}]]}]}]]],
 ", where the following rules are used to eliminate terms in the expectation \
with zero cross-products. (Note: these are general rules; some of them are \
left over from the univariate case.)"
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[ScriptCapitalE]", "Rules"], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       SubsuperscriptBox["q", "_", "2"], "]"}], "\[Rule]", "1"}], ",", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       SubsuperscriptBox["u", "_", "2"], "]"}], "\[Rule]", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}], ",", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{
        SubscriptBox["q", "_"], 
        SubscriptBox["u", "_"]}], "]"}], "\[Rule]", " ", "0"}], ",", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{
        SubscriptBox["q", "t_"], 
        SubscriptBox["q", "s_"]}], "]"}], "\[RuleDelayed]", " ", 
      RowBox[{"0", "/;", 
       RowBox[{"t", "=!=", "s"}]}]}], ",", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{
        SubscriptBox["u", "t_"], 
        SubscriptBox["u", "s_"]}], "]"}], "\[RuleDelayed]", " ", 
      RowBox[{"0", "/;", 
       RowBox[{"t", "=!=", "s"}]}]}], ",", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{
        SubscriptBox["q", 
         RowBox[{"_", ",", "_"}]], 
        SubscriptBox["u", 
         RowBox[{"_", ",", "_"}]]}], "]"}], "\[Rule]", "0"}], ",", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       SubsuperscriptBox["u", 
        RowBox[{"_", ",", "_"}], "2"], "]"}], "\[RuleDelayed]", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}], ",", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{
        SubscriptBox["u", 
         RowBox[{"_", ",", "t_"}]], 
        SubscriptBox["u", 
         RowBox[{"_", ",", "s_"}]]}], "]"}], "\[Rule]", "0"}], ",", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{
        SubscriptBox["q", 
         RowBox[{"_", ",", "t_"}]], " ", 
        SubscriptBox["q", 
         RowBox[{"_", ",", "s_"}]]}], "]"}], "\[RuleDelayed]", 
      RowBox[{"\[Rho]", "/;", 
       RowBox[{"t", "===", "s"}]}]}], ",", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{
        SubscriptBox["q", 
         RowBox[{"_", ",", "t_"}]], " ", 
        SubscriptBox["q", 
         RowBox[{"_", ",", "s_"}]]}], "]"}], "\[RuleDelayed]", 
      RowBox[{"0", "/;", 
       RowBox[{"t", "=!=", "s"}]}]}], ",", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       SubsuperscriptBox["q", 
        RowBox[{"_", ",", "_"}], "2"], "]"}], "\[Rule]", "1"}], ",", "\n", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{"a_", "+", "b_"}], "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{"\[ScriptCapitalE]", "[", "a", "]"}], "+", 
       RowBox[{"\[ScriptCapitalE]", "[", "b", "]"}]}]}], ",", "\n", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", "c_", "]"}], "\[RuleDelayed]", 
      RowBox[{"c", "/;", 
       RowBox[{"NumberQ", "[", "c", "]"}]}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", "c_Symbol", "]"}], "\[RuleDelayed]", 
      RowBox[{"c", "/;", 
       RowBox[{"MemberQ", "[", 
        RowBox[{
         RowBox[{"Attributes", "[", "c", "]"}], ",", "Constant"}], "]"}]}]}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{"c_", " ", "a_"}], "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{"c", " ", 
        RowBox[{"\[ScriptCapitalE]", "[", "a", "]"}]}], "/;", 
       RowBox[{"NumberQ", "[", "c", "]"}]}]}], ",", "\n", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{"c_Symbol", " ", "a_"}], "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{"c", " ", 
        RowBox[{"\[ScriptCapitalE]", "[", "a", "]"}]}], "/;", 
       RowBox[{"MemberQ", "[", 
        RowBox[{
         RowBox[{"Attributes", "[", "c", "]"}], ",", "Constant"}], "]"}]}]}], 
     ",", "\n", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{
        SuperscriptBox["c_Symbol", "n_Integer"], " ", "a_"}], "]"}], 
      "\[RuleDelayed]", " ", 
      RowBox[{
       RowBox[{
        SuperscriptBox["c", "n"], " ", 
        RowBox[{"\[ScriptCapitalE]", "[", "a", "]"}]}], "/;", 
       RowBox[{"MemberQ", "[", 
        RowBox[{
         RowBox[{"Attributes", "[", "c", "]"}], ",", "Constant"}], 
        "]"}]}]}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[124]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[ScriptCapitalE]", "Rules"], "//", "TableForm"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896262645982*^9}],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{
       RowBox[{"\[ScriptCapitalE]", "[", 
        SubsuperscriptBox["q", "_", "2"], "]"}], "\[Rule]", "1"}]},
     {
      RowBox[{
       RowBox[{"\[ScriptCapitalE]", "[", 
        SubsuperscriptBox["u", "_", "2"], "]"}], "\[Rule]", 
       SubsuperscriptBox["\[Sigma]", "u", "2"]}]},
     {
      RowBox[{
       RowBox[{"\[ScriptCapitalE]", "[", 
        RowBox[{
         SubscriptBox["q", "_"], " ", 
         SubscriptBox["u", "_"]}], "]"}], "\[Rule]", "0"}]},
     {
      RowBox[{
       RowBox[{"\[ScriptCapitalE]", "[", 
        RowBox[{
         SubscriptBox["q", "s_"], " ", 
         SubscriptBox["q", "t_"]}], "]"}], "\[RuleDelayed]", 
       RowBox[{"0", "/;", 
        RowBox[{"t", "=!=", "s"}]}]}]},
     {
      RowBox[{
       RowBox[{"\[ScriptCapitalE]", "[", 
        RowBox[{
         SubscriptBox["u", "s_"], " ", 
         SubscriptBox["u", "t_"]}], "]"}], "\[RuleDelayed]", 
       RowBox[{"0", "/;", 
        RowBox[{"t", "=!=", "s"}]}]}]},
     {
      RowBox[{
       RowBox[{"\[ScriptCapitalE]", "[", 
        RowBox[{
         SubscriptBox["q", 
          RowBox[{"_", ",", "_"}]], " ", 
         SubscriptBox["u", 
          RowBox[{"_", ",", "_"}]]}], "]"}], "\[Rule]", "0"}]},
     {
      RowBox[{
       RowBox[{"\[ScriptCapitalE]", "[", 
        SubsuperscriptBox["u", 
         RowBox[{"_", ",", "_"}], "2"], "]"}], "\[RuleDelayed]", 
       SubsuperscriptBox["\[Sigma]", "u", "2"]}]},
     {
      RowBox[{
       RowBox[{"\[ScriptCapitalE]", "[", 
        RowBox[{
         SubscriptBox["u", 
          RowBox[{"_", ",", "s_"}]], " ", 
         SubscriptBox["u", 
          RowBox[{"_", ",", "t_"}]]}], "]"}], "\[Rule]", "0"}]},
     {
      RowBox[{
       RowBox[{"\[ScriptCapitalE]", "[", 
        RowBox[{
         SubscriptBox["q", 
          RowBox[{"_", ",", "s_"}]], " ", 
         SubscriptBox["q", 
          RowBox[{"_", ",", "t_"}]]}], "]"}], "\[RuleDelayed]", 
       RowBox[{"\[Rho]", "/;", 
        RowBox[{"t", "===", "s"}]}]}]},
     {
      RowBox[{
       RowBox[{"\[ScriptCapitalE]", "[", 
        RowBox[{
         SubscriptBox["q", 
          RowBox[{"_", ",", "s_"}]], " ", 
         SubscriptBox["q", 
          RowBox[{"_", ",", "t_"}]]}], "]"}], "\[RuleDelayed]", 
       RowBox[{"0", "/;", 
        RowBox[{"t", "=!=", "s"}]}]}]},
     {
      RowBox[{
       RowBox[{"\[ScriptCapitalE]", "[", 
        SubsuperscriptBox["q", 
         RowBox[{"_", ",", "_"}], "2"], "]"}], "\[Rule]", "1"}]},
     {
      RowBox[{
       RowBox[{"\[ScriptCapitalE]", "[", 
        RowBox[{"a_", "+", "b_"}], "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"\[ScriptCapitalE]", "[", "a", "]"}], "+", 
        RowBox[{"\[ScriptCapitalE]", "[", "b", "]"}]}]}]},
     {
      RowBox[{
       RowBox[{"\[ScriptCapitalE]", "[", "c_", "]"}], "\[RuleDelayed]", 
       RowBox[{"c", "/;", 
        RowBox[{"NumberQ", "[", "c", "]"}]}]}]},
     {
      RowBox[{
       RowBox[{"\[ScriptCapitalE]", "[", "c_Symbol", "]"}], "\[RuleDelayed]", 
       
       RowBox[{"c", "/;", 
        RowBox[{"MemberQ", "[", 
         RowBox[{
          RowBox[{"Attributes", "[", "c", "]"}], ",", "Constant"}], 
         "]"}]}]}]},
     {
      RowBox[{
       RowBox[{"\[ScriptCapitalE]", "[", 
        RowBox[{"a_", " ", "c_"}], "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"c", " ", 
         RowBox[{"\[ScriptCapitalE]", "[", "a", "]"}]}], "/;", 
        RowBox[{"NumberQ", "[", "c", "]"}]}]}]},
     {
      RowBox[{
       RowBox[{"\[ScriptCapitalE]", "[", 
        RowBox[{"a_", " ", "c_Symbol"}], "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"c", " ", 
         RowBox[{"\[ScriptCapitalE]", "[", "a", "]"}]}], "/;", 
        RowBox[{"MemberQ", "[", 
         RowBox[{
          RowBox[{"Attributes", "[", "c", "]"}], ",", "Constant"}], 
         "]"}]}]}]},
     {
      RowBox[{
       RowBox[{"\[ScriptCapitalE]", "[", 
        RowBox[{"a_", " ", 
         SuperscriptBox["c_Symbol", "n_Integer"]}], "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{
         SuperscriptBox["c", "n"], " ", 
         RowBox[{"\[ScriptCapitalE]", "[", "a", "]"}]}], "/;", 
        RowBox[{"MemberQ", "[", 
         RowBox[{
          RowBox[{"Attributes", "[", "c", "]"}], ",", "Constant"}], 
         "]"}]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259409082003`*^9, 3.3896260358082*^9, 
  3.3896263351712*^9, 3.3896264420682*^9, 3.3896276281317997`*^9, 
  3.3896310596549997`*^9, 3.3896311593190002`*^9, 3.3897071294392242`*^9, 
  3.389717262086824*^9, 3.3899920941596003`*^9, 3.3899921420416*^9}]
}, Closed]],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"\[ScriptCapitalE]", ",", "Listable"}], "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896277564578*^9, 3.3896277690578003`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalGamma]", "Rule"], "=", 
   RowBox[{
    SubscriptBox["\[CapitalGamma]", "k_"], "\[RuleDelayed]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{"Expand", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[CapitalDelta]p", "t"], "/.", 
           SubscriptBox["\[CapitalDelta]p", "Rule"]}], ")"}], ".", 
         RowBox[{"Transpose", "[", 
          RowBox[{
           SubscriptBox["\[CapitalDelta]p", 
            RowBox[{"t", "-", "k"}]], "/.", 
           SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}]}], "]"}], "]"}], 
      "//.", 
      SubscriptBox["\[ScriptCapitalE]", "Rules"]}], ")"}]}]}], ";"}]], "Input",\

 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896276626808*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalGamma]", "0"], "/.", 
   SubscriptBox["\[CapitalGamma]", "Rule"]}], "//", "MatrixForm"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896278214978*^9, 3.3896278247167997`*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["c", "2"]}], "+", 
       SubsuperscriptBox["\[Sigma]", "u", "2"]}], 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "2"], " ", "\[Rho]"}]},
     {
      RowBox[{"2", " ", 
       SuperscriptBox["c", "2"], " ", "\[Rho]"}], 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["c", "2"]}], "+", 
       SubsuperscriptBox["\[Sigma]", "u", "2"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259409712*^9, 3.3896262277832003`*^9, 
  3.3896264489182*^9, 3.3896276283068*^9, 3.3896276655657997`*^9, 
  3.3896277819118*^9, 3.3896278251108*^9, 3.3896310597130003`*^9, 
  3.389631159368*^9, 3.389707129486224*^9, 3.389717262139824*^9, 
  3.3899920942546*^9, 3.3899921421586*^9}]
}, Closed]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[CapitalGamma]", "0"], ",", " ", 
   SubscriptBox["\[CapitalGamma]", "1"]}]]],
 " and ",
 Cell[BoxData[
  SubscriptBox["\[CapitalGamma]", "2"]]],
 " are:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"MatrixForm", ",", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[CapitalGamma]", "k"], "/.", 
      SubscriptBox["\[CapitalGamma]", "Rule"]}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "2"}], "}"}]}], "]"}], ",", "1"}], 
  "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         SubsuperscriptBox["\[Sigma]", "u", "2"]}], 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"], " ", "\[Rho]"}]},
       {
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"], " ", "\[Rho]"}], 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         SubsuperscriptBox["\[Sigma]", "u", "2"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", 
         SuperscriptBox["c", "2"]}], 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["c", "2"]}], " ", "\[Rho]"}]},
       {
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["c", "2"]}], " ", "\[Rho]"}], 
        RowBox[{"-", 
         SuperscriptBox["c", "2"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0"},
       {"0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896278679208*^9, 3.3896280195188*^9, 
  3.3896310597650003`*^9, 3.389631159416*^9, 3.389707129535224*^9, 
  3.389717262189824*^9, 3.3899920943946*^9, 3.3899921422756*^9}]
}, Closed]],

Cell[TextData[{
 "Note that ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[CapitalGamma]", "2"], "=", "0"}]]],
 ". We can verify that ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[CapitalGamma]", "k"], "=", "0"}]]],
 " for ",
 Cell[BoxData[
  RowBox[{"|", "k", "|", 
   RowBox[{"\[GreaterEqual]", "2"}]}]]],
 ".\nHere are some trial numerical values:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nValues", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Sigma]", "u", "2"], "\[Rule]", "1"}], ",", 
    RowBox[{"c", "\[Rule]", "10"}], ",", 
    RowBox[{"\[Rho]", "\[Rule]", ".9"}]}], "}"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "u", "2"], "\[Rule]", "1"}], ",", 
   RowBox[{"c", "\[Rule]", "10"}], ",", 
   RowBox[{"\[Rho]", "\[Rule]", "0.9`"}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259411602*^9, 3.3896276284428*^9, 3.3896278855268*^9,
   3.389631059803*^9, 3.389631159451*^9, 3.3897071295722237`*^9, 
  3.389717262226824*^9, 3.3899920944596*^9, 3.3899921423306*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Map", "[", 
   RowBox[{"MatrixForm", ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[CapitalGamma]", "k"], "/.", 
       SubscriptBox["\[CapitalGamma]", "Rule"]}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "0", ",", "1"}], "}"}]}], "]"}], ",", "1"}], "]"}], "/.",
   "nValues"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896278918408003`*^9, 3.3896279004048*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"201", "180.`"},
       {"180.`", "201"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "100"}], 
        RowBox[{"-", "90.`"}]},
       {
        RowBox[{"-", "90.`"}], 
        RowBox[{"-", "100"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259412522*^9, 3.3896276285228*^9, 3.3896279009788*^9,
   3.38963105985*^9, 3.3896311595*^9, 3.3897071296172237`*^9, 
  3.3897172622728243`*^9, 3.3899920945495996`*^9, 3.3899921424196*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Set up VMA form", "Subsubsection"],

Cell["\<\
Since the autocovariances vanish after lag 1, we have a VMA(1) structure:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Theta]", "[", "L_", "]"}], ":=", 
   RowBox[{
    RowBox[{"IdentityMatrix", "[", "2", "]"}], "+", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       SubscriptBox["\[Theta]", 
        RowBox[{"i", ",", "j"}]], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "2"}], "}"}]}], "]"}], "L"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Theta]", "[", "L", "]"}], "//", "PolyForm"}]}], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389707780853224*^9, 3.389707802902224*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\<\"\"\>", " ", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0"},
       {"0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "+", 
  RowBox[{"L", " ", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["\[Theta]", 
         RowBox[{"1", ",", "1"}]], 
        SubscriptBox["\[Theta]", 
         RowBox[{"1", ",", "2"}]]},
       {
        SubscriptBox["\[Theta]", 
         RowBox[{"2", ",", "1"}]], 
        SubscriptBox["\[Theta]", 
         RowBox[{"2", ",", "2"}]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896259413222*^9, 3.3896276285818*^9, 3.3896279209088*^9, 
   3.389631059891*^9, 3.389631159534*^9, 3.3897071296572237`*^9, {
   3.3897077656902237`*^9, 3.389707789985224*^9}, {3.389707869094224*^9, 
   3.389707889276224*^9}, {3.389707942003224*^9, 3.389707979850224*^9}, {
   3.389708017304224*^9, 3.389708064250224*^9}, 3.3897081524802237`*^9, 
   3.3897082223002243`*^9, 3.389709443270224*^9, {3.389709480961224*^9, 
   3.3897095336172237`*^9}, 3.3897101312232237`*^9, 3.389717262314824*^9, 
   3.3899920946205997`*^9, 3.3899921424776*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalOmega]", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "1", "2"], ",", 
       SubscriptBox["\[Sigma]", 
        RowBox[{"1", ",", "2"}]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Sigma]", 
        RowBox[{"1", ",", "2"}]], ",", 
       SubsuperscriptBox["\[Sigma]", "2", "2"]}], "}"}]}], "}"}]}], ";", 
  RowBox[{"\[CapitalOmega]", "//", "MatrixForm"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SubsuperscriptBox["\[Sigma]", "1", "2"], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "2"}]]},
     {
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "2"}]], 
      SubsuperscriptBox["\[Sigma]", "2", "2"]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259413812*^9, 3.3896276286408*^9, 3.3896279209638*^9,
   3.389631059934*^9, 3.389631159572*^9, 3.389707129693224*^9, 
  3.389710160503224*^9, 3.389717262352824*^9, 3.3899920946836*^9, 
  3.3899921425355997`*^9}]
}, Closed]],

Cell["Autocovariance generating function:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", "z_", "]"}], ":=", 
  RowBox[{
   RowBox[{"\[Theta]", "[", "z", "]"}], ".", "\[CapitalOmega]", ".", 
   RowBox[{"Transpose", "[", 
    RowBox[{"\[Theta]", "[", 
     SuperscriptBox["z", 
      RowBox[{"-", "1"}]], "]"}], "]"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "We'll obtain the ",
 Cell[BoxData[
  SubscriptBox["\[CapitalGamma]", "k"]]],
 " for the VMA representation by picking off the appropriate coefficient in \
the AGF."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalGamma]VMA", "Rule"], "=", 
   RowBox[{
    SubscriptBox["\[CapitalGamma]", "k_"], "\[RuleDelayed]", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{
       RowBox[{"g", "[", "z", "]"}], ",", "z", ",", "k"}], "]"}], "]"}]}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Map", "[", 
   RowBox[{"MatrixForm", ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[CapitalGamma]", "k"], "/.", 
       SubscriptBox["\[CapitalGamma]VMA", "Rule"]}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "]"}], "//", 
  "MatrixForm"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       TagBox[
        RowBox[{"(", "\[NoBreak]", GridBox[{
           {
            RowBox[{
             SubsuperscriptBox["\[Sigma]", "1", "2"], "+", 
             RowBox[{
              SubsuperscriptBox["\[Sigma]", "1", "2"], " ", 
              SubsuperscriptBox["\[Theta]", 
               RowBox[{"1", ",", "1"}], "2"]}], "+", 
             RowBox[{
              SubsuperscriptBox["\[Sigma]", "2", "2"], " ", 
              SubsuperscriptBox["\[Theta]", 
               RowBox[{"1", ",", "2"}], "2"]}], "+", 
             RowBox[{"2", " ", 
              SubscriptBox["\[Theta]", 
               RowBox[{"1", ",", "1"}]], " ", 
              SubscriptBox["\[Theta]", 
               RowBox[{"1", ",", "2"}]], " ", 
              SubscriptBox["\[Sigma]", 
               RowBox[{"1", ",", "2"}]]}]}], 
            RowBox[{
             SubscriptBox["\[Sigma]", 
              RowBox[{"1", ",", "2"}]], "+", 
             RowBox[{
              SubscriptBox["\[Theta]", 
               RowBox[{"1", ",", "2"}]], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SubsuperscriptBox["\[Sigma]", "2", "2"], " ", 
                 SubscriptBox["\[Theta]", 
                  RowBox[{"2", ",", "2"}]]}], "+", 
                RowBox[{
                 SubscriptBox["\[Theta]", 
                  RowBox[{"2", ",", "1"}]], " ", 
                 SubscriptBox["\[Sigma]", 
                  RowBox[{"1", ",", "2"}]]}]}], ")"}]}], "+", 
             RowBox[{
              SubscriptBox["\[Theta]", 
               RowBox[{"1", ",", "1"}]], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SubsuperscriptBox["\[Sigma]", "1", "2"], " ", 
                 SubscriptBox["\[Theta]", 
                  RowBox[{"2", ",", "1"}]]}], "+", 
                RowBox[{
                 SubscriptBox["\[Theta]", 
                  RowBox[{"2", ",", "2"}]], " ", 
                 SubscriptBox["\[Sigma]", 
                  RowBox[{"1", ",", "2"}]]}]}], ")"}]}]}]},
           {
            RowBox[{
             SubscriptBox["\[Sigma]", 
              RowBox[{"1", ",", "2"}]], "+", 
             RowBox[{
              SubscriptBox["\[Theta]", 
               RowBox[{"1", ",", "2"}]], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SubsuperscriptBox["\[Sigma]", "2", "2"], " ", 
                 SubscriptBox["\[Theta]", 
                  RowBox[{"2", ",", "2"}]]}], "+", 
                RowBox[{
                 SubscriptBox["\[Theta]", 
                  RowBox[{"2", ",", "1"}]], " ", 
                 SubscriptBox["\[Sigma]", 
                  RowBox[{"1", ",", "2"}]]}]}], ")"}]}], "+", 
             RowBox[{
              SubscriptBox["\[Theta]", 
               RowBox[{"1", ",", "1"}]], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SubsuperscriptBox["\[Sigma]", "1", "2"], " ", 
                 SubscriptBox["\[Theta]", 
                  RowBox[{"2", ",", "1"}]]}], "+", 
                RowBox[{
                 SubscriptBox["\[Theta]", 
                  RowBox[{"2", ",", "2"}]], " ", 
                 SubscriptBox["\[Sigma]", 
                  RowBox[{"1", ",", "2"}]]}]}], ")"}]}]}], 
            RowBox[{
             SubsuperscriptBox["\[Sigma]", "2", "2"], "+", 
             RowBox[{
              SubsuperscriptBox["\[Sigma]", "1", "2"], " ", 
              SubsuperscriptBox["\[Theta]", 
               RowBox[{"2", ",", "1"}], "2"]}], "+", 
             RowBox[{
              SubsuperscriptBox["\[Sigma]", "2", "2"], " ", 
              SubsuperscriptBox["\[Theta]", 
               RowBox[{"2", ",", "2"}], "2"]}], "+", 
             RowBox[{"2", " ", 
              SubscriptBox["\[Theta]", 
               RowBox[{"2", ",", "1"}]], " ", 
              SubscriptBox["\[Theta]", 
               RowBox[{"2", ",", "2"}]], " ", 
              SubscriptBox["\[Sigma]", 
               RowBox[{"1", ",", "2"}]]}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.7]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
        Function[BoxForm`e$, 
         MatrixForm[BoxForm`e$]]]},
      {
       TagBox[
        RowBox[{"(", "\[NoBreak]", GridBox[{
           {
            RowBox[{
             RowBox[{
              SubsuperscriptBox["\[Sigma]", "1", "2"], " ", 
              SubscriptBox["\[Theta]", 
               RowBox[{"1", ",", "1"}]]}], "+", 
             RowBox[{
              SubscriptBox["\[Theta]", 
               RowBox[{"1", ",", "2"}]], " ", 
              SubscriptBox["\[Sigma]", 
               RowBox[{"1", ",", "2"}]]}]}], 
            RowBox[{
             RowBox[{
              SubsuperscriptBox["\[Sigma]", "2", "2"], " ", 
              SubscriptBox["\[Theta]", 
               RowBox[{"1", ",", "2"}]]}], "+", 
             RowBox[{
              SubscriptBox["\[Theta]", 
               RowBox[{"1", ",", "1"}]], " ", 
              SubscriptBox["\[Sigma]", 
               RowBox[{"1", ",", "2"}]]}]}]},
           {
            RowBox[{
             RowBox[{
              SubsuperscriptBox["\[Sigma]", "1", "2"], " ", 
              SubscriptBox["\[Theta]", 
               RowBox[{"2", ",", "1"}]]}], "+", 
             RowBox[{
              SubscriptBox["\[Theta]", 
               RowBox[{"2", ",", "2"}]], " ", 
              SubscriptBox["\[Sigma]", 
               RowBox[{"1", ",", "2"}]]}]}], 
            RowBox[{
             RowBox[{
              SubsuperscriptBox["\[Sigma]", "2", "2"], " ", 
              SubscriptBox["\[Theta]", 
               RowBox[{"2", ",", "2"}]]}], "+", 
             RowBox[{
              SubscriptBox["\[Theta]", 
               RowBox[{"2", ",", "1"}]], " ", 
              SubscriptBox["\[Sigma]", 
               RowBox[{"1", ",", "2"}]]}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.7]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
        Function[BoxForm`e$, 
         MatrixForm[BoxForm`e$]]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896259414762*^9, 3.3896259644582*^9}, 
   3.3896276287398*^9, {3.3896279210518*^9, 3.3896279475948*^9}, 
   3.3896310600039997`*^9, 3.389631159632*^9, 3.389707129755224*^9, 
   3.3897101673262243`*^9, 3.389717262429824*^9, 3.3899920948136*^9, 
   3.3899921426636*^9}]
}, Closed]],

Cell["\<\
Solve for VMA parameters by equating the two representations:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{"Flatten", " ", "@", " ", 
    RowBox[{"MapThread", "[", 
     RowBox[{"Equal", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["\[CapitalGamma]", "0"], ",", 
           SubscriptBox["\[CapitalGamma]", "1"]}], "}"}], "/.", 
         SubscriptBox["\[CapitalGamma]", "Rule"]}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["\[CapitalGamma]", "0"], ",", 
           SubscriptBox["\[CapitalGamma]", "1"]}], "}"}], "/.", 
         SubscriptBox["\[CapitalGamma]VMA", "Rule"]}]}], "}"}], ",", "3"}], 
     "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"eq", "//", "TableForm"}]}], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896280344038*^9, 3.3896280781478*^9}, {
  3.3896281184058*^9, 3.3896282082508*^9}}],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}], "\[Equal]", 
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "1", "2"], "+", 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "1", "2"], " ", 
         SubsuperscriptBox["\[Theta]", 
          RowBox[{"1", ",", "1"}], "2"]}], "+", 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "2", "2"], " ", 
         SubsuperscriptBox["\[Theta]", 
          RowBox[{"1", ",", "2"}], "2"]}], "+", 
        RowBox[{"2", " ", 
         SubscriptBox["\[Theta]", 
          RowBox[{"1", ",", "1"}]], " ", 
         SubscriptBox["\[Theta]", 
          RowBox[{"1", ",", "2"}]], " ", 
         SubscriptBox["\[Sigma]", 
          RowBox[{"1", ",", "2"}]]}]}]}]},
     {
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["c", "2"], " ", "\[Rho]"}], "\[Equal]", 
       RowBox[{
        SubscriptBox["\[Sigma]", 
         RowBox[{"1", ",", "2"}]], "+", 
        RowBox[{
         SubscriptBox["\[Theta]", 
          RowBox[{"1", ",", "2"}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SubsuperscriptBox["\[Sigma]", "2", "2"], " ", 
            SubscriptBox["\[Theta]", 
             RowBox[{"2", ",", "2"}]]}], "+", 
           RowBox[{
            SubscriptBox["\[Theta]", 
             RowBox[{"2", ",", "1"}]], " ", 
            SubscriptBox["\[Sigma]", 
             RowBox[{"1", ",", "2"}]]}]}], ")"}]}], "+", 
        RowBox[{
         SubscriptBox["\[Theta]", 
          RowBox[{"1", ",", "1"}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SubsuperscriptBox["\[Sigma]", "1", "2"], " ", 
            SubscriptBox["\[Theta]", 
             RowBox[{"2", ",", "1"}]]}], "+", 
           RowBox[{
            SubscriptBox["\[Theta]", 
             RowBox[{"2", ",", "2"}]], " ", 
            SubscriptBox["\[Sigma]", 
             RowBox[{"1", ",", "2"}]]}]}], ")"}]}]}]}]},
     {
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["c", "2"], " ", "\[Rho]"}], "\[Equal]", 
       RowBox[{
        SubscriptBox["\[Sigma]", 
         RowBox[{"1", ",", "2"}]], "+", 
        RowBox[{
         SubscriptBox["\[Theta]", 
          RowBox[{"1", ",", "2"}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SubsuperscriptBox["\[Sigma]", "2", "2"], " ", 
            SubscriptBox["\[Theta]", 
             RowBox[{"2", ",", "2"}]]}], "+", 
           RowBox[{
            SubscriptBox["\[Theta]", 
             RowBox[{"2", ",", "1"}]], " ", 
            SubscriptBox["\[Sigma]", 
             RowBox[{"1", ",", "2"}]]}]}], ")"}]}], "+", 
        RowBox[{
         SubscriptBox["\[Theta]", 
          RowBox[{"1", ",", "1"}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SubsuperscriptBox["\[Sigma]", "1", "2"], " ", 
            SubscriptBox["\[Theta]", 
             RowBox[{"2", ",", "1"}]]}], "+", 
           RowBox[{
            SubscriptBox["\[Theta]", 
             RowBox[{"2", ",", "2"}]], " ", 
            SubscriptBox["\[Sigma]", 
             RowBox[{"1", ",", "2"}]]}]}], ")"}]}]}]}]},
     {
      RowBox[{
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}], "\[Equal]", 
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "2", "2"], "+", 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "1", "2"], " ", 
         SubsuperscriptBox["\[Theta]", 
          RowBox[{"2", ",", "1"}], "2"]}], "+", 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "2", "2"], " ", 
         SubsuperscriptBox["\[Theta]", 
          RowBox[{"2", ",", "2"}], "2"]}], "+", 
        RowBox[{"2", " ", 
         SubscriptBox["\[Theta]", 
          RowBox[{"2", ",", "1"}]], " ", 
         SubscriptBox["\[Theta]", 
          RowBox[{"2", ",", "2"}]], " ", 
         SubscriptBox["\[Sigma]", 
          RowBox[{"1", ",", "2"}]]}]}]}]},
     {
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["c", "2"]}], "\[Equal]", 
       RowBox[{
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "1", "2"], " ", 
         SubscriptBox["\[Theta]", 
          RowBox[{"1", ",", "1"}]]}], "+", 
        RowBox[{
         SubscriptBox["\[Theta]", 
          RowBox[{"1", ",", "2"}]], " ", 
         SubscriptBox["\[Sigma]", 
          RowBox[{"1", ",", "2"}]]}]}]}]},
     {
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["c", "2"]}], " ", "\[Rho]"}], "\[Equal]", 
       RowBox[{
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "2", "2"], " ", 
         SubscriptBox["\[Theta]", 
          RowBox[{"1", ",", "2"}]]}], "+", 
        RowBox[{
         SubscriptBox["\[Theta]", 
          RowBox[{"1", ",", "1"}]], " ", 
         SubscriptBox["\[Sigma]", 
          RowBox[{"1", ",", "2"}]]}]}]}]},
     {
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["c", "2"]}], " ", "\[Rho]"}], "\[Equal]", 
       RowBox[{
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "1", "2"], " ", 
         SubscriptBox["\[Theta]", 
          RowBox[{"2", ",", "1"}]]}], "+", 
        RowBox[{
         SubscriptBox["\[Theta]", 
          RowBox[{"2", ",", "2"}]], " ", 
         SubscriptBox["\[Sigma]", 
          RowBox[{"1", ",", "2"}]]}]}]}]},
     {
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["c", "2"]}], "\[Equal]", 
       RowBox[{
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "2", "2"], " ", 
         SubscriptBox["\[Theta]", 
          RowBox[{"2", ",", "2"}]]}], "+", 
        RowBox[{
         SubscriptBox["\[Theta]", 
          RowBox[{"2", ",", "1"}]], " ", 
         SubscriptBox["\[Sigma]", 
          RowBox[{"1", ",", "2"}]]}]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896260023682003`*^9, 3.3896276287848*^9, {3.3896279210948*^9, 
   3.3896279504778*^9}, {3.3896280326478*^9, 3.3896280412998*^9}, 
   3.3896280785368*^9, {3.3896281370438004`*^9, 3.3896282088557997`*^9}, 
   3.389631060059*^9, 3.3896311596809998`*^9, 3.389707129805224*^9, 
   3.389717262484824*^9, 3.3899920949056*^9, 3.3899921427665997`*^9}]
}, Closed]],

Cell["The third equation is redundant, so ... ", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e2", "=", 
  RowBox[{"Drop", "[", 
   RowBox[{"eq", ",", 
    RowBox[{"{", "3", "}"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["c", "2"]}], "+", 
     SubsuperscriptBox["\[Sigma]", "u", "2"]}], "\[Equal]", 
    RowBox[{
     SubsuperscriptBox["\[Sigma]", "1", "2"], "+", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "1", "2"], " ", 
      SubsuperscriptBox["\[Theta]", 
       RowBox[{"1", ",", "1"}], "2"]}], "+", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "2", "2"], " ", 
      SubsuperscriptBox["\[Theta]", 
       RowBox[{"1", ",", "2"}], "2"]}], "+", 
     RowBox[{"2", " ", 
      SubscriptBox["\[Theta]", 
       RowBox[{"1", ",", "1"}]], " ", 
      SubscriptBox["\[Theta]", 
       RowBox[{"1", ",", "2"}]], " ", 
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "2"}]]}]}]}], ",", 
   RowBox[{
    RowBox[{"2", " ", 
     SuperscriptBox["c", "2"], " ", "\[Rho]"}], "\[Equal]", 
    RowBox[{
     SubscriptBox["\[Sigma]", 
      RowBox[{"1", ",", "2"}]], "+", 
     RowBox[{
      SubscriptBox["\[Theta]", 
       RowBox[{"1", ",", "2"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "2", "2"], " ", 
         SubscriptBox["\[Theta]", 
          RowBox[{"2", ",", "2"}]]}], "+", 
        RowBox[{
         SubscriptBox["\[Theta]", 
          RowBox[{"2", ",", "1"}]], " ", 
         SubscriptBox["\[Sigma]", 
          RowBox[{"1", ",", "2"}]]}]}], ")"}]}], "+", 
     RowBox[{
      SubscriptBox["\[Theta]", 
       RowBox[{"1", ",", "1"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "1", "2"], " ", 
         SubscriptBox["\[Theta]", 
          RowBox[{"2", ",", "1"}]]}], "+", 
        RowBox[{
         SubscriptBox["\[Theta]", 
          RowBox[{"2", ",", "2"}]], " ", 
         SubscriptBox["\[Sigma]", 
          RowBox[{"1", ",", "2"}]]}]}], ")"}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["c", "2"]}], "+", 
     SubsuperscriptBox["\[Sigma]", "u", "2"]}], "\[Equal]", 
    RowBox[{
     SubsuperscriptBox["\[Sigma]", "2", "2"], "+", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "1", "2"], " ", 
      SubsuperscriptBox["\[Theta]", 
       RowBox[{"2", ",", "1"}], "2"]}], "+", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "2", "2"], " ", 
      SubsuperscriptBox["\[Theta]", 
       RowBox[{"2", ",", "2"}], "2"]}], "+", 
     RowBox[{"2", " ", 
      SubscriptBox["\[Theta]", 
       RowBox[{"2", ",", "1"}]], " ", 
      SubscriptBox["\[Theta]", 
       RowBox[{"2", ",", "2"}]], " ", 
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "2"}]]}]}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["c", "2"]}], "\[Equal]", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "1", "2"], " ", 
      SubscriptBox["\[Theta]", 
       RowBox[{"1", ",", "1"}]]}], "+", 
     RowBox[{
      SubscriptBox["\[Theta]", 
       RowBox[{"1", ",", "2"}]], " ", 
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "2"}]]}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["c", "2"]}], " ", "\[Rho]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "2", "2"], " ", 
      SubscriptBox["\[Theta]", 
       RowBox[{"1", ",", "2"}]]}], "+", 
     RowBox[{
      SubscriptBox["\[Theta]", 
       RowBox[{"1", ",", "1"}]], " ", 
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "2"}]]}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["c", "2"]}], " ", "\[Rho]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "1", "2"], " ", 
      SubscriptBox["\[Theta]", 
       RowBox[{"2", ",", "1"}]]}], "+", 
     RowBox[{
      SubscriptBox["\[Theta]", 
       RowBox[{"2", ",", "2"}]], " ", 
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "2"}]]}]}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["c", "2"]}], "\[Equal]", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "2", "2"], " ", 
      SubscriptBox["\[Theta]", 
       RowBox[{"2", ",", "2"}]]}], "+", 
     RowBox[{
      SubscriptBox["\[Theta]", 
       RowBox[{"2", ",", "1"}]], " ", 
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "2"}]]}]}]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259419611998`*^9, 3.3896276293168*^9, 
  3.3896279211837997`*^9, 3.3896282259877996`*^9, 3.3896310601029997`*^9, 
  3.389631105199*^9, 3.389631159718*^9, 3.389707129842224*^9, 
  3.3897172625298243`*^9, 3.3899920949846*^9, 3.3899921428406*^9}]
}, Closed]],

Cell[BoxData[
 RowBox[{
  RowBox[{"parms", "=", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Theta]", 
      RowBox[{"1", ",", "1"}]], ",", 
     SubscriptBox["\[Theta]", 
      RowBox[{"1", ",", "2"}]], ",", 
     SubscriptBox["\[Theta]", 
      RowBox[{"2", ",", "1"}]], ",", 
     SubscriptBox["\[Theta]", 
      RowBox[{"2", ",", "2"}]], ",", 
     SubsuperscriptBox["\[Sigma]", "1", "2"], ",", 
     SubsuperscriptBox["\[Sigma]", "2", "2"], ",", 
     SubscriptBox["\[Sigma]", 
      RowBox[{"1", ",", "2"}]]}], "}"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896282697818003`*^9, 3.3896282743478003`*^9}, {
  3.389631083987*^9, 3.3896310877390003`*^9}}],

Cell["We'll attempt only a numerical solution here:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"s", "=", 
   RowBox[{"NSolve", "[", 
    RowBox[{
     RowBox[{"e2", "/.", "nValues"}], ",", "parms"}], "]"}]}], ";", 
  RowBox[{"s", "//", "TableForm"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{
      SubscriptBox["\[Theta]", 
       RowBox[{"1", ",", "1"}]], "\[Rule]", 
      RowBox[{"-", "1.1500962263961414`"}]}], 
     RowBox[{
      SubscriptBox["\[Theta]", 
       RowBox[{"1", ",", "2"}]], "\[Rule]", "0.2200599854704513`"}], 
     RowBox[{
      SubscriptBox["\[Theta]", 
       RowBox[{"2", ",", "1"}]], "\[Rule]", "0.2200599854704513`"}], 
     RowBox[{
      SubscriptBox["\[Theta]", 
       RowBox[{"2", ",", "2"}]], "\[Rule]", 
      RowBox[{"-", "1.1500962263961414`"}]}], 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "1", "2"], "\[Rule]", 
      "105.79577605272648`"}], 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "2", "2"], "\[Rule]", 
      "105.79577605272648`"}], 
     RowBox[{
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "2"}]], "\[Rule]", "98.4973381713924`"}]},
    {
     RowBox[{
      SubscriptBox["\[Theta]", 
       RowBox[{"1", ",", "1"}]], "\[Rule]", 
      RowBox[{"-", "0.8299400145311719`"}]}], 
     RowBox[{
      SubscriptBox["\[Theta]", 
       RowBox[{"1", ",", "2"}]], "\[Rule]", 
      RowBox[{"-", "0.10009622639457186`"}]}], 
     RowBox[{
      SubscriptBox["\[Theta]", 
       RowBox[{"2", ",", "1"}]], "\[Rule]", 
      RowBox[{"-", "0.10009622639457186`"}]}], 
     RowBox[{
      SubscriptBox["\[Theta]", 
       RowBox[{"2", ",", "2"}]], "\[Rule]", 
      RowBox[{"-", "0.8299400145311719`"}]}], 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "1", "2"], "\[Rule]", 
      "108.99733817137135`"}], 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "2", "2"], "\[Rule]", 
      "108.99733817137135`"}], 
     RowBox[{
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "2"}]], "\[Rule]", "95.29577605273735`"}]},
    {
     RowBox[{
      SubscriptBox["\[Theta]", 
       RowBox[{"1", ",", "1"}]], "\[Rule]", 
      RowBox[{"-", "1.222691564424014`"}]}], 
     RowBox[{
      SubscriptBox["\[Theta]", 
       RowBox[{"1", ",", "2"}]], "\[Rule]", "0.1474646474547699`"}], 
     RowBox[{
      SubscriptBox["\[Theta]", 
       RowBox[{"2", ",", "1"}]], "\[Rule]", "0.1474646474547699`"}], 
     RowBox[{
      SubscriptBox["\[Theta]", 
       RowBox[{"2", ",", "2"}]], "\[Rule]", 
      RowBox[{"-", "1.222691564424014`"}]}], 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "1", "2"], "\[Rule]", 
      "92.0026618285279`"}], 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "2", "2"], "\[Rule]", 
      "92.0026618285279`"}], 
     RowBox[{
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "2"}]], "\[Rule]", "84.70422394731574`"}]},
    {
     RowBox[{
      SubscriptBox["\[Theta]", 
       RowBox[{"1", ",", "1"}]], "\[Rule]", 
      RowBox[{"-", "0.9025353525468209`"}]}], 
     RowBox[{
      SubscriptBox["\[Theta]", 
       RowBox[{"1", ",", "2"}]], "\[Rule]", 
      RowBox[{"-", "0.17269156442236905`"}]}], 
     RowBox[{
      SubscriptBox["\[Theta]", 
       RowBox[{"2", ",", "1"}]], "\[Rule]", 
      RowBox[{"-", "0.17269156442236905`"}]}], 
     RowBox[{
      SubscriptBox["\[Theta]", 
       RowBox[{"2", ",", "2"}]], "\[Rule]", 
      RowBox[{"-", "0.9025353525468209`"}]}], 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "1", "2"], "\[Rule]", 
      "95.20422394730468`"}], 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "2", "2"], "\[Rule]", 
      "95.20422394730468`"}], 
     RowBox[{
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "2"}]], "\[Rule]", "81.50266182854921`"}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259424482*^9, 3.3896276297218*^9, 
  3.3896279212167997`*^9, 3.3896282332757998`*^9, 3.3896282785228*^9, 
  3.3896310601730003`*^9, 3.389631110322*^9, 3.3896311598050003`*^9, 
  3.389707130022224*^9, 3.389717262637824*^9, 3.3899921430336*^9}]
}, Closed]],

Cell["Consider the matrix", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"DD", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\[Theta]", "[", "L", "]"}], "/.", 
       RowBox[{"L", "\[Rule]", 
        RowBox[{"1", "/", "L"}]}]}], ")"}], "*", "L"}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"DD", "//", "MatrixForm"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"L", "+", 
       SubscriptBox["\[Theta]", 
        RowBox[{"1", ",", "1"}]]}], 
      SubscriptBox["\[Theta]", 
       RowBox[{"1", ",", "2"}]]},
     {
      SubscriptBox["\[Theta]", 
       RowBox[{"2", ",", "1"}]], 
      RowBox[{"L", "+", 
       SubscriptBox["\[Theta]", 
        RowBox[{"2", ",", "2"}]]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896259424972*^9, 3.3896276297658*^9, 3.3896279212578*^9, 
   3.3896284638688*^9, 3.389631060249*^9, {3.3896311372460003`*^9, 
   3.389631159843*^9}, 3.3897071300572243`*^9, 3.3897172626818237`*^9, 
   3.3899921430966*^9}]
}, Closed]],

Cell["\<\
For the VMA to be invertible, the roots of the determinental equation \
Det[DD]=0 must lie inside the unit circle. We check:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Det", "[", "DD", "]"}], "\[Equal]", "0"}], "/.", 
        RowBox[{"s", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ",", "L"}], "]"}], "//", 
     "Flatten"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "4"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896284691398*^9, 3.3896284694798*^9}, {
  3.389631146926*^9, 3.389631147443*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"L", "\[Rule]", "0.9300362409256906`"}], 
      RowBox[{"L", "\[Rule]", "1.3701562118665922`"}]},
     {
      RowBox[{"L", "\[Rule]", "0.7298437881366008`"}], 
      RowBox[{"L", "\[Rule]", "0.9300362409257431`"}]},
     {
      RowBox[{"L", "\[Rule]", "1.0752269169692443`"}], 
      RowBox[{"L", "\[Rule]", "1.3701562118787836`"}]},
     {
      RowBox[{"L", "\[Rule]", "0.7298437881244515`"}], 
      RowBox[{"L", "\[Rule]", "1.0752269169691904`"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896259428852*^9, 3.3896276301577997`*^9, 3.3896279213858*^9, 
   3.3896284709438*^9, 3.389631060752*^9, {3.389631148073*^9, 
   3.3896311598789997`*^9}, 3.3897071300982237`*^9, 3.389717262719824*^9, 
   3.3899921431535997`*^9}]
}, Closed]],

Cell["Only the second solution is invertible:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sInvertible", "=", 
  RowBox[{"s", "[", 
   RowBox[{"[", "2", "]"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896284763968*^9, 3.3896284767608*^9}, {
  3.389631173203*^9, 3.3896311739440002`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["\[Theta]", 
     RowBox[{"1", ",", "1"}]], "\[Rule]", 
    RowBox[{"-", "0.8299400145311719`"}]}], ",", 
   RowBox[{
    SubscriptBox["\[Theta]", 
     RowBox[{"1", ",", "2"}]], "\[Rule]", 
    RowBox[{"-", "0.10009622639457186`"}]}], ",", 
   RowBox[{
    SubscriptBox["\[Theta]", 
     RowBox[{"2", ",", "1"}]], "\[Rule]", 
    RowBox[{"-", "0.10009622639457186`"}]}], ",", 
   RowBox[{
    SubscriptBox["\[Theta]", 
     RowBox[{"2", ",", "2"}]], "\[Rule]", 
    RowBox[{"-", "0.8299400145311719`"}]}], ",", 
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "1", "2"], "\[Rule]", 
    "108.99733817137135`"}], ",", 
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "2", "2"], "\[Rule]", 
    "108.99733817137135`"}], ",", 
   RowBox[{
    SubscriptBox["\[Sigma]", 
     RowBox[{"1", ",", "2"}]], "\[Rule]", "95.29577605273735`"}]}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896259429412003`*^9, 3.3896276302488003`*^9, 3.3896279214258003`*^9, 
   3.3896284779908*^9, 3.389631060837*^9, {3.389631159895*^9, 
   3.389631176109*^9}, 3.389707130140224*^9, 3.389717262764824*^9, 
   3.3899921432106*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     SubscriptBox["\[Theta]", 
      RowBox[{"i", ",", "j"}]], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "2"}], "}"}]}], "]"}], "/.", "sInvertible"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "0.8299400145311719`"}], 
      RowBox[{"-", "0.10009622639457186`"}]},
     {
      RowBox[{"-", "0.10009622639457186`"}], 
      RowBox[{"-", "0.8299400145311719`"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896259429922*^9, 3.3896276302998*^9, 3.3896279214737997`*^9, 
   3.3896284849268*^9, 3.389631060885*^9, {3.389631159933*^9, 
   3.389631183413*^9}, 3.3897071301752243`*^9, 3.389717262802824*^9, 
   3.3899921432665997`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalOmega]", "/.", "sInvertible"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"108.99733817137135`", "95.29577605273735`"},
     {"95.29577605273735`", "108.99733817137135`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896259431012*^9, 3.3896276303478003`*^9, 3.3896279215178003`*^9, 
   3.3896284897748003`*^9, 3.389631060927*^9, {3.389631159976*^9, 
   3.3896311864440002`*^9}, 3.389707130211224*^9, 3.3897172628458242`*^9, 
   3.3899921433176003`*^9}]
}, Closed]],

Cell["Verify the computation of the random-walk variance:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[Theta]", "[", "1", "]"}], ".", "\[CapitalOmega]", ".", 
     RowBox[{"Transpose", "[", 
      RowBox[{"\[Theta]", "[", "1", "]"}], "]"}]}], "/.", "sInvertible"}], "//",
    "Chop"}], "//", "MatrixForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.9999999999645369`", "0"},
     {"0", "0.9999999999645369`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896259431872*^9, 3.3896276303958*^9, 3.3896279215618*^9, 
   3.3896284923168*^9, 3.389631060969*^9, {3.3896311600150003`*^9, 
   3.389631188881*^9}, 3.389707130251224*^9, 3.389717262885824*^9, 
   3.3899921433726*^9}]
}, Closed]],

Cell["Variance decomposition.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"F", "=", 
    RowBox[{"CholeskyDecomposition", "[", 
     RowBox[{"\[CapitalOmega]", "/.", "sInvertible"}], "]"}]}], ")"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"10.440179029660907`", "9.127791370435197`"},
     {"0.`", "5.067619053281343`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259432441998`*^9, 3.3896276304468*^9, 
  3.3896279216118*^9, 3.3896284967068*^9, 3.389631061066*^9, 
  3.389631160076*^9, 3.38963119184*^9, 3.389707130313224*^9, 
  3.389717262929824*^9, 3.3899921434435997`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Transpose", "[", "F", "]"}], "//", "MatrixForm"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       InterpretationBox["\<\"10.44\"\>",
        10.440179029660907`,
        AutoDelete->True], 
       InterpretationBox["\<\"0.00\"\>",
        0.,
        AutoDelete->True]},
      {
       InterpretationBox["\<\"9.13\"\>",
        9.127791370435197,
        AutoDelete->True], 
       InterpretationBox["\<\"5.07\"\>",
        5.067619053281343,
        AutoDelete->True]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]],
  NumberForm[#, {5, 2}]& ]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259432892*^9, 3.3896276304918003`*^9, 
  3.3896279216507998`*^9, 3.3896285025088*^9, 3.389631061104*^9, 
  3.3896311601219997`*^9, 3.3896311944779997`*^9, 3.3897071303482237`*^9, 
  3.389717262966824*^9, 3.3899921434966*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"\[Theta]", "[", "1", "]"}], ".", 
      RowBox[{"Transpose", "[", "F", "]"}]}], "/.", "sInvertible"}], "//", 
    "MatrixForm"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       InterpretationBox["\<\"0.862\"\>",
        0.8617992225785963,
        AutoDelete->True], 
       InterpretationBox["\<\"-0.507\"\>",
        -0.5072495440386953,
        AutoDelete->True]},
      {
       InterpretationBox["\<\"0.507\"\>",
        0.5072495440659042,
        AutoDelete->True], 
       InterpretationBox["\<\"0.862\"\>",
        0.8617992225625815,
        AutoDelete->True]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]],
  NumberForm[#, {5, 3}]& ]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259433431997`*^9, 3.3896276305458*^9, 
  3.3896279216998*^9, 3.3896285064438*^9, 3.389631061156*^9, 
  3.389631160167*^9, 3.3896311959309998`*^9, 3.389707130389224*^9, 
  3.389717263007824*^9, 3.3899921435526*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Theta]", "[", "1", "]"}], ".", 
      RowBox[{"Transpose", "[", "F", "]"}]}], "/.", "sInvertible"}], ")"}], 
   "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.8617992225785963`", ",", 
   RowBox[{"-", "0.5072495440386953`"}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259433942003`*^9, 3.3896276305978003`*^9, 
  3.3896279217458*^9, 3.3896285088568*^9, 3.3896310612019997`*^9, 
  3.389631160216*^9, 3.389631197328*^9, 3.3897071304402237`*^9, 
  3.3897172630638237`*^9, 3.3899921436026*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  SuperscriptBox["r", "2"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.742697900037073`", ",", "0.2573020999274642`"}], "}"}]], "Output",\

 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896285323878*^9, 3.389631061238*^9, 
  3.3896311602539997`*^9, 3.389631200927*^9, 3.389707130474224*^9, 
  3.389717263099824*^9, 3.3899921436745996`*^9}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Cointegrated model (Chapter 10, section 10.2)", "Subsection"],

Cell[CellGroupData[{

Cell["Model", "Subsubsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["p", "Rule"], " ", "=", 
   RowBox[{"{", " ", 
    RowBox[{
     RowBox[{
      SubscriptBox["p", 
       RowBox[{"1", ",", "t_"}]], "\[RuleDelayed]", 
      RowBox[{
       SubscriptBox["m", "t"], "+", 
       RowBox[{"c", " ", 
        SubscriptBox["q", "t"]}]}]}], ",", 
     RowBox[{
      SubscriptBox["p", 
       RowBox[{"2", ",", "t_"}]], "\[RuleDelayed]", 
      SubscriptBox["m", 
       RowBox[{"t", "-", "1"}]]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["m", "Rule"], "=", 
   RowBox[{
    SubscriptBox["m", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", 
      RowBox[{"t", "-", "1"}]], "+", 
     SubscriptBox["u", "t"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "Rule"], " ", "=", " ", 
   RowBox[{
    SubscriptBox["\[CapitalDelta]p", 
     RowBox[{"i_", ",", "t_"}]], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["p", 
         RowBox[{"i", ",", "t"}]], "/.", 
        SubscriptBox["p", "Rule"]}], "/.", 
       SubscriptBox["m", "Rule"]}], ")"}], "-", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["p", 
        RowBox[{"i", ",", 
         RowBox[{"t", "-", "1"}]}]], "/.", 
       SubscriptBox["p", "Rule"]}], ")"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "t_"], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      SubscriptBox["\[CapitalDelta]p", 
       RowBox[{"1", ",", "t"}]], "}"}], ",", 
     RowBox[{"{", 
      SubscriptBox["\[CapitalDelta]p", 
       RowBox[{"2", ",", "t"}]], "}"}]}], "}"}]}], ";"}]}], "Input",
 CellLabelAutoDelete->True],

Cell["The vector of price differences is:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "t"], "/.", 
   SubscriptBox["\[CapitalDelta]p", "Rule"]}], "//", "MatrixForm"}]], "Input",\

 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{
        RowBox[{"-", "c"}], " ", 
        SubscriptBox["q", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "t"}]]}], "+", 
       RowBox[{"c", " ", 
        SubscriptBox["q", "t"]}], "+", 
       SubscriptBox["u", "t"]}]},
     {
      SubscriptBox["u", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "t"}]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896285472918*^9, 3.3896310613380003`*^9, 
  3.3896312470889997`*^9, 3.389717285561824*^9, 3.3899921437436*^9}]
}, Closed]],

Cell["The difference between the two prices is:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"(", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["p", 
       RowBox[{"1", ",", "t"}]], "/.", 
      SubscriptBox["p", "Rule"]}], "/.", 
     SubscriptBox["m", "Rule"]}], ")"}], "-", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["p", 
      RowBox[{"2", ",", "t"}]], "/.", 
     SubscriptBox["p", "Rule"]}], ")"}]}], ")"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"c", " ", 
   SubscriptBox["q", "t"]}], "+", 
  SubscriptBox["u", "t"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896285473318*^9, 3.389631061377*^9, 3.389631247119*^9, 
  3.389717285594824*^9, 3.3899921437966003`*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Structural VMA representation: VMA I", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Theta]", "[", "L_", "]"}], ":=", 
  RowBox[{
   SubscriptBox["\[Theta]", "0"], "+", 
   RowBox[{
    SubscriptBox["\[Theta]", "1"], "L"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Epsilon]", "Rule"], "=", 
   RowBox[{
    SubscriptBox["\[Epsilon]", "t_"], "\[RuleDelayed]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       SubscriptBox["u", "t"], "}"}], ",", 
      RowBox[{"{", 
       SubscriptBox["q", "t"], "}"}]}], "}"}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["\[Theta]", "Rules"], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Rule", "[", 
      RowBox[{
       SubscriptBox["\[Theta]", "s"], ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Coefficient", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["\[CapitalDelta]p", "t"], "/.", 
              SubscriptBox["\[CapitalDelta]p", "Rule"]}], ")"}], "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["\[Epsilon]", 
               RowBox[{"t", "-", "s"}]], "/.", 
              SubscriptBox["\[Epsilon]", "Rule"]}], ")"}], "[", 
            RowBox[{"[", 
             RowBox[{"j", ",", "1"}], "]"}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "2"}], "}"}]}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "0", ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"Map", "[", 
    RowBox[{"MatrixForm", ",", 
     SubscriptBox["\[Theta]", "Rules"], ",", 
     RowBox[{"{", "2", "}"}]}], "]"}], "}"}], "//", "TableForm"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{
      TagBox[
       SubscriptBox["\[Theta]", "0"],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], "\[Rule]", 
      TagBox[GridBox[{
         {"1", "c"},
         {"0", "0"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]]}], 
     RowBox[{
      TagBox[
       SubscriptBox["\[Theta]", "1"],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], "\[Rule]", 
      TagBox[GridBox[{
         {"0", 
          RowBox[{"-", "c"}]},
         {"1", "0"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]]}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896285552748003`*^9, 3.389631061434*^9, 
  3.389631247174*^9, 3.389717285643824*^9, 3.3899921438775997`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "\[CapitalOmega]", "]"}], ";"}], "\n", 
 RowBox[{
  SubscriptBox["\[CapitalOmega]", "Rule"], "=", 
  RowBox[{"\[CapitalOmega]", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "u", "2"], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"\[CapitalOmega]", "\[Rule]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896285553128*^9, 3.389631061472*^9, 3.389631247209*^9, 
  3.3897172856878242`*^9, 3.3899921439306*^9}]
}, Closed]],

Cell["Autocovariance generating function:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"agfI", "=", 
   RowBox[{"G", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Theta]", "[", "L", "]"}], "/.", 
      SubscriptBox["\[Theta]", "Rules"]}], ",", 
     RowBox[{"\[CapitalOmega]", "/.", 
      SubscriptBox["\[CapitalOmega]", "Rule"]}], ",", "z"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"PolyForm", "[", 
  RowBox[{"agfI", ",", "z"}], "]"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"z", " ", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", 
         SuperscriptBox["c", "2"]}], "0"},
       {
        SubsuperscriptBox["\[Sigma]", "u", "2"], "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "+", 
  FractionBox[
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", 
         SuperscriptBox["c", "2"]}], 
        SubsuperscriptBox["\[Sigma]", "u", "2"]},
       {"0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "z"], "+", 
  RowBox[{"\<\"\"\>", " ", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         SubsuperscriptBox["\[Sigma]", "u", "2"]}], "0"},
       {"0", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896285553638*^9, 3.389631061519*^9, 3.389631247243*^9, 
  3.3897172857398243`*^9, 3.3899921439926*^9}]
}, Closed]],

Cell["This can't be inverted:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Inverse", "[", 
     RowBox[{
      RowBox[{"\[Theta]", "[", "L", "]"}], "/.", 
      SubscriptBox["\[Theta]", "Rules"]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"L", ",", "0", ",", "5"}], "}"}]}], "]"}], "//", 
  "PolyForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"\<\"\"\>", " ", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0"},
       {
        FractionBox["1", "c"], 
        RowBox[{"-", 
         FractionBox["1", "c"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "+", 
  RowBox[{"L", " ", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0"},
       {
        FractionBox["1", "c"], 
        RowBox[{"-", 
         FractionBox["1", "c"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "+", 
  RowBox[{
   SuperscriptBox["L", "2"], " ", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0"},
       {
        FractionBox["1", "c"], 
        RowBox[{"-", 
         FractionBox["1", "c"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "+", 
  RowBox[{
   SuperscriptBox["L", "3"], " ", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0"},
       {
        FractionBox["1", "c"], 
        RowBox[{"-", 
         FractionBox["1", "c"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "+", 
  RowBox[{
   SuperscriptBox["L", "4"], " ", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0"},
       {
        FractionBox["1", "c"], 
        RowBox[{"-", 
         FractionBox["1", "c"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "+", 
  RowBox[{
   SuperscriptBox["L", "5"], " ", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0"},
       {
        FractionBox["1", "c"], 
        RowBox[{"-", 
         FractionBox["1", "c"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "+", 
  FractionBox[
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "1"},
       {"0", 
        RowBox[{"-", 
         FractionBox["1", "c"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "L"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896285554547997`*^9, 3.389631061575*^9, 
  3.389631247283*^9, 3.389717285802824*^9, 3.3899921440816*^9}]
}, Closed]],

Cell["But it gives the correct random-walk variance:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"\[Theta]", "[", "1", "]"}], ".", "\[CapitalOmega]", ".", 
    RowBox[{"Transpose", "[", 
     RowBox[{"\[Theta]", "[", "1", "]"}], "]"}]}], "/.", 
   SubscriptBox["\[Theta]", "Rules"]}], "/.", 
  SubscriptBox["\[CapitalOmega]", "Rule"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubsuperscriptBox["\[Sigma]", "u", "2"], ",", 
     SubsuperscriptBox["\[Sigma]", "u", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubsuperscriptBox["\[Sigma]", "u", "2"], ",", 
     SubsuperscriptBox["\[Sigma]", "u", "2"]}], "}"}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896285555098*^9, 3.389631061613*^9, 3.389631247317*^9, 
  3.3897172858648243`*^9, 3.3899921441366*^9}]
}, Closed]],

Cell["\<\
(There is one random-walk component underlying both securities.)\
\>", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["VMA representation computed from autocovariances: VMA II", \
"Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Theta]II", "[", "L_", "]"}], ":=", 
   RowBox[{
    RowBox[{"IdentityMatrix", "[", "2", "]"}], "+", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       SubscriptBox["\[Theta]", 
        RowBox[{"i", ",", "j"}]], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "2"}], "}"}]}], "]"}], "L"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]II", "[", "L", "]"}], "//", "PolyForm"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"\<\"\"\>", " ", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0"},
       {"0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "+", 
  RowBox[{"L", " ", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["\[Theta]", 
         RowBox[{"1", ",", "1"}]], 
        SubscriptBox["\[Theta]", 
         RowBox[{"1", ",", "2"}]]},
       {
        SubscriptBox["\[Theta]", 
         RowBox[{"2", ",", "1"}]], 
        SubscriptBox["\[Theta]", 
         RowBox[{"2", ",", "2"}]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896285658348*^9, 3.389631061653*^9, 3.389631247351*^9, 
  3.389717285928824*^9, 3.3899921441976*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalOmega]II", "Rule"], "=", 
   RowBox[{"\[CapitalOmega]", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "1", "2"], ",", 
        SubscriptBox["\[Sigma]", 
         RowBox[{"1", ",", "2"}]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["\[Sigma]", 
         RowBox[{"1", ",", "2"}]], ",", 
        SubsuperscriptBox["\[Sigma]", "2", "2"]}], "}"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalOmega]", "/.", 
   SubscriptBox["\[CapitalOmega]II", "Rule"]}], "//", 
  "MatrixForm"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SubsuperscriptBox["\[Sigma]", "1", "2"], 
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "2"}]]},
     {
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "2"}]], 
      SubsuperscriptBox["\[Sigma]", "2", "2"]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896285658918*^9, 3.3896310617*^9, 3.389631247388*^9, 
  3.389717286021824*^9, 3.3899921442586*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"agfII", "=", 
   RowBox[{"G", "[", 
    RowBox[{
     RowBox[{"\[Theta]II", "[", "L", "]"}], ",", 
     RowBox[{"\[CapitalOmega]", "/.", 
      SubscriptBox["\[CapitalOmega]II", "Rule"]}], ",", "z"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"PolyForm", "[", 
  RowBox[{"agfII", ",", "z", ",", "vert"}], "]"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"PolyForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        FractionBox[
         RowBox[{
          SubscriptBox["\[Theta]", 
           RowBox[{"1", ",", "2"}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"z", " ", 
             SubsuperscriptBox["\[Sigma]", "2", "2"], " ", 
             SubscriptBox["\[Theta]", 
              RowBox[{"1", ",", "2"}]]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"z", " ", 
                SubscriptBox["\[Theta]", 
                 RowBox[{"1", ",", "1"}]]}]}], ")"}], " ", 
             SubscriptBox["\[Sigma]", 
              RowBox[{"1", ",", "2"}]]}]}], ")"}]}], "z"], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox[
            SubscriptBox["\[Theta]", 
             RowBox[{"1", ",", "1"}]], "z"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SubsuperscriptBox["\[Sigma]", "1", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"z", " ", 
               SubscriptBox["\[Theta]", 
                RowBox[{"1", ",", "1"}]]}]}], ")"}]}], "+", 
           RowBox[{"z", " ", 
            SubscriptBox["\[Theta]", 
             RowBox[{"1", ",", "2"}]], " ", 
            SubscriptBox["\[Sigma]", 
             RowBox[{"1", ",", "2"}]]}]}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox[
            SubscriptBox["\[Theta]", 
             RowBox[{"2", ",", "2"}]], "z"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"z", " ", 
            SubsuperscriptBox["\[Sigma]", "2", "2"], " ", 
            SubscriptBox["\[Theta]", 
             RowBox[{"1", ",", "2"}]]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"z", " ", 
               SubscriptBox["\[Theta]", 
                RowBox[{"1", ",", "1"}]]}]}], ")"}], " ", 
            SubscriptBox["\[Sigma]", 
             RowBox[{"1", ",", "2"}]]}]}], ")"}]}], "+", 
        FractionBox[
         RowBox[{
          SubscriptBox["\[Theta]", 
           RowBox[{"2", ",", "1"}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SubsuperscriptBox["\[Sigma]", "1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"z", " ", 
                SubscriptBox["\[Theta]", 
                 RowBox[{"1", ",", "1"}]]}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             SubscriptBox["\[Theta]", 
              RowBox[{"1", ",", "2"}]], " ", 
             SubscriptBox["\[Sigma]", 
              RowBox[{"1", ",", "2"}]]}]}], ")"}]}], "z"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        FractionBox[
         RowBox[{
          SubscriptBox["\[Theta]", 
           RowBox[{"1", ",", "2"}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SubsuperscriptBox["\[Sigma]", "2", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"z", " ", 
                SubscriptBox["\[Theta]", 
                 RowBox[{"2", ",", "2"}]]}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             SubscriptBox["\[Theta]", 
              RowBox[{"2", ",", "1"}]], " ", 
             SubscriptBox["\[Sigma]", 
              RowBox[{"1", ",", "2"}]]}]}], ")"}]}], "z"], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox[
            SubscriptBox["\[Theta]", 
             RowBox[{"1", ",", "1"}]], "z"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"z", " ", 
            SubsuperscriptBox["\[Sigma]", "1", "2"], " ", 
            SubscriptBox["\[Theta]", 
             RowBox[{"2", ",", "1"}]]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"z", " ", 
               SubscriptBox["\[Theta]", 
                RowBox[{"2", ",", "2"}]]}]}], ")"}], " ", 
            SubscriptBox["\[Sigma]", 
             RowBox[{"1", ",", "2"}]]}]}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox[
            SubscriptBox["\[Theta]", 
             RowBox[{"2", ",", "2"}]], "z"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SubsuperscriptBox["\[Sigma]", "2", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"z", " ", 
               SubscriptBox["\[Theta]", 
                RowBox[{"2", ",", "2"}]]}]}], ")"}]}], "+", 
           RowBox[{"z", " ", 
            SubscriptBox["\[Theta]", 
             RowBox[{"2", ",", "1"}]], " ", 
            SubscriptBox["\[Sigma]", 
             RowBox[{"1", ",", "2"}]]}]}], ")"}]}], "+", 
        FractionBox[
         RowBox[{
          SubscriptBox["\[Theta]", 
           RowBox[{"2", ",", "1"}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"z", " ", 
             SubsuperscriptBox["\[Sigma]", "1", "2"], " ", 
             SubscriptBox["\[Theta]", 
              RowBox[{"2", ",", "1"}]]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"z", " ", 
                SubscriptBox["\[Theta]", 
                 RowBox[{"2", ",", "2"}]]}]}], ")"}], " ", 
             SubscriptBox["\[Sigma]", 
              RowBox[{"1", ",", "2"}]]}]}], ")"}]}], "z"]}]}], "}"}]}], "}"}],
    ",", "z", ",", "vert"}], "]"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896285659477997`*^9, 3.389631061758*^9, 
  3.389631247433*^9, 3.389717286090824*^9, 3.3899921443255997`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"e", "=", 
   RowBox[{"Union", " ", "@", " ", 
    RowBox[{"Flatten", " ", "@", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"MapThread", "[", 
        RowBox[{"Equal", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Coefficient", "[", 
            RowBox[{"agfI", ",", "z", ",", "k"}], "]"}], ",", 
           RowBox[{"Coefficient", "[", 
            RowBox[{"agfII", ",", "z", ",", "k"}], "]"}]}], "}"}], ",", "2"}],
         "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "1"}], "}"}]}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"e", "//", "TableForm"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{"0", "\[Equal]", 
       RowBox[{
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "2", "2"], " ", 
         SubscriptBox["\[Theta]", 
          RowBox[{"1", ",", "2"}]]}], "+", 
        RowBox[{
         SubscriptBox["\[Theta]", 
          RowBox[{"1", ",", "1"}]], " ", 
         SubscriptBox["\[Sigma]", 
          RowBox[{"1", ",", "2"}]]}]}]}]},
     {
      RowBox[{"0", "\[Equal]", 
       RowBox[{
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "2", "2"], " ", 
         SubscriptBox["\[Theta]", 
          RowBox[{"2", ",", "2"}]]}], "+", 
        RowBox[{
         SubscriptBox["\[Theta]", 
          RowBox[{"2", ",", "1"}]], " ", 
         SubscriptBox["\[Sigma]", 
          RowBox[{"1", ",", "2"}]]}]}]}]},
     {
      RowBox[{"0", "\[Equal]", 
       RowBox[{
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "1", "2"], " ", 
         SubscriptBox["\[Theta]", 
          RowBox[{"1", ",", "1"}]], " ", 
         SubscriptBox["\[Theta]", 
          RowBox[{"2", ",", "1"}]]}], "+", 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "2", "2"], " ", 
         SubscriptBox["\[Theta]", 
          RowBox[{"1", ",", "2"}]], " ", 
         SubscriptBox["\[Theta]", 
          RowBox[{"2", ",", "2"}]]}], "+", 
        SubscriptBox["\[Sigma]", 
         RowBox[{"1", ",", "2"}]], "+", 
        RowBox[{
         SubscriptBox["\[Theta]", 
          RowBox[{"1", ",", "2"}]], " ", 
         SubscriptBox["\[Theta]", 
          RowBox[{"2", ",", "1"}]], " ", 
         SubscriptBox["\[Sigma]", 
          RowBox[{"1", ",", "2"}]]}], "+", 
        RowBox[{
         SubscriptBox["\[Theta]", 
          RowBox[{"1", ",", "1"}]], " ", 
         SubscriptBox["\[Theta]", 
          RowBox[{"2", ",", "2"}]], " ", 
         SubscriptBox["\[Sigma]", 
          RowBox[{"1", ",", "2"}]]}]}]}]},
     {
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["c", "2"]}], "\[Equal]", 
       RowBox[{
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "1", "2"], " ", 
         SubscriptBox["\[Theta]", 
          RowBox[{"1", ",", "1"}]]}], "+", 
        RowBox[{
         SubscriptBox["\[Theta]", 
          RowBox[{"1", ",", "2"}]], " ", 
         SubscriptBox["\[Sigma]", 
          RowBox[{"1", ",", "2"}]]}]}]}]},
     {
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "u", "2"], "\[Equal]", 
       RowBox[{
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "1", "2"], " ", 
         SubscriptBox["\[Theta]", 
          RowBox[{"2", ",", "1"}]]}], "+", 
        RowBox[{
         SubscriptBox["\[Theta]", 
          RowBox[{"2", ",", "2"}]], " ", 
         SubscriptBox["\[Sigma]", 
          RowBox[{"1", ",", "2"}]]}]}]}]},
     {
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "u", "2"], "\[Equal]", 
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "2", "2"], "+", 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "1", "2"], " ", 
         SubsuperscriptBox["\[Theta]", 
          RowBox[{"2", ",", "1"}], "2"]}], "+", 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "2", "2"], " ", 
         SubsuperscriptBox["\[Theta]", 
          RowBox[{"2", ",", "2"}], "2"]}], "+", 
        RowBox[{"2", " ", 
         SubscriptBox["\[Theta]", 
          RowBox[{"2", ",", "1"}]], " ", 
         SubscriptBox["\[Theta]", 
          RowBox[{"2", ",", "2"}]], " ", 
         SubscriptBox["\[Sigma]", 
          RowBox[{"1", ",", "2"}]]}]}]}]},
     {
      RowBox[{
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}], "\[Equal]", 
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "1", "2"], "+", 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "1", "2"], " ", 
         SubsuperscriptBox["\[Theta]", 
          RowBox[{"1", ",", "1"}], "2"]}], "+", 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "2", "2"], " ", 
         SubsuperscriptBox["\[Theta]", 
          RowBox[{"1", ",", "2"}], "2"]}], "+", 
        RowBox[{"2", " ", 
         SubscriptBox["\[Theta]", 
          RowBox[{"1", ",", "1"}]], " ", 
         SubscriptBox["\[Theta]", 
          RowBox[{"1", ",", "2"}]], " ", 
         SubscriptBox["\[Sigma]", 
          RowBox[{"1", ",", "2"}]]}]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896285660168*^9, 3.389631061836*^9, 
  3.3896312474700003`*^9, 3.389717286141824*^9, 3.3899921443966*^9}]
}, Closed]],

Cell[BoxData[
 RowBox[{
  RowBox[{"parms", "=", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Theta]", 
      RowBox[{"1", ",", "1"}]], ",", 
     SubscriptBox["\[Theta]", 
      RowBox[{"1", ",", "2"}]], ",", 
     SubscriptBox["\[Theta]", 
      RowBox[{"2", ",", "1"}]], ",", 
     SubscriptBox["\[Theta]", 
      RowBox[{"2", ",", "2"}]], ",", 
     SubsuperscriptBox["\[Sigma]", "1", "2"], ",", 
     SubsuperscriptBox["\[Sigma]", "2", "2"], ",", 
     SubscriptBox["\[Sigma]", 
      RowBox[{"1", ",", "2"}]]}], "}"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896285810198*^9, 3.3896285844807997`*^9}, {
  3.389631266783*^9, 3.3896312704630003`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"solution", "=", 
   RowBox[{"Solve", "[", 
    RowBox[{"e", ",", "parms"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"solution", "//", "Transpose"}], "//", "TableForm"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "1", "2"], "\[Rule]", 
      FractionBox[
       RowBox[{
        SuperscriptBox["c", "4"], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "2"], " ", 
         SubsuperscriptBox["\[Sigma]", "u", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          SubsuperscriptBox["\[Sigma]", "u", "2"], ")"}], "2"]}], 
       RowBox[{
        SuperscriptBox["c", "2"], "+", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "1", "2"], "\[Rule]", 
      FractionBox[
       RowBox[{
        SuperscriptBox["c", "4"], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "2"], " ", 
         SubsuperscriptBox["\[Sigma]", "u", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          SubsuperscriptBox["\[Sigma]", "u", "2"], ")"}], "2"]}], 
       RowBox[{
        SuperscriptBox["c", "2"], "+", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]},
    {
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "2", "2"], "\[Rule]", 
      FractionBox[
       RowBox[{
        SuperscriptBox["c", "2"], " ", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}], 
       RowBox[{
        SuperscriptBox["c", "2"], "+", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "2", "2"], "\[Rule]", 
      FractionBox[
       RowBox[{
        SuperscriptBox["c", "2"], " ", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}], 
       RowBox[{
        SuperscriptBox["c", "2"], "+", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\[Theta]", 
       RowBox[{"1", ",", "2"}]], "\[Rule]", 
      FractionBox[
       SuperscriptBox["c", "2"], 
       RowBox[{
        SuperscriptBox["c", "2"], "+", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], 
     RowBox[{
      SubscriptBox["\[Theta]", 
       RowBox[{"1", ",", "2"}]], "\[Rule]", 
      FractionBox[
       SuperscriptBox["c", "2"], 
       RowBox[{
        SuperscriptBox["c", "2"], "+", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\[Theta]", 
       RowBox[{"2", ",", "2"}]], "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        SubsuperscriptBox["\[Sigma]", "u", "2"], 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}], 
     RowBox[{
      SubscriptBox["\[Theta]", 
       RowBox[{"2", ",", "2"}]], "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        SubsuperscriptBox["\[Sigma]", "u", "2"], 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}]},
    {
     RowBox[{
      SubscriptBox["\[Theta]", 
       RowBox[{"1", ",", "1"}]], "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox["c", "2"], 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}], 
     RowBox[{
      SubscriptBox["\[Theta]", 
       RowBox[{"1", ",", "1"}]], "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox["c", "2"], 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}]},
    {
     RowBox[{
      SubscriptBox["\[Theta]", 
       RowBox[{"2", ",", "1"}]], "\[Rule]", 
      FractionBox[
       SubsuperscriptBox["\[Sigma]", "u", "2"], 
       RowBox[{
        SuperscriptBox["c", "2"], "+", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], 
     RowBox[{
      SubscriptBox["\[Theta]", 
       RowBox[{"2", ",", "1"}]], "\[Rule]", 
      FractionBox[
       SubsuperscriptBox["\[Sigma]", "u", "2"], 
       RowBox[{
        SuperscriptBox["c", "2"], "+", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]},
    {
     RowBox[{
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "2"}]], "\[Rule]", 
      FractionBox[
       RowBox[{
        SuperscriptBox["c", "2"], " ", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}], 
       RowBox[{
        SuperscriptBox["c", "2"], "+", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], 
     RowBox[{
      SubscriptBox["\[Sigma]", 
       RowBox[{"1", ",", "2"}]], "\[Rule]", 
      FractionBox[
       RowBox[{
        SuperscriptBox["c", "2"], " ", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}], 
       RowBox[{
        SuperscriptBox["c", "2"], "+", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896285661848*^9, 3.3896286064858*^9, 3.3896287138848*^9,
   3.3896313130439997`*^9, 3.3897172862408237`*^9, 3.3899921445486*^9}]
}, Closed]],

Cell["There are two solutions, but they're the same:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"solution", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "===", 
  RowBox[{"solution", "[", 
   RowBox[{"[", "2", "]"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData["True"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896285662408*^9, 3.389631322767*^9, 
  3.389717286295824*^9, 3.3899921446015997`*^9}]
}, Closed]],

Cell["So", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"solution", "=", 
  RowBox[{"solution", "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "1", "2"], "\[Rule]", 
    FractionBox[
     RowBox[{
      SuperscriptBox["c", "4"], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "2"], " ", 
       SubsuperscriptBox["\[Sigma]", "u", "2"]}], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        SubsuperscriptBox["\[Sigma]", "u", "2"], ")"}], "2"]}], 
     RowBox[{
      SuperscriptBox["c", "2"], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], ",", 
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "2", "2"], "\[Rule]", 
    FractionBox[
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}], 
     RowBox[{
      SuperscriptBox["c", "2"], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], ",", 
   RowBox[{
    SubscriptBox["\[Theta]", 
     RowBox[{"1", ",", "2"}]], "\[Rule]", 
    FractionBox[
     SuperscriptBox["c", "2"], 
     RowBox[{
      SuperscriptBox["c", "2"], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], ",", 
   RowBox[{
    SubscriptBox["\[Theta]", 
     RowBox[{"2", ",", "2"}]], "\[Rule]", 
    RowBox[{"-", 
     FractionBox[
      SubsuperscriptBox["\[Sigma]", "u", "2"], 
      RowBox[{
       SuperscriptBox["c", "2"], "+", 
       SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}], ",", 
   RowBox[{
    SubscriptBox["\[Theta]", 
     RowBox[{"1", ",", "1"}]], "\[Rule]", 
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["c", "2"], 
      RowBox[{
       SuperscriptBox["c", "2"], "+", 
       SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}], ",", 
   RowBox[{
    SubscriptBox["\[Theta]", 
     RowBox[{"2", ",", "1"}]], "\[Rule]", 
    FractionBox[
     SubsuperscriptBox["\[Sigma]", "u", "2"], 
     RowBox[{
      SuperscriptBox["c", "2"], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], ",", 
   RowBox[{
    SubscriptBox["\[Sigma]", 
     RowBox[{"1", ",", "2"}]], "\[Rule]", 
    FractionBox[
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}], 
     RowBox[{
      SuperscriptBox["c", "2"], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896285663048*^9, 3.3896313248859997`*^9, 
  3.389717286340824*^9, 3.3899921446596003`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"\[Theta]II", "[", "1", "]"}], "/.", "solution"}], "//", 
   "Simplify"}], "//", "MatrixForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox[
       SubsuperscriptBox["\[Sigma]", "u", "2"], 
       RowBox[{
        SuperscriptBox["c", "2"], "+", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}]], 
      FractionBox[
       SuperscriptBox["c", "2"], 
       RowBox[{
        SuperscriptBox["c", "2"], "+", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}]]},
     {
      FractionBox[
       SubsuperscriptBox["\[Sigma]", "u", "2"], 
       RowBox[{
        SuperscriptBox["c", "2"], "+", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}]], 
      FractionBox[
       SuperscriptBox["c", "2"], 
       RowBox[{
        SuperscriptBox["c", "2"], "+", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896285664428*^9, 3.3896295733258*^9, 3.389631329238*^9, 
  3.389717286389824*^9, 3.3899921447306004`*^9}]
}, Closed]],

Cell["Consider the matrix", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"DD", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\[Theta]II", "[", "L", "]"}], "/.", 
       RowBox[{"L", "\[Rule]", 
        RowBox[{"1", "/", "L"}]}]}], ")"}], "*", "L"}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"DD", "//", "MatrixForm"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"L", "+", 
       SubscriptBox["\[Theta]", 
        RowBox[{"1", ",", "1"}]]}], 
      SubscriptBox["\[Theta]", 
       RowBox[{"1", ",", "2"}]]},
     {
      SubscriptBox["\[Theta]", 
       RowBox[{"2", ",", "1"}]], 
      RowBox[{"L", "+", 
       SubscriptBox["\[Theta]", 
        RowBox[{"2", ",", "2"}]]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896285665067997`*^9, 3.3896295882158003`*^9, 
  3.389631331362*^9, 3.3897172864388237`*^9, 3.3899921447876*^9}]
}, Closed]],

Cell["\<\
For the VMA to be invertible, the roots of the determinental equation \
Det[DD]=0 must lie inside the unit circle. We check:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Det", "[", "DD", "]"}], "\[Equal]", "0"}], "/.", 
        "solution"}], ",", "L"}], "]"}], "//", "Flatten"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "2"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"L", "\[Rule]", "0"}], 
      RowBox[{"L", "\[Rule]", "1"}]},
     {
      RowBox[{"L", "\[Rule]", "0"}], 
      RowBox[{"L", "\[Rule]", "1"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896285672178*^9, 3.3896295909528*^9, 3.389631333832*^9, 
  3.3897172865048237`*^9, 3.3899921448406*^9}]
}, Closed]],

Cell["Uh Oh. Let's try to compute the VAR by polynomial expansion:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Inverse", "[", 
       RowBox[{"\[Theta]II", "[", "L", "]"}], "]"}], "/.", "solution"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"L", ",", "0", ",", "4"}], "}"}]}], "]"}], "//", "Simplify"}], "//",
   "PolyForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"\<\"\"\>", " ", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0"},
       {"0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "+", 
  RowBox[{"L", " ", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox[
         SuperscriptBox["c", "2"], 
         RowBox[{
          SuperscriptBox["c", "2"], "+", 
          SubsuperscriptBox["\[Sigma]", "u", "2"]}]], 
        RowBox[{"-", 
         FractionBox[
          SuperscriptBox["c", "2"], 
          RowBox[{
           SuperscriptBox["c", "2"], "+", 
           SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]},
       {
        RowBox[{"-", 
         FractionBox[
          SubsuperscriptBox["\[Sigma]", "u", "2"], 
          RowBox[{
           SuperscriptBox["c", "2"], "+", 
           SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], 
        FractionBox[
         SubsuperscriptBox["\[Sigma]", "u", "2"], 
         RowBox[{
          SuperscriptBox["c", "2"], "+", 
          SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "+", 
  RowBox[{
   SuperscriptBox["L", "2"], " ", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox[
         SuperscriptBox["c", "2"], 
         RowBox[{
          SuperscriptBox["c", "2"], "+", 
          SubsuperscriptBox["\[Sigma]", "u", "2"]}]], 
        RowBox[{"-", 
         FractionBox[
          SuperscriptBox["c", "2"], 
          RowBox[{
           SuperscriptBox["c", "2"], "+", 
           SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]},
       {
        RowBox[{"-", 
         FractionBox[
          SubsuperscriptBox["\[Sigma]", "u", "2"], 
          RowBox[{
           SuperscriptBox["c", "2"], "+", 
           SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], 
        FractionBox[
         SubsuperscriptBox["\[Sigma]", "u", "2"], 
         RowBox[{
          SuperscriptBox["c", "2"], "+", 
          SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "+", 
  RowBox[{
   SuperscriptBox["L", "3"], " ", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox[
         SuperscriptBox["c", "2"], 
         RowBox[{
          SuperscriptBox["c", "2"], "+", 
          SubsuperscriptBox["\[Sigma]", "u", "2"]}]], 
        RowBox[{"-", 
         FractionBox[
          SuperscriptBox["c", "2"], 
          RowBox[{
           SuperscriptBox["c", "2"], "+", 
           SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]},
       {
        RowBox[{"-", 
         FractionBox[
          SubsuperscriptBox["\[Sigma]", "u", "2"], 
          RowBox[{
           SuperscriptBox["c", "2"], "+", 
           SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], 
        FractionBox[
         SubsuperscriptBox["\[Sigma]", "u", "2"], 
         RowBox[{
          SuperscriptBox["c", "2"], "+", 
          SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "+", 
  RowBox[{
   SuperscriptBox["L", "4"], " ", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox[
         SuperscriptBox["c", "2"], 
         RowBox[{
          SuperscriptBox["c", "2"], "+", 
          SubsuperscriptBox["\[Sigma]", "u", "2"]}]], 
        RowBox[{"-", 
         FractionBox[
          SuperscriptBox["c", "2"], 
          RowBox[{
           SuperscriptBox["c", "2"], "+", 
           SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]},
       {
        RowBox[{"-", 
         FractionBox[
          SubsuperscriptBox["\[Sigma]", "u", "2"], 
          RowBox[{
           SuperscriptBox["c", "2"], "+", 
           SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], 
        FractionBox[
         SubsuperscriptBox["\[Sigma]", "u", "2"], 
         RowBox[{
          SuperscriptBox["c", "2"], "+", 
          SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896285707548*^9, 3.3896296045397997`*^9, 
  3.389631336731*^9, 3.389717286577824*^9, 3.3899921449456*^9}]
}, Closed]],

Cell["No convergence here, either.", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Exercise 10.1", "Subsubsection",
 CellTags->"ExCointegration"],

Cell[CellGroupData[{

Cell[BoxData["solution"], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "1", "2"], "\[Rule]", 
    FractionBox[
     RowBox[{
      SuperscriptBox["c", "4"], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "2"], " ", 
       SubsuperscriptBox["\[Sigma]", "u", "2"]}], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        SubsuperscriptBox["\[Sigma]", "u", "2"], ")"}], "2"]}], 
     RowBox[{
      SuperscriptBox["c", "2"], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], ",", 
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "2", "2"], "\[Rule]", 
    FractionBox[
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}], 
     RowBox[{
      SuperscriptBox["c", "2"], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], ",", 
   RowBox[{
    SubscriptBox["\[Theta]", 
     RowBox[{"1", ",", "2"}]], "\[Rule]", 
    FractionBox[
     SuperscriptBox["c", "2"], 
     RowBox[{
      SuperscriptBox["c", "2"], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], ",", 
   RowBox[{
    SubscriptBox["\[Theta]", 
     RowBox[{"2", ",", "2"}]], "\[Rule]", 
    RowBox[{"-", 
     FractionBox[
      SubsuperscriptBox["\[Sigma]", "u", "2"], 
      RowBox[{
       SuperscriptBox["c", "2"], "+", 
       SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}], ",", 
   RowBox[{
    SubscriptBox["\[Theta]", 
     RowBox[{"1", ",", "1"}]], "\[Rule]", 
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["c", "2"], 
      RowBox[{
       SuperscriptBox["c", "2"], "+", 
       SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}], ",", 
   RowBox[{
    SubscriptBox["\[Theta]", 
     RowBox[{"2", ",", "1"}]], "\[Rule]", 
    FractionBox[
     SubsuperscriptBox["\[Sigma]", "u", "2"], 
     RowBox[{
      SuperscriptBox["c", "2"], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], ",", 
   RowBox[{
    SubscriptBox["\[Sigma]", 
     RowBox[{"1", ",", "2"}]], "\[Rule]", 
    FractionBox[
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}], 
     RowBox[{
      SuperscriptBox["c", "2"], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896296181048*^9, 3.389631345528*^9, 
  3.389717286645824*^9, 3.3899921450056*^9}]
}, Closed]],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "VarianceDecomposition", "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[CapitalOmega]", "/.", 
  SubscriptBox["\[CapitalOmega]II", "Rule"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubsuperscriptBox["\[Sigma]", "1", "2"], ",", 
     SubscriptBox["\[Sigma]", 
      RowBox[{"1", ",", "2"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Sigma]", 
      RowBox[{"1", ",", "2"}]], ",", 
     SubsuperscriptBox["\[Sigma]", "2", "2"]}], "}"}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896313506429996`*^9, 3.389717286718824*^9, 
  3.3899921450755997`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"VarianceDecomposition", "[", 
    RowBox[{"s_", ",", 
     RowBox[{"perm_:", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}]}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Ordering of prices is: \>\"", ",", 
        RowBox[{"TableForm", "[", 
         RowBox[{"{", "perm", "}"}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"F", "=", 
       RowBox[{"Permute", "[", 
        RowBox[{
         RowBox[{"CholeskyDecomposition", "[", 
          RowBox[{"Permute", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"\[CapitalOmega]", "/.", 
               SubscriptBox["\[CapitalOmega]II", "Rule"]}], "//.", "s"}], "//",
              "N"}], ",", "perm"}], "]"}], "]"}], ",", "perm"}], "]"}]}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Cholesky factorization (in correct order) F=\>\"", ",", 
        RowBox[{"MatrixForm", "[", "F", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"\[Theta]Sum", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Theta]II", "[", "1", "]"}], "//.", "s"}], "//", "N"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"a", "=", 
       RowBox[{"\[Theta]Sum", ".", 
        RowBox[{"Transpose", "[", "F", "]"}]}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"Print", "[", 
       RowBox[{
       "\"\<\[Theta](1)\!\(\*SuperscriptBox[\(F\), \(\[Prime]\)]\)=\>\"", ",",
         
        RowBox[{"MatrixForm", "[", "a", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"v", "=", 
       RowBox[{
        RowBox[{"a", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "^", "2"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Variance contributions:\>\"", ",", 
        RowBox[{"MatrixForm", "[", 
         RowBox[{"{", "v", "}"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"tv", "=", 
       RowBox[{"Total", "[", "v", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Total variance=\>\"", ",", "tv"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Information shares= \>\"", ",", 
        RowBox[{"MatrixForm", "[", 
         RowBox[{
          RowBox[{"{", "v", "}"}], "/", "tv"}], "]"}]}], "]"}], ";"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"VarianceDecomposition", "[", 
  RowBox[{
   RowBox[{"Join", "[", 
    RowBox[{"solution", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "u", "2"], "\[Rule]", "1"}], ",", 
       RowBox[{"c", "\[Rule]", "2"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]}], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896296670558*^9, 3.3896296872288*^9}, {
   3.3896297209228*^9, 3.3896297897028*^9}, {3.389631360226*^9, 
   3.389631360737*^9}, 3.389631393367*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Ordering of prices is: \"\>", "\[InvisibleSpace]", 
   TagBox[GridBox[{
      {"1", "2"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    Function[BoxForm`e$, 
     TableForm[BoxForm`e$]]]}],
  SequenceForm["Ordering of prices is: ", 
   TableForm[{{1, 2}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896313942*^9, 3.389717287075824*^9, 3.3899921451726*^9},
 
 CellLabel->"During evaluation of In[192]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Cholesky factorization (in correct order) F=\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2.4083189157584592`", "0.3321819194149599`"},
       {"0.`", "0.8304547985373997`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Cholesky factorization (in correct order) F=", 
   MatrixForm[{{2.4083189157584592`, 0.3321819194149599}, {0., 
    0.8304547985373997}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896313942*^9, 3.389717287075824*^9, 
  3.3899921451786003`*^9},
 CellLabel->"During evaluation of In[192]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Theta](1)\\!\\(\\*SuperscriptBox[\\(F\\), \
\\(\[Prime]\\)]\\)=\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.7474093186836599`", "0.6643638388299198`"},
       {"0.7474093186836599`", "0.6643638388299198`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["\[Theta](1)\!\(\*SuperscriptBox[\(F\), \(\[Prime]\)]\)=", 
   MatrixForm[{{0.7474093186836599, 0.6643638388299198}, {0.7474093186836599, 
    0.6643638388299198}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896313942*^9, 3.389717287075824*^9, 
  3.3899921452195997`*^9},
 CellLabel->"During evaluation of In[192]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Variance contributions:\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.5586206896551726`", "0.44137931034482764`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Variance contributions:", 
   MatrixForm[{{0.5586206896551726, 0.44137931034482764`}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896313942*^9, 3.389717287075824*^9, 
  3.3899921452256002`*^9},
 CellLabel->"During evaluation of In[192]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Total variance=\"\>", "\[InvisibleSpace]", 
   "1.0000000000000002`"}],
  SequenceForm["Total variance=", 1.0000000000000002`],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896313942*^9, 3.389717287075824*^9, 
  3.3899921452306004`*^9},
 CellLabel->"During evaluation of In[192]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Information shares= \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.5586206896551725`", "0.4413793103448275`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Information shares= ", 
   MatrixForm[{{0.5586206896551725, 0.4413793103448275}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896313942*^9, 3.389717287075824*^9, 3.3899921452356*^9},
 
 CellLabel->"During evaluation of In[192]:="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VarianceDecomposition", "[", 
  RowBox[{
   RowBox[{"Join", "[", 
    RowBox[{"solution", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "u", "2"], "\[Rule]", "1"}], ",", 
       RowBox[{"c", "\[Rule]", "2"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Ordering of prices is: \"\>", "\[InvisibleSpace]", 
   TagBox[GridBox[{
      {"2", "1"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    Function[BoxForm`e$, 
     TableForm[BoxForm`e$]]]}],
  SequenceForm["Ordering of prices is: ", 
   TableForm[{{2, 1}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896296185828*^9, 3.389631404849*^9, 
  3.389717287337824*^9, 3.3899921452925997`*^9},
 CellLabel->"During evaluation of In[194]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Cholesky factorization (in correct order) F=\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2.23606797749979`", "0.`"},
       {"0.894427190999916`", "0.8944271909999159`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Cholesky factorization (in correct order) F=", 
   MatrixForm[{{2.23606797749979, 0.}, {0.894427190999916, 
    0.8944271909999159}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896296185828*^9, 3.389631404849*^9, 
  3.389717287337824*^9, 3.3899921452995996`*^9},
 CellLabel->"During evaluation of In[194]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Theta](1)\\!\\(\\*SuperscriptBox[\\(F\\), \
\\(\[Prime]\\)]\\)=\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.447213595499958`", "0.894427190999916`"},
       {"0.447213595499958`", "0.894427190999916`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["\[Theta](1)\!\(\*SuperscriptBox[\(F\), \(\[Prime]\)]\)=", 
   MatrixForm[{{0.447213595499958, 0.894427190999916}, {0.447213595499958, 
    0.894427190999916}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896296185828*^9, 3.389631404849*^9, 
  3.389717287337824*^9, 3.3899921453036003`*^9},
 CellLabel->"During evaluation of In[194]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Variance contributions:\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.20000000000000004`", "0.8000000000000002`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Variance contributions:", 
   MatrixForm[{{0.20000000000000004`, 0.8000000000000002}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896296185828*^9, 3.389631404849*^9, 
  3.389717287337824*^9, 3.3899921453086*^9},
 CellLabel->"During evaluation of In[194]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Total variance=\"\>", "\[InvisibleSpace]", 
   "1.0000000000000002`"}],
  SequenceForm["Total variance=", 1.0000000000000002`],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896296185828*^9, 3.389631404849*^9, 
  3.389717287337824*^9, 3.3899921453126*^9},
 CellLabel->"During evaluation of In[194]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Information shares= \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.19999999999999998`", "0.7999999999999999`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Information shares= ", 
   MatrixForm[{{0.19999999999999998`, 0.7999999999999999}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.3896296185828*^9, 3.389631404849*^9, 
  3.389717287337824*^9, 3.3899921453166*^9},
 CellLabel->"During evaluation of In[194]:="]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["VECM representations.", "Subsubsection"],

Cell[TextData[{
 "Here is the VAR representation for the price ",
 StyleBox["levels",
  FontSlant->"Italic"],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]", "[", "L_", "]"}], ":=", 
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Inverse", "[", 
         RowBox[{"\[Theta]II", "[", "L", "]"}], "]"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "L"}], ")"}]}], "/.", "solution"}], "]"}], "//", 
     "Normal"}], " ", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Phi]", "[", "L", "]"}], "//", "PolyForm"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"\<\"\"\>", " ", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0"},
       {"0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "+", 
  RowBox[{"L", " ", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", 
         FractionBox[
          SubsuperscriptBox["\[Sigma]", "u", "2"], 
          RowBox[{
           SuperscriptBox["c", "2"], "+", 
           SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], 
        RowBox[{"-", 
         FractionBox[
          SuperscriptBox["c", "2"], 
          RowBox[{
           SuperscriptBox["c", "2"], "+", 
           SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]},
       {
        RowBox[{"-", 
         FractionBox[
          SubsuperscriptBox["\[Sigma]", "u", "2"], 
          RowBox[{
           SuperscriptBox["c", "2"], "+", 
           SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], 
        RowBox[{"-", 
         FractionBox[
          SuperscriptBox["c", "2"], 
          RowBox[{
           SuperscriptBox["c", "2"], "+", 
           SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389631409094*^9, 3.389717287577824*^9, 
  3.3899921453876*^9}]
}, Closed]],

Cell["Verify (19.1.34) in Hamilton", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Phi]", "[", "1", "]"}], ".", 
     RowBox[{"\[Theta]II", "[", "1", "]"}]}], "/.", "solution"}], "]"}], "//",
   "MatrixForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "0"},
     {"0", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896314139370003`*^9, 3.389717287620824*^9, 
  3.3899921454486*^9}]
}, Closed]],

Cell[TextData[{
 "Rearrange ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"\[Phi]", 
    RowBox[{"(", "L", ")"}], 
    SubscriptBox["p", "t"]}], "=", 
   SubscriptBox["\[Epsilon]", "t"]}]]],
 "  as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["p", "t"], "+", 
    RowBox[{
     SubscriptBox["\[Phi]", "1"], 
     SubscriptBox["p", 
      RowBox[{"t", "-", "1"}]]}]}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["\[Epsilon]", "t"], " ", "\[DoubleLongLeftRightArrow]", 
      " ", 
      SubscriptBox["p", "t"]}], "-", 
     SubscriptBox["p", 
      RowBox[{"t", "-", "1"}]]}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "I"}], "-", 
        SubscriptBox["\[Phi]", "1"]}], ")"}], 
      SubscriptBox["p", 
       RowBox[{"t", "-", "1"}]]}], "+", 
     SubscriptBox["\[Epsilon]", "t"]}]}]}]]],
 ". The coefficient of ",
 Cell[BoxData[
  SubscriptBox["p", 
   RowBox[{"t", "-", "1"}]]]],
 " on the r.h.s. is:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"IdentityMatrix", "[", "2", "]"}]}], "-", 
    RowBox[{"Coefficient", "[", 
     RowBox[{
      RowBox[{"\[Phi]", "[", "L", "]"}], ",", "L", ",", "1"}], "]"}]}], "//", 
   "Together"}], "//", "MatrixForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox["c", "2"], 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], 
      FractionBox[
       SuperscriptBox["c", "2"], 
       RowBox[{
        SuperscriptBox["c", "2"], "+", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}]]},
     {
      FractionBox[
       SubsuperscriptBox["\[Sigma]", "u", "2"], 
       RowBox[{
        SuperscriptBox["c", "2"], "+", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}]], 
      RowBox[{"-", 
       FractionBox[
        SubsuperscriptBox["\[Sigma]", "u", "2"], 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.38963141612*^9, 3.3897172876818237`*^9, 
  3.3899921455066*^9}]
}, Closed]],

Cell[TextData[{
 "This can be written as the error correction term ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"\[Gamma]", " ", "[", 
    RowBox[{"1", " ", "-", "1"}], "]"}], 
   SubscriptBox["p", 
    RowBox[{"t", "-", "1"}]]}]]],
 " where "
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Gamma]", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      FractionBox[
       RowBox[{"-", 
        SuperscriptBox["c", "2"]}], 
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
        SubsuperscriptBox["c", "1", "2"]}]], "}"}], ",", 
     RowBox[{"{", 
      FractionBox[
       SubsuperscriptBox["\[Sigma]", "u", "2"], 
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
        SuperscriptBox["c", "2"]}]], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Gamma]", ".", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", " ", ",", 
      RowBox[{"-", "1"}]}], "}"}], "}"}]}], " ", "//", " ", 
  "MatrixForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox["c", "2"], 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
         SubsuperscriptBox["c", "1", "2"]}]]}], 
      FractionBox[
       SuperscriptBox["c", "2"], 
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
        SubsuperscriptBox["c", "1", "2"]}]]},
     {
      FractionBox[
       SubsuperscriptBox["\[Sigma]", "u", "2"], 
       RowBox[{
        SuperscriptBox["c", "2"], "+", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}]], 
      RowBox[{"-", 
       FractionBox[
        SubsuperscriptBox["\[Sigma]", "u", "2"], 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389631427007*^9, 3.389717287731824*^9, 
  3.3899921455726*^9}]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]]
},
ScreenStyleEnvironment->"Working",
WindowSize->{1578, 1027},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Visible->True,
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
InputAliases->{"intt" -> RowBox[{"\[Integral]", 
     RowBox[{"\[SelectionPlaceholder]", 
       RowBox[{"\[DifferentialD]", "\[Placeholder]"}]}]}], "dintt" -> 
  RowBox[{
     SubsuperscriptBox[
     "\[Integral]", "\[SelectionPlaceholder]", "\[Placeholder]"], 
     RowBox[{"\[Placeholder]", 
       RowBox[{"\[DifferentialD]", "\[Placeholder]"}]}]}], "sumt" -> RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"\[SelectionPlaceholder]", "=", "\[Placeholder]"}], 
      "\[Placeholder]"], "\[Placeholder]"}], "prodt" -> RowBox[{
     UnderoverscriptBox["\[Product]", 
      RowBox[{"\[SelectionPlaceholder]", "=", "\[Placeholder]"}], 
      "\[Placeholder]"], "\[Placeholder]"}], "dt" -> RowBox[{
     SubscriptBox["\[PartialD]", "\[Placeholder]"], " ", 
     "\[SelectionPlaceholder]"}], "\\[Esc]eee\\[Esc]" -> "\[ScriptCapitalE]", 
  "\\[Escape]eee\\[Escape]" -> "\[ScriptCapitalE]", 
  "\[EscapeKey]EE\[EscapeKey]" -> "\[ScriptCapitalE]", 
  "\[EscapeKey]eee\[EscapeKey]" -> "\[ScriptCapitalE]", "expect" -> 
  "\[ScriptCapitalE]", "exp" -> "\[ScriptCapitalE]", "ex" -> 
  "\[ScriptCapitalE]", "E" -> "\[ScriptCapitalE]", "notation" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], " ", 
       "\[DoubleLongLeftRightArrow]", " ", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "notation>" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], " ", 
       "\[DoubleLongRightArrow]", " ", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "notation<" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], " ", 
       "\[DoubleLongLeftArrow]", " ", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "symb" -> 
  RowBox[{"Symbolize", "[", 
     TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], "]"}], 
  "infixnotation" -> RowBox[{"InfixNotation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], ",", 
       "\[Placeholder]"}], "]"}], "addia" -> RowBox[{"AddInputAlias", "[", 
     RowBox[{"\"\[SelectionPlaceholder]\"", "\[Rule]", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "pattwraper" -> 
  TagBox["\[SelectionPlaceholder]", "NotationPatternTag"], "madeboxeswraper" -> 
  TagBox["\[SelectionPlaceholder]", "NotationMadeBoxesTag"]},
Magnification->1.5,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->"EMMStyle02.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:116"->{
  Cell[18052, 597, 94, 1, 51, "Section",
   CellTags->"c:116"]},
 "ExGlostenHarris"->{
  Cell[109110, 3631, 85, 1, 65, "Subsection",
   CellTags->"ExGlostenHarris"]},
 "ExMRR"->{
  Cell[141675, 4766, 89, 1, 65, "Subsection",
   CellTags->"ExMRR"]},
 "ExCointegration"->{
  Cell[285228, 9313, 68, 1, 44, "Subsubsection",
   CellTags->"ExCointegration"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:116", 315277, 10209},
 {"ExGlostenHarris", 315364, 10212},
 {"ExMRR", 315456, 10215},
 {"ExCointegration", 315548, 10218}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 827, 23, 430, "Title"],
Cell[CellGroupData[{
Cell[1442, 50, 410, 9, 43, "Input"],
Cell[1855, 61, 696, 15, 51, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2588, 81, 32, 0, 92, "Section"],
Cell[CellGroupData[{
Cell[2645, 85, 31, 0, 65, "Subsection"],
Cell[2679, 87, 147, 3, 43, "Input"],
Cell[2829, 92, 111, 3, 32, "Text"],
Cell[2943, 97, 724, 24, 71, "Input"],
Cell[3670, 123, 237, 6, 49, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[3944, 134, 74, 0, 65, "Subsection"],
Cell[4021, 136, 124, 3, 43, "Input"],
Cell[CellGroupData[{
Cell[4170, 143, 44, 0, 44, "Subsubsection"],
Cell[4217, 145, 134, 3, 32, "Text"],
Cell[4354, 150, 324, 10, 43, "Input"],
Cell[4681, 162, 28, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[4734, 166, 514, 17, 46, "Input"],
Cell[5251, 185, 1861, 56, 99, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[7149, 246, 223, 7, 43, "Input"],
Cell[7375, 255, 1868, 56, 99, "Output"]
}, Closed]],
Cell[9258, 314, 46, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[9329, 318, 219, 7, 43, "Input"],
Cell[9551, 327, 1878, 56, 99, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[11466, 388, 514, 17, 46, "Input"],
Cell[11983, 407, 1396, 41, 79, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[13416, 453, 209, 7, 43, "Input"],
Cell[13628, 462, 1392, 41, 79, "Output"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[15069, 509, 62, 0, 44, "Subsubsection"],
Cell[15134, 511, 1956, 45, 134, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[17127, 561, 101, 2, 44, "Subsubsection"],
Cell[17231, 565, 275, 9, 33, "Text"],
Cell[17509, 576, 482, 14, 48, "Input"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[18052, 597, 94, 1, 51, "Section",
 CellTags->"c:116"],
Cell[CellGroupData[{
Cell[18171, 602, 52, 0, 65, "Subsection"],
Cell[CellGroupData[{
Cell[18248, 606, 1284, 43, 100, "Input"],
Cell[19535, 651, 1538, 49, 99, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[21110, 705, 1033, 28, 46, "Input"],
Cell[22146, 735, 796, 26, 38, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[22979, 766, 358, 10, 48, "Input"],
Cell[23340, 778, 460, 11, 44, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[23837, 794, 46, 0, 44, "Subsubsection"],
Cell[23886, 796, 206, 8, 33, "Text"],
Cell[CellGroupData[{
Cell[24117, 808, 381, 12, 43, "Input"],
Cell[24501, 822, 421, 12, 38, "Output"]
}, Closed]],
Cell[24937, 837, 924, 40, 49, "Text"],
Cell[CellGroupData[{
Cell[25886, 881, 1319, 42, 71, "Input"],
Cell[27208, 925, 2845, 83, 53, "Output"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[30102, 1014, 125, 3, 44, "Subsubsection"],
Cell[CellGroupData[{
Cell[30252, 1021, 258, 9, 43, "Input"],
Cell[30513, 1032, 826, 23, 53, "Output"]
}, Closed]],
Cell[31354, 1058, 29, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[31408, 1062, 699, 21, 71, "Input"],
Cell[32110, 1085, 3115, 91, 53, "Output"]
}, Closed]],
Cell[35240, 1179, 264, 7, 33, "Text"],
Cell[35507, 1188, 334, 11, 45, "Input"],
Cell[35844, 1201, 29, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[35898, 1205, 668, 20, 72, "Input"],
Cell[36569, 1227, 1119, 33, 53, "Output"]
}, Closed]],
Cell[37703, 1263, 34, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[37762, 1267, 817, 24, 75, "Input"],
Cell[38582, 1293, 1322, 37, 67, "Output"]
}, Closed]],
Cell[39919, 1333, 72, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[40016, 1337, 448, 13, 43, "Input"],
Cell[40467, 1352, 1423, 39, 67, "Output"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[41939, 1397, 29, 0, 44, "Subsubsection"],
Cell[41971, 1399, 685, 28, 49, "Text"],
Cell[CellGroupData[{
Cell[42681, 1431, 329, 9, 43, "Input"],
Cell[43013, 1442, 1178, 35, 85, "Output"]
}, Closed]],
Cell[44206, 1480, 53, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[44284, 1484, 270, 8, 43, "Input"],
Cell[44557, 1494, 2502, 67, 63, "Output"]
}, Closed]],
Cell[47074, 1564, 61, 3, 55, "Text"],
Cell[CellGroupData[{
Cell[47160, 1571, 773, 22, 71, "Input"],
Cell[47936, 1595, 4681, 136, 63, "Output"]
}, Closed]],
Cell[52632, 1734, 1177, 47, 49, "Text"],
Cell[CellGroupData[{
Cell[53834, 1785, 675, 20, 71, "Input"],
Cell[54512, 1807, 3930, 115, 63, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[58479, 1927, 283, 8, 43, "Input"],
Cell[58765, 1937, 3606, 104, 53, "Output"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[62420, 2047, 51, 0, 44, "Subsubsection"],
Cell[62474, 2049, 104, 3, 32, "Text"],
Cell[CellGroupData[{
Cell[62603, 2056, 535, 18, 80, "Input"],
Cell[63141, 2076, 770, 25, 38, "Output"]
}, Closed]],
Cell[63926, 2104, 421, 16, 56, "Text"],
Cell[64350, 2122, 664, 21, 46, "Input"],
Cell[65017, 2145, 187, 7, 33, "Text"],
Cell[CellGroupData[{
Cell[65229, 2156, 133, 4, 43, "Input"],
Cell[65365, 2162, 241, 5, 38, "Output"]
}, Closed]],
Cell[65621, 2170, 36, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[65682, 2174, 186, 6, 43, "Input"],
Cell[65871, 2182, 289, 7, 38, "Output"]
}, Closed]],
Cell[66175, 2192, 37, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[66237, 2196, 241, 8, 43, "Input"],
Cell[66481, 2206, 431, 12, 38, "Output"]
}, Closed]],
Cell[66927, 2221, 110, 3, 32, "Text"],
Cell[67040, 2226, 479, 15, 45, "Input"],
Cell[CellGroupData[{
Cell[67544, 2245, 135, 4, 43, "Input"],
Cell[67682, 2251, 439, 12, 38, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[68158, 2268, 291, 9, 43, "Input"],
Cell[68452, 2279, 389, 11, 38, "Output"]
}, Closed]],
Cell[68856, 2293, 46, 0, 32, "Text"],
Cell[68905, 2295, 325, 10, 79, "Input"],
Cell[69233, 2307, 200, 5, 33, "Text"],
Cell[CellGroupData[{
Cell[69458, 2316, 412, 13, 43, "Input"],
Cell[69873, 2331, 996, 29, 53, "Output"]
}, Closed]],
Cell[70884, 2363, 184, 8, 33, "Text"],
Cell[CellGroupData[{
Cell[71093, 2375, 614, 19, 46, "Input"],
Cell[71710, 2396, 895, 25, 59, "Output"]
}, Closed]],
Cell[72620, 2424, 69, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[72714, 2428, 423, 13, 43, "Input"],
Cell[73140, 2443, 1131, 32, 59, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[74332, 2482, 95, 2, 65, "Subsection"],
Cell[74430, 2486, 711, 25, 57, "Text"],
Cell[75144, 2513, 118, 5, 33, "Text"],
Cell[CellGroupData[{
Cell[75287, 2522, 473, 15, 75, "Input"],
Cell[75763, 2539, 925, 25, 67, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[76725, 2569, 972, 27, 90, "Input"],
Cell[77700, 2598, 1170, 33, 123, "Output"]
}, Closed]],
Cell[78885, 2634, 74, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[78984, 2638, 183, 6, 43, "Input"],
Cell[79170, 2646, 964, 25, 67, "Output"]
}, Closed]],
Cell[80149, 2674, 57, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[80231, 2678, 166, 4, 43, "Input"],
Cell[80400, 2684, 1481, 41, 67, "Output"]
}, Closed]],
Cell[81896, 2728, 75, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[81996, 2732, 789, 21, 75, "Input"],
Cell[82788, 2755, 1955, 55, 111, "Output"]
}, Closed]],
Cell[84758, 2813, 352, 8, 58, "Text"],
Cell[CellGroupData[{
Cell[85135, 2825, 1048, 29, 75, "Input"],
Cell[86186, 2856, 1088, 30, 87, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[87311, 2891, 248, 8, 43, "Input"],
Cell[87562, 2901, 990, 28, 87, "Output"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[88601, 2935, 42, 0, 65, "Subsection"],
Cell[88646, 2937, 685, 28, 49, "Text"],
Cell[89334, 2967, 625, 24, 82, "Text"],
Cell[CellGroupData[{
Cell[89984, 2995, 218, 7, 43, "Input"],
Cell[90205, 3004, 869, 23, 53, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[91111, 3032, 518, 17, 43, "Input"],
Cell[91632, 3051, 973, 25, 43, "Output"]
}, Closed]],
Cell[92620, 3079, 89, 2, 32, "Text"],
Cell[CellGroupData[{
Cell[92734, 3085, 409, 14, 43, "Input"],
Cell[93146, 3101, 1047, 27, 43, "Output"]
}, Closed]],
Cell[94208, 3131, 85, 2, 32, "Text"],
Cell[CellGroupData[{
Cell[94318, 3137, 41, 0, 44, "Subsubsection"],
Cell[CellGroupData[{
Cell[94384, 3141, 788, 21, 75, "Input"],
Cell[95175, 3164, 1930, 54, 111, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[97142, 3223, 319, 10, 43, "Input"],
Cell[97464, 3235, 1222, 35, 82, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[98723, 3275, 171, 5, 43, "Input"],
Cell[98897, 3282, 406, 9, 41, "Output"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[99352, 3297, 41, 0, 44, "Subsubsection"],
Cell[CellGroupData[{
Cell[99418, 3301, 1043, 29, 75, "Input"],
Cell[100464, 3332, 1136, 32, 87, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[101637, 3369, 319, 10, 43, "Input"],
Cell[101959, 3381, 508, 13, 55, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[102504, 3399, 171, 5, 43, "Input"],
Cell[102678, 3406, 462, 11, 41, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[103201, 3424, 35, 0, 65, "Subsection"],
Cell[103239, 3426, 33, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[103297, 3430, 172, 6, 43, "Input"],
Cell[103472, 3438, 280, 6, 38, "Output"]
}, Closed]],
Cell[103767, 3447, 522, 19, 37, "Text"],
Cell[104292, 3468, 27, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[104344, 3472, 243, 8, 43, "Input"],
Cell[104590, 3482, 336, 8, 38, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[104963, 3495, 181, 6, 43, "Input"],
Cell[105147, 3503, 900, 25, 53, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[106084, 3533, 401, 12, 43, "Input"],
Cell[106488, 3547, 1447, 40, 67, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[107972, 3592, 118, 3, 43, "Input"],
Cell[108093, 3597, 904, 23, 53, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[109058, 3627, 27, 0, 51, "Section"],
Cell[CellGroupData[{
Cell[109110, 3631, 85, 1, 65, "Subsection",
 CellTags->"ExGlostenHarris"],
Cell[109198, 3634, 28, 0, 32, "Text"],
Cell[109229, 3636, 1018, 36, 101, "Input"],
Cell[110250, 3674, 228, 10, 33, "Text"],
Cell[CellGroupData[{
Cell[110503, 3688, 389, 13, 43, "Input"],
Cell[110895, 3703, 1371, 44, 73, "Output"]
}, Closed]],
Cell[112281, 3750, 163, 7, 33, "Text"],
Cell[CellGroupData[{
Cell[112469, 3761, 888, 25, 73, "Input"],
Cell[113360, 3788, 874, 30, 38, "Output"]
}, Closed]],
Cell[114249, 3821, 43, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[114317, 3825, 529, 17, 45, "Input"],
Cell[114849, 3844, 860, 25, 73, "Output"]
}, Closed]],
Cell[115724, 3872, 127, 5, 33, "Text"],
Cell[CellGroupData[{
Cell[115876, 3881, 550, 17, 45, "Input"],
Cell[116429, 3900, 845, 25, 73, "Output"]
}, Closed]],
Cell[117289, 3928, 70, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[117384, 3932, 296, 10, 43, "Input"],
Cell[117683, 3944, 1617, 50, 73, "Output"]
}, Closed]],
Cell[119315, 3997, 378, 14, 33, "Text"],
Cell[CellGroupData[{
Cell[119718, 4015, 1553, 44, 98, "Input"],
Cell[121274, 4061, 2218, 65, 73, "Output"]
}, Closed]],
Cell[123507, 4129, 469, 17, 33, "Text"],
Cell[123979, 4148, 103, 2, 43, "Input"],
Cell[124085, 4152, 330, 15, 37, "Text"],
Cell[CellGroupData[{
Cell[124440, 4171, 769, 24, 64, "Input"],
Cell[125212, 4197, 300, 8, 73, "Output"]
}, Closed]],
Cell[125527, 4208, 56, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[125608, 4212, 1110, 33, 93, "Input"],
Cell[126721, 4247, 1299, 38, 117, "Output"]
}, Closed]],
Cell[128035, 4288, 138, 5, 34, "Text"],
Cell[CellGroupData[{
Cell[128198, 4297, 840, 27, 46, "Input"],
Cell[129041, 4326, 651, 17, 73, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[129729, 4348, 114, 5, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[129868, 4357, 913, 25, 75, "Input"],
Cell[130784, 4384, 1192, 36, 127, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[132013, 4425, 457, 14, 43, "Input"],
Cell[132473, 4441, 768, 24, 73, "Output"]
}, Closed]],
Cell[133256, 4468, 230, 10, 33, "Text"],
Cell[CellGroupData[{
Cell[133511, 4482, 179, 6, 48, "Input"],
Cell[133693, 4490, 1290, 37, 57, "Output"]
}, Closed]],
Cell[134998, 4530, 136, 5, 34, "Text"],
Cell[CellGroupData[{
Cell[135159, 4539, 156, 4, 45, "Input"],
Cell[135318, 4545, 647, 17, 73, "Output"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[136014, 4568, 114, 5, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[136153, 4577, 823, 24, 71, "Input"],
Cell[136979, 4603, 1068, 32, 125, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[138084, 4640, 457, 14, 43, "Input"],
Cell[138544, 4656, 720, 23, 73, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[139301, 4684, 179, 6, 48, "Input"],
Cell[139483, 4692, 1252, 37, 57, "Output"]
}, Closed]],
Cell[140750, 4732, 31, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[140806, 4736, 156, 4, 45, "Input"],
Cell[140965, 4742, 649, 17, 73, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[141675, 4766, 89, 1, 65, "Subsection",
 CellTags->"ExMRR"],
Cell[141767, 4769, 29, 0, 32, "Text"],
Cell[141799, 4771, 1052, 38, 129, "Input"],
Cell[142854, 4811, 256, 14, 33, "Text"],
Cell[CellGroupData[{
Cell[143135, 4829, 484, 16, 43, "Input"],
Cell[143622, 4847, 1284, 42, 93, "Output"]
}, Closed]],
Cell[144921, 4892, 115, 5, 33, "Text"],
Cell[CellGroupData[{
Cell[145061, 4901, 869, 26, 73, "Input"],
Cell[145933, 4929, 540, 16, 38, "Output"]
}, Closed]],
Cell[146488, 4948, 118, 5, 33, "Text"],
Cell[CellGroupData[{
Cell[146631, 4957, 487, 16, 45, "Input"],
Cell[147121, 4975, 797, 22, 55, "Output"]
}, Closed]],
Cell[147933, 5000, 46, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[148004, 5004, 508, 16, 45, "Input"],
Cell[148515, 5022, 784, 22, 53, "Output"]
}, Closed]],
Cell[149314, 5047, 96, 2, 43, "Input"],
Cell[149413, 5051, 152, 5, 33, "Text"],
Cell[CellGroupData[{
Cell[149590, 5060, 1020, 34, 43, "Input"],
Cell[150613, 5096, 1310, 39, 55, "Output"]
}, Closed]],
Cell[151938, 5138, 335, 12, 33, "Text"],
Cell[CellGroupData[{
Cell[152298, 5154, 525, 17, 43, "Input"],
Cell[152826, 5173, 984, 28, 53, "Output"]
}, Closed]],
Cell[153825, 5204, 19, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[153869, 5208, 474, 15, 43, "Input"],
Cell[154346, 5225, 893, 25, 53, "Output"]
}, Closed]],
Cell[155254, 5253, 820, 25, 79, "Text"],
Cell[CellGroupData[{
Cell[156099, 5282, 514, 16, 43, "Input"],
Cell[156616, 5300, 805, 22, 69, "Output"]
}, Closed]],
Cell[157436, 5325, 584, 20, 37, "Text"],
Cell[CellGroupData[{
Cell[158045, 5349, 452, 14, 48, "Input"],
Cell[158500, 5365, 1393, 39, 101, "Output"]
}, Closed]],
Cell[159908, 5407, 312, 10, 34, "Text"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[160269, 5423, 51, 0, 51, "Section"],
Cell[CellGroupData[{
Cell[160345, 5427, 121, 3, 65, "Subsection"],
Cell[CellGroupData[{
Cell[160491, 5434, 30, 0, 44, "Subsubsection"],
Cell[160524, 5436, 1902, 66, 159, "Input"],
Cell[CellGroupData[{
Cell[162451, 5506, 155, 4, 43, "Input"],
Cell[162609, 5512, 992, 32, 38, "Output"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[163650, 5550, 48, 0, 44, "Subsubsection"],
Cell[163701, 5552, 446, 12, 56, "Text"],
Cell[164150, 5566, 4373, 120, 243, "Input"],
Cell[CellGroupData[{
Cell[168548, 5690, 168, 4, 43, "Input"],
Cell[168719, 5696, 5135, 152, 399, "Output"]
}, Closed]],
Cell[173869, 5851, 206, 4, 43, "Input"],
Cell[174078, 5857, 834, 24, 45, "Input"],
Cell[CellGroupData[{
Cell[174937, 5885, 254, 6, 43, "Input"],
Cell[175194, 5893, 1318, 35, 67, "Output"]
}, Closed]],
Cell[176527, 5931, 226, 9, 33, "Text"],
Cell[CellGroupData[{
Cell[176778, 5944, 360, 11, 43, "Input"],
Cell[177141, 5957, 2787, 79, 67, "Output"]
}, Closed]],
Cell[179943, 6039, 366, 14, 56, "Text"],
Cell[CellGroupData[{
Cell[180334, 6057, 282, 8, 48, "Input"],
Cell[180619, 6067, 461, 10, 44, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[181117, 6082, 464, 13, 43, "Input"],
Cell[181584, 6097, 1610, 44, 53, "Output"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[183243, 6147, 40, 0, 44, "Subsubsection"],
Cell[183286, 6149, 97, 2, 32, "Text"],
Cell[CellGroupData[{
Cell[183408, 6155, 633, 19, 73, "Input"],
Cell[184044, 6176, 2136, 55, 57, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[186217, 6236, 530, 16, 48, "Input"],
Cell[186750, 6254, 1056, 28, 67, "Output"]
}, Closed]],
Cell[187821, 6285, 51, 0, 32, "Text"],
Cell[187875, 6287, 313, 9, 48, "Input"],
Cell[188191, 6298, 194, 6, 33, "Text"],
Cell[CellGroupData[{
Cell[188410, 6308, 717, 22, 72, "Input"],
Cell[189130, 6332, 7774, 199, 125, "Output"]
}, Closed]],
Cell[196919, 6534, 85, 2, 32, "Text"],
Cell[CellGroupData[{
Cell[197029, 6540, 901, 24, 71, "Input"],
Cell[197933, 6566, 6780, 197, 231, "Output"]
}, Closed]],
Cell[204728, 6766, 56, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[204809, 6770, 159, 5, 43, "Input"],
Cell[204971, 6777, 4590, 139, 102, "Output"]
}, Closed]],
Cell[209576, 6919, 695, 19, 48, "Input"],
Cell[210274, 6940, 61, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[210360, 6944, 229, 7, 43, "Input"],
Cell[210592, 6953, 4221, 119, 119, "Output"]
}, Closed]],
Cell[214828, 7075, 35, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[214888, 7079, 376, 12, 71, "Input"],
Cell[215267, 7093, 1160, 33, 57, "Output"]
}, Closed]],
Cell[216442, 7129, 148, 3, 32, "Text"],
Cell[CellGroupData[{
Cell[216615, 7136, 566, 17, 43, "Input"],
Cell[217184, 7155, 1306, 33, 91, "Output"]
}, Closed]],
Cell[218505, 7191, 55, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[218585, 7195, 249, 6, 43, "Input"],
Cell[218837, 7203, 1198, 34, 44, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[220072, 7242, 357, 12, 46, "Input"],
Cell[220432, 7256, 1021, 27, 53, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[221490, 7288, 138, 4, 43, "Input"],
Cell[221631, 7294, 942, 23, 53, "Output"]
}, Closed]],
Cell[222588, 7320, 67, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[222680, 7324, 318, 9, 43, "Input"],
Cell[223001, 7335, 890, 23, 53, "Output"]
}, Closed]],
Cell[223906, 7361, 39, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[223970, 7365, 238, 7, 43, "Input"],
Cell[224211, 7374, 902, 22, 53, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[225150, 7401, 235, 7, 43, "Input"],
Cell[225388, 7410, 1267, 36, 53, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[226692, 7451, 343, 11, 43, "Input"],
Cell[227038, 7464, 1278, 36, 53, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[228353, 7505, 298, 10, 43, "Input"],
Cell[228654, 7517, 403, 8, 38, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[229094, 7530, 96, 3, 45, "Input"],
Cell[229193, 7535, 314, 7, 38, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[229568, 7549, 67, 0, 65, "Subsection"],
Cell[CellGroupData[{
Cell[229660, 7553, 30, 0, 44, "Subsubsection"],
Cell[229693, 7555, 1708, 58, 132, "Input"],
Cell[231404, 7615, 51, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[231480, 7619, 192, 6, 43, "Input"],
Cell[231675, 7627, 1068, 32, 55, "Output"]
}, Closed]],
Cell[232758, 7662, 57, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[232840, 7666, 418, 15, 43, "Input"],
Cell[233261, 7683, 273, 7, 38, "Output"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[233583, 7696, 61, 0, 44, "Subsubsection"],
Cell[233647, 7698, 217, 7, 43, "Input"],
Cell[233867, 7707, 360, 12, 45, "Input"],
Cell[CellGroupData[{
Cell[234252, 7723, 1413, 41, 71, "Input"],
Cell[235668, 7766, 2137, 63, 53, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[237842, 7834, 434, 13, 73, "Input"],
Cell[238279, 7849, 415, 11, 44, "Output"]
}, Closed]],
Cell[238709, 7863, 51, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[238785, 7867, 442, 13, 71, "Input"],
Cell[239230, 7882, 2436, 69, 87, "Output"]
}, Closed]],
Cell[241681, 7954, 39, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[241745, 7958, 345, 11, 43, "Input"],
Cell[242093, 7971, 5170, 154, 93, "Output"]
}, Closed]],
Cell[247278, 8128, 62, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[247365, 8132, 336, 9, 43, "Input"],
Cell[247704, 8143, 492, 13, 44, "Output"]
}, Closed]],
Cell[248211, 8159, 88, 2, 32, "Text"]
}, Closed]],
Cell[CellGroupData[{
Cell[248336, 8166, 83, 1, 44, "Subsubsection"],
Cell[CellGroupData[{
Cell[248444, 8171, 551, 17, 73, "Input"],
Cell[248998, 8190, 1692, 48, 57, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[250727, 8243, 710, 22, 75, "Input"],
Cell[251440, 8267, 940, 26, 67, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[252417, 8298, 379, 11, 71, "Input"],
Cell[252799, 8311, 5948, 168, 229, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[258784, 8484, 708, 20, 71, "Input"],
Cell[259495, 8506, 4953, 144, 201, "Output"]
}, Closed]],
Cell[264463, 8653, 691, 19, 48, "Input"],
Cell[CellGroupData[{
Cell[265179, 8676, 264, 7, 71, "Input"],
Cell[265446, 8685, 5193, 158, 333, "Output"]
}, Closed]],
Cell[270654, 8846, 62, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[270741, 8850, 197, 6, 43, "Input"],
Cell[270941, 8858, 167, 3, 38, "Output"]
}, Closed]],
Cell[271123, 8864, 18, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[271166, 8868, 143, 4, 43, "Input"],
Cell[271312, 8874, 2338, 72, 72, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[273687, 8951, 193, 6, 43, "Input"],
Cell[273883, 8959, 1397, 40, 107, "Output"]
}, Closed]],
Cell[275295, 9002, 35, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[275355, 9006, 378, 12, 71, "Input"],
Cell[275736, 9020, 1047, 30, 57, "Output"]
}, Closed]],
Cell[276798, 9053, 148, 3, 32, "Text"],
Cell[CellGroupData[{
Cell[276971, 9060, 407, 13, 43, "Input"],
Cell[277381, 9075, 869, 24, 53, "Output"]
}, Closed]],
Cell[278265, 9102, 76, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[278366, 9106, 361, 12, 43, "Input"],
Cell[278730, 9120, 6402, 185, 105, "Output"]
}, Closed]],
Cell[285147, 9308, 44, 0, 32, "Text"]
}, Closed]],
Cell[CellGroupData[{
Cell[285228, 9313, 68, 1, 44, "Subsubsection",
 CellTags->"ExCointegration"],
Cell[CellGroupData[{
Cell[285321, 9318, 62, 1, 43, "Input"],
Cell[285386, 9321, 2329, 72, 72, "Output"]
}, Closed]],
Cell[287730, 9396, 109, 2, 43, "Input"],
Cell[CellGroupData[{
Cell[287864, 9402, 133, 3, 43, "Input"],
Cell[288000, 9407, 494, 15, 44, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[288531, 9427, 3160, 83, 397, "Input"],
Cell[291694, 9512, 835, 23, 32, "Print"],
Cell[292532, 9537, 1094, 27, 47, "Print"],
Cell[293629, 9566, 1153, 27, 47, "Print"],
Cell[294785, 9595, 980, 24, 32, "Print"],
Cell[295768, 9621, 338, 8, 32, "Print"],
Cell[296109, 9631, 966, 24, 32, "Print"]
}, Closed]],
Cell[CellGroupData[{
Cell[297112, 9660, 404, 12, 48, "Input"],
Cell[297519, 9674, 862, 23, 32, "Print"],
Cell[298384, 9699, 1109, 27, 47, "Print"],
Cell[299496, 9728, 1167, 27, 47, "Print"],
Cell[300666, 9757, 998, 24, 32, "Print"],
Cell[301667, 9783, 356, 8, 32, "Print"],
Cell[302026, 9793, 992, 24, 32, "Print"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[303067, 9823, 46, 0, 44, "Subsubsection"],
Cell[303116, 9825, 126, 5, 32, "Text"],
Cell[CellGroupData[{
Cell[303267, 9834, 541, 16, 71, "Input"],
Cell[303811, 9852, 2207, 64, 107, "Output"]
}, Closed]],
Cell[306033, 9919, 44, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[306102, 9923, 258, 8, 43, "Input"],
Cell[306363, 9933, 700, 20, 53, "Output"]
}, Closed]],
Cell[307078, 9956, 992, 39, 33, "Text"],
Cell[CellGroupData[{
Cell[308095, 9999, 323, 10, 43, "Input"],
Cell[308421, 10011, 1408, 42, 105, "Output"]
}, Closed]],
Cell[309844, 10056, 250, 9, 33, "Text"],
Cell[310097, 10067, 564, 18, 78, "Input"],
Cell[CellGroupData[{
Cell[310686, 10089, 232, 8, 43, "Input"],
Cell[310921, 10099, 1423, 42, 105, "Output"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
