(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    213242,       7309]
NotebookOptionsPosition[    190058,       6583]
NotebookOutlinePosition[    193462,       6672]
CellTagsIndexPosition[    193241,       6662]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "RollBasicAndGeneralized\n",
 StyleBox["Empirical Market Microstructure",
  FontSlant->"Italic"],
 " \n\t(2006, Oxford University Press)\nCompanion ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook\n\nJoel Hasbrouck\n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Copyright", " ", "2007"}], ",", " ", 
    RowBox[{"Joel", " ", 
     RowBox[{"Hasbrouck", ".", " ", "All"}], " ", "rights", " ", 
     RowBox[{"reserved", "."}]}]}], TraditionalForm]],
  FontSize->14,
  FontSlant->"Italic"],
 "\n",
 StyleBox["This notebook covers material in Chapters 3, 4 and 8.",
  FontSize->14]
}], "Title",
 CellChangeTimes->{{3.3896255910914*^9, 3.3896255932033997`*^9}, {
   3.3897167078988237`*^9, 3.389716768500824*^9}, 3.3897219191158237`*^9, {
   3.3897220399168243`*^9, 3.3897220640418243`*^9}, {3.389735393500024*^9, 
   3.389735431148024*^9}, 3.389735530878024*^9, 3.3897355723880243`*^9, {
   3.389735664464024*^9, 3.3897356860350237`*^9}, {3.3899891508672*^9, 
   3.3899891819161997`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Text", "  ", "@", " ", 
  RowBox[{"Style", "[", 
   RowBox[{
    RowBox[{"\"\<Notebook evaluated \>\"", "<>", 
     RowBox[{"DateString", "[", "\"\<DateTime\>\"", "]"}]}], ",", 
    "\"\<Subtitle\>\""}], "]"}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896127180972*^9, 3.3896127205282*^9}, 
   3.389716999411824*^9, {3.3897170351038237`*^9, 3.389717047196824*^9}}],

Cell[BoxData[
 InterpretationBox[Cell[BoxData[
   StyleBox["\<\"Notebook evaluated Wednesday 13 June 2007 10:28:38\"\>", 
    "Subtitle",
    StripOnInput->False]], "Text", "TR"],
  Text[
   Style["Notebook evaluated Wednesday 13 June 2007 10:28:38", 
    "Subtitle"]]]], "Output",
 CellMargins->{{18, Inherited}, {Inherited, 0}},
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896127211071997`*^9, {3.3896127536242*^9, 3.3896127555652*^9}, 
   3.3896128616452*^9, 3.389623031447*^9, 3.3896232934164*^9, 
   3.389716955274824*^9, 3.3897170008718243`*^9, {3.3897170377738237`*^9, 
   3.3897170482808237`*^9}, 3.389735230721224*^9, 3.3899894613552*^9, 
   3.3899897610886*^9, 3.3899911755866003`*^9, 3.3907337181646*^9},
 Background->RGBColor[0.866667, 0.733333, 1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Preliminaries", "Section",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"<<", "Notation`"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3895614945324*^9, 3.3895614962754*^9}, {
  3.389735743815024*^9, 3.389735746425024*^9}}],

Cell["\<\
The following commands define symbolizations that are convenient for labeling \
rules.\
\>", "Text",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3899892653942003`*^9, 3.3899892672032003`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["Anything_", "Rule"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";", 
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["Anything_", "Rules"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell["Set up symbols that will be used as subscripted paramaters:", "Text",
 CellChangeTimes->{{3.3899893037511997`*^9, 3.3899893339452*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["\[Gamma]", "_"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubsuperscriptBox["\[Sigma]", "_", "2"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";"}]}], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3899892926242*^9, 3.3899892956742*^9}}],

Cell["\<\
Define an \"expectations operator\". This isn't a real expectations operator, \
but it knows some simple rules like linearity.
The following command allows the \"expectation\" operator to be entered as \
\[EscapeKey]E\[EscapeKey].\
\>", "Text",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3899893380392*^9, 3.3899894065692*^9}}],

Cell[BoxData[
 RowBox[{"AddInputAlias", "[", 
  RowBox[{
   TagBox["\[ScriptCapitalE]",
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], ",", "\"\<E\>\""}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[ScriptCapitalE]Linearity", "Rules"], "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{"a_", "+", "b_"}], "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{"\[ScriptCapitalE]", "[", "a", "]"}], "+", 
       RowBox[{"\[ScriptCapitalE]", "[", "b", "]"}]}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", "c_", "]"}], "\[RuleDelayed]", 
      RowBox[{"c", "/;", 
       RowBox[{"NumberQ", "[", "c", "]"}]}]}], ",", " ", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", "c_Symbol", "]"}], "\[RuleDelayed]", 
      RowBox[{"c", "/;", 
       RowBox[{"MemberQ", "[", 
        RowBox[{
         RowBox[{"Attributes", "[", "c", "]"}], ",", "Constant"}], "]"}]}]}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{"c_", " ", "a_"}], "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{"c", " ", 
        RowBox[{"\[ScriptCapitalE]", "[", "a", "]"}]}], "/;", 
       RowBox[{"NumberQ", "[", "c", "]"}]}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{"c_Symbol", " ", "a_"}], "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{"c", " ", 
        RowBox[{"\[ScriptCapitalE]", "[", "a", "]"}]}], "/;", 
       RowBox[{"MemberQ", "[", 
        RowBox[{
         RowBox[{"Attributes", "[", "c", "]"}], ",", "Constant"}], "]"}]}]}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{
        SuperscriptBox["c_Symbol", "n_Integer"], " ", "a_"}], "]"}], 
      "\[RuleDelayed]", " ", 
      RowBox[{
       RowBox[{
        SuperscriptBox["c", "n"], " ", 
        RowBox[{"\[ScriptCapitalE]", "[", "a", "]"}]}], "/;", 
       RowBox[{"MemberQ", "[", 
        RowBox[{
         RowBox[{"Attributes", "[", "c", "]"}], ",", "Constant"}], 
        "]"}]}]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.3899895576071997`*^9, 3.3899896215762*^9}},
 CellLabel->"In[7]:="],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"\[ScriptCapitalE]", ",", "Listable"}], "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896277564578*^9, 3.3896277690578003`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Basic Roll (Chapter 3)", "Section",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell["Model:", "Subsection",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["m", "Rule"], "=", 
   RowBox[{
    SubscriptBox["m", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", 
      RowBox[{"t", "-", "1"}]], "+", 
     SubscriptBox["u", "t"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["p", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", "t"], "+", 
     RowBox[{"c", " ", 
      SubscriptBox["q", "t"]}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["\[CapitalDelta]p", "t_"], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["p", "t"], "/.", "\[InvisibleSpace]", 
        SubscriptBox["p", "Rule"]}], "/.", "\[InvisibleSpace]", 
       SubscriptBox["m", "Rule"]}], ")"}], "-", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["p", 
        RowBox[{"t", "-", "1"}]], "/.", "\[InvisibleSpace]", 
       SubscriptBox["p", "Rule"]}], ")"}]}]}]}], ";"}], "\n", 
 RowBox[{
  SubscriptBox["\[CapitalDelta]p", "t"], "/.", 
  SubscriptBox["\[CapitalDelta]p", "Rule"]}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "c"}], " ", 
   SubscriptBox["q", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "t"}]]}], "+", 
  RowBox[{"c", " ", 
   SubscriptBox["q", "t"]}], "+", 
  SubscriptBox["u", "t"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522797964*^9, 3.3895615195134*^9, 3.3895616653388*^9,
   3.389735881109024*^9, 3.3899894631092*^9, 3.3899901408845997`*^9, 
  3.3899911773306*^9, 3.3907337201865997`*^9}]
}, Open  ]],

Cell[TextData[{
 "To obtain ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Var", "[", 
    RowBox[{"\[CapitalDelta]", " ", 
     SubscriptBox["p", "t"]}], "]"}], "=", 
   SubscriptBox["\[Gamma]", "0"]}]]],
 ", consider:"
}], "Text",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3899898706176*^9, 3.3899898742195997`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   SubsuperscriptBox["\[CapitalDelta]p", "t", "2"], "/.", "\[InvisibleSpace]",
    
   SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["c", "2"], " ", 
   SubsuperscriptBox["q", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "t"}], "2"]}], "-", 
  RowBox[{"2", " ", 
   SuperscriptBox["c", "2"], " ", 
   SubscriptBox["q", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "t"}]], " ", 
   SubscriptBox["q", "t"]}], "+", 
  RowBox[{
   SuperscriptBox["c", "2"], " ", 
   SubsuperscriptBox["q", "t", "2"]}], "-", 
  RowBox[{"2", " ", "c", " ", 
   SubscriptBox["q", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "t"}]], " ", 
   SubscriptBox["u", "t"]}], "+", 
  RowBox[{"2", " ", "c", " ", 
   SubscriptBox["q", "t"], " ", 
   SubscriptBox["u", "t"]}], "+", 
  SubsuperscriptBox["u", "t", "2"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522798613997`*^9, 3.3895615195544*^9, 
  3.3895616653768*^9, 3.389735881150024*^9, 3.3899894631661997`*^9, 
  3.3899901409505997`*^9, 3.3899911773816*^9, 3.3907337202776003`*^9}]
}, Open  ]],

Cell["\<\
Now define some additional rules for the expectations operator. (These are \
specific to the model at hand.)\
\>", "Text",
 CellChangeTimes->{{3.3899896809772*^9, 3.3899897093202*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[ScriptCapitalE]Roll", "Rules"], "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       SubsuperscriptBox["q", "_", "2"], "]"}], "\[Rule]", "1"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       SubsuperscriptBox["u", "_", "2"], "]"}], "\[Rule]", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{
        SubscriptBox["q", "_"], 
        SubscriptBox["u", "_"]}], "]"}], "\[Rule]", " ", "0"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{
        SubscriptBox["q", "t_"], 
        SubscriptBox["q", "s_"]}], "]"}], "\[RuleDelayed]", " ", 
      RowBox[{"0", "/;", 
       RowBox[{"t", "=!=", "s"}]}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{
        SubscriptBox["u", "t_"], 
        SubscriptBox["u", "s_"]}], "]"}], "\[RuleDelayed]", " ", 
      RowBox[{"0", "/;", 
       RowBox[{"t", "=!=", "s"}]}]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.3899892356842003`*^9, 3.3899892472321997`*^9}, 
   3.3899895776122*^9, {3.3899896515032*^9, 3.3899896721542*^9}, {
   3.3899898460875998`*^9, 3.3899898471006002`*^9}},
 CellLabel->"In[14]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Attributes", "[", "c", "]"}], "=", 
   RowBox[{"{", "Constant", "}"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3897361367110243`*^9, 3.389736137347024*^9}, {
  3.389736265041024*^9, 3.389736265621024*^9}}],

Cell[TextData[{
 "Then ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Gamma]", "0"], "="}]], "Output"]
}], "Text",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3899898813666*^9, 3.3899899024296*^9}, {
  3.3899899441426*^9, 3.3899899512096*^9}, {3.3899899947166*^9, 
  3.3899900084316*^9}, {3.3899900615576*^9, 3.3899900813496*^9}, {
  3.3899901255366*^9, 3.3899901349526*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[ScriptCapitalE]", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{
      SubsuperscriptBox["\[CapitalDelta]p", "t", "2"], "/.", 
      "\[InvisibleSpace]", 
      SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}], "]"}], "//.", 
   SubscriptBox["\[ScriptCapitalE]Linearity", "Rules"]}], "//.", 
  SubscriptBox["\[ScriptCapitalE]Roll", "Rules"]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3897358526010237`*^9, 3.3897358599290237`*^9}, 
   3.389735918407024*^9, {3.3899898082806*^9, 3.3899898196816*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SuperscriptBox["c", "2"]}], "+", 
  SubsuperscriptBox["\[Sigma]", "u", "2"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522798943996`*^9, 3.3895615195903997`*^9, 
  3.3895616654098*^9, 3.389735881183024*^9, 3.3897359188440237`*^9, 
  3.389736171773024*^9, 3.3899894632122*^9, 3.3899901410516*^9, 
  3.3899911774536*^9, 3.3907337203566*^9}]
}, Open  ]],

Cell[TextData[{
 "To obtain ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Cov", "[", 
    RowBox[{
     SubscriptBox["\[CapitalDelta]p", "t"], ",", 
     SubscriptBox["\[CapitalDelta]p", 
      RowBox[{"t", "-", "1"}]]}], "]"}], "=", 
   SubscriptBox["\[Gamma]", "1"]}]]],
 ":"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{
    SubscriptBox["\[CapitalDelta]p", "t"], " ", 
    SubscriptBox["\[CapitalDelta]p", 
     RowBox[{"t", "-", "1"}]]}], "/.", "\[InvisibleSpace]", 
   SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389736216517024*^9, 3.3897362369870243`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["c", "2"], " ", 
   SubscriptBox["q", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "t"}]], " ", 
   SubscriptBox["q", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "t"}]]}], "-", 
  RowBox[{
   SuperscriptBox["c", "2"], " ", 
   SubsuperscriptBox["q", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "t"}], "2"]}], "-", 
  RowBox[{
   SuperscriptBox["c", "2"], " ", 
   SubscriptBox["q", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "t"}]], " ", 
   SubscriptBox["q", "t"]}], "+", 
  RowBox[{
   SuperscriptBox["c", "2"], " ", 
   SubscriptBox["q", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "t"}]], " ", 
   SubscriptBox["q", "t"]}], "-", 
  RowBox[{"c", " ", 
   SubscriptBox["q", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "t"}]], " ", 
   SubscriptBox["u", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "t"}]]}], "+", 
  RowBox[{"c", " ", 
   SubscriptBox["q", "t"], " ", 
   SubscriptBox["u", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "t"}]]}], "-", 
  RowBox[{"c", " ", 
   SubscriptBox["q", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "t"}]], " ", 
   SubscriptBox["u", "t"]}], "+", 
  RowBox[{"c", " ", 
   SubscriptBox["q", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "t"}]], " ", 
   SubscriptBox["u", "t"]}], "+", 
  RowBox[{
   SubscriptBox["u", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "t"}]], " ", 
   SubscriptBox["u", "t"]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522800084*^9, 3.3895615197504*^9, 3.3895616655238*^9,
   3.389735881335024*^9, 3.3897362218180237`*^9, 3.3899894632642*^9, 
  3.3899901411076*^9, 3.3899911775016003`*^9, 3.3907337204076*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[ScriptCapitalE]", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[CapitalDelta]p", "t"], " ", 
       SubscriptBox["\[CapitalDelta]p", 
        RowBox[{"t", "-", "1"}]]}], "/.", "\[InvisibleSpace]", 
      SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}], "]"}], "//.", 
   SubscriptBox["\[ScriptCapitalE]Linearity", "Rules"]}], "//.", 
  SubscriptBox["\[ScriptCapitalE]Roll", "Rules"]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3897362397700243`*^9, {3.3899898281036*^9, 3.3899898307146*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  SuperscriptBox["c", "2"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522800444*^9, 3.3895615198124*^9, 3.3895616655608*^9,
   3.389735881394024*^9, 3.389736242472024*^9, 3.3899894633092003`*^9, 
  3.3899901411826*^9, 3.3899911775526*^9, 3.3907337204576*^9}]
}, Open  ]],

Cell["The second-order autocorrelation is ... ", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[ScriptCapitalE]", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[CapitalDelta]p", "t"], " ", 
       SubscriptBox["\[CapitalDelta]p", 
        RowBox[{"t", "-", "2"}]]}], "/.", "\[InvisibleSpace]", 
      SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}], "]"}], "//.", 
   SubscriptBox["\[ScriptCapitalE]Linearity", "Rules"]}], "//.", 
  SubscriptBox["\[ScriptCapitalE]Roll", "Rules"]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3899898326415997`*^9, 3.3899898352216*^9}}],

Cell[BoxData["0"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522801224003`*^9, 3.3895615199224*^9, 
  3.3895616656348*^9, 3.3897358815090237`*^9, 3.389736252441024*^9, 
  3.3899894633622*^9, 3.3899901412616*^9, 3.3899911776026*^9, 
  3.3907337205116*^9}]
}, Open  ]],

Cell["... and so on.", "Text",
 CellLabelAutoDelete->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Elements of univariate time-series analysis (Chapter 4)", "Section",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell["Moving average forms", "Subsection",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "\[Theta]", "]"}], ";", 
  RowBox[{
   SubscriptBox["\[Gamma]", "0"], "=."}], ";", 
  RowBox[{
   SubscriptBox["\[Gamma]", "1"], "=."}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "The MA(1) process is ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["x", "t"], "=", 
   RowBox[{
    SubscriptBox["\[Epsilon]", "t"], "+", 
    SubscriptBox["\[Theta]\[Epsilon]", 
     RowBox[{"t", "-", "1"}]]}]}]]],
 ". The autocovariances are:"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["\[Gamma]", "Rules"], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Gamma]", "0"], "\[Rule]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["\[Theta]", "2"], "+", "1"}], ")"}], " ", 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}], ",", 
     RowBox[{
      SubscriptBox["\[Gamma]", "1"], "\[Rule]", 
      RowBox[{"\[Theta]", " ", 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["\[Gamma]", "Rules"], "//", "TableForm"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{
       SubscriptBox["\[Gamma]", "0"], "\[Rule]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["\[Theta]", "2"]}], ")"}], " ", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]},
     {
      RowBox[{
       SubscriptBox["\[Gamma]", "1"], "\[Rule]", 
       RowBox[{"\[Theta]", " ", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522802504*^9, 3.3895615246303997`*^9, 
  3.3895616656808*^9, 3.389736279787024*^9, 3.3899894634312*^9, 
  3.3899901620736*^9, 3.3899911776846*^9, 3.3907337206196003`*^9}]
}, Open  ]],

Cell["\<\
To solve backwards from the autocovariances to the model parameters:\
\>", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Gamma]Equations", "=", 
  RowBox[{"Apply", "[", 
   RowBox[{"Equal", ",", 
    SubscriptBox["\[Gamma]", "Rules"], ",", 
    RowBox[{"{", "1", "}"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["\[Gamma]", "0"], "\[Equal]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[Theta]", "2"]}], ")"}], " ", 
     SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}], ",", 
   RowBox[{
    SubscriptBox["\[Gamma]", "1"], "\[Equal]", 
    RowBox[{"\[Theta]", " ", 
     SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]}], "}"}]], "Output",\

 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522802894*^9, 3.3895615246633997`*^9, 
  3.3895616657118*^9, 3.389736279824024*^9, 3.3899894634772*^9, 
  3.3899901621356*^9, 3.3899911777316*^9, 3.3907337206686*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"\[Gamma]Equations", ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", 
     SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "}"}]}], 
  "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Gamma]", "1"], "\[Equal]", "0"}], "&&", 
    RowBox[{
     SubscriptBox["\[Gamma]", "0"], "\[Equal]", "0"}], "&&", 
    RowBox[{
     SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "\[Equal]", "0"}]}], 
   ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Gamma]", "1"], "\[NotEqual]", "0"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Theta]", "\[Equal]", 
       FractionBox[
        RowBox[{
         SubscriptBox["\[Gamma]", "0"], "-", 
         SqrtBox[
          RowBox[{
           SubsuperscriptBox["\[Gamma]", "0", "2"], "-", 
           RowBox[{"4", " ", 
            SubsuperscriptBox["\[Gamma]", "1", "2"]}]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["\[Gamma]", "1"]}]]}], "||", 
      RowBox[{"\[Theta]", "\[Equal]", 
       FractionBox[
        RowBox[{
         SubscriptBox["\[Gamma]", "0"], "+", 
         SqrtBox[
          RowBox[{
           SubsuperscriptBox["\[Gamma]", "0", "2"], "-", 
           RowBox[{"4", " ", 
            SubsuperscriptBox["\[Gamma]", "1", "2"]}]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["\[Gamma]", "1"]}]]}]}], ")"}], "&&", 
    RowBox[{
     SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "\[Equal]", 
     RowBox[{
      SubscriptBox["\[Gamma]", "0"], "-", 
      RowBox[{
       SubscriptBox["\[Gamma]", "1"], " ", "\[Theta]"}]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Gamma]", "1"], "\[Equal]", "0"}], "&&", 
    RowBox[{
     SubscriptBox["\[Gamma]", "0"], "\[NotEqual]", "0"}], "&&", 
    RowBox[{"\[Theta]", "\[Equal]", "0"}], "&&", 
    RowBox[{
     SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "\[Equal]", 
     SubscriptBox["\[Gamma]", "0"]}]}], ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522804954*^9, 3.3895615248014*^9, 
  3.3895616657748003`*^9, 3.3897362802590237`*^9, 3.3899894636762*^9, 
  3.3899901622665997`*^9, 3.3899911778466*^9, 3.3907337211266003`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"s", "=", 
   RowBox[{"Solve", "[", 
    RowBox[{"\[Gamma]Equations", ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "}"}]}], "]"}]}], 
  ";", 
  RowBox[{"s", "//", "TableForm"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[Gamma]", "0"], "-", 
         SqrtBox[
          RowBox[{
           SubsuperscriptBox["\[Gamma]", "0", "2"], "-", 
           RowBox[{"4", " ", 
            SubsuperscriptBox["\[Gamma]", "1", "2"]}]}]]}], ")"}]}]}], 
     RowBox[{"\[Theta]", "\[Rule]", 
      FractionBox[
       RowBox[{
        SubscriptBox["\[Gamma]", "0"], "+", 
        SqrtBox[
         RowBox[{
          SubsuperscriptBox["\[Gamma]", "0", "2"], "-", 
          RowBox[{"4", " ", 
           SubsuperscriptBox["\[Gamma]", "1", "2"]}]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["\[Gamma]", "1"]}]]}]},
    {
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "\[Rule]", 
      RowBox[{
       FractionBox[
        SubscriptBox["\[Gamma]", "0"], "2"], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        SqrtBox[
         RowBox[{
          SubsuperscriptBox["\[Gamma]", "0", "2"], "-", 
          RowBox[{"4", " ", 
           SubsuperscriptBox["\[Gamma]", "1", "2"]}]}]]}]}]}], 
     RowBox[{"\[Theta]", "\[Rule]", 
      FractionBox[
       RowBox[{
        SubscriptBox["\[Gamma]", "0"], "-", 
        SqrtBox[
         RowBox[{
          SubsuperscriptBox["\[Gamma]", "0", "2"], "-", 
          RowBox[{"4", " ", 
           SubsuperscriptBox["\[Gamma]", "1", "2"]}]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["\[Gamma]", "1"]}]]}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522806344*^9, 3.3895615248334*^9, 3.3895616658098*^9,
   3.389736280298024*^9, 3.3899894637352*^9, 3.3899901623356*^9, 
  3.3899911779066*^9, 3.3907337212426*^9}]
}, Open  ]],

Cell["With some hypothetical values, the MA parameters are", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"s", "/.", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Gamma]", "0"], "\[Rule]", "1"}], ",", 
     RowBox[{
      SubscriptBox["\[Gamma]", "1"], "\[Rule]", 
      RowBox[{"-", ".2"}]}]}], "}"}]}], "//", "TableForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "\[Rule]", 
      "0.041742430504416006`"}], 
     RowBox[{"\[Theta]", "\[Rule]", 
      RowBox[{"-", "4.7912878474779195`"}]}]},
    {
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "\[Rule]", 
      "0.9582575694955839`"}], 
     RowBox[{"\[Theta]", "\[Rule]", 
      RowBox[{"-", "0.20871215252208003`"}]}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522806774*^9, 3.3895615248484*^9, 3.3895616658428*^9,
   3.389736280359024*^9, 3.3899894637822*^9, 3.3899901623976*^9, 
  3.3899911779546003`*^9, 3.3907337212976*^9}]
}, Open  ]],

Cell["So the second solution is the invertible one.", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "//", "Simplify"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[Gamma]", "0"], "-", 
         SqrtBox[
          RowBox[{
           SubsuperscriptBox["\[Gamma]", "0", "2"], "-", 
           RowBox[{"4", " ", 
            SubsuperscriptBox["\[Gamma]", "1", "2"]}]}]]}], ")"}]}]}], ",", 
     RowBox[{"\[Theta]", "\[Rule]", 
      FractionBox[
       RowBox[{
        SubscriptBox["\[Gamma]", "0"], "+", 
        SqrtBox[
         RowBox[{
          SubsuperscriptBox["\[Gamma]", "0", "2"], "-", 
          RowBox[{"4", " ", 
           SubsuperscriptBox["\[Gamma]", "1", "2"]}]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["\[Gamma]", "1"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[Gamma]", "0"], "+", 
         SqrtBox[
          RowBox[{
           SubsuperscriptBox["\[Gamma]", "0", "2"], "-", 
           RowBox[{"4", " ", 
            SubsuperscriptBox["\[Gamma]", "1", "2"]}]}]]}], ")"}]}]}], ",", 
     RowBox[{"\[Theta]", "\[Rule]", 
      FractionBox[
       RowBox[{
        SubscriptBox["\[Gamma]", "0"], "-", 
        SqrtBox[
         RowBox[{
          SubsuperscriptBox["\[Gamma]", "0", "2"], "-", 
          RowBox[{"4", " ", 
           SubsuperscriptBox["\[Gamma]", "1", "2"]}]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["\[Gamma]", "1"]}]]}]}], "}"}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522807234*^9, 3.3895615248704*^9, 3.3895616658868*^9,
   3.389736280425024*^9, 3.3899894638501997`*^9, 3.3899901625146*^9, 
  3.3899911780236*^9, 3.3907337213956003`*^9}]
}, Open  ]],

Cell[TextData[{
 "Alternative form for ",
 Cell[BoxData[
  SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]]],
 " in the invertible case:"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["\[Gamma]", "0"], "+", 
      SqrtBox[
       RowBox[{
        SubsuperscriptBox["\[Gamma]", "0", "2"], "-", 
        RowBox[{"4", " ", 
         SubsuperscriptBox["\[Gamma]", "1", "2"]}]}]]}], ")"}]}], "\[Equal]", 
   
   FractionBox[
    RowBox[{"2", 
     SubsuperscriptBox["\[Gamma]", "1", "2"]}], 
    RowBox[{
     SubscriptBox["\[Gamma]", "0"], "-", 
     SqrtBox[
      RowBox[{
       SubsuperscriptBox["\[Gamma]", "0", "2"], "-", 
       RowBox[{"4", 
        SubsuperscriptBox["\[Gamma]", "1", "2"]}]}]]}]]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData["True"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522808034*^9, 3.3895615249124002`*^9, 
  3.3895616659278*^9, 3.3897362805010242`*^9, 3.3899894639242*^9, 
  3.3899901626275997`*^9, 3.3899911780846*^9, 3.3907337214926*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Autoregressive forms", "Subsection",
 CellLabelAutoDelete->True],

Cell["We define a recursive rule for the residuals:", "Text",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Epsilon]", "Rule"], "=", 
   RowBox[{
    SubscriptBox["\[Epsilon]", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["\[CapitalDelta]p", "t"], "-", 
     RowBox[{"\[Theta]", " ", 
      SubscriptBox["\[Epsilon]", 
       RowBox[{"t", "-", "1"}]]}]}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "t"], "=", 
   RowBox[{
    SubscriptBox["\[Epsilon]", "t"], "-", 
    SubscriptBox["\[Theta]\[Epsilon]", 
     RowBox[{"t", "-", "1"}]]}]}]]],
 ". With one recursive substitution for ",
 Cell[BoxData[
  SubscriptBox["\[Epsilon]", 
   RowBox[{"t", "-", "1"}]]]],
 "...."
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Epsilon]", "t"], "+", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"\[Theta]", " ", 
      SubscriptBox["\[Epsilon]", 
       RowBox[{"t", "-", "1"}]]}], "/.", 
     SubscriptBox["\[Epsilon]", "Rule"]}], ")"}]}], "//", "Expand"}]], "Input",\

 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Theta]", " ", 
   SubscriptBox["\[CapitalDelta]p", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "t"}]]}], "-", 
  RowBox[{
   SuperscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Epsilon]", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "t"}]]}], "+", 
  SubscriptBox["\[Epsilon]", "t"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522808444*^9, 3.3895615249564*^9, 3.3895616659648*^9, 
   3.3899894639821997`*^9, {3.3899901627416*^9, 3.3899901716766*^9}, 
   3.3899911781496*^9, 3.3907337215596*^9}]
}, Open  ]],

Cell["... and two recursive substitutions ...", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Epsilon]", "t"], "+", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Theta]", " ", 
       SubscriptBox["\[Epsilon]", 
        RowBox[{"t", "-", "1"}]]}], "/.", 
      SubscriptBox["\[Epsilon]", "Rule"]}], "/.", 
     SubscriptBox["\[Epsilon]", "Rule"]}], ")"}]}], "//", "Expand"}]], "Input",\

 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    SuperscriptBox["\[Theta]", "2"]}], " ", 
   SubscriptBox["\[CapitalDelta]p", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "t"}]]}], "+", 
  RowBox[{"\[Theta]", " ", 
   SubscriptBox["\[CapitalDelta]p", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "t"}]]}], "+", 
  RowBox[{
   SuperscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Epsilon]", 
    RowBox[{
     RowBox[{"-", "3"}], "+", "t"}]]}], "+", 
  SubscriptBox["\[Epsilon]", "t"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522808774*^9, 3.3895615249994*^9, 3.3895616660028*^9, 
   3.3899894640292*^9, {3.3899901628146*^9, 3.3899901717356*^9}, 
   3.3899911781966*^9, 3.3907337216106*^9}]
}, Open  ]],

Cell["Alternatively, going directly to the autoregressive form:", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"\[Theta]", " ", "L"}]}], ")"}], 
    RowBox[{"-", "1"}]], ",", 
   RowBox[{"{", 
    RowBox[{"L", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   RowBox[{"\[Theta]", " ", "L"}], "+", 
   RowBox[{
    SuperscriptBox["\[Theta]", "2"], " ", 
    SuperscriptBox["L", "2"]}], "-", 
   RowBox[{
    SuperscriptBox["\[Theta]", "3"], " ", 
    SuperscriptBox["L", "3"]}], "+", 
   RowBox[{
    SuperscriptBox["\[Theta]", "4"], " ", 
    SuperscriptBox["L", "4"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "L", "]"}], "5"],
    SeriesData[$CellContext`L, 0, {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`L, 0, {
   1, -$CellContext`\[Theta], $CellContext`\[Theta]^2, \
-$CellContext`\[Theta]^3, $CellContext`\[Theta]^4}, 0, 5, 1],
  Editable->False]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522810324*^9, 3.3895615250624*^9, 3.3895616660768003`*^9, 
   3.3899894641991997`*^9, {3.3899901629386*^9, 3.3899901717976*^9}, 
   3.3899911783076*^9, 3.3907337218086*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4.1", "Subsection",
 CellLabelAutoDelete->True,
 CellTags->"Ch4Ex3period"],

Cell[TextData[{
 "Here is a function to build a table of all possible ",
 Cell[BoxData["n"]],
 " successive realizations of ",
 Cell[BoxData["q"]],
 "."
}], "Text",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"qTable", "[", "n_", "]"}], ":=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "^", 
      RowBox[{"IntegerDigits", "[", 
       RowBox[{"i", ",", "2", ",", "n"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", 
       RowBox[{
        SuperscriptBox["2", "n"], "-", "1"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell["... and for the 3-period problem, the realizations are:", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"q", "=", 
   RowBox[{"qTable", "[", "3", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"TableForm", "[", 
  RowBox[{"q", ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\!\(\*SubscriptBox[\(q\), \(0\)]\)\>\"", ",", 
        "\"\<\!\(\*SubscriptBox[\(q\), \(1\)]\)\>\"", ",", 
        "\"\<\!\(\*SubscriptBox[\(q\), \(2\)]\)\>\""}], "}"}]}], "}"}]}], ",",
    
   RowBox[{"TableAlignments", "\[Rule]", "Right"}]}], "]"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      StyleBox["\[Null]",
       ShowStringCharacters->False], 
      TagBox["\<\"\\!\\(\\*SubscriptBox[\\(q\\), \\(0\\)]\\)\"\>",
       HoldForm], 
      TagBox["\<\"\\!\\(\\*SubscriptBox[\\(q\\), \\(1\\)]\\)\"\>",
       HoldForm], 
      TagBox["\<\"\\!\\(\\*SubscriptBox[\\(q\\), \\(2\\)]\\)\"\>",
       HoldForm]},
     {"1", "1", "1", "1"},
     {"2", "1", "1", 
      RowBox[{"-", "1"}]},
     {"3", "1", 
      RowBox[{"-", "1"}], "1"},
     {"4", "1", 
      RowBox[{"-", "1"}], 
      RowBox[{"-", "1"}]},
     {"5", 
      RowBox[{"-", "1"}], "1", "1"},
     {"6", 
      RowBox[{"-", "1"}], "1", 
      RowBox[{"-", "1"}]},
     {"7", 
      RowBox[{"-", "1"}], 
      RowBox[{"-", "1"}], "1"},
     {"8", 
      RowBox[{"-", "1"}], 
      RowBox[{"-", "1"}], 
      RowBox[{"-", "1"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
      "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   TableForm[
   BoxForm`e$, 
    TableHeadings -> {
     Automatic, {
      "\!\(\*SubscriptBox[\(q\), \(0\)]\)", 
       "\!\(\*SubscriptBox[\(q\), \(1\)]\)", 
       "\!\(\*SubscriptBox[\(q\), \(2\)]\)"}}, TableAlignments -> 
    Right]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522810774*^9, 3.3895615251274*^9, 3.3895616661198*^9, 
   3.3899894642511997`*^9, {3.3899901630296*^9, 3.3899901846316*^9}, 
   3.3899911784166*^9, 3.3907337218736*^9}]
}, Open  ]],

Cell["The transition probabilities for each path are:", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PrTrans", "[", "q_", "]"}], ":=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"q", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}], "\[Equal]", 
        RowBox[{"q", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", 
           RowBox[{"j", "-", "1"}]}], "]"}], "]"}]}], ",", "\[Alpha]", ",", 
       RowBox[{"1", "-", "\[Alpha]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "q", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "2", ",", 
       RowBox[{
        RowBox[{"Dimensions", "[", "q", "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"qp", "=", 
   RowBox[{"PrTrans", "[", "q", "]"}]}], ";"}], "\n", 
 RowBox[{"TableForm", "[", 
  RowBox[{"qp", ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\!\(\*SubscriptBox[\(Pr\), \(0 \[Rule] 1\)]\)\>\"", ",", 
        "\"\<\!\(\*SubscriptBox[\(Pr\), \(1 \[Rule] 2\)]\)\>\""}], "}"}]}], 
     "}"}]}], ",", 
   RowBox[{"TableAlignments", "\[Rule]", "Right"}]}], "]"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      StyleBox["\[Null]",
       ShowStringCharacters->False], 
      TagBox["\<\"\\!\\(\\*SubscriptBox[\\(Pr\\), \\(0 \[Rule] 1\\)]\\)\"\>",
       HoldForm], 
      TagBox["\<\"\\!\\(\\*SubscriptBox[\\(Pr\\), \\(1 \[Rule] 2\\)]\\)\"\>",
       HoldForm]},
     {"1", "\[Alpha]", "\[Alpha]"},
     {"2", "\[Alpha]", 
      RowBox[{"1", "-", "\[Alpha]"}]},
     {"3", 
      RowBox[{"1", "-", "\[Alpha]"}], 
      RowBox[{"1", "-", "\[Alpha]"}]},
     {"4", 
      RowBox[{"1", "-", "\[Alpha]"}], "\[Alpha]"},
     {"5", 
      RowBox[{"1", "-", "\[Alpha]"}], "\[Alpha]"},
     {"6", 
      RowBox[{"1", "-", "\[Alpha]"}], 
      RowBox[{"1", "-", "\[Alpha]"}]},
     {"7", "\[Alpha]", 
      RowBox[{"1", "-", "\[Alpha]"}]},
     {"8", "\[Alpha]", "\[Alpha]"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
      "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   TableForm[
   BoxForm`e$, 
    TableHeadings -> {
     Automatic, {
      "\!\(\*SubscriptBox[\(Pr\), \(0 \[Rule] 1\)]\)", 
       "\!\(\*SubscriptBox[\(Pr\), \(1 \[Rule] 2\)]\)"}}, TableAlignments -> 
    Right]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522811134*^9, 3.3895615251674*^9, 3.3895616661598*^9, 
   3.3899894643012*^9, {3.3899901631226*^9, 3.3899901846846*^9}, 
   3.3899911784776*^9, 3.3907337219316*^9}]
}, Open  ]],

Cell["The total probabilities of each path are:", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"TotalProbs", "=", 
   RowBox[{
    RowBox[{"Apply", "[", 
     RowBox[{"Times", ",", "qp", ",", 
      RowBox[{"{", "1", "}"}]}], "]"}], "/", "2"}]}], ";"}], "\n", 
 RowBox[{"TableForm", "[", 
  RowBox[{"TotalProbs", ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", 
      RowBox[{"{", "\"\<\!\(\*SubscriptBox[\(Pr\), \(Total\)]\)\>\"", "}"}]}],
      "}"}]}], ",", 
   RowBox[{"TableAlignments", "\[Rule]", "Right"}]}], "]"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {"1", 
      FractionBox[
       SuperscriptBox["\[Alpha]", "2"], "2"]},
     {"2", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "\[Alpha]"}], ")"}], " ", "\[Alpha]"}]},
     {"3", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "\[Alpha]"}], ")"}], "2"]}]},
     {"4", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "\[Alpha]"}], ")"}], " ", "\[Alpha]"}]},
     {"5", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "\[Alpha]"}], ")"}], " ", "\[Alpha]"}]},
     {"6", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "\[Alpha]"}], ")"}], "2"]}]},
     {"7", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "\[Alpha]"}], ")"}], " ", "\[Alpha]"}]},
     {"8", 
      FractionBox[
       SuperscriptBox["\[Alpha]", "2"], "2"]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxDividers->{
     "Columns" -> {False, {True}, False}, "ColumnsIndexed" -> {}, 
      "Rows" -> {{False}}, "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   OutputFormsDump`HeadedColumn],
  Function[BoxForm`e$, 
   TableForm[
   BoxForm`e$, 
    TableHeadings -> {Automatic, {"\!\(\*SubscriptBox[\(Pr\), \(Total\)]\)"}},
     TableAlignments -> Right]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522811544*^9, 3.3895615252104*^9, 3.3895616661928*^9, 
   3.3899894643492002`*^9, {3.3899901632366*^9, 3.3899901847626*^9}, 
   3.3899911785386*^9, 3.3907337219906*^9}]
}, Open  ]],

Cell["Verify that the probabilities sum to one:", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Total", "[", "TotalProbs", "]"}], "//", "Simplify"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData["1"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522811893997`*^9, 3.3895615252474003`*^9, 3.3895616662268*^9, 
   3.3899894643972*^9, {3.3899901633136*^9, 3.3899901848296003`*^9}, 
   3.3899911785875998`*^9, 3.3907337220566*^9}]
}, Open  ]],

Cell[TextData[{
 "Compute the ",
 Cell[BoxData[
  SubscriptBox["v", "t"]]],
 "'s using the definition ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["v", "t"], "=", 
   RowBox[{
    SubscriptBox["q", "t"], "-", 
    RowBox[{
     SubscriptBox["\[Phi]q", 
      RowBox[{"t", "-", "1"}]], ":"}]}]}]]]
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{
    RowBox[{"q", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}], "-", 
    RowBox[{"\[Phi]", " ", 
     RowBox[{"q", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}]}]}], ";"}], "\n", 
 RowBox[{"TableForm", "[", 
  RowBox[{"v", ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\!\(\*SubscriptBox[\(v\), \(1\)]\)\>\"", ",", 
        "\"\<\!\(\*SubscriptBox[\(v\), \(2\)]\)\>\""}], "}"}]}], "}"}]}], ",",
    
   RowBox[{"TableAlignments", "\[Rule]", "Right"}]}], "]"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      StyleBox["\[Null]",
       ShowStringCharacters->False], 
      TagBox["\<\"\\!\\(\\*SubscriptBox[\\(v\\), \\(1\\)]\\)\"\>",
       HoldForm], 
      TagBox["\<\"\\!\\(\\*SubscriptBox[\\(v\\), \\(2\\)]\\)\"\>",
       HoldForm]},
     {"1", 
      RowBox[{"1", "-", "\[Phi]"}], 
      RowBox[{"1", "-", "\[Phi]"}]},
     {"2", 
      RowBox[{"1", "-", "\[Phi]"}], 
      RowBox[{
       RowBox[{"-", "1"}], "-", "\[Phi]"}]},
     {"3", 
      RowBox[{
       RowBox[{"-", "1"}], "-", "\[Phi]"}], 
      RowBox[{"1", "+", "\[Phi]"}]},
     {"4", 
      RowBox[{
       RowBox[{"-", "1"}], "-", "\[Phi]"}], 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Phi]"}]},
     {"5", 
      RowBox[{"1", "+", "\[Phi]"}], 
      RowBox[{"1", "-", "\[Phi]"}]},
     {"6", 
      RowBox[{"1", "+", "\[Phi]"}], 
      RowBox[{
       RowBox[{"-", "1"}], "-", "\[Phi]"}]},
     {"7", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Phi]"}], 
      RowBox[{"1", "+", "\[Phi]"}]},
     {"8", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Phi]"}], 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Phi]"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
      "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   TableForm[
   BoxForm`e$, 
    TableHeadings -> {
     Automatic, {
      "\!\(\*SubscriptBox[\(v\), \(1\)]\)", 
       "\!\(\*SubscriptBox[\(v\), \(2\)]\)"}}, TableAlignments -> 
    Right]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522812254*^9, 3.3895615252864*^9, 3.3895616662618*^9, 
   3.3899894644482*^9, {3.3899901634046*^9, 3.3899901848956003`*^9}, 
   3.3899911786466*^9, 3.3907337221196003`*^9}]
}, Open  ]],

Cell[TextData[{
 "Verify that ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["Ev", "1"], "=", 
   RowBox[{
    SubscriptBox["Ev", "2"], "=", "0"}]}]]],
 ":"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"TotalProbs", ".", 
   RowBox[{"v", "[", 
    RowBox[{"[", "All", "]"}], "]"}]}], "//", "Simplify"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522812614*^9, 3.3895615253254004`*^9, 3.3895616662948*^9, 
   3.3899894644962*^9, {3.3899901634826*^9, 3.3899901849596*^9}, 
   3.3899911786976*^9, 3.3907337221766*^9}]
}, Open  ]],

Cell[TextData[{
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Var", 
    RowBox[{"(", 
     SubscriptBox["v", "t"], ")"}]}], "\[Congruent]", 
   SubscriptBox["\[Gamma]", "0"]}]]]
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Gamma]", "0"], "=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"TotalProbs", ".", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"v", "[", 
        RowBox[{"[", "All", "]"}], "]"}], "^", "2"}], ")"}]}], "//", 
    "Simplify"}], ")"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", "-", 
       RowBox[{"4", " ", "\[Alpha]"}]}], ")"}], " ", "\[Phi]"}], "+", 
    SuperscriptBox["\[Phi]", "2"]}], ",", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", "-", 
       RowBox[{"4", " ", "\[Alpha]"}]}], ")"}], " ", "\[Phi]"}], "+", 
    SuperscriptBox["\[Phi]", "2"]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522812974*^9, 3.3895615253684*^9, 3.3895616663308*^9, 
   3.3899894645481997`*^9, {3.3899901635666*^9, 3.3899901850276003`*^9}, 
   3.3899911787506*^9, 3.3907337222566*^9}]
}, Open  ]],

Cell[TextData[{
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Cov", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["v", "t"], ",", 
      SubscriptBox["v", 
       RowBox[{"t", "-", "1"}]]}], ")"}]}], "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["Ev", "t"], 
     SubscriptBox["v", 
      RowBox[{"t", "-", "1"}]]}], "\[Congruent]", 
    SubscriptBox["\[Gamma]", "1"]}]}]]]
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Gamma]", "1"], "=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"TotalProbs", ".", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"v", "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", "1"}], "]"}], "]"}], " ", 
       RowBox[{"v", "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", "2"}], "]"}], "]"}]}], ")"}]}], "//", 
    "Simplify"}], ")"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "4"}], " ", 
   SuperscriptBox["\[Alpha]", "2"], " ", "\[Phi]"}], "-", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", "\[Phi]"}], ")"}], "2"], "+", 
  RowBox[{"2", " ", "\[Alpha]", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Phi]"}], ")"}], "2"]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522813824*^9, 3.3895615254133997`*^9, 3.3895616663747997`*^9, 
   3.3899894646122*^9, {3.3899901636616*^9, 3.3899901851116*^9}, 
   3.3899911788146*^9, 3.3907337223255997`*^9}]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox["v", "t"]]],
 " must be uncorrelated, so solve for the value of ",
 Cell[BoxData["\[Phi]"]],
 " that makes ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Gamma]", "1"], "=", "0"}]]],
 ":"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Gamma]", "1"], "\[Equal]", "0"}], ",", "\[Phi]"}], 
   "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Phi]", "\[Rule]", 
     FractionBox["1", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"2", " ", "\[Alpha]"}]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "\[Alpha]"}]}]}], "}"}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522814894*^9, 3.3895615254494*^9, 3.3895616664077997`*^9, 
   3.3899894646982*^9, {3.3899901637466*^9, 3.3899901851846*^9}, 
   3.3899911788666*^9, 3.3907337224026003`*^9}]
}, Open  ]],

Cell[TextData[{
 "There are two solutions, but only the second has ",
 Cell[BoxData[
  RowBox[{"|", "\[Phi]", "|", 
   RowBox[{"<", "1"}]}]]],
 ". For example,"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Phi]", "/.", "s"}], "/.", 
  RowBox[{"\[Alpha]", "\[Rule]", ".6"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.000000000000001`", ",", "0.19999999999999996`"}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522815224*^9, 3.3895615254854*^9, 3.3895616664398003`*^9, 
   3.3899894647462*^9, {3.3899901638296003`*^9, 3.3899901852586*^9}, 
   3.3899911789175997`*^9, 3.3907337224516*^9}]
}, Open  ]],

Cell["So, take the second solution:", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"s", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "1"}], "]"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"\[Phi]", "\[Rule]", 
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{"2", " ", "\[Alpha]"}]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522815573997`*^9, 3.3895615255224*^9, 3.3895616664748*^9, 
   3.3899894647972*^9, {3.3899901639116*^9, 3.3899901853336*^9}, 
   3.3899911790386*^9, 3.3907337225016003`*^9}]
}, Open  ]],

Cell[TextData[{
 "Verify that this results in ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Gamma]", "1"], "=", "0"}]]],
 ":"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TotalProbs", ".", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"v", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "1"}], "]"}], "]"}], 
      RowBox[{"v", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "2"}], "]"}], "]"}]}], ")"}]}], "/.", "s"}], "//",
   "Simplify"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData["0"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522815924*^9, 3.3895615255643997`*^9, 3.3895616665088*^9, 
   3.3899894648472*^9, {3.3899901639936*^9, 3.3899901854066*^9}, 
   3.3899911790976*^9, 3.3907337225516*^9}]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox["v", "t"]]],
 "'s have no skewness:"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TotalProbs", ".", 
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"v", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "2"}], "]"}], "]"}], "3"], ")"}]}], "/.", "s"}], "//",
   "Simplify"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData["0"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522816284*^9, 3.3895615256004*^9, 3.3895616665397997`*^9, 
   3.3899894649002*^9, {3.3899901640826*^9, 3.3899901854816*^9}, 
   3.3899911791566*^9, 3.3907337226015997`*^9}]
}, Open  ]],

Cell[TextData[{
 "Verify that the higher-order serial moment is non-zero, i.e., ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Cov", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["v", 
       RowBox[{"t", "-", "1"}]], ",", 
      SubsuperscriptBox["v", "t", "3"]}], ")"}]}], "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["Ev", 
      RowBox[{"t", "-", "1"}]], 
     SubsuperscriptBox["v", "t", "3"]}], "\[NotEqual]", "0"}]}]]]
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TotalProbs", ".", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"v", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "1"}], "]"}], "]"}], "*", 
      SuperscriptBox[
       RowBox[{"v", "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", "2"}], "]"}], "]"}], "3"]}], ")"}]}], "/.", 
   "s"}], "//", "Simplify"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "32"}], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "\[Alpha]"}], ")"}], "2"], " ", 
  SuperscriptBox["\[Alpha]", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"2", " ", "\[Alpha]"}]}], ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522816674*^9, 3.3895615256384*^9, 3.3895616665788*^9, 
   3.3899894649992*^9, {3.3899901641736*^9, 3.3899901855606003`*^9}, 
   3.3899911792236*^9, 3.3907337226616*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"ClearAll", "[", 
  RowBox[{"q", ",", "u", ",", "v", ",", 
   SubscriptBox["\[Gamma]", "0"], ",", 
   SubscriptBox["\[Gamma]", "1"]}], "]"}]], "Input",
 CellLabelAutoDelete->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4.2", "Subsection",
 CellLabelAutoDelete->True,
 CellTags->"Ch4ExCorrq"],

Cell["The model is:", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["m", "Rule"], "=", 
   RowBox[{
    SubscriptBox["m", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", 
      RowBox[{"t", "-", "1"}]], "+", 
     SubscriptBox["u", "t"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["p", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", "t"], "+", 
     RowBox[{"c", " ", 
      SubscriptBox["q", "t"]}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["\[CapitalDelta]p", "t_"], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["p", "t"], "/.", "\[InvisibleSpace]", 
        SubscriptBox["p", "Rule"]}], "/.", "\[InvisibleSpace]", 
       SubscriptBox["m", "Rule"]}], ")"}], "-", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["p", 
        RowBox[{"t", "-", "1"}]], "/.", "\[InvisibleSpace]", 
       SubscriptBox["p", "Rule"]}], ")"}]}]}]}], ";"}], "\n", 
 RowBox[{
  SubscriptBox["\[CapitalDelta]p", "t"], "/.", 
  SubscriptBox["\[CapitalDelta]p", "Rule"]}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "c"}], " ", 
   SubscriptBox["q", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "t"}]]}], "+", 
  RowBox[{"c", " ", 
   SubscriptBox["q", "t"]}], "+", 
  SubscriptBox["u", "t"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522818073997`*^9, 3.3895615257014*^9, 
  3.3895616666317997`*^9, 3.3899894650931997`*^9, 3.3899901642676*^9, 
  3.3899903565025997`*^9, 3.3899911793086*^9, 3.3907337227216*^9}]
}, Open  ]],

Cell[TextData[{
 "We need some alternate rules for the expectation operator to recognize the \
correlation between ",
 Cell[BoxData[
  SubscriptBox["q", "t"]]],
 " and ",
 Cell[BoxData[
  SubscriptBox["q", 
   RowBox[{"t", "-", "1"}]]]],
 "."
}], "Text",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[ScriptCapitalE]Alternate", "Rules"], "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       SubsuperscriptBox["q", "_", "2"], "]"}], "\[Rule]", "1"}], ",", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       SubsuperscriptBox["u", "_", "2"], "]"}], "\[Rule]", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{
        SubscriptBox["q", "_"], 
        SubscriptBox["u", "_"]}], "]"}], "\[Rule]", " ", "0"}], ",", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{
        SubscriptBox["q", "t_"], 
        SubscriptBox["q", "s_"]}], "]"}], "\[RuleDelayed]", " ", 
      RowBox[{"0", "/;", 
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"t", "-", "s"}], "]"}], ">", "1"}]}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{
        SubscriptBox["q", "t_"], 
        SubscriptBox["q", "s_"]}], "]"}], "\[RuleDelayed]", " ", 
      RowBox[{"\[Rho]", "/;", 
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"t", "-", "s"}], "]"}], "\[Equal]", "1"}]}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{
        SubscriptBox["u", "t_"], 
        SubscriptBox["u", "s_"]}], "]"}], "\[RuleDelayed]", " ", 
      RowBox[{"0", "/;", 
       RowBox[{"t", "=!=", "s"}]}]}]}], "}"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3899902779536*^9, 3.3899902974196*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[ScriptCapitalE]", "Rules"], "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     SubscriptBox["\[ScriptCapitalE]Alternate", "Rules"], ",", 
     SubscriptBox["\[ScriptCapitalE]Linearity", "Rules"]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.3899910600936003`*^9, 3.3899910656446*^9}},
 CellLabel->"In[59]:="],

Cell["\<\
To get the variance, we multiply everything out, and take the expectation:\
\>", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[ScriptCapitalE]", "[", 
  RowBox[{"Expand", "[", 
   RowBox[{
    SubsuperscriptBox["\[CapitalDelta]p", "t", "2"], "/.", 
    SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"\[ScriptCapitalE]", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["c", "2"], " ", 
    SubsuperscriptBox["q", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "t"}], "2"]}], "-", 
   RowBox[{"2", " ", 
    SuperscriptBox["c", "2"], " ", 
    SubscriptBox["q", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "t"}]], " ", 
    SubscriptBox["q", "t"]}], "+", 
   RowBox[{
    SuperscriptBox["c", "2"], " ", 
    SubsuperscriptBox["q", "t", "2"]}], "-", 
   RowBox[{"2", " ", "c", " ", 
    SubscriptBox["q", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "t"}]], " ", 
    SubscriptBox["u", "t"]}], "+", 
   RowBox[{"2", " ", "c", " ", 
    SubscriptBox["q", "t"], " ", 
    SubscriptBox["u", "t"]}], "+", 
   SubsuperscriptBox["u", "t", "2"]}], "]"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522818803997`*^9, 3.3895615257844*^9, 3.3895616667008*^9, 
   3.3899894652061996`*^9, 3.3899901644666*^9, 3.3899903566566*^9, {
   3.3899904271935997`*^9, 3.3899904484146*^9}, 3.3899911793866*^9, 
   3.3907337228066*^9}]
}, Open  ]],

Cell["\<\
Using the rules described about to eliminate terms that have zero \
expectation:\
\>", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "//.", 
   SubscriptBox["\[ScriptCapitalE]", "Rules"]}], "//", "Simplify"}]], "Input",\

 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3899903087226*^9, 3.3899903217586*^9}, {
   3.3899904183496*^9, 3.3899904401496*^9}, 3.3899910778696003`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "2"}], " ", 
   SuperscriptBox["c", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "\[Rho]"}], ")"}]}], "+", 
  SubsuperscriptBox["\[Sigma]", "u", "2"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522819214*^9, 3.3895615258324003`*^9, 3.3895616667377996`*^9, 
   3.3899894652642*^9, 3.3899901645536003`*^9, 3.3899903567256002`*^9, {
   3.3899904294156*^9, 3.3899904502576*^9}, 3.3899911794466*^9, 
   3.3907337228746*^9}]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Cov", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[CapitalDelta]p", "t"], ",", 
     SubscriptBox["\[CapitalDelta]p", 
      RowBox[{"t", "-", "1"}]]}], ")"}]}]]],
 ":"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[ScriptCapitalE]", "[", 
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[CapitalDelta]p", "t"], 
     SubscriptBox["\[CapitalDelta]p", 
      RowBox[{"t", "-", "1"}]]}], "/.", 
    SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"\[ScriptCapitalE]", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["c", "2"], " ", 
    SubscriptBox["q", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "t"}]], " ", 
    SubscriptBox["q", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "t"}]]}], "-", 
   RowBox[{
    SuperscriptBox["c", "2"], " ", 
    SubsuperscriptBox["q", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "t"}], "2"]}], "-", 
   RowBox[{
    SuperscriptBox["c", "2"], " ", 
    SubscriptBox["q", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "t"}]], " ", 
    SubscriptBox["q", "t"]}], "+", 
   RowBox[{
    SuperscriptBox["c", "2"], " ", 
    SubscriptBox["q", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "t"}]], " ", 
    SubscriptBox["q", "t"]}], "-", 
   RowBox[{"c", " ", 
    SubscriptBox["q", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "t"}]], " ", 
    SubscriptBox["u", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "t"}]]}], "+", 
   RowBox[{"c", " ", 
    SubscriptBox["q", "t"], " ", 
    SubscriptBox["u", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "t"}]]}], "-", 
   RowBox[{"c", " ", 
    SubscriptBox["q", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "t"}]], " ", 
    SubscriptBox["u", "t"]}], "+", 
   RowBox[{"c", " ", 
    SubscriptBox["q", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "t"}]], " ", 
    SubscriptBox["u", "t"]}], "+", 
   RowBox[{
    SubscriptBox["u", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "t"}]], " ", 
    SubscriptBox["u", "t"]}]}], "]"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522819564*^9, 3.3895615258704*^9, 3.3895616667768*^9,
   3.3899894653192*^9, 3.3899901646366*^9, 3.3899903567836*^9, 
  3.3899911794996*^9, 3.3907337229306*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[ScriptCapitalE]", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[CapitalDelta]p", "t"], 
       SubscriptBox["\[CapitalDelta]p", 
        RowBox[{"t", "-", "1"}]]}], "/.", 
      SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}], "]"}], "//.", 
   SubscriptBox["\[ScriptCapitalE]", "Rules"]}], "//", 
  "FullSimplify"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3899903352766*^9, 3.3899903378986*^9}, 
   3.3899904656326*^9, 3.3899910832785997`*^9}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["c", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"2", " ", "\[Rho]"}]}], ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522824424*^9, 3.3895615259904003`*^9, 
  3.3895616668648*^9, 3.3899894658772*^9, 3.3899901650336*^9, 
  3.3899903581956*^9, 3.3899904665046*^9, 3.3899911796776*^9, 
  3.3907337236466*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[ScriptCapitalE]", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[CapitalDelta]p", "t"], 
       SubscriptBox["\[CapitalDelta]p", 
        RowBox[{"t", "-", "2"}]]}], "/.", 
      SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}], "]"}], "//.", 
   SubscriptBox["\[ScriptCapitalE]", "Rules"]}], "//", "Simplify"}]], "Input",\

 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3899903416036*^9, 3.3899904723096*^9, 3.3899910878456*^9}
  ],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SuperscriptBox["c", "2"]}], " ", "\[Rho]"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522825234003`*^9, 3.3895615260344*^9, 
  3.3895616668968*^9, 3.3899894659382*^9, 3.3899901651286*^9, 
  3.3899903582886*^9, 3.3899904727706003`*^9, 3.3899911797306004`*^9, 
  3.3907337237276*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[ScriptCapitalE]", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[CapitalDelta]p", "t"], 
       SubscriptBox["\[CapitalDelta]p", 
        RowBox[{"t", "-", "3"}]]}], "/.", 
      SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}], "]"}], "//.", 
   SubscriptBox["\[ScriptCapitalE]", "Rules"]}], "//", "Simplify"}]], "Input",\

 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3899903460906*^9, 3.3899904841786003`*^9, 
  3.3899910929026003`*^9}],

Cell[BoxData["0"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522825584*^9, 3.3895615260704*^9, 3.3895616669288*^9, 
   3.3899894660332003`*^9, 3.3899901652236*^9, 3.3899903583716*^9, {
   3.3899904782866*^9, 3.3899904855536003`*^9}, 3.3899911797846003`*^9, 
   3.3907337237806*^9}]
}, Open  ]],

Cell[TextData[{
 "Verify that ",
 Cell[BoxData[
  RowBox[{
   SqrtBox[
    RowBox[{
     RowBox[{"-", "Cov"}], 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[CapitalDelta]p", "t"], ",", 
       SubscriptBox["\[CapitalDelta]p", 
        RowBox[{"t", "-", "1"}]]}], ")"}]}]], "<", "c"}]]],
 ":"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    SqrtBox[
     RowBox[{
      RowBox[{"-", 
       RowBox[{"\[ScriptCapitalE]", "[", 
        RowBox[{"Expand", "[", 
         RowBox[{
          RowBox[{
           SubscriptBox["\[CapitalDelta]p", "t"], 
           SubscriptBox["\[CapitalDelta]p", 
            RowBox[{"t", "-", "1"}]]}], "/.", 
          SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}], "]"}]}], "//.", 
      SubscriptBox["\[ScriptCapitalE]", "Rules"]}]], "<", "c"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"0", "<", "\[Rho]", "<", 
       RowBox[{"1", "/", "2"}]}], ",", 
      RowBox[{"c", ">", "0"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3899905112976*^9, 3.3899905123076*^9}, 
   3.3899910983536*^9}],

Cell[BoxData["True"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522827244*^9, 3.3895615261284*^9, 3.3895616669788*^9,
   3.3899894661252003`*^9, 3.3899901653656*^9, 3.3899903584656*^9, 
  3.3899905134955997`*^9, 3.3899911798716*^9, 3.3907337239716*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4.3", "Subsection",
 CellLabelAutoDelete->True,
 CellTags->"Ch4ExCorrup"],

Cell["Model:", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["m", "Rule"], "=", 
   RowBox[{
    SubscriptBox["m", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", 
      RowBox[{"t", "-", "1"}]], "+", 
     SubscriptBox["u", "t"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["p", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", "t"], "+", 
     RowBox[{"c", " ", 
      SubscriptBox["q", "t"]}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["\[CapitalDelta]p", "t_"], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["p", "t"], "/.", "\[InvisibleSpace]", 
        SubscriptBox["p", "Rule"]}], "/.", "\[InvisibleSpace]", 
       SubscriptBox["m", "Rule"]}], ")"}], "-", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["p", 
        RowBox[{"t", "-", "1"}]], "/.", "\[InvisibleSpace]", 
       SubscriptBox["p", "Rule"]}], ")"}]}]}]}], ";"}], "\n", 
 RowBox[{
  SubscriptBox["\[CapitalDelta]p", "t"], "/.", 
  SubscriptBox["\[CapitalDelta]p", "Rule"]}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "c"}], " ", 
   SubscriptBox["q", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "t"}]]}], "+", 
  RowBox[{"c", " ", 
   SubscriptBox["q", "t"]}], "+", 
  SubscriptBox["u", "t"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522827574*^9, 3.3895615261644*^9, 3.3895616670128*^9,
   3.3899894661832*^9, 3.3899901654496*^9, 3.3899905766886*^9, 
  3.3899911799916*^9, 3.3907337240346003`*^9}]
}, Open  ]],

Cell["Modified expectations rules:", "Text",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3899895121082*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[ScriptCapitalE]Alternate", "Rules"], "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       SubsuperscriptBox["q", "_", "2"], "]"}], "\[Rule]", "1"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       SubsuperscriptBox["u", "_", "2"], "]"}], "\[Rule]", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{
        SubscriptBox["q", "s_"], 
        SubscriptBox["u", "t_"]}], "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{"\[Rho]", " ", 
        SubscriptBox["\[Sigma]", "u"]}], "/;", 
       RowBox[{"t", "\[Equal]", "s"}]}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{
        SubscriptBox["q", "s_"], 
        SubscriptBox["u", "t_"]}], "]"}], "\[RuleDelayed]", 
      RowBox[{"0", "/;", 
       RowBox[{"t", "=!=", "s"}]}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{
        SubscriptBox["q", "t_"], 
        SubscriptBox["q", "s_"]}], "]"}], "\[RuleDelayed]", " ", 
      RowBox[{"0", "/;", 
       RowBox[{"t", "=!=", "s"}]}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{
        SubscriptBox["u", "t_"], 
        SubscriptBox["u", "s_"]}], "]"}], "\[RuleDelayed]", " ", 
      RowBox[{"0", "/;", 
       RowBox[{"t", "=!=", "s"}]}]}]}], "}"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3899895121092*^9, {3.3899905251466*^9, 3.3899905449616003`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[ScriptCapitalE]", "Rules"], "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     SubscriptBox["\[ScriptCapitalE]Alternate", "Rules"], ",", 
     SubscriptBox["\[ScriptCapitalE]Linearity", "Rules"]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.3899910600936003`*^9, 3.3899910656446*^9}},
 CellLabel->"In[72]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[ScriptCapitalE]", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{
      SubsuperscriptBox["\[CapitalDelta]p", "t", "2"], "/.", 
      SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}], "]"}], "//.", 
   SubscriptBox["\[ScriptCapitalE]", "Rules"]}], "//", 
  "FullSimplify"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3899905592366*^9, 3.3899911136786003`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SuperscriptBox["c", "2"]}], "+", 
  SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
  RowBox[{"2", " ", "c", " ", "\[Rho]", " ", 
   SubscriptBox["\[Sigma]", "u"]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522828554*^9, 3.3895615262614*^9, 
  3.3895616671168003`*^9, 3.3899894663361998`*^9, 3.3899901656686*^9, 
  3.3899905768266*^9, 3.3899911801186*^9, 3.3907337241706*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[ScriptCapitalE]", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[CapitalDelta]p", "t"], 
       SubscriptBox["\[CapitalDelta]p", 
        RowBox[{"t", "-", "1"}]]}], "/.", 
      SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}], "]"}], "//.", 
   SubscriptBox["\[ScriptCapitalE]", "Rules"]}], "//", "Simplify"}]], "Input",\

 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3899905626576*^9, 3.3899911187986*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "c"}], " ", 
  RowBox[{"(", 
   RowBox[{"c", "+", 
    RowBox[{"\[Rho]", " ", 
     SubscriptBox["\[Sigma]", "u"]}]}], ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522828894*^9, 3.3895615262964*^9, 3.3895616671468*^9,
   3.3899894663932*^9, 3.3899901657566*^9, 3.3899905768956003`*^9, 
  3.3899911801826*^9, 3.3907337242206*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[ScriptCapitalE]", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[CapitalDelta]p", "t"], 
       SubscriptBox["\[CapitalDelta]p", 
        RowBox[{"t", "-", "2"}]]}], "/.", 
      SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}], "]"}], "//.", 
   SubscriptBox["\[ScriptCapitalE]", "Rules"]}], "//", "Simplify"}]], "Input",\

 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3899905659606*^9, 3.3899911286015997`*^9}],

Cell[BoxData["0"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522829244003`*^9, 3.3895615263324003`*^9, 
  3.3895616671788*^9, 3.3899894664452*^9, 3.3899901658366003`*^9, 
  3.3899905769616003`*^9, 3.3899911802386*^9, 3.3907337242726*^9}]
}, Open  ]],

Cell[TextData[{
 "Verify that ",
 Cell[BoxData[
  RowBox[{
   SqrtBox[
    RowBox[{
     RowBox[{"-", "Cov"}], 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[CapitalDelta]p", "t"], ",", 
       SubscriptBox["\[CapitalDelta]p", 
        RowBox[{"t", "-", "1"}]]}], ")"}]}]], ">", "c"}]]],
 ":"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    SqrtBox[
     RowBox[{
      RowBox[{"-", 
       RowBox[{"\[ScriptCapitalE]", "[", 
        RowBox[{"Expand", "[", 
         RowBox[{
          RowBox[{
           SubscriptBox["\[CapitalDelta]p", "t"], 
           SubscriptBox["\[CapitalDelta]p", 
            RowBox[{"t", "-", "1"}]]}], "/.", 
          SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}], "]"}]}], "//.", 
      SubscriptBox["\[ScriptCapitalE]", "Rules"]}]], ">", "c"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"0", "<", "\[Rho]"}], ",", 
      RowBox[{
       SubscriptBox["\[Sigma]", "u"], ">", "0"}], ",", 
      RowBox[{"c", ">", "0"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3899905693866*^9, 3.3899911348306*^9}],

Cell[BoxData["True"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522830034*^9, 3.3895615263943996`*^9, 
  3.3895616672298*^9, 3.3899894665341997`*^9, 3.3899901659566*^9, 
  3.3899905796716003`*^9, 3.3899911803596*^9, 3.3907337243926*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Generalized Roll Model (Chapter 8)", "Section",
 CellLabelAutoDelete->True],

Cell["Assign 'constant' property to model parameters.", "Text",
 CellLabelAutoDelete->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Attributes", "[", "c", "]"}], "=", 
   RowBox[{"{", "Constant", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Attributes", "[", "\[Lambda]", "]"}], "=", 
   RowBox[{"{", "Constant", "}"}]}], ";"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell["Structural model", "Subsection",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["m", "Rule"], "=", 
   RowBox[{
    SubscriptBox["m", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", 
      RowBox[{"t", "-", "1"}]], "+", 
     SubscriptBox["w", "t"]}]}]}], ";", " ", 
  RowBox[{
   SubscriptBox["w", "Rule"], "=", 
   RowBox[{
    SubscriptBox["w", "t_"], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"\[Lambda]", " ", 
      SubscriptBox["q", "t"]}], "+", 
     SubscriptBox["u", "t"]}]}]}], ";", " ", 
  RowBox[{
   SubscriptBox["p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["p", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", "t"], "+", 
     RowBox[{"c", " ", 
      SubscriptBox["q", "t"]}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"TableForm", " ", "@", " ", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["m", "Rule"], ",", " ", 
    SubscriptBox["w", "Rule"], ",", 
    SubscriptBox["p", "Rule"]}], "}"}]}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{
       SubscriptBox["m", "t_"], "\[RuleDelayed]", 
       RowBox[{
        SubscriptBox["m", 
         RowBox[{"t", "-", "1"}]], "+", 
        SubscriptBox["w", "t"]}]}]},
     {
      RowBox[{
       SubscriptBox["w", "t_"], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"\[Lambda]", " ", 
         SubscriptBox["q", "t"]}], "+", 
        SubscriptBox["u", "t"]}]}]},
     {
      RowBox[{
       SubscriptBox["p", "t_"], "\[RuleDelayed]", 
       RowBox[{
        SubscriptBox["m", "t"], "+", 
        RowBox[{"c", " ", 
         SubscriptBox["q", "t"]}]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522830434*^9, 3.3895616672698*^9, 3.3899894666042*^9,
   3.3899907235056*^9, 3.3899908071856003`*^9, 3.3899911804336*^9, 
  3.3907337244606*^9}]
}, Open  ]],

Cell["The bid and ask are:", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["p", "t"], "/.", "\[InvisibleSpace]", 
      SubscriptBox["p", "Rule"]}], "/.", "\[InvisibleSpace]", 
     SubscriptBox["m", "Rule"]}], "/.", "\[InvisibleSpace]", 
    SubscriptBox["w", "Rule"]}], "/.", "\[InvisibleSpace]", 
   RowBox[{
    SubscriptBox["q", "t"], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "//", "TableForm"}]], "Input",\

 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{
       RowBox[{"-", "c"}], "-", "\[Lambda]", "+", 
       SubscriptBox["m", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "t"}]], "+", 
       SubscriptBox["u", "t"]}]},
     {
      RowBox[{"c", "+", "\[Lambda]", "+", 
       SubscriptBox["m", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "t"}]], "+", 
       SubscriptBox["u", "t"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522830854*^9, 3.3895616673048*^9, 3.3899894666542*^9,
   3.3899907235766*^9, 3.3899908072525997`*^9, 3.3899911804955997`*^9, 
  3.3907337245146*^9}]
}, Open  ]],

Cell[TextData[{
 "(The spread is  ",
 Cell[BoxData[
  RowBox[{"2", 
   RowBox[{"(", 
    RowBox[{"c", "+", "\[Lambda]"}], ")"}]}]]],
 ".)  The price change:"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["\[CapitalDelta]p", "t_"], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         SubscriptBox["p", "t"], "/.", "\[InvisibleSpace]", 
         SubscriptBox["p", "Rule"]}], "/.", "\[InvisibleSpace]", 
        SubscriptBox["m", "Rule"]}], "/.", "\[InvisibleSpace]", 
       SubscriptBox["w", "Rule"]}], ")"}], "-", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["p", 
        RowBox[{"t", "-", "1"}]], "/.", "\[InvisibleSpace]", 
       SubscriptBox["p", "Rule"]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["\[CapitalDelta]p", "t"], "/.", 
  SubscriptBox["\[CapitalDelta]p", "Rule"]}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "c"}], " ", 
   SubscriptBox["q", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "t"}]]}], "+", 
  RowBox[{"c", " ", 
   SubscriptBox["q", "t"]}], "+", 
  RowBox[{"\[Lambda]", " ", 
   SubscriptBox["q", "t"]}], "+", 
  SubscriptBox["u", "t"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522831214*^9, 3.3895616673398*^9, 
  3.3899894667061996`*^9, 3.3899907236406*^9, 3.3899908073136*^9, 
  3.3899911805506*^9, 3.3907337245676003`*^9}]
}, Open  ]],

Cell[TextData[{
 "Autocovariances: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Var", "[", 
    RowBox[{"\[CapitalDelta]", " ", 
     SubscriptBox["p", "t"]}], "]"}], "=", 
   SubscriptBox["\[Gamma]", "0"]}]]],
 ":"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[ScriptCapitalE]", "[", 
  RowBox[{"Expand", "[", 
   RowBox[{
    SubsuperscriptBox["\[CapitalDelta]p", "t", "2"], "/.", 
    "\[InvisibleSpace]", 
    SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"\[ScriptCapitalE]", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["c", "2"], " ", 
    SubsuperscriptBox["q", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "t"}], "2"]}], "-", 
   RowBox[{"2", " ", 
    SuperscriptBox["c", "2"], " ", 
    SubscriptBox["q", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "t"}]], " ", 
    SubscriptBox["q", "t"]}], "-", 
   RowBox[{"2", " ", "c", " ", "\[Lambda]", " ", 
    SubscriptBox["q", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "t"}]], " ", 
    SubscriptBox["q", "t"]}], "+", 
   RowBox[{
    SuperscriptBox["c", "2"], " ", 
    SubsuperscriptBox["q", "t", "2"]}], "+", 
   RowBox[{"2", " ", "c", " ", "\[Lambda]", " ", 
    SubsuperscriptBox["q", "t", "2"]}], "+", 
   RowBox[{
    SuperscriptBox["\[Lambda]", "2"], " ", 
    SubsuperscriptBox["q", "t", "2"]}], "-", 
   RowBox[{"2", " ", "c", " ", 
    SubscriptBox["q", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "t"}]], " ", 
    SubscriptBox["u", "t"]}], "+", 
   RowBox[{"2", " ", "c", " ", 
    SubscriptBox["q", "t"], " ", 
    SubscriptBox["u", "t"]}], "+", 
   RowBox[{"2", " ", "\[Lambda]", " ", 
    SubscriptBox["q", "t"], " ", 
    SubscriptBox["u", "t"]}], "+", 
   SubsuperscriptBox["u", "t", "2"]}], "]"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522831574*^9, 3.3895616673778*^9, 
  3.3899894667622004`*^9, 3.3899907237276*^9, 3.3899908073806*^9, 
  3.3899911806126003`*^9, 3.3907337246176*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[ScriptCapitalE]", "Rules"], "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     SubscriptBox["\[ScriptCapitalE]Roll", "Rules"], ",", 
     SubscriptBox["\[ScriptCapitalE]Linearity", "Rules"]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.3899906828856*^9, 3.3899906918396*^9}, {
  3.3899907730306*^9, 3.3899908007316*^9}},
 CellLabel->"In[85]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ScriptCapitalE]", "[", 
   RowBox[{"Expand", "[", 
    RowBox[{
     SubsuperscriptBox["\[CapitalDelta]p", "t", "2"], "/.", 
     "\[InvisibleSpace]", 
     SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}], "]"}], "//.", 
  SubscriptBox["\[ScriptCapitalE]", "Rules"]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3899906680526*^9, 3.3899906994926*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SuperscriptBox["c", "2"]}], "+", 
  RowBox[{"2", " ", "c", " ", "\[Lambda]"}], "+", 
  SuperscriptBox["\[Lambda]", "2"], "+", 
  SubsuperscriptBox["\[Sigma]", "u", "2"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522832304*^9, 3.3895616674428*^9, 
  3.3899894668691998`*^9, 3.3899907240156*^9, 3.3899908075326*^9, 
  3.3899911806826*^9, 3.3907337246865997`*^9}]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"Cov", "[", 
    RowBox[{
     SubscriptBox["\[CapitalDelta]p", "t"], ",", 
     SubscriptBox["\[CapitalDelta]p", 
      RowBox[{"t", "-", "1"}]]}], "]"}], "=", 
   SubscriptBox["\[Gamma]", "1"]}]]],
 ":"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ScriptCapitalE]", "[", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[CapitalDelta]p", "t"], " ", 
      SubscriptBox["\[CapitalDelta]p", 
       RowBox[{"t", "-", "1"}]]}], "/.", "\[InvisibleSpace]", 
     SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}], "]"}], "//.", 
  SubscriptBox["\[ScriptCapitalE]", "Rules"]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3899906720676003`*^9, 3.3899907036926003`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SuperscriptBox["c", "2"]}], "-", 
  RowBox[{"c", " ", "\[Lambda]"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522832674*^9, 3.3895616674758*^9, 3.3899894669252*^9,
   3.3899907241326*^9, 3.3899908076266003`*^9, 3.3899911807455997`*^9, 
  3.3907337247396*^9}]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"Cov", "[", 
    RowBox[{
     SubscriptBox["\[CapitalDelta]p", "t"], ",", 
     SubscriptBox["\[CapitalDelta]p", 
      RowBox[{"t", "-", "2"}]]}], "]"}], "=", 
   SubscriptBox["\[Gamma]", "2"]}]]],
 ":"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ScriptCapitalE]", "[", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[CapitalDelta]p", "t"], " ", 
      SubscriptBox["\[CapitalDelta]p", 
       RowBox[{"t", "-", "2"}]]}], "/.", "\[InvisibleSpace]", 
     SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}], "]"}], "//.", 
  SubscriptBox["\[ScriptCapitalE]", "Rules"]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3899906757466*^9, 3.3899907082916*^9}],

Cell[BoxData["0"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522833084*^9, 3.3895616675098*^9, 3.3899894669852*^9,
   3.3899907242406*^9, 3.3899908077125998`*^9, 3.3899911808066*^9, 
  3.3907337247925997`*^9}]
}, Open  ]],

Cell["\<\
Summarize the first two autocovariances in terms of the structural \
parameters:\
\>", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Gamma]Structural", "Rules"], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Gamma]", "0"], "\[Rule]", 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["c", "2"]}], "+", 
       RowBox[{"2", " ", "c", " ", "\[Lambda]"}], "+", 
       SuperscriptBox["\[Lambda]", "2"], "+", 
       SubsuperscriptBox["\[Sigma]", "u", "2"]}]}], ",", 
     RowBox[{
      SubscriptBox["\[Gamma]", "1"], "\[Rule]", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["c", "2"]}], "-", 
       RowBox[{"c", " ", "\[Lambda]"}]}]}]}], "}"}]}], ";", " ", 
  RowBox[{
   SubscriptBox["\[Gamma]Structural", "Rules"], "//", 
   "TableForm"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{
       SubscriptBox["\[Gamma]", "0"], "\[Rule]", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", "c", " ", "\[Lambda]"}], "+", 
        SuperscriptBox["\[Lambda]", "2"], "+", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}]}]},
     {
      RowBox[{
       SubscriptBox["\[Gamma]", "1"], "\[Rule]", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"c", " ", "\[Lambda]"}]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522833424*^9, 3.3895616675458*^9, 
  3.3899894670671997`*^9, 3.3899907243526*^9, 3.3899908077966003`*^9, 
  3.3899911809666*^9, 3.3907337248546*^9}]
}, Open  ]],

Cell[TextData[{
 "Two ",
 Cell[BoxData["\[Gamma]"], "Output"],
 "s don't suffice to identify ",
 Cell[BoxData[
  RowBox[{"c", ",", " ", "\[Lambda]", ",", " ", 
   SubsuperscriptBox["\[Sigma]", "u", "2"]}]]],
 ". "
}], "Text",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3899907441486*^9, 3.3899907487406*^9}}],

Cell["\<\
Special case. If \[Lambda]=0 (all public info), this reduces to the original \
Roll model.\
\>", "Text",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "Special case. If ",
 Cell[BoxData[
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "u", "2"], "=", "0"}]]],
 ", there is no public information; only private information."
}], "Text",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "Now evaluate ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Var", "[", 
    SubscriptBox["w", "t"], "]"}], "=", 
   SubsuperscriptBox["\[Sigma]", "w", "2"]}]]],
 ":"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ScriptCapitalE]", "[", 
   RowBox[{"Expand", "[", 
    RowBox[{
     SubsuperscriptBox["w", "t", "2"], "/.", "\[InvisibleSpace]", 
     SubscriptBox["w", "Rule"]}], "]"}], "]"}], "//.", 
  SubscriptBox["\[ScriptCapitalE]", "Rules"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[Lambda]", "2"], "+", 
  SubsuperscriptBox["\[Sigma]", "u", "2"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522833794003`*^9, 3.3895616675797997`*^9, 
  3.3899894671342*^9, 3.3899907244466*^9, 3.3899908078806*^9, 
  3.3899911810486*^9, 3.3907337249035997`*^9}]
}, Open  ]],

Cell["Compare with:", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SubscriptBox["\[Gamma]", "0"], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["\[Gamma]", "1"]}]}], "/.", 
   SubscriptBox["\[Gamma]Structural", "Rules"]}], "//", "Simplify"}]], "Input",\

 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[Lambda]", "2"], "+", 
  SubsuperscriptBox["\[Sigma]", "u", "2"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522834184*^9, 3.3895616676148*^9, 
  3.3899894671842003`*^9, 3.3899907245126*^9, 3.3899908079386*^9, 
  3.3899911811306*^9, 3.3907337249526*^9}]
}, Open  ]],

Cell["(Variance ratios.)", "Text",
 CellLabelAutoDelete->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Forecasting using structural and statistical representations", \
"Subsection",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "Analyze ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["f", "t"], "\[Congruent]", 
    RowBox[{
     UnderscriptBox["lim", 
      RowBox[{"k", "\[Rule]", "\[Infinity]"}]], " ", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[ScriptCapitalE]", "*"], "[", 
       RowBox[{
        RowBox[{
         SubscriptBox["p", 
          RowBox[{"t", "+", "k"}]], "|", 
         SubscriptBox["p", "t"]}], ",", " ", "..."}], "]"}], 
      RowBox[{"(", "show", ")"}]}]}]}], "=", 
   RowBox[{
    SuperscriptBox["\[ScriptCapitalE]", "*"], "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["m", "t"], "|", 
      SubscriptBox["p", "t"]}], ",", "..."}], "]"}], " "}]]],
 Cell[BoxData[
  RowBox[{"=", 
   RowBox[{
    SubscriptBox["p", "t"], "-", 
    RowBox[{
     SuperscriptBox["c\[ScriptCapitalE]", "*"], "[", 
     RowBox[{
      RowBox[{
       SubscriptBox["q", "t"], "|", 
       SubscriptBox["p", "t"]}], ",", "..."}], "]"}]}]}]]],
 "\nAnalyze  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["\[ScriptCapitalE]", "*"], "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["q", "t"], "|", 
      SubscriptBox["p", "t"]}], ",", "..."}], "]"}], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[Beta]", "0"], "+", 
       RowBox[{
        SubscriptBox["\[Beta]", "1"], "L"}], "+", 
       RowBox[{
        SubscriptBox["\[Beta]", "2"], 
        SuperscriptBox["L", "2"]}], "+"}], "..."}], ")"}], 
    SubscriptBox["\[Epsilon]", "t"]}]}]]],
 ".\nIn the projection ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Beta]", "k"], "=", 
   FractionBox[
    RowBox[{"Cov", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[Epsilon]", 
        RowBox[{"t", "-", "k"}]], ",", 
       SubscriptBox["q", "t"]}], ")"}]}], 
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]]}]]]
}], "Text",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "To compute ",
 Cell[BoxData[
  RowBox[{"Cov", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Epsilon]", 
      RowBox[{"t", "-", "k"}]], ",", 
     SubscriptBox["q", "t"]}], ")"}]}]]],
 ", note that the statistical representation for ",
 Cell[BoxData[
  SubscriptBox["\[CapitalDelta]p", "t"]]],
 " is\n ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "t"], "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Epsilon]", "t"], "+", 
     SubscriptBox["\[Theta]\[Epsilon]", 
      RowBox[{"t", "-", "1"}]]}], "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Theta]L"}], ")"}], 
     SubscriptBox["\[Epsilon]", "t"]}]}]}]]],
 "; \n the structural representation for ",
 Cell[BoxData[
  SubscriptBox["\[CapitalDelta]p", "t"]]],
 " is ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "t"], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c", 
        RowBox[{"(", 
         RowBox[{"1", "-", "L"}], ")"}]}], "+", "\[Lambda]"}], ")"}], 
     SubscriptBox["q", "t"]}], "+", 
    SubscriptBox["u", "t"]}]}]]],
 "."
}], "Text",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "Equating the structural and statistical representations:\n",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "\[Theta]L"}], ")"}], 
   SubscriptBox["\[Epsilon]", "t"]}]]],
 Cell[BoxData[
  RowBox[{"=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c", 
        RowBox[{"(", 
         RowBox[{"1", "-", "L"}], ")"}]}], "+", "\[Lambda]"}], ")"}], 
     SubscriptBox["q", "t"]}], "+", 
    SubscriptBox["u", "t"]}]}]]],
 ", or\n",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Epsilon]", "t"], "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "\[Theta]L"}], ")"}], 
      RowBox[{"-", "1"}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c", 
        RowBox[{"(", 
         RowBox[{"1", "-", "L"}], ")"}]}], "+", "\[Lambda]"}], ")"}], 
     SubscriptBox["q", "t"]}], "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "\[Theta]L"}], ")"}], 
      RowBox[{"-", "1"}]], 
     SubscriptBox["u", "t"]}]}]}]]],
 "\nThat is,  ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Epsilon]", "t"], "=", 
   RowBox[{
    RowBox[{"A", 
     RowBox[{"(", "L", ")"}], 
     SubscriptBox["q", "t"]}], "+", 
    RowBox[{"B", 
     RowBox[{"(", "L", ")"}], 
     SubscriptBox["u", "t"]}]}]}]]],
 " where (expanding through the fifth term) ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"A", 
    RowBox[{"(", "L", ")"}]}], "="}]]]
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"\[Theta]", " ", "L"}]}], ")"}], 
      RowBox[{"-", "1"}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c", 
        RowBox[{"(", 
         RowBox[{"1", "-", "L"}], ")"}]}], "+", "\[Lambda]"}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"L", ",", "0", ",", "5"}], "}"}]}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"c", "+", "\[Lambda]"}], ")"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "c"}], "-", 
      RowBox[{"c", " ", "\[Theta]"}], "-", 
      RowBox[{"\[Theta]", " ", "\[Lambda]"}]}], ")"}], " ", "L"}], "+", 
   RowBox[{"\[Theta]", " ", 
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"c", " ", "\[Theta]"}], "+", 
      RowBox[{"\[Theta]", " ", "\[Lambda]"}]}], ")"}], " ", 
    SuperscriptBox["L", "2"]}], "-", 
   RowBox[{
    SuperscriptBox["\[Theta]", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"c", " ", "\[Theta]"}], "+", 
      RowBox[{"\[Theta]", " ", "\[Lambda]"}]}], ")"}], " ", 
    SuperscriptBox["L", "3"]}], "+", 
   RowBox[{
    SuperscriptBox["\[Theta]", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"c", " ", "\[Theta]"}], "+", 
      RowBox[{"\[Theta]", " ", "\[Lambda]"}]}], ")"}], " ", 
    SuperscriptBox["L", "4"]}], "-", 
   RowBox[{
    SuperscriptBox["\[Theta]", "4"], " ", 
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"c", " ", "\[Theta]"}], "+", 
      RowBox[{"\[Theta]", " ", "\[Lambda]"}]}], ")"}], " ", 
    SuperscriptBox["L", "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "L", "]"}], "6"],
    SeriesData[$CellContext`L, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`L, 
   0, {$CellContext`c + $CellContext`\[Lambda], -$CellContext`c - \
$CellContext`c $CellContext`\[Theta] - $CellContext`\[Theta] $CellContext`\
\[Lambda], $CellContext`\[Theta] ($CellContext`c + $CellContext`c \
$CellContext`\[Theta] + $CellContext`\[Theta] $CellContext`\[Lambda]), \
-$CellContext`\[Theta]^2 ($CellContext`c + $CellContext`c $CellContext`\
\[Theta] + $CellContext`\[Theta] $CellContext`\[Lambda]), $CellContext`\
\[Theta]^3 ($CellContext`c + $CellContext`c $CellContext`\[Theta] + \
$CellContext`\[Theta] $CellContext`\[Lambda]), -$CellContext`\[Theta]^4 \
($CellContext`c + $CellContext`c $CellContext`\[Theta] + \
$CellContext`\[Theta] $CellContext`\[Lambda])}, 0, 6, 1],
  Editable->False]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522834653997`*^9, 3.3895616676728*^9, 
  3.3899894672612*^9, 3.3899911812386*^9, 3.3907337250416*^9}]
}, Open  ]],

Cell[TextData[{
 "i.e., ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Cov", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["\[Epsilon]", 
       RowBox[{"t", "-", "k"}]], ",", 
      SubscriptBox["q", "t"]}], ")"}]}], "=", 
   RowBox[{
    RowBox[{"Cov", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           SubscriptBox["A", "0"], 
           SubscriptBox["q", 
            RowBox[{"t", "-", "k"}]]}], "+", 
          RowBox[{
           SubscriptBox["A", "1"], 
           SubscriptBox["q", 
            RowBox[{"t", "-", "k", "-", "1"}]]}], "+"}], "..."}], "+", 
        RowBox[{"B", 
         RowBox[{"(", "L", ")"}], 
         SubscriptBox["u", "t"]}]}], ",", " ", 
       SubscriptBox["q", "t"]}], ")"}]}], "=", 
    RowBox[{"{", GridBox[{
       {
        RowBox[{
         RowBox[{"c", "+", "\[Lambda]"}], ",", " ", 
         RowBox[{
          RowBox[{"if", " ", "k"}], "=", "0", " "}]}]},
       {
        RowBox[{"0", ",", " ", "otherwise"}]}
      }]}]}]}]]],
 "\nTherefore, ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Beta]", "0"], "=", 
   FractionBox[
    RowBox[{"c", "+", "\[Lambda]"}], 
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]]}]]],
 " and ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Beta]", "k"], "=", 
   RowBox[{"0", " ", 
    RowBox[{"\[ForAll]", 
     RowBox[{"k", ">", "0"}]}]}]}]]],
 " and ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["f", "t"], "=", 
   RowBox[{
    SubscriptBox["p", "t"], "-", 
    RowBox[{
     FractionBox[
      RowBox[{"c", 
       RowBox[{"(", 
        RowBox[{"c", "+", "\[Lambda]"}], ")"}], " "}], 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]], 
     SubscriptBox["\[Epsilon]", "t"]}]}]}]]]
}], "Text",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "Does this equal the same forecast we'd compute from the statistical \
representation, ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["f", "t"], "=", 
   RowBox[{
    SubscriptBox["p", "t"], "+", 
    SubscriptBox["\[Theta]\[Epsilon]", "t"]}]}]]],
 "?\nDetermine ",
 Cell[BoxData["\[Theta]"]],
 " in terms of the structural parameters."
}], "Text",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "The autocovariances computed from the statistical and structural \
representations must agree. The autocovariances for the MA(1) process ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "t"], "=", 
   RowBox[{
    SubscriptBox["\[Epsilon]", "t"], "+", 
    SubscriptBox["\[Theta]\[Epsilon]", 
     RowBox[{"t", "-", "1"}]]}]}]]],
 " are:"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Gamma]Statistical", "Rules"], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Gamma]", "0"], "\[Rule]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["\[Theta]", "2"], "+", "1"}], ")"}], " ", 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}], ",", 
     RowBox[{
      SubscriptBox["\[Gamma]", "1"], "\[Rule]", 
      RowBox[{"\[Theta]", " ", 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]}], "}"}]}], ";", 
  " ", 
  RowBox[{
   SubscriptBox["\[Gamma]Statistical", "Rules"], "//", 
   "TableForm"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{
       SubscriptBox["\[Gamma]", "0"], "\[Rule]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["\[Theta]", "2"]}], ")"}], " ", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]},
     {
      RowBox[{
       SubscriptBox["\[Gamma]", "1"], "\[Rule]", 
       RowBox[{"\[Theta]", " ", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522835184*^9, 3.3895616677118*^9, 3.3899894673222*^9,
   3.3899911813286*^9, 3.3907337251136*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StatStructEqu", "=", 
   RowBox[{"Apply", "[", 
    RowBox[{"Equal", ",", 
     RowBox[{"Join", "[", 
      RowBox[{
       SubscriptBox["\[Gamma]Statistical", "Rules"], ",", 
       SubscriptBox["\[Gamma]Structural", "Rules"]}], "]"}], ",", 
     RowBox[{"{", "1", "}"}]}], "]"}]}], ";", " ", 
  RowBox[{"StatStructEqu", "//", "TableForm"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{
       SubscriptBox["\[Gamma]", "0"], "\[Equal]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["\[Theta]", "2"]}], ")"}], " ", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]},
     {
      RowBox[{
       SubscriptBox["\[Gamma]", "1"], "\[Equal]", 
       RowBox[{"\[Theta]", " ", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]},
     {
      RowBox[{
       SubscriptBox["\[Gamma]", "0"], "\[Equal]", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", "c", " ", "\[Lambda]"}], "+", 
        SuperscriptBox["\[Lambda]", "2"], "+", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}]}]},
     {
      RowBox[{
       SubscriptBox["\[Gamma]", "1"], "\[Equal]", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"c", " ", "\[Lambda]"}]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522835564003`*^9, 3.3895616677448*^9, 
  3.3899894673712*^9, 3.3899911814196*^9, 3.3907337251686*^9}]
}, Open  ]],

Cell["which implies:", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"Eliminate", "[", 
    RowBox[{"StatStructEqu", ",", 
     RowBox[{"{", 
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "u", "2"], ",", 
       SubscriptBox["\[Gamma]", "0"], ",", 
       SubscriptBox["\[Gamma]", "1"]}], "}"}]}], "]"}], ",", "\[Theta]"}], 
  "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\[Theta]", "\[Rule]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"c", " ", 
       RowBox[{"(", 
        RowBox[{"c", "+", "\[Lambda]"}], ")"}]}], 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]]}]}], "}"}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522838644*^9, 3.3895616678278*^9, 3.3899894674322*^9,
   3.3899911815116*^9, 3.3907337252586*^9}]
}, Open  ]],

Cell[TextData[{
 "i.e., the coefficient of ",
 Cell[BoxData[
  SubscriptBox["\[Epsilon]", "t"]]],
 " is the same in both representations.\nSpecial case: If ",
 Cell[BoxData[
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "u", "2"], "=", "0"}]]],
 " (no public information) ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["f", "t"], "=", 
   RowBox[{
    SubscriptBox["m", "t"], Cell[""]}]}]]],
 "."
}], "Text",
 CellLabelAutoDelete->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "The pricing error: How closely does ",
 Cell[BoxData[
  SubscriptBox["p", "t"]]],
 " track ",
 Cell[BoxData[
  SubscriptBox["m", "t"]]],
 "?"
}], "Subsection",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "The structural model implies ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["s", "t"], "=", 
   RowBox[{
    SubscriptBox["q", "t"], " ", "c"}]}]]],
 ", so ",
 Cell[BoxData[
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "s", "2"], "=", 
   SuperscriptBox["c", "2"]}]]],
 ", but neither ",
 Cell[BoxData["c"]],
 " nor ",
 Cell[BoxData[
  SubsuperscriptBox["\[Sigma]", "u", "2"]]],
 " are identified."
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell["Lower bound", "Subsubsection",
 CellLabelAutoDelete->True],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   SubscriptBox["s", "t"], "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["p", "t"], "-", 
     SubscriptBox["m", "t"]}], "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["p", "t"], "-", 
       SubscriptBox["f", "t"]}], ")"}], "-", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["m", "t"], "-", 
       SubscriptBox["f", "t"]}], ")"}]}]}]}]]],
 ".  Since ",
 Cell[BoxData[
  SubscriptBox["f", "t"]]],
 " is a linear projection of ",
 Cell[BoxData[
  SubscriptBox["m", "t"]]],
 " on ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["p", "t"], ",", 
    SubscriptBox["p", 
     RowBox[{"t", "-", "1"}]], ",", "..."}], "}"}]]],
 ", the filtering error ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["m", "t"], "-", 
   SubscriptBox["f", "t"]}]]],
 " is uncorrelated with ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["p", "t"], "-", 
   SubscriptBox["f", "t"]}]]],
 ". \nTherefore ",
 Cell[BoxData[
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "s", "2"], "=", 
   RowBox[{
    RowBox[{"Var", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["p", "t"], "-", 
       SubscriptBox["f", "t"]}], ")"}]}], "+", 
    RowBox[{"Var", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["m", "t"], "-", 
       SubscriptBox["f", "t"]}], ")"}]}]}]}]]],
 ".  "
}], "Text",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3899912619505997`*^9, 3.3899912697855997`*^9}}],

Cell[TextData[{
 "Next we use the property that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["f", "t"], "=", 
    RowBox[{
     SubscriptBox["p", "t"], "+", 
     SubscriptBox["\[Theta]\[Epsilon]", "t"]}]}], TraditionalForm]]],
 " is not dependent on the structural model parameters. \n\[Implies] ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Var", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["p", "t"], "-", 
      SubscriptBox["f", "t"]}], ")"}]}], "=", 
   RowBox[{
    SuperscriptBox["\[Theta]", "2"], 
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]]],
 " is invariant to structural identificatation\nUnder one parameterization \
(that of exclusively private information, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["u", "t"], "=", "0"}], TraditionalForm]]],
 "), ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["m", "t"], "-", 
     SubscriptBox["f", "t"]}], "=", "0"}], TraditionalForm]]],
 ". \nThis parameterization defines the lower bound.\nIf ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["u", "t"], "=", "0"}], TraditionalForm]]],
 ", we've seen that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["m", "t"], "=", 
    RowBox[{
     SubscriptBox["f", "t"], "=", 
     RowBox[{
      SubscriptBox["p", "t"], "+", Cell[TextData[Cell[BoxData[
       SubscriptBox["\[Theta]\[Epsilon]", "t"]]]]]}]}]}], TraditionalForm]]],
 ", so ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "s", "2"], "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Theta]", "2"], 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "=", 
     SuperscriptBox["c", "2"]}]}], TraditionalForm]]],
 ". To establish the last equality, recall that we have a mapping from the \
structural parameters to the autocovariances, and from the autocovariances to \
the moving average parameters. \nThe MA parameters in terms of the structural \
parameters are:"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{"StatStructEqu", ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Gamma]", "0"], ",", 
       SubscriptBox["\[Gamma]", "1"]}], "}"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", "c", " ", "\[Lambda]"}], "+", 
         SuperscriptBox["\[Lambda]", "2"], "+", 
         SubsuperscriptBox["\[Sigma]", "u", "2"], "-", 
         RowBox[{
          SqrtBox[
           RowBox[{
            SuperscriptBox["\[Lambda]", "2"], "+", 
            SubsuperscriptBox["\[Sigma]", "u", "2"]}]], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"4", " ", "c", " ", "\[Lambda]"}], "+", 
            SuperscriptBox["\[Lambda]", "2"], "+", 
            SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}], ")"}]}]}], ",", 
     RowBox[{"\[Theta]", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", "c", " ", "\[Lambda]"}], "+", 
         SuperscriptBox["\[Lambda]", "2"], "+", 
         SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
         RowBox[{
          SqrtBox[
           RowBox[{
            SuperscriptBox["\[Lambda]", "2"], "+", 
            SubsuperscriptBox["\[Sigma]", "u", "2"]}]], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"4", " ", "c", " ", "\[Lambda]"}], "+", 
            SuperscriptBox["\[Lambda]", "2"], "+", 
            SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}], 
        RowBox[{"2", " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{"c", "+", "\[Lambda]"}], ")"}]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", "c", " ", "\[Lambda]"}], "+", 
         SuperscriptBox["\[Lambda]", "2"], "+", 
         SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
         RowBox[{
          SqrtBox[
           RowBox[{
            SuperscriptBox["\[Lambda]", "2"], "+", 
            SubsuperscriptBox["\[Sigma]", "u", "2"]}]], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"4", " ", "c", " ", "\[Lambda]"}], "+", 
            SuperscriptBox["\[Lambda]", "2"], "+", 
            SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}], ")"}]}]}], ",", 
     RowBox[{"\[Theta]", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", "c", " ", "\[Lambda]"}], "+", 
         SuperscriptBox["\[Lambda]", "2"], "+", 
         SubsuperscriptBox["\[Sigma]", "u", "2"], "-", 
         RowBox[{
          SqrtBox[
           RowBox[{
            SuperscriptBox["\[Lambda]", "2"], "+", 
            SubsuperscriptBox["\[Sigma]", "u", "2"]}]], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"4", " ", "c", " ", "\[Lambda]"}], "+", 
            SuperscriptBox["\[Lambda]", "2"], "+", 
            SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}], 
        RowBox[{"2", " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{"c", "+", "\[Lambda]"}], ")"}]}]]}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522842444*^9, 3.3895616679818*^9, 3.3899894677792*^9,
   3.3899911819056*^9, 3.3907337255425997`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"InvertibleSolution", "=", 
   RowBox[{"sol", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "The value computed for the lower bound is  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[Theta]", "2"], 
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], TraditionalForm]]],
 ":"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Theta]", "2"], " ", 
     SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "/.", 
    "\[InvisibleSpace]", "InvertibleSolution"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], ">", "0"}], ",", 
     RowBox[{"c", ">", "0"}], ",", 
     RowBox[{"\[Lambda]", ">", "0"}]}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"2", " ", "c", " ", "\[Lambda]"}], "+", 
    SuperscriptBox["\[Lambda]", "2"], "+", 
    SubsuperscriptBox["\[Sigma]", "u", "2"], "-", 
    SqrtBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["\[Lambda]", "2"], "+", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "c"}], "+", "\[Lambda]"}], ")"}], "2"], "+", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}], ")"}]}]]}], 
   ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522843733997`*^9, 3.3895616689588003`*^9, 
  3.3899894699172*^9, 3.3899911841646*^9, 3.3907337278046*^9}]
}, Open  ]],

Cell["\<\
In the case of exclusively private information, the lower bound is correct.\
\>", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Theta]", "2"], " ", 
     SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "/.", 
    "\[InvisibleSpace]", "InvertibleSolution"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], "==", "0"}], ",", 
     RowBox[{"c", ">", "0"}], ",", 
     RowBox[{"\[Lambda]", ">", "0"}]}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 SuperscriptBox["c", "2"]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522844354*^9, 3.3895616690397997`*^9, 
  3.3899894701521997`*^9, 3.3899911843806*^9, 3.3907337280606003`*^9}]
}, Open  ]],

Cell[TextData[{
 "In the case of exclusively public information ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], "\[NotEqual]", "0"}], ",", 
     RowBox[{"\[Lambda]", "=", "0"}]}], ")"}], TraditionalForm]]],
 ", though, the lower bound is (in terms of the structural parameters):"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Theta]", "2"], " ", 
     SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "/.", 
    "\[InvisibleSpace]", "InvertibleSolution"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], ">", "0"}], ",", 
     RowBox[{"c", ">", "0"}], ",", 
     RowBox[{"\[Lambda]", "==", "0"}]}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", 
     SuperscriptBox["c", "2"]}], "+", 
    SubsuperscriptBox["\[Sigma]", "u", "2"], "-", 
    SqrtBox[
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}], ")"}]}]]}], 
   ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522845014*^9, 3.3895616693368*^9, 3.3899894708232*^9,
   3.3899911851056004`*^9, 3.3907337287525997`*^9}]
}, Open  ]],

Cell[TextData[{
 "Verify that this is less than the true ",
 Cell[BoxData[
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "s", "2"], "=", 
   SuperscriptBox["c", "2"]}]]],
 ":"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"%", "<", 
    SuperscriptBox["c", "2"]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], ">", "0"}], ",", 
     RowBox[{"c", ">", "0"}], ",", 
     RowBox[{"\[Lambda]", "==", "0"}]}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData["True"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522845754004`*^9, 3.3895616693588*^9, 
  3.3899894709302*^9, 3.3899911851935997`*^9, 3.3907337288416*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General univariate random-walk decompositions (Section 8.6)", \
"Subsection",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", 
    RowBox[{"s", ",", "sol", ",", "K"}], "]"}], ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{
   "Remove", " ", "variables", " ", "that", " ", "may", " ", "have", " ", 
    "been", " ", "used", " ", 
    RowBox[{"earlier", "."}]}], " ", "*)"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell["Moving average operator", "Subsubsection",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Theta]", "Rules"], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Theta]", "[", 
       RowBox[{"z_", ",", 
        RowBox[{"q_:", "q"}], ",", 
        RowBox[{"j_:", "j"}]}], "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{
        UnderoverscriptBox["\[Sum]", 
         RowBox[{"j", "=", "0"}], "q"], 
        RowBox[{
         SubscriptBox["\[Theta]", "j"], 
         SuperscriptBox["z", "j"]}]}], "/;", 
       RowBox[{"FreeQ", "[", 
        RowBox[{"z", ",", "Subscript"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"\[Theta]", "[", 
       RowBox[{
        SubscriptBox["z_", "t_"], ",", 
        RowBox[{"q_:", "q"}], ",", 
        RowBox[{"j_:", "j"}]}], "]"}], "\[RuleDelayed]", 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"j", "=", "0"}], "q"], 
       RowBox[{
        SubscriptBox["\[Theta]", "j"], 
        SubscriptBox["z", 
         RowBox[{"t", "-", "j"}]]}]}]}]}], "}"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell["\<\
This may be used to define an MA polynomial in the lag operator\
\>", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Theta]", "[", 
   RowBox[{"L", ",", "5"}], "]"}], "/.", 
  SubscriptBox["\[Theta]", "Rules"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Theta]", "0"], "+", 
  RowBox[{"L", " ", 
   SubscriptBox["\[Theta]", "1"]}], "+", 
  RowBox[{
   SuperscriptBox["L", "2"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "+", 
  RowBox[{
   SuperscriptBox["L", "3"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{
   SuperscriptBox["L", "4"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{
   SuperscriptBox["L", "5"], " ", 
   SubscriptBox["\[Theta]", "5"]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522846144*^9, 3.3895616694138002`*^9, 
  3.3899894710212*^9, 3.3899911852956*^9, 3.3907337289416*^9}]
}, Open  ]],

Cell["or to generate a moving average", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Theta]", "[", 
   SubscriptBox["\[Epsilon]", "t"], "]"}], "/.", 
  SubscriptBox["\[Theta]", "Rules"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"j", "=", "0"}], "q"], 
  RowBox[{
   SubscriptBox["\[Epsilon]", 
    RowBox[{
     RowBox[{"-", "j"}], "+", "t"}]], " ", 
   SubscriptBox["\[Theta]", "j"]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522848484*^9, 3.3895616695118*^9, 3.3899894713802*^9,
   3.3899911854756002`*^9, 3.3907337293526*^9}]
}, Open  ]],

Cell[TextData[{
 "Define a lag operator ",
 Cell[BoxData["L"]],
 " that applies only to time series ",
 Cell[BoxData["x"]],
 ":"
}], "Text",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"LAppliesTo", "[", "x_", "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["L", "k_"], 
      SubscriptBox["x", "t_"]}], "\[RuleDelayed]", 
     SubscriptBox["x", 
      RowBox[{"t", "-", "k"}]]}], ",", 
    RowBox[{
     RowBox[{"L", " ", 
      SubscriptBox["x", "t_"]}], "\[RuleDelayed]", 
     SubscriptBox["x", 
      RowBox[{"t", "-", "1"}]]}]}], "}"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "Note that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " thinks that ",
 Cell[BoxData[
  SuperscriptBox["L", "k"]]],
 " is a quantity in a multiplication, and reorders in its standard fashion:"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"\[Theta]", "[", 
     RowBox[{"L", ",", "5"}], "]"}], "/.", 
    SubscriptBox["\[Theta]", "Rules"]}], ")"}], 
  SubscriptBox["\[Epsilon]", "t"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Epsilon]", "t"], " ", 
  RowBox[{"(", 
   RowBox[{
    SubscriptBox["\[Theta]", "0"], "+", 
    RowBox[{"L", " ", 
     SubscriptBox["\[Theta]", "1"]}], "+", 
    RowBox[{
     SuperscriptBox["L", "2"], " ", 
     SubscriptBox["\[Theta]", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["L", "3"], " ", 
     SubscriptBox["\[Theta]", "3"]}], "+", 
    RowBox[{
     SuperscriptBox["L", "4"], " ", 
     SubscriptBox["\[Theta]", "4"]}], "+", 
    RowBox[{
     SuperscriptBox["L", "5"], " ", 
     SubscriptBox["\[Theta]", "5"]}]}], ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522848864*^9, 3.3895616695578003`*^9, 
  3.3899894714462*^9, 3.3899911855566*^9, 3.3907337294276*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", "%", "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Epsilon]", "t"], " ", 
   SubscriptBox["\[Theta]", "0"]}], "+", 
  RowBox[{"L", " ", 
   SubscriptBox["\[Epsilon]", "t"], " ", 
   SubscriptBox["\[Theta]", "1"]}], "+", 
  RowBox[{
   SuperscriptBox["L", "2"], " ", 
   SubscriptBox["\[Epsilon]", "t"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "+", 
  RowBox[{
   SuperscriptBox["L", "3"], " ", 
   SubscriptBox["\[Epsilon]", "t"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{
   SuperscriptBox["L", "4"], " ", 
   SubscriptBox["\[Epsilon]", "t"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{
   SuperscriptBox["L", "5"], " ", 
   SubscriptBox["\[Epsilon]", "t"], " ", 
   SubscriptBox["\[Theta]", "5"]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522849194*^9, 3.3895616695938*^9, 3.3899894714992*^9,
   3.3899911856196003`*^9, 3.3907337294856*^9}]
}, Open  ]],

Cell[TextData[{
 "To invoke the ",
 Cell[BoxData["L"]],
 " operator:"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"LAppliesTo", "[", "\[Epsilon]", "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Epsilon]", "t"], " ", 
   SubscriptBox["\[Theta]", "0"]}], "+", 
  RowBox[{
   SubscriptBox["\[Epsilon]", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "t"}]], " ", 
   SubscriptBox["\[Theta]", "1"]}], "+", 
  RowBox[{
   SubscriptBox["\[Epsilon]", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "t"}]], " ", 
   SubscriptBox["\[Theta]", "2"]}], "+", 
  RowBox[{
   SubscriptBox["\[Epsilon]", 
    RowBox[{
     RowBox[{"-", "3"}], "+", "t"}]], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{
   SubscriptBox["\[Epsilon]", 
    RowBox[{
     RowBox[{"-", "4"}], "+", "t"}]], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{
   SubscriptBox["\[Epsilon]", 
    RowBox[{
     RowBox[{"-", "5"}], "+", "t"}]], " ", 
   SubscriptBox["\[Theta]", "5"]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522849533997`*^9, 3.3895616696338*^9, 
  3.3899894715502*^9, 3.3899911857966003`*^9, 3.3907337295506*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Setup", "Subsubsection",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "The structural model is:\n",
 Cell[BoxData[{
  RowBox[{
   SubscriptBox["p", "t"], "=", 
   RowBox[{
    SubscriptBox["m", "t"], "+", 
    SubscriptBox["s", "t"]}]}], "\[IndentingNewLine]", 
  RowBox[{
   SubscriptBox["m", "t"], "=", 
   RowBox[{
    SubscriptBox["m", 
     RowBox[{"t", "-", "1"}]], "+", 
    SubscriptBox["u", "t"]}]}]}]]
}], "Text",
 CellLabelAutoDelete->True],

Cell["or to generate a moving average", "Text",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "The statistical representation for ",
 Cell[BoxData[
  SubscriptBox["\[CapitalDelta]p", "t"]]],
 " is a moving average of order ",
 StyleBox["K",
  FontSlant->"Italic"],
 ":"
}], "Text",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["\[CapitalDelta]p", "t_"], "\[RuleDelayed]", 
    RowBox[{"\[Theta]", "[", 
     RowBox[{
      SubscriptBox["\[Epsilon]", "t"], ",", "K"}], "]"}]}]}], ";"}]], "Input",\

 CellLabelAutoDelete->True],

Cell[TextData[{
 "Using this rule, and the rule for the moving average operator ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "t"], "="}]]]
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "t"], "/.", 
   SubscriptBox["\[CapitalDelta]p", "Rule"]}], "/.", 
  SubscriptBox["\[Theta]", "Rules"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"j", "=", "0"}], "K"], 
  RowBox[{
   SubscriptBox["\[Epsilon]", 
    RowBox[{
     RowBox[{"-", "j"}], "+", "t"}]], " ", 
   SubscriptBox["\[Theta]", "j"]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522850123997`*^9, 3.3895616696977997`*^9, 
  3.3899894716572*^9, 3.3899911859146*^9, 3.3907337297546*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Forecasting", "Subsubsection",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "The price change ",
 StyleBox["k",
  FontSlant->"Italic"],
 " periods ahead of ",
 StyleBox["s",
  FontSlant->"Italic"],
 " is:"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", 
    RowBox[{"s", "+", "k"}]], "/.", 
   SubscriptBox["\[CapitalDelta]p", "Rule"]}], "/.", 
  SubscriptBox["\[Theta]", "Rules"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"j", "=", "0"}], "K"], 
  RowBox[{
   SubscriptBox["\[Epsilon]", 
    RowBox[{
     RowBox[{"-", "j"}], "+", "k", "+", "s"}]], " ", 
   SubscriptBox["\[Theta]", "j"]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522850654*^9, 3.3895616697588*^9, 
  3.3899894717651997`*^9, 3.3899911860236*^9, 3.3907337298766003`*^9}]
}, Open  ]],

Cell[TextData[{
 "The price at time ",
 Cell[BoxData[
  SubscriptBox["p", 
   RowBox[{"t", "+", "K"}]]]],
 " is ",
 Cell[BoxData[
  SubscriptBox["p", "s"]]],
 " plus the cumulative change through ",
 Cell[BoxData[
  RowBox[{"s", "+", "K"}]]],
 ":"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["p", "s"], "+", 
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"k", "=", "1"}], "K"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[CapitalDelta]p", 
       RowBox[{"s", "+", "k"}]], "/.", 
      SubscriptBox["\[CapitalDelta]p", "Rule"]}], "/.", 
     SubscriptBox["\[Theta]", "Rules"]}], ")"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubscriptBox["p", "s"], "+", 
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"k", "=", "1"}], "K"], 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"j", "=", "0"}], "K"], 
    RowBox[{
     SubscriptBox["\[Epsilon]", 
      RowBox[{
       RowBox[{"-", "j"}], "+", "k", "+", "s"}]], " ", 
     SubscriptBox["\[Theta]", "j"]}]}]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522852934*^9, 3.3895616699988003`*^9, 
  3.3899894722321997`*^9, 3.3899911865886*^9, 3.3907337304196*^9}]
}, Open  ]],

Cell["For example, let", "Text",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"K", "=", "3"}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["p", "s"], "+", 
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"k", "=", "1"}], "K"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[CapitalDelta]p", 
       RowBox[{"s", "+", "k"}]], "/.", 
      SubscriptBox["\[CapitalDelta]p", "Rule"]}], "/.", 
     SubscriptBox["\[Theta]", "Rules"]}], ")"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubscriptBox["p", "s"], "+", 
  RowBox[{
   SubscriptBox["\[Epsilon]", 
    RowBox[{"1", "+", "s"}]], " ", 
   SubscriptBox["\[Theta]", "0"]}], "+", 
  RowBox[{
   SubscriptBox["\[Epsilon]", 
    RowBox[{"2", "+", "s"}]], " ", 
   SubscriptBox["\[Theta]", "0"]}], "+", 
  RowBox[{
   SubscriptBox["\[Epsilon]", 
    RowBox[{"3", "+", "s"}]], " ", 
   SubscriptBox["\[Theta]", "0"]}], "+", 
  RowBox[{
   SubscriptBox["\[Epsilon]", "s"], " ", 
   SubscriptBox["\[Theta]", "1"]}], "+", 
  RowBox[{
   SubscriptBox["\[Epsilon]", 
    RowBox[{"1", "+", "s"}]], " ", 
   SubscriptBox["\[Theta]", "1"]}], "+", 
  RowBox[{
   SubscriptBox["\[Epsilon]", 
    RowBox[{"2", "+", "s"}]], " ", 
   SubscriptBox["\[Theta]", "1"]}], "+", 
  RowBox[{
   SubscriptBox["\[Epsilon]", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "s"}]], " ", 
   SubscriptBox["\[Theta]", "2"]}], "+", 
  RowBox[{
   SubscriptBox["\[Epsilon]", "s"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "+", 
  RowBox[{
   SubscriptBox["\[Epsilon]", 
    RowBox[{"1", "+", "s"}]], " ", 
   SubscriptBox["\[Theta]", "2"]}], "+", 
  RowBox[{
   SubscriptBox["\[Epsilon]", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "s"}]], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{
   SubscriptBox["\[Epsilon]", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "s"}]], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{
   SubscriptBox["\[Epsilon]", "s"], " ", 
   SubscriptBox["\[Theta]", "3"]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522853283997`*^9, 3.3895616700618*^9, 
  3.3899894723132*^9, 3.3899911866806*^9, 3.3907337305066*^9}]
}, Open  ]],

Cell["...grouping by \[Epsilon]'s:", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Table", "[", 
    RowBox[{
     SubscriptBox["\[Epsilon]", "k"], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", 
       RowBox[{"s", "-", "K", "-", "1"}], ",", 
       RowBox[{"s", "+", "K"}]}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubscriptBox["p", "s"], "+", 
  RowBox[{
   SubscriptBox["\[Epsilon]", 
    RowBox[{"3", "+", "s"}]], " ", 
   SubscriptBox["\[Theta]", "0"]}], "+", 
  RowBox[{
   SubscriptBox["\[Epsilon]", 
    RowBox[{"2", "+", "s"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Theta]", "0"], "+", 
     SubscriptBox["\[Theta]", "1"]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Epsilon]", 
    RowBox[{"1", "+", "s"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Theta]", "0"], "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Epsilon]", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "s"}]], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{
   SubscriptBox["\[Epsilon]", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "s"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Epsilon]", "s"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"]}], ")"}]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522853644*^9, 3.3895616701118*^9, 
  3.3899894723682003`*^9, 3.3899911867496*^9, 3.3907337305676003`*^9}]
}, Open  ]],

Cell[TextData[{
 "To construct a forecast (as of time s), use the fact that ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"\[ScriptCapitalE]", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Epsilon]", "k"], "|", 
      SubscriptBox["p", "s"]}], ",", 
     SubscriptBox["p", 
      RowBox[{"s", "-", "1"}]], ",", "..."}], "]"}], "=", 
   RowBox[{"0", " ", 
    RowBox[{"\[ForAll]", 
     RowBox[{"k", ">", "s"}]}]}]}]]]
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{
   SubscriptBox["\[Epsilon]", "k_"], "\[RuleDelayed]", 
   RowBox[{"0", "/;", 
    RowBox[{"Simplify", "[", 
     RowBox[{"k", ">", "s"}], "]"}]}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubscriptBox["p", "s"], "+", 
  RowBox[{
   SubscriptBox["\[Epsilon]", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "s"}]], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{
   SubscriptBox["\[Epsilon]", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "s"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Epsilon]", "s"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"]}], ")"}]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522853993998`*^9, 3.3895616701528*^9, 
  3.3899894724192*^9, 3.3899911868156*^9, 3.3907337306236*^9}]
}, Open  ]],

Cell["This can all be summarized in the forecast function", "Text",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["f", "Rule"], "=", 
   RowBox[{
    SubscriptBox["f", "s_"], "\[RuleDelayed]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Collect", "[", 
       RowBox[{
        RowBox[{
         SubscriptBox["p", "s"], "+", 
         RowBox[{
          UnderoverscriptBox["\[Sum]", 
           RowBox[{"k", "=", "1"}], "K"], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SubscriptBox["\[CapitalDelta]p", 
              RowBox[{"s", "+", "k"}]], "/.", 
             SubscriptBox["\[CapitalDelta]p", "Rule"]}], "/.", 
            SubscriptBox["\[Theta]", "Rules"]}], ")"}]}]}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          SubscriptBox["\[Epsilon]", "k"], ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", 
            RowBox[{"s", "-", "K", "-", "1"}], ",", 
            RowBox[{"s", "+", "K"}]}], "}"}]}], "]"}]}], "]"}], "/.", 
      RowBox[{
       SubscriptBox["\[Epsilon]", "k_"], "\[RuleDelayed]", 
       RowBox[{"0", "/;", 
        RowBox[{"Simplify", "[", 
         RowBox[{"k", ">", "s"}], "]"}]}]}]}], ")"}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["f", "t"], "/.", 
  SubscriptBox["f", "Rule"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubscriptBox["p", "t"], "+", 
  RowBox[{
   SubscriptBox["\[Epsilon]", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "t"}]], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{
   SubscriptBox["\[Epsilon]", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "t"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["\[Epsilon]", "t"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"]}], ")"}]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522854434*^9, 3.3895616702038*^9, 3.3899894724892*^9,
   3.3899911868966*^9, 3.3907337306976*^9}]
}, Open  ]],

Cell[TextData[{
 "The first difference of the forecast is proportional to ",
 Cell[BoxData[
  SubscriptBox["\[Epsilon]", "t"]]],
 ", and so is a M'gale:"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["f", "t"], "-", 
     SubscriptBox["f", 
      RowBox[{"t", "-", "1"}]]}], "/.", 
    SubscriptBox["f", "Rule"]}], "/.", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["p", "t"], "-", 
      SubscriptBox["p", 
       RowBox[{"t", "-", "1"}]]}], ")"}], "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[CapitalDelta]p", "t"], "/.", 
       SubscriptBox["\[CapitalDelta]p", "Rule"]}], "/.", 
      SubscriptBox["\[Theta]", "Rules"]}], ")"}]}]}], "//", 
  "Simplify"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Epsilon]", "t"], " ", 
  RowBox[{"(", 
   RowBox[{
    SubscriptBox["\[Theta]", "0"], "+", 
    SubscriptBox["\[Theta]", "1"], "+", 
    SubscriptBox["\[Theta]", "2"], "+", 
    SubscriptBox["\[Theta]", "3"]}], ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522854764*^9, 3.3895616702478*^9, 3.3899894725462*^9,
   3.3899911869656*^9, 3.3907337307576*^9}]
}, Open  ]],

Cell[TextData[{
 "when ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["m", "t"], "=", 
   SubscriptBox["f", "t"]}]]],
 ", the above is ",
 Cell[BoxData[
  RowBox[{"=", 
   SubscriptBox["w", "t"]}]]],
 " and ",
 Cell[BoxData[
  SubsuperscriptBox["\[Sigma]", "w", "2"]]],
 " ="
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"Coefficient", "[", 
    RowBox[{"%", ",", 
     SubscriptBox["\[Epsilon]", "t"]}], "]"}], "2"], 
  SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Theta]", "0"], "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"]}], ")"}], "2"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522855114*^9, 3.3895616702918*^9, 3.3899894725972*^9,
   3.3899911870416*^9, 3.3907337308766003`*^9}]
}, Open  ]],

Cell["cf. eq. (8.10) in the text.", "Text",
 CellLabelAutoDelete->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Pricing error (when ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["m", "t"], "=", 
   SubscriptBox["f", "t"]}]]],
 ")"
}], "Subsubsection",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SubscriptBox["p", "t"], "-", 
    SubscriptBox["m", "t"]}], "/.", 
   RowBox[{
    SubscriptBox["m", "t"], "\[Rule]", 
    SubscriptBox["f", "t"]}]}], "/.", 
  SubscriptBox["f", "Rule"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    SubscriptBox["\[Epsilon]", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "t"}]]}], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{
   SubscriptBox["\[Epsilon]", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "t"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"]}], ")"}]}], "-", 
  RowBox[{
   SubscriptBox["\[Epsilon]", "t"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"]}], ")"}]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522856113997`*^9, 3.3895616704058*^9, 
  3.3899894727002*^9, 3.3899911871745996`*^9, 3.3907337309916*^9}]
}, Open  ]],

Cell[TextData[{
 "The lower-bound for ",
 Cell[BoxData[
  SubsuperscriptBox["\[Sigma]", "s", "2"]]],
 " is:"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", " ", "@@", " ", 
   SuperscriptBox[
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Coefficient", "[", 
       RowBox[{"%", ",", 
        SubscriptBox["\[Epsilon]", 
         RowBox[{"t", "-", "i"}]]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", 
        RowBox[{"K", "-", "1"}]}], "}"}]}], "]"}], "2"]}], 
  SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SubscriptBox["\[Theta]", "2"]}], "-", 
       SubscriptBox["\[Theta]", "3"]}], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SubscriptBox["\[Theta]", "1"]}], "-", 
       SubscriptBox["\[Theta]", "2"], "-", 
       SubscriptBox["\[Theta]", "3"]}], ")"}], "2"], "+", 
    SubsuperscriptBox["\[Theta]", "3", "2"]}], ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522856563997`*^9, 3.3895616704518003`*^9, 
  3.3899894727511997`*^9, 3.3899911872396*^9, 3.3907337310696*^9}]
}, Open  ]],

Cell["cf. (8.12) in the text.", "Text",
 CellLabelAutoDelete->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8.1", "Subsection",
 CellLabelAutoDelete->True,
 CellTags->"Ch8Ex1"],

Cell["\<\
The model is observationally equivalent to one in which there is no lag on \
the efficient price. The autocovariances and moving average representation \
are the same.\
\>", "Text",
 CellLabelAutoDelete->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8.2", "Subsection",
 CellLabelAutoDelete->True,
 CellTags->"Ch8Ex2"],

Cell[TextData[{
 "By rearranging, the model can be written as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "\[Alpha]"}], ")"}], "L"}]}], ")"}], 
    SubscriptBox["p", "t"]}], "=", 
   SubscriptBox["\[Alpha]m", "t"]}]]],
 ". Taking first differences ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "\[Alpha]"}], ")"}], "L"}]}], ")"}], 
    SubscriptBox["\[CapitalDelta]p", "t"]}], "=", 
   RowBox[{
    SubscriptBox["\[Epsilon]", "t"], "=", 
    SubscriptBox["\[Alpha]w", "t"]}]}]]],
 " So:"
}], "Text",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3899908722316*^9, 3.3899908859726*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Phi]", "[", "L_", "]"}], ":=", 
  RowBox[{"1", "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", "\[Alpha]"}], ")"}], "L"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "The MA representation is ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "t"], "=", 
   RowBox[{"\[Theta]", 
    RowBox[{"(", "L", ")"}], 
    SubscriptBox["\[Epsilon]", "t"]}]}]]],
 " where ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"\[Theta]", 
    RowBox[{"(", "L", ")"}]}], "=", 
   RowBox[{"\[Phi]", 
    SuperscriptBox[
     RowBox[{"(", "L", ")"}], 
     RowBox[{"-", "1"}]]}]}]]],
 ". Furthermore ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"\[Theta]", 
    SuperscriptBox[
     RowBox[{"(", "1", ")"}], "2"]}], "="}]]]
}], "Text",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3899908899216003`*^9, 3.3899908912846003`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"\[Phi]", "[", "1", "]"}], 
  RowBox[{"-", "2"}]]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 FractionBox["1", 
  SuperscriptBox["\[Alpha]", "2"]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522856934*^9, 3.3895616705048*^9, 
  3.3899894728162003`*^9, 3.3899911873166*^9, 3.3907337311526003`*^9}]
}, Open  ]],

Cell[TextData[{
 "Since ",
 Cell[BoxData[
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "=", 
   RowBox[{
    SuperscriptBox["\[Alpha]", "2"], 
    SubsuperscriptBox["\[Sigma]", "w", "2"]}]}]]],
 ", ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"\[Theta]", 
    SuperscriptBox[
     RowBox[{"(", "1", ")"}], "2"], 
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "=", 
   SubsuperscriptBox["\[Sigma]", "w", "2"]}]]]
}], "Text",
 CellLabelAutoDelete->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8.3", "Subsection",
 CellLabelAutoDelete->True,
 CellTags->"Ch8Ex3"],

Cell["Over five-minute intervals", "Text",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Sigma]", "Rule"], "=", 
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "\[Rule]", 
    "0.00001"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Theta]", "[", "L_", "]"}], ":=", 
  RowBox[{"1", "-", 
   RowBox[{"0.3", " ", "L"}], " ", "+", " ", 
   RowBox[{"0.1", " ", 
    SuperscriptBox["L", "2"]}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell["Random-walk variance:", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 SqrtBox[
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"\[Theta]", "[", "1", "]"}], "2"], 
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "/.", 
   SubscriptBox["\[Sigma]", "Rule"]}]]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData["0.002529822128134704`"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522857444*^9, 3.3895616705638*^9, 3.3899894728892*^9,
   3.3899911874066*^9, 3.3907337313036003`*^9}]
}, Open  ]],

Cell["Over one day:", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 SqrtBox[
  RowBox[{
   RowBox[{"6", "*", "12", "*", 
    SuperscriptBox[
     RowBox[{"\[Theta]", "[", "1", "]"}], "2"], 
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "/.", 
   SubscriptBox["\[Sigma]", "Rule"]}]]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData["0.021466252583997984`"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522857824*^9, 3.3895616706057997`*^9, 
  3.3899894729392*^9, 3.3899911874656*^9, 3.3907337313626003`*^9}]
}, Open  ]],

Cell["i.e., about 2%", "Text",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "For the pricing error variance, the ",
 Cell[BoxData[
  SubscriptBox["C", "i"]]],
 " coefficients are generally:"
}], "Text",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["C", "Rule"], "=", 
   RowBox[{
    RowBox[{"C", "[", 
     RowBox[{"\[Theta]_", ",", "i_"}], "]"}], ":>", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"j", "=", 
       RowBox[{"i", "+", "1"}]}], 
      RowBox[{"Exponent", "[", 
       RowBox[{
        RowBox[{"\[Theta]", "[", "L", "]"}], ",", "L"}], "]"}]], 
     RowBox[{"-", 
      RowBox[{"Coefficient", "[", 
       RowBox[{
        RowBox[{"\[Theta]", "[", "L", "]"}], ",", "L", ",", "j"}], 
       "]"}]}]}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell["and here ...", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"C", "[", 
     RowBox[{"\[Theta]", ",", "i"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "2"}], "}"}]}], "]"}], "/.", 
  SubscriptBox["C", "Rule"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.19999999999999998`", ",", 
   RowBox[{"-", "0.1`"}], ",", "0"}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522858244*^9, 3.3895616706608*^9, 3.3899894731042*^9,
   3.3899911875495996`*^9, 3.3907337314406*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 SqrtBox[
  RowBox[{
   RowBox[{
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"i", "=", "0"}], 
      RowBox[{
       RowBox[{"Exponent", "[", 
        RowBox[{
         RowBox[{"\[Theta]", "[", "L", "]"}], ",", "L"}], "]"}], "-", "1"}]], 
     
     RowBox[{
      SuperscriptBox[
       RowBox[{"C", "[", 
        RowBox[{"\[Theta]", ",", "i"}], "]"}], "2"], 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}], "/.", 
    SubscriptBox["C", "Rule"]}], "/.", 
   SubscriptBox["\[Sigma]", "Rule"]}]]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData["0.0007071067811865475`"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522858564*^9, 3.3895616707068*^9, 3.3899894731642*^9,
   3.3899911876126003`*^9, 3.3907337315006*^9}]
}, Open  ]],

Cell["i.e., about seven basis points", "Text",
 CellLabelAutoDelete->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8.4", "Subsection",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "The structural model is:\n",
 Cell[BoxData[{
  RowBox[{
   SubscriptBox["m", "t"], "=", 
   RowBox[{
    SubscriptBox["m", 
     RowBox[{"t", "-", "1"}]], "+", 
    SubscriptBox["w", "t"]}]}], "\[IndentingNewLine]", 
  RowBox[{
   SubscriptBox["w", "t"], "=", 
   RowBox[{
    SubscriptBox["\[Lambda]q", "t"], "+", 
    SubscriptBox["u", "t"]}]}], "\[IndentingNewLine]", 
  RowBox[{
   SubscriptBox["p", "t"], "=", 
   RowBox[{
    SubscriptBox["m", 
     RowBox[{"t", "-", "1"}]], "+", 
    RowBox[{"c", " ", 
     SubscriptBox["q", "t"]}]}]}]}]],
 "\nNotice that the price is determined with respect to ",
 StyleBox["lagged",
  FontSlant->"Italic"],
 " value of the implicit efficient price."
}], "Text",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "(a) Using the structural representation, determine the ",
 Cell[BoxData[
  SubscriptBox["\[CapitalDelta]p", "t"]]],
 " autocovariances ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Gamma]", "0"], ",", " ", 
   SubscriptBox["\[Gamma]", "1"]}]]],
 " and verify that ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Gamma]", "2"], "=", "0"}]]],
 "."
}], "Text",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "In this and the following parts, assume that  ",
 Cell[BoxData[
  RowBox[{"c", "=", "2"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"\[Lambda]", "=", "1"}]]],
 ".\n(b) Verify that autocovariances are the same as the autocovariances for \
the (statistical) MA(1) model ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "t"], "=", 
   RowBox[{
    SubscriptBox["\[Epsilon]", "t"], "+", "\[Theta]"}]}]]],
 " where",
 "\n\t",
 Cell[BoxData[{
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "=", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubsuperscriptBox["\[Sigma]", "u", "2"], "+", "1"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SubsuperscriptBox["\[Sigma]", "u", "2"], "+", "9"}], ")"}]}]], "+",
        "5"}], ")"}]}]}], TraditionalForm], "\n", 
  FormBox["and", TraditionalForm], "\n", 
  FormBox[
   RowBox[{"\[Theta]", "=", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}], "+", 
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubsuperscriptBox["\[Sigma]", "u", "2"], "+", "1"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SubsuperscriptBox["\[Sigma]", "u", "2"], "+", "9"}], ")"}]}]], "-",
        "5"}], ")"}]}]}], TraditionalForm]}], "Text"]
}], "Text",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "(c) Verify that ",
 Cell[BoxData[
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "w", "2"], "=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Theta]"}], ")"}], "2"], 
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]]],
 ".\n(d) Compute (in terms of the MA parameters) the lower bound for  ",
 Cell[BoxData[
  SubsuperscriptBox["\[Sigma]", "s", "2"]]],
 " where ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["s", "t"], "=", 
   RowBox[{
    SubscriptBox["p", "t"], "-", 
    SubscriptBox["m", "t"]}]}]]],
 ". Verify that the lower bound is exact when ",
 Cell[BoxData[
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "u", "2"], "=", "0"}]]],
 "."
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell["Analysis", "Subsubsection",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"nValues", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c", "\[Rule]", "2"}], ",", 
     RowBox[{"\[Lambda]", "\[Rule]", "1"}]}], "}"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["m", "Rule"], "=", 
   RowBox[{
    SubscriptBox["m", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", 
      RowBox[{"t", "-", "1"}]], "+", 
     SubscriptBox["w", "t"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["w", "Rule"], "=", 
   RowBox[{
    SubscriptBox["w", "t_"], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"\[Lambda]", " ", 
      SubscriptBox["q", "t"]}], "+", 
     SubscriptBox["u", "t"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["p", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", 
      RowBox[{"t", "-", "1"}]], "+", 
     RowBox[{"c", " ", 
      SubscriptBox["q", "t"]}]}]}]}], ";"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "Pricing error ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["s", "t"], "="}]]]
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["p", "t"], "-", 
     SubscriptBox["m", "t"]}], "/.", 
    SubscriptBox["p", "Rule"]}], "/.", 
   RowBox[{
    SubscriptBox["m", "t"], "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["m", "t"], "/.", 
      SubscriptBox["m", "Rule"]}], ")"}]}]}], "/.", 
  SubscriptBox["w", "Rule"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"c", " ", 
   SubscriptBox["q", "t"]}], "-", 
  RowBox[{"\[Lambda]", " ", 
   SubscriptBox["q", "t"]}], "-", 
  SubscriptBox["u", "t"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522858993998`*^9, 3.3895616708028*^9, 
  3.3899894732422*^9, 3.3899909480685997`*^9, 3.3899911877086*^9, 
  3.3907337316526003`*^9}]
}, Open  ]],

Cell["This implies that the pricing error variance is", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "-", "\[Lambda]"}], ")"}], "2"], "+", 
   SubsuperscriptBox["\[Sigma]", "u", "2"]}], "/.", "nValues"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"1", "+", 
  SubsuperscriptBox["\[Sigma]", "u", "2"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522859334*^9, 3.3895616708408003`*^9, 
  3.3899894733062*^9, 3.3899909481275997`*^9, 3.3899911877696*^9, 
  3.3907337317186003`*^9}]
}, Open  ]],

Cell["Price changes:", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["\[CapitalDelta]p", "t_"], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         SubscriptBox["p", "t"], "/.", "\[InvisibleSpace]", 
         SubscriptBox["p", "Rule"]}], "/.", "\[InvisibleSpace]", 
        SubscriptBox["m", "Rule"]}], "/.", "\[InvisibleSpace]", 
       SubscriptBox["w", "Rule"]}], ")"}], "-", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["p", 
        RowBox[{"t", "-", "1"}]], "/.", "\[InvisibleSpace]", 
       SubscriptBox["p", "Rule"]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["\[CapitalDelta]p", "t"], "/.", 
  SubscriptBox["\[CapitalDelta]p", "Rule"]}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "c"}], " ", 
   SubscriptBox["q", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "t"}]]}], "+", 
  RowBox[{"\[Lambda]", " ", 
   SubscriptBox["q", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "t"}]]}], "+", 
  RowBox[{"c", " ", 
   SubscriptBox["q", "t"]}], "+", 
  SubscriptBox["u", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "t"}]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522859694*^9, 3.3895616708768*^9, 3.3899894733652*^9,
   3.3899909481896*^9, 3.3899911878336*^9, 3.3907337317886*^9}]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"Var", "[", 
    RowBox[{"\[CapitalDelta]", " ", 
     SubscriptBox["p", "t"]}], "]"}], "=", 
   SubscriptBox["\[Gamma]", "0"]}]]],
 ":"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ScriptCapitalE]", "[", 
   RowBox[{"Expand", "[", 
    RowBox[{
     SubsuperscriptBox["\[CapitalDelta]p", "t", "2"], "/.", 
     "\[InvisibleSpace]", 
     SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}], "]"}], "//.", 
  SubscriptBox["\[ScriptCapitalE]", "Rules"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SuperscriptBox["c", "2"]}], "-", 
  RowBox[{"2", " ", "c", " ", "\[Lambda]"}], "+", 
  SuperscriptBox["\[Lambda]", "2"], "+", 
  SubsuperscriptBox["\[Sigma]", "u", "2"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522860134*^9, 3.3895616709138002`*^9, 
  3.3899894734302*^9, 3.3899909482455997`*^9, 3.3899911879016*^9, 
  3.3907337318585997`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SuperscriptBox["c", "2"]}], "-", 
  RowBox[{"2", " ", "\[Lambda]", " ", "c"}], "+", 
  SuperscriptBox["\[Lambda]", "2"], "+", 
  SubsuperscriptBox["\[Sigma]", "u", "2"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SuperscriptBox["c", "2"]}], "-", 
  RowBox[{"2", " ", "c", " ", "\[Lambda]"}], "+", 
  SuperscriptBox["\[Lambda]", "2"], "+", 
  SubsuperscriptBox["\[Sigma]", "u", "2"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522860514*^9, 3.3895616709518003`*^9, 
  3.3899894734872*^9, 3.3899909483086*^9, 3.3899911879625998`*^9, 
  3.3907337319826*^9}]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"Cov", "[", 
    RowBox[{
     SubscriptBox["\[CapitalDelta]p", "t"], ",", 
     SubscriptBox["\[CapitalDelta]p", 
      RowBox[{"t", "-", "1"}]]}], "]"}], "=", 
   SubscriptBox["\[Gamma]", "1"]}]]],
 ":"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ScriptCapitalE]", "[", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[CapitalDelta]p", "t"], " ", 
      SubscriptBox["\[CapitalDelta]p", 
       RowBox[{"t", "-", "1"}]]}], "/.", "\[InvisibleSpace]", 
     SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}], "]"}], "//.", 
  SubscriptBox["\[ScriptCapitalE]", "Rules"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SuperscriptBox["c", "2"]}], "+", 
  RowBox[{"c", " ", "\[Lambda]"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522860964003`*^9, 3.3895616709938*^9, 
  3.3899894735472*^9, 3.3899909483666*^9, 3.3899911880316*^9, 
  3.3907337320556*^9}]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"Cov", "[", 
    RowBox[{
     SubscriptBox["\[CapitalDelta]p", "t"], ",", 
     SubscriptBox["\[CapitalDelta]p", 
      RowBox[{"t", "-", "2"}]]}], "]"}], "=", 
   SubscriptBox["\[Gamma]", "2"]}]]],
 ":"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ScriptCapitalE]", "[", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[CapitalDelta]p", "t"], " ", 
      SubscriptBox["\[CapitalDelta]p", 
       RowBox[{"t", "-", "2"}]]}], "/.", "\[InvisibleSpace]", 
     SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}], "]"}], "//.", 
  SubscriptBox["\[ScriptCapitalE]", "Rules"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData["0"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522861294003`*^9, 3.3895616710438004`*^9, 
  3.3899894736152*^9, 3.3899909484245996`*^9, 3.3899911881116*^9, 
  3.3907337321376*^9}]
}, Open  ]],

Cell["\<\
Summarize the first two autocovariances in terms of the structural \
parameters:\
\>", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Gamma]Structural", "Rules"], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Gamma]", "0"], "\[Rule]", 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["c", "2"]}], "-", 
       RowBox[{"2", " ", "\[Lambda]", " ", "c"}], "+", 
       SuperscriptBox["\[Lambda]", "2"], "+", 
       SubsuperscriptBox["\[Sigma]", "u", "2"]}]}], ",", 
     RowBox[{
      SubscriptBox["\[Gamma]", "1"], "\[Rule]", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["c", "2"]}], "+", 
       RowBox[{"c", " ", "\[Lambda]"}]}]}]}], "}"}]}], ";", " ", 
  RowBox[{
   SubscriptBox["\[Gamma]Structural", "Rules"], "//", 
   "TableForm"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{
       SubscriptBox["\[Gamma]", "0"], "\[Rule]", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", "c", " ", "\[Lambda]"}], "+", 
        SuperscriptBox["\[Lambda]", "2"], "+", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}]}]},
     {
      RowBox[{
       SubscriptBox["\[Gamma]", "1"], "\[Rule]", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"c", " ", "\[Lambda]"}]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522861644*^9, 3.3895616710958*^9, 3.3899894736792*^9,
   3.3899909484835997`*^9, 3.3899911881826*^9, 3.3907337322056*^9}]
}, Open  ]],

Cell[TextData[{
 " Now evaluate ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Var", "[", 
    SubscriptBox["w", "t"], "]"}], "=", 
   SubsuperscriptBox["\[Sigma]", "w", "2"]}]]],
 ":"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ScriptCapitalE]", "[", 
   RowBox[{"Expand", "[", 
    RowBox[{
     SubsuperscriptBox["w", "t", "2"], "/.", "\[InvisibleSpace]", 
     SubscriptBox["w", "Rule"]}], "]"}], "]"}], "//.", 
  SubscriptBox["\[ScriptCapitalE]", "Rules"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[Lambda]", "2"], "+", 
  SubsuperscriptBox["\[Sigma]", "u", "2"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522861994*^9, 3.3895616711608*^9, 3.3899894737382*^9,
   3.3899909485416*^9, 3.3899911882466*^9, 3.3907337323336*^9}]
}, Open  ]],

Cell[TextData[{
 "The autocovariances computed from the statistical and structural \
representations must agree. The autocovariances for the MA(1) process ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "t"], "=", 
   RowBox[{
    SubscriptBox["\[Epsilon]", "t"], "+", 
    SubscriptBox["\[Theta]\[Epsilon]", 
     RowBox[{"t", "-", "1"}]]}]}]]],
 " are:"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Gamma]Statistical", "Rules"], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Gamma]", "0"], "\[Rule]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["\[Theta]", "2"], "+", "1"}], ")"}], " ", 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}], ",", 
     RowBox[{
      SubscriptBox["\[Gamma]", "1"], "\[Rule]", 
      RowBox[{"\[Theta]", " ", 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]}], "}"}]}], ";", 
  " ", 
  RowBox[{
   SubscriptBox["\[Gamma]Statistical", "Rules"], "//", 
   "TableForm"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{
       SubscriptBox["\[Gamma]", "0"], "\[Rule]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["\[Theta]", "2"]}], ")"}], " ", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]},
     {
      RowBox[{
       SubscriptBox["\[Gamma]", "1"], "\[Rule]", 
       RowBox[{"\[Theta]", " ", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522862344*^9, 3.3895616711998*^9, 3.3899894738002*^9,
   3.3899909486136*^9, 3.3899911884326*^9, 3.3907337323996*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StatStructEqu", "=", 
   RowBox[{"Apply", "[", 
    RowBox[{"Equal", ",", 
     RowBox[{"Join", "[", 
      RowBox[{
       SubscriptBox["\[Gamma]Statistical", "Rules"], ",", 
       SubscriptBox["\[Gamma]Structural", "Rules"]}], "]"}], ",", 
     RowBox[{"{", "1", "}"}]}], "]"}]}], ";", " ", 
  RowBox[{"StatStructEqu", "//", "TableForm"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{
       SubscriptBox["\[Gamma]", "0"], "\[Equal]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["\[Theta]", "2"]}], ")"}], " ", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]},
     {
      RowBox[{
       SubscriptBox["\[Gamma]", "1"], "\[Equal]", 
       RowBox[{"\[Theta]", " ", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]},
     {
      RowBox[{
       SubscriptBox["\[Gamma]", "0"], "\[Equal]", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", "c", " ", "\[Lambda]"}], "+", 
        SuperscriptBox["\[Lambda]", "2"], "+", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}]}]},
     {
      RowBox[{
       SubscriptBox["\[Gamma]", "1"], "\[Equal]", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"c", " ", "\[Lambda]"}]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522862724*^9, 3.3895616712388*^9, 3.3899894738642*^9,
   3.3899909486766*^9, 3.3899911884936*^9, 3.3907337324596*^9}]
}, Open  ]],

Cell["which implies:", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{"StatStructEqu", ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Gamma]", "0"], ",", 
       SubscriptBox["\[Gamma]", "1"]}], "}"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", "c", " ", "\[Lambda]"}], "+", 
         SuperscriptBox["\[Lambda]", "2"], "+", 
         SubsuperscriptBox["\[Sigma]", "u", "2"], "-", 
         RowBox[{
          SqrtBox[
           RowBox[{
            SuperscriptBox["\[Lambda]", "2"], "+", 
            SubsuperscriptBox["\[Sigma]", "u", "2"]}]], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"4", " ", "c", " ", "\[Lambda]"}], "+", 
            SuperscriptBox["\[Lambda]", "2"], "+", 
            SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}], ")"}]}]}], ",", 
     RowBox[{"\[Theta]", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", "c", " ", "\[Lambda]"}], "+", 
         SuperscriptBox["\[Lambda]", "2"], "+", 
         SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
         RowBox[{
          SqrtBox[
           RowBox[{
            SuperscriptBox["\[Lambda]", "2"], "+", 
            SubsuperscriptBox["\[Sigma]", "u", "2"]}]], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"4", " ", "c", " ", "\[Lambda]"}], "+", 
            SuperscriptBox["\[Lambda]", "2"], "+", 
            SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}], 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", "c", " ", "\[Lambda]"}]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", "c", " ", "\[Lambda]"}], "+", 
         SuperscriptBox["\[Lambda]", "2"], "+", 
         SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
         RowBox[{
          SqrtBox[
           RowBox[{
            SuperscriptBox["\[Lambda]", "2"], "+", 
            SubsuperscriptBox["\[Sigma]", "u", "2"]}]], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"4", " ", "c", " ", "\[Lambda]"}], "+", 
            SuperscriptBox["\[Lambda]", "2"], "+", 
            SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}], ")"}]}]}], ",", 
     RowBox[{"\[Theta]", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", "c", " ", "\[Lambda]"}], "+", 
         SuperscriptBox["\[Lambda]", "2"], "+", 
         SubsuperscriptBox["\[Sigma]", "u", "2"], "-", 
         RowBox[{
          SqrtBox[
           RowBox[{
            SuperscriptBox["\[Lambda]", "2"], "+", 
            SubsuperscriptBox["\[Sigma]", "u", "2"]}]], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"4", " ", "c", " ", "\[Lambda]"}], "+", 
            SuperscriptBox["\[Lambda]", "2"], "+", 
            SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}], 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", "c", " ", "\[Lambda]"}]}]]}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522863454*^9, 3.3895616713578*^9, 3.3899894741092*^9,
   3.3899909489326*^9, 3.3899911887386*^9, 3.3907337327046003`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InvertibleSolution", "=", 
  RowBox[{"sol", "[", 
   RowBox[{"[", "2", "]"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "\[Rule]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["c", "2"]}], "-", 
       RowBox[{"2", " ", "c", " ", "\[Lambda]"}], "+", 
       SuperscriptBox["\[Lambda]", "2"], "+", 
       SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
       RowBox[{
        SqrtBox[
         RowBox[{
          SuperscriptBox["\[Lambda]", "2"], "+", 
          SubsuperscriptBox["\[Sigma]", "u", "2"]}]], " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox["c", "2"]}], "-", 
          RowBox[{"4", " ", "c", " ", "\[Lambda]"}], "+", 
          SuperscriptBox["\[Lambda]", "2"], "+", 
          SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}], ")"}]}]}], ",", 
   RowBox[{"\[Theta]", "\[Rule]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["c", "2"]}], "-", 
       RowBox[{"2", " ", "c", " ", "\[Lambda]"}], "+", 
       SuperscriptBox["\[Lambda]", "2"], "+", 
       SubsuperscriptBox["\[Sigma]", "u", "2"], "-", 
       RowBox[{
        SqrtBox[
         RowBox[{
          SuperscriptBox["\[Lambda]", "2"], "+", 
          SubsuperscriptBox["\[Sigma]", "u", "2"]}]], " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox["c", "2"]}], "-", 
          RowBox[{"4", " ", "c", " ", "\[Lambda]"}], "+", 
          SuperscriptBox["\[Lambda]", "2"], "+", 
          SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}], 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["c", "2"]}], "-", 
       RowBox[{"2", " ", "c", " ", "\[Lambda]"}]}]]}]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522863784*^9, 3.3895616713738003`*^9, 
  3.3899894741692*^9, 3.3899909489926*^9, 3.3899911888185997`*^9, 
  3.3907337327665997`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"InvertibleSolution", "/.", "nValues"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Lambda]", ">", "0"}], ",", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], ">", "0"}], ",", 
     RowBox[{"c", ">", "0"}]}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "\[Rule]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"5", "+", 
       SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SubsuperscriptBox["\[Sigma]", "u", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"9", "+", 
           SubsuperscriptBox["\[Sigma]", "u", "2"]}], ")"}]}]]}], ")"}]}]}], 
   ",", 
   RowBox[{"\[Theta]", "\[Rule]", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "5"}], "-", 
       SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SubsuperscriptBox["\[Sigma]", "u", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"9", "+", 
           SubsuperscriptBox["\[Sigma]", "u", "2"]}], ")"}]}]]}], ")"}]}]}]}],
   "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522864133997`*^9, 3.3895616715458*^9, 
  3.3899894745332003`*^9, 3.3899909493686*^9, 3.3899911892306004`*^9, 
  3.3907337331316*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", " ", "[", " ", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Theta]"}], ")"}], "2"], 
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "/.", 
   "InvertibleSolution"}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[Lambda]", "2"], "+", 
  SubsuperscriptBox["\[Sigma]", "u", "2"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522864533997`*^9, 3.3895616715938*^9, 
  3.3899894746261997`*^9, 3.3899909494676*^9, 3.3899911893236*^9, 
  3.3907337332296*^9}]
}, Open  ]],

Cell[TextData[{
 "i.e., the coefficient of ",
 Cell[BoxData[
  SubscriptBox["\[Epsilon]", "t"]]],
 " is the same in both representations."
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Theta]", "2"], 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "/.", 
     "InvertibleSolution"}], "/.", "nValues"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Lambda]", ">", "0"}], ",", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], ">", "0"}], ",", 
     RowBox[{"c", ">", "0"}]}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"5", "+", 
    SubsuperscriptBox["\[Sigma]", "u", "2"], "-", 
    SqrtBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"9", "+", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}], ")"}]}]]}], 
   ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522864934*^9, 3.3895616716208*^9, 3.3899894747202*^9,
   3.3899909495566*^9, 3.3899911894216003`*^9, 3.3907337334716*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Theta]", "2"], 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "/.", 
      "InvertibleSolution"}], "/.", "nValues"}], "/.", 
    RowBox[{
     SubsuperscriptBox["\[Sigma]", "u", "2"], "\[Rule]", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Lambda]", ">", "0"}], ",", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], ">", "0"}], ",", 
     RowBox[{"c", ">", "0"}]}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData["1"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522865274*^9, 3.3895616716328*^9, 3.3899894747802*^9,
   3.3899909496166*^9, 3.3899911894835997`*^9, 3.3907337335436*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Theta]", "2"], 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "/.", 
      "InvertibleSolution"}], ")"}], "==", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "-", "\[Lambda]"}], ")"}], "2"], "+", 
     SubsuperscriptBox["\[Sigma]", "u", "2"]}]}], ",", 
   SubsuperscriptBox["\[Sigma]", "u", "2"]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "u", "2"], "\[Rule]", "0"}], "}"}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522866084003`*^9, 3.3895616717348003`*^9, 
  3.3899894750192003`*^9, 3.3899909498416*^9, 3.3899911897146*^9, 
  3.3907337338306*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"InvertibleSolution", "/.", "nValues"}], "/.", 
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "u", "2"], "\[Rule]", "0"}]}], "//", 
  "Simplify"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "\[Rule]", "4"}], ",", 
   RowBox[{"\[Theta]", "\[Rule]", 
    RowBox[{"-", 
     FractionBox["1", "2"]}]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522866384*^9, 3.3895616717448*^9, 3.3899894750832*^9,
   3.3899909498996*^9, 3.3899911897866*^9, 3.3907337339026003`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->None,
WindowSize->{1577, 1027},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Visible->True,
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
CommonDefaultFormatTypes->{"TextInline"->StandardForm},
InputAliases->{"intt" -> RowBox[{"\[Integral]", 
     RowBox[{"\[SelectionPlaceholder]", 
       RowBox[{"\[DifferentialD]", "\[Placeholder]"}]}]}], "dintt" -> 
  RowBox[{
     SubsuperscriptBox[
     "\[Integral]", "\[SelectionPlaceholder]", "\[Placeholder]"], 
     RowBox[{"\[Placeholder]", 
       RowBox[{"\[DifferentialD]", "\[Placeholder]"}]}]}], "sumt" -> RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"\[SelectionPlaceholder]", "=", "\[Placeholder]"}], 
      "\[Placeholder]"], "\[Placeholder]"}], "prodt" -> RowBox[{
     UnderoverscriptBox["\[Product]", 
      RowBox[{"\[SelectionPlaceholder]", "=", "\[Placeholder]"}], 
      "\[Placeholder]"], "\[Placeholder]"}], "dt" -> RowBox[{
     SubscriptBox["\[PartialD]", "\[Placeholder]"], " ", 
     "\[SelectionPlaceholder]"}], "L" -> "\[ScriptCapitalL]", "notation" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], " ", 
       "\[DoubleLongLeftRightArrow]", " ", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "notation>" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], " ", 
       "\[DoubleLongRightArrow]", " ", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "notation<" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], " ", 
       "\[DoubleLongLeftArrow]", " ", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "symb" -> 
  RowBox[{"Symbolize", "[", 
     TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], "]"}], 
  "infixnotation" -> RowBox[{"InfixNotation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], ",", 
       "\[Placeholder]"}], "]"}], "addia" -> RowBox[{"AddInputAlias", "[", 
     RowBox[{"\"\[SelectionPlaceholder]\"", "\[Rule]", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "pattwraper" -> 
  TagBox["\[SelectionPlaceholder]", "NotationPatternTag"], "madeboxeswraper" -> 
  TagBox["\[SelectionPlaceholder]", "NotationMadeBoxesTag"], "E" -> 
  "\[ScriptCapitalE]"},
Magnification->1.5,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->"EMMStyle02.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Ch4Ex3period"->{
  Cell[36531, 1193, 89, 2, 65, "Subsection",
   CellTags->"Ch4Ex3period"]},
 "Ch4ExCorrq"->{
  Cell[59379, 2000, 87, 2, 65, "Subsection",
   CellTags->"Ch4ExCorrq"]},
 "Ch4ExCorrup"->{
  Cell[72705, 2453, 88, 2, 65, "Subsection",
   CellTags->"Ch4ExCorrup"]},
 "Ch8Ex1"->{
  Cell[151184, 5226, 83, 2, 65, "Subsection",
   CellTags->"Ch8Ex1"]},
 "Ch8Ex2"->{
  Cell[151526, 5240, 83, 2, 65, "Subsection",
   CellTags->"Ch8Ex2"]},
 "Ch8Ex3"->{
  Cell[154206, 5348, 83, 2, 65, "Subsection",
   CellTags->"Ch8Ex3"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Ch4Ex3period", 192706, 6641},
 {"Ch4ExCorrq", 192799, 6644},
 {"Ch4ExCorrup", 192891, 6647},
 {"Ch8Ex1", 192979, 6650},
 {"Ch8Ex2", 193063, 6653},
 {"Ch8Ex3", 193147, 6656}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 1023, 26, 430, "Title"],
Cell[CellGroupData[{
Cell[1638, 53, 410, 9, 43, "Input"],
Cell[2051, 64, 770, 16, 51, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2858, 85, 60, 1, 92, "Section"],
Cell[2921, 88, 192, 4, 43, "Input"],
Cell[3116, 94, 208, 5, 32, "Text"],
Cell[3327, 101, 369, 12, 43, "Input"],
Cell[3699, 115, 141, 1, 32, "Text"],
Cell[3843, 118, 452, 14, 76, "Input"],
Cell[4298, 134, 344, 7, 55, "Text"],
Cell[4645, 143, 213, 6, 43, "Input"],
Cell[4861, 151, 2149, 56, 210, "Input"],
Cell[7013, 209, 206, 4, 43, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7256, 218, 69, 1, 92, "Section"],
Cell[CellGroupData[{
Cell[7350, 223, 56, 1, 65, "Subsection"],
Cell[CellGroupData[{
Cell[7431, 228, 1208, 39, 129, "Input"],
Cell[8642, 269, 463, 13, 38, "Output"]
}, Open  ]],
Cell[9120, 285, 320, 11, 33, "Text"],
Cell[CellGroupData[{
Cell[9465, 300, 225, 6, 48, "Input"],
Cell[9693, 308, 946, 28, 43, "Output"]
}, Open  ]],
Cell[10654, 339, 194, 4, 32, "Text"],
Cell[10851, 345, 1437, 37, 193, "Input"],
Cell[12291, 384, 281, 7, 43, "Input"],
Cell[12575, 393, 382, 10, 33, "Text"],
Cell[CellGroupData[{
Cell[12982, 407, 570, 13, 48, "Input"],
Cell[13555, 422, 410, 9, 41, "Output"]
}, Open  ]],
Cell[13980, 434, 312, 12, 33, "Text"],
Cell[CellGroupData[{
Cell[14317, 450, 369, 9, 43, "Input"],
Cell[14689, 461, 1648, 57, 43, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16374, 523, 603, 15, 43, "Input"],
Cell[16980, 540, 311, 6, 41, "Output"]
}, Open  ]],
Cell[17306, 549, 84, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[17415, 554, 580, 14, 43, "Input"],
Cell[17998, 570, 275, 5, 38, "Output"]
}, Open  ]],
Cell[18288, 578, 58, 1, 32, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18395, 585, 102, 1, 92, "Section"],
Cell[CellGroupData[{
Cell[18522, 590, 70, 1, 65, "Subsection"],
Cell[18595, 593, 229, 7, 43, "Input"],
Cell[18827, 602, 302, 11, 33, "Text"],
Cell[CellGroupData[{
Cell[19154, 617, 667, 20, 75, "Input"],
Cell[19824, 639, 1185, 33, 69, "Output"]
}, Open  ]],
Cell[21024, 675, 120, 3, 32, "Text"],
Cell[CellGroupData[{
Cell[21169, 682, 223, 6, 43, "Input"],
Cell[21395, 690, 667, 18, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22099, 713, 236, 7, 48, "Input"],
Cell[22338, 722, 2061, 58, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24436, 785, 322, 10, 48, "Input"],
Cell[24761, 797, 2272, 66, 113, "Output"]
}, Open  ]],
Cell[27048, 866, 96, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[27169, 871, 333, 10, 43, "Input"],
Cell[27505, 883, 1117, 30, 67, "Output"]
}, Open  ]],
Cell[28637, 916, 89, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[28751, 921, 85, 2, 43, "Input"],
Cell[28839, 925, 1941, 56, 74, "Output"]
}, Open  ]],
Cell[30795, 984, 178, 6, 34, "Text"],
Cell[CellGroupData[{
Cell[30998, 994, 713, 24, 90, "Input"],
Cell[31714, 1020, 257, 4, 38, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[32020, 1030, 70, 1, 65, "Subsection"],
Cell[32093, 1033, 89, 1, 32, "Text"],
Cell[32185, 1036, 362, 11, 45, "Input"],
Cell[32550, 1049, 388, 14, 33, "Text"],
Cell[CellGroupData[{
Cell[32963, 1067, 323, 11, 43, "Input"],
Cell[33289, 1080, 563, 16, 41, "Output"]
}, Open  ]],
Cell[33867, 1099, 83, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[33975, 1104, 391, 13, 43, "Input"],
Cell[34369, 1119, 728, 22, 41, "Output"]
}, Open  ]],
Cell[35112, 1144, 101, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[35238, 1149, 299, 10, 48, "Input"],
Cell[35540, 1161, 942, 26, 41, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[36531, 1193, 89, 2, 65, "Subsection",
 CellTags->"Ch4Ex3period"],
Cell[36623, 1197, 192, 7, 33, "Text"],
Cell[36818, 1206, 471, 16, 43, "Input"],
Cell[37292, 1224, 99, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[37416, 1229, 594, 16, 71, "Input"],
Cell[38013, 1247, 1987, 60, 187, "Output"]
}, Open  ]],
Cell[40015, 1310, 91, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[40131, 1315, 1327, 39, 98, "Input"],
Cell[41461, 1356, 1919, 53, 187, "Output"]
}, Open  ]],
Cell[43395, 1412, 85, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[43505, 1417, 548, 15, 71, "Input"],
Cell[44056, 1434, 2125, 65, 281, "Output"]
}, Open  ]],
Cell[46196, 1502, 85, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[46306, 1507, 126, 3, 43, "Input"],
Cell[46435, 1512, 265, 5, 38, "Output"]
}, Open  ]],
Cell[46715, 1520, 336, 14, 33, "Text"],
Cell[CellGroupData[{
Cell[47076, 1538, 826, 26, 71, "Input"],
Cell[47905, 1566, 2251, 69, 187, "Output"]
}, Open  ]],
Cell[50171, 1638, 194, 9, 33, "Text"],
Cell[CellGroupData[{
Cell[50390, 1651, 173, 5, 43, "Input"],
Cell[50566, 1658, 298, 7, 38, "Output"]
}, Open  ]],
Cell[50879, 1668, 216, 9, 33, "Text"],
Cell[CellGroupData[{
Cell[51120, 1681, 317, 11, 43, "Input"],
Cell[51440, 1694, 668, 19, 44, "Output"]
}, Open  ]],
Cell[52123, 1716, 420, 17, 33, "Text"],
Cell[CellGroupData[{
Cell[52568, 1737, 441, 15, 43, "Input"],
Cell[53012, 1754, 581, 16, 41, "Output"]
}, Open  ]],
Cell[53608, 1773, 283, 12, 33, "Text"],
Cell[CellGroupData[{
Cell[53916, 1789, 206, 7, 43, "Input"],
Cell[54125, 1798, 613, 18, 57, "Output"]
}, Open  ]],
Cell[54753, 1819, 200, 7, 33, "Text"],
Cell[CellGroupData[{
Cell[54978, 1830, 144, 4, 43, "Input"],
Cell[55125, 1836, 345, 8, 38, "Output"]
}, Open  ]],
Cell[55485, 1847, 73, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[55583, 1852, 154, 5, 43, "Input"],
Cell[55740, 1859, 363, 9, 38, "Output"]
}, Open  ]],
Cell[56118, 1871, 167, 7, 33, "Text"],
Cell[CellGroupData[{
Cell[56310, 1882, 373, 13, 43, "Input"],
Cell[56686, 1897, 253, 5, 38, "Output"]
}, Open  ]],
Cell[56954, 1905, 131, 6, 33, "Text"],
Cell[CellGroupData[{
Cell[57110, 1915, 288, 10, 48, "Input"],
Cell[57401, 1927, 257, 5, 38, "Output"]
}, Open  ]],
Cell[57673, 1935, 469, 16, 37, "Text"],
Cell[CellGroupData[{
Cell[58167, 1955, 410, 14, 48, "Input"],
Cell[58580, 1971, 545, 16, 41, "Output"]
}, Open  ]],
Cell[59140, 1990, 202, 5, 43, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[59379, 2000, 87, 2, 65, "Subsection",
 CellTags->"Ch4ExCorrq"],
Cell[59469, 2004, 57, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[59551, 2009, 1208, 39, 129, "Input"],
Cell[60762, 2050, 469, 13, 38, "Output"]
}, Open  ]],
Cell[61246, 2066, 282, 11, 33, "Text"],
Cell[61531, 2079, 1676, 46, 163, "Input"],
Cell[63210, 2127, 368, 10, 43, "Input"],
Cell[63581, 2139, 126, 3, 32, "Text"],
Cell[CellGroupData[{
Cell[63732, 2146, 247, 6, 48, "Input"],
Cell[63982, 2154, 1058, 31, 44, "Output"]
}, Open  ]],
Cell[65055, 2188, 132, 4, 32, "Text"],
Cell[CellGroupData[{
Cell[65212, 2196, 287, 7, 43, "Input"],
Cell[65502, 2205, 522, 14, 41, "Output"]
}, Open  ]],
Cell[66039, 2222, 257, 10, 33, "Text"],
Cell[CellGroupData[{
Cell[66321, 2236, 325, 9, 43, "Input"],
Cell[66649, 2247, 1714, 58, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[68400, 2310, 556, 15, 43, "Input"],
Cell[68959, 2327, 412, 11, 41, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[69408, 2343, 524, 15, 43, "Input"],
Cell[69935, 2360, 347, 8, 41, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[70319, 2373, 532, 15, 43, "Input"],
Cell[70854, 2390, 305, 6, 38, "Output"]
}, Open  ]],
Cell[71174, 2399, 343, 14, 35, "Text"],
Cell[CellGroupData[{
Cell[71542, 2417, 838, 24, 60, "Input"],
Cell[72383, 2443, 273, 4, 38, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[72705, 2453, 88, 2, 65, "Subsection",
 CellTags->"Ch4ExCorrup"],
Cell[72796, 2457, 50, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[72871, 2462, 1208, 39, 129, "Input"],
Cell[74082, 2503, 457, 13, 38, "Output"]
}, Open  ]],
Cell[74554, 2519, 112, 2, 32, "Text"],
Cell[74669, 2523, 1733, 46, 222, "Input"],
Cell[76405, 2571, 368, 10, 43, "Input"],
Cell[CellGroupData[{
Cell[76798, 2585, 426, 11, 48, "Input"],
Cell[77227, 2598, 447, 10, 41, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[77711, 2613, 501, 14, 43, "Input"],
Cell[78215, 2629, 395, 10, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[78647, 2644, 505, 14, 43, "Input"],
Cell[79155, 2660, 258, 4, 38, "Output"]
}, Open  ]],
Cell[79428, 2667, 343, 14, 35, "Text"],
Cell[CellGroupData[{
Cell[79796, 2685, 845, 24, 60, "Input"],
Cell[80644, 2711, 257, 4, 38, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[80962, 2722, 81, 1, 92, "Section"],
Cell[81046, 2725, 91, 1, 32, "Text"],
Cell[81140, 2728, 294, 9, 71, "Input"],
Cell[CellGroupData[{
Cell[81459, 2741, 66, 1, 65, "Subsection"],
Cell[CellGroupData[{
Cell[81550, 2746, 962, 32, 72, "Input"],
Cell[82515, 2780, 1322, 41, 79, "Output"]
}, Open  ]],
Cell[83852, 2824, 64, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[83941, 2829, 511, 16, 43, "Input"],
Cell[84455, 2847, 1109, 33, 55, "Output"]
}, Open  ]],
Cell[85579, 2883, 197, 8, 33, "Text"],
Cell[CellGroupData[{
Cell[85801, 2895, 830, 24, 73, "Input"],
Cell[86634, 2921, 505, 15, 38, "Output"]
}, Open  ]],
Cell[87154, 2939, 251, 10, 33, "Text"],
Cell[CellGroupData[{
Cell[87430, 2953, 273, 7, 48, "Input"],
Cell[87706, 2962, 1459, 42, 44, "Output"]
}, Open  ]],
Cell[89180, 3007, 404, 11, 43, "Input"],
Cell[CellGroupData[{
Cell[89609, 3022, 405, 10, 48, "Input"],
Cell[90017, 3034, 432, 10, 41, "Output"]
}, Open  ]],
Cell[90464, 3047, 297, 11, 33, "Text"],
Cell[CellGroupData[{
Cell[90786, 3062, 493, 12, 43, "Input"],
Cell[91282, 3076, 326, 8, 41, "Output"]
}, Open  ]],
Cell[91623, 3087, 297, 11, 33, "Text"],
Cell[CellGroupData[{
Cell[91945, 3102, 485, 12, 43, "Input"],
Cell[92433, 3116, 230, 4, 38, "Output"]
}, Open  ]],
Cell[92678, 3123, 132, 4, 32, "Text"],
Cell[CellGroupData[{
Cell[92835, 3131, 756, 23, 48, "Input"],
Cell[93594, 3156, 1252, 36, 65, "Output"]
}, Open  ]],
Cell[94861, 3195, 315, 10, 34, "Text"],
Cell[95179, 3207, 142, 4, 32, "Text"],
Cell[95324, 3213, 224, 7, 34, "Text"],
Cell[95551, 3222, 217, 9, 34, "Text"],
Cell[CellGroupData[{
Cell[95793, 3235, 309, 8, 48, "Input"],
Cell[96105, 3245, 327, 7, 41, "Output"]
}, Open  ]],
Cell[96447, 3255, 57, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[96529, 3260, 267, 9, 43, "Input"],
Cell[96799, 3271, 319, 7, 41, "Output"]
}, Open  ]],
Cell[97133, 3281, 62, 1, 32, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[97232, 3287, 112, 2, 65, "Subsection"],
Cell[97347, 3291, 1892, 67, 102, "Text"],
Cell[99242, 3360, 1151, 43, 81, "Text"],
Cell[100396, 3405, 1492, 57, 102, "Text"],
Cell[CellGroupData[{
Cell[101913, 3466, 509, 18, 48, "Input"],
Cell[102425, 3486, 2301, 57, 41, "Output"]
}, Open  ]],
Cell[104741, 3546, 1777, 66, 88, "Text"],
Cell[106521, 3614, 391, 13, 57, "Text"],
Cell[106915, 3629, 412, 12, 33, "Text"],
Cell[CellGroupData[{
Cell[107352, 3645, 675, 21, 48, "Input"],
Cell[108030, 3668, 1112, 32, 69, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[109179, 3705, 417, 11, 43, "Input"],
Cell[109599, 3718, 1636, 48, 119, "Output"]
}, Open  ]],
Cell[111250, 3769, 58, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[111333, 3774, 368, 11, 48, "Input"],
Cell[111704, 3787, 452, 13, 62, "Output"]
}, Open  ]],
Cell[112171, 3803, 432, 16, 58, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[112640, 3824, 205, 9, 66, "Subsection"],
Cell[112848, 3835, 453, 19, 34, "Text"],
Cell[CellGroupData[{
Cell[113326, 3858, 64, 1, 44, "Subsubsection"],
Cell[113393, 3861, 1451, 58, 58, "Text"],
Cell[114847, 3921, 1994, 63, 177, "Text"],
Cell[CellGroupData[{
Cell[116866, 3988, 428, 13, 48, "Input"],
Cell[117297, 4003, 3885, 104, 142, "Output"]
}, Open  ]],
Cell[121197, 4110, 168, 5, 43, "Input"],
Cell[121368, 4117, 260, 9, 37, "Text"],
Cell[CellGroupData[{
Cell[121653, 4130, 482, 14, 48, "Input"],
Cell[122138, 4146, 890, 26, 57, "Output"]
}, Open  ]],
Cell[123043, 4175, 127, 3, 32, "Text"],
Cell[CellGroupData[{
Cell[123195, 4182, 483, 14, 48, "Input"],
Cell[123681, 4198, 214, 4, 41, "Output"]
}, Open  ]],
Cell[123910, 4205, 391, 11, 38, "Text"],
Cell[CellGroupData[{
Cell[124326, 4220, 483, 14, 48, "Input"],
Cell[124812, 4236, 627, 19, 57, "Output"]
}, Open  ]],
Cell[125454, 4258, 213, 8, 34, "Text"],
Cell[CellGroupData[{
Cell[125692, 4270, 351, 11, 48, "Input"],
Cell[126046, 4283, 190, 3, 38, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[126297, 4293, 111, 2, 65, "Subsection"],
Cell[126411, 4297, 341, 10, 43, "Input"],
Cell[CellGroupData[{
Cell[126777, 4311, 76, 1, 44, "Subsubsection"],
Cell[126856, 4314, 1045, 33, 81, "Input"],
Cell[127904, 4349, 115, 3, 32, "Text"],
Cell[CellGroupData[{
Cell[128044, 4356, 170, 5, 43, "Input"],
Cell[128217, 4363, 639, 19, 41, "Output"]
}, Open  ]],
Cell[128871, 4385, 75, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[128971, 4390, 178, 5, 43, "Input"],
Cell[129152, 4397, 393, 11, 78, "Output"]
}, Open  ]],
Cell[129560, 4411, 168, 7, 33, "Text"],
Cell[129731, 4420, 473, 16, 48, "Input"],
Cell[130207, 4438, 259, 9, 34, "Text"],
Cell[CellGroupData[{
Cell[130491, 4451, 249, 8, 43, "Input"],
Cell[130743, 4461, 747, 22, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[131527, 4488, 87, 2, 43, "Input"],
Cell[131617, 4492, 905, 26, 41, "Output"]
}, Open  ]],
Cell[132537, 4521, 109, 5, 33, "Text"],
Cell[CellGroupData[{
Cell[132671, 4530, 124, 3, 43, "Input"],
Cell[132798, 4535, 989, 32, 38, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[133836, 4573, 58, 1, 44, "Subsubsection"],
Cell[133897, 4576, 398, 15, 78, "Text"],
Cell[134298, 4593, 75, 1, 32, "Text"],
Cell[134376, 4596, 232, 9, 33, "Text"],
Cell[134611, 4607, 313, 10, 46, "Input"],
Cell[134927, 4619, 198, 6, 33, "Text"],
Cell[CellGroupData[{
Cell[135150, 4629, 214, 6, 43, "Input"],
Cell[135367, 4637, 397, 11, 78, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[135813, 4654, 64, 1, 44, "Subsubsection"],
Cell[135880, 4657, 186, 9, 32, "Text"],
Cell[CellGroupData[{
Cell[136091, 4670, 239, 7, 43, "Input"],
Cell[136333, 4679, 407, 11, 78, "Output"]
}, Open  ]],
Cell[136755, 4693, 287, 13, 33, "Text"],
Cell[CellGroupData[{
Cell[137067, 4710, 407, 13, 79, "Input"],
Cell[137477, 4725, 549, 16, 78, "Output"]
}, Open  ]],
Cell[138041, 4744, 60, 1, 32, "Text"],
Cell[138104, 4747, 95, 3, 43, "Input"],
Cell[CellGroupData[{
Cell[138224, 4754, 407, 13, 79, "Input"],
Cell[138634, 4769, 1645, 53, 38, "Output"]
}, Open  ]],
Cell[140294, 4825, 72, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[140391, 4830, 332, 10, 43, "Input"],
Cell[140726, 4842, 1374, 44, 38, "Output"]
}, Open  ]],
Cell[142115, 4889, 460, 15, 33, "Text"],
Cell[CellGroupData[{
Cell[142600, 4908, 235, 7, 45, "Input"],
Cell[142838, 4917, 802, 25, 38, "Output"]
}, Open  ]],
Cell[143655, 4945, 95, 1, 32, "Text"],
Cell[143753, 4948, 1170, 34, 79, "Input"],
Cell[CellGroupData[{
Cell[144948, 4986, 125, 4, 43, "Input"],
Cell[145076, 4992, 798, 25, 38, "Output"]
}, Open  ]],
Cell[145889, 5020, 193, 6, 33, "Text"],
Cell[CellGroupData[{
Cell[146107, 5030, 631, 22, 43, "Input"],
Cell[146741, 5054, 423, 11, 38, "Output"]
}, Open  ]],
Cell[147179, 5068, 313, 15, 34, "Text"],
Cell[CellGroupData[{
Cell[147517, 5087, 242, 7, 45, "Input"],
Cell[147762, 5096, 474, 12, 41, "Output"]
}, Open  ]],
Cell[148251, 5111, 71, 1, 32, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[148359, 5117, 184, 8, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[148568, 5129, 277, 10, 43, "Input"],
Cell[148848, 5141, 796, 25, 38, "Output"]
}, Open  ]],
Cell[149659, 5169, 148, 6, 34, "Text"],
Cell[CellGroupData[{
Cell[149832, 5179, 473, 14, 45, "Input"],
Cell[150308, 5195, 745, 21, 44, "Output"]
}, Open  ]],
Cell[151068, 5219, 67, 1, 32, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[151184, 5226, 83, 2, 65, "Subsection",
 CellTags->"Ch8Ex1"],
Cell[151270, 5230, 219, 5, 32, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[151526, 5240, 83, 2, 65, "Subsection",
 CellTags->"Ch8Ex2"],
Cell[151612, 5244, 789, 28, 33, "Text"],
Cell[152404, 5274, 212, 7, 43, "Input"],
Cell[152619, 5283, 665, 25, 34, "Text"],
Cell[CellGroupData[{
Cell[153309, 5312, 129, 4, 45, "Input"],
Cell[153441, 5318, 238, 5, 58, "Output"]
}, Open  ]],
Cell[153694, 5326, 475, 17, 34, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[154206, 5348, 83, 2, 65, "Subsection",
 CellTags->"Ch8Ex3"],
Cell[154292, 5352, 70, 1, 32, "Text"],
Cell[154365, 5355, 219, 7, 45, "Input"],
Cell[154587, 5364, 235, 7, 45, "Input"],
Cell[154825, 5373, 65, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[154915, 5378, 256, 8, 57, "Input"],
Cell[155174, 5388, 203, 3, 38, "Output"]
}, Open  ]],
Cell[155392, 5394, 57, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[155474, 5399, 277, 8, 57, "Input"],
Cell[155754, 5409, 207, 3, 38, "Output"]
}, Open  ]],
Cell[155976, 5415, 58, 1, 32, "Text"],
Cell[156037, 5418, 171, 6, 33, "Text"],
Cell[156211, 5426, 585, 19, 84, "Input"],
Cell[156799, 5447, 56, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[156880, 5452, 283, 9, 43, "Input"],
Cell[157166, 5463, 279, 6, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[157482, 5474, 577, 19, 97, "Input"],
Cell[158062, 5495, 204, 3, 38, "Output"]
}, Open  ]],
Cell[158281, 5501, 74, 1, 32, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[158392, 5507, 62, 1, 65, "Subsection"],
Cell[158457, 5510, 752, 26, 126, "Text"],
Cell[159212, 5538, 405, 15, 33, "Text"],
Cell[159620, 5555, 1616, 53, 165, "Text"],
Cell[161239, 5610, 737, 26, 59, "Text"],
Cell[CellGroupData[{
Cell[162001, 5640, 61, 1, 44, "Subsubsection"],
Cell[162065, 5643, 222, 7, 43, "Input"],
Cell[162290, 5652, 804, 29, 101, "Input"],
Cell[163097, 5683, 135, 6, 33, "Text"],
Cell[CellGroupData[{
Cell[163257, 5693, 415, 15, 43, "Input"],
Cell[163675, 5710, 368, 10, 38, "Output"]
}, Open  ]],
Cell[164058, 5723, 91, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[164174, 5728, 231, 7, 45, "Input"],
Cell[164408, 5737, 275, 6, 41, "Output"]
}, Open  ]],
Cell[164698, 5746, 58, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[164781, 5751, 830, 24, 73, "Input"],
Cell[165614, 5777, 564, 18, 38, "Output"]
}, Open  ]],
Cell[166193, 5798, 229, 9, 33, "Text"],
Cell[CellGroupData[{
Cell[166447, 5811, 345, 9, 48, "Input"],
Cell[166795, 5822, 416, 10, 41, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[167248, 5837, 257, 7, 45, "Input"],
Cell[167508, 5846, 412, 10, 41, "Output"]
}, Open  ]],
Cell[167935, 5859, 297, 11, 33, "Text"],
Cell[CellGroupData[{
Cell[168257, 5874, 425, 11, 43, "Input"],
Cell[168685, 5887, 302, 8, 41, "Output"]
}, Open  ]],
Cell[169002, 5898, 297, 11, 33, "Text"],
Cell[CellGroupData[{
Cell[169324, 5913, 425, 11, 43, "Input"],
Cell[169752, 5926, 214, 4, 38, "Output"]
}, Open  ]],
Cell[169981, 5933, 132, 4, 32, "Text"],
Cell[CellGroupData[{
Cell[170138, 5941, 756, 23, 48, "Input"],
Cell[170897, 5966, 1225, 35, 65, "Output"]
}, Open  ]],
Cell[172137, 6004, 218, 9, 34, "Text"],
Cell[CellGroupData[{
Cell[172380, 6017, 309, 8, 48, "Input"],
Cell[172692, 6027, 292, 6, 41, "Output"]
}, Open  ]],
Cell[172999, 6036, 412, 12, 33, "Text"],
Cell[CellGroupData[{
Cell[173436, 6052, 675, 21, 48, "Input"],
Cell[174114, 6075, 1132, 32, 69, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[175283, 6112, 417, 11, 43, "Input"],
Cell[175703, 6125, 1652, 48, 119, "Output"]
}, Open  ]],
Cell[177370, 6176, 58, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[177453, 6181, 428, 13, 48, "Input"],
Cell[177884, 6196, 3967, 106, 141, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[181888, 6307, 148, 4, 43, "Input"],
Cell[182039, 6313, 1972, 54, 74, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[184048, 6372, 352, 10, 48, "Input"],
Cell[184403, 6384, 1246, 38, 57, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[185686, 6427, 299, 9, 48, "Input"],
Cell[185988, 6438, 303, 7, 41, "Output"]
}, Open  ]],
Cell[186306, 6448, 178, 6, 33, "Text"],
Cell[CellGroupData[{
Cell[186509, 6458, 488, 15, 48, "Input"],
Cell[187000, 6475, 588, 17, 57, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[187625, 6497, 592, 18, 48, "Input"],
Cell[188220, 6517, 203, 3, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[188460, 6525, 518, 16, 48, "Input"],
Cell[188981, 6543, 333, 9, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[189351, 6557, 231, 7, 45, "Input"],
Cell[189585, 6566, 409, 10, 56, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
