(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   3052744,      54195]
NotebookOptionsPosition[   3037664,      53718]
NotebookOutlinePosition[   3040993,      53804]
CellTagsIndexPosition[   3040793,      53795]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "SequentialTrade\n",
 StyleBox["Empirical Market Microstructure",
  FontSlant->"Italic"],
 " \n\t(2006, Oxford University Press)\nCompanion ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook\n\nJoel Hasbrouck\n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Copyright", " ", "2007"}], ",", " ", 
    RowBox[{"Joel", " ", 
     RowBox[{"Hasbrouck", ".", " ", "All"}], " ", "rights", " ", 
     RowBox[{"reserved", "."}]}]}], TraditionalForm]],
  FontSize->14,
  FontSlant->"Italic"],
 "\n",
 StyleBox["This notebook covers material related to sequential trade models \
(Chapters 5 and 6)",
  FontSize->14]
}], "Title",
 CellChangeTimes->{{3.3896255910914*^9, 3.3896255932033997`*^9}, {
   3.3897167078988237`*^9, 3.389716768500824*^9}, 3.3897219191158237`*^9, {
   3.3897220399168243`*^9, 3.3897220640418243`*^9}, {3.389735393500024*^9, 
   3.389735431148024*^9}, 3.389735530878024*^9, 3.3897355723880243`*^9, {
   3.389735664464024*^9, 3.3897356860350237`*^9}, {3.3899891508672*^9, 
   3.3899891819161997`*^9}, {3.3899914301996*^9, 3.3899914551656*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Text", "  ", "@", " ", 
  RowBox[{"Style", "[", 
   RowBox[{
    RowBox[{"\"\<Notebook evaluated \>\"", "<>", 
     RowBox[{"DateString", "[", "\"\<DateTime\>\"", "]"}]}], ",", 
    "\"\<Subtitle\>\""}], "]"}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896127180972*^9, 3.3896127205282*^9}, 
   3.389716999411824*^9, {3.3897170351038237`*^9, 3.389717047196824*^9}}],

Cell[BoxData[
 InterpretationBox[Cell[BoxData[
   StyleBox["\<\"Notebook evaluated Monday 4 June 2007 20:18:09\"\>", 
    "Subtitle",
    StripOnInput->False]], "Text", "TR"],
  Text[
   Style["Notebook evaluated Monday 4 June 2007 20:18:09", 
    "Subtitle"]]]], "Output",
 CellMargins->{{18, Inherited}, {Inherited, 0}},
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896127211071997`*^9, {3.3896127536242*^9, 3.3896127555652*^9}, 
   3.3896128616452*^9, 3.389623031447*^9, 3.3896232934164*^9, 
   3.389716955274824*^9, 3.3897170008718243`*^9, {3.3897170377738237`*^9, 
   3.3897170482808237`*^9}, 3.389735230721224*^9, 3.3899894613552*^9, 
   3.3899897610886*^9, 3.3899911755866003`*^9, 3.3899914898976*^9},
 Background->RGBColor[0.866667, 0.733333, 1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Preliminaries", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "SetDirectory", "[", 
   "\"\<c:/Active/Empirical Market Microstructure/Mathematica/Spring \
2007\>\"", "]"}], ";"}]], "Input",
 CellAutoOverwrite->False,
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3881708634346*^9, 3.3881708734596*^9}, {
  3.3881710728336*^9, 3.3881711170716*^9}, {3.389524702079319*^9, 
  3.389524702676319*^9}}],

Cell[TextData[{
 "The ",
 Cell[BoxData["Trees"]],
 " package contains various routines for working with decision trees. See the \
notebook ",
 Cell[BoxData[
  RowBox[{"Trees", " ", 
   RowBox[{"Demo", ".", "nb"}]}]]],
 " for documentation and examples."
}], "Text"],

Cell[BoxData[
 StyleBox[
  RowBox[{"<<", "Trees.m"}], "Input"]], "Input",
 CellLabel->"In[159]:="],

Cell[CellGroupData[{

Cell["Other initializations", "Subsection"],

Cell[BoxData[
 RowBox[{"<<", "PlotLegends`"}]], "Input",
 CellChangeTimes->{{3.3896137404351997`*^9, 3.3896137460622*^9}},
 CellLabel->"In[160]:="],

Cell[BoxData[
 RowBox[{"<<", "Notation`"}]], "Input",
 CellChangeTimes->{{3.3895618301518*^9, 3.3895618319028*^9}, {
  3.3896128213212*^9, 3.3896128249952*^9}},
 CellLabel->"In[161]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["Anything_", "Rule"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";", 
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["Anything_", "Rules"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";"}]], "Input",
 CellLabel->"In[162]:="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Basic one-period problem", "Section"],

Cell[CellGroupData[{

Cell["Event tree", "Subsection"],

Cell["\<\
Functional representation of tree. (If you want to see how this is \
constructed, apply the rules one at a time.)\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LabelTree", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"V", ",", "VLo", ",", "VHi"}], "}"}], "/.", 
      RowBox[{
       RowBox[{"x", ":", 
        RowBox[{"VLo", "|", "VHi"}]}], "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{"x", ",", "Inf", ",", "U"}], "}"}]}]}], "/.", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"VLo", ",", "Inf", ",", "a_"}], "}"}], "\[RuleDelayed]", 
      RowBox[{"{", 
       RowBox[{"VLo", ",", 
        RowBox[{"{", 
         RowBox[{"Inf", ",", "S"}], "}"}], ",", "a"}], "}"}]}]}], "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"VHi", ",", "Inf", ",", "a_"}], "}"}], "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"VHi", ",", 
       RowBox[{"{", 
        RowBox[{"Inf", ",", "B"}], "}"}], ",", "a"}], "}"}]}]}], "/.", 
   RowBox[{"U", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"U", ",", "B", ",", "S"}], "}"}]}]}]}]], "Input",
 CellLabel->"In[163]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"V", ",", 
   RowBox[{"{", 
    RowBox[{"VLo", ",", 
     RowBox[{"{", 
      RowBox[{"Inf", ",", "S"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"U", ",", "B", ",", "S"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"VHi", ",", 
     RowBox[{"{", 
      RowBox[{"Inf", ",", "B"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"U", ",", "B", ",", "S"}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.3896128623742*^9, 3.3896138204648*^9, 
  3.3899914923366003`*^9},
 CellLabel->"Out[163]="]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData["ShowTree"]],
 " command renders a tree in a more intuitive layout. In the following \
diagram, a node can branch to the right and (if there is more than one \
alternative) to the right and down."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShowTree", "[", "LabelTree", "]"}]], "Input",
 CellLabel->"In[164]:="],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      TagBox[GridBox[{
         {"V"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"VLo"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"Inf"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"S"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"U"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"B"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"S"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"VHi"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"Inf"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"B"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"U"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"B"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"S"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.35]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {{
         Offset[0.2]}}, "RowsIndexed" -> {}}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, TableAlignments -> {Left, Top}, TableSpacing -> {0.5, 0.5}]]],
  
  DisplayForm]], "Output",
 CellChangeTimes->{3.3896128624192*^9, 3.3896138205148*^9, 
  3.3899914923966*^9},
 CellLabel->"Out[164]//DisplayForm="]
}, Open  ]],

Cell[TextData[{
 "Construct a new tree, ",
 Cell[BoxData["PrTree"]],
 ", which as the same form as ",
 Cell[BoxData["LabelTree"]],
 ", but in which all nodes are replaced by their conditional probabilities."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"PrTree", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"LabelTree", "/.", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"U", ",", "B", ",", "S"}], "}"}], "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"U", ",", 
              RowBox[{"1", "/", "2"}], ",", 
              RowBox[{"1", "/", "2"}]}], "}"}]}]}], "/.", 
          RowBox[{"S", "\[Rule]", "1"}]}], "/.", 
         RowBox[{"B", "\[Rule]", "1"}]}], "/.", 
        RowBox[{"Inf", "\[Rule]", "\[Mu]"}]}], "/.", 
       RowBox[{"U", "\[Rule]", 
        RowBox[{"1", "-", "\[Mu]"}]}]}], "/.", 
      RowBox[{"VLo", "\[Rule]", "\[Delta]"}]}], "/.", 
     RowBox[{"VHi", "\[Rule]", 
      RowBox[{"1", "-", "\[Delta]"}]}]}], "/.", 
    RowBox[{"V", "\[Rule]", "1"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"BasicTree", "=", 
   RowBox[{"BuildTree", "[", 
    RowBox[{"LabelTree", ",", "PrTree"}], "]"}]}], ";"}], "\n", 
 RowBox[{"ShowTree", "[", "BasicTree", "]"}]}], "Input",
 CellLabel->"In[165]:="],

Cell[BoxData[
 TagBox[
  InterpretationBox[GridBox[{
     {
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"V"},
           {"1"},
           {"1"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"VLo"},
           {"\[Delta]"},
           {"\[Delta]"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"Inf"},
           {"\[Mu]"},
           {
            RowBox[{"\[Delta]", " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {"1"},
           {
            RowBox[{"\[Delta]", " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"U"},
           {
            RowBox[{"1", "-", "\[Mu]"}]},
           {
            RowBox[{"\[Delta]", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {
            FractionBox["1", "2"]},
           {
            RowBox[{
             FractionBox["1", "2"], " ", "\[Delta]", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {
            FractionBox["1", "2"]},
           {
            RowBox[{
             FractionBox["1", "2"], " ", "\[Delta]", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"VHi"},
           {
            RowBox[{"1", "-", "\[Delta]"}]},
           {
            RowBox[{"1", "-", "\[Delta]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"Inf"},
           {"\[Mu]"},
           {
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {"1"},
           {
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"U"},
           {
            RowBox[{"1", "-", "\[Mu]"}]},
           {
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {
            FractionBox["1", "2"]},
           {
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {
            FractionBox["1", "2"]},
           {
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.35]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {{
         Offset[0.2]}}, "RowsIndexed" -> {}}],
   TableForm[{{
      FrameBox[
       TableForm[{$CellContext`V, 1, 1}]], 
      FrameBox[
       TableForm[{$CellContext`VLo, $CellContext`\[Delta], $CellContext`\
\[Delta]}]], 
      FrameBox[
       TableForm[{$CellContext`Inf, $CellContext`\[Mu], $CellContext`\[Delta] \
$CellContext`\[Mu]}]], 
      FrameBox[
       TableForm[{$CellContext`S, 
         1, $CellContext`\[Delta] $CellContext`\[Mu]}]]}, {{" ", " ", " "}, {
      " ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`U, 
         1 - $CellContext`\[Mu], $CellContext`\[Delta] (
          1 - $CellContext`\[Mu])}]], 
      FrameBox[
       TableForm[{$CellContext`B, 
         Rational[1, 2], 
         Rational[1, 2] $CellContext`\[Delta] (1 - $CellContext`\[Mu])}]]}, {{
      " ", " ", " "}, {" ", " ", " "}, {" ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`S, 
         Rational[1, 2], 
         Rational[1, 2] $CellContext`\[Delta] (1 - $CellContext`\[Mu])}]]}, {{
      " ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`VHi, 1 - $CellContext`\[Delta], 
         1 - $CellContext`\[Delta]}]], 
      FrameBox[
       TableForm[{$CellContext`Inf, $CellContext`\[Mu], (
          1 - $CellContext`\[Delta]) $CellContext`\[Mu]}]], 
      FrameBox[
       TableForm[{$CellContext`B, 
         1, (1 - $CellContext`\[Delta]) $CellContext`\[Mu]}]]}, {{
      " ", " ", " "}, {" ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`U, 
         1 - $CellContext`\[Mu], (1 - $CellContext`\[Delta]) (
          1 - $CellContext`\[Mu])}]], 
      FrameBox[
       TableForm[{$CellContext`B, 
         Rational[1, 2], 
         Rational[1, 2] (1 - $CellContext`\[Delta]) (
          1 - $CellContext`\[Mu])}]]}, {{" ", " ", " "}, {" ", " ", " "}, {
      " ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`S, 
         Rational[1, 2], 
         Rational[1, 2] (1 - $CellContext`\[Delta]) (
          1 - $CellContext`\[Mu])}]]}}, TableAlignments -> {Left, Top}, 
    TableSpacing -> {0.5, 0.5}]],
  DisplayForm]], "Output",
 CellChangeTimes->{3.3896128624792*^9, 3.3896138205828*^9, 
  3.3899914924786*^9},
 CellLabel->"Out[167]//DisplayForm="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Conditional probabilities", "Subsection"],

Cell["\<\
Verify that terminal probabilities (buy or sell nodes) add up to 1. \
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Pr", "[", 
   RowBox[{"BasicTree", ",", "S"}], "]"}], "+", 
  RowBox[{"Pr", "[", 
   RowBox[{"BasicTree", ",", "B"}], "]"}]}]], "Input",
 CellLabel->"In[168]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", "\[Mu]"}], ")"}]}], "+", 
  RowBox[{"\[Delta]", " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", "\[Mu]"}], ")"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", "\[Mu]"}], "+", 
  RowBox[{"\[Delta]", " ", "\[Mu]"}]}]], "Output",
 CellChangeTimes->{3.3896128625202*^9, 3.3896138206198*^9, 
  3.3899914925316*^9},
 CellLabel->"Out[168]="]
}, Open  ]],

Cell["... and simplify:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Simplify"}]], "Input",
 CellLabel->"In[169]:="],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{3.3896128625741997`*^9, 3.3896138206618*^9, 
  3.3899914925846*^9},
 CellLabel->"Out[169]="]
}, Open  ]],

Cell[TextData[{
 "The probability of ",
 Cell[BoxData["B"]],
 " is:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Pr", "[", 
   RowBox[{"BasicTree", ",", "B"}], "]"}], "//", "Simplify"}]], "Input",
 CellLabel->"In[170]:="],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "\[Mu]", "-", 
    RowBox[{"2", " ", "\[Delta]", " ", "\[Mu]"}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.3896128626102*^9, 3.3896138206998*^9, 
  3.3899914926396*^9},
 CellLabel->"Out[170]="]
}, Open  ]],

Cell[TextData[{
 "The probability of a ",
 Cell[BoxData["VLo"]],
 " value realization AND a ",
 Cell[BoxData["B"]],
 " is:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Pr", "[", 
   RowBox[{"BasicTree", ",", "VLo", ",", "B"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[171]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "2"]}], " ", "\[Delta]", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "\[Mu]"}], ")"}]}]], "Output",
 CellChangeTimes->{3.3896128626472*^9, 3.3896138207388*^9, 
  3.3899914926946*^9},
 CellLabel->"Out[171]="]
}, Open  ]],

Cell[TextData[{
 "So using Bayes' rule, the revised ",
 Cell[BoxData["\[Delta]"]],
 " conditional on a buy is ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Pr", "[", 
    RowBox[{"VLo", "|", "B"}], "]"}], "="}]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Delta]B", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Pr", "[", 
     RowBox[{"BasicTree", ",", "VLo", ",", "B"}], "]"}], "/", 
    RowBox[{"Pr", "[", 
     RowBox[{"BasicTree", ",", "B"}], "]"}]}], "//", "Simplify"}]}]], "Input",\

 CellLabel->"In[172]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[Delta]", "-", 
   RowBox[{"\[Delta]", " ", "\[Mu]"}]}], 
  RowBox[{"1", "+", "\[Mu]", "-", 
   RowBox[{"2", " ", "\[Delta]", " ", "\[Mu]"}]}]]], "Output",
 CellChangeTimes->{3.3896128627092*^9, 3.3896138207858*^9, 
  3.3899914927606*^9},
 CellLabel->"Out[172]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["\[PartialD]", "\[Mu]"], " ", "\[Delta]B"}], "<", "0"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0", "<", "\[Mu]", "<", "1"}], ",", 
     RowBox[{"0", "<", "\[Delta]", "<", "1"}], ",", 
     RowBox[{"VHi", ">", "VLo"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[173]:="],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.3896128627892*^9, 3.3896138208338003`*^9, 
  3.3899914928336*^9},
 CellLabel->"Out[173]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ask", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"\[Delta]B", " ", "VLo"}], " ", "+", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "\[Delta]B"}], ")"}], " ", "VHi"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[174]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"VLo", " ", "\[Delta]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Mu]"}], ")"}]}], "+", 
   RowBox[{"VHi", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Delta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Mu]"}], ")"}]}]}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "\[Delta]"}]}], ")"}], " ", "\[Mu]"}]}]]], "Output",
 CellChangeTimes->{3.3896128628402*^9, 3.3896138208768*^9, 
  3.3899914928976*^9},
 CellLabel->"Out[174]="]
}, Open  ]],

Cell[TextData[{
 "NOTE: Equation (5.2), p. 45 should read: ",
 Cell[BoxData[
  RowBox[{"A", "=", 
   RowBox[{
    RowBox[{"E", "[", 
     RowBox[{"V", "|", "Buy"}], "]"}], "=", 
    FractionBox[
     RowBox[{
      RowBox[{
       UnderscriptBox["V", "\[HorizontalLine]"], 
       RowBox[{"(", 
        RowBox[{"1", "-", "\[Mu]"}], ")"}], "\[Delta]"}], "+", 
      RowBox[{
       OverscriptBox["V", "\[HorizontalLine]"], 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Mu]"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"1", "-", "\[Delta]"}], ")"}]}]}], 
     RowBox[{"1", "+", 
      RowBox[{"\[Mu]", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", "\[Delta]"}]}], ")"}]}]}]]}]}]]]
}], "Text"],

Cell[TextData[{
 "The revised ",
 Cell[BoxData["\[Delta]"]],
 " conditional on an incoming sell is:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Delta]S", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Pr", "[", 
     RowBox[{"BasicTree", ",", "VLo", ",", "S"}], "]"}], "/", 
    RowBox[{"Pr", "[", 
     RowBox[{"BasicTree", ",", "S"}], "]"}]}], "//", "Simplify"}]}]], "Input",\

 CellLabel->"In[175]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[Delta]", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "\[Mu]"}], ")"}]}], 
  RowBox[{"1", "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "\[Delta]"}]}], ")"}], " ", "\[Mu]"}]}]]], "Output",
 CellChangeTimes->{3.3896128628802*^9, 3.3896138209288*^9, 
  3.3899914929586*^9},
 CellLabel->"Out[175]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Bid", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"\[Delta]S", " ", "VLo"}], " ", "+", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "\[Delta]S"}], ")"}], " ", "VHi"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[176]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"VHi", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Delta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Mu]"}], ")"}]}], "+", 
   RowBox[{"VLo", " ", "\[Delta]", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Mu]"}], ")"}]}]}], 
  RowBox[{"1", "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "\[Delta]"}]}], ")"}], " ", "\[Mu]"}]}]]], "Output",
 CellChangeTimes->{3.3896128629292*^9, 3.3896138209698*^9, 
  3.3899914930246*^9},
 CellLabel->"Out[176]="]
}, Open  ]],

Cell[TextData[{
 "NOTE: Equation (5.6), p. 46 should read: ",
 Cell[BoxData[
  RowBox[{"B", "=", 
   RowBox[{
    RowBox[{"E", "[", 
     RowBox[{"V", "|", "Sell"}], "]"}], "=", 
    FractionBox[
     RowBox[{
      RowBox[{
       UnderscriptBox["V", "\[HorizontalLine]"], 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Mu]"}], ")"}], "\[Delta]"}], "+", 
      RowBox[{
       OverscriptBox["V", "\[HorizontalLine]"], 
       RowBox[{"(", 
        RowBox[{"1", "-", "\[Mu]"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"1", "-", "\[Delta]"}], ")"}]}]}], 
     RowBox[{"1", "-", 
      RowBox[{"\[Mu]", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", "\[Delta]"}]}], ")"}]}]}]]}]}]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Ask", "-", "Bid"}], "//", "Simplify"}]], "Input",
 CellLabel->"In[177]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"4", " ", 
   RowBox[{"(", 
    RowBox[{"VHi", "-", "VLo"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "\[Delta]"}], ")"}], " ", "\[Delta]", " ", 
   "\[Mu]"}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"2", " ", "\[Delta]"}]}], ")"}], "2"], " ", 
    SuperscriptBox["\[Mu]", "2"]}]}]]], "Output",
 CellChangeTimes->{3.3896128629832*^9, 3.3896138210288*^9, 
  3.3899914931106*^9},
 CellLabel->"Out[177]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"\[Delta]", "\[Rule]", 
   RowBox[{"1", "/", "2"}]}]}]], "Input",
 CellLabel->"In[178]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"VHi", "-", "VLo"}], ")"}], " ", "\[Mu]"}]], "Output",
 CellChangeTimes->{3.3896128630271997`*^9, 3.3896138210657997`*^9, 
  3.3899914931605997`*^9},
 CellLabel->"Out[178]="]
}, Open  ]],

Cell[TextData[{
 "Consider an attempt at manipulation by buying at the ask (the cash flow is \
",
 Cell[BoxData[
  RowBox[{"-", "Ask"}]]],
 ") and then selling at the (revised) bid.:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Profits", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"-", "Ask"}], "+", " ", 
    RowBox[{"(", 
     RowBox[{"Bid", "/.", 
      RowBox[{"\[Delta]", "\[Rule]", "\[Delta]B"}]}], ")"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[179]:="],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"VHi", "-", "VLo"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Delta]"}], ")"}], " ", "\[Delta]", " ", 
    "\[Mu]"}], 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"2", " ", "\[Delta]"}]}], ")"}], " ", "\[Mu]"}]}]]}]], "Output",\

 CellChangeTimes->{3.3896128630832*^9, 3.3896138211177998`*^9, 
  3.3899914932276*^9},
 CellLabel->"Out[179]="]
}, Open  ]],

Cell[TextData[{
 "Test whether ",
 Cell[BoxData["Profits"]],
 " can be positive, given the parameter restrictions:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Profits", ">", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0", "<", "\[Mu]", "<", "1"}], ",", 
     RowBox[{"0", "<", "\[Delta]", "<", "1"}], ",", 
     RowBox[{"VHi", ">", "VLo"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[180]:="],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.3896128631401997`*^9, 3.3896138211717997`*^9, 
  3.3899914933146*^9},
 CellLabel->"Out[180]="]
}, Open  ]],

Cell["\<\
There is no manipulation profit even with no informed trading in the unwind:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"-", "Ask"}], "+", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Bid", "/.", 
      RowBox[{"\[Mu]", "\[Rule]", "0"}]}], "/.", 
     RowBox[{"\[Delta]", "\[Rule]", "\[Delta]B"}]}], ")"}]}], "]"}]], "Input",\

 CellLabel->"In[181]:="],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.3896128631752*^9, 3.3896138212098*^9, 
  3.3899914933786*^9},
 CellLabel->"Out[181]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Exercise 5.1 (Different \[Mu]s for different brokers)\
\>", "Subsection",
 CellTags->"SeqTrade1"],

Cell[CellGroupData[{

Cell[BoxData["Ask"], "Input",
 CellLabel->"In[182]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"VLo", " ", "\[Delta]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Mu]"}], ")"}]}], "+", 
   RowBox[{"VHi", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Delta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Mu]"}], ")"}]}]}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "\[Delta]"}]}], ")"}], " ", "\[Mu]"}]}]]], "Output",
 CellChangeTimes->{3.3896128632142*^9, 3.3896138212528*^9, 
  3.3899914934316*^9},
 CellLabel->"Out[182]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Ask", "/.", 
   RowBox[{"\[Delta]", "\[Rule]", 
    RowBox[{"1", "/", "2"}]}]}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[183]:="],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"VHi", "+", "VLo", "+", 
    RowBox[{"VHi", " ", "\[Mu]"}], "-", 
    RowBox[{"VLo", " ", "\[Mu]"}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.3896128634462*^9, 3.3896138213578*^9, 
  3.3899914935326*^9},
 CellLabel->"Out[183]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["Profits", "b"], "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"Ask", "/.", 
       RowBox[{"\[Mu]", "\[Rule]", 
        SubscriptBox["\[Mu]", "Other"]}]}], ")"}], "-", 
     RowBox[{"(", 
      RowBox[{"Ask", "/.", 
       RowBox[{"\[Mu]", "\[Rule]", 
        SubscriptBox["\[Mu]", "b"]}]}], ")"}]}], "/.", 
    RowBox[{"\[Delta]", "\[Rule]", 
     RowBox[{"1", "/", "2"}]}]}], "//", "FullSimplify"}]}]], "Input",
 CellLabel->"In[184]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "2"]}], " ", 
  RowBox[{"(", 
   RowBox[{"VHi", "-", "VLo"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SubscriptBox["\[Mu]", "b"], "-", 
    SubscriptBox["\[Mu]", "Other"]}], ")"}]}]], "Output",
 CellChangeTimes->{3.3896128635042*^9, 3.3896138214138002`*^9, 
  3.3899914936286*^9},
 CellLabel->"Out[184]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    SubscriptBox["Profits", "b"], ">", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0", "<", 
      SubscriptBox["\[Mu]", "b"], "<", "1"}], ",", 
     RowBox[{"0", "<", 
      SubscriptBox["\[Mu]", "Other"], "<", "1"}], ",", 
     RowBox[{
      SubscriptBox["\[Mu]", "b"], "<", 
      SubscriptBox["\[Mu]", "Other"]}], ",", 
     RowBox[{"VHi", ">", "VLo"}], ",", 
     RowBox[{"0", "<", "\[Delta]", "<", "1"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[185]:="],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.3896128635472*^9, 3.3896138214508*^9, 
  3.3899914936846*^9},
 CellLabel->"Out[185]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5.2 (Informed trading only in low state)", "Subsection",
 CellTags->"SeqTrade2"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"LabelTree", "=", 
   RowBox[{"{", 
    RowBox[{"V", ",", 
     RowBox[{"{", 
      RowBox[{"VLo", ",", 
       RowBox[{"{", 
        RowBox[{"In", ",", "S"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Un", ",", "B", ",", "S"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"VHi", ",", 
       RowBox[{"{", 
        RowBox[{"Un", ",", "B", ",", "S"}], "}"}]}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"LabelTree", "//", "ShowTree"}]}], "Input",
 CellLabel->"In[186]:="],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      TagBox[GridBox[{
         {"V"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"VLo"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"In"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"S"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"Un"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"B"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"S"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"VHi"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"Un"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"B"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"S"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.35]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {{
         Offset[0.2]}}, "RowsIndexed" -> {}}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, TableAlignments -> {Left, Top}, TableSpacing -> {0.5, 0.5}]]],
  
  DisplayForm]], "Output",
 CellChangeTimes->{3.3896128635931997`*^9, 3.3896138215067997`*^9, 
  3.3899914937586*^9},
 CellLabel->"Out[187]//DisplayForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"PrTree", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"LabelTree", "/.", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"VLo", ",", 
              RowBox[{"{", 
               RowBox[{"In", ",", "S"}], "}"}], ",", "a_"}], "}"}], 
            "\[RuleDelayed]", 
            RowBox[{"{", 
             RowBox[{"VLo", ",", 
              RowBox[{"{", 
               RowBox[{"In", ",", "1"}], "}"}], ",", "a"}], "}"}]}]}], "/.", 
          RowBox[{
           RowBox[{"B", "|", "S"}], "\[Rule]", 
           RowBox[{"1", "/", "2"}]}]}], "/.", 
         RowBox[{"In", "\[Rule]", "\[Mu]"}]}], "/.", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"VHi", ",", 
           RowBox[{"{", 
            RowBox[{"Un", ",", "a__"}], "}"}]}], "}"}], "\[RuleDelayed]", 
         RowBox[{"{", 
          RowBox[{"VHi", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "a"}], "}"}]}], "}"}]}]}], "/.", 
       RowBox[{"Un", "\[Rule]", 
        RowBox[{"1", "-", "\[Mu]"}]}]}], "/.", 
      RowBox[{"VLo", "\[Rule]", "\[Delta]"}]}], "/.", 
     RowBox[{"VHi", "\[Rule]", 
      RowBox[{"1", "-", "\[Delta]"}]}]}], "/.", 
    RowBox[{"V", "\[Rule]", "1"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExTree", "=", 
   RowBox[{"BuildTree", "[", 
    RowBox[{"LabelTree", ",", "PrTree"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ShowTree", "[", "ExTree", "]"}]}], "Input",
 CellLabel->"In[188]:="],

Cell[BoxData[
 TagBox[
  InterpretationBox[GridBox[{
     {
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"V"},
           {"1"},
           {"1"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"VLo"},
           {"\[Delta]"},
           {"\[Delta]"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"In"},
           {"\[Mu]"},
           {
            RowBox[{"\[Delta]", " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {"1"},
           {
            RowBox[{"\[Delta]", " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"Un"},
           {
            RowBox[{"1", "-", "\[Mu]"}]},
           {
            RowBox[{"\[Delta]", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {
            FractionBox["1", "2"]},
           {
            RowBox[{
             FractionBox["1", "2"], " ", "\[Delta]", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {
            FractionBox["1", "2"]},
           {
            RowBox[{
             FractionBox["1", "2"], " ", "\[Delta]", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"VHi"},
           {
            RowBox[{"1", "-", "\[Delta]"}]},
           {
            RowBox[{"1", "-", "\[Delta]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"Un"},
           {"1"},
           {
            RowBox[{"1", "-", "\[Delta]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {
            FractionBox["1", "2"]},
           {
            FractionBox[
             RowBox[{"1", "-", "\[Delta]"}], "2"]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {
            FractionBox["1", "2"]},
           {
            FractionBox[
             RowBox[{"1", "-", "\[Delta]"}], "2"]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.35]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {{
         Offset[0.2]}}, "RowsIndexed" -> {}}],
   TableForm[{{
      FrameBox[
       TableForm[{$CellContext`V, 1, 1}]], 
      FrameBox[
       TableForm[{$CellContext`VLo, $CellContext`\[Delta], $CellContext`\
\[Delta]}]], 
      FrameBox[
       TableForm[{
        In, $CellContext`\[Mu], $CellContext`\[Delta] $CellContext`\[Mu]}]], 
      FrameBox[
       TableForm[{$CellContext`S, 
         1, $CellContext`\[Delta] $CellContext`\[Mu]}]]}, {{" ", " ", " "}, {
      " ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`Un, 
         1 - $CellContext`\[Mu], $CellContext`\[Delta] (
          1 - $CellContext`\[Mu])}]], 
      FrameBox[
       TableForm[{$CellContext`B, 
         Rational[1, 2], 
         Rational[1, 2] $CellContext`\[Delta] (1 - $CellContext`\[Mu])}]]}, {{
      " ", " ", " "}, {" ", " ", " "}, {" ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`S, 
         Rational[1, 2], 
         Rational[1, 2] $CellContext`\[Delta] (1 - $CellContext`\[Mu])}]]}, {{
      " ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`VHi, 1 - $CellContext`\[Delta], 
         1 - $CellContext`\[Delta]}]], 
      FrameBox[
       TableForm[{$CellContext`Un, 1, 1 - $CellContext`\[Delta]}]], 
      FrameBox[
       TableForm[{$CellContext`B, 
         Rational[1, 2], Rational[1, 2] (1 - $CellContext`\[Delta])}]]}, {{
      " ", " ", " "}, {" ", " ", " "}, {" ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`S, 
         Rational[1, 2], Rational[1, 2] (1 - $CellContext`\[Delta])}]]}}, 
    TableAlignments -> {Left, Top}, TableSpacing -> {0.5, 0.5}]],
  DisplayForm]], "Output",
 CellChangeTimes->{3.3896128636512003`*^9, 3.3896138215608*^9, 
  3.3899914938566*^9},
 CellLabel->"Out[190]//DisplayForm="]
}, Open  ]],

Cell["Verify that terminal node total probabilities add up to one:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Pr", "[", 
    RowBox[{"ExTree", ",", "B"}], "]"}], "+", 
   RowBox[{"Pr", "[", 
    RowBox[{"ExTree", ",", "S"}], "]"}]}], "//", "Simplify"}]], "Input",
 CellLabel->"In[191]:="],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{3.3896128636892*^9, 3.3896138215987997`*^9, 
  3.3899914939096003`*^9},
 CellLabel->"Out[191]="]
}, Open  ]],

Cell[TextData[{
 "Conditional on a buy, the revised ",
 Cell[BoxData["\[Delta]"]],
 " is:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Delta]B", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Pr", "[", 
     RowBox[{"ExTree", ",", "VLo", ",", "B"}], "]"}], "/", 
    RowBox[{"Pr", "[", 
     RowBox[{"ExTree", ",", "B"}], "]"}]}], "//", "Simplify"}]}]], "Input",
 CellLabel->"In[192]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[Delta]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "\[Mu]"}], ")"}]}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{"\[Delta]", " ", "\[Mu]"}]}]]], "Output",
 CellChangeTimes->{3.3896128637402*^9, 3.3896138216338*^9, 
  3.3899914939656*^9},
 CellLabel->"Out[192]="]
}, Open  ]],

Cell["Conditional on a sell ...", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Delta]S", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Pr", "[", 
     RowBox[{"ExTree", ",", "VLo", ",", "S"}], "]"}], "/", 
    RowBox[{"Pr", "[", 
     RowBox[{"ExTree", ",", "S"}], "]"}]}], "//", "Simplify"}]}]], "Input",
 CellLabel->"In[193]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[Delta]", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "\[Mu]"}], ")"}]}], 
  RowBox[{"1", "+", 
   RowBox[{"\[Delta]", " ", "\[Mu]"}]}]]], "Output",
 CellChangeTimes->{3.3896128637762003`*^9, 3.3896138216728*^9, 
  3.3899914941846*^9},
 CellLabel->"Out[193]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ask", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"\[Delta]B", " ", "VLo"}], " ", "+", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "\[Delta]B"}], ")"}], " ", "VHi"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[194]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"VHi", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Delta]"}], ")"}]}], "+", 
   RowBox[{"VLo", " ", "\[Delta]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Mu]"}], ")"}]}]}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{"\[Delta]", " ", "\[Mu]"}]}]]], "Output",
 CellChangeTimes->{3.3896128638152*^9, 3.3896138217228003`*^9, 
  3.3899914942516003`*^9},
 CellLabel->"Out[194]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Bid", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"\[Delta]S", " ", "VLo"}], " ", "+", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "\[Delta]S"}], ")"}], " ", "VHi"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[195]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"VHi", "-", 
   RowBox[{"VHi", " ", "\[Delta]"}], "+", 
   RowBox[{"VLo", " ", "\[Delta]", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Mu]"}], ")"}]}]}], 
  RowBox[{"1", "+", 
   RowBox[{"\[Delta]", " ", "\[Mu]"}]}]]], "Output",
 CellChangeTimes->{3.3896128638652*^9, 3.3896138217588*^9, 
  3.3899914943146*^9},
 CellLabel->"Out[195]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"\[Delta]S", "/.", 
   RowBox[{"\[Delta]", "\[Rule]", "\[Delta]B"}]}], "]"}]], "Input",
 CellLabel->"In[196]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[Delta]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "\[Mu]"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "\[Mu]"}], ")"}]}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{"\[Delta]", " ", 
    SuperscriptBox["\[Mu]", "2"]}]}]]], "Output",
 CellChangeTimes->{3.3896128639062*^9, 3.3896138217948*^9, 
  3.3899914943726*^9},
 CellLabel->"Out[196]="]
}, Open  ]],

Cell["\<\
Manipulation by buying at the ask and selling at the revised bid? Nope.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "Ask"}], " ", "+", " ", "Bid"}], "/.", 
      RowBox[{"\[Delta]", "\[Rule]", "\[Delta]B"}]}], ")"}], ">", "0"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0", "<", "\[Mu]", "<", "1"}], ",", 
     RowBox[{"0", "<", "\[Delta]", "<", "1"}], ",", 
     RowBox[{"VHi", ">", "VLo"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[197]:="],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.3896128640671997`*^9, 3.3896138219328003`*^9, 
  3.3899914946736*^9},
 CellLabel->"Out[197]="]
}, Open  ]],

Cell["\<\
Manipulation by selling at the bid and buying at the revised ask? Nope.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Bid", " ", "-", " ", "Ask"}], "/.", 
      RowBox[{"\[Delta]", "\[Rule]", "\[Delta]S"}]}], ")"}], ">", "0"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0", "<", "\[Mu]", "<", "1"}], ",", 
     RowBox[{"0", "<", "\[Delta]", "<", "1"}], ",", 
     RowBox[{"VHi", ">", "VLo"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[198]:="],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.3896128642162*^9, 3.3896138220748*^9, 
  3.3899914949716*^9},
 CellLabel->"Out[198]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5.3 (Informed traders get a signal)", "Subsection",
 CellTags->"SeqTrade3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LabelTree", "=", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"V", ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"VLo", ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"In", ",", 
         RowBox[{"{", 
          RowBox[{"SLo", ",", "S"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"SHi", ",", "B"}], "}"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"Un", ",", "B", ",", "S"}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"VHi", ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"In", ",", 
         RowBox[{"{", 
          RowBox[{"SLo", ",", "S"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"SHi", ",", "B"}], "}"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"Un", ",", "B", ",", "S"}], "}"}]}], "}"}]}], 
    "\[IndentingNewLine]", "}"}]}], ";", 
  RowBox[{"LabelTree", "//", "ShowTree"}]}]], "Input",
 CellLabel->"In[199]:="],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      TagBox[GridBox[{
         {"V"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"VLo"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"In"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"SLo"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"S"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"SHi"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"B"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"Un"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"B"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"S"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"VHi"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"In"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"SLo"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"S"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"SHi"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"B"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"Un"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"B"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"S"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.35]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {{
         Offset[0.2]}}, "RowsIndexed" -> {}}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, TableAlignments -> {Left, Top}, TableSpacing -> {0.5, 0.5}]]],
  
  DisplayForm]], "Output",
 CellChangeTimes->{3.3896128642782*^9, 3.3896138221238003`*^9, 
  3.3899914950886*^9},
 CellLabel->"Out[199]//DisplayForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"PrTree", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"LabelTree", "/.", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"VLo", ",", 
              RowBox[{"{", 
               RowBox[{"In", ",", 
                RowBox[{"{", 
                 RowBox[{"SLo", ",", "S"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"SHi", ",", "B"}], "}"}]}], "}"}], ",", "a_"}], 
             "}"}], ":>", 
            RowBox[{"{", 
             RowBox[{"VLo", ",", 
              RowBox[{"{", 
               RowBox[{"In", ",", 
                RowBox[{"{", 
                 RowBox[{"\[Gamma]", ",", "1"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"1", "-", "\[Gamma]"}], ",", "1"}], "}"}]}], "}"}], 
              ",", "a"}], "}"}]}]}], "/.", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"VHi", ",", 
             RowBox[{"{", 
              RowBox[{"In", ",", 
               RowBox[{"{", 
                RowBox[{"SLo", ",", "S"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"SHi", ",", "B"}], "}"}]}], "}"}], ",", "a_"}], "}"}],
            ":>", 
           RowBox[{"{", 
            RowBox[{"VHi", ",", 
             RowBox[{"{", 
              RowBox[{"In", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"1", "-", "\[Gamma]"}], ",", "1"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"\[Gamma]", ",", "1"}], "}"}]}], "}"}], ",", "a"}], 
            "}"}]}]}], "/.", 
         RowBox[{
          RowBox[{"B", "|", "S"}], "\[Rule]", 
          RowBox[{"1", "/", "2"}]}]}], "/.", 
        RowBox[{"In", "\[Rule]", "\[Mu]"}]}], "/.", 
       RowBox[{"Un", "\[Rule]", 
        RowBox[{"1", "-", "\[Mu]"}]}]}], "/.", 
      RowBox[{"VLo", "\[Rule]", "\[Delta]"}]}], "/.", 
     RowBox[{"VHi", "\[Rule]", 
      RowBox[{"1", "-", "\[Delta]"}]}]}], "/.", 
    RowBox[{"V", "\[Rule]", "1"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExTree", "=", 
   RowBox[{"BuildTree", "[", 
    RowBox[{"LabelTree", ",", "PrTree"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ShowTree", "[", "ExTree", "]"}]}], "Input",
 CellLabel->"In[200]:="],

Cell[BoxData[
 TagBox[
  InterpretationBox[GridBox[{
     {
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"V"},
           {"1"},
           {"1"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"VLo"},
           {"\[Delta]"},
           {"\[Delta]"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"In"},
           {"\[Mu]"},
           {
            RowBox[{"\[Delta]", " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"SLo"},
           {"\[Gamma]"},
           {
            RowBox[{"\[Gamma]", " ", "\[Delta]", " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {"1"},
           {
            RowBox[{"\[Gamma]", " ", "\[Delta]", " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"SHi"},
           {
            RowBox[{"1", "-", "\[Gamma]"}]},
           {
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Gamma]"}], ")"}], " ", "\[Delta]", " ", 
             "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {"1"},
           {
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Gamma]"}], ")"}], " ", "\[Delta]", " ", 
             "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"Un"},
           {
            RowBox[{"1", "-", "\[Mu]"}]},
           {
            RowBox[{"\[Delta]", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {
            FractionBox["1", "2"]},
           {
            RowBox[{
             FractionBox["1", "2"], " ", "\[Delta]", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {
            FractionBox["1", "2"]},
           {
            RowBox[{
             FractionBox["1", "2"], " ", "\[Delta]", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"VHi"},
           {
            RowBox[{"1", "-", "\[Delta]"}]},
           {
            RowBox[{"1", "-", "\[Delta]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"In"},
           {"\[Mu]"},
           {
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"SLo"},
           {
            RowBox[{"1", "-", "\[Gamma]"}]},
           {
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Gamma]"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {"1"},
           {
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Gamma]"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"SHi"},
           {"\[Gamma]"},
           {
            RowBox[{"\[Gamma]", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {"1"},
           {
            RowBox[{"\[Gamma]", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"Un"},
           {
            RowBox[{"1", "-", "\[Mu]"}]},
           {
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {
            FractionBox["1", "2"]},
           {
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {
            FractionBox["1", "2"]},
           {
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.35]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {{
         Offset[0.2]}}, "RowsIndexed" -> {}}],
   TableForm[{{
      FrameBox[
       TableForm[{$CellContext`V, 1, 1}]], 
      FrameBox[
       TableForm[{$CellContext`VLo, $CellContext`\[Delta], $CellContext`\
\[Delta]}]], 
      FrameBox[
       TableForm[{
        In, $CellContext`\[Mu], $CellContext`\[Delta] $CellContext`\[Mu]}]], 
      FrameBox[
       TableForm[{$CellContext`SLo, $CellContext`\[Gamma], $CellContext`\
\[Gamma] $CellContext`\[Delta] $CellContext`\[Mu]}]], 
      FrameBox[
       TableForm[{$CellContext`S, 
         1, $CellContext`\[Gamma] $CellContext`\[Delta] \
$CellContext`\[Mu]}]]}, {{" ", " ", " "}, {" ", " ", " "}, {" ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`SHi, 
         1 - $CellContext`\[Gamma], (
          1 - $CellContext`\[Gamma]) $CellContext`\[Delta] \
$CellContext`\[Mu]}]], 
      FrameBox[
       TableForm[{$CellContext`B, 
         1, (1 - $CellContext`\[Gamma]) $CellContext`\[Delta] $CellContext`\
\[Mu]}]]}, {{" ", " ", " "}, {" ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`Un, 
         1 - $CellContext`\[Mu], $CellContext`\[Delta] (
          1 - $CellContext`\[Mu])}]], 
      FrameBox[
       TableForm[{$CellContext`B, 
         Rational[1, 2], 
         Rational[1, 2] $CellContext`\[Delta] (1 - $CellContext`\[Mu])}]], {
      " ", " ", " "}}, {{" ", " ", " "}, {" ", " ", " "}, {" ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`S, 
         Rational[1, 2], 
         Rational[1, 2] $CellContext`\[Delta] (1 - $CellContext`\[Mu])}]], {
      " ", " ", " "}}, {{" ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`VHi, 1 - $CellContext`\[Delta], 
         1 - $CellContext`\[Delta]}]], 
      FrameBox[
       TableForm[{
        In, $CellContext`\[Mu], (
          1 - $CellContext`\[Delta]) $CellContext`\[Mu]}]], 
      FrameBox[
       TableForm[{$CellContext`SLo, 
         1 - $CellContext`\[Gamma], (1 - $CellContext`\[Gamma]) (
          1 - $CellContext`\[Delta]) $CellContext`\[Mu]}]], 
      FrameBox[
       TableForm[{$CellContext`S, 
         1, (1 - $CellContext`\[Gamma]) (
          1 - $CellContext`\[Delta]) $CellContext`\[Mu]}]]}, {{
      " ", " ", " "}, {" ", " ", " "}, {" ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`SHi, $CellContext`\[Gamma], $CellContext`\
\[Gamma] (1 - $CellContext`\[Delta]) $CellContext`\[Mu]}]], 
      FrameBox[
       TableForm[{$CellContext`B, 
         1, $CellContext`\[Gamma] (
          1 - $CellContext`\[Delta]) $CellContext`\[Mu]}]]}, {{
      " ", " ", " "}, {" ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`Un, 
         1 - $CellContext`\[Mu], (1 - $CellContext`\[Delta]) (
          1 - $CellContext`\[Mu])}]], 
      FrameBox[
       TableForm[{$CellContext`B, 
         Rational[1, 2], 
         Rational[1, 2] (1 - $CellContext`\[Delta]) (
          1 - $CellContext`\[Mu])}]], {" ", " ", " "}}, {{" ", " ", " "}, {
      " ", " ", " "}, {" ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`S, 
         Rational[1, 2], 
         Rational[1, 2] (1 - $CellContext`\[Delta]) (
          1 - $CellContext`\[Mu])}]], {" ", " ", " "}}}, 
    TableAlignments -> {Left, Top}, TableSpacing -> {0.5, 0.5}]],
  DisplayForm]], "Output",
 CellChangeTimes->{3.3896128643691998`*^9, 3.3896138221878*^9, 
  3.3899914952766*^9},
 CellLabel->"Out[202]//DisplayForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Pr", "[", 
    RowBox[{"ExTree", ",", "B"}], "]"}], "+", 
   RowBox[{"Pr", "[", 
    RowBox[{"ExTree", ",", "S"}], "]"}]}], "//", "Simplify"}]], "Input",
 CellLabel->"In[203]:="],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{3.3896128644161997`*^9, 3.3896138222258*^9, 
  3.3899914953686*^9},
 CellLabel->"Out[203]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Delta]B", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Pr", "[", 
     RowBox[{"ExTree", ",", "VLo", ",", "B"}], "]"}], "/", 
    RowBox[{"Pr", "[", 
     RowBox[{"ExTree", ",", "B"}], "]"}]}], "//", "Simplify"}]}]], "Input",
 CellLabel->"In[204]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[Delta]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", "\[Gamma]"}]}], ")"}], " ", "\[Mu]"}]}], ")"}]}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "\[Gamma]"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "\[Delta]"}]}], ")"}], " ", "\[Mu]"}]}]]], "Output",
 CellChangeTimes->{3.3896128644782*^9, 3.3896138222738*^9, 
  3.3899914954996*^9},
 CellLabel->"Out[204]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Values", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Gamma]", "\[Rule]", ".1"}], ",", 
     RowBox[{"\[Mu]", "\[Rule]", ".2"}], ",", 
     RowBox[{"\[Delta]", "\[Rule]", ".3"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[205]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Delta]B", "/.", "Values"}]], "Input",
 CellLabel->"In[206]:="],

Cell[BoxData["0.3717948717948718`"], "Output",
 CellChangeTimes->{3.3896128645242*^9, 3.3896138223118*^9, 
  3.3899914955986*^9},
 CellLabel->"Out[206]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ask", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"\[Delta]B", " ", "VLo"}], " ", "+", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "\[Delta]B"}], ")"}], " ", "VHi"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[207]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"VLo", " ", "\[Delta]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "\[Gamma]"}]}], ")"}], " ", "\[Mu]"}]}], ")"}]}], 
   "+", 
   RowBox[{"VHi", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Delta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "\[Gamma]"}]}], ")"}], " ", "\[Mu]"}]}], ")"}]}]}],
   
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "\[Gamma]"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "\[Delta]"}]}], ")"}], " ", "\[Mu]"}]}]]], "Output",
 CellChangeTimes->{3.3896128645752*^9, 3.3896138223618*^9, 
  3.3899914956856003`*^9},
 CellLabel->"Out[207]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Delta]S", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Pr", "[", 
     RowBox[{"ExTree", ",", "VLo", ",", "S"}], "]"}], "/", 
    RowBox[{"Pr", "[", 
     RowBox[{"ExTree", ",", "S"}], "]"}]}], "//", "Simplify"}]}]], "Input",
 CellLabel->"In[208]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[Delta]", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", "\[Gamma]"}]}], ")"}], " ", "\[Mu]"}]}], ")"}]}], 
  RowBox[{"1", "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "\[Gamma]"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "\[Delta]"}]}], ")"}], " ", "\[Mu]"}]}]]], "Output",
 CellChangeTimes->{3.3896128646182003`*^9, 3.3896138224018*^9, 
  3.3899914957516003`*^9},
 CellLabel->"Out[208]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Bid1", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"\[Delta]S", " ", "VLo"}], " ", "+", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "\[Delta]S"}], ")"}], " ", "VHi"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[209]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"VHi", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Delta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "\[Gamma]"}]}], ")"}], " ", "\[Mu]"}]}], ")"}]}], 
   "+", 
   RowBox[{"VLo", " ", "\[Delta]", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "\[Gamma]"}]}], ")"}], " ", "\[Mu]"}]}], ")"}]}]}],
   
  RowBox[{"1", "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "\[Gamma]"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "\[Delta]"}]}], ")"}], " ", "\[Mu]"}]}]]], "Output",
 CellChangeTimes->{3.3896128646712*^9, 3.3896138224538*^9, 
  3.3899914958316*^9},
 CellLabel->"Out[209]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"\[Delta]S", "/.", 
   RowBox[{"\[Delta]", "\[Rule]", "\[Delta]B"}]}], "]"}]], "Input",
 CellLabel->"In[210]:="],

Cell[BoxData["\[Delta]"], "Output",
 CellChangeTimes->{3.3896128647122*^9, 3.3896138224888*^9, 
  3.3899914958856*^9},
 CellLabel->"Out[210]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sequences of buys and sells", "Subsection"],

Cell[TextData[{
 Cell[BoxData["\[Delta]Cond"]],
 " returns ",
 Cell[BoxData[
  SubscriptBox["\[Delta]", "k"]]],
 " as a function of ",
 Cell[BoxData[
  SubscriptBox["\[Delta]", 
   RowBox[{"k", "-", "1"}]]]],
 " and the ",
 Cell[BoxData["k"]],
 "th trade (",
 Cell[BoxData["B"]],
 " or ",
 Cell[BoxData["S"]],
 "):"
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Delta]Cond", "Rule"], "=", 
   RowBox[{
    RowBox[{"\[Delta]Cond", "[", 
     RowBox[{"\[Delta]_", ",", "x_"}], "]"}], "\[RuleDelayed]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"x", "===", "B"}], ",", 
      FractionBox[
       RowBox[{"\[Delta]", "-", 
        RowBox[{"\[Delta]", " ", "\[Mu]"}]}], 
       RowBox[{"1", "+", "\[Mu]", "-", 
        RowBox[{"2", " ", "\[Delta]", " ", "\[Mu]"}]}]], ",", 
      FractionBox[
       RowBox[{"\[Delta]", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Mu]"}], ")"}]}], 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"2", " ", "\[Delta]"}]}], ")"}], " ", "\[Mu]"}]}]]}], 
     "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[211]:="],

Cell["\<\
This can be used to obtain the revised \[Delta] for the first trade ...\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Delta]Cond", "[", 
   RowBox[{
    SubscriptBox["\[Delta]", "0"], ",", "S"}], "]"}], "/.", 
  SubscriptBox["\[Delta]Cond", "Rule"]}]], "Input",
 CellLabel->"In[212]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "\[Mu]"}], ")"}], " ", 
   SubscriptBox["\[Delta]", "0"]}], 
  RowBox[{"1", "+", 
   RowBox[{"\[Mu]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", 
       SubscriptBox["\[Delta]", "0"]}]}], ")"}]}]}]]], "Output",
 CellChangeTimes->{3.3896128647762003`*^9, 3.3896138225388002`*^9, 
  3.3899914959625998`*^9},
 CellLabel->"Out[212]="]
}, Open  ]],

Cell["... or a sequence of trades:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{"\[Delta]Cond", ",", 
   SubscriptBox["\[Delta]", "0"], ",", 
   RowBox[{"{", 
    RowBox[{"B", ",", "S"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[213]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\[Delta]", "0"], ",", 
   RowBox[{"\[Delta]Cond", "[", 
    RowBox[{
     SubscriptBox["\[Delta]", "0"], ",", "B"}], "]"}], ",", 
   RowBox[{"\[Delta]Cond", "[", 
    RowBox[{
     RowBox[{"\[Delta]Cond", "[", 
      RowBox[{
       SubscriptBox["\[Delta]", "0"], ",", "B"}], "]"}], ",", "S"}], "]"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.3896128648072*^9, 3.3896138225758*^9, 
  3.3899914960216*^9},
 CellLabel->"Out[213]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "//.", 
   SubscriptBox["\[Delta]Cond", "Rule"]}], "//", "Simplify"}]], "Input",
 CellLabel->"In[214]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\[Delta]", "0"], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Mu]"}], ")"}], " ", 
     SubscriptBox["\[Delta]", "0"]}], 
    RowBox[{
     RowBox[{"-", "1"}], "-", "\[Mu]", "+", 
     RowBox[{"2", " ", "\[Mu]", " ", 
      SubscriptBox["\[Delta]", "0"]}]}]], ",", 
   SubscriptBox["\[Delta]", "0"]}], "}"}]], "Output",
 CellChangeTimes->{3.3896128648431997`*^9, 3.3896138226118*^9, 
  3.3899914960926*^9},
 CellLabel->"Out[214]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["\[PartialD]", "\[Mu]"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\[Delta]Cond", "[", 
        RowBox[{"\[Delta]", ",", "S"}], "]"}], "/.", 
       SubscriptBox["\[Delta]Cond", "Rule"]}], ")"}]}], ">", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0", "<", "\[Delta]", "<", "1"}], ",", 
     RowBox[{"0", "<", "\[Mu]", "<", "1"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[215]:="],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.3896128648901997`*^9, 3.3896138226588*^9, 
  3.3899914961745996`*^9},
 CellLabel->"Out[215]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["\[PartialD]", "\[Mu]"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\[Delta]Cond", "[", 
        RowBox[{"\[Delta]", ",", "B"}], "]"}], "/.", 
       SubscriptBox["\[Delta]Cond", "Rule"]}], ")"}]}], "<", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0", "<", "\[Delta]", "<", "1"}], ",", 
     RowBox[{"0", "<", "\[Mu]", "<", "1"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[216]:="],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.3896128649312*^9, 3.3896138226977997`*^9, 
  3.3899914963126*^9},
 CellLabel->"Out[216]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{"\[Delta]Cond", ",", 
   SubscriptBox["\[Delta]", "0"], ",", 
   RowBox[{"{", 
    RowBox[{"B", ",", "B", ",", "S", ",", "S"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[217]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\[Delta]", "0"], ",", 
   RowBox[{"\[Delta]Cond", "[", 
    RowBox[{
     SubscriptBox["\[Delta]", "0"], ",", "B"}], "]"}], ",", 
   RowBox[{"\[Delta]Cond", "[", 
    RowBox[{
     RowBox[{"\[Delta]Cond", "[", 
      RowBox[{
       SubscriptBox["\[Delta]", "0"], ",", "B"}], "]"}], ",", "B"}], "]"}], 
   ",", 
   RowBox[{"\[Delta]Cond", "[", 
    RowBox[{
     RowBox[{"\[Delta]Cond", "[", 
      RowBox[{
       RowBox[{"\[Delta]Cond", "[", 
        RowBox[{
         SubscriptBox["\[Delta]", "0"], ",", "B"}], "]"}], ",", "B"}], "]"}], 
     ",", "S"}], "]"}], ",", 
   RowBox[{"\[Delta]Cond", "[", 
    RowBox[{
     RowBox[{"\[Delta]Cond", "[", 
      RowBox[{
       RowBox[{"\[Delta]Cond", "[", 
        RowBox[{
         RowBox[{"\[Delta]Cond", "[", 
          RowBox[{
           SubscriptBox["\[Delta]", "0"], ",", "B"}], "]"}], ",", "B"}], 
        "]"}], ",", "S"}], "]"}], ",", "S"}], "]"}]}], "}"}]], "Output",
 CellChangeTimes->{3.3896128649662*^9, 3.3896138227307997`*^9, 
  3.3899914963836*^9},
 CellLabel->"Out[217]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "//.", 
   SubscriptBox["\[Delta]Cond", "Rule"]}], "//", "Simplify"}]], "Input",
 CellLabel->"In[218]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\[Delta]", "0"], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Mu]"}], ")"}], " ", 
     SubscriptBox["\[Delta]", "0"]}], 
    RowBox[{
     RowBox[{"-", "1"}], "-", "\[Mu]", "+", 
     RowBox[{"2", " ", "\[Mu]", " ", 
      SubscriptBox["\[Delta]", "0"]}]}]], ",", 
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "\[Mu]"}], ")"}], "2"], " ", 
     SubscriptBox["\[Delta]", "0"]}], 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "\[Mu]"}], ")"}], "2"], "-", 
     RowBox[{"4", " ", "\[Mu]", " ", 
      SubscriptBox["\[Delta]", "0"]}]}]], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Mu]"}], ")"}], " ", 
     SubscriptBox["\[Delta]", "0"]}], 
    RowBox[{
     RowBox[{"-", "1"}], "-", "\[Mu]", "+", 
     RowBox[{"2", " ", "\[Mu]", " ", 
      SubscriptBox["\[Delta]", "0"]}]}]], ",", 
   SubscriptBox["\[Delta]", "0"]}], "}"}]], "Output",
 CellChangeTimes->{3.3896128650172*^9, 3.3896138227738*^9, 
  3.3899914964756002`*^9},
 CellLabel->"Out[218]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5.4 (Offsetting trades)", "Subsection",
 CellTags->"SeqTrade4"],

Cell["\<\
A sell followed by a buy gives ... (see the analysis of the original problem, \
above).\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FoldList", "[", 
    RowBox[{"\[Delta]Cond", ",", 
     SubscriptBox["\[Delta]", "0"], ",", 
     RowBox[{"{", 
      RowBox[{"S", ",", "B"}], "}"}]}], "]"}], "//.", 
   SubscriptBox["\[Delta]Cond", "Rule"]}], "//", "Simplify"}]], "Input",
 CellLabel->"In[219]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\[Delta]", "0"], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Mu]"}], ")"}], " ", 
     SubscriptBox["\[Delta]", "0"]}], 
    RowBox[{"1", "-", "\[Mu]", "+", 
     RowBox[{"2", " ", "\[Mu]", " ", 
      SubscriptBox["\[Delta]", "0"]}]}]], ",", 
   SubscriptBox["\[Delta]", "0"]}], "}"}]], "Output",
 CellChangeTimes->{3.3896128650572*^9, 3.3896138228087997`*^9, 
  3.3899914965596*^9},
 CellLabel->"Out[219]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"Price Impact\" (section 5.6)", "Subsection"],

Cell["Consider two sells followed by a buy:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FoldList", "[", 
    RowBox[{"\[Delta]Cond", ",", 
     SubscriptBox["\[Delta]", "0"], ",", 
     RowBox[{"{", 
      RowBox[{"S", ",", "S", ",", "B"}], "}"}]}], "]"}], "//.", 
   SubscriptBox["\[Delta]Cond", "Rule"]}], "//", "Simplify"}]], "Input",
 CellLabel->"In[220]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\[Delta]", "0"], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Mu]"}], ")"}], " ", 
     SubscriptBox["\[Delta]", "0"]}], 
    RowBox[{"1", "-", "\[Mu]", "+", 
     RowBox[{"2", " ", "\[Mu]", " ", 
      SubscriptBox["\[Delta]", "0"]}]}]], ",", 
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "\[Mu]"}], ")"}], "2"], " ", 
     SubscriptBox["\[Delta]", "0"]}], 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "\[Mu]"}], ")"}], "2"], "+", 
     RowBox[{"4", " ", "\[Mu]", " ", 
      SubscriptBox["\[Delta]", "0"]}]}]], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Mu]"}], ")"}], " ", 
     SubscriptBox["\[Delta]", "0"]}], 
    RowBox[{"1", "-", "\[Mu]", "+", 
     RowBox[{"2", " ", "\[Mu]", " ", 
      SubscriptBox["\[Delta]", "0"]}]}]]}], "}"}]], "Output",
 CellChangeTimes->{3.3896128651092*^9, 3.3896138228478003`*^9, 
  3.3899914966496*^9},
 CellLabel->"Out[220]="]
}, Open  ]],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  RowBox[{"Fold", Cell[""]}]]],
 "instead of ",
 Cell[BoxData["FoldList"]],
 " returns the last element:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Delta]MM", "=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"Fold", "[", 
      RowBox[{"\[Delta]Cond", ",", 
       SubscriptBox["\[Delta]", "0"], ",", 
       RowBox[{"{", 
        RowBox[{"S", ",", "S", ",", "B"}], "}"}]}], "]"}], "//.", 
     SubscriptBox["\[Delta]Cond", "Rule"]}], "//", "Simplify"}], 
   ")"}]}]], "Input",
 CellLabel->"In[221]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "\[Mu]"}], ")"}], " ", 
   SubscriptBox["\[Delta]", "0"]}], 
  RowBox[{"1", "-", "\[Mu]", "+", 
   RowBox[{"2", " ", "\[Mu]", " ", 
    SubscriptBox["\[Delta]", "0"]}]}]]], "Output",
 CellChangeTimes->{3.3896128651442003`*^9, 3.3896138228828*^9, 
  3.3899914967176*^9},
 CellLabel->"Out[221]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"ParameterRestrictions", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0", "<", "\[Mu]", "<", "1"}], ",", 
     RowBox[{"0", "<", 
      SubscriptBox["\[Delta]", "0"], "<", "1"}], ",", 
     RowBox[{"VHi", ">", "VLo"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[222]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"\[Delta]MM", ">", 
    SubscriptBox["\[Delta]", "0"]}], ",", "ParameterRestrictions"}], 
  "]"}]], "Input",
 CellLabel->"In[223]:="],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.3896128651912003`*^9, 3.3896138229288*^9, 
  3.3899914968016*^9},
 CellLabel->"Out[223]="]
}, Open  ]],

Cell["\<\
So the MM has a more pessimistic view of value than the order-informed \
trader, even after the order-informed trader has bought.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ask", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"\[Delta]MM", " ", "VLo"}], " ", "+", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "\[Delta]MM"}], ")"}], " ", "VHi"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[224]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"VHi", "-", 
   RowBox[{"VHi", " ", "\[Mu]"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"VHi", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Mu]"}], ")"}]}], "+", 
      RowBox[{"VLo", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Mu]"}], ")"}]}]}], ")"}], " ", 
    SubscriptBox["\[Delta]", "0"]}]}], 
  RowBox[{"1", "-", "\[Mu]", "+", 
   RowBox[{"2", " ", "\[Mu]", " ", 
    SubscriptBox["\[Delta]", "0"]}]}]]], "Output",
 CellChangeTimes->{3.3896128652352*^9, 3.3896138229688*^9, 
  3.3899914968906*^9},
 CellLabel->"Out[224]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EV", "=", 
  RowBox[{
   RowBox[{
    SubscriptBox["\[Delta]", "0"], " ", "VLo"}], " ", "+", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SubscriptBox["\[Delta]", "0"]}], ")"}], "VHi"}]}]}]], "Input",
 CellLabel->"In[225]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"VHi", " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     SubscriptBox["\[Delta]", "0"]}], ")"}]}], "+", 
  RowBox[{"VLo", " ", 
   SubscriptBox["\[Delta]", "0"]}]}]], "Output",
 CellChangeTimes->{3.3896128652692003`*^9, 3.3896138230018*^9, 
  3.3899914969625998`*^9},
 CellLabel->"Out[225]="]
}, Open  ]],

Cell["The order-informed trader's expected profits are:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"EV", "-", "Ask"}], "]"}]], "Input",
 CellLabel->"In[226]:="],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"VHi", "-", "VLo"}], ")"}], " ", "\[Mu]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SubscriptBox["\[Delta]", "0"]}], ")"}], " ", 
    SubscriptBox["\[Delta]", "0"]}], 
   RowBox[{"1", "-", "\[Mu]", "+", 
    RowBox[{"2", " ", "\[Mu]", " ", 
     SubscriptBox["\[Delta]", "0"]}]}]]}]], "Output",
 CellChangeTimes->{3.3896128653062*^9, 3.3896138230448*^9, 
  3.3899914970486*^9},
 CellLabel->"Out[226]="]
}, Open  ]],

Cell["The expected profits are positive", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"EV", "-", "Ask"}], ">", "0"}], ",", "ParameterRestrictions"}], 
  "]"}]], "Input",
 CellLabel->"In[227]:="],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.3896128653562*^9, 3.3896138231018*^9, 
  3.3899914971776*^9},
 CellLabel->"Out[227]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Ask", "/.", 
    RowBox[{
     SubscriptBox["\[Delta]", "0"], "\[Rule]", 
     RowBox[{"1", "/", "2"}]}]}], "/.", 
   RowBox[{"VLo", "\[Rule]", "0"}]}], "//", "Simplify"}]], "Input",
 CellLabel->"In[228]:="],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"VHi", "-", 
    RowBox[{"VHi", " ", "\[Mu]"}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.3896128653882*^9, 3.3896138231328*^9, 
  3.3899914973366003`*^9},
 CellLabel->"Out[228]="]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The distribution of buys and sells (Chapter 6)", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"BinomialDistribution", "[", 
    RowBox[{"n", ",", "p"}], "]"}], ",", "nBuys"}], "]"}]], "Input",
 CellLabel->"In[231]:="],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "-", "p"}], ")"}], 
   RowBox[{"n", "-", "nBuys"}]], " ", 
  SuperscriptBox["p", "nBuys"], " ", 
  RowBox[{"Binomial", "[", 
   RowBox[{"n", ",", "nBuys"}], "]"}]}]], "Output",
 CellChangeTimes->{3.3896128661122*^9, 3.3896138681568003`*^9, 
  3.3899914976946*^9},
 CellLabel->"Out[231]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"p", ",", "a", ",", "b", ",", "n", ",", "\[Delta]"}], 
  "]"}]], "Input",
 CellLabel->"In[232]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"PN", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Delta]", " ", 
       RowBox[{"PDF", "[", 
        RowBox[{
         RowBox[{"BinomialDistribution", "[", 
          RowBox[{"n", ",", "p"}], "]"}], ",", "b"}], "]"}]}], "/.", 
      "\[InvisibleSpace]", 
      RowBox[{"p", "\[Rule]", 
       FractionBox[
        RowBox[{"1", "-", "\[Mu]"}], "2"]}]}], ")"}], "+", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
       RowBox[{"PDF", "[", 
        RowBox[{
         RowBox[{"BinomialDistribution", "[", 
          RowBox[{"n", ",", "p"}], "]"}], ",", "b"}], "]"}]}], "/.", 
      "\[InvisibleSpace]", 
      RowBox[{"p", "\[Rule]", 
       RowBox[{
        FractionBox[
         RowBox[{"1", "-", "\[Mu]"}], "2"], "+", "\[Mu]"}]}]}], ")"}]}]}], 
  ";"}]], "Input",
 CellLabel->"In[233]:="],

Cell[CellGroupData[{

Cell[BoxData["PN"], "Input",
 CellLabel->"In[234]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["2", 
    RowBox[{"-", "b"}]], " ", "\[Delta]", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Mu]"}], ")"}]}]}], ")"}], 
    RowBox[{
     RowBox[{"-", "b"}], "+", "n"}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", "\[Mu]"}], ")"}], "b"], " ", 
   RowBox[{"Binomial", "[", 
    RowBox[{"n", ",", "b"}], "]"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Mu]"}], ")"}]}], "-", "\[Mu]"}], ")"}], 
    RowBox[{
     RowBox[{"-", "b"}], "+", "n"}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"1", "-", "\[Mu]"}], "2"], "+", "\[Mu]"}], ")"}], "b"], " ", 
   RowBox[{"Binomial", "[", 
    RowBox[{"n", ",", "b"}], "]"}]}]}]], "Output",
 CellChangeTimes->{3.3896128661612*^9, 3.3896138682047997`*^9, 
  3.3899914977806*^9},
 CellLabel->"Out[234]="]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", 
       RowBox[{
        RowBox[{"PN", "/.", "\[InvisibleSpace]", 
         RowBox[{"n", "\[Rule]", "50"}]}], "/.", "\[InvisibleSpace]", 
        RowBox[{"\[Delta]", "\[Rule]", 
         FractionBox["1", "2"]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "0", ",", "50"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"bPlot", "=", 
   RowBox[{"N", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "/.", "\[InvisibleSpace]", 
       RowBox[{"\[Mu]", "\[Rule]", "0"}]}], ",", 
      RowBox[{"a", "/.", "\[InvisibleSpace]", 
       RowBox[{"\[Mu]", "\[Rule]", ".1"}]}], ",", 
      RowBox[{"a", "/.", "\[InvisibleSpace]", 
       RowBox[{"\[Mu]", "\[Rule]", ".5"}]}]}], "}"}], "]"}]}], 
  ";"}]}], "Input",
 CellLabel->"In[235]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"lineStyles", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
       RowBox[{"Dashing", "[", 
        RowBox[{".01", "r"}], "]"}], ",", 
       RowBox[{"AbsoluteThickness", "[", 
        RowBox[{".5", "r"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "0", ",", "2"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.3896149201127996`*^9, 3.3896149841478*^9}, {
   3.389619683251*^9, 3.3896196876140003`*^9}, 3.389621668238*^9},
 CellLabel->"In[237]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "=", 
  RowBox[{"ListPlot", "[", 
   RowBox[{"bPlot", ",", 
    RowBox[{"PlotJoined", "\[Rule]", "True"}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", "Automatic", ",", "None", ",", "None"}], 
      "}"}]}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Number of buys in fifty trades, \!\(\*
StyleBox[\"b\",
FontSlant->\"Italic\"]\))\>\"", ",", "\"\<Probability\>\""}], "}"}]}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", "lineStyles"}], ",", 
    RowBox[{"BaseStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.3896129925372*^9, 3.3896129954812*^9}, {
  3.3896131106492*^9, 3.3896131441352*^9}, {3.3896133181172*^9, 
  3.3896133523952*^9}, {3.3896138753478003`*^9, 3.3896138765768003`*^9}, {
  3.3896139289568*^9, 3.3896139474818*^9}, {3.3896140570508003`*^9, 
  3.3896140871647997`*^9}, {3.3896143301668*^9, 3.3896144118338003`*^9}, {
  3.3896144772148*^9, 3.3896145197768*^9}, {3.3896145959288*^9, 
  3.3896146587208*^9}, {3.3896147296038*^9, 3.3896147541348*^9}, {
  3.3896147841768*^9, 3.3896148028398*^9}, {3.3896149088928003`*^9, 
  3.3896149128838*^9}, {3.3896149873858*^9, 3.3896149931688004`*^9}, {
  3.38961974325*^9, 3.3896197461*^9}, {3.389621564369*^9, 3.389621576855*^9}},
 
 CellLabel->"In[238]:="],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {GrayLevel[0], AbsoluteThickness[0], Dashing[0], 
    LineBox[{{0., 8.881784197001252*^-16}, {1., 4.440892098500626*^-14}, {2., 
     1.0880185641326534`*^-12}, {3., 1.7408297026122455`*^-11}, {4., 
     2.0454749005693884`*^-10}, {5., 1.8818369085238373`*^-9}, {6., 
     1.411377681392878*^-8}, {7., 8.871516854469519*^-8}, {8., 
     4.768440309277366*^-7}, {9., 2.2252721443294377`*^-6}, {10., 
     9.123615791750694*^-6}, {11., 0.00003317678469727525}, {12., 
     0.00010782455026614457`}, {13., 0.0003151794546241149}, {14., 
     0.0008329742729351608}, {15., 0.001999138255044386}, {16., 
     0.004373114932909594}, {17., 0.008746229865819188}, {18., 
     0.016034754754001845`}, {19., 0.027005902743582055`}, {20., 
     0.041859149252552186`}, {21., 0.05979878464650312}, {22., 
     0.07882567067039048}, {23., 0.09596168603351884}, {24., 
     0.1079568967877087}, {25., 0.11227517265921705`}, {26., 
     0.1079568967877087}, {27., 0.09596168603351884}, {28., 
     0.07882567067039048}, {29., 0.05979878464650312}, {30., 
     0.041859149252552186`}, {31., 0.027005902743582055`}, {32., 
     0.016034754754001845`}, {33., 0.008746229865819188}, {34., 
     0.004373114932909594}, {35., 0.001999138255044386}, {36., 
     0.0008329742729351608}, {37., 0.0003151794546241149}, {38., 
     0.00010782455026614457`}, {39., 0.00003317678469727525}, {40., 
     9.123615791750694*^-6}, {41., 2.2252721443294377`*^-6}, {42., 
     4.768440309277366*^-7}, {43., 8.871516854469519*^-8}, {44., 
     1.411377681392878*^-8}, {45., 1.8818369085238373`*^-9}, {46., 
     2.0454749005693884`*^-10}, {47., 1.7408297026122455`*^-11}, {48., 
     1.0880185641326534`*^-12}, {49., 4.440892098500626*^-14}, {50., 
     8.881784197001252*^-16}}]}, 
   {GrayLevel[0], AbsoluteThickness[0.5], Dashing[0.01], 
    LineBox[{{0., 5.213429983492861*^-14}, {1., 2.13281304851899*^-12}, {2., 
     4.275459156201529*^-11}, {3., 5.597235468839238*^-10}, {4., 
     5.381367478553177*^-9}, {5., 4.051139288632485*^-8}, {6., 
     2.486327169372263*^-7}, {7., 1.2789904509983182`*^-6}, {8., 
     5.626673964199449*^-6}, {9., 0.00002149520154353981}, {10., 
     0.00007216444540780882}, {11., 0.00021496108965489704`}, {12., 
     0.0005726217599121578}, {13., 0.0013731335403419764`}, {14., 
     0.0029809572537181843`}, {15., 0.005888067454965133}, {16., 
     0.010630679535784768`}, {17., 0.01762146783863912}, {18., 
     0.02693818435777257}, {19., 0.03816211508868999}, {20., 
     0.05036966825130327}, {21., 0.06231885175185832}, {22., 
     0.07276227597020764}, {23., 0.08073357425832416}, {24., 
     0.08566756769503875}, {25., 0.08733002742456622}, {26., 
     0.08566756769503872}, {27., 0.08073357425832407}, {28., 
     0.07276227597020755}, {29., 0.06231885175185823}, {30., 
     0.05036966825130318}, {31., 0.03816211508868992}, {32., 
     0.026938184357772513`}, {33., 0.017621467838639087`}, {34., 
     0.01063067953578475}, {35., 0.005888067454965123}, {36., 
     0.0029809572537181786`}, {37., 0.0013731335403419742`}, {38., 
     0.0005726217599121568}, {39., 0.0002149610896548968}, {40., 
     0.00007216444540780874}, {41., 0.000021495201543539785`}, {42., 
     5.626673964199443*^-6}, {43., 1.2789904509983169`*^-6}, {44., 
     2.4863271693722616`*^-7}, {45., 4.051139288632483*^-8}, {46., 
     5.381367478553175*^-9}, {47., 5.597235468839235*^-10}, {48., 
     4.2754591562015287`*^-11}, {49., 2.1328130485189895`*^-12}, {50., 
     5.213429983492861*^-14}}]}, 
   {GrayLevel[0], AbsoluteThickness[1.], Dashing[0.02], 
    LineBox[{{0., 2.831608282134688*^-7}, {1., 4.719347136891147*^-6}, {2., 
     0.0000385413349512777}, {3., 0.0002055537864068144}, {4., 
     0.0008050856634266898}, {5., 0.0024689293678418485`}, {6., 
     0.006172323419604621}, {7., 0.012932487164885872`}, {8., 
     0.023170706170420524`}, {9., 0.03604332070954306}, {10., 
     0.04925920496970905}, {11., 0.05970812723601329}, {12., 
     0.06468380450570368}, {13., 0.06302524541601222}, {14., 
     0.0555222400109168}, {15., 0.0444177920200569}, {16., 
     0.032387973422268394`}, {17., 0.021591982727373706`}, {18., 
     0.013195103007855194`}, {19., 0.007407789517471755}, {20., 
     0.003827415532045243}, {21., 0.00182282574486132}, {22., 
     0.000801915041534887}, {23., 0.0003289809890465933}, {24., 
     0.00013540376073564053`}, {25., 0.00008449194669903969}, {26., 
     0.00013540376073564053`}, {27., 0.0003289809890465933}, {28., 
     0.000801915041534887}, {29., 0.00182282574486132}, {30., 
     0.003827415532045243}, {31., 0.007407789517471755}, {32., 
     0.013195103007855194`}, {33., 0.021591982727373706`}, {34., 
     0.032387973422268394`}, {35., 0.0444177920200569}, {36., 
     0.0555222400109168}, {37., 0.06302524541601222}, {38., 
     0.06468380450570368}, {39., 0.05970812723601329}, {40., 
     0.04925920496970905}, {41., 0.03604332070954306}, {42., 
     0.023170706170420524`}, {43., 0.012932487164885872`}, {44., 
     0.006172323419604621}, {45., 0.0024689293678418485`}, {46., 
     0.0008050856634266898}, {47., 0.0002055537864068144}, {48., 
     0.0000385413349512777}, {49., 4.719347136891147*^-6}, {50., 
     2.831608282134688*^-7}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Times"},
  Frame->True,
  FrameLabel->{
    FormBox[
    "\"Number of buys in fifty trades, \
\\!\\(\\*\\nStyleBox[\\\"b\\\",\\nFontSlant->\\\"Italic\\\"]\\))\"", 
     TraditionalForm], 
    FormBox["\"Probability\"", TraditionalForm]},
  FrameTicks->{Automatic, Automatic, None, None},
  ImageSize->{297.9999999999989, Automatic},
  PlotRange->{{0., 50.}, {0., 0.11227517265921705`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.3896147544798*^9, {3.3896147874428*^9, 3.3896148043848*^9}, {
   3.3896149133308*^9, 3.3896149936668*^9}, 3.3896197465299997`*^9, 
   3.389621577264*^9, 3.3899914979866*^9},
 CellLabel->"Out[238]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"legendLines", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
        RowBox[{"Dashing", "[", 
         RowBox[{".1", "r"}], "]"}], ",", 
        RowBox[{"AbsoluteThickness", "[", 
         RowBox[{".5", "r"}], "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "0", ",", "2"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.3896149201127996`*^9, 3.3896149841478*^9}, {
  3.389619683251*^9, 3.3896196876140003`*^9}, {3.389619814413*^9, 
  3.3896199705290003`*^9}, {3.389620788172*^9, 3.389620837962*^9}, {
  3.3896208788570004`*^9, 3.389620902436*^9}, {3.3896210739440002`*^9, 
  3.38962107709*^9}},
 CellLabel->"In[239]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"legendText", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Style", "[", 
      RowBox[{"#", ",", "Black", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}]}], "]"}], "&"}], 
    " ", "/@", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0.1", ",", "0.5"}], "}"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.389620914783*^9, 3.3896209204820004`*^9}, {
   3.389620988039*^9, 3.389621025764*^9}, 3.389621081079*^9, 
   3.389621619785*^9},
 CellLabel->"In[240]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"legendEntries", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"legendLines", ",", "legendText"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.389621033892*^9, 3.3896210839779997`*^9}},
 CellLabel->"In[241]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShowLegend", "[", 
  RowBox[{"a", ",", 
   RowBox[{"{", 
    RowBox[{"legendEntries", ",", 
     RowBox[{"LegendPosition", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", ".4"}]}], "}"}]}], ",", 
     RowBox[{"LegendSize", "\[Rule]", "0.6"}], ",", 
     RowBox[{"LegendShadow", "\[Rule]", "None"}], ",", 
     RowBox[{"LegendLabel", "\[Rule]", "\[Mu]"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.3896199844309998`*^9, 3.389619996865*^9}, {
  3.389621094799*^9, 3.389621098097*^9}, {3.389621182734*^9, 
  3.389621187608*^9}, {3.3896212580950003`*^9, 3.389621276164*^9}, {
  3.389621319869*^9, 3.3896213638640003`*^9}, {3.3896216388050003`*^9, 
  3.3896216436809998`*^9}},
 CellLabel->"In[242]:="],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    GraphicsBox[{{}, {}, 
      {GrayLevel[0], AbsoluteThickness[0], Dashing[0], 
       LineBox[{{0., 8.881784197001252*^-16}, {1., 4.440892098500626*^-14}, {
        2., 1.0880185641326534`*^-12}, {3., 1.7408297026122455`*^-11}, {4., 
        2.0454749005693884`*^-10}, {5., 1.8818369085238373`*^-9}, {6., 
        1.411377681392878*^-8}, {7., 8.871516854469519*^-8}, {8., 
        4.768440309277366*^-7}, {9., 2.2252721443294377`*^-6}, {10., 
        9.123615791750694*^-6}, {11., 0.00003317678469727525}, {12., 
        0.00010782455026614457`}, {13., 0.0003151794546241149}, {14., 
        0.0008329742729351608}, {15., 0.001999138255044386}, {16., 
        0.004373114932909594}, {17., 0.008746229865819188}, {18., 
        0.016034754754001845`}, {19., 0.027005902743582055`}, {20., 
        0.041859149252552186`}, {21., 0.05979878464650312}, {22., 
        0.07882567067039048}, {23., 0.09596168603351884}, {24., 
        0.1079568967877087}, {25., 0.11227517265921705`}, {26., 
        0.1079568967877087}, {27., 0.09596168603351884}, {28., 
        0.07882567067039048}, {29., 0.05979878464650312}, {30., 
        0.041859149252552186`}, {31., 0.027005902743582055`}, {32., 
        0.016034754754001845`}, {33., 0.008746229865819188}, {34., 
        0.004373114932909594}, {35., 0.001999138255044386}, {36., 
        0.0008329742729351608}, {37., 0.0003151794546241149}, {38., 
        0.00010782455026614457`}, {39., 0.00003317678469727525}, {40., 
        9.123615791750694*^-6}, {41., 2.2252721443294377`*^-6}, {42., 
        4.768440309277366*^-7}, {43., 8.871516854469519*^-8}, {44., 
        1.411377681392878*^-8}, {45., 1.8818369085238373`*^-9}, {46., 
        2.0454749005693884`*^-10}, {47., 1.7408297026122455`*^-11}, {48., 
        1.0880185641326534`*^-12}, {49., 4.440892098500626*^-14}, {50., 
        8.881784197001252*^-16}}]}, 
      {GrayLevel[0], AbsoluteThickness[0.5], Dashing[0.01], 
       LineBox[{{0., 5.213429983492861*^-14}, {1., 2.13281304851899*^-12}, {
        2., 4.275459156201529*^-11}, {3., 5.597235468839238*^-10}, {4., 
        5.381367478553177*^-9}, {5., 4.051139288632485*^-8}, {6., 
        2.486327169372263*^-7}, {7., 1.2789904509983182`*^-6}, {8., 
        5.626673964199449*^-6}, {9., 0.00002149520154353981}, {10., 
        0.00007216444540780882}, {11., 0.00021496108965489704`}, {12., 
        0.0005726217599121578}, {13., 0.0013731335403419764`}, {14., 
        0.0029809572537181843`}, {15., 0.005888067454965133}, {16., 
        0.010630679535784768`}, {17., 0.01762146783863912}, {18., 
        0.02693818435777257}, {19., 0.03816211508868999}, {20., 
        0.05036966825130327}, {21., 0.06231885175185832}, {22., 
        0.07276227597020764}, {23., 0.08073357425832416}, {24., 
        0.08566756769503875}, {25., 0.08733002742456622}, {26., 
        0.08566756769503872}, {27., 0.08073357425832407}, {28., 
        0.07276227597020755}, {29., 0.06231885175185823}, {30., 
        0.05036966825130318}, {31., 0.03816211508868992}, {32., 
        0.026938184357772513`}, {33., 0.017621467838639087`}, {34., 
        0.01063067953578475}, {35., 0.005888067454965123}, {36., 
        0.0029809572537181786`}, {37., 0.0013731335403419742`}, {38., 
        0.0005726217599121568}, {39., 0.0002149610896548968}, {40., 
        0.00007216444540780874}, {41., 0.000021495201543539785`}, {42., 
        5.626673964199443*^-6}, {43., 1.2789904509983169`*^-6}, {44., 
        2.4863271693722616`*^-7}, {45., 4.051139288632483*^-8}, {46., 
        5.381367478553175*^-9}, {47., 5.597235468839235*^-10}, {48., 
        4.2754591562015287`*^-11}, {49., 2.1328130485189895`*^-12}, {50., 
        5.213429983492861*^-14}}]}, 
      {GrayLevel[0], AbsoluteThickness[1.], Dashing[0.02], 
       LineBox[{{0., 2.831608282134688*^-7}, {1., 4.719347136891147*^-6}, {2.,
         0.0000385413349512777}, {3., 0.0002055537864068144}, {4., 
        0.0008050856634266898}, {5., 0.0024689293678418485`}, {6., 
        0.006172323419604621}, {7., 0.012932487164885872`}, {8., 
        0.023170706170420524`}, {9., 0.03604332070954306}, {10., 
        0.04925920496970905}, {11., 0.05970812723601329}, {12., 
        0.06468380450570368}, {13., 0.06302524541601222}, {14., 
        0.0555222400109168}, {15., 0.0444177920200569}, {16., 
        0.032387973422268394`}, {17., 0.021591982727373706`}, {18., 
        0.013195103007855194`}, {19., 0.007407789517471755}, {20., 
        0.003827415532045243}, {21., 0.00182282574486132}, {22., 
        0.000801915041534887}, {23., 0.0003289809890465933}, {24., 
        0.00013540376073564053`}, {25., 0.00008449194669903969}, {26., 
        0.00013540376073564053`}, {27., 0.0003289809890465933}, {28., 
        0.000801915041534887}, {29., 0.00182282574486132}, {30., 
        0.003827415532045243}, {31., 0.007407789517471755}, {32., 
        0.013195103007855194`}, {33., 0.021591982727373706`}, {34., 
        0.032387973422268394`}, {35., 0.0444177920200569}, {36., 
        0.0555222400109168}, {37., 0.06302524541601222}, {38., 
        0.06468380450570368}, {39., 0.05970812723601329}, {40., 
        0.04925920496970905}, {41., 0.03604332070954306}, {42., 
        0.023170706170420524`}, {43., 0.012932487164885872`}, {44., 
        0.006172323419604621}, {45., 0.0024689293678418485`}, {46., 
        0.0008050856634266898}, {47., 0.0002055537864068144}, {48., 
        0.0000385413349512777}, {49., 4.719347136891147*^-6}, {50., 
        2.831608282134688*^-7}}]}},
     AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
     Axes->True,
     AxesOrigin->{0, 0},
     BaseStyle->{FontFamily -> "Times"},
     Frame->True,
     FrameLabel->{
       FormBox[
       "\"Number of buys in fifty trades, \
\\!\\(\\*\\nStyleBox[\\\"b\\\",\\nFontSlant->\\\"Italic\\\"]\\))\"", 
        TraditionalForm], 
       FormBox["\"Probability\"", TraditionalForm]},
     FrameTicks->{Automatic, Automatic, None, None},
     PlotRange->{{0., 50.}, {0., 0.11227517265921705`}},
     PlotRangeClipping->True,
     PlotRangePadding->{
       Scaled[0.02], 
       Scaled[0.02]}], {-1, -0.6180339887498948}, {
    Left, Bottom}, {2, 1.2360679774997896`}], InsetBox[
    GraphicsBox[{{{InsetBox[
         GraphicsBox[
          {GrayLevel[0], AbsoluteThickness[1.], Dashing[0.2], 
           LineBox[{{0, 0}, {2, 0}}]}], {0.08, 0.08}, {Left, Bottom}, {1, 1}],
         InsetBox[
         StyleBox["0.5`",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0],
          BackFaceColor->GrayLevel[0],
          GraphicsColor->GrayLevel[0],
          FontFamily->"Times",
          FontColor->GrayLevel[0]], {1.21, 0.58}, {-1, 0}, Automatic, {1, 
         0}]}, {InsetBox[
         GraphicsBox[
          {GrayLevel[0], AbsoluteThickness[0.5], Dashing[0.1], 
           LineBox[{{0, 0}, {2, 0}}]}], {0.08, 1.24}, {Left, Bottom}, {1, 1}],
         InsetBox[
         StyleBox["0.1`",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0],
          BackFaceColor->GrayLevel[0],
          GraphicsColor->GrayLevel[0],
          FontFamily->"Times",
          FontColor->GrayLevel[0]], {1.21, 1.74}, {-1, 0}, Automatic, {1, 
         0}]}, {InsetBox[
         GraphicsBox[
          {GrayLevel[0], AbsoluteThickness[0], Dashing[0], 
           LineBox[{{0, 0}, {2, 0}}]}], {0.08, 2.4}, {Left, Bottom}, {1, 1}], 
        InsetBox[
         StyleBox["0",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0],
          BackFaceColor->GrayLevel[0],
          GraphicsColor->GrayLevel[0],
          FontFamily->"Times",
          FontColor->GrayLevel[0]], {1.21, 2.9}, {-1, 0}, Automatic, {1, 
         0}]}}, InsetBox["\[Mu]", {1.58, 3.9799999999999995`}, {0, 0}]},
     AspectRatio->1.392857142857143,
     PlotRange->{{-0.1, 3.26}, {-0.1, 4.58}}], {1, -0.4}, {
    Left, Bottom}, {0.4307692307692308, 0.6000000000000001}]},
  AspectRatio->Automatic,
  Background->None,
  ColorOutput->Automatic,
  ImageSize->Automatic,
  PlotRange->All]], "Output",
 CellChangeTimes->{
  3.389619997427*^9, {3.38962079345*^9, 3.3896208038780003`*^9}, 
   3.389620841184*^9, {3.3896210658640003`*^9, 3.389621087699*^9}, 
   3.389621189084*^9, {3.38962125948*^9, 3.389621276951*^9}, {
   3.389621325042*^9, 3.389621364722*^9}, 3.389621585115*^9, {
   3.3896216324709997`*^9, 3.389621644575*^9}, 3.3899914987246*^9},
 CellLabel->"Out[242]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"PoissonDistribution", "[", "\[Mu]", "]"}], ",", "n"}], 
  "]"}]], "Input",
 CellLabel->"In[243]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "\[Mu]"}]], " ", 
   SuperscriptBox["\[Mu]", "n"]}], 
  RowBox[{"n", "!"}]]], "Output",
 CellChangeTimes->{3.3896128664222*^9, 3.3899914987936*^9},
 CellLabel->"Out[243]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "f", "]"}], ";"}], "\n", 
 RowBox[{"fMixDefinition", "=", 
  RowBox[{"fMix", "\[RuleDelayed]", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "\[Alpha]"}], ")"}], " ", 
     RowBox[{"f", "[", 
      RowBox[{"\[Epsilon]", ",", "B"}], "]"}], " ", 
     RowBox[{"f", "[", 
      RowBox[{"\[Epsilon]", ",", "S"}], "]"}]}], "+", 
    RowBox[{"\[Alpha]", " ", "\[Delta]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{
         RowBox[{"\[Epsilon]", "+", "\[Mu]"}], ",", "B"}], "]"}], " ", 
       RowBox[{"f", "[", 
        RowBox[{"\[Epsilon]", ",", "S"}], "]"}]}], ")"}]}], "+", 
    RowBox[{"\[Alpha]", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"\[Epsilon]", "+", "\[Mu]"}], ",", "S"}], "]"}], " ", 
     RowBox[{"f", "[", 
      RowBox[{"\[Epsilon]", ",", "B"}], "]"}]}]}]}]}]}], "Input",
 CellLabel->"In[244]:="],

Cell[BoxData[
 RowBox[{"fMix", "\[RuleDelayed]", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", "\[Alpha]"}], ")"}], " ", 
    RowBox[{"f", "[", 
     RowBox[{"\[Epsilon]", ",", "B"}], "]"}], " ", 
    RowBox[{"f", "[", 
     RowBox[{"\[Epsilon]", ",", "S"}], "]"}]}], "+", 
   RowBox[{"\[Alpha]", " ", "\[Delta]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{
        RowBox[{"\[Epsilon]", "+", "\[Mu]"}], ",", "B"}], "]"}], " ", 
      RowBox[{"f", "[", 
       RowBox[{"\[Epsilon]", ",", "S"}], "]"}]}], ")"}]}], "+", 
   RowBox[{"\[Alpha]", " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
    RowBox[{"f", "[", 
     RowBox[{
      RowBox[{"\[Epsilon]", "+", "\[Mu]"}], ",", "S"}], "]"}], " ", 
    RowBox[{"f", "[", 
     RowBox[{"\[Epsilon]", ",", "B"}], "]"}]}]}]}]], "Output",
 CellChangeTimes->{3.3896128664561996`*^9, 3.389621898863*^9, 
  3.3899914988536*^9},
 CellLabel->"Out[245]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"n", ",", 
          RowBox[{"N", "[", 
           RowBox[{"PDF", "[", 
            RowBox[{
             RowBox[{"PoissonDistribution", "[", "10", "]"}], ",", "n"}], 
            "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "0", ",", "20"}], "}"}]}], "]"}], "}"}], ",", 
     RowBox[{"DisplayFunction", "\[Rule]", "Identity"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{
  3.389621747774*^9, {3.389621779368*^9, 3.3896217812209997`*^9}, 
   3.389621864998*^9},
 CellLabel->"In[246]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"PDF", "[", 
      RowBox[{
       RowBox[{"NormalDistribution", "[", 
        RowBox[{"10", ",", 
         SqrtBox["10"]}], "]"}], ",", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "20"}], "}"}], ",", 
     RowBox[{"DisplayFunction", "\[Rule]", "Identity"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.389621785126*^9, 3.389621804918*^9}, 3.389621866954*^9},
 
 CellLabel->"In[247]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"p1", ",", "p2", ",", 
   RowBox[{"BaseStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.389621812567*^9, 3.3896218464300003`*^9}},
 CellLabel->"In[248]:="],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{0., 0.000045399929762484854`}, {1., 
      0.00045399929762484856`}, {2., 0.0022699964881242427`}, {3., 
      0.007566654960414142}, {4., 0.018916637401035358`}, {5., 
      0.037833274802070715`}, {6., 0.06305545800345119}, {7., 
      0.09007922571921598}, {8., 0.11259903214901998`}, {9., 
      0.1251100357211333}, {10., 0.1251100357211333}, {11., 
      0.1137363961101212}, {12., 0.09478033009176765}, {13., 
      0.07290794622443666}, {14., 0.05207710444602618}, {15., 
      0.03471806963068413}, {16., 0.021698793519177577`}, {17., 
      0.012763996187751515`}, {18., 0.007091108993195287}, {19., 
      0.0037321626279975197`}, {20., 
      0.0018660813139987598`}}]}, {}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt2Xc4le//AHCjkNYp7WWcY0vOOTLT+61S4URkZ+QUskeIkBlZGfmIBiUq
My0lnHPI3qGSNI1Cwx4hv+d7Xb+/nut1Pfd47vW+7/t6RJnuhnY8XFxcOdxc
XP973rrI5KOeubG/UK0s+XaPLlR3ijBMRfzhWU1PcSAfA5ZqWeEiItHg0SM9
kkpjwC1OvPBykXQI7zToj4xlgIuGj+uMcC5U3n541AqPQef82ZRR4VJwqfjT
KFmiB/wfvkn+Em6AbY3HtKnDx6GbU+Hz80cDSN7NOX9smQHk3Ut7NfKoESy8
5MvidxmAnpeezfDBZlA2LZYLOGEAqStepn53aAM8Lei2hm0A62/W84y964Co
T/YJ+24Zwp3GTM8R4ffgzZC6NuprBJNpz2Q+x72Hr0mlV0LTjOCwQ1Nfx9x7
MJqoTj740gh+8s4Yv+zsgT/SyU9O/jMCFQ09teioXtDWOrOy77IxtD9c4JH8
8xlGL9x2jLhvAsGNcjpUmz54l3nLqH2VOTx49Fwi/78+qLcNGl5QNIeOtAO8
4s19cIEdkMK0MgeKg1n5FtV+SBvk3ttTZA6NvBHyXEIDEEAylwgzsoBNGh/W
t9UOAnvCJWgs7yQUPYz+4CI/DAXvr9ZDpDUMrx+O07EdhrnYfK+hx9Yg6auz
XyplGCqequY2f7aG2/tW3umbGwbXhOBHqGYDyQ1x9hY1I3CdTB4bGLMB376E
sSOWv2DvlnMju0tOQebKpvB1WqOQvnxo4f0RJuzXCLAMsR6F3ED+18uYTOh1
k9375/wotJw64HY8kAlbOmIHm/NG4auOW4zOIyYkpTG0L5PGwCxId75lx2kI
F29ds/RhDBxdu6/t+XsaHOB1+k+vCQjfVqRo0GYHXFnTLz/ETkC37uNj+3/Z
QdqyHb2N2RMwwK2/Q3+lPdQ32O/KfTsBsyHFp3uP2IOU0UKWndokqCeq2OZW
2cOPs5IFn7ingPKvKE6W7QBOyUGs9sRp+E6fiKnvcgSeqazP7NxpYK5vcfCY
cYTrpvVcD6um4adHpAtuc4LGHUIH4yenIciGHmp+yglk7z+o0zabgXCrjQPn
fjvBz7LO9irhWei5LqjltN4F3Aak+54WzUHcpHOP/QU3+GL9XqCyYQ5Uti+9
qsxxgxPdl+Vb+ufgSi/GGrx2A5Wm7/4D2/6CwYWMAJK0O/A+yiFtivoLsWZL
9us+uENaoOj+8zbzIBKVN5yT7QGVQlvTVUmLIMj7p2a5lBcoxteztGQXwft+
/12aphfc4/PrNzi8CEs94bJBFl4QN/d2j1PgIhhZ0rOc473A5HNK7fUfixD+
dHbLo0kvGM4jTc5z/gFsPVI4VX8OBEUjJD+rcOGwqs99crQP1O9L2nNRiwuN
02WEj2b7QKRZhvJOQy6sdUxnRrN9gCfxxZGTzlyotmhwnzntA3///XR4d4sL
u2g+2V52vjDSa/ygjYcb7+ll2u3QPg/NaZLSnGZu5E+RIalI+kPMU0WqzXtu
HHylaC922B+Otmuq/hvgxicdgY5ydv5QzW+pvW+JG5Nun3uTedcfyn0THV9Q
eVC8paGTT+wCFBrN5Ran8qBq+pelIUoAXCE1ydw5xYtbwkOy8g4GQanyzmd6
bryolcFFy3UMgn5rd1gI4MWFJXfP9oQgUC8UMjK9xouMhQb/9N4g+KFtGbS6
lRc37BtattXvIhwM/9Xmr74M+9RrH/8oCYbZqbU+hpuWo414ovRxmVAg72Qu
LZGXY9iN7dyzEAp6h55GF1KXY8JM8NYS41DISTbLEDi2HBuLV+n4hIaC4Z47
dazw5bjnRbEJd08oFJ6lbZMdW45dRl+DrRLCgPnBiM3bzIfKdkqDiSsjQPDG
V1fP93xIt5C7lk+OgMcWbjs+D/Kh9ObhxI/qEcDbE+X/kpsfgwSmrkW5REB2
90u6pzI/hkjti5hqjYDBNyIPPmXxY132DV2ttEvg1P4zsdRfAMVed13drBEF
njURTHdJQVyt/CgpsSMGdvUf5pumC6L4hHPql98x0MSzIi8QBdF6eXTvkZWx
II7xY9Hmglh5R9bU8lAsvH/5X0h2rCDycqLkMp7HgmbxvYz3fwRxl+Z/vley
4mDdjfqegy9Wor/BYWHHmCvwyGPViS3aq9HPlmK20TAJmq8L+RearMaIqXG9
yjNJMFi9LfPAmdU4vS7TKvB8EmzbKj3iErwaZSUPdgvfSoKISq3wymerMcxd
4P2OoSQwWR/8xElsDe6PdsiaCE+Gv0/GhCrm12DL2M3LyjVX4U6A87CCKQmr
Rxf1N51PhbDMBYPJn+tQfLrMXHX3TeDq/ILlF4RQg1uAfvzEHZDwtvczktmI
YtyKJDWDHOifumaysmITvpHT7ev0zgWdAaegZM8tGB7Fr0Y1LAK9/kTZXbu2
obqd5WWth49g+BUzpL5wOw4zGn4+2PIU5Ne93XnQZifmiD05M1xcAoIwZds7
sQvlC/+5lXOXwpFfFjNixiJIkjHdYsIog4wN4Z3BZiLo4jhHZhmVwaR6/sPe
kyIo92RuhahVGdyOmXdIZYqgun6T7jvXMvgrebN7hYcIHlq/f3pZQhkUMD+W
jsaIoJfKXmeb9jIgddsEsjgimGIXET+gVw72S1Fm26tFMKtErPumSTmUSxQr
+tWJoAT/dhU963Jw9OH6RW0VwUdbjopkupZD1fo7VjkfRHA25/rIbGw5eB/7
tj9uWgQ7Khe1o+rKobvqDLeFnCjyluTXD6pWwKhmz7agPaIYY/zihjVWAH+l
vuJtmij6Carmth+uACW2msOgiij+F9Vhe/dEBaSUkVq8tERRxLyqhce1AvSf
lqfFWovi9PEkVk5GBdTmbFCoSBTF5qoMWevFCvhEidH+clUUFX/QJzbwsmDq
7hKT95ooNpbXuNYIsICSNfyf9i1RfOD8w1loAwvCMjjzb3JFsT3+0M7TMizY
f82l7neVKFIkcbjFmAXPLldbi0yJosA3nycl91nwQKdpS9SsKArP9BctL2TB
9VUdHb/mRdFe7/tTxmMWhCR+PlzGI4ajP/62VpWzgJH2V96EJIbPrFZV6r1m
wbf7CkuxsmJYHNjz6essC944KpeOy4thvI79xYeLLKiX3X/OnCaGkXsf93vz
sKHwoe53CVUxdH7gMzW4kg1+z+3bKg+LYQBP9AuHXWxYU3czc8ZWDKfEr9h2
a7KBO/quubWdGG4lWaaJHGbDpE6eUM1ZMTwqnG52SocN71ufRyW7i6Fxwax9
rSEbst92uO8OEkPGwRlTudNsUBsUwNNpYnhPeW2UZRgb7Jf7fGltFcNcrgRX
5Zds2Cbc8G7+tRjO/Dyjr1jBhlaVnW1Sb8Rw98N/56U5bFByqakI+yCG30by
UhZq2MDXufGG0g8x1PGyYWu9ZkPO7RLjDG4yWooXCDAH2WD2UvBY0zIybtFp
Nf/2gw2ruqwPzfKTUTJnsd1ihA3e/Px0wzVkzAkQllEcZcMhN1MS33YyHg+f
Mro8x4Z+9dlGV0UyysiIRlos50CaMaPqujIZxas0fU/ycYDhfru0To2MTp/G
nc34OfA06+gDUU0yPqSQ7A6v4EDEivRLb46RMfyl8IXxVRxQIf8K5DEgo2di
Wljnag783KfpvceIjK/38cQWr+GAkccQM9qCjAq/SenWJA5Q3qmihgMZuw3v
pMUIcaB7NF7ZyYmMn5PXJehu4ECc4Df5a65kZBgmhwhs5MCkRszOsXNkVNG+
Yui7iQPV2T1/s0PI2MyVdld0Kwf8WPLjr8PJ+IWUebqKsFx32NC/SDKKSV3b
ZrONAykrZbvN4snYuS/COW47B057BTxbdZ2MDb0i8SU7OaBE+/RM+hYZU3ub
AxV3cUBwHEsO3yZjW77l5SLCxZ58z0PuEfk31Y+lCnMgnOr4/FYuGdm//+ot
F+GAyVjT85cFRP+v5dS6E17wSHox+ZiMiw9bl6mKcqBNYfLFuhIyBi+LbLxG
OGvUpFS+lIyGOvm544S1PXa8PMsm0rurPbkpxoEdCsEvL1WR8Uet1McRwqN/
vr7MqiHj18V4YWUyB1Ld75f1NhH9Iz7ws5Kw4x7B8rlWMsqqep3npnBg3x+X
8k0dZHT3LtiqQZj0sK2c/oaMd0LOdnoT7nOjVRzvJiPvp6DsB4RL5P+rcP1A
RlZfbVw34ZjfMxUxn8i4jiMSt0ycA1ZFFqz7X8no5+ecJUdYwa2CVd1PxvdD
0W3HCfPKi7C/fifKr7cV8iT89lcY+98wGQdvf3CNJ5xbOMDe/puMl95++5RD
OND1KEdljIzqOXb2Lwnr787nGE+S8ZmI8bImwmK/Vld6zZAxXzHnxTvC0wUe
lQl/yfg9mxH+hXCDS2dlwSIZTVZrnRkgfFNOqaqBi0LEm5iTg4Q9fqZVDfJS
ENx3OvYRPlgwX8XLT0GH9//ieglvcrF+JSJIwU07FeteEx6SrXylsZrIv7Zm
8yvC5SPkagsSBYUsyy8WE07Ij6w+L0TBbdGSC+mEmc5D1SmbKMgzsSkxmPBe
WUbNo60UvNp6S82WsMBIUU3rDgq6S3XM7yfcm7eudkSYgkP9zZ1bCD908q4V
IFNwnJ1b9Zvo7zCZd7XiEoQZUfUcwibDqnUHpCmYNR05cIXwguNSXeAeChZd
DLETJtwmzaxPp1Ew066p/isx/llD1fUleym49kLPwduEtR1jGkbVKejizRe2
jvAO6V8Nq4F4vylWq/p/8+mHfqPMAQput7wreo5w6tmNTWeOUvDwhSBKDTEf
HaX8mkJ1KWhZWqF7lvC+Hz1NGXoUpDtdieMn/M3hdnO3EQWfr108qUbM9z0O
sq0MWwpqKHmqeRLr5ZOjsHvhGQpqeTeGDRPrK85FiLTmLAWlwtYq2xAe8pw3
aHOjoDqPxoDaDg7cDWx6YxBIwUR/YfsyYv0aBrN9HwdTsK722XYSYa6wJ5uF
wik4w2eleWoLMR+jbph3RVNQrVrt8zgRDzYnO380uUbBzTXJvl+JeFKbYnPx
+XUKMtdOVawj7H3thPCWDAoW37t0QWM9B17fVLd9n02M14sVJlFEPIq9v3Lg
5GMKPgywzO8n4tlSef7PUy0UvHT8WWjtMg4UsTPjK9uJ8R5V8y/i5YBl1VV5
sS4KuqYJTiTxcKC0LsCjr4eCDxZPeOpyceBch+6k3Q+ivdUjDutm2PD9+8i8
E684JmRNeFp8Y0Pq8OebTXziyNmXfuvGZyI+/+rUkBMUx5j8a386e9lwZ7ws
+BdJHLNoG0gy79hwcjGW12OXOCprfYh0aWJD23q5lT6q4kgLXxvGeMyG/a6u
Qzf2iWPwyNtu1YdsKKorqqsiTpVhbSoZwgVsuBJIjSAdFsdLo2NBXTlsYAwq
LeYbimMJl2dHXxobGks1/3xzFsdTjInh60FsqDll2nk8QxwPHxdqDCT2R8Wy
tEfn74hjiBlfXaAGsf9t7EnIyBbHj9LvLvmosiGi0ZLxM08c1/R1GhlQ2XBA
kVkT9Vwcr566FftYhA0cftfnrHZxLDjfwL/rHwvKisJuyPFK4DuZfSkPn7CA
j2G87RqfBNryrWo5U8QCgyHJdG5BCRS4nL64LpcF38ktqW9JEjirM25qlMEC
ofTNySG7JLDg7WZP/8sscA4vuNylKoHKLTQt7ZMs2G721ifQQwK1/Et3i85X
QAC3zPHmjxLoKbVZs4NSAYOHVnZLfJXArasruVt3VsDxyz9tQvsl0CZ5tdar
TRVAWfvQXWlEAs0nihyvC1RA8w7FhNuzEjjB+6F2fqQcdqnsb/UWksQHdHp5
wiPiPOdmyNipLYl2RzeWUFTKQbD3wlG3p5J4cXe0sb5iGQzcE03JDJTCT7fb
C+x2lEKK1NZlpcbS+GFjn3f17RJIvG5fZysig+oqzbp59KdgkWLVuuq7DH5s
POSS3fIIZg/lzGWyZFFxl3ZGX0QR9A0c8KuKksNJh9amRp48yNKgbm+x3Y3v
vqlB/sUcKLzks85htzyWL6zlO/r4DkQZn9blnZLH5d/oxz613IS9vXdyo1r2
ILe83lxfdiqQ5M/OPmzfg86DJ2Q7ElLhZ7D8ke7OPZj2ps6q9UIqZJPL+qV6
9qD00PXS0eOpsMG5S7hxcA8K0pN5Pi7+B38DeXX5uBRQdG6Tq4HFf/B+pVLl
0a0K+PtwR1HKzhRIk75R2KKrgAvBXG01zUkwOXE4J/yYAvqPy6jeKU0Cfdb4
TVV9BYzgllgbdy8J+E7oxOUYKiBIP/2REJIEPoFzTkHmCtiYn/Jcf28SGLaZ
Su12UEA+usG7vDuJsMpnw924MAWMaZeJYaxMgGBOfJpuqQLqbTYJLhiPgeGP
nJS5l0T9e5nvdbpiwGR+IvF+uQJq2v4e5i2JATkli2hejgIurtnAVesfA935
EhfKahXwbW1N6GWeGKBdY5+U7VLAje17D81viYZB17FdK/8ooKB9l4uqeRQc
226c00ih4jclva71lAhI65fnnJSg4rHbpl1JqyOgv1Dgw09JKoonXV4vPhMO
gVhOWitLRd2C6m2XG8OhwI4ceIJKxfjxBSHwCgfB4jHDXg0qLjiOutnXhEHd
oStcv02o+DVSrPjohVBYv+bs9mAzKr4t86pVsQ8F63eaSiQLKh5oSr6rbhgK
045TzjQrKm5NpoT7E/dpiQTLd76nqbjC5El814cQiHgvU7TkTsV3Ly6FLmqG
gKZb3cl10VRcO/ZuLFH5IvztHjpcHUNFwb+/9aZJF+HpwVW083FUzEtWOhkx
HAQSWw0EPiZQsUGlfcW2jCBYVd3z9EEqFcU2KgZI8QdB99bfqzGbikFPVtx4
/iUAPGo2cNzYVLQZ9d3cVuwPMgrK+aKVVFSnRFWSEvyh77p5alcVFTOF39mf
d/UHE48MF7VaKt79JyX/RMYf9m2X2srXQkVNm+Kgr/f8QMBT3etWDxVlfxo9
WMo5D5k7mJTmKSryFWcvnGf5gBpdVp45Q8VzfUV31t/1gS7tSeXZWSqGTvme
aozyAYHzkbqUBSpGph5pSzTwAY/XeV6BPDR0yXn4x3fQGzBygiO3loaz6gIH
UjZ6w7c/EVbxUjQ09XWf8r7sBYF8eg5kGRpyjZ/pivTwgk07N3uWytIQ6Qvz
j828QEcnN2JAnoZPSUIt5tJe8Di7JV9jLw0d3L6RPjd5Qrj5pr+/NGkYylZf
9WyjJ1Be3U/VO0nDatl8pdHz7tAqN5vda0nD/p1sGlnfHfxSjz5xsibqd7aL
D5dwhybHobZIWxo+iT5d2fTGDbxIsivYDjR0LeH66KPkBmyrooA93jQ8oImD
a7hcwWL26SlSPA09yz8pEyXBMuZy94wrNPTY2Wram+AERU3GQXKJNFy29s+6
dBcn4M6cTj96lYZ6lw5Vxko4wQMtlc6QdBp+rhMQMLzpCFPJZVpjOcT3saOM
DySchcTdVTIdLBqKZ3wWfJ5kDw9UTq4I49BwIe+7VoiHPbAPTn6nVtFwSPM/
AW99e/htLpGTVEND2ed+Pj2r7UE3MkbYoJloz696yYw4O+D7bLih/T0NBaqW
hD8knYGAxL7FlkkaanP1dfG8ZELyjcDeoGkahrjl7G68xYS8exvLds/SsEuE
01ASyoTu8iN+8fM0PCK9WnZJmwlKQ/njDB46qn9qpR7ttSXu097fm9bS8bPs
TGEavy3YTyx73SBDR8s5h+tHR63BOu9Qq6UcHV/Z+DqzX1mDiW1E05/ddPxy
qOaV2zVrONzGW7uRSseVwUo7fMEaJPJ5ymyV6WgScmlSJNkKBphcOXMH6djk
v3zDU01LONMx7ydtRccZmcKrUG8OltHqvuXWRH5rNR3TLHMwwoBz+qfoeDl6
g8vtQHM4VPTX1ec0HT91Jm+tpZoDJWaOWelIR7N+033mGWbQpznDMPel4x/f
AZpHiCkwH42LRCcQ6SW8aNP2xlC/IuC3RhLRnhgoED9kDLuZvOXjyXR8O7B4
O0rUGGbXbzC1TKXjBt69vN96jSDBe2/8nlt0bIOzv4eMjaBc2W/uTR4d1Zax
VNcZnICNrMXXYrV03Kn1aLmIkwFc2BSZ+a6OjqdHK77IHDOAL25rXOMa6PjD
NuHrKQUDKBAWFphupmMtt5XfsZnjcCAU9zd00vH1nkhuctRxcDsUnuf+lY6k
S187Raz0ob5RILx8gY4ex177rlZigMvBr4kNhKOsJR7fUmQAqbw04y1hSSXj
f7vpDDArdHo5SljrikaDngIDvic0j1EW6TigJCGdJMMAPuPEU/GEfcSqSFuF
GXDw8+b91v/oKKgVcGGvAAMGTUd1nQnb17Ha6vgYENNeb+5HWPdV7V6L5Qzo
qPT3SSbcFSyqGMzDAGb2h4Jawlbn/sw1LOhCiGPm9j1LdCxKNstljukC5dt5
6X2EM3lTBKf/6EK9xXFlbcKP9aMDo3/rAonBfeI0YY+OjOTiEV3IlD8dc42w
3gQzamlAFw7cV0/LJmxTZOF2tV8XBoU33HtEWGeGz16yTxfk19VUNhFOi7sQ
pf9FFzqib7V1E+67hI/6PumCL4/vxwHC/+xfjJz/qAvbAvRGxgn7RH5VWtWr
C6wJibklwmX////o/wCEUwJp
      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Times"},
  DisplayFunction:>Identity,
  PlotRange->{{0., 20.}, {0., 0.1251100357211333}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.389621819335*^9, 3.389621869723*^9}, 
   3.3899914992785997`*^9},
 CellLabel->"Out[248]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Mixture aspects of Easley, Kiefer, O'Hara and Paperman (section 6.2)\
\>", "Section",
 CellTags->"c:132"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"fMix", "/.", "\[InvisibleSpace]", "fMixDefinition"}], "/.", 
  "\[InvisibleSpace]", 
  RowBox[{"\[Delta]", "\[Rule]", 
   FractionBox["1", "2"]}]}]], "Input",
 CellLabel->"In[249]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", "\[Alpha]"}], ")"}], " ", 
   RowBox[{"f", "[", 
    RowBox[{"\[Epsilon]", ",", "B"}], "]"}], " ", 
   RowBox[{"f", "[", 
    RowBox[{"\[Epsilon]", ",", "S"}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", "\[Alpha]", " ", 
   RowBox[{"f", "[", 
    RowBox[{"\[Epsilon]", ",", "S"}], "]"}], " ", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"\[Epsilon]", "+", "\[Mu]"}], ",", "B"}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", "\[Alpha]", " ", 
   RowBox[{"f", "[", 
    RowBox[{"\[Epsilon]", ",", "B"}], "]"}], " ", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"\[Epsilon]", "+", "\[Mu]"}], ",", "S"}], "]"}]}]}]], "Output",
 CellChangeTimes->{
  3.3896128668402*^9, {3.389621883979*^9, 3.3896219037019997`*^9}, 
   3.3899914993136*^9},
 CellLabel->"Out[249]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fMixApprox", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"fMix", "/.", "\[InvisibleSpace]", "fMixDefinition"}], "/.", 
    "\[InvisibleSpace]", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"\[Lambda]_", ",", "x_"}], "]"}], "\[RuleDelayed]", 
     RowBox[{"PDF", "[", 
      RowBox[{
       RowBox[{"NormalDistribution", "[", 
        RowBox[{"\[Lambda]", ",", 
         SqrtBox["\[Lambda]"]}], "]"}], ",", "x"}], "]"}]}]}], "/.", 
   "\[InvisibleSpace]", 
   RowBox[{"\[Delta]", "\[Rule]", 
    FractionBox["1", "2"]}]}]}]], "Input",
 CellLabel->"In[250]:="],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"B", "-", "\[Epsilon]"}], ")"}], "2"], 
        RowBox[{"2", " ", "\[Epsilon]"}]]}], "-", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"S", "-", "\[Epsilon]"}], ")"}], "2"], 
       RowBox[{"2", " ", "\[Epsilon]"}]]}]], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "\[Alpha]"}], ")"}]}], 
   RowBox[{"2", " ", "\[Pi]", " ", "\[Epsilon]"}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"S", "-", "\[Epsilon]"}], ")"}], "2"], 
        RowBox[{"2", " ", "\[Epsilon]"}]]}], "-", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"B", "-", "\[Epsilon]", "-", "\[Mu]"}], ")"}], "2"], 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"\[Epsilon]", "+", "\[Mu]"}], ")"}]}]]}]], " ", "\[Alpha]"}],
    
   RowBox[{"4", " ", "\[Pi]", " ", 
    SqrtBox["\[Epsilon]"], " ", 
    SqrtBox[
     RowBox[{"\[Epsilon]", "+", "\[Mu]"}]]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"B", "-", "\[Epsilon]"}], ")"}], "2"], 
        RowBox[{"2", " ", "\[Epsilon]"}]]}], "-", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"S", "-", "\[Epsilon]", "-", "\[Mu]"}], ")"}], "2"], 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"\[Epsilon]", "+", "\[Mu]"}], ")"}]}]]}]], " ", "\[Alpha]"}],
    
   RowBox[{"4", " ", "\[Pi]", " ", 
    SqrtBox["\[Epsilon]"], " ", 
    SqrtBox[
     RowBox[{"\[Epsilon]", "+", "\[Mu]"}]]}]]}]], "Output",
 CellChangeTimes->{3.3896128668761997`*^9, 3.389621907432*^9, 
  3.3899914993986*^9},
 CellLabel->"Out[250]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TestValues", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Alpha]", "\[Rule]", ".4"}], ",", 
    RowBox[{"\[Epsilon]", "\[Rule]", "10"}], ",", 
    RowBox[{"\[Mu]", "\[Rule]", "10"}]}], "}"}]}]], "Input",
 CellLabel->"In[251]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Alpha]", "\[Rule]", "0.4`"}], ",", 
   RowBox[{"\[Epsilon]", "\[Rule]", "10"}], ",", 
   RowBox[{"\[Mu]", "\[Rule]", "10"}]}], "}"}]], "Output",
 CellChangeTimes->{3.3896128669152*^9, 3.3896219095299997`*^9, 
  3.3899914994835997`*^9},
 CellLabel->"Out[251]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{"N", "[", 
      RowBox[{"Log", "[", 
       RowBox[{"fMixApprox", "/.", "\[InvisibleSpace]", "TestValues"}], "]"}],
       "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"S", ",", "0", ",", "30"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"B", ",", "0", ",", "30"}], "}"}], ",", 
     RowBox[{"Contours", "\[Rule]", "20"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Number of buys\>\"", ",", "\"\<Number of sells\>\"", ",", "None", 
        ",", "None"}], "}"}]}], ",", 
     RowBox[{"DisplayFunction", "\[Rule]", "Identity"}], ",", 
     RowBox[{"BaseStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], "}"}]}]}], "]"}]}],
   ";"}]], "Input",
 CellChangeTimes->{{3.3896219251619997`*^9, 3.3896219538450003`*^9}, {
  3.3896220378929996`*^9, 3.389622089898*^9}, {3.389622221758*^9, 
  3.389622243935*^9}},
 CellLabel->"In[252]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"N", "[", 
      RowBox[{"fMixApprox", "/.", "\[InvisibleSpace]", "TestValues"}], "]"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"S", ",", "0", ",", "30"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"B", ",", "0", ",", "30"}], "}"}], ",", 
     RowBox[{"BaseStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
        RowBox[{"FontSize", "\[Rule]", "12"}]}], "}"}]}], ",", 
     RowBox[{"PlotPoints", "\[Rule]", "50"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"ViewPoint", "\[Rule]", 
      RowBox[{"2", " ", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0.9`", ",", "0.4`"}], "}"}]}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Sells\>\"", ",", "\"\<Buys\>\"", ",", "None"}], "}"}]}], 
     ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}], ",", 
     RowBox[{"DisplayFunction", "\[Rule]", "Identity"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{
  3.389622009024*^9, {3.3896221296359997`*^9, 3.389622197682*^9}, {
   3.389622253207*^9, 3.3896222538190002`*^9}, {3.389622327458*^9, 
   3.389622404193*^9}, {3.3896224529960003`*^9, 3.389622524448*^9}},
 CellLabel->"In[253]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"GraphicsRow", "[", 
   RowBox[{"{", 
    RowBox[{"p1", ",", "p2"}], "}"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.389622261493*^9, 3.389622314986*^9}},
 CellLabel->"In[254]:="],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyMfQVYlMv3P4goqCggoBgoIiIqUssuu8SO3YWd1+66dncrdnd3YaDX7sTA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       "], {{
         {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
          GraphicsGroupBox[{
            PolygonBox[{{3497, 4106, 216}, {3284, 3252, 970}, {5351, 4732, 
             1306}, {3283, 3251, 907}, {3398, 5111, 1016}, {3387, 3477, 
             180}, {3273, 3272, 216}, {4375, 3515, 1097}, {3241, 3275, 
             1306}, {3255, 3241, 1306}, {3419, 3497, 216}, {1097, 2564, 
             970}, {6316, 5492, 855}, {2511, 1108, 889}, {4744, 3527, 277}, {
             3261, 3234, 2750}, {4198, 4959, 907}, {3266, 3240, 2784}, {3238, 
             3283, 907}, {4959, 4199, 907}, {5493, 5495, 857}, {3232, 3257, 
             180}, {3477, 4953, 180}, {3280, 3246, 855}, {3277, 3276, 2968}, {
             3250, 3237, 889}, {3281, 3282, 3087}, {3248, 3247, 857}, {3271, 
             3238, 907}, {6318, 6319, 2564}, {6571, 6490, 2750}, {3245, 3284, 
             970}, {5492, 4163, 855}, {4260, 5783, 1016}, {6237, 5032, 
             1530}, {3236, 3263, 2751}, {4734, 5351, 1306}, {6587, 6491, 
             2750}, {3527, 4743, 277}, {2783, 2782, 277}, {6265, 6264, 
             2511}, {3249, 3265, 2782}, {6492, 6493, 2751}, {2784, 2785, 
             277}, {3267, 3268, 2835}, {4164, 5493, 857}, {4388, 4389, 
             1108}, {5783, 3398, 1016}, {5491, 4164, 857}, {6529, 6530, 
             2785}, {6527, 6526, 2783}, {5030, 6237, 1530}, {6491, 6571, 
             2750}, {4163, 4235, 855}},
             VertexColors->None], 
            PolygonBox[{{5025, 6828, 3235, 3256}, {6264, 4388, 1108, 2511}, {
             6525, 4182, 2983, 2782}, {3269, 3239, 1108, 2852}, {3282, 3280, 
             855, 3087}, {4389, 3810, 2852, 1108}, {3253, 3267, 2835, 1016}, {
             3240, 3269, 2852, 2784}, {4235, 6792, 3087, 855}, {3254, 3278, 
             2983, 1097}, {4041, 6829, 3258, 3242}, {5111, 4198, 907, 1016}, {
             5032, 4162, 2968, 1530}, {6526, 6525, 2782, 2783}, {6827, 6586, 
             3270, 3233}, {3246, 3245, 970, 855}, {5495, 5496, 889, 857}, {
             6528, 6529, 2785, 2784}, {3785, 4260, 1016, 2835}, {4182, 4375, 
             1097, 2983}, {6317, 6316, 855, 970}, {4732, 5030, 1530, 1306}, {
             6530, 4744, 277, 2785}, {4743, 6527, 2783, 277}, {6319, 6317, 
             970, 2564}, {3252, 3254, 1097, 970}, {3264, 3266, 2784, 277}, {
             3515, 6318, 2564, 1097}, {6829, 6420, 3259, 3258}, {6722, 4041, 
             3242, 3279}, {5496, 6265, 2511, 889}, {3278, 3249, 2782, 2983}, {
             3265, 3264, 277, 2782}, {3810, 6528, 2784, 2852}, {3251, 3253, 
             1016, 907}, {6832, 4108, 3244, 3274}, {3243, 3255, 1306, 1530}, {
             3239, 3250, 889, 1108}, {3237, 3248, 857, 889}, {3276, 3243, 
             1530, 2968}},
             VertexColors->None], 
            PolygonBox[{{4199, 6722, 3279, 3271, 907}, {6830, 3785, 2835, 
             3268, 3260}, {4162, 6831, 3262, 3277, 2968}, {6792, 6827, 3233, 
             3281, 3087}, {6420, 3387, 180, 3257, 3259}, {6490, 6830, 3260, 
             3261, 2750}, {4106, 6832, 3274, 3273, 216}, {6828, 5491, 857, 
             3247, 3235}, {6586, 6587, 2750, 3234, 3270}, {4108, 4734, 1306, 
             3275, 3244}, {6831, 6492, 2751, 3263, 3262}, {6493, 5025, 3256, 
             3236, 2751}},
             VertexColors->None]}]}, 
         {RGBColor[
          0.32520934005089347`, 0.11268443208005588`, 0.5741013855775641], 
          EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVL1PU3EUvdi0hT77+mhfSx+LIaEa+RccQEYnhUhMBaIOsulggsUE/IiG
RhdZiBqNMXEwkX7gpmCiMRjxY+LDyUQdtC46aQcZOCfnN9z0/e7vfpx7fue2
78z5kXN7zGwKFoNtdZj9gP3H93Av/IFZwzPrj5v97NB9iHMetonvuwWzI3mz
gU6z775ZqdusBf9T5FZh6yjaiMw+4m4b/n7cV4pmO6i/htwacv/CP46YBuLH
EP8oZzaBcxs9h9B/IzQ7Dv8DxF+KhK8na/YuY/YZ4MuIf4vvN4h/jPh1X9gm
0aedUZ39nrCwVxN9UogLca6g/0XYaNJsDjX3Oj/nOdipOrPoOQerxNw8XWZ9
5Am4ymmzfwndkSPy0wTOL/DfRs0R2LMu4a8Dz0pa3C7huwaLpcTlgOv1HNgf
In9fXPmvUopnndcp8VYH/nKk+EHgPVVU/XvI++ALA+sy91hS77cWF1f0xVzN
ZczdhN1AzGXUm89qBvLHHqx/CHhDzo6cFub9BWsnxP3vQDWvZ4WbmMnDltMP
8dJHzO994ePdMn6/+dLTCmq/iPQ+E3jHyZyweqg9ndVbVHH/EjgXgPNoUu/J
eVfzuqN/ClZyGr0J/1dfOrkSSZfUZBk8HQ6kMfJAfslPFX2uRconFwc86YR6
ZR7xf/KlY/qI/X5BvagF1qAeqE32Zt+ZorRFXfHMXuSEPVqu9qjTB+svAsNm
WnWuRsLNOO7EsMNM7REfsfVgj8YC8c2aBU94/gDbaqQZqGVqnRzWuItuX4hl
wc3O3aKGyOcdzLRYkO65NyeK4vos7tt4l8GEsDzJCU8d8204zHznbcfVBfiX
evVW1BPfhtiId9btEfM4M3P5P3Er0HzcFeYRD/ej4XbkJH7HuTO4z3RLH6Hj
g3msQw5KDsdpxE7nxe8u9Mi75w==
             "],
             VertexColors->None], 
            PolygonBox[{{6494, 4740, 1311, 2753}, {3787, 5789, 486, 469}, {
             6572, 6573, 2837, 2836}, {5552, 3823, 2855, 1925}, {5494, 6494, 
             2753, 1874}, {4733, 5031, 5030, 4732}, {5495, 5493, 1874, 
             1875}, {5493, 4164, 2482, 1874}, {4164, 5491, 1872, 2482}, {6588,
              5829, 501, 2855}, {4334, 6419, 2680, 727}, {4726, 5350, 1782, 
             788}, {5450, 5784, 2089, 2090}, {6574, 5809, 487, 2838}, {5032, 
             6237, 2477, 854}, {6236, 6234, 854, 2477}, {4235, 4163, 2479, 
             969}, {5351, 4734, 788, 1782}, {5551, 5550, 289, 1873}, {6526, 
             6527, 1316, 888}, {6828, 5025, 1527, 1872}, {6240, 6241, 1874, 
             853}, {3515, 4375, 888, 251}, {4743, 3527, 1895, 1316}, {6586, 
             6827, 969, 2854}, {6573, 5785, 2090, 2837}, {6264, 6265, 1875, 
             252}, {3540, 5553, 1925, 289}, {3788, 6574, 2838, 470}, {6232, 
             4160, 853, 1527}, {4163, 5492, 1873, 2479}, {4041, 6722, 2991, 
             727}, {3808, 5808, 1936, 486}, {6491, 6587, 2854, 501}, {6493, 
             6492, 854, 1527}, {4959, 4198, 1599, 1477}, {6571, 6491, 501, 
             2836}, {5110, 4957, 1477, 1599}, {6490, 6571, 2836, 468}, {6420, 
             6829, 727, 2680}, {5549, 6572, 2836, 501}, {6530, 6529, 488, 
             1317}, {4958, 4631, 727, 1477}, {5492, 6316, 2563, 1873}, {6319, 
             6318, 251, 2563}, {4199, 4959, 1477, 2991}, {3549, 5564, 1937, 
             1936}, {5791, 3789, 470, 1311}, {5783, 4260, 468, 2089}, {4161, 
             6238, 1527, 854}, {4389, 4388, 252, 488}, {5788, 3786, 469, 
             487}, {5565, 5551, 1873, 1937}, {3527, 4744, 1317, 1895}},
             VertexColors->None], 
            PolygonBox[{{3498, 4367, 788, 4106, 3497}, {3399, 5110, 1599, 
             5111, 3398}, {5353, 3498, 3497, 3419, 1783}, {5031, 6235, 2477, 
             6237, 5030}, {3418, 4733, 4732, 5351, 1782}, {5782, 3399, 3398, 
             5783, 2089}, {3478, 4954, 1475, 4953, 3477}, {6419, 3478, 3477, 
             3387, 2680}},
             VertexColors->None]}]}, 
         {RGBColor[
          0.3663682987297166, 0.18424874562826687`, 0.6319552811237561], 
          EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVE1IVGEUvZXR82ee48y85xtXRUt1hBZmu6wkiGgROZqZVAuXtdOohCBz
0aokpMCIwLLGnxxq0UIX/UhQtijMWhhEkNCibKXbzuncxce73/3uz/nOPd/b
de7C8fNbzewi1jasqzvMflaZbW4xS6XNLmXMIhzsrjY7GJitIma20my6Ugn7
EdOdmE1hP4SYCeTuQY18jVkR8TtRZzE2m89rv4mcE/huwP8S/lex9s9Ds4dZ
s2S72QfY9+Fvgf8vfLfQYxl59cDSh/2PCrNB2Cs5xZfQew6rGzGFQHmLqP8Y
WFodM7EX3B4FvnWcFRDTD3sVdg72JGoPoe4SYsZSZllgLqDXIXw78rrbgUA5
zN0L+5vn3gXeGcRcw1kRfHQmwnUqUV3WPAv7DFYZ/suIvZJXPrHVVwvfRq3Z
yYy4JV+cBTnsQ157Wty34M5rVeLwGHA+SKl+YyBMxPMFHD4CprZAvMTOyXX4
RmLtiaPkvHEuo36vWeBaCoWrB317E827HGEO6DWCuNvA+CklbJxPOdGMJlD7
cyjeqYGkRpyQb9Yf9kWb+PvQayASBs4wdry/UbM3K/6jBsyiQfqaRezTSDXI
DfVKDOzDfrTfgsMM9QFhNwXSLue+Qo3F4ohct7ke3sD3GqszEFbWoobvwfce
Oc3wz6Pnt5T44b2nIvXKNQgfsc0h/nsojZCPm67bonPB2keR9yLULCYR/xX2
vkCr4DOijqZdS8s+G/Zdg94HMtI8NfIxJ52UY82M8xoElo6Ucvh2w7Te72lw
uYH1DCklnP9Cbju4XUf/uUjvfQHnYZ381GOLYyIGap66ilCzy98g+aIWOceu
QLNgnYo66ZjYqBXG0M/3Pej4+bb+pDVfaoF4WYcz/f+fgN2T1TtkDPU+7Jrh
bPgWeZfaOt2HmKmLBdcG+ZuJxOFhnI/Fir+D75FINYYz0h/19g48jMfSC+fd
6O+o32dA/ulrcs08QY1SpDu3ejz9/H/0+Hvkf6XZ65B74iAG8ncjFIfkpsvv
Sz3yn8U61O94ThouZsU74/8Bx0vChA==
             "],
             VertexColors->None], PolygonBox[CompressedData["
1:eJwtk0tI1lEQxce0/NL8+/j072eromWl0KLHKnpIFNEi8pGZWYuWtTPoAUEm
IS1ahPSOwF5qptSiQqGnRdkiMmuRUC2iFmWr3PY7HRcDc++cmTn3zNzF+w5u
PzAnIjZjBdj7kojBqojOwojvRRFJecSjbEThvIh1AM6URRxaGDGTHzGB3QH7
Io1ozEScIOci/mQSsYrzUuw3/hh3Tfh1cyO2gD+fGrsC6+d8mnq5BRGL8iLq
6f+E+I6Me3Thb1UPYil3Q/jDWBe5M9xdIP6aHstm+03D9U/W3CqJP0vNQb0b
MuZym/zjheZ0lfPDxPXrOE/Qv6fCePW4WxPxNnGsujiig1hxmfXIgXlK/mPs
b54578lFnExnuc6nN9hXpfQFW4t+3dRqz/r8jfMm6veCXwn+Fnq3EduN3QvH
B+BaiT7Hiq2XepeWexbicCN1DeWuzpi7ZqjZ6Q2f6HcFTC2xNdgo9U6Bny7y
jEfkJ9ZSM5QWndRozrcmk5UR26g3Hn7vFP4Q9daDrc3zbtxPHPu/I/BrQYMB
3j6IvSO/iXM/flCzh9xzqd+iN4rbx8TcxVHa/CqzVtJoJ7kF5c5VzXr4Nszq
08sbsmizsca+NJpB67aceyunOec7+eLQznkt9fvwh7FWzrtyfp/qN+Q8Q81O
mD70Olvh3dTOjCfeCe3CBvheKzFH5aqGuDVmPTtx/Ap+ODV2CTkfEv8R7apm
rt2orjBe79VsRqqsrWb0APzN1LPTPLqJHQbzmdh++IyR35K1XpN85Eupe6qX
/sRP9P+BVeV7Z1q0G5Wel/heB3+EelNF/rNvEv8p8Vue8W4/T/13tONfEnNQ
b+3A0Rr/Of011dBf1s5qvvrT4no5dS1x7iC2N2fttWOt5L4sNXe9IWE2o1lz
Fed/Moulcg==
             "],
             VertexColors->None], 
            PolygonBox[{{6231, 5332, 5331, 4160, 2475}, {5332, 6230, 2474, 
             4159, 5331}},
             VertexColors->None]}]}, 
         {RGBColor[
          0.4075272574085399, 0.25581305917647823`, 0.6898091766699483], 
          EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VEtoE1EUvTGNybTOM20y4zSbIogKxYLoQnTbokXtQkmtIFQEoSsrVOxC
ERqt2KjgpzvxB9XgZ+UPbRWTGHUtaHVXN4pK/SxE6M5zPOPiMu/dd+695553
3yzfN7zjwCIzG4IlYVdCsw/O7GPC7FZg9gr731j358yKsFrKbH/WbGVkVkbA
T/iOtpttWGz2cqnZAPZ1YCqIe4w8yzJmU/At4GwB/tf47sG+gfVEwew0LFxi
dgbfO6g3ljZ77pt9AiaTUM2edtXdgvNe2FpgppB/M/wrwGEaGNeKusD3IXY2
b/YNfErADgMzCHym2cyDHU5qzRz30O+FSP2wl1Pg24tcFeT50iIcMVXUqsN2
ZhSXifNw35mSPuRb9cW5HznfgsNXcLiEuHfIOwd/F7BrYjzPd0XCTLaZ3Q50
Rt+bOPYqcl6D/YG/D+fbYevT0no0KQ6jkXQhr1853QfPn1ET9OURC23PZdXT
I/jvO2m1GrGrYGOe+p5w6p19+G3qZS/85dh/N9A98Y4ug+NG4BrIPwPMU94X
Nfd0Tj1nnfpn79SevMiZmnXFOnC+fjita1j3+NL8e1a1WfehE29y3goOx2Hr
0rp7zmkz7Al8M7Czad33XOx/4DQfjKXv3ywkFEcsMaW0tCfnAfTdDQ5VcNiG
fCdD1ZrGuu4LPx5otpjLAV/Mqq9GqFnhXHRj7nLQqgP+GuIOYu8lNLM3Q3Fv
wszuhv6bmlT/sycOeeSrBIrl++H7YOwgsMVI3MjlRCA+7Iv5uGa+675ynge3
eSe9j6DujVBzk0LdZKsw46HyMifv7liL7i9f0H1zfRHnk5H4MZ71qGG5oN68
WE9y5fq903+EvkOR7oZaMzdrsC/2RDy15RmxjKVOI5HW5E0tOQ/kUYrnivPy
Iv4v8U10RnoXnGP+Jzr+v42kePKMddjjX633poM=
             "],
             VertexColors->None], 
            PolygonBox[{{4621, 4622, 886, 264}, {5543, 6184, 2433, 799}, {
             3820, 4757, 1326, 1323}, {4757, 3821, 1325, 1326}, {3768, 5452, 
             1843, 2071}, {3538, 4756, 1325, 1922}, {6321, 4241, 2569, 
             2568}, {5054, 3765, 450, 1545}, {6795, 6794, 265, 3094}, {6677, 
             6676, 1921, 2942}, {4956, 4333, 423, 1476}, {4240, 6321, 2568, 
             3048}, {3489, 3406, 1770, 1083}, {3800, 5799, 2071, 480}, {6511, 
             3519, 264, 1887}, {3763, 5028, 1529, 450}, {5330, 4696, 192, 
             1769}, {5766, 5765, 192, 1843}, {5449, 4384, 178, 1841}, {4366, 
             5053, 1545, 450}, {6182, 6185, 2434, 906}, {6292, 6290, 906, 
             2534}, {4355, 5023, 1526, 1083}, {4181, 6263, 1841, 886}, {6469, 
             6468, 799, 1473}, {6259, 6260, 1933, 265}, {5333, 4357, 1083, 
             1770}, {3821, 6291, 2534, 1325}, {5508, 5509, 1887, 266}, {6187, 
             5451, 1843, 1844}, {5797, 3798, 479, 887}, {4086, 4356, 1083, 
             1526}, {4241, 5104, 1592, 2569}, {6675, 6677, 2942, 799}, {5546, 
             5545, 500, 1325}, {3396, 5454, 1844, 192}, {5798, 3799, 480, 
             804}, {6524, 6523, 887, 1592}, {4952, 3720, 423, 1474}, {6229, 
             6230, 1769, 192}, {4384, 4753, 1323, 178}, {5827, 5828, 2131, 
             500}, {3797, 5796, 804, 479}, {6183, 4036, 1473, 2433}, {3397, 
             6775, 3048, 178}, {3722, 4951, 1474, 423}, {6185, 4116, 799, 
             2434}, {5826, 5825, 178, 2131}, {5547, 3538, 1922, 1921}, {5507, 
             6793, 3094, 1843}, {3721, 4955, 1476, 423}, {5563, 5562, 266, 
             1933}, {5029, 3764, 450, 1529}},
             VertexColors->None], 
            PolygonBox[{{5024, 4698, 4697, 4086, 1526}, {4630, 4037, 1474, 
             4951, 4629}, {4627, 5277, 1732, 5276, 4626}, {4728, 5333, 1770, 
             5334, 4727}, {5052, 4731, 4730, 4109, 1544}, {4698, 5330, 1769, 
             5329, 4697}, {4731, 5054, 1545, 4110, 4730}, {4955, 4627, 4626, 
             4039, 1476}, {4036, 4630, 4629, 4950, 1473}, {4089, 4728, 4727, 
             5029, 1529}},
             VertexColors->None]}]}, 
         {RGBColor[
          0.44868621608736303`, 0.3273773727246892, 0.7476630722161404], 
          EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVEtIlGEUveOz0ZlxnIeOtkg3vSdqH0QURFguhMAUooyk1LTQKBHSyCkt
sNJaRKRBD6VFi8pFD8qkBxSECtXCRYW0MXXTpnad07nQ4uP//nvvd+65597v
q2xoq2nNMrMMVjbW/YjZ9bjZk4DZYMxsCGt9rtk1fBfg+wV7brHZp4RZAAdq
cuSnfShltugxp/PN5oKIy5KN52n/ANt8gVka+84ys7dhs1n8H8XZFqxX8O+F
bRTrC/hMwTdcaHYYucaB8wLcypBvBN/sYvFshu9SvjAncX4E8Q34PxiFPSUe
dxD/COdLc+VnHDEj4BXG+pqj3JvyZB/EuatYP4Ly7QfeEdgH8F0Cp0P4PiiU
f0VANS26fRrfhQLVujwkO/3nkb8laXYvIL4/XQf6lnzPeJ7tyJYui77vw9la
1PANXF5Cm7YyadMBju0p5doC/3RYfCqhzZTvG0Pi9B4xJaj1dZH6UoNz1dCo
Cfhrsd/te3IZcD2rYa+KqvZenO9GzQecO3MyZldUcYxJAH8Qs/E9R/nJiRye
ou5nSdU9EZT+7Bt7O+L9ZZ62EuHMFCiWMT1BaU0c9od1M549Zhxj0iHVR/4n
wWUPsD4GpeW0a3gZfLaCz12TrrPer3Zwvh3XbHwG/jvnxp4zH/lQG+pFfOah
BtwzdsLjN4aVg/hngFcP3AJgVqPu7ZznPHHiPHEGyLkx9B8v4/zJ4V9NAfHk
TJB/HfBuxYXJmhrdfhyaHcPKX2b2pkg9Zn/pT3tMEWw7fH7i2NfH1SNqP+z3
pQv2536/arGfSSgX34OxiO7aamgwmtT9Ju/SkLg/RkxnTGcz8PcmhcmcxTHl
JUa3vy1p4GzAOhfUW3IqpveEGtFWgf0a+Fem1P8lv0PsV3+52dmk8k66/pyH
JsQ2p/S/4LrN+12c93ndjD62ptTXCtyRnUm9YYmo8jEX667z3v2GnvucWxti
k1FxG+M9dh3I/U+RYvpg60+K582EtKbOvDcZ7zP7z5niDNDe6/XOJTSLnMNx
7LeFNQs3EuofNeS7+DCut5FvYZdrfgGaXCxXP6qQf11KuCdiwiVmxu8vc12J
qX7Wzlnoj4gn9Wzwe8d5qvFZ5ZuxKqW54ttAXml/53v8DfwLC7Xftw==
             "],
             VertexColors->None], PolygonBox[CompressedData["
1:eJwtlE1IVGEUhs80/s3UjDN35todN2WLitKobbSrRVK5EAIhiDKENHOMjHDT
r5YWJDO6KvqByqJFi1LRDNKggoLIoFwUVISr2rWpXc/hdfHBd+573nPe8/Pd
hvZia88KM2vmVHA6MmblyGwpYfZ4pdlU3qwJ+xL2YpVZPGtWyYnFzWZiZndz
Zn9rZa+uJA72UNrsO8GmsZ9yn+JbRZXwO9xv58RNYo8GZuuI9we7Efsfse7l
5OsxN5N7X2i2lvsAGnalzNoCcV3PA7A8ms+Bnak26weryShfAZ8y+rfCuU9t
P9DUW2f2FbuVe3WN7uVAuf3bc3LPchZN/CzYdK1q8Zoukm9PKC2HybcTfi8a
32B/Jmc32Ik6xR6nphnsPvB34L+SZvP4X6mnvlVmb/k2gb7JvLjXiHcB/0FO
O/db9P8qvsP1yuWc/dSWRtM3tLyHP0e8JfRug38In25y7cjIngcfg1vkWx/9
a4J/EO6jtPrv/Q3xbQQfTKjHZ4l1Pqf+uk9LRjGc2xXXLFpC9d79e+Duxacz
rpypQJpci2tcH2mnfJd8Rj6bU4Hm6zM6Cd5bMFtIqkfDoXrivejgvCbWUKj7
F3yug93IaxafWNyX4M/AR8A/ghcL6qH37kNStW2KpN1rbKO2V7XieoxmfHeH
mpXP37X4jHw2rmkkUk73/5lQr1+kFNvr9d72F6TNezxOrCMZ+fo+LuD7MNR9
TUy5Tkeanefcwr24vN/+xjZgb4zk7zlL3Buy4vqbfEL+iZx203d0DHw00vtx
fDitN+j76vt+INAb9nn5TLej52ZemL8J3+18INs5v+GXAvXCYxbZ5ctpafUZ
d5LreKTdOhrX7ndx5hJ6A7Ohdt533Wfib7u0/D/xeMcixXCucwZCzdBn5zvv
/4rJtOrz/fgPQiWkTg==
             "],
             VertexColors->None]}]}, 
         {RGBColor[
          0.48984517476618633`, 0.39894168627290055`, 0.8055169677623326], 
          EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw9VM9LlFEUvWmODvbZzOd8w9NVtiyV/oASLWqjWTZBv1uYm/LHGGHkSsKF
GWVlrQyaxWCl0aJSxzRoYdm0bNGqoIiCoE1hlrXqHM4j8OKb+94799xz7vfq
OrMH+krM7ByiFFGeMOsLzUL8yMfNXiA6sL5QbfY0MFvDmcEas6wzW8beH+T/
IlpiZlP4PYCz1evMtiJyWD/C+Qww5yLtMf82pjOxCrMl3PmNM7uBsQcxV2aW
TpqN4k4R52/VmrUnVKsC/wc9N+5PO52ZB3YBcaXcrI38nXg/R9wpFf+9yO13
6ul7ldmrNHoBh4M4P+DE7SxyPcBpBU4DcnMps28Qpx7rCOeGcfcB1juwnoyL
0724ehnCnSfgPgqcLuyPOa3J8bLvpRJ4UVKcTiPf7cQxi5qNWLcDYxMwXgMP
f//1Ij413pCSzgOhtKAOQVKecc3+f8Wl+yJ6PBoJqxl3ZzeK3zz+J3G/WCLu
L+PylL2xPtfb4PM4aj1DrUVoMh/IownkroHnEvKrwOxE3aaY/CRPep0KVYP4
LfCuGfGwEhyRL/j8e+D1A7ced84Ar9/p7kVgDiE+gmcvuHd7L+jDsVBeEONr
QjjsL1OjHtnLlPdiBL1n05qvJpw977RHHuROX+gBtWfdFWBOoO4K6n5CrcPg
9zMmPXPeg+3A6XGapTZyjqTXPqwLXp/N8OImeGbWi/tYWvxngDkaSSfqPew1
Jzb9JBfOIr2n78Q+UuP9ALc8uK1hrw74N5zwF9DjSFp3LuH8cqDe6Qf3qe19
5N8Ems0tTnPM2sfB8QSiskz8qBP59zrNJXUZD+UTcRrhYcZJY9Znn6zBN4Df
J78Dfsd5/y1z1if9u3E7pbmh7nw/GmrVO+eUvVODq+gjn1Atfot8Lzj7nNnr
TnM76fE7vHdF/13n/G/6OJuS1tSZM7UrUP4DcFqd5mcGWj5GlODMTr432JsB
/mfc+4JYjclPzj17mYbOJ71WxbR0p+Z8P35UybeFQO8j+zoF7ncjzdg75Gcj
zc+hUDzI4R9zhsfO
             "],
             VertexColors->None], 
            PolygonBox[{{5132, 5131, 926, 1601}, {5767, 3771, 457, 1312}, {
             6304, 5113, 1601, 2550}, {6720, 3385, 1731, 2989}, {4328, 5265, 
             1724, 712}, {5266, 4628, 712, 1724}, {4992, 4695, 747, 1504}, {
             4373, 4374, 968, 926}, {5744, 5745, 1867, 300}, {4934, 4615, 712,
              1462}, {3825, 5832, 1312, 504}, {6219, 6220, 1870, 747}, {6288, 
             4196, 905, 1459}, {5513, 5512, 275, 1749}, {6262, 4180, 885, 
             2473}, {4927, 3536, 1917, 1459}, {4625, 4935, 1462, 712}, {6224, 
             6223, 247, 2467}, {5557, 5560, 1932, 299}, {6286, 6721, 2989, 
             905}, {4259, 5109, 1598, 300}, {6701, 6702, 2471, 248}, {5026, 
             4700, 1291, 1528}, {4702, 4088, 1528, 1291}, {5484, 3719, 2054, 
             1867}, {6254, 4156, 849, 2500}, {5743, 4171, 2499, 2054}, {4171, 
             6222, 2467, 2499}, {4157, 6221, 2467, 2469}, {5347, 4725, 786, 
             1780}, {4699, 4993, 1504, 747}, {4387, 5541, 1917, 1107}, {4234, 
             6315, 2469, 968}, {4117, 5487, 1870, 2435}, {6190, 6189, 747, 
             1870}, {5774, 5773, 300, 1867}, {6489, 3514, 248, 1870}, {4718, 
             5346, 1780, 786}, {6222, 4172, 2500, 2467}, {5559, 6304, 2550, 
             1932}, {4173, 6186, 2435, 2501}, {4194, 4387, 1107, 1598}, {3512,
              5485, 1867, 247}, {3526, 6521, 2502, 275}, {5558, 3547, 299, 
             885}, {5017, 3754, 1291, 1523}, {3537, 4927, 1459, 1919}, {4729, 
             5044, 1538, 786}, {6287, 4195, 905, 1731}, {4174, 6226, 2471, 
             2502}, {3395, 5301, 1749, 177}, {3536, 4385, 1107, 1917}, {4755, 
             4754, 300, 1107}, {6252, 6253, 2495, 849}, {4701, 4083, 1523, 
             1291}, {6251, 6250, 177, 2495}, {6226, 4173, 2501, 2471}, {5541, 
             4928, 1459, 1917}, {6227, 4158, 2473, 2471}, {5043, 4365, 786, 
             1538}, {5542, 5544, 1919, 905}},
             VertexColors->None], 
            PolygonBox[{{5349, 3496, 3495, 3417, 1781}, {3385, 4624, 4623, 
             5275, 1731}, {5018, 3753, 3752, 5017, 1523}, {3473, 4930, 1460, 
             4929, 3472}, {5265, 3473, 3472, 3376, 1724}, {3416, 4724, 4723, 
             5347, 1780}, {3496, 5043, 1538, 5042, 3495}, {4724, 5026, 1528, 
             5027, 4723}, {4624, 4933, 1462, 4935, 4623}, {3753, 4992, 1504, 
             4991, 3752}},
             VertexColors->None]}]}, 
         {RGBColor[
          0.5310041334450094, 0.4705059998211116, 0.8633708633085246], 
          EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lV+IlGUUxs/+m93ZcWZn59sZxrkpWQ1LiuhOw2m3rDZzcTQpBbtIrK5S
kgiCiCDC2DVdSwi6WnUVbaEg21pNL9sVsuyP3WQliBsF3pgV2UX1e3zeLl6+
9z3vOec95znPOd+SbTs37miPiKOsDla5ErGyGDHFfqIWsYd1a09ELhcx1BmR
oZQvR+yqeL9/IOIXziu424nsK87VroiP+iJ+Rj6H8yZ6Jex/xed15E+i9w/y
y+juqFi/2B9xIvMbW5EdYv952LbZjZ+2iGH2m4nlKvJV3OfQu4j+ILJ16Fxr
c6x/ovc1+yb7efbfsP+sFPFWzfs1nfYrnzO99q/YnsDfq/jNE89z1YjZov1u
6fG70j+Wj7ibXDZh/2wj4hnWdwXk6C4MOH7leqTDPicKPuu9Ddzt5nsD+RH8
D5LzG5xn2c+wxnhr6SJ/v+WtILa2XutL3mItJLn8bGS9jO49OZ/Ppdj+RqWl
eDuMySVyP1CzbZOaPFZ3/D9Si5fI94cu5ykb6bcT1299rpFshFmF9fpi6lK1
jnJexlsnOxzbQtIRTsMJ2/1F80PcOFi1vWwfzMwzcUzxru92zAV0F7FaOfs+
ULCvKWzPF53rfT3GUZh8j2xP3eeRTtup3mfJ9VrJdVvPfYs1BTZ3UKsVDfs9
SQyzmXktrMdSDC8Q1+aiufcOeqPdxmoQu6WsfQVzU3rSEZcku8mnDr+juvxf
S2GyD38rM+e7CvyvZM77PfCYL/n9+zPjJaz0pnimd58n911VY/QAOmtYM13W
03eeGo2Q3yOsSWz+4P5w2T0gTogbiicq7kn14yH0LmHbQj7U4z5RjZ/C7nDV
dqqraqBeU14bEjfkby5x7yLxfoz+OLENZea0+DxKLKvL1plk/0nVOAiT8YTz
+9Top5LfVyyKXfHo/mjBOppDQw3jpjk0nmbRdmRPsy6g9zD+7y3bdhjZXs6X
8+ZvK82Z09idqTmHUXxOpvr+m7dM+XSiOzFgPKfxMYbPdvrsNnwua7iP5e/L
Aft8u+Dai593cX9nw3zZjt0E9lfwfaLPuAtz9fFI4q1wld3V1Kenex3DWvgw
TWzTnF/D7mzihuzm09xQrdQD2muezZVcO82t4yXPLs2zZpo/mglfJC6trbvn
1e/CWHfCeR3yR+vmheaA5qnm5+3ktLzhXBWv8lVff1DzTFHPbyLfF+t+48OS
/wGa5+L3ufSu5rrmo2ajeLk6Z55cR/575rPmxvKCMVEe76Y5rFoKS2GoPIWD
uCQ/S1Kc3bz5UOZ/wZvEtrfmO+FQT3P7U3zurvl8ili2gPWZXs9U9alwvpGZ
r/Kvf8srJfvU/P4r75l+UDjVfVafRJrPiquZ6qK5vq3sHFVD9bn8C/ebbyI/
D48erzjHGvrVftdZ2PcXnJd6TRwVN27p97zTrDuGv+OLrSfuTCUd8VXxqO/+
A34kEmI=
             "],
             VertexColors->None], PolygonBox[CompressedData["
1:eJwtlUts1FUUxk8LfTGd6XT+nWb6j4kiICjRGFaCaa2IWpGGgTa8AgvBx0Kt
QoLRhLDQBQJCSyAxMS54VAMSwEiGUh5LWxLeKCsEElLQJQQ0ykL9fXxd3My9
/3PO951z7nfPTF790eK+6oj4gDWRdaAtor814nJVRHMm4uNixIJSxN6GiPIE
fjnvwD6lPuIePqvzEX8mEX9h+5LV2BxR4TyhNqITwMaWiIecR7GV+TYzjZjO
epnzLvCfZP8Ua4B9B9/ugLcNvlvwjZDY8cSYwqolvg/+Xuz7sXfXYc9GnCSf
Mvks4HwJvm6+naWWYk3EdmzvF13PZHzawT9IfPWkiMXwHWB/Cp9F2P4D8wLx
F1kNxP4L/7pCxHBi7gT/zcS3kk8X+VSBUWSfaXFt+nYarD1F90aYQ+yPs7aQ
W6HKvR1gPVHvnI41RcwFfyaxo/C9xv5V1iD5X+NbD3zryfEcuX1Pj44V/U37
rWCu4/w5OT7EfyHnMWLXFr1/npxGchGH4euE7wp8Q/RmIXiD4J0i/zL77pJ7
oW9ruIv3WFfBH+bbJ9g64Otlfx57BexrWXOrpo3wdeGzG9tNejaD2B+xzyP3
nWCMwv8t38qNEb/Av4lcTvBthH2p3lra32atSVOqtTdvLtW8Ar6TOft2wLcb
7Opm343uWFp6OjWXNLUP/0HWBnw3cX4DvNdL1q5yvAfWKJzLwFvO2gLXD9hj
kjWxpOCaVIs0MAv7M6m1Oo1+DnFfdQXfzVCNaznTaizVtLzNb0Z8p8HbiL0r
sa9i1Isj+N+uck968J1PzEF8vyPmOv6PU98ifF8C84+8ORUvjbxJrjebnJ/e
5HbOb+Mz1uA3MxuuOYm5pKEB7JUmvyX5vIjvfL79VuMc301do2rTneutfFj0
W5I+H8O2B/+/ic3hcxutj7X4LehNTkvtI5ve8N6Sa1ItivmK81t534VqukF9
h6i/o96a1NuVJh9pkfMuzj/nrFX1SG99Tt5a1pt/J7VGpc1f4etps0akjQoY
n1L7iax7rxpVe2fi2aQe6K18UbAW9WYeYGsft7fD8VniGaPZovhOzarUvVU/
p6aeWZpV/RnfxdKCtaI7UW26Q92datzK+YWs56Pe/HDWOQpbHPs071o9m+Sz
CqyVBWtbGu+h/ufg+zrjNyjt3gV/RsYa1mz9J/Fs0YztI7Yu7/mr+fdsak5x
CUNa1wzT7JLmldv9xLWLX704Oq4X9USzuD/r2tWDedgnFjyrKjXW9u95a1Ma
FXd2fF4rh2XE3mpxLqrpTuKZq1k7q9axryTGEsY37O83uXb1VP8lP+UcL7yL
WWMoVm9cs2ZK6rvQzPkfSKfu6g==
             "],
             VertexColors->None]}]}, 
         {RGBColor[0.5699543306930553, 0.5374202052772205, 0.909638565392054],
           EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFV1tslEUUnnZ7h13+7nbX3Z+Ckd6gPAAtrdLayHJRaGIMF4nG8qBGfRKE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             "],
             VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVtslFUUhfd0egOd6d9O28yMLUZ6oRYTpKU1gqhYitjEqKhEoy8aL0+K
8iAiYDTGJxtoWokmRqAtabxEaluToniJiajxQaxFQqpg1Iq3oAYlPuq3XH3Y
yT7/Pnvtdfbtv+TeLZseLomIbUgp0lyMaELOoO++IGKmPmI950n0sXTE44WI
s7mI6lTE3OKIy5KIHdj/wN5YHrGX+7PZiFWVEcuQm2sizlUhZREVyHLutiPX
gjWIz1wm4uLqiHnw2pGd2BqRb9LGTGF7MWf/1RA8Q7y3wJvk3M55J7Guzvl8
kvNm4h2rjfgJLh/whv68Ywj7u0URf3P3L2QU2wQ+XejdOfvqWz/8B5ClcG+p
iFiHby8Y+/CdBXM38R+D33n4zaadi99z1pWTTvRVyBx4+ziXwWUZPkP49+E/
je0RONYTu4zzBOc3kQ9T/lbK/TSyFrwm7FPo12X8FuUvyzmDfMT9hjLnZixr
m3L0GefN1OgwtTkbjn0iZyxx6Cn4zXrrKHc28JYepJ94U+S7A24TtX7rLzRG
d11EUvRd5eMWcvFUjWOPgRfoU1XOpXKoXuktGks9cz/6fcgPXJ3lfBvxO+G0
F30azKfRx8BsIN4bcEgRuwQ5gb4GOc3bDlGP1kr3iGohDoqtmpQTfzXvGSf+
UfheBF533r3agqzH1pNzLVSTUd5zT+Je2MF7buDuxrzzu59vK7Ed4VwHt2Y4
bUD/J3EuZB/iLRt5w0Gw2y7ED27vIOfA3wTHrfBZlLi2qqdsv/KGP1O+M4B9
D9KY8rdnwRqG03a4zC92L/+YuLfV0wPkorTG3I+A+XmtZ0r1Vo9/C/Y4MdYR
eyk5vUqzUOVcCGME/sNIK3yvJMZa9OXKUdo5b+E9rUXPuu7ksa3kTgd4TZzf
A/tdZEnKHNPEXpExF3Fqw/fSomdZO2MN/tfnnathpAO9kBhLO+F1fPsK5nKa
+8ez3hnaFV3Iq9heQZ6o8AzeSW7G8Znn7tdp74aGonXtCPVSwo7oLXVPTYD3
EBz/LfFMlaDvyrr+yskM+hDxmiv9Ru2mkmrvFs3PC+DtKrr2p5Qz8rkn41yq
xw6h3wGnIvbv4XQe/5dz9ldMYX9JjM5Kx7gcvK9yxtJMf4rtGTgtAasN+3P1
3jmaLc3kFeC/X+9e0o65veCZ0axopk8Rry/v3KonXysYU1g1vH8E320F72Zx
GKlzj6m3lNOtnB9Fbk2bw0sZ97jqpRk4DNe3c+5d5e/5eveYeqsFvE+yjqlY
6rn9YB2oM3/19DT20XrXUjvqyaxnVLlXDQYT/zP0r9CMHyD+jcjP5c5ha+Kd
qV2pHB/DdrDOs6oe1GzexfmaCs/ocbiuSLwr1AN3Y5vh22/hOx8Tf3Ch3toh
XfgXE+8GzfAXxNqy0C/i0J54xjXbmpF51ZZvN6Wds+0510C51zf5TmadK2E8
gO+DRe+6//9xxD6ade7EQf8u7cyTC/P9H41a/eg=
             "],
             VertexColors->None]}]}, 
         {RGBColor[
          0.6002156891711842, 0.5860417880390154, 0.9103284311590973], 
          EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFV2lsVFUUvsN0ZmgfHV9nOnVm2FrCIih7WWQRpBYwCooBIxER+aNEUMQE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             "],
             VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmlsVGUUhr9S2lKGTm/ndsrMQBUQNGCEAoUqS0QatkQhEDUSlyh/FGXV
hCK0SFV2BcUICgIGBZXNFkgEEjEmLmEJUjYlgmCMIYrBBVQiifq8vP1xknPu
Wb+z3q6Tpk+Y1iaEsAloC3TMhXB3NoSe+SE0JkLIQI+D3gr9AvQM6JnA4fYA
397NhBCXhzAA/J/iEHYi+zhwEH4O+WeTITyNzAF4J3GwAd3LFSHMahfC5A4h
fBWH8EA6hCFFIWzDxmR0pwBH2tvHE+ALUyEU5NlmE7ZWRCEUgRcCw+FH2JyD
r0r0s+Dd4VeBv8i3XuA5vi0A/wD5P/CdKbXvOmKYhv6r8HsoFvibS0JIlGET
/VPkYyr8J4HCPMc0GP93ZGx7JW8aAD4G/hZ4L0PnK1ZgH0ldhf5+7DWm/Xa9
4Q14Q9B5vdg5G4/uBGA3+ruAmyPnRLnoD5wlt+eA8gLHtJJYdyH/SJFjzpb6
TXrLbcR0BN1u2HgePFtIHsDz0R8D3g1oC/41Mrvy/a0H/GPQN4JngLeIr5r4
XiK+s8R/HN5nwI/gXeAH9FugbwAfBYwllknEdDThHulM7vYQzz3EsxHxrpFj
UiwVwEf0Qwk2xoNX8qYDsoVMGXQMrCNX64GF2PqVfJ2A30wOL8gW/I7oriFG
VMJE6GbsNSGTV+gcNYPPTDlX+tYIPp34zhHfIb6dQP6dCvs+i/15kWOQ7y35
jqUi595XTI/lnCPlRm+8iux/wEjoYUAb7C8npn3gp6nx0aRnQL3fGfiG2BdB
/0Rt95PTFnzvh+4F72FytDvtHlTvLaGmXcj9TUBDsXPQB7wj/ucjv5hvX8Su
uWod4TNZ7jfqbcrpAviHY+f6U3J0H7bvB8qha5FpIb6+2FyKrTO8fwfxHUW+
U6FncA3xdINfX+x52gb/EPw0/PPBvbc767epB1WbqMy2VaM84ukTuVajgd7C
c+6dQchcxP/e1v4Y186zfAn7NYWe6TO87W++VZPLb6nREPUe9DpibYKuBP+X
byOQvwV7/VLWkewVdP6CXxeblg318npkruW5p/tBH0+69sugjxD/Cvi9kJ9d
5NoMRGZ5sWtUBZ6NLLuk2LM+Outdopn/nbecZw4xeX2njSR/3dGZh2wV9l5J
+c16q3ysTbmH1buKSbuxWjpF3pEjydWInHujCf8D0p4pzZJkvi/3jtJuuoyN
23nrnKTzswP7U7C/lm9XCjwPDeCb4e+B/x30eGwdQObeAses3fZU1r2pHTcb
vA54Jt81UW9sx19tW/dIPUo1sX3J55vEMxB+U3D+tctOxt412mknO/hG6Dbo
zsxFf3DsWkp/Kbq9od8v8L6sgZ7F+y8k/GbNQhy5FzUTqu3qpH2pxv2hG5Ke
va3QvdHPS5nWTD5E/h4E7sz3zuqPvVzkXa1+WB15B2v3/obP16DblLt3f4Fe
Bd2JeBaBX0p4d69OeTdqh2vXDsr4FmjnLo98o3Sb9IYUumU530r1xMS0bcrW
UOqZRz3W8YY/C1yjRnibWvN1rdi3TDdYt1c37S7e11zu9yvn2m3zU8a146Q7
H52WhG18DF2bcy9liKkvvIac36qcdIqcE+VCPT8UvGfk27QKei++Bqe8S04X
+pbeGpmnm9oA/mXsXaSZvH5LkFmW8E2pzfpGq37bC7zLNFOaJe20HyL3gGqv
m1mP7lygBvnFCe/yGSn3u3Z6lfq51LKq8U7iu9q6L07g7wq8qSn3vmZgE71R
H7v3lV/t7g9LnHvt8JXozsHfxYR9rof/Xuu8qCafx9452jX6J3oU2eci3wrt
RN3SU7FvtW6qbn917F5UjMrl5oxrqZyuxffwEseqmLvCayp1brRzFYt6UL2n
mDakvaO0m+qKfFsry3wbtUMzkW+EboN2+kDk305bVv9EB4llJ/rDinwDNKuj
0t5N6pmN2DuW9C3QzOtWnS7xLdLN6kI8N+S8u1VT7e6fkR/bzv4/0T2r8Kzq
m2alc86108z8D16JW+U=
             "],
             VertexColors->None], 
            PolygonBox[{{4690, 5298, 1748, 5299, 4689}, {4604, 5263, 1722, 
             5262, 4603}, {4607, 4017, 1454, 4919, 4606}, {4016, 4607, 4606, 
             4918, 1453}, {5020, 4693, 4692, 4084, 1524}, {4923, 4604, 4603, 
             4018, 1456}, {4062, 4690, 4689, 4989, 1502}, {4693, 5022, 1525, 
             4085, 4692}},
             VertexColors->None]}]}, 
         {RGBColor[
          0.6304770476493131, 0.6346633708008107, 0.9110182969261407], 
          EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFV2tslFUQvWW7K93tbvfRbXcXihTQlggNBUShJBp+aIyk1SqQaDRKJDyK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             "],
             VertexColors->None], PolygonBox[CompressedData["
1:eJwtlllsVVUUhnen21La3nvP6W17C0XqADWxlUGQwcThQWPEFsFKYqIgiREC
zmIUEGKiQBsIYkCmMlUJYhTEoJEXFRCMYMEBETHWUtSoCYOizBq/P38fVrL2
WcNe61/DPrWTHx/3WG4IoR3Kh46UhjAvG8JvxSFcmxPCsTiEBakQmhIh1EN3
pkPYGYXQWBACqmF0VQijoIa8EJb0CuFRbKdDHZw78DEI+xz0l6G7GZsGfPWr
DqG1dwgLoV3Iu2L7LoGyyEZW2de72PeHn4RNF+dZ0EXufyMZwiZ8HSbgbvgO
7Cux/ZlvS9F9D5tibE/g/xv55ttI4ilFZwqyaVnHtgZ5M/5WEd9gbKfhbyP+
GrAZCL8j13evzYTwbKFjWA2/EnqG8wxoLL6aso51G/Qq8S+BOsGuD/6PY78J
n28V2KdsJ/Kts5d9NADi4vIQvss3RjvL0MdfCtsN+FuFfpxy7tK/kfjPol9J
Pov5loSfj7yR3MZBBytDmFPu2Acj70Z2oNK87k8Q2yXiycO+N/4nZIyZsBpd
aOyWpSwThrPAYhj4/IG/H8lhD+e7iW8LsiT3Rfi7Gpt++JuNj0Z0Z8bWTUA3
Ra6RanOe+3fD3xtb/xA+N5LvUs6nevSr8dUHGgR/AQxnIa+PXW9h1Jg15sJ6
K1RO/Vq5YwDyH9DfA57zyakR3RTnu9D9CvlPYPs2+vvhm7DJcHczNs/j/3za
tm3QOc7r0WnG/jLn1fD/8G1ogXukP/leAQ3Ocw8Pwf/kUtfiFfxvALtb+dYO
fybPs6SeU69ppq6BT1cbq7nYTISfi81BzgegFdxXx3lpL2MwXbFTz7/Aeh85
PIH+QuQF+OpGfxLn/pzr8+zjIrHsi5zbVHKoRF4B1SF/B5u/yeVghXv9IvkV
47s7NlbqofHYnk66HkXQCM4LkP8Kf1I9Fbun1Evq6ank92S1Y9HMDwDLwyUh
3J8whtupxUbki0o8E/cg74J/OOH4tFvUw+pd7RjlJoyEjXL8F/0W5B8kXH/l
up8Ybst3ziuRDY3cS7sS3g2yka565jS5Diz3fTOKrLscDLbm2KYWf1/E7k/t
sJe0G8CwL/KnmYcWYmmtMl+X415Yi48hBe6JOSnXULUTxuu5qwb5+9RqL3f2
UyyltlV/aZZW9NyvmcoQ7+eRsVBPqvYxPiYk3AO13H1llWf/U+Rp+EroKWRp
9SC6LaXeHcLod3zXcGcT/sYUeffVVnvXagce5a5a7uyb6x4YQe7bkvatfTqM
et2QcazyoV5oijyb6ok47ZnTvHRAnchnx5Yrnyng9wh0FNlVfPsY2fLIvVxM
fB3U40yZZ1v98TLy0ZF3g2qg2WxM+20RHqrduLTxUQ3XENvyjOuhnXw7/B0Z
11475QXy/S/2btrM+Szn8ynHJsxrwK5vlXtfNfxT8UDPFdn/a8Q2qKefpK9d
tTv22yT/FXpbiOfmfNfgXNo1Fl6H8r2rZpYZS/XfqaRnSrN0AkoSy5qe/hEe
x8ivq9y1lM8d8B+We9aEid6KRdrnCb8ZnfBTIu8C7YSHqO3kau9C7aR1ALck
9l3SuQR/GWrP886vR34h7fjkU7vqlqzfGu0svaXHifmXAr+pp8BmJ/Lr6J83
sW/Hvkk+4IeDf4p41qe868ajf7jU38RrB78OXrNTth1VaOy2cEdIOF+9JWOy
3k16U1ZGxkjYqGfaIveQzsJsPvyqMmOjnVSgt6qnHvKpt2RTmfFWv1YkvQM0
+8rhSOQ3X73/IPJ1YFeFTlWue6CJXhqbcW7C7NsS7zT1qmayDv9tGb/92hHD
I+9I1Usz3wJ/Nu1e0Jukt+VF9B8o9Myc5Hx97H8hzax6WTOrWVVPa1d+X+p/
L+3MNnRXx66lcmoll0/KPHs12Hwd+Y3T26Z/gi+Rbc/630MzuBfbz2LPgnLU
v8WuMtvqH0NvY3PGtdEbOQ/d+zL+F1APfKT/wcizrBz+BzrDYDo=
             "],
             VertexColors->None], 
            PolygonBox[{{5039, 4714, 4713, 4101, 1536}, {4911, 4593, 4592, 
             4006, 1449}, {4593, 4914, 1450, 4007, 4592}, {4714, 5342, 1778, 
             5341, 4713}},
             VertexColors->None]}]}, 
         {RGBColor[
          0.6607384061274421, 0.6832849535626059, 0.9117081626931841], 
          EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1l31s1dUZxw+W3nJLf+3v/n733t5epYY5x1K7oWYOXFjiYFrbOetwA+PL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             "],
             VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmeMlVUQho8sd5cF9u69391y76UFO0UQA4IGEyKGpoKgYgKWBOlNCWgE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             "],
             VertexColors->None], 
            PolygonBox[{{5142, 5840, 2140, 3828, 5141}, {5355, 5142, 5141, 
             5354, 1784}, {5838, 3581, 3580, 5839, 2140}, {3581, 4825, 1375, 
             4826, 3580}, {4767, 3551, 3550, 4768, 1333}, {3551, 5835, 2139, 
             5837, 3550}},
             VertexColors->None]}]}, 
         {RGBColor[0.690999764605571, 0.731906536324401, 0.9123980284602274], 
          EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1l3uQlWUdx59l9yyc3T33s2fPHloQBBTBnEpEqMFuk7haA9h0UXGMAgoQ
ArxEjRikQoOYI4FIUAtYk5jV1LBIf4ABi5FcViqX3TXlMkoTyK28IJF9vnyf
/njmfd7n/d0v39/zDpoyZ9LsPiGEWVUhVPNsLIeQzIUwriaEj+RD6MmEcByC
nmwI25pCGMz5yUIIE3m/rjaEvzSG8DJrXd8QXuPsddZQaDpYz8G3AJkfY9+V
sJyrkf2fdAgfoG9LMYQL0I/i+z72M9F3EZp7KiHMZ71RH8Ifm6xbeotJy5XM
tzn7d9ayv409a1Lep/qFcCd0bTjzD/RsbQ7hLXSNxY+F6B7VxzrPR73N+Lun
FMJt8B3Ej3+l7MvjyNwI/xZ45/K8CZrTnL/CcwRyvgzvYWSMgG4FNB3Y2Yau
K9G9FV1jkbUHXe3IXwfdW9jTiz899bbnPvh6oeshLod476pjj19XwN+J7E3w
dqP3WfQd5XuJ/Qni8xDfBiCju8r0Y4jTJOT/nLNWvt/MqkHmUvxYUnQubkTG
+Gj/4GrrE+8g5ZO1Ad9v4/vtrAvQLELXoSbvT1Xb9qOsYzX26Zfwv8j+17XO
sWrk2rzzOxl7NuNzBn86Oavw7avYcwsxy7LPQTMD3gmcFdg3oPtYlH8C/blI
kyWWH8pbXwaZ43hvQ2YevtnEKA39PmhHQ9MNzUr28/H3GeU3Ybslt4AtxbJ5
/kyM0shIsX6Prjfx8yS+tLPfwroZW7Yjpx6ZB5GzBZ290FwG30xseI2c9a9y
bmWfbLtInPfD+3HO1yRcp7Lhp9jyCb51EKPvQ38g7ZwlGkK4Cz2EI2xIOD/t
fVwXsqXCmg5PU51pjsb472A/rMq1kGZt4+NxbJjB+VLlGV2b4Xsjbd8kaxf7
b6K7k/0dfC+XLXNt1nUpueuhLWVdFx3Q9mIf5oUk32s4z3B+HjldJdtdYfWn
LlYE19qKguttrmqlyvGR3MeTtnkj9IuFJfjYv59rXz4qR8U656k/+y/w3Cle
9N+DkS3BMVgW4/AQ+qc1O4ab0Lkg6x6/j/Nn066jZuLQBf/txOEJaD7Iun9L
nJ9gfYXz2cR5CTIT8K7C35Wsedh+A74sK9jm9eT6B8gtIvNQnXtTPSNDhFPC
qIP0Ryfro0nbcrFgexSH7qRz9fka50v754nn5VnHZX+1z5THp9PGGtn5KPtp
BffXRnx9MG35I9iPbHYsJjY4XorV75D3InaPYd+KzG0J1+1p7NxAHW9hvy7h
XlWfzkX2vIKxWDbKPtnxdZ6tnKWgmQBvIePebGb/q5LpZhCTWRVj2Mms+0S6
nsLGqch8t8YY0B3nhWpE/ao6OVft2pCuMdCMzZtevTK9zli3MWO7ZfOfkDcQ
HXny1ULdJptNdwXnwwrumzboh7Jfz34k8kZB9xt0jZOMvGtY9aNeUt5fqHWM
ZLN8nVJjfw9E7FUuNM+UG+01ZxQ7xW0XNbKb9WRf4/7kWs8vzSf5Jh7h0w0R
o3QmLJHPwr5FNa7nl5ucV+V0K/Xwh7J7QLj1QMSuTMQn1ZLqXdihmi8S5/tz
lvUdnp8ruq8eJQZPZY0TsyvOk3KkeXAo1u0seFvinJqKvIkF14qwc2/G+HmY
52LOj3D+DM/3M+7RAzWOsXjlz8nY473I6WGt7+s5Kj71zjJ0TYk1fIraeSdl
GmHtY3nzt2L/kKJrbBdnHXnPg/Gc72Q/tcazdE7a81T3kXzZd5KdxHBHk+ek
/OuOudvN2a4m01/q13i+DL71mYixCWOVek05Oxf78EjKc1251cw4FefRbmy5
kPK8Us+N72ucUn4GNviuodxoHqsfHyP2P6r428yEZ7XuGx/mPVtn2Z/Enm80
uhYH1ptXs3g48biSNa3Wdan6xJVLM/PSXOzj/H+q6BrQTGqpd/0K478VcV55
XZt0nd9JXTyCvl7e2/FjeqN90Bwfk/T8Et6rZ9QvfaB/qejZKqzXrNK96N2i
a0719ir7LyHrTK1l6I4gOcKlSQ22QXk6W+vZsSBnfvEOpi7ezBkT2tG1j/hW
cf5Fzm7NOc6aRW0lzyPFRzIVI/m0JvolvBbOqg53IOO9lDFQNXUJv6C5Hjmf
wfefwLMSvatYZ4jNcs7nVZz/Wzm7Jm/ckB7pk/0/RP+2tGfdbJ5XFXwn0+zS
nNb8Uk51n1C/qrfuTrtHVI/CEdWesPl8tE35HFDnnCqXqnGdr+ZgXdJ1tZD8
PNjontU8S8ea6dIZqw2f30Zed9yPRO/JnHtU99zjaduoel9Sds3rjvBwk+8J
+3UPYa2Fdwq0f895NuxpNMYJ317C99fRcQ1yXsH+y5A1OWE/5a9q/7PwnUl5
bvQkXV/KqfBaeCesU70LP47FPA6Ksb0pYT7VeDrKFE1nyXNaWD2c/dWsLs3S
vO9Yul91o/eutLF5BLRXFY3v5/jeGf0Sng2Id0LJVp4uyYdnaNKzZivxWJXx
vhnact49cQid7yP/a/1cc6pp9bV6f2KsbcX7nzHm25HzQpPlvgrf88328xbs
Ogv9wlrHQTYofpWcZ+r/7wUH4h3gF3ljkPBHd4Try74n6O6oOSlfdnHWUXYN
Dapz/aiOzpf8byCs0R3ku/FedBp5n8657m7MGVvFI+yfFPH/gZz5xbs61mBr
xDdhm+Rorv44zlbl5nv9nAthuuyQDXPqfa/Sneq/KedMNLqPKu6a6auJybUp
z+FF6GxPO7aaXfeWjLct5OSdknX8FRl/Y92BndVZ30eFJ8OJ8YSU73Cq05/l
Xat6Ho51O41a2Jl2fPVvtzf+36nHJ0Y8WQHNkEbfU2ao7/LOs+5NR7K2WT7J
N8XiPeRtgOY6aBaXfEfU/XBTyfqka3rB9aRaUiz1XT4K06viHUCz8XTW81H4
rVklXmGA6MW3ERlPs0YnrF//s7JhCLV2eZPv1KmU/wHU1/o+J8Z/L+dPNBqj
luf9rv38euOysF3/2WczvscuaXK/qdf0T39vxfilPKkmWuPdTXg7LN6VWuLM
Gp31PBONsFlYqzoRDt1dMRaplxR75SXFWUPFtizneX/JfmmW6L9Otj2HPQ9n
/K+/P21MFB4+UvQsF6Zp5mo+yIbNWc8SxXc79JtL/s94kjj/Nm25yrHOKvH+
IgzX7FiKvIfLxjDRaT5cjP9ivZHmf/SSWz4=
             "],
             VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3twVdUVxndCgiTknnvPfedSiFCilYRxbOsjtlMq1oIUOw526gNxNBYz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             "],
             VertexColors->None], 
            PolygonBox[{{5144, 4392, 4391, 5145, 1627}, {4440, 3871, 1372, 
             4821, 4439}, {3872, 4440, 4439, 4823, 1373}, {5581, 3570, 1948, 
             5583, 5580}, {4392, 3832, 1334, 4769, 4391}, {3574, 5590, 5589, 
             5595, 1953}, {3571, 5581, 5580, 5587, 1949}, {5590, 3573, 1952, 
             5592, 5589}},
             VertexColors->None]}]}, 
         {RGBColor[
          0.7212611230836999, 0.7805281190861962, 0.9130878942272708], 
          EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHuwlGUdx18OZw9n2T27++7tnLOgCAEKSGigXNJhdIhb+I8WFy0VsUiS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             "],
             VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3mQ13UZxz+77MnvvneXw0QOF1yIBDkymRojMJqMGkXNAjpQEljYRZxR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             "],
             VertexColors->None], 
            PolygonBox[{{3554, 5844, 2143, 5846, 3553}, {3607, 4842, 1388, 
             4843, 3606}, {4773, 3554, 3553, 4774, 1336}, {5880, 3607, 3606, 
             5881, 2173}},
             VertexColors->None]}]}, 
         {RGBColor[
          0.7515224815618289, 0.8291497018479912, 0.9137777599943141], 
          EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHmQlsURxt+9v293v3O/cwHveCAKKgJWACsBiaukpNREOQREjIuICmKV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             "],
             VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlw1dUVx2/295K85ffyliQEAbG4FAe0LtiyjKDYIB0YtVpkX2pBBBVh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             "],
             VertexColors->None], 
            PolygonBox[{{5863, 5359, 5358, 5861, 2156}, {5395, 5398, 1808, 
             5397, 5394}, {5359, 5579, 1946, 3566, 5358}, {5675, 5395, 5394, 
             3667, 2008}},
             VertexColors->None]}]}, 
         {RGBColor[
          0.7798315502795794, 0.8527339251933471, 0.9063251688887227], 
          EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXl01cUVx39ZX16S9/JekrckVQlQlCiVRVBrAbECVhEX6taKJixCFdFK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             "],
             VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHu41WMWx3/n2t7nnH09e+/f3meYkgld6CYZk8qMZJzJpXGJoU6daJR4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             "],
             VertexColors->None], 
            PolygonBox[{{3597, 5363, 5362, 5615, 1963}, {3698, 5416, 5415, 
             5708, 2032}, {5416, 3699, 2034, 5712, 5415}, {5363, 3596, 1962, 
             5611, 5362}},
             VertexColors->None]}]}, 
         {RGBColor[0.80700830406364, 0.8617966484300827, 0.8941500075474393], 
          EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFWWmUVNURftPTe0/36+7p1697YkS2ETwoS2I8gSCLgijLCYYx8YgwLAOM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             "],
             VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHeYlNUVxr+Znd2dLTOzMztlZzVU4QECypIYn4goKGABSVDWFFTa7gKC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             "],
             VertexColors->None]}]}, 
         {RGBColor[0.8341850578477007, 0.8708593716668185, 0.881974846206156],
           EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXt0VNUVxm+SSWYmZGYyITM3EzAKKgIKiBGogPgC5CG2IpWKT0AQMYLK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             "],
             VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHeU1NUVx9/usjtbnBlmmZnfzopIE8Gg0gKRBQsCUsQY3UgQIs1VOipN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             "],
             VertexColors->None]}]}, 
         {RGBColor[
          0.8613618116317613, 0.8799220949035541, 0.8697996848648726], 
          EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mHmQVNUVxt8sTPd00930MNNvepJU2BTLLVOOImSAYdOoKCgjLqiJiiAY
FFBQWWPEJcoiqbgAakzFpBJHhWhFC5VYmlhxBdQkleASica4a2QrFcF8P7+T
P97M7fvuPfcs3znnu6//+bMnXVKbJElBf+r0v9w3SXZWk2SxxlNbk6RfIUmu
0vguvd/QkCSra5LkR2mSXFRKkoWaO7iYJGvLSbKmPkm2ZZPks1ySvJDRe61Z
1+a5jxuTZITmh0pOp/7/Ue+P1niJ1gysJMk0jfflk+RLPTm9W9o7SS7WU6fx
HVrTp0X66Nw26fWb5iR5U+eeot9P6P0Q7f1U8g/SeB1ytPY16T1Ga4ZK9oOp
9V/ZK0keko5Xa36O7LhJeo2SjGUaf6D9J2v8oOyol/3naH2jzl/AWs3/Svv+
pfUzNH5W8p7Tc4j2zNP8Cs0P1Loa/V6p/wtrbN8TYWN7vfW9V/NzpftWnfGH
euu8Q8/jeveIfq/S/0Va00v+LKfW7Ycl+xo/3ynb79DTKB89kfd+7F2hve3y
6UitOanWcWjX/AU661LtvUX2bZdPtson/fV+i57teh7Vmlrp+KfQE/99GvpM
l/yjNL4zsX3Lw8aXJfsCvXtQ4y7JHK3nbuk5RGedW/aa/+ict/V0Sae9er9N
41G1tgFfniGZs6TTAXo/QOOZsvG/rfY1uJmh/8cnxsDuvLGDvIltlrlZ4y2t
3v9wxjgBVxMVtwl6NinO7+r9e3rGaU2n3n+QtXzePd9g+5dL3xv1rJJNm/U+
r/8Tam1fLmwcLf99u2gfL5Ces2XntZq/TLjqRyy0Lyv57YFVcLVScwdIn836
/c+s7f1Q+7cGBjib34wPbFIM2vx7j84cnrO963TWaJ2xgT0an9rmuFzWYF0G
azxQ8mdr/ZO1zp39eecIcdwfudCjtUtk80xwIVuy0vlSzV8RMtBzsWQ8lTcu
+P/nGA/W+RNk+98k6yT59XTp0KP1zZo/XPNPZZxb1Ajyq0nzhxaN/TU5+3y6
5nc3UVyS5Dj9O1S27dL75Yn9uwc9pfMIvR+kdfdofqd8OatgDD8qPc/OWc4y
yT6vYtuW6tx/V30Gdp+Vs+0Pl50zYG2R/n9S9bsLJa+jahyPkpx9Tc5lahVx
AndHKbYHas8A7b1ca7p11u6M681fS85hsEKeUSvOBQ+pY0wdAPvkbC+Nb8g6
1wp6X0z9e57k/UJycxr/WnJ/EmvYh15d2nua3leVM1fXeA3vmT9VeydX7K97
ZePZOnuq3n0uO77Qs1gxHq59nS2O/1LF6hXF5QjZd6LWnp66NgySbhfl7Pt+
GdsHTib39tqHMs5Vait1dbr89lKrbcLvF+e8PlNwXInpSM0dW+vxkdL/M82f
W2O/E5tejc6t+b2swwTpdpp0mlJrXKI7OQ+OqSXUHNYPyTkfT9D64/RslKx/
KIZnaO9YjT+XrV/oeSDjfvW71D3rer3foHGqcxPtu6/kekbcWEvs6GOHNbqX
dfd2rcbmvYp1v6LX0EOerbqP9AczzV5TL5m3FVzXyafWgnOKmt7a6NjNrjeO
qG/Nkt034xzBB9Rn/PBiqzHHOurU2Jz9cLr0/Tvn5u0f5qgh5PHiyGXsH523
31/vkyTXFRxb8g5/00Op1cSZ/Lo553yl3m8PfeYmrlvUr11515MnY/0FwtjU
snF9lv7XFG3TKGHwBul3e639MaBon7wtfedLh2atadMzrMG9DLz0D4yB2bvL
xu2YnHsqY3R5I/SpNFo2Piyq5hT6um/Tu84pOx9ez7gGswZ/V8Ln7GMMBo5R
/Fdr/bDEud5VdL6fLJ0n6vmx9Nsrnb/Q84O8a1K/qEv9Y4zOhfAXumHbouhh
ZwoDV8jvT2tvjTA4LnX9f0byOmVnh+bP1JlHVWzbqb2dW/TZTVn3LXrWcOny
Tm/XdWrPsrLxQG0g57B3p+Z2lB1P6vnM0OFK+fvm1Lp1S84kPdc0uM8cIvn3
JcYUOKGfUscLYQtxpr8T67XSeY2eurxzt6Po/OX9kFhzvOZWp+ZPh2nct2Le
MCJwhS3n9bLOAyKPD844l1fr99oGc7z3sx6DDXQ8OPSkr86J3jpffl3Xam70
gOTd2mA+dgZ1o809irlbYr6u0dwL3kXvpbfR1+AFcAj66dqc15CncIql0a/h
AvReejLz7ZELcCz4LvXhfvl+fdl4XZeDGFoO/fvN4FEZ+aQ59dnPpO7f9O6P
4I21thH+iM7gkJiMibh0KI4/K7j3VeTXVM/T0m1T3v5F/xrZvank2L4gXZ4v
mzNSu8AWuILD0p+oXfCaUal/U9ep79SxybGeMf4Bh/jhoagNyOH95MArOJsZ
9ecdyXu5ZHvg4xOL7rkzyrYf23cqbhc1O0/gz/ynd5Pn+A/bqenYB8a6o3dT
s8DF6uDAYHFVcOnNwuYlBfeEknxTrrheHyJdOpvNY7AHX1CLiFtz1Ntdmru2
bDxM09p5wYeJMX2LHoSs7vAh9SONGjKv4PsJuF0Az8qb/4zVuV2p+8l02T1A
vlhV41oLbwQz8Kes4v2I1l9Xth7osDbwwz0BngUf3RK+6oz7BvyAveDq57L9
rqrl1je6tuKjZcLDS338+0bpslzPnqzzk//ccVZLdjXuFchrDH3uKpq/8nuH
8n1b1Tj8S8kxJr4dsmllwT3hK8W0qWCdwe3Y6PftWvOdFtfLx0rGKPgsF1yb
5ga3xD7OpZZQw6gnk9rMKXsij7ZGjixTjK5udn+mRnNPoIeCqVkl44kaQa+l
5mPXlshB7o74hnhxT/o87ko7M85Favt7GceK+MKniSt5R0wm5W3j6zHfEzL3
Ba/+UPI+qnrdZal5JHhekrOd2Nii9xU9C3Pmrd3Bf96Qn7frmaqY3F42J4MD
1ErG+iZzvF9q/qSS84PzF4Zu1HTuqPCxZTnjA3tvkw5rU9e1Z7X3OT0b5ZdT
5NvuNuOV2DNHTi0sGDdghvvWp3HnwmdtsYb1YIa8e02yHwfrkt9HePmqt3WA
H6IPdSar+M+R3EzGXBwMk+8LNPdiH8uCb8JbyQ/uvi/G/Re5IxrdK1ZF/yYu
8IsjK/4N1uBGcEv6+fFt7unIrYuaPyPWgWH40eN5z5HfXZHjzI0LfvWWdH6z
xfya/KP2gyH45aPBqbCHmkWNGiRd8i3mVMfGWccFtsFKT9TM7qirrzWZM8GX
vl/23XhgyIT3IHeW5i4vOU8Hy1crCu6V4BRfgNXJbY4lcfymzh9WMVcCz3x7
YO33uG+V3SfJW3KJPOIeuSnuztcUfVfHzyP0f2rFfXeYdBja7Dvr9Vnn2vga
x2Rko+XAX/a3msOQe9zHvr7TZfwNAo50suRvLvsd9qALffmmuBdxJ3q4yd81
RsX9Fz3B8P/7xJzgCyPiXHDUGFgiP+qKzpFbUt9L4TJ18s3IFvOI9zO+W+K3
V6r+9rQtuMaJOdcEOOkjgfONUf/BEvfCUuo72CxhdnybccD9AE5NPQdHIyPu
3K+oHffE3WdjYAb+u6vVPLHKvUDP0px7DRybsz7W+09arRN3VNZi+wnaO6uv
awg+wBfEa4Bk9K867+em/j6Fb+FcN8f3NDjowsAi3+EmNPuOAT6XxDycaXHU
tLd0/uw+xgiYpsbhn36BLXxIHWqouBZdXDCfRv/hmj9c456sbVsSde+3Wc+B
n6tSYwI81Bcde+LOt8DvFh0XOPzerGv57fCl1P1tUNxZvva55saV3Gex9bGs
7SWHua/DSbrg2lq3PmvuBoeDz7za6jsw3GeHxr8vmztT676Mej5G+8amljtN
Nr7a5F6DDGI2JWoI42ExvydyCt/tiTVnScaU1N+Qfir73k3N+8AaPXhVcC32
DY0e9H74Gf89k3eMrlRMprT590rZ9VnVXOZCyRxb8R7yEtnkCD2S9/Acvv9x
t8VX3JvhV8RukvbNL/p+Q82mdlPDOzR/RMVxgL9MK7rubMg6luPjDgunh89z
n2GebzKsey/0b5KtR0cN2S85g4rmlAfJn4Wqv0+dX3GNo77xHeWYJvPmdVXb
hl18I/yyxfrRr7gnLIo7CHcV9o7U3iN03v1Z10R6JHm4N3gPWOI7x/jorfTd
NfHt6GjpUGrx/Yf7HvwQ3+W1/oCS6x+4BFf0EXrZmsiPmrg/wA2+yvsOAP/n
21IS35e4C/FdGw5Jn/ykyX5mT23efQqOwV506JTd36r42xN67ovv3kmchfxb
Jfu2qvej1+bAPHW+Pb4fnh3cGRv5JvGNqt/Bed8Ozsl3tY64X6xI3TOo0UfC
YUqOOd+8n4raQi1ZEHUDjO8OnD9XdV6RU/CGnqhd5A/5yf2BHnJ/4Gdwk/MB
vP5YuB5Ssf/A0frA0v7gV9jAd034EXwemZsi3x+QnmMqxtz/ABnKJiA=
             "],
             VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3twlOUVxt9sNmSTze5mk71k1zrlIoUBoZRQNA3XgK1IBQ0KiLVFIRRt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             "],
             VertexColors->None]}]}, 
         {RGBColor[0.888538565415822, 0.8889848181402897, 0.8576245235235892],
           EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmGuMVeUVhjfDXA7nnDlnzlzOmTPWNEbbmrTFgCAzVBBUNKTMjOUyNwaa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             "],
             VertexColors->None], PolygonBox[CompressedData["
1:eJwtlllsFFQUhm8X2tJhZjrTbQa3GBB8UIxCoQXZNYaILZalFVtMChExgRa0
LFEhUUAtxaJspS4YH9QEFFDiEjRExEQwBowh+mC0bIZVdtmp3+/Pw0nuuWdf
7jn3zobG6lmZIYSPgWyguiiE8UBjtxBWZIXQqySEl0pDOJoXwq+5IRxLh3Ac
mJQfwuKMEPpGQ2iApwvaLO7aUyE8VxDC6e4hnAIaOR/kbi76VqLvz2QIt8VC
eB1jDdxVYWsc8Bp4OY6UYWsHMmPRvRmbVfEQarnbzXkvcAXbV4H6SAhL4BmF
rrnQD0H7CB2fJUKYDd55E58KPg24C929iW8E+gZA7w6tgrtJ4JU9Q/g2Yh+r
OB/G31VZvlsG/V/sPcl5IfKLoOcQ8wTOl7g7QzzV8OzDXhPyaXJRD/4H+C5y
0gRvXjEynCuRiWO7P/reJFc3ckJ4rBB5dO5A1zbkH4A+LO5cyEfFXgm+J885
2EluppQ6F7XEX8N5LPSfbtLHo+txYF2WdVaSn774tAx9C+AfAX8L+SjDl6/g
n4G+R+Bfjq02ZDrxbT8wBtkGeE4Q38mkaZJ5Ku4cKPaZ6JuHvmZgdqZroNim
R51rxVgBbTCwJc81HaL4gC/AhyIzjNxkoe9Z9H0AfQW0MfjczPkaPMPBR8ft
65fAHPBp6s9M17iR84K4edeTzw5q10xM7fi7kXyWwz8IuD/Yh5Wc3wLmo/86
+B3YGgn+tXotw7UtJ4a1+a6xeuFvYES+e6IG/iHQ3wPvhs8t2D6b9vkdfOqP
ruFx99Y6cjoQWgUyF+FfA4ymFtPB29Tf8KyFvgaYiq0MdATsXyDf87rZ5jfo
yiA/z0Sco7PU7hywHdk3YD+NbzPgGataw38QXQfSro1qeID8Hix2r/WC/zL5
ugX7m3J9l0P/jUP/dtUT+nj8mwu9PcM53KP3hMz7OaYfw95xYGu2a74PWxP1
RjMd45wCzwC9fem8QiyXgRpkV6OvH7qLSjwL6rFxD3gS/Ank68AnoOt00m9J
OjeCB/y7O9sxr1fu0449D/0vkO8XgfYc1zQXWk7atXgDHVPRPbTYvaUZdQja
QvgbM5yzSeiuBX7g3IFPuYXOiWJdjI6mIveYeks52JtwTkTvgH6VWK+kzKuc
7ISWjfxSbH8OPot6/ozNQegfjsyn0D9JeBaohx/El1FxvwW9wZHkIxP5xch/
mO23nyKGH3M9AzRbtiRM04x5NO4ZoLcvG2XKZcyzsRWdv+PbJeLfjPx91OcU
+D/AfGiF2Z4VE4HvI54ZXT1CKEDHd/APhj/BOV7i2uguF10DY55tmmm/oWsA
+ZlJbvrBvwlfXo07N23EsBtfd2kGB9vU7FmW8G7RPDmTcg+rd6uA/SnPHNEq
wC8W28b/urF3jlwmCq27NuJdU1DoWmvntENfl/Zbkk29tQ71RMRvTrnVztBu
UI6PovtIyr35MDYGpf1m9VY1A45wPpr2rGhC3+0x7zDtrhZ0nES2R9SzUj1Y
T/x1pZ7NreBl5GYvPH3znaNK7FcVutc2qMcSrpFqo514KukaKPfawVOQ70w5
F23IL4H/PPSXc2z/FfA+5Lslzzt0K/jZlHOpN3e4h2XEOxuZoaWOQbhm8Chq
u4W7nt2dI+leqhpl20Yn/vyV9GzUnWo9Mu7drHjKYu4J9YJ6VL2vHaz86g1o
luVGnVvNtIfinuma5Zq5hdi/N+ZZoBmgXfZ2wrNTOy2JbBfxTM73jPyF89NR
zzLl9Dp4QdS10Z9kc6l7RL2hmC5rFgCLoE/hrhz/K4qcC/0JLqS947XbJ0c8
28+nfdaM1+5vhV4X8R/gGvmpK3JttVNujXmmapbqjakWZTffg2oi2++mPavk
wyXOy+P2RX+Yi/I15r+UbETIZe8S/7U0ozJ5m32S7pUZEe/y1cTYleed3oxs
dYl3iWZ2lPzHCj17tEPnk5sEUEssKe5qevrPob+GZl5r1H84/d00Y1eVWka8
sjEB/g1x71LNiJP4eyLtv4Rqot20LW7ftKP0V3w+6tmiP2MpvpWUePapR26k
PKM0m+ST/k7qcfW2/lD/AWPSbRo=
             "],
             VertexColors->None]}]}, 
         {RGBColor[
          0.9157153191998827, 0.8980475413770255, 0.8454493621823058], 
          EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lm1olWUYx2+Pus1zzs45m7qzZ1rQ576V7zPfCHzDNnVzBjqbmkPIjRbO
3qDAqLlUar6FhB8D+1YaQlBBFIQfLBdRH8o0sXRqVFSmpvT/9b/8cHHfz3Vf
9/Xyv17u54HN/Wv6cimlMdF4Uc3klGpFQxNTmpPpuz6lXgn82JzSxikp7a9J
aae+Gyek9NS4lJaUUspJfrv27zVIppzSVp3vEVUls0v8veL9LV3HxHuymlKP
aLQupWF9fyyZftldLz03Mn9XZPOO7HXlU7ql9baoQ/tjNV67Jb9AOlpFJ6Xn
oO6VdWco5/ObBcsUpeuMztvEf1GyL4gu6/t5rb3y6RftZ2s/R/S+9uu1tonf
LvlV8nu+1oel5+gEn7fmbO8D0QzxP6r1N/sNuruxanv3KZZzjSk9Jh3NTVpD
5/3iP1I1f4l486vWNU/rXNEJ7QuSrxV9WGvMXi8bt+FiSksV21nxX9X3oHT0
ye42nT+nuz/XOX7wBk/kb0t+VPLzIp6HxN8s3pa879ZIf23mb+z8FTnqKlhu
t+705L1H/jvl4ZUG47JOtFD0qPijuvegYvuk1mfEB27L8/aZXBxWcb2mmhrI
mb9MdLHOdbRS+8GcZZcHv6h8Xm/2GflcFnrOydazivdSnXnLg0+tUS/U1Fu6
N1BJ6ch4y4ENtYqNS7HnbCj8ob6P6/5a6fle+ndQB8lY4wu1fQ8LsH2pJaVN
Zd/LTzC+YIv+U/ru0X6LdLQoj6elY0Q6V5acM/KDj+gpKcYDmfO5V+tsyWwh
f8rdIVGf6GDsyWPPONfRIt0dKVoOzN7Q3eMtzvfSwA/fiQ3d5G6T/PlcmDwu
HRvUx//q7j71U3vB2NGvz1SMHdiQ287Ib73iuFt0TlsjZuJdXXC/Es+VSeq9
nHthsOq5AG5gfKvOvuAfdYlv9OsXDa5ZYhmOGMFoKPBpVVxdJWNP3PQzsZ8K
f8G5I2zjb7ty8lVmHj1HP3OPuLdWHfsscBZt1f6M1s1V6+wWJmvKjpl5wXz6
31bB+olrTsl5IkfwxsLuLPFrpzo/5Hx65H00Zg92vxWuN6a6VtYr1i7RAunu
m2h/0XNVMmPNrmv6izP42NkRe3AaibyDw906Y9EffDAEp7aoE2btl5l9eTvq
CZl7tUVfjkjmQNW6rmluXWi2PfD4vdGYFJSvgXpjzhvQGjVPDR0Ne79K9mxm
v6mLY5HHT4X/zKrr5nyzse6MXhyMPIIpeNCD3Nsdc4xaHIganlty/sgd85V5
yqxhPvXEvOqWz/slsy3n+X6kxj3XKf434i8quJ8ORn+9rL7J1xuHPzPXHHpO
R7+BIVh0Ro4WFpw/fL0q2bHMfXBF6+XM/XRB63nRioLn+KqYh7wVvBn4TP7R
Qyx/SHa47Lm7VP5sr7jumI3gw7zqFn6fVZxbZtXKgt/hwZhL4INP6AVD3hLw
Jk/7pH9tOWZ2wRhgl3nMfADfNzPPEXp0RdhGPziSG3TyroMJs5E3f3H0OMRZ
W+RxXcyNnsARPljzfjOrf1PuOsqWwWfusGdOIDMQ8xj72OUfhJnLvCWfe+Kd
q1Of3Sm6DokLXeipTPYso3b4H8ma7B/Y9IbOaU2e9fj2rnS/0+L+oI9nlux7
r+r0WrNtgiN1Ty/vCT+oW/6Jnqj6jDxtC/1F6S81Od+9YRvM6Vt6FRyoC+oD
/3+SLxcz55UZtrrsuQAefdGn7A9HP3ydud/oNfI/GP2youT3hu8TDe4HfKJ3
f8jsM/9Ap6K2eLPxkfn2dMX9gI1D8b6MRr0iQw3vVKy7qn5j2lv8v8iMv97o
2UGv9EdvESNzgfkAbjujlsFnxhTPROZhR/gxI97x4cgv/0GT4l+IN2N71N7R
qGt0/jPV/yXzY64ujNq+Kf3TS8aYtyvfZP+nlXwGf3HZfuDDf+E8YNM=
             "],
             VertexColors->None], PolygonBox[CompressedData["
1:eJwllElsTmEUhk9L29v2Hzr5b2+xsLYzldasCVG0qClKdaAqWkG0ph0xBUmN
iYilaWeKRIJERMSCtFiaYyoShJQO4jl5Fyf3fOe835nueb9RDZsWtaWb2Wpk
KJJImcWRsei3s8yWJcx+Rnxzzfakma0JzeqQFehHM80ulJhtzjM7NcTsRMxs
Cr6pyPXAbAGYQWyvioUdQ8yv6Llxs3r009h2gZ1Pjpsk/8SdFmKdBPM5Gxs5
VxaZ1SJHwFZR6AtqeYm8DxSjB3059+9wfyH4b9xdD74dbGWO9N2hYrutjXMf
mBp854iZTa9BSrXdot8c9NyUdJ9BBvEzkUbwDUgluU5wPkCsdvqbQOwy5Brx
y7HNwn8t32wd+kb8D9C/kG8Od/9SXyn+I9xfir8R/xb6rWaGBzKYBzPMwpcs
pE5TzhHg/wwzmwx+PvhLYC8i3dTX735qHY5UgX+EbWESHzHuotdwZ5DcA8gh
9GXgO5h9Xlx6yMxKwU5EmvE3Eb+NXjojxe7KUq7LyNmYcraGwrjPc9aQ7xn4
afRWwXkG9V6h5ybitRDvFb43yFz827BtJXcsrn9TQP4GYjWGqn266d9vYCY9
2dqBAfKeJd6ZodoB35Vj4P8F2pl3kXJ47EpydOL7zLka/WC6ev8SaTd8BsdD
YdznMbajr6OHD4F2KmKWE8hRn6YesvgX2/H3BfpHHeDbQ/X2Dtt9aq3l/Bg9
Rj0V3H0bqZZLnFeF2mHfXcf08i+HJ/Qvy7BN9lrobxy938BfRa7VoWJV4x+P
PiMpbA62HaF2zHfLay7nPDOpu845n1UptquBZjYx1I76brptL/6RCXHTd+oN
83mNLEFvpb8un11Su9PGeRJ37+Upt++41zq7RNz0ms+X6A1w7vuOHEqKM84V
fzN60Q9jO5cujh73XUiIO/uwZTDfRFz6fvLlxGVz3d+UJvKvRboDvTn9xeKU
c8k5PJ5YxSnNyv9ZM7mai/S2fAzEpbxCccs59Zv8vyK9ZV7TPO7vDIXtSNO/
9jfC3wb/558icca54jv1MF93HOtvwFHnT0Jcds4/4fw40i57zaPxxVJ6S52T
ryNxwHffOeG7/q1As/ed/4H+vUBc8n/i3FpCTdNzxbHnnCclxFW39TCPbaF2
0d+YuqR20HfPOb2Y89NI/9LfnP+ZP8y+
             "],
             VertexColors->None]}]}, 
         {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
          GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlDFPVFEQhQfELL63+5BoeIhuYe0PYAEthEQNWOxbEgstIKtoohGibMzq
X1g0MdjZK9qa2GisTUw0iC36B6xcpRAXPV9miMXkzr577sw5c8/dk82VxnK/
md1THFD8ScwKrYuKK31mE6nZtPJvo2a9stm49r8eM9tWXNBeQ4crA2ZnhVlV
Pqz8ls4NjpgdUrwpmX0U9pOilvr+rGq0hL0+ZNbO/dzWoO9T77OwhfZO63da
Mfs+6mfm1H9buCVh2sovlZ1fqj6J4m3J61MbDnXV2FStqdTxk1pnxLOq/Lfy
m32OQyuaV/X9rqJujp0KPD3o1RWHn4nnfC/6Xd/lPtdArYZ5kFMTDdRilhcz
s/fDZq8HXAd64LAx4Oc5VxPmkTjvJM4TDHrPqcaHkuf7PMCjeb7fOcCL7+yj
Yzp0tcqurSnMrzgL/xtHFUM+LzRyjjNnUsftz4qe9ajVjb6cQQezq2j2meJd
yTn+SLxXWd9OZa490z0ePGK2YO6b4dDcDb/R94l0zwn/V98eKh/PnAf6qAEG
/zHzInzHivfA0B8cs2Ve8GaO51PnjO6d4F/EzDiLF/A93HaVr8e9bInD/JDP
485hs+djvrcgzy4qNtWnl/hZ5kAf7pL64J5GnS+DzrURPmdlPhuq92LMcXCo
hvfgwG/4LKnPtdxrPMjdQ8yd/d3wcC1x7cwALuxRB/3cB73oD98iML3Qi6Zn
oWtWtdeleS/xO+iFLta9wE/GW8Iv3DN6qN8p+zynAzMRnsd3+I85o7sVPizi
vwaeL8d8FszhqjQ2c6/LG8JncGhGLfBr4Wdq8huvF6EXXD3e8lq858fStJy7
L47LkydGfC7sdeKdwJ35kfOO2vHGX+m9zmR+r6z3c8/xclLxmaCpET7kPdaS
/2+yEzzpfzs4dIIb33nf1fDJWvCB1z/gILSg
             "],
             VertexColors->None], 
            PolygonBox[{{5639, 5643, 1980, 346}, {5641, 5639, 346, 1979}, {
             3325, 5640, 1979, 2615}, {3343, 6548, 2815, 96}, {5658, 5987, 
             2259, 2802}, {3921, 6608, 2874, 2876}, {3943, 6010, 1206, 628}, {
             3627, 6610, 2876, 347}, {5660, 5658, 2802, 1995}, {3659, 6546, 
             2813, 2815}, {3442, 3339, 2634, 1041}, {4846, 6611, 2877, 67}, {
             6822, 6826, 3227, 3219}, {5985, 5989, 2260, 594}, {3639, 6540, 
             2804, 2805}, {6620, 5659, 1995, 2886}, {5988, 4293, 1037, 
             2260}, {6009, 3942, 627, 1192}, {6609, 4846, 67, 2875}, {6542, 
             3934, 2887, 2806}, {5213, 6367, 2615, 593}, {4293, 5983, 2257, 
             1037}, {5984, 5213, 593, 2257}, {3338, 6784, 3067, 95}, {3934, 
             4531, 1192, 2887}, {3923, 6541, 2805, 2877}, {5642, 3326, 2616, 
             1980}, {5646, 5644, 347, 1982}, {3326, 5645, 1982, 2616}, {6544, 
             6545, 2269, 362}, {6608, 3920, 2875, 2874}, {6540, 3640, 2806, 
             2804}, {6825, 6544, 362, 3227}, {6621, 3442, 1041, 2888}, {6546, 
             3658, 2814, 2813}, {6380, 5223, 628, 2634}, {6547, 3342, 95, 
             2814}, {5997, 6620, 2886, 2269}, {5986, 6606, 2872, 2259}, {6607,
              5985, 594, 2872}, {4552, 3343, 96, 1206}, {6008, 6622, 2888, 
             627}, {6784, 4209, 3219, 3067}},
             VertexColors->None]}]}}, {{}, 
         {GrayLevel[0], Opacity[0.4], 
          TagBox[
           
           TooltipBox[
            LineBox[{5989, 5985, 6607, 6606, 5986, 5987, 5658, 5660, 5659, 
             6620, 5997, 5998, 6545, 6544, 6825, 6824, 6826, 6822, 6823, 4209,
              6784, 3338, 4869, 3342, 6547, 3658, 6546, 3659, 6548, 3343, 
             4552, 3660, 6010, 3943, 5223, 6380, 3339, 3442, 6621, 6622, 6008,
              3942, 6009, 3651, 4531, 3934, 6542, 3640, 6540, 3639, 6541, 
             3923, 6611, 4846, 6609, 3920, 6608, 3921, 6610, 3627, 5644, 5646,
              5645, 3326, 5642, 5643, 5639, 5641, 5640, 3325, 6367, 5213, 
             5984, 5983, 4293, 5988, 5989}],
            RowBox[{"-", "5.2`"}]],
           Annotation[#, -5.2, "Tooltip"]& ]}, 
         {GrayLevel[0], Opacity[0.4], 
          TagBox[
           
           TooltipBox[
            LineBox[{5946, 5942, 5944, 5943, 4508, 3324, 5212, 5211, 5981, 
             5980, 4292, 5982, 3919, 5976, 3918, 5656, 3637, 5383, 3638, 5657,
              3933, 4529, 3649, 4866, 3650, 6006, 6007, 6005, 6378, 6379, 
             4550, 6395, 6394, 5230, 3960, 4871, 4870, 6736, 4210, 6296, 4211,
              4880, 4879, 6407, 6406, 6405, 3978, 6642, 3671, 6459, 6644, 
             6645, 3979, 6646, 3980, 6647, 3672, 6634, 6635, 6396, 6397, 3344,
              3447, 6632, 6633, 6033, 6035, 6034, 3661, 6011, 6012, 5224, 
             6381, 3340, 3443, 6624, 6625, 6623, 6627, 6626, 3652, 3935, 6783,
              3334, 6456, 6455, 6454, 3641, 6613, 3925, 6612, 3924, 4848, 
             4849, 3922, 5214, 6368, 6369, 4844, 4845, 4202, 6293, 4201, 6727,
              4489, 5948, 3906, 5947, 5950, 5949, 3614, 4830, 3613, 4484, 
             6360, 5624, 3612, 5369, 3611, 5623, 6359, 5172, 3905, 5941, 4290,
              5945, 5946}],
            RowBox[{"-", "5.8500000000000005`"}]],
           Annotation[#, -5.8500000000000005`, "Tooltip"]& ]}, 
         {GrayLevel[0], Opacity[0.4], 
          TagBox[
           
           TooltipBox[
            LineBox[{5603, 5368, 5903, 6451, 3431, 5904, 4451, 4452, 3880, 
             5176, 5177, 3301, 4485, 3316, 4486, 4487, 4832, 4831, 3615, 5953,
              3908, 5951, 3907, 5952, 4490, 4491, 4203, 5201, 5202, 5203, 
             4847, 3327, 5648, 5649, 5647, 3628, 5650, 6370, 5651, 3629, 5376,
              3630, 5652, 6372, 6733, 4207, 6371, 3926, 6734, 6735, 6373, 
             6374, 3328, 4853, 3335, 6377, 6376, 4208, 4858, 4857, 4859, 4532,
              6386, 6385, 6384, 3945, 6628, 6014, 5387, 5668, 5667, 6013, 
             3444, 6383, 6382, 5225, 3944, 4554, 4553, 3347, 6552, 6553, 6549,
              6551, 6550, 3346, 6399, 6637, 6636, 6038, 5390, 3662, 5671, 
             6037, 6036, 3448, 3345, 6398, 5685, 3673, 5403, 5405, 6650, 6651,
              6648, 3981, 6649, 6556, 6557, 6555, 6559, 6558, 6654, 4594, 
             4595, 4013, 6101, 4012, 6656, 3468, 3367, 5730, 5731, 5437, 5438,
              6659, 4028, 6657, 4027, 6658, 4646, 3390, 4942, 4943, 4214, 
             6742, 6744, 6743, 4941, 6738, 6739, 6737, 6741, 6740, 4011, 6298,
              4213, 6297, 4212, 5715, 3702, 5422, 3701, 5714, 3995, 5699, 
             3687, 6554, 5698, 6065, 6064, 6643, 4881, 6063, 3975, 6062, 3976,
              4560, 4559, 5233, 5232, 5231, 3961, 6032, 3657, 4877, 4878, 
             4549, 4548, 4868, 4530, 6001, 6002, 5220, 3941, 4526, 4525, 3333,
              3440, 5384, 5382, 5655, 5654, 3323, 3438, 6605, 3915, 5975, 
             3916, 4507, 4506, 5939, 3903, 5931, 3904, 5940, 4289, 5938, 3902,
              5170, 5199, 5200, 4482, 4483, 3878, 5173, 6352, 6353, 3430, 
             5900, 5602, 5603}],
            RowBox[{"-", "6.5`"}]],
           Annotation[#, -6.5, "Tooltip"]& ]}, 
         {GrayLevel[0], Opacity[0.4], 
          TagBox[
           TooltipBox[LineBox[CompressedData["
1:eJwl1ElIlmEUBeDXsgGc0kzTCtSMpGg0LNOwwbCBBqJRK2wwwv4SyiaDZqKR
ihY2QVGLFkGLoDZRi1pksw00qEGbsFVBFjTX89HieL577rnnvd/wm7u8bs66
uBBCgj/pmSEMTgmhJD2EUmhPDGF/aghf8fdeIfyAn/ScZOz6Te8QfuFc9W96
XsTqNvq9rBDuQ6vr7dkhtOD++n/5JjpnEkx21h/+fHocLqft412bpOf6mLOn
qqfBFIj1CGE6rjD3WvZC/BIvwK/w5zQ74RaoNX+ad6zso+oS3C8jhGreOr1r
sq/DGvUOdS1+z7fR2V/s2gG1do3Rd+rPNv+IP47nI2yjf8IBzur3sP8sngJn
nInOhgZZe+zw1N4L4KH5B5DWM4Stes20BjmNvKfgJHSX11tvl7kiWcXq0ThF
fqX8vrhYPQau8q+wZ050jl13w1l5b+Xuo+XCXL55MMJcIRyhFUCS3JX0vTLL
6BOi9ybvlvlWfBMP9DyP639QP1e342c43m6NMvrIyIZLzn1Bn8xfDnm0XKiX
f978enwOb8A59GlmY55BVnSvkAlb7Fwpt1nOIrxZ3YueAeP48+UW4hNQatcS
2CNzmcxEnuHqYTAE6un37HofmqJ3IXMC3yp6nn4NHq8+QB+F56uzoufjeiQc
NXPXezqID0HM/W3iPey6gve23ipaDdTTNsD46Nu3Yxm+rL+Y/yIepf4W7Y4v
qGfQuzqjykwl3HGfX/QH6Z/Snymzw+8t5j6bou+WfxBfKR6Ks/kS8AB1Ie8j
7/8x1PC3ymmDqug75Xvr+ob8JP5keOcen/Au0e+kf0W/M16qLpJVjePV1+ld
cKqZNBitN9B5q/W7Jf//P/EPY7GMZA==
             "]],
            RowBox[{"-", "7.15`"}]],
           Annotation[#, -7.15, "Tooltip"]& ]}, 
         {GrayLevel[0], Opacity[0.4], 
          TagBox[
           TooltipBox[LineBox[CompressedData["
1:eJwl1GtozmEYx/Eb29gchx0xzZCzOSVzTBlyKIfIodbGxrDNG8Y2p+SVY5FD
ORZiFkLRHEIU4QXijZAwRtgURZLPPy++z+++f9d1X9f1v5/n/2QWlM0sbRJC
GO4jpm0IQxJDqGkfwhkstH7bKoTXSSH0TwvhDf3SMYRX9CUepobwABm8uJQQ
YlHbLoR4moA/ySG0oM2xSa3vak2Tm43+vH64KT+bDkJPjDbDQNrU2WYR+sTS
GMzjH1OnWesQ8tQ4Yj1f/n01yngxOMkrEMtHjXW++Hl6LjrXQT96Cy2tEzCp
TQg71C2XV+LML8+Trddsfqre6digbgrG8Mcik5eFLbyumMabjr68ftjK64kW
7nAwTXR3u9Wu1SOBF48pek9FlvVOvZZa76LvzVKH4/JP4CTGy+mqRgZu2Nep
81XOY/qNfqS3+LcxRb98+TPpWjNVYA2qUIlZ/EXii/HZuTvOZKnbHQfFYtND
qOc3qPuJNkZ3bq56+ty+Rn5nuV2wX/53d/+Mf4p/GtXopfZL+Uv1K8a46K7U
KLQ+K3duNJP9YH45nWN/iP/AmUfRs5vhIc3wXRThuj4HeIXWlc7k6rlKnzT+
RiS5u2RM4K8Vr8A1foH8HLUv2F/EamfKURHVwVbeZs9xT26j8/fpdt42jNQv
B1XyRqqxwJyJ/NHWOc6Mop3kP/VbOmbW9eY/SjfQJ+aoFGuQV2V/iL+OHqEz
1NlMy+yXm+WH+j+xWn6d/BL+JvFSekXty1hpn6lfN2Rghf1yvJB/WHxJdNco
wjzniukkuk/dUrPspSV0qufZI3+ieK54Lp0c5Ubvnrne+t56RO+DnNlm++l9
3Wa9HQPkd5Z3V887KOWl2y8z9xZ106z/OtPojo7aN9BUXrH4MPkp0f+BeD3/
I5KjmcWGiiVZ/xaL1/uDWG+9cuz70A5icfxas11Fkb6FeGe2/OhdR3N5eTSO
XpIzwrqa5qlf3e7//9o/3Q+l0A==
             "]],
            RowBox[{"-", "7.800000000000001`"}]],
           Annotation[#, -7.800000000000001, "Tooltip"]& ]}, 
         {GrayLevel[0], Opacity[0.4], 
          TagBox[
           TooltipBox[LineBox[CompressedData["
1:eJwl1F1MlnUYx/G/gIAGlPgWtgViGLYKcb1sLhe40iWpwXTrQJAEY8tX8CRd
lmKrRQLLSnQLp1jzhVCY0yNINhYiOrcUnXqAQSBl1MosD3Kjz70Ovs/vvn7X
9b+u676f+3lmrtlUtHFcCKHIR+fUEEanhPDjtBAGEPNwCPMmhfBzcggtqSEc
fSSEY4jlz+f/yj/Nb+Z9izbXrciTy8dEdSf5mXrOQgXvdlIIQ+YM4w9eYgrP
9eVHQ3gnOiPu1OMhul58hT8qnyT+S30y/V3cx79HnzbjsekhpPAHnWs3rwPP
8AfElXpUIVf8svN5GLVDPe8+/YzuwbDaITypz1L9lmEJXkcBRuQupIVwEYXi
lViBHPX/yHWbeQ4j9orxXNI9vwxMsONEVPISkcWbjSReMj7Uo9Ju1XQzvWSX
Ij2/Fu8UN9Ed9E9z33P+ihm7xAf41fQbetWZbe5rK/pcFzs/eXIIq+hp+TM4
hXr115y/irvyb9LL6rfb+Qc6nbfAnJeQMsP+9qtHHXrN/tR97sY+55rkD2Mv
9qEBj6vbqW4GqsXp4nftVGfuC+I3nHueLqdvmVGK1WhDK0rkcjEPa8RlKMd1
e93AYufK7TpXPgcfm5OJe3b/G8/JD6GONwdve84VWGiPV/AqUvVrsNMtz6Mf
ezyjDXp/Tue4t+t23SReFH2n6r5Hc/TO8B/o3ajvbD2y0MP/jX9XnxPOr3Xm
Jq8LQW2CHRPsW2TuDnt8gHjxYT0WOT/edaHc+/ztiBXHIcG9xKPFHi36jove
KdzQ96no/XO+Vu412sk7i0b5r3BA/SdyNciPfotY5zqLDtrzJxxSf8neM3kZ
+FL8Be7Y+RcsUV+tT5/a4+qK7XaMFtIt/Gw7V9EC8X7+oF3LxRnOldF+8Uf8
XPmV4inqc1w/i1o9u+QT1VZF77t5W2gHrx0T3FOZXS7yL+CB/RbocUSulN/L
68F9fi6/xvM4KNfv3sebE4cYBLPGov8Yv/F1enarOxd9b+a/aF42TXM+jj4R
7ar3eT16Ua6+S20m/199ZtExGtTfilScrr4z+k70L1F/k//d1P//Q/8Dy8m/
3g==
             "]],
            RowBox[{"-", "8.450000000000001`"}]],
           Annotation[#, -8.450000000000001, "Tooltip"]& ]}, 
         {GrayLevel[0], Opacity[0.4], 
          TagBox[
           
           TooltipBox[
            LineBox[{3329, 4509, 3321, 5209, 5208, 5971, 5970, 3893, 5967, 
             5968, 5205, 6365, 3320, 4499, 3310, 5188, 5187, 3892, 5920, 3603,
              4469, 3887, 5182, 3888, 5917, 3600, 4808, 3599, 4463, 6357, 
             3306, 5621, 6449, 5622, 5365, 5619, 5618, 3305, 5613, 6447, 5615,
              5362, 5611, 5610, 3304, 4459, 4461, 3854, 4457, 3853, 4798, 
             4421, 5864, 3424, 6446, 5863, 5359, 5579, 5578, 5858, 3849, 4270,
              4269, 4793, 3565, 4786, 4787, 4413, 5153, 4407, 3562, 4783, 
             3561, 4405, 6338, 5571, 3559, 5569, 3558, 5570, 6337, 4400, 3557,
              4777, 3556, 5851, 3838, 5567, 3837, 4263, 4262, 5854, 3839, 
             5843, 5853, 5852, 4442, 3298, 5167, 5146, 5886, 5885, 4281, 5890,
              5891, 5877, 5889, 5888, 4480, 3311, 5195, 5164, 3894, 5927, 
             4286, 4287, 6358, 5633, 3897, 5929, 3624, 4851, 3625, 4504, 3913,
              5974, 6537, 3632, 6539, 3634, 5653, 3931, 4516, 3644, 4865, 
             3646, 4522, 3938, 4538, 4864, 4863, 3653, 4873, 4301, 4303, 6391,
              6392, 5674, 5675, 5395, 5398, 3454, 3350, 4570, 5249, 5248, 
             4575, 3991, 4577, 4576, 6087, 5706, 5708, 5415, 5712, 5711, 6099,
              5724, 5726, 5432, 5728, 5727, 6105, 6106, 4639, 3725, 4963, 
             3726, 6116, 4047, 5282, 5283, 4670, 3740, 6124, 4068, 5306, 6123,
              6122, 4675, 6747, 6748, 6299, 6303, 6302, 4071, 6143, 6144, 
             6140, 6142, 6141, 4706, 5036}],
            RowBox[{"-", "9.1`"}]],
           Annotation[#, -9.1, "Tooltip"]& ], 
          TagBox[
           
           TooltipBox[
            LineBox[{3348, 6402, 5234, 6055, 6054, 4308, 6058, 3972, 6051, 
             6057, 6056, 4568, 3356, 5244, 5243, 6075, 6074, 4312, 4892, 3678,
              4566, 4889, 4888, 3458, 4311, 3985, 6068, 3984, 6071, 4579, 
             3363, 6718, 6719, 6272, 4188, 6274, 4185, 6271, 4187, 6270, 4186,
              4255, 4254, 5768, 3772, 5469, 5471, 5472, 3811, 6761, 4228, 
             6760, 4227, 6776, 6777, 6716, 6717, 5128, 4226, 5137, 5138, 5127,
              5126, 4376, 5801, 3507, 6791, 5800, 5475, 6566, 3773, 6800, 
             5510, 3523, 6513, 6813, 4150, 6700, 6487, 6488, 3509, 5082, 3508,
              5083, 5084, 4229, 5129, 4369, 4370, 4230, 6312, 6311, 5474, 
             4149, 6206, 4015, 6102, 5738, 5739, 5443, 5741, 5740, 6112, 4650,
              5294, 5293, 5270, 4055, 4339, 3481, 3391, 5295, 4680, 3746, 
             5007, 4349, 6134, 6135, 6131, 6133, 6132, 4710, 3412, 5339, 5319,
              4097, 6154, 4360, 6158, 6159, 6157, 6667, 6666}],
            RowBox[{"-", "9.1`"}]],
           Annotation[#, -9.1, "Tooltip"]& ]}, 
         {GrayLevel[0], Opacity[0.4], 
          TagBox[
           
           TooltipBox[
            LineBox[{3322, 5210, 4503, 3914, 4502, 4501, 4840, 3896, 4479, 
             3608, 4842, 3607, 5880, 5882, 5165, 6344, 3297, 3427, 6594, 3868,
              5876, 3870, 5879, 3583, 5849, 3835, 5147, 6334, 6335, 3421, 
             6591, 6592, 5842, 5845, 5844, 3554, 4773, 3555, 4396, 5148, 5149,
              4398, 4399, 3841, 4401, 4776, 4775}],
            RowBox[{"-", "9.75`"}]],
           Annotation[#, -9.75, "Tooltip"]& ], 
          TagBox[
           
           TooltipBox[
            LineBox[{3413, 3492, 6664, 6665, 6152, 6156, 6155, 3759, 6136, 
             6137, 5324, 6439, 6440, 3486, 4350, 4078, 4679, 5321, 5322, 4681,
              4980, 4981, 4654, 3733, 4974, 3732, 4651, 4032, 5742, 4033, 
             6113, 4331, 4944, 3718, 4620, 5260, 6175, 4114, 5473, 4113, 6501,
              6814, 4170, 6707, 6257, 6711, 6712, 6514, 3524, 6515, 6516, 
             6414, 6415, 3370, 6708, 5096, 5097, 4251, 5099, 5098, 4168, 5095,
              5501, 5500, 4169, 6247, 3688, 5470, 3689, 5700, 3541, 5810, 
             3812, 5520, 5521, 3531, 6275, 5056, 5057, 4899, 3998, 6273, 5252,
              4580, 3690, 4890, 3691, 4581, 5253, 3364, 4584, 4891, 3987, 
             4567, 3988, 4313, 3459, 6652, 3986, 6072, 6077, 6076, 3679, 6059,
              6060, 5236, 6403, 3349, 3453, 4884}],
            RowBox[{"-", "9.75`"}]],
           Annotation[#, -9.75, "Tooltip"]& ], 
          TagBox[
           
           TooltipBox[
            LineBox[{3939, 4517, 3940, 4521, 4520, 4862, 4537, 4539, 3957, 
             4876, 3654, 4543, 3956, 6022, 6025, 6024, 3667, 5394, 5397, 5399,
              6404, 4571, 3681, 4895, 4315, 4316, 6410, 5702, 6561, 3696, 
             5414, 5417, 5418, 6411, 5721, 6564, 3712, 5431, 5433, 3474, 3377,
              4634, 4635, 4043, 4336, 4042, 4961, 4642, 4969, 4970, 4669, 
             3739, 4996, 3741, 6125, 4069, 5307, 5308, 5309, 4703, 4704, 4093,
              5335, 4092, 6138, 5006, 5035, 4095}],
            RowBox[{"-", "9.75`"}]],
           Annotation[#, -9.75, "Tooltip"]& ], 
          TagBox[
           
           TooltipBox[
            LineBox[{5152, 4404, 3845, 4408, 4406, 3290, 4411, 4412, 3848, 
             4792, 3564, 4415, 6339, 5575, 5860, 5859, 3566, 5358, 5861, 5862,
              3851, 4422, 3569, 4799, 4272, 4273, 3852, 5588, 3572, 5361, 
             5865, 5866, 3855, 5596, 3575, 5364, 5868, 6448, 3425, 5869, 4427,
              4429, 3860, 4276, 5157, 5158, 4464, 3307, 5181, 4467, 3601, 
             4815, 3602, 5919, 3891, 5186, 3890, 5918, 4474, 4475, 4200, 5192,
              5193, 5194, 4838, 5207, 5206}],
            RowBox[{"-", "9.75`"}]],
           Annotation[#, -9.75, "Tooltip"]& ]}, 
         {GrayLevel[0], Opacity[0.4], 
          TagBox[
           
           TooltipBox[
            LineBox[{3313, 5196, 4478, 3898, 4843, 3606, 5881, 4477, 3871, 
             4440, 3872, 4822, 4280, 5878, 3869, 5140, 5162, 5163, 4441, 5847,
              3833, 5834, 3834, 5848, 4261, 4770, 3832, 4392, 5144, 4395, 
             5846, 3553, 4774, 3836, 4397, 4772, 4771}],
            RowBox[{"-", "10.4`"}]],
           Annotation[#, -10.4, "Tooltip"]& ], 
          TagBox[
           
           TooltipBox[
            LineBox[{3341, 4542, 6631, 6021, 6023, 5673, 5677, 5676, 6061, 
             3973, 4569, 3680, 4897, 3682, 4573, 3992, 6085, 6560, 3695, 6562,
              3697, 5705, 4008, 6097, 6563, 3711, 6565, 3713, 6104, 4025, 
             5434, 6416, 4636, 3723, 4962, 4335, 4337, 5278, 3388, 4665, 4666,
              4065, 4346, 4064, 4994, 4671, 5003, 5004, 4249, 5749, 5750, 
             3755, 6324, 3756, 6798, 6799, 6797, 5751, 5336, 6441, 3408}],
            RowBox[{"-", "10.4`"}]],
           Annotation[#, -10.4, "Tooltip"]& ], 
          TagBox[
           
           TooltipBox[
            LineBox[{4099, 6153, 4100, 6165, 4361, 6162, 4098, 5323, 5340, 
             3414, 4711, 5013, 5014, 4685, 3748, 5008, 3747, 4982, 4059, 4684,
              5296, 4341, 4340, 4977, 4978, 4653, 4652, 3381, 3476, 6209, 
             4332, 4031, 4619, 5272, 3380, 6207, 6212, 5762, 6817, 5763, 5761,
              3766, 5764, 6502, 5504, 3791, 5793, 4118, 5792, 3790, 5502, 
             5503, 6713, 4178, 6517, 6518, 5100, 4177, 6773, 4237, 6770, 6772,
              6771, 3371, 5814, 5815, 5812, 3813, 5811, 3814, 4750, 4749, 
             3532, 5522, 5523, 5412, 6671, 6462, 6463, 4898, 4582, 6276, 4583,
              4903, 4902, 4318, 4319, 3999, 4587, 4000, 4901, 3692, 4893, 
             3693, 4585, 5256, 3365, 4589, 6079, 6080, 6073, 3990, 6081, 4314,
              6078, 3989, 5235, 5245}],
            RowBox[{"-", "10.4`"}]],
           Annotation[#, -10.4, "Tooltip"]& ], 
          TagBox[
           
           TooltipBox[
            LineBox[{4791, 4414, 3291, 5573, 5574, 5572, 5577, 5576, 6341, 
             6340, 4418, 3567, 4797, 3568, 4420, 6342, 5584, 3570, 5581, 3571,
              5586, 6343, 5593, 3573, 5590, 3574, 5870, 3857, 5867, 3856, 
             4428, 3577, 4807, 4274, 4275, 4805, 4804, 4435, 4436, 3863, 4279,
              5160, 5161, 4468, 3309, 5185, 4471, 3604, 4819, 3605, 5923, 
             5924, 5191, 5922, 5921}],
            RowBox[{"-", "10.4`"}]],
           Annotation[#, -10.4, "Tooltip"]& ]}, 
         {GrayLevel[0], Opacity[0.4], 
          TagBox[
           
           TooltipBox[
            LineBox[{3288, 4394, 3287, 5145, 4391, 4769, 3552, 4767, 3551, 
             5835, 5836, 5833, 6169, 6788, 6168, 3420, 6444, 6443, 6332, 5355,
              5142, 5840, 5838, 3581, 4825, 3582, 4823, 4439, 4821, 4820, 
             4476, 4841}],
            RowBox[{"-", "11.05`"}]],
           Annotation[#, -11.05, "Tooltip"]& ], 
          TagBox[
           
           TooltipBox[
            LineBox[{3358, 4572, 6653, 6084, 6086, 5701, 5704, 5703, 6655, 
             6096, 6098, 5720, 5723, 5722, 6103, 4632, 4633, 4967, 4966, 3724,
              4638, 4044, 4663, 4045, 4965, 3737, 4995, 4345, 4347, 5303, 
             3400, 6200, 4131, 6328, 4253, 6326, 4252, 6327, 6330, 6329, 4090,
              5033, 4250, 6325, 6749, 4218, 5117, 4217, 5034, 6139, 4094}],
            RowBox[{"-", "11.05`"}]],
           Annotation[#, -11.05, "Tooltip"]& ], 
          TagBox[
           
           TooltipBox[
            LineBox[{3415, 3493, 6668, 6669, 6160, 6164, 6163, 3760, 5015, 
             4081, 4715, 5325, 4352, 4351, 5010, 5011, 4683, 4682, 3392, 3482,
              4976, 4057, 4660, 4058, 4657, 4655, 4947, 6211, 4152, 6210, 
             4153, 4946, 4945, 5477, 5476, 6208, 4151, 5087, 5479, 3510, 4735,
              5482, 5481, 5480, 3780, 6584, 3804, 6582, 3802, 6581, 3803, 
             6583, 3779, 5478, 5802, 5803, 3801, 5804, 4377, 4378, 4189, 5524,
              5525, 5526, 5086, 6763, 6764, 6762, 6766, 6765, 3815, 6585, 
             3816, 5813, 3775, 5413, 3774, 5769, 3372, 6278, 4190, 6277, 6280,
              6279, 4001, 6283, 5254, 5255, 3464, 4900, 4586, 4588, 4908, 
             4907, 4320, 4321, 4002, 4591, 4003, 4906, 3694, 6082, 6083, 5247,
              6409, 3357, 3460, 4894}],
            RowBox[{"-", "11.05`"}]],
           Annotation[#, -11.05, "Tooltip"]& ], 
          TagBox[
           
           TooltipBox[
            LineBox[{4796, 4419, 3292, 5582, 5583, 5580, 5587, 5585, 3293, 
             5591, 5592, 5589, 5595, 5594, 3294, 4423, 4424, 4803, 4802, 3576,
              4426, 5156, 4432, 3859, 4806, 3579, 4814, 4277, 4278, 4813, 
             4812, 5064, 4127, 4816, 3866, 4470, 3867, 4473, 5367, 4472, 5190,
              5189}],
            RowBox[{"-", "11.05`"}]],
           Annotation[#, -11.05, "Tooltip"]& ]}, 
         {GrayLevel[0], Opacity[0.4], 
          TagBox[
           
           TooltipBox[
            LineBox[{3407, 3490, 5456, 5455, 4219, 5116, 5115, 4091, 6662, 
             6323, 4245, 6322, 4244, 5463, 5462, 4998, 4067, 5069, 4066, 4668,
              3738, 4999, 5000, 4664, 4662, 4964, 4637, 5280, 5279}],
            RowBox[{"-", "11.700000000000001`"}]],
           Annotation[#, -11.700000000000001`, "Tooltip"]& ], 
          TagBox[
           
           TooltipBox[
            LineBox[{3830, 4393, 3831, 4768, 3550, 5837, 3827, 6589, 3826, 
             6170, 6171, 4761, 4111, 4765, 6173, 6172, 5354, 5141, 3828, 5839,
              3580, 4826, 3873, 4438, 5166}],
            RowBox[{"-", "11.700000000000001`"}]],
           Annotation[#, -11.700000000000001`, "Tooltip"]& ], 
          TagBox[
           
           TooltipBox[
            LineBox[{3858, 4801, 4425, 3295, 4430, 4431, 4811, 4810, 3578, 
             4434, 5159, 5872, 3862, 6593, 5871, 4220, 6307, 5460, 5461, 4817,
              6475, 4818, 4112, 5366, 6199, 6805, 3426, 6450}],
            RowBox[{"-", "11.700000000000001`"}]],
           Annotation[#, -11.700000000000001`, "Tooltip"]& ], 
          TagBox[
           
           TooltipBox[
            LineBox[{4102, 6161, 6167, 6166, 4362, 5038, 5039, 4714, 5342, 
             4712, 3404, 3487, 5009, 4079, 4691, 4080, 4687, 4686, 4986, 4987,
              4661, 3736, 4979, 3734, 4656, 4034, 5091, 4035, 4948, 5059, 
             5058, 5088, 5089, 4232, 5135, 4231, 5130, 5090, 3525, 5511, 4379,
              3542, 5136, 4256, 4257, 6465, 6464, 6811, 3777, 6567, 3778, 
             5770, 3776, 5085, 4371, 4372, 4746, 4745, 4598, 4599, 4382, 3543,
              4741, 4258, 6281, 6282, 5528, 6532, 3533, 4904, 5532, 5531, 
             5529, 4191, 5261, 3373, 4601, 4602, 4004, 4605, 5257, 5258, 3465,
              4905, 4590, 4911, 4593, 4914, 4913, 4322, 6094, 6095, 5246, 
             5259}],
            RowBox[{"-", "11.700000000000001`"}]],
           Annotation[#, -11.700000000000001`, "Tooltip"]& ]}, 
         {GrayLevel[0], Opacity[0.4], 
          TagBox[
           
           TooltipBox[
            LineBox[{3286, 4390, 3285, 6308, 5139, 4136, 4760, 6204, 4759, 
             5055, 4764, 6196, 4766, 3829, 4763, 5143, 4762, 4437, 4824}],
            RowBox[{"-", "12.35`"}]],
           Annotation[#, -12.35, "Tooltip"]& ], 
          TagBox[
           
           TooltipBox[
            LineBox[{3500, 5067, 4128, 6752, 4223, 6751, 4222, 5065, 4126, 
             6678, 6679, 6476, 6477, 5061, 4125, 5118, 4221, 5063, 5062, 3865,
              5874, 3864, 6815, 5875, 5873, 3296, 4433, 4809, 3861}],
            RowBox[{"-", "12.35`"}]],
           Annotation[#, -12.35, "Tooltip"]& ], 
          TagBox[
           
           TooltipBox[
            LineBox[{4005, 4910, 3466, 4323, 4007, 4592, 4006, 4912, 4609, 
             3374, 5263, 4604, 4923, 3707, 4909, 3706, 4920, 4017, 4607, 4016,
              6177, 6178, 5530, 4115, 6179, 6176, 4192, 5534, 5533, 5527, 
             3817, 4381, 5816, 4380, 5429, 5428, 6258, 3705, 4600, 5505, 3518,
              4742, 6504, 6503, 6578, 3792, 6580, 6579, 6802, 6801, 6510, 
             5556, 6821, 3545, 6535, 3544, 6534, 6248, 6507, 6506, 6509, 6508,
              6505, 6769, 6768, 4236, 6181, 6673, 6674, 6180, 5446, 5447, 
             3382, 5273, 4659, 3735, 4983, 4342, 4344, 5298, 4690, 4062, 4988,
              3749, 5012, 3751, 5022, 4693, 5020, 5019, 4716, 5343, 5341, 
             4713, 4101, 4363, 3494, 5345, 5344}],
            RowBox[{"-", "12.35`"}]],
           Annotation[#, -12.35, "Tooltip"]& ], 
          TagBox[
           
           TooltipBox[
            LineBox[{5060, 5075, 4141, 6689, 4142, 6686, 6688, 6687, 5074, 
             4133, 6753, 6754, 6478, 6480, 6479, 6680, 4132, 6681, 6201, 6203,
              6202, 4130, 5070, 4129, 5068, 4997, 4667, 5305, 5304}],
            RowBox[{"-", "12.35`"}]],
           Annotation[#, -12.35, "Tooltip"]& ]}, 
         {GrayLevel[0], Opacity[0.4], 
          TagBox[
           
           TooltipBox[
            LineBox[{3375, 4611, 4613, 4916, 4915, 3709, 4610, 5262, 4603, 
             4018, 4924, 4325, 4926, 3708, 4919, 4606, 4918, 4917, 6467, 6466,
              6672, 5430, 5536, 5535, 3534, 4751, 4752, 3819, 5817, 3818, 
             5818, 5823, 5822, 3383, 6774, 4238, 6320, 4239, 5102, 5101, 6520,
              6519, 5794, 3794, 5779, 3793, 6193, 4120, 6191, 4119, 6192, 
             4121, 6194, 3795, 5781, 3796, 5795, 3767, 5133, 5134, 4737, 6767,
              4736, 6225, 6213, 3393, 5297, 4658, 4060, 4343, 6214, 3483, 
             3394, 5299, 4689, 4989, 3750, 5016, 4353, 5021, 4085, 4692, 4084,
              4717, 3761, 5040, 5041, 4721, 4720, 5047}],
            RowBox[{"-", "13"}]],
           Annotation[#, -13, "Tooltip"]& ], 
          TagBox[
           
           TooltipBox[
            LineBox[{3501, 5072, 3502, 5464, 5071, 4134, 5125, 4135, 5078, 
             5079, 5124, 5123, 4144, 5077, 6482, 6481, 4247, 6781, 4145, 6331,
              5467, 5468, 5073, 5120}],
            RowBox[{"-", "13"}]],
           Annotation[#, -13, "Tooltip"]& ], 
          TagBox[
           
           TooltipBox[
            LineBox[{3506, 5066, 6486, 6485, 6484, 4147, 4368, 3505, 5076, 
             4143, 5121, 5122, 4243, 6778, 4242, 4140, 6779, 6780, 6685, 6684,
              6683, 4246, 5465, 3503, 5119, 5112}],
            RowBox[{"-", "13"}]],
           Annotation[#, -13, "Tooltip"]& ], 
          TagBox[
           
           TooltipBox[
            LineBox[{4224, 6309, 4225, 6310, 4137, 6205, 4139, 6682, 4138, 
             6803, 6472, 6473, 6197, 4122, 6195, 4123, 6198, 6590, 5841, 6724,
              6725, 6726, 6723, 6333}],
            RowBox[{"-", "13"}]],
           Annotation[#, -13, "Tooltip"]& ]}, 
         {GrayLevel[0], Opacity[0.4], 
          TagBox[
           
           TooltipBox[
            LineBox[{3499, 6474, 5459, 6306, 6305, 4124, 6693, 6694, 6690, 
             6692, 6691, 3504, 6696, 6697, 6695, 6699, 6698, 4146, 6758, 6759,
              6755, 6757, 6756}],
            RowBox[{"-", "13.65`"}]],
           Annotation[#, -13.65, "Tooltip"]& ], 
          TagBox[
           
           TooltipBox[
            LineBox[{4105, 4722, 5049, 5048, 4364, 5045, 3762, 4719, 5328, 
             3405, 3488, 4354, 4082, 4688, 5326, 5327, 4694, 4990, 6216, 6217,
              6215, 4155, 6218, 4061, 4985, 5486, 6228, 4154, 5092, 5489, 
             5490, 4738, 4739, 3784, 6570, 3783, 6812, 5807, 3807, 5780, 3781,
              5778, 3782, 5806, 3806, 5805, 3805, 4383, 3546, 6284, 4193, 
             5539, 5540, 3535, 5094, 6313, 5820, 5821, 5537, 6533, 5538, 5777,
              6568, 6569, 5775, 5776, 5772, 5771, 3384, 5107, 5108, 4925, 
             4019, 4608, 4020, 4326, 6285, 3471, 4921, 4922, 4614, 3710, 4936,
              4327, 4931, 4932, 4612, 5264}],
            RowBox[{"-", "13.65`"}]],
           Annotation[#, -13.65, "Tooltip"]& ]}, 
         {GrayLevel[0], Opacity[0.4], 
          TagBox[
           
           TooltipBox[
            LineBox[{3824, 5831, 3825, 5832, 3770, 5767, 3771, 5466, 6483}],
            RowBox[{"-", "14.3`"}]],
           Annotation[#, -14.3, "Tooltip"]& ], 
          TagBox[
           
           TooltipBox[
            LineBox[{4022, 4930, 3473, 5265, 4328, 4023, 4615, 4934, 4933, 
             4624, 3385, 6720, 6721, 6286, 4196, 6288, 4021, 4928, 5541, 4387,
              4194, 5109, 4259, 5773, 5774, 5483, 5485, 3512, 5819, 3511, 
             6223, 6224, 6221, 4157, 6315, 4234, 6314, 4233, 4374, 4373, 5131,
              5132, 5114, 5113, 6304, 5559, 5560, 5557, 3547, 5558, 4179, 
             6261, 4180, 6262, 4158, 6227, 6702, 6701, 3513, 4984, 3514, 6489,
              5488, 6220, 6219, 4063, 4695, 4992, 3753, 5018, 4083, 4701, 
             4700, 5026, 4724, 3416, 5346, 4718, 4103, 4365, 5043, 3496, 5349,
              5348}],
            RowBox[{"-", "14.3`"}]],
           Annotation[#, -14.3, "Tooltip"]& ]}, 
         {GrayLevel[0], Opacity[0.4], 
          TagBox[
           
           TooltipBox[
            LineBox[{3417, 3495, 5042, 5044, 4729, 4104, 4725, 5347, 4723, 
             5027, 4088, 4702, 3754, 5017, 3752, 4991, 4993, 4699, 5302, 6189,
              6190, 5487, 4117, 6188, 6186, 4173, 6226, 4174, 6804, 6255, 
             6521, 3526, 5512, 5513, 5300, 5301, 3395, 6256, 6250, 6251, 6249,
              6253, 6252, 4156, 6254, 4172, 6222, 4171, 5743, 3719, 5484, 
             5745, 5744, 3548, 4754, 4755, 4386, 6289, 4385, 3536, 4927, 3537,
              5544, 5542, 4195, 6287, 5274, 5275, 4623, 4935, 4625, 4024, 
             4628, 5266, 3376, 3472, 4929}],
            RowBox[{"-", "14.950000000000001`"}]],
           Annotation[#, -14.950000000000001`, "Tooltip"]& ]}, 
         {GrayLevel[0], Opacity[0.4], 
          TagBox[
           
           TooltipBox[
            LineBox[{3386, 5277, 4627, 4955, 3721, 4937, 3720, 4952, 4037, 
             4630, 4036, 6183, 6184, 5543, 4116, 6185, 6182, 4197, 6290, 6292,
              6291, 3821, 4757, 3820, 4753, 4384, 5449, 5448, 6263, 4181, 
             4622, 4621, 3520, 5093, 3519, 6511, 5506, 5509, 5508, 3522, 5562,
              5563, 5561, 6260, 6259, 6512, 3521, 6794, 6795, 6793, 5507, 
             5451, 6187, 5453, 5454, 3396, 4696, 5330, 4698, 5024, 5023, 4355,
              4357, 5333, 4728, 4089, 5028, 3763, 5046, 3765, 5054, 4731, 
             5052, 5051}],
            RowBox[{"-", "15.600000000000001`"}]],
           Annotation[#, -15.600000000000001`, "Tooltip"]& ]}, 
         {GrayLevel[0], Opacity[0.4], 
          TagBox[
           
           TooltipBox[
            LineBox[{4109, 4730, 4110, 5053, 4366, 5050, 3764, 5029, 4727, 
             5334, 3406, 3489, 6233, 4356, 4086, 4697, 5329, 6231, 5332, 6230,
              6229, 6239, 5765, 5766, 5452, 3768, 5799, 3800, 5790, 3799, 
             5798, 6471, 5796, 3797, 5787, 3798, 5797, 6523, 6524, 5103, 5104,
              4241, 6321, 4240, 6775, 3397, 5825, 5826, 5824, 5828, 5827, 
             3822, 5830, 5545, 5546, 4756, 3538, 5547, 6796, 5548, 6676, 6677,
              6675, 6468, 6469, 4949, 4950, 4629, 4951, 3722, 4960, 4333, 
             4956, 4039, 4626, 5276}],
            RowBox[{"-", "16.25`"}]],
           Annotation[#, -16.25, "Tooltip"]& ]}, 
         {GrayLevel[0], Opacity[0.4], 
          TagBox[
           
           TooltipBox[
            LineBox[{4038, 4954, 3478, 6419, 4334, 4040, 4631, 4958, 4957, 
             5110, 3399, 5782, 5784, 5450, 5785, 6573, 6572, 5549, 5829, 6588,
              3823, 5552, 5553, 3540, 4758, 3539, 5550, 5551, 5565, 6536, 
             5564, 3549, 5808, 3808, 5514, 6522, 5789, 3787, 5786, 3786, 5788,
              3809, 5809, 6574, 3788, 6575, 3789, 5791, 3769, 4740, 6494, 
             5494, 6241, 6240, 4159, 5331, 4160, 6232, 4087, 6238, 4161, 6234,
              6236, 6235, 5031, 4733, 3418, 5350, 4726, 4107, 4367, 3498, 
             5353, 5352}],
            RowBox[{"-", "16.900000000000002`"}]],
           Annotation[#, -16.900000000000002`, "Tooltip"]& ]}, 
         {GrayLevel[0], Opacity[0.4], 
          TagBox[
           
           TooltipBox[
            LineBox[{3419, 3497, 4106, 6832, 4108, 4734, 5351, 4732, 5030, 
             6237, 5032, 4162, 6831, 6492, 6493, 5025, 6828, 5491, 4164, 5493,
              5495, 5496, 6265, 6264, 4388, 4389, 3810, 6528, 6529, 6530, 
             4744, 3527, 4743, 6527, 6526, 6525, 4182, 4375, 3515, 6318, 6319,
              6317, 6316, 5492, 4163, 4235, 6792, 6827, 6586, 6587, 6491, 
             6571, 6490, 6830, 3785, 4260, 5783, 3398, 5111, 4198, 4959, 4199,
              6722, 4041, 6829, 6420, 3387, 3477, 4953}],
            RowBox[{"-", "17.55`"}]],
           Annotation[#, -17.55, "Tooltip"]& ]}, {}, {}}}],
      AspectRatio->1,
      BaseStyle->{FontFamily -> "Times"},
      DisplayFunction:>Identity,
      Frame->True,
      FrameLabel->{
        FormBox["\"Number of buys\"", TraditionalForm], 
        FormBox["\"Number of sells\"", TraditionalForm], None, None},
      PlotRange->{{0, 30}, {0, 30}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}], {192., -189.}, ImageScaled[{0.5, 0.5}], {360., 360.}],
     InsetBox[
     Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJxM3XVUlVnfh3FUTDBAxEYsxAZEREVCMBCxQREEu7uwuxMdY+zuxK6xO8bu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       "], {{
         {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxMnXW8VcX3hs8953KLe+rCNVAUQUVsFBELRUWwu0UUExvFDrCwsLsLBQvF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             "]], Polygon3DBox[CompressedData["
1:eJwtnXm8VdMbxs88n3PvPfucWxlTSomIlCFKRCkRERGJzCQyjxWRqQyRyBQR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             "]], Polygon3DBox[CompressedData["
1:eJwl13mcz3UeB/DvmDHDIOcIMwwjVyPjPpaIyJhxzjjGMQw52iwRDSNy3yai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             "]]}]}, {}, {}, {}}, {Line3DBox[CompressedData["
1:eJwl1Edsj3Ecx/GvWTVae68arVGbAw64cOHChYsV40AJvXDhwoWL2dq1arRW
7dGWmrU5UKsRGkEEEUSsxOuJw8v7+UiT///5PU+bMXPhxAW1IqKZf56mRiTX
j/Q6Q1zPJp/i9Iib+pt+fqjanqZruUJ604jvmlU7Ygpj7NVaxmdy7Yw6EZNY
SaF9Rt/ToW5ElT1Bl1NCarOIGm1VL2IcI+2lWkw1OXZ6fZ9DLgV2oVaRmhLx
0B6pORRQp7n/S9ogYljCnqubuc1c+68OcN8zuMVz1lPFfTawkTxKGzsX3cRm
yuwtupVtlNvbdQcFXLR36i52c8neo3sppMLep/s5wGX7oBZRzBX7kB7mCFft
o3qMEq7Zx/UEJ5PnZ5/S05zhhn1Wz3GeSvtCch/Jd+emXZ58z+S7JfdvVyTf
I/ls7vAi+Vye8IB1TKc/+c7vj/O7xSZm23N0KLUZYj9w/juYTy17hDbgsWd2
3/Paq4sZzXY7TV941kXMs5foWFoy3H7t/TjGMlLs8dqed96pR96n07qCieyx
u+on72Ipi+xVOplMRtnfvL+XWUMTe6pm88s7/9z7Xql5zKLSPT9jsOvHeo9B
rgcygJ/JuSS/K2Tzw+6rfejNd7uXZpHJV7un9qA7X+xumkFXPttdtDOd+Gh3
1A6054PdTtvShvd2a21FS97aLbR58rvOG9sthtuKNGrsJuqxRyNe2Q1VwuOL
ly48qvBIwvFHte2ow5GG44u7qf//fvwDw6WTaw==
          "]], {
          Line3DBox[{4011, 4760, 4010, 4761, 4012, 4762, 4013, 3320, 4014, 
           4763, 4015, 4764, 4016, 5375, 5585, 4017, 4765, 4018, 4766, 4019, 
           5376, 5586, 4020, 4767, 4021, 4768, 4022, 5377, 5587, 4023, 4769, 
           4024, 4770, 4025, 5378, 5588, 4026, 4771, 4027, 4772, 4028, 5379, 
           5589, 4029, 4773, 4030, 4774, 4031, 5380, 5590, 4032, 4775, 4033, 
           4776, 4034, 5381, 5591, 4035, 4777, 4036, 4778, 4037, 5382, 5592, 
           4038, 4779, 4039, 4780, 4040, 5383, 5593, 4041, 4781, 4042, 4782, 
           4043, 5384, 5594, 4044, 4783, 4045, 4784, 4046, 5385, 5595, 4047, 
           4785, 4048, 4786, 4049, 5386, 5596, 4050, 4787, 4051, 4788, 4052, 
           5387, 5597, 4053, 4789, 4054, 4790, 4055, 5388, 5598, 4056, 4791, 
           4057, 4792, 4058, 4793, 4059}], 
          Line3DBox[{4061, 4794, 4060, 4795, 4062, 4796, 4063, 5480, 4797, 
           4064, 4798, 4065, 4799, 4066, 3366, 4067, 4800, 4068, 4801, 4069, 
           5389, 5599, 4070, 4802, 4071, 4803, 4072, 5390, 5600, 4073, 4804, 
           4074, 4805, 4075, 5391, 5601, 4076, 4806, 4077, 4807, 4078, 5392, 
           5602, 4079, 4808, 4080, 4809, 4081, 5393, 5603, 4082, 4810, 4083, 
           4811, 4084, 5394, 5604, 4085, 4812, 4086, 4813, 4087, 5395, 5605, 
           4088, 4814, 4089, 4815, 4090, 5396, 5606, 4091, 4816, 4092, 4817, 
           4093, 5397, 5607, 4094, 4818, 4095, 4819, 4096, 5398, 5608, 4097, 
           4820, 4098, 4821, 4099, 5399, 5609, 4100, 4822, 4101, 4823, 4102, 
           5400, 5610, 4103, 4824, 4104, 4825, 4105, 5401, 5611, 4106, 4826, 
           4107, 4827, 4108, 4828, 4109}], 
          Line3DBox[{4111, 4829, 4110, 4830, 4112, 4831, 4113, 5481, 4832, 
           4114, 4833, 4115, 4834, 4116, 5482, 4835, 4117, 4836, 4118, 4837, 
           4119, 3412, 4120, 4838, 4121, 4839, 4122, 5402, 5612, 4123, 4840, 
           4124, 4841, 4125, 5403, 5613, 4126, 4842, 4127, 4843, 4128, 5404, 
           5614, 4129, 4844, 4130, 4845, 4131, 5405, 5615, 4132, 4846, 4133, 
           4847, 4134, 5406, 5616, 4135, 4848, 4136, 4849, 4137, 5407, 5617, 
           4138, 4850, 4139, 4851, 4140, 5408, 5618, 4141, 4852, 4142, 4853, 
           4143, 5409, 5619, 4144, 4854, 4145, 4855, 4146, 5410, 5620, 4147, 
           4856, 4148, 4857, 4149, 5411, 5621, 4150, 4858, 4151, 4859, 4152, 
           5412, 5622, 4153, 4860, 4154, 4861, 4155, 5413, 5623, 4156, 4862, 
           4157, 4863, 4158, 4864, 4159}], 
          Line3DBox[{4161, 4865, 4160, 4866, 4162, 4867, 4163, 5483, 4868, 
           4164, 4869, 4165, 4870, 4166, 5484, 4871, 4167, 4872, 4168, 4873, 
           4169, 5485, 4874, 4170, 4875, 4171, 4876, 4172, 3458, 4173, 4877, 
           4174, 4878, 4175, 5414, 5624, 4176, 4879, 4177, 4880, 4178, 5415, 
           5625, 4179, 4881, 4180, 4882, 4181, 5416, 5626, 4182, 4883, 4183, 
           4884, 4184, 5417, 5627, 4185, 4885, 4186, 4886, 4187, 5418, 5628, 
           4188, 4887, 4189, 4888, 4190, 5419, 5629, 4191, 4889, 4192, 4890, 
           4193, 5420, 5630, 4194, 4891, 4195, 4892, 4196, 5421, 5631, 4197, 
           4893, 4198, 4894, 4199, 5422, 5632, 4200, 4895, 4201, 4896, 4202, 
           5423, 5633, 4203, 4897, 4204, 4898, 4205, 5424, 5634, 4206, 4899, 
           4207, 4900, 4208, 4901, 4209}], 
          Line3DBox[{4211, 4902, 4210, 4903, 4212, 4904, 4213, 5486, 4905, 
           4214, 4906, 4215, 4907, 4216, 5487, 4908, 4217, 4909, 4218, 4910, 
           4219, 5488, 4911, 4220, 4912, 4221, 4913, 4222, 5489, 4914, 4223, 
           4915, 4224, 4916, 4225, 3504, 4226, 4917, 4227, 4918, 4228, 5425, 
           5635, 4229, 4919, 4230, 4920, 4231, 5426, 5636, 4232, 4921, 4233, 
           4922, 4234, 5427, 5637, 4235, 4923, 4236, 4924, 4237, 5428, 5638, 
           4238, 4925, 4239, 4926, 4240, 5429, 5639, 4241, 4927, 4242, 4928, 
           4243, 5430, 5640, 4244, 4929, 4245, 4930, 4246, 5431, 5641, 4247, 
           4931, 4248, 4932, 4249, 5432, 5642, 4250, 4933, 4251, 4934, 4252, 
           5433, 5643, 4253, 4935, 4254, 4936, 4255, 5434, 5644, 4256, 4937, 
           4257, 4938, 4258, 4939, 4259}], 
          Line3DBox[{4261, 4940, 4260, 4941, 4262, 4942, 4263, 5490, 4943, 
           4264, 4944, 4265, 4945, 4266, 5491, 4946, 4267, 4947, 4268, 4948, 
           4269, 5492, 4949, 4270, 4950, 4271, 4951, 4272, 5493, 4952, 4273, 
           4953, 4274, 4954, 4275, 5494, 4955, 4276, 4956, 4277, 4957, 4278, 
           3550, 4279, 4958, 4280, 4959, 4281, 5435, 5645, 4282, 4960, 4283, 
           4961, 4284, 5436, 5646, 4285, 4962, 4286, 4963, 4287, 5437, 5647, 
           4288, 4964, 4289, 4965, 4290, 5438, 5648, 4291, 4966, 4292, 4967, 
           4293, 5439, 5649, 4294, 4968, 4295, 4969, 4296, 5440, 5650, 4297, 
           4970, 4298, 4971, 4299, 5441, 5651, 4300, 4972, 4301, 4973, 4302, 
           5442, 5652, 4303, 4974, 4304, 4975, 4305, 5443, 5653, 4306, 4976, 
           4307, 4977, 4308, 4978, 4309}], 
          Line3DBox[{4311, 4979, 4310, 4980, 4312, 4981, 4313, 5495, 4982, 
           4314, 4983, 4315, 4984, 4316, 5496, 4985, 4317, 4986, 4318, 4987, 
           4319, 5497, 4988, 4320, 4989, 4321, 4990, 4322, 5498, 4991, 4323, 
           4992, 4324, 4993, 4325, 5499, 4994, 4326, 4995, 4327, 4996, 4328, 
           5500, 4997, 4329, 4998, 4330, 4999, 4331, 3596, 4332, 5000, 4333, 
           5001, 4334, 5444, 5654, 4335, 5002, 4336, 5003, 4337, 5445, 5655, 
           4338, 5004, 4339, 5005, 4340, 5446, 5656, 4341, 5006, 4342, 5007, 
           4343, 5447, 5657, 4344, 5008, 4345, 5009, 4346, 5448, 5658, 4347, 
           5010, 4348, 5011, 4349, 5449, 5659, 4350, 5012, 4351, 5013, 4352, 
           5450, 5660, 4353, 5014, 4354, 5015, 4355, 5451, 5661, 4356, 5016, 
           4357, 5017, 4358, 5018, 4359}], 
          Line3DBox[{4361, 5019, 4360, 5020, 4362, 5021, 4363, 5501, 5022, 
           4364, 5023, 4365, 5024, 4366, 5502, 5025, 4367, 5026, 4368, 5027, 
           4369, 5503, 5028, 4370, 5029, 4371, 5030, 4372, 5504, 5031, 4373, 
           5032, 4374, 5033, 4375, 5505, 5034, 4376, 5035, 4377, 5036, 4378, 
           5506, 5037, 4379, 5038, 4380, 5039, 4381, 5507, 5040, 4382, 5041, 
           4383, 5042, 4384, 3642, 4385, 5043, 4386, 5044, 4387, 5452, 5662, 
           4388, 5045, 4389, 5046, 4390, 5453, 5663, 4391, 5047, 4392, 5048, 
           4393, 5454, 5664, 4394, 5049, 4395, 5050, 4396, 5455, 5665, 4397, 
           5051, 4398, 5052, 4399, 5456, 5666, 4400, 5053, 4401, 5054, 4402, 
           5457, 5667, 4403, 5055, 4404, 5056, 4405, 5458, 5668, 4406, 5057, 
           4407, 5058, 4408, 5059, 4409}], 
          Line3DBox[{4411, 5060, 4410, 5061, 4412, 5062, 4413, 5508, 5063, 
           4414, 5064, 4415, 5065, 4416, 5509, 5066, 4417, 5067, 4418, 5068, 
           4419, 5510, 5069, 4420, 5070, 4421, 5071, 4422, 5511, 5072, 4423, 
           5073, 4424, 5074, 4425, 5512, 5075, 4426, 5076, 4427, 5077, 4428, 
           5513, 5078, 4429, 5079, 4430, 5080, 4431, 5514, 5081, 4432, 5082, 
           4433, 5083, 4434, 5515, 5084, 4435, 5085, 4436, 5086, 4437, 3688, 
           4438, 5087, 4439, 5088, 4440, 5459, 5669, 4441, 5089, 4442, 5090, 
           4443, 5460, 5670, 4444, 5091, 4445, 5092, 4446, 5461, 5671, 4447, 
           5093, 4448, 5094, 4449, 5462, 5672, 4450, 5095, 4451, 5096, 4452, 
           5463, 5673, 4453, 5097, 4454, 5098, 4455, 5464, 5674, 4456, 5099, 
           4457, 5100, 4458, 5101, 4459}], 
          Line3DBox[{4461, 5102, 4460, 5103, 4462, 5104, 4463, 5516, 5105, 
           4464, 5106, 4465, 5107, 4466, 5517, 5108, 4467, 5109, 4468, 5110, 
           4469, 5518, 5111, 4470, 5112, 4471, 5113, 4472, 5519, 5114, 4473, 
           5115, 4474, 5116, 4475, 5520, 5117, 4476, 5118, 4477, 5119, 4478, 
           5521, 5120, 4479, 5121, 4480, 5122, 4481, 5522, 5123, 4482, 5124, 
           4483, 5125, 4484, 5523, 5126, 4485, 5127, 4486, 5128, 4487, 5524, 
           5129, 4488, 5130, 4489, 5131, 4490, 3734, 4491, 5132, 4492, 5133, 
           4493, 5465, 5675, 4494, 5134, 4495, 5135, 4496, 5466, 5676, 4497, 
           5136, 4498, 5137, 4499, 5467, 5677, 4500, 5138, 4501, 5139, 4502, 
           5468, 5678, 4503, 5140, 4504, 5141, 4505, 5469, 5679, 4506, 5142, 
           4507, 5143, 4508, 5144, 4509}], 
          Line3DBox[{4511, 5145, 4510, 5146, 4512, 5147, 4513, 5525, 5148, 
           4514, 5149, 4515, 5150, 4516, 5526, 5151, 4517, 5152, 4518, 5153, 
           4519, 5527, 5154, 4520, 5155, 4521, 5156, 4522, 5528, 5157, 4523, 
           5158, 4524, 5159, 4525, 5529, 5160, 4526, 5161, 4527, 5162, 4528, 
           5530, 5163, 4529, 5164, 4530, 5165, 4531, 5531, 5166, 4532, 5167, 
           4533, 5168, 4534, 5532, 5169, 4535, 5170, 4536, 5171, 4537, 5533, 
           5172, 4538, 5173, 4539, 5174, 4540, 5534, 5175, 4541, 5176, 4542, 
           5177, 4543, 3780, 4544, 5178, 4545, 5179, 4546, 5470, 5680, 4547, 
           5180, 4548, 5181, 4549, 5471, 5681, 4550, 5182, 4551, 5183, 4552, 
           5472, 5682, 4553, 5184, 4554, 5185, 4555, 5473, 5683, 4556, 5186, 
           4557, 5187, 4558, 5188, 4559}], 
          Line3DBox[{4561, 5189, 4560, 5190, 4562, 5191, 4563, 5535, 5192, 
           4564, 5193, 4565, 5194, 4566, 5536, 5195, 4567, 5196, 4568, 5197, 
           4569, 5537, 5198, 4570, 5199, 4571, 5200, 4572, 5538, 5201, 4573, 
           5202, 4574, 5203, 4575, 5539, 5204, 4576, 5205, 4577, 5206, 4578, 
           5540, 5207, 4579, 5208, 4580, 5209, 4581, 5541, 5210, 4582, 5211, 
           4583, 5212, 4584, 5542, 5213, 4585, 5214, 4586, 5215, 4587, 5543, 
           5216, 4588, 5217, 4589, 5218, 4590, 5544, 5219, 4591, 5220, 4592, 
           5221, 4593, 5545, 5222, 4594, 5223, 4595, 5224, 4596, 3826, 4597, 
           5225, 4598, 5226, 4599, 5474, 5684, 4600, 5227, 4601, 5228, 4602, 
           5475, 5685, 4603, 5229, 4604, 5230, 4605, 5476, 5686, 4606, 5231, 
           4607, 5232, 4608, 5233, 4609}], 
          Line3DBox[{4611, 5234, 4610, 5235, 4612, 5236, 4613, 5546, 5237, 
           4614, 5238, 4615, 5239, 4616, 5547, 5240, 4617, 5241, 4618, 5242, 
           4619, 5548, 5243, 4620, 5244, 4621, 5245, 4622, 5549, 5246, 4623, 
           5247, 4624, 5248, 4625, 5550, 5249, 4626, 5250, 4627, 5251, 4628, 
           5551, 5252, 4629, 5253, 4630, 5254, 4631, 5552, 5255, 4632, 5256, 
           4633, 5257, 4634, 5553, 5258, 4635, 5259, 4636, 5260, 4637, 5554, 
           5261, 4638, 5262, 4639, 5263, 4640, 5555, 5264, 4641, 5265, 4642, 
           5266, 4643, 5556, 5267, 4644, 5268, 4645, 5269, 4646, 5557, 5270, 
           4647, 5271, 4648, 5272, 4649, 3872, 4650, 5273, 4651, 5274, 4652, 
           5477, 5687, 4653, 5275, 4654, 5276, 4655, 5478, 5688, 4656, 5277, 
           4657, 5278, 4658, 5279, 4659}], 
          Line3DBox[{4661, 5280, 4660, 5281, 4662, 5282, 4663, 5558, 5283, 
           4664, 5284, 4665, 5285, 4666, 5559, 5286, 4667, 5287, 4668, 5288, 
           4669, 5560, 5289, 4670, 5290, 4671, 5291, 4672, 5561, 5292, 4673, 
           5293, 4674, 5294, 4675, 5562, 5295, 4676, 5296, 4677, 5297, 4678, 
           5563, 5298, 4679, 5299, 4680, 5300, 4681, 5564, 5301, 4682, 5302, 
           4683, 5303, 4684, 5565, 5304, 4685, 5305, 4686, 5306, 4687, 5566, 
           5307, 4688, 5308, 4689, 5309, 4690, 5567, 5310, 4691, 5311, 4692, 
           5312, 4693, 5568, 5313, 4694, 5314, 4695, 5315, 4696, 5569, 5316, 
           4697, 5317, 4698, 5318, 4699, 5570, 5319, 4700, 5320, 4701, 5321, 
           4702, 3918, 4703, 5322, 4704, 5323, 4705, 5479, 5689, 4706, 5324, 
           4707, 5325, 4708, 5326, 4709}], 
          Line3DBox[{4711, 5327, 4710, 5328, 4712, 5329, 4713, 5571, 5330, 
           4714, 5331, 4715, 5332, 4716, 5572, 5333, 4717, 5334, 4718, 5335, 
           4719, 5573, 5336, 4720, 5337, 4721, 5338, 4722, 5574, 5339, 4723, 
           5340, 4724, 5341, 4725, 5575, 5342, 4726, 5343, 4727, 5344, 4728, 
           5576, 5345, 4729, 5346, 4730, 5347, 4731, 5577, 5348, 4732, 5349, 
           4733, 5350, 4734, 5578, 5351, 4735, 5352, 4736, 5353, 4737, 5579, 
           5354, 4738, 5355, 4739, 5356, 4740, 5580, 5357, 4741, 5358, 4742, 
           5359, 4743, 5581, 5360, 4744, 5361, 4745, 5362, 4746, 5582, 5363, 
           4747, 5364, 4748, 5365, 4749, 5583, 5366, 4750, 5367, 4751, 5368, 
           4752, 5584, 5369, 4753, 5370, 4754, 5371, 4755, 3964, 4756, 5372, 
           4757, 5373, 4758, 5374, 4759}]}, {
          Line3DBox[{2525, 3275, 2526, 3290, 2555, 3305, 2570, 3320, 2585, 
           3335, 2600, 3350, 2615, 3365, 5480, 2630, 3380, 2645, 3395, 2660, 
           3410, 5481, 2675, 3425, 2690, 3440, 2705, 3455, 5483, 2720, 3470, 
           2735, 3485, 2750, 3500, 5486, 2765, 3515, 2780, 3530, 2795, 3545, 
           5490, 2810, 3560, 2825, 3575, 2840, 3590, 5495, 2855, 3605, 2870, 
           3620, 2885, 3635, 5501, 2900, 3650, 2915, 3665, 2930, 3680, 5508, 
           2945, 3695, 2960, 3710, 2975, 3725, 5516, 2990, 3740, 3005, 3755, 
           3020, 3770, 5525, 3035, 3785, 3050, 3800, 3065, 3815, 5535, 3080, 
           3830, 3095, 3845, 3110, 3860, 5546, 3125, 3875, 3140, 3890, 3155, 
           3905, 5558, 3170, 3920, 3185, 3935, 3200, 3950, 5571, 3215, 3965, 
           3230, 3980, 3245, 3995, 3260}], 
          Line3DBox[{2527, 3276, 2528, 3291, 2556, 3306, 2571, 5585, 3321, 
           2586, 3336, 2601, 3351, 2616, 3366, 2631, 3381, 2646, 3396, 2661, 
           3411, 5482, 2676, 3426, 2691, 3441, 2706, 3456, 5484, 2721, 3471, 
           2736, 3486, 2751, 3501, 5487, 2766, 3516, 2781, 3531, 2796, 3546, 
           5491, 2811, 3561, 2826, 3576, 2841, 3591, 5496, 2856, 3606, 2871, 
           3621, 2886, 3636, 5502, 2901, 3651, 2916, 3666, 2931, 3681, 5509, 
           2946, 3696, 2961, 3711, 2976, 3726, 5517, 2991, 3741, 3006, 3756, 
           3021, 3771, 5526, 3036, 3786, 3051, 3801, 3066, 3816, 5536, 3081, 
           3831, 3096, 3846, 3111, 3861, 5547, 3126, 3876, 3141, 3891, 3156, 
           3906, 5559, 3171, 3921, 3186, 3936, 3201, 3951, 5572, 3216, 3966, 
           3231, 3981, 3246, 3996, 3261}], 
          Line3DBox[{2529, 3277, 2530, 3292, 2557, 3307, 2572, 5586, 3322, 
           2587, 3337, 2602, 3352, 2617, 5599, 3367, 2632, 3382, 2647, 3397, 
           2662, 3412, 2677, 3427, 2692, 3442, 2707, 3457, 5485, 2722, 3472, 
           2737, 3487, 2752, 3502, 5488, 2767, 3517, 2782, 3532, 2797, 3547, 
           5492, 2812, 3562, 2827, 3577, 2842, 3592, 5497, 2857, 3607, 2872, 
           3622, 2887, 3637, 5503, 2902, 3652, 2917, 3667, 2932, 3682, 5510, 
           2947, 3697, 2962, 3712, 2977, 3727, 5518, 2992, 3742, 3007, 3757, 
           3022, 3772, 5527, 3037, 3787, 3052, 3802, 3067, 3817, 5537, 3082, 
           3832, 3097, 3847, 3112, 3862, 5548, 3127, 3877, 3142, 3892, 3157, 
           3907, 5560, 3172, 3922, 3187, 3937, 3202, 3952, 5573, 3217, 3967, 
           3232, 3982, 3247, 3997, 3262}], 
          Line3DBox[{2531, 3278, 2532, 3293, 2558, 3308, 2573, 5587, 3323, 
           2588, 3338, 2603, 3353, 2618, 5600, 3368, 2633, 3383, 2648, 3398, 
           2663, 5612, 3413, 2678, 3428, 2693, 3443, 2708, 3458, 2723, 3473, 
           2738, 3488, 2753, 3503, 5489, 2768, 3518, 2783, 3533, 2798, 3548, 
           5493, 2813, 3563, 2828, 3578, 2843, 3593, 5498, 2858, 3608, 2873, 
           3623, 2888, 3638, 5504, 2903, 3653, 2918, 3668, 2933, 3683, 5511, 
           2948, 3698, 2963, 3713, 2978, 3728, 5519, 2993, 3743, 3008, 3758, 
           3023, 3773, 5528, 3038, 3788, 3053, 3803, 3068, 3818, 5538, 3083, 
           3833, 3098, 3848, 3113, 3863, 5549, 3128, 3878, 3143, 3893, 3158, 
           3908, 5561, 3173, 3923, 3188, 3938, 3203, 3953, 5574, 3218, 3968, 
           3233, 3983, 3248, 3998, 3263}], 
          Line3DBox[{2533, 3279, 2534, 3294, 2559, 3309, 2574, 5588, 3324, 
           2589, 3339, 2604, 3354, 2619, 5601, 3369, 2634, 3384, 2649, 3399, 
           2664, 5613, 3414, 2679, 3429, 2694, 3444, 2709, 5624, 3459, 2724, 
           3474, 2739, 3489, 2754, 3504, 2769, 3519, 2784, 3534, 2799, 3549, 
           5494, 2814, 3564, 2829, 3579, 2844, 3594, 5499, 2859, 3609, 2874, 
           3624, 2889, 3639, 5505, 2904, 3654, 2919, 3669, 2934, 3684, 5512, 
           2949, 3699, 2964, 3714, 2979, 3729, 5520, 2994, 3744, 3009, 3759, 
           3024, 3774, 5529, 3039, 3789, 3054, 3804, 3069, 3819, 5539, 3084, 
           3834, 3099, 3849, 3114, 3864, 5550, 3129, 3879, 3144, 3894, 3159, 
           3909, 5562, 3174, 3924, 3189, 3939, 3204, 3954, 5575, 3219, 3969, 
           3234, 3984, 3249, 3999, 3264}], 
          Line3DBox[{2535, 3280, 2536, 3295, 2560, 3310, 2575, 5589, 3325, 
           2590, 3340, 2605, 3355, 2620, 5602, 3370, 2635, 3385, 2650, 3400, 
           2665, 5614, 3415, 2680, 3430, 2695, 3445, 2710, 5625, 3460, 2725, 
           3475, 2740, 3490, 2755, 5635, 3505, 2770, 3520, 2785, 3535, 2800, 
           3550, 2815, 3565, 2830, 3580, 2845, 3595, 5500, 2860, 3610, 2875, 
           3625, 2890, 3640, 5506, 2905, 3655, 2920, 3670, 2935, 3685, 5513, 
           2950, 3700, 2965, 3715, 2980, 3730, 5521, 2995, 3745, 3010, 3760, 
           3025, 3775, 5530, 3040, 3790, 3055, 3805, 3070, 3820, 5540, 3085, 
           3835, 3100, 3850, 3115, 3865, 5551, 3130, 3880, 3145, 3895, 3160, 
           3910, 5563, 3175, 3925, 3190, 3940, 3205, 3955, 5576, 3220, 3970, 
           3235, 3985, 3250, 4000, 3265}], 
          Line3DBox[{2537, 3281, 2538, 3296, 2561, 3311, 2576, 5590, 3326, 
           2591, 3341, 2606, 3356, 2621, 5603, 3371, 2636, 3386, 2651, 3401, 
           2666, 5615, 3416, 2681, 3431, 2696, 3446, 2711, 5626, 3461, 2726, 
           3476, 2741, 3491, 2756, 5636, 3506, 2771, 3521, 2786, 3536, 2801, 
           5645, 3551, 2816, 3566, 2831, 3581, 2846, 3596, 2861, 3611, 2876, 
           3626, 2891, 3641, 5507, 2906, 3656, 2921, 3671, 2936, 3686, 5514, 
           2951, 3701, 2966, 3716, 2981, 3731, 5522, 2996, 3746, 3011, 3761, 
           3026, 3776, 5531, 3041, 3791, 3056, 3806, 3071, 3821, 5541, 3086, 
           3836, 3101, 3851, 3116, 3866, 5552, 3131, 3881, 3146, 3896, 3161, 
           3911, 5564, 3176, 3926, 3191, 3941, 3206, 3956, 5577, 3221, 3971, 
           3236, 3986, 3251, 4001, 3266}], 
          Line3DBox[{2539, 3282, 2540, 3297, 2562, 3312, 2577, 5591, 3327, 
           2592, 3342, 2607, 3357, 2622, 5604, 3372, 2637, 3387, 2652, 3402, 
           2667, 5616, 3417, 2682, 3432, 2697, 3447, 2712, 5627, 3462, 2727, 
           3477, 2742, 3492, 2757, 5637, 3507, 2772, 3522, 2787, 3537, 2802, 
           5646, 3552, 2817, 3567, 2832, 3582, 2847, 5654, 3597, 2862, 3612, 
           2877, 3627, 2892, 3642, 2907, 3657, 2922, 3672, 2937, 3687, 5515, 
           2952, 3702, 2967, 3717, 2982, 3732, 5523, 2997, 3747, 3012, 3762, 
           3027, 3777, 5532, 3042, 3792, 3057, 3807, 3072, 3822, 5542, 3087, 
           3837, 3102, 3852, 3117, 3867, 5553, 3132, 3882, 3147, 3897, 3162, 
           3912, 5565, 3177, 3927, 3192, 3942, 3207, 3957, 5578, 3222, 3972, 
           3237, 3987, 3252, 4002, 3267}], 
          Line3DBox[{2541, 3283, 2542, 3298, 2563, 3313, 2578, 5592, 3328, 
           2593, 3343, 2608, 3358, 2623, 5605, 3373, 2638, 3388, 2653, 3403, 
           2668, 5617, 3418, 2683, 3433, 2698, 3448, 2713, 5628, 3463, 2728, 
           3478, 2743, 3493, 2758, 5638, 3508, 2773, 3523, 2788, 3538, 2803, 
           5647, 3553, 2818, 3568, 2833, 3583, 2848, 5655, 3598, 2863, 3613, 
           2878, 3628, 2893, 5662, 3643, 2908, 3658, 2923, 3673, 2938, 3688, 
           2953, 3703, 2968, 3718, 2983, 3733, 5524, 2998, 3748, 3013, 3763, 
           3028, 3778, 5533, 3043, 3793, 3058, 3808, 3073, 3823, 5543, 3088, 
           3838, 3103, 3853, 3118, 3868, 5554, 3133, 3883, 3148, 3898, 3163, 
           3913, 5566, 3178, 3928, 3193, 3943, 3208, 3958, 5579, 3223, 3973, 
           3238, 3988, 3253, 4003, 3268}], 
          Line3DBox[{2543, 3284, 2544, 3299, 2564, 3314, 2579, 5593, 3329, 
           2594, 3344, 2609, 3359, 2624, 5606, 3374, 2639, 3389, 2654, 3404, 
           2669, 5618, 3419, 2684, 3434, 2699, 3449, 2714, 5629, 3464, 2729, 
           3479, 2744, 3494, 2759, 5639, 3509, 2774, 3524, 2789, 3539, 2804, 
           5648, 3554, 2819, 3569, 2834, 3584, 2849, 5656, 3599, 2864, 3614, 
           2879, 3629, 2894, 5663, 3644, 2909, 3659, 2924, 3674, 2939, 5669, 
           3689, 2954, 3704, 2969, 3719, 2984, 3734, 2999, 3749, 3014, 3764, 
           3029, 3779, 5534, 3044, 3794, 3059, 3809, 3074, 3824, 5544, 3089, 
           3839, 3104, 3854, 3119, 3869, 5555, 3134, 3884, 3149, 3899, 3164, 
           3914, 5567, 3179, 3929, 3194, 3944, 3209, 3959, 5580, 3224, 3974, 
           3239, 3989, 3254, 4004, 3269}], 
          Line3DBox[{2545, 3285, 2546, 3300, 2565, 3315, 2580, 5594, 3330, 
           2595, 3345, 2610, 3360, 2625, 5607, 3375, 2640, 3390, 2655, 3405, 
           2670, 5619, 3420, 2685, 3435, 2700, 3450, 2715, 5630, 3465, 2730, 
           3480, 2745, 3495, 2760, 5640, 3510, 2775, 3525, 2790, 3540, 2805, 
           5649, 3555, 2820, 3570, 2835, 3585, 2850, 5657, 3600, 2865, 3615, 
           2880, 3630, 2895, 5664, 3645, 2910, 3660, 2925, 3675, 2940, 5670, 
           3690, 2955, 3705, 2970, 3720, 2985, 5675, 3735, 3000, 3750, 3015, 
           3765, 3030, 3780, 3045, 3795, 3060, 3810, 3075, 3825, 5545, 3090, 
           3840, 3105, 3855, 3120, 3870, 5556, 3135, 3885, 3150, 3900, 3165, 
           3915, 5568, 3180, 3930, 3195, 3945, 3210, 3960, 5581, 3225, 3975, 
           3240, 3990, 3255, 4005, 3270}], 
          Line3DBox[{2547, 3286, 2548, 3301, 2566, 3316, 2581, 5595, 3331, 
           2596, 3346, 2611, 3361, 2626, 5608, 3376, 2641, 3391, 2656, 3406, 
           2671, 5620, 3421, 2686, 3436, 2701, 3451, 2716, 5631, 3466, 2731, 
           3481, 2746, 3496, 2761, 5641, 3511, 2776, 3526, 2791, 3541, 2806, 
           5650, 3556, 2821, 3571, 2836, 3586, 2851, 5658, 3601, 2866, 3616, 
           2881, 3631, 2896, 5665, 3646, 2911, 3661, 2926, 3676, 2941, 5671, 
           3691, 2956, 3706, 2971, 3721, 2986, 5676, 3736, 3001, 3751, 3016, 
           3766, 3031, 5680, 3781, 3046, 3796, 3061, 3811, 3076, 3826, 3091, 
           3841, 3106, 3856, 3121, 3871, 5557, 3136, 3886, 3151, 3901, 3166, 
           3916, 5569, 3181, 3931, 3196, 3946, 3211, 3961, 5582, 3226, 3976, 
           3241, 3991, 3256, 4006, 3271}], 
          Line3DBox[{2549, 3287, 2550, 3302, 2567, 3317, 2582, 5596, 3332, 
           2597, 3347, 2612, 3362, 2627, 5609, 3377, 2642, 3392, 2657, 3407, 
           2672, 5621, 3422, 2687, 3437, 2702, 3452, 2717, 5632, 3467, 2732, 
           3482, 2747, 3497, 2762, 5642, 3512, 2777, 3527, 2792, 3542, 2807, 
           5651, 3557, 2822, 3572, 2837, 3587, 2852, 5659, 3602, 2867, 3617, 
           2882, 3632, 2897, 5666, 3647, 2912, 3662, 2927, 3677, 2942, 5672, 
           3692, 2957, 3707, 2972, 3722, 2987, 5677, 3737, 3002, 3752, 3017, 
           3767, 3032, 5681, 3782, 3047, 3797, 3062, 3812, 3077, 5684, 3827, 
           3092, 3842, 3107, 3857, 3122, 3872, 3137, 3887, 3152, 3902, 3167, 
           3917, 5570, 3182, 3932, 3197, 3947, 3212, 3962, 5583, 3227, 3977, 
           3242, 3992, 3257, 4007, 3272}], 
          Line3DBox[{2551, 3288, 2552, 3303, 2568, 3318, 2583, 5597, 3333, 
           2598, 3348, 2613, 3363, 2628, 5610, 3378, 2643, 3393, 2658, 3408, 
           2673, 5622, 3423, 2688, 3438, 2703, 3453, 2718, 5633, 3468, 2733, 
           3483, 2748, 3498, 2763, 5643, 3513, 2778, 3528, 2793, 3543, 2808, 
           5652, 3558, 2823, 3573, 2838, 3588, 2853, 5660, 3603, 2868, 3618, 
           2883, 3633, 2898, 5667, 3648, 2913, 3663, 2928, 3678, 2943, 5673, 
           3693, 2958, 3708, 2973, 3723, 2988, 5678, 3738, 3003, 3753, 3018, 
           3768, 3033, 5682, 3783, 3048, 3798, 3063, 3813, 3078, 5685, 3828, 
           3093, 3843, 3108, 3858, 3123, 5687, 3873, 3138, 3888, 3153, 3903, 
           3168, 3918, 3183, 3933, 3198, 3948, 3213, 3963, 5584, 3228, 3978, 
           3243, 3993, 3258, 4008, 3273}], 
          Line3DBox[{2553, 3289, 2554, 3304, 2569, 3319, 2584, 5598, 3334, 
           2599, 3349, 2614, 3364, 2629, 5611, 3379, 2644, 3394, 2659, 3409, 
           2674, 5623, 3424, 2689, 3439, 2704, 3454, 2719, 5634, 3469, 2734, 
           3484, 2749, 3499, 2764, 5644, 3514, 2779, 3529, 2794, 3544, 2809, 
           5653, 3559, 2824, 3574, 2839, 3589, 2854, 5661, 3604, 2869, 3619, 
           2884, 3634, 2899, 5668, 3649, 2914, 3664, 2929, 3679, 2944, 5674, 
           3694, 2959, 3709, 2974, 3724, 2989, 5679, 3739, 3004, 3754, 3019, 
           3769, 3034, 5683, 3784, 3049, 3799, 3064, 3814, 3079, 5686, 3829, 
           3094, 3844, 3109, 3859, 3124, 5688, 3874, 3139, 3889, 3154, 3904, 
           3169, 5689, 3919, 3184, 3934, 3199, 3949, 3214, 3964, 3229, 3979, 
           3244, 3994, 3259, 4009, 3274}]}, {}, {}}},
       VertexNormals->CompressedData["
1:eJw8nHdcT+/7x9ulpS3tvffWOHdDaWpvIpGGlQiZKYqK+CiiyCYJ0cS5U6hE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        "]],
      Axes->True,
      AxesLabel->{
        FormBox["\"Sells\"", TraditionalForm], 
        FormBox["\"Buys\"", TraditionalForm], None},
      BaseStyle->{FontFamily -> "Times", FontSize -> 12},
      BoxRatios->{1, 1, 0.4},
      DisplayFunction:>Identity,
      Method->{"RotationControl" -> "Globe"},
      PlotRange->{All, All, All},
      PlotRangePadding->{Automatic, Automatic, Automatic},
      Ticks->None,
      ViewPoint->{2, 1.8, 0.8}], {576., -189.}, ImageScaled[{0.5, 0.5}], {360., 360.},
     
     ContentSelectable->True]}, {}},
  ContentSelectable->True,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.389622274722*^9, 3.3896223041689997`*^9}, 
   3.3896223421070004`*^9, 3.3896225325880003`*^9, 3.3899915127366*^9},
 CellLabel->"Out[254]="]
}, Open  ]],

Cell[CellGroupData[{

Cell["Supplementary results", "Subsubsection"],

Cell[TextData[{
 "The \"base\" density here is a bivariate normal centered at ten buys and \
ten sells. The stretching of the density along the ",
 Cell[BoxData[
  FormBox["B", TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]]],
 " axes reflects the higher arrival rates on information days. The canyon \
between the two lobes occurs because if an information event occurs, good and \
bad news are mutually exclusive. The density above is representative. Changes \
in the parameter values can dramatically distort the picture, as the \
following examples show."
}], "Text",
 CellChangeTimes->{{3.389622704992*^9, 3.389622705856*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"\[Mu]_", ",", "\[Alpha]_", ",", "\[Epsilon]_"}], "]"}], ":=", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"Log", "[", "fMixApprox", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"gg", "[", 
    RowBox[{"\[Mu]_", ",", "\[Alpha]_", ",", "\[Epsilon]_"}], "]"}], ":=", 
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{"g", "[", 
      RowBox[{"\[Mu]", ",", "\[Alpha]", ",", "\[Epsilon]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"S", ",", "0", ",", "50"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"B", ",", "0", ",", "50"}], "}"}], ",", 
     RowBox[{"Contours", "\[Rule]", "30"}], ",", 
     RowBox[{"DisplayFunction", "\[Rule]", "Identity"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"\"\<\[Mu]=\>\"", "<>", 
       RowBox[{"ToString", "[", "\[Mu]", "]"}], "<>", "\"\< \[Alpha]=\>\"", "<>",
        
       RowBox[{"ToString", "[", 
        RowBox[{"NumberForm", "[", 
         RowBox[{"\[Alpha]", ",", 
          RowBox[{"{", 
           RowBox[{"3", ",", "2"}], "}"}]}], "]"}], "]"}], "<>", 
       "\"\< \[Epsilon]=\>\"", "<>", 
       RowBox[{"ToString", "[", "\[Epsilon]", "]"}], "<>", "\"\< PIN=\>\"", "<>",
        
       RowBox[{"ToString", "[", 
        RowBox[{"NumberForm", "[", 
         RowBox[{
          FractionBox[
           RowBox[{"\[Alpha]", " ", "\[Mu]"}], 
           RowBox[{
            RowBox[{"\[Alpha]", " ", "\[Mu]"}], "+", 
            RowBox[{"2", " ", "\[Epsilon]"}]}]], ",", 
          RowBox[{"{", 
           RowBox[{"3", ",", "2"}], "}"}]}], "]"}], "]"}]}]}], ",", 
     RowBox[{"BaseStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
        RowBox[{"FontSize", "\[Rule]", "12"}]}], "}"}]}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.389622631927*^9, 3.389622653505*^9}},
 CellLabel->"In[255]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"GraphicsGrid", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"gg", "[", 
        RowBox[{"10", ",", "0.1`", ",", "10"}], "]"}], ",", 
       RowBox[{"gg", "[", 
        RowBox[{"10", ",", "0.2`", ",", "10"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"gg", "[", 
        RowBox[{"10", ",", "0.5`", ",", "10"}], "]"}], ",", 
       RowBox[{"gg", "[", 
        RowBox[{"10", ",", "0.99`", ",", "10"}], "]"}]}], "}"}]}], "}"}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[257]:="],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyMfXVglMfzd3ApFiCBQIDgFkIS4jqXy0VwghWnuBanWNHg7g7F3aV4cbeW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        "], {{{}, {}, {}, {}, {}, {}, {}, 
          {RGBColor[
           0.38706038036848905`, 0.22022668739102078`, 0.6610405050504429], 
           EdgeForm[None], 
           GraphicsGroupBox[
            PolygonBox[{{6399, 6398, 3564, 3565}, {6378, 3827, 3513, 3526}, {
             6388, 4404, 3525, 3550}, {6395, 6390, 3553, 3558}, {6387, 6386, 
             3548, 3549}, {6389, 4347, 3523, 3552}, {5283, 6384, 3544, 
             3547}, {6377, 4530, 3528, 3521}, {5280, 6371, 3511, 3542}, {4666,
              6370, 3510, 3530}, {6390, 6378, 3526, 3553}, {4530, 6373, 3514, 
             3528}, {6398, 3963, 3518, 3564}, {6385, 6392, 3555, 3545}, {5281,
              5280, 3542, 3543}, {6381, 4251, 3522, 3536}, {5120, 6383, 3539, 
             3540}, {6382, 6393, 3556, 3538}, {5965, 6395, 3558, 3560}, {6392,
              6391, 3554, 3555}, {5091, 6381, 3536, 3537}, {5596, 6377, 3521, 
             3551}, {6394, 4563, 3529, 3557}, {5282, 5283, 3547, 3546}, {6346,
              3949, 3516, 3566}, {4962, 6387, 3549, 3533}, {6384, 3950, 3517, 
             3544}, {6397, 5281, 3543, 3562}, {4961, 4962, 3533, 3532}, {4756,
              6374, 3515, 3531}, {6393, 6394, 3557, 3556}, {6379, 6380, 3535, 
             3534}, {4521, 4961, 3532, 3527}, {3950, 6385, 3545, 3517}, {6391,
              6346, 3566, 3554}, {4404, 6376, 3520, 3525}, {6373, 4756, 3531, 
             3514}, {4347, 4348, 3524, 3523}, {4251, 6389, 3552, 3522}, {6369,
              6388, 3550, 3509}, {6386, 5596, 3551, 3548}, {4348, 6375, 3519, 
             3524}, {6050, 6399, 3565, 3563}, {6374, 5282, 3546, 3515}, {6370,
              5091, 3537, 3510}, {6371, 4666, 3530, 3511}, {6396, 6397, 3562, 
             3561}, {6372, 5120, 3540, 3512}, {5964, 5965, 3560, 3559}, {5220,
              5964, 3559, 3541}, {3949, 6396, 3561, 3516}, {3963, 6382, 3538, 
             3518}, {6375, 6050, 3563, 3519}, {4563, 6372, 3512, 3529}, {6383,
              5220, 3541, 3539}, {6376, 4521, 3527, 3520}, {6380, 6369, 3509, 
             3535}},
             VertexColors->None]]}, 
          {RGBColor[
           0.41825908458067645`, 0.2744728083378958, 0.7048940580218185], 
           EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVE1IlFEUvZqjjmPfzDc/+Ba1aFebIHTMaRlURDMEURDtMgj6UVcR6cIW
RVBQbaKBqSjbhbTQNlEraVGYtGhVtLFyoaQUjlbqWOdw7uLx/s4799xz7/ft
6B86NthsZmcwtmDsaTF7mDD7gHU1a3YzY1bE2d9gtoTxHuA+3Fdw9grrW7h/
AFwv9jew/pQTx51Os2ir2VuQlvHuCMZCSnzLBXHebjN7Ca4Z8MxjfRXrU816
8xrzZJPZRZw/SojzWmx2PRZurkNviO8D796UtM0jzhfw70uarSPWCvYNvB2H
xjXsO4EppXQ2ZdLBfJgLtZBjGuNeTvkw7kfEXAu6pzfkpj/DabNDsfCzuP+B
0e3evGs3u4I8zkPLhYL29KTovu1uVx7MnTNz4Xp/ZDYaif8yztKt8A9vzibF
Qe6d0PUccWvgf4b5KLRWE8IRz7jMr+w5HoyllTpHMG96HWc8Z55/BsdUJL/p
JT3lW+K4n3afS37eA8665/sb85+guh1vlUf0rQU67+akh3p3ZaR5DtiJWDjL
m30P6oVVzOtBNd3APJCWV6w/ecm5EIQjph6prqwp8x7vkD9vcH4/q/7h2Tb3
jX5QC/W/QNzJvOpQ9H4l/lxBuol7jPsneb0fhJafQX25jLkfeTUQcwX4VYwT
SfU3e4l89GbW/TkJLd2x1hsZ9SXrQ47TzvMP2LEueTzQJj5+U7yr+vf4FFrG
MLZ7L9FvauZ3xj29+ga+r0G9U8vKC2Kom3xcVxCn3KVviHrZW/SHvbyZU61Z
z19e00vgOBDLN+LoB2PVkMdikK/UTH7GoT7WjOsSfDucVQ70shH0nmfsXZ4T
y/fE1wv6p/R6L1e8Zvz3sHfZj/8BdOO07Q==
              "],
              VertexColors->None], 
             PolygonBox[{{6049, 4422, 715, 2871}, {4421, 6049, 2871, 194}, {
              3779, 5621, 2389, 1901}, {5008, 3701, 194, 889}, {6386, 6387, 
              1789, 207}, {6346, 6391, 968, 3342}, {5081, 5082, 1900, 1073}, {
              6385, 3950, 700, 968}, {6381, 5091, 1911, 1100}, {4759, 4760, 
              1077, 435}, {6375, 4348, 1277, 2873}, {4764, 4763, 435, 1078}, {
              5622, 5620, 1078, 2389}, {6376, 4404, 1331, 1570}, {6389, 4251, 
              1100, 1277}, {4531, 3779, 1901, 1438}, {6394, 6393, 716, 
              1465}, {4137, 4696, 1331, 923}, {6397, 6396, 699, 2076}, {6050, 
              6375, 2873, 2872}, {5964, 5220, 2025, 2789}, {6374, 4756, 1620, 
              1438}, {6370, 4666, 1551, 1911}, {4756, 6373, 1437, 1620}, {
              3949, 6346, 3342, 699}, {4961, 4521, 1432, 1789}, {6372, 4563, 
              1465, 1934}, {5299, 4484, 1408, 2094}, {5282, 6374, 1438, 
              2077}, {6219, 3777, 1336, 3050}, {6384, 5283, 2077, 700}, {5119,
               5300, 2094, 717}, {5638, 5482, 2249, 2406}, {5483, 5481, 889, 
              2249}, {4403, 4694, 1570, 1331}, {6383, 5120, 1934, 717}, {5220,
               6383, 717, 2025}, {6380, 6379, 923, 1331}, {4485, 4425, 602, 
              1408}, {4530, 6377, 2362, 1437}, {6371, 5280, 2076, 2732}, {
              4425, 3828, 524, 602}, {3777, 5638, 2406, 1336}, {6395, 5965, 
              2789, 602}, {4694, 3897, 1432, 1570}, {5118, 5119, 717, 715}, {
              3778, 4531, 1438, 1900}, {5619, 6220, 3050, 1077}, {4521, 6376, 
              1570, 1432}, {4943, 3650, 207, 1432}, {3827, 6378, 602, 524}, {
              4666, 6371, 2732, 1551}, {3711, 5013, 1073, 207}, {5596, 6386, 
              207, 2362}, {6398, 6399, 2872, 716}},
              VertexColors->None]}]}, 
          {RGBColor[
           0.44945778879286385`, 0.3287189292847708, 0.7487476109931941], 
           EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VEtrU2EQndbkphG55t48rEIXgvgAV71dKO4EJalCoE1j3IhN0aK3pJt2
7UZBQcGF1VYFce0DtVWKu7SFlv4DC+5da3RVH+dwxsXwfXe+mTNnzkxyuD07
1uk3syuwPbBvObNq1uwynCdx7wVmG3hYLJj1V8zaebOzoVm9qLfNyGwd1kXu
Any3QuUdjc3eISfN4B2+ZcR86DO7hJwpYIzAP5kXHnPHcL5F3feIqSH2DmwU
3x/LZp9gId6vBfIRc9XzmZvux71k9hmcdxB7D3WH8f4GGBPgsZQVNmsk8B8H
v+0B9biC+Lsef3HQ7EdZceeR+/KAtBgB/7lQtch90vnPoO4jr0tO5Pa1T1ij
GfXbRd6FQfVFDozlnbjkQQ670O037D6+W+ix6fiv9kovYvXA6xesgberqPui
JLxpYF+HBfvE91wkbGI0HId80pzmyD42fV43gJfCtgZUg/HkXM9rhozn3NZC
+WtZcWSPryPpS22Zz77YyzxiHxbV201gBxX128AcToE3l+1IoDzeE58l+TTh
7+T0/bOsvWFd7hnnTz4d14gxx4DXLaouZ8jZs9ch6LAdSr/djPYm9ZlQT2rC
uXFvyPs0zmYsPks4n8aKW8T5JBavKs6DqHEI9xXk/kXdB+DyDP7nsThxp7Z8
r/j+x2PG88JIXGPyIIeJQDP8r0HLue0g70tRM+MujvvekivxqSd15W7xzho1
3z3+5oYq6pf5w76H3xFbjRTXC/Ub475yb6gR45uua+K5ddd8Cv22S/pv4O6v
Ov8NcDxTUMxjaLAQq6cWzhMFzfk26iyXxI0aJ5F0/gdLSZf4
              "],
              VertexColors->None], 
             PolygonBox[{{3962, 4422, 1352, 1464}, {4346, 4780, 1637, 1276}, {
              5483, 5482, 433, 2248}, {4137, 4526, 1433, 1572}, {5633, 4248, 
              2402, 2401}, {4693, 4692, 622, 1433}, {5057, 5219, 2024, 601}, {
              5618, 5917, 2731, 1098}, {4695, 4524, 1433, 1571}, {4562, 3826, 
              1353, 1464}, {5218, 3825, 1352, 2024}, {5299, 5300, 1933, 
              477}, {5217, 3879, 601, 698}, {5619, 4234, 2387, 2386}, {4764, 
              4235, 2390, 1624}, {5622, 5621, 434, 2388}, {3778, 5082, 1899, 
              434}, {5081, 4231, 2383, 1899}, {4235, 5620, 2388, 2390}, {5634,
               3636, 193, 2402}, {4485, 4484, 477, 1354}, {6246, 3637, 1276, 
              3078}, {4942, 5557, 2318, 1780}, {5661, 6247, 3078, 1131}, {
              5117, 4645, 477, 1932}, {4645, 4646, 1131, 477}, {4780, 3828, 
              1354, 1637}, {4155, 5556, 1074, 964}, {4759, 3780, 1902, 
              1622}, {4526, 4136, 1571, 1433}, {4548, 4758, 1621, 1075}, {
              4757, 3936, 1454, 1621}, {5558, 5060, 964, 2318}, {3825, 4562, 
              1464, 1352}, {4423, 3962, 1464, 1353}, {3896, 4680, 1562, 
              622}, {4100, 5481, 2248, 2250}, {4547, 4548, 1075, 193}, {4403, 
              4696, 1572, 622}, {5118, 4423, 1353, 1933}, {4249, 5633, 2401, 
              2403}, {4233, 5618, 1098, 1074}, {4231, 5013, 1836, 2383}, {
              3780, 4763, 1624, 1902}, {4762, 4249, 2403, 1623}, {3711, 3650, 
              1780, 1836}, {4681, 3897, 622, 1562}, {5008, 4100, 2250, 
              1832}, {4421, 3701, 1832, 1352}, {5279, 3948, 698, 1454}, {4424,
               5116, 1932, 1353}, {4234, 4760, 1622, 2387}, {3786, 4761, 1623,
               2731}, {6219, 6220, 2386, 433}},
              VertexColors->None], 
             PolygonBox[{{4523, 4942, 1780, 4943, 4522}, {4121, 4523, 4522, 
              4681, 1562}},
              VertexColors->None]}]}, 
          {RGBColor[
           0.4806564930050512, 0.3829650502316458, 0.7926011639645697], 
           EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVD1Mk1EUvaU/X0uxfN/rVwQMxiLI7k+CcWNQGhKDBkJMjEgVSIjR1U03
44AbauvgZGJCsVEBR6NFMY6uLm6Mhm4gGs/Jecbh5b13v3vPPffc+75y9c7l
2x1mtoCVxBrrNbsbmv3Im63EZns9ZlHW7FNk9hlrLW02FZjlYcsjsIWgLpzX
cG7gWzOt8zJiH8X6NuzMfhfNEhmzWezXsQ4y8iNeA/t75NlG7l8psxuI+1BU
nlvdZs9xPwKcjZLZRdiXkbMZKHcnYi/lzEaxviTEm+dnOO8i9i1y34TfOPZR
3J8g3xbqaEXiOwLbHPB3gLdbMKvGqmsM/psF4byA71XkrSWFfdbnYq0jnkeY
lU71hHKUM/LnuS8jzgOHzdol8Z0C/rSTXwP4Mzh/h/7nsV9wimkj/7dIfE5i
Hw6FuRdKL2q1CM0GcL4HzENYM4E4t1HX0Ui1TwfSktwmvR99msAZRK4l4Jzy
seTZ8D1kX+7n1DfivIE2raLwyIW6kE9XTn2mDqzvYagaqc1+SvZV+PaFwt8n
d6wHnZgF8FxxynUa9Xb0KOYa8ryMpB81YG+ow5VAM0N+1Ii8icl5pB7/ZpIY
nI0U8NJY8znNDnnQfwLfXwXyYT95Z0+fgmMC/hXcHzvNCvWo4fy1IJ8ydBiM
/8dXfOw28N8VxJHzSV3IhfjzPge1pN7Uc7ZXWMQZwn48VhzfwapTPRvAex2r
d1vA3yypT5zDSd/HA9jHI+HyG3Wl/QxiF4C1jrk64fQOmZ89/Oj7yFproWrg
W+HckBttdSf7hNeSNSbhXw9l48xxPuh/DL4/EfsnrbfA98qesoYl3xf2pOKx
+rPyY13rqOlcqLnkm6Jm7K/zPg3/n3D+zFne8fNc7dZ/im+Ptn6P+Rdwx58P

              "],
              VertexColors->None], 
             PolygonBox[{{3947, 5268, 2064, 2074}, {4679, 4212, 2355, 1561}, {
              4762, 4761, 456, 1097}, {5152, 5156, 1967, 522}, {5595, 4217, 
              2361, 2360}, {4547, 4551, 1455, 1452}, {3767, 4549, 1453, 
              1881}, {5594, 4232, 2384, 2360}, {3717, 4402, 921, 219}, {5634, 
              4248, 1097, 1274}, {4216, 5595, 2360, 3040}, {4121, 4680, 1431, 
              909}, {5062, 5063, 1881, 685}, {5058, 5056, 1876, 1877}, {5061, 
              5882, 2695, 1879}, {3786, 5917, 2385, 456}, {5155, 5555, 2316, 
              1967}, {4551, 3700, 1831, 1455}, {3695, 4640, 1534, 180}, {5057,
               3879, 2023, 1876}, {5279, 3936, 684, 2075}, {5883, 4674, 411, 
              2695}, {4960, 3717, 219, 1788}, {4250, 6239, 1966, 1099}, {6246,
               6247, 2431, 180}, {5268, 3948, 2075, 2064}, {4693, 4525, 921, 
              1569}, {3896, 4692, 1569, 1431}, {5154, 5152, 522, 1966}, {4382,
               5660, 2431, 868}, {5555, 5261, 2060, 2316}, {5558, 5557, 909, 
              1879}, {5267, 3938, 2065, 2064}, {5262, 5062, 685, 2060}, {5881,
               3765, 410, 2065}, {5217, 3947, 2074, 2023}, {4550, 3939, 2066, 
              1453}, {3766, 6210, 3040, 411}, {5117, 5116, 1130, 1537}, {4779,
               4271, 1130, 1275}, {4272, 4646, 1537, 2432}, {5218, 5219, 1876,
               523}, {4642, 4081, 868, 1130}, {4232, 5556, 2317, 2384}, {4155,
               5060, 1879, 2317}, {3939, 5267, 2064, 2066}, {4525, 4524, 219, 
              921}, {5297, 5298, 1877, 410}, {4212, 5061, 1879, 2355}, {3700, 
              3636, 1274, 1831}, {5637, 5635, 1099, 2405}, {4424, 3826, 523, 
              1130}, {4233, 5594, 2360, 2385}, {4217, 5636, 2405, 2361}, {
              4757, 4758, 1452, 684}, {5661, 4272, 2432, 2431}, {4520, 4678, 
              1561, 1431}, {3935, 4345, 1275, 2059}, {5660, 3695, 180, 
              2431}, {4956, 4958, 1431, 921}, {5056, 3935, 2059, 1876}},
              VertexColors->None]}]}, 
          {RGBColor[
           0.5118551972172386, 0.4372111711785208, 0.8364547169359453], 
           EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVE1IVFEY/fx744z25s3PG2dhaToUBS0K2pq6qCTaKERIpOnspIR+rDYu
giKN/ndSmyiIRkfSfrYmaCAR1KIfEoLQZWWbSC3snDl3cXnv3Xfuueec77t3
a99g56lyM7uEUYHxKDTbnTDbU2VWwOjDZAGAO2mz+jqzV3h/7putZsyuxMxu
Yv5E3KyI+V94NiXNNrCuWGt2sNLsdRm4wHfZF+f5rNkM1u6LCTMRMQuBa8P8
J+z9tcZsBTzZlFk/9m4E3yDWNmBtDns1prWG3H619l0D3xzwSczdwv/baf3L
4PsIsAk8C3hOAnsPeiqAr8LIR80OQ8NJz2zaxN3k+BfK5Z/eK4G9GIjvLv73
x8U1C1+doXAz2H82JfwqsD1xvQ94yoP8D4Fvg5e3Jn87ncdR7Dcc1Z774fdx
Qpi/NfJBr2lP/jjfG9U/zm/DXg+gYQw8U1i7EGhP5tsSU/1aNmlNqR7Ycx7j
KPY8A2xrVvn8gN6hrPDPwPMmUC7kYUbU/wX7XHA5HPJUt/vIcwT4c4HmesAx
hvd/0JfH95Jbm4OPxZjqkAO+GcM8ZTmfUJ7MnT3BnjFkvhFKN2uY8aTzOLQf
w1j35It46vgOnt8p6Wf2M64WzDbA/8UyeVmuVS714N+SUF91eOJnvtS77DST
m3swt5KfqPy2QnsYqCY8E99SOhd/8HyH+o5EVOdhV2viOhz/1ZhyIk+pNjHp
ZP+eDYTh/ktOJ89Nb0pnh/P0QG2d0NCF0eiphqcD5fMe+CdJ+e2OqFacbwfm
ha8sPyLXIeD3RlW3z6E0sY+2B+qlzcimK1Q+7JWiOzsN6P8d8Dweke/BuLxz
sMbETIKjkFT9++I6M6xvHeY/hMqa54n9RH30fSAp79eBnQ7VAzw3eXc26YXZ
MTf25YCbZ23JTb/r0LOGcQ3YdvCtZ7TXFDifYuyq1l3C2tPXOOZ++tJddB5K
+svVp+TkWbmRVgbUwB6gZmbX7e4W9ij7JHT3zLhbS15+k5M6R929suIrR+Ko
ddTh2Te8S4ihVq7hO88NsQV3T4w4HvY7zy37iD1KD8yN+TWn9U4e3tPkyjvN
zJBaJ9w771x6CB0HvXLtHHrgpS/9/wHgIs+b
              "],
              VertexColors->None], PolygonBox[CompressedData["
1:eJwtkztoU2EUx49pHo1KcnOT3GZRm7YiDg4WXNUWVERcIogItjV281FQaJ06
Fh/4BJegm4KY2mJ9jWpFI1UEHXyA4OIqrU6mUerv8M9w4Hz3O+f/ON+55epY
5VTMzAaIOLFSNBsqmf1dYzaSNnuSMRsMzaKk2cGUWS/5upzZhgTFfHsemdWo
37/WbMdq+jifp2Yfd+c4l8nfBmYnOK/QM0P+J08NWJPg/86aPQx173hf4Z+g
phgXxmu4XhE3V5nNIrSH2lnuR9t4I2ANE7UOs37Oe7jfTbwHLgSjhZ7lSLl7
+ICfefDqCWn4Ap9F8vodzzcKZtWsuAJ6Fsm7Q/k9BkcDr8+o3463H3i+TP0l
ooG+Qyl57QvlxT19Av8M33Jtfvc2UBKXe9zVZbaEpml6v4F5j94Wfi76Gcwx
+KfB7+s0e4GmXs+J+ylxbgLvTlHefQZPwWrkpcVndhevQ5xbSc3EtTfpqcfk
4U1eb+ZvdZie09x9Bm9bWppfcj8H3xb4F+hpRpqRz2aKnkn4dqK50MbfjJ+P
GWl3T75LV6nPdGqnrpFfIWZi+vaA/HFGWM4xTv1ESbtUxc98Xhqc2zVPwdUV
aJZ7icWMZuiz8xkdofZ2Tlrc8zLnJnEhpZkewNtSVm/pb7qV2gqY3UnNsBiI
w7HdUxl9w+j5h/ZbeErgP05E+B9Na/cfUX8yqX/AuXzHfbedcyN5f07YzvGO
8xz1x5Pq8d3/ldUu+76MB3oTfwt/g3qonfNd851fCPRPeb1jnOU8WNK/6ZqO
gnW9oF3xGfcU5MG1+85U8P8zq9n6P1CjvyOSF/e4Pqd/0vfX5/Mf4C6RVQ==

              "],
              VertexColors->None], 
             PolygonBox[{{4691, 4518, 4517, 4133, 1568}, {4518, 4957, 1787, 
              4956, 4517}},
              VertexColors->None]}]}, 
          {RGBColor[
           0.543053901429426, 0.4914572921253958, 0.8803082699073209], 
           EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVV1ojmEYvvHt2/fx/b7v3s+7JAkhK2FxNpS1fEtpO8ABte3AdoCyfMsB
J4qJ2fxECSWbWP62lJwJLfk5mGb+orXvSIallJ/5uS7XIwdPz/Pez/1z3dd9
3887u3FH3fbJZnYGawrWQGj2BquYMDtQarYnbtaAi6sZsxk5fX/1za7huyVi
dgrf5TGzYzhPh2y/Z3YI+osjko3C5wHIktPN8lGz0/B9B346cTdRYtYH+1Gc
P8O2Nqfvg9CfwLkM8vdps1medAtJs11YowmtZtz3w/9H2K6B/gi+fwVm72Bz
HZhaUmZp2PZAp+jiMRb1fuB8BPsi6GxPyQ/zfpJV7rVx4fWhM477auCPg6gP
8F2HGDfgfwD3/djXT1Y+fTFxNQ6d+kB3+bjyuAP/G8vMNmGNlgoHd9rWRIR3
YJI4p+/Xk8Tv1ojOy+PilHyui4t38hsF5vOI9SUm3Vsl0mduxEQ8J8HPz0Bx
7nviixxsRh0vIt+TsNkNzINZ2ZMb8kUfj6A7GzYdOFeDh31Yr4BhJnTneML/
FLKF4OfWVLPhqHgh54aavAiEvRN5H8VKAudtlzPzXefyYG4LgKcDawj2P7D3
wn8Tzl2w2xIq9xGHi3ltgLzcVzzmdyojv+yRxqj4+BdvwHHCvJjLZfi+5Ekv
AewvfGFgnN+BYg374q7G9cueqOy7Q/U0+2OuJ47osxK5vJ1mtgR7P+SPM4qZ
h/5YoF7g/dK4dAqode9UYfMS6h/WjLP1zVf9OU9BRjNVk1MPsW/IC/nmDPTA
93zacA5x34BapnGeF1MM9i17kPHZz/Tb5PhpRe3WhupP5jfhas+aP3R5seaR
UHUfg+97nvivSIiXEee71vmnDfubvdEGu0Ko/IiFtSWeMKq+24bzStxVJXTH
fqz3dMeZoIz8tJdqNtjb5IlnYmgFxuFAnJa5GjAX2jEebck178nhFfCzIy1u
ig7n395GD3xKCRvnqdvNFPurK6ce42y0OwzkN+lmljXge0Q+i+5t4nvCN+yB
L1xzUnqPehw25stY3VnNIfOlbKWzvQv5YEqxGl1s+l8FbvZCXlGiWAX3HlZA
f1FW8iH4e+ar71nnZveOHMf9spT4GUd+nwLNH9+/w77i0hfnh/rViBVmVCvO
xnJXX+4r3LkN9y8DfbNnv7u+vUBZWvUlB4WMeCCWKpfjTU//A/Z8u6e54kyt
DuWXPivdrBBzDrITWdWxyr3/5JAzlHa1OIv6niv7/08qd/PP2WA9iYc8rfbE
1XPg3JlRnDrIlmSl0wEMh0P1OP3QB98E7qw7z/T3Naa5yDuOyAk5bnU8/wEz
uAs/
              "],
              VertexColors->None], PolygonBox[CompressedData["
1:eJwtlE9I1FEQxyfTbbdc1/3trm5USNj/hLAijyUUkiKFQtFRu9ShhMKNDnYs
I00ryVMdSqmkKCWQblJREBUYalYQsZ0qSyk0y6g+w9fDwHtvZr5v5jvf91Y2
NtUdzTGzPVguVpcyexg3e7fA7F7YbDRhNoZV4XxA4E/W09iZRWat2L6k2X7s
SchsL/5/5FuR2baIWZblb2LnsIP4D4PxOWb2NDBrYT+XZzZE7Im0WZBv1oF/
nPxK9hURYTwi9jH2AV/DQrPnhWb3A8WexzaAnU7o/jFsnPUUGLXkbsK/vNjs
IvXF6KVvsVkX2BsLzAaobTt3ThB7Gswa4quxZdQzEdNdLezL4aKXmF/kH8lR
73cK5XMOSsCeAi+C7xD3NeM7S31J1gmsE7xS/L2mGpvAzoKRIXc1mJXEFpFz
jvvK4CNDfd+I6Q+Lk3ruXhEXtwOcdRP7l7O7Yc3Ea28FozqkHq5Sz0hCs1pK
zCew1rEfCSnnGPE7uOP9ErOtxDfg7yAnGhZHufhC2DTrt9S8lvhrKe2dA+d6
KqZavJ9J/FX0mKWfLPXsJrc6LS6HyK+ntrpA3F2mv1GwLsXlKydmEm5uJ8WF
c3gDXy13/Agp/ia5J7lvkHUjZ8NxadC152cp7ycQd87hMHizCWnNNXyKfWWB
8DzGtfcFvD950uAk9Wyh/u6INJMB73VK3PgMe1hfT83PPizujhOzOSIO36Q0
c5+1a3aMffH8PD2mLS3Nu9bLmGeba5Wzj/nS4Av6GWOfierM1y85a47qLF0o
TpyLNPWuL5bmXGuD6DnKPr9YWncNlNDfd3L6I+rxGeuBQG+lHStlvSrQ2jXl
3PTM4ztHNUWaqc/SMbyWW4G495p24m9Pqxd/k87dlaS05hweSOpPcGzXhM+y
LC7uHb8PrFcFqt3/hBn8X2P6a/w9XSC3M6m/wzXpb8XfsL9dfzOuxTXUNxvW
PNoTetP+ll3jXXFpzLXlM6gAe1cg7nyG/rZm5v8vf2P/Ae6ruXU=
              "],
              VertexColors->None]}]}, 
          {RGBColor[
           0.5714906066251039, 0.5398885732266976, 0.9096735877515102], 
           EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVVlsjGEUvXQ67TCd1UwbEoKJkBINDygiQis0SCT2WKNVFM/iTVrx0CaS
tiq2F3ut0dSLeEGIB0vtWh6a2EpNxZImEuIc54qHL9+d+9/v3HvPPd83Izfu
XLJjoJmdxMrBupprdqjArBz78iFmy7C688y2hc1eDjK7NMBsK34fcrs3ajYs
bfYL8WuKYBealQXM9iKmA3snYp4lzZ5iVcNXGjO7DvsGkj3C/illVgl/P+yO
uFkVznyH/S0pjDDwCgqV7yhqmYxcl4HZid9dWPko/jby1iN+NOL7gF+BmAsh
sw1BxGL/HNC3fMQ/hm8cYg+k5WfdVV7n6IjZfvgHDFKevpRyzYe9IC2seWnl
IH4L7DKs87DbwuJoFezawWZ1WAvR47F82eSQvLFeYjJHrcdsgX9CQJyQv+6k
OGxCXw2wM/g+A/sk1PcG9ZfgW3FAOOyRfazH2feo9wPWPNTQGNM8iLMvAS5j
ysH8JX52GnyfU8r7FfYIxGXxrQe+GvwuB/Y72HUx5VsUEjbP96D2MV43a1rk
fmqk0+dCbsqdH9bIvTsgjraH1Tdt8kYt8XdNWJjEoZ/1L8XcsxFpkrO6O1Dz
OlwgrbbnSgutzu9wxE9P6jf77k0J8wLsH0lhcCacDfnfnKf+LgKzBBrMIK4F
/rGI7YG+1+VIs+SLXFFL1BHrYb3bvf5S5HkdFeYTxB8bIuxmxPXnC3MWOJ6I
mE2osxG5nuJMPb6fhf9+XL3Mwf4woh6pM86EvK0E5vG48Fh/reuqw3XM+CBm
HsA6OFj351RI36m9lz6XVvjOuZ/6aXWbd32l3/c18K0NiZNryDsKNS/G2WfA
vud1LoA9v0haYO38Rj857neeqQXm5RypgaxrlbNt8/l+BAcjHf+fvllnDJx0
wd8HzDLYU6LqfV1I9XEuH+GrLxLmceCcSInr39hbYop9QD7jett4ju8Nz7b6
G8Gz1BLnyplS91V56p0cVLvNOde4bheiv9PArMfZmbCvIN/boHol19QDtXnY
39IjbpMfzjaS0LyoUfbMfnnn9iSUn9hFMeFTaxmveRVyrcb6CV8a32cjPhVU
DL+TQ+qaM+z2d4J4rH8XuDqT0P3ZHZRmOjyGOuWbkEUfz5PqsTiiNyjj95z3
nfonH5udE+Ykn8x7J6F5kM9bsG8mlKcCeCuS0n/WdcDayMcR5513YmpC94J5
yCVzzYFvLlZhUPeEvTKG+iU26+e7nvE7yblVem0lUd03xn9BXy+Smg21Rk0v
9reQb9pfnnKFQX+l3wHitPt/Inn7CZyhhf/fMO6c9auo7j/vPt+AdFz2KdcY
6+Rdb4qrjwbwOjctDU5Djc3u/xQVj+SQWv/bd47yU7+sYXxc+qOfb1WFc/sH
SZ4Ygw==
              "],
              VertexColors->None], PolygonBox[CompressedData["
1:eJwtk9lL1XEQxcfUq9fc7va7t4KihSgskHpoT8KbomFBEGlQVpQthD30FL1F
24NSYHojSgglyoykqD+gIugh2hesHoQ2U28rBIHRZzo9DMz3NzNnzsyc3/Tt
+9e3TjCzBiwPm1FmtiFuVpNvto7AWMIsi+0pMLuda5aJmFWSs4NYG+9HvNPY
fd63qHmA/zZldq7E7Cbv07yDcrNEiHze6agwvDbJt6cxsyfYTvBbsBS5q8np
zFfOYvwlUdV6z+P4veDvKza7lmO2jNrl2Duw+qjvAbs6KmzHWAn3Kqy70GyI
AUuJ/ST/GLmD1L/E/018U1gzLiw164io33swFvD+RnxtWD3WBGbf4ZgF62pY
sY9YbVg5X/C/YnvBGgB/Ff0qIuLuO3iMf7BM+2oB4xO5H7CKPGFk6fcwol36
DSYn8Zn3RrE4Zug9Tv5m/GbsEviXo9q1Y44Sqyd/eKLZfDBPwXcSMx7hnVMk
rA7fcZ4wm7h1Y1y7GSpQ7sa4fK/xW97DZhbopt3Ezsc12y6+peE3Na7dvy7S
bU5E1dtv1MksK2Lape+0Hj5zeY8RH4B/P1zqAvnbQtJSdUS38XkOlOomXj+b
HheYL0SPM3DLoI9hdvknoV00864JdHOfp59vi4j38P5VKD2kiWfpeYVYX1ja
eENOQ640Mg3uI7y35urGXeRnAmE556pAnJ3rRb7dIX+U/HGwD4V063n/9e03
PxyVxl3bNcR7E5rBuTsn331tIC0555KkNO7aPss+f8TU03u5Zkeo/ZzQv+n/
TBdcXpCzG38LOa/wi5OqdQ22sav2lGb9NxP5d6Pi6ju4DtbScv3bvuMpzqVc
2vSZWtl9BTYLrEIwjxIbTmgW12x1Uhrw2w9i7fSfE9MtvMa16hydm2u2LSZM
x3JN5cOtMqJ9+E3rUrq539o13Eh+U0y385yhmHp6L9dwQO3JQNr2Gz4n/iwm
bfpO/gJx+rMf
              "],
              VertexColors->None], 
             PolygonBox[{{5775, 3690, 3689, 3619, 2561}, {4955, 3716, 3715, 
              3653, 1786}, {3690, 4624, 1519, 4623, 3689}, {3716, 6149, 2968, 
              6148, 3715}},
              VertexColors->None]}]}, 
          {RGBColor[
           0.5944288733481605, 0.5767439852100458, 0.9101965095819687], 
           EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VFtIVFEU3abOOFPM3Lkz92qlRf70IMqilzVqYFgTgiUESfQTBWE1FhQE
1U8kBFNJr7GgvvJDKSIrgiL6ys9SKuknKAt6otCD3h+txTp9bO6556yz99p7
r7Nnbetqz08ysyKsFDYRmI3DWmNmPz2zq7DtZWYtsAiAQyVme6eYdcE6gGlI
m51PmR3E5abQ7Cv+dwA7ENc58e/g7zNsEP47I2b7YQVgXkbNcsDMx3qi3Kw7
qlg3fGB9Yfch/l/crQPuI76fAt3ZmQDPSrM+k6+WmPyvi2kdx94Y7t71FW8l
1jdxdzLO2qP6kvMA1kWsTwDfAe6bYb8i4nM4plxmZMzWINaBqIy5Ma9j4LAF
+EXAfsM34eteDnW45ulugP0Q9jCieix0NcmjfnGse7E+FNM95n4dNs/x53eO
W7NGXBdL1Ic3EfmhvzrnkxybHc9OcOsBj2nl2htLaz8LjilwS0UUnzwWlMkP
1+RTD8wKWAKY8irlyRzzru/E38JeY5XwrMfvycrvD2p8zpNezkAXp2EF3F2D
7whsLdaeL37kRn97nU/e5z+5LE2anYKv3ci1Py4Mz7+A0/cK7TfhvBF2Cf+z
XV/Z0x7qNy1sG/aiOI8Cv8QXb3JmPhdK5WcrYh3PCNeLmhVhMcQcjahv1Bjz
63ea3gA/G2EzcXYHNZhWqTPWO0wpr7jjw1j3weVeWlwmgK0Hv4uIlcXeqrR6
2QQ/zwLlThzfRtG9NfpmfYhjD9nrOe7dUBtvce99IN2/SKourMlT+D7qCzcV
3KpCaY1vcXFC7+UBMD9CceX9gvP5CJhdnuqaxfkeT3qkRtlD1vO8p363uLfM
OOTMnrSE4kBt8pyc/9eU9aRGpmd0xhlTGcp3NfhXgHNukvRH7bCnzSlpiLGb
cX4F60cmfS33hRtETjcy4sBa8Z0wx1dRpwP899IP8CeBfwyeI4FqSd3lnfZ+
Y+95WjXnXOh084rzaa17p3w/9EEOc4FdHyo36q4vlPbqkopH3Dj1nhGnupTe
FTVILTQ4PXzAt9vTDNsEbG1S3G8npF1qqQb71RnNLdoJN5cLbnawd5xn5Mwz
znFqkblcrlAc1nYVOL7xdIezirOb8+pJWrphLyvxrUXsIfg660nr1OJwoFqz
ziuQy2vnhzwYkzVfBu5tvt4Xe3LT4dnbmqQ48JzvnBjyol6oDfojP/rkDOYb
JLfV8HEkoZq3luqd0U82kG5yLn7BcRgGt4mE+k7sZZc75zv7Qz/0Per8c66w
J+TzD3fQ4iY=
              "],
              VertexColors->None], PolygonBox[CompressedData["
1:eJwtlEtIlGEUhk/qzDgjzPz/jDOaZmEEXYg0F3lJM7AsS6iEoAtuoiBKi6Ag
qDaBEEgFhWNBbcpFbiKlTddVLU2JIuhCSdAVXVRkSYuel+PiwH++95z3O9/7
vd9fve9o15ECM9tOFBGVZWbd5WazJWbDCbOmrNnblNm1YrOrxMfArDlntiJu
dpuGFvBmoqPA8YpSsypiOGYWZa2c2tf0T0fMTtHTTr6RGDLnvBma7c6Y/Y2a
jbHWS15G/pS8s9AsR/6O/uvihmM6abYT/g/wx+CvI2+m/iP1I/RfYJaLxA/y
HvAzwtNm4Ry/9h4k4gmfYQD+RvAk+En2m+L802V+FuF9nPcTfO3MvpnoIf+a
9e8E52+lt5b5zjNbBo4KemfBV4HdYo9zzDoT+KwxOJPUTzBTX8w1kdaXA6+V
5pMZvwNpf4KaCmbNsvYE7tPsmeP7YNJn01oZ+Pyca7ufPe+Dd6d8r230z4Dd
pX5wnlkX+RbyDuIAtS/pH+J7fdK1kWYP6K+m/33M+7eSL2G+38WO16NXQ+h3
30/8BP+V8bOIcwHnrYMzH3cPjKJFS8a1LWFtirwRvgTfncQjsKbAMc23Dj1a
iZq4z6xZvslfcZ/pO9/P6VlZ5GtfyD9n/e51R/KaNJNWmukF2DH4a+PO+QY8
SLuX5K8J8HEiz17LwDeAtaVdD91pIb1j4EvjfoZXOmvWZ9cdh+D50GvlsV0Z
10xaydN7+d5DXKF3dcS9rDclf8nT9WnfQ9z9EedKB+4lce4AvxF6/yLWJvge
D91PmyKupTSUdtJU3moLHZPHalLuUfGJvyHta/qW53vpf5b1s+tN665rQ59V
d65ZLoVeLw7d7R04DkX9jqtS/malpf4BI2CT9ByPeo28/ydwb2rme2n3kLyj
mrXMvrDUva43vDjlHpT39Mbz7Lc8417Vm5UWa1L+tqVJJb1TSf/XtMN5mL0e
z+mhO/vH2QYCx+SBs2l/w3q78tAovQ/n9pMH/gO2jqN/
              "],
              VertexColors->None]}]}, 
          {RGBColor[
           0.6173671400712172, 0.6135993971933941, 0.9107194314124273], 
           EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lUtsVVUUhpfifZx72/s+97YIA3Tio4mpA0qkRQeQ+BpYTdREdOBIRdpo
NFESJ1xIAFESQQJxoIBaqW2ixoliEBMHDBB8JVKjVGOiE6vRCSWa6P/l3wx2
ztpr773Wv/71OGsenb536sqIOK61QuurPGK6ETGSRVzUd1cn4tJVERcGIrZl
lt8qRbyttXBFxPhQxOO6V5Z+TG/P1yPukKF7dD5Sjjgt4xt1lkmelbylGfGk
1lQh4pT210h/SHaqyS420SGjfxCfVdt4omF/+Lq/HfGA1nIx4u5WxBqdrZK8
vqK9sB5TLF8IzwrpB6XfrTgeqRvDTt2fkv72om2DDft1rcmS7b+j7z86OywM
8wM+/1zyQ8JzX8n6XbLfkZ09ives5K0Nx0Fsr8nmndIv1SKu7tjee/J7c9d2
jsnOkcz3Z0o+x+bvuj/cMb+1dIYeLPhGzhX3Stm5S/afl+5AZhl7RzPzBn9H
kgxe3hLfD1Vziu135WdW61phndP++oRnVBie1vpUHD6mb1f+hhXTHt19sWO+
cuVwfW49PtcW7Ouk7m4RD5nsjOt8IjcX5/T9MreP2YJr5Lhy0Re25zLXCbXz
zJDPRhLP5OJn2Xtf3M1LPl8xN8THOTFxh7zfUklvUzzYvFX2Nmj9WHUeZxKv
SwVjh7d+1TL5wgY1Djb8US/EBUfUJTW7SXVTKTpG/MAZdfuw8H/c9tunhPnb
3Pj+6Mlfz35uUt5O62x/5h4BI/cX9LbYNoZh3f2pbV/4P5UwfFd3jxHjhGL6
Onc+D0k+POS6314yv9gdl69fGq61xQH3MPHdppy+qbOe5D/l52zN724sWEc9
/y39X1o7SvbHO3CSq+0J9+uqgb3CsL9g++SAvoP/fsXc8L6f+pp9P72FS3J5
OY87K65t+mNVxz3yW9m2wbO3Y17goqWYDsr3buk/FPaLerOj4pzwJS+fCPsH
NXO8Vrwd1f0DBffWdT3XEPMC3UI4H/QS+Md096OWa3qf4ns5Nxb4aRXtd0Ln
G1re9+Rrq95MYx9eu7b1kt7d0PS7Z5Wfk11zRPzkCD7PCeNMy/y80nRs2Ce+
ZpLBPtkyVubZWMszjRnwfd01DH/MMzgs6PyM9L8WPBuWUp23G55Z8AlH2KDH
X5X+X+k3625IPpObS3pmMvXYG03nm3zghx7CFzXbTnVLb9Fj5G5f03ME+8yb
iUG/4RyZecqXPXr+LRfS3IbHE/JxUHIm25W298sN/5PoT/heXffdzySvy80p
M4+aqqZZThzl5Asc+O20/R9iTg+Kq4GWOSI3i6lHwLKY8JRTrxPL5TMw8A/5
JjcfG9OsIPZR2fuv7nfjkl+ouQao/bk0K8jbUJrhl2RjOTe+1arPlR1zSf0x
g+h9+onZOZf8zKf/0WjXM4X6Xdd07fKOeb85zXxwbEoxUJfbUp3/D5B/AJ0=

              "],
              VertexColors->None], PolygonBox[CompressedData["
1:eJwtlF2I1GUUxk+u48zs6n9n5j//2VHXwPWmDy8UygxdFUHIXEjzoiAN0RtL
3bUwSKGL1CDN0nQVpRs1yVoJNL0xRRO6UMhvwRYU1KCE2lJv3EXBfo/PXBx4
z/uc93w855x3/NKeN7uHRcQSZDjyRTViE9LHZbEQkaYRVaQ7F/F6U8S7rRFb
wH8ZZpvBLGJRPWKoJeLtYsQ48EIl4i72PUitFnGuFNELthY5AnYY+fWZiB8J
2I79dHx8U3CMHmxPE29hPmIi9ivQz4OPGkE+2F9IIs6UiY3temz+AJ9GjH3Y
fosswPd8pJ9aenPG7mCzv2ib42C3S449Bfw3fL+PXkBvJsYb4FNa/fZZ9L+J
N7st4vfmiA5yPA/WXXZtqnEVb6fXHLsFH5M4T0Z2KJ9wLYPonzW7pgOcu7jb
DJdt3D1EP5W6to3onxBvVmLsRfy/RD7HEmPKbyzc9xLzEXx/j7/D6EfAN4BP
JL86/kbXzPW8JmMXqfH5om2qvP0ys2/loN5trrrX6uHnnBdT4w/0doicvsL2
ZfQd2P+FzdHEOSmXBXnXsjUzJn/qvXra3eDnFLnsJkbXSHpB/D11cyRudNdO
vHHIwbxnYmXZHOutfFzC94XM3KqGsyXPlOoTx1fBVnOXgL9GTjOIvw0fm8il
gv4EX59yN4dzARmP7b6y+9uO/grY1+inwzP2AufOit+Koyv4H8o82zdaGr2s
OJZ6+ghsJz4Xgb9TtK/tjfjyqVy2Nvzr7hZ8HaLeCQXvkGapyN2JEZ6pAWZt
ORyP5ryBeD+DnUTm590T7dIo4g/kvFM/JZ4B9V4218hnJhzf5G3rcPdOM61Z
Vg/XY99Vce3akQ787S0bk82rvP+3zbG1783EXsabXeEcD2E/WPJsrCua+866
uVEPpvG+v9VvVUNZ+1Exl6p/C3ha8qwo5kGwB8TYSO799L+v6p3Tromjqdhf
x9/cJu98Ddss9WzLv3Z7atm7rB2fUfeMajbFgXofJc+rZuAeb/vQP9Y+YNNW
c03rGv/TY+J9UDJ36mlnZk5Uj/6o98AuZ/6b9GfI13+p/yL5fA7uLiau5bu8
ucuRw585c9ih3U7da+n6W/5JbKs/RrOpnqgXmtH7qXNWruJoJL6ysmvXDHzI
28kVz7Zm7OnfkHkW9UesgY+P6t49cTgGfgcS/x3aubdSz4RmYRAf/wMBP8ps

              "],
              VertexColors->None]}]}, 
          {RGBColor[
           0.6403054067942738, 0.6504548091767424, 0.9112423532428859], 
           EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVltoXFUU3XnMzJ1nZu6dOxkQkSoJ0tKYKlSlidr0o/lQP/rjExs7ICja
io5WRERtxWYaU1+TTgtiLUhNRS0ioj+tNj8+qhJF2uLExECtUMVH+hE/qq7l
2uDH4ZzZd+991l77cWbFlm2btnaa2SxWF9Z8t9k7abMfsNfzZnM5s/cSZuNl
s91YQWC2Bd/akN+NfbRq9lTR7EzW7NnQbLliloe8BflRnBs4xyWzHL6N4qId
OHdCfzsuOwmd7T3y34eVTpo9CvnT0P2nR+crcb4q1LfnY7MybH8Cho343Q/f
uW5hJJ6DJlkzY/YjzlMZnd/uENb3ccepDsmWctLhfh7rQ2CbBLYOx7Y3I3va
8jvP1HkMuOKKfFHGb/RH3sjZLqxMr1kWax/krYx2+vk5q9/EuBs+JrD+BtfN
tHgaxypD9iYwjOFcS8mG+qug8z3OfdgvKiAHWE3g/wucfIO1GvIaZJkI+Bzb
2awwD4O/lYit1inZ1QnJn4H+LdAfxO+d0NkRitfrIX8C6wT8H8V+W1U2lwDP
MOI9Dp2hnM7kfCt8fwlehsDbDHRPV5UTYuwOhZO2jPWg1xhj3dilnbGP4nwc
uucQ++Pw/ydwHcLvsaSwXOgVns8hm6zKNoVzEuts4n9MiU7V55BjY70ueX6b
ng/m4gA4ew3rPL6nI8VA/K8E8jXToTpbCMQbYx3y2LnqKemkYLsTOfsIssuA
fT98TsFPC3ZTgeJaAPZ5rDZsToKna6CzNxBu5or3Upcy1idjZgys2Vno3ltU
/jOB4uG9b6EXFyLh+ATYvyrI9nfI/sCqwfZlcPNxQfG+WlJeySFra8rvOpSR
X/okT/TPvmh7joi/lFM8zNMwuH8QeAaAZy6lmNjXrP05P59GjOuAe7/zdybQ
vQXYNSBfdPmiczuTFH+sE/LMWmHujgHvbKQ+GIDdFViTgfJAfphr3k9b3sve
5Xxh/zbAz51VxbISfh7AOoLzhm7lmPGSe/pbB/1F+GgkZFvGnVEkXE+WZE/b
ccgakdcy8vlcrDh4P2MlBvbB/V5L5KvlNbAJeFbHwsseY0zs6xH4OVdQLBHw
T8Tii73en1a/czYSH7F9Bp1KRXOGdofLsr2AXAeRYuE9C15vnOXv+jyfLmq+
MP/0S/+csZzd69OKkXUx5nlf5fcf8bnKGZPzfcDPb4TqSfYja4d9Rm7ZxzdU
1MusUfYMcbJ2vo1lfwx4txX1XuR9xvGuzUnNV9b/SFp88a7lrHLHHH7Xo7t5
7yPIc72qOrWi3g/GdbiofmAvsBaWY9UD71rv+F9Arq4LlXvKRlzOvnkxVO/U
vBfZL3vgZ7QiXhOhZi7riJyQI/pfA/lDBeWNfBAvOWEepj0XLwHbrVV94zv7
cF5vGHP7aVH55TuQDZWPU9D9oqS3knrUJ6ZB6O+r6g0hZ2OOMx+qVuiHbzK5
Ztw3QX4z1sXg9LdIHDE+ck6f9L8W3/tKwk9Z3eWvQ7YC+s0uvRn0wfO1Jb0T
fCMO4Hyp6wSowVSv3tI1FWElzjuA9/aq8sl3ou6x3xjqTRr0XBAv6+E++DsR
q145Gz/IqP9b/r73+/8Ryjg3voaPy3ultwF3jlTEO+fZvL/RxErumZ8J9NBd
PZqDfM+X/E3n23VPSXPpV2BYG2su/lJQ37Ke6bPtbxnrnPN0xmuGWJkjcrjZ
z+yHtvcXa2jebf+bWQnNw13+X4LzhO8T+eCbQl6ZA3I77fOXentKqmPas0b4
v4r5+hcrvFSx
              "],
              VertexColors->None], PolygonBox[CompressedData["
1:eJwtlEuI1WUYxt/m3M8Z55z//8xxjkSIi5FQmmkKtPBC6cJZVAuFTIMSJxK7
KIRltOiCI84cp5EujqPgBReKShYhgpsi3QQOhZdqJCUVzBaKGC1sofV7eGbx
wvd+7/c87/V7Z63duHxDW0S8hmSRGV0RI50R5WLE4XJE//SIu7WIr0sRx5GJ
akQujWjkIhZkIp7Bfhv7ZcAf5CMG0R/uiNgJ1yn0cj2ihCzMGLOS84vIGPrj
6BX8fQHfVw9F7MZfCb3c5fM4sqABLiEOgtxDTL2cn+f9I3nj30J/M7E/+Zgk
vvlgxng7juTxdalqrOJ5Aew+vc+Y43XO6xJjxfEHvgt1v71ciPiE3AbBLENf
Qv73sT9ArsI3Ea7NUnI+UnKNUrDDyEywp8Fca5hD2GeRi1W/ke1LOF5BH6be
xaJrfpTzMWQT+Bw5v00t+5sRNyoR34Rz+w3MrqJz/A7f72JP2iNa9GB10z7E
fQ/MFnw/TX7zqdVN9Jewv9y0bSnvC+SSR8ao9S5kD/wHkH+K7lE32CfIv0S8
3XDsRz8wVT/lv7/hnqgXwmxD78Dn9aJrNIqvHU3PzjIwF7BvwN6O7x7uLmGb
RL4Ff4UctuDre3IeKLjm6m0n9TqTd3/Uu72JfSuGJ3n/Efp7Gce4mdwPcfdq
3pwN9QZ/a/B3ImffW7FPyzqGu3D/jazh/QD6CO+H0A/C/4D4Wpy3T/dZPV3C
eQX9uVJwz9vFhQxlPaOfcS52uZaa6Z/I5U7d3JPoP+K/F47hrDEb0c9Rk7kl
x6RczqJ3l5xTgt6DPlr0/7la9x/V39SMDGGrw3Fjqt4T6FEzdjYc59EXNV3r
x5DDxPczMZ0sO+de7PdT/2X5GGm4x6qvOFvoPdR0oM09zaeOSbHcRB4llhnU
Y23WnKrdmaZ7qRp21hyjYvsTWY++EPvvFefchj4v9WxtzngWNbOaVc3kKt5+
XvOsaoZV++Wd/pvqwTy4f6l6trSD5hDbpw37Usz/Yeub4ldNVPs+ZGfJPdgO
Vwu5Fv6DT4H9IXGv9McqYH+Foz/jGZpFLM+lnnfN36amd452jf7gYM07TLvr
r4pn8f2qZ08zKa7TqXelOM/VjdFbzbx6/2Hiv64ZUK3eqLmXqtk97P823EvF
/A697EOuT/1PnXeAb+V8txv8eNO7QTmrV7c6vFvUs3rdO1L7Tn9sMbEtSl07
caj3o4l7ozvtykLq3mtnflzzjtNu0476HwGO1JU=
              "],
              VertexColors->None]}]}, 
          {RGBColor[
           0.6632436735173305, 0.6873102211600907, 0.9117652750733445], 
           EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVl9olWUYf9zO951zdrad831n3zmHBC3ZqrN0QoGwLiJPWRJkzhWYQUJo
wiK9U7OYmw7mXFt4Rl2old04K6HEi0EX2QwR8qZC05Do7yDaLKWcEKz6/fo9
4MXD+533fd7f8zy/58977nphx4btDWZ2DtIIuSdldiIw+3CR2c2c2RQOH4e8
UTEbh6xohh7k+dBsc0rrlyl9rw91lxj1FrMJyJK02WBiViiYHYCBQy06exR6
o9ivRmad+C6XzUqQ1bh7DPjtWKehf29Ke+/Bt9OB7vNuD2xNpWRrT8bsFH7X
GqTfCTkJ/+dziuEx4DTGZpMF+dkEO9my9N7HXlIy25U1Owpf8u5nb6hz4n2R
N/sb97uxvwzxfB3KtwXsrUxkexwYY5B/gbMb+sdxdh7+HMP5Ycgf8LEDWDX3
7Qq4/LYiji7gfC9s9yOuw21mfXnx/kTR7KFWs+vAXwK8X+kHdN6G7juQeiBf
ub4E/Vb4Pgys4UbFQd55ngbO94j3FXBxI7x9bwNs9UK+g09dwD4I/RGcLcb3
ujblnXf2QB6E/kCofM9C/6+szri/H7ZC4Fexf7wJuKHinEtJl/htge5QP41Y
tsH/PuydwN5oRjrToXJFu6wz2iPGDeCvLenbmnRn1mvvzYzqbxUwG6DXjL0z
4Gx/LJ5ZK8Ql5igwDhb1m3HXSrLL+iMv5IR5eCBWLmbAxy+QNVnxvS4Wdx8z
55As9mcCxcba6MTefYniaYEv3UXlYgj3Bguq6QB7WyPpP1JSbIyLfLzonCTA
OJu/XdezsDNswvgxEQ7jJw/0n3yv9lplnV3PqB4+CXWfd2ljwHPH+qXvrOE7
gXkk0Z2tFdUxa/gS7K9KxO816DyM/Unsv4r1tZJ8Ii/Mc4f3P/NwGZzHiPFi
3vuuWXi0OwEecmX11j5g/pToLvu9w/ui5vEwluWcG5H4rXqvcy5NeaycCZOB
5g7PdmbVx+y7OmxVysKifq9jEqfH9Sd9VhFnpCi/6fNi1M9QSfXaDh8u5FW3
7IOxjL4/g1+fRsJgvse8hrmOus5bOeXjimn90785S1gHrIEh8PBVUbNmJfDe
TZS7msdITtYEio1xBc36Js+fI18HipqxzBPzwxysAP7d8Hljg85fL0mH/m7K
y2fOmKfaNGf6I80g1nyf1zJnad3nN3toKTjZ1iqunoPdjRXNV9YiZyJrqd1z
+b/PWc0CxkEM9hxxPoKdO3D3g5xqkCvv/oNcLUAmcsrPlrTy9hts1iJxsAj3
lhbEKzngHnl4MhZ35I3vyUiinuZ7QR3y1oNY10OuAvcI1qOQCjg7i7vfgIu5
QDZ7vV6WtygW+rYPmF3Q28v3B/bnC+q3q84NZwvn/a68bC1AfxrfPwTi7Ewk
3vh2nXZ/WHdTXnucnWmfn8zfnMdFv3KxftMX+sQ+YT9xDrKnnkZ+n4HcCpW7
Gc8f32HGx/xGsB/Gyul4pFnPOc9ZMuBz6edEPUl8zlDGyvqpY+9Z8H4rp/dz
S0W9Tp9Yi/STtmiHvcmZzJ6nb4ORuCMW58GmivqLdUM86t8Pvzoi2eqO9JZU
PUbi0Bb/Fxxyzvlus2fYL12JYmNcrBvmnPM2Q/1YdbQWNl9uVY1eA0+/QwbT
qguu9J++33R/6B+/mVO+tf3OA9/gEcfnTKommkvUnfe7/wGbjjd2
              "],
              VertexColors->None], PolygonBox[CompressedData["
1:eJwtlV2IlHUUxs/OzO7s7OjM7Oy8M0OCpmnipgZm0nZRuWVJkNlG4AcZiHph
qHdpJrqisK3bqu1SkBrVRbmWYNKF4EV+dBGpUAaREpFUgt8phUKw5u/pmYsD
57zn+znnf96Jy9f1rE1FxGooAz1Wivi+HjF9bMSJdESqHJGGXkP5cxOE7nR7
xBD6d6ER7CvViDdyEc1jIl4tRIyiv9Ac0Ue8PUnEA9j83RrxFzQB/oPE/Pv5
iEeJvRX7LdjnWyI68d+MvBn5R+RH0M+CFqX8rVqMSPDfiH8337o6Ip6HbmLb
R731WkQNmku9PXybiu5L7HM5x7tN/gnk+CRsM5PYMxrxVcMl4vc28v8LLUHe
jX4hvvuRz6C7gv88+K+gd+h9ADqBfnwWTLA9jn4F/Et8Ow9e39StGwavywXH
kO8z0Cr4DD4X4VdDU5DnII9pcU3HkI+3O7dq/ohePm7g9zr6B6lvfNm1yv4p
arlKjz/Q2356XlChDugX8j+Xcm3D2L/c4hrnEOt6ybbvEbMJfif5+hvzWEHt
K6H/ct6BJ/H/UPNHfwv9PmLvgY4Qu47/XuLNLrq2m8hL4fdWrBvBZ1PBMeTb
ifwE/GAjn2b4O/4XoXnkm0K+P+G/w+azNn97hXluRT4HFnewX1gxpsJSPSr3
PuK9nXYN2rX7S65FmO3Avx96Nu2ZzUDfQ4xfyTWIflPVO6zdvSr8wOqFsmOp
58Vg8TX6L3gLd9jf0Zp7Ui/DyNvajaGw0z7pLf2RuBe9qR3whZJ3VT1/Suyf
isZ+GT47sT/Ft17Vxnv6jfgXoI3EfhPKw7dBnRnPcJB6J5I/2jyju/i+VXXt
h9GXyDWQuD5h0g8/tpFf35bjOw76B/sK8sPoZyZ+W/LXLp0k5rVm79QS6lsK
3c4bw1TJPatX7ex8cu+qu/Zr2K8v+mboVnxLzNPI0xPnehz/s8ziGPkPNrkn
3ZZzdb8V3RjNuqnuW6GZ9+F7t2as1UMr/qNl13oUOlk0BpJ1I4SlMBa2wlS7
ppuj+Qj/w8Q7BH2e940Q1toJ7YIw78b+unYu6zevtyrMVL/ebEK/G4rubT3+
29BvhyZn3FM3+qerxkI7pt3pIua0jHcoX/YN1e0Uxr3w8+l3UtYxtPtDZd8y
vYFF6IZK3j3NQLf3QMm5dYNvdPhm61ar5jUF31TdPsXcjn22w7ukmWt35vJt
JOcd0u3TzZS9bqB0neAx0GqbLPi01nzb1MND6CYnnqVspsGfAo+utDFa2e6b
/f+tTvuW6iboFuimvsjbG1f0bdINaUGfLfsWyue+uv9J+hdpRvcAgpvhww==

              "],
              VertexColors->None]}]}, 
          {RGBColor[
           0.686181940240387, 0.7241656331434388, 0.9122881969038031], 
           EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFllts1FUQxk93t9vtxd39d3fbBoKUWEEKVRMvqQ+aVH2xDd4SEy+AWq3g
iyYWjFhNStQWURJti0RAY2hrgk0sJl76ZJUXbiY+o4lQqUZJ9MEYL6EUv5/f
aXiY/M/OmTMz55tv5uyq3mfvfyYVQjgpSUuuSkLYUgmhrTqEnpoQPtTm11Uh
TEv3iSRXG8IVxRBe13ouF8J4XQgTkqOyeasxhIcLIUzqzLz2vpf0av1PJoTN
kozW/fJ5qC76zMun4u3VutIcwkct3jsv/TeJ7V9sCqGk3+cVN51yPOxHFOtE
3nE/LYUwI7lLvqfk40zJcX5Sjj9K7tDZNn3XSYaUU6YhhO3SbZNcVL5Xy35b
2ne9VO/8yeO5GufZrNxaJJPS/Vnv+5LLXNYYcMfj8r1VuGQz3p+MmNxXDuFu
yeka5zce9Udkv0ZxN6edB/l0an1O/t4W9qdUi+XK7R6d/U7nbtT6QMV7+EI3
Ij83CYc9wupL2b+i/Y6C87lBeTbnbFOqdgz8b6hx7mC4XvanZP+m7D5XLp9J
urV/QDEfiXWkdv21rt8H+t4sv+054xSEY0b6fcJmVLI2YjMe8XlNfh6Un4mU
98eiTXfEYrTKvk7Hu3AOPblxP+6A/lfV+d6y+UBN8AE398rfO83WbSm6BuDP
vcmLs/AVHbFaZfOubEaptdZPiCsp3WFBPgYr5utEvDOx0sI2JZkXftdoP58Y
y0v6LkrmtB7R2da8z4BHKmKCv1ejzz7FebLFvLuoc5tkX9TZRu1fkP/prHUv
NVlP78FHatol+8d1dqzK8QvJ5XryHZPNVvlZFM7HcubUYGJewRXuCpeG5eOs
7jyl3BoVa6NkSPpu2d9SMpcHlcuZaHNWv1+OefxbbQzxyR2pPfm0JZ4X5Fsl
/zvl8zqtv9W6U37urHWd+hrcW9QZfMH2XMV22KzUub9k/7dizKb9hT+92n+s
xTHx8VSD4w4Ip0Xl2pF2Ln1Rv6Lmsg/i8aV/sznPA7gP3juajDlnqRU8P5i4
x8Bsl2JuL5jvFeXZpPXT0n8lm1nJYa2vlJ/VBWNEHuyD5/uyf0/yR87zYFmj
sXtDumLRc/E34X174p6it3bl4nzMGHt4Sx2oGb+PM6N0fjjyGn5Pxl7oiTOK
OXok7975ouTZ+v9c1dlEZ7tkv182t+bNB+4AXmBU0n5ZsiPnu/Ylvg+8Jy/m
BvXYEGOBMXNwaQYW68xV8GqPMwcusscs6oucoSZw9oV687ZTeV6fN9c4ty72
34LiP5oYT3i6ENfPK7fpsu3g2gMl821jwXN/qcb9Mc8fSp4R4JTSflqyr94z
hjeBmTCTNRfw/3O9+Yh+Nt4ZP8zFYxXPrcNl9yR8441iNsHnqTgfuTu+8YUf
+mBZ5DmYzsRYzKGVRfcnc6QYeQRvuNOY1gPyfaHZ9aJuA7F2vBXUhroQi/vw
pjBreD+w+TjvXMmTd3K+YhvqvtQfcJfepq9ZZ7Pud2oOJ/FP3rmICTnCkfXS
P1TwfKdeK3iLK/Y1LN1Q2T3XKt2Jgv2c1Hetfu+WfjVvX8UxutSLq/LmA7P2
95LvxjtDneEF/UMO5Mn7TR/AZ3jH7IF7zIOjBWO4M/G7iJ63bSjawzvWxOJ9
4/8KfcS8/KVg/8yo9shD8trTZPv9utPBsnuvW+d6JMuznknwmz5sr/g+2FND
9qkv7/NteefToXPXNhpreLc75vYfq9E6Lg==
              "],
              VertexColors->None], PolygonBox[CompressedData["
1:eJwtlNuLlWUUxtfMPsweD7P3/vb+Zu8UD+FoTToWBGJdBJY3jZgWBRlhNqZj
XRTkAc2E1BhNLVBHBWc08dRBcBSk7MbUm8n8CzIoJ0cJwS5COqr1e3zmYsF6
33V4nrXed60Hu9554e3GiOhGssimcsRG5Bz6qkxEqcQ5jfixEDGMPJBEfFWJ
6GyK2N1AXEvEJORPgidwNxm90hqxsjniL+4uFyPaiO8hdgcyHf0RpDd8dwB9
JniP5iJ+5/xGPeIzMFcTnx0TMY7zAD4FznORJ8Aei30I36F8xCdgLavbdxX2
S/h2Y8+D/Tc5p3JO4TCHIrcQMwlbQ914u6nvJfK9iPRmfPcR/u3w6Wo0xhJ8
jxPTSP5A1oGXUGMPxwHwf8F/E/YboyOeAX9c4h6pN+IwiP0M+Z9tcs/key11
LYr5lHxt4LWBXRoV0Ye+H7kc5jcI9ykj/VuLf45c/yTGPovcw3cMUiJ+KGe9
gv+6gu8uEH93xD6DfK9TT1fdtfTCcSn6cjhls67xffisRzoyjhH2d0X3Thwe
o/YN5NuA7WresR/A50TWOYqc+7HvxH4N/1P4fwPn+dS+B7xi2TWplgo+rbWI
GnKM2o8ib2HbX+WO2MfxOQ3+KWRxxn/gKfJ1Vvz2+qOv4H+OnMd5r2NIB+cV
+A8W/IY95HqVu5Xg57nrBetz7uZxbh9tbluqtoljP3pf1bnEYRqxHdSXz7vm
f4m/U/M86I2ew3c8PleI/QEpwWVG6r+uP7eE839lv416OhW82RX3TvMl7ueR
L3KuYYB8i8h3FH06OQ6BtaZofRZ8r9LfrbzZoWb3fEHVPVOvxKGO/y74Xmxw
T8+C9XXFvdcfnJl4xoWtmj5u9QxpdjST7alrEPdtYL5M7l01z7I4rS6ak7iI
w7dl7wDNvmq4Q/73yHez2f/tV/wnJu6d3vBnuKTEHx7lN9lZ8h/Q298m50Lq
eb7qXmbB64PP5JJnQX/qS2r/iRzvNjlHN/a7RdejGdLsbk+9q/T+/egHU+8W
zfjT2G+2OPdianqt7DfS22imq6lrEHfN0LKyZ06z9mbOu1B/XH9bf+Ah8UNm
47+14N03LbWuHfhHyTWqNu1Ize73RfdWM1zGN0mtq+fahZ34jM97H2nWJiTe
Zerhh/huTl2b8PfSu301/2X1RLszg/9wzjv0CP062eJZX858z0u8Y9RPYdyD
y5Mj86SZka6dpF2ku2GwrqfebfpTmh3lvJ8LvEvEP5x6ltWDi5zT1L1ST38j
362Key1OmbrfRG+xD87/A8MW1IM=
              "],
              VertexColors->None]}]}, 
          {RGBColor[
           0.7091202069634438, 0.7610210451267871, 0.9128111187342617], 
           EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlltolnUcx/++27u92973fd7Tsy3Ttc3NTU3zohMZERREBzoYZMVWppDW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              "],
              VertexColors->None], PolygonBox[CompressedData["
1:eJwllUtsVXUQxofb3tb2Xu6555577m0I1Ja+BKKy8ZEgiQY3PuIDE1FTo7Ym
VBeVmLTUx4IgL5WoFBE0PjD4NtqSWDC6gFUBV7owrqCuNG40bkRtRX+f32KS
mf+8vpkzM6d35InN44WIGIdaoXu7IrZARzsj5lAMZhGHGhHtyN+1RayoRDya
RowVI04i765H3J9EFC/DHzoH35NH7IJ/HtoBv9SMmC5h2xIxg/9JYt7eHrGT
mCn6PHG8Kex3I5eqEXuwfZm3b5AnyXER+/6OiFn8j5P/TXR38LYH3d66+Y/A
+xC6JWgB/Sj0MLWMQMvKEQ9S4LPoBsi3BdsJciyA5VP0L6E/xdtW8vWl1s+D
5zFsXyf+GWxP8DYDP8nbfME1v49vlf58jX6SGAPE+yexr/q1HfsJaFvBNfxZ
i/gLGgHbWnwmsN1HjIGyY+7K3TP16jwxeqh3mv4N0b+DfJ+D8IehdcgfFlzr
MDZJ0TXvJdYC/esnXh9UJ1YGbcB2FjwV7K/I/W1u5O01Yh2C1pYc8yy6rfiv
pte90BnkOWoq0rvLkc8hrwL/TNhmrGof2fZBa8Ayj9wN/y35fqwak7Coxi+J
9UXmWJqBDPunG8Y2RcxrsP8M/9YO93QU3w+q/nY3Y7NI7lruWVnXYmwnoItF
YxylvtbMs3kd+sPYrsT/APxV2KyoGbOwykdYNWOaLWFW73bUnEs9vKTZRL+v
6Hn5m285w9sq+BJvy9GdSvwt9Q3Uywvkf7HsniboO3JjnQTzIPqEereRa475
r8CXoQfAPs5bDX55w/yTHd61Sm5f7Yhmsz81Fs1od8U+sv2DGEnqb6xvq/rv
xPdn8A3Ddxc968OJd0Uzfy1Yb4F+bfPMDWB/NrGv8u1E7qxatwb5PXpzDPp+
mTF/Qry86d1Rzfclvgm6BZrZZ8C3Efqtzf71xN9I8YVxtWYnN6+bcQndv6l3
VzP7VMPfXP37hRrThndOu6YeavZrFevU/w3En6p7V7Vz7+B7FPoKrKfBvL7m
G6D+tYPpJ2p7ocu9k41qG2r626hGYX8D+1eKruFK4j+Xezc1E/PI57HfXvLM
Xmi6JtWitxvw35/aVj0Wf3XNufXWQu4C9AOz/zs+t6G7FXq84Jxl3cLcvdNN
XGy6p5J1U3ULdVN1S3UTj1D7WOLbrZu1Ht31mW+RdraGfwa92+kbX0XXn3lX
/58R8h3JvSvTyEPwg7lvj2q6C/7u3PE0f4vkmyVfd4tvWr3pnqvXyrGZ2Pdk
vuXawZvA+zE+vcTaxNurTd803bIe3t4i9tu5e6EeyPbzinXyOU6upbp3TzlP
I1dzf3vNyCNdzqHYuvn6d61MPfv6h/0HjgfZhQ==
              "],
              VertexColors->None]}]}, 
          {RGBColor[
           0.7320584736865003, 0.7978764571101354, 0.9133340405647202], 
           EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVltsVFUU3XXa23lx78yduTNFKvahg/3SRFsTMVD9EhOePghota30MQQk
LcESqdSY1ERFja1V+FESfEfq48MvQX4khsQftOVHqAlajBQ/SsTS1sS1ug7x
4+See+4+66y999r73PrOPVuevcnMLmPEMM5EZqcxjmLemjX7I2f2YJXZfNEs
njF7K2V2JG9WDswKcbOtCbPZtNmnFWY9sGsCyDD2vhmavYGx0TN7GPa/+2YP
4PvuhJ7bKs3SBTO/oLUgadaI9RPYewDPOYw2YCXAIYnh4z0DDlmM92Abw54n
gPFzhZ7b3PwwuK8Ez7/AbQXOrw2F9WiN2WMYs+C/iL0jwLhWbfakJ/+4vwrr
Q1hrwblTnjiRT29aPq6BzYvVsuFZT+P5FMYnmDfg3AvgNoxza8F3rCD+S/FJ
aS/jc8HFaAZxvZwTXk9afE7GFIP+mM79ETGbz+qs/YjhasR8DvbXMR/HfAfO
2sX4YZzHOR1478YYwN4xnPkn5pOY78K3bzz5xbhwvYyk1yJO74L3DN5HMU7B
ZgPWr3hao82XOGchL1zmYG9K+f0Ha0l8a4ZNCjjD9B82E3E9z8Dmbnw/GAmH
8fwF6x2YJ2H/UqT3BOb7MZ/EfAd8vdkXfk9c/hA/C5x1OG8t5lfxnMvr2xFP
fpdh348Y7MW4iPePPD0ZhxJiu7ZSe58Bfj5QHjbjzE0Y43HprcpT3L/A93ng
dzn8LsfhOGybM9KIH4kreTKXjAvnzG23y+8iML4K5Ecz8nwgq3PWe9INNUNe
1A+5GbS5IqO8rUYMnvcVwwx8+hDf+nDuyzg3DZspYJ7F2hDmo9DNQ8A/VlDe
tmL9cYyrwGkE/gas1eEZ4HupqFqh/ql91jj9HnSaO4RaeT3UHuqd2qVuhzzV
MXGasL7dE/fBtGqxAvxPwNdYJN/b8H1PQjXFOu1ztboMHEKMEVM+w0C+rwP/
lpw0sgDb3xx3Yux2OMfA64NQ2OwfrFuuk0drpeJ5iX0mVN5mEO/PgX8WtulI
fYR5asb8p0B6zyEeYVH7ya/NYb4Cjrf44rIdz4mitPR2UvXHXldOa844cn+H
y+m5pPYxJuwbnc6evZLzzzBvr1Ysac+6Zz5Y+68ib9PI6R3YNwi+d4XKTXVC
NsxXHbjXhKpT4pET8Xl+u+NA7HZ3Vj1wuiL1FeL8m1CdM4etLn7sZ+wR7A/M
83qXa/rAPBBnSaeO823IVSYnnBfA97VQe+7F/Osa+bLT6YfcyJNYxCFencOk
761Oi9Rrh4vlxZT28httic1zqQtqkxjv48x8UX6wBrinNfH/HUONsc9dcT2w
IatYMA4N4H5PTpq/PVCsGeePPWmH/eQQ1u731Yf7gNGPcR982IR9mzH+5v2Q
UF7pSwAuP/iql0vA3IiYH4+rPs65Golh33JfvXja1/3KuyeKC4s47B+8Q5gL
3gujLkYDcfEgB/a3fW4+5Xou++o+6H8gr3hSQ6vSikM3uCyC0/dx3e1NvrTU
ifNTkc680Qd5Z30H22WRzqgsqteQB3PbklF+id3kemvJncU5e1W2oJpnf+h1
9yb/GybcvUBtRi5u9ZHuTvqcwfNUIF978Tycl92dofLBXDCegw7zubz+V+jL
t7BPRsoT8zro/iVWFdU7WNsHwf1X2KwBt8mi7hLeI6NYeyeSXq7zfwFjHPbX
PPVUck7gexApB9Qm9c28sA/sdP8/rK1qV6e8G6fzujuIxZyxh4wDY3mN7FjH
twaqZdYXebEfMk/shcwpe0zZ4VfmdIfx/joP/qcD6YR1SK0R5wYnaoCxZ6yo
vbFI9zHvYuaLdUJtPALMLTn5yj7Afs3/DdbZkOsD/M8gf+qNPf5koD5Pv8su
DvwvYGx4D1Ir1C51suhiwjl7K/VO/FmnDfpFLkv3NPCPhqpt1jX1Mum0PeIw
eRa1VnLaZi1Rv4xDp/OZ/vKeWenLZijSHclc8r+slJPOFwL1AuqFPbvR9bz/
AHRiYOE=
              "],
              VertexColors->None], PolygonBox[CompressedData["
1:eJwtlUtsVHUUxv8ynel02s6duTO3U2xBUQSaYHRBSyKmPhYSTQRBkQQFbSPF
JiABhBJRSkwwgq9oQWFDCKKuqLpxoyAbjTGiRqVupJoArWIxCgqlxcTf5zeL
k/mfOa/vPO+M7vVLn5oSQtgJ1eg3CWF/MYQveQ9nQ7gM/1BzCBfqQ1heF8Jo
IYSDcQgrMiG0NYSQbwqhEXoD/XXID/C+Afsb0yFEuRBaeLdCK1MhLCLQ07yv
j/zWfwt4by6HcKk2hHHoe/hiKYTj+B8g/nAlhFNQB7o74TuQ5cDwE++f0Xke
fHPw2TXF//2G/DDytWDpx9/DYP+G/7p4XySHEWKNQvuxbcfmW2Rp/O8Bazc6
F8htIzmcxv5ddCbRXYX/PvLrwf+ryJ/D//3IFkNbiT83cvwh5CPIdhFzNrWZ
02AsKWJ8lDGmHL4+Rn8TWPLU6G/8fxDZdxe0m9gzq/n/i34D9n3EOKl8od7I
mIW1CX4C+5qic1kNPxg5B2F/Imvb+oJ7KR9b4OsKxir+KvrzS67lZ/AfRsYk
LGug1tg9U6/GwTsT+Vz+S6O/DX4quc7H3zHkteDdhm5LbF3Jj6NfR8wNwgLF
8Pfh/y5kd4D5bD6EQ+g/mvF/0/G1B/1z6P4BldCfkbj3Pcg3UZ8VefdDPTqD
7fuRc1dPy7wnwTCM7pq0e6GZ1ayqJ29jvyDv+T6Pfkzvlzd7Nu5kAW5Hdm+1
HkfR6QPrFuhg8Ixeh//2xLOpGRbWafg/nzXmqdh3F41VPZ8Ov7vZs6AdWZx4
J2R7BP234G+G74Ufyxq7cpa9cvi95JnWLO+A3iFWQ5N3bT10lvzXwp+qc/6N
6jc+bsPfZvwtI3ZEjp013mHt9oP4u5RxDf7C/tPIupqZfeTaSYwIfwn/bcdf
f+JaCeMsfM2GVsI/gs9swTOlWXq93rb7y55N+ahHdhT/bSnnNB47pmINZjy7
V8ueNc3w5+gewSZd551fAtYd1HAIrP9kvOsvJN4F7Zx2KVudL+3UPc2+WbpV
p+FX855EZ2PKN6kFfAPV+dqL/Fp815Q8K7qB6sW+xLOnfF8C6wnkj9V65xvx
daXs3VKNX6T2u6BJ4v3IDfkK3e3E6IRfhc1JajVU8T5pZtuRnav2UznqtlyJ
XQvJfyF2MfJuyMc89Av438A7BS3FdmHJ/VAPX8H2T3T6eS+CboW/JfbsPpv2
rt4U+a2d7S+4RqrNQM5YFCNVvZfy9Vrs2yafEXjyiWujGk+Ad6zkWfzhmhAe
SHwTtOuDyGchW5L4/f/NoFaXy+6tatCB/5qKY+tm6NYPJr4dunlted9A3T7t
XJF31ORZUw0024XEt0T1V+8/UX+zxqdZCc3urWbmYuwbod14D8ol7qFsZaPb
3ZP49mmelmE/RozvyKcX+1/BdyLvXO/mv3VN1pFMO/cF7wL5HMh5x3TLRvLW
1U0rIytVfFv0zVwItpdj9+oMGN8k9t7Es6aZVG9bC74F6vHX8E9G3sXHa/0t
039665um261vrr61ulnFimdSsyhMml3NpGZRM3wMXw2Jvz3ayWfAOlHx7uoe
zEO3veR+amf0bdxa9rdZ38hpeecg7Jr5w7Fvkm6RbkIB29HIt039/A865x4o

              "],
              VertexColors->None]}]}, 
          {RGBColor[
           0.7549967404095571, 0.8347318690934837, 0.9138569623951789], 
           EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl21s3lUZxk/X9nn+ffr0ef+3z1gBOxMdETBOCyqRxRcYIQGUsA6aoXGF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              "],
              VertexColors->None], PolygonBox[CompressedData["
1:eJwtlltslFUUhQ+9zkzbuU9nkKK2JIIxYASLIgnViIok4iUCiqgRpJAIRTrV
yK3EgCDxQpGLJIo1oIIB+mAiKiC8oBiNEgVUkBJfipiSoGBRkajfyurDTs75
995rX846+/z1M+Y/0FISQngbKUNOJUMYUxvC5mgIncjFbAjn0iEMKg1hRiSE
hkwI/yRCOMj6cEUIn2E7MRXCt/jeGWOfC2Fm0mC95SF0Yfs3GE+wrgMjxv5P
9jPxf5RvH4O9DNmOfRG89eBdAd5gdBXgHUD3E3it6J5D9uBfSYwa9EPB20g+
B2sde3hlCPNYz0VS6CqwWYztQmQF+x+JWQp2X9a1xMpdazf4b0Vd82vYrkXm
0JQz2NyYcc2q9RSyFfsJGePVEnMTeItyxn4VvB7y/QX8aRHnUGQ9Ph5CAds+
8vuuQGvyITQRq6mG+qmnBP952LdWgYV+CZKrBpue3E+s+5AOsIaDPxCsUvYP
oVtBmw+Rz+fIXeBPQCLUcgn8Ydgux6cX27NId7l9evCfSE7HyOXfAeRMvmuU
M7qrkAvU8wcyHftnwV9OLiuRevLZhr6B9W3E+BLsdezXg92WdW3q2cKCa1Du
svkL3YWs+aMz30m9Z1M+myTfZlF7PfspJeZUkVpaa/u5gk0k5R6pNzrzKPtq
fNqwHYPPRtbrkDWqlW+jsN2Q81rnsZhcDpNvS4V7uoj6x8Z9durRI+D1kN/D
/Xz8j9515Hz26ukL+BfBfDPqHjyO7rGc8z0QMbeWIscj5kQfZzqHnpTQjyvp
Xxrfu8E/Uumei+vtyNoB5nwi7hwU+11yXEG8k0n3em+ZuTkafWO5OXpDwpwX
188jO1i3gvc0eOOEnzTHxK0G/Legn4t+JPqb0b/C+mXFD/1nDl6B/UXw25DT
7If0830nNb2Yd0zFqqtyL3dh31zhnqp3tyNfVbqH41kvwX9Eib+p9hT+Ryvd
g0EFc1Zc3QFeE7qVcXOpiM9JsIv412C7Dvxx2P6adC80A8aiv04+4g/72dg2
IwMq3fNb6dXpuLk9FZ8u4k/BfgvY15LfYHSrwbwUdQ+GsS+mXPs3mjGcZTTp
u7OKb7GUOSeuDdP50o+LeZ/9vmBuf8++pcocvwf/HuJNK/UMG0i9XXy7g/37
VZ4dy9if6OfLz6zbiVdf5h7F2O9LOJZm5gJyjcd9F7eS39CUe6Daxd8+9GOJ
cRzs5+npLvDrCu7tCPA+YH1T0rE74e8o9NfHnbt6WIN+O9+qse3EZgixJ+V8
9uJ4nWY/0oX9M9g3E6+6YNsfoubO1QnrxKHd5Pdhytzvxf9E0jNcs3sBMjrp
nJSLZuAqejcJ/9ex3UAPOtm3JXxWjcRYyX513tyTje6ibKTTnSxQSxU5PcW6
D/8ycq9O+LxawIjqvSGfE+WeaXF8D+GzH368Qb+OoG/M+fx1RprFnyTsq5m8
jfN9D+nA/kr2v7M+n/VZKMbOjHuuXusOTqa2Bwu+e5vB/4JYibzXB9AP0ttY
8CzXzKogXsj5LZsf8VnOSjo3nemTrG+p9VusN7UK2xkpz/4i9os1GzJ+m3RG
x4g1Le7ZKU5eppbmnLlcLPVb/lvas0Z8LUX3acJYqjcOVn3Gd0EcXpIz58Q1
zTj1ujznXNXzqfiuJeY1xFpAD/ZguxfZVOJ/gpeItTTpt0UcV++7M7bVGWjW
6M3XW6+Z04tvFz6zWU9HfybjO6273I7PUs2qWnNdM/QSuq/j1umN01urN1mz
X2+uZsNlvu2t9IyYSq6T854152Lm/raMY+kOtOf8hshfd1RvU0PKvdN9uJda
RhbM1W6+NaHbnTa3xRFxTf8Y6r8415bxndFd0Uzbn3DP1Wu9YerdO1lzSz3U
rJ6XNrZm9mTsO/LmtmaYZlUs7X8rcVa1Tcm7FtV4Out/LL0n+gc5wv5o1rNU
MzmFbTJvLmoGNoL3Udr/Xnpj/gdNok42
              "],
              VertexColors->None]}]}, 
          {RGBColor[
           0.7763750371043867, 0.8515812701514754, 0.9078736836937149], 
           EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXlwldUZxr/c7LnJTW7uqtFYtdVWxzosVSGxiFhBqRtW0TJTERUVUEig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              "],
              VertexColors->None], PolygonBox[CompressedData["
1:eJwtl2eMlWUWx5+5U+693OH2O+8VFMQNBiXRUDSCgzRRdJdqFJGogB1EZxAT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              "],
              VertexColors->None]}]}, 
          {RGBColor[
           0.7969751574663384, 0.858450861382541, 0.8986448482320005], 
           EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHmQVdURxu/MY9682d6bedvFKtGgodwTBRE1KTcEiUZ0iIJo1IgbsqMm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              "],
              VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnmQz3UYxz/7+9mDXb/d370aanQQUbGU0qSskEraEAljdTjW7qIpV6Uy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              "],
              VertexColors->None]}]}, 
          {RGBColor[0.81757527782829, 0.8653204526136066, 0.8894160127702861],
            EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtmHuw1VUVx3/3wbnn3nOf5x0KZCI1dlEBk8YwBMHxwSPl2WCT0CRCl/dM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              "],
              VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnmQznUcx78edp/HLvvs8zy/58iZ7hxlV9EolKgppFhHqUkqV+vYNZP6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              "],
              VertexColors->None]}]}, 
          {RGBColor[
           0.8381753981902417, 0.8721900438446721, 0.8801871773085718], 
           EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHuQ1lUZx38se3n3/r7se1lkTVDHqRgWKrNAICCcnAFiuWUNFNqI3Bpc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              "],
              VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnmQ13MYxz9t7f5+u+3u7/r+jnRIJUfEEKPtoMKYId0M5ZxSYbIydBik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              "],
              VertexColors->None]}]}, 
          {RGBColor[
           0.8587755185521934, 0.8790596350757377, 0.8709583418468574], 
           EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmGmQlNUVhm9Pz8L0zPT0TDf9ddBUCWMwaMSNVIIpy2WopBQ1JRh/RGJc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              "],
              VertexColors->None], PolygonBox[CompressedData["
1:eJwllllslVUQx09ve1u4t+3tXfi+K2LCJgpIkASXYhCwJAYoaAB9oaAsFQoC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              "],
              VertexColors->None]}]}, 
          {RGBColor[0.879375638914145, 0.8859292263068033, 0.861729506385143],
            EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmnlw1dUVx38vIYnJ27I83ntqFe10gSASOwOkMy6xVq1LlULHQUEUBQlu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              "],
              VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3mMVVUSxk9v7/Wi973u9/rep6MSlyiySGvUbjOguIuAAiYkDg00CAoq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              "],
              VertexColors->None]}]}, 
          {RGBColor[
           0.8999757592760966, 0.8927988175378688, 0.8525006709234287], 
           EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmnlwldUZxr97CSS5N3cJXG6ioyyVAOIGCioI1gpBdoKSRNmCIK3jWsVd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              "],
              VertexColors->None], PolygonBox[CompressedData["
1:eJwllnuQjnUUx3+72PXua5/3WV7P+9YfZMaQWyi3wXYdIdcRYcOahmGmGXJt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              "],
              VertexColors->None]}]}, 
          {RGBColor[
           0.9205758796380483, 0.8996684087689344, 0.8432718354617144], 
           EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl9lvVVUUxnd76W17L4feFuy99AkwaiLGW6ZojNCWRGZChGqgDWD8A1SU
KUGGB6OvToAmGhDEaEJFE4lhisODCSbGEeMzhEFaaMvQMiTG7+f6Gnw42evs
s/bea/jWt9eZ+vyLK1+oTSk9XpNSTuPKLKV9Eq5KPiy5V/Odkg9NSGmgNaWN
hZQ+qktpSItmaf7JfMyNaM3f+n5Zzwa9b9KzWc+o5p+W/l3pd0l/nb6v1TOs
91ezGJmfXk7pYT3HtKZQSekz6RzU2kU695DkKdK5IFtuj09pUHJO8hI97ZLr
NC7VM0Pyco2D2rNeY74Y9q/Q/GSNPXo6Utg+aPtf0pmLmlJqkO51r5+p8Zrs
GNbzst5Pj0vppJ4PZM9P8uWC1s7X/HF9X1IIu7ps2/1a+5z2XK/njr5dle1X
WiMefL9jne8aYz1r10n3Kdlw2/st1bNFZ5yQTceLkY9hrVlmH/M1IWPnZtm1
X9+rKXzCfvzq1Z7zteeNQnzfZ52hFLFqt6/4iH5PS0pr9DygfI5kEfcp1u+U
3jSNl6XbIXliihhsdRyuWGdqCrnD+mADXNzMhT/nc6G/xeuIA351WR60zNqL
0n0sHzkbKkS8NhMTYeNMSdiQ3w1ZzLEOLIBdcPum/H6rEjZ+mgsMttWEjfiD
nax/Q983ae6E9rvULLs0t7s+pcU6b0A6MxTDmXq+1/ujyltVj0KUjhTjHfm1
fMhzial0/1Lc+iXvqI11yAs0900l9FdlYSf2rtD8kdawcVcWI3ayH2ew53HZ
dqwSeaa2ipWor73ysa8cWL6Wi1oB88upLe11tDF8mOu8zNLcu/JtXk3U1nrX
10YZ9afjeUnvv+nc12sD92CDmiDGxB+sjmqf1a3xDlbvjo95cI1MbsEaPoK3
fs4qBQ7Y9wdiWxO6d7z2Cfm0RP4cVG19rTwsbAqOIb+Nes7WhA0NlsEh8qCx
xjtyfyH0eUceKIT+bMVpTjnOZp7vYPgL+dqeRayrWcjUOLVetTxPtnSXYy94
psV8iNzsOspZhlveV04/lD/niIH8niX5bC44hJFzGc9Zxt5+25n3/tQ4+QP3
+E3eyB/1uD2LvA271uvNAx22qdM8kfc+z8iGrypRe2N+UqM7stCBe8nzNfNA
p7mS/X4thm3YeVF5OTAhcDFozHH2I9q/vhIcc9Q1etbcTC2228cG5wWsUcPg
bSiL2qAuVmv+l0rUPbw3OwvugwPAJTxAvV60zN61jv+QZXA+Uoizc+Zj+GTQ
+J/tGLIv79QC8jzv12kug3/AQtXYgKuog/vNT8PW4dxxjvOw5Wnm1zrbBveB
fe6gTb4PqfO+LO7X//JQDB4i7uThunMxau6EEwbsU4f35+wZzjVngwGwtqp0
D1/kb6Lzu9w+cB/etD03nHdyypn3FeNcYjGv5h5PHqiL2BN3ahgb4AnqiXd0
wSh8w7jb8hivcfff1fh2JTh2WxZ3f5fxjAyWbhWC5+CNY/KjwbxX1X7v1AfX
0lNwrxCbLtVmTzls786CW8k/e3EGMVmgfR7UPieLgfdtPne0EOdx1iZji/jj
KxjjHX66bY6i5rbbTuzd7t7l57qoBWpirM7hjRZjgBxtc61hT7PzCDaoy2dL
UZvEaadjdclcSby5x25lcZcRP+4qYgj372kK/u/zWnDCuOt/8g77e0Z1VpgU
ueGMnZ7nfgDjV9xXoA8HgMl645Kx0fKoYz3icdQx3CugfVKJXLF3n88mVtsc
t8OebzPP5c1XzY4VuKL2yRV1OuB7NGe7Dts27hfqFpwuHB88Dof8qLvmdGvc
S+NcF8Sf+7xqTNa6dtpdC/g5ueYevpH3K64nyxGnXtvd5rrhvc21NNOcAK/M
Ml8hn7D9p4ohYy+93aj7gW8Vpz2VsJ2Y/T4h7KP3AkPgBz1ijO/gutv36RHZ
9c+E6KlXGvNV894q9xW99oNYgaMBx/YPrVvWGvxMzL4sxlnEuH8Ml1l8Yx57
R2wzGCBW8AZ9HxiEN8A+/Qj1Qb+7w+c9lA//8f28+2Z4tEEYbJwU9UwPsMS9
Lj6dKodfW91/XDcPDbhno9743uWe5IK5vVc10VOKuiGuHaWILf8S4B1O4o6a
Xop7ivu9w1zPnbOmFDVfNccMuK+b67PRZQ1c+rHsfKUlaoGa3Gd7+ad5ryls
JH5HjEm+E6uxXpnxurkdHgNT9D7HmqP/WSx5Qznqjf+A8+6dh421mcbwVcdk
nPHMvUN/Su+I7UPmJnhprQxZ1xI5obf6vBz9FRjf1xQ4p2fpLsW9wX2FLeQa
v0/bd2LHHuS0wfyADv8NsyuBXzDFCH7uuB/E7jmV6I3Yf65jj/3cOdjCvUOf
C+9vdv/F2WP/E4P28V+cePVO
              "],
              VertexColors->None], PolygonBox[CompressedData["
1:eJwllElIlXEUxW8Oqd/L955D33NpCwsysEEJopnSLEtSKwfUqH1mqe1aBS0T
Gmyn+VJaZUFRWtKwiAoiGoTWRqlooRZquel3O4sL3333/M89d3prTrXVnEkx
syNYGrY7btaYa1a00ux+xOxmzGwoYXY03WwOYHrU7Cx+JrFq8KfzzLoLzEpW
mV3izYMcs+VsswuQ9fJmL+8bwM8HZr+xTLAbyNGXatYFZhL8BHZuhd40Eusm
x0f4J8Fc4X039p3c7+B7E5pdJn4IroNYFf5h7GGW2TgcjeSqAr+a97+IL2VL
k2txDtc6y2+U+F9zHfl2gP8A/iv5Rnnfh7+copq34J/E/sI1A/8Y+Mfw9RNL
pultLfHpQBznIe7IVawTfCv4beRMgl+A/wRa34bSPoIF+Wav8Sv5vp5BHHxT
XLVvpZ8H4G+DPyOinu8iVgjfPb4r0D9ILzrJtx1sFxytcLWEmlUSjk/EM8lx
Fe4SbDNcG10v2l6Cz8rXDH12jilLqGav9VWgWZQm9O0zmYF7OlQtHYFyD0T1
7RqGc7QjvhteczNv91HDEvFF7Ecoza61E5tjFvVgZgPNsBzspoS0XaSGZ9T6
vEC1+szaid2OqrdZEfWmMqZv75HnGolrtzxna0KczuUzvIvfgz+Lfwt96/HH
our9MPE6/M9R7dJMoF16lCOs75Tv8p6Ydst32mfXk6fe+gwjaA0K1Pt2/FK+
a9AznqqbWou/QM2F1PIUvhaKqiA+yvc64jfgniLf+3RpLAJfHhf2SUSz9xv1
2/Qd8N4twvciSz1siGuHfHcmyNkLXzX13EnVTvfz3ZTQLfrN1YItK9Duu8Yk
8alQ2ufxj8d1g3573/AHiRUn1KtrGbqF+rhy+U34bR6LC+s36rexM6Ze+o14
bZ7Dub3GIfh+htoF11gf6kb8NrymL2Bb4PgTaGeL4W7OVa/8P2QglCbX4j31
XnrPvFfe0/0x7aDvnnP8A7oTudI=
              "],
              VertexColors->None]}]}}, {{}, 
          {GrayLevel[0], Opacity[0.4], 
           TagBox[
            
            TooltipBox[
             LineBox[{4160, 4698, 4697, 6196, 4178, 6195, 4179, 6197, 3737, 
              6301, 4180, 3901, 5971, 3902, 5972, 3796, 5708, 5709, 3569, 
              5976, 3575, 5720, 5719, 5834, 5833, 3719, 4181, 6324, 4182, 
              3983, 3984, 6289, 3576, 4532, 3579, 6290, 4283, 4584, 4583, 
              3746, 5979, 3906, 5977, 3905, 5978, 3916, 4535, 3911, 6062, 
              3991, 6061, 3990, 4585, 3747, 5865, 5866, 6155, 6154, 5801, 
              5727, 5726, 5725, 3992, 6063, 3838, 6077, 4000, 6076, 3999, 
              3663, 5807, 5870, 5869, 3750, 4725, 3749, 5868, 5867, 4191, 
              6202, 3914, 4537, 3589, 6000, 3912, 5999, 3913, 6001, 3748, 
              4723, 4724, 4310, 6331, 4309, 4536, 4184, 6352, 4185, 4183, 
              4187, 4186, 3728, 5940, 5941, 5939, 5984, 5983, 3910, 5937, 
              5938, 5936, 3800, 5982, 3909, 5981, 3908, 4282, 6329, 4281, 
              6152, 4140, 6151, 4139, 4701, 4702, 4167, 6181, 4166, 6182, 
              3574, 3656, 5797, 5798, 5931, 5930, 3797, 5130, 5832, 5015, 
              6310, 3795, 5128, 5129, 4963, 6288, 3568, 3654, 6335, 6336, 
              6294, 4159, 6176, 4160}],
             RowBox[{"-", "7"}]],
            Annotation[#, -7, "Tooltip"]& ]}, 
          {GrayLevel[0], Opacity[0.4], 
           TagBox[
            
            TooltipBox[
             LineBox[{3570, 5711, 5710, 4273, 6248, 3966, 4564, 5713, 5712, 
              6052, 6051, 3833, 4964, 5301, 5302, 3967, 5162, 3834, 4965, 
              5662, 6337, 3655, 5663, 4566, 3968, 6053, 3969, 6180, 4165, 
              6179, 4164, 5722, 5721, 5932, 3798, 6344, 5835, 3720, 6300, 
              3907, 3739, 4789, 3740, 6303, 4304, 5016, 3721, 4703, 6153, 
              4141, 5542, 4142, 5543, 4284, 6183, 4168, 5837, 5838, 3724, 
              4704, 4705, 6270, 6271, 6269, 6273, 6272, 4305, 4307, 6330, 
              4306, 5246, 3586, 4826, 4825, 5135, 5134, 5678, 4706, 3726, 
              5842, 5841, 4169, 6184, 3805, 4413, 6295, 6311, 3839, 5918, 
              5919, 3787, 5244, 5245, 5243, 5809, 5808, 5810, 3664, 3585, 
              5733, 5732, 4001, 4237, 6325, 4236, 3751, 6304, 3920, 4301, 
              4192, 6305, 3752, 4726, 4727, 4312, 6274, 4311, 3667, 3590, 
              6186, 6187, 6185, 6189, 6188, 4144, 6162, 4145, 5813, 5814, 
              4341, 4340, 6192, 4172, 5847, 5848, 3729, 4707, 5544, 5141, 
              5142, 5138, 5140, 5139, 5247, 3604, 6291, 4287, 4286, 5687, 
              5688, 5684, 5686, 5685, 4721, 4710, 3732, 5024, 5023, 5562, 
              4173, 5033, 3743, 6200, 4189, 6198, 4188, 6199, 4709, 3731, 
              5022, 4308, 5862, 5863, 3742, 4783, 6255, 6002, 6003, 5849, 
              3730, 5949, 3810, 5947, 3809, 5948, 4170, 6190, 4171, 6191, 
              4018, 5748, 5749, 5750, 4589, 3592, 3670, 4991, 4990, 3846, 
              5189, 5735, 4983, 4982, 4981, 3843, 6070, 6071, 6069, 3997, 
              4586, 3996, 6075, 3998, 6072, 6074, 6073}],
             RowBox[{"-", "10.5`"}]],
            Annotation[#, -10.5, "Tooltip"]& ], 
           TagBox[
            
            TooltipBox[
             LineBox[{3738, 6302, 3915, 3904, 5242, 5124, 5125, 5123, 5127, 
              5126, 5161, 5121, 5122, 4813, 4814, 3567, 5241, 3900, 3965, 
              6316, 3964}],
             RowBox[{"-", "10.5`"}]],
            Annotation[#, -10.5, "Tooltip"]& ]}, 
          {GrayLevel[0], Opacity[0.4], 
           TagBox[
            
            TooltipBox[
             LineBox[{3600, 4590, 6103, 5373, 5374, 5963, 5962, 3854, 6253, 
              6254, 5757, 5758, 5759, 4608, 5766, 5765, 6113, 4046, 6348, 
              5850, 5851, 5852, 4711, 4712, 4190, 4800, 4801, 4370, 3684, 
              6201, 5567, 5248, 5249, 5953, 5952, 3815, 6007, 6008, 6004, 
              6006, 6005, 3621, 6010, 6011, 6009, 6013, 6012, 3816, 4877, 
              4995, 4996, 3685, 6115, 6116, 6114, 6118, 6117, 3863, 6105, 
              6106, 5760, 5761, 3605, 3678, 5820, 5821, 5398, 5400, 5399, 
              3855, 5375, 4019, 4852, 5751, 4358, 4357, 4796, 4797, 4445, 
              4444, 3593, 5817, 5816, 6163, 5815, 5887, 5886, 3770, 4238, 
              6221, 6222, 5943, 3806, 5944, 3771, 5888, 4218, 6211, 6212, 
              5885, 3768, 4746, 3769, 5065, 5066, 4984, 5961, 5811, 5812, 
              4414, 6046, 3952, 5293, 3953, 4253, 6327, 4252, 6159, 4143, 
              6158, 6161, 6160, 4004, 6089, 4005, 5333, 3844, 5320, 5321, 
              4827, 4973, 6333, 3587, 3665, 6079, 6080, 6078, 6082, 6081, 
              3840, 6064, 6065, 5728, 5729, 3582, 5804, 5803, 5802, 6345, 
              3801, 5942, 3802, 5993, 5994, 5990, 5992, 5991, 6018, 5986, 
              5987, 5985, 5989, 5988, 3799, 5723, 5724, 3580, 5980, 3577, 
              3657, 5800, 5799, 4138, 4700, 4699, 3722, 6055, 3973, 6054, 
              3972, 4569, 6250, 4274, 6249, 6252, 6251, 3835, 5163, 5165, 
              5164, 3571, 4565, 4567}],
             RowBox[{"-", "14"}]],
            Annotation[#, -14, "Tooltip"]& ], 
           TagBox[
            TooltipBox[LineBox[{3921, 4541, 4540, 4812, 4811}],
             RowBox[{"-", "14"}]],
            Annotation[#, -14, "Tooltip"]& ]}, 
          {GrayLevel[0], Opacity[0.4], 
           TagBox[
            
            TooltipBox[
             LineBox[{3970, 4570, 4568, 5715, 5714, 4815, 4275, 5664, 3971, 
              5666, 4277, 4817, 4818, 4819, 4574, 4575, 3986, 6056, 3985, 
              6057, 4581, 6058, 5311, 5312, 5166, 5168, 5167, 5315, 4428, 
              4429, 3993, 6066, 6067, 5806, 5805, 3660, 3583, 5178, 5179, 
              4974, 4975, 6085, 6086, 6083, 4002, 6084, 4432, 5739, 5738, 
              5737, 6094, 6093, 5335, 4985, 5184, 5183, 5334, 3668, 3591, 
              5736, 4829, 6090, 6092, 6091, 6318, 6317, 5920, 5092, 4254, 
              5639, 4839, 4838, 5137, 5136, 5190, 5270, 3753, 5039, 5038, 
              5250, 3922, 6312, 5040, 5874, 5873, 3923, 6028, 6165, 6164, 
              6166, 5946, 3808, 5945, 3807, 4410, 3781, 4798, 4330, 6283, 
              4332, 5871, 5872, 3754, 4728, 4708, 4600, 4601, 4809, 4808, 
              4020, 4449, 3856, 5402, 4035, 5401, 6108, 6107, 3679, 3606, 
              5195, 5196, 4997, 4999, 6121, 6122, 6119, 4048, 6120, 4463, 
              5779, 5778, 5777, 6128, 6127, 5441, 6362, 6366, 6368, 6367, 
              5204, 6363, 6364, 6341, 6340, 5440, 3691, 3622, 6334, 5003, 
              4893, 4064, 4470, 4469, 3630, 5213, 5214, 5210, 5212, 5211, 
              3628, 4628, 4892, 4891, 4890, 4293, 4626, 4625, 5672, 4290, 
              5671, 4291, 5673, 4047, 5670, 4289, 5669, 4288, 6256, 4609, 
              4876, 4875}],
             RowBox[{"-", "17.5`"}]],
            Annotation[#, -17.5, "Tooltip"]& ]}, 
          {GrayLevel[0], Opacity[0.4], 
           TagBox[
            
            TooltipBox[
             LineBox[{3620, 4617, 6257, 6258, 5674, 4292, 5675, 4062, 5461, 
              4084, 5460, 4083, 4629, 4063, 5462, 4086, 4909, 4910, 3629, 
              4486, 3638, 5222, 5223, 5221, 5225, 5224, 3639, 4487, 4488, 
              4087, 4911, 5784, 5785, 3696, 5463, 5215, 5216, 5006, 5464, 
              5786, 6293, 5787, 6132, 6131, 5788, 5789, 4471, 5444, 4066, 
              5443, 4067, 5445, 4375, 5442, 4065, 4894, 4895, 4896, 4464, 
              5426, 5427, 5197, 3865, 4998, 3864, 5403, 5404, 4866, 5762, 
              5763, 3680, 4365, 4036, 4863, 4864, 4865, 5569, 5568, 5571, 
              4527, 4528, 4795, 4794, 3898, 6043, 3943, 6042, 3942, 6174, 
              6175, 6173, 4156, 6323, 4157, 3940, 6040, 3941, 6041, 3782, 
              4765, 4766, 4325, 6332, 4324, 3601, 4256, 6328, 4257, 4255, 
              5921, 5922, 5923, 4769, 3788, 5093, 5094, 6168, 6167, 5819, 
              5818, 6347, 4013, 6095, 5352, 5354, 5353, 3847, 4986, 3848, 
              5191, 5742, 3594, 4435, 5338, 4007, 5337, 4008, 5339, 4351, 
              5336, 4006, 4830, 4831, 4832, 4433, 5323, 4003, 5322, 5325, 
              5324, 4978, 4976, 5181, 5180, 3584, 3661, 6068, 3994, 5317, 
              3995, 4431, 4430, 5316, 5172, 5173, 5169, 5314, 5313, 6059, 
              4427, 5308, 5309, 5307, 3987, 5310, 3977, 4580, 4822, 4821, 
              4279, 5668, 3974, 5665, 4276, 4816, 5716, 3572, 4571, 4572}],
             RowBox[{"-", "21"}]],
            Annotation[#, -21, "Tooltip"]& ]}, 
          {GrayLevel[0], Opacity[0.4], 
           TagBox[
            
            TooltipBox[
             LineBox[{3975, 4576, 4573, 5718, 5717, 4820, 4278, 5667, 3976, 
              4579, 3981, 5305, 3982, 5306, 3837, 4713, 4714, 4350, 3658, 
              3578, 5170, 5171, 4969, 4970, 3659, 3581, 5174, 5175, 4971, 
              4972, 3662, 5731, 5730, 4824, 5319, 5318, 3841, 4977, 3842, 
              5182, 5330, 5329, 4434, 4835, 4834, 4833, 4009, 5340, 4352, 
              5343, 4011, 5341, 4010, 5342, 4438, 4842, 4841, 4840, 5356, 
              5355, 4353, 4593, 4594, 4437, 4436, 4591, 3671, 3595, 5743, 
              6097, 6096, 6100, 6099, 6098, 6320, 6319, 5924, 5095, 4258, 
              5640, 4854, 4853, 5144, 5143, 5192, 5271, 3755, 5042, 5041, 
              5251, 6030, 6029, 5043, 5876, 5875, 3924, 6031, 4146, 5951, 
              3812, 5950, 3811, 6223, 4239, 5083, 5084, 4729, 4193, 4313, 
              6306, 3756, 5570, 5548, 5406, 6355, 5407, 5405, 4037, 4456, 
              3866, 5425, 4049, 5424, 6124, 6123, 3686, 3612, 4465, 4466, 
              4631, 4630, 4376, 5451, 5452, 5449, 4068, 5450, 4472, 4914, 
              4913, 4912, 4088, 5465, 4383, 5468, 4090, 5466, 4089, 5467, 
              4489, 3640, 5793, 5230, 3882, 5007, 3881, 5490, 5491, 5489, 
              6135, 4103, 6349, 5825, 3704, 5826, 5488, 5010, 5229, 5228, 
              5487, 3703, 6299, 5486, 5009, 5227, 5226, 5485, 3702, 4390, 
              4719, 4718, 3880, 5484, 4101, 4926, 5792, 4647, 4085, 5677, 
              4295, 5676, 4294, 6259, 4627, 4908, 4907}],
             RowBox[{"-", "24.5`"}]],
            Annotation[#, -24.5, "Tooltip"]& ]}, 
          {GrayLevel[0], Opacity[0.4], 
           TagBox[
            
            TooltipBox[
             LineBox[{3978, 4582, 4577, 4578, 3980, 5303, 3979, 5304, 4163, 
              5559, 4411, 4412, 4302, 5017, 5018, 5019, 4715, 3723, 5836, 
              5020, 5933, 5934, 5935, 5131, 4823, 5995, 5996, 5839, 5840, 
              3725, 3917, 6019, 6020, 5958, 5960, 5959, 4339, 5997, 5998, 
              5843, 5844, 3727, 6021, 5176, 5177, 5133, 3804, 5132, 3803, 
              5560, 5561, 5021, 5845, 5846, 5327, 5328, 5326, 6088, 6087, 
              3666, 3588, 5185, 5186, 4987, 4989, 5347, 5348, 5344, 5346, 
              5345, 4441, 3597, 4845, 4844, 5360, 5359, 4354, 4597, 4598, 
              4440, 4439, 4592, 3672, 3596, 5744, 4843, 5358, 5357, 3851, 
              5377, 4023, 6104, 4022, 5546, 5547, 5545, 4147, 5642, 4259, 
              5641, 5925, 4554, 3954, 4805, 4806, 4553, 6357, 4552, 6338, 
              4992, 3675, 5752, 4994, 4993, 4855, 4021, 6226, 6227, 6224, 
              4240, 6225, 3772, 5890, 5889, 6045, 6044, 6264, 5598, 5599, 
              5067, 5891, 3773, 4731, 4732, 4220, 5597, 4219, 6213, 3681, 
              3607, 4457, 4458, 4194, 4730, 4371, 4372, 5767, 4879, 4050, 
              5428, 3870, 5447, 5448, 5446, 6130, 6129, 3692, 3623, 4473, 
              4474, 4651, 4650, 4384, 5475, 5476, 5472, 5474, 5473, 4490, 
              3642, 4934, 4933, 6137, 6136, 5493, 5011, 5232, 5231, 5492, 
              3705, 3641, 5794, 4932, 5029, 5028, 5861, 6321, 5860, 5030, 
              5566, 5565, 5564, 5159, 3832, 5160, 5234, 5233, 6027, 3736, 
              5859, 5858, 6017, 6016, 3831, 5969, 5970, 5966, 5968, 5967, 
              6026, 3735, 5857, 5856, 6015, 6014, 3829, 5157, 3830, 5158, 
              5855, 3734, 4720, 5854, 5853, 5027, 4177, 4349, 3651, 5563, 
              4174, 4929, 4928, 4927, 4102, 4649, 4648, 4931, 4930}],
             RowBox[{"-", "28"}]],
            Annotation[#, -28, "Tooltip"]& ]}, 
          {GrayLevel[0], Opacity[0.4], 
           TagBox[
            
            TooltipBox[
             LineBox[{3744, 5864, 3919, 4539, 4538, 4426, 5829, 5828, 5014, 
              3889, 6024, 6025, 6022, 3918, 6023, 3733, 6194, 4175, 6193, 
              4176, 4717, 4716, 5026, 5025}],
             RowBox[{"-", "31.5`"}]],
            Annotation[#, -31.5, "Tooltip"]& ], 
           TagBox[
            
            TooltipBox[
             LineBox[{3988, 6060, 3989, 4534, 4533, 3573, 4968, 4967, 4966, 
              3836, 5974, 5975, 5973, 3903, 3718, 6178, 4161, 6177, 4162, 
              6265, 6266, 6268, 6267, 4303, 4781, 4280}],
             RowBox[{"-", "31.5`"}]],
            Annotation[#, -31.5, "Tooltip"]& ], 
           TagBox[
            
            TooltipBox[
             LineBox[{4285, 4782, 4587, 3741, 5031, 5032, 6157, 6156, 5734, 
              4980, 6356, 4979, 4828, 5332, 5331, 3845, 4988, 5188, 5187, 
              5349, 4443, 3599, 4848, 4847, 5366, 5365, 4355, 4599, 3849, 
              4442, 4596, 4595, 3673, 3598, 5745, 4846, 5362, 5361, 3852, 
              5380, 4025, 5378, 4024, 4360, 4359, 5383, 4026, 5376, 5382, 
              5381, 5643, 3608, 6032, 3925, 5252, 3926, 5294, 3956, 6047, 
              3955, 6277, 6278, 6275, 4316, 6276, 4328, 5693, 4329, 5694, 
              4315, 4799, 4314, 4790, 4415, 5286, 5287, 5285, 5284, 6033, 
              3927, 6313, 5085, 3783, 5902, 6353, 4197, 6203, 5877, 5878, 
              4733, 3757, 4734, 4735, 4792, 4791, 4405, 4406, 4317, 5689, 
              4318, 5690, 4196, 5572, 4195, 5573, 4618, 4467, 3624, 4897, 
              4878, 4069, 5453, 4377, 4378, 5780, 4899, 4070, 5454, 3875, 
              5470, 5471, 5469, 6134, 6133, 3697, 3631, 4915, 4491, 3883, 
              4667, 4391, 5500, 5501, 5497, 5499, 5498, 4504, 3652, 5235, 
              5827, 5236, 5012, 3890, 5521, 5522, 5520, 6143, 4122, 6350, 
              5830, 5831, 6171, 6172, 5037, 5036, 3745, 4722, 5035, 5034}],
             RowBox[{"-", "31.5`"}]],
            Annotation[#, -31.5, "Tooltip"]& ]}, 
          {GrayLevel[0], Opacity[0.4], 
           TagBox[
            
            TooltipBox[
             LineBox[{4012, 4588, 3669, 5741, 5740, 4837, 5351, 5350, 3850, 
              5367, 5368, 5363, 6102, 6101, 3674, 5747, 5746, 4850, 4014, 
              5369, 3853, 5386, 4028, 5384, 4027, 4362, 4361, 5388, 4030, 
              5379, 4029, 5387, 4450, 3609, 4867, 4260, 5097, 5099, 5100, 
              4602, 3789, 5096, 4416, 3814, 4770, 3813, 5194, 3858, 5193, 
              3857, 5600, 4222, 5068, 5069, 4747, 4221, 4750, 4751, 4336, 
              4749, 4748, 6215, 3613, 5769, 5768, 5905, 5904, 3784, 5903, 
              6229, 6228, 5623, 6214, 4223, 6354, 5892, 4150, 6322, 4151, 
              6169, 5550, 4881, 4051, 5429, 3871, 4632, 3872, 4468, 4636, 
              4635, 4475, 4917, 4916, 4898, 4091, 5477, 4385, 4386, 5790, 
              4919, 4092, 5478, 3884, 5496, 4105, 5494, 4104, 6138, 3706, 
              3643, 5795, 4936, 5503, 5502, 3891, 5525, 5526, 5523, 4123, 
              6144, 3712, 4945, 4944}],
             RowBox[{"-", "35"}]],
            Annotation[#, -35, "Tooltip"]& ]}, 
          {GrayLevel[0], Opacity[0.4], 
           TagBox[
            
            TooltipBox[
             LineBox[{4125, 5524, 4126, 5528, 4397, 5527, 4124, 4935, 4946, 
              4947, 4505, 5509, 4107, 5495, 4108, 5510, 4392, 5506, 4106, 
              4918, 4937, 3644, 4492, 4655, 4656, 4476, 3877, 4652, 3876, 
              5456, 5457, 4902, 5781, 4380, 4379, 5455, 4071, 4880, 4900, 
              5770, 3625, 5574, 5578, 5238, 5239, 5237, 3899, 5240, 5893, 
              5072, 3945, 5273, 4158, 5272, 3944, 5070, 5071, 6230, 6231, 
              5906, 5907, 5908, 4767, 4768, 4327, 6281, 4326, 6282, 3614, 
              5650, 5645, 5646, 5644, 4261, 4772, 4771, 5927, 5926, 5647, 
              5649, 6309, 5648, 4148, 5098, 4149, 5549, 4038, 6109, 6110, 
              5410, 5409, 3859, 4603, 3860, 4451, 4868, 3610, 4452, 5390, 
              5391, 5385, 4032, 5392, 4363, 5389, 4031, 4849, 4856, 4857, 
              4446, 5371, 4016, 5364, 4017, 5372, 4356, 5370, 4015, 4836, 
              4851}],
             RowBox[{"-", "38.5`"}]],
            Annotation[#, -38.5, "Tooltip"]& ]}, 
          {GrayLevel[0], Opacity[0.4], 
           TagBox[
            
            TooltipBox[
             LineBox[{3603, 5754, 4860, 5396, 5395, 4364, 4606, 4607, 4448, 
              4447, 4604, 3676, 3602, 5753, 4859, 5394, 5393, 3861, 5413, 
              4040, 5411, 4039, 4367, 4366, 5416, 4041, 5408, 5415, 5414, 
              5651, 3616, 6034, 3928, 5253, 3929, 5295, 3958, 6048, 3957, 
              6280, 4320, 6279, 4319, 4736, 4198, 6243, 4262, 6240, 6242, 
              6241, 4417, 5289, 3758, 6307, 5288, 6036, 6035, 6039, 6038, 
              6037, 5086, 6314, 5909, 5087, 6315, 3932, 5254, 5255, 5049, 
              3760, 4529, 3759, 5047, 5048, 5044, 5575, 5045, 5046, 4633, 
              4634, 4200, 5576, 4199, 5577, 4637, 4477, 3632, 4920, 4901, 
              4093, 5479, 4387, 4388, 5791, 4922, 4094, 5480, 3885, 5507, 
              5508, 5504, 6140, 6139, 3707, 3645, 4506, 4507, 4683, 4682, 
              4398, 5533, 5534, 5532, 6147, 6146}],
             RowBox[{"-", "42"}]],
            Annotation[#, -42, "Tooltip"]& ]}, 
          {GrayLevel[0], Opacity[0.4], 
           TagBox[
            
            TooltipBox[
             LineBox[{4033, 4605, 3677, 5756, 5755, 4862, 4034, 5397, 3862, 
              4453, 4869, 4858, 4042, 5417, 4368, 5420, 4043, 5412, 5419, 
              5418, 5697, 3617, 5773, 5774, 6245, 6244, 4263, 4611, 4610, 
              5102, 5101, 4418, 3818, 4556, 3817, 5200, 5201, 5198, 3867, 
              5199, 3946, 5274, 5276, 5275, 3931, 4752, 3930, 4542, 4544, 
              4543, 3687, 3615, 4342, 4241, 5910, 5911, 5912, 4754, 3785, 
              5604, 5605, 5602, 4226, 5603, 6351, 4152, 6170, 5551, 5553, 
              5552, 4903, 4480, 4072, 4638, 3878, 4653, 4654, 4482, 4481, 
              4661, 4493, 3646, 4938, 4921, 4109, 5513, 4393, 5515, 4112, 
              5505, 4111, 4508, 3892, 5531, 4128, 5529, 4127, 6145, 3713, 
              4949, 4948}],
             RowBox[{"-", "45.5`"}]],
            Annotation[#, -45.5, "Tooltip"]& ]}, 
          {GrayLevel[0], Opacity[0.4], 
           TagBox[
            
            TooltipBox[
             LineBox[{4131, 5530, 5536, 5535, 4399, 4685, 4686, 4510, 4509, 
              3647, 3708, 6141, 6142, 5511, 4110, 5514, 3886, 4494, 4097, 
              4483, 4098, 4662, 4389, 4658, 4659, 4479, 5579, 4478, 3626, 
              3693, 6216, 4224, 5601, 4225, 4740, 4739, 3775, 5073, 4228, 
              5897, 5898, 5899, 4755, 3776, 4753, 5896, 5895, 5894, 4227, 
              4409, 3774, 6233, 4242, 6232, 6235, 6234, 4052, 4882, 5001, 
              5002, 5771, 5772, 5000, 6339, 6361, 6360, 4555, 6359, 3959, 
              4774, 3960, 5653, 4265, 5652, 4264, 4619, 4054, 4802, 4331, 
              5696, 4333, 5430, 4053, 4773, 4810, 6286, 6287, 5704, 4337, 
              5699, 5698, 5203, 5202, 5421, 6112, 6111, 4871, 5764, 3611, 
              3682, 4612, 4454, 4455, 4615, 4614, 4369, 5422, 5423, 4861, 
              4872}],
             RowBox[{"-", "49"}]],
            Annotation[#, -49, "Tooltip"]& ]}, 
          {GrayLevel[0], Opacity[0.4], 
           TagBox[
            
            TooltipBox[
             LineBox[{4044, 4613, 3683, 4874, 4873, 4462, 4045, 4460, 4459, 
              4884, 4883, 4870, 4057, 5435, 4373, 4620, 4621, 4297, 5654, 
              4296, 5679, 5681, 5680, 6297, 6296, 5822, 6261, 6260, 4056, 
              5431, 4055, 5432, 4545, 3790, 5103, 4266, 5104, 5105, 5106, 
              4775, 3791, 5928, 5145, 3820, 5954, 3819, 5290, 5291, 5088, 
              5913, 5260, 3934, 5257, 5259, 5258, 6236, 5624, 5625, 5586, 
              6205, 4208, 5587, 4206, 4741, 5880, 5055, 4207, 5585, 4201, 
              6204, 4202, 5580, 4096, 4737, 4095, 4657, 3698, 3633, 4495, 
              4496, 4670, 4669, 4394, 5517, 4116, 5512, 4115, 5516, 4511, 
              4512, 4130, 4513, 4129, 4684, 3714, 4951, 4950}],
             RowBox[{"-", "52.5`"}]],
            Annotation[#, -52.5, "Tooltip"]& ]}, 
          {GrayLevel[0], Opacity[0.4], 
           TagBox[
            
            TooltipBox[
             LineBox[{3618, 4887, 4461, 3869, 4616, 3868, 5436, 5437, 5433, 
              6126, 6125, 3688, 4886, 4885, 5658, 4058, 5656, 5657, 5655, 
              4267, 4344, 4343, 5256, 3933, 5050, 5052, 3762, 5296, 3761, 
              5583, 5584, 5582, 4205, 5692, 4323, 5691, 4322, 4408, 4407, 
              4793, 4321, 4785, 4784, 5682, 5148, 5149, 5146, 3821, 5147, 
              4244, 5627, 4245, 5628, 4209, 5588, 6207, 6206, 3763, 4660, 
              3764, 5879, 5054, 4203, 5581, 4099, 4663, 4497, 4498, 4114, 
              4502, 4113, 4668, 3709, 3648, 5796, 4940, 5519, 5518, 3893, 
              4687, 3894, 4514, 4689, 4688}],
             RowBox[{"-", "56"}]],
            Annotation[#, -56, "Tooltip"]& ]}, 
          {GrayLevel[0], Opacity[0.4], 
           TagBox[
            
            TooltipBox[
             LineBox[{4059, 4624, 3690, 5775, 4374, 4061, 5434, 4060, 5439, 
              5438, 5702, 5701, 5783, 5782, 4905, 5706, 5705, 4268, 5695, 
              5107, 5108, 4622, 3792, 4419, 4420, 4560, 4559, 3822, 5205, 
              3874, 5051, 3873, 5610, 5611, 5074, 5075, 4738, 4204, 5609, 
              4229, 5606, 5608, 5607, 5617, 3634, 4924, 4923, 5150, 5956, 
              5955, 5089, 5915, 6237, 4243, 6326, 5914, 5626, 5079, 5614, 
              5613, 4153, 5053, 4154, 5554, 4925, 4501, 4665, 4664, 3887, 
              4671, 3888, 4503, 4676, 4675, 4515, 4953, 4952, 4939, 4132, 
              4400, 6149, 3716, 4955, 4954}],
             RowBox[{"-", "59.5`"}]],
            Annotation[#, -59.5, "Tooltip"]& ]}, 
          {GrayLevel[0], Opacity[0.4], 
           TagBox[
            
            TooltipBox[
             LineBox[{3653, 3715, 6148, 6150, 5537, 5540, 5539, 3895, 4677, 
              4120, 4519, 4941, 4396, 4395, 4673, 4118, 4500, 5589, 4499, 
              3635, 3699, 6217, 6218, 5612, 4230, 4744, 6308, 4743, 5901, 
              5900, 5080, 5616, 5615, 5683, 5277, 5278, 5076, 5077, 5078, 
              4246, 5629, 4247, 5630, 4073, 4904, 5005, 6292, 3627, 3694, 
              5004, 6342, 6365, 4557, 6358, 4558, 4777, 4776, 3961, 4561, 
              5111, 5109, 4269, 5659, 4076, 4803, 4804, 4334, 5700, 6285, 
              6284, 4074, 4807, 4075, 4639, 4338, 5707, 4335, 5703, 5208, 
              5209, 5206, 5207, 4889, 5776, 3619, 3689, 4623}],
             RowBox[{"-", "63"}]],
            Annotation[#, -63, "Tooltip"]& ]}, 
          {GrayLevel[0], Opacity[0.4], 
           TagBox[
            
            TooltipBox[
             LineBox[{4134, 5538, 4135, 5541, 4401, 4690, 4691, 4518, 4957, 
              4516, 3649, 3710, 4672, 4117, 4742, 4119, 5590, 4211, 6208, 
              4210, 5591, 4214, 5064, 5884, 4745, 4213, 5593, 4215, 6209, 
              5592, 5632, 5631, 6238, 5264, 5265, 5263, 3937, 5266, 5916, 
              5090, 3951, 5292, 3823, 5957, 3824, 5151, 5929, 3794, 4778, 
              5115, 5114, 5113, 4270, 5112, 3793, 4546, 5458, 4077, 5110, 
              4078, 6262, 6263, 5824, 6298, 4788, 4300, 4786, 4298, 4641, 
              4299, 4644, 4643, 4381, 5459, 4080, 4888, 4906}],
             RowBox[{"-", "66.5`"}]],
            Annotation[#, -66.5, "Tooltip"]& ]}, 
          {GrayLevel[0], Opacity[0.4], 
           TagBox[
            
            TooltipBox[
             LineBox[{4079, 4640, 3695, 5660, 4382, 4082, 4787, 4081, 4642, 
              4271, 4779, 6343, 5823, 4345, 3935, 5056, 5058, 5059, 5298, 
              5297, 3765, 5881, 5269, 3938, 5267, 3939, 4550, 4549, 3767, 
              5063, 5062, 5262, 5261, 5555, 5155, 5156, 5152, 5154, 5153, 
              6239, 4250, 5635, 5637, 5636, 4217, 5595, 4216, 6210, 3766, 
              4674, 5883, 5882, 5061, 4212, 4679, 4678, 4520, 4958, 4956, 
              4517, 4133, 4402, 3717, 4960, 4959}],
             RowBox[{"-", "70"}]],
            Annotation[#, -70, "Tooltip"]& ]}, 
          {GrayLevel[0], Opacity[0.4], 
           TagBox[
            
            TooltipBox[
             LineBox[{3637, 6246, 6247, 5661, 4272, 4646, 4645, 5117, 5116, 
              4424, 3826, 4562, 3825, 5218, 5219, 5057, 3879, 5217, 3947, 
              5268, 3948, 5279, 3936, 4757, 4758, 4548, 4547, 4551, 3700, 
              3636, 5634, 4248, 5633, 4249, 4762, 4761, 3786, 5917, 5618, 
              4233, 5594, 4232, 5556, 4155, 5060, 5558, 5557, 4942, 4523, 
              4121, 4680, 3896, 4692, 4693, 4525, 4524, 4695}],
             RowBox[{"-", "73.5`"}]],
            Annotation[#, -73.5, "Tooltip"]& ]}, 
          {GrayLevel[0], Opacity[0.4], 
           TagBox[
            
            TooltipBox[
             LineBox[{4136, 4526, 4137, 4696, 4403, 4694, 3897, 4681, 4522, 
              4943, 3650, 3711, 5013, 4231, 5081, 5082, 3778, 4531, 3779, 
              5621, 5622, 5620, 4235, 4764, 4763, 3780, 4759, 4760, 4234, 
              5619, 6220, 6219, 3777, 5638, 5482, 5483, 5481, 4100, 5008, 
              3701, 4421, 6049, 4422, 3962, 4423, 5118, 5119, 5300, 5299, 
              4484, 4485, 4425, 3828, 4780, 4346}],
             RowBox[{"-", "77"}]],
            Annotation[#, -77, "Tooltip"]& ]}, 
          {GrayLevel[0], Opacity[0.4], 
           TagBox[
            
            TooltipBox[
             LineBox[{3827, 6378, 6390, 6395, 5965, 5964, 5220, 6383, 5120, 
              6372, 4563, 6394, 6393, 6382, 3963, 6398, 6399, 6050, 6375, 
              4348, 4347, 6389, 4251, 6381, 5091, 6370, 4666, 6371, 5280, 
              5281, 6397, 6396, 3949, 6346, 6391, 6392, 6385, 3950, 6384, 
              5283, 5282, 6374, 4756, 6373, 4530, 6377, 5596, 6386, 6387, 
              4962, 4961, 4521, 6376, 4404, 6388, 6369, 6380, 6379}],
             RowBox[{"-", "80.5`"}]],
            
            Annotation[#, -80.5, 
             "Tooltip"]& ]}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}],
       AspectRatio->1,
       BaseStyle->{FontFamily -> "Times", FontSize -> 12},
       DisplayFunction:>Identity,
       Frame->True,
       PlotLabel->FormBox[
        "\"\[Mu]=10 \[Alpha]=0.10 \[Epsilon]=10 PIN=0.05\"", TraditionalForm],
       
       PlotRange->{{0, 50}, {0, 50}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}], {192., -192.}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyMfXVglMfzd3AvBCsJQYMFAsRJiNzc5S4XCkECFKcFWty1uAf30gLFimuR
4hrc3QuUQCkUhxZtKLwPl3x2b+aS7+/NHyzz7HP77M6O7czsbqnW3eK/zejm
5lbaw83tUyn/ytaYXqbG9NzEYS8F39jS5fqWLmVFva+Ct36qvu4v3g9WcAbH
v2EKLuf4fQRvLz+J9swKdry+JFrB1x3t2xTseD3EruDUXwlYjzPt0kvBGC+v
91UwxsvfD1YwxgsY42XtGePl7ZkVjPECxngBY7x83mpQevOY9jh1ycfrJcbr
JcbrJcbrJcbrJcbrJcbrJcbrJcbrJcbrJcbrJcbrSqdpz6MepywxXsAYL38v
WMEYL2CMl7VnjJe3Z1YwxgsY4wWM8XK+q0Hp8WHadOrlMi5er0s+v75ifn3F
/PqK+fUV8+sr5tdXzK+vmF9fMb++Yn5d5UzafOjlMm9yXIBlifECxngBY7ys
PWO8vB2zgjFewBgvYIyXy80alJ4cTVvOeLnQpZw3OS7+vi45PQcLeg4W9Bws
6DlY0HOwoOdgQc/Barzp6Ym05aiXC99JupTzJscFWJYYL2vPGC9vz6xgjBcw
xgsY4+V6rwalpwfT1hNeLnJF8p2kSzlvclyAZYnx8vbMCsZ4AWO8gDFertdr
UHp6Pm096CXorKyLXJF8J+lSzpscF2vPqWTyyoCZvDJgJq8MmMkrZbfUELC2
Y9LW814uekHKTSlXJN9JupTzJsfF29Mll1dmIa/MQl6Z1XjTs9PStmO8XPSe
1AtSbkq5IvlO0qWcNzkuwLLEeAFjvIAxXg5rOzRtO83LRa9LvSf1gpSbUq5I
vpN0KedNjguwLDFewBgf18vS7vRysVOkHpd6TuoBKSelHJF8JulQzpMcB2A3
9iftZGlHSjtL2iFST0s9JuW8lINSTkg+knRWg75wwIGq7OoYVzVVfm88LnOs
uiq3fWqvWZQqHe+9JlU6mk20qPJTs2XGWVWZMt73JpTAHOCU8RZS76X0v5SC
HdVFY4n/voZLu2hHlmgvvecp7fm4PJf1rF/5/Yj124BRD7yiHjDqgWfUA0Y9
8I56wKjHPKAeMGv/NfH2X5OqBz7/N969XPDG8VQ2XTzJEvgBDHwAxvgBY7yA
MT72PugO3zHojvUD9GjUY7xyfHI8sn/oN/oHGP0DjP4BxvckXUk6kXiRv5d0
JulI4lH2W9KhpDOJdzlOSaeSDuU8SbxIOpZ0KudV4lHSuaRjSQeyXtIBYClX
3FL/JF9IupHzKucpbTmFdVch9R3OL/q7buKP86eXi/xK2w9RKF0653axn4IZ
3RgwowMDZvNqwGye8P5rEt+rQemNm4+jrJAzmg+53e6nYE7XZQWdlhV0V1bQ
UVkhH8squpB6WvIZ9DbHj6/Aj6/Aj9bz6c2DHCfeT2+eJB7wnfTmUeIp7XF4
ueBNjis9OpB4ThsPXi54T28epJ7ndFRD6BuNV4k3/r6/4A9/ob/8VTv/v+9x
f9BjE8pPT7dMik33OZfj2m/E5TnsI/07+ZyNV8H4c32OdjDv6dmBsD9lPZ6D
DtKzG2Gvyno8B12kZ2fCvpX1eA66Sc8uhT0s65mdbNBZenYs7GdZj+ewa/E+
Sjxn9rZTPZ5/eq1GfIyLnYznjnky1huyHs9T2gtQpZw3lIy/40NUKecJJZ47
5vtumCrlvKDE826fvtM3UpVyHlDiuaPdUbqUeGfrF8jlOF1KPKPEc8d3CutS
4hUlnju+k2RT5QxHO0EKv4BlCXw68FA01AWWJfB589P314a7wLIEPh3zQyYX
WJbApwMPHcwusCyBTwceAqJdYFkCnw70JVtdYFkCn9zu9Fd4An4Z3Rlyhuuh
YIUnhl/wu9EuYNAx8ITfge6Y3Hqt/XjAE34HumP2KfQS/IMGnhh+QXevNczk
iIEnhl/QXaKGmdwA3oBfwz5Eu8zf6bT+5c+9VD23F3MLO1XHLeV6kLfjq+q5
X7iQaE/HEdJeb5YV39FxhRQtJexqGS8y9Dr3v/oJ+1G3I+Uh6A10KNc7Uh5K
fpZ+b7k+kv2S8lLyu/Qj8/UTufC79LtKvQZ6RL3kf+m3lHoN9Il6KQ/wnOsh
C2+vsNZTUj7gueNzIXauRw17JU09l2RLh269XOhK0g2vz6LKlO95KJjbze9N
3C4G/+jfgV8x79w+8xD8X0q9Dxjvp3zXW+kTx++OVRR48eHywoDxe7zP1glY
Nxv0mjK/fkIf+wl55sfligHje3z98d4EPOG76DfokNmR0POwZxMtxH5vfA8w
vgcY85bevGBcGCf4iY+buH8D9p4BM3ltwPg+YHxf2snMbjL4Ed9F+6hH+4DR
PmC0L/VeenoN/Ivvon3Uo33AaF/6U+S8SDylpyfB/+gHw5dRz/CVBp1JOpDz
wvxIaehdyA/0A99DPfhK8o2ka0l3kg7kvEk8p6fnYz/952AMl3MGfwKGnJBy
QPK15DvJF5JOJV1JOpDzlJ7dAbkl5ZKUM7w+0IVPJF1LOpR0IudR2jm8PiBd
u1vqVak3pR6UeillPtxd1ut4Lkv0B3hj/cpfUvUPeGR2pROeZXtMnhu/T8Fr
efU+2kd7KXitourxPr6DdvE7qWdQj37K7zI73WhPfhcwxiH7KfvF9ST8gfp3
zC40vsvinJO0H1bqId6uj3ou/d+yHfk71v/pN0woufwKEHiT/pobJoZ3p3WO
XM9IuxIw8CrtRMCgY7wHuQg6Z+teJ7sNMErwHeSX5AvwIePHZC0vpV9B+oEw
nvT8CtLvw/R4Gn4F6eeRfgTpx4H9inEBDxgP02tp+A3w3NHOzWhVMrnp5Ddg
8nZZqv/GI1UvdEq1jxNS8R2U+ru6qf3Yr0uMQ65H5fymqY/xfKWdz+NKHceG
XEU9o1snvnRjfz7KDuNwbhc7kftFYT8HK5j7kSWcW/iNU+0+FV/QMOuek9+Y
v59b4Q+vMrsA41H+/0LCjnBzY3rZeJ/RhZNex/tY3+B9/vvcaj64njGr9kCn
zO+txifzQApxO8eo59/zcpk33v+yIg9C2yUsLqHyG3zEfPuK/vmK/viKvAlh
56i80VR/Qxp0xOSr8ut7qHUAYJmfyew+Qx/gfcAyD0rayTJvSNq1Ms9G2pmo
53afv4grpsMnhv5M+U4A9x+o+K6249l638mul3lO0g6XeUHSLpZ5NdIOlXkq
0i5Mj+8ZXUF/5NfrENhtTD/Cjrsbxv1qxvsYn1xXyDwnaefLPCFpV8u8G2nn
yvxS6beU6zvpN5J5dXgf45HrIpmnJdcpMs9Jrgtk3pC003k+6HtTenIY/CjX
/ZhHGefhfjZXPxfGi/cxPrnuwvsYn1znsPiOMT657mDxCGO+pF4BnjE+mUcj
+V6ud2U+pVxvS7qV+ZVy/S39fIBht8i8PLauStb2AWDYQ4zendaFMm9MrtNk
/imX+1ovujn/OektLnek3vJ1wS/7vYFfrheDVT3wi3rGt07+BtQzPnDyP3A5
r+1I4J/JmdfkkieI92FPY54A433gF+8Dv+z7sBOc7BRpZ0i9L+0SbieUdcG3
1FOcz/xc8kdRD3yjHvhGPfCNeuAb9cA315vanyLlgIy7Av+oBx4BA9+sfQOf
0o7jdom087xc7CDOJ6Vc8lP5/Pi45KtKvQkY+MT7wCfqgU/UA5+oBz5Zf/Jr
vgY+eX9c/XioBx2y8SRaXPz2gOEfd+B7UqyLnQO7C/UYP+r5Olrnu7Lfqzw1
nf+Kep6HpvNhUc/zzHR+LO+f1hsYP+oxftRzOVdD2Mkyj1LH12ReK8/70Xlr
zN5Z4u1it3I958P9wkY91x/+3A9jtIN1NvxBjn5MClUliys77X/hfmE/F787
YMee0JIRqoQeQj3Pf9TjAIz30A/IURnvlvqNyYkOWk866jvpkj13ilczP8hr
kYcVEKhK4I3Z24WDVL3j+cEQVTrW8V9WVyXGx/wf4eGq3vH8QaQqHfOym1Tp
6FZdqyod4/WIUSXWD+BLZv8Y603Heytd+VbCTK+r9ZK7WP/lVv5A1AN/gPm8
u4t4ZkkRn3RX/UA9nqMf+D38ijxvpBSPzxv8w+0aH55HgnjbSrt6n+cN+Kl6
5hd18nvIcXM5LH6fBl7wnOU5GOOW4wTM89P0uPk6tqQLHgADD9weLe+CF5Z3
Y8wHxgG64HSi6Qowl+/eLnhk7+f3E3Z9FRe8AXbwaQPtp02Rz9rPzdcjGg/c
P15DtSt/h/5yfJd1kbO8/lXK+uhwrJAfHtyedfJbyDxDhneV7+zH4wlOfmOZ
hyfzZCC/8Vz6lWUensybgZ5lz53yZMC3eC7jLdKPC/nO1o1O/luZVwM5zejS
KW9J+oFl3p7MF5P+YOh1+RzfZXo+UdenlzfF7PtEXc++55TXA32D59BDgJm9
65RXwfqVZFPjZ36U1+SiL/Hcgf+aukT/Zd4dl8tmjpcOrvl5gB39KahL6F2m
t5Jc8/AwfjyXcVVmry6zufjZATvGlRzE9fXKVH9LzzBll0DfQv86+ptZxw1Z
ntOpKJd6mV8q83RYOxtNqh2UeM7qoedPRan5Ab6ZveRndqln8fzXrnk/zC5a
ZFbtoMRzlIhXoB7z6WjnncUFliXiJZg/tq7Yr+MqiIdgHlGP+XT8foKYX5V3
HszlC+Qe5sEpX1DmAzL5CDl0N4zLtbu6nuVtjiIXvw2TqzVJ0Qv4Q8brAKOe
6ZM4C5/vRAuXrwUt6juQD+gX8C3zE9n877eqdjAPbL6TbKof4EPG54h3IY6Y
ZHNZNzL5t8zGv7NMx7+Yni9s5esVjAvxacTnVRxA7vPXfkvUc7/fexOzkwwY
/ZZ+QNh5kEfSzyXjOfJ70OOYt5RaD06fKl8yixon4LTtPrGPHXmLSh5VEe37
cjpHnpFhP6SMM0DBPB7hpeoxbonn9PCKcTI9gXy7OIsL3tOOe5V1eR/zwPPx
arjgjZdl07azYZ8gbzu/hpk8nhSq6BvjYXrYgCG/IDdBD6B/2LWAf/v0+/90
XBjtgW/RHosTG/MAvpDr+pR+pPqjYX8mWHi8uQHWd6/EvposQt6U5Hyu1gnu
Lna5XPcx+8z4Dr4LvmB4uYN1wg2xv1fY8077jCQdYX65Hq7C80iUf8GV7yRf
ynw5bq9WceEz7pfPoPDP4iUGDPtD2htyfQ+Y2WWnotQ84j3IbUe3ob/rWtV7
0L94Dr0KmNGrk54FLNcNgMFH4AuMAzDGB1ju24G+Y+eIGPiEPYbxAgY+AEs/
PPgFfIT+A4acBl+zfNWioTw/XPF5sJovwJAHTJ872XHge8wbmxc/M9eTdXX/
mH3USa8THORUOzW+E6jni+lPFecMUPPE/FJ39Tk1mAfUww7G+Fh+jVP+EaOD
zJHqd5gXwOg3k/91rdw+HGfldKv266XG2ZRf5bHSK2wdCju5ZxiPS8TpfBq0
D3nE7Ablp/FX/Mv0Afw+TnohTX8d+FXF6fX6XK7X2bq/rlXos9wufga2jlf9
1ufVMLse+W2jNMz83sk6TsLWmWrfm59L3Anzwuw2+EsSpf/Eg6/bJ4Wq+QGM
+QP/go7Y+gv2781oNX/M7oOdq+RtFUUP4FO2/oWfZJTOJwBf4n2mV8GnTuto
wGw9tUy/D/0NOQu9xvwNK3U80FF2t/P3DX3N9CPyP9XvAngeRVwAf9/AP48b
+Cv5iPnl61FXO1HyBc9/8eP0nF/CGt9svXMwhOeTjNL4g/6CPcTsjO52pb+Y
P0zhNUDZDcw/7LQ/Kc08VORLTdL7RBh+nPb7QB6yOIibpl+5Xwf0DLkn83zl
fkbgCfwG/IAe+brEy8WvBD5h8u9mNI/nF9ZxKeavQvxXrVNypOqDMko+QI7A
jgOemDyA3FDyxc8lboLfQ9/g94Dxe8D4PWDMF8tX7mBWchntAUZ7gNEeYLQn
7QDIdbQHGO0BRnuA0R6Po5VRcknmLaE9wGgPMNrjfjpXPAKWecBs/rA+UesC
13mU8yLxKvEi43BoPz26kPMs50niWeIJ/WawQZeSziTdyHmX8ybxLvGWXt6G
pEtJV5Iu5LzKeZF4xDgBMzlYtAJfxzv5F2F/MrvLaT0AfQN5AfvYUTr5UZnc
iwtQchyw9FMwuazO73Dn/XTT8TO2ru6p4wrS3oS+Zn42J38ry687FSX0n94f
BbnJ1o1+rvsfGX8U1vYS6jEPDH9OcWOm35Nc81AwD5DPjJ5X6jwKRifjrGJe
bOnqMcDs+4beAd1iPc/GZ9hvgMFXHF9VVD1gtA+Y8ZkBM7sJ+xxUPCBAxFsC
BL5c7R42Lqf2mJ1d2KpghicDRnuAmT8d61XEme6G8f0Td/V6BjDmDTC+x/zF
iB+j3ug3z98P4P4GP7PSF/ge3sf32O+N7wEG/lkczvi+/F56djF+z9YP6L8T
zPQu/CpO8yrnReI1PTxLv7f0i0NOQX4BduClUzTngzToVtKdpJv/a56ZPEpj
XtLbh5GeHx52O8YBPmV0a/Cp5Kv0+E7ykeQDSaf/Fx3JdQ/Gw9pzohsZB5Bx
AsmHkk8k3aZHd0zPOK2rQCeynunP/7EPRsYZmH8jPT+PU5wKMJtPJ7+ajFtB
j6bIW09Vcv160oSS5S8EyP1lJ034PvgD3wd/sO/ejObx/S91vjh+z8azyKxg
yCm0j3oH3N3O19Hd7dy+uKPrgXeGH+SbIM6BdeX0xybuv8oi/LapeSaIh+J9
+CFgn3TQ58iCXvC+zGtBPd4HveB9vo7S77N8JeUv9+D2gfHH+ALnMSXpOAbe
Z3lEhbWcYHzvpv3oLI8wzuKybmR+o8I675eNC+v8kM+VX4L7m3TeDfczFBf0
WcPFTgYds/iWkz+P+YsRD++p87aZ3Bgn9C/y+1Ucy8Llyjgr1yvxMWJ9XkPZ
mcAHj7Nl4frTie5Svheg7E/Wv1E675bJVeS1OrXP5+mxSdKV1JewT/m+WzO3
N/3MPD8C+f2QU35mzocJIq/XaR3Efh+v10mAOd3XcJHbMs8W9YAlH3I6Tc0f
S9Z8wP3M7mnbZU50IOkIdj23V/X7sp6tA15rfc/wBfnbXfv7IH9ZvYEfzCe3
b3X+P+oBS7kDuQH8MP3txCeSD1APOpF5AXgf9Wwenega9cCH7A/wwuLkK3V+
vLRbJZ9IPkV7oCO5Xpd0KNvD76UfHPMq9z3L9vB7zJO0HxgdjNP2BdsfMSl9
ugeM/uD99OhA/h50hf7h9+AL+XvGp07rThZvN+iMn6eUxeU55JiEU9r3cckT
RynPj5W/k34g+P/Z+QqGvmHnPBj6g+eDPlZxV8RlZZ4u8MfzZnVeM18/a/0H
GPFlzKvMO8Z4uHx7ZeL4To3Dd9dxcNhN/1c/oKfx/sdPf9XQ7p8m4Al6GnI+
xS4vl0ovpZUeTunvu5TvrxL5BIZdwOIsyD8ND+fruN3E17MJFp5HVljbm8wf
4ZSnIO1aGQdizxNc8wplnhGTwx4x3F5N0v4ZwPg9y7Ny8j/JuK/chyDz8Rzt
OsWBmRxI1vlvLO9AxRF1HBIws4sNfLO4GvK4nPIFMB9s3WL8DvErhn/kUSI+
Jc8tOByr8AW6c0v9w3cdvzPWNSlPcyg6Y/3qW1nRE9Y/oDPQC9rBuNB/4M3B
bh/ANydNeF9+h9mVd1K/Vyx1P27v1H0q6yNVnN3RXsfU8ddLPafsd2vadOCU
18js0KTUfYljU9cb/0bzvI/kINUeywvp6xpPBz4cw+yc6lf3t6Tw++ep9PvW
rMabovd0/Bn4xXwgrszsKj+hV9+J/Gicq52g47+Odhqk5neEhVH3T8/vpeY9
nkjdlzY+NZ5VQK8XWT5w/dR9ZjdS5SXy0NR+45Pi/OwsSr4jfs7WUyre5u5i
t0s7G3wo14toV9qh0Mdy/Yf3IT+k3SrXd3if20najpN2MDuHI8nG9ZTaN19S
6KeS3O/erIrSn3zdHaxgZgcZMLObnOphx0GPMb/gpFCulxBXMuph3wBmfIPz
i7rYXOpBF/geiws7rcN43noAn5/4EL4+Qlw9WfsFpV+N2336+8yvBXpReR4a
xnjl9+X3ADN6cKpndjvW0077ktLL22HnQch1j1wHOK2n5ffkukiuE6SdLtfX
7H30X62HU/0YTvFJvo/DX8Esr2mUPtfi/8rLlvWQAyxOW1OcF12TXOJI0IOQ
x4AhzzB+6SeV++nl+Lkc8VXfAz64neqvYMbPhbX+QT3ib2y82MdgwCwftrA+
V4H9nkwueojnV4n9AB10XA32RZr4MWDUMz8j8lGd/LhoD/iS+hb9Y/HGwlae
l19Yx5uZnM5P/PdYh6SR54t5Qj36k+Z+0SR9/xJgdp50kt5PD5jbDzaRj6Lr
IefZ+QVGPcsHWCnuEUuycTvVyb+OeWF4dsrrR730awMvzM+drNfDzL5cZuP5
Cyv1fU2AGX6kX89pvzfeZ/PptN8b9Xxdqfd7y/Gjns2vAWN8eD/luYeL/sY6
kPtnPVQ7sLdgPyNPhPu7U/l+bSWXPG7AkFfsnIUO+twQ8CfeY3LF6TwWua5g
eiy/Xrfw9b2Z7+twkn9sX5jTc2avd9LygLUToPOYUM/WKQZeJf0xuWLgFXgG
njje9T5t+B2Y3Dus1+GAmT9d7ct0V3Z1SrsFhN7X51vD/gLM7GXjd2gH9bB3
yqSup1LwXtXl3ASs//m5llVVPirkEdqBP0Huk5X9Aow8E7yPfqI9ZneE6Dx2
uX5h9zUgjz1c5ynJfIz09rmzc3+c1tXyfbaPsZneLwf6Ar072nmn8+dRsnWN
0zm3bD3t9D7LT32tYdA5vgM6B4zv4Dlbb+FcxQk6Px+lo95Dv8fkTF0rt+My
a7ygf3J/IfCOfoFvHc8Thb8mQe/vQz1gvId2GF4SLHxcTv4Z5t9J41xFvAd8
sH0K8Rpm8mWCPuclvd9BDwF20PsBmyqBZ+i/FDGg6/Ec78Gf4KC31WHKn+AY
R2Qq/rOaVOlor5ZZlcAf81sHiPzOQtp/IP1W4EOs7zHvyNsCP8CfALuTnZNi
0AH8R6AXBidYVLvoH+PLdxZObwl6PyLqGd0lChj0sFvHpyTM6GyclePtpt53
DTwx/42H9m+BLiQM+gRdMD720PYp6gGz+BrW6aCnQOEfq6v98Fy/ZVH6hvkp
0vVz6HPo4S9L0Qv5RLzNXZzXJc4tdvKTQM9x+8tH6TGp55h/0tAf6fkV0A7b
b7JRnwvgeH+PWfmzQC/pyVHQH5uv/a77mJgccNpH52ivno3PE/arOe1jc/ze
ya/B8ZhBlbAv3Jz/1H61xyYWr0A8Qp1flJrHAf+NUc/2ITr5g9BP4AHzwPzi
OKdbnZNVSskJaX+m9LN06u+DUtq96yPuafXh8s7pfGWWP5Bf+5dgj6DEOFke
ixNe8F30g++j8//feXPq3G3sG6rmgkfQofSry3MlQY+wbyQM+wP0CLnJ9Br0
KeQF5NcduZ+hlDhfrqTLPEq/K94Hf7E4Cs4zLaz1JfgAdjLjkwY6Lgi64nRW
SpzHVtKFjgCjf3gf/ZN0w94H3R3WdMToKiCQx/EQv0oOUvYm2wcIOy+NfXeQ
i7B7WWk8B33wcQar+Bj6gfgZ65dRj9+xdhBXS6MdZlcb6wDAKXq3pIJZvndA
OudK4RzRnmE8LpdZ29vAC/Qz6BX0yeRogKudyuhdnmOSoP03jnqn86slDL0N
ukN9er/De3KfLDsXS95H7BSHZOshP7MaL2DmP3R6ztYDr8W9ZH7aHmbxXKd9
m4AZvxZ2tX9Z3LOwsPP3RasSesrBH8ExvB3km49NfW+xhe8XXWzheg95CfVs
Ko6E+BFgZl85nT/O8Jlo4fItPob330PkUdxxzQfE/KJ9Fk+J1/EPR7vd4V95
xfOunPZVAUY97BmeN1NIySFZL+WclMvIi+D2ldavbH0/yk/F4bg/yIe375R/
l4LXAG4XpeEHZ/lHTvt4WD7C//AbY/5Qj3lgeQXjXPPz0/NrYr64HyvVXo0P
UfwIfc/Oj8L50h30edX/l58f45d+bwkzuyxR56VjvOz741zjP+z3/8Nvi/FL
v2Z6fk7YkWxfVFHXeBLsGSZv1TrPkq6fH+OV+6zwexknkH5z4EP6meU+KrSH
embX/g8/NvDF9pnF6/gW8AFY0o2kK+aHctpHIOM8LA/JKQ4AmO0ncoqTAJ8y
biBh2b4851b65SXM1uNJNu7PjXfdb8jO+3aKAwB/bF9d0VjOdzjHwekcdWkf
ww+MesDy3isZN2H0Bf+eU9yB0Qf2JzvFnYAvGaeQsGwfvwe+5L475q9wiosA
PyzfrGiskDuueQFcz2RxkcvMv45zUpz2z/DzGV33d+L3kMNM7znFuaUc/b/i
0oxvnfaPyrwivC/5gp235eSvgt8P+E5TrzvlSQBmet5JLzE5Br94GnkEwB9r
3xivhNEe8CXloNQTzH5zksPp3fOWZvzQ6bxw1LP1mNHetE//uR2j/Hws/+Om
xg/T07j/0CmvBHwj80Sk3QP6we8ZfY2zcn9HGnkZwDfrj5NeZfQ3TuRtON0r
wdqHnnHSw3gf+Mf7TG46nR8u5QwfTxTHR5yF4y+NcyHxfcwjx5dFted47uR3
xvxJ/x7Pm8nN59nJ7nW0K/dtTvdy2ccp7VCuh9PP40lp38dl/7S0Y1h/EgPS
zYvBfMo8Fbn/Wup5wP9XHgzmPz27g+1Pdzr/XOoNZnc46QHwoewP5Fh6dpq0
U/C+tGNk3kt6elm2lzJP+l4O1j7y7yelr7dk+2gP45ftoR5ym8txP5d92gzG
PtpTOp7nwG8afjLHvNbWJd5z4H+/lc/Hfr0OBZ8BhhyFnx0l3gN/go6YnFT7
EFLz9brblT8X404zLzu+nFq/puhPf24POJ2jje+iXdYO/LpOfiTUo13kAcBu
lnmhMq4q4zzsnJKe+twm0Jc8h0fGVR3jXKT9JCyulDmS24MP9HnA7PwXp7gp
5p/5TXbr92FvsDhrnDhHdJzOE3egJY1zzgAz+yKNcybZuT1O54wCZvorSccV
WFzO6RwF/A7ty98BRj/wfYw/vTw0lseGfPoqpEoZh5V5WcxOc4rTTk+1/2Tc
mrXndL4vfsf8C5iHt2ZVwm5ieBirzy/D+NPLIwKeZFwX+pfFfZ3OA2byYbxN
lY52g3Wcl+ER9u73UQqfGC/Ln3GKi7M85rcaLyw/5obGC+w6hqdETa+od8D7
0j/HjvkRkzW9wX+HcTI+AV6X6riko5tdNZ5Ab2w/MPJ+4E/A+QSQIzjPObP2
J7O8jTgd/2X7GmoS5xen82fZ/sWlVoUvx+PfrRzf+3R8F/TC1jfL9PlvwBOj
8wkaZnlrnbScYHScpOsZnUFPjbepfgEGvUMvsPbgz0Q8+Y6dyynkI2GfeQMN
83x2ud/3vdqfDBj0xtZZSa7n18p4s/zO/86jl/147NIPFh932tecph/WaV80
G4fT+QMsr3W3PneO0d2kUJ7vscjM5f0ikdfptJ+d8d8dO7dfQjQM/mP7MBID
eJyoo4XnI/RAHPmFCSWeO8pjnkr+AGb+mt6p98CW1nlObJ1ZRcs1macEPmJy
DOuZulae7+Ikr0EnTK46yRXAwAvkNOw81OM5+AF4Y3ydX8sjll/htD8J9AZ8
QP6g38gnAIz3MU7UQ56Cjtg6I0H7I0AHLL6YFMz1mIFfjAf4RX/57/T+K0e7
nnauB1bqeDHbtwM79UAqX/xGPH8a58NNtKv4D+jH8Xu3HCLuoO9zYfYxzo90
us+FxdVxHokb7of153JB3fP42CTvEWR+WeN7fN99bu7nNX7P1y/y/O7H4vzu
x+L87sfqnGiZT8HHF+Xyfcgpfi+jzL9wF/kW7i7rdsgLFk96rc/xhB6UfkHp
h+HnMmq/IPQQiy8k6/s6Hf2bJO/fzM3jCcY88HyJLEq+snPS3ML4utPpHHHA
6Z07y/IqjPdlXIjtSzDkNjsHGOeHZtb3laR5HqPTeWLsfNhJsS7rV+AR9YD5
/USudiDLX0I+5NholccE/KM9yAfwP+gFMMuDWaL9i4Ah9wFDXuC7oDMZp+T6
VJ/7weIIXWzcT97F1Q5C+0xuGe1z/eyrYOAXdI/vAcb3AMs8NcgpyDvQK+YJ
9SyPCe873eOD9lP4y5/Lz+saRj5LmucEO93XltK+h/oe5CrLE3I6pxcwO592
XBku7+JDFF3Kcyh5Xoqwbx6lrl8Ohyo6ZX6wRTqfU9IR5hf9YnETJ/pm+yTq
2RR9oz2Z1w/6YfsaDqfGXToFqtLRr6nVVcniBLtJ6TWULF/eKLn+8VAw7Ejk
neF9Fhc06lmeasjnSo6yvCWVV+aj8m0c476rz0Nm+QKJFi7fld1QksdHkDeV
qO/hYuvoxNLpjoudr2eMC+OEXcLyDtIYB2CMA+NCv9MbF8aBfqLf6Y0L42B4
MPqD93n/9LmWvP0C3H6W+yic8qQkHuQ9AzgPIYWPT4r7BU6a8F1Gtwn6PgGu
H/wUXQPfsM+AV7YewfkATvsYQNew32WeEqMHJxh8ArsO7aB9B58iT/aGtnsB
O8rOVuUnAOz4jlOePc9jwzlywSqfXJ7bL/2CGCfzN8rnTvsImF7br/1Fjn4u
1TDr71jXfQOAYR9jHcP8nLBHTkVxf8WpKJ5PkNWk8vchF5m97uQXdfRzdKq/
pD2pvH7Ach5h7wHG77E+xLgd8L/Ryv8BmOVrvbdx/29yEM+LczpfAOsp6QfG
OLF/AeNk668EC9cT6lySfKqEPGXtG3wM+pF8i/wofp6VjjMA5vfF+al20C7k
GuwOdi6Z0702sHel3Q+9L/UEv+fOj++raRKh8MX8TuDTPXo+AbP151idFwi9
6aAL+J3r6fkFnDJem8I3l4/5eJ4x8s4axKr1JPQKt7M8+HuGPcP9NKV4XMwp
P07WM7nulBeM76e0X5Gf/4VznOHfWluJ+5+c8sUxfyxfAef5h4er/FfwO2DI
MRb36xHL/TXIG0wDT6BriScOV0x3nNALcpyA07uHRJ4jAvsPMLuXxEmvMz0U
h3M0dN4y4z9jXOgn9DjTn4YeZ3a3AWNe5Ljk9/Ee+InnPXtzOjTaZXnPBl39
z364+fD2nO6lkfdOAGZ5/k73TkDeyHgYW4d1tnI5HK/v82X3qRjzAb3C/AgF
UvN6fiYl35l+627n66+i8nxYH7UuZ/k4Lufk6XVaeus2+GGwbkvP7wOY+Y1h
Dyu/i/b7SL+Q9BvJPCfA0m8E/KeMS6+LwSdY1/F9Mu9NzH+Qhl9J+p3kPTg8
jyeI6zHcOxIe7rJOx7zJda48T1L6saSfC/KJ3UPhtF5j9uRNDeP7cl3Nz5cM
VvZ32n4rfxe/EWB2bmOyzpNm33HyEzG6PKz9TuBf6UfCvAGWfhm+b7A0z/eH
vAReJmlY4pGtnw26ZPOTX99fDn0PeQB+l3qH3ffgpHdA3wx+p8/jwjww//47
C/fDFEqNp/U38feQb+iUZyHPEcfvYIeCfjB/jnmrLexKY/zAN1tHOq1zUqhW
+1fY+j48nMtZ3J+K810zpvJdserqnC2UoCd+7l5J7qeEvefkFwLM7AbYoTj/
yrA/2Twa9SyOhe/k1zCLwxt6k8eL9X14fD+lvq8c6wNml2G9YPQnvXEy+8oY
F74PGN9Huxg32y+Ae7Pya5j5eeLLcf+Oy7rbm8f71T3vGmZ5Hfh+QQu3Bw7q
cxkgJ5ifoLtdrbfZfMK+cDo3n+ej+os4tb+Lnz693/F9fP6KXgGjXcxDenSC
eWB0ofZ9uM4D8CzpKj2/A+aJrRed7uGR85LePLB5ctpHw+y8NOYpvXkBDL6H
HJB0BXmSQrceXJ4Y9iaTH/C/qfur9HPmXzHsx/Tacfwc9/I57YODHEK9tA9l
PhVbdyboc+/gb4FcduB/nM6/YPoR+7LG6vwXxGGxzgae2L15G8X90Y9M6neQ
5wxO43csLvF9+u2w+PhunWfE/FSPTMpehfyC/wnrWdi1DryM1rD0k+B3gFlc
NI12WHuLLdx/dUPnCcIfcj3VjnY8H6/tINh10g5i9gTWVdCnScHcD95T73uQ
9znL/afynDF2fkKVVLye0OdzyjgSi+vhHMcqpOLUgKXdnKZfI404nozzwW7m
8U/Y9e5cjql4Ie77y6H4HjDbr4p2nfax///GbWWclcWzEnR+CezXlH5lS/nd
H3q9iH6xeUvD7mP2ipPdB5jlVzjtE2f5Jci3wDmY/XV8BvoopT841yyA28dx
4p4bP381HmYXYx4Ou8bBmN2N8zcMPQO7A3YRO+8hDTsG74MPuP/8hgnyB373
NO0kQz7jPbYuxv2vd6qp+A/kDPzh8JvBvw2+hzyFfIX9Chj+HMhhyAX0i633
cQ4O4sGPTIo/mZw8EaHkFPy5DrlfT+eryLg3s4OTNSzj4MxfG5Z6ntKyYPVd
+BeZnxr36D6I5PoMcYSwMGVXA2Z8gnOA7+hzm+BvYXngWGfV1ONl8j0ugPvH
EgIUnSAuiPZgXzlKlXftxc/dOObpYp9zu0DDMi8KfAW7iPGDYRehHvzP7BeD
H3hehp/qH2B8B+Pg+ywD+LoT97eo9Yy+HwP1fH+Xn4LZ+wZd4H15Dgb6wf3s
gYqupN5j/kW1DylI0RHkIafTsmoeYA+CHiCXZf4D9BbsSJbf6GlX/AJ7DvTA
5M0dnQ+AdkAXjva72xU+If+YvWrA0q5nejoZ59p4iHsyg1QJfAJm8RXc031M
n0cAegAfMT2B+K7TPb4YJ9YRjI9el1Tt8Pwab5L6lPGH8p8VUnKayf3XOi7M
7Gb45w08Yd0AfmNx8ipaPss8fcw75DXkDOw0to4Zp+1pxCdT+EjD8Lewc3Nw
fnUXHYd0/C4pmMsHP7OS52namYt1nrajP+90fAZ6BjD0EvoN/QO9gv4CxnoB
43aU8TFKTzneC9b56oD5+UtZFAx9j3kEH4Be8D7LtzLohOFJndOCOFlpIYd9
XeJGkJP8XvaqSt6w+9txDkeTCOXfwfhYXgHymw15zPKMneYV9MvPn/LgdKDu
nSykfpfeewxW9zQEcznvdC834PTkMmAWV0kO4vuTnO6nSZsvH5vYfBp8mh5f
AgZfMj3awewSBwBdYL8Rj6dkcPG34jtMrxj6k8XJDJjZz8lBih4gVxnfYb3t
Z+bxkxsWbhcXDuJ2cOEgpU8hB1m+rCHXQUfoN9tfb/QzvXGw+U5Dz8u4OOSC
43sBep+a4/XOVoXPlH7gfNFMyl6X9/7iPTYO7KvBuUiJFm6/JGg/Ds/7LMnp
z9CD/HxWd7HeLaTWt7DL03tP+p9Z3jT85rBLJoVyfjL0G/iD+V+SNcziEE56
ATDWI5CnWPcy/VeTXNYZLE8FfKfOU0P8K5jbDep+gSrCTqui+AzyEPYfywMY
RdyedNrnj/Z5Hqm/uKdZ2yUYP8YHOcL20cH/Dv/baw2zceJeB3VeTCnOR1gX
q/PpfBU9QT6zfG0Dj4zP4S+5Gc316D6d/4p+wU50jKe+zleF/gHdga8hFyHH
uL/cX9kvzC4uWkHE7X24HWnUM7lowLBvwYewH8H3zL432gMfMzmNc1QMmMfx
fF3OzYXcBYz3WH6JU56UfA55Cjnh+Hktbc9wuZjDxY4ADHzjPfAPPz/bQ+gH
Dx6PhV/W4EeuH0uJdU1Jxf/oB9MrTutA9B98BntLxkd4PgHOiwAdvzdJmNkX
6r7NiiLvooxLXgK3l/U6meWh39X5BZBXsPOYH7WmOC94lM5rhX0J/nDgYbw+
L4DHz305PUJOKT3n+h7g9N6T/jApt4Bv5scsrM8FZeeIG3yQHp9gPPIcRyZn
cJ5dZp1vJ9ddcj0m1wfM/3pQyy3QJ/NrOsXR2LwY9Mj3UxVXeonRofLX5hP2
upd6zvxv6hyZsnx/b3w5fn4F7okGvWHfD869VPc4BPD7Md18uNw35Jy0n8B3
zI508mvw/vq56D0mD+7q/eSw72A3OIbZSdtLWEdincb2rT0yCT2n9zWDP8A/
zF/8m45DQH9C34AfoZcAc73lruYD84X5YHGTBqGKPpnfNVH4b2Fnxen8ZdAJ
5KaM97P9dQkBKi8NfMfkpPF9yEnA0GvMjoa9gvkM1/sIeH5jMD//FHadshPL
u+AJMOQmi2+r+xI8xDk/Xmq83G/jwe1ftV7y5fE93NsFvnHyq4AOIXflehz0
B9jxmbpifabyAqtwuzG/Xh/ifbfUP2Z3Gus3tp51krc8nlle2THMbsE5D8bv
ZfyRxaUSNQx+c7yXVd+by86FOKZh5F/An5zyXbPCI/f7eyu6ZXFpJzsH8obd
P6DiS4VEHq678FthH00NLo8P6zxWBiPekRAg1rP+XG8XDOD3HsZpmNvD7kIe
F1Lyh8WjEwPEuVcBaedZQ64FBHJ/c6K2pxGnhLyCHGLyC/4X3Ht3x9U+dqDj
ro/LOhjzxs7X26/5AfTL12vlxT6adOwKtX71cZlXiVfId8g/Ft90yivhdpZe
l3A5X0rxE+xAxqcqH0PzF8ujUefy5lP4xveZXhitYdgdjv501+cCwT5zdKu2
hqHnIKeZ3puo1ztoDzD4m63bF2t+Bt8xu7Gg0A8Fxf7y/MT5raaeB54/oZ8z
f/5EO/dzTNTjAX6BP8hjwMz/jn0Oyp+l7RzUO74TYqeVE6dV2bXARi1eXm/8
eXYbjYjsOvjrObHkPjP8fr27MVTtv79aUaKNQo+cHLxwSww9D1oR9Nl5nR97
vPCS1ZsI+ds1qHHiD56nr1rV79AOfod2HPP66VyrPo/J9tGmSvX801+Sjd7U
DKmTNDNGze+odz98/KKHjUxn4i/NaGqntatyRHebps8h2Vwq09RJJ23UxvtV
/Lek+4nneO/5+t5uA7xs9HOvi9NWdY6ljz8WqZ7/pY28b69q2axtDPlkChtX
bos+n7vjnry/vI+zka3P4HG/Jtsp+71cK1/66nNrUOL5yh0/X39ivHcqU5Bb
tdo2Wn1myo1T2e1kenm1698bbHTLb/TBp2VS5Y3TuSt7SoX/uXiDnWb9kv+S
uYe+7wh4BZ7RL/Sz0qghZ1+WilEl9qN/Neaf19Ytxvd6vZo1q2ZsSlnJRrNC
ppLdKU4IOi48pczsn8vb6MPSeUObfK/nwfG9CTFU3pxr78Y/bPT5x1OPuxh4
+mdz+NEyBt4ybfm88p5RMfTr1gPj1t2z0Yp2Wwc0M+al+kS3PMOMeUp+8WrX
vl426vkgcb3HYjtN2Vc79mYem1qX98vSL+ovAy9/JFVecyC7pkvQKfAEvGFc
GOeKzWeW9zPodmTnyJFVDDpe3n7R4M0bdD435PWhwiO7hTTR37V99TjjB6Mf
f+a4ePp8p1ha49nnQL1iBh3MfHyhcq9Ymtp9sTmHp03Jj7kXsnx5dKyNfqq8
a9Tq1Xa6uzfpVGR3G22qbZ2Q2xjX9ok975w2xrl1W1RC0EjDzu+2ptWjYTaK
2jfm+X+TYmhs/TVhU+/YaNzjTOs2WOwUf7yDb5afbLTvz4P9anXW68+GJ6du
NX3vqeRpl7I9uhbJV0nBHRI7ewYH6DzvJY/CV/xeJELVfxy9qmOXtjrPGfbF
1EDL2bNZbqk8j/359ydfm7PVVOvgtYpLa+pzIYG3OaW2fX5j2BVTk4Sfrr/I
bFP1/xRYd/GL5Tn5esvQEz/+XLp34Nu8yo661LVg0pOyeandmFLr+w8yqfdz
1rSe8S6v/Q/36nzZ8KpnViXX2pvc/f9z1+s10MHXgztduFWtBG1qETmh4GR9
T3bTuWHrf3+p78PM2W5J0SlnPZWdUnDTuMT4j6Hc/jPwMePeX7Um5K+sxrto
4NLy/02oTLtetRhbeJO2c9DPDQsvDqRfA5QeP7Igf7mLiwOU/P/8gn+JGq31
uXwP5pf4MGR5AFXO8TTfP9t0HvaHGmMKhF7XcWyUzd7m+nrSYB1Pa9Gl2WKv
q8Gqvc1Pqx0anj2Evt31w9A+WezC7gumAwv/fbHGpPdD0efhHyZW1fdNDhkS
2vfXLjof4dK1/rXLW8LoyZ48IW2W6bhE2Idax07VL6v6sarixNn1h+n9+ii/
Wt96VNHtEep7CQe2W4JJ30851Nd25Jee+n7KPzt8qFS3jr6f8offzrYscjmC
IlrNO/96stajoNvt2/K/PDLJrOYhsqPtXngnfQ71twv9+i/tq/O+BpSbcXGB
U3x86LtDbTu3Iro0eejJA1O1v/TQlsxjipr0eUXoz5o9Xf4eXkJ/v8vLnfdm
z9LrqCWhgXmzmSyKzma8vPY46Kk+p+n50o+rk7Lr+ObVyk2fL31g4GVLyfGP
L4hzuQw5nvHOlpN+yWb1vQE/fZl9sU3v51/f+221OXd1fkuONp/59jTs2N+W
zvtz0mF9bg7Kwhv7va64XrdfuZOPaedN3f/lZ8dOLrZXt//u0r0w9zH6XOhm
1373nTrboAv/j6PPLNfnBxyrvvHKs1mu9xP+c8rrWa4JNprQofXwrmP1uTzo
z+jTi/4uM9pGG8JrPSwaqeX5/K9mFD14OafqJ/g4b7Z5q7xq6XO6PV+u/0AD
7XSu29K2I3/R9xFivgue/27slbZ2evT497BKbhGqHnQUU2rg0EJxdvJpWvHU
7PH6/sGYmAdxFawaTwmDXz16d7co/bWh8a+rquVSJZ6f8vD79UgpO5WLaF53
9YOiNG/iDzUyG+3vOjik2+LOZSnwcrugx5nsFBH0pWni4Ur0uGmFVlcNebPo
aKYiMQbddm/65wn/07H0Y+lltc/1M9absbP3ZTJFU8YyjU7OXhREd0IjQn0z
2Ojxjpwzf/4+iG63Ln8i8kosLRi0q0eAVzBVmzl9p9VoZ3j5rZmvGO0WTvb/
e8t2XdbN+MF7Sgk7HY2b3LnduVCaNu13638GP3t77x73b1wojXn3vljSiiA6
N6FUu56nwilHg9pDgm0RqjzX9be+39SJpmoZPwx9cj+c/h6/roQ5v6GHXhRa
2+J6ON0r/2tSotGfv2e9/fO4OUKNG3g4/WaC7cmSUPp8/PrJQ4+Z6OiIqpNX
uht6t+KKX/p1NpHlxx0tg87H0unE2VmTj5rouZtX4rUt4TS3xsLMW7qYac3W
SwOqLogmzxkT/8p52eCnoLN5e31lo5sPIx/5nDJTuSsFer7IaafuHUJ3jlxn
pkf9Kz+4tSSWFt3PvjBumFnhEXjFODCuCaYShUb3M9GDv0qty2XY116Lb9TL
bHznlyNl71YwvvtyXJdz67ztdJaur2k7LZoOjHpbkBJjKffnxVqe/yZazQvm
CXgBnjBOjDvDtS8XvTlpprKlHxwmYxyrP3rf61jQTh7Xf6sfU9Om6Ah0BboB
HWEeMa8YN/AwOnFRYiWjnytzBP/Z21u3i++AzkB3oCPQFegCdIJ5xTxjnjBv
wDPwDrwATxVanP1peY9AVe5NWB0bPL+6Ksd8scC8on5V+rJ8m5N3ThSgxBv3
Q+YX86Me7T+f3poK0bcN3Qut3RJCx/uXa3/8emmaE+i3t3ztKGq4wHPH6UWF
yHv2D0H/VIylvs2+fzL+RUHqNaJTjh8WB9IvJXoOfZvBR7WL76BdfKfUroE7
/3trp1cnljY7P6eq+h3awXfRD3wX/YB8Lpd/b3Byjli6XnFT0sV3R9U5BugX
+onv4Lt4r27Lf2ev2nBU3aNOw/KOj3pZUPkbzy8s5v/KrzgtPVQ59vDWEO53
axZFTwcFvZieo7KSWw2n74wYt8hP/Y7v1/Wlrg2bHlo7Rf+O77f2p71xk9tG
769IvY8NHFgqZxTVypGtbvBprd/PZ906pv+EKAowzdv77Umig23u1Rs/U+u3
R/eozV95zdR9RZU8j3taqfQgz9Ghly30bO7zCm2McvGYxh32Gc9v5D1QybNm
DH3xqP/sV8OtdG1kycfl28TQzQc7jtu+s9KgBnV7PTWef9Z/dpYCNfVzvIc4
RvtlIcc+vA9WJZ471knjrPTH6Wk7PuuizxEu3L+g97sfbarE8/3bNjbbc92m
ytsvHsQ+/SmIap9auOXY+QDaYXpVqL9nKNX6JmrFvD/CaNzmHCO+OxxOr6cm
Pqv/n2Gv9dwQPWhJOM344d9LC7tE0qGzBc6NK2FS5Zzt/2Z/ZPCL5b+e5090
NuykqkNW3W1hps/nNWkV35/oRNGHVbo1Mauy2OeWw3mLhNDbU+t+Pjw6gEzL
px1bvySE7v/s1mxWF+0H++OPEnUtGYNpY6f3u+68iaT21670qntB76vOu7fI
tPdVDD3+94NeP26zUJf4dfPn1oqi67UCn/113kIZL/a++lOw9md+89WKe1uf
muha0KsKL1pbafOj1plXnCU6lX/Aid65rTR46KrBxRpb6OQ3jZsVqmGss4oe
Djm5xUKFB5rvHugYQ5+drkujl1uo375xSR9+M9brHpUn3ShqpcSoYs3WvTDW
S6/Gh7T9ykplInc+7d/8mbo/D/6QuJAKCaNXuVPBZ9+F/HxJnzOE53gP/NN8
3+8JVcN0XlTJOqu62ov7UXSx9U0WLI5Q/qi3Z88FW2ro+6CmtR3375u1+j68
Hkkb8g55rvNdql7dOe9qbX0+Adq/WjBPocv1qlGNquWb7/8jQtXjO/ju3vb1
i3bOrO9lAH/U2hU6oPd/URRY6fHHi2/0fXuwn9YVGtHkfQkz/fjnXz6Vcup7
eFC/ss+dxXuHWKjkBpp1q5y+zwh+sYGD+9R9MFmf+zPr2LWWJQtGU5v3dUzW
n1zPN0hatKFT1hgrdezVKaT+Nf0cdlnzjm+enFtvpfy195Z7NMOu+Co8o9fd
r8/E8riwYU+evrBq5YNO+v6wOfubRTeK0vOEeUta0a/C7vyBNGXjAY83vf8x
nQp4d/hk0SB6RrH2n4u/Mk38b5R7jGc1yt6pd6t/jv5r8n5Tp0TCF9XozCS3
XPMbJZsKryu+etbOGIoZk3N5de/81H7n/at7WsTStOtVCyYO9aTsO4Lr54u1
0qQDk3Z4XSlJX8ZN++psAyutPL5j+J41pampZU3vYw+N8Y/t1bdzf2/qWf/y
Tc+psfSkxAhTxp+8qXf9R769yUpjdo7tGHWzPNnMy7LmahtLUbUrmfpUrKj6
jXGg3xjHEvs4n7m2KArpfH5n4uRA+s32ZtnJNVFUYUf2JoH1Aylv8b6VK5Wx
kmX0kKELfgugZ81WbK4XHUtXNo+vebxBoBo38IBxAw/vZwac7WwPpyu1Fq72
3lyNfiuwfF/lbLG0uXztkc0+q0bJ+QsvHLXEQuO+6HO+8vTq1H3T4G2HvKJp
4864UrPzVqfkhhNnBRhyuO2YM/Ppp+o0bOC2tTteW2lr347N3j4Jo99+3vhu
dukY+nhpXMThDtXp+Lt/Ah7tsNPOiAHjS2SvrsaFcWJcGGeL4ZMKdjsXQssL
bGyR4XUk/fiwU7lszc30tteOK9WbmqhtrkKD+42y0lfhvSYWiI+i7ovr3Jw5
y0rvu50uOSEiiorY3s6cGxJDC75dPrtgmSiqEvtzvuwX7LS8dLuOi45HUuzD
Ce3eUHWqEdX46sGNRPNX9R7erFg05U6o9CykgZkaD7Bu+e7raGr5zw9ur6qb
acO1drXMHjGU3GnizAu7iUY+etnuijGe8CZni9t+MOTxrfhLHY7a6VAHU51b
NcwKb8Aj8AY8Ftt0+1U3Q44Geo8sMdyQq183Ng/pFRRFa3LGeQ2+YKFsE6tW
+/GOlS5UjFpSomY0hZS8Me30YzsN2+h2/etpFkWXoFPQJegUdAc6BJ2AbjBv
mEfMG+YReAWegVfg+ah5cUm7Idcfjw+2TTXk/Ovd1Se2nkqU03Ko17xnVpoX
W7FA3g0xlKvM7WEP71tp9LP7X4z+O4b65yuyecApK7X4NseOHQ1iKcyr38we
+62KD8GX4CvwGegIdIV5xTxfbpUt4AtjXiaeufPX1iIx9DB/Lfdthl75rPnv
wRkMPfN3yeWLXi6zUECFR8MbdIpRfA6+B9+Cj8Gn4NuCl6e1CKsTSOdOLPH1
jNF8Ar4BXYPOQWegO9AJ6AZ0Arq56NUm8uNUC403rLfOxjw/XPfxfCFDz332
btqblobegx0BuwJ2A+yI1n1vtvyvZCS9nFPuRamHUZS/w8y+Hw074Xjc1W+2
GnbDyOt/drF8shO65Nx60bAbti8tVari42jKEBrTcddZg84mPhjuvSQfZbVk
Gvzmyh0TSjzPXmfZ/qBNQdT3r3Vj6n1Xgjragxd8rBZEy4pdGvThVnGqnHt0
pxMnQqhJkZxXfvixDK2c+/e85G8C6G6LKqeLFqhIld5FFz5ZOoQGhHvWu32l
HIXGedRfPSiWgmzDs4bMLUGn+p4bu2Z0LFW7bvPeWLi8+g6+i+/gu2gX38F3
0Q98B9/Fd/BdfAff/dhv/qMn7X9T++Sq52kz0sNP5wEgbpyt3tQOedqXo0VV
M9SNmqDPNYH/t36b7B3bjyhN2Zdf8+rTW59rgvc2F20fGD1Bv4ff4b0HrboW
XN5bn3O2bF/f8plWXzEVm9prWNLIALJcy7LUp3AIZWy67OKZjgHk/exRnf7L
Q5TfkOVPG3YI7JK535WJ+MmwO3M2uL6yr2GHwj9TtOauht+PCaWnDxbmmGLY
nc0PNerXcUm4zhNvfuvXu9kjaEuGMZOL9TXT1pkBbU9NjaTQaWP+eF3dkI+/
eWSnSURf/2I6lONJNBX2KjqoX3ZtR8CuWPrvVw/25db3G+J5wfDJeSqusVDj
nz7kKPkkhobcnVqlg8lKD7v1ueh+wfV+yVoBw+wFe+vneA/P8V6j3oN//2Fx
iJo32FEVpg7aceFKNWXf3s4x98a7RuHU/XrDgVcr6PPCUOI57KiSVeM25Fih
Szy/8GGnLT6LzleBnTR3xdjRzQ27qW7HDhfz9nC9HxLPO08bf3vIyWhVXs0y
ZfTva230vnapVeVLxtBPH35e8lmfaKrfeXCzQYac+KVGLq+QhtHU92NC9gLz
LGQunelsWKSN3k35PWF5Yyt98+U/7xuVtNHdcP9a1b8x1lE3KlTcuUKXmIeg
pclrf9tlyO1hmyZ9HW2lKsdiNq6caazDXvwy+stxdmqxsM+B8KI2+qF4xjo5
t9hpR7vve9XPruNgB7zKZyp2w0pYd4JuwUfgK9B344DY0klhOSj544/PRues
Tg1rnF/uEZVZzc/i0HV/3rmUldq/Lvbr6somqjHoQuL5G09NHcL/69pzHtGL
Mn8M3nQrE/UuNiHnn4Y8/2lOlQvLN380YR6Obhu0anO5HHS4180Rg/taaVPr
7Pkr3f9gGua28odLRQ098cvN7i3WZ6CROZLORO6MUf09fyxzjulNsV54b8K6
btibh3Mq+GdT9nfOugW9R5wrRCPKHLJNv6jvo7Qf+uP0wzN6H9Tiar2/mtRH
39O0w3/ofc9y2s71PpGwdXZDfa7r6Vdt3QvU0Pf+NP5ha9Ozf+nzfYA34BHr
BcvJc1emJ1WmEzULH5rqp/MHCrzJ/nJD1ufqPJ9xs7J8/HL/NXVez71albr+
2rcIBWX3nV7FI/XcVDcPylz6Vq+Btf2V/R02tlqg9Yj+Dn6PdT7aR37BzHIN
vnh9xZ+qnVlW5N8O+h6v+jfbvffc6Xpf5ZOnW20Vz/rTT4c/a9KjuL6HCvy9
eML5Y2vv+FOLCpNnRnweo36P+bm8p3Hkz57+NN7H+vrlu9fqvCHIr9tvugd9
0zyIklYfscw6qu9VA72Ym43P3eucPo8odnvG+aH3Ayn38N/6Ljscrd5Hf3+p
uXTL0Z7BlHS9wahNTvdeob/lPpzJeGdIMHn+W61Did/1fZOz/nm/wreYPocR
/b9f/ePXG98GKT4AX2De4beB3oE82+Sea2/1/voeM/TP9vLh3SWVQ2nzM989
0ZVsLv6MOg3zeI+qpvcvHJkXPmXr1GqKn0eM3JdlXfMwxYfgyxLXvyjg4RbM
z1MK0etY8MfbSY2HeH2pz1N6ffdUqfOTwqmLT607zRe73r9oqzPq60b9ItS6
Md+3l8OOtQ2nt3leVu76net9i1Wy7lloHRqh1pdXI2ZtyHC7Op1cfnJ6hRh9
3+L9ybd3Dssa43LfYsMg7wLFK+v7FKOm7ux545tIJWcgdyBnIHcSey+kjzNu
uZzntNUnvPCiW1E0Nt+9PfWq6PsWm7Rcc9d/b3Xl90K/sK4HfqrVHX5jQiV9
TvOgucN6h+Qy0YOsp1/d/NL1/sTktsXNR17q86DmFfytftu5UXS1TvYR5Tro
+xPvn2208+4D1/sTu/Q7PKrcehM1ODJtwaAV+v5E4KPBiLgzc5qR8ptUXLly
YmAls5Kr4BvIXchh8BHqF09esCtudKDIQwtUfPjPyY5Nt67W9xeOuxrQulmh
CPV72Ac180/PUPGDjkv9HnT8Q9f8ZrIsnzbx0B9WKt7yY7tB9cx0+Uufh9+6
2/nvjfEW/yfn6/05LYrei+07tO4vw+4+vn9GfEDmWPV9jH97M49TK0+bld6A
HoGcAt32yTLtQsG5rvcVQu6Bz+8nnzvS9ICWG/g98AE5A75F/bWK1vX3X7ve
Vwi+B9/g/Wm2z6pXfKrvJwQe4AcCvZw1730R+shCXUyjJn+2LYZqvH7R4VBZ
fT/hRN+t4a13RtPnjaYfvnIiVrUH/HTLmWXRsy3RSo9Cr9YpmPl5+d8LqnmS
ehBy+0nklbPPJ2i5zvw/Bv6gB4C/qEc3veZP13IV75/LHTxzooE/fE/RV6pc
hpzD+63Hd94fut/1/kHIScgVyWeAX7kVKDP7O7OCG9TMeSOsvLi/ysB3yz9G
3b+1zEZjC7aOiOuh7xuc6z0qZutu1/sEdz26fzpbJ50HUbHz6529h2u7A3Sc
bVnTbt5LX5kwj7BTYLfAboAdEbj1Y4MTX1dwuR8QdgL0ptRDgIFP6DHITdRD
nkHuQq6gHnIFcgl8NmTPgCkfNmm+xPv1d2cJKn2HeH6OgU/w9YSjjWvGxms/
/PvjLXy7PYrm+V2f8mnzJR7MNtVOD26PW7++hKZ7zBP8kGUuNOlUt2VG+vxV
V8vaPfr8uu53T/q2itN6UOoJwMt+8x5T64W+zw9yU/mVR023jb3mej8f5C7k
DN4PrlhoZuxkfV8f+H7nU3owxqz5Du+vmZLv5YjFWq5h/ODb2kXKJf7SQ+d3
Sb8r6OWUZ7vPn0/IqkqWp2nojfsPVj/Z96g0dVyXPCRjLp3H2Txw+Y0myxD/
9qEPo03VslUz0SS/o26BWyvS55aj8/PlM1HbhdsaZPKppOil+OxtVcLK+lOX
nHs67OoQTpnOvc1U4lQQ/bS20o1Jt13P9yu//VbrXTdC1e/QTofde7f5G3bp
1Vl9y+UZov2Y8Gtm/v5RxVwtzfTvlQqrHhwIV/3GONBvjOPB5v7J7ZuaaH6N
iQWfN9PnIo4s0r9Xv7dm5ReEnxB+QfgJEy+524831qX/gRN169SMppX//Dy+
3R2r8oPBLwY/GPxiz+tmztRgqet5fKO9pr8f/ySW3hZMmPu0pYGnvAdeBT8M
oEyDY7f7vQ6kHQ+9u893D6Tn/ZvlPdYrRJUH97v9MbVnOLVJmGbeVqI69fzF
XiBfmXDy8fI+PthUnSKrrp7yzf5IVc7yiRjVNMKqyh9q//ddltklaeFJj8or
xmajhfXjLrj9bKc3hyqe+PtZFnrzqkBM+Ul28j7lWeTO2kyKj8BX8GvsGbf3
45O570yv/g3vPD+0CkXW96yVu1R+qrHRv1eljSaqdKzFoLvNitPjRstKeQw0
04PzL8KP1XRX30U/Wme4NjdwsIXa7DpXe3TrMhQbsHxOez8LWfJXnfKofkWa
euD000u1qtOvuVsVKPGVP/2+qmbhTevtlPWvnX3+zeJPodUvB3kX/Ywynxh3
p3KrCPUefod+oF/QX1jnTcr0+7vwX0rQprFfLh3eXPcD/Zq53u+m/7pyNN08
xfRzN90v9BN4Ax6BN+AReALe0G+Mw/dmm7XTTbG0oFPfEbnG/WHCd/Bd0Ano
Rua9gS/Bp+BL8CnWgVgXQl8j7w3rQqwTLxatO2RcZX2OG9Z9WAfCzwJ+LbSy
3NPB08Mo7O9t+Y+UiVR+F8jF/Y9i83bZo89rg58Jfie1P/fXvE9KRESpEs/h
h4Jfqnv9hok3+xjrjX1+/WpO0+d01zu2PrzRPcMenxF61i1O7z/Cc7wH/8zK
kjO9rr610ID223fkaGyhsz6dJo/NrZ/jPchf+Lng11J+Lp/d+S4UtVLTje+a
Z79uU34u+L0ur5p9alduw/4q0mdUxQr6XPArrQ9UWbbaqko8r1m92oWPTV3v
k0Rc8O6thBN/+ZMqS287M+yXu/qcetjV6B+e471VJzP2qj0oml62LL8r6Wv9
3QUJb9q0q26jwGxPL2Ubps+9gB0j72/Ee/Bjwa8F+b79Rqtd+TNHUtvsUxfv
OW+iuW+6NTevjaLCRc+dervURCfHrhnVdl+Ueo738BzvvfhjTO6h+01kGdX+
zLlDRPGDZv6Q/YqJYop1Lt1oNZF16oZCMevNlLQt6bNMpQ37f+Smpm/mmmlZ
9dIhv1TUz/EenuO9LwuXs0ca8/3ZqAwfVhWw0Ml3hdZ5Jlso3+5GvnPzW6hJ
09tZzyXpEuNv8fU3md5dj6bvcg5bMKWIjVqveRJePjiGDv0589rDfVbK+92O
0oMNe9Fjfcs5vQ24f++Hb9Ytt9Fat2Vzu3WPoW+6Dq9/c4KNnv63LOppPROF
1nz0Z1MKoSWb978cHWaiox8aeJypGUIdYrY3tMSb6c2lzGdPbQmjYwnxI4fW
cj2/7vnI7+0vO0ZQ4T6+C4t6WOh2o6A3S/JE0rMCJevl+jKasvY4f/irPZE0
osfLHe0KWyiuT569rc7pe+Ff7SvQZ6i3oT/3r0nYlNWg/3ltXk6JJGq4sMGZ
Ux+t9ODgvFZ/jyV6V6Hw23Nr9X2QScnNBjbda6WstqcLFrtb6NGerJWbHzP0
q9d6GprHQosyFb/f+mg0BVdo13/MJ7s5YfGYBpeNdUOke5tcVqN+66acC97Z
qPrHbWc/D7LQ3gZVxlb+07Ab+/fzjO9qoWL+hztPWGkj84DG0y4a8zKm38lt
R4rE0OrEljfz4fxGg36bDF/8ZvCIaCrw7NSla1NstLTA5+0/hFqpaDefcXkn
Gvqt7I/fHH4XTXt2j6zYZHIsTbi4sHiYwd9XCg94NcSQyx3DD4xZXFivV+BX
g93Sue262CWUQck1+A16/fqwYJKfvncxcVKTerMKmCjjsdk75m/wUPzQ8Und
3J/d86TRC5scHHMnCyX9+OCzlmO8abLJ3/TwflayvDv0fe2r5ajS6+qlV+7M
RpZKHT82Ol5e5eWwfcBFQ2lm64jjCZ4BZI2akGvdltTzBBIDaMjMAdFXjr8T
5/e9V/1su63HzH3xnnRm6N4VLb0tlLnX1U79T+UX5/dJv2dZev/VsStn++vz
SW8Gles890qsGgfGtTv0aJ0ZQ8Opdgv3O1uP+tHFBX4VN40gWhx/4KVPiVCK
XjE8p3000arZM8OueOk84fhSw079OTyUGoVurnUk2UYPmn/4/dEoww5bFfjv
6L12enh60MRVsdFUcXHj3cnzA6h7ds8dQYN13jXysG/RonhbpD/Z48bnOXEj
lgIeL5+TsXMsbeifcfWaoX+b0G+MA3ofdsDtXT8GVKgN+9tH8Uepn4a7lczi
o+wc2D2/T9jWv14ddzo17InHigFm9R18d+3CqtUW+evz+JAXzs6BSNTzCPqq
+eOUSrv/LESrb/Sbse4V8so86PTXpb7y2hGp9leBzkB3aBd59GgH7aIdtIt2
0O7Dqvf73SrvRtN+PDJu0epYRT9vNxQ41OCnWAr8Y/9PQzuHU945fv1CPKPo
98XnNn/1wEK1ho71Dict9yAHIfcgB6EXwBeQo5CrebqX/PZ182gaWPPK+XO/
6vspb/06wX3gJKui/6lZ5rQYsymYxhxcnyHLo1D68u9d1zaMCKYWbi+SN9QP
peE1RpZMXhpM//zSMajngmr09fhSi+IuB5N37yJ1x2+vRt3X+1nmnAmmnrWm
BLd6aKIPk8uHDjgZQe9G9m7180wTFTuVNeHh/Qiqf/f3O5aNZrqfvUKfdsY6
MHRD5arTvW108lLffVtORqt9re5jc3htjA6mQ9H3q5UrGEWvfF4OsdvD6NGl
yOSaFyJp8L8Jk7o3D1N2xa6MHd//ulz7Hdpub+k2qbyFFpz901pxm1Xt64Rf
YerEZLfZhvz87+LvQw+80eccdLoy6PG7gfo+Tcf01rXSip7f9AyKsqh1Ht/v
503PF+U78LIwkbv7nSt9moVSs8VZS2WnMPJPznIu2/1w6j+pouecExF0LGvt
2H1hNho64bLbOUNvNi23Kd/qABvl/37KkSJVzEr+bixhrXvkN6IBZyPbjs9q
p4Aoj2JvM0TThKlDSj0dbKdLpRd3HFbaovYp9ahc5++Fv1qocqEvvvFpYKfE
sBmv425aFD0WzXAk0G1tVRp4sF5Aiwp2xYczV0xosSkbzoFxF3lFXmp90qrF
H2uaDCtLflElEiYPD+X7HyaFUg+f3TUaPAtVcVB5r4Q9JLb10J4RNPfv2o2+
+tGs4oaIE8G+BD+NmNtoRlw+ne8IOzTHiDnNbt8yq/17eS9Ndvuirr4XGPuq
et2qOT1rkpki8gzoXNRLn2MAuYw4ZJB1wp5Be/Q96fCDwC/y+sbg5Pdf2Ln9
aqw74TeIGb09aNr1LHR3dL9b2RO9KYv78ALTcmWl+KT2cRRTllpRszrbqtip
Sueu/SeW9KGFi2uvLF/eTOOv7fvpdk8/qr69Xrd8ZaJpzs7gTB1/86NpydX2
ZzHWv95vuo3KddqPHtTv4Vl6upWy552wrOcxf8ocNe5qXcNO/DNg2MTGXf3o
+YPhlb6va6Y663YczNQ4iJLbDWm+wKDvnH6Z7PuWBBrrt0mZai6MoQ4entl+
oCAa1Dr7yrPesXRl4JDKjTcHUv3FbbYPLWamsE75spQZVY1OfujS4lLOaMp+
bXqFhJPVqEFs9xI9z1npn9JZxvY9Uo0mZV44gPrHkDn+vMdx4/3i4fWHFjke
RPEL2zzdb8ixcQGvvvvlNwsVvLs84HHzCHrb/WW98QsNe359+NLBbSIo6+1X
TwN2xlCTBvnKv50TTi1arYr+2qDvTUVa3/OsGG6sR9Y0e1krlrI9f3jd3zec
ahXfvX2Cwb9X5kf8e+CQiea1q1w+354YWrXKfVdygInCmh78omlSDJXsnvi+
W3YTBTY9uDSuoaGfYtZ+X/lMlMIz8A48AW/VJp3sHHEgnL7dPvtYq5Zmenyi
9q5y38dQSMteWbaHmulEUJVsTw19M3JRjj3N8pip7+r1lkehsfSmatZKz3eb
1bxhHoE34BF4AF76RZZscPyIYb9UHPFvm6cGvx5Znu1Oo1jq1+Rk3d7vLWre
QQeYd9AB5hXzjHnBPAHPwDvwBjzeXVRyg6WembI/3nhpwh9WY3w/v+niY6Yh
LUbWKxNuU3QKugWdge5AR6Ar0AHoAvOKeca8Yp4xb5hHzBvmEXjHPMScy/94
Vdlo6ui5NN/LrTF0eLG9e4l80bSsWrf/dt6LUXQMugbdgI5AB6ALzCPmFfOI
ecU8YF6Sji/InW2/lTIXDPCv2yCWLs9q1fy/byzUuE1Cj1czylPLoqVqNTDs
m7ddAiLH/1eBdjyu09DH0Nu13Gffj3ug9Q3yPl/3/qrV9KU2tU/9wmxT6Iuq
MWqfpfVtVODdycE0a0+VFecNuyznySHvY34LobnPj0zu1CZA7NMpq/b9wZ6F
HIdch5zGvjfo+3k/tg5+mhRGX7zYPeGeVd8TBLncrPeaWWcy6ns+Zn3278IH
DSIp718nH5Y8Fa7OP1H3rhSv321+nnCVtw79+Djv6dH5hut7Omy1vpvpttyi
7CfI5eYrls9cuCRK5bVD7kPuTsnd7YeEF0R9uvfeeWuy3kfesu+lmhNL29T6
/HHOhpFL12g/A+yguG/6D1+y0EIlXn9uoSDtB4e+zWb5sVR/Yz2/K3bto2P1
bUrvQx9gHxX0bbMsUcMvDrUq/Th3Z5sDT5ZbqciY5NX1rmq/BOYJ+yahR/G7
Lp4LWpU21vkzfLP98/gHT/rs+1fHXve3UZ+Fa+psOVOIvpj95MfZPnaDP26c
b/Tei+K2lQzLV8dKL9rlpexflqMXL9YM+iaPlcYe7/6l27OKVHv2sq3t8lup
oFf2HQ23VqRDGSZ2t903U/PZDXKt2OdL7e9VXnjVWIcsnL11WGtTZRraeOWC
PUNttPnMsOD2v/nS9WMX5+Q9Y9DjFM/u3/lXof2brPPCjsXQwjfNsuXqWoVy
RD7avjiUaEjDSbdLVwigKp3mNdpey0JL2n/1NvOeAArMFH/26TkbfZt1ycKb
iwPIY1TH9Rda2CnvXktES58A+nvUL/9cHhRLVecO9yODvhfvH+OZO8JCG78+
vOifKiEUXvpKv4xbLdS2595HG4YG0+Y494INC1jp18r2HhHG+n35gIXv79kN
OOferAHPg+nK2oVXDh2y0cUlFy5cLBZCrzZ/83PFZnZ63OmYpeGWYMo+7JuC
eY9G0d2Q888OBYdTgX9KZTxyNYqG+5ef2sIvnB54ehzN8chM3zYdWDq0RBjl
PFfts+6h0VRoUTevpOdh9NPgzK9zHo6mJZf3NnlhCaOjm590b/XeSl1L19jd
/14YDQ8oOmXaMBvFvWnabnPZMMo97eqKkn8GUJ5P5bcmepA/a5PvPM30tuv8
y2FjTNThbVC+nk+jqW2hXzdmLxdJwXP+yDKsiI26BB3J5bYhkj77trdf/Aob
TVi64PTQbJE0Pfly599PxND17PHlottH0vFMC6dVPhBDvfes/eDeO5IWte/Q
abthn0xt86ZElh0Ral4wTwurf9GNfg2mbBOGPc0TTFQk+kqD3Z/bacDtHpHt
/Ik6d3e/MNKgry6fygdEJ6bOO3ltbQyd+lR2Mezz7UF7y5rs9Lxcvr4zPIna
Nbt4M66dnXo3m/1f+8NEZ4rVHdlvoT2l/NpM/xQYuNKvQCy9/FRe0HQHOgSd
gG4w76ADzDvoAPOCecK8YJ4Kzp9fqXHuSKoyq1X1PkUsZN/w3+HJuyMp36bg
c4saRpOpsPWe5wwrrX3xb/3XxyyUwWdgrv3GOmhG3MF594x1kb97x54Zt8ZS
QvMe1k5lLPTii3jLjCexKeVaC90esHG954hYuvOptFgU34CPQJeKTlPpEnQK
ugEdgW5AR6AD0AXoAHTRd0qT3S1qEM25+uj2MmNdt7nhDyO8zpip5qoOg/9Y
b8i7gad6Rs0009GA8NqvLFbqs77nrVIFzVSvXdKOq/ui6W7Os9PujyWqey/h
4/6PVtqdO35jeUOPrTv9zc5fDf0DuQM5BLkDOQS5AzkEOQG5ATkBuQE5AbkB
OQC5AD4F34JvwEege/AB6B58ALoHH0yPz3hldYRh9yfenOQxy0bJPQ6+X7/J
TD9uHDWz1/c2unujYbk1owx8bMv9/ZhkG11qdCR34xxmsgQOGRBofA98AL4A
3YMPwBfgk9DZ8/q9ijb01Z2qc6Mu26jyo/rLBgZaaN0Jj+Dwf20UPurPdZ2S
zbT8q7nF7D1jKHh2rzq5u1ro594Vd9+/G6PkEuQU+BZ8DD4D34HPwHfgK/AZ
+A58OHLo7aTSxrow7MmuH6ca68RupjH9bneLJnuVBqaJnez0NGjf0sGx0dQ8
33cFmuy1U7EHod1f3rDQ+IPPbp6pb1d8AL4A3YMPwBfgk7DKdZZNfBdNLfre
Pn5pgp12ereyZz0STdYb87e9e2unErdu1VjraSOfX60f744z5ETeXtPDs9to
9eGkLn9vtlNVU8lNr5YYdu3rSVPWxNvJs3arQcGGvq9qPXCyuaEvh0dlLfrJ
j/jUY/fYT37FvL9OXfDaoPtBk+15zpePpZaxE3rW62/Ysd6WJN/nsfTVjI0l
vE9GkHts5trbHprowJH2c7fdj6AFQy736zbTRCM3Ln85vUYkLf7hYdUtY6No
7YfLO3pujaZ+X+zscLmpjZauWXx+ycloch/blIZ52yhpwfPYvhmsVPLrvFvH
zbfSs++u7Znf2EqhuT5k8zfsgb8GRlVp/K2Vvi58z7N6CRvNXrDlxYEJNrrt
f736l91jqGLrKxnDywZQ436LXhboVFSVeN5jWunvzvQ+YkKJfIJncWcK9Y4J
pGN3i/+3c1+gOmfp5ImNJxo22p+6n+uk6eF+0/dJRv9HFel37d/i0bT/i4q9
T39tpe+2ZakUMSiaRuds3rRvOSv5txna/M330TT+bs81o0bF0LrKWc6duhxN
nXZl7LtwbgyVbx/jNepktIpD2UeFVogeUJ3Odqw25c376vzeqXFWav5tvfqn
Tlko39EjeY6+iKYmTR9/2XSLmYY+L7er9P5oWhy2PamTIYeu1brY7v/V9d3x
VL7v40Z2SfYoM2RmczjOuc5yjrbSHqLSEAmVBkWRSCmSUGlKW4kGFfUmlUhJ
Ci2pJKMoJfk973dd9/PT5/U9/zyv84z7ee7rvu5rj6AgPoz9WVT4bDMH5kpc
rjy4SAjHU+o17cwF4KLZ8usVte5zfTcYWWDdOkq+yhor5vp0iADcD8mMNHxk
AlkHzSUyf0rDkRlak6VrTSH31Lflfm0yYHvVL7xJzRbKg9UrTXPfs3tOfDBU
LbCB4B8f7/rsa2JrbJk1hb2bASAYYaX3XAKO8W9HHctgQ2VQ4tkNkl3skg/9
bzoucyDpR3HgUtZDNtY9EPvzc7e9+D7rAA/Ebbb8E/VPNhvrEuD1CVZ6Jaoz
BLBh+7YJWof/Yc/8FiYYHcQDnZ4En7WUXG6pvuKxHrUfo6W6nS/P0QasM4DP
vwzd6l3Z7gGsN3VjpW+9Yt8es657iZkAxsY0FScHKMHcuT3f9KX5sLXjy5lH
MVrw0GtVb387Nf7FL4EjyzWIH0l1BPNI3KbL7IF1EoYT+RrtIFg34e86B/gf
4YhwRTgiXD1sZt9wtbYk/lOtRR8D3q8SDoxv/bdu3+IvLQcNbGG15VuHgHMj
YHXd0H8859rDi4QHqT73h8M5pZ2ZMQ/ovjBYZ2BbzkHny2Z0HUBcN1zH+ElL
Us4oAsy17175qdgVFp/xSxdEsuA8e+ubWkPsS8GFFKUrbyJX0fia5z20zTPS
FT6MLOt4dUM0sL4XdX93em3AIA8WuX+M0ZIYt/EsEjcTsOvyiFAJFpzNbi9T
Kvb4qx6cJ6mDgHiFeIZ4hXiGdUoG1Nu4aQcJGUc+RB+k46jqOWMfTL1Bx+fJ
d7kFHzoIIJ7R0Nu+xeOvPiGepM4C4iniLeIh4qU0f47/sE/uJG4I64agvoXz
QjudCl8ze1m2gNyPemp6Q99og28Aq5fFrtjuJIDMi5opNXFcUNTTk3g+WgAn
JhTm7U7g/k8dizdyhfuvJgmJvwvxd63BvKwKPQ6Zb+PFohcHZnGgKPbJC2lH
D3I/Xm8q+bVz1wUueE1/sXTdfdHA+mYU/jVZ3Uu9qUDH43UXvB+Xqk3HES00
/CDxMpwL/HlRDe+Xi8g+wX2M+xr3He5D3He4D3Gf4r5FvPsbr/A/1oFBOyTa
uzdLDXqrw+NBh+aIj96FQO7HOi54P65PkmV21Owsus7KgPG20HZR1JtRj1au
5M1arCWk67yvmHuFmSQk7/vvGCyEN0uVphVXcgl+Yd0O1FsnTJe9W/eShu/U
HT8gTIcHPJ/SkvBPf9WPo64LFKaeHzSOD+/Sp5yRSxSR70G6h3QQ9+nf+xD/
Y92cAfGMFPyWPm6tud1H7xu8H+ve4P2k792xDQ6jxgkI3rQzjNKCz/BhVt+5
orjJMHB8Cp7Lzv84VEvJLS9KPH5GPwOi3/+mm61spcjS0IyhdF8JrIuEdAPx
Ft+PdAT39YB4wi30Psc6PbiPRhiN6cx9RO8b3Cf4PM4H9w3uE7yOdXZwPNx3
OB7iUXTV1cQFPR4go3NvkdM1Ou611798m9hGur8HrqPrj6b+A+8EcHPT+OQw
D3rf476yfzpnsvsoSv6srK6KvUj7LfB5tLOjXQWvIx9AvvB/7WP8j+/DfV1o
EGlbEEnj7cJba7u3qtN2G8RbfB7xFvEY8Rav4/ciHg+sI+RJ9gWO71VezWx6
Tj+P9qg9nFFuTx4JSZ0gfB7tSPg82o+wThfa0SZuClk1PtUccssTC0xGuQ2s
200d8Tze93c/JH3/cIn+p3S968hZcXfipV1hSsT3xeLTRQSvsT7dl8ESq80O
fWSjHxP9mujfl8gK/S5roAb1DfOOhIZxSRwhnsf7vLY9meaW5kH+I15Zfa84
LLvPGm5e9vB1bBGS6zgOjvsbTmbEr4x+ZFz33/DqZlsXGuiPWicCu6cefTlV
39ndTp3+78dR475f9cAkIY9dYhdmNGqY6H++C78Dvwuv43ehHINyDcoxKNfw
5s82WbSKC2vnjJQJHmwCieJ6TYFdBmCzkKMlNxigL0/u7sn1vewNvZwHAaki
cHT4uMVKm66rvmH0xxq/Q26ETmCcDsbtcL6bRL/OAZhzW6+2s44N40yFfSqn
uODRJ75HKZIDvFVrApXU+QP7+1D/r76652DuzYXs9Embg1ZyQXW1TKfnHR65
D587INf5KkeFC80ZahbMHi5MOHT66gFlLuxQK9bX7OXC7ImBliuTuHDk1a5V
kqt48HHVJtlNByh989Gw4eVTeHC4fe6HZhc+KN1TnV6yU0D0DNQ7UM9AvYPr
v/WdEUWn0iY1f9mtSdtNw5bdy2rSouOp0K7aMWTKja0s9v/Yn23XzK9OGsSG
Qw8fSo3YxSb1gvH8gH4f1Hm8D+nlkM2DXDirgPwvE3MYGzGOA08ibts9TP6z
v23o83gfnsf7frBylV98petto52brW37c+hJJyjKuRj02hz7ETsRuar3/Zjd
FaedoeGQ0fjbsXS/Rbyu0N446o6sK5zx8Hsoqc8h+JKYWtHeXg6w4MaNUSEu
TKhK0y9acARAm5nOPO7NhEJdxuA1Slzo2c+f+qmGBR1x6y6eO80F86Na5zv7
2HDj2SvNxVkC4Bjrvkvr58LjTeVz5LU9IGzY7Naty3hw/tCSuDGUXs0tzdVe
QenZWIcH9ZeVe5O2n1ooDfXGI9+YaxnCHvWX493CWfAiPWNy0z1LcNKc9PbU
XmfYeDLMmsW0g7HNAa1L/nGGkd1jokJs7cD0nfVGoyQ1OCtcYKhfy4G1usNP
JD7Vga2djQEbnbjA7j2+qsxKQOgm+nelDzffP0fBWY/5OdaV2sdDrRdU+/jn
sfG95Dukec7HtFzA6HvhnVnNDPD1nZaU0e8MGpW2Qjk3Vxi8TKN7XoYbwKgh
3vbb3OGh85vqlq1usO3Y9W0zbrmD5JV7HxJ0+LAyJXr64slcOD5mlbj5NAFE
ib+pf/mGDwH8CofxbAEkX7O7d6GDT/AS8RTxAPHiUXCHhgsll/dciWZGKfHh
4cwxFqarXUG7NSjsirYjVOy6Vn5a1xVmFTyZlWnvCB9WShW0HGeC3SBzsYix
zoQuGDXsmXBjLQMUdjldPL2D7uNbY5/lvnAkn9Tzdb4b8u5DIB+i5uy12WDH
hf0KEz5ELOUD+5TeZxcHSt713qxaP1QAEf8e2znwvM9/aYilAEZK7EtNfMOB
dRcFMtIsK5j06+Me0yV0XfArL3ZXWm+wg6re05zQ51IkDgLX6fHSDXKyQg4Y
cQ3FN1oLyD5BuhqSoChlos8DVc2ojB+26Fc3I/RKw2toVN56c+h92OszZBnW
kTeFCWKjgj6vcIGd+YLA2yMYILF13vb4d25gUmKfdv0uEyI3tfqt3iSAYccc
u9PlOCAx1V3em9JXnvnaPPSj9JXoZXNm+AuEcMf0TocFpSffH1uRMctLCPZ5
dguPNXIhZp+LdH+0Pdm3mFeO+I52F7TD2Ex/3hb5QxZcF428kufXTersYN2d
QrsdffkpQwg/rVsi/zBtugYkPXm7VdpeCeZZLTIxo+QxlRLHFtHXH+zncYNd
51LrUtgUdH1GWCe7PFvdN3MYtQ6b97QxmuVJnhm+B+nQeNYHr5hMJZALb39b
q8iHSMMAdYvkNrbD+JwvZUN58G5V34fyPTJEvrG5e2rtLH95UDA4O0j9ugDc
JWN+Loj9zH69b6/Zx8eUntN18tyLGhmynsLJ11P00hWIXId5NgPl3lb2Aouo
C8XBFB81Piq4eVIebo1LP2NezAOFNzcKvsSpQtcDn4UWoQJQ/1qfrMxVA9OY
Zwu/tTuC/kPxo61P9CHTccJ1hlAIPwZFhnXtMwD9hJyDh784QNyJNXG1CqNI
vhPWFVIe69Uk+4qu633BberB5bZCUI1aW8pvofN6MM/n54Qz4e5cIbl/R8ud
ta838sDnyyWFR7tGE/kX89aeH4nyLT/DI3E0TDO41+4igMrZQbKrvUaDlcZk
+6rpAnI9f7zf7kuU3tB/Y0jBTkpuFd87r/pyPB9SJks7pzbaErnui9K67eIL
7eCIWMK919X/xhNvDtmQTOcBYl6gSLevOm8sl9gJbHk+eRa7ecB2t+QrKjuD
j55E1spiLqR3r9RJD3YkegvJ+7oeEfq+TECe95u+7mT2BAFsGF6lUNTjBAd3
BMcfS+TDt/jCe5dXO8JIGZd3zRJCuPLBhJnDtAeWhVW29GgheX65dLzehBAR
eLy/e3qNjhNcaEp+9OYcBxaUm2aXvaDzFDFvUbuqYLGaIZfQDYQv5u1JfX7d
pz6U7nuI3495aEee7hmqcEpArndE+co6fKL406jBR7YfcQLVRldFIzUhuW4x
Oz/vwBEPGDpSpH/qMAMG36ia5F0mglOHW+wrprvCXL3c+2vsRTBxwSkLVRsG
6N6Kv6pD0dUnNv4rt1F0FvXwv/VK/I9yOuY13V0/wuXyMxGMX6Ru2qjEguWB
x1+EU/LzLtGo1T7ytJ7+t975t/0I86Cy5+W+rrohAjXXJZNO5wO8bTrW7ikS
gffNOXON2QDM607FEjNsIXdz02fjSwBxXqqn/c7bEr1xm/6x9NeDHUGQNHn8
ylKAYSGRc27OdSTX9dixsUxnJgQ8Oa87lZIbuMJHx9cuo+OeIWeD/deNTBhi
s2rrk3wuPEy8NGW4mRtMO7xr71IFLnjFVlZWSQCsrvTt0lpFx9VjnP3DxbGb
bw+n+/98mcYw3kLJGd5+8m3hlNwx4sX2KK0qFiwzcci8pcYFnY7esdljeXBW
VdB4r4uuc4p5bpgHh3iF/AP1YIQf5oVlD+d32TyxhfDpeQd8i+g8esyrr97Z
u0uj0I7oC1kHG17yS+2hS1N8T8AlHnB17qbNXu8Ch4Ysun8mggsfcz5X7Lzo
Qu7HuDbM0xYFHt+v/oJJrofvMDA0j2WCW5nSMLXNfJB01E9x8nCDKG2lMTpv
eAReu58pzn+4jguGzq1KU43ofIrblY3x6hR8bU/t6ekM50PoW9XXae9ZYDqh
uNH0Iw+uTd+ybtRFDrzKUj+40pgLqfYfe+oKOSS+Eeua4T7LaFcQDrYTgvy9
krx3Ilovt/oiPm4LpacHdKXcDX3sAYH/HvNoPRTz5jCvDsdD+vV/6dXtBoO4
OfEusM1xrP3aCXxoGHkuf12dC+HrCD/MW78/3qVU+yeTXL8023/W/qkUfk7e
wP5i7wGXt9ydZmvqBp/8z7oXZdJ52pj3HVNQ2h01mrZvmf/qlHlM6UWq/T2S
LZYecPBMZLH2fRZUTrsxfwglB5S2fJphrUznSSdWfPmxj5Jzl2zxfTJJ0wPu
1r7JnUfpOcd3eCWq5dB2eqyDgXZ2xEOWY7WM7W5beH96SMVJK7ruAtZhCA/Z
rbxggx3RY3w2bHgn6+QIzaf2mYc40XUOsO4B2yS+dU6LI7l/ccPPguxZLlBb
kCS2v18AGhUZXU47Xcj1+Kacfeu6naHX57ykRaqQwBfz+re8utoouMUk95+d
9+T62m9usD68T1L6gRDetXYMTXziCqk34k/vdBcS+GJe/Kjvuhl7NGh7V2Xb
Vc7TGDZ8zzC5qHRfCNM2Jym+i2YB03+XVtoY2q6Ldt6PxwK2u0bTeQU2aV1J
L1toPBwq1hjnPEYADp7BZzYVCuD7+jJ39jQBsTNjXTy8X27EndrIQgeoyJK9
9LBECI8zxK8s63Mg9iKs04B4jHoU2v0VdnkzfoxmkvvdX3NN4rEvUQ6df4t5
72hHxuuYF4/j43zRDu2/PfZOwRA6Tuj3fVpg5zs+cY2XIoQceBV67Y0HyQuo
Oj42ROe7B/wzuyw/f7YG9C2KfW2SRPdj8z15+4oZ9X/B/E0lc88agb2m9FbN
HSKIsB1sZbPcmNQdGdA/6Cvtp/k2OL//4XYLODgxcOQFim+cuTHv+6R6ir/M
+b6OwbIlfUo8Qz9em3XeBXS13t9ctYIDWh/c5x4ex4axIyWVlXOciR6q1blC
wVfSlfzHuFGMI/14QH693f+nR2MdRoQr6uEYF4Z0Jbm/XbHvEYfEp1vs7HZj
f6Dk3swi37XSAni/JqzS250HFwNqI5/00HZK7ENwd5aW4tLDPFKHEfc3yrsY
Jzb0vqBHopzaxxHjLD2W0vn3uC54Hu/DdcB1+T0vWxi5oKWl66EIzFnQG1pH
9zVff7RzjoWMK7GrnUtYlD07VQQnzu49di6il8T9Yx7AlJ2969wd1Ejc3oFw
TmNOpNPA/GJKronpz9Yv22oASqMfLzfaiHYrfXAeduBKzRYRkWc3X99THK0p
IvLoru4bHfnqIhg7wbNSFGQNZ2Z827wjj+6jWeea5NP60JrII6JfAqkNlNxb
YNSa4rfXHSZyL4v27X7DflgzZvVyNp13EfrPh3cJtvR78Tvsk/eOcPYxhQ9x
q9oPbhbBGudr1xbnjKLo+Jy7SuEiWLk9ftidchsYNs4Hzt4Qwme5DrPJy22g
Z1CPqtkTIZGzTu13SbTUdoFLPA+ZSZTePr7wSs85So9/k1U+syzZFWRaZkcq
NdP6sELF0lszDrnBSMk37W/j3GHUTs7M05ReH5dbH1SnxYIzP4KSDZe7EbwM
0to+ZEq6O6hsy9l+YBwldyh/DX93zh0st+8IuW3IgVam/5ozD9zh26nKBx6W
LDAPNS8yzgTyHI7TFjRIcD+coo+mGWdf8VjkiOdRj5SaXqzmPA3gc4X9hct+
LCIfIX4Oj/Hszkii/1+9aLLLgfou82xpg2m6POA7nB8Xk0aNtzGntvA9FySU
H+hPPAOwiNPmr9VAyYmTnF6HL+aS5/6vceV0h2Vu5HAhgzvL+mgLkCOex33d
ciLNZ4seF76tau8o+QFEvtjne9jmVCalH2kqDfYzp+uiYp1UrJuK5zFOE+M2
kW8uqq1rspjEJ/9rKtZ6drzgQ+MKg6w1mR4wSsLjg5wvH8ocdaNktfgwc9Zi
FavXAnLf/zUO1lnF/f8f+aWuY1zn6wkLZd8ucAeLV3Fea0R0vTJua5ejdBYl
NzwNM+ipp/vsYtwexvExpdrtc8u58MDMpbQmhO5L+t3KNm/+ag4Y8NMVj2Zz
oe+HTMssRy65Pv9FbtEWcy6cYJwL6uzmEnjiODguPofjuMixG8MT6bydvKSA
KUs28SFJWGetp0jXd1tXk/mcLU+fx/tWSv4yVfHxAMlRwqvOsgIYk1v++EiJ
BzTUKC++E0DXZbbbPjnfmeJbeB7vw+dwHIQr1ukoPjSkiR9F96nBcQb4hyg+
jnHO/32vlgdYGBTo3MwVgHTd+ehYMQ/4YTIxYu0NAcTe7EoJ7hVAV8YpiXEl
AnIfPte0Jfqn0SE6TxntXO+7vJ4Oo/Tk4RLVR1MV6XyOU8PeFcbJ8qD7iIK0
zicesR/eP/kqYXgbXd/EVLAz9pSXHbRNvKoe4elM+p4JIsb8CrnjDmkMowbe
WyeiJ1nMSA7SWOwKI18tEl81nOJjJfckWnrcCD7N3RPhe0yd0gsmpzKPUftr
QL9jah/u3e+9QfyFO1gt27+lSYYHd891rj4qzYLYPdX1TrO4UGn6zbhcF0CK
7fXL/hMXQDV6nPldNqgfaimy+MUFK27N+umFbKj5fDlXX58PMrfzzFI/ASy5
V1swtp0PaQ6jRHnUvq+/u1K3NpcPKS7ja/gUvRjh4LlTLYX/+xhG50sl6nX6
FYbT/dnurZ47bcdSLgg3abgqfOb9Pvpxofn6qfZdez3ggOXW4/27KfjfvPD8
1hKP30cRXWdkhdoay7jJPGBdf/nuJCXHx02SsnXvoa8bnMl+W0zpMyU/rG11
wzwG9oWj8OWMt2a4qg0fWKLSHrUrgt9HMz4I6+UnPb0ihIblWx8HU/qD3aQl
skeSBhF+inmIx82rbuVK9bLRLod2OrRTDbTL/WTjOPgcjtMVU1O8UaQOBw+E
Vh0VG0b8eG7n3Be6bFOBuRutR7+QFhH+jXY9tPPheeTzGxfGx/cetyf2TpQb
FCU+prvNG0XsYGgXQzkA5QKUA1AuQLsY2smQH6NdDN+D78X34HuRjiNdv7pO
YdheT7qPacbbDRHlb/hw03roYeVpdN4C5jGgfRDt9GiXx32mxnhsbsCm5PuZ
k3RX1tB2MpRTwlL13UOniZMj+nupraYa3dzFXn5B8sa7aDt41jfk8Antz2yx
mwmPRQqOMP95SP6SgK9s3L/W4c81HEx72YNGzMuJLHKEQ80Jgvt7vrEjgrYt
CzvtAbMmSpREag+DgvyEW+8ovXFl/5qsW0dHQjJsctT6KIA9KcZ636qMoPJN
WLnqMXuQP5IlJiVuBtmjFzceLBcQONbKLSuLTRaAc19WmFyvBdQx65qUCyi9
ReOscbCxOanDjfI45t3hvC369TrrJUaTI84D54Xvxe9A+aFii0ukKMqexJVj
nPnoNTvfz2Y7wbeHEsxPk9lQ1Bnx7exYJ9h34mP1IgYbXt0LcZLUcwGnNzO2
lUVTfLw2NP7hcBdQKeuw48cA/DT01um+7Aqd5YNfztcG6BN9vyM5jwGM8nnV
Aac5MEN3SKR+PgP2LSs6/dGL0ptb2uy9g3lgHKES0ezAgZcnT2y9T+nNO2wU
mxWvA1y82BNpQOllL4InqUhm037g/tS2kcsoPlz3JerEGlU9YI6+V9zoQq8D
rgvC+c2vre2Dbeg8B8x7wDwHzHvAPAfMe1j2dNbhAAkh5C3b+LGvlE/6qymL
fe3dTOEt4gHiBX6f6WOd9wvfCCBshoP9/DI9+KeHUzTzMbWuKfK5vXb6oPDp
1ZxHtTSeIN7g9zYEaqS9LRPAr5r9965Zm8LR62s1ehoEYF7H3niRYwq7bu7v
9Wyg8QbxCPEG8Whcl8hsnKU91L/beC/ZSwQ+n5+pe80GuFexa4vlBQ6xF2Cd
/fCHBVe2ujgSfeD4hPbuGStFcDc+ZpLLqhHkPN6nxtHMfLBJBCz99wYtAkp/
6GtdKJUgArOtT+uzqwyI3I5yPMrtKMdjXR2ss4N1dbDODsatDuiHYUfHsSJd
QTqz7h+b4sSRPJi24UAm/wKX+KP5lVsd2u5z4ZVODNPFVAg/0t8fiDThQ9+G
/ZmPWyk8slcIT1jHJ/RI6oDuW3mKr2EdH6zrk9GmajqW7QpNmxjBDUZuJK4V
41wxrhXjXBXWptgszmeRfqe8bfwzOofdST7w0x1hMS+BMzD+zoYD+5Ykas1L
oOTIwSknmtIB/KeaVFgN4ZA+ltLnk3cdfkrXH8Fx8DkcxzijvtprI3dgfRVK
fi79cthojogLdnU8z3VKfBiSlDvS9gAt52AeK8q7BjLW+Uss6SOeR/jvtjOx
4KZwgSl3OFZ9HA9iM0orT2RxCd1e1iBzRHMOH9QcHhxZqioAn9LPrb1LaDgj
3FHeMU+d1slqcwe9+OvH1X4Bgde5YrZYbhGXwAH5/67tG8xVNvLByZJRcv6d
gNjvUM4zLJv4fIgktZ/bhplckBL9Pr6l5IEbXaXWj4WE7/w33mshPItvtJrY
TT2vuTxp+FXsUyYFuwKWbwSuB/mPcSAYF9KubtAtVsuB4YHwYfguNZJ3jHYb
pFNIt5AuIJ1AuoB0Avc90gHc90gH0I+KflXsA4b8Avkc8j2086PdH/uwoZ0R
8Qn9ALgej5XWnvJvsIE8x3Gd21uA6Psof9blfEjjXLQhdnK0myPeoZ3cTrak
45oWjzyPcH+aenvCmXgbmKrkpydvg/l2dsQOinZRtPuhHdSia73uszkeZDzk
08i3w7WM7u5TcYdMv0ttr40dwFNJYpruCBahJ6jvl/5oj3T7ak/08HWGEjaD
HB2I3wP9INinDukmwgv9IoFvtb7/m3eP8hD6AdAvgHhpdm+/7roeO6Jnsk8t
MfBptid2XLTr4nzRjus3WmXbiM0eZHy0W6IdE/us4feh3RDtmihv/tRgSFtU
2MPrYV5yBrVCMh5efypIm+j12gnUXhgf3jtbRORDs6UujE5/DtFzEF5D1RZb
+Do4E3xg/TpSnZvmTPwe6AfBvnoD8v3H036RC18D9/zzgEvsrIgf+92SvKbG
OBM/APoFsI8ejofwRT/BjJXZFUaZdF0KtGujnXvSgs/jzh2h+xLhelSLKz92
++oEp/+1b3UJB86Xgmfo4OeuJlXOxI6OdnXsu4ffg+uHdnakV/Kcb1Wz7jsD
x+115FFjD/J9eH1EYnbXKCNXgOz6GoX1HsSOlROSvu9JJW3XQrxGPMc8W8Rr
9LuhH+6F73fX5yu4f/Xj5sLU5+0+bS2uxK+Efib0O6Efyr9Zvqx2PH9gPWIK
3i/svwR2ybuR8dCPhX4W9LugHwb9Mu5tTfH2rwVkPISX+eL2Brf79Pjo10G/
AvoZ0O+AfghcnynrpPSmmtDjod9i54OT0lPOehB76jozHe/oOBF5P/qfLu5b
MlrypivpSzigHjI1Ptr9cb8cE2oZ7Yp0g29Td2yy+CUk48tUbQrVHioi6+E9
LP+syJABCht3LcqPYIHXot7kh8WusGVpwLGDinSfUPSbYB402rnrig+fy6L0
3Jr7tZvjP7CIXw/9fDdl3zKD1/OJnI/wu7coLMr4Bu23Qj8W+rXQz7VSca7B
MDmPgfVoKPhttcgNsk2gx0M/Gfpp0G+Dfhz06yC8gjtk0odI0eOhHyjZ/pSW
4KIHmR/C3znW2np1FIv0fRxQj/n/87Mg/P1SHd0+6FLwebky5IiEiIy3Mc43
ovSpkNBpjHvBOBiMc0E6hnwd+T7yvQH5Cl9pPjjz3NX98MkafnSJjduXSPeh
Rf8Eqd/jfF1+9QkOif+MkQ78/GUyB0zHHOo1vTj6r/7fDoSPYBwHxnUgX8Q4
DuRT+DzGTWAcBdJtjJtAOoZ0HOk2Po99ZkmdlD/7AukG0gnc54gnmIePefd4
fZRyc6f9DBGBH64vT9E6xP4JkDgijCvCOCTsY4xxRchXkics/FWcLE7soLhe
MQsuu83o5pL1QTkD43AwLgfXA+NwUG7B8THuBeNgMC4G42SQb+M+QLqNfAvh
jXEoyAdxfIQn0lGkmwPG+7d+2Z99jPsWr6N/qj7I64yUNA8KbiUyr7yl6KmG
ma3hMB4cePLyTsgLD3i/REpZSpVH4q4wDgvhi32gMQ4L+ewH96P+d/vF6Lyh
P/A9kFkWNbGQT+KsMO4K45AwLgnjlDBuCfEV5TqMc8K4J+zTjHZgXB+Mg0K5
EL8P44owzgjjjjAOCd+HcUq4PigH4PpgHBDKFTg+rg/yJeRDSLdwfZBOIl3E
62trYucaDuPClO1dLnXX+fAxUbJvZhylb/FXPlVyEpB98VqC+zrdlE/+l0Z6
hU+/KSB4jXUnsM4Efh9ex7oTWGcC3492c7SjY9wcxtH9rcegnxj9xn/39ca4
OYyjwzg4jItD++CAODhq/6FcjvQM5VaMA8O4MOyrjf54XD+ME0O5GOUyjMPC
uCyUo1BuwvVGuQrlKLyOchPKVRj3hXFg2JcbvwfxBePCkH6i3IhyIn4fXke5
EeVE5FsoF6AcgnIKXid5FX/4IvJNvI505MK4zrbaDA8SN4dxdCjXI19E+KOc
j3I9Xsf5oZyPcWwY14Zxbhj39rccinFpGKeGcWsYx4ZyEb4P549yEspFKCfh
/kO5DOUw5BsYt4ZxbBjXhnFuKAfg+4jc9EcuQDkA5QKUM3B85FPIt5BP4XXs
U/l3X0n8j3VBsE4I1gXBOiFo50S7J9aRwLoSgun/+IdO5xF7CNod0Q6pUjyn
4nCmkJZT/uBFSlrJhydd0lB9OnWFfrgQ9mQFF/nPFAfMW8E8lpe+/PRXlLyW
U3UksbLIGJ75zFhykieEwnKbzQclTQl/wD6eOA6Oi/4OzOvBPB60i+K4+B4c
F9+DcSMYR1JslGiY6cGA754TUh6qssDOqLeDM4cBWb9y54145E7sZmhHK977
fG5vKQP2T/BkXAhjwqUuz1mhZxlwrXm5ypI7TIKfMVtbS0tUmfBumNnTXy8Z
xF+WLrpdOvMcpQeJTq16qE/3vUf5MtJ/8vwN7gBKCRmfs6S54JHqMibKCuDa
0rJLkXZc4mfHunGYt478srI+tsV3Mhd8xas2xOrwweZxYHXzaR6U9OQvVFgt
IHZHtEOGjr4k97xHAFLevzL6D/HB8O0yZpOLBxkP7VeFwfcvJe3hk77wyC/x
ORzn7zwXjKvEOEv8foyr3HHqkPscYy4s9RuqpXKR7nM/oH+IKh0XiPwK/abo
J0W/KdpbGbfYqmd8OSQOE+My8Tzeh+OhnRLtkminvKsis6rmFYccp27O5f9I
5oFfi1lIKMU/L3H0K3du58Hyc70xfc58KBpvXhtQKIC9g9IuGI6h+9YjvNAf
iHFh6LdFOyXyz/bhzWM+f+WTI563bPkWMypcQI7o50e6gX5+9PvrW2gmTIxk
QV32ecWrRgBRvt+iz/mz4FFoRdV9AR3XZPfl5sPhXmzi90c+L884e6NNlgNT
7lXLRn3iwMEMVb5UH4BWdWnIEkXavt3OeFrhrcKFOwaGzs0GPGhbljd79CDa
7o33XY71lLo0ggeXvAOXmFzhgerjB7LFmjy4xzl5w/o2XedzqlqETxaHB3tv
K0csMKL95RFR2UpsTQHMdFFr7Xb0gHFabE5pMZ/Atcj8q9TXXD7se7Xg1elK
ATSuWt1tGOABF89WZ4rvoOA97nOorjaAx4htX9ZecYWu/tSTF3wpPaDfauqi
za4EHpys4Z2bsxjw/CqncqscF8w4LcxsbXcI2pnYwKjnwRiP3ssdngDfvsXl
7n7Fg/2WN1/uEgKhm0NdfEtF8znkv0L+9f3LlLhwYWLL5fx3fPAIsx/7XIwL
BRbTvHxyeSDGjVmkuI6Wo+KVJ8Y820XXz0ytKjPez+aC7k7tpuaRHvDkZ3e6
tz4XQkKfpOwI8QCpND3Ti70cSGp8dquIkjufBvcPnkThpUaxT+7kBMHA+BUK
Tl6KnPqsfTxYPS5buUXDg9jRH7yyarTP9BiY70zh3RPJh7PyGDx49L5dT5Wi
I5zbxxPbKbpS/XOKbkWEAOSuahV9YNN5rglhz26Ob6X0lTW357j1CKE2zu3I
7TIetIotWxjwTAhHggQ6dTU8uM6a90mP4tOW2mqzezsovtN8dHqLqQgK5Ns+
KObS+d+vD21fOCFWAjqebB0hncQd6B+n9i+7XVLCdmkXe6N6QH7wEj65jnrL
HOXdrgWBHWzEa9TjUG9DfiacIhb+okdAnkf47yzNuhLs2sNGuoh6Cuol+Dzm
vWAeDH43zgPzYDAvBt+D88J54Lww7wXzYPB+nCfOC+eJeSmYp4J5MJgXg8/j
PHFeOE9vN+ePbCcAtcnG/NkLKL2lwyE1JlkArg6qPw9c4oBi7jkprbMCuK2b
UBibQ8cdX1XIPF9YyoHbSrM+zF0mhM9zoiqGruTBzGjpXqUQIQzteJUbGUjX
I01mhdQci+PBAt1/bN4NE5Ajyt+7j+Xu4IdS8mDIYdlKQ3vi9/RasktKdiGX
HI0XjD2rQcmNYZs8gg7bt7HxiOcvODDO1HTqgK7gScPwJWxIcou9OqZMm8hl
/61nuTbMdf76SET9v9hbpuy2yA2KXrTNyrKl49xQ70L+hXFvSFeRziJdRTqL
cWdIn5GfYRwa0lWks0hXkc6+Kb4nGk3pgV77o/PltWg6h3QP6RzSPYwrxThT
5CtXEu5aW5fywFtqqxnjFx9YeiVLPj6j4/erpPdqeN9whfbNjdYPYgXQ8e/R
nwu8Rw0zj94UDPTfUe/fYfDh86CZf+K+wtzg14J32rliLJhbz/Wv5vOBkXye
s43LhSUFS9c2/n965n983Z4Pm2Q2Bgk9ab3yXZz/IdkEIHrMznjm0O8RXMiR
LL5TmOtB+DHqd/OOXLA9nicEiSH5MpccAfawLh3akedI5qv8/nW6oxUH+rTs
87akCUB4enqfOiVX+dXIS+U/pvA3dKte8ghKzmLt8ko1t4P0W8OurZgnBO8V
DwMnVwigZEzcc6smIPaOAKu85/F+XFis0Mb4kCWEmuaj2bcLuDArcYNB2T4z
KFLJOmBpIU/6YHyzdbhrLzMY9j5bdvnN7tGw9KuTRrVjNRvtC2EVtr5ndmWR
Po3Yt/H2yvod1dG2RM5FPwr2OdzedzN1OccNfKMeiclVyRJ9xirv59ore+Wh
3v1QAUeWBZ++Jjzov/uYjfrNLj2xklmDDpK671gHfpkgJsJWi0veF57zXLxS
hk/+j45Ou/7yKF0XAvtUkb5VQdc5Wovd4Z5hkf9qbWVQO6Y2dqS3O4kTQr6D
deTn64bEMVJ45DrSD+wj9jU1yrGbIyDX11tyPMyZQuL3Rzsn2j3RrolwxT5j
CFesQ4N0BfuyDejHSPG5Jeq9pSsuO5C+Y3gd8VN+/IF5s7IciB62Znrd9kl1
jlD9PGGMQYoYaOV8W5KV70L6AKD/BfH5/bmAxcaBdJ8pvI7jpUc7146PcoHy
4255tzQdYZOqRoBtmCtca5/7vpHrSPQK9BuiHxH9hrjO2PcS9UHUv4MTLuTb
GNF1rLHvCr6/Py39QtZlJvmfx7kboq0CpK8jyuOIb0YJU+N3hNNx9Rhnj/Aq
3nLzfdBmNoy/+jEtbZwACvcclg5bQNchyZNyVpWeArDsyz9hVzcICF3FPpyI
N/j9U3Qa3z4bT/eVxOv4PUp7G1X8t9J9FfE60vmiKTqMn4k8yFk5ozpDXAjr
ahmTz2TxiL0J+7Tq1z65sVFNh9g7sV4F9m3FPpU4D3y/cqCfpJUz3ccRr+P7
m4exluYzabkM5TTS5/VP31cNe1g3usFkoL1PxwUUlHxuv4ym+14iH8U+kPhf
PytSTzlThdgfcB9hXN9/44rJQRZr+61nn0WQ+NHSITDdFiLedE46GkfXvdKI
nr3ae7UQ2uV01E50/PF7BwtJ/kBEqMkZiRdShA5MvZ9UwE7RJnkhv9+jRfgL
49e48oopxlCXPDLphTpdZx7xEtdZTF7usOogIHXYM6xWLbO4xwavjEkG+467
ELxDuMufZAT8E8iBiuIJiT35bmSdEe7D5hj8nDGBB/XGuuf0wtmEDyKfwDwU
zEvBPBTMS8E4F4z3YKj0hb0sp4/p18otGlapkCPSofVTZ7tcm6kMv3be1/vk
PpqSYxLkLp9QgXf5FfsGcVkkTwP37ZjH7elh05QJnZLn9u/WyDWDfXazN6b0
2YHtovxfo9abwTjVVTt15nMJPXzMSD/htIgLg6byZ4qC9WH2gz6/ayu4cG1o
RtrsKQZgf/P9aOF6LrQud/k2qc2QYpR1W+au5YLnu/g5svGG5Dvxu/E78bsx
rwHzHDCvAfMcvrPsz3QeMSPfjd+J343fid+N34nfjd+J3414oRUoP/LxBvq7
cR743TgPtP+m1R8POLuUrmONda2xjjXWtcbvwbwTjBvDODKMG8M4MswzwbyT
d6FfV2eNEsFBm6EaH3pq2BNnn75hqIvxkffZH1Oko7ZT332AJS+Yf2HkX31R
KDrydtHesV9EcPFYdGZIgw3IMgokPzTZQkfirh6rfHOCZwGe/vw4NRaItzCO
TXwA0Bj/yniaPCWPfmaub/0M4P+NuUai053keWDeB+Z5YN4Hyk2qsTqSdx8C
MHvMGvfv4cLJRy/Hrr0PJA8D8zIwDwPzMvZIalqd6uFCwM931d4aFF1/5Jd2
t477+7iUT/IaMM9h9I69Kw3VnGCtfuHVvO9OJC8B8xRQjp4wLb49dLY7OeJ5
zCtAPQ3lZcwzWJMY7pu5nAdT+M3MKfF8yHu0Z59SEA9Sru84FxXLh/LvD2Bo
IO9/8gjwP8blY5w+xuVjnD7a7ZDfot0O7XhYb2XuwWnzGyzcoaQ7z2FKCwts
HgYctjZwJ3aop/vvnOqeD/DQsOvtt60c+BYQK89ZBmBrftzEIIFeF9ew4Yq+
lJ6/RZoz/csqLsiNnu6zLIu6v+pE1p6JXLj8MVq29iAfRKoR30aJ8cHBdK5/
VzYfIq9EnYv9yYNeJ/6Be1V8uHhUbyqD0rfbG8ZGOI0SACM4uPTOYA84e03H
79BIt9/HJgfgaz+ta2p0/Q3vXgdS36OaWTPCJ5MB6XLamxWM3WH1za3zSnYz
QDNeTCix3B02pIvGGkYwwMknui3kIoCR5cvkKVxXOP89v/LjE4CyqSNjVo50
haItOlZL1nMJ3cd5Di9c9O71EACr0EnVYR+FcKWTE1i7ayjccPjcX9ojhN5j
u/qdS5VIXDrGqX9UPHp0yFFH4H//lf81Uh+WjVpwYaSTCLrtc5WN+yzB7HDC
V599TBj171HLhtBTzAPD53Ccwynrx2ox7GCmxHSJrSnOhN+p5m27Obmf7puE
fLe4aPa4nOHKEFg2LW67vzuh20jHkW7je+dv076XRn2H779H6rve2HLGdIYx
QWb9oyDXMgYEBlseVzVmwguDnsMRLxgQZZZVlelCrdfe9VvlmwTw7LBsy0xX
um4QwgnhhnBCuCEcEC71I2Kkd3mJCP99bXcyU3WBCHzNVls7u+uAlFns+qNe
fBInfEdw+3TwWwH5j+8ddH/p114rAzB7rZnVPUdE9JrFEbM2nh8nAh/5VAlW
hQVE+61zU5skgtvfbh8tybCAPsZPlmdUF6n7yqoseb9BtZfEtZO4lDFCm6up
zjDhSjZHzsQN+p5ukNl23RkuqcfVzFpGwWdIcWH5PGdw5N3fm9HjBqWL1cxv
RjmTukNIL9B/hHWIcN4IB5WhDZ6JPupQNCNnywmGCDJ2ND1+fFIDXj9nDVfx
oOGCcMJ54rwbz4+8Gk/xsyPxTZaPg+h5Ixxw3giH0WV3R46n9FDEH+w7hH2I
sO8Q9iHCvkPYhwj7DmEfouVeGgtSku1+y7NNZoRPIN/AuGiMk8Z54rxxnjhv
lT55KX+Kr9V5+yvlNhmApfPbuvQd2O/ZkOgXT3+qZUwQp+eNcMDzeB/uh2b3
x4N5NvS4+B4cF9+z2l5mTjybAVaHXiv3zKL7NiC8sO4P9nG4ZLR7utU9JgTu
ClTMaHYjfXeQLmMfB8QrpGfY12HoBc6c9HV8sO99tOlNK+1/lzKIyb2f6QTr
T098Ot3xTx7UbScS54tx0gUi37njh3Aguf+By6AMgLX3zh/aYcSBh6Wh2ZK7
AOIO5fRGL3Yl9j/UG1CPyK6K2zHihoDoGbi/UM5HuwHaEVCeDjReGaSpZEHs
CIiXqIejnQDtCmhnEPvzW3pzubajHW1nQPkO434wDgjt3RgH5H1/bvnBRiYs
PBTxqYJJ610kLuiPnlFj2x9TmU3rJbh+aJdAOwXO5+hHtxONmkxip8D1Qrgh
HPG9+B3e3ydyFAdz4b6bXfYiczew9WnRv2DJhZZHE2WsFWi97289DP+jHQTt
Igif/piTywL9absI0m+Eb1j/wmiREht465SG29W7EH2iX0K5PWM/DwJfPRur
YseGmpwjQ/6tt/2hSnwNaNN6Ht6PdgW0M6A+hnYOtCug3ox6tq14Xv5RlgA+
iR0e7NJD69XzIwIevXDWGxgfQMmzaCdBu8KiwtSNq6SExO6AdogfHAmvq3Mk
f+NpqYjYOazk2pS+XKbtGn/bJfA/2g8+XR/itOD4/9oNkO8zffdXf91B2xHw
OtYNxDqCLyaXsCabsH8fm12IfKVhMp9hK8OAhQ2M8zdO25D1PDtidIqJsw0c
COvOCwhkgg7Tbc72MBt4lKOu8mMok/AVvB/5CPIV5CPIVxD/b3remlV/1Y2s
08iayNuhSWxoSdvhOV6eR/xqV9ryE1eb8GBiyvOvR9LZxG+G47gaSZQfDf/D
h2w4EHG9UJK1jA0sn0ZxPQGH+LVwPZfHimV5UPvrv2MDn+gFqCeg/3lm17ba
9w6uZL03dyaV5xjJwvGz2z2WxhqA3sUTmXeKpWFa9iPB2sGWsKBq+8G4HEUo
Eizwu+XHhJCF8k5rFBWh7ClH9cIzNhlHv6Z3Ql8uGw7uj5rPmqULgsJgE3M5
ACfXqdc78w1A//39njWtbFi7n/NPRLQ+ROtdifaN4xA8nuyTdZNdzoELvD1m
wnpV2GOofPrlSQqepcZDnviokO/E9/3j2m4RIZKDqVVv9Ec764LM+5odT/Xl
oNDX41ddgC6ZB84L54HzGvYlrT7zK5vofdOen7/YMQxAO+jLAc0VxpBqMqy+
p58N0oOSkk98MoGVPlmpX+6yYXz6t/SScaNgjl5J8/o3bBhbvN5O9ooppSs8
1A6LoPVOftsnneiRXEJvs2r7/xFIcGHzIbH3779awOaaW1f9FSn951bLIdk9
FtCfHNOwYAJtF7nuIm0xfLwQ9nJsmi+qGkPI8dNy0dT12dd7L1tKjoS+QEbl
2jGU3FbwlvnOzBAM1X9taaLuD8+WaQ0UGRG9o0f9kq38Vls4sMlnpulKV1iw
Mev40wm2UBOk+vKT8VC6X/KfdUC7Kz5H6jC3McJ0KfnWceMh7kSKLjDPn2m7
dNAWqh5/3fTsBIOMi+/BdUI8QTxAvEA8QLzAdcB1QTgj3BHOCHfUi1FPxrqi
WGcU4Y7rgHDHdUC44zog//A4KWtVlEmvA64LrgOuC64DrguuA64LrgOuC+IV
4hniFeLZkrzFCW/TbaBr8smFOxrUiX+iyTxyS91QTVg8VC74n4I/8btOGuQ+
fA7lJ987wpqZljbgN/HJ6Zg09T/+QnqcAfVwqXFw3HHlczv91jnCSuUOtdOD
GUSORrl6do/C/MQIR8IXsM4iqd/1R97CuotYV5X0qcpsy/G+wIWLbzc92D+S
1qsxTgTjQtA/j/yrZsfG+7eS6Lon6F9+xOwRtUTTeV3/HeN4kMiZ9HoSjw++
0HpaIZEF/8geX+MucIfuTrWAxXtZsFXdpy8B3Akd7grQn3j/Ggs+xvsuvtzF
hohzJ7/X72eR83gfnsf7chM/DKm4wyZ2lukMqVuTXrPBT36eZmomEP3d7Xpd
N38UBzTTos3m3eaAr3l2SIcmfR7vw/N43/JVfbc6Ijhgcm7sA/tTXJhqHvd6
cDTFz191F906yCXxANVpXO22Th4k5J69venMH7n0B223dAh+OfysyAk8jK9V
uz5mg379qLOd4k4wu7VGzIuir5clFJYz/Bjg/jxJcOwgB2YG7vQXp/j8qZtH
xoivBnh/LMnUdBWT2NWHyfd8GZTMBKmjPnEt+gDNvyxbE/6NQ7q1yejFGIDa
TOFY/2QmsbeMZ3kci3QBeNoYbm1nxwUzg60PK6yo++oWxJ2w4cKFpIcLfKyB
+D3QD5Lub2KVf9yZ+JlRLoQcL/O1E34RuQrlrDGra0r2uckQOnJt5ejiVktp
SDFu9N6y3xiCmnSvHOXKQkZectztMaPIuPgeHJf0fbXnVlVJvWAjHuJ70M9V
olzSW5dewEb/wN9+L6Sn6KdKN7isUb+plo32/L/9YqEJsTli+jJQEKK74HkT
pf9805HZsFoGIm+svLn4nYjUkcW6siiXoFyDcgzKNSjHoFxD6s4VmD/eM8mF
xBGYKJSuiRzhAqxT65TDhwOc+pzZP2OtC7R4LorPoOQPzfz0VQvLXOBOkOZO
37VsOGwcu0yT+u+eufG65xA70H3AfnGUkt+27I4YsszfbmB97vF2sKtsjc7b
FBGwnc7cXWFhC09k7TKNX4lgke/+dcepee7I2ms70UiGyJEoVyL8UE5AuQDl
BJQLUE7o//fnLAK3N8tfTjz9ko11erBuD8olKKcoHWtPTG52htbZc5eOSXGF
u8rCq/0fnGGe09hlnnGucERp5v1flJ4mvTLkfIolC/xzx8TlHgGo8NujtMCU
BS16rXc8F3NhfojLJlEDQKPyCq+LAdzfx+cAJ3/8Gr/xDZfQp/+Wu54L6Xpn
u4L9+CC+zmbCOL8/8W/H+ITO2BsVfNtM6SviH+3yuj+yfx8pvbWQnT+jkNrP
OycHddRIusOasltL+p5yoEfly6DG8dR3Sn12vzBLALr8rOZUSo9Y6fJU+eM4
we9jIQ+YBibedrcY8ECwonnaOEew95z0axOHQeR2pN8Pg8Wnpfk6QmH/Wu9q
ig+k5r8bvY3iC5v/CTg/6g4lr6uNLbpwlgEV43Te2FQwfx/PMIi+O2fDYDWH
qQyYqXx3zwIzFpR92iTJBgbEj381bZKbgNjxdhgoH5RJNgLvt+qVp9QBMrWu
ap6ZKYBiv3HuX3U4cE7uudUPWbrPAPpZvi13GO6zAig+Vdv2xZDuq/JbbrYF
A5bk3thUih8r3Mycv00LlHyV58kfG0LiNjCO4/1Z5hlJMW3o42y/tzzDFoLX
WAT4TXD5fVS0g3k2/i+SsoeDnfTYYWev2oH/zU+jtaY5QrzcJm+/E3bQ0Wd+
I6XeHtSERW8azlL6/djT63QLjGCTc5dNKzWfmlzP4O2rePDk3+NbDgxt9fxy
1ksZPu4fv/PYYBGRW1GORbkV5Vjsm4t9dLFvLvbRRTkM5TKUw1Au07/RxrN4
4AZPLO/+SMtxIPaswbqT61TkhfAjdubVuNdORM55dfTN/s6CKrbUiStVrc3K
EN+i/u5MnS246N78fPQfcyiVnDflVg4XNqxkyNu+5RO7PNrpMW5v95/4PMRr
q0rvyIg+HrwrP//IerIalGzSPff2xjAQaSutHaMlAnH9szdeTraG1B7LnZlB
o2GP4rWklzrudF6oaHSeCPTIEc+fmPiiLW2dHbHD4LrgOuE8cF44D5zXb/oi
Di1r65vWXBXBfd8byw3t2ERuRPra9Gq60tZLDkQPu/2uI3T1B8xzcYBWxt7P
SyTtIXPCk8TlZ+XBtSlvtl+ZkIyD4xbXjulfc3UQzJdbO3toNdpVPeGAT7LO
7SfyxI+KftXBBsEHh0zgwo0Tckqzxc0IHiJelhg3bfO9xIIavYaLNmkaxM+5
e2no6fQ0x99wynEGqc/SsRceOZJ1w3VcYP6y4EoqH3TSrgWZGtJ9kbxO++s9
TpUn+xL3qV/Tq7Gbz/PggI5u3oZKDhxmqlxIu8ODyC+bEieWcsA6UGVSDyX3
rul33he/kUfwHPG+Iq/ySt5wrN+nQuCEcFt9JNDggp0+5MmJzY2eS61f+GZm
NfBpv1+P7OMr9Z/Z6B+cP6E4fuXlHjauP/Kbz1lvLOrMzSH4gdVEy518kPiy
+tWkO3xwsxdbNPoDxeYVC6rlz1PymsvtS7qhTLitst7ox1IHuFa7m7OuiAPN
8fUdlSvdiL4sW6ksZdPgAJoOy93i30v/Vb9QDrbL/jJbeFVI6AjSFfSDoB3x
0RfHbXplXFikuVGHL8aDJQZBhxvW/KkTtpwP/CXrjxsrUvpnN/vFihgXcEqP
DbFso+OcsF6EraKXyvmJIhCo27zqU7eFAJ8SKeEHVyLnkfzDyRqNPRR/yj9m
Xdi5kwWJgsHGz4fwQeoFM9DzFF3PaOHQYDuH6xyosr17Trr+T1zndQ6Ro1Cu
+o9NTBHCRPe9Q06u5xE4xCY6/Vox5Y8cHiyE6l9+7quCeNBRcutla5oQVAdP
k3KazYOYxzmfN64WEvn9v3lvF4La/U23h/ry4P8BgH9f/g==
        "], {{{}, {}, {}, {}, {}, {}, {}, {}, 
          {RGBColor[
           0.41451304602822947`, 0.2679594589691, 0.6996285476667962], 
           EdgeForm[None], 
           GraphicsGroupBox[{
             PolygonBox[{{3597, 3593, 207}, {1522, 1995, 689}, {3609, 3606, 
              2868}, {2868, 3380, 194}, {3599, 3596, 2451}, {3572, 3565, 
              689}, {2035, 1538, 700}, {1995, 2166, 689}, {3794, 5234, 
              1995}, {4150, 5147, 874}, {3910, 4544, 594}, {3571, 3595, 
              1397}, {4149, 5227, 874}, {3596, 3598, 2451}, {3610, 3590, 
              2409}, {1095, 2409, 688}, {3589, 3610, 2409}, {4188, 4664, 
              912}, {3567, 3611, 3380}, {3587, 3559, 2035}, {4837, 4510, 
              1397}, {3584, 3576, 953}, {4002, 4619, 700}, {2166, 1999, 
              689}, {5398, 4002, 700}, {4910, 4447, 517}, {1998, 1997, 429}, {
              4545, 3795, 429}, {3578, 3585, 1890}, {3561, 3599, 2451}, {1536,
               2868, 194}, {3600, 3603, 594}, {5149, 4291, 1062}, {3590, 3592,
               2409}, {953, 1999, 429}, {3607, 3566, 699}, {5229, 5231, 
              1062}, {1890, 874, 194}, {5232, 4673, 1522}, {3601, 3607, 
              699}, {3566, 3608, 699}, {4691, 4000, 1536}, {953, 1997, 688}, {
              3594, 3581, 1902}, {1062, 2451, 207}, {3738, 4542, 194}, {5237, 
              5236, 1998}, {4516, 3793, 1404}, {3573, 3600, 594}, {1404, 1095,
               688}, {3579, 3578, 1890}, {2827, 2107, 594}, {3575, 3584, 
              953}, {1997, 953, 429}, {5998, 5999, 2761}, {2474, 1404, 688}, {
              4664, 4189, 912}, {3605, 3604, 2827}, {1536, 1539, 699}, {3795, 
              4886, 429}, {1999, 2761, 429}, {3793, 5741, 1404}, {3612, 3567, 
              3380}, {1999, 953, 689}, {5227, 4150, 874}, {3556, 3583, 
              1397}, {4658, 3690, 207}, {5399, 5400, 2179}, {1997, 2474, 
              688}, {3577, 3602, 1538}, {3581, 3580, 1902}, {3595, 3556, 
              1397}, {3585, 3557, 1890}, {3564, 3572, 689}, {3591, 3563, 
              688}, {2868, 1536, 699}, {4834, 4835, 1658}, {3690, 3744, 
              207}, {1538, 2179, 700}, {4291, 5229, 1062}, {3846, 4910, 
              517}, {1539, 1538, 699}, {4312, 5604, 1095}},
              VertexColors->None], 
             PolygonBox[{{5400, 5398, 700, 2179}, {5604, 4149, 874, 1095}, {
              5147, 3738, 194, 874}, {3555, 3579, 1890, 194}, {4001, 5399, 
              2179, 1538}, {5338, 3910, 594, 2107}, {4693, 4001, 1538, 
              1539}, {3586, 3587, 2035, 700}, {5234, 3992, 2166, 1995}, {3992,
               5238, 1999, 2166}, {3744, 5149, 1062, 207}, {4000, 4693, 1539, 
              1536}, {3563, 3575, 953, 688}, {4293, 4516, 1404, 2474}, {4189, 
              4837, 1397, 912}, {3598, 3597, 207, 2451}, {3570, 3561, 2451, 
              1062}, {3565, 3562, 1522, 689}, {3559, 3577, 1538, 2035}, {3576,
               3564, 689, 953}, {4619, 5338, 2107, 700}, {5231, 5232, 1522, 
              1062}, {5238, 5998, 2761, 1999}, {5999, 4545, 429, 2761}, {4510,
               4834, 1658, 1397}, {5121, 4658, 207, 1902}, {4542, 4691, 1536, 
              194}, {3560, 3573, 594, 517}, {3611, 3555, 194, 3380}, {4673, 
              3794, 1995, 1522}, {5236, 5235, 1997, 1998}, {3604, 3588, 2107, 
              2827}, {3602, 3601, 699, 1538}, {3569, 3571, 1397, 1658}, {3562,
               3570, 1062, 1522}, {4886, 5237, 1998, 429}, {3608, 3609, 2868, 
              699}, {3603, 3605, 2827, 594}, {3583, 3582, 912, 1397}, {3557, 
              3568, 874, 1890}, {5741, 4312, 1095, 1404}, {3593, 3594, 1902, 
              207}, {3568, 3558, 1095, 874}, {3606, 3612, 3380, 2868}, {4544, 
              3846, 517, 594}, {3588, 3586, 700, 2107}, {3558, 3589, 2409, 
              1095}, {3592, 3591, 688, 2409}, {5235, 4293, 2474, 1997}},
              VertexColors->None], 
             PolygonBox[{{4835, 4659, 3574, 3569, 1658}, {4659, 5121, 1902, 
              3580, 3574}},
              VertexColors->None]}]}, 
          {RGBColor[
           0.44588202472007354`, 0.3225016412509203, 0.7437214420179455], 
           EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1U71rFHEQnYu3uzkP3M3e3p4gFoEUSecHZ2EnqJ2FmphYCImFGMGcSUwa
Uwkhf4BGxUIihGiIac5CUDBG/MZClOAXKPhRiCkUktS+xxuL5Tc7v/m9eTNv
pv1k48hQi5mdxrcJ31hmllfMFkOzi61mlwOz9wWzJoLWNpuFfq67/SoyO1A0
u4OYiZrZhUz/U7nZwBazvYG+JeCdgv9banajDTberiRmg7nid8P/Hd/vQP/M
QczjuH+CuNsls3FgX4vFpVY1uwn7fovOnlR2IRRn2s/AbQfeLQBnGr53XssX
xPbF4vAX2G8q4jYOuxc5FtGI7ThnwH8KGJ8RvwffaiC8B45ZR/yPqnzMP+N8
JvFmJ3yHYX9AzNlcb4ZD1ce87N+G97CbPYsVfxQ4D9GfS4hbxtlAT68EwmM9
jAkR+6hNNRGj3Coc1jDtNbLWeln2J+CXU/leRNKMvaXGr2F34t3zSPisi//M
Scwu2B1F+efBYbake77t9DtqSO2pG/H4lnfUnHzI6yM4FGPVtQTuVzPpVMik
PfsyDPtMLn5BrDjGUHvypi6/oEkzVV0vI/lZC3NyLsh5IVQ95LwrVQ7iMzfn
gxqNwnc+U30/EXMCOk3grgf5j+Wqc38sbdhz1kNfx/9+hMLnnDIvOawA51Ai
ne/hzCqKow7cJXJmPbTJYR33g6inP5KGPMk/x0xtrSpuAzHt3CXczaIfTxNx
boLXWkXvuBMjmXgQY941qqeaXc7twVhzwBkgxqjX3uVasqahmnaMON3IuZzI
z76s+txyHwZci3OIbWTS4W6qXaLWb1HTvlQ94ZyzR5yNfp811nirJCziXEf8
tkx705urd+wbd+6r8+eO/nF86jjpu8B9HUuEw1kgLu3H8PUBa873Zs738R9q
N7JX
              "],
              VertexColors->None], 
             PolygonBox[{{5228, 5226, 1990, 1991}, {4289, 5719, 1707, 1060}, {
              4336, 5767, 1338, 1126}, {5604, 4312, 2491, 2352}, {6039, 6040, 
              2806, 2805}, {4189, 4664, 1516, 1660}, {5147, 4150, 2353, 
              1925}, {3793, 4516, 1065, 427}, {3844, 4692, 1537, 1427}, {3795,
               4545, 1430, 1996}, {5271, 3817, 471, 1428}, {4664, 4188, 1659, 
              1516}, {5741, 3793, 427, 2491}, {4292, 5230, 1992, 2472}, {5236,
               5237, 1709, 1065}, {4673, 5232, 1993, 428}, {4910, 3846, 1429, 
              1727}, {5738, 4309, 1093, 1994}, {5229, 4291, 2471, 1992}, {
              4619, 4002, 2869, 1491}, {5227, 4149, 2352, 1990}, {4692, 3845, 
              1428, 1537}, {4835, 4834, 614, 1515}, {3690, 4658, 1515, 
              1889}, {5718, 5716, 1060, 2468}, {5230, 5233, 1994, 1992}, {
              5722, 5717, 2468, 2473}, {4213, 5721, 2472, 941}, {4660, 5110, 
              1889, 1515}, {5108, 5109, 1888, 2059}, {4447, 4910, 1727, 
              1338}, {4542, 3738, 1925, 1427}, {3744, 3690, 1889, 1927}, {
              4884, 5228, 1991, 1707}, {4150, 5227, 1990, 2353}, {3909, 5337, 
              1427, 593}, {5720, 3908, 593, 2470}, {5999, 5998, 690, 1430}, {
              5400, 5399, 698, 2178}, {4886, 3795, 1996, 1709}, {4544, 3910, 
              1491, 1429}, {5234, 3794, 428, 690}, {4000, 4691, 1427, 698}, {
              4786, 4787, 1126, 471}, {4002, 5398, 2178, 2869}, {5226, 4290, 
              2470, 1990}, {3928, 4821, 1649, 614}, {6040, 5298, 2059, 
              2806}, {3689, 5722, 2473, 1888}, {4173, 4660, 1515, 1649}, {
              4831, 4830, 614, 1516}, {5665, 4214, 941, 1889}, {5231, 5229, 
              1992, 1993}, {4510, 4837, 1660, 614}, {5243, 6039, 2805, 
              1093}, {4836, 4661, 1516, 1659}, {4291, 5149, 1927, 2471}},
              VertexColors->None]}]}, 
          {RGBColor[
           0.4772510034119176, 0.3770438235327406, 0.7878143363690949], 
           EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1Uz1Mk1EUvdrS9iOm/dp+/XBlUFZN/IkOglHZXBSwOqiBiEEbjDHo4OKg
MmgItlacJcQNFYlFDQPExMQ/FmqjJrq46CIxyuw5Odfh5r13333nnnvveZ2D
F46MbjSzEVgCNheZ3e8wa6XNthfMtsF+tpnN43w6Y5ZEcBO+ck7+Y7HZUmg2
E5j9wnod5zNJs5N5nbkfR+x6pPc9uH+TNbu7wawCX1Q024KYOnyzwJ0Hhxbe
nUdcL/zdWPfDbgcyxpZg1U1md2CT8L3D28HNwADmU2DMwQZSZjuxfod9AeZL
YCwAdwLxy1jPRcJqoK6z8F1LCG84EE4f3iVzqvcTYg9hvxf8F3BfQ1wD62qg
PKxxT0Z4rKsaiPsy9m05xwLOR+R9FOnuVFo9ZkwfuA3ApgNZ3WtkPvadb+/h
/DqlO/qYj7nIo+p9SHjckqkW+rtwToDDbKT7lYL6xRpZK+vnfhfmsLuoHO+z
iqO/yVrSmgvxao45hH4fiJX3IPDLsThRL6uuGd6RB3Geo/ZKrN5w/sWS+JfB
a6hDPNoz4k+e7A9X1nIRMaOR8q6D446C5sX+tdrVw2HPxRhiv3WNrQWqibi0
uveHGp9ynX+mnsFvDHFPkOdxJC5f4f8Gu5LSbKk/YpLLq1C5JlyXJcde9Nld
xn1nLG0xz9VIuai7imvvOO7HQnGf8dnz7TT+zta8sLi+iLW/ifVGLN3xf1BP
1FI/8I5G0gVn2ONzvIQePMxK/+OIXws1z1s+d/aw1/vNHnK21Dfr+guMP0XN
gXPk3BjT5N+JFdeN+wd51c1+sdfsMfl2Of8PiFkpSkMn4B/Jqv+L3jvWW3Ot
Usv7EPMsFEfOtuF5+c9+p/XX6Jt0/3+tcP8D2FOR4vpj5WMu6uVwqHrJlX2m
/x9LjLJ4
              "],
              VertexColors->None], 
             PolygonBox[{{4514, 4515, 1213, 1173}, {6012, 5737, 2487, 2775}, {
              5720, 4290, 1061, 2105}, {3844, 5337, 2106, 516}, {5987, 3789, 
              405, 1975}, {5071, 3733, 180, 1862}, {5699, 4281, 2450, 2448}, {
              5768, 5070, 1862, 2518}, {4445, 4446, 1125, 516}, {5740, 4311, 
              1094, 2450}, {5799, 4918, 1735, 2544}, {4786, 3817, 2034, 
              1622}, {4213, 5207, 1975, 2406}, {4928, 4927, 1173, 1735}, {
              4391, 5819, 2446, 1213}, {4884, 4279, 1045, 1061}, {5294, 5297, 
              2058, 515}, {4337, 4787, 1622, 2518}, {5204, 3908, 2105, 
              1972}, {3787, 5205, 1972, 404}, {5271, 4543, 1125, 2034}, {3689,
               5109, 1887, 193}, {5718, 5717, 193, 2467}, {6242, 6243, 2448, 
              405}, {5697, 5696, 404, 2444}, {5072, 4337, 2518, 1862}, {5296, 
              5799, 2544, 2058}, {3681, 5767, 2517, 180}, {5366, 4445, 516, 
              2144}, {4173, 4821, 1514, 896}, {4279, 5719, 2469, 1045}, {4827,
               4661, 219, 1653}, {5764, 5766, 2516, 1125}, {5738, 5233, 1063, 
              2488}, {3928, 4830, 1655, 1514}, {4278, 5208, 1975, 2443}, {
              4292, 5721, 2406, 1063}, {3751, 4826, 1653, 219}, {5207, 4214, 
              2407, 1975}, {4543, 3845, 516, 1125}, {5765, 4129, 1622, 
              2516}, {5203, 3975, 2144, 1972}, {3909, 5204, 1972, 2106}, {
              4820, 4172, 896, 1514}, {5665, 5110, 896, 2407}, {4280, 5695, 
              2444, 2446}, {4172, 5694, 2443, 896}, {4289, 5716, 2467, 
              2469}, {4129, 5768, 2518, 1622}, {5737, 4309, 2488, 2487}, {
              5108, 5298, 2007, 1887}, {4185, 4657, 1514, 1655}, {5295, 3843, 
              515, 1094}, {5243, 6012, 2775, 2007}, {4336, 5072, 1862, 2517}},
              
              VertexColors->None], 
             PolygonBox[{{4663, 4185, 1655, 4831, 4662}, {4184, 4663, 4662, 
              4827, 1653}},
              VertexColors->None]}]}, 
          {RGBColor[
           0.5086199821037617, 0.4315860058145608, 0.8319072307202442], 
           EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VTtMVFEQnV3gsY//vn37WAoN2JjYqI3GRjBaKZVIAhiNfAoLUQtjARYS
UFGjBARsBBI1Eo0RiIGwgoW1WUA0MTFS2FGR2KgxATyHcy1u7t13Z86cmTl3
tqbtyunLcTO7j5WHla0wOx6ZZfLNarHP43eEc6NndqEAO4zK0mZPys1uJMwS
WNMlZh9iZgdKdZ4A4AJ8HvjyvQ2cPqxV/K7DfizSXVNoNgf8EDbN2A8HZg+B
3waM3kKzt+SFOLlKYVbCPhPqbgb7m1DxG7F/LDObxfdUyizAeuWJy2xc3PYB
+yJsloA5Bsw/oe6IS4zHMe2+O3+D/STsryHnbXDtxj6K7wtF4s78xuG7mC98
3vNMmwZXqzPI5QdwxpLCaUbMFqx58BzFvg78nzh3JeRLvGewfZoU3gncHcE+
hu/94Pw7lM1R1K8e9brqKedsXDZ/YZv2dc663zyvoC8bvupfi9rUYS3BN4f4
7ajtInLaD55ngTmQp9i8J6fWEvWDvWjP4Iy1XIz8wWEveBp8J4CTC1Rb8voS
iBv7RF/m0QGs1570cBI2K7Dp9NR72tKXPfv/rRo2m0nVkD1ZL1Zf7qAODaHy
ysN5KtT9wUAaon6IwZyIczOhXrEe7EFnoXLk+bon+zjqEytVjp99nVmrU8Cs
D1RHaon6pmaYD+vC3uzgFynGLOInUduXwN1VZfY8EnZ5Wpqjb9bXPXOh3psc
Z8ZtdXVmLGqR2vwOm7VAXCeBNx1Kb9XA312l3rKum06TIWKlsXoS0gb5Mfdh
9OhFJPxV+HxyObMvW750S33dLZfGiNXjfGlHfvSdA+agr/kwA17TgWbDoMuL
39m3XEq9Y5wVV8+hAsVjLMbcdnHJn/GoDdpRq5wz3Qn50CbmOPOeb4Y+xOI8
KKuU1ojZ4XDiyKM3kj97sOrypXaZA3nWoH57sNYc9prjWhdo7rD+G+jPSChc
an3LzbTtjHpMbL5fciVP1iDr6kPN8sxe94NLTYXyOo/6nEtKP9TEuJtRtH3n
fHn/K5TNEPZHoXrxFRiXItn1wWYq0Kw5lJI+iDOCXi+n9J2aYu+Iwzl6z+VF
npxD5Ma5OOFm407tPfHk++9yeQ2Heg98Cy0VmhcDbla3ujfO/wPaMx/meisS
DrXZ497hUkq14HfOKvrxLb9Pqmfs1z/3qetg
              "],
              VertexColors->None], PolygonBox[CompressedData["
1:eJwtk0tI1GEUxa/jODMm8/7POG5SWxTUxjZFmzRyJa0ywwoitF1ZQdEiWxTa
EyoyrUVZ0JMifBCKk7ZoWzo+ioLIRTtXRpuIoOx3ui4u3O8+zn2c+9V3HN99
LGRmLUgYOZI3+5wye11pVkRiNWbJnNkYQQ1xs6P4i/gLYY+ZQJ/EZmvM8rKh
r0+breD7iwxlzAYSZocqzFojZu/Qm4i5hm+SnBL+bNbsBb6A/Mf4aqm5QK0Q
sha9Crxl4ud47yK+lpo53r/BvJs0e4O/D707ZjaLf4YaU2B3gbkTvM4C9irv
WdhPsM3HvUY25z2pl3Pk7w3MmvHfBH88avaT9yVqDDL/Nmr84n2Z9/2Q7+Qe
ehyMM+SejXlv08zTHPUeh4n/hG2J+pX4e8Be5n047D13Vpu1Bz67et6BvzHv
u9SOLqBfRBbQ28rNetG/k/+h0m0J8vvp/xUU9KgmtYvE/MH3kvlvgd0f+K6K
9HuFfhM571UzbEg7Z+JKHGoW7VS71EzvE74j7WYM/DT4+8CbQH8Ofg5fX+DY
52PO1SgctEWcs/34GnnfKfOcDPktKedGnMvXhDwIecwI8aNIDKy3ZT7rwbTv
XjMP4LuN/Ij6Ducyzpm4EuZW8LdkPXcq7LvXTeuWxYFu8xHSXeE3+pH8BqTE
+CfIn074DQlLmLNglbK+e93wAfC+4T+FfgNbR8Fz/sdWOffVgXOhG3iG7yTS
FfWch9RuFGbEexBXQc53J85GwO5Ney3t8Cn+lYL/BXF8Nel/Un9ROxsmvo6e
9qz2p9uux78Y9xtfh15X439HtlZ6awucS920bn0s5Vzq5rWLzcj1ct/JJvSN
q/uRbSbjf1b3KtsgvX7lfTri8y0l/AZ1e+JoHOzted+tctp5f1ndn/AWM15D
ujCass6huNOOhui1POl/RzfxD4nLqJY=
              "],
              VertexColors->None]}]}, 
          {RGBColor[
           0.5399889607956058, 0.48612818809638114`, 0.8760001250713937], 
           EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lUtsVHUUxg/T6WPa0pm5986dzkKg7tRQF7rQxFeMC1AXBozE14KWBkl4
7DQkAhpd0C6ASKkLcKfGRBFNqtIFxEQXLhwoPkCTutCNNaGMuHJB1O+X7+/i
5t77v+d855zvfOfciakD2/ZXIuIDXX26nhqIyPsjTlYj7hmJODQU8ZvOp3Sf
XR+xU/cl3Y+m5+khP3+5LuJ0PWJ9K2JRgMdGbY/vw1nEc0XETeF+o+tpxdgi
m0rFtvgeaUTU5HteSRzU9z9kN6NvH1d8Bs4l4fVqzu0tXVm/cSbbEQ8qRk/v
u4bsg/0+ne8p/L6lGXGlsM/3sn1C8Q4MOMe5VAv5tYW7V/Z3K//79H5N76+V
ERtkv015zCn+8Zrthjp6r5ujn4S5o+6cH8ocm7h3KO6jecSyYt2p87t0rfb7
G7kSC/9diecXBx0jrzq/1cQD32eS/RHlc135XNT3S8Lr6to7YG7mq+bnMdk8
UxjnXuVwoXQtO6v2+3Gd+SIvML9VjhuFub3PdU9X3Z/fpYGrwxGf15z7Lyn/
nvK8MWicPMWFH3rU1bVWc2/RB/09Pmqe0QXf0Rg9hNftuX3rLXMKH9iARS3Y
dtPz5XQOPvfLSRPgopOzitkS3uqY8lbced3H1IsdqmEl5Ubc8+MRX4y7zx+q
ptsa1v6b4uqTzLrapFxu79jvjM7+aVq/a6r7eqodvngm/03COJdZ3zNJT3AL
53B1NfGw9P/s6PzPQfO8Ir93mu4184QNnFMbucMvPd4vzMN91l8v4e9Wn18q
XPuC7qcK48Lj5Ii1Myn8nzPP1VbFOZulHsi21XJ+he5LpfP8SN+/Kz0vC7Kv
lI7NGbPE+bx8TxbWwqeyH2maWzDoATicbej4PM+tV+pAi+iM2k/VXQP5Py4O
s9w1snPYQczFr/J7vuHdgN6KYesBrtAYfKLrtdSX+4V5OvWROVjOPAtzaXZ5
PqHz10v370LT+wvNPpJ5Z91Mc9CtuYdj4me27njsgF7aF8wseORMz5gXNH9I
2IdL+0+oph+U/+KAc8YOm82Ze0NfXpXtWsOx4Ga55vjoGn3Dw3SaYbhlXp/M
rEF0dWLUuMS5WDoW+2+h7n3D/GEHV9jyDOdfq66vdBXyHW55FxMTTR1s22Yx
9Yyc4Z5ZgX8wjiWcpYRPDszTC7ntrqVdgu+zwmzmqQf91hHaILfZtB/Q7pWa
feCS2Pj+Jb+ybb657x7zM7ORp//CA5n/B/QGnOnEFVx2E5/UiT0ziy/88cxu
WEm7pV14J/KNvKbSfj4qLv8u/M7M0Av09lnDOxcdsJs359bjezrb2DHmDZ2/
Ubq2f7V73i8938zoTPoH8P88k3SILokP/iuyf3nc+xi8d0tjTnQcg2f20620
o7Yq1kqao7ebnmHm9z9S2h/g
              "],
              VertexColors->None], PolygonBox[CompressedData["
1:eJwtlEtI1FEUxk/TaI7Wf2b+M6PjotB2ReaiFgUZIRSZEaGBpBVpSC1Ed5WV
9lyULTJTW6S0iTZlD7ByY4tq0WZIiazAwFYZZPZY1KKo38dxceCee8/5vvO8
5S0dde0RM9uFRJE1odnPlNmBJWazeWadJWYzWbPepWYjGN4qNlteavZqmdlc
zOx32mw4brauyKylwG1P4PM45j43A7MjgeO15zn29aSfdVcN3iY459Gv4FPJ
uTFhdjzf7DN318DvQ75iO49M4/8D2c+5e7FzxzNmXQUewyxcg9h/431qkdk4
+GPEVEksb0nwPvgX4N9OLnvgyIUeo+JpQ69F70871xv8I/jXJJxLNs/heoak
iDWNDMJfiD7G+z0we9Bz5L+2yGM6i/8ZpI73L2DGsB2Iey3lI6xtxJMudMy/
nMsSHttL+KrVC+zbsJ/g7jLnLcT4nbdW8Iex/4jeyVsrNgHcWeLvJ9cGMM/B
3YXkwJ5ADgZ+p/MGMCLgjYMxim8EOV/sdzpPYtONfgppjjrGDFwVofdGPRpQ
bxJuq5p/4G069Fg0P+85v1vQ5ZNLeY7KbSv2O0OvuWpdTz0a4H6N3rGQzwpm
rQyZZt76iCHEP5XyXqknTQmfGWGrBvW8vch4b1Rz1aIk7diqyR+4mwLnVgxD
8AXYHyrwGlSBtSrptdZMPkB/GDq3ZuY2tegPvLbzMZ/t1aHnqnke4XwXCdFT
yCTcG+Puq7sbvA2Fzq27k/SrnJhH4Zsq9N05xrx+KvIdepL1nqlXmmHNwubQ
Z00zodm5g74732eoNuE7rHhUw0b496oGUZ+ZjGqT8d3QTj0ln/VJ3w3FUEEs
V7Gf0xv6SmpfXuq7rh5o9/9lPXf9AUnsH8GZijrHL3wvxv0vaEb28V6T9Foo
Ru2GZlizqx05mvUaKHflPAfW6WLn1swdJvcq9J6Y77zO+jP0V+juUtw5xaUe
KvbetO+acpigFjsW9lcx/geNBLIf
              "],
              VertexColors->None]}]}, 
          {RGBColor[
           0.5693623571995244, 0.5364690685914929, 0.9096250702197047], 
           EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNVUloVFEQ7Jksk0lM/syfzCTxpBCJ0XgRDwouuKDEBTGCHhIl5JBFRQ8G
xbgkikdBxSWKXgQFVwRBFFwQk4mJihoXUDEQVBQUweUYtyqrFQ+P//5/3dXd
1fX6j23aULc+amYnsXKwViTMqkKzPXhJF5pVYI3LM+vD80Tc7EzELBvTPgLH
Gtgugk8n7C+Vm01MmlWPwjvsx+PZn2v2KwXgUrN18LuKcwvM9gKzHX5l8Nla
ZNZRJPsI/NqKzXphexqxzgF/PnwSsP8I++vYNwLzGp7vSsyewuYu8O9hVeYp
12X5WMinH1if85TzeeBcCHU2Bb43M2a5OO/Gt/eOcwh5xdNmGwvwDX7r81XX
ZuTYUWb2zDlg/cS8jP0u7Ocin3mwTcJnFux7YsI4C5ta5BxFrMWw3QcO9mM1
wf4I4hbjbDb8WlHvnTzhFCL+YeTRDv8B+PVjFSPuIOwfh8ppaUx4DVHFaY0r
FvNizcxtcoH6x5yyeN7x73OANwPrFtpwF3iLA+E8wX5loLrJ9UiuODwXVT3E
zykUZ8yT/enxHjWCvyvg6BIw56IP9Ulpg9oh3+zJrozsaPOvTznqObXCvqdd
a8z5AWq6H1ev64DxMC7eapHnoxLFJS/X85Ur+5DjuY1BrAnIYQD77RnFZtwu
PHdmhNULnpcj1yH4d3l8cjICv6mB+nEVNd3ICPcN7IdS4r4WNg3Yv4XvNNgO
lopvaoBP5h8JxAV5+AL7ICFt1GV0xu/U9e20+OYa8lrI2VvX8ALYHA2FyTtD
TlgL9ZH1vlD79a7/1cCek5LuY8A+GKiHvX4XeB+pB76Tn4tRnRNnLPy2Qufz
csVrpfeIXFDr5LYkoXpYC+8ptUt7csQeMDfe75qU8qXNGr/P7G2l93fE+8p7
x5ibyoVDDPoRh9p8nZY+K8DxaKzdMemAuqAve7eqUN+7kde3lO7sTzyrQ+l5
eijds7/kj/j0by5Vv1nfNpzvyOj8eFJzkDOQ/enxHlEjna6T58B8gdWerzqa
PB/W2uactPqeWu0E9qeEdF0P/X5HjFOmeTApJf8hxyI3DTjvDtQf9nBhqD6x
Ps5c1siaWTs1+Tcee8S5yLnGfKi7Tu/XkkB3nnxyZrT7jOJcW+M5U1MR1wO5
Y33kgTOjpUS1k69WryuswLeE/g+cB8yR3xclNZfZ7wOBtMgz1lSQVl2TkMsw
1kuTNnt9RlWN0p5a5X+B/4cB31f5P4X5Mm/qamYo3ROD84R2tCFG9j/MDsep
Rm4zQtlwLva5De1p9ycWNDlcrhjkuMv7vrZMNff5zOhy7R0H3rFQM4D8XXQO
P4CbwYzuE/+rP1LisxnYLViDRfpfZv0+fsX5K58zI34PeQcZj7b8/zCvLf4/
+g0WSwxH
              "],
              VertexColors->None], PolygonBox[CompressedData["
1:eJwllEtIVHEUxo+jjo9qZu4d544GRUYbK1tEi4IeVEKZPVAXLjQIF2pltkiK
nlPRMiiIrMhNiyKwCIRIyEJQUyGqMYOK3FQg9IBoW0m/j7M48P/f8/rOd77/
rW4/2tQTM7O9WBEWVZgNBWZXis0ulphdiMyu8q0d5+syvifMboZmW+Nmd4m/
xTmRMttSaBaQM0x8VGl2aoFZQTnx5E7xbRHnP9To4t6JjVJ7DMsSuwz/FL7T
5BznfgJ7R3wd38oyZjnqd9H7WKnX7k15rHo0k9uEFTDEHWKOZM02g+kXWCap
0ZY2W0J8I/i+gvkvs80Hjlf4Z/BVp73XdiwX+IzyKaaVexv2KOY9hjk/xWYK
zA4Qv5rc7yk/i7MRzh1gzIPtBf1LwX8taTYQ8xp5Zt9JfgbfWuaZButyLEev
HvD14bsR+L0t5lxdT/rs4uwz9b5g+0rc30C/t+TPFXtOH7EHyRnH30vOB3xr
sMv4eqnfgv996GfldDJrBGf7wTPCzJNw+Y2aw3Hf2SF83dgE53HsDfEd1J8g
9z4czDJ/FfdLJY5JvWqxj+Y9tbvyjGPRDrsi15i09Zj7bWI3JJ2Lurhj+Z32
WsJ0MuuakVakCeN8L+H1u/n2j9j5tM+ifosrXIPSnjAptj9wn3I2iQ9q5vBP
srM8sQ34VxT7zD/Be4ZvL8H2qsy5lKakJXH6PHLNSCtFfGul947Ata8asch3
qN3sJn8X/epD50oa+ER8fcp9mlHcHs66VsTxqsA5F9c1C82eoKUhrJD7IPjX
J51DcacdrCR+sNJj9YZ+UDsXOXZp8qH6B679Rqyz0t+M3oo0OpfwN6q3KU3X
pr2GcvXmp4l9EHpuVblrV990loZr8OVD16520Ez+UvKbuM/GXdt7ks6H9Cnu
N4auNe1gG/E1ge9Cb3YUrYxlPDfF/Rm91gXOtTjQWx4I3ac3rbfcH7p29F7V
+3zk/yphOMf5bOTcaaf/AX7EquY=
              "],
              VertexColors->None]}]}, 
          {RGBColor[
           0.5924258150652623, 0.5735256279063238, 0.9101508460226225], 
           EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNVUlIlVEUPk7v+USfvsHfZ5ssCZoosKAoiFDCBqIoKGhEcSiNBq2FbtpE
u9JykxlBk5s0tEWZWVkL06LIXrqTNKFBN0Uroazv87tmi8O9/73nfuec7wz/
gtITu44nmlkzJAlSlWO2LGT2KtmswG9WCDmMfX2K2S9IG5RH0s3iOOuGjMTM
RrPNVgTMxrF+gqzE/nSWmYe7NoCuwbv3PrMP0G8NwkjUrBZnd3HXArxOHNV7
Zul4sxF6Q37pPkswK4U/ncDpTjM7GNC7C0nSex2QbzWpZichV4E1jvMivL8N
zNXAG4E/R6E/DL0hSD6kDO/OQ4LYXwLeE7wxvK2GrWM5ir08ID3qFIOP/RFh
74Tvm8Pye9gvX+lnLWz9jCqmPwlaGde1kGKm3/S34D8+ySV9rsbZZ3y/gX4F
Yu3Nkp9bYGcrZCpF8bU4/efg6it0DiWL69EUxdgE3e+w9xTfezLNFoeFO4h1
SVj4dXj7zb0lbo3jrQn6qeDqVKq4Zwz0fxq+t0X1PbMGtb8PP5fCViLy8hNy
MyB+e4H/AuJLU855x/M+2GqEFMPWJOwvj4j3x8DoCSkPrKlhlyMPto540mdM
qzIV15DTIec3cN4fFJe7oVsZkx+0TTzmlG8KfaqHbtoJz/nR6HR2RJVX8vsI
OlMx3ZFz8kEetsP+Qrwdw/lbV//08wHieBhRXlnn5I76QcTYHJZt5plck2fi
nXGYzCHzwVzkQXd+WLkkb4yTWJN+1TprhvbfOx8+uHomDxfBweWwYpzwK3Zi
7vLEy2xuuOa7midH1FmXrr25vm71CXMCvvV7sst42RPshQBi7cDdLZ96pcr1
y0vY34TzSpxXwJ/rQdUbMWszhHsuU1yT566Qcsw83AFmF2QDargEePezpF+B
+3fAeYGYxrI1azhnyD1x6edAUDOC8yEP/ubE1LsdWBeFNKPY67z/t3exkO+P
2eL8OfTXh8QH51yf688r0GmAjX0p8mPKnTMn5Jockot6l98DnBUh1UId/K/0
NCOK3CxljlhfrEXWGGs57vLI2Dgv2cu5eDsS0Z78Md5uN3Pjzv+SDOVmdqaV
u/fsyXI3uwZgvyGqOqrw1M/sX8Z0NqS42qOaX5xZ5H3YP+dPmcNkzTIm1i3j
iKWpNmbq0O8wgfMlKFus+3HXd7mwG/M0v5nb9Ijs0HZCQHnvwf28qGy1Iyf3
snXHfwjv2ty/4qTrHdYc42SMzEef62nOjLWZ2tPPAsf5XtiNePp3sEbH3LyN
u/omzjbwMegpNs7OHxHNz2msvyOa09Ql77T/F8RbD4U=
              "],
              VertexColors->None], PolygonBox[CompressedData["
1:eJwtVEtIlGEUvWP+oyPq/A/nn5k2KRHRg4IKioQIpexJIOQirShqRIRe1iKD
WhTtCs3A0gh6btKwFj2sRF2UKUEK1UrSBCNdiauedg7HxYX73e8+zr33fF/J
4eOVx7LMbC8kG7LCM3uaMsvKMxuEYTg0m3LNDkJPwVYA/YZvts8x27TAbK7Q
rLPI7BH1iFkj9LOQTzlmnyGD8N0dNxuHf13U7BzyPQvM1uBuKGb2NWG2Djnr
ED8Gn+vwzYHtRK7ZKch35G9Fjs2InUbMTegVwDiBcxmkF7F+2uxQgdliYHyO
3FcRc99U4wfuG0PFH8B9F853EN+IWvdgW4Z8/xBTD98PiAngm4bsB7YrwFSO
uwgwzaL3EfgvRG/pIuHtgAyg1h7k+OMoZyly9yI+Cv+N+WZNuOtLSTcM+hrO
LZAeRxgXwbcUchn1jsSkv0fO7jzZniC2C9KdLVsS+mlXtY/ifhT4JjCv1TFh
+o36GeDrRz8dqDeWUA3mXgWphZ4JtSvu6CJ6iwWaRRuJgNi5QL03AGMRZ5s0
e4j7hgLNuj4pbnDm+YF2zl3TZxT1xhOqRTy1wJtJaTd3YdsC7CW++FAL/wH2
G2q35NgM8Be62i1ntBb42uBfPn++gPu4qzM5OIP6mULtbtJR7q2uuMYau+Li
IM/k13LEF4eaHTnO3Oc95WLOWfRyCTHtWeL0EPIPQsqArxyyIa4Zc7YVkHbo
X5CjIap5LYVe5epMPOTuJPBN5YiD/ajdF4qL5Eh1oBrMTU7/Qr6XkCbEvoU0
++IQuUNbtSdOkovrHeV+BVuzoxrfEuqZvZITI4gd9jUfziPf1Rvk2yMeYq+K
Cysxk8vEwNrkdCvuajzVOoP3aDi/8NQ7MX1E/e2I+emIczt8vWG+Xdo4205g
isQ0Y76lylBc4Jv6G2hmrM83yN0V+8LPnS3xxEFyj2+As73ladbEexv13/ni
Envc5ovT5DJ3mAq1I/rzTfNvacH9yVz9MbkJ9cjeaHsN32nUeBPVTFcG6pm9
0kbukaM983x5jPgHgf5C9kiu7PT0V5Iz/wFxUr7M
              "],
              VertexColors->None]}]}, 
          {RGBColor[
           0.6154892729310001, 0.6105821872211546, 0.9106766218255402], 
           EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNlV+IVVUUxpd15x7v3Nude8+9c2Z8ySTqJXtJX2q0MKikjEihEGZIy6yX
SoIatSbIaxaBg39SyCIwnR4Cw0lL5qU0+jMTzVMPFfQXtRwsIqbAwrDvx7cH
eticffZZ+1vfWutb6yx68InVj18WEW9rXa71WFfEYBYxopcbGhHf90YsrkRc
p3W91oeyWarzH3r9/ndfxLe9/l7T80BPxJb5EbeUI9YKa7lwXq5HvJRH7Nfd
o/0R41rX1iLuk+1XOt8gAtv0/nzNvhqtiOPykZcibtdzkWyeFc7CIuJH+dg9
L2JUmCda9jEoux3yNyCbLmHnsrtfOBPd9nNR+xfk6892xOvydUTPS7qfiWeX
1rRsPhDmuiu8x++wzscz2z8svC/FY4XOR3X3rO7OZOb8YsV8XmtG9BeOBdu/
2rYHjyf4ZWHeqv1e7Svi3hGnC13mtaPHvjbLZlRne+b527uZ92eF+VThWMHo
SThwHJxvfGIe1PpGed4qzFrLttT00bJziM3ainlOKY6BwvzXCL8o/A28hyrG
5PvCZLNR9n+0rA/iIl/EtkD1eaBubZzW+Zmaa/GvzoYLx4M9uSa3u2S/W2uZ
OP0ivzvFdUjn66Wl9oJUN32/o2EddnR3e6oj/sgT3N4Xl2cKa2xS36a0DonD
Rp09onVc71v1nBHO5xXnnzNygg8wySPfuA/OuZJ5wf9KcViZONRKrge1+Ee1
vkffdlGXFG+15HquzG33q2zeE79luntEmn1O7yvE+7CwJ0rGOyluA0375D65
A3Of7C8J6zfxXS89H0u9cL7ivoIncdca3qPBi0mH9BC6ZE98xMk3+opv9Okh
3T1YOFfEfT7FPl2NGCs7JzeL113iP6v9zrrvYH9Kz4+0MuF+XNgOG3r0toY1
Nqn9VG7N3dS0dtEt+v057cnHgdw5wW8n9dKYfL6j+K/OzL+TakRt8Umurso9
F/A1LR/d3ebwifA/LfwO1rY0T6oN14NaUCtqBgd6azz1FzhgzNWGJ7XALz6J
nRnztdYMmpefVpozP4nvd2kGrhL/u1u229J2H6K3N2W7uXC+R8TlldyzCz+z
qf5PKs9jdfcvc5GZQp/if+Z/HNijT2xL/banJ4iFvqAXX039eKLpPqQH7xSv
G5v29Znw36h7NizJnG/mM9jnEj7645wavaW70ed3+pLeGEn5PJ30j95/T3le
nuY/ezQ/nXS/pp70JLiDsj3acL7pp8m6c/6F9vua5obumRvMOmK60Oe4mE9Z
mnvb1Suzbc+tuZnOOc9yuouuj2Xer6r7n0S86Av9oTH0uKTH8T6tWm1qON/8
C5jL6GSi6f6HJ/8o+hOO5H442TDDrmm698ZlU23Z/1DSFjb7iTF3P/O/5C41
xIZ8zWmwmnTYSfMPXe/VvT25cwxvsImLGg8l/HuVj9Vtx3wm6Z2a8t86nLic
6vcsZt79B7+HGDI=
              "],
              VertexColors->None], PolygonBox[CompressedData["
1:eJwtlEtIFVAQhke7er160/vu2qYikqDaaJtSC4NAyqiMEsHA7LnpAUFp1CIo
WyWZKRQRWNkqw0dktimjh0buC7IH0UMiKiTQiOz7mbsYOHNm5p//zOMsajpc
eyjbzOqQANKdMruOjIbMbqDnx83WIOO5ZjeRT4V+p/Nk0KwF368Rs7GQxzxG
f6Q7wIL5ZpsTZmeKzBryzPrx35LwO50HkCvYCpJmx7G3IG85VxB/DqzlSIrz
dnz2QLIe3eaZ1cChi+PioNtKYman5rjPZfShqFlbjlkzeHfA60Wqst3/KFx7
yR/Ethu8OPh13DVwrkP+gb2Pu7ucc/G5BHYB9grw68HsBHuUuwO8/yD6ILZo
sVnjXLMYb95PbAv46wKO8Rn7Me5a8W/g7gfxpUXOR5hF1DIS99iOLOqA7xdi
dgb8DbPwuQ1eTp5zHsC2ixoMU9sifMrA+hl1LGGu4vwnTZ/C8Ma+Hv/nMed6
Ep8+9BD5ptHD2I+g16C/ynWOYfQTcHgB90r8Y5y3Rbz2qs8CsBbGHOshPdhE
bD05JwOOUY3vy0w+9WQq4TVXrTUD1TGfAfVeHJrBzyf+W2Z+foG3NNPPBnzC
cX+z3qqa1ia8ZqrVIPYlxPbx3pKw16QA29aE23pyndu2Qp9lcTyPrS3hs6sa
X1O/Cz2XOLeT+wEx5eSvIH6aWs8gy0L+Xs2qZkyzpZnV7I+kfNa1A884P0Gm
wM7nLgC3nLTX7jXxTWCNka8d/n+5uw/fnrjPZhlykfxthT5rleTvVC2irq9F
34jvhrj3VjkmI76Dqp16NoTtXtx7pxjtUiP5xwt8pzRLmnHNtmbqXdJ7qret
wD7L225l+HzHPoF9ZcRtqsF79AnwTof9DW/QSyO+q7L/Bv8sGFeZxaqA97Yr
5tzV4zHO8zPzox3S3/I05bXSH9Of9hqpNuqpuPdHvJd6Qzl4I2nvjf4YcfmQ
9NziJOzizHuUQ7u5N+VctKOtcAsn/a8RxzS24pT3R/+Hdmd11HdVO6RZmOHu
Y9hnQrO5I/MfaUZlG8bnQpb7aBc7Yt477eQote6O+q7JR7vfmfTaal//A8XQ
uYo=
              "],
         