(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    418649,      13695]
NotebookOptionsPosition[    386384,      12648]
NotebookOutlinePosition[    388888,      12733]
CellTagsIndexPosition[    388287,      12712]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Solutions to text problems\n",
 StyleBox["Empirical Market Microstructure",
  FontSlant->"Italic"],
 " \n\t(2006, Oxford University Press)\nCompanion ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook\n\nJoel Hasbrouck\n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Copyright", " ", "2007"}], ",", " ", 
    RowBox[{"Joel", " ", 
     RowBox[{"Hasbrouck", ".", " ", "All"}], " ", "rights", " ", 
     RowBox[{"reserved", "."}]}]}], TraditionalForm]],
  FontSize->14,
  FontSlant->"Italic"]
}], "Title",
 CellChangeTimes->{{3.3896255910914*^9, 3.3896255932033997`*^9}, {
   3.3897167078988237`*^9, 3.389716768500824*^9}, 3.3897219191158237`*^9, {
   3.3897220399168243`*^9, 3.3897220640418243`*^9}, {3.3900309756364307`*^9, 
   3.39003097613043*^9}, {3.39003125878343*^9, 3.3900312813864307`*^9}}],

Cell[CellGroupData[{

Cell["Exercise 4.1 (Source notebook: RollBasicAndGeneralized)", "Subsection",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3907328007766*^9, 3.3907328059596*^9}, {
  3.3907328497046003`*^9, 3.3907328673705997`*^9}},
 CellTags->"Ch4Ex3period"],

Cell[TextData[{
 "Here is a function to build a table of all possible ",
 Cell[BoxData["n"]],
 " successive realizations of ",
 Cell[BoxData["q"]],
 "."
}], "Text",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"qTable", "[", "n_", "]"}], ":=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "^", 
      RowBox[{"IntegerDigits", "[", 
       RowBox[{"i", ",", "2", ",", "n"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", 
       RowBox[{
        SuperscriptBox["2", "n"], "-", "1"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell["... and for the 3-period problem, the realizations are:", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"q", "=", 
   RowBox[{"qTable", "[", "3", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"TableForm", "[", 
  RowBox[{"q", ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\!\(\*SubscriptBox[\(q\), \(0\)]\)\>\"", ",", 
        "\"\<\!\(\*SubscriptBox[\(q\), \(1\)]\)\>\"", ",", 
        "\"\<\!\(\*SubscriptBox[\(q\), \(2\)]\)\>\""}], "}"}]}], "}"}]}], ",",
    
   RowBox[{"TableAlignments", "\[Rule]", "Right"}]}], "]"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      StyleBox["\[Null]",
       ShowStringCharacters->False], 
      TagBox["\<\"\\!\\(\\*SubscriptBox[\\(q\\), \\(0\\)]\\)\"\>",
       HoldForm], 
      TagBox["\<\"\\!\\(\\*SubscriptBox[\\(q\\), \\(1\\)]\\)\"\>",
       HoldForm], 
      TagBox["\<\"\\!\\(\\*SubscriptBox[\\(q\\), \\(2\\)]\\)\"\>",
       HoldForm]},
     {"1", "1", "1", "1"},
     {"2", "1", "1", 
      RowBox[{"-", "1"}]},
     {"3", "1", 
      RowBox[{"-", "1"}], "1"},
     {"4", "1", 
      RowBox[{"-", "1"}], 
      RowBox[{"-", "1"}]},
     {"5", 
      RowBox[{"-", "1"}], "1", "1"},
     {"6", 
      RowBox[{"-", "1"}], "1", 
      RowBox[{"-", "1"}]},
     {"7", 
      RowBox[{"-", "1"}], 
      RowBox[{"-", "1"}], "1"},
     {"8", 
      RowBox[{"-", "1"}], 
      RowBox[{"-", "1"}], 
      RowBox[{"-", "1"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
      "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   TableForm[
   BoxForm`e$, 
    TableHeadings -> {
     Automatic, {
      "\!\(\*SubscriptBox[\(q\), \(0\)]\)", 
       "\!\(\*SubscriptBox[\(q\), \(1\)]\)", 
       "\!\(\*SubscriptBox[\(q\), \(2\)]\)"}}, TableAlignments -> 
    Right]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522810774*^9, 3.3895615251274*^9, 3.3895616661198*^9, 
   3.3899894642511997`*^9, {3.3899901630296*^9, 3.3899901846316*^9}}]
}, Open  ]],

Cell["The transition probabilities for each path are:", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PrTrans", "[", "q_", "]"}], ":=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"q", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}], "\[Equal]", 
        RowBox[{"q", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", 
           RowBox[{"j", "-", "1"}]}], "]"}], "]"}]}], ",", "\[Alpha]", ",", 
       RowBox[{"1", "-", "\[Alpha]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "q", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "2", ",", 
       RowBox[{
        RowBox[{"Dimensions", "[", "q", "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"qp", "=", 
   RowBox[{"PrTrans", "[", "q", "]"}]}], ";"}], "\n", 
 RowBox[{"TableForm", "[", 
  RowBox[{"qp", ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\!\(\*SubscriptBox[\(Pr\), \(0 \[Rule] 1\)]\)\>\"", ",", 
        "\"\<\!\(\*SubscriptBox[\(Pr\), \(1 \[Rule] 2\)]\)\>\""}], "}"}]}], 
     "}"}]}], ",", 
   RowBox[{"TableAlignments", "\[Rule]", "Right"}]}], "]"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      StyleBox["\[Null]",
       ShowStringCharacters->False], 
      TagBox["\<\"\\!\\(\\*SubscriptBox[\\(Pr\\), \\(0 \[Rule] 1\\)]\\)\"\>",
       HoldForm], 
      TagBox["\<\"\\!\\(\\*SubscriptBox[\\(Pr\\), \\(1 \[Rule] 2\\)]\\)\"\>",
       HoldForm]},
     {"1", "\[Alpha]", "\[Alpha]"},
     {"2", "\[Alpha]", 
      RowBox[{"1", "-", "\[Alpha]"}]},
     {"3", 
      RowBox[{"1", "-", "\[Alpha]"}], 
      RowBox[{"1", "-", "\[Alpha]"}]},
     {"4", 
      RowBox[{"1", "-", "\[Alpha]"}], "\[Alpha]"},
     {"5", 
      RowBox[{"1", "-", "\[Alpha]"}], "\[Alpha]"},
     {"6", 
      RowBox[{"1", "-", "\[Alpha]"}], 
      RowBox[{"1", "-", "\[Alpha]"}]},
     {"7", "\[Alpha]", 
      RowBox[{"1", "-", "\[Alpha]"}]},
     {"8", "\[Alpha]", "\[Alpha]"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
      "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   TableForm[
   BoxForm`e$, 
    TableHeadings -> {
     Automatic, {
      "\!\(\*SubscriptBox[\(Pr\), \(0 \[Rule] 1\)]\)", 
       "\!\(\*SubscriptBox[\(Pr\), \(1 \[Rule] 2\)]\)"}}, TableAlignments -> 
    Right]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522811134*^9, 3.3895615251674*^9, 3.3895616661598*^9, 
   3.3899894643012*^9, {3.3899901631226*^9, 3.3899901846846*^9}}]
}, Open  ]],

Cell["The total probabilities of each path are:", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"TotalProbs", "=", 
   RowBox[{
    RowBox[{"Apply", "[", 
     RowBox[{"Times", ",", "qp", ",", 
      RowBox[{"{", "1", "}"}]}], "]"}], "/", "2"}]}], ";"}], "\n", 
 RowBox[{"TableForm", "[", 
  RowBox[{"TotalProbs", ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", 
      RowBox[{"{", "\"\<\!\(\*SubscriptBox[\(Pr\), \(Total\)]\)\>\"", "}"}]}],
      "}"}]}], ",", 
   RowBox[{"TableAlignments", "\[Rule]", "Right"}]}], "]"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {"1", 
      FractionBox[
       SuperscriptBox["\[Alpha]", "2"], "2"]},
     {"2", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "\[Alpha]"}], ")"}], " ", "\[Alpha]"}]},
     {"3", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "\[Alpha]"}], ")"}], "2"]}]},
     {"4", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "\[Alpha]"}], ")"}], " ", "\[Alpha]"}]},
     {"5", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "\[Alpha]"}], ")"}], " ", "\[Alpha]"}]},
     {"6", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "\[Alpha]"}], ")"}], "2"]}]},
     {"7", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "\[Alpha]"}], ")"}], " ", "\[Alpha]"}]},
     {"8", 
      FractionBox[
       SuperscriptBox["\[Alpha]", "2"], "2"]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxDividers->{
     "Columns" -> {False, {True}, False}, "ColumnsIndexed" -> {}, 
      "Rows" -> {{False}}, "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   OutputFormsDump`HeadedColumn],
  Function[BoxForm`e$, 
   TableForm[
   BoxForm`e$, 
    TableHeadings -> {Automatic, {"\!\(\*SubscriptBox[\(Pr\), \(Total\)]\)"}},
     TableAlignments -> Right]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522811544*^9, 3.3895615252104*^9, 3.3895616661928*^9, 
   3.3899894643492002`*^9, {3.3899901632366*^9, 3.3899901847626*^9}}]
}, Open  ]],

Cell["Verify that the probabilities sum to one:", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Total", "[", "TotalProbs", "]"}], "//", "Simplify"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData["1"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522811893997`*^9, 3.3895615252474003`*^9, 3.3895616662268*^9, 
   3.3899894643972*^9, {3.3899901633136*^9, 3.3899901848296003`*^9}}]
}, Open  ]],

Cell[TextData[{
 "Compute the ",
 Cell[BoxData[
  SubscriptBox["v", "t"]]],
 "'s using the definition ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["v", "t"], "=", 
   RowBox[{
    SubscriptBox["q", "t"], "-", 
    RowBox[{
     SubscriptBox["\[Phi]q", 
      RowBox[{"t", "-", "1"}]], ":"}]}]}]]]
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{
    RowBox[{"q", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}], "-", 
    RowBox[{"\[Phi]", " ", 
     RowBox[{"q", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}]}]}], ";"}], "\n", 
 RowBox[{"TableForm", "[", 
  RowBox[{"v", ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\!\(\*SubscriptBox[\(v\), \(1\)]\)\>\"", ",", 
        "\"\<\!\(\*SubscriptBox[\(v\), \(2\)]\)\>\""}], "}"}]}], "}"}]}], ",",
    
   RowBox[{"TableAlignments", "\[Rule]", "Right"}]}], "]"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      StyleBox["\[Null]",
       ShowStringCharacters->False], 
      TagBox["\<\"\\!\\(\\*SubscriptBox[\\(v\\), \\(1\\)]\\)\"\>",
       HoldForm], 
      TagBox["\<\"\\!\\(\\*SubscriptBox[\\(v\\), \\(2\\)]\\)\"\>",
       HoldForm]},
     {"1", 
      RowBox[{"1", "-", "\[Phi]"}], 
      RowBox[{"1", "-", "\[Phi]"}]},
     {"2", 
      RowBox[{"1", "-", "\[Phi]"}], 
      RowBox[{
       RowBox[{"-", "1"}], "-", "\[Phi]"}]},
     {"3", 
      RowBox[{
       RowBox[{"-", "1"}], "-", "\[Phi]"}], 
      RowBox[{"1", "+", "\[Phi]"}]},
     {"4", 
      RowBox[{
       RowBox[{"-", "1"}], "-", "\[Phi]"}], 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Phi]"}]},
     {"5", 
      RowBox[{"1", "+", "\[Phi]"}], 
      RowBox[{"1", "-", "\[Phi]"}]},
     {"6", 
      RowBox[{"1", "+", "\[Phi]"}], 
      RowBox[{
       RowBox[{"-", "1"}], "-", "\[Phi]"}]},
     {"7", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Phi]"}], 
      RowBox[{"1", "+", "\[Phi]"}]},
     {"8", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Phi]"}], 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Phi]"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
      "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   TableForm[
   BoxForm`e$, 
    TableHeadings -> {
     Automatic, {
      "\!\(\*SubscriptBox[\(v\), \(1\)]\)", 
       "\!\(\*SubscriptBox[\(v\), \(2\)]\)"}}, TableAlignments -> 
    Right]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522812254*^9, 3.3895615252864*^9, 3.3895616662618*^9, 
   3.3899894644482*^9, {3.3899901634046*^9, 3.3899901848956003`*^9}}]
}, Open  ]],

Cell[TextData[{
 "Verify that ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["Ev", "1"], "=", 
   RowBox[{
    SubscriptBox["Ev", "2"], "=", "0"}]}]]],
 ":"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"TotalProbs", ".", 
   RowBox[{"v", "[", 
    RowBox[{"[", "All", "]"}], "]"}]}], "//", "Simplify"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522812614*^9, 3.3895615253254004`*^9, 3.3895616662948*^9, 
   3.3899894644962*^9, {3.3899901634826*^9, 3.3899901849596*^9}}]
}, Open  ]],

Cell[TextData[{
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Var", 
    RowBox[{"(", 
     SubscriptBox["v", "t"], ")"}]}], "\[Congruent]", 
   SubscriptBox["\[Gamma]", "0"]}]]]
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Gamma]", "0"], "=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"TotalProbs", ".", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"v", "[", 
        RowBox[{"[", "All", "]"}], "]"}], "^", "2"}], ")"}]}], "//", 
    "Simplify"}], ")"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", "-", 
       RowBox[{"4", " ", "\[Alpha]"}]}], ")"}], " ", "\[Phi]"}], "+", 
    SuperscriptBox["\[Phi]", "2"]}], ",", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", "-", 
       RowBox[{"4", " ", "\[Alpha]"}]}], ")"}], " ", "\[Phi]"}], "+", 
    SuperscriptBox["\[Phi]", "2"]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522812974*^9, 3.3895615253684*^9, 3.3895616663308*^9, 
   3.3899894645481997`*^9, {3.3899901635666*^9, 3.3899901850276003`*^9}}]
}, Open  ]],

Cell[TextData[{
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Cov", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["v", "t"], ",", 
      SubscriptBox["v", 
       RowBox[{"t", "-", "1"}]]}], ")"}]}], "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["Ev", "t"], 
     SubscriptBox["v", 
      RowBox[{"t", "-", "1"}]]}], "\[Congruent]", 
    SubscriptBox["\[Gamma]", "1"]}]}]]]
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Gamma]", "1"], "=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"TotalProbs", ".", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"v", "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", "1"}], "]"}], "]"}], " ", 
       RowBox[{"v", "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", "2"}], "]"}], "]"}]}], ")"}]}], "//", 
    "Simplify"}], ")"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "4"}], " ", 
   SuperscriptBox["\[Alpha]", "2"], " ", "\[Phi]"}], "-", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", "\[Phi]"}], ")"}], "2"], "+", 
  RowBox[{"2", " ", "\[Alpha]", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Phi]"}], ")"}], "2"]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522813824*^9, 3.3895615254133997`*^9, 3.3895616663747997`*^9, 
   3.3899894646122*^9, {3.3899901636616*^9, 3.3899901851116*^9}}]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox["v", "t"]]],
 " must be uncorrelated, so solve for the value of ",
 Cell[BoxData["\[Phi]"]],
 " that makes ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Gamma]", "1"], "=", "0"}]]],
 ":"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Gamma]", "1"], "\[Equal]", "0"}], ",", "\[Phi]"}], 
   "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Phi]", "\[Rule]", 
     FractionBox["1", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"2", " ", "\[Alpha]"}]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "\[Alpha]"}]}]}], "}"}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522814894*^9, 3.3895615254494*^9, 3.3895616664077997`*^9, 
   3.3899894646982*^9, {3.3899901637466*^9, 3.3899901851846*^9}}]
}, Open  ]],

Cell[TextData[{
 "There are two solutions, but only the second has ",
 Cell[BoxData[
  RowBox[{"|", "\[Phi]", "|", 
   RowBox[{"<", "1"}]}]]],
 ". For example,"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Phi]", "/.", "s"}], "/.", 
  RowBox[{"\[Alpha]", "\[Rule]", ".6"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.000000000000001`", ",", "0.19999999999999996`"}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522815224*^9, 3.3895615254854*^9, 3.3895616664398003`*^9, 
   3.3899894647462*^9, {3.3899901638296003`*^9, 3.3899901852586*^9}}]
}, Open  ]],

Cell["So, take the second solution:", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"s", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "1"}], "]"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"\[Phi]", "\[Rule]", 
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{"2", " ", "\[Alpha]"}]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522815573997`*^9, 3.3895615255224*^9, 3.3895616664748*^9, 
   3.3899894647972*^9, {3.3899901639116*^9, 3.3899901853336*^9}}]
}, Open  ]],

Cell[TextData[{
 "Verify that this results in ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Gamma]", "1"], "=", "0"}]]],
 ":"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TotalProbs", ".", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"v", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "1"}], "]"}], "]"}], 
      RowBox[{"v", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "2"}], "]"}], "]"}]}], ")"}]}], "/.", "s"}], "//",
   "Simplify"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData["0"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522815924*^9, 3.3895615255643997`*^9, 3.3895616665088*^9, 
   3.3899894648472*^9, {3.3899901639936*^9, 3.3899901854066*^9}}]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox["v", "t"]]],
 "'s have no skewness:"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TotalProbs", ".", 
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"v", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "2"}], "]"}], "]"}], "3"], ")"}]}], "/.", "s"}], "//",
   "Simplify"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData["0"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522816284*^9, 3.3895615256004*^9, 3.3895616665397997`*^9, 
   3.3899894649002*^9, {3.3899901640826*^9, 3.3899901854816*^9}}]
}, Open  ]],

Cell[TextData[{
 "Verify that the higher-order serial moment is non-zero, i.e., ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Cov", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["v", 
       RowBox[{"t", "-", "1"}]], ",", 
      SubsuperscriptBox["v", "t", "3"]}], ")"}]}], "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["Ev", 
      RowBox[{"t", "-", "1"}]], 
     SubsuperscriptBox["v", "t", "3"]}], "\[NotEqual]", "0"}]}]]]
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TotalProbs", ".", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"v", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "1"}], "]"}], "]"}], "*", 
      SuperscriptBox[
       RowBox[{"v", "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", "2"}], "]"}], "]"}], "3"]}], ")"}]}], "/.", 
   "s"}], "//", "Simplify"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "32"}], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "\[Alpha]"}], ")"}], "2"], " ", 
  SuperscriptBox["\[Alpha]", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"2", " ", "\[Alpha]"}]}], ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522816674*^9, 3.3895615256384*^9, 3.3895616665788*^9, 
   3.3899894649992*^9, {3.3899901641736*^9, 3.3899901855606003`*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"ClearAll", "[", 
  RowBox[{"q", ",", "u", ",", "v", ",", 
   SubscriptBox["\[Gamma]", "0"], ",", 
   SubscriptBox["\[Gamma]", "1"]}], "]"}]], "Input",
 CellLabelAutoDelete->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4.2 (Source notebook: RollBasicAndGeneralized)", "Subsection",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3907328922855997`*^9, 3.3907328930976*^9}},
 CellTags->"Ch4ExCorrq"],

Cell["The model is:", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["m", "Rule"], "=", 
   RowBox[{
    SubscriptBox["m", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", 
      RowBox[{"t", "-", "1"}]], "+", 
     SubscriptBox["u", "t"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["p", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", "t"], "+", 
     RowBox[{"c", " ", 
      SubscriptBox["q", "t"]}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["\[CapitalDelta]p", "t_"], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["p", "t"], "/.", "\[InvisibleSpace]", 
        SubscriptBox["p", "Rule"]}], "/.", "\[InvisibleSpace]", 
       SubscriptBox["m", "Rule"]}], ")"}], "-", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["p", 
        RowBox[{"t", "-", "1"}]], "/.", "\[InvisibleSpace]", 
       SubscriptBox["p", "Rule"]}], ")"}]}]}]}], ";"}], "\n", 
 RowBox[{
  SubscriptBox["\[CapitalDelta]p", "t"], "/.", 
  SubscriptBox["\[CapitalDelta]p", "Rule"]}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "c"}], " ", 
   SubscriptBox["q", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "t"}]]}], "+", 
  RowBox[{"c", " ", 
   SubscriptBox["q", "t"]}], "+", 
  SubscriptBox["u", "t"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522818073997`*^9, 3.3895615257014*^9, 
  3.3895616666317997`*^9, 3.3899894650931997`*^9, 3.3899901642676*^9, 
  3.3899903565025997`*^9, 3.3899911793086*^9}]
}, Open  ]],

Cell[TextData[{
 "We need some alternate rules for the expectation operator to recognize the \
correlation between ",
 Cell[BoxData[
  SubscriptBox["q", "t"]]],
 " and ",
 Cell[BoxData[
  SubscriptBox["q", 
   RowBox[{"t", "-", "1"}]]]],
 "."
}], "Text",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[ScriptCapitalE]Alternate", "Rules"], "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       SubsuperscriptBox["q", "_", "2"], "]"}], "\[Rule]", "1"}], ",", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       SubsuperscriptBox["u", "_", "2"], "]"}], "\[Rule]", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{
        SubscriptBox["q", "_"], 
        SubscriptBox["u", "_"]}], "]"}], "\[Rule]", " ", "0"}], ",", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{
        SubscriptBox["q", "t_"], 
        SubscriptBox["q", "s_"]}], "]"}], "\[RuleDelayed]", " ", 
      RowBox[{"0", "/;", 
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"t", "-", "s"}], "]"}], ">", "1"}]}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{
        SubscriptBox["q", "t_"], 
        SubscriptBox["q", "s_"]}], "]"}], "\[RuleDelayed]", " ", 
      RowBox[{"\[Rho]", "/;", 
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"t", "-", "s"}], "]"}], "\[Equal]", "1"}]}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{
        SubscriptBox["u", "t_"], 
        SubscriptBox["u", "s_"]}], "]"}], "\[RuleDelayed]", " ", 
      RowBox[{"0", "/;", 
       RowBox[{"t", "=!=", "s"}]}]}]}], "}"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3899902779536*^9, 3.3899902974196*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[ScriptCapitalE]", "Rules"], "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     SubscriptBox["\[ScriptCapitalE]Alternate", "Rules"], ",", 
     SubscriptBox["\[ScriptCapitalE]Linearity", "Rules"]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.3899910600936003`*^9, 3.3899910656446*^9}},
 CellLabel->"In[59]:="],

Cell["\<\
To get the variance, we multiply everything out, and take the expectation:\
\>", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[ScriptCapitalE]", "[", 
  RowBox[{"Expand", "[", 
   RowBox[{
    SubsuperscriptBox["\[CapitalDelta]p", "t", "2"], "/.", 
    SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"\[ScriptCapitalE]", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["c", "2"], " ", 
    SubsuperscriptBox["q", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "t"}], "2"]}], "-", 
   RowBox[{"2", " ", 
    SuperscriptBox["c", "2"], " ", 
    SubscriptBox["q", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "t"}]], " ", 
    SubscriptBox["q", "t"]}], "+", 
   RowBox[{
    SuperscriptBox["c", "2"], " ", 
    SubsuperscriptBox["q", "t", "2"]}], "-", 
   RowBox[{"2", " ", "c", " ", 
    SubscriptBox["q", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "t"}]], " ", 
    SubscriptBox["u", "t"]}], "+", 
   RowBox[{"2", " ", "c", " ", 
    SubscriptBox["q", "t"], " ", 
    SubscriptBox["u", "t"]}], "+", 
   SubsuperscriptBox["u", "t", "2"]}], "]"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522818803997`*^9, 3.3895615257844*^9, 3.3895616667008*^9, 
   3.3899894652061996`*^9, 3.3899901644666*^9, 3.3899903566566*^9, {
   3.3899904271935997`*^9, 3.3899904484146*^9}, 3.3899911793866*^9}]
}, Open  ]],

Cell["\<\
Using the rules described about to eliminate terms that have zero \
expectation:\
\>", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "//.", 
   SubscriptBox["\[ScriptCapitalE]", "Rules"]}], "//", "Simplify"}]], "Input",\

 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3899903087226*^9, 3.3899903217586*^9}, {
   3.3899904183496*^9, 3.3899904401496*^9}, 3.3899910778696003`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "2"}], " ", 
   SuperscriptBox["c", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "\[Rho]"}], ")"}]}], "+", 
  SubsuperscriptBox["\[Sigma]", "u", "2"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522819214*^9, 3.3895615258324003`*^9, 3.3895616667377996`*^9, 
   3.3899894652642*^9, 3.3899901645536003`*^9, 3.3899903567256002`*^9, {
   3.3899904294156*^9, 3.3899904502576*^9}, 3.3899911794466*^9}]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Cov", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[CapitalDelta]p", "t"], ",", 
     SubscriptBox["\[CapitalDelta]p", 
      RowBox[{"t", "-", "1"}]]}], ")"}]}]]],
 ":"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[ScriptCapitalE]", "[", 
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[CapitalDelta]p", "t"], 
     SubscriptBox["\[CapitalDelta]p", 
      RowBox[{"t", "-", "1"}]]}], "/.", 
    SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"\[ScriptCapitalE]", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["c", "2"], " ", 
    SubscriptBox["q", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "t"}]], " ", 
    SubscriptBox["q", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "t"}]]}], "-", 
   RowBox[{
    SuperscriptBox["c", "2"], " ", 
    SubsuperscriptBox["q", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "t"}], "2"]}], "-", 
   RowBox[{
    SuperscriptBox["c", "2"], " ", 
    SubscriptBox["q", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "t"}]], " ", 
    SubscriptBox["q", "t"]}], "+", 
   RowBox[{
    SuperscriptBox["c", "2"], " ", 
    SubscriptBox["q", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "t"}]], " ", 
    SubscriptBox["q", "t"]}], "-", 
   RowBox[{"c", " ", 
    SubscriptBox["q", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "t"}]], " ", 
    SubscriptBox["u", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "t"}]]}], "+", 
   RowBox[{"c", " ", 
    SubscriptBox["q", "t"], " ", 
    SubscriptBox["u", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "t"}]]}], "-", 
   RowBox[{"c", " ", 
    SubscriptBox["q", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "t"}]], " ", 
    SubscriptBox["u", "t"]}], "+", 
   RowBox[{"c", " ", 
    SubscriptBox["q", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "t"}]], " ", 
    SubscriptBox["u", "t"]}], "+", 
   RowBox[{
    SubscriptBox["u", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "t"}]], " ", 
    SubscriptBox["u", "t"]}]}], "]"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522819564*^9, 3.3895615258704*^9, 3.3895616667768*^9,
   3.3899894653192*^9, 3.3899901646366*^9, 3.3899903567836*^9, 
  3.3899911794996*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[ScriptCapitalE]", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[CapitalDelta]p", "t"], 
       SubscriptBox["\[CapitalDelta]p", 
        RowBox[{"t", "-", "1"}]]}], "/.", 
      SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}], "]"}], "//.", 
   SubscriptBox["\[ScriptCapitalE]", "Rules"]}], "//", 
  "FullSimplify"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3899903352766*^9, 3.3899903378986*^9}, 
   3.3899904656326*^9, 3.3899910832785997`*^9}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["c", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"2", " ", "\[Rho]"}]}], ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522824424*^9, 3.3895615259904003`*^9, 
  3.3895616668648*^9, 3.3899894658772*^9, 3.3899901650336*^9, 
  3.3899903581956*^9, 3.3899904665046*^9, 3.3899911796776*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[ScriptCapitalE]", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[CapitalDelta]p", "t"], 
       SubscriptBox["\[CapitalDelta]p", 
        RowBox[{"t", "-", "2"}]]}], "/.", 
      SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}], "]"}], "//.", 
   SubscriptBox["\[ScriptCapitalE]", "Rules"]}], "//", "Simplify"}]], "Input",\

 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3899903416036*^9, 3.3899904723096*^9, 3.3899910878456*^9}
  ],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SuperscriptBox["c", "2"]}], " ", "\[Rho]"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522825234003`*^9, 3.3895615260344*^9, 
  3.3895616668968*^9, 3.3899894659382*^9, 3.3899901651286*^9, 
  3.3899903582886*^9, 3.3899904727706003`*^9, 3.3899911797306004`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[ScriptCapitalE]", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[CapitalDelta]p", "t"], 
       SubscriptBox["\[CapitalDelta]p", 
        RowBox[{"t", "-", "3"}]]}], "/.", 
      SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}], "]"}], "//.", 
   SubscriptBox["\[ScriptCapitalE]", "Rules"]}], "//", "Simplify"}]], "Input",\

 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3899903460906*^9, 3.3899904841786003`*^9, 
  3.3899910929026003`*^9}],

Cell[BoxData["0"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3895522825584*^9, 3.3895615260704*^9, 3.3895616669288*^9, 
   3.3899894660332003`*^9, 3.3899901652236*^9, 3.3899903583716*^9, {
   3.3899904782866*^9, 3.3899904855536003`*^9}, 3.3899911797846003`*^9}]
}, Open  ]],

Cell[TextData[{
 "Verify that ",
 Cell[BoxData[
  RowBox[{
   SqrtBox[
    RowBox[{
     RowBox[{"-", "Cov"}], 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[CapitalDelta]p", "t"], ",", 
       SubscriptBox["\[CapitalDelta]p", 
        RowBox[{"t", "-", "1"}]]}], ")"}]}]], "<", "c"}]]],
 ":"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    SqrtBox[
     RowBox[{
      RowBox[{"-", 
       RowBox[{"\[ScriptCapitalE]", "[", 
        RowBox[{"Expand", "[", 
         RowBox[{
          RowBox[{
           SubscriptBox["\[CapitalDelta]p", "t"], 
           SubscriptBox["\[CapitalDelta]p", 
            RowBox[{"t", "-", "1"}]]}], "/.", 
          SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}], "]"}]}], "//.", 
      SubscriptBox["\[ScriptCapitalE]", "Rules"]}]], "<", "c"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"0", "<", "\[Rho]", "<", 
       RowBox[{"1", "/", "2"}]}], ",", 
      RowBox[{"c", ">", "0"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3899905112976*^9, 3.3899905123076*^9}, 
   3.3899910983536*^9}],

Cell[BoxData["True"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522827244*^9, 3.3895615261284*^9, 3.3895616669788*^9,
   3.3899894661252003`*^9, 3.3899901653656*^9, 3.3899903584656*^9, 
  3.3899905134955997`*^9, 3.3899911798716*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4.3 (Source notebook: RollBasicAndGeneralized)", "Subsection",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3907328950416*^9, 3.3907328966376*^9}},
 CellTags->"Ch4ExCorrup"],

Cell["Model:", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["m", "Rule"], "=", 
   RowBox[{
    SubscriptBox["m", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", 
      RowBox[{"t", "-", "1"}]], "+", 
     SubscriptBox["u", "t"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["p", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", "t"], "+", 
     RowBox[{"c", " ", 
      SubscriptBox["q", "t"]}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["\[CapitalDelta]p", "t_"], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["p", "t"], "/.", "\[InvisibleSpace]", 
        SubscriptBox["p", "Rule"]}], "/.", "\[InvisibleSpace]", 
       SubscriptBox["m", "Rule"]}], ")"}], "-", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["p", 
        RowBox[{"t", "-", "1"}]], "/.", "\[InvisibleSpace]", 
       SubscriptBox["p", "Rule"]}], ")"}]}]}]}], ";"}], "\n", 
 RowBox[{
  SubscriptBox["\[CapitalDelta]p", "t"], "/.", 
  SubscriptBox["\[CapitalDelta]p", "Rule"]}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "c"}], " ", 
   SubscriptBox["q", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "t"}]]}], "+", 
  RowBox[{"c", " ", 
   SubscriptBox["q", "t"]}], "+", 
  SubscriptBox["u", "t"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522827574*^9, 3.3895615261644*^9, 3.3895616670128*^9,
   3.3899894661832*^9, 3.3899901654496*^9, 3.3899905766886*^9, 
  3.3899911799916*^9}]
}, Open  ]],

Cell["Modified expectations rules:", "Text",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3899895121082*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[ScriptCapitalE]Alternate", "Rules"], "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       SubsuperscriptBox["q", "_", "2"], "]"}], "\[Rule]", "1"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       SubsuperscriptBox["u", "_", "2"], "]"}], "\[Rule]", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{
        SubscriptBox["q", "s_"], 
        SubscriptBox["u", "t_"]}], "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{"\[Rho]", " ", 
        SubscriptBox["\[Sigma]", "u"]}], "/;", 
       RowBox[{"t", "\[Equal]", "s"}]}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{
        SubscriptBox["q", "s_"], 
        SubscriptBox["u", "t_"]}], "]"}], "\[RuleDelayed]", 
      RowBox[{"0", "/;", 
       RowBox[{"t", "=!=", "s"}]}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{
        SubscriptBox["q", "t_"], 
        SubscriptBox["q", "s_"]}], "]"}], "\[RuleDelayed]", " ", 
      RowBox[{"0", "/;", 
       RowBox[{"t", "=!=", "s"}]}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[ScriptCapitalE]", "[", 
       RowBox[{
        SubscriptBox["u", "t_"], 
        SubscriptBox["u", "s_"]}], "]"}], "\[RuleDelayed]", " ", 
      RowBox[{"0", "/;", 
       RowBox[{"t", "=!=", "s"}]}]}]}], "}"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3899895121092*^9, {3.3899905251466*^9, 3.3899905449616003`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[ScriptCapitalE]", "Rules"], "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     SubscriptBox["\[ScriptCapitalE]Alternate", "Rules"], ",", 
     SubscriptBox["\[ScriptCapitalE]Linearity", "Rules"]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.3899910600936003`*^9, 3.3899910656446*^9}},
 CellLabel->"In[72]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[ScriptCapitalE]", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{
      SubsuperscriptBox["\[CapitalDelta]p", "t", "2"], "/.", 
      SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}], "]"}], "//.", 
   SubscriptBox["\[ScriptCapitalE]", "Rules"]}], "//", 
  "FullSimplify"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3899905592366*^9, 3.3899911136786003`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SuperscriptBox["c", "2"]}], "+", 
  SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
  RowBox[{"2", " ", "c", " ", "\[Rho]", " ", 
   SubscriptBox["\[Sigma]", "u"]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522828554*^9, 3.3895615262614*^9, 
  3.3895616671168003`*^9, 3.3899894663361998`*^9, 3.3899901656686*^9, 
  3.3899905768266*^9, 3.3899911801186*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[ScriptCapitalE]", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[CapitalDelta]p", "t"], 
       SubscriptBox["\[CapitalDelta]p", 
        RowBox[{"t", "-", "1"}]]}], "/.", 
      SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}], "]"}], "//.", 
   SubscriptBox["\[ScriptCapitalE]", "Rules"]}], "//", "Simplify"}]], "Input",\

 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3899905626576*^9, 3.3899911187986*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "c"}], " ", 
  RowBox[{"(", 
   RowBox[{"c", "+", 
    RowBox[{"\[Rho]", " ", 
     SubscriptBox["\[Sigma]", "u"]}]}], ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522828894*^9, 3.3895615262964*^9, 3.3895616671468*^9,
   3.3899894663932*^9, 3.3899901657566*^9, 3.3899905768956003`*^9, 
  3.3899911801826*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[ScriptCapitalE]", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[CapitalDelta]p", "t"], 
       SubscriptBox["\[CapitalDelta]p", 
        RowBox[{"t", "-", "2"}]]}], "/.", 
      SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}], "]"}], "//.", 
   SubscriptBox["\[ScriptCapitalE]", "Rules"]}], "//", "Simplify"}]], "Input",\

 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3899905659606*^9, 3.3899911286015997`*^9}],

Cell[BoxData["0"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522829244003`*^9, 3.3895615263324003`*^9, 
  3.3895616671788*^9, 3.3899894664452*^9, 3.3899901658366003`*^9, 
  3.3899905769616003`*^9, 3.3899911802386*^9}]
}, Open  ]],

Cell[TextData[{
 "Verify that ",
 Cell[BoxData[
  RowBox[{
   SqrtBox[
    RowBox[{
     RowBox[{"-", "Cov"}], 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[CapitalDelta]p", "t"], ",", 
       SubscriptBox["\[CapitalDelta]p", 
        RowBox[{"t", "-", "1"}]]}], ")"}]}]], ">", "c"}]]],
 ":"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    SqrtBox[
     RowBox[{
      RowBox[{"-", 
       RowBox[{"\[ScriptCapitalE]", "[", 
        RowBox[{"Expand", "[", 
         RowBox[{
          RowBox[{
           SubscriptBox["\[CapitalDelta]p", "t"], 
           SubscriptBox["\[CapitalDelta]p", 
            RowBox[{"t", "-", "1"}]]}], "/.", 
          SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}], "]"}]}], "//.", 
      SubscriptBox["\[ScriptCapitalE]", "Rules"]}]], ">", "c"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"0", "<", "\[Rho]"}], ",", 
      RowBox[{
       SubscriptBox["\[Sigma]", "u"], ">", "0"}], ",", 
      RowBox[{"c", ">", "0"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3899905693866*^9, 3.3899911348306*^9}],

Cell[BoxData["True"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522830034*^9, 3.3895615263943996`*^9, 
  3.3895616672298*^9, 3.3899894665341997`*^9, 3.3899901659566*^9, 
  3.3899905796716003`*^9, 3.3899911803596*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Exercise 5.1 (Different \[Mu]s for different brokers, Source notebook: \
SequentialTrade)\
\>", "Subsection",
 CellChangeTimes->{{3.3907329859826*^9, 3.3907329998946*^9}},
 CellTags->"SeqTrade1"],

Cell[CellGroupData[{

Cell[BoxData["Ask"], "Input",
 CellLabel->"In[182]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"VLo", " ", "\[Delta]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Mu]"}], ")"}]}], "+", 
   RowBox[{"VHi", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Delta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Mu]"}], ")"}]}]}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "\[Delta]"}]}], ")"}], " ", "\[Mu]"}]}]]], "Output",
 CellChangeTimes->{3.3896128632142*^9, 3.3896138212528*^9, 
  3.3899914934316*^9},
 CellLabel->"Out[182]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Ask", "/.", 
   RowBox[{"\[Delta]", "\[Rule]", 
    RowBox[{"1", "/", "2"}]}]}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[183]:="],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"VHi", "+", "VLo", "+", 
    RowBox[{"VHi", " ", "\[Mu]"}], "-", 
    RowBox[{"VLo", " ", "\[Mu]"}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.3896128634462*^9, 3.3896138213578*^9, 
  3.3899914935326*^9},
 CellLabel->"Out[183]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["Profits", "b"], "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"Ask", "/.", 
       RowBox[{"\[Mu]", "\[Rule]", 
        SubscriptBox["\[Mu]", "Other"]}]}], ")"}], "-", 
     RowBox[{"(", 
      RowBox[{"Ask", "/.", 
       RowBox[{"\[Mu]", "\[Rule]", 
        SubscriptBox["\[Mu]", "b"]}]}], ")"}]}], "/.", 
    RowBox[{"\[Delta]", "\[Rule]", 
     RowBox[{"1", "/", "2"}]}]}], "//", "FullSimplify"}]}]], "Input",
 CellLabel->"In[184]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "2"]}], " ", 
  RowBox[{"(", 
   RowBox[{"VHi", "-", "VLo"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SubscriptBox["\[Mu]", "b"], "-", 
    SubscriptBox["\[Mu]", "Other"]}], ")"}]}]], "Output",
 CellChangeTimes->{3.3896128635042*^9, 3.3896138214138002`*^9, 
  3.3899914936286*^9},
 CellLabel->"Out[184]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    SubscriptBox["Profits", "b"], ">", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0", "<", 
      SubscriptBox["\[Mu]", "b"], "<", "1"}], ",", 
     RowBox[{"0", "<", 
      SubscriptBox["\[Mu]", "Other"], "<", "1"}], ",", 
     RowBox[{
      SubscriptBox["\[Mu]", "b"], "<", 
      SubscriptBox["\[Mu]", "Other"]}], ",", 
     RowBox[{"VHi", ">", "VLo"}], ",", 
     RowBox[{"0", "<", "\[Delta]", "<", "1"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[185]:="],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.3896128635472*^9, 3.3896138214508*^9, 
  3.3899914936846*^9},
 CellLabel->"Out[185]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Exercise 5.2 (Informed trading only in low state, Source notebook: \
SequentialTrade)\
\>", "Subsection",
 CellChangeTimes->{3.3907330075556*^9},
 CellTags->"SeqTrade2"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"LabelTree", "=", 
   RowBox[{"{", 
    RowBox[{"V", ",", 
     RowBox[{"{", 
      RowBox[{"VLo", ",", 
       RowBox[{"{", 
        RowBox[{"In", ",", "S"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Un", ",", "B", ",", "S"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"VHi", ",", 
       RowBox[{"{", 
        RowBox[{"Un", ",", "B", ",", "S"}], "}"}]}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"LabelTree", "//", "ShowTree"}]}], "Input",
 CellLabel->"In[186]:="],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      TagBox[GridBox[{
         {"V"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"VLo"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"In"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"S"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"Un"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"B"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"S"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"VHi"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"Un"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"B"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"S"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.35]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {{
         Offset[0.2]}}, "RowsIndexed" -> {}}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, TableAlignments -> {Left, Top}, TableSpacing -> {0.5, 0.5}]]],
  
  DisplayForm]], "Output",
 CellChangeTimes->{3.3896128635931997`*^9, 3.3896138215067997`*^9, 
  3.3899914937586*^9},
 CellLabel->"Out[187]//DisplayForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"PrTree", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"LabelTree", "/.", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"VLo", ",", 
              RowBox[{"{", 
               RowBox[{"In", ",", "S"}], "}"}], ",", "a_"}], "}"}], 
            "\[RuleDelayed]", 
            RowBox[{"{", 
             RowBox[{"VLo", ",", 
              RowBox[{"{", 
               RowBox[{"In", ",", "1"}], "}"}], ",", "a"}], "}"}]}]}], "/.", 
          RowBox[{
           RowBox[{"B", "|", "S"}], "\[Rule]", 
           RowBox[{"1", "/", "2"}]}]}], "/.", 
         RowBox[{"In", "\[Rule]", "\[Mu]"}]}], "/.", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"VHi", ",", 
           RowBox[{"{", 
            RowBox[{"Un", ",", "a__"}], "}"}]}], "}"}], "\[RuleDelayed]", 
         RowBox[{"{", 
          RowBox[{"VHi", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "a"}], "}"}]}], "}"}]}]}], "/.", 
       RowBox[{"Un", "\[Rule]", 
        RowBox[{"1", "-", "\[Mu]"}]}]}], "/.", 
      RowBox[{"VLo", "\[Rule]", "\[Delta]"}]}], "/.", 
     RowBox[{"VHi", "\[Rule]", 
      RowBox[{"1", "-", "\[Delta]"}]}]}], "/.", 
    RowBox[{"V", "\[Rule]", "1"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExTree", "=", 
   RowBox[{"BuildTree", "[", 
    RowBox[{"LabelTree", ",", "PrTree"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ShowTree", "[", "ExTree", "]"}]}], "Input",
 CellLabel->"In[188]:="],

Cell[BoxData[
 TagBox[
  InterpretationBox[GridBox[{
     {
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"V"},
           {"1"},
           {"1"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"VLo"},
           {"\[Delta]"},
           {"\[Delta]"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"In"},
           {"\[Mu]"},
           {
            RowBox[{"\[Delta]", " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {"1"},
           {
            RowBox[{"\[Delta]", " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"Un"},
           {
            RowBox[{"1", "-", "\[Mu]"}]},
           {
            RowBox[{"\[Delta]", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {
            FractionBox["1", "2"]},
           {
            RowBox[{
             FractionBox["1", "2"], " ", "\[Delta]", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {
            FractionBox["1", "2"]},
           {
            RowBox[{
             FractionBox["1", "2"], " ", "\[Delta]", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"VHi"},
           {
            RowBox[{"1", "-", "\[Delta]"}]},
           {
            RowBox[{"1", "-", "\[Delta]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"Un"},
           {"1"},
           {
            RowBox[{"1", "-", "\[Delta]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {
            FractionBox["1", "2"]},
           {
            FractionBox[
             RowBox[{"1", "-", "\[Delta]"}], "2"]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {
            FractionBox["1", "2"]},
           {
            FractionBox[
             RowBox[{"1", "-", "\[Delta]"}], "2"]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.35]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {{
         Offset[0.2]}}, "RowsIndexed" -> {}}],
   TableForm[{{
      FrameBox[
       TableForm[{$CellContext`V, 1, 1}]], 
      FrameBox[
       TableForm[{$CellContext`VLo, $CellContext`\[Delta], $CellContext`\
\[Delta]}]], 
      FrameBox[
       TableForm[{
        In, $CellContext`\[Mu], $CellContext`\[Delta] $CellContext`\[Mu]}]], 
      FrameBox[
       TableForm[{$CellContext`S, 
         1, $CellContext`\[Delta] $CellContext`\[Mu]}]]}, {{" ", " ", " "}, {
      " ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`Un, 
         1 - $CellContext`\[Mu], $CellContext`\[Delta] (
          1 - $CellContext`\[Mu])}]], 
      FrameBox[
       TableForm[{$CellContext`B, 
         Rational[1, 2], 
         Rational[1, 2] $CellContext`\[Delta] (1 - $CellContext`\[Mu])}]]}, {{
      " ", " ", " "}, {" ", " ", " "}, {" ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`S, 
         Rational[1, 2], 
         Rational[1, 2] $CellContext`\[Delta] (1 - $CellContext`\[Mu])}]]}, {{
      " ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`VHi, 1 - $CellContext`\[Delta], 
         1 - $CellContext`\[Delta]}]], 
      FrameBox[
       TableForm[{$CellContext`Un, 1, 1 - $CellContext`\[Delta]}]], 
      FrameBox[
       TableForm[{$CellContext`B, 
         Rational[1, 2], Rational[1, 2] (1 - $CellContext`\[Delta])}]]}, {{
      " ", " ", " "}, {" ", " ", " "}, {" ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`S, 
         Rational[1, 2], Rational[1, 2] (1 - $CellContext`\[Delta])}]]}}, 
    TableAlignments -> {Left, Top}, TableSpacing -> {0.5, 0.5}]],
  DisplayForm]], "Output",
 CellChangeTimes->{3.3896128636512003`*^9, 3.3896138215608*^9, 
  3.3899914938566*^9},
 CellLabel->"Out[190]//DisplayForm="]
}, Open  ]],

Cell["Verify that terminal node total probabilities add up to one:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Pr", "[", 
    RowBox[{"ExTree", ",", "B"}], "]"}], "+", 
   RowBox[{"Pr", "[", 
    RowBox[{"ExTree", ",", "S"}], "]"}]}], "//", "Simplify"}]], "Input",
 CellLabel->"In[191]:="],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{3.3896128636892*^9, 3.3896138215987997`*^9, 
  3.3899914939096003`*^9},
 CellLabel->"Out[191]="]
}, Open  ]],

Cell[TextData[{
 "Conditional on a buy, the revised ",
 Cell[BoxData["\[Delta]"]],
 " is:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Delta]B", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Pr", "[", 
     RowBox[{"ExTree", ",", "VLo", ",", "B"}], "]"}], "/", 
    RowBox[{"Pr", "[", 
     RowBox[{"ExTree", ",", "B"}], "]"}]}], "//", "Simplify"}]}]], "Input",
 CellLabel->"In[192]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[Delta]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "\[Mu]"}], ")"}]}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{"\[Delta]", " ", "\[Mu]"}]}]]], "Output",
 CellChangeTimes->{3.3896128637402*^9, 3.3896138216338*^9, 
  3.3899914939656*^9},
 CellLabel->"Out[192]="]
}, Open  ]],

Cell["Conditional on a sell ...", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Delta]S", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Pr", "[", 
     RowBox[{"ExTree", ",", "VLo", ",", "S"}], "]"}], "/", 
    RowBox[{"Pr", "[", 
     RowBox[{"ExTree", ",", "S"}], "]"}]}], "//", "Simplify"}]}]], "Input",
 CellLabel->"In[193]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[Delta]", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "\[Mu]"}], ")"}]}], 
  RowBox[{"1", "+", 
   RowBox[{"\[Delta]", " ", "\[Mu]"}]}]]], "Output",
 CellChangeTimes->{3.3896128637762003`*^9, 3.3896138216728*^9, 
  3.3899914941846*^9},
 CellLabel->"Out[193]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ask", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"\[Delta]B", " ", "VLo"}], " ", "+", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "\[Delta]B"}], ")"}], " ", "VHi"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[194]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"VHi", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Delta]"}], ")"}]}], "+", 
   RowBox[{"VLo", " ", "\[Delta]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Mu]"}], ")"}]}]}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{"\[Delta]", " ", "\[Mu]"}]}]]], "Output",
 CellChangeTimes->{3.3896128638152*^9, 3.3896138217228003`*^9, 
  3.3899914942516003`*^9},
 CellLabel->"Out[194]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Bid", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"\[Delta]S", " ", "VLo"}], " ", "+", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "\[Delta]S"}], ")"}], " ", "VHi"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[195]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"VHi", "-", 
   RowBox[{"VHi", " ", "\[Delta]"}], "+", 
   RowBox[{"VLo", " ", "\[Delta]", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Mu]"}], ")"}]}]}], 
  RowBox[{"1", "+", 
   RowBox[{"\[Delta]", " ", "\[Mu]"}]}]]], "Output",
 CellChangeTimes->{3.3896128638652*^9, 3.3896138217588*^9, 
  3.3899914943146*^9},
 CellLabel->"Out[195]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"\[Delta]S", "/.", 
   RowBox[{"\[Delta]", "\[Rule]", "\[Delta]B"}]}], "]"}]], "Input",
 CellLabel->"In[196]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[Delta]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "\[Mu]"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "\[Mu]"}], ")"}]}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{"\[Delta]", " ", 
    SuperscriptBox["\[Mu]", "2"]}]}]]], "Output",
 CellChangeTimes->{3.3896128639062*^9, 3.3896138217948*^9, 
  3.3899914943726*^9},
 CellLabel->"Out[196]="]
}, Open  ]],

Cell["\<\
Manipulation by buying at the ask and selling at the revised bid? Nope.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "Ask"}], " ", "+", " ", "Bid"}], "/.", 
      RowBox[{"\[Delta]", "\[Rule]", "\[Delta]B"}]}], ")"}], ">", "0"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0", "<", "\[Mu]", "<", "1"}], ",", 
     RowBox[{"0", "<", "\[Delta]", "<", "1"}], ",", 
     RowBox[{"VHi", ">", "VLo"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[197]:="],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.3896128640671997`*^9, 3.3896138219328003`*^9, 
  3.3899914946736*^9},
 CellLabel->"Out[197]="]
}, Open  ]],

Cell["\<\
Manipulation by selling at the bid and buying at the revised ask? Nope.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Bid", " ", "-", " ", "Ask"}], "/.", 
      RowBox[{"\[Delta]", "\[Rule]", "\[Delta]S"}]}], ")"}], ">", "0"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0", "<", "\[Mu]", "<", "1"}], ",", 
     RowBox[{"0", "<", "\[Delta]", "<", "1"}], ",", 
     RowBox[{"VHi", ">", "VLo"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[198]:="],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.3896128642162*^9, 3.3896138220748*^9, 
  3.3899914949716*^9},
 CellLabel->"Out[198]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Exercise 5.3 (Informed traders get a signal, Source notebook: \
SequentialTrade)\
\>", "Subsection",
 CellChangeTimes->{3.3907330107546*^9},
 CellTags->"SeqTrade3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LabelTree", "=", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"V", ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"VLo", ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"In", ",", 
         RowBox[{"{", 
          RowBox[{"SLo", ",", "S"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"SHi", ",", "B"}], "}"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"Un", ",", "B", ",", "S"}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"VHi", ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"In", ",", 
         RowBox[{"{", 
          RowBox[{"SLo", ",", "S"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"SHi", ",", "B"}], "}"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"Un", ",", "B", ",", "S"}], "}"}]}], "}"}]}], 
    "\[IndentingNewLine]", "}"}]}], ";", 
  RowBox[{"LabelTree", "//", "ShowTree"}]}]], "Input",
 CellLabel->"In[199]:="],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      TagBox[GridBox[{
         {"V"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"VLo"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"In"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"SLo"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"S"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"SHi"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"B"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"Un"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"B"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"S"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"VHi"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"In"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"SLo"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"S"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"SHi"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"B"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"Un"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"B"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"S"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.35]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {{
         Offset[0.2]}}, "RowsIndexed" -> {}}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, TableAlignments -> {Left, Top}, TableSpacing -> {0.5, 0.5}]]],
  
  DisplayForm]], "Output",
 CellChangeTimes->{3.3896128642782*^9, 3.3896138221238003`*^9, 
  3.3899914950886*^9},
 CellLabel->"Out[199]//DisplayForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"PrTree", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"LabelTree", "/.", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"VLo", ",", 
              RowBox[{"{", 
               RowBox[{"In", ",", 
                RowBox[{"{", 
                 RowBox[{"SLo", ",", "S"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"SHi", ",", "B"}], "}"}]}], "}"}], ",", "a_"}], 
             "}"}], ":>", 
            RowBox[{"{", 
             RowBox[{"VLo", ",", 
              RowBox[{"{", 
               RowBox[{"In", ",", 
                RowBox[{"{", 
                 RowBox[{"\[Gamma]", ",", "1"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"1", "-", "\[Gamma]"}], ",", "1"}], "}"}]}], "}"}], 
              ",", "a"}], "}"}]}]}], "/.", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"VHi", ",", 
             RowBox[{"{", 
              RowBox[{"In", ",", 
               RowBox[{"{", 
                RowBox[{"SLo", ",", "S"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"SHi", ",", "B"}], "}"}]}], "}"}], ",", "a_"}], "}"}],
            ":>", 
           RowBox[{"{", 
            RowBox[{"VHi", ",", 
             RowBox[{"{", 
              RowBox[{"In", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"1", "-", "\[Gamma]"}], ",", "1"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"\[Gamma]", ",", "1"}], "}"}]}], "}"}], ",", "a"}], 
            "}"}]}]}], "/.", 
         RowBox[{
          RowBox[{"B", "|", "S"}], "\[Rule]", 
          RowBox[{"1", "/", "2"}]}]}], "/.", 
        RowBox[{"In", "\[Rule]", "\[Mu]"}]}], "/.", 
       RowBox[{"Un", "\[Rule]", 
        RowBox[{"1", "-", "\[Mu]"}]}]}], "/.", 
      RowBox[{"VLo", "\[Rule]", "\[Delta]"}]}], "/.", 
     RowBox[{"VHi", "\[Rule]", 
      RowBox[{"1", "-", "\[Delta]"}]}]}], "/.", 
    RowBox[{"V", "\[Rule]", "1"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExTree", "=", 
   RowBox[{"BuildTree", "[", 
    RowBox[{"LabelTree", ",", "PrTree"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ShowTree", "[", "ExTree", "]"}]}], "Input",
 CellLabel->"In[200]:="],

Cell[BoxData[
 TagBox[
  InterpretationBox[GridBox[{
     {
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"V"},
           {"1"},
           {"1"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"VLo"},
           {"\[Delta]"},
           {"\[Delta]"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"In"},
           {"\[Mu]"},
           {
            RowBox[{"\[Delta]", " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"SLo"},
           {"\[Gamma]"},
           {
            RowBox[{"\[Gamma]", " ", "\[Delta]", " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {"1"},
           {
            RowBox[{"\[Gamma]", " ", "\[Delta]", " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"SHi"},
           {
            RowBox[{"1", "-", "\[Gamma]"}]},
           {
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Gamma]"}], ")"}], " ", "\[Delta]", " ", 
             "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {"1"},
           {
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Gamma]"}], ")"}], " ", "\[Delta]", " ", 
             "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"Un"},
           {
            RowBox[{"1", "-", "\[Mu]"}]},
           {
            RowBox[{"\[Delta]", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {
            FractionBox["1", "2"]},
           {
            RowBox[{
             FractionBox["1", "2"], " ", "\[Delta]", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {
            FractionBox["1", "2"]},
           {
            RowBox[{
             FractionBox["1", "2"], " ", "\[Delta]", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"VHi"},
           {
            RowBox[{"1", "-", "\[Delta]"}]},
           {
            RowBox[{"1", "-", "\[Delta]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"In"},
           {"\[Mu]"},
           {
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"SLo"},
           {
            RowBox[{"1", "-", "\[Gamma]"}]},
           {
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Gamma]"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {"1"},
           {
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Gamma]"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"SHi"},
           {"\[Gamma]"},
           {
            RowBox[{"\[Gamma]", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {"1"},
           {
            RowBox[{"\[Gamma]", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"Un"},
           {
            RowBox[{"1", "-", "\[Mu]"}]},
           {
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {
            FractionBox["1", "2"]},
           {
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {
            FractionBox["1", "2"]},
           {
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.35]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {{
         Offset[0.2]}}, "RowsIndexed" -> {}}],
   TableForm[{{
      FrameBox[
       TableForm[{$CellContext`V, 1, 1}]], 
      FrameBox[
       TableForm[{$CellContext`VLo, $CellContext`\[Delta], $CellContext`\
\[Delta]}]], 
      FrameBox[
       TableForm[{
        In, $CellContext`\[Mu], $CellContext`\[Delta] $CellContext`\[Mu]}]], 
      FrameBox[
       TableForm[{$CellContext`SLo, $CellContext`\[Gamma], $CellContext`\
\[Gamma] $CellContext`\[Delta] $CellContext`\[Mu]}]], 
      FrameBox[
       TableForm[{$CellContext`S, 
         1, $CellContext`\[Gamma] $CellContext`\[Delta] \
$CellContext`\[Mu]}]]}, {{" ", " ", " "}, {" ", " ", " "}, {" ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`SHi, 
         1 - $CellContext`\[Gamma], (
          1 - $CellContext`\[Gamma]) $CellContext`\[Delta] \
$CellContext`\[Mu]}]], 
      FrameBox[
       TableForm[{$CellContext`B, 
         1, (1 - $CellContext`\[Gamma]) $CellContext`\[Delta] $CellContext`\
\[Mu]}]]}, {{" ", " ", " "}, {" ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`Un, 
         1 - $CellContext`\[Mu], $CellContext`\[Delta] (
          1 - $CellContext`\[Mu])}]], 
      FrameBox[
       TableForm[{$CellContext`B, 
         Rational[1, 2], 
         Rational[1, 2] $CellContext`\[Delta] (1 - $CellContext`\[Mu])}]], {
      " ", " ", " "}}, {{" ", " ", " "}, {" ", " ", " "}, {" ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`S, 
         Rational[1, 2], 
         Rational[1, 2] $CellContext`\[Delta] (1 - $CellContext`\[Mu])}]], {
      " ", " ", " "}}, {{" ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`VHi, 1 - $CellContext`\[Delta], 
         1 - $CellContext`\[Delta]}]], 
      FrameBox[
       TableForm[{
        In, $CellContext`\[Mu], (
          1 - $CellContext`\[Delta]) $CellContext`\[Mu]}]], 
      FrameBox[
       TableForm[{$CellContext`SLo, 
         1 - $CellContext`\[Gamma], (1 - $CellContext`\[Gamma]) (
          1 - $CellContext`\[Delta]) $CellContext`\[Mu]}]], 
      FrameBox[
       TableForm[{$CellContext`S, 
         1, (1 - $CellContext`\[Gamma]) (
          1 - $CellContext`\[Delta]) $CellContext`\[Mu]}]]}, {{
      " ", " ", " "}, {" ", " ", " "}, {" ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`SHi, $CellContext`\[Gamma], $CellContext`\
\[Gamma] (1 - $CellContext`\[Delta]) $CellContext`\[Mu]}]], 
      FrameBox[
       TableForm[{$CellContext`B, 
         1, $CellContext`\[Gamma] (
          1 - $CellContext`\[Delta]) $CellContext`\[Mu]}]]}, {{
      " ", " ", " "}, {" ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`Un, 
         1 - $CellContext`\[Mu], (1 - $CellContext`\[Delta]) (
          1 - $CellContext`\[Mu])}]], 
      FrameBox[
       TableForm[{$CellContext`B, 
         Rational[1, 2], 
         Rational[1, 2] (1 - $CellContext`\[Delta]) (
          1 - $CellContext`\[Mu])}]], {" ", " ", " "}}, {{" ", " ", " "}, {
      " ", " ", " "}, {" ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`S, 
         Rational[1, 2], 
         Rational[1, 2] (1 - $CellContext`\[Delta]) (
          1 - $CellContext`\[Mu])}]], {" ", " ", " "}}}, 
    TableAlignments -> {Left, Top}, TableSpacing -> {0.5, 0.5}]],
  DisplayForm]], "Output",
 CellChangeTimes->{3.3896128643691998`*^9, 3.3896138221878*^9, 
  3.3899914952766*^9},
 CellLabel->"Out[202]//DisplayForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Pr", "[", 
    RowBox[{"ExTree", ",", "B"}], "]"}], "+", 
   RowBox[{"Pr", "[", 
    RowBox[{"ExTree", ",", "S"}], "]"}]}], "//", "Simplify"}]], "Input",
 CellLabel->"In[203]:="],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{3.3896128644161997`*^9, 3.3896138222258*^9, 
  3.3899914953686*^9},
 CellLabel->"Out[203]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Delta]B", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Pr", "[", 
     RowBox[{"ExTree", ",", "VLo", ",", "B"}], "]"}], "/", 
    RowBox[{"Pr", "[", 
     RowBox[{"ExTree", ",", "B"}], "]"}]}], "//", "Simplify"}]}]], "Input",
 CellLabel->"In[204]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[Delta]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", "\[Gamma]"}]}], ")"}], " ", "\[Mu]"}]}], ")"}]}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "\[Gamma]"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "\[Delta]"}]}], ")"}], " ", "\[Mu]"}]}]]], "Output",
 CellChangeTimes->{3.3896128644782*^9, 3.3896138222738*^9, 
  3.3899914954996*^9},
 CellLabel->"Out[204]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Values", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Gamma]", "\[Rule]", ".1"}], ",", 
     RowBox[{"\[Mu]", "\[Rule]", ".2"}], ",", 
     RowBox[{"\[Delta]", "\[Rule]", ".3"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[205]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Delta]B", "/.", "Values"}]], "Input",
 CellLabel->"In[206]:="],

Cell[BoxData["0.3717948717948718`"], "Output",
 CellChangeTimes->{3.3896128645242*^9, 3.3896138223118*^9, 
  3.3899914955986*^9},
 CellLabel->"Out[206]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ask", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"\[Delta]B", " ", "VLo"}], " ", "+", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "\[Delta]B"}], ")"}], " ", "VHi"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[207]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"VLo", " ", "\[Delta]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "\[Gamma]"}]}], ")"}], " ", "\[Mu]"}]}], ")"}]}], 
   "+", 
   RowBox[{"VHi", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Delta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "\[Gamma]"}]}], ")"}], " ", "\[Mu]"}]}], ")"}]}]}],
   
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "\[Gamma]"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "\[Delta]"}]}], ")"}], " ", "\[Mu]"}]}]]], "Output",
 CellChangeTimes->{3.3896128645752*^9, 3.3896138223618*^9, 
  3.3899914956856003`*^9},
 CellLabel->"Out[207]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Delta]S", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Pr", "[", 
     RowBox[{"ExTree", ",", "VLo", ",", "S"}], "]"}], "/", 
    RowBox[{"Pr", "[", 
     RowBox[{"ExTree", ",", "S"}], "]"}]}], "//", "Simplify"}]}]], "Input",
 CellLabel->"In[208]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[Delta]", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", "\[Gamma]"}]}], ")"}], " ", "\[Mu]"}]}], ")"}]}], 
  RowBox[{"1", "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "\[Gamma]"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "\[Delta]"}]}], ")"}], " ", "\[Mu]"}]}]]], "Output",
 CellChangeTimes->{3.3896128646182003`*^9, 3.3896138224018*^9, 
  3.3899914957516003`*^9},
 CellLabel->"Out[208]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Bid1", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"\[Delta]S", " ", "VLo"}], " ", "+", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "\[Delta]S"}], ")"}], " ", "VHi"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[209]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"VHi", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Delta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "\[Gamma]"}]}], ")"}], " ", "\[Mu]"}]}], ")"}]}], 
   "+", 
   RowBox[{"VLo", " ", "\[Delta]", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "\[Gamma]"}]}], ")"}], " ", "\[Mu]"}]}], ")"}]}]}],
   
  RowBox[{"1", "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "\[Gamma]"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "\[Delta]"}]}], ")"}], " ", "\[Mu]"}]}]]], "Output",
 CellChangeTimes->{3.3896128646712*^9, 3.3896138224538*^9, 
  3.3899914958316*^9},
 CellLabel->"Out[209]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"\[Delta]S", "/.", 
   RowBox[{"\[Delta]", "\[Rule]", "\[Delta]B"}]}], "]"}]], "Input",
 CellLabel->"In[210]:="],

Cell[BoxData["\[Delta]"], "Output",
 CellChangeTimes->{3.3896128647122*^9, 3.3896138224888*^9, 
  3.3899914958856*^9},
 CellLabel->"Out[210]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Exercise 5.4 (Offsetting trades, Source notebook: SequentialTrade)\
\>", "Subsection",
 CellChangeTimes->{3.3907330138486*^9},
 CellTags->"SeqTrade4"],

Cell["\<\
A sell followed by a buy gives ... (see the analysis of the original problem, \
above).\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FoldList", "[", 
    RowBox[{"\[Delta]Cond", ",", 
     SubscriptBox["\[Delta]", "0"], ",", 
     RowBox[{"{", 
      RowBox[{"S", ",", "B"}], "}"}]}], "]"}], "//.", 
   SubscriptBox["\[Delta]Cond", "Rule"]}], "//", "Simplify"}]], "Input",
 CellLabel->"In[219]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\[Delta]", "0"], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Mu]"}], ")"}], " ", 
     SubscriptBox["\[Delta]", "0"]}], 
    RowBox[{"1", "-", "\[Mu]", "+", 
     RowBox[{"2", " ", "\[Mu]", " ", 
      SubscriptBox["\[Delta]", "0"]}]}]], ",", 
   SubscriptBox["\[Delta]", "0"]}], "}"}]], "Output",
 CellChangeTimes->{3.3896128650572*^9, 3.3896138228087997`*^9, 
  3.3899914965596*^9},
 CellLabel->"Out[219]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Exercise 7.1 (Informative noise traders, Source notebook: StrategicTrade)\
\>", "Subsection",
 CellChangeTimes->{{3.3907329605256*^9, 3.3907329685866003`*^9}},
 CellTags->"ExStrategicTrade1"],

Cell["As in the basic problem:", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["p", "Rule"], "=", 
   RowBox[{"p", "\[Rule]", 
    RowBox[{
     RowBox[{"y", " ", "\[Lambda]"}], "+", "\[Mu]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["y", "Rule"], "=", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"u", "+", "x"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["\[Pi]", "Rule"], "=", 
   RowBox[{"\[Pi]", "\[Rule]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"v", "-", "p"}], ")"}], " ", "x"}]}]}], ";"}]}], "Input",
 CellLabelAutoDelete->True],

Cell["The informed trader's profits are:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Pi]", "/.", "\[InvisibleSpace]", 
    SubscriptBox["\[Pi]", "Rule"]}], "/.", "\[InvisibleSpace]", 
   SubscriptBox["p", "Rule"]}], "/.", "\[InvisibleSpace]", 
  SubscriptBox["y", "Rule"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"x", " ", 
  RowBox[{"(", 
   RowBox[{"v", "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"u", "+", "x"}], ")"}], " ", "\[Lambda]"}], "-", "\[Mu]"}], 
   ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623037954*^9, 3.3896231174616003`*^9, 
  3.3896232951174*^9, 3.3899917561966*^9, 3.3899918084166*^9}]
}, Open  ]],

Cell[TextData[{
 "At this point we diverge from the basic model because ",
 Cell[BoxData["u"]],
 " and ",
 Cell[BoxData["v"]],
 " are correlated. The projection the informed trader makes is:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"uvDist", "=", 
  RowBox[{"MVN", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       SubscriptBox["p", "0"], "}"}], ",", 
      RowBox[{"{", "0", "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["\[CapitalSigma]", "0"], ",", 
        SubscriptBox["\[Sigma]", "uv"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["\[Sigma]", "uv"], ",", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"v", ",", "u"}], "}"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"v"},
        {"u"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["p", "0"]},
       {"0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["\[CapitalSigma]", "0"], 
        SubscriptBox["\[Sigma]", "uv"]},
       {
        SubscriptBox["\[Sigma]", "uv"], 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623037992*^9, 3.3896231175016003`*^9, 
  3.3896232951454*^9, 3.3899917562676*^9, 3.3899918084716*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"uConditionalDist", "=", 
  RowBox[{"MVNConditional", "[", 
   RowBox[{"uvDist", ",", "u", ",", "v"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"u", 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"v", "-", 
       SubscriptBox["p", "0"]}], ")"}], " ", 
     SubscriptBox["\[Sigma]", "uv"]}], 
    SubscriptBox["\[CapitalSigma]", "0"]], ",", 
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "u", "2"], "-", 
    FractionBox[
     SubsuperscriptBox["\[Sigma]", "uv", "2"], 
     SubscriptBox["\[CapitalSigma]", "0"]]}], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.38962303804*^9, 3.3896231175396*^9, 3.3896232951754*^9, 
  3.3899917563316*^9, 3.3899918085226*^9}]
}, Open  ]],

Cell[TextData[{
 "The informed trader's expected profits (conditional on ",
 Cell[BoxData["v"]],
 ") are:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"E\[Pi]", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"\[Pi]", "/.", 
       SubscriptBox["\[Pi]", "Rule"]}], "/.", 
      SubscriptBox["p", "Rule"]}], "/.", 
     SubscriptBox["y", "Rule"]}], "/.", 
    RowBox[{"u", "\[Rule]", 
     RowBox[{"GetMean", "[", "uConditionalDist", "]"}]}]}]}], 
  "\[IndentingNewLine]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"x", " ", 
  RowBox[{"(", 
   RowBox[{"v", "-", "\[Mu]", "-", 
    RowBox[{"\[Lambda]", " ", 
     RowBox[{"(", 
      RowBox[{"x", "+", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"v", "-", 
           SubscriptBox["p", "0"]}], ")"}], " ", 
         SubscriptBox["\[Sigma]", "uv"]}], 
        SubscriptBox["\[CapitalSigma]", "0"]]}], ")"}]}]}], ")"}]}]], "Output",\

 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623038075*^9, 3.3896231175776*^9, 3.3896232952064*^9, 
  3.3899917563966*^9, 3.3899918085746*^9}]
}, Open  ]],

Cell["The informed trader's optimal trade is:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xOpt", "=", 
  RowBox[{"First", " ", "@", "  ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["\[PartialD]", "x"], "E\[Pi]"}], "\[Equal]", "0"}], ",", 
      "x"}], "]"}], "]"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"v", "-", "\[Mu]"}], ")"}], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     RowBox[{"\[Lambda]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "v"}], "+", 
        SubscriptBox["p", "0"]}], ")"}], " ", 
      SubscriptBox["\[Sigma]", "uv"]}]}], 
    RowBox[{"2", " ", "\[Lambda]", " ", 
     SubscriptBox["\[CapitalSigma]", "0"]}]]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623038126*^9, 3.3896231176205997`*^9, 
  3.3896232952464*^9, 3.3899917564656*^9, 3.3899918086446*^9}]
}, Open  ]],

Cell[TextData[{
 "The MM conjectures that the informed trader's demand is linear in ",
 Cell[BoxData["v"]],
 " (as above), and must figure out ",
 Cell[BoxData[
  RowBox[{"E", "[", 
   RowBox[{"v", "|", "y"}], "]"}]]],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["x", "Rule"], "=", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"\[Alpha]", "+", 
     RowBox[{"v", " ", "\[Beta]"}]}]}]}], ";"}], "\n", 
 RowBox[{"xEqu", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "/.", "\[InvisibleSpace]", 
     SubscriptBox["x", "Rule"]}], ")"}], "\[Equal]", 
   RowBox[{"(", 
    RowBox[{"x", "/.", "\[InvisibleSpace]", "xOpt"}], ")"}]}]}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Alpha]", "+", 
   RowBox[{"v", " ", "\[Beta]"}]}], "\[Equal]", 
  FractionBox[
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"v", "-", "\[Mu]"}], ")"}], " ", 
     SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
    RowBox[{"\[Lambda]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "v"}], "+", 
       SubscriptBox["p", "0"]}], ")"}], " ", 
     SubscriptBox["\[Sigma]", "uv"]}]}], 
   RowBox[{"2", " ", "\[Lambda]", " ", 
    SubscriptBox["\[CapitalSigma]", "0"]}]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623038166*^9, 3.3896231176596003`*^9, 
  3.3896232952774*^9, 3.3899917565316*^9, 3.3899918086996*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["x", "Solutions"], "=", 
  RowBox[{"Reduce", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["\[ForAll]", "v"], "xEqu"}], " ", "&&", " ", 
     RowBox[{
      SubscriptBox["\[CapitalSigma]", "0"], ">", "0"}], " ", "&&", " ", 
     RowBox[{"\[Lambda]", ">", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Alpha]", ",", "\[Beta]"}], "}"}], ",", "Reals"}], 
   "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalSigma]", "0"], ">", "0"}], "&&", 
  RowBox[{"\[Lambda]", ">", "0"}], "&&", 
  RowBox[{"\[Alpha]", "\[Equal]", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[Mu]"}], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     RowBox[{"\[Lambda]", " ", 
      SubscriptBox["p", "0"], " ", 
      SubscriptBox["\[Sigma]", "uv"]}]}], 
    RowBox[{"2", " ", "\[Lambda]", " ", 
     SubscriptBox["\[CapitalSigma]", "0"]}]]}], "&&", 
  RowBox[{"\[Beta]", "\[Equal]", 
   FractionBox[
    RowBox[{
     SubscriptBox["\[CapitalSigma]", "0"], "-", 
     RowBox[{"\[Lambda]", " ", 
      SubscriptBox["\[Sigma]", "uv"]}]}], 
    RowBox[{"2", " ", "\[Lambda]", " ", 
     SubscriptBox["\[CapitalSigma]", "0"]}]]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623038227*^9, 3.3896231177216*^9, 
  3.3896232953324003`*^9, 3.3899917566046*^9, 3.3899918088046*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["x", "Solutions"], "=", 
  RowBox[{"Simplify", " ", "@", " ", 
   RowBox[{"ToRules", " ", "@", " ", 
    RowBox[{"Take", "[", 
     RowBox[{
      SubscriptBox["x", "Solutions"], ",", 
      RowBox[{"-", "2"}]}], "]"}]}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Alpha]", "\[Rule]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["\[Mu]", "\[Lambda]"]}], "+", 
       FractionBox[
        RowBox[{
         SubscriptBox["p", "0"], " ", 
         SubscriptBox["\[Sigma]", "uv"]}], 
        SubscriptBox["\[CapitalSigma]", "0"]]}], ")"}]}]}], ",", 
   RowBox[{"\[Beta]", "\[Rule]", 
    FractionBox[
     RowBox[{
      SubscriptBox["\[CapitalSigma]", "0"], "-", 
      RowBox[{"\[Lambda]", " ", 
       SubscriptBox["\[Sigma]", "uv"]}]}], 
     RowBox[{"2", " ", "\[Lambda]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}]]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230382679996`*^9, 3.3896231177616*^9, 
  3.3896232953654003`*^9, 3.3899917567466*^9, 3.3899918088626003`*^9}]
}, Open  ]],

Cell[TextData[{
 "Now the MM must compute ",
 Cell[BoxData[
  RowBox[{"E", "[", 
   RowBox[{"v", "|", "y"}], "]"}]]],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MakeLinearForm", "[", 
  RowBox[{"uvDist", ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{
      RowBox[{"y", "/.", 
       SubscriptBox["y", "Rule"]}], "/.", 
      SubscriptBox["x", "Rule"]}]}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"v"},
        {
         RowBox[{"u", "+", "\[Alpha]", "+", 
          RowBox[{"v", " ", "\[Beta]"}]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["p", "0"]},
        {
         RowBox[{"\[Alpha]", "+", 
          RowBox[{"\[Beta]", " ", 
           SubscriptBox["p", "0"]}]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["\[CapitalSigma]", "0"], 
        RowBox[{
         RowBox[{"\[Beta]", " ", 
          SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
         SubscriptBox["\[Sigma]", "uv"]}]},
       {
        RowBox[{
         RowBox[{"\[Beta]", " ", 
          SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
         SubscriptBox["\[Sigma]", "uv"]}], 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
         RowBox[{"\[Beta]", " ", 
          SubscriptBox["\[Sigma]", "uv"]}], "+", 
         RowBox[{"\[Beta]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[Beta]", " ", 
             SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
            SubscriptBox["\[Sigma]", "uv"]}], ")"}]}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230383050003`*^9, 3.3896231178036003`*^9, 
  3.3896232953964*^9, 3.3899917568206*^9, 3.3899918089236*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vyDist", "=", 
  RowBox[{"SetLabel", "[", 
   RowBox[{"%", ",", 
    RowBox[{"{", 
     RowBox[{"v", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"v"},
        {"y"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["p", "0"]},
        {
         RowBox[{"\[Alpha]", "+", 
          RowBox[{"\[Beta]", " ", 
           SubscriptBox["p", "0"]}]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["\[CapitalSigma]", "0"], 
        RowBox[{
         RowBox[{"\[Beta]", " ", 
          SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
         SubscriptBox["\[Sigma]", "uv"]}]},
       {
        RowBox[{
         RowBox[{"\[Beta]", " ", 
          SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
         SubscriptBox["\[Sigma]", "uv"]}], 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
         RowBox[{"\[Beta]", " ", 
          SubscriptBox["\[Sigma]", "uv"]}], "+", 
         RowBox[{"\[Beta]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[Beta]", " ", 
             SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
            SubscriptBox["\[Sigma]", "uv"]}], ")"}]}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623038344*^9, 3.3896231178396*^9, 3.3896232954274*^9, 
  3.3899917568946*^9, 3.3899918089936*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vConditionalDist", "=", 
  RowBox[{
   RowBox[{"MVNConditional", "[", 
    RowBox[{"vyDist", ",", "v", ",", "y"}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"v", 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"y", "-", "\[Alpha]"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\[Beta]", " ", 
         SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
        SubscriptBox["\[Sigma]", "uv"]}], ")"}]}], "+", 
     RowBox[{
      SubscriptBox["p", "0"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
        RowBox[{"\[Beta]", " ", 
         SubscriptBox["\[Sigma]", "uv"]}]}], ")"}]}]}], 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
     RowBox[{"2", " ", "\[Beta]", " ", 
      SubscriptBox["\[Sigma]", "uv"]}]}]], ",", 
   FractionBox[
    RowBox[{
     RowBox[{
      SubscriptBox["\[CapitalSigma]", "0"], " ", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}], "-", 
     SubsuperscriptBox["\[Sigma]", "uv", "2"]}], 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
     RowBox[{"2", " ", "\[Beta]", " ", 
      SubscriptBox["\[Sigma]", "uv"]}]}]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230384049997`*^9, 3.3896231178936*^9, 
  3.3896232954784*^9, 3.3899917569946003`*^9, 3.3899918091106*^9}]
}, Open  ]],

Cell["Market efficiency:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pEqu", "=", " ", 
  RowBox[{
   RowBox[{"GetMean", "[", "vConditionalDist", "]"}], "\[Equal]", 
   RowBox[{"(", 
    RowBox[{"p", "/.", 
     SubscriptBox["p", "Rule"]}], ")"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"y", "-", "\[Alpha]"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\[Beta]", " ", 
        SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
       SubscriptBox["\[Sigma]", "uv"]}], ")"}]}], "+", 
    RowBox[{
     SubscriptBox["p", "0"], " ", 
     RowBox[{"(", 
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
       RowBox[{"\[Beta]", " ", 
        SubscriptBox["\[Sigma]", "uv"]}]}], ")"}]}]}], 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Beta]", "2"], " ", 
     SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
    SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
    RowBox[{"2", " ", "\[Beta]", " ", 
     SubscriptBox["\[Sigma]", "uv"]}]}]], "\[Equal]", 
  RowBox[{
   RowBox[{"y", " ", "\[Lambda]"}], "+", "\[Mu]"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.38962303844*^9, 3.3896231179326*^9, 3.3896232955184*^9, 
  3.3899917570615997`*^9, 3.3899918091656*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"ForAll", "[", 
     RowBox[{"y", ",", "True", ",", "pEqu"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Mu]", ",", "\[Lambda]"}], "}"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Beta]", "2"], " ", 
     SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
    SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
    RowBox[{"2", " ", "\[Beta]", " ", 
     SubscriptBox["\[Sigma]", "uv"]}]}], "\[NotEqual]", "0"}], "&&", 
  RowBox[{"\[Mu]", "\[Equal]", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[Alpha]"}], " ", "\[Beta]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
      SubscriptBox["p", "0"]}], "-", 
     RowBox[{"\[Alpha]", " ", 
      SubscriptBox["\[Sigma]", "uv"]}], "+", 
     RowBox[{"\[Beta]", " ", 
      SubscriptBox["p", "0"], " ", 
      SubscriptBox["\[Sigma]", "uv"]}]}], 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
     RowBox[{"2", " ", "\[Beta]", " ", 
      SubscriptBox["\[Sigma]", "uv"]}]}]]}], "&&", 
  RowBox[{"\[Lambda]", "\[Equal]", 
   FractionBox[
    RowBox[{
     RowBox[{"\[Beta]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     SubscriptBox["\[Sigma]", "uv"]}], 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
     RowBox[{"2", " ", "\[Beta]", " ", 
      SubscriptBox["\[Sigma]", "uv"]}]}]]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623038513*^9, 3.3896231179996*^9, 3.3896232955804*^9, 
  3.3899917572486*^9, 3.3899918092876*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["p", "Solutions"], "=", 
  RowBox[{"ToRules", "[", 
   RowBox[{"Take", "[", 
    RowBox[{"r", ",", 
     RowBox[{"-", "2"}]}], "]"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Mu]", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[Alpha]"}], " ", "\[Beta]", " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
       SubscriptBox["p", "0"]}], "-", 
      RowBox[{"\[Alpha]", " ", 
       SubscriptBox["\[Sigma]", "uv"]}], "+", 
      RowBox[{"\[Beta]", " ", 
       SubscriptBox["p", "0"], " ", 
       SubscriptBox["\[Sigma]", "uv"]}]}], 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
      RowBox[{"2", " ", "\[Beta]", " ", 
       SubscriptBox["\[Sigma]", "uv"]}]}]]}], ",", 
   RowBox[{"\[Lambda]", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"\[Beta]", " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      SubscriptBox["\[Sigma]", "uv"]}], 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
      RowBox[{"2", " ", "\[Beta]", " ", 
       SubscriptBox["\[Sigma]", "uv"]}]}]]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623038551*^9, 3.3896231180366*^9, 3.3896232956104*^9, 
  3.3899917574416*^9, 3.3899918093096*^9}]
}, Open  ]],

Cell["Collecting the results and solving:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EquSet", "=", 
  RowBox[{"Apply", "[", 
   RowBox[{"Equal", ",", 
    RowBox[{"Join", "[", 
     RowBox[{
      SubscriptBox["p", "Solutions"], ",", 
      SubscriptBox["x", "Solutions"]}], "]"}], ",", "1"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Mu]", "\[Equal]", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[Alpha]"}], " ", "\[Beta]", " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
       SubscriptBox["p", "0"]}], "-", 
      RowBox[{"\[Alpha]", " ", 
       SubscriptBox["\[Sigma]", "uv"]}], "+", 
      RowBox[{"\[Beta]", " ", 
       SubscriptBox["p", "0"], " ", 
       SubscriptBox["\[Sigma]", "uv"]}]}], 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
      RowBox[{"2", " ", "\[Beta]", " ", 
       SubscriptBox["\[Sigma]", "uv"]}]}]]}], ",", 
   RowBox[{"\[Lambda]", "\[Equal]", 
    FractionBox[
     RowBox[{
      RowBox[{"\[Beta]", " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      SubscriptBox["\[Sigma]", "uv"]}], 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
      RowBox[{"2", " ", "\[Beta]", " ", 
       SubscriptBox["\[Sigma]", "uv"]}]}]]}], ",", 
   RowBox[{"\[Alpha]", "\[Equal]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["\[Mu]", "\[Lambda]"]}], "+", 
       FractionBox[
        RowBox[{
         SubscriptBox["p", "0"], " ", 
         SubscriptBox["\[Sigma]", "uv"]}], 
        SubscriptBox["\[CapitalSigma]", "0"]]}], ")"}]}]}], ",", 
   RowBox[{"\[Beta]", "\[Equal]", 
    FractionBox[
     RowBox[{
      SubscriptBox["\[CapitalSigma]", "0"], "-", 
      RowBox[{"\[Lambda]", " ", 
       SubscriptBox["\[Sigma]", "uv"]}]}], 
     RowBox[{"2", " ", "\[Lambda]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}]]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230385880003`*^9, 3.3896231180776*^9, 
  3.3896232956414003`*^9, 3.3899917577005997`*^9, 3.3899918093326*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["Model", "Solutions"], "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{"EquSet", ",", 
       RowBox[{"{", 
        RowBox[{"\[Mu]", ",", "\[Lambda]", ",", "\[Alpha]", ",", "\[Beta]"}], 
        "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "u", "2"], ">", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[CapitalSigma]", "0"], ">", "0"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["Model", "Solutions"], "//", "Transpose"}], "//", 
  "TableForm"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"\[Alpha]", "\[Rule]", 
      FractionBox[
       RowBox[{
        SubscriptBox["p", "0"], " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["\[Sigma]", "uv"], "-", 
          SqrtBox[
           RowBox[{
            RowBox[{"4", " ", 
             SubscriptBox["\[CapitalSigma]", "0"], " ", 
             SubsuperscriptBox["\[Sigma]", "u", "2"]}], "-", 
            RowBox[{"3", " ", 
             SubsuperscriptBox["\[Sigma]", "uv", "2"]}]}]]}], ")"}]}], 
       RowBox[{"2", " ", 
        SubscriptBox["\[CapitalSigma]", "0"]}]]}], 
     RowBox[{"\[Alpha]", "\[Rule]", 
      FractionBox[
       RowBox[{
        SubscriptBox["p", "0"], " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["\[Sigma]", "uv"], "+", 
          SqrtBox[
           RowBox[{
            RowBox[{"4", " ", 
             SubscriptBox["\[CapitalSigma]", "0"], " ", 
             SubsuperscriptBox["\[Sigma]", "u", "2"]}], "-", 
            RowBox[{"3", " ", 
             SubsuperscriptBox["\[Sigma]", "uv", "2"]}]}]]}], ")"}]}], 
       RowBox[{"2", " ", 
        SubscriptBox["\[CapitalSigma]", "0"]}]]}]},
    {
     RowBox[{"\[Mu]", "\[Rule]", 
      SubscriptBox["p", "0"]}], 
     RowBox[{"\[Mu]", "\[Rule]", 
      SubscriptBox["p", "0"]}]},
    {
     RowBox[{"\[Lambda]", "\[Rule]", 
      FractionBox[
       RowBox[{
        SubscriptBox["\[CapitalSigma]", "0"], " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["\[Sigma]", "uv"], "+", 
          SqrtBox[
           RowBox[{
            RowBox[{"4", " ", 
             SubscriptBox["\[CapitalSigma]", "0"], " ", 
             SubsuperscriptBox["\[Sigma]", "u", "2"]}], "-", 
            RowBox[{"3", " ", 
             SubsuperscriptBox["\[Sigma]", "uv", "2"]}]}]]}], ")"}]}], 
       RowBox[{
        RowBox[{"4", " ", 
         SubscriptBox["\[CapitalSigma]", "0"], " ", 
         SubsuperscriptBox["\[Sigma]", "u", "2"]}], "-", 
        RowBox[{"3", " ", 
         SubsuperscriptBox["\[Sigma]", "uv", "2"]}], "+", 
        RowBox[{
         SubscriptBox["\[Sigma]", "uv"], " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"4", " ", 
            SubscriptBox["\[CapitalSigma]", "0"], " ", 
            SubsuperscriptBox["\[Sigma]", "u", "2"]}], "-", 
           RowBox[{"3", " ", 
            SubsuperscriptBox["\[Sigma]", "uv", "2"]}]}]]}]}]]}], 
     RowBox[{"\[Lambda]", "\[Rule]", 
      FractionBox[
       RowBox[{
        SubscriptBox["\[CapitalSigma]", "0"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["\[Sigma]", "uv"]}], "+", 
          SqrtBox[
           RowBox[{
            RowBox[{"4", " ", 
             SubscriptBox["\[CapitalSigma]", "0"], " ", 
             SubsuperscriptBox["\[Sigma]", "u", "2"]}], "-", 
            RowBox[{"3", " ", 
             SubsuperscriptBox["\[Sigma]", "uv", "2"]}]}]]}], ")"}]}], 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         SubscriptBox["\[CapitalSigma]", "0"], " ", 
         SubsuperscriptBox["\[Sigma]", "u", "2"]}], "+", 
        RowBox[{"3", " ", 
         SubsuperscriptBox["\[Sigma]", "uv", "2"]}], "+", 
        RowBox[{
         SubscriptBox["\[Sigma]", "uv"], " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"4", " ", 
            SubscriptBox["\[CapitalSigma]", "0"], " ", 
            SubsuperscriptBox["\[Sigma]", "u", "2"]}], "-", 
           RowBox[{"3", " ", 
            SubsuperscriptBox["\[Sigma]", "uv", "2"]}]}]]}]}]]}]},
    {
     RowBox[{"\[Beta]", "\[Rule]", 
      FractionBox[
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["\[Sigma]", "uv"]}], "+", 
        SqrtBox[
         RowBox[{
          RowBox[{"4", " ", 
           SubscriptBox["\[CapitalSigma]", "0"], " ", 
           SubsuperscriptBox["\[Sigma]", "u", "2"]}], "-", 
          RowBox[{"3", " ", 
           SubsuperscriptBox["\[Sigma]", "uv", "2"]}]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["\[CapitalSigma]", "0"]}]]}], 
     RowBox[{"\[Beta]", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SubscriptBox["\[Sigma]", "uv"], "+", 
         SqrtBox[
          RowBox[{
           RowBox[{"4", " ", 
            SubscriptBox["\[CapitalSigma]", "0"], " ", 
            SubsuperscriptBox["\[Sigma]", "u", "2"]}], "-", 
           RowBox[{"3", " ", 
            SubsuperscriptBox["\[Sigma]", "uv", "2"]}]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["\[CapitalSigma]", "0"]}]]}]}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623038867*^9, 3.3896231182236*^9, 
  3.3896232957804003`*^9, 3.3899917578375998`*^9, 3.3899918096226*^9}]
}, Open  ]],

Cell[TextData[{
 "Only the first solution can have ",
 Cell[BoxData[
  RowBox[{"\[Beta]", ">", "0"}]]],
 ", So:"
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["Model", "Solutions"], "=", 
   RowBox[{
    SubscriptBox["Model", "Solutions"], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Sigma]", "uv"], "=", "0"}]]],
 ", this reduces to the original solutions:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    SubscriptBox["Model", "Solutions"], "/.", "\[InvisibleSpace]", 
    RowBox[{
     SubscriptBox["\[Sigma]", "uv"], "\[Rule]", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[CapitalSigma]", "0"], ">", "0"}], ",", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], ">", "0"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Alpha]", "\[Rule]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
       SubscriptBox["p", "0"]}], 
      SqrtBox[
       RowBox[{
        SubscriptBox["\[CapitalSigma]", "0"], " ", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}]]]}]}], ",", 
   RowBox[{"\[Mu]", "\[Rule]", 
    SubscriptBox["p", "0"]}], ",", 
   RowBox[{"\[Lambda]", "\[Rule]", 
    FractionBox[
     SubscriptBox["\[CapitalSigma]", "0"], 
     RowBox[{"2", " ", 
      SqrtBox[
       RowBox[{
        SubscriptBox["\[CapitalSigma]", "0"], " ", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]]}], ",", 
   RowBox[{"\[Beta]", "\[Rule]", 
    SqrtBox[
     FractionBox[
      SubsuperscriptBox["\[Sigma]", "u", "2"], 
      SubscriptBox["\[CapitalSigma]", "0"]]]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623038954*^9, 3.3896231182785997`*^9, 
  3.3896232958274*^9, 3.3899917579105997`*^9, 3.3899918096826*^9}]
}, Open  ]],

Cell["With perfect correlation...", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AltSolution", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["Model", "Solutions"], "/.", "\[InvisibleSpace]", 
     RowBox[{
      SubscriptBox["\[Sigma]", "uv"], "\[Rule]", 
      SqrtBox[
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "u", "2"], 
        SubscriptBox["\[CapitalSigma]", "0"]}]]}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[CapitalSigma]", "0"], ">", "0"}], ",", 
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "u", "2"], ">", "0"}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Alpha]", "\[Rule]", "0"}], ",", 
   RowBox[{"\[Mu]", "\[Rule]", 
    SubscriptBox["p", "0"]}], ",", 
   RowBox[{"\[Lambda]", "\[Rule]", 
    SqrtBox[
     FractionBox[
      SubscriptBox["\[CapitalSigma]", "0"], 
      SubsuperscriptBox["\[Sigma]", "u", "2"]]]}], ",", 
   RowBox[{"\[Beta]", "\[Rule]", "0"}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623038998*^9, 3.3896231183156*^9, 3.3896232958634*^9, 
  3.3899917579716*^9, 3.3899918097455997`*^9}]
}, Open  ]],

Cell[TextData[{
 "Since ",
 Cell[BoxData[
  RowBox[{"\[Beta]", "=", "0"}]]],
 ", the informed trader doesn't trade at all. The uninformed trade, though, \
is linear in ",
 Cell[BoxData["v"]],
 ":"
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["u", "Rule"], "=", 
   RowBox[{"u", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"v", "-", 
        SubscriptBox["p", "0"]}], ")"}], " ", 
      SqrtBox[
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
        SubscriptBox["\[CapitalSigma]", "0"]}]]}], 
     SubscriptBox["\[CapitalSigma]", "0"]]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "Under these conditions, the market clearing price becomes ",
 Cell[BoxData[
  RowBox[{"p", "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["p", "0"], "+", 
     RowBox[{"\[Lambda]", " ", "y"}]}], "=", "v"}]}]]],
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["p", "Rule"], "/.", "\[InvisibleSpace]", "AltSolution"}], 
      "/.", "\[InvisibleSpace]", 
      SubscriptBox["y", "Rule"]}], "/.", "\[InvisibleSpace]", 
     RowBox[{"x", "\[Rule]", "0"}]}], "/.", "\[InvisibleSpace]", 
    SubscriptBox["u", "Rule"]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[CapitalSigma]", "0"], ">", "0"}], ",", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], ">", "0"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"p", "\[Rule]", "v"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623039043*^9, 3.3896231183676*^9, 3.3896232959014*^9, 
  3.3899917580755997`*^9, 3.3899918098286*^9}]
}, Open  ]],

Cell["Also,  the conditional variance is:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GetVariance", "[", "vConditionalDist", "]"}], "//.", 
   "\[InvisibleSpace]", 
   SubscriptBox["Model", "Solutions"]}], "/.", "\[InvisibleSpace]", 
  RowBox[{
   SubscriptBox["\[Sigma]", "uv"], "\[Rule]", 
   SqrtBox[
    RowBox[{
     SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
     SubscriptBox["\[CapitalSigma]", "0"]}]]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData["0"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.38962303909*^9, 3.3896231184016*^9, 
  3.3896232959323997`*^9, 3.3899917581516*^9, 3.3899918098506002`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Exercise 7.2 (Informed trader gets a signal, Source notebook: StrategicTrade)\
\
\>", "Subsection",
 CellChangeTimes->{3.3907329753346*^9},
 CellTags->"ExStrategicTrade2"],

Cell[TextData[{
 "The informed trader in the basic model has perfect information about ",
 StyleBox["v",
  FontSlant->"Italic"],
 ". Consider the case where she only gets a signal ",
 StyleBox["s",
  FontSlant->"Italic"],
 " about ",
 StyleBox["v",
  FontSlant->"Italic"],
 ". That is, ",
 Cell[BoxData[
  RowBox[{"s", "=", 
   RowBox[{"v", "+", "\[Epsilon]"}]}]]],
 " where ",
 Cell[BoxData[
  RowBox[{"\[Epsilon]", "~", 
   RowBox[{"N", "[", 
    RowBox[{"0", ",", 
     SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "]"}]}]]],
 ", independent of ",
 Cell[BoxData["v"]],
 ". Solve the model by proceeding as in the basic case. Solve the informed \
trader's problem; solve the MM's problem; solve for the model parameters ",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Mu]", ",", "\[Lambda]"}], 
   ")"}]]],
 " in terms of the inputs, ",
 Cell[BoxData[
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "u", "2"], ",", " ", 
   SubscriptBox["\[CapitalSigma]", "0"], ","}]]],
 " and ",
 Cell[BoxData[
  SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]]],
 ". Interpret your results. Verify that when ",
 Cell[BoxData[
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "=", "0"}]]],
 ", you get the original model solutions."
}], "Text"],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["p", "Rule"], "=", 
   RowBox[{"p", "\[Rule]", 
    RowBox[{
     RowBox[{"y", " ", "\[Lambda]"}], "+", "\[Mu]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["y", "Rule"], "=", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"u", "+", "x"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["\[Pi]", "Rule"], "=", 
   RowBox[{"\[Pi]", "\[Rule]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"v", "-", "p"}], ")"}], " ", "x"}]}]}], ";"}]}], "Input",
 CellLabelAutoDelete->True],

Cell["Informed trader's profits:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Pi]", "/.", "\[InvisibleSpace]", 
    SubscriptBox["\[Pi]", "Rule"]}], "/.", "\[InvisibleSpace]", 
   SubscriptBox["p", "Rule"]}], "/.", "\[InvisibleSpace]", 
  SubscriptBox["y", "Rule"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"x", " ", 
  RowBox[{"(", 
   RowBox[{"v", "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"u", "+", "x"}], ")"}], " ", "\[Lambda]"}], "-", "\[Mu]"}], 
   ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623039134*^9, 3.3896231184435997`*^9, 
  3.3896232959674*^9, 3.3899917582706003`*^9, 3.3899918098806*^9}]
}, Open  ]],

Cell[TextData[{
 "The informed trader gets the signal ",
 Cell[BoxData["s"]],
 ":"
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["s", "Rule"], "=", 
   RowBox[{"s", "\[Rule]", 
    RowBox[{"v", "+", "\[Epsilon]"}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell["There are three random variables in this problem:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v\[Epsilon]uDistribution", "=", 
  RowBox[{"MVN", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["p", "0"], ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["\[CapitalSigma]", "0"], ",", "0", ",", "0"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], ",", "0"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"v", ",", "\[Epsilon]", ",", "u"}], "}"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"v"},
        {"\[Epsilon]"},
        {"u"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["p", "0"]},
        {"0"},
        {"0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["\[CapitalSigma]", "0"], "0", "0"},
       {"0", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "0"},
       {"0", "0", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623039176*^9, 3.3896231184966*^9, 3.3896232960114*^9, 
  3.3899917583616*^9, 3.3899918099616003`*^9}]
}, Open  ]],

Cell[TextData[{
 "We can rework this into a distribution for ",
 Cell[BoxData[
  RowBox[{"v", ",", "s", ",", "u"}]]],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MakeLinearForm", "[", 
  RowBox[{"v\[Epsilon]uDistribution", ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"s", "/.", 
      SubscriptBox["s", "Rule"]}], ",", "u"}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"v"},
        {
         RowBox[{"v", "+", "\[Epsilon]"}]},
        {"u"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["p", "0"]},
        {
         SubscriptBox["p", "0"]},
        {"0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["\[CapitalSigma]", "0"], 
        SubscriptBox["\[CapitalSigma]", "0"], "0"},
       {
        SubscriptBox["\[CapitalSigma]", "0"], 
        RowBox[{
         SubscriptBox["\[CapitalSigma]", "0"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "0"},
       {"0", "0", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623039218*^9, 3.3896231185346003`*^9, 
  3.3896232960434*^9, 3.3899917584286003`*^9, 3.3899918099946003`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vsuDistribution", "=", 
  RowBox[{"SetLabel", "[", 
   RowBox[{"%", ",", 
    RowBox[{"{", 
     RowBox[{"v", ",", "s", ",", "u"}], "}"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"v"},
        {"s"},
        {"u"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["p", "0"]},
        {
         SubscriptBox["p", "0"]},
        {"0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["\[CapitalSigma]", "0"], 
        SubscriptBox["\[CapitalSigma]", "0"], "0"},
       {
        SubscriptBox["\[CapitalSigma]", "0"], 
        RowBox[{
         SubscriptBox["\[CapitalSigma]", "0"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "0"},
       {"0", "0", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230392530003`*^9, 3.3896231185726*^9, 
  3.3896232960744*^9, 3.3899917584946003`*^9, 3.3899918100576*^9}]
}, Open  ]],

Cell[TextData[{
 "The informed trader forms the conditional distribution of ",
 Cell[BoxData["v"]],
 " based on his signal:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vConditionalDistInf", "=", 
  RowBox[{"MVNConditional", "[", 
   RowBox[{"vsuDistribution", ",", "v", ",", "s"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"v", 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   RowBox[{
    FractionBox[
     RowBox[{
      SubscriptBox["\[CapitalSigma]", "0"], " ", 
      RowBox[{"(", 
       RowBox[{"s", "-", 
        SubscriptBox["p", "0"]}], ")"}]}], 
     RowBox[{
      SubscriptBox["\[CapitalSigma]", "0"], "+", 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]], "+", 
    SubscriptBox["p", "0"]}], ",", 
   RowBox[{
    SubscriptBox["\[CapitalSigma]", "0"], "-", 
    FractionBox[
     SubsuperscriptBox["\[CapitalSigma]", "0", "2"], 
     RowBox[{
      SubscriptBox["\[CapitalSigma]", "0"], "+", 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]]}], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.38962303929*^9, 3.3896231186096*^9, 
  3.3896232961113997`*^9, 3.3899917585546*^9, 3.3899918101366*^9}]
}, Open  ]],

Cell["The expected profits are developed from:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Pi]", "/.", "\[InvisibleSpace]", 
    SubscriptBox["\[Pi]", "Rule"]}], "/.", "\[InvisibleSpace]", 
   SubscriptBox["p", "Rule"]}], "/.", "\[InvisibleSpace]", 
  SubscriptBox["y", "Rule"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"x", " ", 
  RowBox[{"(", 
   RowBox[{"v", "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"u", "+", "x"}], ")"}], " ", "\[Lambda]"}], "-", "\[Mu]"}], 
   ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623039326*^9, 3.3896231186466*^9, 3.3896232961424*^9, 
  3.3899917586176*^9, 3.3899918102026*^9}]
}, Open  ]],

Cell[TextData[{
 "... substituting in the conditional mean for ",
 Cell[BoxData["v"]],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"E\[Pi]", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"\[Pi]", "/.", "\[InvisibleSpace]", 
       SubscriptBox["\[Pi]", "Rule"]}], "/.", "\[InvisibleSpace]", 
      SubscriptBox["p", "Rule"]}], "/.", "\[InvisibleSpace]", 
     SubscriptBox["y", "Rule"]}], "/.", 
    RowBox[{"u", "\[Rule]", "0"}]}], "/.", 
   RowBox[{"v", "\[Rule]", 
    RowBox[{"GetMean", "[", "vConditionalDistInf", "]"}]}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"x", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "x"}], " ", "\[Lambda]"}], "-", "\[Mu]", "+", 
    FractionBox[
     RowBox[{
      SubscriptBox["\[CapitalSigma]", "0"], " ", 
      RowBox[{"(", 
       RowBox[{"s", "-", 
        SubscriptBox["p", "0"]}], ")"}]}], 
     RowBox[{
      SubscriptBox["\[CapitalSigma]", "0"], "+", 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]], "+", 
    SubscriptBox["p", "0"]}], ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623039362*^9, 3.3896231186826*^9, 3.3896232961734*^9, 
  3.3899917586776*^9, 3.3899918102606*^9}]
}, Open  ]],

Cell[TextData[{
 "The informed trader maximizes expected profits by trading ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]]],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xOpt", "=", 
  RowBox[{"First", " ", "@", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["\[PartialD]", "x"], "E\[Pi]"}], "\[Equal]", "0"}], ",", 
      "x"}], "]"}], "]"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   FractionBox[
    RowBox[{
     RowBox[{"s", " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "-", 
     RowBox[{"\[Mu]", " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["\[CapitalSigma]", "0"], "+", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}], "+", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], " ", 
      SubscriptBox["p", "0"]}]}], 
    RowBox[{"2", " ", "\[Lambda]", " ", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[CapitalSigma]", "0"], "+", 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}]]}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623039409*^9, 3.3896231187276*^9, 3.3896232962124*^9, 
  3.3899917587406*^9, 3.3899918103386*^9}]
}, Open  ]],

Cell[TextData[{
 "The MM conjectures that the informed trader's demand is linear in ",
 Cell[BoxData["s"]],
 ":"
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["x", "Rule"], "=", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"\[Alpha]", "+", 
     RowBox[{"s", " ", "\[Beta]"}]}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "Knowing the optimization process that the informed trader followed, the MM \
can solve for ",
 Cell[BoxData["\[Alpha]"]],
 " and ",
 Cell[BoxData["\[Beta]"]],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xEqu", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "/.", "\[InvisibleSpace]", 
     SubscriptBox["x", "Rule"]}], ")"}], "\[Equal]", 
   RowBox[{"(", 
    RowBox[{"x", "/.", "\[InvisibleSpace]", "xOpt"}], ")"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Alpha]", "+", 
   RowBox[{"s", " ", "\[Beta]"}]}], "\[Equal]", 
  FractionBox[
   RowBox[{
    RowBox[{"s", " ", 
     SubscriptBox["\[CapitalSigma]", "0"]}], "-", 
    RowBox[{"\[Mu]", " ", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[CapitalSigma]", "0"], "+", 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}], "+", 
    RowBox[{
     SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], " ", 
     SubscriptBox["p", "0"]}]}], 
   RowBox[{"2", " ", "\[Lambda]", " ", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["\[CapitalSigma]", "0"], "+", 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], 
     ")"}]}]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623039576*^9, 3.3896231187696*^9, 3.3896232962454*^9, 
  3.3899917588906*^9, 3.3899918104026003`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["x", "Solutions"], "=", 
  RowBox[{"Reduce", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["\[ForAll]", "s"], "xEqu"}], " ", "&&", " ", 
     RowBox[{
      SubscriptBox["\[CapitalSigma]", "0"], ">", "0"}], " ", "&&", " ", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], ">", "0"}], " ", "&&",
      " ", 
     RowBox[{"\[Lambda]", ">", "0"}], " ", "&&", " ", 
     RowBox[{"s", "\[NotEqual]", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Alpha]", ",", "\[Beta]"}], "}"}], ",", "Reals"}], 
   "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], ">", "0"}], "&&", 
  RowBox[{
   SubscriptBox["\[CapitalSigma]", "0"], ">", "0"}], "&&", 
  RowBox[{"\[Lambda]", ">", "0"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"s", "<", "0"}], "&&", 
      RowBox[{"\[Alpha]", "\[Equal]", 
       FractionBox[
        RowBox[{
         RowBox[{
          RowBox[{"-", "\[Mu]"}], " ", 
          SubscriptBox["\[CapitalSigma]", "0"]}], "-", 
         RowBox[{"\[Mu]", " ", 
          SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "+", 
         RowBox[{
          SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], " ", 
          SubscriptBox["p", "0"]}]}], 
        RowBox[{
         RowBox[{"2", " ", "\[Lambda]", " ", 
          SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
         RowBox[{"2", " ", "\[Lambda]", " ", 
          SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]]}], "&&", 
      RowBox[{"\[Beta]", "\[Equal]", 
       FractionBox[
        SubscriptBox["\[CapitalSigma]", "0"], 
        RowBox[{
         RowBox[{"2", " ", "\[Lambda]", " ", 
          SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
         RowBox[{"2", " ", "\[Lambda]", " ", 
          SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]]}]}], ")"}], "||",
     
    RowBox[{"(", 
     RowBox[{
      RowBox[{"s", ">", "0"}], "&&", 
      RowBox[{"\[Alpha]", "\[Equal]", 
       FractionBox[
        RowBox[{
         RowBox[{
          RowBox[{"-", "\[Mu]"}], " ", 
          SubscriptBox["\[CapitalSigma]", "0"]}], "-", 
         RowBox[{"\[Mu]", " ", 
          SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "+", 
         RowBox[{
          SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], " ", 
          SubscriptBox["p", "0"]}]}], 
        RowBox[{
         RowBox[{"2", " ", "\[Lambda]", " ", 
          SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
         RowBox[{"2", " ", "\[Lambda]", " ", 
          SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]]}], "&&", 
      RowBox[{"\[Beta]", "\[Equal]", 
       FractionBox[
        SubscriptBox["\[CapitalSigma]", "0"], 
        RowBox[{
         RowBox[{"2", " ", "\[Lambda]", " ", 
          SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
         RowBox[{"2", " ", "\[Lambda]", " ", 
          SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]]}]}], ")"}]}], 
   ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230396280003`*^9, 3.3896231188266*^9, 
  3.3896232962964*^9, 3.3899917589616003`*^9, 3.3899918104996*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["x", "Solutions"], "=", 
  RowBox[{"Simplify", " ", "@", " ", 
   RowBox[{"ToRules", " ", "@", " ", 
    RowBox[{"Take", "[", 
     RowBox[{
      RowBox[{
       SubscriptBox["x", "Solutions"], "[", 
       RowBox[{"[", 
        RowBox[{"4", ",", "1"}], "]"}], "]"}], ",", 
      RowBox[{"-", "2"}]}], "]"}]}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Alpha]", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[Mu]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[CapitalSigma]", "0"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}], "+", 
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], " ", 
       SubscriptBox["p", "0"]}]}], 
     RowBox[{"2", " ", "\[Lambda]", " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["\[CapitalSigma]", "0"], "+", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}]]}], ",", 
   RowBox[{"\[Beta]", "\[Rule]", 
    FractionBox[
     SubscriptBox["\[CapitalSigma]", "0"], 
     RowBox[{
      RowBox[{"2", " ", "\[Lambda]", " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      RowBox[{"2", " ", "\[Lambda]", " ", 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]]}]}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623039663*^9, 3.3896231188666*^9, 3.3896232963304*^9, 
  3.3899917590236*^9, 3.3899918105615997`*^9}]
}, Open  ]],

Cell[TextData[{
 "Now the MM must figure out ",
 Cell[BoxData[
  RowBox[{"E", "[", 
   RowBox[{
    RowBox[{"V", "|", "Y"}], "=", "y"}], "]"}]]],
 ". This is a little more involved than in the original problem because the \
informed trader's demand is conditioned on ",
 Cell[BoxData["s"]],
 ". The joint distribution of ",
 Cell[BoxData["v"]],
 " and ",
 Cell[BoxData[
  RowBox[{"y", "=", 
   RowBox[{"u", "+", "\[Alpha]", "+", "s\[Beta]"}]}]]],
 " is:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MakeLinearForm", "[", 
  RowBox[{"vsuDistribution", ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{
      RowBox[{"y", "/.", 
       SubscriptBox["y", "Rule"]}], "/.", 
      SubscriptBox["x", "Rule"]}]}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"v"},
        {
         RowBox[{"u", "+", "\[Alpha]", "+", 
          RowBox[{"s", " ", "\[Beta]"}]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["p", "0"]},
        {
         RowBox[{"\[Alpha]", "+", 
          RowBox[{"\[Beta]", " ", 
           SubscriptBox["p", "0"]}]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["\[CapitalSigma]", "0"], 
        RowBox[{"\[Beta]", " ", 
         SubscriptBox["\[CapitalSigma]", "0"]}]},
       {
        RowBox[{"\[Beta]", " ", 
         SubscriptBox["\[CapitalSigma]", "0"]}], 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
         RowBox[{
          SuperscriptBox["\[Beta]", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["\[CapitalSigma]", "0"], "+", 
            SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230397*^9, 3.3896231189066*^9, 3.3896232963644*^9, 
  3.3899917591106*^9, 3.3899918106216*^9}]
}, Open  ]],

Cell["... and relabeling:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vyDistribution", "=", 
  RowBox[{"SetLabel", "[", 
   RowBox[{"%", ",", 
    RowBox[{"{", 
     RowBox[{"v", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"v"},
        {"y"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["p", "0"]},
        {
         RowBox[{"\[Alpha]", "+", 
          RowBox[{"\[Beta]", " ", 
           SubscriptBox["p", "0"]}]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["\[CapitalSigma]", "0"], 
        RowBox[{"\[Beta]", " ", 
         SubscriptBox["\[CapitalSigma]", "0"]}]},
       {
        RowBox[{"\[Beta]", " ", 
         SubscriptBox["\[CapitalSigma]", "0"]}], 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
         RowBox[{
          SuperscriptBox["\[Beta]", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["\[CapitalSigma]", "0"], "+", 
            SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623039731*^9, 3.3896231189435997`*^9, 
  3.3896232963954*^9, 3.3899917591786003`*^9, 3.3899918106876*^9}]
}, Open  ]],

Cell[TextData[{
 "So the distribution of ",
 Cell[BoxData["v"]],
 " (conditional on ",
 Cell[BoxData["y"]],
 ") is:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vConditionalDistributionMM", "=", 
  RowBox[{"MVNConditional", "[", 
   RowBox[{"vyDistribution", ",", "v", ",", "y"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"v", 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   RowBox[{
    SubscriptBox["p", "0"], "+", 
    FractionBox[
     RowBox[{"\[Beta]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"], " ", 
      RowBox[{"(", 
       RowBox[{"y", "-", "\[Alpha]", "-", 
        RowBox[{"\[Beta]", " ", 
         SubscriptBox["p", "0"]}]}], ")"}]}], 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[CapitalSigma]", "0"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}]}]]}], 
   ",", 
   RowBox[{
    SubscriptBox["\[CapitalSigma]", "0"], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SubsuperscriptBox["\[CapitalSigma]", "0", "2"]}], 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[CapitalSigma]", "0"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}]}]]}], 
   ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230397679996`*^9, 3.3896231189806004`*^9, 
  3.3896232964264*^9, 3.3899917592416*^9, 3.3899918107455997`*^9}]
}, Open  ]],

Cell["Market efficiency requires", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pEqu", "=", 
  RowBox[{
   RowBox[{"GetMean", "[", "vConditionalDistributionMM", "]"}], "\[Equal]", 
   RowBox[{"(", 
    RowBox[{"p", "/.", "\[InvisibleSpace]", 
     SubscriptBox["p", "Rule"]}], ")"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["p", "0"], "+", 
   FractionBox[
    RowBox[{"\[Beta]", " ", 
     SubscriptBox["\[CapitalSigma]", "0"], " ", 
     RowBox[{"(", 
      RowBox[{"y", "-", "\[Alpha]", "-", 
       RowBox[{"\[Beta]", " ", 
        SubscriptBox["p", "0"]}]}], ")"}]}], 
    RowBox[{
     SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["\[CapitalSigma]", "0"], "+", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}]}]]}], 
  "\[Equal]", 
  RowBox[{
   RowBox[{"y", " ", "\[Lambda]"}], "+", "\[Mu]"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623039799*^9, 3.3896231190355997`*^9, 
  3.3896232964554*^9, 3.3899917593046*^9, 3.3899918108006*^9}]
}, Open  ]],

Cell["Solving:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["p", "Solutions"], "=", 
  RowBox[{"Reduce", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["\[ForAll]", "y"], "pEqu"}], " ", "&&", " ", 
     RowBox[{
      SubscriptBox["\[CapitalSigma]", "0"], ">", "0"}], " ", "&&", " ", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], ">", "0"}], "  ", "&&",
      " ", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], ">", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Mu]", ",", "\[Lambda]"}], "}"}], ",", "Reals"}], 
   "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], ">", "0"}], "&&", 
  RowBox[{
   SubscriptBox["\[CapitalSigma]", "0"], ">", "0"}], "&&", 
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "u", "2"], ">", "0"}], "&&", 
  RowBox[{"\[Mu]", "\[Equal]", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[Alpha]"}], " ", "\[Beta]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
      SubscriptBox["p", "0"]}], "+", 
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], " ", 
      SubscriptBox["p", "0"]}]}], 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]]}], "&&", 
  RowBox[{"\[Lambda]", "\[Equal]", 
   FractionBox[
    RowBox[{"\[Beta]", " ", 
     SubscriptBox["\[CapitalSigma]", "0"]}], 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230399519997`*^9, 3.3896231191926003`*^9, 
  3.3896232966024*^9, 3.3899917594286003`*^9, 3.3899918111586*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["p", "Solutions"], "=", 
  RowBox[{"Simplify", " ", "@", " ", 
   RowBox[{"ToRules", " ", "@", " ", 
    RowBox[{"Take", "[", 
     RowBox[{
      SubscriptBox["p", "Solutions"], ",", 
      RowBox[{"-", "2"}]}], "]"}]}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Mu]", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[Alpha]"}], " ", "\[Beta]", " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
         RowBox[{
          SuperscriptBox["\[Beta]", "2"], " ", 
          SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}], ")"}], " ", 
       SubscriptBox["p", "0"]}]}], 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[CapitalSigma]", "0"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}]}]]}], 
   ",", 
   RowBox[{"\[Lambda]", "\[Rule]", 
    FractionBox[
     RowBox[{"\[Beta]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[CapitalSigma]", "0"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}]}]]}]}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.38962304*^9, 3.3896231192386*^9, 3.3896232966504*^9, 
  3.3899917596216*^9, 3.3899918112086*^9}]
}, Open  ]],

Cell["Collecting the results and solving:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EquationSet", "=", 
  RowBox[{"Apply", "[", 
   RowBox[{"Equal", ",", 
    RowBox[{"Join", "[", 
     RowBox[{
      SubscriptBox["p", "Solutions"], ",", 
      SubscriptBox["x", "Solutions"]}], "]"}], ",", "1"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Mu]", "\[Equal]", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[Alpha]"}], " ", "\[Beta]", " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
         RowBox[{
          SuperscriptBox["\[Beta]", "2"], " ", 
          SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}], ")"}], " ", 
       SubscriptBox["p", "0"]}]}], 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[CapitalSigma]", "0"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}]}]]}], 
   ",", 
   RowBox[{"\[Lambda]", "\[Equal]", 
    FractionBox[
     RowBox[{"\[Beta]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[CapitalSigma]", "0"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}]}]]}], 
   ",", 
   RowBox[{"\[Alpha]", "\[Equal]", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[Mu]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[CapitalSigma]", "0"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}], "+", 
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], " ", 
       SubscriptBox["p", "0"]}]}], 
     RowBox[{"2", " ", "\[Lambda]", " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["\[CapitalSigma]", "0"], "+", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}]]}], ",", 
   RowBox[{"\[Beta]", "\[Equal]", 
    FractionBox[
     SubscriptBox["\[CapitalSigma]", "0"], 
     RowBox[{
      RowBox[{"2", " ", "\[Lambda]", " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      RowBox[{"2", " ", "\[Lambda]", " ", 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]]}]}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230400360003`*^9, 3.3896231192746*^9, 
  3.3896232966784*^9, 3.3899917596886*^9, 3.3899918112316*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["Model", "Solutions"], "=", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{"EquationSet", ",", 
       RowBox[{"{", 
        RowBox[{"\[Mu]", ",", "\[Lambda]", ",", "\[Alpha]", ",", "\[Beta]"}], 
        "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[CapitalSigma]", "0"], ">", "0"}], ",", 
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "u", "2"], ">", "0"}], ",", 
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], ">", "0"}]}], 
      "}"}]}], "]"}], "//", "First"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Alpha]", "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       FractionBox[
        SubsuperscriptBox["\[Sigma]", "u", "2"], 
        RowBox[{
         SubscriptBox["\[CapitalSigma]", "0"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]]]}], " ", 
     SubscriptBox["p", "0"]}]}], ",", 
   RowBox[{"\[Mu]", "\[Rule]", 
    SubscriptBox["p", "0"]}], ",", 
   RowBox[{"\[Lambda]", "\[Rule]", 
    FractionBox[
     SubscriptBox["\[CapitalSigma]", "0"], 
     RowBox[{"2", " ", 
      SqrtBox[
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["\[CapitalSigma]", "0"], "+", 
          SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}]]}]]}], 
   ",", 
   RowBox[{"\[Beta]", "\[Rule]", 
    SqrtBox[
     FractionBox[
      SubsuperscriptBox["\[Sigma]", "u", "2"], 
      RowBox[{
       SubscriptBox["\[CapitalSigma]", "0"], "+", 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]]]}]}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230401400003`*^9, 3.3896231194356003`*^9, 
  3.3896232967764*^9, 3.3899917597576*^9, 3.3899918114056*^9}]
}, Open  ]],

Cell["To recover the original solutions:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["Model", "Solutions"], "/.", "\[InvisibleSpace]", 
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "\[Rule]", 
   "0"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Alpha]", "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       FractionBox[
        SubsuperscriptBox["\[Sigma]", "u", "2"], 
        SubscriptBox["\[CapitalSigma]", "0"]]]}], " ", 
     SubscriptBox["p", "0"]}]}], ",", 
   RowBox[{"\[Mu]", "\[Rule]", 
    SubscriptBox["p", "0"]}], ",", 
   RowBox[{"\[Lambda]", "\[Rule]", 
    FractionBox[
     SubscriptBox["\[CapitalSigma]", "0"], 
     RowBox[{"2", " ", 
      SqrtBox[
       RowBox[{
        SubscriptBox["\[CapitalSigma]", "0"], " ", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]]}], ",", 
   RowBox[{"\[Beta]", "\[Rule]", 
    SqrtBox[
     FractionBox[
      SubsuperscriptBox["\[Sigma]", "u", "2"], 
      SubscriptBox["\[CapitalSigma]", "0"]]]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623040171*^9, 3.3896231194695997`*^9, 
  3.3896232968084*^9, 3.3899917598826*^9, 3.3899918114276*^9}]
}, Open  ]],

Cell[TextData[{
 "Given the price (or equivalently the total order flow), the variance of ",
 Cell[BoxData["v"]],
 " is:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetVariance", "[", "vConditionalDistributionMM", "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[CapitalSigma]", "0"], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[Beta]", "2"], " ", 
    SubsuperscriptBox["\[CapitalSigma]", "0", "2"]}], 
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
    RowBox[{
     SuperscriptBox["\[Beta]", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[CapitalSigma]", "0"], "+", 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], 
      ")"}]}]}]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623040204*^9, 3.3896231195056*^9, 3.3896232968374*^9, 
  3.3899917599416*^9, 3.3899918114866*^9}]
}, Open  ]],

Cell[TextData[{
 "As we degrade the signal (increase ",
 Cell[BoxData[
  SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]]],
 "), the conditional variance approaches the unconditional variance."
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Exercise 7.3 (Broker piggy-backs on informed trader, Source notebook: \
StrategicTrade)\
\>", "Subsection",
 CellChangeTimes->{3.3907329808136*^9},
 CellTags->"ExStrategicTrade3"],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["p", "Rule"], "=", 
   RowBox[{"p", "\[Rule]", 
    RowBox[{
     RowBox[{"y", " ", "\[Lambda]"}], "+", "\[Mu]"}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "But now the order flow includes the broker's order flow ",
 Cell[BoxData["\[Gamma]x"]],
 "."
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["y", "Rule"], "=", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"u", "+", 
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "\[Gamma]"}], ")"}]}]}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell["The informed trader's profits are:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Pi]", "Rule"], "=", 
   RowBox[{"\[Pi]", "\[Rule]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"v", "-", "p"}], ")"}], " ", "x"}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "Substituting in for the price conjecture and ",
 StyleBox["y",
  FontSlant->"Italic"],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Pi]", "/.", "\[InvisibleSpace]", 
    SubscriptBox["\[Pi]", "Rule"]}], "/.", "\[InvisibleSpace]", 
   SubscriptBox["p", "Rule"]}], "/.", "\[InvisibleSpace]", 
  SubscriptBox["y", "Rule"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"x", " ", 
  RowBox[{"(", 
   RowBox[{"v", "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"u", "+", 
       RowBox[{"x", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Gamma]"}], ")"}]}]}], ")"}], " ", "\[Lambda]"}],
     "-", "\[Mu]"}], ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230402530003`*^9, 3.3896231195636*^9, 
  3.3896232968844*^9, 3.3899917600986*^9, 3.3899918115836*^9}]
}, Open  ]],

Cell[TextData[{
 "The expected profits (conditional on ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]]],
 ") are ",
 Cell[BoxData["E\[Pi]"]],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"E\[Pi]", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"\[Pi]", "/.", "\[InvisibleSpace]", 
       SubscriptBox["\[Pi]", "Rule"]}], "/.", "\[InvisibleSpace]", 
      SubscriptBox["p", "Rule"]}], "/.", "\[InvisibleSpace]", 
     SubscriptBox["y", "Rule"]}], "/.", "\[InvisibleSpace]", 
    RowBox[{"u", "\[Rule]", "0"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"x", " ", 
  RowBox[{"(", 
   RowBox[{"v", "-", 
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Gamma]"}], ")"}], " ", "\[Lambda]"}], "-", 
    "\[Mu]"}], ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230402860003`*^9, 3.3896231195986*^9, 
  3.3896232969154*^9, 3.3899917601586*^9, 3.3899918116526003`*^9}]
}, Open  ]],

Cell["The optimal quantity is:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xOpt", "=", 
  RowBox[{"First", " ", "@", " ", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["\[PartialD]", "x"], "E\[Pi]"}], "\[Equal]", "0"}], ",", 
     "x"}], "]"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   FractionBox[
    RowBox[{"v", "-", "\[Mu]"}], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Gamma]"}], ")"}], " ", "\[Lambda]"}]]}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230403199997`*^9, 3.3896231196366*^9, 
  3.3896232969474*^9, 3.3899917602276*^9, 3.3899918117156*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["x", "Rule"], "=", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"\[Alpha]", "+", 
     RowBox[{"v", " ", "\[Beta]"}]}]}]}], ";"}], "\n", 
 RowBox[{"xEqu", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "/.", "\[InvisibleSpace]", 
     SubscriptBox["x", "Rule"]}], ")"}], "\[Equal]", 
   RowBox[{"(", 
    RowBox[{"x", "/.", "\[InvisibleSpace]", "xOpt"}], ")"}]}]}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Alpha]", "+", 
   RowBox[{"v", " ", "\[Beta]"}]}], "\[Equal]", 
  FractionBox[
   RowBox[{"v", "-", "\[Mu]"}], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Gamma]"}], ")"}], " ", "\[Lambda]"}]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230403529997`*^9, 3.3896231196706*^9, 
  3.3896232969784*^9, 3.3899917602855997`*^9, 3.3899918117706003`*^9}]
}, Open  ]],

Cell["Solving:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["x", "Solutions"], "=", 
  RowBox[{"Reduce", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["\[ForAll]", "v"], "xEqu"}], " ", "&&", "  ", 
     RowBox[{"\[Lambda]", ">", "0"}], "&&", " ", 
     RowBox[{"\[Gamma]", ">", "0"}]}], " ", ",", 
    RowBox[{"{", 
     RowBox[{"\[Alpha]", ",", "\[Beta]"}], "}"}], ",", "Reals"}], 
   "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Lambda]", ">", "0"}], "&&", 
  RowBox[{"\[Gamma]", ">", "0"}], "&&", 
  RowBox[{"\[Alpha]", "\[Equal]", 
   RowBox[{"-", 
    FractionBox["\[Mu]", 
     RowBox[{
      RowBox[{"2", " ", "\[Lambda]"}], "+", 
      RowBox[{"2", " ", "\[Gamma]", " ", "\[Lambda]"}]}]]}]}], "&&", 
  RowBox[{"\[Beta]", "\[Equal]", 
   FractionBox["1", 
    RowBox[{
     RowBox[{"2", " ", "\[Lambda]"}], "+", 
     RowBox[{"2", " ", "\[Gamma]", " ", "\[Lambda]"}]}]]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623040394*^9, 3.3896231197136*^9, 
  3.3896232970164003`*^9, 3.3899917603556004`*^9, 3.3899918119326*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["x", "Solutions"], "=", 
  RowBox[{"Simplify", " ", "@", " ", 
   RowBox[{"ToRules", " ", "@", " ", 
    RowBox[{"Take", "[", 
     RowBox[{
      SubscriptBox["x", "Solutions"], ",", 
      RowBox[{"-", "2"}]}], "]"}]}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Alpha]", "\[Rule]", 
    RowBox[{"-", 
     FractionBox["\[Mu]", 
      RowBox[{
       RowBox[{"2", " ", "\[Lambda]"}], "+", 
       RowBox[{"2", " ", "\[Gamma]", " ", "\[Lambda]"}]}]]}]}], ",", 
   RowBox[{"\[Beta]", "\[Rule]", 
    FractionBox["1", 
     RowBox[{
      RowBox[{"2", " ", "\[Lambda]"}], "+", 
      RowBox[{"2", " ", "\[Gamma]", " ", "\[Lambda]"}]}]]}]}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230404300003`*^9, 3.3896231197476*^9, 
  3.3896232970494003`*^9, 3.3899917604136*^9, 3.3899918120056*^9}]
}, Open  ]],

Cell[TextData[{
 "As always, the MM must figure out ",
 Cell[BoxData[
  RowBox[{"E", "[", 
   RowBox[{"v", "|", "y"}], "]"}]]],
 ". Starting from the original joint distribution:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"uvDist", "=", 
  RowBox[{"MVN", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       SubscriptBox["p", "0"], "}"}], ",", 
      RowBox[{"{", "0", "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["\[CapitalSigma]", "0"], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"v", ",", "u"}], "}"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"v"},
        {"u"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["p", "0"]},
       {"0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["\[CapitalSigma]", "0"], "0"},
       {"0", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623040467*^9, 3.3896231197846003`*^9, 
  3.3896232970854*^9, 3.3899917604796*^9, 3.3899918120936003`*^9}]
}, Open  ]],

Cell[TextData[{
 "Now, though, we have a more complicated form for  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"y", ":", "y"}], "=", 
   RowBox[{"u", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Alpha]", "+", 
       RowBox[{"v", " ", "\[Beta]"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Gamma]"}], ")"}]}]}]}]]],
 ". The joint distribution of ",
 Cell[BoxData["v"]],
 " and ",
 Cell[BoxData["y"]],
 " is:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MakeLinearForm", "[", 
  RowBox[{"uvDist", ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{
      RowBox[{"y", "/.", 
       SubscriptBox["y", "Rule"]}], "/.", 
      SubscriptBox["x", "Rule"]}]}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"v"},
        {
         RowBox[{"u", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"\[Alpha]", "+", 
             RowBox[{"v", " ", "\[Beta]"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Gamma]"}], ")"}]}]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["p", "0"]},
        {
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"\[Alpha]", "+", 
             RowBox[{"v", " ", "\[Beta]"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Gamma]"}], ")"}]}], "-", 
          RowBox[{"v", " ", 
           RowBox[{"(", 
            RowBox[{"\[Beta]", "+", 
             RowBox[{"\[Beta]", " ", "\[Gamma]"}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"\[Beta]", "+", 
             RowBox[{"\[Beta]", " ", "\[Gamma]"}]}], ")"}], " ", 
           SubscriptBox["p", "0"]}]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["\[CapitalSigma]", "0"], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"\[Beta]", "+", 
           RowBox[{"\[Beta]", " ", "\[Gamma]"}]}], ")"}], " ", 
         SubscriptBox["\[CapitalSigma]", "0"]}]},
       {
        RowBox[{
         RowBox[{"(", 
          RowBox[{"\[Beta]", "+", 
           RowBox[{"\[Beta]", " ", "\[Gamma]"}]}], ")"}], " ", 
         SubscriptBox["\[CapitalSigma]", "0"]}], 
        RowBox[{
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"\[Beta]", "+", 
             RowBox[{"\[Beta]", " ", "\[Gamma]"}]}], ")"}], "2"], " ", 
          SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
         SubsuperscriptBox["\[Sigma]", "u", "2"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623040501*^9, 3.3896231198266*^9, 3.3896232971174*^9, 
  3.3899917605476*^9, 3.3899918121756*^9}]
}, Open  ]],

Cell["...relabeling:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vyDistribution", "=", 
  RowBox[{"SetLabel", "[", 
   RowBox[{"%", ",", 
    RowBox[{"{", 
     RowBox[{"v", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"v"},
        {"y"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["p", "0"]},
        {
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"\[Alpha]", "+", 
             RowBox[{"v", " ", "\[Beta]"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Gamma]"}], ")"}]}], "-", 
          RowBox[{"v", " ", 
           RowBox[{"(", 
            RowBox[{"\[Beta]", "+", 
             RowBox[{"\[Beta]", " ", "\[Gamma]"}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"\[Beta]", "+", 
             RowBox[{"\[Beta]", " ", "\[Gamma]"}]}], ")"}], " ", 
           SubscriptBox["p", "0"]}]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["\[CapitalSigma]", "0"], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"\[Beta]", "+", 
           RowBox[{"\[Beta]", " ", "\[Gamma]"}]}], ")"}], " ", 
         SubscriptBox["\[CapitalSigma]", "0"]}]},
       {
        RowBox[{
         RowBox[{"(", 
          RowBox[{"\[Beta]", "+", 
           RowBox[{"\[Beta]", " ", "\[Gamma]"}]}], ")"}], " ", 
         SubscriptBox["\[CapitalSigma]", "0"]}], 
        RowBox[{
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"\[Beta]", "+", 
             RowBox[{"\[Beta]", " ", "\[Gamma]"}]}], ")"}], "2"], " ", 
          SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
         SubsuperscriptBox["\[Sigma]", "u", "2"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623040541*^9, 3.3896231198656*^9, 
  3.3896232971493998`*^9, 3.3899917606126003`*^9, 3.3899918122616*^9}]
}, Open  ]],

Cell["The conditional distribution is:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vConditionalDist", "=", 
  RowBox[{
   RowBox[{"MVNConditional", "[", 
    RowBox[{"vyDistribution", ",", "v", ",", "y"}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"v", 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[Beta]"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "\[Gamma]"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "y"}], "+", "\[Alpha]", "+", 
        RowBox[{"\[Alpha]", " ", "\[Gamma]"}]}], ")"}], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
      SubscriptBox["p", "0"]}]}], 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Gamma]"}], ")"}], "2"], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     SubsuperscriptBox["\[Sigma]", "u", "2"]}]], ",", 
   FractionBox[
    RowBox[{
     SubscriptBox["\[CapitalSigma]", "0"], " ", 
     SubsuperscriptBox["\[Sigma]", "u", "2"]}], 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Gamma]"}], ")"}], "2"], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     SubsuperscriptBox["\[Sigma]", "u", "2"]}]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623040602*^9, 3.3896231199256*^9, 3.3896232972064*^9, 
  3.3899917607265997`*^9, 3.3899918123896*^9}]
}, Open  ]],

Cell["Market efficiency:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pEqu", "=", 
  RowBox[{
   RowBox[{"GetMean", "[", "vConditionalDist", "]"}], "\[Equal]", 
   RowBox[{"(", 
    RowBox[{"p", "/.", 
     SubscriptBox["p", "Rule"]}], ")"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{
     RowBox[{"-", "\[Beta]"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Gamma]"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "y"}], "+", "\[Alpha]", "+", 
       RowBox[{"\[Alpha]", " ", "\[Gamma]"}]}], ")"}], " ", 
     SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
    RowBox[{
     SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
     SubscriptBox["p", "0"]}]}], 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Beta]", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "\[Gamma]"}], ")"}], "2"], " ", 
     SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
    SubsuperscriptBox["\[Sigma]", "u", "2"]}]], "\[Equal]", 
  RowBox[{
   RowBox[{"y", " ", "\[Lambda]"}], "+", "\[Mu]"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623040634*^9, 3.3896231199625998`*^9, 
  3.3896232972344*^9, 3.3899917607886*^9, 3.3899918124556*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["p", "Solutions"], "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[ForAll]", "y"], "pEqu"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Mu]", ",", "\[Lambda]"}], "}"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Beta]", "2"], " ", 
     SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["\[Beta]", "2"], " ", "\[Gamma]", " ", 
     SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
    RowBox[{
     SuperscriptBox["\[Beta]", "2"], " ", 
     SuperscriptBox["\[Gamma]", "2"], " ", 
     SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
    SubsuperscriptBox["\[Sigma]", "u", "2"]}], "\[NotEqual]", "0"}], "&&", 
  RowBox[{"\[Mu]", "\[Equal]", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[Alpha]"}], " ", "\[Beta]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "-", 
     RowBox[{"2", " ", "\[Alpha]", " ", "\[Beta]", " ", "\[Gamma]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "-", 
     RowBox[{"\[Alpha]", " ", "\[Beta]", " ", 
      SuperscriptBox["\[Gamma]", "2"], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
      SubscriptBox["p", "0"]}]}], 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[Beta]", "2"], " ", "\[Gamma]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SuperscriptBox["\[Gamma]", "2"], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], "&&", 
  RowBox[{"\[Lambda]", "\[Equal]", 
   FractionBox[
    RowBox[{
     RowBox[{"\[Beta]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     RowBox[{"\[Beta]", " ", "\[Gamma]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}]}], 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[Beta]", "2"], " ", "\[Gamma]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SuperscriptBox["\[Gamma]", "2"], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623040718*^9, 3.3896231200436*^9, 3.3896232973124*^9, 
  3.3899917611205997`*^9, 3.3899918126216*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["p", "Solutions"], "=", 
  RowBox[{"Simplify", " ", "@", " ", 
   RowBox[{"ToRules", "[", 
    RowBox[{"Take", "[", 
     RowBox[{
      SubscriptBox["p", "Solutions"], ",", 
      RowBox[{"-", "2"}]}], "]"}], "]"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Mu]", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[Alpha]"}], " ", "\[Beta]", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Gamma]"}], ")"}], "2"], " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
       SubscriptBox["p", "0"]}]}], 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Gamma]"}], ")"}], "2"], " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], ",", 
   RowBox[{"\[Lambda]", "\[Rule]", 
    FractionBox[
     RowBox[{"\[Beta]", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "\[Gamma]"}], ")"}], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Gamma]"}], ")"}], "2"], " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230407650003`*^9, 3.3896231200926*^9, 
  3.3896232973543997`*^9, 3.3899917618046*^9, 3.3899918126745996`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EquationSet", "=", 
  RowBox[{"Apply", "[", 
   RowBox[{"Equal", ",", 
    RowBox[{"Join", "[", 
     RowBox[{
      SubscriptBox["p", "Solutions"], ",", 
      SubscriptBox["x", "Solutions"]}], "]"}], ",", "1"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Mu]", "\[Equal]", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[Alpha]"}], " ", "\[Beta]", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Gamma]"}], ")"}], "2"], " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
       SubscriptBox["p", "0"]}]}], 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Gamma]"}], ")"}], "2"], " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], ",", 
   RowBox[{"\[Lambda]", "\[Equal]", 
    FractionBox[
     RowBox[{"\[Beta]", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "\[Gamma]"}], ")"}], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Gamma]"}], ")"}], "2"], " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], ",", 
   RowBox[{"\[Alpha]", "\[Equal]", 
    RowBox[{"-", 
     FractionBox["\[Mu]", 
      RowBox[{
       RowBox[{"2", " ", "\[Lambda]"}], "+", 
       RowBox[{"2", " ", "\[Gamma]", " ", "\[Lambda]"}]}]]}]}], ",", 
   RowBox[{"\[Beta]", "\[Equal]", 
    FractionBox["1", 
     RowBox[{
      RowBox[{"2", " ", "\[Lambda]"}], "+", 
      RowBox[{"2", " ", "\[Gamma]", " ", "\[Lambda]"}]}]]}]}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623040797*^9, 3.3896231201266003`*^9, 
  3.3896232973844*^9, 3.3899917619386*^9, 3.3899918126976*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["Model", "Solutions"], "=", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{"EquationSet", ",", 
       RowBox[{"{", 
        RowBox[{"\[Mu]", ",", "\[Lambda]", ",", "\[Alpha]", ",", "\[Beta]"}], 
        "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[CapitalSigma]", "0"], ">", "0"}], ",", 
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "u", "2"], ">", "0"}]}], "}"}]}], "]"}],
    "//", "First"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Alpha]", "\[Rule]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SqrtBox[
        FractionBox[
         SubsuperscriptBox["\[Sigma]", "u", "2"], 
         SubscriptBox["\[CapitalSigma]", "0"]]], " ", 
       SubscriptBox["p", "0"]}], 
      RowBox[{"1", "+", "\[Gamma]"}]]}]}], ",", 
   RowBox[{"\[Mu]", "\[Rule]", 
    SubscriptBox["p", "0"]}], ",", 
   RowBox[{"\[Lambda]", "\[Rule]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SqrtBox[
      FractionBox[
       SubscriptBox["\[CapitalSigma]", "0"], 
       SubsuperscriptBox["\[Sigma]", "u", "2"]]]}]}], ",", 
   RowBox[{"\[Beta]", "\[Rule]", 
    FractionBox[
     SqrtBox[
      FractionBox[
       SubsuperscriptBox["\[Sigma]", "u", "2"], 
       SubscriptBox["\[CapitalSigma]", "0"]]], 
     RowBox[{"1", "+", "\[Gamma]"}]]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623040888*^9, 3.3896231202426*^9, 3.3896232974704*^9, 
  3.3899917620106*^9, 3.3899918128406*^9}]
}, Open  ]],

Cell["To recover the original solution ...", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["Model", "Solutions"], "/.", 
  RowBox[{"\[Gamma]", "\[Rule]", "0"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Alpha]", "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       FractionBox[
        SubsuperscriptBox["\[Sigma]", "u", "2"], 
        SubscriptBox["\[CapitalSigma]", "0"]]]}], " ", 
     SubscriptBox["p", "0"]}]}], ",", 
   RowBox[{"\[Mu]", "\[Rule]", 
    SubscriptBox["p", "0"]}], ",", 
   RowBox[{"\[Lambda]", "\[Rule]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SqrtBox[
      FractionBox[
       SubscriptBox["\[CapitalSigma]", "0"], 
       SubsuperscriptBox["\[Sigma]", "u", "2"]]]}]}], ",", 
   RowBox[{"\[Beta]", "\[Rule]", 
    SqrtBox[
     FractionBox[
      SubsuperscriptBox["\[Sigma]", "u", "2"], 
      SubscriptBox["\[CapitalSigma]", "0"]]]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623040918*^9, 3.3896231203106003`*^9, 
  3.3896232974983997`*^9, 3.3899917620716*^9, 3.3899918128626003`*^9}]
}, Open  ]],

Cell["The expected profits are", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"PowerExpand", "[", 
   RowBox[{
    RowBox[{"E\[Pi]", "/.", "\[InvisibleSpace]", 
     SubscriptBox["x", "Rule"]}], "/.", "\[InvisibleSpace]", 
    SubscriptBox["Model", "Solutions"]}], "]"}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    SubsuperscriptBox["\[Sigma]", "u", "2"]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"v", "-", 
      SubscriptBox["p", "0"]}], ")"}], "2"]}], 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "\[Gamma]"}], ")"}], " ", 
   SqrtBox[
    SubscriptBox["\[CapitalSigma]", "0"]]}]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230409560003`*^9, 3.3896231203496*^9, 
  3.3896232975344*^9, 3.3899917621466*^9, 3.3899918129426003`*^9}]
}, Open  ]],

Cell["The informed trader's demand is:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   SubscriptBox["x", "Rule"], "/.", "\[InvisibleSpace]", 
   SubscriptBox["Model", "Solutions"]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"x", "\[Rule]", 
  FractionBox[
   RowBox[{
    SqrtBox[
     FractionBox[
      SubsuperscriptBox["\[Sigma]", "u", "2"], 
      SubscriptBox["\[CapitalSigma]", "0"]]], " ", 
    RowBox[{"(", 
     RowBox[{"v", "-", 
      SubscriptBox["p", "0"]}], ")"}]}], 
   RowBox[{"1", "+", "\[Gamma]"}]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623041005*^9, 3.3896231203926*^9, 
  3.3896232975713997`*^9, 3.3899917622125998`*^9, 3.3899918129765997`*^9}]
}, Open  ]],

Cell[TextData[{
 "Since ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Gamma]", ">", "0"}], TraditionalForm]]],
 ", the informed trader's expected profits are lower. Also, she fades her \
demand to take into account the crooked broker. The informativeness of the \
price is:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GetVariance", "[", "vConditionalDist", "]"}], "/.", 
  SubscriptBox["Model", "Solutions"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 FractionBox[
  SubscriptBox["\[CapitalSigma]", "0"], "2"]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.38962304104*^9, 3.3896231204346*^9, 
  3.3896232976084003`*^9, 3.3899917622785997`*^9, 3.3899918130156*^9}]
}, Open  ]],

Cell["Unchanged, relative to the original model. ", "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8.1 (Source notebook: RollBasicAndGeneralized)", "Subsection",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3907329052436*^9, 3.3907329059906*^9}},
 CellTags->"Ch8Ex1"],

Cell["\<\
The model is observationally equivalent to one in which there is no lag on \
the efficient price. The autocovariances and moving average representation \
are the same.\
\>", "Text",
 CellLabelAutoDelete->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8.2 (Source notebook: RollBasicAndGeneralized)", "Subsection",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3907329075826*^9, 3.3907329082756*^9}},
 CellTags->"Ch8Ex2"],

Cell[TextData[{
 "By rearranging, the model can be written as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "\[Alpha]"}], ")"}], "L"}]}], ")"}], 
    SubscriptBox["p", "t"]}], "=", 
   SubscriptBox["\[Alpha]m", "t"]}]]],
 ". Taking first differences ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "\[Alpha]"}], ")"}], "L"}]}], ")"}], 
    SubscriptBox["\[CapitalDelta]p", "t"]}], "=", 
   RowBox[{
    SubscriptBox["\[Epsilon]", "t"], "=", 
    SubscriptBox["\[Alpha]w", "t"]}]}]]],
 " So:"
}], "Text",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3899908722316*^9, 3.3899908859726*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Phi]", "[", "L_", "]"}], ":=", 
  RowBox[{"1", "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", "\[Alpha]"}], ")"}], "L"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "The MA representation is ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "t"], "=", 
   RowBox[{"\[Theta]", 
    RowBox[{"(", "L", ")"}], 
    SubscriptBox["\[Epsilon]", "t"]}]}]]],
 " where ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"\[Theta]", 
    RowBox[{"(", "L", ")"}]}], "=", 
   RowBox[{"\[Phi]", 
    SuperscriptBox[
     RowBox[{"(", "L", ")"}], 
     RowBox[{"-", "1"}]]}]}]]],
 ". Furthermore ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"\[Theta]", 
    SuperscriptBox[
     RowBox[{"(", "1", ")"}], "2"]}], "="}]]]
}], "Text",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3899908899216003`*^9, 3.3899908912846003`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"\[Phi]", "[", "1", "]"}], 
  RowBox[{"-", "2"}]]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 FractionBox["1", 
  SuperscriptBox["\[Alpha]", "2"]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522856934*^9, 3.3895616705048*^9, 
  3.3899894728162003`*^9}]
}, Open  ]],

Cell[TextData[{
 "Since ",
 Cell[BoxData[
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "=", 
   RowBox[{
    SuperscriptBox["\[Alpha]", "2"], 
    SubsuperscriptBox["\[Sigma]", "w", "2"]}]}]]],
 ", ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"\[Theta]", 
    SuperscriptBox[
     RowBox[{"(", "1", ")"}], "2"], 
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "=", 
   SubsuperscriptBox["\[Sigma]", "w", "2"]}]]]
}], "Text",
 CellLabelAutoDelete->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8.3 (Source notebook: RollBasicAndGeneralized)", "Subsection",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3907329101396*^9, 3.3907329109986*^9}},
 CellTags->"Ch8Ex3"],

Cell["Over five-minute intervals", "Text",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Sigma]", "Rule"], "=", 
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "\[Rule]", 
    "0.00001"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Theta]", "[", "L_", "]"}], ":=", 
  RowBox[{"1", "-", 
   RowBox[{"0.3", " ", "L"}], " ", "+", " ", 
   RowBox[{"0.1", " ", 
    SuperscriptBox["L", "2"]}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell["Random-walk variance:", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 SqrtBox[
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"\[Theta]", "[", "1", "]"}], "2"], 
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "/.", 
   SubscriptBox["\[Sigma]", "Rule"]}]]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData["0.002529822128134704`"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522857444*^9, 3.3895616705638*^9, 3.3899894728892*^9}
  ]
}, Open  ]],

Cell["Over one day:", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 SqrtBox[
  RowBox[{
   RowBox[{"6", "*", "12", "*", 
    SuperscriptBox[
     RowBox[{"\[Theta]", "[", "1", "]"}], "2"], 
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "/.", 
   SubscriptBox["\[Sigma]", "Rule"]}]]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData["0.021466252583997984`"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522857824*^9, 3.3895616706057997`*^9, 
  3.3899894729392*^9}]
}, Open  ]],

Cell["i.e., about 2%", "Text",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "For the pricing error variance, the ",
 Cell[BoxData[
  SubscriptBox["C", "i"]]],
 " coefficients are generally:"
}], "Text",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["C", "Rule"], "=", 
   RowBox[{
    RowBox[{"C", "[", 
     RowBox[{"\[Theta]_", ",", "i_"}], "]"}], ":>", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"j", "=", 
       RowBox[{"i", "+", "1"}]}], 
      RowBox[{"Exponent", "[", 
       RowBox[{
        RowBox[{"\[Theta]", "[", "L", "]"}], ",", "L"}], "]"}]], 
     RowBox[{"-", 
      RowBox[{"Coefficient", "[", 
       RowBox[{
        RowBox[{"\[Theta]", "[", "L", "]"}], ",", "L", ",", "j"}], 
       "]"}]}]}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell["and here ...", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"C", "[", 
     RowBox[{"\[Theta]", ",", "i"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "2"}], "}"}]}], "]"}], "/.", 
  SubscriptBox["C", "Rule"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.19999999999999998`", ",", 
   RowBox[{"-", "0.1`"}], ",", "0"}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522858244*^9, 3.3895616706608*^9, 3.3899894731042*^9}
  ]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 SqrtBox[
  RowBox[{
   RowBox[{
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"i", "=", "0"}], 
      RowBox[{
       RowBox[{"Exponent", "[", 
        RowBox[{
         RowBox[{"\[Theta]", "[", "L", "]"}], ",", "L"}], "]"}], "-", "1"}]], 
     
     RowBox[{
      SuperscriptBox[
       RowBox[{"C", "[", 
        RowBox[{"\[Theta]", ",", "i"}], "]"}], "2"], 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}], "/.", 
    SubscriptBox["C", "Rule"]}], "/.", 
   SubscriptBox["\[Sigma]", "Rule"]}]]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData["0.0007071067811865475`"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522858564*^9, 3.3895616707068*^9, 3.3899894731642*^9}
  ]
}, Open  ]],

Cell["i.e., about seven basis points", "Text",
 CellLabelAutoDelete->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8.4 (Source notebook: RollBasicAndGeneralized)", "Subsection",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3907329129666*^9, 3.3907329143956003`*^9}}],

Cell[TextData[{
 "The structural model is:\n",
 Cell[BoxData[{
  RowBox[{
   SubscriptBox["m", "t"], "=", 
   RowBox[{
    SubscriptBox["m", 
     RowBox[{"t", "-", "1"}]], "+", 
    SubscriptBox["w", "t"]}]}], "\[IndentingNewLine]", 
  RowBox[{
   SubscriptBox["w", "t"], "=", 
   RowBox[{
    SubscriptBox["\[Lambda]q", "t"], "+", 
    SubscriptBox["u", "t"]}]}], "\[IndentingNewLine]", 
  RowBox[{
   SubscriptBox["p", "t"], "=", 
   RowBox[{
    SubscriptBox["m", 
     RowBox[{"t", "-", "1"}]], "+", 
    RowBox[{"c", " ", 
     SubscriptBox["q", "t"]}]}]}]}]],
 "\nNotice that the price is determined with respect to ",
 StyleBox["lagged",
  FontSlant->"Italic"],
 " value of the implicit efficient price."
}], "Text",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "(a) Using the structural representation, determine the ",
 Cell[BoxData[
  SubscriptBox["\[CapitalDelta]p", "t"]]],
 " autocovariances ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Gamma]", "0"], ",", " ", 
   SubscriptBox["\[Gamma]", "1"]}]]],
 " and verify that ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Gamma]", "2"], "=", "0"}]]],
 "."
}], "Text",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "In this and the following parts, assume that  ",
 Cell[BoxData[
  RowBox[{"c", "=", "2"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"\[Lambda]", "=", "1"}]]],
 ".\n(b) Verify that autocovariances are the same as the autocovariances for \
the (statistical) MA(1) model ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "t"], "=", 
   RowBox[{
    SubscriptBox["\[Epsilon]", "t"], "+", "\[Theta]"}]}]]],
 " where",
 "\n\t",
 Cell[BoxData[{
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "=", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubsuperscriptBox["\[Sigma]", "u", "2"], "+", "1"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SubsuperscriptBox["\[Sigma]", "u", "2"], "+", "9"}], ")"}]}]], "+",
        "5"}], ")"}]}]}], TraditionalForm], "\n", 
  FormBox["and", TraditionalForm], "\n", 
  FormBox[
   RowBox[{"\[Theta]", "=", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}], "+", 
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubsuperscriptBox["\[Sigma]", "u", "2"], "+", "1"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SubsuperscriptBox["\[Sigma]", "u", "2"], "+", "9"}], ")"}]}]], "-",
        "5"}], ")"}]}]}], TraditionalForm]}], "Text"]
}], "Text",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "(c) Verify that ",
 Cell[BoxData[
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "w", "2"], "=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Theta]"}], ")"}], "2"], 
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]]],
 ".\n(d) Compute (in terms of the MA parameters) the lower bound for  ",
 Cell[BoxData[
  SubsuperscriptBox["\[Sigma]", "s", "2"]]],
 " where ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["s", "t"], "=", 
   RowBox[{
    SubscriptBox["p", "t"], "-", 
    SubscriptBox["m", "t"]}]}]]],
 ". Verify that the lower bound is exact when ",
 Cell[BoxData[
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "u", "2"], "=", "0"}]]],
 "."
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell["Analysis", "Subsubsection",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"nValues", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c", "\[Rule]", "2"}], ",", 
     RowBox[{"\[Lambda]", "\[Rule]", "1"}]}], "}"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["m", "Rule"], "=", 
   RowBox[{
    SubscriptBox["m", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", 
      RowBox[{"t", "-", "1"}]], "+", 
     SubscriptBox["w", "t"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["w", "Rule"], "=", 
   RowBox[{
    SubscriptBox["w", "t_"], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"\[Lambda]", " ", 
      SubscriptBox["q", "t"]}], "+", 
     SubscriptBox["u", "t"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["p", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", 
      RowBox[{"t", "-", "1"}]], "+", 
     RowBox[{"c", " ", 
      SubscriptBox["q", "t"]}]}]}]}], ";"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "Pricing error ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["s", "t"], "="}]]]
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["p", "t"], "-", 
     SubscriptBox["m", "t"]}], "/.", 
    SubscriptBox["p", "Rule"]}], "/.", 
   RowBox[{
    SubscriptBox["m", "t"], "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["m", "t"], "/.", 
      SubscriptBox["m", "Rule"]}], ")"}]}]}], "/.", 
  SubscriptBox["w", "Rule"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"c", " ", 
   SubscriptBox["q", "t"]}], "-", 
  RowBox[{"\[Lambda]", " ", 
   SubscriptBox["q", "t"]}], "-", 
  SubscriptBox["u", "t"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522858993998`*^9, 3.3895616708028*^9, 
  3.3899894732422*^9, 3.3899909480685997`*^9}]
}, Open  ]],

Cell["This implies that the pricing error variance is", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "-", "\[Lambda]"}], ")"}], "2"], "+", 
   SubsuperscriptBox["\[Sigma]", "u", "2"]}], "/.", "nValues"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"1", "+", 
  SubsuperscriptBox["\[Sigma]", "u", "2"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522859334*^9, 3.3895616708408003`*^9, 
  3.3899894733062*^9, 3.3899909481275997`*^9}]
}, Open  ]],

Cell["Price changes:", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["\[CapitalDelta]p", "t_"], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         SubscriptBox["p", "t"], "/.", "\[InvisibleSpace]", 
         SubscriptBox["p", "Rule"]}], "/.", "\[InvisibleSpace]", 
        SubscriptBox["m", "Rule"]}], "/.", "\[InvisibleSpace]", 
       SubscriptBox["w", "Rule"]}], ")"}], "-", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["p", 
        RowBox[{"t", "-", "1"}]], "/.", "\[InvisibleSpace]", 
       SubscriptBox["p", "Rule"]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["\[CapitalDelta]p", "t"], "/.", 
  SubscriptBox["\[CapitalDelta]p", "Rule"]}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "c"}], " ", 
   SubscriptBox["q", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "t"}]]}], "+", 
  RowBox[{"\[Lambda]", " ", 
   SubscriptBox["q", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "t"}]]}], "+", 
  RowBox[{"c", " ", 
   SubscriptBox["q", "t"]}], "+", 
  SubscriptBox["u", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "t"}]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522859694*^9, 3.3895616708768*^9, 3.3899894733652*^9,
   3.3899909481896*^9}]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"Var", "[", 
    RowBox[{"\[CapitalDelta]", " ", 
     SubscriptBox["p", "t"]}], "]"}], "=", 
   SubscriptBox["\[Gamma]", "0"]}]]],
 ":"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ScriptCapitalE]", "[", 
   RowBox[{"Expand", "[", 
    RowBox[{
     SubsuperscriptBox["\[CapitalDelta]p", "t", "2"], "/.", 
     "\[InvisibleSpace]", 
     SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}], "]"}], "//.", 
  SubscriptBox["\[ScriptCapitalE]", "Rules"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SuperscriptBox["c", "2"]}], "-", 
  RowBox[{"2", " ", "c", " ", "\[Lambda]"}], "+", 
  SuperscriptBox["\[Lambda]", "2"], "+", 
  SubsuperscriptBox["\[Sigma]", "u", "2"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522860134*^9, 3.3895616709138002`*^9, 
  3.3899894734302*^9, 3.3899909482455997`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SuperscriptBox["c", "2"]}], "-", 
  RowBox[{"2", " ", "\[Lambda]", " ", "c"}], "+", 
  SuperscriptBox["\[Lambda]", "2"], "+", 
  SubsuperscriptBox["\[Sigma]", "u", "2"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SuperscriptBox["c", "2"]}], "-", 
  RowBox[{"2", " ", "c", " ", "\[Lambda]"}], "+", 
  SuperscriptBox["\[Lambda]", "2"], "+", 
  SubsuperscriptBox["\[Sigma]", "u", "2"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522860514*^9, 3.3895616709518003`*^9, 
  3.3899894734872*^9, 3.3899909483086*^9}]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"Cov", "[", 
    RowBox[{
     SubscriptBox["\[CapitalDelta]p", "t"], ",", 
     SubscriptBox["\[CapitalDelta]p", 
      RowBox[{"t", "-", "1"}]]}], "]"}], "=", 
   SubscriptBox["\[Gamma]", "1"]}]]],
 ":"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ScriptCapitalE]", "[", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[CapitalDelta]p", "t"], " ", 
      SubscriptBox["\[CapitalDelta]p", 
       RowBox[{"t", "-", "1"}]]}], "/.", "\[InvisibleSpace]", 
     SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}], "]"}], "//.", 
  SubscriptBox["\[ScriptCapitalE]", "Rules"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SuperscriptBox["c", "2"]}], "+", 
  RowBox[{"c", " ", "\[Lambda]"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522860964003`*^9, 3.3895616709938*^9, 
  3.3899894735472*^9, 3.3899909483666*^9}]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"Cov", "[", 
    RowBox[{
     SubscriptBox["\[CapitalDelta]p", "t"], ",", 
     SubscriptBox["\[CapitalDelta]p", 
      RowBox[{"t", "-", "2"}]]}], "]"}], "=", 
   SubscriptBox["\[Gamma]", "2"]}]]],
 ":"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ScriptCapitalE]", "[", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[CapitalDelta]p", "t"], " ", 
      SubscriptBox["\[CapitalDelta]p", 
       RowBox[{"t", "-", "2"}]]}], "/.", "\[InvisibleSpace]", 
     SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}], "]"}], "//.", 
  SubscriptBox["\[ScriptCapitalE]", "Rules"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData["0"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522861294003`*^9, 3.3895616710438004`*^9, 
  3.3899894736152*^9, 3.3899909484245996`*^9}]
}, Open  ]],

Cell["\<\
Summarize the first two autocovariances in terms of the structural \
parameters:\
\>", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Gamma]Structural", "Rules"], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Gamma]", "0"], "\[Rule]", 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["c", "2"]}], "-", 
       RowBox[{"2", " ", "\[Lambda]", " ", "c"}], "+", 
       SuperscriptBox["\[Lambda]", "2"], "+", 
       SubsuperscriptBox["\[Sigma]", "u", "2"]}]}], ",", 
     RowBox[{
      SubscriptBox["\[Gamma]", "1"], "\[Rule]", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["c", "2"]}], "+", 
       RowBox[{"c", " ", "\[Lambda]"}]}]}]}], "}"}]}], ";", " ", 
  RowBox[{
   SubscriptBox["\[Gamma]Structural", "Rules"], "//", 
   "TableForm"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{
       SubscriptBox["\[Gamma]", "0"], "\[Rule]", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", "c", " ", "\[Lambda]"}], "+", 
        SuperscriptBox["\[Lambda]", "2"], "+", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}]}]},
     {
      RowBox[{
       SubscriptBox["\[Gamma]", "1"], "\[Rule]", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"c", " ", "\[Lambda]"}]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522861644*^9, 3.3895616710958*^9, 3.3899894736792*^9,
   3.3899909484835997`*^9}]
}, Open  ]],

Cell[TextData[{
 " Now evaluate ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Var", "[", 
    SubscriptBox["w", "t"], "]"}], "=", 
   SubsuperscriptBox["\[Sigma]", "w", "2"]}]]],
 ":"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ScriptCapitalE]", "[", 
   RowBox[{"Expand", "[", 
    RowBox[{
     SubsuperscriptBox["w", "t", "2"], "/.", "\[InvisibleSpace]", 
     SubscriptBox["w", "Rule"]}], "]"}], "]"}], "//.", 
  SubscriptBox["\[ScriptCapitalE]", "Rules"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[Lambda]", "2"], "+", 
  SubsuperscriptBox["\[Sigma]", "u", "2"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522861994*^9, 3.3895616711608*^9, 3.3899894737382*^9,
   3.3899909485416*^9}]
}, Open  ]],

Cell[TextData[{
 "The autocovariances computed from the statistical and structural \
representations must agree. The autocovariances for the MA(1) process ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "t"], "=", 
   RowBox[{
    SubscriptBox["\[Epsilon]", "t"], "+", 
    SubscriptBox["\[Theta]\[Epsilon]", 
     RowBox[{"t", "-", "1"}]]}]}]]],
 " are:"
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Gamma]Statistical", "Rules"], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Gamma]", "0"], "\[Rule]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["\[Theta]", "2"], "+", "1"}], ")"}], " ", 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}], ",", 
     RowBox[{
      SubscriptBox["\[Gamma]", "1"], "\[Rule]", 
      RowBox[{"\[Theta]", " ", 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]}], "}"}]}], ";", 
  " ", 
  RowBox[{
   SubscriptBox["\[Gamma]Statistical", "Rules"], "//", 
   "TableForm"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{
       SubscriptBox["\[Gamma]", "0"], "\[Rule]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["\[Theta]", "2"]}], ")"}], " ", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]},
     {
      RowBox[{
       SubscriptBox["\[Gamma]", "1"], "\[Rule]", 
       RowBox[{"\[Theta]", " ", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522862344*^9, 3.3895616711998*^9, 3.3899894738002*^9,
   3.3899909486136*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StatStructEqu", "=", 
   RowBox[{"Apply", "[", 
    RowBox[{"Equal", ",", 
     RowBox[{"Join", "[", 
      RowBox[{
       SubscriptBox["\[Gamma]Statistical", "Rules"], ",", 
       SubscriptBox["\[Gamma]Structural", "Rules"]}], "]"}], ",", 
     RowBox[{"{", "1", "}"}]}], "]"}]}], ";", " ", 
  RowBox[{"StatStructEqu", "//", "TableForm"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{
       SubscriptBox["\[Gamma]", "0"], "\[Equal]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["\[Theta]", "2"]}], ")"}], " ", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]},
     {
      RowBox[{
       SubscriptBox["\[Gamma]", "1"], "\[Equal]", 
       RowBox[{"\[Theta]", " ", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]},
     {
      RowBox[{
       SubscriptBox["\[Gamma]", "0"], "\[Equal]", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", "c", " ", "\[Lambda]"}], "+", 
        SuperscriptBox["\[Lambda]", "2"], "+", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}]}]},
     {
      RowBox[{
       SubscriptBox["\[Gamma]", "1"], "\[Equal]", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"c", " ", "\[Lambda]"}]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522862724*^9, 3.3895616712388*^9, 3.3899894738642*^9,
   3.3899909486766*^9}]
}, Open  ]],

Cell["which implies:", "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{"StatStructEqu", ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Gamma]", "0"], ",", 
       SubscriptBox["\[Gamma]", "1"]}], "}"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", "c", " ", "\[Lambda]"}], "+", 
         SuperscriptBox["\[Lambda]", "2"], "+", 
         SubsuperscriptBox["\[Sigma]", "u", "2"], "-", 
         RowBox[{
          SqrtBox[
           RowBox[{
            SuperscriptBox["\[Lambda]", "2"], "+", 
            SubsuperscriptBox["\[Sigma]", "u", "2"]}]], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"4", " ", "c", " ", "\[Lambda]"}], "+", 
            SuperscriptBox["\[Lambda]", "2"], "+", 
            SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}], ")"}]}]}], ",", 
     RowBox[{"\[Theta]", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", "c", " ", "\[Lambda]"}], "+", 
         SuperscriptBox["\[Lambda]", "2"], "+", 
         SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
         RowBox[{
          SqrtBox[
           RowBox[{
            SuperscriptBox["\[Lambda]", "2"], "+", 
            SubsuperscriptBox["\[Sigma]", "u", "2"]}]], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"4", " ", "c", " ", "\[Lambda]"}], "+", 
            SuperscriptBox["\[Lambda]", "2"], "+", 
            SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}], 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", "c", " ", "\[Lambda]"}]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", "c", " ", "\[Lambda]"}], "+", 
         SuperscriptBox["\[Lambda]", "2"], "+", 
         SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
         RowBox[{
          SqrtBox[
           RowBox[{
            SuperscriptBox["\[Lambda]", "2"], "+", 
            SubsuperscriptBox["\[Sigma]", "u", "2"]}]], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"4", " ", "c", " ", "\[Lambda]"}], "+", 
            SuperscriptBox["\[Lambda]", "2"], "+", 
            SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}], ")"}]}]}], ",", 
     RowBox[{"\[Theta]", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", "c", " ", "\[Lambda]"}], "+", 
         SuperscriptBox["\[Lambda]", "2"], "+", 
         SubsuperscriptBox["\[Sigma]", "u", "2"], "-", 
         RowBox[{
          SqrtBox[
           RowBox[{
            SuperscriptBox["\[Lambda]", "2"], "+", 
            SubsuperscriptBox["\[Sigma]", "u", "2"]}]], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"4", " ", "c", " ", "\[Lambda]"}], "+", 
            SuperscriptBox["\[Lambda]", "2"], "+", 
            SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}], 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", "c", " ", "\[Lambda]"}]}]]}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522863454*^9, 3.3895616713578*^9, 3.3899894741092*^9,
   3.3899909489326*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InvertibleSolution", "=", 
  RowBox[{"sol", "[", 
   RowBox[{"[", "2", "]"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "\[Rule]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["c", "2"]}], "-", 
       RowBox[{"2", " ", "c", " ", "\[Lambda]"}], "+", 
       SuperscriptBox["\[Lambda]", "2"], "+", 
       SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
       RowBox[{
        SqrtBox[
         RowBox[{
          SuperscriptBox["\[Lambda]", "2"], "+", 
          SubsuperscriptBox["\[Sigma]", "u", "2"]}]], " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox["c", "2"]}], "-", 
          RowBox[{"4", " ", "c", " ", "\[Lambda]"}], "+", 
          SuperscriptBox["\[Lambda]", "2"], "+", 
          SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}], ")"}]}]}], ",", 
   RowBox[{"\[Theta]", "\[Rule]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["c", "2"]}], "-", 
       RowBox[{"2", " ", "c", " ", "\[Lambda]"}], "+", 
       SuperscriptBox["\[Lambda]", "2"], "+", 
       SubsuperscriptBox["\[Sigma]", "u", "2"], "-", 
       RowBox[{
        SqrtBox[
         RowBox[{
          SuperscriptBox["\[Lambda]", "2"], "+", 
          SubsuperscriptBox["\[Sigma]", "u", "2"]}]], " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox["c", "2"]}], "-", 
          RowBox[{"4", " ", "c", " ", "\[Lambda]"}], "+", 
          SuperscriptBox["\[Lambda]", "2"], "+", 
          SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}], 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["c", "2"]}], "-", 
       RowBox[{"2", " ", "c", " ", "\[Lambda]"}]}]]}]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522863784*^9, 3.3895616713738003`*^9, 
  3.3899894741692*^9, 3.3899909489926*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"InvertibleSolution", "/.", "nValues"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Lambda]", ">", "0"}], ",", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], ">", "0"}], ",", 
     RowBox[{"c", ">", "0"}]}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "\[Rule]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"5", "+", 
       SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SubsuperscriptBox["\[Sigma]", "u", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"9", "+", 
           SubsuperscriptBox["\[Sigma]", "u", "2"]}], ")"}]}]]}], ")"}]}]}], 
   ",", 
   RowBox[{"\[Theta]", "\[Rule]", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "5"}], "-", 
       SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SubsuperscriptBox["\[Sigma]", "u", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"9", "+", 
           SubsuperscriptBox["\[Sigma]", "u", "2"]}], ")"}]}]]}], ")"}]}]}]}],
   "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522864133997`*^9, 3.3895616715458*^9, 
  3.3899894745332003`*^9, 3.3899909493686*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", " ", "[", " ", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Theta]"}], ")"}], "2"], 
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "/.", 
   "InvertibleSolution"}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[Lambda]", "2"], "+", 
  SubsuperscriptBox["\[Sigma]", "u", "2"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522864533997`*^9, 3.3895616715938*^9, 
  3.3899894746261997`*^9, 3.3899909494676*^9}]
}, Open  ]],

Cell[TextData[{
 "i.e., the coefficient of ",
 Cell[BoxData[
  SubscriptBox["\[Epsilon]", "t"]]],
 " is the same in both representations."
}], "Text",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Theta]", "2"], 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "/.", 
     "InvertibleSolution"}], "/.", "nValues"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Lambda]", ">", "0"}], ",", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], ">", "0"}], ",", 
     RowBox[{"c", ">", "0"}]}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"5", "+", 
    SubsuperscriptBox["\[Sigma]", "u", "2"], "-", 
    SqrtBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"9", "+", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}], ")"}]}]]}], 
   ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522864934*^9, 3.3895616716208*^9, 3.3899894747202*^9,
   3.3899909495566*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Theta]", "2"], 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "/.", 
      "InvertibleSolution"}], "/.", "nValues"}], "/.", 
    RowBox[{
     SubsuperscriptBox["\[Sigma]", "u", "2"], "\[Rule]", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Lambda]", ">", "0"}], ",", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], ">", "0"}], ",", 
     RowBox[{"c", ">", "0"}]}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData["1"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522865274*^9, 3.3895616716328*^9, 3.3899894747802*^9,
   3.3899909496166*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Theta]", "2"], 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "/.", 
      "InvertibleSolution"}], ")"}], "==", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "-", "\[Lambda]"}], ")"}], "2"], "+", 
     SubsuperscriptBox["\[Sigma]", "u", "2"]}]}], ",", 
   SubsuperscriptBox["\[Sigma]", "u", "2"]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "u", "2"], "\[Rule]", "0"}], "}"}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522866084003`*^9, 3.3895616717348003`*^9, 
  3.3899894750192003`*^9, 3.3899909498416*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"InvertibleSolution", "/.", "nValues"}], "/.", 
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "u", "2"], "\[Rule]", "0"}]}], "//", 
  "Simplify"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "\[Rule]", "4"}], ",", 
   RowBox[{"\[Theta]", "\[Rule]", 
    RowBox[{"-", 
     FractionBox["1", "2"]}]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3895522866384*^9, 3.3895616717448*^9, 3.3899894750832*^9,
   3.3899909498996*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Exercise 9.1 (Glosten and Harris, Source notebook: \
MultivariateMicrostructureModels)\
\>", "Subsection",
 CellChangeTimes->{{3.3907329235366*^9, 3.3907329356646*^9}},
 CellTags->"ExGlostenHarris"],

Cell["Definitions:", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["m", "Rule"], "=", 
   RowBox[{
    SubscriptBox["m", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", 
      RowBox[{"t", "-", "1"}]], "+", 
     SubscriptBox["w", "t"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["w", "Rule"], "=", 
   RowBox[{
    SubscriptBox["w", "t_"], "\[RuleDelayed]", " ", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Lambda]", "0"], " ", 
      SubscriptBox["q", "t"]}], "+", 
     RowBox[{
      SubscriptBox["\[Lambda]", "1"], " ", 
      SubscriptBox["Q", "t"]}], "+", 
     SubscriptBox["u", "t"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["p", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", "t"], "+", 
     RowBox[{
      SubscriptBox["c", "1"], " ", 
      SubscriptBox["q", "t"]}], "+", 
     RowBox[{
      SubscriptBox["c", "2"], " ", 
      SubscriptBox["Q", "t"]}]}]}]}], ";"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "With these definitions, ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["m", "t"], ",", " ", 
   SubscriptBox["w", "t"]}]]],
 " and ",
 Cell[BoxData[
  SubscriptBox["p", "t"]]],
 " are (respectively):"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"{", " ", 
   RowBox[{
    RowBox[{
     SubscriptBox["m", "t"], "/.", 
     SubscriptBox["m", "Rule"]}], ",", 
    RowBox[{
     SubscriptBox["w", "t"], "/.", 
     SubscriptBox["w", "Rule"]}], ",", 
    RowBox[{
     SubscriptBox["p", "t"], "/.", 
     SubscriptBox["p", "Rule"]}]}], "}"}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{
       SubscriptBox["m", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "t"}]], "+", 
       SubscriptBox["w", "t"]}]},
     {
      RowBox[{
       SubscriptBox["u", "t"], "+", 
       RowBox[{
        SubscriptBox["q", "t"], " ", 
        SubscriptBox["\[Lambda]", "0"]}], "+", 
       RowBox[{
        SubscriptBox["Q", "t"], " ", 
        SubscriptBox["\[Lambda]", "1"]}]}]},
     {
      RowBox[{
       SubscriptBox["m", "t"], "+", 
       RowBox[{
        SubscriptBox["c", "1"], " ", 
        SubscriptBox["q", "t"]}], "+", 
       RowBox[{
        SubscriptBox["c", "2"], " ", 
        SubscriptBox["Q", "t"]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259196912003`*^9, 3.389717125565824*^9, 
  3.3897171564058237`*^9, 3.389717222104824*^9}]
}, Open  ]],

Cell[TextData[{
 "The price change at time ",
 Cell[BoxData["t"]],
 " is ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "t"], "="}]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["\[CapitalDelta]p", "t_"], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         SubscriptBox["p", "t"], "/.", "\[InvisibleSpace]", 
         SubscriptBox["p", "Rule"]}], "/.", "\[InvisibleSpace]", 
        SubscriptBox["m", "Rule"]}], "/.", "\[InvisibleSpace]", 
       SubscriptBox["w", "Rule"]}], ")"}], "-", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["p", 
        RowBox[{"t", "-", "1"}]], "/.", "\[InvisibleSpace]", 
       SubscriptBox["p", "Rule"]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "t"], "/.", "\[InvisibleSpace]", 
   SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["c", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["q", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "t"}]]}], "+", 
     SubscriptBox["q", "t"]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["c", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["Q", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "t"}]]}], "+", 
     SubscriptBox["Q", "t"]}], ")"}]}], "+", 
  SubscriptBox["u", "t"], "+", 
  RowBox[{
   SubscriptBox["q", "t"], " ", 
   SubscriptBox["\[Lambda]", "0"]}], "+", 
  RowBox[{
   SubscriptBox["Q", "t"], " ", 
   SubscriptBox["\[Lambda]", "1"]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259197352*^9, 3.389717125604824*^9, 
  3.389717156442824*^9, 3.389717222145824*^9}]
}, Open  ]],

Cell["The vector of variables is:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["y", "Rule"], "=", 
   RowBox[{
    SubscriptBox["y", "t_"], "\[RuleDelayed]", 
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["\[CapitalDelta]p", "t"], ",", 
        SubscriptBox["q", "t"], ",", 
        SubscriptBox["Q", "t"]}], "}"}], "}"}], "]"}]}]}], ";", 
  RowBox[{"MatrixForm", "[", 
   RowBox[{
    SubscriptBox["y", "t"], "/.", 
    SubscriptBox["y", "Rule"]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SubscriptBox["\[CapitalDelta]p", "t"]},
     {
      SubscriptBox["q", "t"]},
     {
      SubscriptBox["Q", "t"]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259197782*^9, 3.389717125639824*^9, 
  3.389717156476824*^9, 3.3897172221878242`*^9}]
}, Open  ]],

Cell[TextData[{
 "and the disturbances are ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Epsilon]", "t"], "="}]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Epsilon]", "Rule"], "=", 
   RowBox[{
    SubscriptBox["\[Epsilon]", "t_"], "\[RuleDelayed]", 
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["u", "t"], ",", 
        SubscriptBox["q", "t"], ",", 
        SubscriptBox["Q", "t"]}], "}"}], "}"}], "]"}]}]}], ";", 
  RowBox[{"MatrixForm", "[", 
   RowBox[{
    SubscriptBox["\[Epsilon]", "t"], "/.", 
    SubscriptBox["\[Epsilon]", "Rule"]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SubscriptBox["u", "t"]},
     {
      SubscriptBox["q", "t"]},
     {
      SubscriptBox["Q", "t"]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259198132*^9, 3.3897171256958237`*^9, 
  3.389717156520824*^9, 3.389717222231824*^9}]
}, Open  ]],

Cell["With substitutions, the vector of system variables is:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["y", "t"], "/.", 
      SubscriptBox["y", "Rule"]}], "/.", 
     SubscriptBox["\[CapitalDelta]p", "Rule"]}], ")"}], "//", "MatrixForm"}], 
  "//", "Simplify"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{
        SubscriptBox["c", "1"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["q", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "t"}]]}], "+", 
          SubscriptBox["q", "t"]}], ")"}]}], "+", 
       RowBox[{
        SubscriptBox["c", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["Q", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "t"}]]}], "+", 
          SubscriptBox["Q", "t"]}], ")"}]}], "+", 
       SubscriptBox["u", "t"], "+", 
       RowBox[{
        SubscriptBox["q", "t"], " ", 
        SubscriptBox["\[Lambda]", "0"]}], "+", 
       RowBox[{
        SubscriptBox["Q", "t"], " ", 
        SubscriptBox["\[Lambda]", "1"]}]}]},
     {
      SubscriptBox["q", "t"]},
     {
      SubscriptBox["Q", "t"]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259198522*^9, 3.3897171257408237`*^9, 
  3.389717156567824*^9, 3.3897172222738237`*^9}]
}, Open  ]],

Cell[TextData[{
 "The MA model is ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["y", "t"], "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Theta]", "0"], 
     SubscriptBox["\[Epsilon]", "t"]}], "+", 
    RowBox[{
     SubscriptBox["\[Theta]", "1"], 
     SubscriptBox["\[Epsilon]", 
      RowBox[{"t", "-", "1"}]]}]}]}]]],
 " where the coefficient matrices are:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\[Theta]", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["\[Theta]", "Rules"], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Rule", "[", 
      RowBox[{
       SubscriptBox["\[Theta]", "s"], ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Coefficient", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SubscriptBox["y", "t"], "/.", 
               SubscriptBox["y", "Rule"]}], "/.", 
              SubscriptBox["\[CapitalDelta]p", "Rule"]}], ")"}], "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["\[Epsilon]", 
               RowBox[{"t", "-", "s"}]], "/.", 
              SubscriptBox["\[Epsilon]", "Rule"]}], ")"}], "[", 
            RowBox[{"[", 
             RowBox[{"j", ",", "1"}], "]"}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "3"}], "}"}]}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"{", 
  RowBox[{"Map", "[", 
   RowBox[{"MatrixForm", ",", 
    SubscriptBox["\[Theta]", "Rules"], ",", 
    RowBox[{"{", "2", "}"}]}], "]"}], "}"}]}], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389717133358824*^9, 3.389717135035824*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     TagBox[
      SubscriptBox["\[Theta]", "0"],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]], "\[Rule]", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"1", 
          RowBox[{
           SubscriptBox["c", "1"], "+", 
           SubscriptBox["\[Lambda]", "0"]}], 
          RowBox[{
           SubscriptBox["c", "2"], "+", 
           SubscriptBox["\[Lambda]", "1"]}]},
         {"0", "1", "0"},
         {"0", "0", "1"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}], ",", 
    RowBox[{
     TagBox[
      SubscriptBox["\[Theta]", "1"],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]], "\[Rule]", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0", 
          RowBox[{"-", 
           SubscriptBox["c", "1"]}], 
          RowBox[{"-", 
           SubscriptBox["c", "2"]}]},
         {"0", "0", "0"},
         {"0", "0", "0"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}]}], "}"}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896259199012003`*^9, {3.3897171257878237`*^9, 3.389717156617824*^9}, 
   3.389717222326824*^9}]
}, Open  ]],

Cell[TextData[{
 "To build the covariance matrix, we need to work out ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Cov", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["q", "t"], ",", 
      SubscriptBox["Q", "t"]}], ")"}]}], "=", 
   RowBox[{
    RowBox[{"E", "[", 
     RowBox[{
      SubscriptBox["Q", "t"], "Sign", 
      RowBox[{"(", 
       SubscriptBox["Q", "t"], ")"}]}], "]"}], "=", 
    RowBox[{"E", "|", 
     SubscriptBox["Q", "t"], "|"}]}]}]]]
}], "Text"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\[CapitalOmega]", "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  SubscriptBox["Q", "t"]]],
 " ~ ",
 Cell[BoxData[
  RowBox[{"N", 
   RowBox[{"(", 
    RowBox[{"0", ",", 
     SubsuperscriptBox["\[Sigma]", "Q", "2"]}], ")"}], Cell[""]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"E", "[", 
    RowBox[{"|", "Q", "|"}], "]"}], "="}]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
    RowBox[{
     RowBox[{"Abs", "[", "x", "]"}], " ", 
     RowBox[{"PDF", "[", 
      RowBox[{
       RowBox[{"NormalDistribution", "[", 
        RowBox[{"0", ",", 
         SubscriptBox["\[Sigma]", "Q"]}], "]"}], ",", "x"}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Sigma]", "Q"], "\[Element]", "Reals"}], ",", 
     RowBox[{
      RowBox[{"Re", "[", 
       SuperscriptBox[
        RowBox[{"(", 
         SubscriptBox["\[Sigma]", "Q"], ")"}], "2"], "]"}], ">", "0"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   FractionBox["2", "\[Pi]"]], " ", 
  SubscriptBox["\[Sigma]", "Q"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896259214952*^9, {3.389717127160824*^9, 3.389717157068824*^9}, 
   3.389717222795824*^9}]
}, Open  ]],

Cell["So the disturbance covariance matrix is:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalOmega]", "Rule"], "=", 
   RowBox[{"\[CapitalOmega]", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubsuperscriptBox["\[Sigma]", "u", "2"], ",", "0", ",", "0"}], 
         "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1", ",", 
          SubscriptBox["\[Sigma]", 
           RowBox[{"q", ",", "Q"}]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          SubscriptBox["\[Sigma]", 
           RowBox[{"q", ",", "Q"}]], ",", 
          SubsuperscriptBox["\[Sigma]", "Q", "2"]}], "}"}]}], "}"}], "/.", 
      RowBox[{
       SubscriptBox["\[Sigma]", 
        RowBox[{"q", ",", "Q"}]], "\[Rule]", 
       SqrtBox[
        RowBox[{"2", 
         RowBox[{
          SubsuperscriptBox["\[Sigma]", "Q", "2"], "/", "\[Pi]"}]}]]}]}], 
     ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Map", "[", 
  RowBox[{"MatrixForm", ",", 
   SubscriptBox["\[CapitalOmega]", "Rule"], ",", "1"}], "]"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  TagBox["\[CapitalOmega]",
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], "\[Rule]", 
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       SubsuperscriptBox["\[Sigma]", "u", "2"], "0", "0"},
      {"0", "1", 
       RowBox[{
        SqrtBox[
         FractionBox["2", "\[Pi]"]], " ", 
        SqrtBox[
         SubsuperscriptBox["\[Sigma]", "Q", "2"]]}]},
      {"0", 
       RowBox[{
        SqrtBox[
         FractionBox["2", "\[Pi]"]], " ", 
        SqrtBox[
         SubsuperscriptBox["\[Sigma]", "Q", "2"]]}], 
       SubsuperscriptBox["\[Sigma]", "Q", "2"]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896259215572*^9, {3.389717127224824*^9, 3.389717157112824*^9}, 
   3.389717222834824*^9}]
}, Open  ]],

Cell[TextData[{
 "The random-walk variance is ",
 Cell[BoxData[
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "w", "2"], "="}]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[Theta]", "0"], "+", 
         SubscriptBox["\[Theta]", "1"]}], ")"}], ".", "\[CapitalOmega]", ".", 
       
       RowBox[{"Transpose", "[", 
        RowBox[{
         SubscriptBox["\[Theta]", "0"], "+", 
         SubscriptBox["\[Theta]", "1"]}], "]"}]}], "/.", 
      SubscriptBox["\[Theta]", "Rules"]}], "/.", 
     SubscriptBox["\[CapitalOmega]", "Rule"]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[Sigma]", "Q"], ">", "0"}], ",", 
      RowBox[{
       SubscriptBox["\[Sigma]", "_"], "\[Element]", "Reals"}]}], "}"}]}], 
   "]"}], "[", 
  RowBox[{"[", 
   RowBox[{"1", ",", "1"}], "]"}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
  SubsuperscriptBox["\[Lambda]", "0", "2"], "+", 
  RowBox[{"2", " ", 
   SqrtBox[
    FractionBox["2", "\[Pi]"]], " ", 
   SqrtBox[
    SubsuperscriptBox["\[Sigma]", "Q", "2"]], " ", 
   SubscriptBox["\[Lambda]", "0"], " ", 
   SubscriptBox["\[Lambda]", "1"]}], "+", 
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "Q", "2"], " ", 
   SubsuperscriptBox["\[Lambda]", "1", "2"]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896259216322002`*^9, {3.3897171272918243`*^9, 3.389717157151824*^9}, 
   3.389717222878824*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Decomposition with ",
 Cell[BoxData[
  SubscriptBox["q", "t"]]],
 " first:"
}], "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"F1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Permute", "[", 
      RowBox[{
       RowBox[{"CholeskyDecomposition", "[", 
        RowBox[{"Permute", "[", 
         RowBox[{
          RowBox[{"\[CapitalOmega]", "/.", 
           SubscriptBox["\[CapitalOmega]", "Rule"]}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "3", ",", "1"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "1", ",", "2"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "Q", "2"], ">", "0"}], ",", 
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "u", "2"], ">", "0"}]}], "}"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"F1", "//", "MatrixForm"}]}], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3897172031878242`*^9, 3.389717216267824*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SqrtBox[
       SubsuperscriptBox["\[Sigma]", "u", "2"]], "0", "0"},
     {"0", "1", 
      RowBox[{
       SqrtBox[
        FractionBox["2", "\[Pi]"]], " ", 
       SqrtBox[
        SubsuperscriptBox["\[Sigma]", "Q", "2"]]}]},
     {"0", "0", 
      RowBox[{
       SqrtBox[
        FractionBox[
         RowBox[{
          RowBox[{"-", "2"}], "+", "\[Pi]"}], "\[Pi]"]], " ", 
       SqrtBox[
        SubsuperscriptBox["\[Sigma]", "Q", "2"]]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896259217052*^9, {3.389717127342824*^9, 3.389717157193824*^9}, 
   3.389717222934824*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VarDecomp1", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[Theta]", "0"], "+", 
         SubscriptBox["\[Theta]", "1"]}], ")"}], ".", 
       RowBox[{"Transpose", "[", "F1", "]"}]}], "/.", 
      SubscriptBox["\[Theta]", "Rules"]}], "//", "Simplify"}], ")"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SqrtBox[
    SubsuperscriptBox["\[Sigma]", "u", "2"]], ",", 
   RowBox[{
    SubscriptBox["\[Lambda]", "0"], "+", 
    RowBox[{
     SqrtBox[
      FractionBox["2", "\[Pi]"]], " ", 
     SqrtBox[
      SubsuperscriptBox["\[Sigma]", "Q", "2"]], " ", 
     SubscriptBox["\[Lambda]", "1"]}]}], ",", 
   RowBox[{
    SqrtBox[
     FractionBox[
      RowBox[{
       RowBox[{"-", "2"}], "+", "\[Pi]"}], "\[Pi]"]], " ", 
    SqrtBox[
     SubsuperscriptBox["\[Sigma]", "Q", "2"]], " ", 
    SubscriptBox["\[Lambda]", "1"]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896259217522*^9, {3.389717127402824*^9, 3.389717157233824*^9}, 
   3.389717222980824*^9}]
}, Open  ]],

Cell[TextData[{
 "The variance components corresponding to ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["u", "t"], ",", " ", 
   SubscriptBox["q", "t"]}]]],
 " and ",
 Cell[BoxData[
  SubscriptBox["Q", "t"]]],
 " are:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    SuperscriptBox["VarDecomp1", "2"], "//", "Simplify"}], "}"}], "//", 
  "TableForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[GridBox[{
    {
     SubsuperscriptBox["\[Sigma]", "u", "2"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["\[Lambda]", "0"], "+", 
        RowBox[{
         SqrtBox[
          FractionBox["2", "\[Pi]"]], " ", 
         SqrtBox[
          SubsuperscriptBox["\[Sigma]", "Q", "2"]], " ", 
         SubscriptBox["\[Lambda]", "1"]}]}], ")"}], "2"], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "\[Pi]"}], ")"}], " ", 
       SubsuperscriptBox["\[Sigma]", "Q", "2"], " ", 
       SubsuperscriptBox["\[Lambda]", "1", "2"]}], "\[Pi]"]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896259219032*^9, {3.389717127450824*^9, 3.3897171572738237`*^9}, 
   3.389717223021824*^9}]
}, Open  ]],

Cell[TextData[{
 "Verify that they add up to the correct ",
 Cell[BoxData[
  SubsuperscriptBox["\[Sigma]", "w", "2"]]],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", " ", "@@", " ", 
   SuperscriptBox["VarDecomp1", "2"]}], "//", "Simplify"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
  SubsuperscriptBox["\[Lambda]", "0", "2"], "+", 
  RowBox[{"2", " ", 
   SqrtBox[
    FractionBox["2", "\[Pi]"]], " ", 
   SqrtBox[
    SubsuperscriptBox["\[Sigma]", "Q", "2"]], " ", 
   SubscriptBox["\[Lambda]", "0"], " ", 
   SubscriptBox["\[Lambda]", "1"]}], "+", 
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "Q", "2"], " ", 
   SubsuperscriptBox["\[Lambda]", "1", "2"]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896259219482*^9, {3.389717127524824*^9, 3.3897171573128242`*^9}, 
   3.389717223064824*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Decomposition with ",
 Cell[BoxData[
  SubscriptBox["Q", "t"]]],
 " first:"
}], "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"F2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Permute", "[", 
      RowBox[{
       RowBox[{"CholeskyDecomposition", "[", 
        RowBox[{"Permute", "[", 
         RowBox[{
          RowBox[{"\[CapitalOmega]", "/.", 
           SubscriptBox["\[CapitalOmega]", "Rule"]}], ",", 
          RowBox[{"{", 
           RowBox[{"3", ",", "2", ",", "1"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2", ",", "1"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[Sigma]", "Q"], ">", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Sigma]", "u"], ">", "0"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"F2", "//", "MatrixForm"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SqrtBox[
       SubsuperscriptBox["\[Sigma]", "u", "2"]], "0", "0"},
     {"0", 
      SqrtBox[
       FractionBox[
        RowBox[{
         RowBox[{"-", "2"}], "+", "\[Pi]"}], "\[Pi]"]], "0"},
     {"0", 
      SqrtBox[
       FractionBox["2", "\[Pi]"]], 
      SqrtBox[
       SubsuperscriptBox["\[Sigma]", "Q", "2"]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896259219912*^9, {3.389717127567824*^9, 3.389717157355824*^9}, 
   3.389717223105824*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VarDecomp2", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[Theta]", "0"], "+", 
         SubscriptBox["\[Theta]", "1"]}], ")"}], ".", 
       RowBox[{"Transpose", "[", "F2", "]"}]}], "/.", 
      SubscriptBox["\[Theta]", "Rules"]}], "//", "Simplify"}], ")"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SqrtBox[
    SubsuperscriptBox["\[Sigma]", "u", "2"]], ",", 
   RowBox[{
    SqrtBox[
     FractionBox[
      RowBox[{
       RowBox[{"-", "2"}], "+", "\[Pi]"}], "\[Pi]"]], " ", 
    SubscriptBox["\[Lambda]", "0"]}], ",", 
   RowBox[{
    RowBox[{
     SqrtBox[
      FractionBox["2", "\[Pi]"]], " ", 
     SubscriptBox["\[Lambda]", "0"]}], "+", 
    RowBox[{
     SqrtBox[
      SubsuperscriptBox["\[Sigma]", "Q", "2"]], " ", 
     SubscriptBox["\[Lambda]", "1"]}]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896259220462*^9, {3.3897171276228237`*^9, 3.389717157395824*^9}, 
   3.389717223151824*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    SuperscriptBox["VarDecomp2", "2"], "}"}], "//", "Simplify"}], "//", 
  "TableForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[GridBox[{
    {
     SubsuperscriptBox["\[Sigma]", "u", "2"], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "\[Pi]"}], ")"}], " ", 
       SubsuperscriptBox["\[Lambda]", "0", "2"]}], "\[Pi]"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SqrtBox[
          FractionBox["2", "\[Pi]"]], " ", 
         SubscriptBox["\[Lambda]", "0"]}], "+", 
        RowBox[{
         SqrtBox[
          SubsuperscriptBox["\[Sigma]", "Q", "2"]], " ", 
         SubscriptBox["\[Lambda]", "1"]}]}], ")"}], "2"]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896259220952*^9, {3.389717127661824*^9, 3.3897171574378242`*^9}, 
   3.389717223194824*^9}]
}, Open  ]],

Cell["... and verify:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", " ", "@@", " ", 
   SuperscriptBox["VarDecomp2", "2"]}], "//", "Simplify"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
  SubsuperscriptBox["\[Lambda]", "0", "2"], "+", 
  RowBox[{"2", " ", 
   SqrtBox[
    FractionBox["2", "\[Pi]"]], " ", 
   SqrtBox[
    SubsuperscriptBox["\[Sigma]", "Q", "2"]], " ", 
   SubscriptBox["\[Lambda]", "0"], " ", 
   SubscriptBox["\[Lambda]", "1"]}], "+", 
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "Q", "2"], " ", 
   SubsuperscriptBox["\[Lambda]", "1", "2"]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896259221412*^9, {3.389717127709824*^9, 3.3897171574828243`*^9}, 
   3.3897172232328243`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Exercise 9.2 (Madhavan, Richardson and Roomans, Source notebook: \
MultivariateMicrostructureModels)\
\>", "Subsection",
 CellChangeTimes->{3.3907329475346003`*^9},
 CellTags->"ExMRR"],

Cell["The model is:", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["q", "Rule"], "=", 
   RowBox[{
    SubscriptBox["q", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["v", "t"], "+", 
     RowBox[{"\[Beta]", " ", 
      SubscriptBox["q", 
       RowBox[{"t", "-", "1"}]]}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["m", "Rule"], "=", 
   RowBox[{
    SubscriptBox["m", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", 
      RowBox[{"t", "-", "1"}]], "+", 
     SubscriptBox["w", "t"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["w", "Rule"], "=", 
   RowBox[{
    SubscriptBox["w", "t_"], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"\[Lambda]", " ", 
      SubscriptBox["v", "t"]}], "+", 
     SubscriptBox["u", "t"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["p", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", "t"], "+", 
     RowBox[{"c", " ", 
      SubscriptBox["q", "t"]}]}]}]}], ";"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "With these rules, ",
 Cell[BoxData[
  SubscriptBox["q", "t"]]],
 ", ",
 Cell[BoxData[
  SubscriptBox["m", "t"]]],
 ", ",
 Cell[BoxData[
  SubscriptBox["w", "t"]]],
 ", and ",
 Cell[BoxData[
  SubscriptBox["p", "t"]]],
 " are:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["q", "t"], "/.", 
     SubscriptBox["q", "Rule"]}], ",", " ", 
    RowBox[{
     SubscriptBox["m", "t"], "/.", 
     SubscriptBox["m", "Rule"]}], ",", " ", 
    RowBox[{
     SubscriptBox["w", "t"], "/.", 
     SubscriptBox["w", "Rule"]}], ",", " ", 
    RowBox[{
     SubscriptBox["p", "t"], "/.", 
     SubscriptBox["p", "Rule"]}]}], "}"}], "//", "TableForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{
       RowBox[{"\[Beta]", " ", 
        SubscriptBox["q", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "t"}]]}], "+", 
       SubscriptBox["v", "t"]}]},
     {
      RowBox[{
       SubscriptBox["m", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "t"}]], "+", 
       SubscriptBox["w", "t"]}]},
     {
      RowBox[{
       SubscriptBox["u", "t"], "+", 
       RowBox[{"\[Lambda]", " ", 
        SubscriptBox["v", "t"]}]}]},
     {
      RowBox[{
       SubscriptBox["m", "t"], "+", 
       RowBox[{"c", " ", 
        SubscriptBox["q", "t"]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259221921997`*^9, 3.389717127757824*^9, 
  3.389717244586824*^9}]
}, Open  ]],

Cell[TextData[{
 "The price change is ",
 Cell[BoxData[
  SubscriptBox["\[CapitalDelta]p", "t"]]],
 "="
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["\[CapitalDelta]p", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["\[CapitalDelta]p", "t"], "\[Rule]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{
          SubscriptBox["p", "t"], "/.", 
          SubscriptBox["p", "Rule"]}], "/.", 
         SubscriptBox["m", "Rule"]}], "/.", 
        SubscriptBox["w", "Rule"]}], ")"}], "-", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["p", 
         RowBox[{"t", "-", "1"}]], "/.", 
        SubscriptBox["p", "Rule"]}], ")"}]}]}]}]}], ";"}], "\n", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   SubscriptBox["\[CapitalDelta]p", "t"], "/.", "\[InvisibleSpace]", 
   SubscriptBox["\[CapitalDelta]p", "Rule"]}], "]"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[CapitalDelta]p", "t"], "\[Rule]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "c"}], " ", 
    SubscriptBox["q", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "t"}]]}], "+", 
   RowBox[{"c", " ", 
    SubscriptBox["q", "t"]}], "+", 
   SubscriptBox["u", "t"], "+", 
   RowBox[{"\[Lambda]", " ", 
    SubscriptBox["v", "t"]}]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259222332*^9, 3.3897171277988243`*^9, 
  3.389717244631824*^9}]
}, Open  ]],

Cell[TextData[{
 "The system variables are ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["y", "t"], "="}]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["y", "Rule"], "=", 
   RowBox[{
    SubscriptBox["y", "t_"], "\[RuleDelayed]", 
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["\[CapitalDelta]p", "t"], ",", 
        SubscriptBox["q", "t"]}], "}"}], "}"}], "]"}]}]}], ";", 
  RowBox[{
   RowBox[{
    SubscriptBox["y", "t"], "/.", 
    SubscriptBox["y", "Rule"]}], "//", "MatrixForm"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SubscriptBox["\[CapitalDelta]p", "t"]},
     {
      SubscriptBox["q", "t"]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259222742*^9, 3.389717127840824*^9, 
  3.3897172446748238`*^9}]
}, Open  ]],

Cell["The vector of disturbances is:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Epsilon]", "Rule"], "=", 
   RowBox[{
    SubscriptBox["\[Epsilon]", "t_"], "\[RuleDelayed]", 
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["u", "t"], ",", 
        SubscriptBox["v", "t"]}], "}"}], "}"}], "]"}]}]}], ";", 
  RowBox[{
   RowBox[{
    SubscriptBox["\[Epsilon]", "t"], "/.", 
    SubscriptBox["\[Epsilon]", "Rule"]}], "//", "MatrixForm"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SubscriptBox["u", "t"]},
     {
      SubscriptBox["v", "t"]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259223162003`*^9, 3.389717127881824*^9, 
  3.389717244717824*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "\[Theta]", "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "With substitutions, the vector of system variables becomes ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["y", "t"], "="}]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        SubscriptBox["\[CapitalDelta]p", "t"], "}"}], ",", 
       RowBox[{"{", 
        SubscriptBox["q", "t"], "}"}]}], "}"}], "/.", 
     RowBox[{
      SubscriptBox["\[CapitalDelta]p", "t"], "\[Rule]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           SubscriptBox["p", "t"], "/.", 
           SubscriptBox["p", "Rule"]}], "/.", 
          SubscriptBox["m", "Rule"]}], "/.", 
         SubscriptBox["w", "Rule"]}], ")"}], "-", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["p", 
          RowBox[{"t", "-", "1"}]], "/.", 
         SubscriptBox["p", "Rule"]}], ")"}]}]}]}], "/.", 
    RowBox[{
     SubscriptBox["q", "t"], "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["q", "t"], "/.", 
       SubscriptBox["q", "Rule"]}], ")"}]}]}], "//", "Simplify"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"c", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Beta]"}], ")"}], " ", 
        SubscriptBox["q", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "t"}]]}], "+", 
       SubscriptBox["u", "t"], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c", "+", "\[Lambda]"}], ")"}], " ", 
        SubscriptBox["v", "t"]}]}]},
     {
      RowBox[{
       RowBox[{"\[Beta]", " ", 
        SubscriptBox["q", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "t"}]]}], "+", 
       SubscriptBox["v", "t"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259223682003`*^9, 3.389717127933824*^9, 
  3.3897172447658243`*^9}]
}, Open  ]],

Cell[TextData[{
 "This is a first-order vector autoregressive process: ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["y", "t"], "=", 
   RowBox[{
    RowBox[{"\[Phi]", " ", 
     SubscriptBox["y", 
      RowBox[{"t", "-", "1"}]]}], "+", 
    RowBox[{"\[Theta]", " ", 
     SubscriptBox["\[Epsilon]", "t"]}]}]}]]],
 " where "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Phi]", "Rule"], "=", 
   RowBox[{"\[Phi]", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"c", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "\[Beta]"}], ")"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "\[Beta]"}], "}"}]}], "}"}]}]}], ";", 
  RowBox[{"MatrixForm", " ", "/@", " ", 
   SubscriptBox["\[Phi]", "Rule"]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  TagBox["\[Phi]",
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], "\[Rule]", 
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", 
       RowBox[{"c", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Beta]"}], ")"}]}]},
      {"0", "\[Beta]"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259224112*^9, 3.3897171279758244`*^9, 
  3.389717244809824*^9}]
}, Open  ]],

Cell["and", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Theta]", "Rule"], "=", 
   RowBox[{"\[Theta]", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"(", 
         RowBox[{"c", "+", "\[Lambda]"}], ")"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], ";", 
  RowBox[{"MatrixForm", " ", "/@", " ", 
   SubscriptBox["\[Theta]", "Rule"]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  TagBox["\[Theta]",
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], "\[Rule]", 
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1", 
       RowBox[{"c", "+", "\[Lambda]"}]},
      {"0", "1"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259224592*^9, 3.389717128019824*^9, 
  3.3897172448508244`*^9}]
}, Open  ]],

Cell[TextData[{
 "It may be put in vector moving average (VMA) form as: ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["y", "t"], "=", 
   RowBox[{
    UnderscriptBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"I", "-", "\[Phi]L"}], ")"}], 
       RowBox[{"-", "1"}]], "\[Theta]"}], 
     UnderscriptBox["\[UnderBrace]", 
      RowBox[{"VMA", " ", "coefficients"}]]], 
    SubscriptBox["\[Epsilon]", "t"]}]}]]],
 ". We could obtain the VMA coefficient matrices by doing the series \
expansion. Here, though, to compute the random-walk variance, we just need \
the sum of the moving average coefficients, and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"I", "-", "\[Phi]"}], ")"}], 
     RowBox[{"-", "1"}]], "\[Theta]"}], "="}]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"maSum", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Inverse", "[", 
      RowBox[{
       RowBox[{"IdentityMatrix", "[", "2", "]"}], "-", 
       RowBox[{"(", 
        RowBox[{"\[Phi]", "/.", 
         SubscriptBox["\[Phi]", "Rule"]}], ")"}]}], "]"}], ".", 
     RowBox[{"(", 
      RowBox[{"\[Theta]", "/.", 
       SubscriptBox["\[Theta]", "Rule"]}], ")"}]}], "//", "Simplify"}]}], ";",
   " ", 
  RowBox[{"maSum", "//", "MatrixForm"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "\[Lambda]"},
     {"0", 
      FractionBox["1", 
       RowBox[{"1", "-", "\[Beta]"}]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259225032*^9, 3.389717128059824*^9, 
  3.389717244896824*^9}]
}, Open  ]],

Cell[TextData[{
 "To compute the random-walk variance ",
 Cell[BoxData[
  SubsuperscriptBox["\[Sigma]", "w", "2"]]],
 ", take the upper left hand entry of ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"[", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"I", "-", "\[Phi]"}], ")"}], 
      RowBox[{"-", "1"}]], "\[Theta]"}], "]"}], 
   SuperscriptBox[
    RowBox[{"\[CapitalOmega]", "[", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"I", "-", "\[Phi]"}], ")"}], 
       RowBox[{"-", "1"}]], "\[Theta]"}], "]"}], "\[Prime]"]}]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"maSum", ".", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "u", "2"], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        SubsuperscriptBox["\[Sigma]", "v", "2"]}], "}"}]}], "}"}], ".", 
    RowBox[{"Transpose", "[", "maSum", "]"}]}], "//", "Simplify"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
       RowBox[{
        SuperscriptBox["\[Lambda]", "2"], " ", 
        SubsuperscriptBox["\[Sigma]", "v", "2"]}]}], 
      FractionBox[
       RowBox[{"\[Lambda]", " ", 
        SubsuperscriptBox["\[Sigma]", "v", "2"]}], 
       RowBox[{"1", "-", "\[Beta]"}]]},
     {
      FractionBox[
       RowBox[{"\[Lambda]", " ", 
        SubsuperscriptBox["\[Sigma]", "v", "2"]}], 
       RowBox[{"1", "-", "\[Beta]"}]], 
      FractionBox[
       SubsuperscriptBox["\[Sigma]", "v", "2"], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Beta]"}], ")"}], "2"]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896259225442*^9, 3.389717128104824*^9, 
  3.389717244941824*^9}]
}, Open  ]],

Cell[TextData[{
 "The quantity ",
 Cell[BoxData[
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
   RowBox[{
    SuperscriptBox["\[Lambda]", "2"], 
    SubsuperscriptBox["\[Sigma]", "v", "2"]}]}]]],
 " summarizes the public information and trade-related components of the \
random-walk."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 11.1 (Soure notebook: DealersAndInventories)", "Subsection",
 CellChangeTimes->{{3.3899923477756*^9, 3.3899923495095997`*^9}, {
  3.3907330322665997`*^9, 3.3907330454266*^9}},
 CellTags->"ExGarman"],

Cell["\<\
(The numbers in Exercise 11.1 were used to generate the figure.)\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a_", ",", "b_", ",", "c_", ",", "x_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"a", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"b", " ", "x"}], " ", "+", " ", "c"}]}], ";"}]], "Input",
 CellLabel->"In[208]:="],

Cell["Inverse arrival rates of sellers (who receive the bid price)", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ps", "=", 
  RowBox[{"f", "[", 
   RowBox[{".2", ",", ".2", ",", "2", ",", "\[Lambda]"}], "]"}]}]], "Input",
 CellLabel->"In[209]:="],

Cell[BoxData[
 RowBox[{"2", "+", 
  RowBox[{"0.2`", " ", "\[Lambda]"}], "+", 
  RowBox[{"0.2`", " ", 
   SuperscriptBox["\[Lambda]", "2"]}]}]], "Output",
 CellChangeTimes->{3.389697903671224*^9, 3.389718414137224*^9, 
  3.389718812668624*^9, 3.3899922924625998`*^9},
 CellLabel->"Out[209]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"ps", ",", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[210]:="],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVz30w1HkcB/Dv77eEmrOWum6JWuEqDIf04PL5RDc6JVcx1KyHcR7y2NLO
KM55pofV1B1OhzzUXSdPJ/SgPJz2dIdQEmHR5rbNqtWVjCT3vT/e857XP++Z
tyDo6IEQlhCyj+b/dg9RPmh74e0c5SyhIqjhaiga5zvA5g8qy3XU9iUFRfX8
XaCT5StE6j33B68V872gd9GnO4XaJ3iu+Qd+MAwmzSgZhqDMJts1hy+Ggdbs
lZoswdJVnlmn+Rlwdo/nZq4GwVTt+s9P8XNBnepSbKdN0PdQWe3M68tg4TGs
FcsjuGIpVehmUgtbk8qFRwwJmu9/pbx7pgFqcXp5+nqC8T3boODtLZDpJEGz
NcHVDbwxhmkFm79v2BdvIXhd7trd+2U7RCeXPKtyIdgeUWx0aFoK6WXvjBUe
BGctdnCro++Bg60gvs6XIDtfqWdk3glH/foa24IJOi4FXj9Y0w3Vt6L0fUUE
uzMcejo29UL+sqo5je8Irj2nmq941Qd2ixejdE4RVM2Njw3YPgSLji55Wh7B
y1O3O3XP9oOBLEM/+BJBXeMr6snJR5BlETIXWEdQEt4YWmr2GHo7E91bWwi+
w8rJI8mDMPS6Ne7CfYJiO2nDp3eHQDwdz+0aITheIz3zQDAMh3jPm0+qCC5E
PCrcmDAC+25aSA4vELTcqfUx9PYouIQcNxctZ9CtXBBWt3oMYn8UcCyMGIw3
DjB9KhyHmDeSX1dZMmg17b1i0GMC1lhvDNB0YtCAO6MtfT8B2eUruRV7GdRo
LaxdX/QUNCvSA475MRjpcPuJzh45jH7lPMSIGKz8Oqi05Z0c5o2P5OWnMTir
MtRT5D+Dwq4sH+dcBhsPunFyd01C3ZvDoS1XGEzenVnSoJgEUf9colsTgwKZ
+9ClzH+g5Vrlk/ZuBrdvycjl2ylgg9fjDZueMig06Z1n+hVwysQ/LPst3e/M
kYtSn0PDza47EzosFmj4iw+YKUGXJ5szN2HRYKyxnJUqwZR5O+ttx6JmUqrX
ttgXMLipriNvN4ukwr9Wrj8Fb6x3e9b4sRj3c22OfvsUlCb+IleIWWy2PKnN
i1GBj5xE6klY5LnHWaXpTsOw6RqtpTIWR637+k/cmYbAnbYjgiYWf78IZpP+
L2FHZkzbUh+LfrWOPOOPL8HpRHJe03MWUzLLUkevvoJtLgbfNBMOViuNC3X3
qqHPb3gh7DMO7ufpbr33Xg0R+jduRdhx8LQmazRKff77yJFoaun87OIM9U03
waKI2lEuu2u4oAbO63MYT21YX+0ZQ51bknIvnVru5RG26oMaiqLKBoqoxQWS
/G8X1bCrQ/lvD3W1JOXEcerDD/9a+ZBakSIW5lAfdbrqOEDtGy40vUFdYBab
MEK9Y7tVzfKPanh2gMsqqZeNdv1ZRx24NofH2HMQ+lp/66COXkiz16A+Lq0/
M0Kd4JDgrUU9VVW4X3OJ/mmOuvAJdU9SpMyXuskySGBIrRUX0BZN3a4OcjWm
xtCDl9KoO/VCQtZRX9vnFF5F/SQ8usKCWuVis/cP6omyY10bqc22rLd5TK1w
THxpRe1vuVpfRT29IYNrS/3T2hWzS9Qz8We/sKf+D9hAMAo=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 2.},
  PlotRange->{{0, 1}, {2.000000004081633, 2.399999987755102}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.389697903735224*^9, 3.389718414174224*^9, 
  3.3897188127166243`*^9, 3.3899922925596*^9},
 CellLabel->"Out[210]="]
}, Open  ]],

Cell["Inverse arrive rate of buyers (who pay the ask)", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pb", "=", 
  RowBox[{"f", "[", 
   RowBox[{".2", ",", 
    RowBox[{"-", "1"}], ",", "3", ",", "\[Lambda]"}], "]"}]}]], "Input",
 CellLabel->"In[211]:="],

Cell[BoxData[
 RowBox[{"3", "-", "\[Lambda]", "+", 
  RowBox[{"0.2`", " ", 
   SuperscriptBox["\[Lambda]", "2"]}]}]], "Output",
 CellChangeTimes->{3.389697903747224*^9, 3.389718414204224*^9, 
  3.389718812729624*^9, 3.3899922925896*^9},
 CellLabel->"Out[211]="]
}, Open  ]],

Cell[CellGroupData[{

Cell["The single price equilbrium", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ps", ",", "pb"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<\[Lambda]\>\"", ",", "\"\<p\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[212]:="],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVz30w1HkcB/Dv77eEmrOWum6JWuEqDIf04PL5RDc6JVcx1KyHcR7y2NLO
KM55pofV1B1OhzzUXSdPJ/SgPJz2dIdQEmHR5rbNqtWVjCT3vT/e857XP++Z
tyDo6IEQlhCyj+b/dg9RPmh74e0c5SyhIqjhaiga5zvA5g8qy3XU9iUFRfX8
XaCT5StE6j33B68V872gd9GnO4XaJ3iu+Qd+MAwmzSgZhqDMJts1hy+Ggdbs
lZoswdJVnlmn+Rlwdo/nZq4GwVTt+s9P8XNBnepSbKdN0PdQWe3M68tg4TGs
FcsjuGIpVehmUgtbk8qFRwwJmu9/pbx7pgFqcXp5+nqC8T3boODtLZDpJEGz
NcHVDbwxhmkFm79v2BdvIXhd7trd+2U7RCeXPKtyIdgeUWx0aFoK6WXvjBUe
BGctdnCro++Bg60gvs6XIDtfqWdk3glH/foa24IJOi4FXj9Y0w3Vt6L0fUUE
uzMcejo29UL+sqo5je8Irj2nmq941Qd2ixejdE4RVM2Njw3YPgSLji55Wh7B
y1O3O3XP9oOBLEM/+BJBXeMr6snJR5BlETIXWEdQEt4YWmr2GHo7E91bWwi+
w8rJI8mDMPS6Ne7CfYJiO2nDp3eHQDwdz+0aITheIz3zQDAMh3jPm0+qCC5E
PCrcmDAC+25aSA4vELTcqfUx9PYouIQcNxctZ9CtXBBWt3oMYn8UcCyMGIw3
DjB9KhyHmDeSX1dZMmg17b1i0GMC1lhvDNB0YtCAO6MtfT8B2eUruRV7GdRo
LaxdX/QUNCvSA475MRjpcPuJzh45jH7lPMSIGKz8Oqi05Z0c5o2P5OWnMTir
MtRT5D+Dwq4sH+dcBhsPunFyd01C3ZvDoS1XGEzenVnSoJgEUf9colsTgwKZ
+9ClzH+g5Vrlk/ZuBrdvycjl2ylgg9fjDZueMig06Z1n+hVwysQ/LPst3e/M
kYtSn0PDza47EzosFmj4iw+YKUGXJ5szN2HRYKyxnJUqwZR5O+ttx6JmUqrX
ttgXMLipriNvN4ukwr9Wrj8Fb6x3e9b4sRj3c22OfvsUlCb+IleIWWy2PKnN
i1GBj5xE6klY5LnHWaXpTsOw6RqtpTIWR637+k/cmYbAnbYjgiYWf78IZpP+
L2FHZkzbUh+LfrWOPOOPL8HpRHJe03MWUzLLUkevvoJtLgbfNBMOViuNC3X3
qqHPb3gh7DMO7ufpbr33Xg0R+jduRdhx8LQmazRKff77yJFoaun87OIM9U03
waKI2lEuu2u4oAbO63MYT21YX+0ZQ51bknIvnVru5RG26oMaiqLKBoqoxQWS
/G8X1bCrQ/lvD3W1JOXEcerDD/9a+ZBakSIW5lAfdbrqOEDtGy40vUFdYBab
MEK9Y7tVzfKPanh2gMsqqZeNdv1ZRx24NofH2HMQ+lp/66COXkiz16A+Lq0/
M0Kd4JDgrUU9VVW4X3OJ/mmOuvAJdU9SpMyXuskySGBIrRUX0BZN3a4OcjWm
xtCDl9KoO/VCQtZRX9vnFF5F/SQ8usKCWuVis/cP6omyY10bqc22rLd5TK1w
THxpRe1vuVpfRT29IYNrS/3T2hWzS9Qz8We/sKf+D9hAMAo=
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwVzX881HccB3D3vR/fll+ppGMy0baiaXj4keX9rvSQH9VDTlR+9LBiKjd5
nNKqFTutyGrNuJDfazNy5Y62B7ri0CQVRflxp9vtupycVlcPwu2zP16P1+P5
z+vlGP/19n2UiYnJVpL/O3if9uGtFxH+ms4Ns0YjjayNtilKrif4vs/2iCP2
KBUVS7gBkD+t5N+cozHk3kD9ZS4PUmKuvTk+S2Pk3nctF7l7oVQy9sX0NI0j
bt9vzOUKYLy8XWYw0Fhmve10NlcI608vPj+pozFjnuSTs9w8GEpewjMM0Bi1
s1w8+aoKRo+23nheS6OpMSM6cJkY5g+G+s7PonFF2IS2LUcK6278FbIplsYj
Pb4gevMnZKULnX70pNFGaqVgMGTg51AwMWVOY6NqY/f9L1rBt2iL9Ds1B1v3
X7bbOS6HhoNqP9dmDho+Xmd5NbkTrAtnrBX5HKSmahbYreiC3QEXFrfzOehl
3NMYXtcNk2ayvTVBHOwWevZ0rLoPfWJGWvEKDjpc0E1VTzyAzsGJ8P45Nure
KRWP1/RCdGdb4swgG6vGmrosfuiDzaN2gmNSNlrY/6pXqx9BjLVZsul5Np5L
akgoc+6HvLxRWnCQjW+xRv3VyQHQCJ42BgWyUeAuly5pewJLlr4xn3Bmo7JO
nvPQcRDG2pobLE3Y+H7/o6KV3wxB2lCHdO0wC13W03MJTcOwWXuh/qMmFgZW
OCZet1GAhFftISpg4RH7uOXPopXgpfq87tZhFrqOR5gObBkFS4/oNMUOFi6y
nJwnnx4FqqQ7tdyThSxZkdip+BmEneUHUNYsPODZ9PSDEBVEvNh+YulrJtYE
xZfdfKuCTXwb91W9TDTobBdo8v8G1h/fOnRImNgQHsjMC1BD3q6LIpefmHhy
c1apVKMGm6oPQ63SmOg4EvykMusf6On/7KQikolrvYV5XHcNzFTXqc74MDF6
2f0pRp8G+D/7JpXZkf2uXFVKxnNguZVv+mWGQhErVrDdWQuLDu/yMx+lcJGi
oYKSayHTP9slQk4h+0QGz/fQC9Avi1xdcoVCk+pYsWrhGJjdqbH1zqEwtVCc
u7B1DGwKW8KeJVPY4nJmnhVfB718/4ZDYRRaBae6ZlqMQ4XZ6j3+3hQOr37Q
d7R5HHoTTDPX2FF4rQSc1bEvoeLxbS2PQWGM2MvKfu4l+CiaDodoGXgqqzxj
+PcJcC10W3nsHgOvau2LLEL1QImEJl1SBoZZWfh0TuvBx1zzaXwhA7PZlN0w
8fPjQk4csXzKMDtJnB/krN5N7KUaabN9r4fXU4mlEcS2kqvb+MRXGo3WQcQq
3pZE6xk9/FuawlxDLBCdy/9yVg+O7lHK2Uvk/9ypo+nEsvXLW6aJNacE0bnE
MXUvC98RRyVFL79BXFByZscr4nVrXevmz+mBNdRzT03MGb7bfp1Y3lbcfJcY
Hsh+6yDeVXm88A5xulySM0SsV8aktxOP1RaFsY16WJri7Ckj7jlxYCSKOH78
dk09MZ0adyuZ+LWk9qyYGBPCKzOJhU9EibXE9Vv9kmqJq3zSnK4Q6za4hd4m
9hDsY1QSO3s7ufUTt5pFKkuJY11sFuqIt1HBLcXEBQ6mBiPxCM+/6BLxf1jG
Tb0=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"\[Lambda]\"", TraditionalForm], 
    FormBox["\"p\"", TraditionalForm]},
  AxesOrigin->{0, 2.},
  PlotRange->{{0, 1}, {2.000000004081633, 2.999999979591837}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.389697903785224*^9, 3.3897184142422237`*^9, 
  3.3897188127686243`*^9, 3.3899922926566*^9},
 CellLabel->"Out[212]="]
}, Open  ]],

Cell["Determination of the single-price equilibrium arrival rate:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Lambda]Eq", "=", 
  RowBox[{"\[Lambda]", "/.", 
   RowBox[{"Flatten", "[", 
    RowBox[{"NSolve", "[", 
     RowBox[{
      RowBox[{"ps", "\[Equal]", "pb"}], ",", "\[Lambda]"}], "]"}], 
    "]"}]}]}]], "Input",
 CellLabel->"In[213]:="],

Cell[BoxData["0.8333333333333334`"], "Output",
 CellChangeTimes->{3.3896979038332243`*^9, 3.389718414290224*^9, 
  3.389718812787624*^9, 3.3899922926846*^9},
 CellLabel->"Out[213]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pEq", "=", 
  RowBox[{"ps", "/.", 
   RowBox[{"\[Lambda]", "\[Rule]", "\[Lambda]Eq"}]}]}]], "Input",
 CellLabel->"In[214]:="],

Cell[BoxData["2.3055555555555554`"], "Output",
 CellChangeTimes->{3.389697903860224*^9, 3.3897184143262243`*^9, 
  3.389718812815624*^9, 3.3899922927326*^9},
 CellLabel->"Out[214]="]
}, Open  ]],

Cell["(Optimal) average profit and arrival intensity:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"NMaximize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Lambda]", 
       RowBox[{"(", 
        RowBox[{"pb", "-", "ps"}], ")"}]}], ",", 
      RowBox[{"\[Lambda]", ">", "0"}]}], "}"}], ",", "\[Lambda]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[215]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.20833333333333331`", ",", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]", "\[Rule]", "0.41666666666666663`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.389697904222224*^9, 3.3897184144262238`*^9, 
  3.389718812879624*^9, 3.3899922929326*^9},
 CellLabel->"Out[215]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Lambda]Opt", "=", 
  RowBox[{"\[Lambda]", "/.", 
   RowBox[{"sol", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", "1"}], "]"}], "]"}]}]}]], "Input",
 CellLabel->"In[216]:="],

Cell[BoxData["0.41666666666666663`"], "Output",
 CellChangeTimes->{3.389697904250224*^9, 3.3897184144592237`*^9, 
  3.3897188129276237`*^9, 3.3899922929816*^9},
 CellLabel->"Out[216]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"bid", "=", 
  RowBox[{"ps", "/.", 
   RowBox[{"\[Lambda]", "\[Rule]", "\[Lambda]Opt"}]}]}]], "Input",
 CellLabel->"In[217]:="],

Cell[BoxData["2.1180555555555554`"], "Output",
 CellChangeTimes->{3.389697904280224*^9, 3.389718414495224*^9, 
  3.389718812955624*^9, 3.3899922930425997`*^9},
 CellLabel->"Out[217]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ask", "=", 
  RowBox[{"pb", "/.", 
   RowBox[{"\[Lambda]", "\[Rule]", "\[Lambda]Opt"}]}]}]], "Input",
 CellLabel->"In[218]:="],

Cell[BoxData["2.6180555555555554`"], "Output",
 CellChangeTimes->{3.389697904310224*^9, 3.389718414535224*^9, 
  3.3897188129856243`*^9, 3.3899922930976*^9},
 CellLabel->"Out[218]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"extra", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"GrayLevel", "[", "0.9`", "]"}], ",", 
     RowBox[{"Rectangle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.01`", ",", "bid"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Lambda]Opt", ",", "ask"}], "}"}]}], "]"}], ",", 
     RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
     RowBox[{"Dashing", "[", 
      RowBox[{"{", "0.01`", "}"}], "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\[Lambda]Opt", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Lambda]Opt", ",", "ask"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "bid"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Lambda]Opt", ",", "bid"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "ask"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Lambda]Opt", ",", "ask"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\[Lambda]Eq", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Lambda]Eq", ",", "pEq"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "pEq"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Lambda]Eq", ",", "pEq"}], "}"}]}], "}"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{
      "\"\<\!\(\*SuperscriptBox[\(\[Lambda]\), \(Buy\)]\)(p)\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"0.3`", ",", "2.9`"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{
      "\"\<\!\(\*SuperscriptBox[\(\[Lambda]\), \(Sell\)]\)(p)\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"1.05`", ",", "2.6`"}], "}"}]}], "]"}]}], 
    "\[IndentingNewLine]", "}"}]}], ";"}], "\n", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ps", ",", "pb"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]", ",", "0", ",", "1.2`"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1.2`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.8`", ",", "3.1`"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Arrival rate\>\"", ",", "\"\<Price, p\>\""}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "\[Lambda]Opt", ",", " ", 
          "\"\<\!\(\*SuperscriptBox[\(\[Lambda]\), \(Optimal\)]\) \>\""}], 
         "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "\[Lambda]Eq", ",", 
          "\"\<\!\(\*SuperscriptBox[\(\[Lambda]\), \(Eq\)]\)\>\""}], "}"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"bid", ",", "Bid"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ask", ",", "Ask"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "pEq", ",", "\"\<\!\(\*SuperscriptBox[\(p\), \(Eq\)]\)\>\""}], 
         "}"}]}], "}"}], ",", "None", ",", "None"}], "}"}]}], ",", 
   RowBox[{"Epilog", "\[Rule]", "extra"}], ",", 
   RowBox[{"BaseStyle", "\[Rule]", "baseStyle"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.389718018864224*^9, 3.389718154928224*^9}, {
  3.389718195495224*^9, 3.389718220869224*^9}, {3.389718255610224*^9, 
  3.3897183983012238`*^9}, {3.389718497233224*^9, 3.389718571626224*^9}, {
  3.389718610594224*^9, 3.389718616046224*^9}},
 CellLabel->"In[219]:="],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVz3s0lHkcx/Hf8zy6mKQNlZUmE6mkC2Ni1fh+SVGaynWlK1aHQboe3ZBL
p4tqjVKWVOsoTUWJhjjlRFddx+VExKBBW2oukdJp97d/fM77vP78CMLi/CJY
QshKuv+r75g4r8wnxK1v+WUqgnmpU62MprqAPEiRa0sdN7388Gu+N1hyPDcJ
dfAgK77DDwZLt5TsHOrn7TMn3eBHwt5FigIRQ3BUw8I0OX833A6xt4hlCdpI
Hrhe4h8G1ym+ezoNCAp5vNMF/GyQVO4frTIkeFb5ZUTANDkAabA1n0CwMaJM
ev/qTRhd4REx1orgnLm+78oLK4DtJSEwm+CgnUlS6vRq0Ndp69TOBN3P8/yc
cmoguex0zRxPgriYP5DZ9QDs9mUcZ/wI9q2wFpyb/AR0322+WWwiqAtdZrJg
yjOYLZIX3o4l6CRjzCo3voTSzj8dmQSC/RGxsREiJYQFlWVXpxM0U/hN8Cyt
h7zz415dyqH/TZMfZPs2QnvrSJH/VYKSQWgWNjbBsOLu55Aqght6vPSe8a/h
31mZfHhO0PPIY79rJi0w3vwEG9hBsLWkxSwk8w3UnN1idEVD8ESvsCPBsQ1a
NSRpiGNQl8836lO8Bb5ybGX8RAa3R/u5P17bAbUZC6pHzWYwfEfS+qT9Kuiu
ICfuAoNqfd5TsbgTAnYLm474MzjwXSV2Nu4C2SPRj5QoBts9Yzr9lV0QZXVq
Tkoigw59wsLcjG5Y/XDvivSTDJqYWG3jb3oHmjO/yNuvMPgsMSDmvkANwgvO
iZb3GDTbXhR9Ua8G9aamzqoWBh/e9Thecq8HZKFvLLboGPRdaaVSJffC156l
GZ8MWZT+Mc3Zx68PkuM3Z/Vbs7j2Tkx1s9l7UPfM3HFtEYvlcfooWcN7SFn+
ZENoIIt/Xz5nfjD/H0j4mmZdspXFcJvModzwD+CtJ4svHmWx1PZKW7/TR+hx
v7PPp5DFtmieLmzoIzgo6nMO1bAYxyucxVX0g69xkb74LYsZ8yIj2g99gsit
klcFwywePbOtvm3ZZzi4b+6AmTmHvNqXgjHGGrAdoR6SOnNo0JsWLd6lAW2J
/bRbQRxK7dslyU0asL8m9lm/k8NJt5bd7BJroSlzZOjoLA7nb1xzPfC8FvIP
7jHiyjj8KTokbv+pBfIrGDbVc2i6+pEkbbMOFurqvB9+4TAr/ergwkc66M57
dfKDmQFu4OULxs/XQ+kBwxgvFwOUcC/kU6hPWQYU+1Av+vHNwY56xPULmlXU
Fp98PRZTy8phVzD1ayUTvos65PesxCjq1X+FFrRQX1Sek6VTe8wUzMh30IN9
id3tl9QOAsn1YmoVv2y4gdrKYo9zFbV1Krg1U/8co/RqpA6Yt65WRV31+UDk
SEc9bJ5Y9FxL7VSukkupl0wt6jL9zQCtbxg5xlN3DwRON6c2kbtUplKPqyWR
ltTanIy6s9Sm7uv6baiLE/HDC+q6p3ZDIuq8+JgdrdRtQd2urtTHtmYP91In
NOcluFFLwzRjGKEepNXmnBf1mrWWp8ZSK2xalvhQewd4W1pQyw7kHl5F7SLZ
WWBLPVy/8ak/9YylF+yF1PrJtsbB1P8B8XUULw==
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwVx384E3gcwPH9Xsap1vpx0ph+kKcUW3Jl9/mEwtWK0RM6YuJq1rly029a
5dRVyKNyoeLRsYpUmKeu6+nK0eXSRDi7kcbWDxnLnnQ73ff+eD/v5yWQpUqT
aBQKZT3p/1t6ZyypXRvz5b7j9bZPn9hYcsTF1cHFD3jDq+yBOHW+5lgnPwTi
x7iCjAk2Rllp4rv8KJhiyJLZbGz8U+8xs4a/DbSh1/3Hx9nIfrbyqJq/B9p9
p6x/b2HjPEnjip/5x0B/ljMwbGSjkMM5W84vBFrqi5e2VjYWa98zI93UoKGF
xacVs7E9qVb+8OpNKI4JKG1VsHGxV7hBU9EAeys5PTlfstHqyc08Mv8emA83
TTY4sHHVRY5UdP43iK0rS6X3shAD+WP5/Y2QVVwgeFrFQtO6uYILsx9BwZ3K
+kkZLBxNCOX6zmkBhXGGcDichaLTVN7tLa3gG6vmXHJj4VDSjh1Jy7SQOfQy
wWxlIq9eOj3oVhs4aXUtuS1MjJqmaiwMb4e4TKFh+kUmSqzQJWzvgOf8ujEX
JRPjBoMtQbs7oWsx76N7CBODjjdLr3G7ocp3rjXbmYk9N7p5Mfl/wT4P1S8b
3jMwxyjsPeijA+l9qdznEQNHy/gOpvq/ocrPLuvbUgbuSpGuat7cC/bflJh0
6QxMTMuMzTzQB9cOxEQVShg4YCl5LBa/AOv+14Y8dwaOfewTL3fsh+p++6dd
E3TUByleRGj7IfqyZfuGbjp6m4QVRXkvoUf4RmitpSOX67qTH28ATWPE7Uk5
dGzJiFQ8FAxAbp8m1ktOR96uqpTLlgHYcyLSsTOQjr//GnDqxv1BcBvrfd7A
p2P4ete+PpUR9MvEh07baCjf6rZ8rdQEsujJfpwuGm6+q7jXxXsFM6rfKVLq
aahJtWw//ewVPFYKR01naFhaeWFWVtlrOBS3sdUtjYaJ8/I/FCW+gVhT6dWF
ETS8teCKbkj0FmqKzS4MbxrqUjijsg9vYdIjmkvJVBqmcioW0huG4N9NCeeD
LVTMW7ItSZ/9Do43B8/qb6Pij+d2tulChyFd1H3YpY6KnAetAntHM/xgpa7d
eoaKDOPRFLHSDMdiAvc/SKeifJFeouowQ0RcwwZ1DBVn1oXe7BePgNeCitxb
/lRcuiX6+saLI5C17oqdr4CKE8uyxfqJERDlZ8+sZ1FxWliT5GjyKCSOvR1M
f03BMyeuWlc2jcKmg77JBU8pGMcpE0xdagEeTzliV0dBCf2Jeg4xRdVVzSL2
t417exLvM4gVdGKnd+EBgcSzcx2NtloKdmqpiUpih7Qm3TBx2E8J5d3EauW5
5g7iAA+Be5m3BbRJNaWlxN4CyfVq4txy6ZYLxK5Oe5ffIdZ1W52LiCfstcHt
xG4eqwsLiO8MH9rG8rHA1xHjOdnEIk2fWk58ynDvwA7iuTUOPruJRSdVK+TE
XLXf7SPEcs/VH5KJR87n/VFMfPirtrR44uoMfPOEWPY5IyWCuGS3Iq2HOEPZ
4RFGfPK7wn+MxAubKwfXEctlZnuq0AKe4Rtla4ijNzsXfEasyvZyDSQOiQxx
diJOrrXTA7Gf5PvyBcTdnYNF/sTuay4tEhLrRhqjvyD+D0LJMUE=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 1.8},
  Background->GrayLevel[1],
  BaseStyle->{FontFamily -> "Times", FontSize -> 12},
  Epilog->{
    GrayLevel[0.9], 
    RectangleBox[{0.01, 2.1180555555555554`}, {0.41666666666666663`, 
     2.6180555555555554`}], 
    GrayLevel[0], 
    Dashing[{0.01}], 
    LineBox[{{0.41666666666666663`, 0}, {0.41666666666666663`, 
      2.6180555555555554`}}], 
    LineBox[{{0, 2.1180555555555554`}, {0.41666666666666663`, 
      2.1180555555555554`}}], 
    LineBox[{{0, 2.6180555555555554`}, {0.41666666666666663`, 
      2.6180555555555554`}}], 
    LineBox[{{0.8333333333333334, 0}, {0.8333333333333334, 
      2.3055555555555554`}}], 
    LineBox[{{0, 2.3055555555555554`}, {0.8333333333333334, 
      2.3055555555555554`}}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*SuperscriptBox[\\(\[Lambda]\\), \\(Buy\\)]\\)(p)\"", 
      TraditionalForm], {0.3, 2.9}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*SuperscriptBox[\\(\[Lambda]\\), \\(Sell\\)]\\)(p)\"", 
      TraditionalForm], {1.05, 2.6}]},
  Frame->True,
  FrameLabel->{
    FormBox["\"Arrival rate\"", TraditionalForm], 
    FormBox["\"Price, p\"", TraditionalForm]},
  FrameTicks->{{{0.41666666666666663`, 
      FormBox[
      "\"\\!\\(\\*SuperscriptBox[\\(\[Lambda]\\), \\(Optimal\\)]\\) \"", 
       TraditionalForm]}, {0.8333333333333334, 
      FormBox[
      "\"\\!\\(\\*SuperscriptBox[\\(\[Lambda]\\), \\(Eq\\)]\\)\"", 
       TraditionalForm]}}, {{2.1180555555555554`, 
      FormBox["Bid", TraditionalForm]}, {2.6180555555555554`, 
      FormBox["Ask", TraditionalForm]}, {2.3055555555555554`, 
      FormBox[
      "\"\\!\\(\\*SuperscriptBox[\\(p\\), \\(Eq\\)]\\)\"", TraditionalForm]}},
     None, None},
  PlotRange->{{0, 1.2}, {1.8, 3.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.3896979043592243`*^9, 3.3897184145902243`*^9, {3.389718502883224*^9, 
   3.3897185291752243`*^9}, 3.389718573661224*^9, 3.389718616518224*^9, 
   3.389718813045624*^9, 3.3899922931906*^9},
 CellLabel->"Out[220]="]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 15.1 (Source notebook: TradingStrategiesI)", "Subsection",
 CellChangeTimes->{{3.3907330171056004`*^9, 3.3907330489856*^9}},
 CellTags->"ExTradingStrategy"],

Cell[CellGroupData[{

Cell["Model dynamics", "Subsubsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["m", "Rule"], "=", 
   RowBox[{
    SubscriptBox["m", "t_"], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["m", 
        RowBox[{"t", "-", "1"}]], "/.", 
       RowBox[{
        SubscriptBox["m", "0"], "\[Rule]", "0"}]}], ")"}], "+", 
     RowBox[{
      SubscriptBox[
       RowBox[{"\[Lambda]", " "}], "t"], 
      SubscriptBox["s", "t"]}], "+", "\[Mu]", "+", 
     SubscriptBox["\[Epsilon]", "t"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["p", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", "t"], "+", 
     RowBox[{"\[Gamma]", " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["s", "t"], "/.", 
        RowBox[{
         SubscriptBox["s", "0"], "\[Rule]", "0"}]}], ")"}]}]}]}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["W", "Rule"], "=", 
   RowBox[{
    SubscriptBox["W", "t_"], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{
      SubscriptBox["W", 
       RowBox[{"t", "-", "1"}]], "-", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["s", 
         RowBox[{"t", "-", "1"}]], "/.", 
        RowBox[{
         SubscriptBox["s", "0"], "\[Rule]", "0"}]}], ")"}]}], "/;", 
     RowBox[{"!", 
      RowBox[{"t", "===", "0"}]}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Epsilon]Zap", "=", 
   RowBox[{
    SubscriptBox["\[Epsilon]", "_"], "\[Rule]", "0"}]}], ";"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"solution", "=", 
   RowBox[{
    RowBox[{"OptOrders", "[", 
     RowBox[{"3", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["p", "Rule"], ",", 
          SubscriptBox["m", "Rule"], ",", "\[Epsilon]Zap"}], "}"}], "/.", 
        RowBox[{"\[Mu]", "\[Rule]", "0"}]}], "/.", 
       RowBox[{"\[Gamma]", "\[Rule]", "0"}]}]}], "]"}], "//", "Simplify"}]}], 
  ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lagrangian: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"\[Delta]", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SubscriptBox["s", "1"], "-", 
       SubscriptBox["s", "2"], "-", 
       SubscriptBox["s", "3"]}], ")"}]}], "+", 
    RowBox[{
     SubsuperscriptBox["s", "1", "2"], " ", 
     SubscriptBox["\[Lambda]", "1"]}], "+", 
    RowBox[{
     SubscriptBox["s", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["s", "1"], " ", 
        SubscriptBox["\[Lambda]", "1"]}], "+", 
       RowBox[{
        SubscriptBox["s", "2"], " ", 
        SubscriptBox["\[Lambda]", "2"]}]}], ")"}]}], "+", 
    RowBox[{
     SubscriptBox["s", "3"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["s", "1"], " ", 
        SubscriptBox["\[Lambda]", "1"]}], "+", 
       RowBox[{
        SubscriptBox["s", "2"], " ", 
        SubscriptBox["\[Lambda]", "2"]}], "+", 
       RowBox[{
        SubscriptBox["s", "3"], " ", 
        SubscriptBox["\[Lambda]", "3"]}]}], ")"}]}]}]}],
  SequenceForm[
  "Lagrangian: ", $CellContext`\[Delta] (1 - Subscript[$CellContext`s, 1] - 
     Subscript[$CellContext`s, 2] - Subscript[$CellContext`s, 3]) + 
   Subscript[$CellContext`s, 1]^2 Subscript[$CellContext`\[Lambda], 1] + 
   Subscript[$CellContext`s, 2] (
     Subscript[$CellContext`s, 1] Subscript[$CellContext`\[Lambda], 1] + 
     Subscript[$CellContext`s, 2] Subscript[$CellContext`\[Lambda], 2]) + 
   Subscript[$CellContext`s, 3] (
     Subscript[$CellContext`s, 1] Subscript[$CellContext`\[Lambda], 1] + 
     Subscript[$CellContext`s, 2] Subscript[$CellContext`\[Lambda], 2] + 
     Subscript[$CellContext`s, 3] Subscript[$CellContext`\[Lambda], 3])],
  Editable->False]], "Print",
 CellChangeTimes->{3.389717443995224*^9},
 CellLabel->"During evaluation of In[31]:="],

Cell[BoxData["\<\"First order conditions:\"\>"], "Print",
 CellChangeTimes->{3.389717443997224*^9},
 CellLabel->"During evaluation of In[31]:="],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[Delta]"}], "+", 
        RowBox[{"2", " ", 
         SubscriptBox["s", "1"], " ", 
         SubscriptBox["\[Lambda]", "1"]}], "+", 
        RowBox[{
         SubscriptBox["s", "2"], " ", 
         SubscriptBox["\[Lambda]", "1"]}], "+", 
        RowBox[{
         SubscriptBox["s", "3"], " ", 
         SubscriptBox["\[Lambda]", "1"]}]}], "\[Equal]", "0"}]},
     {
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[Delta]"}], "+", 
        RowBox[{
         SubscriptBox["s", "1"], " ", 
         SubscriptBox["\[Lambda]", "1"]}], "+", 
        RowBox[{"2", " ", 
         SubscriptBox["s", "2"], " ", 
         SubscriptBox["\[Lambda]", "2"]}], "+", 
        RowBox[{
         SubscriptBox["s", "3"], " ", 
         SubscriptBox["\[Lambda]", "2"]}]}], "\[Equal]", "0"}]},
     {
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[Delta]"}], "+", 
        RowBox[{
         SubscriptBox["s", "1"], " ", 
         SubscriptBox["\[Lambda]", "1"]}], "+", 
        RowBox[{
         SubscriptBox["s", "2"], " ", 
         SubscriptBox["\[Lambda]", "2"]}], "+", 
        RowBox[{"2", " ", 
         SubscriptBox["s", "3"], " ", 
         SubscriptBox["\[Lambda]", "3"]}]}], "\[Equal]", "0"}]},
     {
      RowBox[{
       RowBox[{"1", "-", 
        SubscriptBox["s", "1"], "-", 
        SubscriptBox["s", "2"], "-", 
        SubscriptBox["s", "3"]}], "\[Equal]", "0"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.3897174439992237`*^9},
 CellLabel->"During evaluation of In[31]:="],

Cell[BoxData["\<\"Solutions:\"\>"], "Print",
 CellChangeTimes->{3.389717444001224*^9},
 CellLabel->"During evaluation of In[31]:="],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{"\[Delta]", "\[Rule]", 
       FractionBox[
        RowBox[{"2", " ", 
         SubscriptBox["\[Lambda]", "1"], " ", 
         RowBox[{"(", 
          RowBox[{
           SubsuperscriptBox["\[Lambda]", "2", "2"], "+", 
           RowBox[{
            SubscriptBox["\[Lambda]", "1"], " ", 
            SubscriptBox["\[Lambda]", "3"]}], "-", 
           RowBox[{"4", " ", 
            SubscriptBox["\[Lambda]", "2"], " ", 
            SubscriptBox["\[Lambda]", "3"]}]}], ")"}]}], 
        RowBox[{
         SubscriptBox["\[Lambda]", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Lambda]", "2"], "-", 
           RowBox[{"4", " ", 
            SubscriptBox["\[Lambda]", "3"]}]}], ")"}]}]]}]},
     {
      RowBox[{
       SubscriptBox["s", "1"], "\[Rule]", 
       RowBox[{"1", "+", 
        FractionBox[
         RowBox[{"2", " ", 
          SubscriptBox["\[Lambda]", "1"], " ", 
          SubscriptBox["\[Lambda]", "3"]}], 
         RowBox[{
          SubsuperscriptBox["\[Lambda]", "2", "2"], "-", 
          RowBox[{"4", " ", 
           SubscriptBox["\[Lambda]", "2"], " ", 
           SubscriptBox["\[Lambda]", "3"]}]}]]}]}]},
     {
      RowBox[{
       SubscriptBox["s", "2"], "\[Rule]", 
       FractionBox[
        RowBox[{
         SubscriptBox["\[Lambda]", "1"], " ", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Lambda]", "2"], "-", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "3"]}]}], ")"}]}], 
        RowBox[{
         SubscriptBox["\[Lambda]", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Lambda]", "2"], "-", 
           RowBox[{"4", " ", 
            SubscriptBox["\[Lambda]", "3"]}]}], ")"}]}]]}]},
     {
      RowBox[{
       SubscriptBox["s", "3"], "\[Rule]", 
       RowBox[{"-", 
        FractionBox[
         SubscriptBox["\[Lambda]", "1"], 
         RowBox[{
          SubscriptBox["\[Lambda]", "2"], "-", 
          RowBox[{"4", " ", 
           SubscriptBox["\[Lambda]", "3"]}]}]]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.389717444003224*^9},
 CellLabel->"During evaluation of In[31]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"solution", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Lambda]", "1"], "\[Rule]", "2"}], ",", 
     RowBox[{
      SubscriptBox["\[Lambda]", "2"], "\[Rule]", "1"}], ",", 
     RowBox[{
      SubscriptBox["\[Lambda]", "3"], "\[Rule]", " ", 
      RowBox[{"1", "/", "2"}]}]}], "}"}]}], "//", "TableForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{"\[Delta]", "\[Rule]", "0"}]},
     {
      RowBox[{
       SubscriptBox["s", "1"], "\[Rule]", 
       RowBox[{"-", "1"}]}]},
     {
      RowBox[{
       SubscriptBox["s", "2"], "\[Rule]", "0"}]},
     {
      RowBox[{
       SubscriptBox["s", "3"], "\[Rule]", "2"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389717444040224*^9}]
}, Open  ]],

Cell[TextData[{
 "As a check, verify that with constant ",
 Cell[BoxData["\[Lambda]"]],
 ", we obtain the original solution to the basic problem."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"solution", "/.", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Lambda]", "_"], "\[Rule]", "\[Lambda]"}], "}"}]}], "//", 
  "TableForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{"\[Delta]", "\[Rule]", 
       FractionBox[
        RowBox[{"4", " ", "\[Lambda]"}], "3"]}]},
     {
      RowBox[{
       SubscriptBox["s", "1"], "\[Rule]", 
       FractionBox["1", "3"]}]},
     {
      RowBox[{
       SubscriptBox["s", "2"], "\[Rule]", 
       FractionBox["1", "3"]}]},
     {
      RowBox[{
       SubscriptBox["s", "3"], "\[Rule]", 
       FractionBox["1", "3"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389717444086224*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1578, 1027},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->"EMMStyle02.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Ch4Ex3period"->{
  Cell[1450, 48, 247, 4, 65, "Subsection",
   CellTags->"Ch4Ex3period"]},
 "Ch4ExCorrq"->{
  Cell[23812, 843, 196, 3, 39, "Subsection",
   CellTags->"Ch4ExCorrq"]},
 "Ch4ExCorrup"->{
  Cell[37069, 1292, 193, 3, 39, "Subsection",
   CellTags->"Ch4ExCorrup"]},
 "SeqTrade1"->{
  Cell[45315, 1561, 205, 5, 39, "Subsection",
   CellTags->"SeqTrade1"]},
 "SeqTrade2"->{
  Cell[48461, 1683, 179, 5, 39, "Subsection",
   CellTags->"SeqTrade2"]},
 "SeqTrade3"->{
  Cell[83229, 2765, 174, 5, 39, "Subsection",
   CellTags->"SeqTrade3"]},
 "SeqTrade4"->{
  Cell[145701, 4631, 160, 4, 39, "Subsection",
   CellTags->"SeqTrade4"]},
 "ExStrategicTrade1"->{
  Cell[146866, 4676, 201, 4, 39, "Subsection",
   CellTags->"ExStrategicTrade1"]},
 "ExStrategicTrade2"->{
  Cell[186864, 5990, 181, 5, 39, "Subsection",
   CellTags->"ExStrategicTrade2"]},
 "ExStrategicTrade3"->{
  Cell[231501, 7450, 189, 5, 39, "Subsection",
   CellTags->"ExStrategicTrade3"]},
 "Ch8Ex1"->{
  Cell[264822, 8556, 188, 3, 39, "Subsection",
   CellTags->"Ch8Ex1"]},
 "Ch8Ex2"->{
  Cell[265269, 8571, 188, 3, 39, "Subsection",
   CellTags->"Ch8Ex2"]},
 "Ch8Ex3"->{
  Cell[268010, 8680, 188, 3, 39, "Subsection",
   CellTags->"Ch8Ex3"]},
 "ExGlostenHarris"->{
  Cell[303063, 9907, 208, 5, 39, "Subsection",
   CellTags->"ExGlostenHarris"]},
 "ExMRR"->{
  Cell[335040, 11041, 194, 5, 39, "Subsection",
   CellTags->"ExMRR"]},
 "ExGarman"->{
  Cell[353343, 11701, 213, 3, 39, "Subsection",
   CellTags->"ExGarman"]},
 "ExTradingStrategy"->{
  Cell[374384, 12253, 171, 2, 65, "Subsection",
   CellTags->"ExTradingStrategy"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Ch4Ex3period", 386683, 12658},
 {"Ch4ExCorrq", 386774, 12661},
 {"Ch4ExCorrup", 386866, 12664},
 {"SeqTrade1", 386958, 12667},
 {"SeqTrade2", 387048, 12670},
 {"SeqTrade3", 387138, 12673},
 {"SeqTrade4", 387228, 12676},
 {"ExStrategicTrade1", 387327, 12679},
 {"ExStrategicTrade2", 387434, 12682},
 {"ExStrategicTrade3", 387541, 12685},
 {"Ch8Ex1", 387637, 12688},
 {"Ch8Ex2", 387722, 12691},
 {"Ch8Ex3", 387807, 12694},
 {"ExGlostenHarris", 387901, 12697},
 {"ExMRR", 387994, 12700},
 {"ExGarman", 388081, 12703},
 {"ExTradingStrategy", 388180, 12706}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 835, 21, 392, "Title"],
Cell[CellGroupData[{
Cell[1450, 48, 247, 4, 65, "Subsection",
 CellTags->"Ch4Ex3period"],
Cell[1700, 54, 192, 7, 33, "Text"],
Cell[1895, 63, 471, 16, 43, "Input"],
Cell[2369, 81, 99, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[2493, 86, 594, 16, 71, "Input"],
Cell[3090, 104, 1943, 59, 187, "Output"]
}, Open  ]],
Cell[5048, 166, 91, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[5164, 171, 1327, 39, 98, "Input"],
Cell[6494, 212, 1875, 52, 187, "Output"]
}, Open  ]],
Cell[8384, 267, 85, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[8494, 272, 548, 15, 71, "Input"],
Cell[9045, 289, 2081, 64, 281, "Output"]
}, Open  ]],
Cell[11141, 356, 85, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[11251, 361, 126, 3, 43, "Input"],
Cell[11380, 366, 217, 4, 38, "Output"]
}, Open  ]],
Cell[11612, 373, 336, 14, 33, "Text"],
Cell[CellGroupData[{
Cell[11973, 391, 826, 26, 71, "Input"],
Cell[12802, 419, 2203, 68, 187, "Output"]
}, Open  ]],
Cell[15020, 490, 194, 9, 33, "Text"],
Cell[CellGroupData[{
Cell[15239, 503, 173, 5, 43, "Input"],
Cell[15415, 510, 254, 6, 38, "Output"]
}, Open  ]],
Cell[15684, 519, 216, 9, 33, "Text"],
Cell[CellGroupData[{
Cell[15925, 532, 317, 11, 43, "Input"],
Cell[16245, 545, 624, 18, 44, "Output"]
}, Open  ]],
Cell[16884, 566, 420, 17, 33, "Text"],
Cell[CellGroupData[{
Cell[17329, 587, 441, 15, 43, "Input"],
Cell[17773, 604, 533, 15, 41, "Output"]
}, Open  ]],
Cell[18321, 622, 283, 12, 33, "Text"],
Cell[CellGroupData[{
Cell[18629, 638, 206, 7, 43, "Input"],
Cell[18838, 647, 565, 17, 57, "Output"]
}, Open  ]],
Cell[19418, 667, 200, 7, 33, "Text"],
Cell[CellGroupData[{
Cell[19643, 678, 144, 4, 43, "Input"],
Cell[19790, 684, 297, 7, 38, "Output"]
}, Open  ]],
Cell[20102, 694, 73, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[20200, 699, 154, 5, 43, "Input"],
Cell[20357, 706, 315, 8, 38, "Output"]
}, Open  ]],
Cell[20687, 717, 167, 7, 33, "Text"],
Cell[CellGroupData[{
Cell[20879, 728, 373, 13, 43, "Input"],
Cell[21255, 743, 209, 4, 38, "Output"]
}, Open  ]],
Cell[21479, 750, 131, 6, 33, "Text"],
Cell[CellGroupData[{
Cell[21635, 760, 288, 10, 48, "Input"],
Cell[21926, 772, 209, 4, 38, "Output"]
}, Open  ]],
Cell[22150, 779, 469, 16, 37, "Text"],
Cell[CellGroupData[{
Cell[22644, 799, 410, 14, 48, "Input"],
Cell[23057, 815, 501, 15, 41, "Output"]
}, Open  ]],
Cell[23573, 833, 202, 5, 43, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23812, 843, 196, 3, 39, "Subsection",
 CellTags->"Ch4ExCorrq"],
Cell[24011, 848, 57, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[24093, 853, 1208, 39, 129, "Input"],
Cell[25304, 894, 449, 13, 38, "Output"]
}, Open  ]],
Cell[25768, 910, 282, 11, 33, "Text"],
Cell[26053, 923, 1676, 46, 163, "Input"],
Cell[27732, 971, 368, 10, 43, "Input"],
Cell[28103, 983, 126, 3, 32, "Text"],
Cell[CellGroupData[{
Cell[28254, 990, 247, 6, 48, "Input"],
Cell[28504, 998, 1034, 30, 44, "Output"]
}, Open  ]],
Cell[29553, 1031, 132, 4, 32, "Text"],
Cell[CellGroupData[{
Cell[29710, 1039, 287, 7, 43, "Input"],
Cell[30000, 1048, 498, 13, 41, "Output"]
}, Open  ]],
Cell[30513, 1064, 257, 10, 33, "Text"],
Cell[CellGroupData[{
Cell[30795, 1078, 325, 9, 43, "Input"],
Cell[31123, 1089, 1694, 58, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32854, 1152, 556, 15, 43, "Input"],
Cell[33413, 1169, 389, 10, 41, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33839, 1184, 524, 15, 43, "Input"],
Cell[34366, 1201, 324, 7, 41, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34727, 1213, 532, 15, 43, "Input"],
Cell[35262, 1230, 281, 5, 38, "Output"]
}, Open  ]],
Cell[35558, 1238, 343, 14, 35, "Text"],
Cell[CellGroupData[{
Cell[35926, 1256, 838, 24, 60, "Input"],
Cell[36767, 1282, 253, 4, 38, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[37069, 1292, 193, 3, 39, "Subsection",
 CellTags->"Ch4ExCorrup"],
Cell[37265, 1297, 50, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[37340, 1302, 1208, 39, 129, "Input"],
Cell[38551, 1343, 433, 13, 38, "Output"]
}, Open  ]],
Cell[38999, 1359, 112, 2, 32, "Text"],
Cell[39114, 1363, 1733, 46, 222, "Input"],
Cell[40850, 1411, 368, 10, 43, "Input"],
Cell[CellGroupData[{
Cell[41243, 1425, 426, 11, 48, "Input"],
Cell[41672, 1438, 427, 10, 41, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[42136, 1453, 501, 14, 43, "Input"],
Cell[42640, 1469, 375, 10, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[43052, 1484, 505, 14, 43, "Input"],
Cell[43560, 1500, 238, 4, 38, "Output"]
}, Open  ]],
Cell[43813, 1507, 343, 14, 35, "Text"],
Cell[CellGroupData[{
Cell[44181, 1525, 845, 24, 60, "Input"],
Cell[45029, 1551, 237, 4, 38, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[45315, 1561, 205, 5, 39, "Subsection",
 CellTags->"SeqTrade1"],
Cell[CellGroupData[{
Cell[45545, 1570, 54, 1, 43, "Input"],
Cell[45602, 1573, 647, 22, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46286, 1600, 174, 5, 43, "Input"],
Cell[46463, 1607, 312, 9, 56, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46812, 1621, 507, 16, 43, "Input"],
Cell[47322, 1639, 370, 12, 56, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47729, 1656, 541, 16, 43, "Input"],
Cell[48273, 1674, 139, 3, 38, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[48461, 1683, 179, 5, 39, "Subsection",
 CellTags->"SeqTrade2"],
Cell[CellGroupData[{
Cell[48665, 1692, 544, 17, 71, "Input"],
Cell[49212, 1711, 11373, 324, 103, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[60622, 2040, 1566, 46, 152, "Input"],
Cell[62191, 2088, 15478, 453, 447, "Output"]
}, Open  ]],
Cell[77684, 2544, 76, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[77785, 2548, 225, 7, 43, "Input"],
Cell[78013, 2557, 144, 3, 38, "Output"]
}, Open  ]],
Cell[78172, 2563, 102, 4, 33, "Text"],
Cell[CellGroupData[{
Cell[78299, 2571, 273, 8, 43, "Input"],
Cell[78575, 2581, 337, 11, 59, "Output"]
}, Open  ]],
Cell[78927, 2595, 41, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[78993, 2599, 273, 8, 43, "Input"],
Cell[79269, 2609, 301, 9, 59, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[79607, 2623, 272, 9, 43, "Input"],
Cell[79882, 2634, 490, 16, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[80409, 2655, 272, 9, 43, "Input"],
Cell[80684, 2666, 380, 11, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[81101, 2682, 163, 4, 43, "Input"],
Cell[81267, 2688, 426, 14, 61, "Output"]
}, Open  ]],
Cell[81708, 2705, 95, 2, 32, "Text"],
Cell[CellGroupData[{
Cell[81828, 2711, 473, 15, 43, "Input"],
Cell[82304, 2728, 148, 3, 38, "Output"]
}, Open  ]],
Cell[82467, 2734, 95, 2, 32, "Text"],
Cell[CellGroupData[{
Cell[82587, 2740, 450, 14, 43, "Input"],
Cell[83040, 2756, 140, 3, 38, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[83229, 2765, 174, 5, 39, "Subsection",
 CellTags->"SeqTrade3"],
Cell[CellGroupData[{
Cell[83428, 2774, 1068, 30, 287, "Input"],
Cell[84499, 2806, 22075, 627, 155, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[106611, 3438, 2362, 67, 179, "Input"],
Cell[108976, 3507, 30647, 882, 643, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[139660, 4394, 225, 7, 43, "Input"],
Cell[139888, 4403, 140, 3, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[140065, 4411, 273, 8, 43, "Input"],
Cell[140341, 4421, 695, 24, 59, "Output"]
}, Open  ]],
Cell[141051, 4448, 273, 8, 43, "Input"],
Cell[CellGroupData[{
Cell[141349, 4460, 88, 2, 43, "Input"],
Cell[141440, 4464, 154, 3, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[141631, 4472, 272, 9, 43, "Input"],
Cell[141906, 4483, 1067, 38, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[143010, 4526, 273, 8, 43, "Input"],
Cell[143286, 4536, 663, 22, 59, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[143986, 4563, 273, 9, 43, "Input"],
Cell[144262, 4574, 1044, 37, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[145343, 4616, 163, 4, 43, "Input"],
Cell[145509, 4622, 143, 3, 38, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[145701, 4631, 160, 4, 39, "Subsection",
 CellTags->"SeqTrade4"],
Cell[145864, 4637, 111, 3, 32, "Text"],
Cell[CellGroupData[{
Cell[146000, 4644, 311, 9, 43, "Input"],
Cell[146314, 4655, 503, 15, 59, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[146866, 4676, 201, 4, 39, "Subsection",
 CellTags->"ExStrategicTrade1"],
Cell[147070, 4682, 40, 0, 32, "Text"],
Cell[147113, 4684, 541, 19, 98, "Input"],
Cell[147657, 4705, 50, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[147732, 4709, 276, 7, 43, "Input"],
Cell[148011, 4718, 355, 10, 38, "Output"]
}, Open  ]],
Cell[148381, 4731, 203, 6, 33, "Text"],
Cell[CellGroupData[{
Cell[148609, 4741, 649, 21, 48, "Input"],
Cell[149261, 4764, 2354, 69, 61, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[151652, 4838, 172, 4, 43, "Input"],
Cell[151827, 4844, 727, 23, 64, "Output"]
}, Open  ]],
Cell[152569, 4870, 118, 4, 33, "Text"],
Cell[CellGroupData[{
Cell[152712, 4878, 405, 13, 71, "Input"],
Cell[153120, 4893, 575, 17, 60, "Output"]
}, Open  ]],
Cell[153710, 4913, 55, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[153790, 4917, 321, 10, 43, "Input"],
Cell[154114, 4929, 672, 19, 59, "Output"]
}, Open  ]],
Cell[154801, 4951, 235, 8, 33, "Text"],
Cell[CellGroupData[{
Cell[155061, 4963, 456, 14, 71, "Input"],
Cell[155520, 4979, 696, 20, 59, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[156253, 5004, 466, 14, 43, "Input"],
Cell[156722, 5020, 952, 26, 59, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[157711, 5051, 302, 9, 43, "Input"],
Cell[158016, 5062, 879, 25, 60, "Output"]
}, Open  ]],
Cell[158910, 5090, 134, 6, 33, "Text"],
Cell[CellGroupData[{
Cell[159069, 5100, 286, 9, 43, "Input"],
Cell[159358, 5111, 3164, 91, 61, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[162559, 5207, 192, 6, 43, "Input"],
Cell[162754, 5215, 3071, 89, 61, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[165862, 5309, 209, 6, 43, "Input"],
Cell[166074, 5317, 1602, 48, 73, "Output"]
}, Open  ]],
Cell[167691, 5368, 34, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[167750, 5372, 243, 7, 43, "Input"],
Cell[167996, 5381, 1026, 30, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[169059, 5416, 274, 8, 43, "Input"],
Cell[169336, 5426, 1663, 46, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[171036, 5477, 219, 7, 43, "Input"],
Cell[171258, 5486, 1427, 39, 67, "Output"]
}, Open  ]],
Cell[172700, 5528, 51, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[172776, 5532, 279, 8, 43, "Input"],
Cell[173058, 5542, 2107, 59, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[175202, 5606, 699, 22, 75, "Input"],
Cell[175904, 5630, 5157, 145, 201, "Output"]
}, Open  ]],
Cell[181076, 5778, 124, 5, 33, "Text"],
Cell[181203, 5785, 220, 7, 43, "Input"],
Cell[181426, 5794, 157, 6, 33, "Text"],
Cell[CellGroupData[{
Cell[181608, 5804, 445, 14, 48, "Input"],
Cell[182056, 5820, 1033, 30, 84, "Output"]
}, Open  ]],
Cell[183104, 5853, 43, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[183172, 5857, 616, 19, 61, "Input"],
Cell[183791, 5878, 537, 14, 73, "Output"]
}, Open  ]],
Cell[184343, 5895, 208, 8, 33, "Text"],
Cell[184554, 5905, 453, 15, 87, "Input"],
Cell[185010, 5922, 247, 9, 33, "Text"],
Cell[CellGroupData[{
Cell[185282, 5935, 624, 19, 48, "Input"],
Cell[185909, 5956, 210, 4, 38, "Output"]
}, Open  ]],
Cell[186134, 5963, 51, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[186210, 5967, 417, 12, 57, "Input"],
Cell[186630, 5981, 185, 3, 38, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[186864, 5990, 181, 5, 39, "Subsection",
 CellTags->"ExStrategicTrade2"],
Cell[187048, 5997, 1284, 41, 87, "Text"],
Cell[CellGroupData[{
Cell[188357, 6042, 33, 0, 44, "Subsubsection"],
Cell[188393, 6044, 541, 19, 98, "Input"],
Cell[188937, 6065, 42, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[189004, 6069, 276, 7, 43, "Input"],
Cell[189283, 6078, 359, 10, 38, "Output"]
}, Open  ]],
Cell[189657, 6091, 94, 4, 33, "Text"],
Cell[189754, 6097, 185, 6, 43, "Input"],
Cell[189942, 6105, 65, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[190032, 6109, 732, 22, 48, "Input"],
Cell[190767, 6133, 2466, 73, 87, "Output"]
}, Open  ]],
Cell[193248, 6209, 134, 5, 33, "Text"],
Cell[CellGroupData[{
Cell[193407, 6218, 256, 7, 43, "Input"],
Cell[193666, 6227, 2690, 79, 87, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[196393, 6311, 211, 6, 43, "Input"],
Cell[196607, 6319, 2648, 78, 87, "Output"]
}, Open  ]],
Cell[199270, 6400, 136, 4, 33, "Text"],
Cell[CellGroupData[{
Cell[199431, 6408, 184, 4, 43, "Input"],
Cell[199618, 6414, 953, 29, 67, "Output"]
}, Open  ]],
Cell[200586, 6446, 56, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[200667, 6450, 276, 7, 43, "Input"],
Cell[200946, 6459, 351, 10, 38, "Output"]
}, Open  ]],
Cell[201312, 6472, 103, 4, 33, "Text"],
Cell[CellGroupData[{
Cell[201440, 6480, 485, 13, 43, "Input"],
Cell[201928, 6495, 639, 18, 65, "Output"]
}, Open  ]],
Cell[202582, 6516, 145, 5, 32, "Text"],
Cell[CellGroupData[{
Cell[202752, 6525, 320, 10, 43, "Input"],
Cell[203075, 6537, 830, 23, 73, "Output"]
}, Open  ]],
Cell[203920, 6563, 124, 4, 33, "Text"],
Cell[204047, 6569, 215, 7, 43, "Input"],
Cell[204265, 6578, 193, 7, 33, "Text"],
Cell[CellGroupData[{
Cell[204483, 6589, 283, 8, 43, "Input"],
Cell[204769, 6599, 858, 24, 73, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[205664, 6628, 628, 18, 48, "Input"],
Cell[206295, 6648, 2580, 67, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[208912, 6720, 392, 12, 43, "Input"],
Cell[209307, 6734, 1135, 31, 73, "Output"]
}, Open  ]],
Cell[210457, 6768, 466, 16, 57, "Text"],
Cell[CellGroupData[{
Cell[210948, 6788, 295, 9, 43, "Input"],
Cell[211246, 6799, 2943, 85, 63, "Output"]
}, Open  ]],
Cell[214204, 6887, 35, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[214264, 6891, 200, 6, 43, "Input"],
Cell[214467, 6899, 2869, 83, 63, "Output"]
}, Open  ]],
Cell[217351, 6985, 128, 6, 33, "Text"],
Cell[CellGroupData[{
Cell[217504, 6995, 190, 4, 43, "Input"],
Cell[217697, 7001, 1437, 44, 71, "Output"]
}, Open  ]],
Cell[219149, 7048, 42, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[219216, 7052, 269, 7, 43, "Input"],
Cell[219488, 7061, 831, 24, 65, "Output"]
}, Open  ]],
Cell[220334, 7088, 24, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[220383, 7092, 606, 18, 48, "Input"],
Cell[220992, 7112, 1595, 43, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[222624, 7160, 302, 9, 43, "Input"],
Cell[222929, 7171, 1409, 41, 73, "Output"]
}, Open  ]],
Cell[224353, 7215, 51, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[224429, 7219, 284, 8, 43, "Input"],
Cell[224716, 7229, 2351, 67, 73, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[227104, 7301, 678, 20, 48, "Input"],
Cell[227785, 7323, 1251, 37, 82, "Output"]
}, Open  ]],
Cell[229051, 7363, 50, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[229126, 7367, 215, 6, 45, "Input"],
Cell[229344, 7375, 956, 28, 84, "Output"]
}, Open  ]],
Cell[230315, 7406, 133, 4, 33, "Text"],
Cell[CellGroupData[{
Cell[230473, 7414, 117, 2, 43, "Input"],
Cell[230593, 7418, 638, 18, 70, "Output"]
}, Open  ]],
Cell[231246, 7439, 206, 5, 34, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[231501, 7450, 189, 5, 39, "Subsection",
 CellTags->"ExStrategicTrade3"],
Cell[CellGroupData[{
Cell[231715, 7459, 33, 0, 44, "Subsubsection"],
Cell[231751, 7461, 214, 7, 43, "Input"],
Cell[231968, 7470, 122, 4, 33, "Text"],
Cell[232093, 7476, 264, 9, 43, "Input"],
Cell[232360, 7487, 50, 0, 32, "Text"],
Cell[232413, 7489, 237, 8, 43, "Input"],
Cell[232653, 7499, 121, 5, 32, "Text"],
Cell[CellGroupData[{
Cell[232799, 7508, 276, 7, 43, "Input"],
Cell[233078, 7517, 451, 13, 38, "Output"]
}, Open  ]],
Cell[233544, 7533, 161, 7, 33, "Text"],
Cell[CellGroupData[{
Cell[233730, 7544, 433, 11, 43, "Input"],
Cell[234166, 7557, 378, 10, 38, "Output"]
}, Open  ]],
Cell[234559, 7570, 40, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[234624, 7574, 278, 9, 43, "Input"],
Cell[234905, 7585, 391, 11, 57, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[235333, 7601, 456, 14, 71, "Input"],
Cell[235792, 7617, 429, 11, 56, "Output"]
}, Open  ]],
Cell[236236, 7631, 24, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[236285, 7635, 434, 13, 43, "Input"],
Cell[236722, 7650, 656, 17, 59, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[237415, 7672, 302, 9, 43, "Input"],
Cell[237720, 7683, 608, 17, 59, "Output"]
}, Open  ]],
Cell[238343, 7703, 191, 6, 33, "Text"],
Cell[CellGroupData[{
Cell[238559, 7713, 577, 19, 48, "Input"],
Cell[239139, 7734, 2286, 67, 61, "Output"]
}, Open  ]],
Cell[241440, 7804, 446, 17, 33, "Text"],
Cell[CellGroupData[{
Cell[241911, 7825, 286, 9, 43, "Input"],
Cell[242200, 7836, 3786, 109, 61, "Output"]
}, Open  ]],
Cell[246001, 7948, 30, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[246056, 7952, 200, 6, 43, "Input"],
Cell[246259, 7960, 3549, 102, 61, "Output"]
}, Open  ]],
Cell[249823, 8065, 48, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[249896, 8069, 217, 6, 43, "Input"],
Cell[250116, 8077, 1487, 45, 67, "Output"]
}, Open  ]],
Cell[251618, 8125, 34, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[251677, 8129, 238, 7, 43, "Input"],
Cell[251918, 8138, 974, 28, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[252929, 8171, 283, 9, 46, "Input"],
Cell[253215, 8182, 2417, 62, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[255669, 8249, 297, 9, 43, "Input"],
Cell[255969, 8260, 1395, 39, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[257401, 8304, 284, 8, 43, "Input"],
Cell[257688, 8314, 1786, 51, 67, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[259511, 8370, 583, 18, 48, "Input"],
Cell[260097, 8390, 1032, 31, 103, "Output"]
}, Open  ]],
Cell[261144, 8424, 52, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[261221, 8428, 148, 4, 43, "Input"],
Cell[261372, 8434, 919, 27, 78, "Output"]
}, Open  ]],
Cell[262306, 8464, 40, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[262371, 8468, 289, 7, 43, "Input"],
Cell[262663, 8477, 526, 16, 78, "Output"]
}, Open  ]],
Cell[263204, 8496, 48, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[263277, 8500, 195, 5, 43, "Input"],
Cell[263475, 8507, 492, 14, 96, "Output"]
}, Open  ]],
Cell[263982, 8524, 283, 8, 32, "Text"],
Cell[CellGroupData[{
Cell[264290, 8536, 165, 4, 43, "Input"],
Cell[264458, 8542, 241, 5, 55, "Output"]
}, Open  ]],
Cell[264714, 8550, 59, 0, 32, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[264822, 8556, 188, 3, 39, "Subsection",
 CellTags->"Ch8Ex1"],
Cell[265013, 8561, 219, 5, 32, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[265269, 8571, 188, 3, 39, "Subsection",
 CellTags->"Ch8Ex2"],
Cell[265460, 8576, 789, 28, 33, "Text"],
Cell[266252, 8606, 212, 7, 43, "Input"],
Cell[266467, 8615, 665, 25, 34, "Text"],
Cell[CellGroupData[{
Cell[267157, 8644, 129, 4, 45, "Input"],
Cell[267289, 8650, 194, 5, 58, "Output"]
}, Open  ]],
Cell[267498, 8658, 475, 17, 34, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[268010, 8680, 188, 3, 39, "Subsection",
 CellTags->"Ch8Ex3"],
Cell[268201, 8685, 70, 1, 32, "Text"],
Cell[268274, 8688, 219, 7, 45, "Input"],
Cell[268496, 8697, 235, 7, 45, "Input"],
Cell[268734, 8706, 65, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[268824, 8711, 256, 8, 57, "Input"],
Cell[269083, 8721, 159, 3, 38, "Output"]
}, Open  ]],
Cell[269257, 8727, 57, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[269339, 8732, 277, 8, 57, "Input"],
Cell[269619, 8742, 163, 3, 38, "Output"]
}, Open  ]],
Cell[269797, 8748, 58, 1, 32, "Text"],
Cell[269858, 8751, 171, 6, 33, "Text"],
Cell[270032, 8759, 585, 19, 84, "Input"],
Cell[270620, 8780, 56, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[270701, 8785, 283, 9, 43, "Input"],
Cell[270987, 8796, 235, 6, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[271259, 8807, 577, 19, 97, "Input"],
Cell[271839, 8828, 160, 3, 38, "Output"]
}, Open  ]],
Cell[272014, 8834, 74, 1, 32, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[272125, 8840, 171, 2, 39, "Subsection"],
Cell[272299, 8844, 752, 26, 126, "Text"],
Cell[273054, 8872, 405, 15, 33, "Text"],
Cell[273462, 8889, 1616, 53, 165, "Text"],
Cell[275081, 8944, 737, 26, 59, "Text"],
Cell[CellGroupData[{
Cell[275843, 8974, 61, 1, 44, "Subsubsection"],
Cell[275907, 8977, 222, 7, 43, "Input"],
Cell[276132, 8986, 804, 29, 101, "Input"],
Cell[276939, 9017, 135, 6, 33, "Text"],
Cell[CellGroupData[{
Cell[277099, 9027, 415, 15, 43, "Input"],
Cell[277517, 9044, 321, 9, 38, "Output"]
}, Open  ]],
Cell[277853, 9056, 91, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[277969, 9061, 231, 7, 45, "Input"],
Cell[278203, 9070, 228, 5, 41, "Output"]
}, Open  ]],
Cell[278446, 9078, 58, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[278529, 9083, 830, 24, 73, "Input"],
Cell[279362, 9109, 524, 18, 38, "Output"]
}, Open  ]],
Cell[279901, 9130, 229, 9, 33, "Text"],
Cell[CellGroupData[{
Cell[280155, 9143, 345, 9, 48, "Input"],
Cell[280503, 9154, 369, 9, 41, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[280909, 9168, 257, 7, 45, "Input"],
Cell[281169, 9177, 365, 9, 41, "Output"]
}, Open  ]],
Cell[281549, 9189, 297, 11, 33, "Text"],
Cell[CellGroupData[{
Cell[281871, 9204, 425, 11, 43, "Input"],
Cell[282299, 9217, 259, 7, 41, "Output"]
}, Open  ]],
Cell[282573, 9227, 297, 11, 33, "Text"],
Cell[CellGroupData[{
Cell[282895, 9242, 425, 11, 43, "Input"],
Cell[283323, 9255, 171, 3, 38, "Output"]
}, Open  ]],
Cell[283509, 9261, 132, 4, 32, "Text"],
Cell[CellGroupData[{
Cell[283666, 9269, 756, 23, 48, "Input"],
Cell[284425, 9294, 1185, 35, 65, "Output"]
}, Open  ]],
Cell[285625, 9332, 218, 9, 34, "Text"],
Cell[CellGroupData[{
Cell[285868, 9345, 309, 8, 48, "Input"],
Cell[286180, 9355, 252, 6, 41, "Output"]
}, Open  ]],
Cell[286447, 9364, 412, 12, 33, "Text"],
Cell[CellGroupData[{
Cell[286884, 9380, 675, 21, 48, "Input"],
Cell[287562, 9403, 1092, 32, 69, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[288691, 9440, 417, 11, 43, "Input"],
Cell[289111, 9453, 1612, 48, 119, "Output"]
}, Open  ]],
Cell[290738, 9504, 58, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[290821, 9509, 428, 13, 48, "Input"],
Cell[291252, 9524, 3923, 106, 141, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[295212, 9635, 148, 4, 43, "Input"],
Cell[295363, 9641, 1921, 53, 74, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[297321, 9699, 352, 10, 48, "Input"],
Cell[297676, 9711, 1199, 37, 57, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[298912, 9753, 299, 9, 48, "Input"],
Cell[299214, 9764, 260, 6, 41, "Output"]
}, Open  ]],
Cell[299489, 9773, 178, 6, 33, "Text"],
Cell[CellGroupData[{
Cell[299692, 9783, 488, 15, 48, "Input"],
Cell[300183, 9800, 544, 17, 57, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[300764, 9822, 592, 18, 48, "Input"],
Cell[301359, 9842, 159, 3, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[301555, 9850, 518, 16, 48, "Input"],
Cell[302076, 9868, 290, 8, 44, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[302403, 9881, 231, 7, 45, "Input"],
Cell[302637, 9890, 365, 10, 56, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[303063, 9907, 208, 5, 39, "Subsection",
 CellTags->"ExGlostenHarris"],
Cell[303274, 9914, 28, 0, 32, "Text"],
Cell[303305, 9916, 1018, 36, 101, "Input"],
Cell[304326, 9954, 228, 10, 33, "Text"],
Cell[CellGroupData[{
Cell[304579, 9968, 389, 13, 43, "Input"],
Cell[304971, 9983, 1328, 43, 73, "Output"]
}, Open  ]],
Cell[306314, 10029, 163, 7, 33, "Text"],
Cell[CellGroupData[{
Cell[306502, 10040, 888, 25, 73, "Input"],
Cell[307393, 10067, 831, 29, 38, "Output"]
}, Open  ]],
Cell[308239, 10099, 43, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[308307, 10103, 529, 17, 45, "Input"],
Cell[308839, 10122, 817, 24, 73, "Output"]
}, Open  ]],
Cell[309671, 10149, 127, 5, 33, "Text"],
Cell[CellGroupData[{
Cell[309823, 10158, 550, 17, 45, "Input"],
Cell[310376, 10177, 802, 24, 73, "Output"]
}, Open  ]],
Cell[311193, 10204, 70, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[311288, 10208, 296, 10, 43, "Input"],
Cell[311587, 10220, 1574, 49, 73, "Output"]
}, Open  ]],
Cell[313176, 10272, 378, 14, 33, "Text"],
Cell[CellGroupData[{
Cell[313579, 10290, 1553, 44, 98, "Input"],
Cell[315135, 10336, 2178, 65, 73, "Output"]
}, Open  ]],
Cell[317328, 10404, 469, 17, 33, "Text"],
Cell[317800, 10423, 103, 2, 43, "Input"],
Cell[317906, 10427, 330, 15, 37, "Text"],
Cell[CellGroupData[{
Cell[318261, 10446, 769, 24, 64, "Input"],
Cell[319033, 10472, 260, 8, 73, "Output"]
}, Open  ]],
Cell[319308, 10483, 56, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[319389, 10487, 1110, 33, 93, "Input"],
Cell[320502, 10522, 1255, 38, 117, "Output"]
}, Open  ]],
Cell[321772, 10563, 138, 5, 34, "Text"],
Cell[CellGroupData[{
Cell[321935, 10572, 840, 27, 46, "Input"],
Cell[322778, 10601, 611, 17, 73, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[323426, 10623, 114, 5, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[323565, 10632, 913, 25, 75, "Input"],
Cell[324481, 10659, 1152, 36, 127, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[325670, 10700, 457, 14, 43, "Input"],
Cell[326130, 10716, 724, 24, 73, "Output"]
}, Open  ]],
Cell[326869, 10743, 230, 10, 33, "Text"],
Cell[CellGroupData[{
Cell[327124, 10757, 179, 6, 48, "Input"],
Cell[327306, 10765, 1246, 37, 57, "Output"]
}, Open  ]],
Cell[328567, 10805, 136, 5, 34, "Text"],
Cell[CellGroupData[{
Cell[328728, 10814, 156, 4, 45, "Input"],
Cell[328887, 10820, 607, 17, 73, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[329543, 10843, 114, 5, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[329682, 10852, 823, 24, 71, "Input"],
Cell[330508, 10878, 1028, 32, 125, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[331573, 10915, 457, 14, 43, "Input"],
Cell[332033, 10931, 676, 23, 73, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[332746, 10959, 179, 6, 48, "Input"],
Cell[332928, 10967, 1212, 37, 57, "Output"]
}, Open  ]],
Cell[334155, 11007, 31, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[334211, 11011, 156, 4, 45, "Input"],
Cell[334370, 11017, 609, 17, 73, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[335040, 11041, 194, 5, 39, "Subsection",
 CellTags->"ExMRR"],
Cell[335237, 11048, 29, 0, 32, "Text"],
Cell[335269, 11050, 1052, 38, 129, "Input"],
Cell[336324, 11090, 256, 14, 33, "Text"],
Cell[CellGroupData[{
Cell[336605, 11108, 484, 16, 43, "Input"],
Cell[337092, 11126, 1236, 42, 93, "Output"]
}, Open  ]],
Cell[338343, 11171, 115, 5, 33, "Text"],
Cell[CellGroupData[{
Cell[338483, 11180, 869, 26, 73, "Input"],
Cell[339355, 11208, 496, 16, 38, "Output"]
}, Open  ]],
Cell[339866, 11227, 118, 5, 33, "Text"],
Cell[CellGroupData[{
Cell[340009, 11236, 487, 16, 45, "Input"],
Cell[340499, 11254, 757, 22, 55, "Output"]
}, Open  ]],
Cell[341271, 11279, 46, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[341342, 11283, 508, 16, 45, "Input"],
Cell[341853, 11301, 744, 22, 53, "Output"]
}, Open  ]],
Cell[342612, 11326, 96, 2, 43, "Input"],
Cell[342711, 11330, 152, 5, 33, "Text"],
Cell[CellGroupData[{
Cell[342888, 11339, 1020, 34, 43, "Input"],
Cell[343911, 11375, 1266, 39, 55, "Output"]
}, Open  ]],
Cell[345192, 11417, 335, 12, 33, "Text"],
Cell[CellGroupData[{
Cell[345552, 11433, 525, 17, 43, "Input"],
Cell[346080, 11452, 940, 28, 53, "Output"]
}, Open  ]],
Cell[347035, 11483, 19, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[347079, 11487, 474, 15, 43, "Input"],
Cell[347556, 11504, 853, 25, 53, "Output"]
}, Open  ]],
Cell[348424, 11532, 820, 25, 79, "Text"],
Cell[CellGroupData[{
Cell[349269, 11561, 514, 16, 43, "Input"],
Cell[349786, 11579, 765, 22, 69, "Output"]
}, Open  ]],
Cell[350566, 11604, 584, 20, 37, "Text"],
Cell[CellGroupData[{
Cell[351175, 11628, 452, 14, 48, "Input"],
Cell[351630, 11644, 1349, 39, 101, "Output"]
}, Open  ]],
Cell[352994, 11686, 312, 10, 34, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[353343, 11701, 213, 3, 39, "Subsection",
 CellTags->"ExGarman"],
Cell[353559, 11706, 88, 2, 32, "Text"],
Cell[353650, 11710, 292, 9, 45, "Input"],
Cell[353945, 11721, 76, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[354046, 11725, 157, 4, 43, "Input"],
Cell[354206, 11731, 291, 7, 41, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[354534, 11743, 173, 5, 43, "Input"],
Cell[354710, 11750, 2131, 41, 353, "Output"]
}, Open  ]],
Cell[356856, 11794, 63, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[356944, 11798, 176, 5, 43, "Input"],
Cell[357123, 11805, 261, 6, 41, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[357421, 11816, 52, 0, 44, "Subsubsection"],
Cell[CellGroupData[{
Cell[357498, 11820, 349, 11, 43, "Input"],
Cell[357850, 11833, 3966, 74, 368, "Output"]
}, Open  ]],
Cell[361831, 11910, 75, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[361931, 11914, 261, 8, 43, "Input"],
Cell[362195, 11924, 182, 3, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[362414, 11932, 149, 4, 43, "Input"],
Cell[362566, 11938, 182, 3, 38, "Output"]
}, Open  ]],
Cell[362763, 11944, 63, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[362851, 11948, 323, 11, 43, "Input"],
Cell[363177, 11961, 313, 8, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[363527, 11974, 199, 6, 43, "Input"],
Cell[363729, 11982, 185, 3, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[363951, 11990, 150, 4, 43, "Input"],
Cell[364104, 11996, 184, 3, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[364325, 12004, 150, 4, 43, "Input"],
Cell[364478, 12010, 182, 3, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[364697, 12018, 4047, 114, 247, "Input"],
Cell[368747, 12134, 5576, 112, 373, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[374384, 12253, 171, 2, 65, "Subsection",
 CellTags->"ExTradingStrategy"],
Cell[CellGroupData[{
Cell[374580, 12259, 39, 0, 44, "Subsubsection"],
Cell[374622, 12261, 1516, 53, 129, "Input"],
Cell[CellGroupData[{
Cell[376163, 12318, 485, 15, 43, "Input"],
Cell[376651, 12335, 1886, 49, 35, "Print"],
Cell[378540, 12386, 144, 2, 32, "Print"],
Cell[378687, 12390, 2060, 63, 85, "Print"],
Cell[380750, 12455, 131, 2, 32, "Print"],
Cell[380884, 12459, 2677, 80, 175, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[383598, 12544, 406, 12, 43, "Input"],
Cell[384007, 12558, 895, 30, 91, "Output"]
}, Open  ]],
Cell[384917, 12591, 158, 4, 33, "Text"],
Cell[CellGroupData[{
Cell[385100, 12599, 216, 7, 46, "Input"],
Cell[385319, 12608, 1013, 34, 143, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
