(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    246953,       7361]
NotebookOptionsPosition[    238299,       7103]
NotebookOutlinePosition[    241406,       7181]
CellTagsIndexPosition[    241363,       7178]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "TreesDemo\n",
 StyleBox["Empirical Market Microstructure",
  FontSlant->"Italic"],
 " \n\t(2006, Oxford University Press)\nCompanion ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook\n\nJoel Hasbrouck\n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Copyright", " ", "2007"}], ",", " ", 
    RowBox[{"Joel", " ", 
     RowBox[{"Hasbrouck", ".", " ", "All"}], " ", "rights", " ", 
     RowBox[{"reserved", "."}]}]}], TraditionalForm]],
  FontSize->14,
  FontSlant->"Italic"],
 "\n",
 StyleBox["This notebook illustrates the use of the Tree package to build, \
display and analyze trees used in sequential trade models.",
  FontSize->14]
}], "Title",
 CellChangeTimes->{{3.3896255910914*^9, 3.3896255932033997`*^9}, {
   3.3897167078988237`*^9, 3.389716768500824*^9}, 3.3897219191158237`*^9, {
   3.3897220399168243`*^9, 3.3897220640418243`*^9}, {3.389735393500024*^9, 
   3.389735431148024*^9}, 3.389735530878024*^9, 3.3897355723880243`*^9, {
   3.3907335831646*^9, 3.3907335836116*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Text", "  ", "@", " ", 
  RowBox[{"Style", "[", 
   RowBox[{
    RowBox[{"\"\<Notebook evaluated \>\"", "<>", 
     RowBox[{"DateString", "[", "\"\<DateTime\>\"", "]"}]}], ",", 
    "\"\<Subtitle\>\""}], "]"}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896127180972*^9, 3.3896127205282*^9}, 
   3.389716999411824*^9, {3.3897170351038237`*^9, 3.389717047196824*^9}}],

Cell[BoxData[
 InterpretationBox[Cell[BoxData[
   StyleBox["\<\"Notebook evaluated Monday 4 June 2007 20:12:55\"\>", 
    "Subtitle",
    StripOnInput->False]], "Text", "TR"],
  Text[
   Style["Notebook evaluated Monday 4 June 2007 20:12:55", 
    "Subtitle"]]]], "Output",
 CellMargins->{{18, Inherited}, {Inherited, 0}},
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896127211071997`*^9, {3.3896127536242*^9, 3.3896127555652*^9}, 
   3.3896128616452*^9, 3.389623031447*^9, 3.3896232934164*^9, 
   3.389716955274824*^9, 3.3897170008718243`*^9, {3.3897170377738237`*^9, 
   3.3897170482808237`*^9}, 3.389735230721224*^9, 3.3899894613552*^9, 
   3.3899897610886*^9, 3.3899911755866003`*^9},
 Background->RGBColor[0.866667, 0.733333, 1]]
}, Open  ]],

Cell["\<\
 A tree is represented as a multilevel list where the entries are expressions \
corresponding to nodes. For example:\
\>", "Text",
 CellAutoOverwrite->False,
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3881699046610003`*^9, 3.388169933311*^9}, {
   3.3882548246102*^9, 3.3882548580072002`*^9}, 3.3895516164884*^9, {
   3.3895516600774*^9, 3.3895516652953997`*^9}, {3.389735544315024*^9, 
   3.3897355659620237`*^9}}],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"{", "root", "}"}]]],
 " is a tree with one node (named '",
 Cell[BoxData["root"]],
 "') "
}], "BulletedList",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3881699046619997`*^9}],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"root", ",", "a1", ",", "a2"}], "}"}]]],
 " is a tree where ",
 Cell[BoxData["root"]],
 " can branch to ",
 Cell[BoxData["a1"]],
 " or ",
 Cell[BoxData["a2"]],
 ". "
}], "BulletedList",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904663*^9}],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"root", ",", 
    RowBox[{"{", 
     RowBox[{"a1", ",", "a11", ",", "a12"}], "}"}], ",", "a2"}], "}"}]]],
 ", the node at ",
 Cell[BoxData["a1"]],
 " can branch to ",
 Cell[BoxData["a11"]],
 " or ",
 Cell[BoxData["a12"]],
 "."
}], "BulletedList",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904663*^9}],

Cell[TextData[{
 "More formally, a tree is ",
 Cell[BoxData[
  RowBox[{"{", "node", "}"}]]],
 " where nodes may be iteratively defined as ",
 Cell[BoxData[
  RowBox[{"node", ":=", 
   RowBox[{"{", 
    RowBox[{"node1", ",", "...", ",", "nodeN"}], "}"}]}]]],
 ". You will usually build a tree by adding nodes that have meaningful \
symbols. Transition probabilities are contained in a multilevel list with the \
same structure as the tree, with the root node = 1; Total probabilities are \
similarly structured. "
}], "Text",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.388169904663*^9, {3.3895516689494*^9, 3.3895516798744*^9}}],

Cell[CellGroupData[{

Cell["Initialization", "Section",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904663*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "SetDirectory", "[", 
   "\"\<c:/Active/Empirical Market Microstructure/Mathematica/Spring \
2007\>\"", "]"}], ";"}]], "Input",
 CellAutoOverwrite->False,
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3881708634346*^9, 3.3881708734596*^9}, {
  3.3881710728336*^9, 3.3881711170716*^9}, {3.389524702079319*^9, 
  3.389524702676319*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{"<<", "Trees.m"}], "Input"]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.388169904663*^9, {3.3881702923915997`*^9, 3.3881702941376*^9}, {
   3.3881703726616*^9, 3.3881704180736*^9}, {3.3881705103336*^9, 
   3.3881705160986*^9}, {3.3881705548106003`*^9, 3.3881705699175997`*^9}, {
   3.3881711360826*^9, 3.3881711368436003`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example using a simple decision tree", "Section",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904664*^9}],

Cell["\<\
Here is a simple label tree for a sequential trade model in which value can \
be either low or high:\
\>", "Text",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904664*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LabelTree", "=", 
  RowBox[{"{", 
   RowBox[{"V", ",", "VLo", ",", "VHi"}], "}"}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904664*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"V", ",", "VLo", ",", "VHi"}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.388169904664*^9, 3.3881711437426*^9, {3.3881712369746*^9, 
   3.3881712469326*^9}, 3.3881713371864*^9, 3.388181935914*^9, {
   3.388182094722*^9, 3.388182096389*^9}, 3.3882549782962*^9, 
   3.3895506628656*^9, 3.3895507262066*^9, 3.3895509864404*^9, 
   3.3895517312354*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShowTree", "[", "LabelTree", "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904664*^9}],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      TagBox[GridBox[{
         {"V"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"VLo"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"VHi"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.35]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {{
         Offset[0.2]}}, "RowsIndexed" -> {}}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, TableAlignments -> {Left, Top}, TableSpacing -> {0.5, 0.5}]]],
  
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904664*^9, 3.3882549784042*^9, 3.3895509864774*^9, 
  3.3895517312754*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LabelTree", "=", 
  RowBox[{"LabelTree", "/.", 
   RowBox[{
    RowBox[{"x", ":", 
     RowBox[{"VLo", "|", "VHi"}]}], "\[RuleDelayed]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "Inf", ",", "U"}], "}"}]}]}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904664*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"V", ",", 
   RowBox[{"{", 
    RowBox[{"VLo", ",", "Inf", ",", "U"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"VHi", ",", "Inf", ",", "U"}], "}"}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904664*^9, 3.3882549784412003`*^9, 
  3.3895509865174*^9, 3.3895517313244*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShowTree", "[", "LabelTree", "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904665*^9}],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      TagBox[GridBox[{
         {"V"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"VLo"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"Inf"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"U"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"VHi"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"Inf"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"U"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.35]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {{
         Offset[0.2]}}, "RowsIndexed" -> {}}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, TableAlignments -> {Left, Top}, TableSpacing -> {0.5, 0.5}]]],
  
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904665*^9, 3.3882549784852*^9, 3.3895509865554*^9, 
  3.3895517313574*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LabelTree", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"LabelTree", "/.", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"VLo", ",", "Inf", ",", "a_"}], "}"}], "\[RuleDelayed]", 
      RowBox[{"{", 
       RowBox[{"VLo", ",", 
        RowBox[{"{", 
         RowBox[{"Inf", ",", "S"}], "}"}], ",", "a"}], "}"}]}]}], "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"VHi", ",", "Inf", ",", "a_"}], "}"}], "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"VHi", ",", 
       RowBox[{"{", 
        RowBox[{"Inf", ",", "B"}], "}"}], ",", "a"}], "}"}]}]}], "/.", 
   RowBox[{"U", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"U", ",", "B", ",", "S"}], "}"}]}]}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904665*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"V", ",", 
   RowBox[{"{", 
    RowBox[{"VLo", ",", 
     RowBox[{"{", 
      RowBox[{"Inf", ",", "S"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"U", ",", "B", ",", "S"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"VHi", ",", 
     RowBox[{"{", 
      RowBox[{"Inf", ",", "B"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"U", ",", "B", ",", "S"}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904665*^9, 3.3882549785212*^9, 
  3.3895509865903997`*^9, 3.3895517313943996`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShowTree", "[", "LabelTree", "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904665*^9}],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      TagBox[GridBox[{
         {"V"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"VLo"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"Inf"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"S"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"U"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"B"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"S"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"VHi"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"Inf"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"B"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"U"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"B"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"S"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.35]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {{
         Offset[0.2]}}, "RowsIndexed" -> {}}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, TableAlignments -> {Left, Top}, TableSpacing -> {0.5, 0.5}]]],
  
  DisplayForm]], "Output",
 CellChangeTimes->{3.3895509866434*^9, 3.3895517314424*^9},
 CellLabel->"Out[78]//DisplayForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transitional probabilities", "Subsection",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904665*^9}],

Cell["\<\
Now we'll construct the tree of transitional probabilities. Since this has \
the same form as the label tree, it is easiest to start with the label tree \
and replace the names of the nodes with the transition probabilities. To \
start, we put in the probabilities of uninformed buys and sells:\
\>", "Text",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904665*^9}],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      TagBox[GridBox[{
         {"V"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"VLo"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"Inf"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"S"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"U"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"B"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"S"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"VHi"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"Inf"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"B"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"U"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"B"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"S"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.35]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {{
         Offset[0.2]}}, "RowsIndexed" -> {}}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, TableAlignments -> {Left, Top}, TableSpacing -> {0.5, 0.5}]]],
  
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904665*^9, 3.3882549785892*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrTree", "=", 
  RowBox[{"LabelTree", "/.", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"U", ",", "B", ",", "S"}], "}"}], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"U", ",", 
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"1", "/", "2"}]}], "}"}]}]}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904665*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"V", ",", 
   RowBox[{"{", 
    RowBox[{"VLo", ",", 
     RowBox[{"{", 
      RowBox[{"Inf", ",", "S"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"U", ",", 
       FractionBox["1", "2"], ",", 
       FractionBox["1", "2"]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"VHi", ",", 
     RowBox[{"{", 
      RowBox[{"Inf", ",", "B"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"U", ",", 
       FractionBox["1", "2"], ",", 
       FractionBox["1", "2"]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904665*^9, 3.3882549786112003`*^9, 
  3.3895509866774*^9, 3.3895517314824*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShowTree", "[", "PrTree", "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904665*^9}],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      TagBox[GridBox[{
         {"V"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"VLo"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"Inf"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"S"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"U"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {
          FractionBox["1", "2"]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {
          FractionBox["1", "2"]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"VHi"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"Inf"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"B"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"U"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {
          FractionBox["1", "2"]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {
          FractionBox["1", "2"]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.35]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {{
         Offset[0.2]}}, "RowsIndexed" -> {}}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, TableAlignments -> {Left, Top}, TableSpacing -> {0.5, 0.5}]]],
  
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904665*^9, 3.3882549786642*^9, 
  3.3895509867144003`*^9, 3.3895517315204*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrTree", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"PrTree", "/.", 
         RowBox[{"S", "\[Rule]", "1"}]}], "/.", 
        RowBox[{"B", "\[Rule]", "1"}]}], "/.", 
       RowBox[{"Inf", "\[Rule]", "\[Mu]"}]}], "/.", 
      RowBox[{"U", "\[Rule]", 
       RowBox[{"1", "-", "\[Mu]"}]}]}], "/.", 
     RowBox[{"VLo", "\[Rule]", "\[Delta]"}]}], "/.", 
    RowBox[{"VHi", "\[Rule]", 
     RowBox[{"1", "-", "\[Delta]"}]}]}], "/.", 
   RowBox[{"V", "\[Rule]", "1"}]}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904665*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{"\[Delta]", ",", 
     RowBox[{"{", 
      RowBox[{"\[Mu]", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "-", "\[Mu]"}], ",", 
       FractionBox["1", "2"], ",", 
       FractionBox["1", "2"]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "-", "\[Delta]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Mu]", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "-", "\[Mu]"}], ",", 
       FractionBox["1", "2"], ",", 
       FractionBox["1", "2"]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904665*^9, 3.3882549786872*^9, 3.3895509867504*^9, 
  3.3895517315504*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShowTree", "[", "PrTree", "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904665*^9}],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      TagBox[GridBox[{
         {"1"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\[Delta]"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\[Mu]"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"1"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {
          RowBox[{"1", "-", "\[Mu]"}]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {
          FractionBox["1", "2"]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {
          FractionBox["1", "2"]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {
          RowBox[{"1", "-", "\[Delta]"}]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\[Mu]"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"1"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {
          RowBox[{"1", "-", "\[Mu]"}]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {
          FractionBox["1", "2"]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {
          FractionBox["1", "2"]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.35]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {{
         Offset[0.2]}}, "RowsIndexed" -> {}}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, TableAlignments -> {Left, Top}, TableSpacing -> {0.5, 0.5}]]],
  
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904666*^9, 3.3882549787651997`*^9, 
  3.3895509867883997`*^9, 3.3895517315864*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShowTree", "[", 
  RowBox[{"LabelTree", ",", "PrTree"}], "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904666*^9}],

Cell[BoxData[
 TagBox[
  InterpretationBox[GridBox[{
     {
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"V"},
           {"1"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"VLo"},
           {"\[Delta]"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"Inf"},
           {"\[Mu]"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {"1"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"U"},
           {
            RowBox[{"1", "-", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {
            FractionBox["1", "2"]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {
            FractionBox["1", "2"]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"VHi"},
           {
            RowBox[{"1", "-", "\[Delta]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"Inf"},
           {"\[Mu]"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {"1"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"U"},
           {
            RowBox[{"1", "-", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {
            FractionBox["1", "2"]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {
            FractionBox["1", "2"]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.35]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {{
         Offset[0.2]}}, "RowsIndexed" -> {}}],
   TableForm[{{
      FrameBox[
       TableForm[{$CellContext`V, 1}]], 
      FrameBox[
       TableForm[{$CellContext`VLo, $CellContext`\[Delta]}]], 
      FrameBox[
       TableForm[{$CellContext`Inf, $CellContext`\[Mu]}]], 
      FrameBox[
       TableForm[{$CellContext`S, 1}]]}, {{" ", " "}, {" ", " "}, 
      FrameBox[
       TableForm[{$CellContext`U, 1 - $CellContext`\[Mu]}]], 
      FrameBox[
       TableForm[{$CellContext`B, 
         Rational[1, 2]}]]}, {{" ", " "}, {" ", " "}, {" ", " "}, 
      FrameBox[
       TableForm[{$CellContext`S, 
         Rational[1, 2]}]]}, {{" ", " "}, 
      FrameBox[
       TableForm[{$CellContext`VHi, 1 - $CellContext`\[Delta]}]], 
      FrameBox[
       TableForm[{$CellContext`Inf, $CellContext`\[Mu]}]], 
      FrameBox[
       TableForm[{$CellContext`B, 1}]]}, {{" ", " "}, {" ", " "}, 
      FrameBox[
       TableForm[{$CellContext`U, 1 - $CellContext`\[Mu]}]], 
      FrameBox[
       TableForm[{$CellContext`B, 
         Rational[1, 2]}]]}, {{" ", " "}, {" ", " "}, {" ", " "}, 
      FrameBox[
       TableForm[{$CellContext`S, 
         Rational[1, 2]}]]}}, TableAlignments -> {Left, Top}, 
    TableSpacing -> {0.5, 0.5}]],
  DisplayForm]], "Output",
 CellChangeTimes->{3.3895509868344*^9, 3.3895517316434*^9},
 CellLabel->"Out[83]//DisplayForm="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Total probabilities", "Subsection",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904666*^9}],

Cell[TextData[{
 "The ",
 Cell[BoxData["PrTotal"]],
 " function takes the transitional probabilities and returns a tree with \
total probabilities:"
}], "Text",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904666*^9}],

Cell[BoxData[
 TagBox[
  InterpretationBox[GridBox[{
     {
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"V"},
           {"1"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"VLo"},
           {"\[Delta]"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"Inf"},
           {"\[Mu]"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {"1"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"U"},
           {
            RowBox[{"1", "-", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {
            FractionBox["1", "2"]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {
            FractionBox["1", "2"]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"VHi"},
           {
            RowBox[{"1", "-", "\[Delta]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"Inf"},
           {"\[Mu]"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {"1"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"U"},
           {
            RowBox[{"1", "-", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {
            FractionBox["1", "2"]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {
            FractionBox["1", "2"]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.35]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {{
         Offset[0.2]}}, "RowsIndexed" -> {}}],
   TableForm[{{
      FrameBox[
       TableForm[{$CellContext`V, 1}]], 
      FrameBox[
       TableForm[{$CellContext`VLo, $CellContext`\[Delta]}]], 
      FrameBox[
       TableForm[{$CellContext`Inf, $CellContext`\[Mu]}]], 
      FrameBox[
       TableForm[{$CellContext`S, 1}]]}, {{" ", " "}, {" ", " "}, 
      FrameBox[
       TableForm[{$CellContext`U, 1 - $CellContext`\[Mu]}]], 
      FrameBox[
       TableForm[{$CellContext`B, 
         Rational[1, 2]}]]}, {{" ", " "}, {" ", " "}, {" ", " "}, 
      FrameBox[
       TableForm[{$CellContext`S, 
         Rational[1, 2]}]]}, {{" ", " "}, 
      FrameBox[
       TableForm[{$CellContext`VHi, 1 - $CellContext`\[Delta]}]], 
      FrameBox[
       TableForm[{$CellContext`Inf, $CellContext`\[Mu]}]], 
      FrameBox[
       TableForm[{$CellContext`B, 1}]]}, {{" ", " "}, {" ", " "}, 
      FrameBox[
       TableForm[{$CellContext`U, 1 - $CellContext`\[Mu]}]], 
      FrameBox[
       TableForm[{$CellContext`B, 
         Rational[1, 2]}]]}, {{" ", " "}, {" ", " "}, {" ", " "}, 
      FrameBox[
       TableForm[{$CellContext`S, 
         Rational[1, 2]}]]}}, TableAlignments -> {Left, Top}, 
    TableSpacing -> {0.5, 0.5}]],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904666*^9, 3.3882549788462*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PrTotal", "[", "PrTree", "]"}], "//", "ShowTree"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904666*^9}],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      TagBox[GridBox[{
         {"1"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\[Delta]"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {
          RowBox[{"\[Delta]", " ", "\[Mu]"}]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {
          RowBox[{"\[Delta]", " ", "\[Mu]"}]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {
          RowBox[{"\[Delta]", " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {
          RowBox[{
           FractionBox["1", "2"], " ", "\[Delta]", " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {
          RowBox[{
           FractionBox["1", "2"], " ", "\[Delta]", " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {
          RowBox[{"1", "-", "\[Delta]"}]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", "\[Mu]"}]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", "\[Mu]"}]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {
          RowBox[{
           FractionBox["1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]},
     {
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {"\<\" \"\>"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column], 
      TagBox[GridBox[{
         {
          RowBox[{
           FractionBox["1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.5599999999999999]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Column]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.35]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {{
         Offset[0.2]}}, "RowsIndexed" -> {}}],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, TableAlignments -> {Left, Top}, TableSpacing -> {0.5, 0.5}]]],
  
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904666*^9, 3.3882549788942003`*^9, 
  3.3895509868943996`*^9, 3.3895517317033997`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BasicTree", "=", 
  RowBox[{"BuildTree", "[", 
   RowBox[{"LabelTree", ",", "PrTree"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904666*^9}],

Cell[BoxData[
 RowBox[{"Trees`Private`Tree", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"V", ",", 
     RowBox[{"{", 
      RowBox[{"VLo", ",", 
       RowBox[{"{", 
        RowBox[{"Inf", ",", "S"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"U", ",", "B", ",", "S"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"VHi", ",", 
       RowBox[{"{", 
        RowBox[{"Inf", ",", "B"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"U", ",", "B", ",", "S"}], "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"\[Delta]", ",", 
       RowBox[{"{", 
        RowBox[{"\[Mu]", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "-", "\[Mu]"}], ",", 
         FractionBox["1", "2"], ",", 
         FractionBox["1", "2"]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "-", "\[Delta]"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Mu]", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "-", "\[Mu]"}], ",", 
         FractionBox["1", "2"], ",", 
         FractionBox["1", "2"]}], "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"\[Delta]", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\[Delta]", " ", "\[Mu]"}], ",", 
         RowBox[{"\[Delta]", " ", "\[Mu]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\[Delta]", " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", "\[Mu]"}], ")"}]}], ",", 
         RowBox[{
          FractionBox["1", "2"], " ", "\[Delta]", " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", "\[Mu]"}], ")"}]}], ",", 
         RowBox[{
          FractionBox["1", "2"], " ", "\[Delta]", " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "-", "\[Delta]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", "\[Mu]"}], ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", "\[Mu]"}]}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", "\[Mu]"}], ")"}]}], ",", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", "\[Mu]"}], ")"}]}], ",", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}], "}"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904666*^9, 3.3882549789212*^9, 3.3895509869284*^9, 
  3.3895517317374*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShowTree", "[", "BasicTree", "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904666*^9}],

Cell[BoxData[
 TagBox[
  InterpretationBox[GridBox[{
     {
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"V"},
           {"1"},
           {"1"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"VLo"},
           {"\[Delta]"},
           {"\[Delta]"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"Inf"},
           {"\[Mu]"},
           {
            RowBox[{"\[Delta]", " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {"1"},
           {
            RowBox[{"\[Delta]", " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"U"},
           {
            RowBox[{"1", "-", "\[Mu]"}]},
           {
            RowBox[{"\[Delta]", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {
            FractionBox["1", "2"]},
           {
            RowBox[{
             FractionBox["1", "2"], " ", "\[Delta]", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {
            FractionBox["1", "2"]},
           {
            RowBox[{
             FractionBox["1", "2"], " ", "\[Delta]", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"VHi"},
           {
            RowBox[{"1", "-", "\[Delta]"}]},
           {
            RowBox[{"1", "-", "\[Delta]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"Inf"},
           {"\[Mu]"},
           {
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {"1"},
           {
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"U"},
           {
            RowBox[{"1", "-", "\[Mu]"}]},
           {
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {
            FractionBox["1", "2"]},
           {
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {
            FractionBox["1", "2"]},
           {
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.35]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {{
         Offset[0.2]}}, "RowsIndexed" -> {}}],
   TableForm[{{
      FrameBox[
       TableForm[{$CellContext`V, 1, 1}]], 
      FrameBox[
       TableForm[{$CellContext`VLo, $CellContext`\[Delta], $CellContext`\
\[Delta]}]], 
      FrameBox[
       TableForm[{$CellContext`Inf, $CellContext`\[Mu], $CellContext`\[Delta] \
$CellContext`\[Mu]}]], 
      FrameBox[
       TableForm[{$CellContext`S, 
         1, $CellContext`\[Delta] $CellContext`\[Mu]}]]}, {{" ", " ", " "}, {
      " ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`U, 
         1 - $CellContext`\[Mu], $CellContext`\[Delta] (
          1 - $CellContext`\[Mu])}]], 
      FrameBox[
       TableForm[{$CellContext`B, 
         Rational[1, 2], 
         Rational[1, 2] $CellContext`\[Delta] (1 - $CellContext`\[Mu])}]]}, {{
      " ", " ", " "}, {" ", " ", " "}, {" ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`S, 
         Rational[1, 2], 
         Rational[1, 2] $CellContext`\[Delta] (1 - $CellContext`\[Mu])}]]}, {{
      " ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`VHi, 1 - $CellContext`\[Delta], 
         1 - $CellContext`\[Delta]}]], 
      FrameBox[
       TableForm[{$CellContext`Inf, $CellContext`\[Mu], (
          1 - $CellContext`\[Delta]) $CellContext`\[Mu]}]], 
      FrameBox[
       TableForm[{$CellContext`B, 
         1, (1 - $CellContext`\[Delta]) $CellContext`\[Mu]}]]}, {{
      " ", " ", " "}, {" ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`U, 
         1 - $CellContext`\[Mu], (1 - $CellContext`\[Delta]) (
          1 - $CellContext`\[Mu])}]], 
      FrameBox[
       TableForm[{$CellContext`B, 
         Rational[1, 2], 
         Rational[1, 2] (1 - $CellContext`\[Delta]) (
          1 - $CellContext`\[Mu])}]]}, {{" ", " ", " "}, {" ", " ", " "}, {
      " ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`S, 
         Rational[1, 2], 
         Rational[1, 2] (1 - $CellContext`\[Delta]) (
          1 - $CellContext`\[Mu])}]]}}, TableAlignments -> {Left, Top}, 
    TableSpacing -> {0.5, 0.5}]],
  DisplayForm]], "Output",
 CellChangeTimes->{3.3895509869784*^9, 3.3895517317974*^9},
 CellLabel->"Out[86]//DisplayForm="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Joint and conditional probabilities", "Subsection",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904667*^9}],

Cell[TextData[{
 "The ",
 Cell[BoxData["Pr"]],
 " function may be used to obtain the total probability of a particular \
node:"
}], "Text",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904667*^9}],

Cell[BoxData[
 TagBox[
  InterpretationBox[GridBox[{
     {
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"V"},
           {"1"},
           {"1"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"VLo"},
           {"\[Delta]"},
           {"\[Delta]"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"Inf"},
           {"\[Mu]"},
           {
            RowBox[{"\[Delta]", " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {"1"},
           {
            RowBox[{"\[Delta]", " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"U"},
           {
            RowBox[{"1", "-", "\[Mu]"}]},
           {
            RowBox[{"\[Delta]", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {
            FractionBox["1", "2"]},
           {
            RowBox[{
             FractionBox["1", "2"], " ", "\[Delta]", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {
            FractionBox["1", "2"]},
           {
            RowBox[{
             FractionBox["1", "2"], " ", "\[Delta]", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"VHi"},
           {
            RowBox[{"1", "-", "\[Delta]"}]},
           {
            RowBox[{"1", "-", "\[Delta]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"Inf"},
           {"\[Mu]"},
           {
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {"1"},
           {
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"U"},
           {
            RowBox[{"1", "-", "\[Mu]"}]},
           {
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {
            FractionBox["1", "2"]},
           {
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {
            FractionBox["1", "2"]},
           {
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.35]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {{
         Offset[0.2]}}, "RowsIndexed" -> {}}],
   TableForm[{{
      FrameBox[
       TableForm[{$CellContext`V, 1, 1}]], 
      FrameBox[
       TableForm[{$CellContext`VLo, $CellContext`\[Delta], $CellContext`\
\[Delta]}]], 
      FrameBox[
       TableForm[{$CellContext`Inf, $CellContext`\[Mu], $CellContext`\[Delta] \
$CellContext`\[Mu]}]], 
      FrameBox[
       TableForm[{$CellContext`S, 
         1, $CellContext`\[Delta] $CellContext`\[Mu]}]]}, {{" ", " ", " "}, {
      " ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`U, 
         1 - $CellContext`\[Mu], $CellContext`\[Delta] (
          1 - $CellContext`\[Mu])}]], 
      FrameBox[
       TableForm[{$CellContext`B, 
         Rational[
         1, 2], (Rational[1, 2] $CellContext`\[Delta]) (
          1 - $CellContext`\[Mu])}]]}, {{" ", " ", " "}, {" ", " ", " "}, {
      " ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`S, 
         Rational[
         1, 2], (Rational[1, 2] $CellContext`\[Delta]) (
          1 - $CellContext`\[Mu])}]]}, {{" ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`VHi, 1 - $CellContext`\[Delta], 
         1 - $CellContext`\[Delta]}]], 
      FrameBox[
       TableForm[{$CellContext`Inf, $CellContext`\[Mu], (
          1 - $CellContext`\[Delta]) $CellContext`\[Mu]}]], 
      FrameBox[
       TableForm[{$CellContext`B, 
         1, (1 - $CellContext`\[Delta]) $CellContext`\[Mu]}]]}, {{
      " ", " ", " "}, {" ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`U, 
         1 - $CellContext`\[Mu], (1 - $CellContext`\[Delta]) (
          1 - $CellContext`\[Mu])}]], 
      FrameBox[
       TableForm[{$CellContext`B, 
         Rational[
         1, 2], (Rational[1, 2] (1 - $CellContext`\[Delta])) (
          1 - $CellContext`\[Mu])}]]}, {{" ", " ", " "}, {" ", " ", " "}, {
      " ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`S, 
         Rational[
         1, 2], (Rational[1, 2] (1 - $CellContext`\[Delta])) (
          1 - $CellContext`\[Mu])}]]}}, TableAlignments -> {Left, Top}, 
    TableSpacing -> {0.5, 0.5}]],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904666*^9, 3.3882549789952*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Pr", "[", 
  RowBox[{"BasicTree", ",", "VLo"}], "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904667*^9}],

Cell[BoxData["\[Delta]"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904667*^9, 3.3882549790362*^9, 
  3.3895509870304003`*^9, 3.3895517318444*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Pr", "[", 
  RowBox[{"BasicTree", ",", "S"}], "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904667*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", "\[Mu]"}], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", "\[Delta]", " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", "\[Mu]"}], ")"}]}], "+", 
  RowBox[{"\[Delta]", " ", "\[Mu]"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904667*^9, 3.3882549790582*^9, 3.3895509870604*^9, 
  3.3895517318744*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShowTree", "[", "BasicTree", "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904667*^9}],

Cell[BoxData[
 TagBox[
  InterpretationBox[GridBox[{
     {
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"V"},
           {"1"},
           {"1"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"VLo"},
           {"\[Delta]"},
           {"\[Delta]"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"Inf"},
           {"\[Mu]"},
           {
            RowBox[{"\[Delta]", " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {"1"},
           {
            RowBox[{"\[Delta]", " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"U"},
           {
            RowBox[{"1", "-", "\[Mu]"}]},
           {
            RowBox[{"\[Delta]", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {
            FractionBox["1", "2"]},
           {
            RowBox[{
             FractionBox["1", "2"], " ", "\[Delta]", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {
            FractionBox["1", "2"]},
           {
            RowBox[{
             FractionBox["1", "2"], " ", "\[Delta]", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"VHi"},
           {
            RowBox[{"1", "-", "\[Delta]"}]},
           {
            RowBox[{"1", "-", "\[Delta]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"Inf"},
           {"\[Mu]"},
           {
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {"1"},
           {
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", "\[Mu]"}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"U"},
           {
            RowBox[{"1", "-", "\[Mu]"}]},
           {
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {
            FractionBox["1", "2"]},
           {
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {
            FractionBox["1", "2"]},
           {
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.35]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {{
         Offset[0.2]}}, "RowsIndexed" -> {}}],
   TableForm[{{
      FrameBox[
       TableForm[{$CellContext`V, 1, 1}]], 
      FrameBox[
       TableForm[{$CellContext`VLo, $CellContext`\[Delta], $CellContext`\
\[Delta]}]], 
      FrameBox[
       TableForm[{$CellContext`Inf, $CellContext`\[Mu], $CellContext`\[Delta] \
$CellContext`\[Mu]}]], 
      FrameBox[
       TableForm[{$CellContext`S, 
         1, $CellContext`\[Delta] $CellContext`\[Mu]}]]}, {{" ", " ", " "}, {
      " ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`U, 
         1 - $CellContext`\[Mu], $CellContext`\[Delta] (
          1 - $CellContext`\[Mu])}]], 
      FrameBox[
       TableForm[{$CellContext`B, 
         Rational[1, 2], 
         Rational[1, 2] $CellContext`\[Delta] (1 - $CellContext`\[Mu])}]]}, {{
      " ", " ", " "}, {" ", " ", " "}, {" ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`S, 
         Rational[1, 2], 
         Rational[1, 2] $CellContext`\[Delta] (1 - $CellContext`\[Mu])}]]}, {{
      " ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`VHi, 1 - $CellContext`\[Delta], 
         1 - $CellContext`\[Delta]}]], 
      FrameBox[
       TableForm[{$CellContext`Inf, $CellContext`\[Mu], (
          1 - $CellContext`\[Delta]) $CellContext`\[Mu]}]], 
      FrameBox[
       TableForm[{$CellContext`B, 
         1, (1 - $CellContext`\[Delta]) $CellContext`\[Mu]}]]}, {{
      " ", " ", " "}, {" ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`U, 
         1 - $CellContext`\[Mu], (1 - $CellContext`\[Delta]) (
          1 - $CellContext`\[Mu])}]], 
      FrameBox[
       TableForm[{$CellContext`B, 
         Rational[1, 2], 
         Rational[1, 2] (1 - $CellContext`\[Delta]) (
          1 - $CellContext`\[Mu])}]]}, {{" ", " ", " "}, {" ", " ", " "}, {
      " ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`S, 
         Rational[1, 2], 
         Rational[1, 2] (1 - $CellContext`\[Delta]) (
          1 - $CellContext`\[Mu])}]]}}, TableAlignments -> {Left, Top}, 
    TableSpacing -> {0.5, 0.5}]],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904667*^9, 3.3882549791312*^9, 
  3.3895509871233997`*^9, 3.3895517319364*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Pr", "[", 
   RowBox[{"BasicTree", ",", "S"}], "]"}], "+", 
  RowBox[{"Pr", "[", 
   RowBox[{"BasicTree", ",", "B"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904667*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", "\[Mu]"}], ")"}]}], "+", 
  RowBox[{"\[Delta]", " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", "\[Mu]"}], ")"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", "\[Mu]"}], "+", 
  RowBox[{"\[Delta]", " ", "\[Mu]"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904667*^9, 3.3882549791542*^9, 
  3.3895509871554003`*^9, 3.3895517319684*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Simplify"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904667*^9}],

Cell[BoxData["1"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904667*^9, 3.3882549792242002`*^9, 
  3.3895509871904*^9, 3.3895517320004*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Pr", "[", 
   RowBox[{"BasicTree", ",", "VLo", ",", "B"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904667*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "2"]}], " ", "\[Delta]", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "\[Mu]"}], ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904667*^9, 3.3882549792692003`*^9, 
  3.3895509872234*^9, 3.3895517320444*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Pr", "[", 
  RowBox[{"BasicTree", ",", "VLo", ",", "Inf", ",", "B"}], "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904667*^9}],

Cell[BoxData["0"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904668*^9, 3.3882549792872*^9, 
  3.3895509872553997`*^9, 3.3895517320854*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Pr", "[", 
  RowBox[{"BasicTree", ",", "VLo", ",", "Inf", ",", "S"}], "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904668*^9}],

Cell[BoxData[
 RowBox[{"\[Delta]", " ", "\[Mu]"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904668*^9, 3.3882549793052*^9, 
  3.3895509872874002`*^9, 3.3895517321174*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Pr", "[", 
   RowBox[{"BasicTree", ",", "VLo", ",", "B"}], "]"}], "/", 
  RowBox[{"Pr", "[", 
   RowBox[{"BasicTree", ",", "B"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904668*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[Delta]", " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", "\[Mu]"}], ")"}]}], 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "\[Mu]"}], ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", "\[Delta]", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "\[Mu]"}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", "\[Mu]"}]}], 
    ")"}]}]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904668*^9, 3.3882549793501997`*^9, 
  3.3895509873184*^9, 3.3895517321624002`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Simplify"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904668*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[Delta]", "-", 
   RowBox[{"\[Delta]", " ", "\[Mu]"}]}], 
  RowBox[{"1", "+", "\[Mu]", "-", 
   RowBox[{"2", " ", "\[Delta]", " ", "\[Mu]"}]}]]], "Output",
 CellChangeTimes->{3.3895509873604*^9, 3.3895517321954*^9},
 CellLabel->"Out[96]="]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Additional routines", "Section",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904668*^9}],

Cell[CellGroupData[{

Cell["Checking conformance of tree structures", "Subsubsection",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904668*^9}],

Cell[TextData[{
 "Sometimes when you're building up label transitional probability trees, \
it's difficult to verify that they have the same list structure. You can do \
this verification with ",
 Cell[BoxData["CheckConformance"]],
 ":"
}], "Text",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904668*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[Delta]", "-", 
   RowBox[{"\[Delta]", " ", "\[Mu]"}]}], 
  RowBox[{"1", "+", "\[Mu]", "-", 
   RowBox[{"2", " ", "\[Delta]", " ", "\[Mu]"}]}]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904668*^9, 3.3882549794231997`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckConformance", "[", 
  RowBox[{"LabelTree", ",", "PrTree"}], "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.388169904668*^9}],

Cell[BoxData["True"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3881699046689997`*^9, 3.3895509874374*^9, 
  3.3895517322293997`*^9}]
}, Open  ]],

Cell[TextData[{
 "For example, here's a different label tree, one that doesn't conform to ",
 Cell[BoxData["PrTree"]],
 "."
}], "Text",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3881699046689997`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BadLabelTree", "=", 
  RowBox[{"LabelTree", "/.", 
   RowBox[{"Inf", "->", 
    RowBox[{"{", "Inf", "}"}]}]}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3881699046689997`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"V", ",", 
   RowBox[{"{", 
    RowBox[{"VLo", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "Inf", "}"}], ",", "S"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"U", ",", "B", ",", "S"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"VHi", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "Inf", "}"}], ",", "B"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"U", ",", "B", ",", "S"}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3881699046689997`*^9, 3.3895509874684*^9, 
  3.3895517322634*^9}]
}, Open  ]],

Cell[TextData[{
 "In this case, ",
 Cell[BoxData["CheckConformance"]],
 " highlights the first"
}], "Text",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3881699046689997`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckConformance", "[", 
  RowBox[{"BadLabelTree", ",", "PrTree"}], "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3881699046689997`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CheckConformance. First list mismatch at \"\>", 
   "\[InvisibleSpace]", "1"}],
  SequenceForm["CheckConformance. First list mismatch at ", 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.3895517322994003`*^9},
 CellLabel->"During evaluation of In[99]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Tree \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "1"}], "}"}]}],
  SequenceForm["Tree ", 1, " ", {2, 2, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.3895517323024*^9},
 CellLabel->"During evaluation of In[99]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "Inf", "}"}], ",", "S"}], "}"}]], "Print",
 CellChangeTimes->{3.3895517323034*^9},
 CellLabel->"During evaluation of In[99]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Tree \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Tree ", 2, " ", {2, 2}],
  Editable->False]], "Print",
 CellChangeTimes->{3.3895517323054*^9},
 CellLabel->"During evaluation of In[99]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Delta]", ",", 
   RowBox[{"{", 
    RowBox[{"\[Mu]", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "-", "\[Mu]"}], ",", 
     FractionBox["1", "2"], ",", 
     FractionBox["1", "2"]}], "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.3895517323064003`*^9},
 CellLabel->"During evaluation of In[99]:="],

Cell[BoxData["$Aborted"], "Output",
 CellChangeTimes->{3.3895509875144*^9, 3.3895517323084*^9},
 CellLabel->"Out[99]="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Delta]", ",", 
   RowBox[{"{", 
    RowBox[{"\[Mu]", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "-", "\[Mu]"}], ",", 
     FractionBox["1", "2"], ",", 
     FractionBox["1", "2"]}], "}"}]}], "}"}]], "Print",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3881699046689997`*^9, 3.3895509875114*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Tree \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Tree ", 2, " ", {2, 2}],
  Editable->False]], "Print",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3881699046689997`*^9, 3.3895509875094*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "Inf", "}"}], ",", "S"}], "}"}]], "Print",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3881699046689997`*^9, 3.3895509875084*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Tree \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "1"}], "}"}]}],
  SequenceForm["Tree ", 1, " ", {2, 2, 1}],
  Editable->False]], "Print",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3881699046689997`*^9, 3.3895509875064*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CheckConformance. First list mismatch at \"\>", 
   "\[InvisibleSpace]", "1"}],
  SequenceForm["CheckConformance. First list mismatch at ", 1],
  Editable->False]], "Print",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3881699046689997`*^9, 3.3895509875044003`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"CheckConformance. First list mismatch at \"\>", 
   "\[InvisibleSpace]", "1"}],
  SequenceForm["CheckConformance. First list mismatch at ", 1],
  Editable->False]], "Print",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3881699046689997`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Tree \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "1"}], "}"}]}],
  SequenceForm["Tree ", 1, " ", {2, 2, 1}],
  Editable->False]], "Print",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3881699046689997`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "Inf", "}"}], ",", "S"}], "}"}]], "Print",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3881699046689997`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Tree \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Tree ", 2, " ", {2, 2}],
  Editable->False]], "Print",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3881699046689997`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Delta]", ",", 
   RowBox[{"{", 
    RowBox[{"\[Mu]", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "-", "\[Mu]"}], ",", 
     FractionBox["1", "2"], ",", 
     FractionBox["1", "2"]}], "}"}]}], "}"}]], "Print",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3881699046689997`*^9}],

Cell[BoxData["$Aborted"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3881699046689997`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Marked trees", "Subsubsection",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3881699046689997`*^9}],

Cell[TextData[{
 "Sometimes we'd like to display a tree with certain nodes prominently \
marked. Here is the ",
 Cell[BoxData["LabelTree"]],
 ", with ",
 Cell[BoxData["S"]],
 " nodes marked:"
}], "Text",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3881699046689997`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShowTree", "[", 
  RowBox[{"LabelTree", ",", 
   RowBox[{"MarkedTree", "[", 
    RowBox[{"LabelTree", ",", "S"}], "]"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.38816990467*^9}],

Cell[BoxData[
 TagBox[
  InterpretationBox[GridBox[{
     {
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"V"},
           {"\<\"\"\>"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"VLo"},
           {"\<\"\"\>"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"Inf"},
           {"\<\"\"\>"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {"\<\"\\!\\(\\*\\nStyleBox[\\\"\[FivePointedStar]\[FivePointedStar]\
\[FivePointedStar]\\\",\\nFontSize->16,\\nFontColor->RGBColor[1, 0, \
0]]\\)\"\>"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"U"},
           {"\<\"\"\>"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {"\<\"\"\>"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {"\<\"\\!\\(\\*\\nStyleBox[\\\"\[FivePointedStar]\[FivePointedStar]\
\[FivePointedStar]\\\",\\nFontSize->16,\\nFontColor->RGBColor[1, 0, \
0]]\\)\"\>"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"VHi"},
           {"\<\"\"\>"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"Inf"},
           {"\<\"\"\>"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {"\<\"\"\>"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"U"},
           {"\<\"\"\>"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {"\<\"\"\>"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {"\<\"\\!\\(\\*\\nStyleBox[\\\"\[FivePointedStar]\[FivePointedStar]\
\[FivePointedStar]\\\",\\nFontSize->16,\\nFontColor->RGBColor[1, 0, \
0]]\\)\"\>"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.35]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {{
         Offset[0.2]}}, "RowsIndexed" -> {}}],
   TableForm[{{
      FrameBox[
       TableForm[{$CellContext`V, ""}]], 
      FrameBox[
       TableForm[{$CellContext`VLo, ""}]], 
      FrameBox[
       TableForm[{$CellContext`Inf, ""}]], 
      FrameBox[
       TableForm[{$CellContext`S, 
         "\!\(\*\nStyleBox[\"\[FivePointedStar]\[FivePointedStar]\
\[FivePointedStar]\",\nFontSize->16,\nFontColor->RGBColor[1, 0, 0]]\)"}]]}, {{
      " ", " "}, {" ", " "}, 
      FrameBox[
       TableForm[{$CellContext`U, ""}]], 
      FrameBox[
       TableForm[{$CellContext`B, ""}]]}, {{" ", " "}, {" ", " "}, {" ", " "},
       
      FrameBox[
       TableForm[{$CellContext`S, 
         "\!\(\*\nStyleBox[\"\[FivePointedStar]\[FivePointedStar]\
\[FivePointedStar]\",\nFontSize->16,\nFontColor->RGBColor[1, 0, 0]]\)"}]]}, {{
      " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`VHi, ""}]], 
      FrameBox[
       TableForm[{$CellContext`Inf, ""}]], 
      FrameBox[
       TableForm[{$CellContext`B, ""}]]}, {{" ", " "}, {" ", " "}, 
      FrameBox[
       TableForm[{$CellContext`U, ""}]], 
      FrameBox[
       TableForm[{$CellContext`B, ""}]]}, {{" ", " "}, {" ", " "}, {" ", " "},
       
      FrameBox[
       TableForm[{$CellContext`S, 
         "\!\(\*\nStyleBox[\"\[FivePointedStar]\[FivePointedStar]\
\[FivePointedStar]\",\nFontSize->16,\nFontColor->RGBColor[1, 0, 0]]\)"}]]}}, 
    TableAlignments -> {Left, Top}, TableSpacing -> {0.5, 0.5}]],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.38816990467*^9, 3.3895509875694*^9, 3.3895517323624*^9}]
}, Open  ]],

Cell["Here is the tree with \"buy\" nodes marked:", "Text",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.38816990467*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MarkedTree", "[", 
   RowBox[{"BasicTree", ",", "B"}], "]"}], "//", "ShowTree"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.38816990467*^9}],

Cell[BoxData[
 TagBox[
  InterpretationBox[GridBox[{
     {
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"V"},
           {"1"},
           {"1"},
           {"\<\"\"\>"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"VLo"},
           {"\[Delta]"},
           {"\[Delta]"},
           {"\<\"\"\>"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"Inf"},
           {"\[Mu]"},
           {
            RowBox[{"\[Delta]", " ", "\[Mu]"}]},
           {"\<\"\"\>"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {"1"},
           {
            RowBox[{"\[Delta]", " ", "\[Mu]"}]},
           {"\<\"\"\>"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"U"},
           {
            RowBox[{"1", "-", "\[Mu]"}]},
           {
            RowBox[{"\[Delta]", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]},
           {"\<\"\"\>"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {
            FractionBox["1", "2"]},
           {
            RowBox[{
             FractionBox["1", "2"], " ", "\[Delta]", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]},
           {"\<\"\\!\\(\\*\\nStyleBox[\\\"\[FivePointedStar]\[FivePointedStar]\
\[FivePointedStar]\\\",\\nFontSize->16,\\nFontColor->RGBColor[1, 0, \
0]]\\)\"\>"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {
            FractionBox["1", "2"]},
           {
            RowBox[{
             FractionBox["1", "2"], " ", "\[Delta]", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]},
           {"\<\"\"\>"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"VHi"},
           {
            RowBox[{"1", "-", "\[Delta]"}]},
           {
            RowBox[{"1", "-", "\[Delta]"}]},
           {"\<\"\"\>"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"Inf"},
           {"\[Mu]"},
           {
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", "\[Mu]"}]},
           {"\<\"\"\>"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {"1"},
           {
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", "\[Mu]"}]},
           {"\<\"\\!\\(\\*\\nStyleBox[\\\"\[FivePointedStar]\[FivePointedStar]\
\[FivePointedStar]\\\",\\nFontSize->16,\\nFontColor->RGBColor[1, 0, \
0]]\\)\"\>"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"U"},
           {
            RowBox[{"1", "-", "\[Mu]"}]},
           {
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]},
           {"\<\"\"\>"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"B"},
           {
            FractionBox["1", "2"]},
           {
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]},
           {"\<\"\\!\\(\\*\\nStyleBox[\\\"\[FivePointedStar]\[FivePointedStar]\
\[FivePointedStar]\\\",\\nFontSize->16,\\nFontColor->RGBColor[1, 0, \
0]]\\)\"\>"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]},
     {GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], GridBox[{
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"},
        {"\<\" \"\>"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.1]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], 
      FrameBox[
       TagBox[
        TagBox[GridBox[{
           {"S"},
           {
            FractionBox["1", "2"]},
           {
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Delta]"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Mu]"}], ")"}]}]},
           {"\<\"\"\>"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.5599999999999999]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {\

              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         Column],
        Function[BoxForm`e$, 
         TableForm[BoxForm`e$]]]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.35]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {{
         Offset[0.2]}}, "RowsIndexed" -> {}}],
   TableForm[{{
      FrameBox[
       TableForm[{$CellContext`V, 1, 1, ""}]], 
      FrameBox[
       TableForm[{$CellContext`VLo, $CellContext`\[Delta], $CellContext`\
\[Delta], ""}]], 
      FrameBox[
       TableForm[{$CellContext`Inf, $CellContext`\[Mu], $CellContext`\[Delta] \
$CellContext`\[Mu], ""}]], 
      FrameBox[
       TableForm[{$CellContext`S, 1, $CellContext`\[Delta] $CellContext`\[Mu],
          ""}]]}, {{" ", " ", " ", " "}, {" ", " ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`U, 
         1 - $CellContext`\[Mu], $CellContext`\[Delta] (
          1 - $CellContext`\[Mu]), ""}]], 
      FrameBox[
       TableForm[{$CellContext`B, 
         Rational[1, 2], 
         Rational[1, 2] $CellContext`\[Delta] (1 - $CellContext`\[Mu]), 
         "\!\(\*\nStyleBox[\"\[FivePointedStar]\[FivePointedStar]\
\[FivePointedStar]\",\nFontSize->16,\nFontColor->RGBColor[1, 0, 0]]\)"}]]}, {{
      " ", " ", " ", " "}, {" ", " ", " ", " "}, {" ", " ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`S, 
         Rational[1, 2], 
         Rational[1, 2] $CellContext`\[Delta] (1 - $CellContext`\[Mu]), 
         ""}]]}, {{" ", " ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`VHi, 1 - $CellContext`\[Delta], 
         1 - $CellContext`\[Delta], ""}]], 
      FrameBox[
       TableForm[{$CellContext`Inf, $CellContext`\[Mu], (
          1 - $CellContext`\[Delta]) $CellContext`\[Mu], ""}]], 
      FrameBox[
       TableForm[{$CellContext`B, 
         1, (1 - $CellContext`\[Delta]) $CellContext`\[Mu], 
         "\!\(\*\nStyleBox[\"\[FivePointedStar]\[FivePointedStar]\
\[FivePointedStar]\",\nFontSize->16,\nFontColor->RGBColor[1, 0, 0]]\)"}]]}, {{
      " ", " ", " ", " "}, {" ", " ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`U, 
         1 - $CellContext`\[Mu], (1 - $CellContext`\[Delta]) (
          1 - $CellContext`\[Mu]), ""}]], 
      FrameBox[
       TableForm[{$CellContext`B, 
         Rational[1, 2], 
         Rational[1, 2] (1 - $CellContext`\[Delta]) (1 - $CellContext`\[Mu]), 
         "\!\(\*\nStyleBox[\"\[FivePointedStar]\[FivePointedStar]\
\[FivePointedStar]\",\nFontSize->16,\nFontColor->RGBColor[1, 0, 0]]\)"}]]}, {{
      " ", " ", " ", " "}, {" ", " ", " ", " "}, {" ", " ", " ", " "}, 
      FrameBox[
       TableForm[{$CellContext`S, 
         Rational[1, 2], 
         Rational[1, 2] (1 - $CellContext`\[Delta]) (1 - $CellContext`\[Mu]), 
         ""}]]}}, TableAlignments -> {Left, Top}, 
    TableSpacing -> {0.5, 0.5}]],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.38816990467*^9, 3.3895509876443996`*^9, 
  3.3895517324264*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->None,
PrintingStyleEnvironment->"Printout",
WindowSize->{1578, 1027},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Visible->True,
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PrintingMargins"->{{54, 54}, {72, 72}}},
ShowSelection->True,
InputAliases->{"intt" -> RowBox[{"\[Integral]", 
     RowBox[{"\[SelectionPlaceholder]", 
       RowBox[{"\[DifferentialD]", "\[Placeholder]"}]}]}], "dintt" -> 
  RowBox[{
     SubsuperscriptBox[
     "\[Integral]", "\[SelectionPlaceholder]", "\[Placeholder]"], 
     RowBox[{"\[Placeholder]", 
       RowBox[{"\[DifferentialD]", "\[Placeholder]"}]}]}], "sumt" -> RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"\[SelectionPlaceholder]", "=", "\[Placeholder]"}], 
      "\[Placeholder]"], "\[Placeholder]"}], "prodt" -> RowBox[{
     UnderoverscriptBox["\[Product]", 
      RowBox[{"\[SelectionPlaceholder]", "=", "\[Placeholder]"}], 
      "\[Placeholder]"], "\[Placeholder]"}], "dt" -> RowBox[{
     SubscriptBox["\[PartialD]", "\[Placeholder]"], " ", 
     "\[SelectionPlaceholder]"}], "notation" -> RowBox[{"Notation", "[", 
     RowBox[{
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> "NotationTemplateStyle"],
        " ", "\[DoubleLongLeftRightArrow]", " ", 
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> 
        "NotationTemplateStyle"]}], "]"}], "notation>" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> "NotationTemplateStyle"],
        " ", "\[DoubleLongRightArrow]", " ", 
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> 
        "NotationTemplateStyle"]}], "]"}], "notation<" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> "NotationTemplateStyle"],
        " ", "\[DoubleLongLeftArrow]", " ", 
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> 
        "NotationTemplateStyle"]}], "]"}], "symb" -> 
  RowBox[{"Symbolize", "[", 
     TagBox[
     "\[Placeholder]", NotationBoxTag, TagStyle -> "NotationTemplateStyle"], 
     "]"}], "infixnotation" -> RowBox[{"InfixNotation", "[", 
     RowBox[{
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> "NotationTemplateStyle"],
        ",", "\[Placeholder]"}], "]"}], "addia" -> 
  RowBox[{"AddInputAlias", "[", 
     RowBox[{"\"\[Placeholder]\"", "\[Rule]", 
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> 
        "NotationTemplateStyle"]}], "]"}], "pattwraper" -> 
  TagBox["\[Placeholder]", NotationPatternTag, TagStyle -> 
    "NotationPatternWrapperStyle"], "madeboxeswraper" -> 
  TagBox["\[Placeholder]", NotationMadeBoxesTag, TagStyle -> 
    "NotationMadeBoxesWrapperStyle"], "E" -> "\[ScriptCapitalE]"},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->"EMMStyle02.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 1024, 26, 430, "Title"],
Cell[CellGroupData[{
Cell[1639, 53, 410, 9, 43, "Input"],
Cell[2052, 64, 742, 16, 51, "Output"]
}, Open  ]],
Cell[2809, 83, 432, 9, 32, "Text"],
Cell[3244, 94, 223, 8, 36, "BulletedList"],
Cell[3470, 104, 310, 13, 36, "BulletedList"],
Cell[3783, 119, 379, 16, 36, "BulletedList"],
Cell[4165, 137, 636, 16, 56, "Text"],
Cell[CellGroupData[{
Cell[4826, 157, 100, 2, 92, "Section"],
Cell[4929, 161, 375, 10, 43, "Input"],
Cell[5307, 173, 381, 8, 43, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5725, 186, 122, 2, 92, "Section"],
Cell[5850, 190, 191, 5, 32, "Text"],
Cell[CellGroupData[{
Cell[6066, 199, 185, 5, 43, "Input"],
Cell[6254, 206, 414, 9, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6705, 220, 136, 3, 43, "Input"],
Cell[6844, 225, 2822, 81, 53, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9703, 311, 311, 9, 43, "Input"],
Cell[10017, 322, 343, 9, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10397, 336, 136, 3, 43, "Input"],
Cell[10536, 341, 7104, 203, 87, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17677, 549, 765, 23, 43, "Input"],
Cell[18445, 574, 579, 17, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19061, 596, 136, 3, 43, "Input"],
Cell[19200, 601, 13481, 384, 121, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32718, 990, 115, 2, 71, "Subsection"],
Cell[32836, 994, 385, 7, 55, "Text"],
Cell[33224, 1003, 13471, 384, 133, "Output"],
Cell[CellGroupData[{
Cell[46720, 1391, 359, 11, 55, "Input"],
Cell[47082, 1404, 679, 21, 68, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47798, 1430, 133, 3, 55, "Input"],
Cell[47934, 1435, 13634, 389, 181, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[61605, 1829, 628, 19, 55, "Input"],
Cell[62236, 1850, 779, 24, 68, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[63052, 1879, 133, 3, 55, "Input"],
Cell[63188, 1884, 13753, 392, 181, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[76978, 2281, 164, 4, 55, "Input"],
Cell[77145, 2287, 16325, 475, 359, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[93519, 2768, 108, 2, 71, "Subsection"],
Cell[93630, 2772, 227, 7, 33, "Text"],
Cell[93860, 2781, 16315, 475, 359, "Output"],
Cell[CellGroupData[{
Cell[110200, 3260, 163, 4, 55, "Input"],
Cell[110366, 3266, 14858, 422, 181, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[125261, 3693, 197, 5, 55, "Input"],
Cell[125461, 3700, 3084, 93, 153, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[128582, 3798, 136, 3, 55, "Input"],
Cell[128721, 3803, 19064, 557, 525, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[147834, 4366, 124, 2, 71, "Subsection"],
Cell[147961, 4370, 206, 7, 33, "Text"],
Cell[148170, 4379, 19077, 558, 525, "Output"],
Cell[CellGroupData[{
Cell[167272, 4941, 155, 4, 55, "Input"],
Cell[167430, 4947, 169, 3, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[167636, 4955, 153, 4, 55, "Input"],
Cell[167792, 4961, 503, 15, 68, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[168332, 4981, 136, 3, 55, "Input"],
Cell[168471, 4986, 19101, 558, 525, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[187609, 5549, 238, 7, 55, "Input"],
Cell[187850, 5558, 536, 16, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[188423, 5579, 124, 3, 55, "Input"],
Cell[188550, 5584, 162, 3, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[188749, 5592, 200, 6, 55, "Input"],
Cell[188952, 5600, 312, 9, 68, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[189301, 5614, 177, 4, 55, "Input"],
Cell[189481, 5620, 162, 3, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[189680, 5628, 177, 4, 55, "Input"],
Cell[189860, 5634, 195, 4, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[190092, 5643, 250, 7, 55, "Input"],
Cell[190345, 5652, 757, 24, 81, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[191139, 5681, 124, 3, 55, "Input"],
Cell[191266, 5686, 279, 7, 71, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[191606, 5700, 105, 2, 98, "Section"],
Cell[CellGroupData[{
Cell[191736, 5706, 131, 2, 44, "Subsubsection"],
Cell[191870, 5710, 315, 8, 33, "Text"],
Cell[192188, 5720, 286, 7, 71, "Output"],
Cell[CellGroupData[{
Cell[192499, 5731, 172, 4, 55, "Input"],
Cell[192674, 5737, 150, 3, 50, "Output"]
}, Open  ]],
Cell[192839, 5743, 207, 6, 33, "Text"],
Cell[CellGroupData[{
Cell[193071, 5753, 218, 6, 55, "Input"],
Cell[193292, 5761, 612, 19, 50, "Output"]
}, Open  ]],
Cell[193919, 5783, 179, 6, 33, "Text"],
Cell[CellGroupData[{
Cell[194123, 5793, 180, 4, 55, "Input"],
Cell[194306, 5799, 311, 7, 32, "Print"],
Cell[194620, 5808, 370, 9, 32, "Print"],
Cell[194993, 5819, 183, 5, 32, "Print"],
Cell[195179, 5826, 357, 9, 32, "Print"],
Cell[195539, 5837, 368, 11, 50, "Print"],
Cell[195910, 5850, 119, 2, 50, "Output"],
Cell[196032, 5854, 421, 13, 50, "Print"],
Cell[196456, 5869, 414, 11, 32, "Print"],
Cell[196873, 5882, 240, 7, 32, "Print"],
Cell[197116, 5891, 427, 11, 32, "Print"],
Cell[197546, 5904, 368, 9, 32, "Print"],
Cell[197917, 5915, 344, 9, 32, "Print"],
Cell[198264, 5926, 407, 11, 32, "Print"],
Cell[198674, 5939, 220, 7, 32, "Print"],
Cell[198897, 5948, 394, 11, 32, "Print"],
Cell[199294, 5961, 401, 13, 50, "Print"],
Cell[199698, 5976, 107, 2, 50, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[199854, 5984, 109, 2, 44, "Subsubsection"],
Cell[199966, 5988, 275, 9, 33, "Text"],
Cell[CellGroupData[{
Cell[200266, 6001, 229, 6, 55, "Input"],
Cell[200498, 6009, 16826, 480, 309, "Output"]
}, Open  ]],
Cell[217339, 6492, 125, 2, 32, "Text"],
Cell[CellGroupData[{
Cell[217489, 6498, 192, 5, 55, "Input"],
Cell[217684, 6505, 20563, 592, 639, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
