function waveTest( )
    %   test run of wmtsa routines (with recoded modwtj and imodwtj in
    %   'hasbrouck/Functions'
    clear all;
    fclose('all');
    clc
    close all
    format compact;
    fprintf('wavetest %s computer is %s; OS is %s\n', datestr(clock), computer, getenv('OS'));
    addpath('./hasbrouckFunctions',genpath('../wmtsa-matlab-0.2.6/wmtsa/dwt'),genpath('../wmtsa-matlab-0.2.6/wmtsa/utils'))
    %   construct a random bivariate time series.
    nObs = 10;
    rng(123456);
    x = cumsum(randn(nObs,1))+(1:nObs)';
    x = [x x+2*randn(nObs,1)];
    disp 'simulated time series:'
    x
    JMax=3; %  max level of modwt transform
    [w,v,att]=modwt(x,'haar',JMax,'circular');
    %   do the inverse transform and verify that series is recovered
    x2 = imodwt(w,v,att);
    disp 'max difference between orignal and recovered series is ...'
    md=max(abs(x2-x))
    disp 'wavelet covariances (MJ is the number of non-boundary wavelet coefficients used)';
    [wcov, MJ] = waveletCovariance(w,0,att)
    return;
end

