*	ComputeCorrelations builds an output dataset containing a correlation matrix
	The input dataset (dsCovIn) is assumed to contain an nxn covariance matrix.
	dsCovIn must have n rows, n numeric variables and a character variable (_name_)
	that contains the names of the variables.
	dsCovIn can have additional character variables, but these are ignored.

	The output dataset (dsCorrOut) contains n numeric column variables and two character
	variables (_type_ and _name_).  It has n+1 rows (observations)
	The first n rows contain the correlation matrix: _type_=""corr"" and
	_name_ = "p1", "p2", etc.
	The last row contains the standard deviations.  _type_=""SD"" and _name_ is empty.
;
%macro ComputeCorrelations(dsCovIn, dsCorrOut);
proc iml;
	start main;
	use &dsCovIn;
	read all into cov [colname=cn  rowname=_name_];
	n = ncol(cov);
	if n^=nrow(cov) then do;
		print "covariance matrix not square.";
		abort;
	end;
	sd = j(1,n,0);
	do i=1 to n;
		sd[i] = sqrt(cov[i,i]);
	end;
/*	print sd;*/
	corr = j(n,n,0);
	do i=1 to n;
		do j=1 to n;
			corr[i,j] = cov[i,j]/(sd[i]*sd[j]);
		end;
	end;
/*	print cov;*/
/*	print corr;*/
	create &dsCorrOut from corr [colname=cn];
	append from corr;
	append from sd;
	finish;
	run;
	quit;
*	Add names and descriptions;
data &dsCorrOut;
	set &dsCorrOut end=last;
	if ^last then do;
		_name_ = compress("p" || _n_," ");
		_type_ = "corr";
	end;
	else do;
		_name_= " ";
		_type_ = "SD";
	end;
	run;
%mend ComputeCorrelations;
