*	RowDifference(dsCoeff,dsOutput,PrintLevel=1)

	In the typical price discovery analysis, the rows of the coefficient matrix
	should be identical.  This macro checks for this, reporting the maximum
	absolute and relative differences among the rows (using the Euclidean norm).

	Parameters
	dsCoeff		Input dataset containing the coefficients
	PrintLevel	0	No output
				1	Printed output (default).

	The maximum differences may be used later in your program.
	They are saved in the macro variables &MaxAbsDiff and &MaxRelDiff.
;
%macro RowDifference(dsCoeff,PrintLevel=1);
%global MaxAbsDiff;
%global MaxRelDiff;
proc iml;
	start main;
	if &PrintLevel>=1 then print "RowDifference: Analysis of coefficient matrix rows.";
	use &dsCoeff;
	read all into b [colname=VarNamesb];
	mattrib b rowname=VarNamesb label="Coefficient matrix";
	if &PrintLevel>=1 then print b;
	MaxAbsDiff = 0;
	MaxRelDiff = 0;

	do i=1 to nrow(b);
		do j=i+1 to nrow(b);
			dvec = b[i,]-b[j,];
			d = ssq(dvec);
			sd = sqrt(d);
			if d>MaxAbsDiff then MaxAbsDiff=d;
			m = sqrt( max(ssq(b[i,]),ssq(b[j,])) );
			if m>0 then do;
				dr = sd/m;
				if dr>MaxRelDiff then MaxRelDiff=dr;
			end;
		end;
	end;
	if &PrintLevel>=1 then do;
		print "Analysis of (Euclidean norm) row differences in coefficient matrix.";
		print 	MaxAbsDiff[label="Max absolute difference" format=20.10]
				MaxRelDiff[label="Max relative difference" format=20.10];
	end;
	create TempDiff01 var {MaxAbsDiff MaxRelDiff};
	append;
	finish main;

	run;
	quit;
data _null_;
	set TempDiff01;
	call symput("MaxAbsDiff",left(put(MaxAbsDiff,e15.6)));
	call symput("MaxRelDiff",left(put(MaxRelDiff,e15.6)));
	run;
%mend RowDifference;
