function AsyInfoClusterEstimate(d, Prog)

%	Set output files
f1 = [Prog.OutputDir '\DrawList.lst'];
f2 = [Prog.OutputDir '\GibbsAnalyze.lst'];
if Prog.MakeDraws
	[s,w]=dos(['del "' f1 '"']);
	[s,w]=dos(['del "' f2 '"']);	%	If we're making fresh draws, delete any old gibbs analysis listings.
	[s,w]=dos(['del "' Prog.OutputDir '\*.fig"']);	%	Also delete any figure files.
	diary(f1);
else
	[s,w]=dos(['del "' f2 '"']);
	diary(f2);
end

format compact;
disp(char(' ', [Prog.RunDesc ' starting on ' datestr(now)]));
disp(Prog);

Prog.nParm = 3 + 2*(Prog.J+1);

for i=1:length(d);
	d(i).p = log(d(i).P);
	d(i).dP = diff(d(i).P);
	d(i).dp = diff(d(i).p); 
end;

disp(repmat('-',1,50));
StructStats(d,1);
disp(repmat('-',1,50));
RollParam_dP = RollEstimate(d,'dP');
disp(repmat('-',1,50));
RollParam_dp = RollEstimate(d,'dp');

% par=Prog.par;

par.varu = RollParam_dp.Variance;
if isfinite(RollParam_dP.HalfSpread)
	par.C = RollParam_dP.HalfSpread;
else
	par.C = .01;
end
par.ClusterProb = 0;
par.ClusterMult = Prog.ClusterMult;
par.lambda = repmat(.00001,Prog.J+1,2);
disp(char(repmat('-',1,50), 'Starting Values:'));
StructDisp(par);

%	Initialize latent data values
for i=1:length(d)
	n = length(d(i).P);
	d(i).q = [1 sign(d(i).dp)];
	d(i).K = ones(1,n);
	M = d(i).P - d(i).q*(par.C+.5);
	d(i).m = log(M);
end

%	Set Priors
Priors.C.mu=0;
Priors.C.cov=1000;
Priors.varu.alpha=1e-12;
Priors.varu.beta=1e-12;
Priors.ClusterProb.alpha=.5;
Priors.ClusterProb.beta=.5;
Priors.lambda.mu=zeros(2*(Prog.J+1),1);
Priors.lambda.cov=diag(repmat(1000,1,2*(Prog.J+1)));
disp(char(repmat('-',1,50), 'Priors:'))
StructDisp(Priors);

if Prog.MakeDraws
	Draws = Gibbs(Prog, d, par, Priors);
	save(['.\' Prog.OutputDir '\Draws'],'Draws');
else
	disp('Reading saved draws.');
	load(['.\' Prog.OutputDir '\Draws']);
end

AnalyzeGibbsDraws(Prog, Draws, d);

diary off;

%**************************************************************************************
function AnalyzeGibbsDraws(Prog, Draws, d);

[D,DNames] = DrawStructure2Matrix(Draws);
GibbsSummary(D,.2,DNames);

sdu = 10000*sqrt(GetDrawVector(Draws,'par.varu'));
C = GetDrawVector(Draws,'par.C');
ClusterProb = GetDrawVector(Draws,'par.ClusterProb');
lambdaSum = 10000*GetDrawVector(Draws,'lambdaSum');
R2 = GetDrawVector(Draws,'R2');
pG = [sdu C ClusterProb lambdaSum R2];
GibbsSummary(pG,.2,{'sdu x 10,000' 'C (Ticks)' 'k' 'lambdaSum(1)' 'lambdaSum(2)' 'R2'});

if Prog.GibbsGraphs
	pG = [sdu C ClusterProb];
	fn={'\sigma_{\itu}\times10,000' '\itC (ticks)' 'k'};
	GibbsGraphs(pG, .1, 100, fn);
	saveas(gcf,  [Prog.OutputDir '\sigCk.fig']);
	figure;
	GibbsGraphsPost(pG, .1, fn);
	saveas(gcf,  [Prog.OutputDir '\PostSigCk.fig']);
end

%**************************************************************************************

function Draws = Gibbs(Prog, d, par, Priors)

nDay = length(d);
nLambda = prod(size(par.lambda));

tic;

nAccept = 0;

for i=1:nDay
	x = d(i).x;
	n = length(x);
	%	d(i).X is [ 1 x(t) 1 x(t-1) . . . 1 x(t-J)]'
	d(i).X = zeros(nLambda,n-1);
	for j=0:Prog.J;
		xx = [zeros(2,j) [ones(1,n-j); x(1:n-j)] ];
		d(i).X(2*j+1:2*j+2,:) = xx(:,2:end);
	end;
end

disp(repmat('-',1,50));
disp([Prog.RunDesc ' Draw. . .']);
for iDraw=1:Prog.nDraw
	
	npr = 100;
	%npr = 1;
	if (mod(iDraw,npr)==0) fprintf(1,'%6d',iDraw); end;
	if (mod(iDraw,10*npr)==0 | iDraw==Prog.nDraw) fprintf(1,'\n'); end;
	
	%	Make mC draw
	[newd, newC, Accept] = Draw_mC(Prog, d,par,Priors);
	if Accept; nAccept = nAccept + 1; end;
	par.C = newC;
	for i=1:nDay
		d(i).m = newd(i).m;
	end
	
	%	Make m, q, K draw
	newd = Draw_mqK(d,par);
	for i=1:nDay
		d(i).m = newd(i).m;
		d(i).q = newd(i).q;
		d(i).K = newd(i).K;
	end
	
	for i=1:nDay
		d(i).dm=diff(d(i).m);
	end
	
	Make_lambdaDraw = logical(1);
	if Make_lambdaDraw
		for i=1:nDay
			n = length(d(i).q);
			Q = zeros(nLambda,n-1);
			for j=0:Prog.J;
				q = [zeros(1,j) d(i).q(1:n-j)];
				Q(2*j+1:2*j+2,:) = repmat(q(2:end),2,1);
			end;
			d(i).XX = Q .* d(i).X;
			%         d(i).y = diff(d(i).m);
			d(i).y = d(i).dm;
		end
		Post = BayesRegressionUpdate(Priors.lambda, [d.y]', [d.XX]', par.varu);
		if Post.ret==0	%normal return
			nLambdaPositive = min(nLambda,4);
			LowerLimit = [zeros(nLambdaPositive,1); repmat(-inf,nLambda-nLambdaPositive,1)];
			UpperLimit = repmat(inf,nLambda,1);
			[lambdaCol,p] = mvnrndT(Post.mu, Post.cov, LowerLimit, UpperLimit);
			if p>0
				disp('Post.cov not pos definite.  Keeping old value of lambda.');
				disp(['Draw ' int2str(iDraw)]);
				disp('Current parameters');
				disp(par);
				disp(par.lambda);
				Debug = logical(1);
				if Debug
					disp('Post.cov');
					disp(num2str(Post.cov));
					return;
				end
				error('done');
			else
				par.lambda = transpose(reshape(lambdaCol,2,Prog.J+1));
			end
		else
			disp('Gibbs. Error return from BayesRegressionUpdate. Keeping old value for lambda.');
		end
	end
	
	%	Make varu draw
	lambdaRow = reshape(par.lambda',1,nLambda);
	for i=1:nDay
		n = length(d(i).q);
		Q = zeros(nLambda,n-1);
		for j=0:Prog.J;
			q = [zeros(1,j) d(i).q(1:n-j)];
			Q(2*j+1:2*j+2,:) = repmat(q(2:end),2,1);
		end;
		Impact = lambdaRow * (Q .* d(i).X);
		d(i).u = d(i).dm - Impact;
	end
	Post = BayesVarianceUpdate(Priors.varu, [d.u]);
	par.varu = InverseGammaRnd(Post.alpha, Post.beta);
	
	MakeClusterProbDraw = logical(1);
	if MakeClusterProbDraw
		Posterior = BayesBernoulliUpdate(Priors.ClusterProb, [d.K]==par.ClusterMult);
		newClusterProb = betarnd(Posterior.alpha, Posterior.beta);
		par.ClusterProb = newClusterProb;
	end
	
	CurrDraw.par = par;
	
	%	Various additional and transformed parameters
	CurrDraw.lambdaSum = sum(par.lambda);
	
	n = prod(size([d.dp]));
	CurrDraw.VarTot = sum([d.dm].^2)/n;
	CurrDraw.Varu = sum([d.u].^2)/n;
	CurrDraw.Varx = CurrDraw.VarTot - CurrDraw.Varu;
	CurrDraw.R2 = CurrDraw.Varx/CurrDraw.VarTot;
	
	%	Different lambda for different direction trades?
	for i=1:nDay
		n = length(d(i).q);
		Q = zeros(nLambda,n-1);
		for j=0:Prog.J;
			q = [zeros(1,j) d(i).q(1:n-j)];
			Q(2*j+1:2*j+2,:) = repmat(q(2:end),2,1);
		end;
		d(i).XX = [(Q>0).*Q .* d(i).X; (Q<0).*Q .* d(i).X];
		d(i).y = d(i).dm;
	end
	prior2.lambda.mu=zeros(4*(Prog.J+1),1);
	prior2.lambda.cov=diag(repmat(1000,1,4*(Prog.J+1)));
	Post = BayesRegressionUpdate(prior2.lambda, [d.y]', [d.XX]', par.varu);
	if Post.ret==0	%normal return
		lambda2 = mvnrnd(Post.mu,Post.cov,1);
		ll = reshape(lambda2,2,Prog.J+1,2);
		sl = squeeze(sum(ll,2));
		CurrDraw.lam0Buy = sl(1,1);
		CurrDraw.lam1Buy = sl(2,1);
		CurrDraw.lam0Sell = sl(1,2);
		CurrDraw.lam1Sell = sl(2,2);
	else
		error('Abnormal return from BayesRegrssionUpdate')
	end;
	
	if iDraw==1
		Draws = repmat(CurrDraw,1,Prog.nDraw);
	else
		Draws(iDraw) = CurrDraw;
	end
end

disp(['Acceptance rate in (m,C) draws = ',num2str(nAccept/Prog.nDraw)]);
ElapsedTime = toc;
disp(['Elapsed time: ' num2str(ElapsedTime) ' seconds  (' shms(ElapsedTime) ').']);

%**************************************************************************************

function newd=Draw_mqK(d,par)
for i=1:length(d)
	ranu = rand(length(d(i).P),2);
	newd(i) = AsyInfoClusterDraw_mqK(d(i),ranu,par);	%	This is a C++ routine
end

%**************************************************************************************
function [CDraw, ProbCDraw, ProbOldC]=DrawC(d, par, Priors)
%	Make a new draw of C and compute transition probabilities

%	Make C draw using regression model.
XpX = sum([d.dq].^2);
DInv = XpX/par.varU + 1/Priors.C.cov;
d = par.C *XpX/par.varU + Priors.C.mu/Priors.C.cov;
D = 1/DInv;
mu = D*d;
sd = sqrt(D);
% disp(sprintf('par.varU=%g mu=%g sd=%g',par.varU,mu,sd))
CDraw = RandNormT(mu, sd, 0, inf);

%	Probability of making this draw.
ProbCDraw = normpdf(CDraw,mu,sd)/(1-normcdf(0,mu,sd));

%	Probability of drawing existing value of C, starting with new draw.
d = CDraw *XpX/par.varU + Priors.C.mu/Priors.C.cov;
mu = D*d;
ProbOldC = normpdf(par.C,mu,sd)/(1-normcdf(0,mu,sd));

% disp(sprintf('DrawC from %g(%g) to %g(%g) Prob(To/From)=%g', par.C,ProbOldC, CDraw, ProbCDraw, ProbCDraw/ProbOldC))

%**************************************************************************************
function [newd, newC, Accept] = Draw_mC(Prog, d, par, Priors)
%	Metropolis-Hastings draws of m and C

nDay = length(d);
nLambda = prod(size(par.lambda));
lambdaRow = reshape(par.lambda',1,nLambda);
for i=1:nDay
	n = length(d(i).m);
	d(i).M = exp(d(i).m);
	Q = zeros(nLambda,n-1);
	for j=0:Prog.J;
		q = [zeros(1,j) d(i).q(1:n-j)];
		Q(2*j+1:2*j+2,:) = repmat(q(2:end),2,1);
	end;
	d(i).Impact = lambdaRow * (Q .* d(i).X);
	d(i).dq = diff(d(i).q);
end	

par.varU = mean([d.P])^2 * par.varu;

[CDraw, ProbCDraw, ProbOldC] = DrawC(d, par, Priors);

for i=1:nDay
	dDraw(i).m = log(d(i).M - d(i).q*(CDraw - par.C) );
	dDraw(i).u = diff(dDraw(i).m) - d(i).Impact;
	d(i).u = diff(d(i).m) - d(i).Impact;
end

f1 = normpdf(CDraw,Priors.C.mu,sqrt(Priors.C.cov))/normpdf(par.C, Priors.C.mu, sqrt(Priors.C.cov));
f2 = ProbOldC/ProbCDraw;
f3 = exp( -sum([dDraw(i).u].^2)/(2*par.varu) + sum([d(i).u].^2)/(2*par.varu));
alpha = min(1, f1*f2*f3);

if rand(1)<alpha	%accept
	Accept = 1;
	newC = CDraw;
	for i=1:nDay
		newd(i).m = dDraw(i).m;
	end
else
	Accept = 0;
	newC = par.C;
	for i=1:nDay
		newd(i).m = d(i).m;
	end
end