function AsyInfoClusterMain(nDraw)

addpath('.\m Files\General', '.\m Files\Special', '.\m Files\Statistics', '.\AsyInfoCluster');

close all;
randn('state',1234567);	%Initialize random number generators
rand ('state',5123456);

%	Simulation code:
Prog.RunDesc = 'AsyInfoCluster Simulation';
Prog.OutputDir = '.\AsyInfoCluster\Simulate';
s=mkdir(Prog.OutputDir);
Prog.nDraw = 1000;
if nargin==1; Prog.nDraw=nDraw; end;
Prog.MakeDraws = logical(1);	%	True to generate new draws; false to renalyze old draws.
Prog.GibbsGraphs = logical(0);
Prog.LambdaGraphs = logical(0);

% %	Simulation parameters
% par.MStart = 7000;
% par.varu = 1.e-8;
% par.C = .5;
% par.ClusterProb = .01;
% par.ClusterMult = 5;
% %impact is q(t)*(lambda(1,1) + lambda(1,2)*x(t)) + q(t-1)*(lambda(2,1) + lambda(2,2)*x(t-1)) + ...
% par.lambda = [.05 .02; .04 .01];
% % par.lambda = [.05 .02; .04 .01; .03 .01; .02 .01; .01 .01];
% % par.lambda = [.01 .01; .01 .01]/1000;
% [n,m] = size(par.lambda);
% par.J = n-1;	%	number of lags on lambda
% nDay=1;
% n=1000;
% d=AsyInfoClusterSimulate(nDay, n, par);
% Prog.J = par.J;
% Prog.ClusterMult = par.ClusterMult;
% Prog.nDraw=500;
% Prog.par = par;
% AsyInfoClusterEstimate(d, Prog);
% diary off;
% return;
% %	End of simulation code

Analyses = struct( ...
	'Symbol',		{'PB',		'SP',			'EC',			'SF'		'NB'}, ...
	'ClusterMult',	{2,			5,				2,				5			5}, ...
	'BigVolDay',	{27091999,	10081999,	13081999,	23081999	19081999});
Analyses = Analyses([3 5]);
disp(Analyses)
Prog.J=5;

%	Do all the analyses
Prog.nDraw = 500;
if nargin==1; Prog.nDraw=nDraw; end;
for Analysis=Analyses
	disp(repmat('-',1,50));
	disp(Analysis);
	Prog.RunDesc = ['AsyInfoCluster analysis for ' Analysis.Symbol];
	Prog.OutputDir = ['.\AsyInfoCluster\' Analysis.Symbol];
	s=mkdir(Prog.OutputDir);
	Prog.MakeDraws = logical(1);	%	True to generate new draws; false to renalyze old draws.
	Prog.GibbsGraphs = logical(1);
	Prog.LambdaGraphs = logical(1);
	Prog.ClusterMult = Analysis.ClusterMult;
	d=dbuild(['.\CME Data\f103' Analysis.Symbol '.dat']);
	AsyInfoClusterEstimate(d, Prog);
	diary off;
	close all;
end

return;

