function GraphBuildImpact2;
%	Build impact from preset parameters
close all;

addpath('.\m Files\', '.\m Files\General', '.\m Files\Special', '.\m Files\Statistics', '.\AsyInfoCluster');

UseDir = '.\AsyInfoCluster\2KDraws\';

Analyses = struct(...
	'Symbol',	{'PB'			'EC'	'NB'		'SP'}, 		...
	'Label',	{'Pork Bellies'	'Euro'	'UK'		'S&P'}, 		...
	'Tick', 	{4.3 			0.94	1.2			0.75}, 			...
	'BuySize',	{1:.1:10		1:.1:50	1:.1:50		1:.1:100},	...
	'GraphNo',	{1				2		3			4},			...
	'Lambda0',	{6.390			2.485	1.913		0.454},		...
	'Lambda1',	{1.952			0.011	-0.20		0.077});

set(gcf,'DefaultAxesFontSize',12);
set(gcf,'DefaultAxesColorOrder',[0 0 0]);

for Analysis=Analyses
	
	sv = sqrt(Analysis.BuySize);
	nBuy = size(sv,2);
	Impact = Analysis.Lambda0 + Analysis.Lambda1*sv;
	
	vtick = [0 Analysis.BuySize];
	tickLine = repmat(Analysis.Tick,size(vtick));
	
	subplot(2,2,Analysis.GraphNo);
	plot(Analysis.BuySize,Impact);
	hold on;
	plot(vtick,tickLine,'--');
	hold off;
	set(gca, 'YLim', [0 Inf]);
	
	title(Analysis.Label);
	xlabel('Buy Size (Contracts)');
	ylabel('Cum Impact (Basis Points)');
	
	%if Analysis.GraphNo==1
	%   EndPt = ['Cumulative impact through trade 5'];
	%   legend(EndPt,'Approx Tick');
	%end
	box off;
end
