function RollFixedcMain(nDraw);
%	RollFixedcMain(nDraw) estimates the Roll model with a fixed c.
%	nDraw is the number of sweeps of the sampler (default=1000)

addpath('.\m Files\', '.\m Files\General', '.\m Files\Special', '.\m Files\Statistics', '.\Roll Fixed c');

close all; clc;
randn('state',1234567);	%Initialize random number generators
rand ('state',5123456);

%	Simulation code
Prog.RunDesc = 'Roll Fixed c Simulation';
Prog.OutputDir = '.\Roll Fixed c\Simulate';
s=mkdir(Prog.OutputDir);
Prog.nDraw = 1000;
if nargin==1; Prog.nDraw=nDraw; end;
Prog.MakeDraws = logical(1);	%	True to generate new draws; false to renalyze old draws.
Prog.GibbsGraphs = logical(0);
%	Simulation parameters
par.MStart = 100;		%	Initial price
par.varu = .01^2;		%	Random-walk variance
par.c=.01;				%	log half-spread
nDay=1;					%	Number of days to simulate
n=1000;					%	Number of observations per day
d=RollSimulate(nDay, n, par);
Prog.Draw_q = logical(1);	% True to draw q's; false to set by sign of price change.
Prog.OtherDiagnostics = logical(1);
RollFixedcEstimate(d, Prog);
diary off;
return;

% Analyses = struct( 'Symbol',	{'PB' 'SP' 'EC' 'SF' 'NB'});
% % Analyses = Analyses(1);
% 
% Prog.nDraw = 1000;
% if nargin==1; Prog.nDraw=nDraw; end;
% 
% %	Principal estimates (with random q)
% for Analysis=Analyses
% 	disp(repmat('-',1,50));
% 	disp(Analysis);
% 	Prog.RunDesc = ['Roll Fixed c analysis for ' Analysis.Symbol];
% 	Prog.OutputDir = ['.\Roll Fixed c\Check u q Corrs\' Analysis.Symbol];
% 	s=mkdir(Prog.OutputDir);
% 	Prog.MakeDraws = logical(1);	%	True to generate new draws; false to renalyze old draws.
% 	Prog.GibbsGraphs = logical(1);
% 	Prog.Draw_q = logical(1);
% 	Prog.OtherDiagnostics = logical(1);
% 	d=dbuild(['.\CME Data\f103' Analysis.Symbol '.dat']);
% 	RollFixedcEstimate(d, Prog);
% 	diary off;
% 	close all;
% end

%	Alternative estimates (with fixed q)
% for Analysis=Analyses
% 	disp(repmat('-',1,50));
% 	disp(Analysis);
% 	Prog.RunDesc = ['Roll Fixed c analysis with fixed q for ' Analysis.Symbol];
% 	Prog.OutputDir = ['.\Roll Fixed c\Fixed q\' Analysis.Symbol];
% 	s=mkdir(Prog.OutputDir);
% 	Prog.MakeDraws = logical(1);	%	True to generate new draws; false to renalyze old draws.
% 	Prog.GibbsGraphs = logical(1);
% 	Prog.Draw_q = logical(0);
% 	Prog.OtherDiagnostics = logical(0);
% 	d=dbuild(['.\CME Data\f103' Analysis.Symbol '.dat']);
% 	RollFixedcEstimate(d, Prog);
% 	diary off;
% 	close all;
% end

return;

