(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     53400,       1627]
NotebookOptionsPosition[     46381,       1406]
NotebookOutlinePosition[     49513,       1489]
CellTagsIndexPosition[     49341,       1480]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "DealersAndInventories\n",
 StyleBox["Empirical Market Microstructure",
  FontSlant->"Italic"],
 " \n\t(2006, Oxford University Press)\nCompanion ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook\n\nJoel Hasbrouck\n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Copyright", " ", "2007"}], ",", " ", 
    RowBox[{"Joel", " ", 
     RowBox[{"Hasbrouck", ".", " ", "All"}], " ", "rights", " ", 
     RowBox[{"reserved", "."}]}]}], TraditionalForm]],
  FontSize->14,
  FontSlant->"Italic"],
 "\n",
 StyleBox["This notebook covers material in Chapter 11",
  FontSize->14]
}], "Title",
 CellChangeTimes->{{3.3896255910914*^9, 3.3896255932033997`*^9}, {
   3.3897167078988237`*^9, 3.389716768500824*^9}, 3.3897219191158237`*^9, {
   3.3899919263996*^9, 3.3899919275346003`*^9}, {3.3899922385226*^9, 
   3.3899922456106*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Text", "  ", "@", " ", 
  RowBox[{"Style", "[", 
   RowBox[{
    RowBox[{"\"\<Notebook evaluated \>\"", "<>", 
     RowBox[{"DateString", "[", "\"\<DateTime\>\"", "]"}]}], ",", 
    "\"\<Subtitle\>\""}], "]"}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896127180972*^9, 3.3896127205282*^9}, 
   3.389716999411824*^9, {3.3897170351038237`*^9, 3.389717047196824*^9}}],

Cell[BoxData[
 InterpretationBox[Cell[BoxData[
   StyleBox["\<\"Notebook evaluated Monday 4 June 2007 20:31:30\"\>", 
    "Subtitle",
    StripOnInput->False]], "Text", "TR"],
  Text[
   Style["Notebook evaluated Monday 4 June 2007 20:31:30", 
    "Subtitle"]]]], "Output",
 CellMargins->{{18, Inherited}, {Inherited, 0}},
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896127211071997`*^9, {3.3896127536242*^9, 3.3896127555652*^9}, 
   3.3896128616452*^9, 3.389623031447*^9, 3.3896232934164*^9, 
   3.389716955274824*^9, 3.3897170008718243`*^9, {3.3897170377738237`*^9, 
   3.3897170482808237`*^9}, 3.3899920823416*^9, 3.3899921326345997`*^9, 
   3.3899922909496*^9},
 Background->RGBColor[0.866667, 0.733333, 1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Preliminaries", "Section"],

Cell[BoxData[
 RowBox[{"<<", "Notation`"}]], "Input",
 CellChangeTimes->{{3.389697850171224*^9, 3.389697852371224*^9}},
 CellLabel->"In[202]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["Anything_", "Rule"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";", 
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["Anything_", "Rules"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";"}]], "Input",
 CellLabel->"In[203]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"baseStyle", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
     RowBox[{"FontSize", "\[Rule]", "12"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.3897185857272243`*^9, 3.3897186031422243`*^9}},
 CellLabel->"In[204]:="]
}, Closed]],

Cell[CellGroupData[{

Cell["Poisson/exponential arrival model", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"PoissonDistribution", "[", "\[Lambda]", "]"}], ",", "n"}], 
  "]"}]], "Input",
 CellLabel->"In[205]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "\[Lambda]"}]], " ", 
   SuperscriptBox["\[Lambda]", "n"]}], 
  RowBox[{"n", "!"}]]], "Output",
 CellChangeTimes->{3.3896979035582237`*^9, 3.389718812543624*^9, 
  3.3899922922386*^9},
 CellLabel->"Out[205]="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"ExponentialDistribution", "[", "\[Alpha]", "]"}], ",", "\[Tau]"}],
   "]"}]], "Input",
 CellLabel->"In[206]:="],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "\[Alpha]"}], " ", "\[Tau]"}]], " ", "\[Alpha]"}]], "Output",\

 CellChangeTimes->{3.3896979036022243`*^9, 3.389718812576624*^9, 
  3.3899922923375998`*^9},
 CellLabel->"Out[206]="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"ExponentialDistribution", "[", "\[Alpha]", "]"}], "]"}]], "Input",
 CellLabel->"In[207]:="],

Cell[BoxData[
 FractionBox["1", "\[Alpha]"]], "Output",
 CellChangeTimes->{3.389697903636224*^9, 3.389718812620624*^9, 
  3.3899922923926*^9},
 CellLabel->"Out[207]="]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Garman (Section 11.1.1, Exercise 11.1)", "Section",
 CellTags->"ExGarman"],

Cell["\<\
(The numbers in Exercise 11.1 were used to generate the figure.)\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a_", ",", "b_", ",", "c_", ",", "x_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"a", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"b", " ", "x"}], " ", "+", " ", "c"}]}], ";"}]], "Input",
 CellLabel->"In[208]:="],

Cell["Inverse arrival rates of sellers (who receive the bid price)", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ps", "=", 
  RowBox[{"f", "[", 
   RowBox[{".2", ",", ".2", ",", "2", ",", "\[Lambda]"}], "]"}]}]], "Input",
 CellLabel->"In[209]:="],

Cell[BoxData[
 RowBox[{"2", "+", 
  RowBox[{"0.2`", " ", "\[Lambda]"}], "+", 
  RowBox[{"0.2`", " ", 
   SuperscriptBox["\[Lambda]", "2"]}]}]], "Output",
 CellChangeTimes->{3.389697903671224*^9, 3.389718414137224*^9, 
  3.389718812668624*^9, 3.3899922924625998`*^9},
 CellLabel->"Out[209]="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"ps", ",", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[210]:="],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVz30w1HkcB/Dv77eEmrOWum6JWuEqDIf04PL5RDc6JVcx1KyHcR7y2NLO
KM55pofV1B1OhzzUXSdPJ/SgPJz2dIdQEmHR5rbNqtWVjCT3vT/e857XP++Z
tyDo6IEQlhCyj+b/dg9RPmh74e0c5SyhIqjhaiga5zvA5g8qy3XU9iUFRfX8
XaCT5StE6j33B68V872gd9GnO4XaJ3iu+Qd+MAwmzSgZhqDMJts1hy+Ggdbs
lZoswdJVnlmn+Rlwdo/nZq4GwVTt+s9P8XNBnepSbKdN0PdQWe3M68tg4TGs
FcsjuGIpVehmUgtbk8qFRwwJmu9/pbx7pgFqcXp5+nqC8T3boODtLZDpJEGz
NcHVDbwxhmkFm79v2BdvIXhd7trd+2U7RCeXPKtyIdgeUWx0aFoK6WXvjBUe
BGctdnCro++Bg60gvs6XIDtfqWdk3glH/foa24IJOi4FXj9Y0w3Vt6L0fUUE
uzMcejo29UL+sqo5je8Irj2nmq941Qd2ixejdE4RVM2Njw3YPgSLji55Wh7B
y1O3O3XP9oOBLEM/+BJBXeMr6snJR5BlETIXWEdQEt4YWmr2GHo7E91bWwi+
w8rJI8mDMPS6Ne7CfYJiO2nDp3eHQDwdz+0aITheIz3zQDAMh3jPm0+qCC5E
PCrcmDAC+25aSA4vELTcqfUx9PYouIQcNxctZ9CtXBBWt3oMYn8UcCyMGIw3
DjB9KhyHmDeSX1dZMmg17b1i0GMC1lhvDNB0YtCAO6MtfT8B2eUruRV7GdRo
LaxdX/QUNCvSA475MRjpcPuJzh45jH7lPMSIGKz8Oqi05Z0c5o2P5OWnMTir
MtRT5D+Dwq4sH+dcBhsPunFyd01C3ZvDoS1XGEzenVnSoJgEUf9colsTgwKZ
+9ClzH+g5Vrlk/ZuBrdvycjl2ylgg9fjDZueMig06Z1n+hVwysQ/LPst3e/M
kYtSn0PDza47EzosFmj4iw+YKUGXJ5szN2HRYKyxnJUqwZR5O+ttx6JmUqrX
ttgXMLipriNvN4ukwr9Wrj8Fb6x3e9b4sRj3c22OfvsUlCb+IleIWWy2PKnN
i1GBj5xE6klY5LnHWaXpTsOw6RqtpTIWR637+k/cmYbAnbYjgiYWf78IZpP+
L2FHZkzbUh+LfrWOPOOPL8HpRHJe03MWUzLLUkevvoJtLgbfNBMOViuNC3X3
qqHPb3gh7DMO7ufpbr33Xg0R+jduRdhx8LQmazRKff77yJFoaun87OIM9U03
waKI2lEuu2u4oAbO63MYT21YX+0ZQ51bknIvnVru5RG26oMaiqLKBoqoxQWS
/G8X1bCrQ/lvD3W1JOXEcerDD/9a+ZBakSIW5lAfdbrqOEDtGy40vUFdYBab
MEK9Y7tVzfKPanh2gMsqqZeNdv1ZRx24NofH2HMQ+lp/66COXkiz16A+Lq0/
M0Kd4JDgrUU9VVW4X3OJ/mmOuvAJdU9SpMyXuskySGBIrRUX0BZN3a4OcjWm
xtCDl9KoO/VCQtZRX9vnFF5F/SQ8usKCWuVis/cP6omyY10bqc22rLd5TK1w
THxpRe1vuVpfRT29IYNrS/3T2hWzS9Qz8We/sKf+D9hAMAo=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 2.},
  PlotRange->{{0, 1}, {2.000000004081633, 2.399999987755102}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.389697903735224*^9, 3.389718414174224*^9, 
  3.3897188127166243`*^9, 3.3899922925596*^9},
 CellLabel->"Out[210]="]
}, Closed]],

Cell["Inverse arrive rate of buyers (who pay the ask)", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pb", "=", 
  RowBox[{"f", "[", 
   RowBox[{".2", ",", 
    RowBox[{"-", "1"}], ",", "3", ",", "\[Lambda]"}], "]"}]}]], "Input",
 CellLabel->"In[211]:="],

Cell[BoxData[
 RowBox[{"3", "-", "\[Lambda]", "+", 
  RowBox[{"0.2`", " ", 
   SuperscriptBox["\[Lambda]", "2"]}]}]], "Output",
 CellChangeTimes->{3.389697903747224*^9, 3.389718414204224*^9, 
  3.389718812729624*^9, 3.3899922925896*^9},
 CellLabel->"Out[211]="]
}, Closed]],

Cell[CellGroupData[{

Cell["The single price equilbrium", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ps", ",", "pb"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<\[Lambda]\>\"", ",", "\"\<p\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[212]:="],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVz30w1HkcB/Dv77eEmrOWum6JWuEqDIf04PL5RDc6JVcx1KyHcR7y2NLO
KM55pofV1B1OhzzUXSdPJ/SgPJz2dIdQEmHR5rbNqtWVjCT3vT/e857XP++Z
tyDo6IEQlhCyj+b/dg9RPmh74e0c5SyhIqjhaiga5zvA5g8qy3XU9iUFRfX8
XaCT5StE6j33B68V872gd9GnO4XaJ3iu+Qd+MAwmzSgZhqDMJts1hy+Ggdbs
lZoswdJVnlmn+Rlwdo/nZq4GwVTt+s9P8XNBnepSbKdN0PdQWe3M68tg4TGs
FcsjuGIpVehmUgtbk8qFRwwJmu9/pbx7pgFqcXp5+nqC8T3boODtLZDpJEGz
NcHVDbwxhmkFm79v2BdvIXhd7trd+2U7RCeXPKtyIdgeUWx0aFoK6WXvjBUe
BGctdnCro++Bg60gvs6XIDtfqWdk3glH/foa24IJOi4FXj9Y0w3Vt6L0fUUE
uzMcejo29UL+sqo5je8Irj2nmq941Qd2ixejdE4RVM2Njw3YPgSLji55Wh7B
y1O3O3XP9oOBLEM/+BJBXeMr6snJR5BlETIXWEdQEt4YWmr2GHo7E91bWwi+
w8rJI8mDMPS6Ne7CfYJiO2nDp3eHQDwdz+0aITheIz3zQDAMh3jPm0+qCC5E
PCrcmDAC+25aSA4vELTcqfUx9PYouIQcNxctZ9CtXBBWt3oMYn8UcCyMGIw3
DjB9KhyHmDeSX1dZMmg17b1i0GMC1lhvDNB0YtCAO6MtfT8B2eUruRV7GdRo
LaxdX/QUNCvSA475MRjpcPuJzh45jH7lPMSIGKz8Oqi05Z0c5o2P5OWnMTir
MtRT5D+Dwq4sH+dcBhsPunFyd01C3ZvDoS1XGEzenVnSoJgEUf9colsTgwKZ
+9ClzH+g5Vrlk/ZuBrdvycjl2ylgg9fjDZueMig06Z1n+hVwysQ/LPst3e/M
kYtSn0PDza47EzosFmj4iw+YKUGXJ5szN2HRYKyxnJUqwZR5O+ttx6JmUqrX
ttgXMLipriNvN4ukwr9Wrj8Fb6x3e9b4sRj3c22OfvsUlCb+IleIWWy2PKnN
i1GBj5xE6klY5LnHWaXpTsOw6RqtpTIWR637+k/cmYbAnbYjgiYWf78IZpP+
L2FHZkzbUh+LfrWOPOOPL8HpRHJe03MWUzLLUkevvoJtLgbfNBMOViuNC3X3
qqHPb3gh7DMO7ufpbr33Xg0R+jduRdhx8LQmazRKff77yJFoaun87OIM9U03
waKI2lEuu2u4oAbO63MYT21YX+0ZQ51bknIvnVru5RG26oMaiqLKBoqoxQWS
/G8X1bCrQ/lvD3W1JOXEcerDD/9a+ZBakSIW5lAfdbrqOEDtGy40vUFdYBab
MEK9Y7tVzfKPanh2gMsqqZeNdv1ZRx24NofH2HMQ+lp/66COXkiz16A+Lq0/
M0Kd4JDgrUU9VVW4X3OJ/mmOuvAJdU9SpMyXuskySGBIrRUX0BZN3a4OcjWm
xtCDl9KoO/VCQtZRX9vnFF5F/SQ8usKCWuVis/cP6omyY10bqc22rLd5TK1w
THxpRe1vuVpfRT29IYNrS/3T2hWzS9Qz8We/sKf+D9hAMAo=
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwVzX881HccB3D3vR/fll+ppGMy0baiaXj4keX9rvSQH9VDTlR+9LBiKjd5
nNKqFTutyGrNuJDfazNy5Y62B7ri0CQVRflxp9vtupycVlcPwu2zP16P1+P5
z+vlGP/19n2UiYnJVpL/O3if9uGtFxH+ms4Ns0YjjayNtilKrif4vs/2iCP2
KBUVS7gBkD+t5N+cozHk3kD9ZS4PUmKuvTk+S2Pk3nctF7l7oVQy9sX0NI0j
bt9vzOUKYLy8XWYw0Fhmve10NlcI608vPj+pozFjnuSTs9w8GEpewjMM0Bi1
s1w8+aoKRo+23nheS6OpMSM6cJkY5g+G+s7PonFF2IS2LUcK6278FbIplsYj
Pb4gevMnZKULnX70pNFGaqVgMGTg51AwMWVOY6NqY/f9L1rBt2iL9Ds1B1v3
X7bbOS6HhoNqP9dmDho+Xmd5NbkTrAtnrBX5HKSmahbYreiC3QEXFrfzOehl
3NMYXtcNk2ayvTVBHOwWevZ0rLoPfWJGWvEKDjpc0E1VTzyAzsGJ8P45Nure
KRWP1/RCdGdb4swgG6vGmrosfuiDzaN2gmNSNlrY/6pXqx9BjLVZsul5Np5L
akgoc+6HvLxRWnCQjW+xRv3VyQHQCJ42BgWyUeAuly5pewJLlr4xn3Bmo7JO
nvPQcRDG2pobLE3Y+H7/o6KV3wxB2lCHdO0wC13W03MJTcOwWXuh/qMmFgZW
OCZet1GAhFftISpg4RH7uOXPopXgpfq87tZhFrqOR5gObBkFS4/oNMUOFi6y
nJwnnx4FqqQ7tdyThSxZkdip+BmEneUHUNYsPODZ9PSDEBVEvNh+YulrJtYE
xZfdfKuCTXwb91W9TDTobBdo8v8G1h/fOnRImNgQHsjMC1BD3q6LIpefmHhy
c1apVKMGm6oPQ63SmOg4EvykMusf6On/7KQikolrvYV5XHcNzFTXqc74MDF6
2f0pRp8G+D/7JpXZkf2uXFVKxnNguZVv+mWGQhErVrDdWQuLDu/yMx+lcJGi
oYKSayHTP9slQk4h+0QGz/fQC9Avi1xdcoVCk+pYsWrhGJjdqbH1zqEwtVCc
u7B1DGwKW8KeJVPY4nJmnhVfB718/4ZDYRRaBae6ZlqMQ4XZ6j3+3hQOr37Q
d7R5HHoTTDPX2FF4rQSc1bEvoeLxbS2PQWGM2MvKfu4l+CiaDodoGXgqqzxj
+PcJcC10W3nsHgOvau2LLEL1QImEJl1SBoZZWfh0TuvBx1zzaXwhA7PZlN0w
8fPjQk4csXzKMDtJnB/krN5N7KUaabN9r4fXU4mlEcS2kqvb+MRXGo3WQcQq
3pZE6xk9/FuawlxDLBCdy/9yVg+O7lHK2Uvk/9ypo+nEsvXLW6aJNacE0bnE
MXUvC98RRyVFL79BXFByZscr4nVrXevmz+mBNdRzT03MGb7bfp1Y3lbcfJcY
Hsh+6yDeVXm88A5xulySM0SsV8aktxOP1RaFsY16WJri7Ckj7jlxYCSKOH78
dk09MZ0adyuZ+LWk9qyYGBPCKzOJhU9EibXE9Vv9kmqJq3zSnK4Q6za4hd4m
9hDsY1QSO3s7ufUTt5pFKkuJY11sFuqIt1HBLcXEBQ6mBiPxCM+/6BLxf1jG
Tb0=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"\[Lambda]\"", TraditionalForm], 
    FormBox["\"p\"", TraditionalForm]},
  AxesOrigin->{0, 2.},
  PlotRange->{{0, 1}, {2.000000004081633, 2.999999979591837}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.389697903785224*^9, 3.3897184142422237`*^9, 
  3.3897188127686243`*^9, 3.3899922926566*^9},
 CellLabel->"Out[212]="]
}, Closed]],

Cell["Determination of the single-price equilibrium arrival rate:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Lambda]Eq", "=", 
  RowBox[{"\[Lambda]", "/.", 
   RowBox[{"Flatten", "[", 
    RowBox[{"NSolve", "[", 
     RowBox[{
      RowBox[{"ps", "\[Equal]", "pb"}], ",", "\[Lambda]"}], "]"}], 
    "]"}]}]}]], "Input",
 CellLabel->"In[213]:="],

Cell[BoxData["0.8333333333333334`"], "Output",
 CellChangeTimes->{3.3896979038332243`*^9, 3.389718414290224*^9, 
  3.389718812787624*^9, 3.3899922926846*^9},
 CellLabel->"Out[213]="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pEq", "=", 
  RowBox[{"ps", "/.", 
   RowBox[{"\[Lambda]", "\[Rule]", "\[Lambda]Eq"}]}]}]], "Input",
 CellLabel->"In[214]:="],

Cell[BoxData["2.3055555555555554`"], "Output",
 CellChangeTimes->{3.389697903860224*^9, 3.3897184143262243`*^9, 
  3.389718812815624*^9, 3.3899922927326*^9},
 CellLabel->"Out[214]="]
}, Closed]],

Cell["(Optimal) average profit and arrival intensity:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"NMaximize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Lambda]", 
       RowBox[{"(", 
        RowBox[{"pb", "-", "ps"}], ")"}]}], ",", 
      RowBox[{"\[Lambda]", ">", "0"}]}], "}"}], ",", "\[Lambda]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[215]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.20833333333333331`", ",", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]", "\[Rule]", "0.41666666666666663`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.389697904222224*^9, 3.3897184144262238`*^9, 
  3.389718812879624*^9, 3.3899922929326*^9},
 CellLabel->"Out[215]="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Lambda]Opt", "=", 
  RowBox[{"\[Lambda]", "/.", 
   RowBox[{"sol", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", "1"}], "]"}], "]"}]}]}]], "Input",
 CellLabel->"In[216]:="],

Cell[BoxData["0.41666666666666663`"], "Output",
 CellChangeTimes->{3.389697904250224*^9, 3.3897184144592237`*^9, 
  3.3897188129276237`*^9, 3.3899922929816*^9},
 CellLabel->"Out[216]="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"bid", "=", 
  RowBox[{"ps", "/.", 
   RowBox[{"\[Lambda]", "\[Rule]", "\[Lambda]Opt"}]}]}]], "Input",
 CellLabel->"In[217]:="],

Cell[BoxData["2.1180555555555554`"], "Output",
 CellChangeTimes->{3.389697904280224*^9, 3.389718414495224*^9, 
  3.389718812955624*^9, 3.3899922930425997`*^9},
 CellLabel->"Out[217]="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ask", "=", 
  RowBox[{"pb", "/.", 
   RowBox[{"\[Lambda]", "\[Rule]", "\[Lambda]Opt"}]}]}]], "Input",
 CellLabel->"In[218]:="],

Cell[BoxData["2.6180555555555554`"], "Output",
 CellChangeTimes->{3.389697904310224*^9, 3.389718414535224*^9, 
  3.3897188129856243`*^9, 3.3899922930976*^9},
 CellLabel->"Out[218]="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"extra", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"GrayLevel", "[", "0.9`", "]"}], ",", 
     RowBox[{"Rectangle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.01`", ",", "bid"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Lambda]Opt", ",", "ask"}], "}"}]}], "]"}], ",", 
     RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
     RowBox[{"Dashing", "[", 
      RowBox[{"{", "0.01`", "}"}], "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\[Lambda]Opt", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Lambda]Opt", ",", "ask"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "bid"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Lambda]Opt", ",", "bid"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "ask"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Lambda]Opt", ",", "ask"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\[Lambda]Eq", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Lambda]Eq", ",", "pEq"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "pEq"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Lambda]Eq", ",", "pEq"}], "}"}]}], "}"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{
      "\"\<\!\(\*SuperscriptBox[\(\[Lambda]\), \(Buy\)]\)(p)\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"0.3`", ",", "2.9`"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{
      "\"\<\!\(\*SuperscriptBox[\(\[Lambda]\), \(Sell\)]\)(p)\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"1.05`", ",", "2.6`"}], "}"}]}], "]"}]}], 
    "\[IndentingNewLine]", "}"}]}], ";"}], "\n", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ps", ",", "pb"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]", ",", "0", ",", "1.2`"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1.2`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.8`", ",", "3.1`"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Arrival rate\>\"", ",", "\"\<Price, p\>\""}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "\[Lambda]Opt", ",", " ", 
          "\"\<\!\(\*SuperscriptBox[\(\[Lambda]\), \(Optimal\)]\) \>\""}], 
         "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "\[Lambda]Eq", ",", 
          "\"\<\!\(\*SuperscriptBox[\(\[Lambda]\), \(Eq\)]\)\>\""}], "}"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"bid", ",", "Bid"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ask", ",", "Ask"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "pEq", ",", "\"\<\!\(\*SuperscriptBox[\(p\), \(Eq\)]\)\>\""}], 
         "}"}]}], "}"}], ",", "None", ",", "None"}], "}"}]}], ",", 
   RowBox[{"Epilog", "\[Rule]", "extra"}], ",", 
   RowBox[{"BaseStyle", "\[Rule]", "baseStyle"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.389718018864224*^9, 3.389718154928224*^9}, {
  3.389718195495224*^9, 3.389718220869224*^9}, {3.389718255610224*^9, 
  3.3897183983012238`*^9}, {3.389718497233224*^9, 3.389718571626224*^9}, {
  3.389718610594224*^9, 3.389718616046224*^9}},
 CellLabel->"In[219]:="],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVz3s0lHkcx/Hf8zy6mKQNlZUmE6mkC2Ni1fh+SVGaynWlK1aHQboe3ZBL
p4tqjVKWVOsoTUWJhjjlRFddx+VExKBBW2oukdJp97d/fM77vP78CMLi/CJY
QshKuv+r75g4r8wnxK1v+WUqgnmpU62MprqAPEiRa0sdN7388Gu+N1hyPDcJ
dfAgK77DDwZLt5TsHOrn7TMn3eBHwt5FigIRQ3BUw8I0OX833A6xt4hlCdpI
Hrhe4h8G1ym+ezoNCAp5vNMF/GyQVO4frTIkeFb5ZUTANDkAabA1n0CwMaJM
ev/qTRhd4REx1orgnLm+78oLK4DtJSEwm+CgnUlS6vRq0Ndp69TOBN3P8/yc
cmoguex0zRxPgriYP5DZ9QDs9mUcZ/wI9q2wFpyb/AR0322+WWwiqAtdZrJg
yjOYLZIX3o4l6CRjzCo3voTSzj8dmQSC/RGxsREiJYQFlWVXpxM0U/hN8Cyt
h7zz415dyqH/TZMfZPs2QnvrSJH/VYKSQWgWNjbBsOLu55Aqght6vPSe8a/h
31mZfHhO0PPIY79rJi0w3vwEG9hBsLWkxSwk8w3UnN1idEVD8ESvsCPBsQ1a
NSRpiGNQl8836lO8Bb5ybGX8RAa3R/u5P17bAbUZC6pHzWYwfEfS+qT9Kuiu
ICfuAoNqfd5TsbgTAnYLm474MzjwXSV2Nu4C2SPRj5QoBts9Yzr9lV0QZXVq
Tkoigw59wsLcjG5Y/XDvivSTDJqYWG3jb3oHmjO/yNuvMPgsMSDmvkANwgvO
iZb3GDTbXhR9Ua8G9aamzqoWBh/e9Thecq8HZKFvLLboGPRdaaVSJffC156l
GZ8MWZT+Mc3Zx68PkuM3Z/Vbs7j2Tkx1s9l7UPfM3HFtEYvlcfooWcN7SFn+
ZENoIIt/Xz5nfjD/H0j4mmZdspXFcJvModzwD+CtJ4svHmWx1PZKW7/TR+hx
v7PPp5DFtmieLmzoIzgo6nMO1bAYxyucxVX0g69xkb74LYsZ8yIj2g99gsit
klcFwywePbOtvm3ZZzi4b+6AmTmHvNqXgjHGGrAdoR6SOnNo0JsWLd6lAW2J
/bRbQRxK7dslyU0asL8m9lm/k8NJt5bd7BJroSlzZOjoLA7nb1xzPfC8FvIP
7jHiyjj8KTokbv+pBfIrGDbVc2i6+pEkbbMOFurqvB9+4TAr/ergwkc66M57
dfKDmQFu4OULxs/XQ+kBwxgvFwOUcC/kU6hPWQYU+1Av+vHNwY56xPULmlXU
Fp98PRZTy8phVzD1ayUTvos65PesxCjq1X+FFrRQX1Sek6VTe8wUzMh30IN9
id3tl9QOAsn1YmoVv2y4gdrKYo9zFbV1Krg1U/8co/RqpA6Yt65WRV31+UDk
SEc9bJ5Y9FxL7VSukkupl0wt6jL9zQCtbxg5xlN3DwRON6c2kbtUplKPqyWR
ltTanIy6s9Sm7uv6baiLE/HDC+q6p3ZDIuq8+JgdrdRtQd2urtTHtmYP91In
NOcluFFLwzRjGKEepNXmnBf1mrWWp8ZSK2xalvhQewd4W1pQyw7kHl5F7SLZ
WWBLPVy/8ak/9YylF+yF1PrJtsbB1P8B8XUULw==
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwVx384E3gcwPH9Xsap1vpx0ph+kKcUW3Jl9/mEwtWK0RM6YuJq1rly029a
5dRVyKNyoeLRsYpUmKeu6+nK0eXSRDi7kcbWDxnLnnQ73ff+eD/v5yWQpUqT
aBQKZT3p/1t6ZyypXRvz5b7j9bZPn9hYcsTF1cHFD3jDq+yBOHW+5lgnPwTi
x7iCjAk2Rllp4rv8KJhiyJLZbGz8U+8xs4a/DbSh1/3Hx9nIfrbyqJq/B9p9
p6x/b2HjPEnjip/5x0B/ljMwbGSjkMM5W84vBFrqi5e2VjYWa98zI93UoKGF
xacVs7E9qVb+8OpNKI4JKG1VsHGxV7hBU9EAeys5PTlfstHqyc08Mv8emA83
TTY4sHHVRY5UdP43iK0rS6X3shAD+WP5/Y2QVVwgeFrFQtO6uYILsx9BwZ3K
+kkZLBxNCOX6zmkBhXGGcDichaLTVN7tLa3gG6vmXHJj4VDSjh1Jy7SQOfQy
wWxlIq9eOj3oVhs4aXUtuS1MjJqmaiwMb4e4TKFh+kUmSqzQJWzvgOf8ujEX
JRPjBoMtQbs7oWsx76N7CBODjjdLr3G7ocp3rjXbmYk9N7p5Mfl/wT4P1S8b
3jMwxyjsPeijA+l9qdznEQNHy/gOpvq/ocrPLuvbUgbuSpGuat7cC/bflJh0
6QxMTMuMzTzQB9cOxEQVShg4YCl5LBa/AOv+14Y8dwaOfewTL3fsh+p++6dd
E3TUByleRGj7IfqyZfuGbjp6m4QVRXkvoUf4RmitpSOX67qTH28ATWPE7Uk5
dGzJiFQ8FAxAbp8m1ktOR96uqpTLlgHYcyLSsTOQjr//GnDqxv1BcBvrfd7A
p2P4ete+PpUR9MvEh07baCjf6rZ8rdQEsujJfpwuGm6+q7jXxXsFM6rfKVLq
aahJtWw//ewVPFYKR01naFhaeWFWVtlrOBS3sdUtjYaJ8/I/FCW+gVhT6dWF
ETS8teCKbkj0FmqKzS4MbxrqUjijsg9vYdIjmkvJVBqmcioW0huG4N9NCeeD
LVTMW7ItSZ/9Do43B8/qb6Pij+d2tulChyFd1H3YpY6KnAetAntHM/xgpa7d
eoaKDOPRFLHSDMdiAvc/SKeifJFeouowQ0RcwwZ1DBVn1oXe7BePgNeCitxb
/lRcuiX6+saLI5C17oqdr4CKE8uyxfqJERDlZ8+sZ1FxWliT5GjyKCSOvR1M
f03BMyeuWlc2jcKmg77JBU8pGMcpE0xdagEeTzliV0dBCf2Jeg4xRdVVzSL2
t417exLvM4gVdGKnd+EBgcSzcx2NtloKdmqpiUpih7Qm3TBx2E8J5d3EauW5
5g7iAA+Be5m3BbRJNaWlxN4CyfVq4txy6ZYLxK5Oe5ffIdZ1W52LiCfstcHt
xG4eqwsLiO8MH9rG8rHA1xHjOdnEIk2fWk58ynDvwA7iuTUOPruJRSdVK+TE
XLXf7SPEcs/VH5KJR87n/VFMfPirtrR44uoMfPOEWPY5IyWCuGS3Iq2HOEPZ
4RFGfPK7wn+MxAubKwfXEctlZnuq0AKe4Rtla4ijNzsXfEasyvZyDSQOiQxx
diJOrrXTA7Gf5PvyBcTdnYNF/sTuay4tEhLrRhqjvyD+D0LJMUE=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 1.8},
  Background->GrayLevel[1],
  BaseStyle->{FontFamily -> "Times", FontSize -> 12},
  Epilog->{
    GrayLevel[0.9], 
    RectangleBox[{0.01, 2.1180555555555554`}, {0.41666666666666663`, 
     2.6180555555555554`}], 
    GrayLevel[0], 
    Dashing[{0.01}], 
    LineBox[{{0.41666666666666663`, 0}, {0.41666666666666663`, 
      2.6180555555555554`}}], 
    LineBox[{{0, 2.1180555555555554`}, {0.41666666666666663`, 
      2.1180555555555554`}}], 
    LineBox[{{0, 2.6180555555555554`}, {0.41666666666666663`, 
      2.6180555555555554`}}], 
    LineBox[{{0.8333333333333334, 0}, {0.8333333333333334, 
      2.3055555555555554`}}], 
    LineBox[{{0, 2.3055555555555554`}, {0.8333333333333334, 
      2.3055555555555554`}}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*SuperscriptBox[\\(\[Lambda]\\), \\(Buy\\)]\\)(p)\"", 
      TraditionalForm], {0.3, 2.9}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*SuperscriptBox[\\(\[Lambda]\\), \\(Sell\\)]\\)(p)\"", 
      TraditionalForm], {1.05, 2.6}]},
  Frame->True,
  FrameLabel->{
    FormBox["\"Arrival rate\"", TraditionalForm], 
    FormBox["\"Price, p\"", TraditionalForm]},
  FrameTicks->{{{0.41666666666666663`, 
      FormBox[
      "\"\\!\\(\\*SuperscriptBox[\\(\[Lambda]\\), \\(Optimal\\)]\\) \"", 
       TraditionalForm]}, {0.8333333333333334, 
      FormBox[
      "\"\\!\\(\\*SuperscriptBox[\\(\[Lambda]\\), \\(Eq\\)]\\)\"", 
       TraditionalForm]}}, {{2.1180555555555554`, 
      FormBox["Bid", TraditionalForm]}, {2.6180555555555554`, 
      FormBox["Ask", TraditionalForm]}, {2.3055555555555554`, 
      FormBox[
      "\"\\!\\(\\*SuperscriptBox[\\(p\\), \\(Eq\\)]\\)\"", TraditionalForm]}},
     None, None},
  PlotRange->{{0, 1.2}, {1.8, 3.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.3896979043592243`*^9, 3.3897184145902243`*^9, {3.389718502883224*^9, 
   3.3897185291752243`*^9}, 3.389718573661224*^9, 3.389718616518224*^9, 
   3.389718813045624*^9, 3.3899922931906*^9},
 CellLabel->"Out[220]="]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Risk aversion and dealer behavior (Section 11.2)", "Section",
 CellTags->"c:150"],

Cell[CellGroupData[{

Cell["One security", "Subsection",
 CellTags->"c:151"],

Cell["\<\
The certainty equivalent in the CARA-Normal framework is given by the \
following rule. (There is a change of notation; the risk-aversion parameter \
is \[Alpha].)\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["EU", "Rule"], "=", 
  RowBox[{
   RowBox[{"EU", "[", 
    RowBox[{"\[Mu]_", ",", "var_"}], "]"}], "\[RuleDelayed]", 
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"CharacteristicFunction", "[", 
       RowBox[{
        RowBox[{"NormalDistribution", "[", 
         RowBox[{"\[Mu]", ",", 
          SqrtBox["var"]}], "]"}], ",", "t"}], "]"}]}], "/.", 
     RowBox[{"t", "\[Rule]", 
      RowBox[{"I", " ", "\[Alpha]"}]}]}], "]"}]}]}]], "Input",
 CellLabel->"In[221]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"EU", "[", 
   RowBox[{"\[Mu]_", ",", "var_"}], "]"}], "\[RuleDelayed]", 
  RowBox[{"-", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     FractionBox[
      RowBox[{"var", " ", 
       SuperscriptBox["\[Alpha]", "2"]}], "2"], "-", 
     RowBox[{"\[Alpha]", " ", "\[Mu]"}]}]]}]}]], "Output",
 CellChangeTimes->{3.389697904428224*^9, 3.389718631220224*^9, 
  3.389718813076624*^9, 3.3899922932746*^9},
 CellLabel->"Out[221]="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["CE", "Rule"], "=", 
  RowBox[{
   RowBox[{"CE", "[", 
    RowBox[{"\[Mu]_", ",", "var_"}], "]"}], "\[RuleDelayed]", 
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Exponent", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"CharacteristicFunction", "[", 
            RowBox[{
             RowBox[{"NormalDistribution", "[", 
              RowBox[{"\[Mu]", ",", 
               SqrtBox["var"]}], "]"}], ",", "t"}], "]"}]}], "/.", 
          RowBox[{"t", "\[Rule]", 
           RowBox[{"I", " ", "\[Alpha]"}]}]}], ",", "E"}], "]"}]}], "/", 
      "\[Alpha]"}], "//", "Simplify"}], "]"}]}]}]], "Input",
 CellLabel->"In[222]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"CE", "[", 
   RowBox[{"\[Mu]_", ",", "var_"}], "]"}], "\[RuleDelayed]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"var", " ", "\[Alpha]"}], "2"]}], "+", "\[Mu]"}]}]], "Output",
 CellChangeTimes->{3.389697904461224*^9, 3.389718631266224*^9, 
  3.3897188131106243`*^9, 3.3899922933356*^9},
 CellLabel->"Out[222]="]
}, Closed]],

Cell[TextData[{
 "Starting with ",
 Cell[BoxData["n"]],
 " shares, the bid at which the dealer is indifferent is:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["B", "Rule"], "=", 
  RowBox[{
   RowBox[{"Take", " ", "@@", " ", 
    RowBox[{"Flatten", " ", "@@", " ", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"CE", "[", 
          RowBox[{
           RowBox[{"n", " ", 
            SubscriptBox["\[Mu]", "X"]}], ",", 
           RowBox[{
            SuperscriptBox["n", "2"], 
            SubsuperscriptBox["\[Sigma]", "X", "2"]}]}], "]"}], "\[Equal]", 
         RowBox[{"CE", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}], 
             SubscriptBox["\[Mu]", "X"]}], "-", "B"}], ",", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}], "2"], 
            SubsuperscriptBox["\[Sigma]", "X", "2"]}]}], "]"}]}], "/.", 
        SubscriptBox["CE", "Rule"]}], ",", "B"}], "]"}]}]}], "//", 
   "Simplify"}]}]], "Input",
 CellLabel->"In[223]:="],

Cell[BoxData[
 RowBox[{"B", "\[Rule]", 
  RowBox[{
   SubscriptBox["\[Mu]", "X"], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "n"}]}], ")"}], " ", "\[Alpha]", " ", 
    SubsuperscriptBox["\[Sigma]", "X", "2"]}]}]}]], "Output",
 CellChangeTimes->{3.389697904522224*^9, 3.389718631302224*^9, 
  3.389718813156624*^9, 3.3899922934035997`*^9},
 CellLabel->"Out[223]="]
}, Closed]],

Cell[TextData[{
 "with a notional price ",
 Cell[BoxData["P"]],
 ", the optimal n is:"
}], "Text",
 CellTags->"c:152"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["nOpt", "Rule"], "=", 
  RowBox[{"Take", " ", "@@", " ", 
   RowBox[{"Flatten", " ", "@@", " ", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["\[PartialD]", "n"], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"CE", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"n", " ", 
              SubscriptBox["\[Mu]", "X"]}], "-", 
             RowBox[{"n", " ", "P"}]}], ",", 
            RowBox[{
             SuperscriptBox["n", "2"], 
             SubsuperscriptBox["\[Sigma]", "X", "2"]}]}], "]"}], "/.", 
          SubscriptBox["CE", "Rule"]}], ")"}]}], "\[Equal]", "0"}], ",", 
      "n"}], "]"}]}]}]}]], "Input",
 CellLabel->"In[224]:="],

Cell[BoxData[
 RowBox[{"n", "\[Rule]", 
  FractionBox[
   RowBox[{
    RowBox[{"-", "P"}], "+", 
    SubscriptBox["\[Mu]", "X"]}], 
   RowBox[{"\[Alpha]", " ", 
    SubsuperscriptBox["\[Sigma]", "X", "2"]}]]}]], "Output",
 CellChangeTimes->{3.389697904554224*^9, 3.389718631347224*^9, 
  3.389718813189624*^9, 3.3899922934625998`*^9},
 CellLabel->"Out[224]="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["B", "Rule"], "/.", 
   SubscriptBox["nOpt", "Rule"]}], "//", "Simplify"}]], "Input",
 CellLabel->"In[225]:="],

Cell[BoxData[
 RowBox[{"B", "\[Rule]", 
  RowBox[{"P", "-", 
   FractionBox[
    RowBox[{"\[Alpha]", " ", 
     SubsuperscriptBox["\[Sigma]", "X", "2"]}], "2"]}]}]], "Output",
 CellChangeTimes->{3.3896979045842237`*^9, 3.389718631387224*^9, 
  3.389718813219624*^9, 3.3899922935116*^9},
 CellLabel->"Out[225]="]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Two securities: setting the bid with correlated risky assets", \
"Subsection",
 CellTags->"c:154"],

Cell[TextData[{
 "Suppose that we have two assets with payoffs ",
 Cell[BoxData[
  FormBox[
   RowBox[{"X", "~", 
    RowBox[{"N", "(", 
     RowBox[{"\[Mu]", ",", "\[CapitalOmega]"}]}]}], TraditionalForm]]],
 ") bivariate normal. The expanded notation treats ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", ",", " ", "B", ",", " ", "\[Mu]", ",", " ", 
    RowBox[{"and", " ", "P"}]}], TraditionalForm]]],
 " as vectors:"
}], "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["n", "_"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["B", "_"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["P", "_"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["\[Sigma]", "_"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";"}]}], "Input",
 CellLabel->"In[226]:="],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["All", "Rules"], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"n", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         SubscriptBox["n", "1"], "}"}], ",", 
        RowBox[{"{", 
         SubscriptBox["n", "2"], "}"}]}], "}"}]}], ",", 
     RowBox[{"B", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         SubscriptBox["B", "1"], "}"}], ",", 
        RowBox[{"{", 
         SubscriptBox["B", "2"], "}"}]}], "}"}]}], ",", 
     RowBox[{"\[Mu]", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         SubscriptBox["\[Mu]", "1"], "}"}], ",", 
        RowBox[{"{", 
         SubscriptBox["\[Mu]", "2"], "}"}]}], "}"}]}], ",", 
     RowBox[{"P", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         SubscriptBox["P", "1"], "}"}], ",", 
        RowBox[{"{", 
         SubscriptBox["P", "2"], "}"}]}], "}"}]}], ",", "\[IndentingNewLine]",
      
     RowBox[{"\[CapitalOmega]", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubsuperscriptBox["\[Sigma]", "1", "2"], ",", 
          RowBox[{"\[Rho]", " ", 
           SubscriptBox["\[Sigma]", "1"], 
           SubscriptBox["\[Sigma]", "2"]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\[Rho]", " ", 
           SubscriptBox["\[Sigma]", "1"], 
           SubscriptBox["\[Sigma]", "2"]}], ",", 
          SubsuperscriptBox["\[Sigma]", "2", "2"]}], "}"}]}], "}"}]}]}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{"Map", "[", 
   RowBox[{"MatrixForm", ",", 
    SubscriptBox["All", "Rules"], ",", "2"}], "]"}], "}"}]}], "Input",
 CellChangeTimes->{{3.389718643253224*^9, 3.389718645250224*^9}},
 CellLabel->"In[230]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    TagBox[
     RowBox[{
      TagBox["n",
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], "\[Rule]", 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {
           SubscriptBox["n", "1"]},
          {
           SubscriptBox["n", "2"]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]]}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]], ",", 
    TagBox[
     RowBox[{
      TagBox["B",
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], "\[Rule]", 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {
           SubscriptBox["B", "1"]},
          {
           SubscriptBox["B", "2"]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]]}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]], ",", 
    TagBox[
     RowBox[{
      TagBox["\[Mu]",
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], "\[Rule]", 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {
           SubscriptBox["\[Mu]", "1"]},
          {
           SubscriptBox["\[Mu]", "2"]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]]}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]], ",", 
    TagBox[
     RowBox[{
      TagBox["P",
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], "\[Rule]", 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {
           SubscriptBox["P", "1"]},
          {
           SubscriptBox["P", "2"]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]]}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]], ",", 
    TagBox[
     RowBox[{
      TagBox["\[CapitalOmega]",
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], "\[Rule]", 
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {
           SubsuperscriptBox["\[Sigma]", "1", "2"], 
           RowBox[{"\[Rho]", " ", 
            SubscriptBox["\[Sigma]", "1"], " ", 
            SubscriptBox["\[Sigma]", "2"]}]},
          {
           RowBox[{"\[Rho]", " ", 
            SubscriptBox["\[Sigma]", "1"], " ", 
            SubscriptBox["\[Sigma]", "2"]}], 
           SubsuperscriptBox["\[Sigma]", "2", "2"]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]]}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.389697904651224*^9, {3.389718631437224*^9, 3.3897186461052237`*^9}, 
   3.389718813291624*^9, 3.3899922936336*^9},
 CellLabel->"Out[231]="]
}, Closed]],

Cell[TextData[{
 "Find the bid for security 1 that's consistent with the same CE before and \
after an execution (aquisition of one more share of security 1 at price ",
 Cell[BoxData[
  SubscriptBox["B", "1"]]],
 ")."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["B1", "Rule"], "=", 
  RowBox[{
   RowBox[{"Take", " ", "@@", " ", 
    RowBox[{"Flatten", " ", "@@", " ", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"CE", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Transpose", "[", "n", "]"}], ".", "\[Mu]"}], ",", 
            RowBox[{
             RowBox[{"Transpose", "[", "n", "]"}], ".", "\[CapitalOmega]", 
             ".", "n"}]}], "]"}], "\[Equal]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"CE", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"Transpose", "[", "n", "]"}], ".", "\[Mu]"}], "-", 
               SubscriptBox["B", "1"]}], ",", 
              RowBox[{
               RowBox[{"Transpose", "[", "n", "]"}], ".", "\[CapitalOmega]", 
               ".", "n"}]}], "]"}], "/.", 
            RowBox[{"n", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 SubscriptBox["n", "1"], "+", "1"}], "}"}], ",", 
               RowBox[{"{", 
                SubscriptBox["n", "2"], "}"}]}], "}"}]}]}], ")"}]}], "/.", 
         SubscriptBox["CE", "Rule"]}], "/.", 
        SubscriptBox["All", "Rules"]}], ",", 
       SubscriptBox["B", "1"]}], "]"}]}]}], "//", "FullSimplify"}]}]], "Input",\

 CellLabel->"In[232]:="],

Cell[BoxData[
 RowBox[{
  SubscriptBox["B", "1"], "\[Rule]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], " ", "\[Alpha]", " ", 
    SubscriptBox["\[Sigma]", "1"], " ", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["\[Sigma]", "1"], "+", 
      RowBox[{"2", " ", 
       SubscriptBox["n", "1"], " ", 
       SubscriptBox["\[Sigma]", "1"]}], "+", 
      RowBox[{"2", " ", 
       SubscriptBox["n", "2"], " ", "\[Rho]", " ", 
       SubscriptBox["\[Sigma]", "2"]}]}], ")"}]}], "+", 
   SubscriptBox["\[Mu]", "1"]}]}]], "Output",
 CellChangeTimes->{
  3.389697904854224*^9, {3.389718633740224*^9, 3.389718659622224*^9}, 
   3.389718813535624*^9, 3.3899922938426*^9},
 CellLabel->"Out[232]="]
}, Closed]],

Cell["At the optimum:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["nOpt", "Rules"], "=", 
  RowBox[{
   RowBox[{"First", " ", "@", " ", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"0", "\[Equal]", "#"}], "&"}], " ", "/@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           SubscriptBox["\[PartialD]", "#"], 
           RowBox[{"Take", " ", "@@", " ", 
            RowBox[{"Flatten", " ", "@@", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"CE", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"Transpose", "[", "n", "]"}], ".", 
                   RowBox[{"(", 
                    RowBox[{"\[Mu]", "-", "P"}], ")"}]}], ",", 
                  RowBox[{
                   RowBox[{"Transpose", "[", "n", "]"}], ".", 
                   "\[CapitalOmega]", ".", "n"}]}], "]"}], "/.", 
                SubscriptBox["CE", "Rule"]}], "/.", 
               SubscriptBox["All", "Rules"]}], ")"}]}]}]}], "&"}], " ", "/@", 
         
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["n", "1"], ",", 
           SubscriptBox["n", "2"]}], "}"}]}], ")"}]}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["n", "1"], ",", 
        SubscriptBox["n", "2"]}], "}"}]}], "]"}]}], "//", 
   "Simplify"}]}]], "Input",
 CellLabel->"In[233]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["n", "1"], "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{
       SubscriptBox["P", "2"], " ", "\[Rho]", " ", 
       SubscriptBox["\[Sigma]", "1"]}], "-", 
      RowBox[{
       SubscriptBox["P", "1"], " ", 
       SubscriptBox["\[Sigma]", "2"]}], "+", 
      RowBox[{
       SubscriptBox["\[Sigma]", "2"], " ", 
       SubscriptBox["\[Mu]", "1"]}], "-", 
      RowBox[{"\[Rho]", " ", 
       SubscriptBox["\[Sigma]", "1"], " ", 
       SubscriptBox["\[Mu]", "2"]}]}], 
     RowBox[{
      RowBox[{"\[Alpha]", " ", 
       SubsuperscriptBox["\[Sigma]", "1", "2"], " ", 
       SubscriptBox["\[Sigma]", "2"]}], "-", 
      RowBox[{"\[Alpha]", " ", 
       SuperscriptBox["\[Rho]", "2"], " ", 
       SubsuperscriptBox["\[Sigma]", "1", "2"], " ", 
       SubscriptBox["\[Sigma]", "2"]}]}]]}], ",", 
   RowBox[{
    SubscriptBox["n", "2"], "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{
       SubscriptBox["P", "2"], " ", 
       SubscriptBox["\[Sigma]", "1"]}], "-", 
      RowBox[{
       SubscriptBox["P", "1"], " ", "\[Rho]", " ", 
       SubscriptBox["\[Sigma]", "2"]}], "+", 
      RowBox[{"\[Rho]", " ", 
       SubscriptBox["\[Sigma]", "2"], " ", 
       SubscriptBox["\[Mu]", "1"]}], "-", 
      RowBox[{
       SubscriptBox["\[Sigma]", "1"], " ", 
       SubscriptBox["\[Mu]", "2"]}]}], 
     RowBox[{"\[Alpha]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[Rho]", "2"]}], ")"}], " ", 
      SubscriptBox["\[Sigma]", "1"], " ", 
      SubsuperscriptBox["\[Sigma]", "2", "2"]}]]}]}], "}"}]], "Output",
 CellChangeTimes->{3.389697904922224*^9, 3.389718633839224*^9, 
  3.3897188135736237`*^9, 3.3899922939606*^9},
 CellLabel->"Out[233]="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["B1", "Rule"], "/.", 
   SubscriptBox["nOpt", "Rules"]}], "//", "Simplify"}]], "Input",
 CellLabel->"In[234]:="],

Cell[BoxData[
 RowBox[{
  SubscriptBox["B", "1"], "\[Rule]", 
  RowBox[{
   SubscriptBox["P", "1"], "-", 
   FractionBox[
    RowBox[{"\[Alpha]", " ", 
     SubsuperscriptBox["\[Sigma]", "1", "2"]}], "2"]}]}]], "Output",
 CellChangeTimes->{3.389697904957224*^9, 3.389718634486224*^9, 
  3.389718813612624*^9, 3.3899922940136003`*^9},
 CellLabel->"Out[234]="]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]]
},
AutoGeneratedPackage->None,
WindowSize->{1578, 1027},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Visible->True,
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
InputAliases->{"intt" -> RowBox[{"\[Integral]", 
     RowBox[{"\[SelectionPlaceholder]", 
       RowBox[{"\[DifferentialD]", "\[Placeholder]"}]}]}], "dintt" -> 
  RowBox[{
     SubsuperscriptBox[
     "\[Integral]", "\[SelectionPlaceholder]", "\[Placeholder]"], 
     RowBox[{"\[Placeholder]", 
       RowBox[{"\[DifferentialD]", "\[Placeholder]"}]}]}], "sumt" -> RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"\[SelectionPlaceholder]", "=", "\[Placeholder]"}], 
      "\[Placeholder]"], "\[Placeholder]"}], "prodt" -> RowBox[{
     UnderoverscriptBox["\[Product]", 
      RowBox[{"\[SelectionPlaceholder]", "=", "\[Placeholder]"}], 
      "\[Placeholder]"], "\[Placeholder]"}], "dt" -> RowBox[{
     SubscriptBox["\[PartialD]", "\[Placeholder]"], " ", 
     "\[SelectionPlaceholder]"}], "E" -> "\[ScriptCapitalE]", "notation" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], " ", 
       "\[DoubleLongLeftRightArrow]", " ", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "notation>" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], " ", 
       "\[DoubleLongRightArrow]", " ", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "notation<" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], " ", 
       "\[DoubleLongLeftArrow]", " ", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "symb" -> 
  RowBox[{"Symbolize", "[", 
     TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], "]"}], 
  "infixnotation" -> RowBox[{"InfixNotation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], ",", 
       "\[Placeholder]"}], "]"}], "addia" -> RowBox[{"AddInputAlias", "[", 
     RowBox[{"\"\[SelectionPlaceholder]\"", "\[Rule]", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "pattwraper" -> 
  TagBox["\[SelectionPlaceholder]", "NotationPatternTag"], "madeboxeswraper" -> 
  TagBox["\[SelectionPlaceholder]", "NotationMadeBoxesTag"]},
Magnification->1.5,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->"EMMStyle02.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "ExGarman"->{
  Cell[4961, 177, 80, 1, 51, "Section",
   CellTags->"ExGarman"]},
 "c:150"->{
  Cell[25869, 727, 87, 1, 51, "Section",
   CellTags->"c:150"]},
 "c:151"->{
  Cell[25981, 732, 54, 1, 65, "Subsection",
   CellTags->"c:151"]},
 "c:152"->{
  Cell[30055, 872, 118, 5, 33, "Text",
   CellTags->"c:152"]},
 "c:154"->{
  Cell[31878, 942, 104, 2, 65, "Subsection",
   CellTags->"c:154"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"ExGarman", 48938, 1462},
 {"c:150", 49017, 1465},
 {"c:151", 49094, 1468},
 {"c:152", 49174, 1471},
 {"c:154", 49249, 1474}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 855, 24, 430, "Title"],
Cell[CellGroupData[{
Cell[1470, 51, 410, 9, 43, "Input"],
Cell[1883, 62, 720, 16, 51, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2640, 83, 32, 0, 92, "Section"],
Cell[2675, 85, 144, 3, 43, "Input"],
Cell[2822, 90, 366, 12, 43, "Input"],
Cell[3191, 104, 312, 8, 43, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[3540, 117, 52, 0, 51, "Section"],
Cell[CellGroupData[{
Cell[3617, 121, 162, 5, 43, "Input"],
Cell[3782, 128, 303, 9, 61, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[4122, 142, 170, 5, 43, "Input"],
Cell[4295, 149, 271, 8, 38, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[4603, 162, 139, 3, 43, "Input"],
Cell[4745, 167, 167, 4, 56, "Output"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[4961, 177, 80, 1, 51, "Section",
 CellTags->"ExGarman"],
Cell[5044, 180, 88, 2, 32, "Text"],
Cell[5135, 184, 292, 9, 45, "Input"],
Cell[5430, 195, 76, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[5531, 199, 157, 4, 43, "Input"],
Cell[5691, 205, 291, 7, 41, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[6019, 217, 173, 5, 43, "Input"],
Cell[6195, 224, 2131, 41, 353, "Output"]
}, Closed]],
Cell[8341, 268, 63, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[8429, 272, 176, 5, 43, "Input"],
Cell[8608, 279, 261, 6, 41, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[8906, 290, 52, 0, 44, "Subsubsection"],
Cell[CellGroupData[{
Cell[8983, 294, 349, 11, 43, "Input"],
Cell[9335, 307, 3966, 74, 368, "Output"]
}, Closed]],
Cell[13316, 384, 75, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[13416, 388, 261, 8, 43, "Input"],
Cell[13680, 398, 182, 3, 38, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[13899, 406, 149, 4, 43, "Input"],
Cell[14051, 412, 182, 3, 38, "Output"]
}, Closed]],
Cell[14248, 418, 63, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[14336, 422, 323, 11, 43, "Input"],
Cell[14662, 435, 313, 8, 38, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[15012, 448, 199, 6, 43, "Input"],
Cell[15214, 456, 185, 3, 38, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[15436, 464, 150, 4, 43, "Input"],
Cell[15589, 470, 184, 3, 38, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[15810, 478, 150, 4, 43, "Input"],
Cell[15963, 484, 182, 3, 38, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[16182, 492, 4047, 114, 247, "Input"],
Cell[20232, 608, 5576, 112, 373, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[25869, 727, 87, 1, 51, "Section",
 CellTags->"c:150"],
Cell[CellGroupData[{
Cell[25981, 732, 54, 1, 65, "Subsection",
 CellTags->"c:151"],
Cell[26038, 735, 187, 4, 32, "Text"],
Cell[CellGroupData[{
Cell[26250, 743, 536, 16, 56, "Input"],
Cell[26789, 761, 466, 13, 54, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[27292, 779, 745, 22, 56, "Input"],
Cell[28040, 803, 364, 10, 53, "Output"]
}, Closed]],
Cell[28419, 816, 126, 4, 33, "Text"],
Cell[CellGroupData[{
Cell[28570, 824, 1030, 31, 48, "Input"],
Cell[29603, 857, 437, 12, 56, "Output"]
}, Closed]],
Cell[30055, 872, 118, 5, 33, "Text",
 CellTags->"c:152"],
Cell[CellGroupData[{
Cell[30198, 881, 757, 23, 48, "Input"],
Cell[30958, 906, 359, 10, 61, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[31354, 921, 161, 5, 43, "Input"],
Cell[31518, 928, 311, 8, 61, "Output"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[31878, 942, 104, 2, 65, "Subsection",
 CellTags->"c:154"],
Cell[31985, 946, 430, 13, 32, "Text"],
Cell[32418, 961, 750, 28, 133, "Input"],
Cell[CellGroupData[{
Cell[33193, 993, 1826, 56, 102, "Input"],
Cell[35022, 1051, 5031, 148, 67, "Output"]
}, Closed]],
Cell[40068, 1202, 229, 6, 33, "Text"],
Cell[CellGroupData[{
Cell[40322, 1212, 1451, 41, 125, "Input"],
Cell[41776, 1255, 721, 21, 56, "Output"]
}, Closed]],
Cell[42512, 1279, 31, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[42568, 1283, 1405, 41, 98, "Input"],
Cell[43976, 1326, 1792, 52, 64, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[45805, 1383, 163, 5, 43, "Input"],
Cell[45971, 1390, 358, 10, 61, "Output"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
