(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    121972,       3558]
NotebookOptionsPosition[    112501,       3265]
NotebookOutlinePosition[    115654,       3347]
CellTagsIndexPosition[    115572,       3342]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "TradingStrategiesI\n",
 StyleBox["Empirical Market Microstructure",
  FontSlant->"Italic"],
 " \n\t(2006, Oxford University Press)\nCompanion ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook\n\nJoel Hasbrouck\n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Copyright", " ", "2007"}], ",", " ", 
    RowBox[{"Joel", " ", 
     RowBox[{"Hasbrouck", ".", " ", "All"}], " ", "rights", " ", 
     RowBox[{"reserved", "."}]}]}], TraditionalForm]],
  FontSize->14,
  FontSlant->"Italic"],
 "\n",
 StyleBox["This notebook covers the Bertsimas and Lo order splitting model \
(Chapter 15, section 15.1)",
  FontSize->14]
}], "Title",
 CellChangeTimes->{{3.3896255910914*^9, 3.3896255932033997`*^9}, {
  3.3897167078988237`*^9, 3.389716768500824*^9}, {3.3897177261502237`*^9, 
  3.3897177401822243`*^9}, {3.3900307220694304`*^9, 3.3900307405094304`*^9}}],\


Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Text", "  ", "@", " ", 
  RowBox[{"Style", "[", 
   RowBox[{
    RowBox[{"\"\<Notebook evaluated \>\"", "<>", 
     RowBox[{"DateString", "[", "\"\<DateTime\>\"", "]"}]}], ",", 
    "\"\<Subtitle\>\""}], "]"}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896127180972*^9, 3.3896127205282*^9}, 
   3.389716999411824*^9, {3.3897170351038237`*^9, 3.389717047196824*^9}}],

Cell[BoxData[
 InterpretationBox[Cell[BoxData[
   StyleBox["\<\"Notebook evaluated Monday 4 June 2007 20:35:42\"\>", 
    "Subtitle",
    StripOnInput->False]], "Text", "TR"],
  Text[
   Style["Notebook evaluated Monday 4 June 2007 20:35:42", 
    "Subtitle"]]]], "Output",
 CellMargins->{{18, Inherited}, {Inherited, 0}},
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896127211071997`*^9, {3.3896127536242*^9, 3.3896127555652*^9}, 
   3.3896128616452*^9, 3.389623031447*^9, 3.3896232934164*^9, 
   3.389716955274824*^9, 3.3897170008718243`*^9, {3.3897170377738237`*^9, 
   3.3897170482808237`*^9}, 3.3899920823416*^9, 3.3899921326345997`*^9, 
   3.3899925422046003`*^9},
 Background->RGBColor[0.866667, 0.733333, 1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Initializations", "Section"],

Cell[BoxData[
 RowBox[{"<<", "Notation`"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896320663532*^9, 3.3896320701432*^9}}],

Cell["\<\
The following commands define symbolizations that are convenient for labeling \
things.\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["Anything_", "Rule"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";", 
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["Anything_", "Rules"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";"}]], "Input",
 CellLabelAutoDelete->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Basic problem (Section 15.1.1)", "Section"],

Cell[CellGroupData[{

Cell["Model dynamics", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["m", "Rule"], "=", 
   RowBox[{
    SubscriptBox["m", "t_"], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["m", 
        RowBox[{"t", "-", "1"}]], "/.", 
       RowBox[{
        SubscriptBox["m", "0"], "\[Rule]", "0"}]}], ")"}], "+", 
     RowBox[{"\[Lambda]", " ", 
      SubscriptBox["s", "t"]}], "+", "\[Mu]", "+", 
     SubscriptBox["\[Epsilon]", "t"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["p", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", "t"], "+", 
     RowBox[{"\[Gamma]", " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["s", "t"], "/.", 
        RowBox[{
         SubscriptBox["s", "0"], "\[Rule]", "0"}]}], ")"}]}]}]}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["W", "Rule"], "=", 
   RowBox[{
    SubscriptBox["W", "t_"], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{
      SubscriptBox["W", 
       RowBox[{"t", "-", "1"}]], "-", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["s", 
         RowBox[{"t", "-", "1"}]], "/.", 
        RowBox[{
         SubscriptBox["s", "0"], "\[Rule]", "0"}]}], ")"}]}], "/;", 
     RowBox[{"!", 
      RowBox[{"t", "===", "0"}]}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Epsilon]Zap", "=", 
   RowBox[{
    SubscriptBox["\[Epsilon]", "_"], "\[Rule]", "0"}]}], ";"}]}], "Input",
 CellLabelAutoDelete->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Minimize the total expected purchase cost over ",
 Cell[BoxData[
  RowBox[{"T", "=", "3"}]]],
 " periods."
}], "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"T", "=", "3"}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpCost", "=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"t", "=", "1"}], "T"], 
      RowBox[{
       SubscriptBox["p", "t"], 
       SubscriptBox["s", "t"]}]}], ")"}], "//.", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["p", "Rule"], ",", 
      SubscriptBox["m", "Rule"], ",", "\[Epsilon]Zap"}], "}"}]}], 
   ")"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["s", "1"], " ", 
   RowBox[{"(", 
    RowBox[{"\[Mu]", "+", 
     RowBox[{"\[Gamma]", " ", 
      SubscriptBox["s", "1"]}], "+", 
     RowBox[{"\[Lambda]", " ", 
      SubscriptBox["s", "1"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["s", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", "\[Mu]"}], "+", 
     RowBox[{"\[Lambda]", " ", 
      SubscriptBox["s", "1"]}], "+", 
     RowBox[{"\[Gamma]", " ", 
      SubscriptBox["s", "2"]}], "+", 
     RowBox[{"\[Lambda]", " ", 
      SubscriptBox["s", "2"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["s", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"3", " ", "\[Mu]"}], "+", 
     RowBox[{"\[Lambda]", " ", 
      SubscriptBox["s", "1"]}], "+", 
     RowBox[{"\[Lambda]", " ", 
      SubscriptBox["s", "2"]}], "+", 
     RowBox[{"\[Gamma]", " ", 
      SubscriptBox["s", "3"]}], "+", 
     RowBox[{"\[Lambda]", " ", 
      SubscriptBox["s", "3"]}]}], ")"}]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389717442836224*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Lagrangian", "=", 
  RowBox[{"ExpCost", "+", 
   RowBox[{"\[Delta]", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"t", "=", "1"}], "T"], 
       SubscriptBox["s", "t"]}]}], ")"}]}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["s", "1"], " ", 
   RowBox[{"(", 
    RowBox[{"\[Mu]", "+", 
     RowBox[{"\[Gamma]", " ", 
      SubscriptBox["s", "1"]}], "+", 
     RowBox[{"\[Lambda]", " ", 
      SubscriptBox["s", "1"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["s", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", "\[Mu]"}], "+", 
     RowBox[{"\[Lambda]", " ", 
      SubscriptBox["s", "1"]}], "+", 
     RowBox[{"\[Gamma]", " ", 
      SubscriptBox["s", "2"]}], "+", 
     RowBox[{"\[Lambda]", " ", 
      SubscriptBox["s", "2"]}]}], ")"}]}], "+", 
  RowBox[{"\[Delta]", " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     SubscriptBox["s", "1"], "-", 
     SubscriptBox["s", "2"], "-", 
     SubscriptBox["s", "3"]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["s", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"3", " ", "\[Mu]"}], "+", 
     RowBox[{"\[Lambda]", " ", 
      SubscriptBox["s", "1"]}], "+", 
     RowBox[{"\[Lambda]", " ", 
      SubscriptBox["s", "2"]}], "+", 
     RowBox[{"\[Gamma]", " ", 
      SubscriptBox["s", "3"]}], "+", 
     RowBox[{"\[Lambda]", " ", 
      SubscriptBox["s", "3"]}]}], ")"}]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389717442872224*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FOC", "=", 
  RowBox[{"Append", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[PartialD]", 
          SubscriptBox["s", "#"]], " ", "Lagrangian"}], ")"}], "\[Equal]", 
       "0"}], "&"}], " ", "/@", " ", 
     RowBox[{"Range", "[", "T", "]"}]}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[PartialD]", "\[Delta]"], " ", "Lagrangian"}], ")"}], 
     "\[Equal]", "0"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "\[Delta]"}], "+", "\[Mu]", "+", 
     RowBox[{"\[Gamma]", " ", 
      SubscriptBox["s", "1"]}], "+", 
     RowBox[{"\[Lambda]", " ", 
      SubscriptBox["s", "1"]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"\[Gamma]", "+", "\[Lambda]"}], ")"}], " ", 
      SubscriptBox["s", "1"]}], "+", 
     RowBox[{"\[Lambda]", " ", 
      SubscriptBox["s", "2"]}], "+", 
     RowBox[{"\[Lambda]", " ", 
      SubscriptBox["s", "3"]}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "\[Delta]"}], "+", 
     RowBox[{"2", " ", "\[Mu]"}], "+", 
     RowBox[{"\[Lambda]", " ", 
      SubscriptBox["s", "1"]}], "+", 
     RowBox[{"\[Gamma]", " ", 
      SubscriptBox["s", "2"]}], "+", 
     RowBox[{"\[Lambda]", " ", 
      SubscriptBox["s", "2"]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"\[Gamma]", "+", "\[Lambda]"}], ")"}], " ", 
      SubscriptBox["s", "2"]}], "+", 
     RowBox[{"\[Lambda]", " ", 
      SubscriptBox["s", "3"]}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "\[Delta]"}], "+", 
     RowBox[{"3", " ", "\[Mu]"}], "+", 
     RowBox[{"\[Lambda]", " ", 
      SubscriptBox["s", "1"]}], "+", 
     RowBox[{"\[Lambda]", " ", 
      SubscriptBox["s", "2"]}], "+", 
     RowBox[{"\[Gamma]", " ", 
      SubscriptBox["s", "3"]}], "+", 
     RowBox[{"\[Lambda]", " ", 
      SubscriptBox["s", "3"]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"\[Gamma]", "+", "\[Lambda]"}], ")"}], " ", 
      SubscriptBox["s", "3"]}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{"1", "-", 
     SubscriptBox["s", "1"], "-", 
     SubscriptBox["s", "2"], "-", 
     SubscriptBox["s", "3"]}], "\[Equal]", "0"}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389717442916224*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"solutions", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{"FOC", ",", 
     RowBox[{"Append", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         SubscriptBox["s", "i"], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "T"}], "}"}]}], "]"}], ",", "\[Delta]"}], "]"}]}],
     "]"}], "//", "Simplify"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Delta]", "\[Rule]", 
     RowBox[{
      FractionBox["2", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"\[Gamma]", "+", 
        RowBox[{"2", " ", "\[Lambda]"}], "+", 
        RowBox[{"3", " ", "\[Mu]"}]}], ")"}]}]}], ",", 
    RowBox[{
     SubscriptBox["s", "1"], "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{"2", " ", "\[Gamma]"}], "+", "\[Lambda]", "+", 
       RowBox[{"3", " ", "\[Mu]"}]}], 
      RowBox[{
       RowBox[{"6", " ", "\[Gamma]"}], "+", 
       RowBox[{"3", " ", "\[Lambda]"}]}]]}], ",", 
    RowBox[{
     SubscriptBox["s", "2"], "\[Rule]", 
     FractionBox["1", "3"]}], ",", 
    RowBox[{
     SubscriptBox["s", "3"], "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{"2", " ", "\[Gamma]"}], "+", "\[Lambda]", "-", 
       RowBox[{"3", " ", "\[Mu]"}]}], 
      RowBox[{
       RowBox[{"6", " ", "\[Gamma]"}], "+", 
       RowBox[{"3", " ", "\[Lambda]"}]}]]}]}], "}"}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389717442981224*^9}]
}, Open  ]],

Cell["In the no-drift case:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"solutions", "/.", 
   RowBox[{"\[Mu]", "\[Rule]", "0"}]}], "//", "Simplify"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Delta]", "\[Rule]", 
     RowBox[{
      FractionBox["2", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"\[Gamma]", "+", 
        RowBox[{"2", " ", "\[Lambda]"}]}], ")"}]}]}], ",", 
    RowBox[{
     SubscriptBox["s", "1"], "\[Rule]", 
     FractionBox["1", "3"]}], ",", 
    RowBox[{
     SubscriptBox["s", "2"], "\[Rule]", 
     FractionBox["1", "3"]}], ",", 
    RowBox[{
     SubscriptBox["s", "3"], "\[Rule]", 
     FractionBox["1", "3"]}]}], "}"}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389717443028224*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "T", "]"}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell["Procedure", "Subsubsection"],

Cell["The following procedure automates the solution.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"OptOrders", "[", 
    RowBox[{
     RowBox[{"T_:", "3"}], ",", 
     RowBox[{"AllRules_:", 
      RowBox[{"{", "}"}]}], ",", 
     RowBox[{"params_:", 
      RowBox[{"{", "}"}]}], ",", 
     RowBox[{"PrintFlag_:", "True"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "Lagrangian", ",", "solutions"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"a", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           UnderoverscriptBox["\[Sum]", 
            RowBox[{"t", "=", "1"}], "T"], 
           RowBox[{
            SubscriptBox["p", "t"], 
            SubscriptBox["s", "t"]}]}], ")"}], "//.", "AllRules"}], "//.", 
        "params"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Lagrangian", "=", 
       RowBox[{"a", "+", 
        RowBox[{"\[Delta]", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{
            UnderoverscriptBox["\[Sum]", 
             RowBox[{"t", "=", "1"}], "T"], 
            SubscriptBox["s", "t"]}]}], ")"}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"FOC", "=", 
       RowBox[{"Append", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["\[PartialD]", 
               SubscriptBox["s", "#"]], " ", "Lagrangian"}], ")"}], 
            "\[Equal]", "0"}], "&"}], " ", "/@", " ", 
          RowBox[{"Range", "[", "T", "]"}]}], ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["\[PartialD]", "\[Delta]"], " ", "Lagrangian"}], 
           ")"}], "\[Equal]", "0"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"solutions", "=", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Solve", "[", 
           RowBox[{"FOC", ",", 
            RowBox[{"Append", "[", 
             RowBox[{
              RowBox[{"Table", "[", 
               RowBox[{
                SubscriptBox["s", "i"], ",", 
                RowBox[{"{", 
                 RowBox[{"i", ",", "T"}], "}"}]}], "]"}], ",", "\[Delta]"}], 
             "]"}]}], "]"}], "//", "Simplify"}], "//", "Chop"}], "//", 
        "Flatten"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"PrintFlag", ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<Lagrangian: \>\"", ",", "Lagrangian"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Print", "[", "\"\<First order conditions:\>\"", "]"}], ";", 
         
         RowBox[{"Print", "[", 
          RowBox[{"TableForm", "[", "FOC", "]"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Print", "[", "\"\<Solutions:\>\"", "]"}], ";", 
         RowBox[{"Print", "[", 
          RowBox[{"TableForm", "[", "solutions", "]"}], "]"}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      "solutions"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{"OptOrders", "[", 
    RowBox[{"3", ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["p", "Rule"], ",", 
       SubscriptBox["m", "Rule"], ",", "\[Epsilon]Zap"}], "}"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lagrangian: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SubscriptBox["s", "1"], " ", 
     RowBox[{"(", 
      RowBox[{"\[Mu]", "+", 
       RowBox[{"\[Gamma]", " ", 
        SubscriptBox["s", "1"]}], "+", 
       RowBox[{"\[Lambda]", " ", 
        SubscriptBox["s", "1"]}]}], ")"}]}], "+", 
    RowBox[{
     SubscriptBox["s", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "\[Mu]"}], "+", 
       RowBox[{"\[Lambda]", " ", 
        SubscriptBox["s", "1"]}], "+", 
       RowBox[{"\[Gamma]", " ", 
        SubscriptBox["s", "2"]}], "+", 
       RowBox[{"\[Lambda]", " ", 
        SubscriptBox["s", "2"]}]}], ")"}]}], "+", 
    RowBox[{"\[Delta]", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SubscriptBox["s", "1"], "-", 
       SubscriptBox["s", "2"], "-", 
       SubscriptBox["s", "3"]}], ")"}]}], "+", 
    RowBox[{
     SubscriptBox["s", "3"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", "\[Mu]"}], "+", 
       RowBox[{"\[Lambda]", " ", 
        SubscriptBox["s", "1"]}], "+", 
       RowBox[{"\[Lambda]", " ", 
        SubscriptBox["s", "2"]}], "+", 
       RowBox[{"\[Gamma]", " ", 
        SubscriptBox["s", "3"]}], "+", 
       RowBox[{"\[Lambda]", " ", 
        SubscriptBox["s", "3"]}]}], ")"}]}]}]}],
  SequenceForm[
  "Lagrangian: ", 
   Subscript[$CellContext`s, 1] ($CellContext`\[Mu] + $CellContext`\[Gamma] 
      Subscript[$CellContext`s, 1] + $CellContext`\[Lambda] 
      Subscript[$CellContext`s, 1]) + 
   Subscript[$CellContext`s, 2] (
     2 $CellContext`\[Mu] + $CellContext`\[Lambda] 
      Subscript[$CellContext`s, 1] + $CellContext`\[Gamma] 
      Subscript[$CellContext`s, 2] + $CellContext`\[Lambda] 
      Subscript[$CellContext`s, 2]) + $CellContext`\[Delta] (1 - 
     Subscript[$CellContext`s, 1] - Subscript[$CellContext`s, 2] - 
     Subscript[$CellContext`s, 3]) + 
   Subscript[$CellContext`s, 3] (
     3 $CellContext`\[Mu] + $CellContext`\[Lambda] 
      Subscript[$CellContext`s, 1] + $CellContext`\[Lambda] 
      Subscript[$CellContext`s, 2] + $CellContext`\[Gamma] 
      Subscript[$CellContext`s, 3] + $CellContext`\[Lambda] 
      Subscript[$CellContext`s, 3])],
  Editable->False]], "Print",
 CellChangeTimes->{3.389717443092224*^9},
 CellLabel->"During evaluation of In[12]:="],

Cell[BoxData["\<\"First order conditions:\"\>"], "Print",
 CellChangeTimes->{3.389717443094224*^9},
 CellLabel->"During evaluation of In[12]:="],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[Delta]"}], "+", "\[Mu]", "+", 
        RowBox[{"\[Gamma]", " ", 
         SubscriptBox["s", "1"]}], "+", 
        RowBox[{"\[Lambda]", " ", 
         SubscriptBox["s", "1"]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"\[Gamma]", "+", "\[Lambda]"}], ")"}], " ", 
         SubscriptBox["s", "1"]}], "+", 
        RowBox[{"\[Lambda]", " ", 
         SubscriptBox["s", "2"]}], "+", 
        RowBox[{"\[Lambda]", " ", 
         SubscriptBox["s", "3"]}]}], "\[Equal]", "0"}]},
     {
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[Delta]"}], "+", 
        RowBox[{"2", " ", "\[Mu]"}], "+", 
        RowBox[{"\[Lambda]", " ", 
         SubscriptBox["s", "1"]}], "+", 
        RowBox[{"\[Gamma]", " ", 
         SubscriptBox["s", "2"]}], "+", 
        RowBox[{"\[Lambda]", " ", 
         SubscriptBox["s", "2"]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"\[Gamma]", "+", "\[Lambda]"}], ")"}], " ", 
         SubscriptBox["s", "2"]}], "+", 
        RowBox[{"\[Lambda]", " ", 
         SubscriptBox["s", "3"]}]}], "\[Equal]", "0"}]},
     {
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[Delta]"}], "+", 
        RowBox[{"3", " ", "\[Mu]"}], "+", 
        RowBox[{"\[Lambda]", " ", 
         SubscriptBox["s", "1"]}], "+", 
        RowBox[{"\[Lambda]", " ", 
         SubscriptBox["s", "2"]}], "+", 
        RowBox[{"\[Gamma]", " ", 
         SubscriptBox["s", "3"]}], "+", 
        RowBox[{"\[Lambda]", " ", 
         SubscriptBox["s", "3"]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"\[Gamma]", "+", "\[Lambda]"}], ")"}], " ", 
         SubscriptBox["s", "3"]}]}], "\[Equal]", "0"}]},
     {
      RowBox[{
       RowBox[{"1", "-", 
        SubscriptBox["s", "1"], "-", 
        SubscriptBox["s", "2"], "-", 
        SubscriptBox["s", "3"]}], "\[Equal]", "0"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.389717443097224*^9},
 CellLabel->"During evaluation of In[12]:="],

Cell[BoxData["\<\"Solutions:\"\>"], "Print",
 CellChangeTimes->{3.389717443099224*^9},
 CellLabel->"During evaluation of In[12]:="],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{"\[Delta]", "\[Rule]", 
       RowBox[{
        FractionBox["2", "3"], " ", 
        RowBox[{"(", 
         RowBox[{"\[Gamma]", "+", 
          RowBox[{"2", " ", "\[Lambda]"}], "+", 
          RowBox[{"3", " ", "\[Mu]"}]}], ")"}]}]}]},
     {
      RowBox[{
       SubscriptBox["s", "1"], "\[Rule]", 
       FractionBox[
        RowBox[{
         RowBox[{"2", " ", "\[Gamma]"}], "+", "\[Lambda]", "+", 
         RowBox[{"3", " ", "\[Mu]"}]}], 
        RowBox[{
         RowBox[{"6", " ", "\[Gamma]"}], "+", 
         RowBox[{"3", " ", "\[Lambda]"}]}]]}]},
     {
      RowBox[{
       SubscriptBox["s", "2"], "\[Rule]", 
       FractionBox["1", "3"]}]},
     {
      RowBox[{
       SubscriptBox["s", "3"], "\[Rule]", 
       FractionBox[
        RowBox[{
         RowBox[{"2", " ", "\[Gamma]"}], "+", "\[Lambda]", "-", 
         RowBox[{"3", " ", "\[Mu]"}]}], 
        RowBox[{
         RowBox[{"6", " ", "\[Gamma]"}], "+", 
         RowBox[{"3", " ", "\[Lambda]"}]}]]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.389717443101224*^9},
 CellLabel->"During evaluation of In[12]:="]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Analysis of time structure", "Subsection"],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the coefficients of ",
 Cell[BoxData["\[Mu]"]],
 " in the solutions when ",
 Cell[BoxData[
  RowBox[{"T", "=", "3"}]]],
 ";"
}], "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"T", "=", "3"}], ";"}], "\n", 
 RowBox[{
  SubscriptBox["s", "Solutions"], "=", 
  RowBox[{
   RowBox[{"OptOrders", "[", 
    RowBox[{"T", ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["p", "Rule"], ",", 
       SubscriptBox["m", "Rule"], ",", "\[Epsilon]Zap"}], "}"}], ",", 
     RowBox[{"{", "}"}], ",", "False"}], "]"}], "//", 
   "FullSimplify"}]}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Delta]", "\[Rule]", 
    RowBox[{
     FractionBox["2", "3"], " ", 
     RowBox[{"(", 
      RowBox[{"\[Gamma]", "+", 
       RowBox[{"2", " ", "\[Lambda]"}], "+", 
       RowBox[{"3", " ", "\[Mu]"}]}], ")"}]}]}], ",", 
   RowBox[{
    SubscriptBox["s", "1"], "\[Rule]", 
    RowBox[{
     FractionBox["1", "3"], "+", 
     FractionBox["\[Mu]", 
      RowBox[{
       RowBox[{"2", " ", "\[Gamma]"}], "+", "\[Lambda]"}]]}]}], ",", 
   RowBox[{
    SubscriptBox["s", "2"], "\[Rule]", 
    FractionBox["1", "3"]}], ",", 
   RowBox[{
    SubscriptBox["s", "3"], "\[Rule]", 
    RowBox[{
     FractionBox["1", "3"], "-", 
     FractionBox["\[Mu]", 
      RowBox[{
       RowBox[{"2", " ", "\[Gamma]"}], "+", "\[Lambda]"}]]}]}]}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389717443286224*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Coefficient", "[", 
    RowBox[{"#", ",", "\[Mu]"}], "]"}], "&"}], " ", "/@", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      SubscriptBox["s", "i"], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "T"}], "}"}]}], "]"}], "/.", 
    SubscriptBox["s", "Solutions"]}], ")"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"2", " ", "\[Gamma]"}], "+", "\[Lambda]"}]], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{
      RowBox[{"2", " ", "\[Gamma]"}], "+", "\[Lambda]"}]]}]}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389717443320224*^9}]
}, Open  ]],

Cell["Compare with:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"T", "+", "1"}], ")"}], "-", 
     RowBox[{"2", "t"}]}], 
    RowBox[{"2", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "\[Gamma]"}], "+", "\[Lambda]"}], ")"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "T"}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"2", " ", "\[Gamma]"}], "+", "\[Lambda]"}]], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{
      RowBox[{"2", " ", "\[Gamma]"}], "+", "\[Lambda]"}]]}]}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389717443357224*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"T", "=", "4"}]]]
}], "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"T", "=", "4"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["s", "Solutions"], "=", 
   RowBox[{
    RowBox[{"OptOrders", "[", 
     RowBox[{"T", ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["p", "Rule"], ",", 
        SubscriptBox["m", "Rule"], ",", "\[Epsilon]Zap"}], "}"}], ",", 
      RowBox[{"{", "}"}], ",", "False"}], "]"}], "//", "FullSimplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Coefficient", "[", 
    RowBox[{"#", ",", "\[Mu]"}], "]"}], "&"}], " ", "/@", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      SubscriptBox["s", "i"], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "T"}], "}"}]}], "]"}], "/.", 
    SubscriptBox["s", "Solutions"]}], ")"}]}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["3", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "\[Gamma]"}], "+", "\[Lambda]"}], ")"}]}]], ",", 
   FractionBox["1", 
    RowBox[{
     RowBox[{"4", " ", "\[Gamma]"}], "+", 
     RowBox[{"2", " ", "\[Lambda]"}]}]], ",", 
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "\[Gamma]"}], "+", "\[Lambda]"}], ")"}]}]]}], ",", 
   RowBox[{"-", 
    FractionBox["3", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "\[Gamma]"}], "+", "\[Lambda]"}], ")"}]}]]}]}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389717443614224*^9}]
}, Open  ]],

Cell["Compare with:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"T", "+", "1"}], ")"}], "-", 
     RowBox[{"2", "t"}]}], 
    RowBox[{"2", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "\[Gamma]"}], "+", "\[Lambda]"}], ")"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "T"}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["3", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "\[Gamma]"}], "+", "\[Lambda]"}], ")"}]}]], ",", 
   FractionBox["1", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "\[Gamma]"}], "+", "\[Lambda]"}], ")"}]}]], ",", 
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "\[Gamma]"}], "+", "\[Lambda]"}], ")"}]}]]}], ",", 
   RowBox[{"-", 
    FractionBox["3", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "\[Gamma]"}], "+", "\[Lambda]"}], ")"}]}]]}]}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3897174436502237`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"T", "=", "5"}]]]
}], "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"T", "=", "5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["s", "Solutions"], "=", 
   RowBox[{
    RowBox[{"OptOrders", "[", 
     RowBox[{"T", ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["p", "Rule"], ",", 
        SubscriptBox["m", "Rule"], ",", "\[Epsilon]Zap"}], "}"}], ",", 
      RowBox[{"{", "}"}], ",", "False"}], "]"}], "//", "FullSimplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Coefficient", "[", 
    RowBox[{"#", ",", "\[Mu]"}], "]"}], "&"}], " ", "/@", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      SubscriptBox["s", "i"], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "T"}], "}"}]}], "]"}], "/.", 
    SubscriptBox["s", "Solutions"]}], ")"}]}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["2", 
    RowBox[{
     RowBox[{"2", " ", "\[Gamma]"}], "+", "\[Lambda]"}]], ",", 
   FractionBox["1", 
    RowBox[{
     RowBox[{"2", " ", "\[Gamma]"}], "+", "\[Lambda]"}]], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{
      RowBox[{"2", " ", "\[Gamma]"}], "+", "\[Lambda]"}]]}], ",", 
   RowBox[{"-", 
    FractionBox["2", 
     RowBox[{
      RowBox[{"2", " ", "\[Gamma]"}], "+", "\[Lambda]"}]]}]}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389717443850224*^9}]
}, Open  ]],

Cell["Compare with:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"T", "+", "1"}], ")"}], "-", 
     RowBox[{"2", "t"}]}], 
    RowBox[{"2", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "\[Gamma]"}], "+", "\[Lambda]"}], ")"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "T"}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["2", 
    RowBox[{
     RowBox[{"2", " ", "\[Gamma]"}], "+", "\[Lambda]"}]], ",", 
   FractionBox["1", 
    RowBox[{
     RowBox[{"2", " ", "\[Gamma]"}], "+", "\[Lambda]"}]], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{
      RowBox[{"2", " ", "\[Gamma]"}], "+", "\[Lambda]"}]]}], ",", 
   RowBox[{"-", 
    FractionBox["2", 
     RowBox[{
      RowBox[{"2", " ", "\[Gamma]"}], "+", "\[Lambda]"}]]}]}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3897174439332237`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "T", "]"}], ";"}]], "Input",
 CellLabelAutoDelete->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 15.1", "Subsection",
 CellTags->"ExTradingStrategy"],

Cell[CellGroupData[{

Cell["Model dynamics", "Subsubsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["m", "Rule"], "=", 
   RowBox[{
    SubscriptBox["m", "t_"], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["m", 
        RowBox[{"t", "-", "1"}]], "/.", 
       RowBox[{
        SubscriptBox["m", "0"], "\[Rule]", "0"}]}], ")"}], "+", 
     RowBox[{
      SubscriptBox[
       RowBox[{"\[Lambda]", " "}], "t"], 
      SubscriptBox["s", "t"]}], "+", "\[Mu]", "+", 
     SubscriptBox["\[Epsilon]", "t"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["p", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", "t"], "+", 
     RowBox[{"\[Gamma]", " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["s", "t"], "/.", 
        RowBox[{
         SubscriptBox["s", "0"], "\[Rule]", "0"}]}], ")"}]}]}]}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["W", "Rule"], "=", 
   RowBox[{
    SubscriptBox["W", "t_"], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{
      SubscriptBox["W", 
       RowBox[{"t", "-", "1"}]], "-", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["s", 
         RowBox[{"t", "-", "1"}]], "/.", 
        RowBox[{
         SubscriptBox["s", "0"], "\[Rule]", "0"}]}], ")"}]}], "/;", 
     RowBox[{"!", 
      RowBox[{"t", "===", "0"}]}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Epsilon]Zap", "=", 
   RowBox[{
    SubscriptBox["\[Epsilon]", "_"], "\[Rule]", "0"}]}], ";"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"solution", "=", 
   RowBox[{
    RowBox[{"OptOrders", "[", 
     RowBox[{"3", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["p", "Rule"], ",", 
          SubscriptBox["m", "Rule"], ",", "\[Epsilon]Zap"}], "}"}], "/.", 
        RowBox[{"\[Mu]", "\[Rule]", "0"}]}], "/.", 
       RowBox[{"\[Gamma]", "\[Rule]", "0"}]}]}], "]"}], "//", "Simplify"}]}], 
  ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lagrangian: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"\[Delta]", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SubscriptBox["s", "1"], "-", 
       SubscriptBox["s", "2"], "-", 
       SubscriptBox["s", "3"]}], ")"}]}], "+", 
    RowBox[{
     SubsuperscriptBox["s", "1", "2"], " ", 
     SubscriptBox["\[Lambda]", "1"]}], "+", 
    RowBox[{
     SubscriptBox["s", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["s", "1"], " ", 
        SubscriptBox["\[Lambda]", "1"]}], "+", 
       RowBox[{
        SubscriptBox["s", "2"], " ", 
        SubscriptBox["\[Lambda]", "2"]}]}], ")"}]}], "+", 
    RowBox[{
     SubscriptBox["s", "3"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["s", "1"], " ", 
        SubscriptBox["\[Lambda]", "1"]}], "+", 
       RowBox[{
        SubscriptBox["s", "2"], " ", 
        SubscriptBox["\[Lambda]", "2"]}], "+", 
       RowBox[{
        SubscriptBox["s", "3"], " ", 
        SubscriptBox["\[Lambda]", "3"]}]}], ")"}]}]}]}],
  SequenceForm[
  "Lagrangian: ", $CellContext`\[Delta] (1 - Subscript[$CellContext`s, 1] - 
     Subscript[$CellContext`s, 2] - Subscript[$CellContext`s, 3]) + 
   Subscript[$CellContext`s, 1]^2 Subscript[$CellContext`\[Lambda], 1] + 
   Subscript[$CellContext`s, 2] (
     Subscript[$CellContext`s, 1] Subscript[$CellContext`\[Lambda], 1] + 
     Subscript[$CellContext`s, 2] Subscript[$CellContext`\[Lambda], 2]) + 
   Subscript[$CellContext`s, 3] (
     Subscript[$CellContext`s, 1] Subscript[$CellContext`\[Lambda], 1] + 
     Subscript[$CellContext`s, 2] Subscript[$CellContext`\[Lambda], 2] + 
     Subscript[$CellContext`s, 3] Subscript[$CellContext`\[Lambda], 3])],
  Editable->False]], "Print",
 CellChangeTimes->{3.389717443995224*^9},
 CellLabel->"During evaluation of In[31]:="],

Cell[BoxData["\<\"First order conditions:\"\>"], "Print",
 CellChangeTimes->{3.389717443997224*^9},
 CellLabel->"During evaluation of In[31]:="],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[Delta]"}], "+", 
        RowBox[{"2", " ", 
         SubscriptBox["s", "1"], " ", 
         SubscriptBox["\[Lambda]", "1"]}], "+", 
        RowBox[{
         SubscriptBox["s", "2"], " ", 
         SubscriptBox["\[Lambda]", "1"]}], "+", 
        RowBox[{
         SubscriptBox["s", "3"], " ", 
         SubscriptBox["\[Lambda]", "1"]}]}], "\[Equal]", "0"}]},
     {
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[Delta]"}], "+", 
        RowBox[{
         SubscriptBox["s", "1"], " ", 
         SubscriptBox["\[Lambda]", "1"]}], "+", 
        RowBox[{"2", " ", 
         SubscriptBox["s", "2"], " ", 
         SubscriptBox["\[Lambda]", "2"]}], "+", 
        RowBox[{
         SubscriptBox["s", "3"], " ", 
         SubscriptBox["\[Lambda]", "2"]}]}], "\[Equal]", "0"}]},
     {
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[Delta]"}], "+", 
        RowBox[{
         SubscriptBox["s", "1"], " ", 
         SubscriptBox["\[Lambda]", "1"]}], "+", 
        RowBox[{
         SubscriptBox["s", "2"], " ", 
         SubscriptBox["\[Lambda]", "2"]}], "+", 
        RowBox[{"2", " ", 
         SubscriptBox["s", "3"], " ", 
         SubscriptBox["\[Lambda]", "3"]}]}], "\[Equal]", "0"}]},
     {
      RowBox[{
       RowBox[{"1", "-", 
        SubscriptBox["s", "1"], "-", 
        SubscriptBox["s", "2"], "-", 
        SubscriptBox["s", "3"]}], "\[Equal]", "0"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.3897174439992237`*^9},
 CellLabel->"During evaluation of In[31]:="],

Cell[BoxData["\<\"Solutions:\"\>"], "Print",
 CellChangeTimes->{3.389717444001224*^9},
 CellLabel->"During evaluation of In[31]:="],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{"\[Delta]", "\[Rule]", 
       FractionBox[
        RowBox[{"2", " ", 
         SubscriptBox["\[Lambda]", "1"], " ", 
         RowBox[{"(", 
          RowBox[{
           SubsuperscriptBox["\[Lambda]", "2", "2"], "+", 
           RowBox[{
            SubscriptBox["\[Lambda]", "1"], " ", 
            SubscriptBox["\[Lambda]", "3"]}], "-", 
           RowBox[{"4", " ", 
            SubscriptBox["\[Lambda]", "2"], " ", 
            SubscriptBox["\[Lambda]", "3"]}]}], ")"}]}], 
        RowBox[{
         SubscriptBox["\[Lambda]", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Lambda]", "2"], "-", 
           RowBox[{"4", " ", 
            SubscriptBox["\[Lambda]", "3"]}]}], ")"}]}]]}]},
     {
      RowBox[{
       SubscriptBox["s", "1"], "\[Rule]", 
       RowBox[{"1", "+", 
        FractionBox[
         RowBox[{"2", " ", 
          SubscriptBox["\[Lambda]", "1"], " ", 
          SubscriptBox["\[Lambda]", "3"]}], 
         RowBox[{
          SubsuperscriptBox["\[Lambda]", "2", "2"], "-", 
          RowBox[{"4", " ", 
           SubscriptBox["\[Lambda]", "2"], " ", 
           SubscriptBox["\[Lambda]", "3"]}]}]]}]}]},
     {
      RowBox[{
       SubscriptBox["s", "2"], "\[Rule]", 
       FractionBox[
        RowBox[{
         SubscriptBox["\[Lambda]", "1"], " ", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Lambda]", "2"], "-", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "3"]}]}], ")"}]}], 
        RowBox[{
         SubscriptBox["\[Lambda]", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Lambda]", "2"], "-", 
           RowBox[{"4", " ", 
            SubscriptBox["\[Lambda]", "3"]}]}], ")"}]}]]}]},
     {
      RowBox[{
       SubscriptBox["s", "3"], "\[Rule]", 
       RowBox[{"-", 
        FractionBox[
         SubscriptBox["\[Lambda]", "1"], 
         RowBox[{
          SubscriptBox["\[Lambda]", "2"], "-", 
          RowBox[{"4", " ", 
           SubscriptBox["\[Lambda]", "3"]}]}]]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.389717444003224*^9},
 CellLabel->"During evaluation of In[31]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"solution", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Lambda]", "1"], "\[Rule]", "2"}], ",", 
     RowBox[{
      SubscriptBox["\[Lambda]", "2"], "\[Rule]", "1"}], ",", 
     RowBox[{
      SubscriptBox["\[Lambda]", "3"], "\[Rule]", " ", 
      RowBox[{"1", "/", "2"}]}]}], "}"}]}], "//", "TableForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{"\[Delta]", "\[Rule]", "0"}]},
     {
      RowBox[{
       SubscriptBox["s", "1"], "\[Rule]", 
       RowBox[{"-", "1"}]}]},
     {
      RowBox[{
       SubscriptBox["s", "2"], "\[Rule]", "0"}]},
     {
      RowBox[{
       SubscriptBox["s", "3"], "\[Rule]", "2"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389717444040224*^9}]
}, Open  ]],

Cell[TextData[{
 "As a check, verify that with constant ",
 Cell[BoxData["\[Lambda]"]],
 ", we obtain the original solution to the basic problem."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"solution", "/.", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Lambda]", "_"], "\[Rule]", "\[Lambda]"}], "}"}]}], "//", 
  "TableForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{"\[Delta]", "\[Rule]", 
       FractionBox[
        RowBox[{"4", " ", "\[Lambda]"}], "3"]}]},
     {
      RowBox[{
       SubscriptBox["s", "1"], "\[Rule]", 
       FractionBox["1", "3"]}]},
     {
      RowBox[{
       SubscriptBox["s", "2"], "\[Rule]", 
       FractionBox["1", "3"]}]},
     {
      RowBox[{
       SubscriptBox["s", "3"], "\[Rule]", 
       FractionBox["1", "3"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389717444086224*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Geometrically declining non-stochastic temporary impact (Section 15.1.2)\
\>", "Section"],

Cell[CellGroupData[{

Cell["Definitions:", "Subsubsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["m", "Rule"], "=", 
   RowBox[{
    SubscriptBox["m", "t_"], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["m", 
        RowBox[{"t", "-", "1"}]], "/.", 
       RowBox[{
        SubscriptBox["m", "0"], "\[Rule]", "0"}]}], ")"}], "+", 
     RowBox[{"\[Lambda]", " ", 
      SubscriptBox["s", "t"]}], "+", "\[Mu]", "+", 
     SubscriptBox["\[Epsilon]", "t"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["p", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", "t"], "+", 
     RowBox[{"\[Gamma]", " ", 
      SubscriptBox["A", "t"]}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["W", "Rule"], "=", 
   RowBox[{
    SubscriptBox["W", "t_"], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{
      SubscriptBox["W", 
       RowBox[{"t", "-", "1"}]], "-", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["s", 
         RowBox[{"t", "-", "1"}]], "/.", 
        RowBox[{
         SubscriptBox["s", "0"], "\[Rule]", "0"}]}], ")"}]}], "/;", 
     RowBox[{"!", 
      RowBox[{"t", "===", "0"}]}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["A", "Rule"], "=", 
   RowBox[{
    SubscriptBox["A", "t_"], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{
      SubscriptBox["s", "t"], "+", 
      RowBox[{"\[Theta]", " ", 
       SubscriptBox["A", 
        RowBox[{"t", "-", "1"}]]}]}], "/;", 
     RowBox[{"!", 
      RowBox[{"t", "===", "0"}]}]}]}]}], ";"}]}], "Input",
 CellLabelAutoDelete->True],

Cell["Example:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{
   RowBox[{
    SubscriptBox["A", "5"], "//.", 
    SubscriptBox["A", "Rule"]}], ",", "\[Theta]"}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["\[Theta]", "5"], " ", 
   SubscriptBox["A", "0"]}], "+", 
  RowBox[{
   SuperscriptBox["\[Theta]", "4"], " ", 
   SubscriptBox["s", "1"]}], "+", 
  RowBox[{
   SuperscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["s", "2"]}], "+", 
  RowBox[{
   SuperscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["s", "3"]}], "+", 
  RowBox[{"\[Theta]", " ", 
   SubscriptBox["s", "4"]}], "+", 
  SubscriptBox["s", "5"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3897174775512238`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"AllRules", "=", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["p", "Rule"], ",", 
     SubscriptBox["A", "Rule"], ",", 
     SubscriptBox["m", "Rule"], ",", "\[Epsilon]Zap"}], "}"}]}], 
  ";"}]], "Input",
 CellLabelAutoDelete->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Quadratic analysis", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{"OptOrders", "[", 
    RowBox[{"2", ",", "AllRules"}], "]"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lagrangian: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SubscriptBox["s", "1"], " ", 
     RowBox[{"(", 
      RowBox[{"\[Mu]", "+", 
       RowBox[{"\[Lambda]", " ", 
        SubscriptBox["s", "1"]}], "+", 
       RowBox[{"\[Gamma]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Theta]", " ", 
           SubscriptBox["A", "0"]}], "+", 
          SubscriptBox["s", "1"]}], ")"}]}]}], ")"}]}], "+", 
    RowBox[{"\[Delta]", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SubscriptBox["s", "1"], "-", 
       SubscriptBox["s", "2"]}], ")"}]}], "+", 
    RowBox[{
     SubscriptBox["s", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "\[Mu]"}], "+", 
       RowBox[{"\[Lambda]", " ", 
        SubscriptBox["s", "1"]}], "+", 
       RowBox[{"\[Lambda]", " ", 
        SubscriptBox["s", "2"]}], "+", 
       RowBox[{"\[Gamma]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Theta]", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"\[Theta]", " ", 
              SubscriptBox["A", "0"]}], "+", 
             SubscriptBox["s", "1"]}], ")"}]}], "+", 
          SubscriptBox["s", "2"]}], ")"}]}]}], ")"}]}]}]}],
  SequenceForm[
  "Lagrangian: ", 
   Subscript[$CellContext`s, 1] ($CellContext`\[Mu] + $CellContext`\[Lambda] 
      Subscript[$CellContext`s, 
        1] + $CellContext`\[Gamma] ($CellContext`\[Theta] 
        Subscript[$CellContext`A, 0] + 
       Subscript[$CellContext`s, 1])) + $CellContext`\[Delta] (1 - 
     Subscript[$CellContext`s, 1] - Subscript[$CellContext`s, 2]) + 
   Subscript[$CellContext`s, 2] (
     2 $CellContext`\[Mu] + $CellContext`\[Lambda] 
      Subscript[$CellContext`s, 1] + $CellContext`\[Lambda] 
      Subscript[$CellContext`s, 
        2] + $CellContext`\[Gamma] ($CellContext`\[Theta] ($CellContext`\
\[Theta] Subscript[$CellContext`A, 0] + Subscript[$CellContext`s, 1]) + 
       Subscript[$CellContext`s, 2]))],
  Editable->False]], "Print",
 CellChangeTimes->{3.3897174776242237`*^9},
 CellLabel->"During evaluation of In[40]:="],

Cell[BoxData["\<\"First order conditions:\"\>"], "Print",
 CellChangeTimes->{3.389717477627224*^9},
 CellLabel->"During evaluation of In[40]:="],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[Delta]"}], "+", "\[Mu]", "+", 
        RowBox[{"\[Lambda]", " ", 
         SubscriptBox["s", "1"]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"\[Gamma]", "+", "\[Lambda]"}], ")"}], " ", 
         SubscriptBox["s", "1"]}], "+", 
        RowBox[{"\[Gamma]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[Theta]", " ", 
            SubscriptBox["A", "0"]}], "+", 
           SubscriptBox["s", "1"]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[Gamma]", " ", "\[Theta]"}], "+", "\[Lambda]"}], ")"}], 
         " ", 
         SubscriptBox["s", "2"]}]}], "\[Equal]", "0"}]},
     {
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[Delta]"}], "+", 
        RowBox[{"2", " ", "\[Mu]"}], "+", 
        RowBox[{"\[Lambda]", " ", 
         SubscriptBox["s", "1"]}], "+", 
        RowBox[{"\[Lambda]", " ", 
         SubscriptBox["s", "2"]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"\[Gamma]", "+", "\[Lambda]"}], ")"}], " ", 
         SubscriptBox["s", "2"]}], "+", 
        RowBox[{"\[Gamma]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[Theta]", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"\[Theta]", " ", 
               SubscriptBox["A", "0"]}], "+", 
              SubscriptBox["s", "1"]}], ")"}]}], "+", 
           SubscriptBox["s", "2"]}], ")"}]}]}], "\[Equal]", "0"}]},
     {
      RowBox[{
       RowBox[{"1", "-", 
        SubscriptBox["s", "1"], "-", 
        SubscriptBox["s", "2"]}], "\[Equal]", "0"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.389717477630224*^9},
 CellLabel->"During evaluation of In[40]:="],

Cell[BoxData["\<\"Solutions:\"\>"], "Print",
 CellChangeTimes->{3.3897174776312237`*^9},
 CellLabel->"During evaluation of In[40]:="],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{"\[Delta]", "\[Rule]", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Gamma]", " ", 
           RowBox[{"(", 
            RowBox[{"2", "+", "\[Theta]"}], ")"}]}], "+", 
          RowBox[{"3", " ", 
           RowBox[{"(", 
            RowBox[{"\[Lambda]", "+", "\[Mu]"}], ")"}]}], "+", 
          RowBox[{"\[Gamma]", " ", "\[Theta]", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Theta]"}], ")"}], " ", 
           SubscriptBox["A", "0"]}]}], ")"}]}]}]},
     {
      RowBox[{
       SubscriptBox["s", "1"], "\[Rule]", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[Gamma]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "2"}], "+", "\[Theta]"}], ")"}]}], "+", "\[Lambda]",
           "+", "\[Mu]", "+", 
          RowBox[{"\[Gamma]", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "\[Theta]"}], ")"}], " ", "\[Theta]", 
           " ", 
           SubscriptBox["A", "0"]}]}], 
         RowBox[{
          RowBox[{"2", " ", "\[Gamma]", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "2"}], "+", "\[Theta]"}], ")"}]}], "-", 
          RowBox[{"2", " ", "\[Lambda]"}]}]]}]}]},
     {
      RowBox[{
       SubscriptBox["s", "2"], "\[Rule]", 
       FractionBox[
        RowBox[{
         RowBox[{"\[Gamma]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", "\[Theta]"}], ")"}]}], "-", "\[Lambda]", 
         "+", "\[Mu]", "+", 
         RowBox[{"\[Gamma]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Theta]"}], ")"}], " ", "\[Theta]", 
          " ", 
          SubscriptBox["A", "0"]}]}], 
        RowBox[{
         RowBox[{"2", " ", "\[Gamma]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", "\[Theta]"}], ")"}]}], "-", 
         RowBox[{"2", " ", "\[Lambda]"}]}]]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.389717477634224*^9},
 CellLabel->"During evaluation of In[40]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Flatten", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["s", "1"], "/.", "sol"}], "/.", 
    RowBox[{"\[Mu]", "\[Rule]", "0"}]}], "]"}], "//", "Apart"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], "-", 
  FractionBox[
   RowBox[{"\[Gamma]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Theta]"}], ")"}], " ", "\[Theta]", " ", 
    SubscriptBox["A", "0"]}], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[Gamma]"}], "+", 
      RowBox[{"\[Gamma]", " ", "\[Theta]"}], "-", "\[Lambda]"}], 
     ")"}]}]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389717477667224*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"params", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Mu]", "\[Rule]", "0"}], ",", 
     RowBox[{"\[Gamma]", "\[Rule]", 
      RowBox[{"1", "/", "10"}]}], ",", 
     RowBox[{"\[Lambda]", "\[Rule]", 
      RowBox[{"1", "/", "10"}]}], ",", 
     RowBox[{"\[Theta]", "\[Rule]", 
      RowBox[{"1", "/", "2"}]}], ",", 
     RowBox[{
      SubscriptBox["A", "0"], "\[Rule]", "0"}]}], "}"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"pp", "[", 
    RowBox[{"T_", ",", 
     RowBox[{"params_:", 
      RowBox[{"{", "}"}]}]}], "]"}], ":=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Range", "[", "T", "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          SubscriptBox["s", "i"], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "T"}], "}"}]}], "]"}], "/.", 
        RowBox[{"OptOrders", "[", 
         RowBox[{"T", ",", "AllRules", ",", "params", ",", "False"}], "]"}]}],
        "//", "Flatten"}]}], "}"}], "]"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"graphText", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Text", "[", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"T\",
FontSlant->\"Italic\"]\)=10\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"11", ",", ".12"}], "}"}]}], "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"T\",
FontSlant->\"Italic\"]\)=5\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", ".23"}], "}"}]}], "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"T\",
FontSlant->\"Italic\"]\)=4\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", ".27"}], "}"}]}], "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"T\",
FontSlant->\"Italic\"]\)=3\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", ".35"}], "}"}]}], "]"}]}], "}"}]}], ";"}]], "Input",\

 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"baseStyle", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
     RowBox[{"FontSize", "\[Rule]", "12"}]}], "}"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389717533784224*^9, 3.3897175498402243`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p1", "=", 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"pp", "[", 
       RowBox[{"3", ",", "params"}], "]"}], ",", 
      RowBox[{"pp", "[", 
       RowBox[{"4", ",", "params"}], "]"}], ",", 
      RowBox[{"pp", "[", 
       RowBox[{"5", ",", "params"}], "]"}], ",", 
      RowBox[{"pp", "[", 
       RowBox[{"10", ",", "params"}], "]"}]}], "}"}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Range", "[", "10", "]"}], ",", 
       RowBox[{"Range", "[", 
        RowBox[{"0", ",", "0.4`", ",", "0.1`"}], "]"}], ",", "None", ",", 
       "None"}], "}"}]}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Trade period, t \>\"", ",", "\"\<Proportion of total trade\>\"", 
       ",", "\"\<A. Optimal trading strategies over various horizons\>\"", 
       ",", "None"}], "}"}]}], ",", 
    RowBox[{"Background", "\[Rule]", 
     RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "12"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0.4`"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Thickness", "[", "0.001`", "]"}], "}"}]}], ",", 
    RowBox[{"Epilog", "\[Rule]", "graphText"}], ",", 
    RowBox[{"BaseStyle", "\[Rule]", "baseStyle"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389717372221224*^9, 3.389717389566224*^9}, 
   3.389717498362224*^9, {3.389717558054224*^9, 3.389717566427224*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[0.001], 
    LineBox[{{1., 0.3448275862068966}, {2., 0.3103448275862069}, {3., 
     0.3448275862068966}}]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Thickness[0.001], 
    LineBox[{{1., 0.2682926829268293}, {2., 0.23170731707317074`}, {3., 
     0.23170731707317074`}, {4., 0.2682926829268293}}]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], Thickness[0.001], 
    LineBox[{{1., 0.22135922330097088`}, {2., 0.1883495145631068}, {3., 
     0.18058252427184465`}, {4., 0.1883495145631068}, {5., 
     0.22135922330097088`}}]}, 
   {Hue[0.37820393249936934`, 0.6, 0.6], Thickness[0.001], 
    LineBox[{{1., 0.11978897351687513`}, {2., 0.10112151491859409`}, {3., 
     0.09470686884214939}, {4., 0.09252672769198518}, {5., 
     0.0918559150303962}, {6., 0.0918559150303962}, {7., 
     0.09252672769198518}, {8., 0.09470686884214939}, {9., 
     0.10112151491859409`}, {10., 0.11978897351687513`}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  Background->GrayLevel[1],
  BaseStyle->{FontFamily -> "Times", FontSize -> 12},
  Epilog->{
    InsetBox[
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"T\\\",\\nFontSlant->\\\"Italic\\\"]\\)=10\"",
       TraditionalForm], {11, 0.12}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"T\\\",\\nFontSlant->\\\"Italic\\\"]\\)=5\"", 
      TraditionalForm], {6, 0.23}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"T\\\",\\nFontSlant->\\\"Italic\\\"]\\)=4\"", 
      TraditionalForm], {5, 0.27}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"T\\\",\\nFontSlant->\\\"Italic\\\"]\\)=3\"", 
      TraditionalForm], {4, 0.35}]},
  Frame->True,
  FrameLabel->{
    FormBox["\"Trade period, t \"", TraditionalForm], 
    FormBox["\"Proportion of total trade\"", TraditionalForm], 
    FormBox[
    "\"A. Optimal trading strategies over various horizons\"", 
     TraditionalForm], None},
  FrameTicks->{{{1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}, {4, 
      FormBox["4", TraditionalForm]}, {5, 
      FormBox["5", TraditionalForm]}, {6, 
      FormBox["6", TraditionalForm]}, {7, 
      FormBox["7", TraditionalForm]}, {8, 
      FormBox["8", TraditionalForm]}, {9, 
      FormBox["9", TraditionalForm]}, {10, 
      FormBox["10", TraditionalForm]}}, {{0., 
      FormBox["0.`", TraditionalForm]}, {0.1, 
      FormBox["0.1`", TraditionalForm]}, {0.2, 
      FormBox["0.2`", TraditionalForm]}, {0.30000000000000004`, 
      FormBox["0.30000000000000004`", TraditionalForm]}, {0.4, 
      FormBox["0.4`", TraditionalForm]}}, None, None},
  ImageSize->{411.33333333333303`, Automatic},
  PlotRange->{{0, 12}, {0, 0.4}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3897174781052237`*^9, 3.3897174996162243`*^9}, {
  3.389717552597224*^9, 3.389717567178224*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p2", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["s", "1"], "/.", "\[InvisibleSpace]", 
     RowBox[{"Flatten", "[", 
      RowBox[{"OptOrders", "[", 
       RowBox[{"3", ",", "AllRules", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\[Mu]", "\[Rule]", "0"}], ",", 
          RowBox[{"\[Gamma]", "\[Rule]", 
           FractionBox["1", "10"]}], ",", 
          RowBox[{"\[Lambda]", "\[Rule]", 
           FractionBox["1", "10"]}], ",", 
          RowBox[{
           SubscriptBox["A", "0"], "\[Rule]", "0"}]}], "}"}], ",", "False"}], 
       "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Theta]", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"Background", "\[Rule]", 
     RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.329`", ",", "0.35`"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Persistence parameter, \[Theta]\>\"", ",", 
       "\"\<Proportion of total\\nexecuted on first trade\>\"", ",", 
       "\"\<B. Persistence and the first trade, T=3\>\"", ",", "None"}], 
      "}"}]}], ",", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Range", "[", 
        RowBox[{"0", ",", "1", ",", "0.2`"}], "]"}], ",", 
       RowBox[{"Range", "[", 
        RowBox[{"0.33`", ",", "0.35`", ",", "0.01`"}], "]"}], ",", "None", 
       ",", "None"}], "}"}]}], ",", 
    RowBox[{"BaseStyle", "\[Rule]", "baseStyle"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389717405891224*^9, 3.389717418243224*^9}, {
  3.389717579720224*^9, 3.389717588213224*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd2Hk8VOsbAHBrWW7WuqJdRNTPmjY8ilJZouxZStbr5kbjohIKiahEdhEq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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0.33},
  Background->GrayLevel[1],
  BaseStyle->{FontFamily -> "Times", FontSize -> 12},
  Frame->True,
  FrameLabel->{
    FormBox["\"Persistence parameter, \[Theta]\"", TraditionalForm], 
    FormBox[
    "\"Proportion of total\\nexecuted on first trade\"", TraditionalForm], 
    FormBox["\"B. Persistence and the first trade, T=3\"", TraditionalForm], 
    None},
  FrameTicks->{{{0., 
      FormBox["0.`", TraditionalForm]}, {0.2, 
      FormBox["0.2`", TraditionalForm]}, {0.4, 
      FormBox["0.4`", TraditionalForm]}, {0.6000000000000001, 
      FormBox["0.6000000000000001`", TraditionalForm]}, {0.8, 
      FormBox["0.8`", TraditionalForm]}, {1., 
      FormBox["1.`", TraditionalForm]}}, {{0.33, 
      FormBox["0.33`", TraditionalForm]}, {0.34, 
      FormBox["0.34`", TraditionalForm]}, {0.35, 
      FormBox["0.35`", TraditionalForm]}}, None, None},
  PlotRange->{{0, 1}, {0.329, 0.35}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389717478534224*^9, 3.389717589048224*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsRow", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p1", ",", "p2"}], "}"}], ",", 
   RowBox[{"Spacings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Scaled", "[", 
       RowBox[{"-", "0.05`"}], "]"}], ",", 
      RowBox[{"Scaled", "[", "0", "]"}]}], "}"}]}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"GrayLevel", "[", "1", "]"}]}]}], "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389717611842224*^9, 3.389717637837224*^9}}],

Cell[BoxData[
 GraphicsBox[{{
    {GrayLevel[1], RectangleBox[{348., 0}, {696., -222.49223594996212`}]}, 
    {GrayLevel[1], RectangleBox[{0, 0}, {348., -222.49223594996212`}]}}, {
    InsetBox[
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], Thickness[0.001], 
        LineBox[{{1., 0.3448275862068966}, {2., 0.3103448275862069}, {3., 
         0.3448275862068966}}]}, 
       {Hue[0.9060679774997897, 0.6, 0.6], Thickness[0.001], 
        LineBox[{{1., 0.2682926829268293}, {2., 0.23170731707317074`}, {3., 
         0.23170731707317074`}, {4., 0.2682926829268293}}]}, 
       {Hue[0.14213595499957954`, 0.6, 0.6], Thickness[0.001], 
        LineBox[{{1., 0.22135922330097088`}, {2., 0.1883495145631068}, {3., 
         0.18058252427184465`}, {4., 0.1883495145631068}, {5., 
         0.22135922330097088`}}]}, 
       {Hue[0.37820393249936934`, 0.6, 0.6], Thickness[0.001], 
        LineBox[{{1., 0.11978897351687513`}, {2., 0.10112151491859409`}, {3., 
         0.09470686884214939}, {4., 0.09252672769198518}, {5., 
         0.0918559150303962}, {6., 0.0918559150303962}, {7., 
         0.09252672769198518}, {8., 0.09470686884214939}, {9., 
         0.10112151491859409`}, {10., 0.11978897351687513`}}]}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->True,
      AxesOrigin->{0, 0},
      Background->GrayLevel[1],
      BaseStyle->{FontFamily -> "Times", FontSize -> 12},
      Epilog->{
        InsetBox[
         FormBox[
         "\"\\!\\(\\*\\nStyleBox[\\\"T\\\",\\nFontSlant->\\\"Italic\\\"]\\)=\
10\"", TraditionalForm], {11, 0.12}], 
        InsetBox[
         FormBox[
         "\"\\!\\(\\*\\nStyleBox[\\\"T\\\",\\nFontSlant->\\\"Italic\\\"]\\)=5\
\"", TraditionalForm], {6, 0.23}], 
        InsetBox[
         FormBox[
         "\"\\!\\(\\*\\nStyleBox[\\\"T\\\",\\nFontSlant->\\\"Italic\\\"]\\)=4\
\"", TraditionalForm], {5, 0.27}], 
        InsetBox[
         FormBox[
         "\"\\!\\(\\*\\nStyleBox[\\\"T\\\",\\nFontSlant->\\\"Italic\\\"]\\)=3\
\"", TraditionalForm], {4, 0.35}]},
      Frame->True,
      FrameLabel->{
        FormBox["\"Trade period, t \"", TraditionalForm], 
        FormBox["\"Proportion of total trade\"", TraditionalForm], 
        FormBox[
        "\"A. Optimal trading strategies over various horizons\"", 
         TraditionalForm], None},
      FrameTicks->{{{1, 
          FormBox["1", TraditionalForm]}, {2, 
          FormBox["2", TraditionalForm]}, {3, 
          FormBox["3", TraditionalForm]}, {4, 
          FormBox["4", TraditionalForm]}, {5, 
          FormBox["5", TraditionalForm]}, {6, 
          FormBox["6", TraditionalForm]}, {7, 
          FormBox["7", TraditionalForm]}, {8, 
          FormBox["8", TraditionalForm]}, {9, 
          FormBox["9", TraditionalForm]}, {10, 
          FormBox["10", TraditionalForm]}}, {{0., 
          FormBox["0.`", TraditionalForm]}, {0.1, 
          FormBox["0.1`", TraditionalForm]}, {0.2, 
          FormBox["0.2`", TraditionalForm]}, {0.30000000000000004`, 
          FormBox["0.30000000000000004`", TraditionalForm]}, {0.4, 
          FormBox["0.4`", TraditionalForm]}}, None, None},
      PlotRange->{{0, 12}, {0, 0.4}},
      PlotRangeClipping->True,
      PlotRangePadding->{Automatic, Automatic}], {174., -111.24611797498106`},
      ImageScaled[{0.5, 0.5}], {360., 222.49223594996212`},
     Background->GrayLevel[1]], InsetBox[
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd2Hk8VOsbAHBrWW7WuqJdRNTPmjY8ilJZouxZStbr5kbjohIKiahEdhEq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         "]]}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->True,
      AxesOrigin->{0, 0.33},
      Background->GrayLevel[1],
      BaseStyle->{FontFamily -> "Times", FontSize -> 12},
      Frame->True,
      FrameLabel->{
        FormBox["\"Persistence parameter, \[Theta]\"", TraditionalForm], 
        FormBox[
        "\"Proportion of total\\nexecuted on first trade\"", TraditionalForm],
         
        FormBox[
        "\"B. Persistence and the first trade, T=3\"", TraditionalForm], 
        None},
      FrameTicks->{{{0., 
          FormBox["0.`", TraditionalForm]}, {0.2, 
          FormBox["0.2`", TraditionalForm]}, {0.4, 
          FormBox["0.4`", TraditionalForm]}, {0.6000000000000001, 
          FormBox["0.6000000000000001`", TraditionalForm]}, {0.8, 
          FormBox["0.8`", TraditionalForm]}, {1., 
          FormBox["1.`", TraditionalForm]}}, {{0.33, 
          FormBox["0.33`", TraditionalForm]}, {0.34, 
          FormBox["0.34`", TraditionalForm]}, {0.35, 
          FormBox["0.35`", TraditionalForm]}}, None, None},
      PlotRange->{{0, 1}, {0.329, 0.35}},
      PlotRangeClipping->True,
      PlotRangePadding->{Automatic, Automatic}], {522., -111.24611797498106`},
      ImageScaled[{0.5, 0.5}], {360., 222.49223594996212`},
     Background->GrayLevel[1]]}, {}},
  ContentSelectable->True,
  ImageSize->{626.6666666666656, Automatic},
  PlotRangePadding->{6, 5}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389717639387224*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Geometrically declining stochastic temporary impact (Section 15.1.3)\
\>", "Section"],

Cell[CellGroupData[{

Cell["Definitions:", "Subsubsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["m", "Rule"], "=", 
   RowBox[{
    SubscriptBox["m", "t_"], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["m", 
        RowBox[{"t", "-", "1"}]], "/.", 
       RowBox[{
        SubscriptBox["m", "0"], "\[Rule]", "0"}]}], ")"}], "+", 
     RowBox[{"\[Lambda]", " ", 
      SubscriptBox["s", "t"]}], "+", "\[Mu]", "+", 
     SubscriptBox["\[Epsilon]", "t"]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["p", "Rule"], "=", 
   RowBox[{
    SubscriptBox["p", "t_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["m", "t"], "+", 
     RowBox[{"\[Gamma]", " ", 
      SubscriptBox["A", "t"]}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"wRule", "=", 
   RowBox[{
    SubscriptBox["w", "t_"], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{
      SubscriptBox["w", 
       RowBox[{"t", "-", "1"}]], "-", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["s", 
         RowBox[{"t", "-", "1"}]], "/.", 
        RowBox[{
         SubscriptBox["s", "0"], "\[Rule]", "0"}]}], ")"}]}], "/;", 
     RowBox[{"!", 
      RowBox[{"t", "===", "0"}]}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["A", "Rule"], "=", 
   RowBox[{
    SubscriptBox["A", "t_"], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{
      SubscriptBox["s", "t"], "+", 
      RowBox[{"\[Theta]", " ", 
       SubscriptBox["A", 
        RowBox[{"t", "-", "1"}]]}], "+", 
      SubscriptBox["u", "t"]}], "/;", 
     RowBox[{"!", 
      RowBox[{"t", "===", "0"}]}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Epsilon]Zap", "=", 
   RowBox[{
    SubscriptBox["\[Epsilon]", "_"], "\[Rule]", "0"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"uZap", "=", 
   RowBox[{
    SubscriptBox["u", "_"], "\[Rule]", "0"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"params", "=", 
   RowBox[{"{", 
    RowBox[{"\[Mu]", "\[Rule]", "0"}], "}"}]}], ";"}]}], "Input",
 CellLabelAutoDelete->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"Manual\" Backwards optimization", "Subsection"],

Cell["At time T the expected cost is:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["p", "T"], " ", 
      SubscriptBox["w", "T"]}], "/.", 
     SubscriptBox["p", "Rule"]}], "/.", 
    SubscriptBox["m", "Rule"]}], "/.", 
   RowBox[{
    SubscriptBox["s", "T"], "\[Rule]", 
    SubscriptBox["w", "T"]}]}], "/.", "params"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubscriptBox["w", "T"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"\[Gamma]", " ", 
     SubscriptBox["A", "T"]}], "+", 
    SubscriptBox["m", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "T"}]], "+", 
    RowBox[{"\[Lambda]", " ", 
     SubscriptBox["w", "T"]}], "+", 
    SubscriptBox["\[Epsilon]", "T"]}], ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389717667685224*^9, 3.389717680108224*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["EV", "T"], "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           SubscriptBox["p", "T"], " ", 
           SubscriptBox["w", "T"]}], "/.", 
          SubscriptBox["p", "Rule"]}], "/.", 
         SubscriptBox["m", "Rule"]}], "/.", 
        SubscriptBox["A", "Rule"]}], "/.", 
       RowBox[{
        SubscriptBox["s", "T"], "\[Rule]", 
        SubscriptBox["w", "T"]}]}], "/.", "\[Epsilon]Zap"}], "/.", "uZap"}], "/.",
     "params"}], "//", "FullSimplify"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubscriptBox["w", "T"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"\[Gamma]", " ", "\[Theta]", " ", 
     SubscriptBox["A", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "T"}]]}], "+", 
    SubscriptBox["m", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "T"}]], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Gamma]", "+", "\[Lambda]"}], ")"}], " ", 
     SubscriptBox["w", "T"]}]}], ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389717667901224*^9, 3.389717680196224*^9}}]
}, Open  ]],

Cell["At time T-1, the value function is:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["EV", "T"], "+", 
     RowBox[{
      SubscriptBox["p", 
       RowBox[{"T", "-", "1"}]], 
      SubscriptBox["s", 
       RowBox[{"T", "-", "1"}]]}]}], ")"}], "/.", 
   SubscriptBox["p", "Rule"]}], "/.", "wRule"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["1", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "T"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"\[Gamma]", " ", 
      SubscriptBox["A", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "T"}]]}], "+", 
     SubscriptBox["m", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "T"}]]}], ")"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["1", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "T"}]]}], "+", 
     SubscriptBox["w", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "T"}]]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"\[Gamma]", " ", "\[Theta]", " ", 
      SubscriptBox["A", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "T"}]]}], "+", 
     SubscriptBox["m", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "T"}]], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"\[Gamma]", "+", "\[Lambda]"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["1", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "T"}]]}], "+", 
        SubscriptBox["w", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "T"}]]}], ")"}]}]}], ")"}]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389717667935224*^9, 3.389717680218224*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SubscriptBox["EV", "T"], "+", 
             RowBox[{
              SubscriptBox["p", 
               RowBox[{"T", "-", "1"}]], 
              SubscriptBox["s", 
               RowBox[{"T", "-", "1"}]]}]}], ")"}], "/.", "params"}], "/.", 
          "wRule"}], "/.", 
         SubscriptBox["p", "Rule"]}], "/.", 
        SubscriptBox["m", "Rule"]}], "/.", 
       SubscriptBox["A", "Rule"]}], "/.", "\[Epsilon]Zap"}], "/.", "uZap"}], "/.",
     "params"}], "//", "FullSimplify"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[Gamma]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "\[Theta]"}], ")"}]}], "+", "\[Lambda]"}], 
    ")"}], " ", 
   SubsuperscriptBox["1", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "T"}], "2"]}], "+", 
  RowBox[{
   SubscriptBox["1", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "T"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[Gamma]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "\[Theta]"}], ")"}], " ", "\[Theta]", " ", 
      SubscriptBox["A", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "T"}]]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\[Gamma]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", "\[Theta]"}], ")"}]}], "-", "\[Lambda]"}],
        ")"}], " ", 
      SubscriptBox["w", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "T"}]]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["w", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "T"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"\[Gamma]", " ", 
      SuperscriptBox["\[Theta]", "2"], " ", 
      SubscriptBox["A", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "T"}]]}], "+", 
     SubscriptBox["m", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "T"}]], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"\[Gamma]", "+", "\[Lambda]"}], ")"}], " ", 
      SubscriptBox["w", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "T"}]]}]}], ")"}]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3897176682162237`*^9, 3.389717680622224*^9}}]
}, Open  ]],

Cell["Optimizing:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"0", "==", 
         RowBox[{
          SubscriptBox["\[PartialD]", 
           SubscriptBox["s", 
            RowBox[{
             RowBox[{"T", "-", "1"}], "/.", "params"}]]], " ", "v"}]}], "/.", 
        "params"}], ",", 
       SubscriptBox["s", 
        RowBox[{
         RowBox[{"T", "-", "1"}], "/.", "params"}]]}], "]"}], "//", 
     "Simplify"}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubscriptBox["1", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "T"}]], "\[Rule]", 
  FractionBox[
   RowBox[{
    RowBox[{
     RowBox[{"-", "\[Gamma]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Theta]"}], ")"}], " ", "\[Theta]", " ", 
     SubscriptBox["A", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "T"}]]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\[Gamma]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", "\[Theta]"}], ")"}]}], "-", "\[Lambda]"}], 
      ")"}], " ", 
     SubscriptBox["w", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "T"}]]}]}], 
   RowBox[{
    RowBox[{"2", " ", "\[Gamma]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "\[Theta]"}], ")"}]}], "-", 
    RowBox[{"2", " ", "\[Lambda]"}]}]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389717668415224*^9, 3.389717680660224*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{
   RowBox[{"sol", "[", 
    RowBox[{"[", "2", "]"}], "]"}], "//", "Apart"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"\[Gamma]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Theta]"}], ")"}], " ", "\[Theta]", " ", 
     SubscriptBox["A", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "T"}]]}], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "\[Gamma]"}], "+", 
       RowBox[{"\[Gamma]", " ", "\[Theta]"}], "-", "\[Lambda]"}], ")"}]}]]}], 
  "+", 
  FractionBox[
   SubscriptBox["w", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "T"}]], "2"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3897176685172243`*^9, 3.389717680691224*^9}}]
}, Open  ]],

Cell[TextData[{
 "Verify that the sign of the ",
 Cell[BoxData[
  SubscriptBox["A", 
   RowBox[{"T", "-", "2"}]]]],
 " coefficient is negative:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Coefficient", "[", 
     RowBox[{"s", ",", 
      SubscriptBox["A", 
       RowBox[{"T", "-", "2"}]]}], "]"}], "<", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Gamma]", ">", "0"}], ",", 
     RowBox[{"0", "<", "\[Theta]", "<", "1"}], ",", 
     RowBox[{"\[Lambda]", ">", "0"}]}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData["True"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389717668568224*^9, 3.3897176807302237`*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->None,
WindowSize->{1578, 1027},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Visible->True,
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
InputAliases->{"intt" -> RowBox[{"\[Integral]", 
     RowBox[{"\[SelectionPlaceholder]", 
       RowBox[{"\[DifferentialD]", "\[Placeholder]"}]}]}], "dintt" -> 
  RowBox[{
     SubsuperscriptBox[
     "\[Integral]", "\[SelectionPlaceholder]", "\[Placeholder]"], 
     RowBox[{"\[Placeholder]", 
       RowBox[{"\[DifferentialD]", "\[Placeholder]"}]}]}], "sumt" -> RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"\[SelectionPlaceholder]", "=", "\[Placeholder]"}], 
      "\[Placeholder]"], "\[Placeholder]"}], "prodt" -> RowBox[{
     UnderoverscriptBox["\[Product]", 
      RowBox[{"\[SelectionPlaceholder]", "=", "\[Placeholder]"}], 
      "\[Placeholder]"], "\[Placeholder]"}], "dt" -> RowBox[{
     SubscriptBox["\[PartialD]", "\[Placeholder]"], " ", 
     "\[SelectionPlaceholder]"}], "notation" -> RowBox[{"Notation", "[", 
     RowBox[{
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> "NotationTemplateStyle"],
        " ", "\[DoubleLongLeftRightArrow]", " ", 
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> 
        "NotationTemplateStyle"]}], "]"}], "notation>" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> "NotationTemplateStyle"],
        " ", "\[DoubleLongRightArrow]", " ", 
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> 
        "NotationTemplateStyle"]}], "]"}], "notation<" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> "NotationTemplateStyle"],
        " ", "\[DoubleLongLeftArrow]", " ", 
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> 
        "NotationTemplateStyle"]}], "]"}], "symb" -> 
  RowBox[{"Symbolize", "[", 
     TagBox[
     "\[Placeholder]", NotationBoxTag, TagStyle -> "NotationTemplateStyle"], 
     "]"}], "infixnotation" -> RowBox[{"InfixNotation", "[", 
     RowBox[{
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> "NotationTemplateStyle"],
        ",", "\[Placeholder]"}], "]"}], "addia" -> 
  RowBox[{"AddInputAlias", "[", 
     RowBox[{"\"\[Placeholder]\"", "\[Rule]", 
       TagBox[
       "\[Placeholder]", NotationBoxTag, TagStyle -> 
        "NotationTemplateStyle"]}], "]"}], "pattwraper" -> 
  TagBox["\[Placeholder]", NotationPatternTag, TagStyle -> 
    "NotationPatternWrapperStyle"], "madeboxeswraper" -> 
  TagBox["\[Placeholder]", NotationMadeBoxesTag, TagStyle -> 
    "NotationMadeBoxesWrapperStyle"], "E" -> "\[ScriptCapitalE]"},
Magnification->1.5,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->"EMMStyle02.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "ExTradingStrategy"->{
  Cell[32714, 1148, 67, 1, 65, "Subsection",
   CellTags->"ExTradingStrategy"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"ExTradingStrategy", 115468, 3336}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 883, 24, 430, "Title"],
Cell[CellGroupData[{
Cell[1500, 52, 410, 9, 43, "Input"],
Cell[1913, 63, 724, 16, 51, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2674, 84, 34, 0, 92, "Section"],
Cell[2711, 86, 143, 3, 43, "Input"],
Cell[2857, 91, 111, 3, 32, "Text"],
Cell[2971, 96, 369, 12, 43, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3377, 113, 49, 0, 92, "Section"],
Cell[CellGroupData[{
Cell[3451, 117, 36, 0, 65, "Subsection"],
Cell[3490, 119, 1472, 51, 129, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4999, 175, 142, 5, 66, "Subsection"],
Cell[5144, 182, 95, 3, 43, "Input"],
Cell[CellGroupData[{
Cell[5264, 189, 459, 16, 79, "Input"],
Cell[5726, 207, 1076, 35, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6839, 247, 313, 10, 79, "Input"],
Cell[7155, 259, 1260, 41, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8452, 305, 549, 18, 46, "Input"],
Cell[9004, 325, 1863, 56, 64, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10904, 386, 407, 13, 43, "Input"],
Cell[11314, 401, 1078, 33, 59, "Output"]
}, Open  ]],
Cell[12407, 437, 37, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[12469, 441, 151, 4, 43, "Input"],
Cell[12623, 447, 615, 20, 56, "Output"]
}, Open  ]],
Cell[13253, 470, 104, 3, 43, "Input"],
Cell[CellGroupData[{
Cell[13382, 477, 34, 0, 44, "Subsubsection"],
Cell[13419, 479, 63, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[13507, 483, 3399, 96, 474, "Input"],
Cell[16909, 581, 2349, 62, 32, "Print"],
Cell[19261, 645, 144, 2, 32, "Print"],
Cell[19408, 649, 2524, 74, 85, "Print"],
Cell[21935, 725, 131, 2, 32, "Print"],
Cell[22069, 729, 1615, 50, 141, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23745, 786, 48, 0, 65, "Subsection"],
Cell[CellGroupData[{
Cell[23818, 790, 168, 7, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[24011, 801, 441, 14, 71, "Input"],
Cell[24455, 817, 869, 29, 59, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25361, 851, 395, 13, 43, "Input"],
Cell[25759, 866, 354, 12, 59, "Output"]
}, Open  ]],
Cell[26128, 881, 29, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[26182, 885, 390, 14, 71, "Input"],
Cell[26575, 901, 354, 12, 59, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26978, 919, 89, 4, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[27092, 927, 835, 27, 98, "Input"],
Cell[27930, 956, 757, 26, 59, "Output"]
}, Open  ]],
Cell[28702, 985, 29, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[28756, 989, 390, 14, 71, "Input"],
Cell[29149, 1005, 788, 27, 59, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29986, 1038, 89, 4, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[30100, 1046, 835, 27, 98, "Input"],
Cell[30938, 1075, 572, 19, 59, "Output"]
}, Open  ]],
Cell[31525, 1097, 29, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[31579, 1101, 390, 14, 71, "Input"],
Cell[31972, 1117, 574, 19, 59, "Output"]
}, Open  ]],
Cell[32561, 1139, 104, 3, 43, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[32714, 1148, 67, 1, 65, "Subsection",
 CellTags->"ExTradingStrategy"],
Cell[CellGroupData[{
Cell[32806, 1153, 39, 0, 44, "Subsubsection"],
Cell[32848, 1155, 1516, 53, 129, "Input"],
Cell[CellGroupData[{
Cell[34389, 1212, 485, 15, 43, "Input"],
Cell[34877, 1229, 1886, 49, 35, "Print"],
Cell[36766, 1280, 144, 2, 32, "Print"],
Cell[36913, 1284, 2060, 63, 85, "Print"],
Cell[38976, 1349, 131, 2, 32, "Print"],
Cell[39110, 1353, 2677, 80, 175, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[41824, 1438, 406, 12, 43, "Input"],
Cell[42233, 1452, 895, 30, 91, "Output"]
}, Open  ]],
Cell[43143, 1485, 158, 4, 33, "Text"],
Cell[CellGroupData[{
Cell[43326, 1493, 216, 7, 46, "Input"],
Cell[43545, 1502, 1013, 34, 143, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[44631, 1544, 99, 2, 92, "Section"],
Cell[CellGroupData[{
Cell[44755, 1550, 37, 0, 44, "Subsubsection"],
Cell[44795, 1552, 1612, 55, 129, "Input"],
Cell[46410, 1609, 24, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[46459, 1613, 195, 6, 43, "Input"],
Cell[46657, 1621, 549, 18, 41, "Output"]
}, Open  ]],
Cell[47221, 1642, 270, 9, 43, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47528, 1656, 43, 0, 44, "Subsubsection"],
Cell[CellGroupData[{
Cell[47596, 1660, 166, 5, 43, "Input"],
Cell[47765, 1667, 2138, 57, 32, "Print"],
Cell[49906, 1726, 144, 2, 32, "Print"],
Cell[50053, 1730, 2280, 68, 67, "Print"],
Cell[52336, 1800, 133, 2, 32, "Print"],
Cell[52472, 1804, 2689, 80, 117, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[55198, 1889, 229, 7, 43, "Input"],
Cell[55430, 1898, 521, 17, 59, "Output"]
}, Open  ]],
Cell[55966, 1918, 474, 14, 43, "Input"],
Cell[56443, 1934, 666, 21, 43, "Input"],
Cell[57112, 1957, 880, 30, 43, "Input"],
Cell[57995, 1989, 313, 8, 43, "Input"],
Cell[CellGroupData[{
Cell[58333, 2001, 1757, 45, 152, "Input"],
Cell[60093, 2048, 3041, 69, 450, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[63171, 2122, 1886, 49, 188, "Input"],
Cell[65060, 2173, 6456, 116, 374, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[71553, 2294, 508, 14, 43, "Input"],
Cell[72064, 2310, 28471, 496, 327, 10083, 192, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[100596, 2813, 95, 2, 92, "Section"],
Cell[CellGroupData[{
Cell[100716, 2819, 37, 0, 44, "Subsubsection"],
Cell[100756, 2821, 1941, 67, 212, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[102734, 2893, 55, 0, 65, "Subsection"],
Cell[102792, 2895, 47, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[102864, 2899, 369, 13, 43, "Input"],
Cell[103236, 2914, 453, 14, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[103726, 2933, 635, 21, 43, "Input"],
Cell[104364, 2956, 537, 17, 38, "Output"]
}, Open  ]],
Cell[104916, 2976, 51, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[104992, 2980, 336, 12, 43, "Input"],
Cell[105331, 2994, 1325, 47, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[106693, 3046, 746, 24, 43, "Input"],
Cell[107442, 3072, 1710, 60, 44, "Output"]
}, Open  ]],
Cell[109167, 3135, 27, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[109219, 3139, 606, 20, 50, "Input"],
Cell[109828, 3161, 976, 33, 59, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[110841, 3199, 161, 5, 43, "Input"],
Cell[111005, 3206, 693, 23, 59, "Output"]
}, Open  ]],
Cell[111713, 3232, 156, 6, 33, "Text"],
Cell[CellGroupData[{
Cell[111894, 3242, 425, 13, 43, "Input"],
Cell[112322, 3257, 127, 2, 38, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
