(* ::Package:: *)

(************************************************************************)
(* This file was generated automatically by the Mathematica front end.  *)
(* It contains Initialization cells from a Notebook file, which         *)
(* typically will have the same name as this file except ending in      *)
(* ".nb" instead of ".m".                                               *)
(*                                                                      *)
(* This file is intended to be loaded into the Mathematica kernel using *)
(* the package loading commands Get or Needs.  Doing so is equivalent   *)
(* to using the Evaluate Initialization Cells menu command in the front *)
(* end.                                                                 *)
(*                                                                      *)
(* DO NOT EDIT THIS FILE.  This entire file is regenerated              *)
(* automatically each time the parent Notebook file is saved in the     *)
(* Mathematica front end.  Any changes you make to this file will be    *)
(* overwritten.                                                         *)
(************************************************************************)



(* ::Title:: *)
(*MVN package*)
(*Empirical Market Microstructure *)
(*	(2006, Oxford University Press)*)
(*Companion Mathematica notebook*)
(**)
(*Joel Hasbrouck*)
(*Copyright 2007, Joel Hasbrouck. All rights reserved.*)


(* ::Text:: *)
(*This package defines a multivariate normal distribution "object" (i.e, a representation for variables that are multivariate normal), and various routines to work with them. The notebook should be stored as a package.*)


(* ::Section:: *)
(*Properties of the multivariate normal distribution:*)


(* ::Text:: *)
(*The package implements functionality based on the following relations.*)


(* ::Text:: *)
(*Consider a multivariate normal distribution:*)


(* ::NumberedEquation:: *)
(**)
(*\!\(\*UnderscriptBox["X", *)
(*RowBox[{"n", "*", "1"}]]\)=({*)
(* {Subscript[X, 1]},*)
(* {Subscript[X, 2]}*)
(*}); E[X]=\[Mu]=({*)
(* {Subscript[\[Mu], 1]},*)
(* {Subscript[\[Mu], 2]}*)
(*}); Var[X]=\[CapitalSigma]=({*)
(* {Subscript[\[CapitalSigma], 11], Subscript[\[CapitalSigma], 12]},*)
(* {Subscript[\[CapitalSigma], 21], Subscript[\[CapitalSigma], 22]}*)
(*})*)


(* ::Text:: *)
(*The partitions here must be consistent, but are otherwise arbitrary. Either Subscript[X, 1] or Subscript[X, 2] or both may be scalars.*)


(* ::Text:: *)
(*If X~MVN(\[Mu],\[CapitalSigma]), then*)


(* ::NumberedEquation:: *)
(*E[Subscript[X, 1]|Subscript[X, 2]]=Subscript[\[Mu], 1]+(Subscript[X, 2]-Subscript[\[Mu], 2])\!*)
(*\*SubsuperscriptBox[\(\[CapitalSigma]\), \(22\), \(-1\)]Subscript[\[CapitalSigma], 21]*)


(* ::NumberedEquation:: *)
(*Var[Subscript[X, 1]|Subscript[X, 2]]=Subscript[\[CapitalSigma], 11]-Subscript[\[CapitalSigma], 12]\!*)
(*\*SubsuperscriptBox[\(\[CapitalSigma]\), \(22\), \(-1\)]Subscript[\[CapitalSigma], 21]*)


(* ::Text:: *)
(*Consider a linear transform Y=AX+b, where A is a rectangular matrix and b is a column vector. Then:*)


(* ::NumberedEquation:: *)
(*Y~MVN(A \[Mu]+b, *)
(*\!\(\*SuperscriptBox["A\[CapitalSigma]A", "\[Prime]"]\))*)


BeginPackage["MVN`"];


(* ::Subsubsection:: *)
(*The MVN "object"*)


MVN::usage="MVN[\[Mu],\[CapitalSigma],v] is an object that represents a multivariate normal distribution with mean vector \[Mu] and covariance matrix \[CapitalSigma]. The third parameter, v, is list of Mathematica expressions that correspond to the variables. (Typically they are variable names or formulas for the variables.)";


GetMean::usage="GetMean[mvn] where mvn is an MVN object returns the mean vector of mvn.";


SetMean::usage="SetMean[mvn,\[Mu]New] where mvn is an MVN object returns mvn with the mean vector set to \[Mu]New.";


GetVariance::usage="GetVariance[mvn] where mvn is an MVN object returns the variance matrix of mvn.";


SetVariance::usage="SetVariance[mvn,\[CapitalSigma]New] where mvn is an MVN object returns mvn with the variance matrix set to \[CapitalSigma]New.";


GetLabel::usage="GetLabel[mvn] where mvn is an MVN object returns the label vector of mvn.";


SetLabel::usage="SetLabel[MVN,v2] returns an MVN object in which the vector of variable expressions is replaced by v2.";


StandardMVN::usage="StandardMVN[n,x] returns an MVN of order n with zero mean and a covariance matrix equal to the identity matrix. The variables are labeled \!\(\*SubscriptBox[\"x\", \"1\"]\),...,\!\(\*SubscriptBox[\"x\", \"n\"]\). If the second argument is omitted, the variables are labeled \!\(\*SubscriptBox[\"z\", \"1\"]\),...,\!\(\*SubscriptBox[\"z\", \"n\"]\)";


LinearForm::usage="LinearForm[mvn1,b,c] (where b is a matrix and c is a vector) returns an MVN that describes a linear transformation of mvn1. If mvn1=MVN[\[Mu],\[CapitalSigma],v] then the return MVN is the distribution of b.v+c. LinearForm[mvn1,b] returns an MVN giving the distribution of b.v";


MakeLinearForm::usage="MakeLinearForm[MVN0,b] returns an MVN object representing the distribution of a set of linear combinations of the variables in MVN0=MVN[\[Mu],\[CapitalSigma],v]. b is a list of expressions defining linear combinations of v (and a constant, if desired).";


MVNConditional::usage="MVNConditional[MVN0,v1,v2] returns an MVN object representing a conditional multivariate normal distribution. MVN0=MVN0[\[Mu],\[CapitalSigma],v] is the joint distribution. v2 is a list of the conditioning variables; v1 is a list of the target variables. Both v1 and v2 must map to (correspond to) v. MVNConditional[MVN0,v1] returns the conditional distribution of v1 conditioned on all variables that are not in v1.";


Format[MVN[\[Mu]Local_,\[CapitalSigma]Local_,vLocal_]]:=RowBox[{mpForm[vLocal]," ~ ",StyleBox[\[ScriptCapitalN],FontSize->16,FontWeight->Bold],"(",
mpForm[\[Mu]Local],",",mpForm[\[CapitalSigma]Local],")"}]//DisplayForm


Begin["`Private`"];


(* ::Subsubsection:: *)
(*DisplayForm formatting of MVN objects*)


(* ::Subsubsection:: *)
(*Getting and setting parameters*)


GetMean[MVN[\[Mu]_,\[CapitalSigma]_,v_]]:=GetElement[\[Mu]];


SetMean[MVN[\[Mu]_,\[CapitalSigma]_,v_],\[Mu]New_]:=MVN[\[Mu]New,\[CapitalSigma],v]


GetVariance[MVN[\[Mu]_,\[CapitalSigma]_,v_]]:=GetElement[\[CapitalSigma]]


SetVariance[MVN[\[Mu]_,\[CapitalSigma]_,v_],\[CapitalSigma]New_]:=MVN[\[Mu],\[CapitalSigma]New,v]


GetLabel[MVN[\[Mu]_,\[CapitalSigma]_,v_]]:=GetElement[v];


SetLabel[MVN[\[Mu]_,\[CapitalSigma]_,v_],v2_]:=MVN[\[Mu],\[CapitalSigma],v2]


(* ::Subsubsection:: *)
(*Constructing and transforming MVN's*)


StandardMVN[1,v_:Global`z]:=MVN[0,1,v]


StandardMVN[n_,v_:Global`z]:=MVN[Table[0,{n}],IdentityMatrix[n],Table[Subscript[v, i],{i,1,n}]]


LinearForm[MVN[\[Mu]_,\[CapitalSigma]_,v_],b_,c_:0]:=MVN[b.ToVector[\[Mu]]+c,b.ToMatrix[\[CapitalSigma]].Transpose[b],b.ToVector[v]+c]


MakeLinearForm[MVN[\[Mu]_,\[CapitalSigma]_,v_],vNew_]:=Module[{b,b0},
b=Transpose[Coefficient[ToVector[vNew],#,1]&/@ ToVector[v]];
b0 = ToVector[vNew]-b.ToVector[v];
LinearForm[MVN[\[Mu],\[CapitalSigma],v],b,b0]
]


(* ::Subsubsection:: *)
(*Conditional distributions*)


MVNConditional[MVN[\[Mu]_,\[CapitalSigma]_,v_],v1a_,v2a_:0]:=Module[{v1,v2,i1,i2},
v1=ToVector[v1a];
i1=Position[v,#]&/@v1 // Flatten;
i2=
If[v2a=!=0,
	v2=ToVector[v2a];Position[v,#]&/@v2 //Flatten,
	Complement[Range[Length[ToVector[v]]],i1]
];
MVN[
\[Mu][[i1]]+(v[[i2]]-\[Mu][[i2]]).Inverse[\[CapitalSigma][[i2,i2]]].\[CapitalSigma][[i2,i1]],
\[CapitalSigma][[i1,i1]]-\[CapitalSigma][[i1,i2]].Inverse[\[CapitalSigma][[i2,i2]]].\[CapitalSigma][[i2,i1]],
v[[i1]]]
]


(* ::Subsubsection:: *)
(*Helper functions*)


mpForm[x_]:=Which[MatrixQ[x]&&((Times @@ Dimensions @ x)==1),x[[1,1]],
VectorQ[x]&&(Length[x]==1),x[[1]],True,MatrixForm[x]];


GetElement[x_]:=Which[MatrixQ[x]&&((Times @@ Dimensions @ x)==1),x[[1,1]],
VectorQ[x]&&(Length[x]==1),x[[1]],True,x];


ToVector[x_]:=Flatten[{x}];


ToMatrix[x_]:=Which[MatrixQ[x],x,VectorQ[x],{x},True,{{x}}];


End[];


EndPackage[]
