(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    254499,       8424]
NotebookOptionsPosition[    229090,       7620]
NotebookOutlinePosition[    233250,       7736]
CellTagsIndexPosition[    232867,       7720]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "StrategicTrade\n",
 StyleBox["Empirical Market Microstructure",
  FontSlant->"Italic"],
 " \n\t(2006, Oxford University Press)\nCompanion ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook\n\nJoel Hasbrouck\n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Copyright", " ", "2007"}], ",", " ", 
    RowBox[{"Joel", " ", 
     RowBox[{"Hasbrouck", ".", " ", "All"}], " ", "rights", " ", 
     RowBox[{"reserved", "."}]}]}], TraditionalForm]],
  FontSize->14,
  FontSlant->"Italic"],
 "\n",
 StyleBox["This notebook covers material related to the strategic trade \
models (Chapter 7).",
  FontSize->14]
}], "Title",
 CellChangeTimes->{{3.3896255910914*^9, 3.3896255932033997`*^9}, {
   3.3897167078988237`*^9, 3.389716768500824*^9}, 3.3897219191158237`*^9, {
   3.3897220399168243`*^9, 3.3897220640418243`*^9}, {3.389735393500024*^9, 
   3.389735431148024*^9}, 3.389735530878024*^9, 3.3897355723880243`*^9, {
   3.389735664464024*^9, 3.3897356860350237`*^9}, {3.3899891508672*^9, 
   3.3899891819161997`*^9}, {3.3899914301996*^9, 3.3899914551656*^9}, {
   3.3899917048936*^9, 3.3899917280786*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Text", "  ", "@", " ", 
  RowBox[{"Style", "[", 
   RowBox[{
    RowBox[{"\"\<Notebook evaluated \>\"", "<>", 
     RowBox[{"DateString", "[", "\"\<DateTime\>\"", "]"}]}], ",", 
    "\"\<Subtitle\>\""}], "]"}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896127180972*^9, 3.3896127205282*^9}, 
   3.389716999411824*^9, {3.3897170351038237`*^9, 3.389717047196824*^9}}],

Cell[BoxData[
 InterpretationBox[Cell[BoxData[
   StyleBox["\<\"Notebook evaluated Monday 4 June 2007 20:23:25\"\>", 
    "Subtitle",
    StripOnInput->False]], "Text", "TR"],
  Text[
   Style["Notebook evaluated Monday 4 June 2007 20:23:25", 
    "Subtitle"]]]], "Output",
 CellMargins->{{18, Inherited}, {Inherited, 0}},
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896127211071997`*^9, {3.3896127536242*^9, 3.3896127555652*^9}, 
   3.3896128616452*^9, 3.389623031447*^9, 3.3896232934164*^9, 
   3.389716955274824*^9, 3.3897170008718243`*^9, {3.3897170377738237`*^9, 
   3.3897170482808237`*^9}, 3.389735230721224*^9, 3.3899894613552*^9, 
   3.3899897610886*^9, 3.3899911755866003`*^9, 3.3899914898976*^9, 
   3.3899917493266*^9, 3.3899918053166*^9},
 Background->RGBColor[0.866667, 0.733333, 1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Preliminaries", "Section"],

Cell[CellGroupData[{

Cell["Invoke the multivariate normal package", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "SetDirectory", "[", 
   "\"\<c:/Active/Empirical Market Microstructure/Mathematica/Spring \
2007\>\"", "]"}], ";"}]], "Input",
 CellAutoOverwrite->False,
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3881708634346*^9, 3.3881708734596*^9}, {
  3.3881710728336*^9, 3.3881711170716*^9}, {3.389524702079319*^9, 
  3.389524702676319*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{"<<", "MVN.m"}], "Input"]], "Input",
 CellLabelAutoDelete->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Notations", "Subsection"],

Cell[BoxData[
 RowBox[{"<<", "Notation`"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896230434639997`*^9, 3.389623048724*^9}}],

Cell["\<\
The following commands define symbolizations that are convenient for labeling \
things.\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["Anything_", "Rule"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";", 
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["Anything_", "Rules"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["Anything_", "Solution"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";", 
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["Anything_", "Solutions"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";"}]}], "Input",
 CellLabelAutoDelete->True],

Cell["\<\
The following command allows the \"expectation\" operator to be entered as \
\[EscapeKey]E\[EscapeKey].\
\>", "Text"],

Cell[BoxData[
 RowBox[{"AddInputAlias", "[", 
  RowBox[{
   TagBox["\[ScriptCapitalE]",
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], ",", "\"\<E\>\""}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"Symbolize", "[", 
  TagBox[
   SubsuperscriptBox["\[Sigma]", "_", "2"],
   NotationBoxTag,
   BaseStyle->"NotationTemplateStyle"], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"Symbolize", "[", 
  TagBox[
   SubscriptBox["\[Mu]", "_"],
   NotationBoxTag,
   BaseStyle->"NotationTemplateStyle"], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"Symbolize", "[", 
  TagBox[
   SubscriptBox["\[CapitalSigma]", "_"],
   NotationBoxTag,
   BaseStyle->"NotationTemplateStyle"], "]"}]], "Input",
 CellLabelAutoDelete->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["The single-period model", "Section",
 CellTags->"c:40"],

Cell[CellGroupData[{

Cell["The informed trader's problem", "Subsubsection",
 CellTags->"c:41"],

Cell["\<\
The informed trader conjectures that the MM uses a linear price adjustment \
rule:\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["p", "Rule"], "=", 
   RowBox[{"p", "\[Rule]", 
    RowBox[{
     RowBox[{"y", " ", "\[Lambda]"}], "+", "\[Mu]"}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "where ",
 StyleBox["y",
  FontSlant->"Italic"],
 " is the total order flow:"
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["y", "Rule"], "=", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"u", "+", "x"}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell["The informed trader's profits are:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Pi]", "Rule"], "=", 
   RowBox[{"\[Pi]", "\[Rule]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"v", "-", "p"}], ")"}], " ", "x"}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "Substituting in for the price conjecture and ",
 StyleBox["y",
  FontSlant->"Italic"],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Pi]", "/.", "\[InvisibleSpace]", 
    SubscriptBox["\[Pi]", "Rule"]}], "/.", "\[InvisibleSpace]", 
   SubscriptBox["p", "Rule"]}], "/.", "\[InvisibleSpace]", 
  SubscriptBox["y", "Rule"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"x", " ", 
  RowBox[{"(", 
   RowBox[{"v", "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"u", "+", "x"}], ")"}], " ", "\[Lambda]"}], "-", "\[Mu]"}], 
   ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623036686*^9, 3.3896231123426*^9, 
  3.3896232942544003`*^9, 3.3899917524955997`*^9, 3.3899918071056004`*^9}]
}, Closed]],

Cell[TextData[{
 "The expected profits are ",
 Cell[BoxData[
  FormBox[Cell["E\[Pi]"], TraditionalForm]]],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"E\[Pi]", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[Pi]", "/.", "\[InvisibleSpace]", 
      SubscriptBox["\[Pi]", "Rule"]}], "/.", "\[InvisibleSpace]", 
     SubscriptBox["p", "Rule"]}], "/.", "\[InvisibleSpace]", 
    SubscriptBox["y", "Rule"]}], "/.", "\[InvisibleSpace]", 
   RowBox[{"u", "\[Rule]", "0"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"x", " ", 
  RowBox[{"(", 
   RowBox[{"v", "-", 
    RowBox[{"x", " ", "\[Lambda]"}], "-", "\[Mu]"}], ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230367209997`*^9, 3.3896231123915997`*^9, 
  3.3896232942834*^9, 3.3899917525466003`*^9, 3.3899918071686*^9}]
}, Closed]],

Cell[TextData[{
 "The informed trader maximizes expected profits by trading ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]]],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xOpt", "=", " ", 
  RowBox[{"First", " ", "@", " ", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["\[PartialD]", "x"], "E\[Pi]"}], "\[Equal]", "0"}], ",", 
     "x"}], "]"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   FractionBox[
    RowBox[{"v", "-", "\[Mu]"}], 
    RowBox[{"2", " ", "\[Lambda]"}]]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623036777*^9, 3.3896231124596*^9, 3.3896232943204*^9, 
  3.3899917526015997`*^9, 3.3899918072356*^9}]
}, Closed]],

Cell["The second-order condition for the max is ", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[PartialD]", 
    RowBox[{"x", ",", "x"}]], "E\[Pi]"}], "<", "0"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "2"}], " ", "\[Lambda]"}], "<", "0"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623036811*^9, 3.3896231125116*^9, 3.3896232943504*^9, 
  3.3899917526526003`*^9, 3.3899918073096*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["The market maker's problem", "Subsubsection",
 CellTags->"c:42"],

Cell[TextData[{
 "The MM conjectures that the informed trader's demand is linear in ",
 Cell[BoxData["v"]],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["x", "Rule"], "=", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"\[Alpha]", "+", 
    RowBox[{"v", " ", "\[Beta]"}]}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"x", "\[Rule]", 
  RowBox[{"\[Alpha]", "+", 
   RowBox[{"v", " ", "\[Beta]"}]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623036848*^9, 3.3896231125746*^9, 3.3896232943844*^9, 
  3.3899917527106*^9, 3.3899918073686*^9}]
}, Closed]],

Cell["\<\
Knowing the optimization process that the informed trader followed, the MM \
can solve for \[Alpha] and \[Beta]:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xEqu", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "/.", "\[InvisibleSpace]", 
     SubscriptBox["x", "Rule"]}], ")"}], "\[Equal]", 
   RowBox[{"(", 
    RowBox[{"x", "/.", "\[InvisibleSpace]", "xOpt"}], ")"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Alpha]", "+", 
   RowBox[{"v", " ", "\[Beta]"}]}], "\[Equal]", 
  FractionBox[
   RowBox[{"v", "-", "\[Mu]"}], 
   RowBox[{"2", " ", "\[Lambda]"}]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623036887*^9, 3.3896231126476*^9, 3.3896232944154*^9, 
  3.3899917527646*^9, 3.3899918074186*^9}]
}, Closed]],

Cell[TextData[{
 "for all ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]]],
 ". This implies:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "=", 
  RowBox[{"Reduce", "[", " ", 
   RowBox[{
    RowBox[{"ForAll", "[", 
     RowBox[{"v", ",", "True", ",", "xEqu"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Alpha]", ",", "\[Beta]"}], "}"}], ",", "Reals"}], 
   "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"\[Lambda]", "<", "0"}], "&&", 
    RowBox[{"\[Alpha]", "\[Equal]", 
     RowBox[{"-", 
      FractionBox["\[Mu]", 
       RowBox[{"2", " ", "\[Lambda]"}]]}]}], "&&", 
    RowBox[{"\[Beta]", "\[Equal]", 
     FractionBox["1", 
      RowBox[{"2", " ", "\[Lambda]"}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"\[Lambda]", ">", "0"}], "&&", 
    RowBox[{"\[Alpha]", "\[Equal]", 
     RowBox[{"-", 
      FractionBox["\[Mu]", 
       RowBox[{"2", " ", "\[Lambda]"}]]}]}], "&&", 
    RowBox[{"\[Beta]", "\[Equal]", 
     FractionBox["1", 
      RowBox[{"2", " ", "\[Lambda]"}]]}]}], ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623037001*^9, 3.3896231127256002`*^9, 
  3.3896232944744*^9, 3.3899917528826*^9, 3.3899918075126*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["x", "Solutions"], "=", 
  RowBox[{"ToRules", "[", 
   RowBox[{"r", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Alpha]", "\[Rule]", 
    RowBox[{"-", 
     FractionBox["\[Mu]", 
      RowBox[{"2", " ", "\[Lambda]"}]]}]}], ",", 
   RowBox[{"\[Beta]", "\[Rule]", 
    FractionBox["1", 
     RowBox[{"2", " ", "\[Lambda]"}]]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.38962303704*^9, 3.3896231127756*^9, 
  3.3896232945053997`*^9, 3.3899917532125998`*^9, 3.3899918075766*^9}]
}, Closed]],

Cell[TextData[{
 "Now the MM must figure out ",
 Cell[BoxData[
  RowBox[{"E", "[", 
   RowBox[{
    RowBox[{"V", "|", "Y"}], "=", "y"}], "]"}]]],
 ". First, consider the joint distribution of ",
 Cell[BoxData["v"]],
 " and ",
 Cell[BoxData["u"]],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"uvDist", "=", 
  RowBox[{"MVN", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       SubscriptBox["p", "0"], "}"}], ",", 
      RowBox[{"{", "0", "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["\[CapitalSigma]", "0"], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"v", ",", "u"}], "}"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"v"},
        {"u"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["p", "0"]},
       {"0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["\[CapitalSigma]", "0"], "0"},
       {"0", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623037086*^9, 3.3896231128416*^9, 3.3896232945464*^9, 
  3.3899917532876*^9, 3.3899918076246*^9}]
}, Closed]],

Cell[TextData[{
 "Now consider the joint distribution of ",
 Cell[BoxData["v"]],
 " and ",
 Cell[BoxData["y"]],
 " where ",
 Cell[BoxData[
  RowBox[{"y", "="}]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "/.", 
   SubscriptBox["y", "Rule"]}], "/.", 
  SubscriptBox["x", "Rule"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"u", "+", "\[Alpha]", "+", 
  RowBox[{"v", " ", "\[Beta]"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623037127*^9, 3.3896231128886003`*^9, 
  3.3896232945774*^9, 3.3899917533556004`*^9, 3.3899918076636*^9}]
}, Closed]],

Cell["So", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MakeLinearForm", "[", 
  RowBox[{"uvDist", ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{
      RowBox[{"y", "/.", 
       SubscriptBox["y", "Rule"]}], "/.", 
      SubscriptBox["x", "Rule"]}]}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"v"},
        {
         RowBox[{"u", "+", "\[Alpha]", "+", 
          RowBox[{"v", " ", "\[Beta]"}]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["p", "0"]},
        {
         RowBox[{"\[Alpha]", "+", 
          RowBox[{"\[Beta]", " ", 
           SubscriptBox["p", "0"]}]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["\[CapitalSigma]", "0"], 
        RowBox[{"\[Beta]", " ", 
         SubscriptBox["\[CapitalSigma]", "0"]}]},
       {
        RowBox[{"\[Beta]", " ", 
         SubscriptBox["\[CapitalSigma]", "0"]}], 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Beta]", "2"], " ", 
          SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
         SubsuperscriptBox["\[Sigma]", "u", "2"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230371689997`*^9, 3.3896231129435997`*^9, 
  3.3896232946154003`*^9, 3.3899917534926*^9, 3.3899918077246*^9}]
}, Closed]],

Cell["Relabeling:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vyDist", "=", 
  RowBox[{"SetLabel", "[", 
   RowBox[{"%", ",", 
    RowBox[{"{", 
     RowBox[{"v", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"v"},
        {"y"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["p", "0"]},
        {
         RowBox[{"\[Alpha]", "+", 
          RowBox[{"\[Beta]", " ", 
           SubscriptBox["p", "0"]}]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["\[CapitalSigma]", "0"], 
        RowBox[{"\[Beta]", " ", 
         SubscriptBox["\[CapitalSigma]", "0"]}]},
       {
        RowBox[{"\[Beta]", " ", 
         SubscriptBox["\[CapitalSigma]", "0"]}], 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Beta]", "2"], " ", 
          SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
         SubsuperscriptBox["\[Sigma]", "u", "2"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623037204*^9, 3.3896231130095997`*^9, 
  3.3896232946443996`*^9, 3.3899917535506*^9, 3.3899918077796*^9}]
}, Closed]],

Cell[TextData[{
 "Now consider the conditional distribution ",
 Cell[BoxData[
  RowBox[{"v", "|", "y"}]]],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vConditionalDist", "=", 
  RowBox[{"MVNConditional", "[", 
   RowBox[{"vyDist", ",", "v", ",", "y"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"v", 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   RowBox[{
    SubscriptBox["p", "0"], "+", 
    FractionBox[
     RowBox[{"\[Beta]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"], " ", 
      RowBox[{"(", 
       RowBox[{"y", "-", "\[Alpha]", "-", 
        RowBox[{"\[Beta]", " ", 
         SubscriptBox["p", "0"]}]}], ")"}]}], 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], ",", 
   RowBox[{
    SubscriptBox["\[CapitalSigma]", "0"], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SubsuperscriptBox["\[CapitalSigma]", "0", "2"]}], 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623037273*^9, 3.3896231130875998`*^9, 
  3.3896232946784*^9, 3.3899917536296*^9, 3.3899918078366003`*^9}]
}, Closed]],

Cell[TextData[{
 "Market efficiency requires that the mean of this distribution be equal to \
",
 Cell[BoxData["p"]],
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GetMean", "[", "vConditionalDist", "]"}], "\[Equal]", 
  RowBox[{"(", 
   RowBox[{"p", "/.", 
    SubscriptBox["p", "Rule"]}], ")"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["p", "0"], "+", 
   FractionBox[
    RowBox[{"\[Beta]", " ", 
     SubscriptBox["\[CapitalSigma]", "0"], " ", 
     RowBox[{"(", 
      RowBox[{"y", "-", "\[Alpha]", "-", 
       RowBox[{"\[Beta]", " ", 
        SubscriptBox["p", "0"]}]}], ")"}]}], 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], "\[Equal]", 
  RowBox[{
   RowBox[{"y", " ", "\[Lambda]"}], "+", "\[Mu]"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623037308*^9, 3.3896231131466*^9, 3.3896232947094*^9, 
  3.3899917536876*^9, 3.3899918078866*^9}]
}, Closed]],

Cell[TextData[{
 "for all values of ",
 Cell[BoxData["y"]],
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"ForAll", "[", 
     RowBox[{"y", ",", "True", ",", "%"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Mu]", ",", "\[Lambda]"}], "}"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Beta]", "2"], " ", 
     SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
    SubsuperscriptBox["\[Sigma]", "u", "2"]}], "\[NotEqual]", "0"}], "&&", 
  RowBox[{"\[Mu]", "\[Equal]", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[Alpha]"}], " ", "\[Beta]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
      SubscriptBox["p", "0"]}]}], 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], "&&", 
  RowBox[{"\[Lambda]", "\[Equal]", 
   FractionBox[
    RowBox[{"\[Beta]", " ", 
     SubscriptBox["\[CapitalSigma]", "0"]}], 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623037418*^9, 3.3896231132246*^9, 3.3896232947634*^9, 
  3.3899917543255997`*^9, 3.3899918080126*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["p", "Solutions"], "=", 
  RowBox[{"ToRules", "[", 
   RowBox[{"r", "[", 
    RowBox[{"[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], "]"}], "]"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Mu]", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[Alpha]"}], " ", "\[Beta]", " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
       SubscriptBox["p", "0"]}]}], 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], ",", 
   RowBox[{"\[Lambda]", "\[Rule]", 
    FractionBox[
     RowBox[{"\[Beta]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230374560003`*^9, 3.3896231132816*^9, 
  3.3896232947974*^9, 3.3899917543956003`*^9, 3.3899918080425997`*^9}]
}, Closed]],

Cell["Collecting these results...", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EquationSet", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Equal", "@@", "#1"}], "&"}], ")"}], "/@", 
   RowBox[{"Join", "[", 
    RowBox[{
     SubscriptBox["p", "Solutions"], ",", 
     SubscriptBox["x", "Solutions"]}], "]"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Mu]", "\[Equal]", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[Alpha]"}], " ", "\[Beta]", " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
       SubscriptBox["p", "0"]}]}], 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], ",", 
   RowBox[{"\[Lambda]", "\[Equal]", 
    FractionBox[
     RowBox[{"\[Beta]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], ",", 
   RowBox[{"\[Alpha]", "\[Equal]", 
    RowBox[{"-", 
     FractionBox["\[Mu]", 
      RowBox[{"2", " ", "\[Lambda]"}]]}]}], ",", 
   RowBox[{"\[Beta]", "\[Equal]", 
    FractionBox["1", 
     RowBox[{"2", " ", "\[Lambda]"}]]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230374960003`*^9, 3.3896231133515997`*^9, 
  3.3896232948254004`*^9, 3.3899917548816*^9, 3.3899918080676003`*^9}]
}, Closed]],

Cell["\<\
... and solving for the parameters in terms of the fundamental variables. \
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["Model", "Solutions"], "=", 
   RowBox[{"Solve", "[", 
    RowBox[{"EquationSet", ",", 
     RowBox[{"{", 
      RowBox[{"\[Mu]", ",", "\[Lambda]", ",", "\[Alpha]", ",", "\[Beta]"}], 
      "}"}]}], "]"}]}], ";", " ", 
  RowBox[{
   SubscriptBox["Model", "Solutions"], "//", "TableForm"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"\[Alpha]", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SqrtBox[
          SubsuperscriptBox["\[Sigma]", "u", "2"]], " ", 
         SubscriptBox["p", "0"]}], 
        SqrtBox[
         SubscriptBox["\[CapitalSigma]", "0"]]]}]}], 
     RowBox[{"\[Mu]", "\[Rule]", 
      SubscriptBox["p", "0"]}], 
     RowBox[{"\[Lambda]", "\[Rule]", 
      FractionBox[
       SqrtBox[
        SubscriptBox["\[CapitalSigma]", "0"]], 
       RowBox[{"2", " ", 
        SqrtBox[
         SubsuperscriptBox["\[Sigma]", "u", "2"]]}]]}], 
     RowBox[{"\[Beta]", "\[Rule]", 
      FractionBox[
       SqrtBox[
        SubsuperscriptBox["\[Sigma]", "u", "2"]], 
       SqrtBox[
        SubscriptBox["\[CapitalSigma]", "0"]]]}]},
    {
     RowBox[{"\[Alpha]", "\[Rule]", 
      FractionBox[
       RowBox[{
        SqrtBox[
         SubsuperscriptBox["\[Sigma]", "u", "2"]], " ", 
        SubscriptBox["p", "0"]}], 
       SqrtBox[
        SubscriptBox["\[CapitalSigma]", "0"]]]}], 
     RowBox[{"\[Mu]", "\[Rule]", 
      SubscriptBox["p", "0"]}], 
     RowBox[{"\[Lambda]", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        SqrtBox[
         SubscriptBox["\[CapitalSigma]", "0"]], 
        RowBox[{"2", " ", 
         SqrtBox[
          SubsuperscriptBox["\[Sigma]", "u", "2"]]}]]}]}], 
     RowBox[{"\[Beta]", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        SqrtBox[
         SubsuperscriptBox["\[Sigma]", "u", "2"]], 
        SqrtBox[
         SubscriptBox["\[CapitalSigma]", "0"]]]}]}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230376540003`*^9, 3.3896231134296*^9, 
  3.3896232948714*^9, 3.3899917552726*^9, 3.3899918081376*^9}]
}, Closed]],

Cell[TextData[{
 "Only first solution has positive ",
 Cell[BoxData["\[Lambda]"]],
 " and ",
 Cell[BoxData["\[Beta]"]],
 ", so:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["Model", "Solutions"], "=", 
   RowBox[{"First", " ", "@", " ", 
    SubscriptBox["Model", "Solutions"]}]}], ";", " ", 
  RowBox[{"TableForm", " ", "@", " ", 
   SubscriptBox["Model", "Solutions"]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{"\[Alpha]", "\[Rule]", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SqrtBox[
           SubsuperscriptBox["\[Sigma]", "u", "2"]], " ", 
          SubscriptBox["p", "0"]}], 
         SqrtBox[
          SubscriptBox["\[CapitalSigma]", "0"]]]}]}]},
     {
      RowBox[{"\[Mu]", "\[Rule]", 
       SubscriptBox["p", "0"]}]},
     {
      RowBox[{"\[Lambda]", "\[Rule]", 
       FractionBox[
        SqrtBox[
         SubscriptBox["\[CapitalSigma]", "0"]], 
        RowBox[{"2", " ", 
         SqrtBox[
          SubsuperscriptBox["\[Sigma]", "u", "2"]]}]]}]},
     {
      RowBox[{"\[Beta]", "\[Rule]", 
       FractionBox[
        SqrtBox[
         SubsuperscriptBox["\[Sigma]", "u", "2"]], 
        SqrtBox[
         SubscriptBox["\[CapitalSigma]", "0"]]]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623037709*^9, 3.3896231134906*^9, 
  3.3896232948993998`*^9, 3.3899917553346*^9, 3.3899918081646*^9}]
}, Closed]],

Cell["Note:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    SubscriptBox["y", "Rule"], "/.", 
    SubscriptBox["x", "Rule"]}], "/.", 
   SubscriptBox["Model", "Solutions"]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"y", "\[Rule]", 
  RowBox[{"u", "+", 
   FractionBox[
    RowBox[{"v", " ", 
     SqrtBox[
      SubsuperscriptBox["\[Sigma]", "u", "2"]]}], 
    SqrtBox[
     SubscriptBox["\[CapitalSigma]", "0"]]], "-", 
   FractionBox[
    RowBox[{
     SqrtBox[
      SubsuperscriptBox["\[Sigma]", "u", "2"]], " ", 
     SubscriptBox["p", "0"]}], 
    SqrtBox[
     SubscriptBox["\[CapitalSigma]", "0"]]]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623037755*^9, 3.3896231135666*^9, 3.3896232949414*^9, 
  3.3899917555826*^9, 3.3899918082446003`*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Properties of the solution", "Subsubsection",
 CellTags->"c:43"],

Cell["The informed trader's expected profits are:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"PowerExpand", "[", 
   RowBox[{
    RowBox[{"E\[Pi]", "/.", "\[InvisibleSpace]", 
     SubscriptBox["x", "Rule"]}], "//.", "\[InvisibleSpace]", 
    SubscriptBox["Model", "Solutions"]}], "]"}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    SubsuperscriptBox["\[Sigma]", "u", "2"]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"v", "-", 
      SubscriptBox["p", "0"]}], ")"}], "2"]}], 
  RowBox[{"2", " ", 
   SqrtBox[
    SubscriptBox["\[CapitalSigma]", "0"]]}]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230377939997`*^9, 3.3896231136366*^9, 
  3.3896232949764*^9, 3.3899917558356*^9, 3.3899918082806*^9}]
}, Closed]],

Cell["The informed trader's demand is", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["x", "Rule"], "/.", "\[InvisibleSpace]", 
   SubscriptBox["Model", "Solutions"]}], "//", "Simplify"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"x", "\[Rule]", 
  FractionBox[
   RowBox[{
    SqrtBox[
     SubsuperscriptBox["\[Sigma]", "u", "2"]], " ", 
    RowBox[{"(", 
     RowBox[{"v", "-", 
      SubscriptBox["p", "0"]}], ")"}]}], 
   SqrtBox[
    SubscriptBox["\[CapitalSigma]", "0"]]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623037836*^9, 3.3896231137056*^9, 3.3896232950084*^9, 
  3.3899917559096003`*^9, 3.3899918083086*^9}]
}, Closed]],

Cell["\<\
How much of the private information is impounded in the price? \
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GetVariance", "[", "vConditionalDist", "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SubscriptBox["\[CapitalSigma]", "0"], " ", 
   SubsuperscriptBox["\[Sigma]", "u", "2"]}], 
  RowBox[{
   RowBox[{
    SuperscriptBox["\[Beta]", "2"], " ", 
    SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
   SubsuperscriptBox["\[Sigma]", "u", "2"]}]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230378710003`*^9, 3.3896231137606*^9, 
  3.3896232950484*^9, 3.3899917559716*^9, 3.3899918083326*^9}]
}, Closed]],

Cell["Or, in terms of the input parameters:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"%", "//.", "\[InvisibleSpace]", 
   SubscriptBox["Model", "Solutions"]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 FractionBox[
  SubscriptBox["\[CapitalSigma]", "0"], "2"]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623037909*^9, 3.3896231138106003`*^9, 
  3.3896232950774*^9, 3.3899917560506*^9, 3.3899918083866*^9}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems based on the single-period model", "Section",
 CellTags->"c:51"],

Cell[CellGroupData[{

Cell["Exercise 7.1 (Informative noise traders)", "Subsection",
 CellTags->"ExStrategicTrade1"],

Cell["As in the basic problem:", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["p", "Rule"], "=", 
   RowBox[{"p", "\[Rule]", 
    RowBox[{
     RowBox[{"y", " ", "\[Lambda]"}], "+", "\[Mu]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["y", "Rule"], "=", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"u", "+", "x"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["\[Pi]", "Rule"], "=", 
   RowBox[{"\[Pi]", "\[Rule]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"v", "-", "p"}], ")"}], " ", "x"}]}]}], ";"}]}], "Input",
 CellLabelAutoDelete->True],

Cell["The informed trader's profits are:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Pi]", "/.", "\[InvisibleSpace]", 
    SubscriptBox["\[Pi]", "Rule"]}], "/.", "\[InvisibleSpace]", 
   SubscriptBox["p", "Rule"]}], "/.", "\[InvisibleSpace]", 
  SubscriptBox["y", "Rule"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"x", " ", 
  RowBox[{"(", 
   RowBox[{"v", "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"u", "+", "x"}], ")"}], " ", "\[Lambda]"}], "-", "\[Mu]"}], 
   ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623037954*^9, 3.3896231174616003`*^9, 
  3.3896232951174*^9, 3.3899917561966*^9, 3.3899918084166*^9}]
}, Closed]],

Cell[TextData[{
 "At this point we diverge from the basic model because ",
 Cell[BoxData["u"]],
 " and ",
 Cell[BoxData["v"]],
 " are correlated. The projection the informed trader makes is:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"uvDist", "=", 
  RowBox[{"MVN", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       SubscriptBox["p", "0"], "}"}], ",", 
      RowBox[{"{", "0", "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["\[CapitalSigma]", "0"], ",", 
        SubscriptBox["\[Sigma]", "uv"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["\[Sigma]", "uv"], ",", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"v", ",", "u"}], "}"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"v"},
        {"u"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["p", "0"]},
       {"0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["\[CapitalSigma]", "0"], 
        SubscriptBox["\[Sigma]", "uv"]},
       {
        SubscriptBox["\[Sigma]", "uv"], 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623037992*^9, 3.3896231175016003`*^9, 
  3.3896232951454*^9, 3.3899917562676*^9, 3.3899918084716*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"uConditionalDist", "=", 
  RowBox[{"MVNConditional", "[", 
   RowBox[{"uvDist", ",", "u", ",", "v"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"u", 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"v", "-", 
       SubscriptBox["p", "0"]}], ")"}], " ", 
     SubscriptBox["\[Sigma]", "uv"]}], 
    SubscriptBox["\[CapitalSigma]", "0"]], ",", 
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "u", "2"], "-", 
    FractionBox[
     SubsuperscriptBox["\[Sigma]", "uv", "2"], 
     SubscriptBox["\[CapitalSigma]", "0"]]}], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.38962303804*^9, 3.3896231175396*^9, 3.3896232951754*^9, 
  3.3899917563316*^9, 3.3899918085226*^9}]
}, Closed]],

Cell[TextData[{
 "The informed trader's expected profits (conditional on ",
 Cell[BoxData["v"]],
 ") are:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"E\[Pi]", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"\[Pi]", "/.", 
       SubscriptBox["\[Pi]", "Rule"]}], "/.", 
      SubscriptBox["p", "Rule"]}], "/.", 
     SubscriptBox["y", "Rule"]}], "/.", 
    RowBox[{"u", "\[Rule]", 
     RowBox[{"GetMean", "[", "uConditionalDist", "]"}]}]}]}], 
  "\[IndentingNewLine]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"x", " ", 
  RowBox[{"(", 
   RowBox[{"v", "-", "\[Mu]", "-", 
    RowBox[{"\[Lambda]", " ", 
     RowBox[{"(", 
      RowBox[{"x", "+", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"v", "-", 
           SubscriptBox["p", "0"]}], ")"}], " ", 
         SubscriptBox["\[Sigma]", "uv"]}], 
        SubscriptBox["\[CapitalSigma]", "0"]]}], ")"}]}]}], ")"}]}]], "Output",\

 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623038075*^9, 3.3896231175776*^9, 3.3896232952064*^9, 
  3.3899917563966*^9, 3.3899918085746*^9}]
}, Closed]],

Cell["The informed trader's optimal trade is:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xOpt", "=", 
  RowBox[{"First", " ", "@", "  ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["\[PartialD]", "x"], "E\[Pi]"}], "\[Equal]", "0"}], ",", 
      "x"}], "]"}], "]"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"v", "-", "\[Mu]"}], ")"}], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     RowBox[{"\[Lambda]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "v"}], "+", 
        SubscriptBox["p", "0"]}], ")"}], " ", 
      SubscriptBox["\[Sigma]", "uv"]}]}], 
    RowBox[{"2", " ", "\[Lambda]", " ", 
     SubscriptBox["\[CapitalSigma]", "0"]}]]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623038126*^9, 3.3896231176205997`*^9, 
  3.3896232952464*^9, 3.3899917564656*^9, 3.3899918086446*^9}]
}, Closed]],

Cell[TextData[{
 "The MM conjectures that the informed trader's demand is linear in ",
 Cell[BoxData["v"]],
 " (as above), and must figure out ",
 Cell[BoxData[
  RowBox[{"E", "[", 
   RowBox[{"v", "|", "y"}], "]"}]]],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["x", "Rule"], "=", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"\[Alpha]", "+", 
     RowBox[{"v", " ", "\[Beta]"}]}]}]}], ";"}], "\n", 
 RowBox[{"xEqu", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "/.", "\[InvisibleSpace]", 
     SubscriptBox["x", "Rule"]}], ")"}], "\[Equal]", 
   RowBox[{"(", 
    RowBox[{"x", "/.", "\[InvisibleSpace]", "xOpt"}], ")"}]}]}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Alpha]", "+", 
   RowBox[{"v", " ", "\[Beta]"}]}], "\[Equal]", 
  FractionBox[
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"v", "-", "\[Mu]"}], ")"}], " ", 
     SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
    RowBox[{"\[Lambda]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "v"}], "+", 
       SubscriptBox["p", "0"]}], ")"}], " ", 
     SubscriptBox["\[Sigma]", "uv"]}]}], 
   RowBox[{"2", " ", "\[Lambda]", " ", 
    SubscriptBox["\[CapitalSigma]", "0"]}]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623038166*^9, 3.3896231176596003`*^9, 
  3.3896232952774*^9, 3.3899917565316*^9, 3.3899918086996*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["x", "Solutions"], "=", 
  RowBox[{"Reduce", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["\[ForAll]", "v"], "xEqu"}], " ", "&&", " ", 
     RowBox[{
      SubscriptBox["\[CapitalSigma]", "0"], ">", "0"}], " ", "&&", " ", 
     RowBox[{"\[Lambda]", ">", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Alpha]", ",", "\[Beta]"}], "}"}], ",", "Reals"}], 
   "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[CapitalSigma]", "0"], ">", "0"}], "&&", 
  RowBox[{"\[Lambda]", ">", "0"}], "&&", 
  RowBox[{"\[Alpha]", "\[Equal]", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[Mu]"}], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     RowBox[{"\[Lambda]", " ", 
      SubscriptBox["p", "0"], " ", 
      SubscriptBox["\[Sigma]", "uv"]}]}], 
    RowBox[{"2", " ", "\[Lambda]", " ", 
     SubscriptBox["\[CapitalSigma]", "0"]}]]}], "&&", 
  RowBox[{"\[Beta]", "\[Equal]", 
   FractionBox[
    RowBox[{
     SubscriptBox["\[CapitalSigma]", "0"], "-", 
     RowBox[{"\[Lambda]", " ", 
      SubscriptBox["\[Sigma]", "uv"]}]}], 
    RowBox[{"2", " ", "\[Lambda]", " ", 
     SubscriptBox["\[CapitalSigma]", "0"]}]]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623038227*^9, 3.3896231177216*^9, 
  3.3896232953324003`*^9, 3.3899917566046*^9, 3.3899918088046*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["x", "Solutions"], "=", 
  RowBox[{"Simplify", " ", "@", " ", 
   RowBox[{"ToRules", " ", "@", " ", 
    RowBox[{"Take", "[", 
     RowBox[{
      SubscriptBox["x", "Solutions"], ",", 
      RowBox[{"-", "2"}]}], "]"}]}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Alpha]", "\[Rule]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["\[Mu]", "\[Lambda]"]}], "+", 
       FractionBox[
        RowBox[{
         SubscriptBox["p", "0"], " ", 
         SubscriptBox["\[Sigma]", "uv"]}], 
        SubscriptBox["\[CapitalSigma]", "0"]]}], ")"}]}]}], ",", 
   RowBox[{"\[Beta]", "\[Rule]", 
    FractionBox[
     RowBox[{
      SubscriptBox["\[CapitalSigma]", "0"], "-", 
      RowBox[{"\[Lambda]", " ", 
       SubscriptBox["\[Sigma]", "uv"]}]}], 
     RowBox[{"2", " ", "\[Lambda]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}]]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230382679996`*^9, 3.3896231177616*^9, 
  3.3896232953654003`*^9, 3.3899917567466*^9, 3.3899918088626003`*^9}]
}, Closed]],

Cell[TextData[{
 "Now the MM must compute ",
 Cell[BoxData[
  RowBox[{"E", "[", 
   RowBox[{"v", "|", "y"}], "]"}]]],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MakeLinearForm", "[", 
  RowBox[{"uvDist", ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{
      RowBox[{"y", "/.", 
       SubscriptBox["y", "Rule"]}], "/.", 
      SubscriptBox["x", "Rule"]}]}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"v"},
        {
         RowBox[{"u", "+", "\[Alpha]", "+", 
          RowBox[{"v", " ", "\[Beta]"}]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["p", "0"]},
        {
         RowBox[{"\[Alpha]", "+", 
          RowBox[{"\[Beta]", " ", 
           SubscriptBox["p", "0"]}]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["\[CapitalSigma]", "0"], 
        RowBox[{
         RowBox[{"\[Beta]", " ", 
          SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
         SubscriptBox["\[Sigma]", "uv"]}]},
       {
        RowBox[{
         RowBox[{"\[Beta]", " ", 
          SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
         SubscriptBox["\[Sigma]", "uv"]}], 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
         RowBox[{"\[Beta]", " ", 
          SubscriptBox["\[Sigma]", "uv"]}], "+", 
         RowBox[{"\[Beta]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[Beta]", " ", 
             SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
            SubscriptBox["\[Sigma]", "uv"]}], ")"}]}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230383050003`*^9, 3.3896231178036003`*^9, 
  3.3896232953964*^9, 3.3899917568206*^9, 3.3899918089236*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vyDist", "=", 
  RowBox[{"SetLabel", "[", 
   RowBox[{"%", ",", 
    RowBox[{"{", 
     RowBox[{"v", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"v"},
        {"y"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["p", "0"]},
        {
         RowBox[{"\[Alpha]", "+", 
          RowBox[{"\[Beta]", " ", 
           SubscriptBox["p", "0"]}]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["\[CapitalSigma]", "0"], 
        RowBox[{
         RowBox[{"\[Beta]", " ", 
          SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
         SubscriptBox["\[Sigma]", "uv"]}]},
       {
        RowBox[{
         RowBox[{"\[Beta]", " ", 
          SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
         SubscriptBox["\[Sigma]", "uv"]}], 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
         RowBox[{"\[Beta]", " ", 
          SubscriptBox["\[Sigma]", "uv"]}], "+", 
         RowBox[{"\[Beta]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[Beta]", " ", 
             SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
            SubscriptBox["\[Sigma]", "uv"]}], ")"}]}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623038344*^9, 3.3896231178396*^9, 3.3896232954274*^9, 
  3.3899917568946*^9, 3.3899918089936*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vConditionalDist", "=", 
  RowBox[{
   RowBox[{"MVNConditional", "[", 
    RowBox[{"vyDist", ",", "v", ",", "y"}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"v", 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"y", "-", "\[Alpha]"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\[Beta]", " ", 
         SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
        SubscriptBox["\[Sigma]", "uv"]}], ")"}]}], "+", 
     RowBox[{
      SubscriptBox["p", "0"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
        RowBox[{"\[Beta]", " ", 
         SubscriptBox["\[Sigma]", "uv"]}]}], ")"}]}]}], 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
     RowBox[{"2", " ", "\[Beta]", " ", 
      SubscriptBox["\[Sigma]", "uv"]}]}]], ",", 
   FractionBox[
    RowBox[{
     RowBox[{
      SubscriptBox["\[CapitalSigma]", "0"], " ", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}], "-", 
     SubsuperscriptBox["\[Sigma]", "uv", "2"]}], 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
     RowBox[{"2", " ", "\[Beta]", " ", 
      SubscriptBox["\[Sigma]", "uv"]}]}]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230384049997`*^9, 3.3896231178936*^9, 
  3.3896232954784*^9, 3.3899917569946003`*^9, 3.3899918091106*^9}]
}, Closed]],

Cell["Market efficiency:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pEqu", "=", " ", 
  RowBox[{
   RowBox[{"GetMean", "[", "vConditionalDist", "]"}], "\[Equal]", 
   RowBox[{"(", 
    RowBox[{"p", "/.", 
     SubscriptBox["p", "Rule"]}], ")"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"y", "-", "\[Alpha]"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\[Beta]", " ", 
        SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
       SubscriptBox["\[Sigma]", "uv"]}], ")"}]}], "+", 
    RowBox[{
     SubscriptBox["p", "0"], " ", 
     RowBox[{"(", 
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
       RowBox[{"\[Beta]", " ", 
        SubscriptBox["\[Sigma]", "uv"]}]}], ")"}]}]}], 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Beta]", "2"], " ", 
     SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
    SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
    RowBox[{"2", " ", "\[Beta]", " ", 
     SubscriptBox["\[Sigma]", "uv"]}]}]], "\[Equal]", 
  RowBox[{
   RowBox[{"y", " ", "\[Lambda]"}], "+", "\[Mu]"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.38962303844*^9, 3.3896231179326*^9, 3.3896232955184*^9, 
  3.3899917570615997`*^9, 3.3899918091656*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"ForAll", "[", 
     RowBox[{"y", ",", "True", ",", "pEqu"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Mu]", ",", "\[Lambda]"}], "}"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Beta]", "2"], " ", 
     SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
    SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
    RowBox[{"2", " ", "\[Beta]", " ", 
     SubscriptBox["\[Sigma]", "uv"]}]}], "\[NotEqual]", "0"}], "&&", 
  RowBox[{"\[Mu]", "\[Equal]", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[Alpha]"}], " ", "\[Beta]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
      SubscriptBox["p", "0"]}], "-", 
     RowBox[{"\[Alpha]", " ", 
      SubscriptBox["\[Sigma]", "uv"]}], "+", 
     RowBox[{"\[Beta]", " ", 
      SubscriptBox["p", "0"], " ", 
      SubscriptBox["\[Sigma]", "uv"]}]}], 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
     RowBox[{"2", " ", "\[Beta]", " ", 
      SubscriptBox["\[Sigma]", "uv"]}]}]]}], "&&", 
  RowBox[{"\[Lambda]", "\[Equal]", 
   FractionBox[
    RowBox[{
     RowBox[{"\[Beta]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     SubscriptBox["\[Sigma]", "uv"]}], 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
     RowBox[{"2", " ", "\[Beta]", " ", 
      SubscriptBox["\[Sigma]", "uv"]}]}]]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623038513*^9, 3.3896231179996*^9, 3.3896232955804*^9, 
  3.3899917572486*^9, 3.3899918092876*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["p", "Solutions"], "=", 
  RowBox[{"ToRules", "[", 
   RowBox[{"Take", "[", 
    RowBox[{"r", ",", 
     RowBox[{"-", "2"}]}], "]"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Mu]", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[Alpha]"}], " ", "\[Beta]", " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
       SubscriptBox["p", "0"]}], "-", 
      RowBox[{"\[Alpha]", " ", 
       SubscriptBox["\[Sigma]", "uv"]}], "+", 
      RowBox[{"\[Beta]", " ", 
       SubscriptBox["p", "0"], " ", 
       SubscriptBox["\[Sigma]", "uv"]}]}], 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
      RowBox[{"2", " ", "\[Beta]", " ", 
       SubscriptBox["\[Sigma]", "uv"]}]}]]}], ",", 
   RowBox[{"\[Lambda]", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"\[Beta]", " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      SubscriptBox["\[Sigma]", "uv"]}], 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
      RowBox[{"2", " ", "\[Beta]", " ", 
       SubscriptBox["\[Sigma]", "uv"]}]}]]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623038551*^9, 3.3896231180366*^9, 3.3896232956104*^9, 
  3.3899917574416*^9, 3.3899918093096*^9}]
}, Closed]],

Cell["Collecting the results and solving:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EquSet", "=", 
  RowBox[{"Apply", "[", 
   RowBox[{"Equal", ",", 
    RowBox[{"Join", "[", 
     RowBox[{
      SubscriptBox["p", "Solutions"], ",", 
      SubscriptBox["x", "Solutions"]}], "]"}], ",", "1"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Mu]", "\[Equal]", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[Alpha]"}], " ", "\[Beta]", " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
       SubscriptBox["p", "0"]}], "-", 
      RowBox[{"\[Alpha]", " ", 
       SubscriptBox["\[Sigma]", "uv"]}], "+", 
      RowBox[{"\[Beta]", " ", 
       SubscriptBox["p", "0"], " ", 
       SubscriptBox["\[Sigma]", "uv"]}]}], 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
      RowBox[{"2", " ", "\[Beta]", " ", 
       SubscriptBox["\[Sigma]", "uv"]}]}]]}], ",", 
   RowBox[{"\[Lambda]", "\[Equal]", 
    FractionBox[
     RowBox[{
      RowBox[{"\[Beta]", " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      SubscriptBox["\[Sigma]", "uv"]}], 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
      RowBox[{"2", " ", "\[Beta]", " ", 
       SubscriptBox["\[Sigma]", "uv"]}]}]]}], ",", 
   RowBox[{"\[Alpha]", "\[Equal]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["\[Mu]", "\[Lambda]"]}], "+", 
       FractionBox[
        RowBox[{
         SubscriptBox["p", "0"], " ", 
         SubscriptBox["\[Sigma]", "uv"]}], 
        SubscriptBox["\[CapitalSigma]", "0"]]}], ")"}]}]}], ",", 
   RowBox[{"\[Beta]", "\[Equal]", 
    FractionBox[
     RowBox[{
      SubscriptBox["\[CapitalSigma]", "0"], "-", 
      RowBox[{"\[Lambda]", " ", 
       SubscriptBox["\[Sigma]", "uv"]}]}], 
     RowBox[{"2", " ", "\[Lambda]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}]]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230385880003`*^9, 3.3896231180776*^9, 
  3.3896232956414003`*^9, 3.3899917577005997`*^9, 3.3899918093326*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["Model", "Solutions"], "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{"EquSet", ",", 
       RowBox[{"{", 
        RowBox[{"\[Mu]", ",", "\[Lambda]", ",", "\[Alpha]", ",", "\[Beta]"}], 
        "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "u", "2"], ">", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[CapitalSigma]", "0"], ">", "0"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["Model", "Solutions"], "//", "Transpose"}], "//", 
  "TableForm"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"\[Alpha]", "\[Rule]", 
      FractionBox[
       RowBox[{
        SubscriptBox["p", "0"], " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["\[Sigma]", "uv"], "-", 
          SqrtBox[
           RowBox[{
            RowBox[{"4", " ", 
             SubscriptBox["\[CapitalSigma]", "0"], " ", 
             SubsuperscriptBox["\[Sigma]", "u", "2"]}], "-", 
            RowBox[{"3", " ", 
             SubsuperscriptBox["\[Sigma]", "uv", "2"]}]}]]}], ")"}]}], 
       RowBox[{"2", " ", 
        SubscriptBox["\[CapitalSigma]", "0"]}]]}], 
     RowBox[{"\[Alpha]", "\[Rule]", 
      FractionBox[
       RowBox[{
        SubscriptBox["p", "0"], " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["\[Sigma]", "uv"], "+", 
          SqrtBox[
           RowBox[{
            RowBox[{"4", " ", 
             SubscriptBox["\[CapitalSigma]", "0"], " ", 
             SubsuperscriptBox["\[Sigma]", "u", "2"]}], "-", 
            RowBox[{"3", " ", 
             SubsuperscriptBox["\[Sigma]", "uv", "2"]}]}]]}], ")"}]}], 
       RowBox[{"2", " ", 
        SubscriptBox["\[CapitalSigma]", "0"]}]]}]},
    {
     RowBox[{"\[Mu]", "\[Rule]", 
      SubscriptBox["p", "0"]}], 
     RowBox[{"\[Mu]", "\[Rule]", 
      SubscriptBox["p", "0"]}]},
    {
     RowBox[{"\[Lambda]", "\[Rule]", 
      FractionBox[
       RowBox[{
        SubscriptBox["\[CapitalSigma]", "0"], " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["\[Sigma]", "uv"], "+", 
          SqrtBox[
           RowBox[{
            RowBox[{"4", " ", 
             SubscriptBox["\[CapitalSigma]", "0"], " ", 
             SubsuperscriptBox["\[Sigma]", "u", "2"]}], "-", 
            RowBox[{"3", " ", 
             SubsuperscriptBox["\[Sigma]", "uv", "2"]}]}]]}], ")"}]}], 
       RowBox[{
        RowBox[{"4", " ", 
         SubscriptBox["\[CapitalSigma]", "0"], " ", 
         SubsuperscriptBox["\[Sigma]", "u", "2"]}], "-", 
        RowBox[{"3", " ", 
         SubsuperscriptBox["\[Sigma]", "uv", "2"]}], "+", 
        RowBox[{
         SubscriptBox["\[Sigma]", "uv"], " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"4", " ", 
            SubscriptBox["\[CapitalSigma]", "0"], " ", 
            SubsuperscriptBox["\[Sigma]", "u", "2"]}], "-", 
           RowBox[{"3", " ", 
            SubsuperscriptBox["\[Sigma]", "uv", "2"]}]}]]}]}]]}], 
     RowBox[{"\[Lambda]", "\[Rule]", 
      FractionBox[
       RowBox[{
        SubscriptBox["\[CapitalSigma]", "0"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["\[Sigma]", "uv"]}], "+", 
          SqrtBox[
           RowBox[{
            RowBox[{"4", " ", 
             SubscriptBox["\[CapitalSigma]", "0"], " ", 
             SubsuperscriptBox["\[Sigma]", "u", "2"]}], "-", 
            RowBox[{"3", " ", 
             SubsuperscriptBox["\[Sigma]", "uv", "2"]}]}]]}], ")"}]}], 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         SubscriptBox["\[CapitalSigma]", "0"], " ", 
         SubsuperscriptBox["\[Sigma]", "u", "2"]}], "+", 
        RowBox[{"3", " ", 
         SubsuperscriptBox["\[Sigma]", "uv", "2"]}], "+", 
        RowBox[{
         SubscriptBox["\[Sigma]", "uv"], " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"4", " ", 
            SubscriptBox["\[CapitalSigma]", "0"], " ", 
            SubsuperscriptBox["\[Sigma]", "u", "2"]}], "-", 
           RowBox[{"3", " ", 
            SubsuperscriptBox["\[Sigma]", "uv", "2"]}]}]]}]}]]}]},
    {
     RowBox[{"\[Beta]", "\[Rule]", 
      FractionBox[
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["\[Sigma]", "uv"]}], "+", 
        SqrtBox[
         RowBox[{
          RowBox[{"4", " ", 
           SubscriptBox["\[CapitalSigma]", "0"], " ", 
           SubsuperscriptBox["\[Sigma]", "u", "2"]}], "-", 
          RowBox[{"3", " ", 
           SubsuperscriptBox["\[Sigma]", "uv", "2"]}]}]]}], 
       RowBox[{"2", " ", 
        SubscriptBox["\[CapitalSigma]", "0"]}]]}], 
     RowBox[{"\[Beta]", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SubscriptBox["\[Sigma]", "uv"], "+", 
         SqrtBox[
          RowBox[{
           RowBox[{"4", " ", 
            SubscriptBox["\[CapitalSigma]", "0"], " ", 
            SubsuperscriptBox["\[Sigma]", "u", "2"]}], "-", 
           RowBox[{"3", " ", 
            SubsuperscriptBox["\[Sigma]", "uv", "2"]}]}]]}], 
        RowBox[{"2", " ", 
         SubscriptBox["\[CapitalSigma]", "0"]}]]}]}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623038867*^9, 3.3896231182236*^9, 
  3.3896232957804003`*^9, 3.3899917578375998`*^9, 3.3899918096226*^9}]
}, Closed]],

Cell[TextData[{
 "Only the first solution can have ",
 Cell[BoxData[
  RowBox[{"\[Beta]", ">", "0"}]]],
 ", So:"
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["Model", "Solutions"], "=", 
   RowBox[{
    SubscriptBox["Model", "Solutions"], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Sigma]", "uv"], "=", "0"}]]],
 ", this reduces to the original solutions:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    SubscriptBox["Model", "Solutions"], "/.", "\[InvisibleSpace]", 
    RowBox[{
     SubscriptBox["\[Sigma]", "uv"], "\[Rule]", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[CapitalSigma]", "0"], ">", "0"}], ",", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], ">", "0"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Alpha]", "\[Rule]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
       SubscriptBox["p", "0"]}], 
      SqrtBox[
       RowBox[{
        SubscriptBox["\[CapitalSigma]", "0"], " ", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}]]]}]}], ",", 
   RowBox[{"\[Mu]", "\[Rule]", 
    SubscriptBox["p", "0"]}], ",", 
   RowBox[{"\[Lambda]", "\[Rule]", 
    FractionBox[
     SubscriptBox["\[CapitalSigma]", "0"], 
     RowBox[{"2", " ", 
      SqrtBox[
       RowBox[{
        SubscriptBox["\[CapitalSigma]", "0"], " ", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]]}], ",", 
   RowBox[{"\[Beta]", "\[Rule]", 
    SqrtBox[
     FractionBox[
      SubsuperscriptBox["\[Sigma]", "u", "2"], 
      SubscriptBox["\[CapitalSigma]", "0"]]]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623038954*^9, 3.3896231182785997`*^9, 
  3.3896232958274*^9, 3.3899917579105997`*^9, 3.3899918096826*^9}]
}, Closed]],

Cell["With perfect correlation...", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AltSolution", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["Model", "Solutions"], "/.", "\[InvisibleSpace]", 
     RowBox[{
      SubscriptBox["\[Sigma]", "uv"], "\[Rule]", 
      SqrtBox[
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "u", "2"], 
        SubscriptBox["\[CapitalSigma]", "0"]}]]}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[CapitalSigma]", "0"], ">", "0"}], ",", 
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "u", "2"], ">", "0"}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Alpha]", "\[Rule]", "0"}], ",", 
   RowBox[{"\[Mu]", "\[Rule]", 
    SubscriptBox["p", "0"]}], ",", 
   RowBox[{"\[Lambda]", "\[Rule]", 
    SqrtBox[
     FractionBox[
      SubscriptBox["\[CapitalSigma]", "0"], 
      SubsuperscriptBox["\[Sigma]", "u", "2"]]]}], ",", 
   RowBox[{"\[Beta]", "\[Rule]", "0"}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623038998*^9, 3.3896231183156*^9, 3.3896232958634*^9, 
  3.3899917579716*^9, 3.3899918097455997`*^9}]
}, Closed]],

Cell[TextData[{
 "Since ",
 Cell[BoxData[
  RowBox[{"\[Beta]", "=", "0"}]]],
 ", the informed trader doesn't trade at all. The uninformed trade, though, \
is linear in ",
 Cell[BoxData["v"]],
 ":"
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["u", "Rule"], "=", 
   RowBox[{"u", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"v", "-", 
        SubscriptBox["p", "0"]}], ")"}], " ", 
      SqrtBox[
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
        SubscriptBox["\[CapitalSigma]", "0"]}]]}], 
     SubscriptBox["\[CapitalSigma]", "0"]]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "Under these conditions, the market clearing price becomes ",
 Cell[BoxData[
  RowBox[{"p", "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["p", "0"], "+", 
     RowBox[{"\[Lambda]", " ", "y"}]}], "=", "v"}]}]]],
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["p", "Rule"], "/.", "\[InvisibleSpace]", "AltSolution"}], 
      "/.", "\[InvisibleSpace]", 
      SubscriptBox["y", "Rule"]}], "/.", "\[InvisibleSpace]", 
     RowBox[{"x", "\[Rule]", "0"}]}], "/.", "\[InvisibleSpace]", 
    SubscriptBox["u", "Rule"]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[CapitalSigma]", "0"], ">", "0"}], ",", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], ">", "0"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"p", "\[Rule]", "v"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623039043*^9, 3.3896231183676*^9, 3.3896232959014*^9, 
  3.3899917580755997`*^9, 3.3899918098286*^9}]
}, Closed]],

Cell["Also,  the conditional variance is:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GetVariance", "[", "vConditionalDist", "]"}], "//.", 
   "\[InvisibleSpace]", 
   SubscriptBox["Model", "Solutions"]}], "/.", "\[InvisibleSpace]", 
  RowBox[{
   SubscriptBox["\[Sigma]", "uv"], "\[Rule]", 
   SqrtBox[
    RowBox[{
     SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
     SubscriptBox["\[CapitalSigma]", "0"]}]]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData["0"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.38962303909*^9, 3.3896231184016*^9, 
  3.3896232959323997`*^9, 3.3899917581516*^9, 3.3899918098506002`*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Exercise 7.2 (Informed trader gets a signal)", "Subsection",
 CellTags->"ExStrategicTrade2"],

Cell[TextData[{
 "The informed trader in the basic model has perfect information about ",
 StyleBox["v",
  FontSlant->"Italic"],
 ". Consider the case where she only gets a signal ",
 StyleBox["s",
  FontSlant->"Italic"],
 " about ",
 StyleBox["v",
  FontSlant->"Italic"],
 ". That is, ",
 Cell[BoxData[
  RowBox[{"s", "=", 
   RowBox[{"v", "+", "\[Epsilon]"}]}]]],
 " where ",
 Cell[BoxData[
  RowBox[{"\[Epsilon]", "~", 
   RowBox[{"N", "[", 
    RowBox[{"0", ",", 
     SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "]"}]}]]],
 ", independent of ",
 Cell[BoxData["v"]],
 ". Solve the model by proceeding as in the basic case. Solve the informed \
trader's problem; solve the MM's problem; solve for the model parameters ",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Mu]", ",", "\[Lambda]"}], 
   ")"}]]],
 " in terms of the inputs, ",
 Cell[BoxData[
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "u", "2"], ",", " ", 
   SubscriptBox["\[CapitalSigma]", "0"], ","}]]],
 " and ",
 Cell[BoxData[
  SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]]],
 ". Interpret your results. Verify that when ",
 Cell[BoxData[
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "=", "0"}]]],
 ", you get the original model solutions."
}], "Text"],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["p", "Rule"], "=", 
   RowBox[{"p", "\[Rule]", 
    RowBox[{
     RowBox[{"y", " ", "\[Lambda]"}], "+", "\[Mu]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["y", "Rule"], "=", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"u", "+", "x"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["\[Pi]", "Rule"], "=", 
   RowBox[{"\[Pi]", "\[Rule]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"v", "-", "p"}], ")"}], " ", "x"}]}]}], ";"}]}], "Input",
 CellLabelAutoDelete->True],

Cell["Informed trader's profits:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Pi]", "/.", "\[InvisibleSpace]", 
    SubscriptBox["\[Pi]", "Rule"]}], "/.", "\[InvisibleSpace]", 
   SubscriptBox["p", "Rule"]}], "/.", "\[InvisibleSpace]", 
  SubscriptBox["y", "Rule"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"x", " ", 
  RowBox[{"(", 
   RowBox[{"v", "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"u", "+", "x"}], ")"}], " ", "\[Lambda]"}], "-", "\[Mu]"}], 
   ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623039134*^9, 3.3896231184435997`*^9, 
  3.3896232959674*^9, 3.3899917582706003`*^9, 3.3899918098806*^9}]
}, Closed]],

Cell[TextData[{
 "The informed trader gets the signal ",
 Cell[BoxData["s"]],
 ":"
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["s", "Rule"], "=", 
   RowBox[{"s", "\[Rule]", 
    RowBox[{"v", "+", "\[Epsilon]"}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell["There are three random variables in this problem:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v\[Epsilon]uDistribution", "=", 
  RowBox[{"MVN", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["p", "0"], ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["\[CapitalSigma]", "0"], ",", "0", ",", "0"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], ",", "0"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"v", ",", "\[Epsilon]", ",", "u"}], "}"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"v"},
        {"\[Epsilon]"},
        {"u"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["p", "0"]},
        {"0"},
        {"0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["\[CapitalSigma]", "0"], "0", "0"},
       {"0", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "0"},
       {"0", "0", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623039176*^9, 3.3896231184966*^9, 3.3896232960114*^9, 
  3.3899917583616*^9, 3.3899918099616003`*^9}]
}, Closed]],

Cell[TextData[{
 "We can rework this into a distribution for ",
 Cell[BoxData[
  RowBox[{"v", ",", "s", ",", "u"}]]],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MakeLinearForm", "[", 
  RowBox[{"v\[Epsilon]uDistribution", ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"s", "/.", 
      SubscriptBox["s", "Rule"]}], ",", "u"}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"v"},
        {
         RowBox[{"v", "+", "\[Epsilon]"}]},
        {"u"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["p", "0"]},
        {
         SubscriptBox["p", "0"]},
        {"0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["\[CapitalSigma]", "0"], 
        SubscriptBox["\[CapitalSigma]", "0"], "0"},
       {
        SubscriptBox["\[CapitalSigma]", "0"], 
        RowBox[{
         SubscriptBox["\[CapitalSigma]", "0"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "0"},
       {"0", "0", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623039218*^9, 3.3896231185346003`*^9, 
  3.3896232960434*^9, 3.3899917584286003`*^9, 3.3899918099946003`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vsuDistribution", "=", 
  RowBox[{"SetLabel", "[", 
   RowBox[{"%", ",", 
    RowBox[{"{", 
     RowBox[{"v", ",", "s", ",", "u"}], "}"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"v"},
        {"s"},
        {"u"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["p", "0"]},
        {
         SubscriptBox["p", "0"]},
        {"0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["\[CapitalSigma]", "0"], 
        SubscriptBox["\[CapitalSigma]", "0"], "0"},
       {
        SubscriptBox["\[CapitalSigma]", "0"], 
        RowBox[{
         SubscriptBox["\[CapitalSigma]", "0"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "0"},
       {"0", "0", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230392530003`*^9, 3.3896231185726*^9, 
  3.3896232960744*^9, 3.3899917584946003`*^9, 3.3899918100576*^9}]
}, Closed]],

Cell[TextData[{
 "The informed trader forms the conditional distribution of ",
 Cell[BoxData["v"]],
 " based on his signal:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vConditionalDistInf", "=", 
  RowBox[{"MVNConditional", "[", 
   RowBox[{"vsuDistribution", ",", "v", ",", "s"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"v", 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   RowBox[{
    FractionBox[
     RowBox[{
      SubscriptBox["\[CapitalSigma]", "0"], " ", 
      RowBox[{"(", 
       RowBox[{"s", "-", 
        SubscriptBox["p", "0"]}], ")"}]}], 
     RowBox[{
      SubscriptBox["\[CapitalSigma]", "0"], "+", 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]], "+", 
    SubscriptBox["p", "0"]}], ",", 
   RowBox[{
    SubscriptBox["\[CapitalSigma]", "0"], "-", 
    FractionBox[
     SubsuperscriptBox["\[CapitalSigma]", "0", "2"], 
     RowBox[{
      SubscriptBox["\[CapitalSigma]", "0"], "+", 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]]}], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.38962303929*^9, 3.3896231186096*^9, 
  3.3896232961113997`*^9, 3.3899917585546*^9, 3.3899918101366*^9}]
}, Closed]],

Cell["The expected profits are developed from:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Pi]", "/.", "\[InvisibleSpace]", 
    SubscriptBox["\[Pi]", "Rule"]}], "/.", "\[InvisibleSpace]", 
   SubscriptBox["p", "Rule"]}], "/.", "\[InvisibleSpace]", 
  SubscriptBox["y", "Rule"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"x", " ", 
  RowBox[{"(", 
   RowBox[{"v", "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"u", "+", "x"}], ")"}], " ", "\[Lambda]"}], "-", "\[Mu]"}], 
   ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623039326*^9, 3.3896231186466*^9, 3.3896232961424*^9, 
  3.3899917586176*^9, 3.3899918102026*^9}]
}, Closed]],

Cell[TextData[{
 "... substituting in the conditional mean for ",
 Cell[BoxData["v"]],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"E\[Pi]", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"\[Pi]", "/.", "\[InvisibleSpace]", 
       SubscriptBox["\[Pi]", "Rule"]}], "/.", "\[InvisibleSpace]", 
      SubscriptBox["p", "Rule"]}], "/.", "\[InvisibleSpace]", 
     SubscriptBox["y", "Rule"]}], "/.", 
    RowBox[{"u", "\[Rule]", "0"}]}], "/.", 
   RowBox[{"v", "\[Rule]", 
    RowBox[{"GetMean", "[", "vConditionalDistInf", "]"}]}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"x", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "x"}], " ", "\[Lambda]"}], "-", "\[Mu]", "+", 
    FractionBox[
     RowBox[{
      SubscriptBox["\[CapitalSigma]", "0"], " ", 
      RowBox[{"(", 
       RowBox[{"s", "-", 
        SubscriptBox["p", "0"]}], ")"}]}], 
     RowBox[{
      SubscriptBox["\[CapitalSigma]", "0"], "+", 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]], "+", 
    SubscriptBox["p", "0"]}], ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623039362*^9, 3.3896231186826*^9, 3.3896232961734*^9, 
  3.3899917586776*^9, 3.3899918102606*^9}]
}, Closed]],

Cell[TextData[{
 "The informed trader maximizes expected profits by trading ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]]],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xOpt", "=", 
  RowBox[{"First", " ", "@", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["\[PartialD]", "x"], "E\[Pi]"}], "\[Equal]", "0"}], ",", 
      "x"}], "]"}], "]"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   FractionBox[
    RowBox[{
     RowBox[{"s", " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "-", 
     RowBox[{"\[Mu]", " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["\[CapitalSigma]", "0"], "+", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}], "+", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], " ", 
      SubscriptBox["p", "0"]}]}], 
    RowBox[{"2", " ", "\[Lambda]", " ", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[CapitalSigma]", "0"], "+", 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}]]}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623039409*^9, 3.3896231187276*^9, 3.3896232962124*^9, 
  3.3899917587406*^9, 3.3899918103386*^9}]
}, Closed]],

Cell[TextData[{
 "The MM conjectures that the informed trader's demand is linear in ",
 Cell[BoxData["s"]],
 ":"
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["x", "Rule"], "=", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"\[Alpha]", "+", 
     RowBox[{"s", " ", "\[Beta]"}]}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "Knowing the optimization process that the informed trader followed, the MM \
can solve for ",
 Cell[BoxData["\[Alpha]"]],
 " and ",
 Cell[BoxData["\[Beta]"]],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xEqu", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "/.", "\[InvisibleSpace]", 
     SubscriptBox["x", "Rule"]}], ")"}], "\[Equal]", 
   RowBox[{"(", 
    RowBox[{"x", "/.", "\[InvisibleSpace]", "xOpt"}], ")"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Alpha]", "+", 
   RowBox[{"s", " ", "\[Beta]"}]}], "\[Equal]", 
  FractionBox[
   RowBox[{
    RowBox[{"s", " ", 
     SubscriptBox["\[CapitalSigma]", "0"]}], "-", 
    RowBox[{"\[Mu]", " ", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[CapitalSigma]", "0"], "+", 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}], "+", 
    RowBox[{
     SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], " ", 
     SubscriptBox["p", "0"]}]}], 
   RowBox[{"2", " ", "\[Lambda]", " ", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["\[CapitalSigma]", "0"], "+", 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], 
     ")"}]}]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623039576*^9, 3.3896231187696*^9, 3.3896232962454*^9, 
  3.3899917588906*^9, 3.3899918104026003`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["x", "Solutions"], "=", 
  RowBox[{"Reduce", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["\[ForAll]", "s"], "xEqu"}], " ", "&&", " ", 
     RowBox[{
      SubscriptBox["\[CapitalSigma]", "0"], ">", "0"}], " ", "&&", " ", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], ">", "0"}], " ", "&&",
      " ", 
     RowBox[{"\[Lambda]", ">", "0"}], " ", "&&", " ", 
     RowBox[{"s", "\[NotEqual]", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Alpha]", ",", "\[Beta]"}], "}"}], ",", "Reals"}], 
   "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], ">", "0"}], "&&", 
  RowBox[{
   SubscriptBox["\[CapitalSigma]", "0"], ">", "0"}], "&&", 
  RowBox[{"\[Lambda]", ">", "0"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"s", "<", "0"}], "&&", 
      RowBox[{"\[Alpha]", "\[Equal]", 
       FractionBox[
        RowBox[{
         RowBox[{
          RowBox[{"-", "\[Mu]"}], " ", 
          SubscriptBox["\[CapitalSigma]", "0"]}], "-", 
         RowBox[{"\[Mu]", " ", 
          SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "+", 
         RowBox[{
          SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], " ", 
          SubscriptBox["p", "0"]}]}], 
        RowBox[{
         RowBox[{"2", " ", "\[Lambda]", " ", 
          SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
         RowBox[{"2", " ", "\[Lambda]", " ", 
          SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]]}], "&&", 
      RowBox[{"\[Beta]", "\[Equal]", 
       FractionBox[
        SubscriptBox["\[CapitalSigma]", "0"], 
        RowBox[{
         RowBox[{"2", " ", "\[Lambda]", " ", 
          SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
         RowBox[{"2", " ", "\[Lambda]", " ", 
          SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]]}]}], ")"}], "||",
     
    RowBox[{"(", 
     RowBox[{
      RowBox[{"s", ">", "0"}], "&&", 
      RowBox[{"\[Alpha]", "\[Equal]", 
       FractionBox[
        RowBox[{
         RowBox[{
          RowBox[{"-", "\[Mu]"}], " ", 
          SubscriptBox["\[CapitalSigma]", "0"]}], "-", 
         RowBox[{"\[Mu]", " ", 
          SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], "+", 
         RowBox[{
          SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], " ", 
          SubscriptBox["p", "0"]}]}], 
        RowBox[{
         RowBox[{"2", " ", "\[Lambda]", " ", 
          SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
         RowBox[{"2", " ", "\[Lambda]", " ", 
          SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]]}], "&&", 
      RowBox[{"\[Beta]", "\[Equal]", 
       FractionBox[
        SubscriptBox["\[CapitalSigma]", "0"], 
        RowBox[{
         RowBox[{"2", " ", "\[Lambda]", " ", 
          SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
         RowBox[{"2", " ", "\[Lambda]", " ", 
          SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]]}]}], ")"}]}], 
   ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230396280003`*^9, 3.3896231188266*^9, 
  3.3896232962964*^9, 3.3899917589616003`*^9, 3.3899918104996*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["x", "Solutions"], "=", 
  RowBox[{"Simplify", " ", "@", " ", 
   RowBox[{"ToRules", " ", "@", " ", 
    RowBox[{"Take", "[", 
     RowBox[{
      RowBox[{
       SubscriptBox["x", "Solutions"], "[", 
       RowBox[{"[", 
        RowBox[{"4", ",", "1"}], "]"}], "]"}], ",", 
      RowBox[{"-", "2"}]}], "]"}]}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Alpha]", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[Mu]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[CapitalSigma]", "0"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}], "+", 
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], " ", 
       SubscriptBox["p", "0"]}]}], 
     RowBox[{"2", " ", "\[Lambda]", " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["\[CapitalSigma]", "0"], "+", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}]]}], ",", 
   RowBox[{"\[Beta]", "\[Rule]", 
    FractionBox[
     SubscriptBox["\[CapitalSigma]", "0"], 
     RowBox[{
      RowBox[{"2", " ", "\[Lambda]", " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      RowBox[{"2", " ", "\[Lambda]", " ", 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]]}]}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623039663*^9, 3.3896231188666*^9, 3.3896232963304*^9, 
  3.3899917590236*^9, 3.3899918105615997`*^9}]
}, Closed]],

Cell[TextData[{
 "Now the MM must figure out ",
 Cell[BoxData[
  RowBox[{"E", "[", 
   RowBox[{
    RowBox[{"V", "|", "Y"}], "=", "y"}], "]"}]]],
 ". This is a little more involved than in the original problem because the \
informed trader's demand is conditioned on ",
 Cell[BoxData["s"]],
 ". The joint distribution of ",
 Cell[BoxData["v"]],
 " and ",
 Cell[BoxData[
  RowBox[{"y", "=", 
   RowBox[{"u", "+", "\[Alpha]", "+", "s\[Beta]"}]}]]],
 " is:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MakeLinearForm", "[", 
  RowBox[{"vsuDistribution", ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{
      RowBox[{"y", "/.", 
       SubscriptBox["y", "Rule"]}], "/.", 
      SubscriptBox["x", "Rule"]}]}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"v"},
        {
         RowBox[{"u", "+", "\[Alpha]", "+", 
          RowBox[{"s", " ", "\[Beta]"}]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["p", "0"]},
        {
         RowBox[{"\[Alpha]", "+", 
          RowBox[{"\[Beta]", " ", 
           SubscriptBox["p", "0"]}]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["\[CapitalSigma]", "0"], 
        RowBox[{"\[Beta]", " ", 
         SubscriptBox["\[CapitalSigma]", "0"]}]},
       {
        RowBox[{"\[Beta]", " ", 
         SubscriptBox["\[CapitalSigma]", "0"]}], 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
         RowBox[{
          SuperscriptBox["\[Beta]", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["\[CapitalSigma]", "0"], "+", 
            SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230397*^9, 3.3896231189066*^9, 3.3896232963644*^9, 
  3.3899917591106*^9, 3.3899918106216*^9}]
}, Closed]],

Cell["... and relabeling:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vyDistribution", "=", 
  RowBox[{"SetLabel", "[", 
   RowBox[{"%", ",", 
    RowBox[{"{", 
     RowBox[{"v", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"v"},
        {"y"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["p", "0"]},
        {
         RowBox[{"\[Alpha]", "+", 
          RowBox[{"\[Beta]", " ", 
           SubscriptBox["p", "0"]}]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["\[CapitalSigma]", "0"], 
        RowBox[{"\[Beta]", " ", 
         SubscriptBox["\[CapitalSigma]", "0"]}]},
       {
        RowBox[{"\[Beta]", " ", 
         SubscriptBox["\[CapitalSigma]", "0"]}], 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
         RowBox[{
          SuperscriptBox["\[Beta]", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["\[CapitalSigma]", "0"], "+", 
            SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623039731*^9, 3.3896231189435997`*^9, 
  3.3896232963954*^9, 3.3899917591786003`*^9, 3.3899918106876*^9}]
}, Closed]],

Cell[TextData[{
 "So the distribution of ",
 Cell[BoxData["v"]],
 " (conditional on ",
 Cell[BoxData["y"]],
 ") is:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vConditionalDistributionMM", "=", 
  RowBox[{"MVNConditional", "[", 
   RowBox[{"vyDistribution", ",", "v", ",", "y"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"v", 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   RowBox[{
    SubscriptBox["p", "0"], "+", 
    FractionBox[
     RowBox[{"\[Beta]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"], " ", 
      RowBox[{"(", 
       RowBox[{"y", "-", "\[Alpha]", "-", 
        RowBox[{"\[Beta]", " ", 
         SubscriptBox["p", "0"]}]}], ")"}]}], 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[CapitalSigma]", "0"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}]}]]}], 
   ",", 
   RowBox[{
    SubscriptBox["\[CapitalSigma]", "0"], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SubsuperscriptBox["\[CapitalSigma]", "0", "2"]}], 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[CapitalSigma]", "0"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}]}]]}], 
   ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230397679996`*^9, 3.3896231189806004`*^9, 
  3.3896232964264*^9, 3.3899917592416*^9, 3.3899918107455997`*^9}]
}, Closed]],

Cell["Market efficiency requires", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pEqu", "=", 
  RowBox[{
   RowBox[{"GetMean", "[", "vConditionalDistributionMM", "]"}], "\[Equal]", 
   RowBox[{"(", 
    RowBox[{"p", "/.", "\[InvisibleSpace]", 
     SubscriptBox["p", "Rule"]}], ")"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["p", "0"], "+", 
   FractionBox[
    RowBox[{"\[Beta]", " ", 
     SubscriptBox["\[CapitalSigma]", "0"], " ", 
     RowBox[{"(", 
      RowBox[{"y", "-", "\[Alpha]", "-", 
       RowBox[{"\[Beta]", " ", 
        SubscriptBox["p", "0"]}]}], ")"}]}], 
    RowBox[{
     SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["\[CapitalSigma]", "0"], "+", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}]}]]}], 
  "\[Equal]", 
  RowBox[{
   RowBox[{"y", " ", "\[Lambda]"}], "+", "\[Mu]"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623039799*^9, 3.3896231190355997`*^9, 
  3.3896232964554*^9, 3.3899917593046*^9, 3.3899918108006*^9}]
}, Closed]],

Cell["Solving:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["p", "Solutions"], "=", 
  RowBox[{"Reduce", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["\[ForAll]", "y"], "pEqu"}], " ", "&&", " ", 
     RowBox[{
      SubscriptBox["\[CapitalSigma]", "0"], ">", "0"}], " ", "&&", " ", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], ">", "0"}], "  ", "&&",
      " ", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], ">", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Mu]", ",", "\[Lambda]"}], "}"}], ",", "Reals"}], 
   "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], ">", "0"}], "&&", 
  RowBox[{
   SubscriptBox["\[CapitalSigma]", "0"], ">", "0"}], "&&", 
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "u", "2"], ">", "0"}], "&&", 
  RowBox[{"\[Mu]", "\[Equal]", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[Alpha]"}], " ", "\[Beta]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
      SubscriptBox["p", "0"]}], "+", 
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], " ", 
      SubscriptBox["p", "0"]}]}], 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]]}], "&&", 
  RowBox[{"\[Lambda]", "\[Equal]", 
   FractionBox[
    RowBox[{"\[Beta]", " ", 
     SubscriptBox["\[CapitalSigma]", "0"]}], 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230399519997`*^9, 3.3896231191926003`*^9, 
  3.3896232966024*^9, 3.3899917594286003`*^9, 3.3899918111586*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["p", "Solutions"], "=", 
  RowBox[{"Simplify", " ", "@", " ", 
   RowBox[{"ToRules", " ", "@", " ", 
    RowBox[{"Take", "[", 
     RowBox[{
      SubscriptBox["p", "Solutions"], ",", 
      RowBox[{"-", "2"}]}], "]"}]}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Mu]", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[Alpha]"}], " ", "\[Beta]", " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
         RowBox[{
          SuperscriptBox["\[Beta]", "2"], " ", 
          SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}], ")"}], " ", 
       SubscriptBox["p", "0"]}]}], 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[CapitalSigma]", "0"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}]}]]}], 
   ",", 
   RowBox[{"\[Lambda]", "\[Rule]", 
    FractionBox[
     RowBox[{"\[Beta]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[CapitalSigma]", "0"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}]}]]}]}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.38962304*^9, 3.3896231192386*^9, 3.3896232966504*^9, 
  3.3899917596216*^9, 3.3899918112086*^9}]
}, Closed]],

Cell["Collecting the results and solving:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EquationSet", "=", 
  RowBox[{"Apply", "[", 
   RowBox[{"Equal", ",", 
    RowBox[{"Join", "[", 
     RowBox[{
      SubscriptBox["p", "Solutions"], ",", 
      SubscriptBox["x", "Solutions"]}], "]"}], ",", "1"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Mu]", "\[Equal]", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[Alpha]"}], " ", "\[Beta]", " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
         RowBox[{
          SuperscriptBox["\[Beta]", "2"], " ", 
          SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}], ")"}], " ", 
       SubscriptBox["p", "0"]}]}], 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[CapitalSigma]", "0"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}]}]]}], 
   ",", 
   RowBox[{"\[Lambda]", "\[Equal]", 
    FractionBox[
     RowBox[{"\[Beta]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[CapitalSigma]", "0"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}]}]]}], 
   ",", 
   RowBox[{"\[Alpha]", "\[Equal]", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[Mu]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[CapitalSigma]", "0"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}], "+", 
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], " ", 
       SubscriptBox["p", "0"]}]}], 
     RowBox[{"2", " ", "\[Lambda]", " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["\[CapitalSigma]", "0"], "+", 
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}]]}], ",", 
   RowBox[{"\[Beta]", "\[Equal]", 
    FractionBox[
     SubscriptBox["\[CapitalSigma]", "0"], 
     RowBox[{
      RowBox[{"2", " ", "\[Lambda]", " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      RowBox[{"2", " ", "\[Lambda]", " ", 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]}]]}]}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230400360003`*^9, 3.3896231192746*^9, 
  3.3896232966784*^9, 3.3899917596886*^9, 3.3899918112316*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["Model", "Solutions"], "=", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{"EquationSet", ",", 
       RowBox[{"{", 
        RowBox[{"\[Mu]", ",", "\[Lambda]", ",", "\[Alpha]", ",", "\[Beta]"}], 
        "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[CapitalSigma]", "0"], ">", "0"}], ",", 
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "u", "2"], ">", "0"}], ",", 
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], ">", "0"}]}], 
      "}"}]}], "]"}], "//", "First"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Alpha]", "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       FractionBox[
        SubsuperscriptBox["\[Sigma]", "u", "2"], 
        RowBox[{
         SubscriptBox["\[CapitalSigma]", "0"], "+", 
         SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]]]}], " ", 
     SubscriptBox["p", "0"]}]}], ",", 
   RowBox[{"\[Mu]", "\[Rule]", 
    SubscriptBox["p", "0"]}], ",", 
   RowBox[{"\[Lambda]", "\[Rule]", 
    FractionBox[
     SubscriptBox["\[CapitalSigma]", "0"], 
     RowBox[{"2", " ", 
      SqrtBox[
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["\[CapitalSigma]", "0"], "+", 
          SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], ")"}]}]]}]]}], 
   ",", 
   RowBox[{"\[Beta]", "\[Rule]", 
    SqrtBox[
     FractionBox[
      SubsuperscriptBox["\[Sigma]", "u", "2"], 
      RowBox[{
       SubscriptBox["\[CapitalSigma]", "0"], "+", 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}]]]}]}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230401400003`*^9, 3.3896231194356003`*^9, 
  3.3896232967764*^9, 3.3899917597576*^9, 3.3899918114056*^9}]
}, Closed]],

Cell["To recover the original solutions:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["Model", "Solutions"], "/.", "\[InvisibleSpace]", 
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"], "\[Rule]", 
   "0"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Alpha]", "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       FractionBox[
        SubsuperscriptBox["\[Sigma]", "u", "2"], 
        SubscriptBox["\[CapitalSigma]", "0"]]]}], " ", 
     SubscriptBox["p", "0"]}]}], ",", 
   RowBox[{"\[Mu]", "\[Rule]", 
    SubscriptBox["p", "0"]}], ",", 
   RowBox[{"\[Lambda]", "\[Rule]", 
    FractionBox[
     SubscriptBox["\[CapitalSigma]", "0"], 
     RowBox[{"2", " ", 
      SqrtBox[
       RowBox[{
        SubscriptBox["\[CapitalSigma]", "0"], " ", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]]}], ",", 
   RowBox[{"\[Beta]", "\[Rule]", 
    SqrtBox[
     FractionBox[
      SubsuperscriptBox["\[Sigma]", "u", "2"], 
      SubscriptBox["\[CapitalSigma]", "0"]]]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623040171*^9, 3.3896231194695997`*^9, 
  3.3896232968084*^9, 3.3899917598826*^9, 3.3899918114276*^9}]
}, Closed]],

Cell[TextData[{
 "Given the price (or equivalently the total order flow), the variance of ",
 Cell[BoxData["v"]],
 " is:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetVariance", "[", "vConditionalDistributionMM", "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[CapitalSigma]", "0"], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[Beta]", "2"], " ", 
    SubsuperscriptBox["\[CapitalSigma]", "0", "2"]}], 
   RowBox[{
    SubsuperscriptBox["\[Sigma]", "u", "2"], "+", 
    RowBox[{
     SuperscriptBox["\[Beta]", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[CapitalSigma]", "0"], "+", 
       SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]}], 
      ")"}]}]}]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623040204*^9, 3.3896231195056*^9, 3.3896232968374*^9, 
  3.3899917599416*^9, 3.3899918114866*^9}]
}, Closed]],

Cell[TextData[{
 "As we degrade the signal (increase ",
 Cell[BoxData[
  SubsuperscriptBox["\[Sigma]", "\[Epsilon]", "2"]]],
 "), the conditional variance approaches the unconditional variance."
}], "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Exercise 7.3 (Broker piggy-backs on informed trader)", "Subsection",
 CellTags->"ExStrategicTrade3"],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["p", "Rule"], "=", 
   RowBox[{"p", "\[Rule]", 
    RowBox[{
     RowBox[{"y", " ", "\[Lambda]"}], "+", "\[Mu]"}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "But now the order flow includes the broker's order flow ",
 Cell[BoxData["\[Gamma]x"]],
 "."
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["y", "Rule"], "=", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"u", "+", 
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "\[Gamma]"}], ")"}]}]}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell["The informed trader's profits are:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Pi]", "Rule"], "=", 
   RowBox[{"\[Pi]", "\[Rule]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"v", "-", "p"}], ")"}], " ", "x"}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "Substituting in for the price conjecture and ",
 StyleBox["y",
  FontSlant->"Italic"],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Pi]", "/.", "\[InvisibleSpace]", 
    SubscriptBox["\[Pi]", "Rule"]}], "/.", "\[InvisibleSpace]", 
   SubscriptBox["p", "Rule"]}], "/.", "\[InvisibleSpace]", 
  SubscriptBox["y", "Rule"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"x", " ", 
  RowBox[{"(", 
   RowBox[{"v", "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"u", "+", 
       RowBox[{"x", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Gamma]"}], ")"}]}]}], ")"}], " ", "\[Lambda]"}],
     "-", "\[Mu]"}], ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230402530003`*^9, 3.3896231195636*^9, 
  3.3896232968844*^9, 3.3899917600986*^9, 3.3899918115836*^9}]
}, Closed]],

Cell[TextData[{
 "The expected profits (conditional on ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]]],
 ") are ",
 Cell[BoxData["E\[Pi]"]],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"E\[Pi]", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"\[Pi]", "/.", "\[InvisibleSpace]", 
       SubscriptBox["\[Pi]", "Rule"]}], "/.", "\[InvisibleSpace]", 
      SubscriptBox["p", "Rule"]}], "/.", "\[InvisibleSpace]", 
     SubscriptBox["y", "Rule"]}], "/.", "\[InvisibleSpace]", 
    RowBox[{"u", "\[Rule]", "0"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"x", " ", 
  RowBox[{"(", 
   RowBox[{"v", "-", 
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Gamma]"}], ")"}], " ", "\[Lambda]"}], "-", 
    "\[Mu]"}], ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230402860003`*^9, 3.3896231195986*^9, 
  3.3896232969154*^9, 3.3899917601586*^9, 3.3899918116526003`*^9}]
}, Closed]],

Cell["The optimal quantity is:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xOpt", "=", 
  RowBox[{"First", " ", "@", " ", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["\[PartialD]", "x"], "E\[Pi]"}], "\[Equal]", "0"}], ",", 
     "x"}], "]"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   FractionBox[
    RowBox[{"v", "-", "\[Mu]"}], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Gamma]"}], ")"}], " ", "\[Lambda]"}]]}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230403199997`*^9, 3.3896231196366*^9, 
  3.3896232969474*^9, 3.3899917602276*^9, 3.3899918117156*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["x", "Rule"], "=", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"\[Alpha]", "+", 
     RowBox[{"v", " ", "\[Beta]"}]}]}]}], ";"}], "\n", 
 RowBox[{"xEqu", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "/.", "\[InvisibleSpace]", 
     SubscriptBox["x", "Rule"]}], ")"}], "\[Equal]", 
   RowBox[{"(", 
    RowBox[{"x", "/.", "\[InvisibleSpace]", "xOpt"}], ")"}]}]}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Alpha]", "+", 
   RowBox[{"v", " ", "\[Beta]"}]}], "\[Equal]", 
  FractionBox[
   RowBox[{"v", "-", "\[Mu]"}], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Gamma]"}], ")"}], " ", "\[Lambda]"}]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230403529997`*^9, 3.3896231196706*^9, 
  3.3896232969784*^9, 3.3899917602855997`*^9, 3.3899918117706003`*^9}]
}, Closed]],

Cell["Solving:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["x", "Solutions"], "=", 
  RowBox[{"Reduce", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["\[ForAll]", "v"], "xEqu"}], " ", "&&", "  ", 
     RowBox[{"\[Lambda]", ">", "0"}], "&&", " ", 
     RowBox[{"\[Gamma]", ">", "0"}]}], " ", ",", 
    RowBox[{"{", 
     RowBox[{"\[Alpha]", ",", "\[Beta]"}], "}"}], ",", "Reals"}], 
   "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Lambda]", ">", "0"}], "&&", 
  RowBox[{"\[Gamma]", ">", "0"}], "&&", 
  RowBox[{"\[Alpha]", "\[Equal]", 
   RowBox[{"-", 
    FractionBox["\[Mu]", 
     RowBox[{
      RowBox[{"2", " ", "\[Lambda]"}], "+", 
      RowBox[{"2", " ", "\[Gamma]", " ", "\[Lambda]"}]}]]}]}], "&&", 
  RowBox[{"\[Beta]", "\[Equal]", 
   FractionBox["1", 
    RowBox[{
     RowBox[{"2", " ", "\[Lambda]"}], "+", 
     RowBox[{"2", " ", "\[Gamma]", " ", "\[Lambda]"}]}]]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623040394*^9, 3.3896231197136*^9, 
  3.3896232970164003`*^9, 3.3899917603556004`*^9, 3.3899918119326*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["x", "Solutions"], "=", 
  RowBox[{"Simplify", " ", "@", " ", 
   RowBox[{"ToRules", " ", "@", " ", 
    RowBox[{"Take", "[", 
     RowBox[{
      SubscriptBox["x", "Solutions"], ",", 
      RowBox[{"-", "2"}]}], "]"}]}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Alpha]", "\[Rule]", 
    RowBox[{"-", 
     FractionBox["\[Mu]", 
      RowBox[{
       RowBox[{"2", " ", "\[Lambda]"}], "+", 
       RowBox[{"2", " ", "\[Gamma]", " ", "\[Lambda]"}]}]]}]}], ",", 
   RowBox[{"\[Beta]", "\[Rule]", 
    FractionBox["1", 
     RowBox[{
      RowBox[{"2", " ", "\[Lambda]"}], "+", 
      RowBox[{"2", " ", "\[Gamma]", " ", "\[Lambda]"}]}]]}]}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230404300003`*^9, 3.3896231197476*^9, 
  3.3896232970494003`*^9, 3.3899917604136*^9, 3.3899918120056*^9}]
}, Closed]],

Cell[TextData[{
 "As always, the MM must figure out ",
 Cell[BoxData[
  RowBox[{"E", "[", 
   RowBox[{"v", "|", "y"}], "]"}]]],
 ". Starting from the original joint distribution:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"uvDist", "=", 
  RowBox[{"MVN", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       SubscriptBox["p", "0"], "}"}], ",", 
      RowBox[{"{", "0", "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["\[CapitalSigma]", "0"], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"v", ",", "u"}], "}"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"v"},
        {"u"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["p", "0"]},
       {"0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["\[CapitalSigma]", "0"], "0"},
       {"0", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623040467*^9, 3.3896231197846003`*^9, 
  3.3896232970854*^9, 3.3899917604796*^9, 3.3899918120936003`*^9}]
}, Closed]],

Cell[TextData[{
 "Now, though, we have a more complicated form for  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"y", ":", "y"}], "=", 
   RowBox[{"u", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Alpha]", "+", 
       RowBox[{"v", " ", "\[Beta]"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Gamma]"}], ")"}]}]}]}]]],
 ". The joint distribution of ",
 Cell[BoxData["v"]],
 " and ",
 Cell[BoxData["y"]],
 " is:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MakeLinearForm", "[", 
  RowBox[{"uvDist", ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{
      RowBox[{"y", "/.", 
       SubscriptBox["y", "Rule"]}], "/.", 
      SubscriptBox["x", "Rule"]}]}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"v"},
        {
         RowBox[{"u", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"\[Alpha]", "+", 
             RowBox[{"v", " ", "\[Beta]"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Gamma]"}], ")"}]}]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["p", "0"]},
        {
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"\[Alpha]", "+", 
             RowBox[{"v", " ", "\[Beta]"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Gamma]"}], ")"}]}], "-", 
          RowBox[{"v", " ", 
           RowBox[{"(", 
            RowBox[{"\[Beta]", "+", 
             RowBox[{"\[Beta]", " ", "\[Gamma]"}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"\[Beta]", "+", 
             RowBox[{"\[Beta]", " ", "\[Gamma]"}]}], ")"}], " ", 
           SubscriptBox["p", "0"]}]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["\[CapitalSigma]", "0"], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"\[Beta]", "+", 
           RowBox[{"\[Beta]", " ", "\[Gamma]"}]}], ")"}], " ", 
         SubscriptBox["\[CapitalSigma]", "0"]}]},
       {
        RowBox[{
         RowBox[{"(", 
          RowBox[{"\[Beta]", "+", 
           RowBox[{"\[Beta]", " ", "\[Gamma]"}]}], ")"}], " ", 
         SubscriptBox["\[CapitalSigma]", "0"]}], 
        RowBox[{
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"\[Beta]", "+", 
             RowBox[{"\[Beta]", " ", "\[Gamma]"}]}], ")"}], "2"], " ", 
          SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
         SubsuperscriptBox["\[Sigma]", "u", "2"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623040501*^9, 3.3896231198266*^9, 3.3896232971174*^9, 
  3.3899917605476*^9, 3.3899918121756*^9}]
}, Closed]],

Cell["...relabeling:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vyDistribution", "=", 
  RowBox[{"SetLabel", "[", 
   RowBox[{"%", ",", 
    RowBox[{"{", 
     RowBox[{"v", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"v"},
        {"y"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["p", "0"]},
        {
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"\[Alpha]", "+", 
             RowBox[{"v", " ", "\[Beta]"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Gamma]"}], ")"}]}], "-", 
          RowBox[{"v", " ", 
           RowBox[{"(", 
            RowBox[{"\[Beta]", "+", 
             RowBox[{"\[Beta]", " ", "\[Gamma]"}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"\[Beta]", "+", 
             RowBox[{"\[Beta]", " ", "\[Gamma]"}]}], ")"}], " ", 
           SubscriptBox["p", "0"]}]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["\[CapitalSigma]", "0"], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"\[Beta]", "+", 
           RowBox[{"\[Beta]", " ", "\[Gamma]"}]}], ")"}], " ", 
         SubscriptBox["\[CapitalSigma]", "0"]}]},
       {
        RowBox[{
         RowBox[{"(", 
          RowBox[{"\[Beta]", "+", 
           RowBox[{"\[Beta]", " ", "\[Gamma]"}]}], ")"}], " ", 
         SubscriptBox["\[CapitalSigma]", "0"]}], 
        RowBox[{
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"\[Beta]", "+", 
             RowBox[{"\[Beta]", " ", "\[Gamma]"}]}], ")"}], "2"], " ", 
          SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
         SubsuperscriptBox["\[Sigma]", "u", "2"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623040541*^9, 3.3896231198656*^9, 
  3.3896232971493998`*^9, 3.3899917606126003`*^9, 3.3899918122616*^9}]
}, Closed]],

Cell["The conditional distribution is:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vConditionalDist", "=", 
  RowBox[{
   RowBox[{"MVNConditional", "[", 
    RowBox[{"vyDistribution", ",", "v", ",", "y"}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"v", 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[Beta]"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "\[Gamma]"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "y"}], "+", "\[Alpha]", "+", 
        RowBox[{"\[Alpha]", " ", "\[Gamma]"}]}], ")"}], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
      SubscriptBox["p", "0"]}]}], 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Gamma]"}], ")"}], "2"], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     SubsuperscriptBox["\[Sigma]", "u", "2"]}]], ",", 
   FractionBox[
    RowBox[{
     SubscriptBox["\[CapitalSigma]", "0"], " ", 
     SubsuperscriptBox["\[Sigma]", "u", "2"]}], 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Gamma]"}], ")"}], "2"], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     SubsuperscriptBox["\[Sigma]", "u", "2"]}]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623040602*^9, 3.3896231199256*^9, 3.3896232972064*^9, 
  3.3899917607265997`*^9, 3.3899918123896*^9}]
}, Closed]],

Cell["Market efficiency:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pEqu", "=", 
  RowBox[{
   RowBox[{"GetMean", "[", "vConditionalDist", "]"}], "\[Equal]", 
   RowBox[{"(", 
    RowBox[{"p", "/.", 
     SubscriptBox["p", "Rule"]}], ")"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{
     RowBox[{"-", "\[Beta]"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Gamma]"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "y"}], "+", "\[Alpha]", "+", 
       RowBox[{"\[Alpha]", " ", "\[Gamma]"}]}], ")"}], " ", 
     SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
    RowBox[{
     SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
     SubscriptBox["p", "0"]}]}], 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Beta]", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "\[Gamma]"}], ")"}], "2"], " ", 
     SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
    SubsuperscriptBox["\[Sigma]", "u", "2"]}]], "\[Equal]", 
  RowBox[{
   RowBox[{"y", " ", "\[Lambda]"}], "+", "\[Mu]"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623040634*^9, 3.3896231199625998`*^9, 
  3.3896232972344*^9, 3.3899917607886*^9, 3.3899918124556*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["p", "Solutions"], "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[ForAll]", "y"], "pEqu"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Mu]", ",", "\[Lambda]"}], "}"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Beta]", "2"], " ", 
     SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["\[Beta]", "2"], " ", "\[Gamma]", " ", 
     SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
    RowBox[{
     SuperscriptBox["\[Beta]", "2"], " ", 
     SuperscriptBox["\[Gamma]", "2"], " ", 
     SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
    SubsuperscriptBox["\[Sigma]", "u", "2"]}], "\[NotEqual]", "0"}], "&&", 
  RowBox[{"\[Mu]", "\[Equal]", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[Alpha]"}], " ", "\[Beta]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "-", 
     RowBox[{"2", " ", "\[Alpha]", " ", "\[Beta]", " ", "\[Gamma]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "-", 
     RowBox[{"\[Alpha]", " ", "\[Beta]", " ", 
      SuperscriptBox["\[Gamma]", "2"], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
      SubscriptBox["p", "0"]}]}], 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[Beta]", "2"], " ", "\[Gamma]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SuperscriptBox["\[Gamma]", "2"], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], "&&", 
  RowBox[{"\[Lambda]", "\[Equal]", 
   FractionBox[
    RowBox[{
     RowBox[{"\[Beta]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     RowBox[{"\[Beta]", " ", "\[Gamma]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}]}], 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[Beta]", "2"], " ", "\[Gamma]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SuperscriptBox["\[Gamma]", "2"], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623040718*^9, 3.3896231200436*^9, 3.3896232973124*^9, 
  3.3899917611205997`*^9, 3.3899918126216*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["p", "Solutions"], "=", 
  RowBox[{"Simplify", " ", "@", " ", 
   RowBox[{"ToRules", "[", 
    RowBox[{"Take", "[", 
     RowBox[{
      SubscriptBox["p", "Solutions"], ",", 
      RowBox[{"-", "2"}]}], "]"}], "]"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Mu]", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[Alpha]"}], " ", "\[Beta]", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Gamma]"}], ")"}], "2"], " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
       SubscriptBox["p", "0"]}]}], 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Gamma]"}], ")"}], "2"], " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], ",", 
   RowBox[{"\[Lambda]", "\[Rule]", 
    FractionBox[
     RowBox[{"\[Beta]", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "\[Gamma]"}], ")"}], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Gamma]"}], ")"}], "2"], " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230407650003`*^9, 3.3896231200926*^9, 
  3.3896232973543997`*^9, 3.3899917618046*^9, 3.3899918126745996`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EquationSet", "=", 
  RowBox[{"Apply", "[", 
   RowBox[{"Equal", ",", 
    RowBox[{"Join", "[", 
     RowBox[{
      SubscriptBox["p", "Solutions"], ",", 
      SubscriptBox["x", "Solutions"]}], "]"}], ",", "1"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Mu]", "\[Equal]", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[Alpha]"}], " ", "\[Beta]", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Gamma]"}], ")"}], "2"], " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
       SubscriptBox["p", "0"]}]}], 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Gamma]"}], ")"}], "2"], " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], ",", 
   RowBox[{"\[Lambda]", "\[Equal]", 
    FractionBox[
     RowBox[{"\[Beta]", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "\[Gamma]"}], ")"}], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Gamma]"}], ")"}], "2"], " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], ",", 
   RowBox[{"\[Alpha]", "\[Equal]", 
    RowBox[{"-", 
     FractionBox["\[Mu]", 
      RowBox[{
       RowBox[{"2", " ", "\[Lambda]"}], "+", 
       RowBox[{"2", " ", "\[Gamma]", " ", "\[Lambda]"}]}]]}]}], ",", 
   RowBox[{"\[Beta]", "\[Equal]", 
    FractionBox["1", 
     RowBox[{
      RowBox[{"2", " ", "\[Lambda]"}], "+", 
      RowBox[{"2", " ", "\[Gamma]", " ", "\[Lambda]"}]}]]}]}], 
  "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623040797*^9, 3.3896231201266003`*^9, 
  3.3896232973844*^9, 3.3899917619386*^9, 3.3899918126976*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["Model", "Solutions"], "=", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{"EquationSet", ",", 
       RowBox[{"{", 
        RowBox[{"\[Mu]", ",", "\[Lambda]", ",", "\[Alpha]", ",", "\[Beta]"}], 
        "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[CapitalSigma]", "0"], ">", "0"}], ",", 
       RowBox[{
        SubsuperscriptBox["\[Sigma]", "u", "2"], ">", "0"}]}], "}"}]}], "]"}],
    "//", "First"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Alpha]", "\[Rule]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SqrtBox[
        FractionBox[
         SubsuperscriptBox["\[Sigma]", "u", "2"], 
         SubscriptBox["\[CapitalSigma]", "0"]]], " ", 
       SubscriptBox["p", "0"]}], 
      RowBox[{"1", "+", "\[Gamma]"}]]}]}], ",", 
   RowBox[{"\[Mu]", "\[Rule]", 
    SubscriptBox["p", "0"]}], ",", 
   RowBox[{"\[Lambda]", "\[Rule]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SqrtBox[
      FractionBox[
       SubscriptBox["\[CapitalSigma]", "0"], 
       SubsuperscriptBox["\[Sigma]", "u", "2"]]]}]}], ",", 
   RowBox[{"\[Beta]", "\[Rule]", 
    FractionBox[
     SqrtBox[
      FractionBox[
       SubsuperscriptBox["\[Sigma]", "u", "2"], 
       SubscriptBox["\[CapitalSigma]", "0"]]], 
     RowBox[{"1", "+", "\[Gamma]"}]]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623040888*^9, 3.3896231202426*^9, 3.3896232974704*^9, 
  3.3899917620106*^9, 3.3899918128406*^9}]
}, Closed]],

Cell["To recover the original solution ...", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["Model", "Solutions"], "/.", 
  RowBox[{"\[Gamma]", "\[Rule]", "0"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Alpha]", "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       FractionBox[
        SubsuperscriptBox["\[Sigma]", "u", "2"], 
        SubscriptBox["\[CapitalSigma]", "0"]]]}], " ", 
     SubscriptBox["p", "0"]}]}], ",", 
   RowBox[{"\[Mu]", "\[Rule]", 
    SubscriptBox["p", "0"]}], ",", 
   RowBox[{"\[Lambda]", "\[Rule]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SqrtBox[
      FractionBox[
       SubscriptBox["\[CapitalSigma]", "0"], 
       SubsuperscriptBox["\[Sigma]", "u", "2"]]]}]}], ",", 
   RowBox[{"\[Beta]", "\[Rule]", 
    SqrtBox[
     FractionBox[
      SubsuperscriptBox["\[Sigma]", "u", "2"], 
      SubscriptBox["\[CapitalSigma]", "0"]]]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623040918*^9, 3.3896231203106003`*^9, 
  3.3896232974983997`*^9, 3.3899917620716*^9, 3.3899918128626003`*^9}]
}, Closed]],

Cell["The expected profits are", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"PowerExpand", "[", 
   RowBox[{
    RowBox[{"E\[Pi]", "/.", "\[InvisibleSpace]", 
     SubscriptBox["x", "Rule"]}], "/.", "\[InvisibleSpace]", 
    SubscriptBox["Model", "Solutions"]}], "]"}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    SubsuperscriptBox["\[Sigma]", "u", "2"]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"v", "-", 
      SubscriptBox["p", "0"]}], ")"}], "2"]}], 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "\[Gamma]"}], ")"}], " ", 
   SqrtBox[
    SubscriptBox["\[CapitalSigma]", "0"]]}]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230409560003`*^9, 3.3896231203496*^9, 
  3.3896232975344*^9, 3.3899917621466*^9, 3.3899918129426003`*^9}]
}, Closed]],

Cell["The informed trader's demand is:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   SubscriptBox["x", "Rule"], "/.", "\[InvisibleSpace]", 
   SubscriptBox["Model", "Solutions"]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"x", "\[Rule]", 
  FractionBox[
   RowBox[{
    SqrtBox[
     FractionBox[
      SubsuperscriptBox["\[Sigma]", "u", "2"], 
      SubscriptBox["\[CapitalSigma]", "0"]]], " ", 
    RowBox[{"(", 
     RowBox[{"v", "-", 
      SubscriptBox["p", "0"]}], ")"}]}], 
   RowBox[{"1", "+", "\[Gamma]"}]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623041005*^9, 3.3896231203926*^9, 
  3.3896232975713997`*^9, 3.3899917622125998`*^9, 3.3899918129765997`*^9}]
}, Closed]],

Cell[TextData[{
 "Since ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Gamma]", ">", "0"}], TraditionalForm]]],
 ", the informed trader's expected profits are lower. Also, she fades her \
demand to take into account the crooked broker. The informativeness of the \
price is:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GetVariance", "[", "vConditionalDist", "]"}], "/.", 
  SubscriptBox["Model", "Solutions"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 FractionBox[
  SubscriptBox["\[CapitalSigma]", "0"], "2"]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.38962304104*^9, 3.3896231204346*^9, 
  3.3896232976084003`*^9, 3.3899917622785997`*^9, 3.3899918130156*^9}]
}, Closed]],

Cell["Unchanged, relative to the original model. ", "Text"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["The multiperiod model", "Section",
 CellTags->"c:44"],

Cell[CellGroupData[{

Cell["Setup", "Subsubsection",
 CellTags->"c:45"],

Cell[TextData[{
 "There are ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"k", "=", "1"}], ",", "...", ",", "N"}]]],
 " auctions. These are equally-spaced on a unit time interval. In real time, \
the ",
 StyleBox["k",
  FontSlant->"Italic"],
 "th auction occurs at time ",
 Cell[BoxData[
  FractionBox["k", "T"]]],
 ", so the increment between auctions is ",
 Cell[BoxData[
  RowBox[{"\[CapitalDelta]t", "=", 
   FractionBox["1", "T"]}]]],
 ". At the ",
 StyleBox["kth",
  FontSlant->"Italic"],
 " auction, noise traders submit an order flow ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["u", "k"], "~", "N"}], 
   RowBox[{"(", 
    RowBox[{"0", ",", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], "\[CapitalDelta]t"}]}], 
    ")"}]}]]],
 ". The informed trader submits an order flow ",
 Cell[BoxData[
  SubscriptBox["\[CapitalDelta]x", "t"]]],
 "."
}], "Text"],

Cell[TextData[{
 "The informed traders profits are given recursively as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Pi]", "k"], "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"v", "-", 
          SubscriptBox["p", "k"]}], ")"}], "\[CapitalDelta]", 
        SubscriptBox["x", "k"]}], "+", 
       RowBox[{
        SubscriptBox["\[Pi]", 
         RowBox[{"k", "+", "1"}]], "for", "k"}]}], "=", "1"}]}], ",", "...", 
    ",", 
    RowBox[{
     RowBox[{"N", "and", 
      SubscriptBox["\[Pi]", 
       RowBox[{"N", "+", "1"}]]}], "\[Congruent]", "0"}]}], 
   TraditionalForm]]],
 "."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection",
 CellTags->"c:46"],

Cell[TextData[{
 "Kyle's Theorem 2 gives the solution as follows\nThe informed trader's \
demand in auction ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]]],
 " is linear in the difference between the true value ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]]],
 " and the price on the preceding auction, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["p", 
    RowBox[{"n", "-", "1"}]], TraditionalForm]]],
 ":"
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{
   "\[Alpha]", ",", "\[Beta]", ",", "\[Lambda]", ",", "\[Delta]", ",", 
    "\[CapitalSigma]", ",", "\[CapitalDelta]t"}], "]"}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Notation", "[", 
   RowBox[{
    TagBox[
     SubscriptBox["\[Beta]", "n_"],
     NotationBoxTag,
     BaseStyle->"NotationTemplateStyle"], " ", "\[DoubleLongLeftRightArrow]", 
    " ", 
    TagBox[
     RowBox[{"\[Beta]", "[", "n_", "]"}],
     NotationBoxTag,
     BaseStyle->"NotationTemplateStyle"]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Notation", "[", 
   RowBox[{
    TagBox[
     SubscriptBox["\[Lambda]", "n_"],
     NotationBoxTag,
     BaseStyle->"NotationTemplateStyle"], " ", "\[DoubleLongLeftRightArrow]", 
    " ", 
    TagBox[
     RowBox[{"\[Lambda]", "[", "n_", "]"}],
     NotationBoxTag,
     BaseStyle->"NotationTemplateStyle"]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Notation", "[", 
   RowBox[{
    TagBox[
     SubscriptBox["\[Alpha]", "n_"],
     NotationBoxTag,
     BaseStyle->"NotationTemplateStyle"], " ", "\[DoubleLongLeftRightArrow]", 
    " ", 
    TagBox[
     RowBox[{"\[Alpha]", "[", "n_", "]"}],
     NotationBoxTag,
     BaseStyle->"NotationTemplateStyle"]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Notation", "[", 
   RowBox[{
    TagBox[
     SubscriptBox["\[Delta]", "n_"],
     NotationBoxTag,
     BaseStyle->"NotationTemplateStyle"], " ", "\[DoubleLongLeftRightArrow]", 
    " ", 
    TagBox[
     RowBox[{"\[Delta]", "[", "n_", "]"}],
     NotationBoxTag,
     BaseStyle->"NotationTemplateStyle"]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Notation", "[", 
   RowBox[{
    TagBox[
     SubscriptBox["\[CapitalSigma]", "n_"],
     NotationBoxTag,
     BaseStyle->"NotationTemplateStyle"], " ", "\[DoubleLongLeftRightArrow]", 
    " ", 
    TagBox[
     RowBox[{"\[CapitalSigma]", "[", "n_", "]"}],
     NotationBoxTag,
     BaseStyle->"NotationTemplateStyle"]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Notation", "[", 
   RowBox[{
    TagBox[
     SubscriptBox["\[Phi]", "n_"],
     NotationBoxTag,
     BaseStyle->"NotationTemplateStyle"], " ", "\[DoubleLongLeftRightArrow]", 
    " ", 
    TagBox[
     RowBox[{"\[Phi]", "[", "n_", "]"}],
     NotationBoxTag,
     BaseStyle->"NotationTemplateStyle"]}], "]"}], ";"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalDelta]xSolution", "=", 
   RowBox[{
    SubscriptBox["\[CapitalDelta]x", "n_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["\[Beta]", "n"], " ", 
     RowBox[{"(", 
      RowBox[{"v", "-", 
       SubscriptBox["p", 
        RowBox[{"n", "-", "1"}]]}], ")"}], " ", "\[CapitalDelta]t"}]}]}], 
  ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell["\<\
The MM's price adjustment rule is linear in the total order flow:\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalDelta]pSolution", "=", 
   RowBox[{
    SubscriptBox["\[CapitalDelta]p", "n_"], "\[RuleDelayed]", 
    RowBox[{
     SubscriptBox["\[Lambda]", "n"], " ", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[CapitalDelta]u", "n"], "+", 
       SubscriptBox["\[CapitalDelta]x", "n"]}], ")"}]}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    SubscriptBox["\[CapitalDelta]x", "2"], "/.", "\[CapitalDelta]xSolution"}],
    ")"}], "+", 
  SubscriptBox["u", "2"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubscriptBox["u", "2"], "+", 
  RowBox[{"\[CapitalDelta]t", " ", 
   RowBox[{"(", 
    RowBox[{"v", "-", 
     SubscriptBox["p", "1"]}], ")"}], " ", 
   SubscriptBox["\[Beta]", "2"]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230411689997`*^9, 3.3896231345586*^9, 
  3.3896232977344*^9, 3.3896243394744*^9, 3.3899917625196*^9, 
  3.3899918134206*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[CapitalDelta]p", "1"], "/.", 
  "\[CapitalDelta]pSolution"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    SubscriptBox["\[CapitalDelta]u", "1"], "+", 
    SubscriptBox["\[CapitalDelta]x", "1"]}], ")"}], " ", 
  SubscriptBox["\[Lambda]", "1"]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623041198*^9, 3.3896231345936003`*^9, 
  3.3896232977614*^9, 3.3896243395294*^9, 3.3899917625755997`*^9, 
  3.3899918135006*^9}]
}, Closed]],

Cell["Expected profits are quadratic:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"E\[Pi]Solution", "=", 
   RowBox[{
    SubscriptBox["E\[Pi]", "n_"], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Alpha]", 
       RowBox[{"n", "-", "1"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"v", "-", 
         SubscriptBox["p", 
          RowBox[{"n", "-", "1"}]]}], ")"}], "2"]}], "+", 
     SubscriptBox["\[Delta]", "n"]}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell["\<\
The constants in the above are given by the solutions to the difference \
equation system:\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Alpha]Solution", "=", 
   RowBox[{
    SubscriptBox["\[Alpha]", "k_"], "\[RuleDelayed]", 
    FractionBox["1", 
     RowBox[{"4", " ", 
      SubscriptBox["\[Lambda]", 
       RowBox[{"k", "+", "1"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{
         SubscriptBox["\[Alpha]", 
          RowBox[{"k", "+", "1"}]], " ", 
         SubscriptBox["\[Lambda]", 
          RowBox[{"k", "+", "1"}]]}]}], ")"}]}]]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Delta]Solution", "=", 
   RowBox[{
    SubscriptBox["\[Delta]", "k_"], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"\[CapitalDelta]t", " ", 
      SubscriptBox["\[Alpha]", 
       RowBox[{"k", "+", "1"}]], " ", 
      SubsuperscriptBox["\[Lambda]", 
       RowBox[{"k", "+", "1"}], "2"], " ", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}], "+", 
     SubscriptBox["\[Delta]", 
      RowBox[{"k", "+", "1"}]]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Beta]Solution", "=", 
   RowBox[{
    SubscriptBox["\[Beta]", "n_"], "\[RuleDelayed]", 
    FractionBox[
     RowBox[{"1", "-", 
      RowBox[{"2", " ", 
       SubscriptBox["\[Alpha]", "n"], " ", 
       SubscriptBox["\[Lambda]", "n"]}]}], 
     RowBox[{"\[CapitalDelta]t", " ", 
      RowBox[{"(", 
       RowBox[{"2", " ", 
        SubscriptBox["\[Lambda]", "n"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{
           SubscriptBox["\[Alpha]", "n"], " ", 
           SubscriptBox["\[Lambda]", "n"]}]}], ")"}]}], ")"}]}]]}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Lambda]Solution", "=", 
   RowBox[{
    SubscriptBox["\[Lambda]", "n_"], "\[RuleDelayed]", 
    FractionBox[
     RowBox[{
      SubscriptBox["\[Beta]", "n"], " ", 
      SubscriptBox["\[CapitalSigma]", "n"]}], 
     SubsuperscriptBox["\[Sigma]", "u", "2"]]}]}], ";"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"TerminalConditions", "[", "n_", "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Alpha]", "n"], "\[Rule]", "0"}], ",", 
    RowBox[{
     SubscriptBox["\[Delta]", "n"], "\[Rule]", "0"}]}], "}"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "subject to the terminal conditions ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Alpha]", "N"], "=", 
   RowBox[{
    SubscriptBox["\[Delta]", "N"], "=", "0"}]}]]],
 ".  The above recursions are backwards. ",
 Cell[BoxData[
  SubscriptBox["\[CapitalSigma]", "n"]]],
 " is the variance of ",
 Cell[BoxData["v"]],
 " conditional on all order flow and prices through auction ",
 Cell[BoxData["n"]],
 ". It is given by the ",
 StyleBox["forward",
  FontSlant->"Italic"],
 " recursion:"
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalSigma]Solution", "=", 
   RowBox[{
    SubscriptBox["\[CapitalSigma]", "n_"], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{
        SubscriptBox["\[Beta]", "n"], " ", 
        SubscriptBox["\[Lambda]", "n"], " ", "\[CapitalDelta]t"}]}], ")"}], 
     " ", 
     SubscriptBox["\[CapitalSigma]", 
      RowBox[{"n", "-", "1"}]]}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "The solutions for ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["\[Alpha]", "k"], ",", 
    SubscriptBox["\[Delta]", "k"], ",", 
    SubscriptBox["\[Beta]", "k"], ",", 
    SubscriptBox["\[Lambda]", "k"], ",", 
    SubscriptBox["\[CapitalSigma]", "k"]}], "}"}]]],
 " don't depend on the realization of ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]]],
 ". That is, given ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["\[CapitalSigma]", "0"], ",", 
    SubscriptBox["p", "0"], ",", 
    SubsuperscriptBox["\[Sigma]", "u", "2"]}], "}"}]]],
 ", agents can perfectly forecast the depth and demand coefficients."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Analysis of solution", "Subsubsection",
 CellTags->"c:47"],

Cell[TextData[{
 "To compute a solution given ",
 StyleBox["N",
  FontSlant->"Italic"],
 " and the model parameters ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["\[CapitalSigma]", "0"], ",", 
    SubscriptBox["p", "0"], ",", 
    SubsuperscriptBox["\[Sigma]", "u", "2"]}], "}"}]]],
 ", start at the ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"n", 
     StyleBox["th",
      FontSlant->"Italic"]}]], TraditionalForm]]],
 " auction. Taking the solution for ",
 Cell[BoxData[
  SubscriptBox["\[Lambda]", "n"]]],
 " and plugging in from the solution for ",
 Cell[BoxData[
  SubscriptBox["\[Beta]", "n"]]],
 " yields a cubic polynomial equation for ",
 Cell[BoxData[
  SubscriptBox["\[Lambda]", "n"]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Lambda]Equation", "=", 
  RowBox[{
   SubscriptBox["\[Lambda]", "n"], "\[Equal]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Lambda]", "n"], "/.", "\[InvisibleSpace]", 
      "\[Lambda]Solution"}], "/.", "\[InvisibleSpace]", "\[Beta]Solution"}], 
    ")"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Lambda]", "n"], "\[Equal]", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"2", " ", 
       SubscriptBox["\[Alpha]", "n"], " ", 
       SubscriptBox["\[Lambda]", "n"]}]}], ")"}], " ", 
    SubscriptBox["\[CapitalSigma]", "n"]}], 
   RowBox[{"2", " ", "\[CapitalDelta]t", " ", 
    SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
    SubscriptBox["\[Lambda]", "n"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{
       SubscriptBox["\[Alpha]", "n"], " ", 
       SubscriptBox["\[Lambda]", "n"]}]}], ")"}]}]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230412530003`*^9, 3.3896231346706*^9, 
  3.3896232978134003`*^9, 3.3896243395903997`*^9, 3.3899917626865997`*^9, 
  3.3899918136406*^9}]
}, Closed]],

Cell[TextData[{
 "The equation has three roots. They are not pretty ones. If you really want \
to see them, run the following ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " line (which is not visible in the pdf/printout versions of this \
document)."
}], "Text"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"s", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{"\[Lambda]Equation", ",", 
        SubscriptBox["\[Lambda]", "n"]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SubsuperscriptBox["\[Sigma]", "u", "2"], ">", "0"}], ",", 
        RowBox[{
         SubscriptBox["\[CapitalSigma]", "n"], ">", "0"}], ",", 
        RowBox[{
         SubscriptBox["\[Alpha]", "n"], ">", "0"}], ",", 
        RowBox[{"\[CapitalDelta]t", ">", "0"}]}], "}"}]}], "]"}]}], ";"}], 
  "*)"}]], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "The full solution procedure is as follows. The model parameters are ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[CapitalSigma]", "0"], ",", " ", "v"}]]],
 " and ",
 Cell[BoxData[
  SubsuperscriptBox["\[Sigma]", "u", "2"]]],
 "."
}], "Text"],

Cell[TextData[{
 "Pick a trial value of ",
 Cell[BoxData[
  SubscriptBox["\[CapitalSigma]", "N"]]],
 ". By the terminal conditions, ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Alpha]", "N"], "=", 
   RowBox[{
    SubscriptBox["\[Delta]", "N"], "=", "0"}]}]]],
 ". Solve the polynomial equation for ",
 Cell[BoxData[
  SubscriptBox["\[Lambda]", "N"]]],
 ". In general, this is a cubic, but at step ",
 Cell[BoxData["N"]],
 ", it is quadratic. Take ",
 Cell[BoxData[
  SubscriptBox["\[Lambda]", "N"]]],
 " as the positive root.  Compute ",
 Cell[BoxData[
  SubscriptBox["\[Beta]", "n"]]],
 " using ",
 Cell[BoxData["\[Beta]Solution"]],
 ". Compute ",
 Cell[BoxData[
  SubscriptBox["\[CapitalSigma]", 
   RowBox[{"N", "-", "1"}]]]],
 " using:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[CapitalSigma]SolutionBack", "=", 
  RowBox[{
   SubscriptBox["\[CapitalSigma]", "n_"], ":>", 
   RowBox[{"-", 
    FractionBox[
     SubscriptBox["\[CapitalSigma]", 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"\[CapitalDelta]t", " ", 
       SubscriptBox["\[Beta]", 
        RowBox[{"n", "+", "1"}]], " ", 
       SubscriptBox["\[Lambda]", 
        RowBox[{"n", "+", "1"}]]}]}]]}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[CapitalSigma]", "n_"], "\[RuleDelayed]", 
  RowBox[{"-", 
   FractionBox[
    SubscriptBox["\[CapitalSigma]", 
     RowBox[{"n", "+", "1"}]], 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"\[CapitalDelta]t", " ", 
      SubscriptBox["\[Beta]", 
       RowBox[{"n", "+", "1"}]], " ", 
      SubscriptBox["\[Lambda]", 
       RowBox[{"n", "+", "1"}]]}]}]]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623041289*^9, 3.3896231347056*^9, 
  3.3896232978473997`*^9, 3.3896243396233997`*^9, 3.3899917627616*^9, 
  3.3899918137386*^9}]
}, Closed]],

Cell[TextData[{
 "At step ",
 Cell[BoxData[
  RowBox[{"N", "-", "1"}]]],
 ", compute ",
 Cell[BoxData[
  SubscriptBox["\[Alpha]", 
   RowBox[{"N", "-", "1"}]]]],
 " and ",
 Cell[BoxData[
  SubscriptBox["\[Delta]", 
   RowBox[{"N", "-", "1"}]]]],
 " using ",
 Cell[BoxData["\[Alpha]Solution"]],
 " and ",
 Cell[BoxData["\[Delta]Solution"]],
 ". Solve for ",
 Cell[BoxData[
  SubscriptBox["\[Lambda]", 
   RowBox[{"N", "-", "1"}]]]],
 ", taking the middle root. Compute ",
 Cell[BoxData[
  SubscriptBox["\[Beta]", 
   RowBox[{"n", "-", "1"}]]]],
 " using ",
 Cell[BoxData["\[Beta]Solution"]],
 ". Compute ",
 Cell[BoxData[
  SubscriptBox["\[CapitalSigma]", 
   RowBox[{"n", "-", "1"}]]]],
 " using ",
 Cell[BoxData["\[CapitalSigma]SolutionBack"]],
 ". Iterate over ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"N", "-", "2"}], ",", " ", 
   RowBox[{"N", "-", "3"}], ",", " ", 
   RowBox[{"...", " ", "1"}]}]]],
 ". Denote the sequence of ",
 Cell[BoxData[
  SubscriptBox["\[CapitalSigma]", "k"]]],
 " implied by the intial guess ",
 Cell[BoxData[
  SubscriptBox["\[CapitalSigma]", "N"]]],
 " as ",
 Cell[BoxData[
  RowBox[{
   SubsuperscriptBox["\[CapitalSigma]", 
    RowBox[{"N", "-", "1"}], "*"], ",", 
   SubsuperscriptBox["\[CapitalSigma]", 
    RowBox[{"N", "-", "2"}], "*"], ",", 
   RowBox[{"...", 
    SubsuperscriptBox["\[CapitalSigma]", "0", "*"]}]}]]],
 ". "
}], "Text"],

Cell[TextData[{
 "Compare ",
 Cell[BoxData[
  SubsuperscriptBox["\[CapitalSigma]", "0", "*"]]],
 " to the actual value ",
 Cell[BoxData[
  SubscriptBox["\[CapitalSigma]", "0"]]],
 ". Make a new guess at ",
 Cell[BoxData[
  SubscriptBox["\[CapitalSigma]", "N"]]],
 ". Repeat until ",
 Cell[BoxData[
  SubsuperscriptBox["\[CapitalSigma]", "0", "*"]]],
 " has (sufficiently) converged to ",
 Cell[BoxData[
  SubscriptBox["\[CapitalSigma]", "0"]]],
 "."
}], "Text"],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"KyleSolve", "[", 
   RowBox[{"T", ",", 
    SubsuperscriptBox["\[Sigma]", "u", "2"], ",", 
    SubscriptBox["\[CapitalSigma]", "0"]}], "]"}]]],
 " computes a full numerical solution, where ",
 Cell[BoxData["T"]],
 " is the number of auctions and ",
 Cell[BoxData[
  SubsuperscriptBox["\[Sigma]", "u", "2"]]],
 " is the total noise variance (assumed equally distributed over all the \
auctions). ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " reserves \"N\" to denote the numerical rounding operator, so these \
routines use ",
 StyleBox["T",
  FontSlant->"Italic"],
 " instead."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Multiple times >2", "Subsubsection"],

Cell[TextData[{
 "The routine ",
 Cell[BoxData[
  RowBox[{"KyleSolve", "[", 
   RowBox[{"T", ",", 
    SubsuperscriptBox["\[Sigma]", "u", "2"], ",", 
    SubscriptBox["\[CapitalSigma]", "0"]}], "]"}]]],
 " solves the multiperiod model following the procedure described in Kyle \
(1985, p. 1333)."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"KyleFull", "[", 
    RowBox[{"T_Integer", ",", "Varu_", ",", "\[CapitalSigma]0_"}], "]"}], ":=",
    
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[CapitalDelta]t", "=", 
        RowBox[{"1", "/", "T"}]}], ",", "\[Phi]Roots", ",", 
       "\[Lambda]Equation", ",", "\[Lambda]Roots", ",", "\[Alpha]", ",", 
       "\[Delta]", ",", "\[Lambda]", ",", "\[CapitalSigma]", ",", "\[Beta]", 
       ",", "\[Phi]"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "U", "2"], "=", "Varu"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"\[Phi]", "[", "T", "]"}], "=", "0"}], ";", " ", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"equ", " ", "=", 
          RowBox[{
           RowBox[{
            RowBox[{"\[Phi]", "[", "k", "]"}], "-", 
            RowBox[{"\[Phi]", "[", 
             RowBox[{"k", "-", "1"}], "]"}]}], "\[Equal]", 
           RowBox[{
            RowBox[{"-", "\[CapitalDelta]t"}], "-", 
            RowBox[{
             SuperscriptBox["\[CapitalDelta]t", "2"], "/", 
             RowBox[{"\[Phi]", "[", 
              RowBox[{"k", "-", "1"}], "]"}]}], "+", 
            RowBox[{
             SuperscriptBox["\[CapitalDelta]t", "3"], "/", 
             SuperscriptBox[
              RowBox[{"\[Phi]", "[", 
               RowBox[{"k", "-", "1"}], "]"}], "2"]}]}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"\[Phi]Roots", "=", 
          RowBox[{"NSolve", "[", 
           RowBox[{"equ", ",", 
            RowBox[{"\[Phi]", "[", 
             RowBox[{"k", "-", "1"}], "]"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"s", "=", 
          RowBox[{
           SubscriptBox["\[Phi]", 
            RowBox[{"k", "-", "1"}]], "/.", "\[Phi]Roots"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"s2", "=", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"-", "5"}], "/", "4"}], "<", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                SubscriptBox["\[Phi]", "k"], "-", "#"}], ")"}], "/", 
              "\[CapitalDelta]t"}], " ", "<=", 
             RowBox[{"-", "1"}]}], "&"}], "/@", "s"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"s3", "=", 
          RowBox[{"Select", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"\[Phi]", "[", 
              RowBox[{"k", "-", "1"}], "]"}], "/.", "\[Phi]Roots"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "5"}], "/", "4"}], "<", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"\[Phi]", "[", "k", "]"}], "-", "#"}], ")"}], "/", 
               "\[CapitalDelta]t"}], " ", "<=", 
              RowBox[{"-", "1"}]}], "&"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"\[Phi]", "[", 
           RowBox[{"k", "-", "1"}], "]"}], "=", 
          RowBox[{"First", "[", "s3", "]"}]}], ";"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"k", ",", "T", ",", "1", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"\[CapitalSigma]", "[", "0", "]"}], "=", "\[CapitalSigma]0"}], 
      ";", " ", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"\[CapitalSigma]", "[", "k", "]"}], "=", 
          RowBox[{
           RowBox[{"\[CapitalSigma]", "[", 
            RowBox[{"k", "-", "1"}], "]"}], "/", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"\[CapitalDelta]t", "/", 
              RowBox[{"\[Phi]", "[", 
               RowBox[{"k", "-", "1"}], "]"}]}]}], ")"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"\[Alpha]", "[", "k", "]"}], "=", 
          SqrtBox[
           RowBox[{
            SubsuperscriptBox["\[Sigma]", "U", "2"], 
            RowBox[{
             RowBox[{"\[Phi]", "[", "k", "]"}], "/", 
             RowBox[{"(", 
              RowBox[{"4", " ", 
               RowBox[{"\[CapitalSigma]", "[", "k", "]"}]}], ")"}]}]}]]}], 
         ";", "\[IndentingNewLine]", 
         RowBox[{"\[Lambda]Equation", "=", 
          RowBox[{
           RowBox[{"\[Lambda]", "[", "k", "]"}], "\[Equal]", 
           FractionBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"2", " ", 
                RowBox[{"\[Alpha]", "[", "k", "]"}], " ", 
                RowBox[{"\[Lambda]", "[", "k", "]"}]}]}], ")"}], " ", 
             RowBox[{"\[CapitalSigma]", "[", "k", "]"}]}], 
            RowBox[{"2", " ", "\[CapitalDelta]t", " ", 
             SubsuperscriptBox["\[Sigma]", "U", "2"], " ", 
             RowBox[{"\[Lambda]", "[", "k", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{
                RowBox[{"\[Alpha]", "[", "k", "]"}], " ", 
                RowBox[{"\[Lambda]", "[", "k", "]"}]}]}], ")"}]}]]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"\[Lambda]Roots", "=", 
          RowBox[{"Chop", " ", "[", " ", 
           RowBox[{
            RowBox[{"\[Lambda]", "[", "k", "]"}], "/.", 
            RowBox[{"NSolve", "[", 
             RowBox[{"\[Lambda]Equation", ",", 
              RowBox[{"\[Lambda]", "[", "k", "]"}]}], "]"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"\[Lambda]", "[", "k", "]"}], "=", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Length", "[", "\[Lambda]Roots", "]"}], "\[LessEqual]", 
             "2"}], ",", 
            RowBox[{"First", "[", 
             RowBox[{"Select", "[", 
              RowBox[{"\[Lambda]Roots", ",", 
               RowBox[{
                RowBox[{"#", ">", "0"}], "&"}]}], "]"}], "]"}], ",", 
            RowBox[{
             RowBox[{"Sort", "[", "\[Lambda]Roots", "]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"\[Beta]", "[", "k", "]"}], "=", 
          RowBox[{
           RowBox[{"\[Lambda]", "[", "k", "]"}], " ", 
           RowBox[{
            SubsuperscriptBox["\[Sigma]", "U", "2"], "/", 
            RowBox[{"\[CapitalSigma]", "[", "k", "]"}]}]}]}], ";"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"k", ",", "T"}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
      
      RowBox[{
       RowBox[{"\[Delta]", "[", "T", "]"}], "=", "0"}], ";", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Delta]", "[", "k", "]"}], "=", 
         RowBox[{
          RowBox[{"\[CapitalDelta]t", " ", 
           RowBox[{"\[Alpha]", "[", 
            RowBox[{"k", "+", "1"}], "]"}], " ", 
           SuperscriptBox[
            RowBox[{"\[Lambda]", "[", 
             RowBox[{"k", "+", "1"}], "]"}], "2"], " ", 
           SubsuperscriptBox["\[Sigma]", "U", "2"]}], "+", 
          RowBox[{"\[Delta]", "[", 
           RowBox[{"k", "+", "1"}], "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", 
          RowBox[{"T", "-", "1"}], ",", "1", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\[Alpha]", "[", "k", "]"}], ",", 
          RowBox[{"\[Delta]", "[", "k", "]"}], ",", 
          RowBox[{"\[Lambda]", "[", "k", "]"}], ",", 
          RowBox[{"\[Beta]", "[", "k", "]"}], ",", 
          RowBox[{"\[CapitalSigma]", "[", "k", "]"}], ",", 
          RowBox[{"\[CapitalSigma]", "[", 
           RowBox[{"k", "-", "1"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", "1", ",", "T"}], "}"}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"KyleFull", "[", 
  RowBox[{"2", ",", "1", ",", "12"}], "]"}]}], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896233514444*^9, 3.3896233615903997`*^9}, {
   3.3896233921514*^9, 3.3896234556094*^9}, 3.3896234907844*^9, {
   3.3896235224063997`*^9, 3.3896235408434*^9}, {3.3896236423484*^9, 
   3.3896237337544003`*^9}, {3.3896238058104*^9, 3.3896238826504*^9}, {
   3.3896239180464*^9, 3.3896239311954*^9}, {3.3896239649514*^9, 
   3.3896239804294*^9}, {3.3896240893084*^9, 3.3896241213143997`*^9}, {
   3.3896241805204*^9, 3.3896242095154*^9}, {3.3896243855024*^9, 
   3.3896243982363997`*^9}, {3.3896245672894*^9, 3.3896245884854*^9}, {
   3.3896246220624*^9, 3.3896246578993998`*^9}, {3.3896248298444*^9, 
   3.3896248785464*^9}, {3.3896249225934*^9, 3.3896252946324*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.1226887095759965`", ",", "0", ",", "2.261651190257307`", ",", 
     "0.2723483883780199`", ",", "8.304257659561152`", ",", "12"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "2.0376773124762844`", ",", "0.4907548383039858`", 
     ",", "4.152128829780576`", ",", "8.304257659561152`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.3896249391054*^9, 3.3896251359364*^9, 
  3.3896252953733997`*^9, 3.3899917631906*^9, 3.3899918139526*^9},
 CellLabel->"Out[136]="]
}, Closed]],

Cell[BoxData[
 RowBox[{
  RowBox[{"KyleHeadings", "=", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\[Alpha]\>\"", ",", "\"\<\[Delta]\>\"", ",", "\"\<\[Lambda]\>\"", 
        ",", "\"\<\[Beta]\>\"", ",", 
        "\"\<\!\(\*SubscriptBox[\(\[CapitalSigma]\), \(k\)]\)\>\"", ",", 
        "\"\<\!\(\*SubscriptBox[\(\[CapitalSigma]\), \(k - 1\)]\)\>\""}], 
       "}"}]}], "}"}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"KyleFull", "[", 
    RowBox[{"10", ",", "1", ",", "12."}], "]"}], ",", "KyleHeadings"}], 
  "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      StyleBox["\[Null]",
       ShowStringCharacters->False], 
      TagBox["\<\"\[Alpha]\"\>",
       HoldForm], 
      TagBox["\<\"\[Delta]\"\>",
       HoldForm], 
      TagBox["\<\"\[Lambda]\"\>",
       HoldForm], 
      TagBox["\<\"\[Beta]\"\>",
       HoldForm], 
      TagBox["\<\"\\!\\(\\*SubscriptBox[\\(\[CapitalSigma]\\), \
\\(k\\)]\\)\"\>",
       HoldForm], 
      TagBox["\<\"\\!\\(\\*SubscriptBox[\\(\[CapitalSigma]\\), \\(k - \
1\\)]\\)\"\>",
       HoldForm]},
     {"1", "0.15199732142852787`", "0.9482891295407431`", 
      "2.9975531724512456`", "0.27196797283204943`", "11.021713848278559`", 
      "12.`"},
     {"2", "0.1505321988861283`", "0.8132215231599698`", "2.99544189027366`", 
      "0.298459177784373`", "10.036353757021235`", "11.021713848278559`"},
     {"3", "0.14871316881307048`", "0.6800407221999142`", 
      "2.992582261553856`", "0.33095171656169686`", "9.042353043653035`", 
      "10.036353757021235`"},
     {"4", "0.1463889938666465`", "0.5492931921420345`", "2.988563814765759`",
       "0.37182545429741753`", "8.037544983069536`", "9.042353043653035`"},
     {"5", "0.14330503975924616`", "0.4218066764997316`", 
      "2.9826438178962875`", "0.42495032129103205`", "7.018805889673843`", 
      "8.037544983069536`"},
     {"6", "0.13899412771717676`", "0.29892407374968033`", 
      "2.9733564391315537`", "0.497101768891377`", "5.981383743137051`", 
      "7.018805889673843`"},
     {"7", "0.13248852814840362`", "0.1830430461739156`", 
      "2.957447413210648`", "0.6014117183224472`", "4.917508793244051`", 
      "5.981383743137051`"},
     {"8", "0.12137492458905555`", "0.07910261212529335`", 
      "2.926360165974516`", "0.7674438032853951`", "3.813126320711549`", 
      "4.917508793244051`"},
     {"9", "0.09733513220843021`", "0", "2.850759635785989`", 
      "1.0803384631373547`", "2.638765287970259`", "3.813126320711549`"},
     {"10", "0", "0", "2.5684456817160157`", "1.9467026441686042`", 
      "1.3193826439851295`", "2.638765287970259`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
      "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   TableForm[
   BoxForm`e$, 
    TableHeadings -> {
     Automatic, {
      "\[Alpha]", "\[Delta]", "\[Lambda]", "\[Beta]", 
       "\!\(\*SubscriptBox[\(\[CapitalSigma]\), \(k\)]\)", 
       "\!\(\*SubscriptBox[\(\[CapitalSigma]\), \(k - 1\)]\)"}}]]]], "Output",\

 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623042017*^9, 3.3896231351415997`*^9, 
  3.3896232983873997`*^9, 3.3896243401043997`*^9, 3.3896253175394*^9, 
  3.3899917637466*^9, 3.3899918144886*^9}]
}, Closed]],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<ErrorBarPlots`\>\"", "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Lambda]Build", "[", 
    RowBox[{"T_", ",", "vu_", ",", "\[CapitalSigma]0_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[CapitalDelta]t", "=", 
        RowBox[{"1", "/", "T"}]}], ",", "\[Lambda]"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[Lambda]", "=", 
       RowBox[{
        RowBox[{"Transpose", "[", 
         RowBox[{"KyleFull", "[", 
          RowBox[{"T", ",", "vu", ",", "\[CapitalSigma]0"}], "]"}], "]"}], 
        "[", 
        RowBox[{"[", "3", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Range", "[", 
          RowBox[{"\[CapitalDelta]t", ",", "1", ",", "\[CapitalDelta]t"}], 
          "]"}], ",", "\[Lambda]"}], "}"}], "]"}]}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Lambda]Build", "[", 
      RowBox[{"50", ",", "1", ",", "1.`"}], "]"}], ",", 
     RowBox[{"\[Lambda]Build", "[", 
      RowBox[{"20", ",", "1", ",", "1.`"}], "]"}], ",", 
     RowBox[{"\[Lambda]Build", "[", 
      RowBox[{"4", ",", "1", ",", "1.`"}], "]"}]}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1.02`"}], "}"}], ",", "All"}], "}"}]}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic", ",", "None", ",", "None"}], 
     "}"}]}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<Auction\>\"", ",", "\"\<Depth\>\"", ",", "None", ",", "None"}], 
     "}"}]}], ",", 
   RowBox[{"BaseStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896253713664*^9, 3.3896254441954*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{0.02, 0.9563468514304936}, {0.04, 0.956340296319816}, {0.06, 
     0.9563333454765097}, {0.08, 0.9563259662356995}, {0.1, 
     0.9563181224792313}, {0.12, 0.9563097741844095}, {0.14, 
     0.9563008769043462}, {0.16, 0.9562913811691522}, {0.18, 
     0.9562812317828399}, {0.2, 0.9562703670087327}, {0.22, 
     0.9562587176126554}, {0.24, 0.9562462057372039}, {0.26, 
     0.9562327435785779}, {0.28, 0.95621823181246}, {0.3, 
     0.9562025577277063}, {0.32, 0.9561855929875426}, {0.34, 
     0.9561671909486587}, {0.36, 0.9561471834209632}, {0.38, 
     0.9561253767354663}, {0.4, 0.9561015469474262}, {0.42, 
     0.9560754339471406}, {0.44, 0.9560467341826013}, {0.46, 
     0.9560150916088541}, {0.48, 0.955980086347606}, {0.5, 
     0.9559412203701757}, {0.52, 0.9558978992701134}, {0.54, 
     0.9558494088541172}, {0.56, 0.9557948847835762}, {0.58, 
     0.9557332728003023}, {0.6, 0.9556632760253035}, {0.62, 
     0.9555832842752805}, {0.64, 0.955491277988331}, {0.66, 
     0.955384695721008}, {0.68, 0.9552602484411897}, {0.7, 
     0.955113654581459}, {0.72, 0.9549392544781211}, {0.74, 
     0.9547294366969219}, {0.76, 0.9544737628180621}, {0.78, 
     0.9541575936039094}, {0.8, 0.9537598607986209}, {0.82, 
     0.9532493134929895}, {0.84, 0.9525779064584483}, {0.86, 
     0.9516685183818907}, {0.88, 0.9503906155652846}, {0.9, 
     0.9485080024381658}, {0.92, 0.9455545310826003}, {0.94, 
     0.9404953153940111}, {0.96, 0.9306092865627057}, {0.98, 
     0.9065676267969197}, {1., 0.8167892083922031}}]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], 
    LineBox[{{0.05, 0.9151907272612064}, {0.1, 0.9151026100849459}, {0.15, 
     0.9150005330557934}, {0.2, 0.9148813461692226}, {0.25, 
     0.9147409488397743}, {0.3, 0.9145739206381567}, {0.35, 
     0.9143729718657777}, {0.4, 0.9141281053355458}, {0.45, 
     0.9138253006111077}, {0.5, 0.9134443799929974}, {0.55, 
     0.9129554135495364}, {0.6, 0.9123123869265919}, {0.65, 
     0.9114414387330786}, {0.7, 0.9102175529374849}, {0.75, 
     0.9084145179688916}, {0.8, 0.9055858900069691}, {0.85, 
     0.9007405276386642}, {0.9, 0.8912723817797644}, {0.95, 
     0.8682469642701932}, {1., 0.782263484458228}}]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], 
    LineBox[{{0.25, 0.7647970318255842}, {0.5, 0.756757857804224}, {0.75, 
     0.7372075317918821}, {1., 0.6642010353276688}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0.7000000000000001},
  Background->GrayLevel[1],
  BaseStyle->{FontFamily -> "Times"},
  Frame->True,
  FrameLabel->{
    FormBox["\"Auction\"", TraditionalForm], 
    FormBox["\"Depth\"", TraditionalForm], None, None},
  FrameTicks->{Automatic, Automatic, None, None},
  PlotRange->{{0, 1.02}, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.3896253995494003`*^9, 3.3896254459504004`*^9}, 
   3.3899917668515997`*^9, 3.3899918178296003`*^9},
 CellLabel->"Out[141]="]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Problem based on Holden and Subrahmanyam (not referenced in book).\
\>", "Section"],

Cell[TextData[{
 "There are two identical informed traders ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", "2"}]]],
 ". Each conjectures that the MM uses a linear price adjustment rule. "
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["p", "Rule"], "=", 
   RowBox[{"p", "\[Rule]", 
    RowBox[{
     RowBox[{"y", " ", "\[Lambda]"}], "+", "\[Mu]"}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "where ",
 StyleBox["y",
  FontSlant->"Italic"],
 " is the total order flow:"
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["y", "Rule"], "=", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"u", "+", 
     SubscriptBox["x", "1"], "+", 
     SubscriptBox["x", "2"]}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell["The first (representative) informed trader's profits are:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Pi]", "Rule"], "=", 
   RowBox[{
    SubscriptBox["\[Pi]", "1"], "\[Rule]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"v", "-", "p"}], ")"}], " ", 
     SubscriptBox["x", "1"]}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "Substituting in for the price conjecture and ",
 StyleBox["y",
  FontSlant->"Italic"],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SubscriptBox["\[Pi]", "1"], "/.", "\[InvisibleSpace]", 
    SubscriptBox["\[Pi]", "Rule"]}], "/.", "\[InvisibleSpace]", 
   SubscriptBox["p", "Rule"]}], "/.", "\[InvisibleSpace]", 
  SubscriptBox["y", "Rule"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubscriptBox["x", "1"], " ", 
  RowBox[{"(", 
   RowBox[{"v", "-", "\[Mu]", "-", 
    RowBox[{"\[Lambda]", " ", 
     RowBox[{"(", 
      RowBox[{"u", "+", 
       SubscriptBox["x", "1"], "+", 
       SubscriptBox["x", "2"]}], ")"}]}]}], ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230444189997`*^9, 3.3896233003624*^9, 
  3.3896254654774*^9, 3.3899917669926*^9, 3.3899918179706*^9}]
}, Closed]],

Cell["\<\
Informed trader 1 conjectures that trader 2 uses a linear strategy:\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["x", "Rule"], "=", 
   RowBox[{
    SubscriptBox["x", "2"], "\[Rule]", 
    RowBox[{"\[Alpha]", "+", 
     RowBox[{"\[Beta]", " ", "v"}]}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[TextData[{
 "The expected profits are",
 Cell[BoxData[
  FormBox[Cell[""], TraditionalForm]]],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[ScriptCapitalE]\[Pi]", "1"], "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["\[Pi]", "1"], "/.", "\[InvisibleSpace]", 
       SubscriptBox["\[Pi]", "Rule"]}], "/.", "\[InvisibleSpace]", 
      SubscriptBox["p", "Rule"]}], "/.", "\[InvisibleSpace]", 
     SubscriptBox["y", "Rule"]}], "/.", 
    SubscriptBox["x", "Rule"]}], "/.", "\[InvisibleSpace]", 
   RowBox[{"u", "\[Rule]", "0"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubscriptBox["x", "1"], " ", 
  RowBox[{"(", 
   RowBox[{"v", "-", "\[Mu]", "-", 
    RowBox[{"\[Lambda]", " ", 
     RowBox[{"(", 
      RowBox[{"\[Alpha]", "+", 
       RowBox[{"v", " ", "\[Beta]"}], "+", 
       SubscriptBox["x", "1"]}], ")"}]}]}], ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230444639997`*^9, 3.3896233004034*^9, 
  3.3896254655134*^9, 3.3899917671106*^9, 3.3899918180636*^9}]
}, Closed]],

Cell["Solve the model.", "Text"],

Cell[CellGroupData[{

Cell["Analysis", "Subsection"],

Cell["The informed trader maximizes expected profits by trading:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xOpt", "=", 
  RowBox[{"(", " ", 
   RowBox[{
    RowBox[{"Take", " ", "@@", " ", 
     RowBox[{"Flatten", " ", "@@", " ", 
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          SubscriptBox["\[PartialD]", 
           SubscriptBox["x", "1"]], 
          SubscriptBox["\[ScriptCapitalE]\[Pi]", "1"]}], "\[Equal]", "0"}], 
        ",", 
        SubscriptBox["x", "1"]}], "]"}]}]}], "//", "Simplify"}], 
   ")"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  SubscriptBox["x", "1"], "\[Rule]", 
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     RowBox[{"\[Alpha]", " ", "\[Lambda]"}], "+", 
     RowBox[{"v", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"\[Beta]", " ", "\[Lambda]"}]}], ")"}]}], "+", "\[Mu]"}], 
    RowBox[{"2", " ", "\[Lambda]"}]]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623044502*^9, 3.3896233004404*^9, 3.3896254655544*^9, 
  3.3899917673936*^9, 3.3899918181496*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["The market maker's problem", "Subsubsection",
 CellTags->"c:42"],

Cell[TextData[{
 "The MM conjectures that each informed trader's demand is linear in ",
 Cell[BoxData["v"]],
 ":"
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["x", "Rule"], "=", 
   RowBox[{
    SubscriptBox["x", "_"], "\[Rule]", 
    RowBox[{"\[Alpha]", "+", 
     RowBox[{"v", " ", "\[Beta]"}]}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell["\<\
Knowing the optimization process that the informed traders followed, the MM \
can solve for \[Alpha] and \[Beta]:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xEqu", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["x", "1"], "/.", "\[InvisibleSpace]", 
     SubscriptBox["x", "Rule"]}], ")"}], "\[Equal]", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["x", "1"], "/.", "\[InvisibleSpace]", "xOpt"}], 
    ")"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Alpha]", "+", 
   RowBox[{"v", " ", "\[Beta]"}]}], "\[Equal]", 
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     RowBox[{"\[Alpha]", " ", "\[Lambda]"}], "+", 
     RowBox[{"v", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"\[Beta]", " ", "\[Lambda]"}]}], ")"}]}], "+", "\[Mu]"}], 
    RowBox[{"2", " ", "\[Lambda]"}]]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623044547*^9, 3.3896233004784*^9, 3.3896254655884*^9, 
  3.3899917674716*^9, 3.3899918181856003`*^9}]
}, Closed]],

Cell[TextData[{
 "for all ",
 Cell[BoxData[
  RowBox[{"v", ":"}]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "=", 
  RowBox[{"Reduce", "[", " ", 
   RowBox[{
    RowBox[{"ForAll", "[", 
     RowBox[{"v", ",", "True", ",", "xEqu"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Alpha]", ",", "\[Beta]"}], "}"}], ",", "Reals"}], 
   "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"\[Lambda]", "<", "0"}], "&&", 
    RowBox[{"\[Alpha]", "\[Equal]", 
     RowBox[{"-", 
      FractionBox["\[Mu]", 
       RowBox[{"3", " ", "\[Lambda]"}]]}]}], "&&", 
    RowBox[{"\[Beta]", "\[Equal]", 
     FractionBox["1", 
      RowBox[{"3", " ", "\[Lambda]"}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"\[Lambda]", ">", "0"}], "&&", 
    RowBox[{"\[Alpha]", "\[Equal]", 
     RowBox[{"-", 
      FractionBox["\[Mu]", 
       RowBox[{"3", " ", "\[Lambda]"}]]}]}], "&&", 
    RowBox[{"\[Beta]", "\[Equal]", 
     FractionBox["1", 
      RowBox[{"3", " ", "\[Lambda]"}]]}]}], ")"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623044584*^9, 3.3896233005564003`*^9, 
  3.3896254656284*^9, 3.3899917675826*^9, 3.3899918182286*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["x", "Solutions"], "=", 
  RowBox[{"ToRules", "[", 
   RowBox[{"r", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Alpha]", "\[Rule]", 
    RowBox[{"-", 
     FractionBox["\[Mu]", 
      RowBox[{"3", " ", "\[Lambda]"}]]}]}], ",", 
   RowBox[{"\[Beta]", "\[Rule]", 
    FractionBox["1", 
     RowBox[{"3", " ", "\[Lambda]"}]]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623044626*^9, 3.3896233005894003`*^9, 
  3.3896254656633997`*^9, 3.3899917676456003`*^9, 3.3899918182525997`*^9}]
}, Closed]],

Cell[TextData[{
 "Now the MM must figure out ",
 Cell[BoxData[
  RowBox[{"E", "[", 
   RowBox[{
    RowBox[{"V", "|", "Y"}], "=", "y"}], "]"}]]],
 ". First, consider the joint distribution of ",
 Cell[BoxData["v"]],
 " and ",
 Cell[BoxData["u"]],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"uvDist", "=", 
  RowBox[{"MVN", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       SubscriptBox["p", "0"], "}"}], ",", 
      RowBox[{"{", "0", "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["\[CapitalSigma]", "0"], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"v", ",", "u"}], "}"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"v"},
        {"u"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["p", "0"]},
       {"0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["\[CapitalSigma]", "0"], "0"},
       {"0", 
        SubsuperscriptBox["\[Sigma]", "u", "2"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623044658*^9, 3.3896233006244*^9, 
  3.3896254657004004`*^9, 3.3899917677076*^9, 3.3899918182816*^9}]
}, Closed]],

Cell[TextData[{
 "Now consider the joint distribution of ",
 Cell[BoxData["v"]],
 " and ",
 Cell[BoxData["y"]],
 " where ",
 Cell[BoxData[
  RowBox[{"y", "="}]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "/.", 
   SubscriptBox["y", "Rule"]}], "/.", 
  SubscriptBox["x", "Rule"]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"u", "+", 
  RowBox[{"2", " ", "\[Alpha]"}], "+", 
  RowBox[{"2", " ", "v", " ", "\[Beta]"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623044691*^9, 3.3896233006604*^9, 3.3896254657324*^9, 
  3.3899917677696*^9, 3.3899918183526*^9}]
}, Closed]],

Cell["So", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MakeLinearForm", "[", 
  RowBox[{"uvDist", ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{
      RowBox[{"y", "/.", 
       SubscriptBox["y", "Rule"]}], "/.", 
      SubscriptBox["x", "Rule"]}]}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"v"},
        {
         RowBox[{"u", "+", 
          RowBox[{"2", " ", "\[Alpha]"}], "+", 
          RowBox[{"2", " ", "v", " ", "\[Beta]"}]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["p", "0"]},
        {
         RowBox[{
          RowBox[{"2", " ", "\[Alpha]"}], "+", 
          RowBox[{"2", " ", "\[Beta]", " ", 
           SubscriptBox["p", "0"]}]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["\[CapitalSigma]", "0"], 
        RowBox[{"2", " ", "\[Beta]", " ", 
         SubscriptBox["\[CapitalSigma]", "0"]}]},
       {
        RowBox[{"2", " ", "\[Beta]", " ", 
         SubscriptBox["\[CapitalSigma]", "0"]}], 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["\[Beta]", "2"], " ", 
          SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
         SubsuperscriptBox["\[Sigma]", "u", "2"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623044724*^9, 3.3896233006984*^9, 
  3.3896254657693996`*^9, 3.3899917678356*^9, 3.3899918184276*^9}]
}, Closed]],

Cell["Relabeling:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vyDist", "=", 
  RowBox[{"SetLabel", "[", 
   RowBox[{"%", ",", 
    RowBox[{"{", 
     RowBox[{"v", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"v"},
        {"y"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SubscriptBox["p", "0"]},
        {
         RowBox[{
          RowBox[{"2", " ", "\[Alpha]"}], "+", 
          RowBox[{"2", " ", "\[Beta]", " ", 
           SubscriptBox["p", "0"]}]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["\[CapitalSigma]", "0"], 
        RowBox[{"2", " ", "\[Beta]", " ", 
         SubscriptBox["\[CapitalSigma]", "0"]}]},
       {
        RowBox[{"2", " ", "\[Beta]", " ", 
         SubscriptBox["\[CapitalSigma]", "0"]}], 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["\[Beta]", "2"], " ", 
          SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
         SubsuperscriptBox["\[Sigma]", "u", "2"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623044763*^9, 3.3896233007363997`*^9, 
  3.3896254658004*^9, 3.3899917678996*^9, 3.3899918185086*^9}]
}, Closed]],

Cell[TextData[{
 "Now consider the conditional distribution ",
 Cell[BoxData[
  RowBox[{"v", "|", "y"}]]],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vConditionalDist", "=", 
  RowBox[{"MVNConditional", "[", 
   RowBox[{"vyDist", ",", "v", ",", "y"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  RowBox[{"v", 
   RowBox[{" ", 
    RowBox[{"~", " "}]}], 
   StyleBox["\[ScriptCapitalN]",
    FontSize->16,
    FontWeight->Bold], "(", 
   RowBox[{
    SubscriptBox["p", "0"], "+", 
    FractionBox[
     RowBox[{"2", " ", "\[Beta]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"], " ", 
      RowBox[{"(", 
       RowBox[{"y", "-", 
        RowBox[{"2", " ", "\[Alpha]"}], "-", 
        RowBox[{"2", " ", "\[Beta]", " ", 
         SubscriptBox["p", "0"]}]}], ")"}]}], 
     RowBox[{
      RowBox[{"4", " ", 
       SuperscriptBox["\[Beta]", "2"], " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], ",", 
   RowBox[{
    SubscriptBox["\[CapitalSigma]", "0"], "-", 
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["\[Beta]", "2"], " ", 
      SubsuperscriptBox["\[CapitalSigma]", "0", "2"]}], 
     RowBox[{
      RowBox[{"4", " ", 
       SuperscriptBox["\[Beta]", "2"], " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], ")"}],
  DisplayForm]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230447980003`*^9, 3.3896233007693996`*^9, 
  3.3896254658324003`*^9, 3.3899917680416*^9, 3.3899918185826*^9}]
}, Closed]],

Cell[TextData[{
 "Market efficiency requires that the mean of this distribution be equal to \
",
 Cell[BoxData["p"]],
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GetMean", "[", "vConditionalDist", "]"}], "\[Equal]", 
  RowBox[{"(", 
   RowBox[{"p", "/.", 
    SubscriptBox["p", "Rule"]}], ")"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["p", "0"], "+", 
   FractionBox[
    RowBox[{"2", " ", "\[Beta]", " ", 
     SubscriptBox["\[CapitalSigma]", "0"], " ", 
     RowBox[{"(", 
      RowBox[{"y", "-", 
       RowBox[{"2", " ", "\[Alpha]"}], "-", 
       RowBox[{"2", " ", "\[Beta]", " ", 
        SubscriptBox["p", "0"]}]}], ")"}]}], 
    RowBox[{
     RowBox[{"4", " ", 
      SuperscriptBox["\[Beta]", "2"], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], "\[Equal]", 
  RowBox[{
   RowBox[{"y", " ", "\[Lambda]"}], "+", "\[Mu]"}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230448389997`*^9, 3.3896233008044*^9, 
  3.3896254658654003`*^9, 3.3899917681156*^9, 3.3899918186516*^9}]
}, Closed]],

Cell[TextData[{
 "for all values of ",
 Cell[BoxData["y"]],
 ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"ForAll", "[", 
     RowBox[{"y", ",", "True", ",", "%"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Mu]", ",", "\[Lambda]"}], "}"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"4", " ", 
     SuperscriptBox["\[Beta]", "2"], " ", 
     SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
    SubsuperscriptBox["\[Sigma]", "u", "2"]}], "\[NotEqual]", "0"}], "&&", 
  RowBox[{"\[Mu]", "\[Equal]", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", "\[Alpha]", " ", "\[Beta]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     RowBox[{
      SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
      SubscriptBox["p", "0"]}]}], 
    RowBox[{
     RowBox[{"4", " ", 
      SuperscriptBox["\[Beta]", "2"], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], "&&", 
  RowBox[{"\[Lambda]", "\[Equal]", 
   FractionBox[
    RowBox[{"2", " ", "\[Beta]", " ", 
     SubscriptBox["\[CapitalSigma]", "0"]}], 
    RowBox[{
     RowBox[{"4", " ", 
      SuperscriptBox["\[Beta]", "2"], " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
     SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623044892*^9, 3.3896233008554*^9, 3.3896254659214*^9, 
  3.3899917683006*^9, 3.3899918187756*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["p", "Solutions"], "=", 
  RowBox[{"ToRules", "[", 
   RowBox[{"r", "[", 
    RowBox[{"[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], "]"}], "]"}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Mu]", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", "\[Alpha]", " ", "\[Beta]", " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
       SubscriptBox["p", "0"]}]}], 
     RowBox[{
      RowBox[{"4", " ", 
       SuperscriptBox["\[Beta]", "2"], " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], ",", 
   RowBox[{"\[Lambda]", "\[Rule]", 
    FractionBox[
     RowBox[{"2", " ", "\[Beta]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], 
     RowBox[{
      RowBox[{"4", " ", 
       SuperscriptBox["\[Beta]", "2"], " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230449300003`*^9, 3.3896233008884*^9, 
  3.3896254659524*^9, 3.3899917683686*^9, 3.3899918187995996`*^9}]
}, Closed]],

Cell["Collecting these results...", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EquationSet", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Equal", "@@", "#1"}], "&"}], ")"}], "/@", 
   RowBox[{"Join", "[", 
    RowBox[{
     SubscriptBox["p", "Solutions"], ",", 
     SubscriptBox["x", "Solutions"]}], "]"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Mu]", "\[Equal]", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", "\[Alpha]", " ", "\[Beta]", " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      RowBox[{
       SubsuperscriptBox["\[Sigma]", "u", "2"], " ", 
       SubscriptBox["p", "0"]}]}], 
     RowBox[{
      RowBox[{"4", " ", 
       SuperscriptBox["\[Beta]", "2"], " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], ",", 
   RowBox[{"\[Lambda]", "\[Equal]", 
    FractionBox[
     RowBox[{"2", " ", "\[Beta]", " ", 
      SubscriptBox["\[CapitalSigma]", "0"]}], 
     RowBox[{
      RowBox[{"4", " ", 
       SuperscriptBox["\[Beta]", "2"], " ", 
       SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
      SubsuperscriptBox["\[Sigma]", "u", "2"]}]]}], ",", 
   RowBox[{"\[Alpha]", "\[Equal]", 
    RowBox[{"-", 
     FractionBox["\[Mu]", 
      RowBox[{"3", " ", "\[Lambda]"}]]}]}], ",", 
   RowBox[{"\[Beta]", "\[Equal]", 
    FractionBox["1", 
     RowBox[{"3", " ", "\[Lambda]"}]]}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230449639997`*^9, 3.3896233009234*^9, 
  3.3896254659844*^9, 3.3899917684416*^9, 3.3899918188276*^9}]
}, Closed]],

Cell["\<\
... and solving for the parameters in terms of the fundamental variables. \
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["Model", "Solutions"], "=", 
   RowBox[{"Solve", "[", 
    RowBox[{"EquationSet", ",", 
     RowBox[{"{", 
      RowBox[{"\[Mu]", ",", "\[Lambda]", ",", "\[Alpha]", ",", "\[Beta]"}], 
      "}"}]}], "]"}]}], ";", " ", 
  RowBox[{
   SubscriptBox["Model", "Solutions"], "//", "TableForm"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"\[Alpha]", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SqrtBox[
          SubsuperscriptBox["\[Sigma]", "u", "2"]], " ", 
         SubscriptBox["p", "0"]}], 
        RowBox[{
         SqrtBox["2"], " ", 
         SqrtBox[
          SubscriptBox["\[CapitalSigma]", "0"]]}]]}]}], 
     RowBox[{"\[Mu]", "\[Rule]", 
      SubscriptBox["p", "0"]}], 
     RowBox[{"\[Lambda]", "\[Rule]", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", 
        SqrtBox[
         SubscriptBox["\[CapitalSigma]", "0"]]}], 
       RowBox[{"3", " ", 
        SqrtBox[
         SubsuperscriptBox["\[Sigma]", "u", "2"]]}]]}], 
     RowBox[{"\[Beta]", "\[Rule]", 
      FractionBox[
       SqrtBox[
        SubsuperscriptBox["\[Sigma]", "u", "2"]], 
       RowBox[{
        SqrtBox["2"], " ", 
        SqrtBox[
         SubscriptBox["\[CapitalSigma]", "0"]]}]]}]},
    {
     RowBox[{"\[Alpha]", "\[Rule]", 
      FractionBox[
       RowBox[{
        SqrtBox[
         SubsuperscriptBox["\[Sigma]", "u", "2"]], " ", 
        SubscriptBox["p", "0"]}], 
       RowBox[{
        SqrtBox["2"], " ", 
        SqrtBox[
         SubscriptBox["\[CapitalSigma]", "0"]]}]]}], 
     RowBox[{"\[Mu]", "\[Rule]", 
      SubscriptBox["p", "0"]}], 
     RowBox[{"\[Lambda]", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SqrtBox["2"], " ", 
         SqrtBox[
          SubscriptBox["\[CapitalSigma]", "0"]]}], 
        RowBox[{"3", " ", 
         SqrtBox[
          SubsuperscriptBox["\[Sigma]", "u", "2"]]}]]}]}], 
     RowBox[{"\[Beta]", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        SqrtBox[
         SubsuperscriptBox["\[Sigma]", "u", "2"]], 
        RowBox[{
         SqrtBox["2"], " ", 
         SqrtBox[
          SubscriptBox["\[CapitalSigma]", "0"]]}]]}]}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623045019*^9, 3.3896233009684*^9, 3.3896254660324*^9, 
  3.3899917685436*^9, 3.3899918188826*^9}]
}, Closed]],

Cell[TextData[{
 "Only first solution has positive ",
 Cell[BoxData["\[Lambda]"]],
 " and ",
 Cell[BoxData["\[Beta]"]],
 ", so:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["Model", "Solutions"], "=", 
   RowBox[{"First", " ", "@", " ", 
    SubscriptBox["Model", "Solutions"]}]}], ";", " ", 
  RowBox[{"TableForm", " ", "@", " ", 
   SubscriptBox["Model", "Solutions"]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{"\[Alpha]", "\[Rule]", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SqrtBox[
           SubsuperscriptBox["\[Sigma]", "u", "2"]], " ", 
          SubscriptBox["p", "0"]}], 
         RowBox[{
          SqrtBox["2"], " ", 
          SqrtBox[
           SubscriptBox["\[CapitalSigma]", "0"]]}]]}]}]},
     {
      RowBox[{"\[Mu]", "\[Rule]", 
       SubscriptBox["p", "0"]}]},
     {
      RowBox[{"\[Lambda]", "\[Rule]", 
       FractionBox[
        RowBox[{
         SqrtBox["2"], " ", 
         SqrtBox[
          SubscriptBox["\[CapitalSigma]", "0"]]}], 
        RowBox[{"3", " ", 
         SqrtBox[
          SubsuperscriptBox["\[Sigma]", "u", "2"]]}]]}]},
     {
      RowBox[{"\[Beta]", "\[Rule]", 
       FractionBox[
        SqrtBox[
         SubsuperscriptBox["\[Sigma]", "u", "2"]], 
        RowBox[{
         SqrtBox["2"], " ", 
         SqrtBox[
          SubscriptBox["\[CapitalSigma]", "0"]]}]]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230450550003`*^9, 3.3896233010364*^9, 
  3.3896254660664*^9, 3.3899917686076*^9, 3.3899918189166*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Properties of the solution", "Subsubsection",
 CellTags->"c:43"],

Cell["An informed trader's expected profits are:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", " ", "@", " ", 
  RowBox[{"PowerExpand", " ", "@", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[ScriptCapitalE]\[Pi]", "1"], "/.", "\[InvisibleSpace]", 
      
      SubscriptBox["x", "Rule"]}], "//.", "\[InvisibleSpace]", 
     SubscriptBox["Model", "Solutions"]}], ")"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    SubsuperscriptBox["\[Sigma]", "u", "2"]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"v", "-", 
      SubscriptBox["p", "0"]}], ")"}], "2"]}], 
  RowBox[{"3", " ", 
   SqrtBox["2"], " ", 
   SqrtBox[
    SubscriptBox["\[CapitalSigma]", "0"]]}]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623045102*^9, 3.3896233010744*^9, 
  3.3896254661113997`*^9, 3.3899917686836*^9, 3.3899918190046*^9}]
}, Closed]],

Cell["Either (say, the first) informed trader's demand is", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SubscriptBox["x", "1"], "/.", 
    SubscriptBox["x", "Rule"]}], "/.", "\[InvisibleSpace]", 
   SubscriptBox["Model", "Solutions"]}], "//", "Simplify"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    SubsuperscriptBox["\[Sigma]", "u", "2"]], " ", 
   RowBox[{"(", 
    RowBox[{"v", "-", 
     SubscriptBox["p", "0"]}], ")"}]}], 
  RowBox[{
   SqrtBox["2"], " ", 
   SqrtBox[
    SubscriptBox["\[CapitalSigma]", "0"]]}]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623045133*^9, 3.3896233011134*^9, 3.3896254661524*^9, 
  3.3899917687506*^9, 3.3899918190486*^9}]
}, Closed]],

Cell["\<\
How much of the private information is impounded in the price? \
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GetVariance", "[", "vConditionalDist", "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SubscriptBox["\[CapitalSigma]", "0"], " ", 
   SubsuperscriptBox["\[Sigma]", "u", "2"]}], 
  RowBox[{
   RowBox[{"4", " ", 
    SuperscriptBox["\[Beta]", "2"], " ", 
    SubscriptBox["\[CapitalSigma]", "0"]}], "+", 
   SubsuperscriptBox["\[Sigma]", "u", "2"]}]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389623045166*^9, 3.3896233011493998`*^9, 
  3.3896254661834*^9, 3.3899917688086*^9, 3.3899918190786*^9}]
}, Closed]],

Cell["Or, in terms of the input parameters:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"%", "//.", "\[InvisibleSpace]", 
   SubscriptBox["Model", "Solutions"]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 FractionBox[
  SubscriptBox["\[CapitalSigma]", "0"], "3"]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3896230452060003`*^9, 3.3896233011834*^9, 
  3.3896254662153997`*^9, 3.3899917688786*^9, 3.3899918191535997`*^9}]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]]
},
ScreenStyleEnvironment->"Working",
WindowToolbars->"RulerBar",
WindowSize->{1578, 1027},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Visible->True,
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
InputAliases->{"intt" -> RowBox[{"\[Integral]", 
     RowBox[{"\[SelectionPlaceholder]", 
       RowBox[{"\[DifferentialD]", "\[Placeholder]"}]}]}], "dintt" -> 
  RowBox[{
     SubsuperscriptBox[
     "\[Integral]", "\[SelectionPlaceholder]", "\[Placeholder]"], 
     RowBox[{"\[Placeholder]", 
       RowBox[{"\[DifferentialD]", "\[Placeholder]"}]}]}], "sumt" -> RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"\[SelectionPlaceholder]", "=", "\[Placeholder]"}], 
      "\[Placeholder]"], "\[Placeholder]"}], "prodt" -> RowBox[{
     UnderoverscriptBox["\[Product]", 
      RowBox[{"\[SelectionPlaceholder]", "=", "\[Placeholder]"}], 
      "\[Placeholder]"], "\[Placeholder]"}], "dt" -> RowBox[{
     SubscriptBox["\[PartialD]", "\[Placeholder]"], " ", 
     "\[SelectionPlaceholder]"}], "notation" -> RowBox[{"Notation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], " ", 
       "\[DoubleLongLeftRightArrow]", " ", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "notation>" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], " ", 
       "\[DoubleLongRightArrow]", " ", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "notation<" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], " ", 
       "\[DoubleLongLeftArrow]", " ", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "symb" -> 
  RowBox[{"Symbolize", "[", 
     TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], "]"}], 
  "infixnotation" -> RowBox[{"InfixNotation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], ",", 
       "\[Placeholder]"}], "]"}], "addia" -> RowBox[{"AddInputAlias", "[", 
     RowBox[{"\"\[SelectionPlaceholder]\"", "\[Rule]", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "pattwraper" -> 
  TagBox["\[SelectionPlaceholder]", "NotationPatternTag"], "madeboxeswraper" -> 
  TagBox["\[SelectionPlaceholder]", "NotationMadeBoxesTag"], "E" -> 
  "\[ScriptCapitalE]"},
Magnification->1.5,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->"EMMStyle02.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:40"->{
  Cell[5642, 193, 61, 1, 51, "Section",
   CellTags->"c:40"]},
 "c:41"->{
  Cell[5728, 198, 73, 1, 44, "Subsubsection",
   CellTags->"c:41"]},
 "c:42"->{
  Cell[9712, 358, 70, 1, 44, "Subsubsection",
   CellTags->"c:42"],
  Cell[199709, 6612, 70, 1, 44, "Subsubsection",
   CellTags->"c:42"]},
 "c:43"->{
  Cell[35946, 1260, 70, 1, 44, "Subsubsection",
   CellTags->"c:43"],
  Cell[225972, 7504, 70, 1, 44, "Subsubsection",
   CellTags->"c:43"]},
 "c:51"->{
  Cell[38868, 1369, 79, 1, 51, "Section",
   CellTags->"c:51"]},
 "ExStrategicTrade1"->{
  Cell[38972, 1374, 94, 1, 65, "Subsection",
   CellTags->"ExStrategicTrade1"]},
 "ExStrategicTrade2"->{
  Cell[78863, 2685, 98, 1, 65, "Subsection",
   CellTags->"ExStrategicTrade2"]},
 "ExStrategicTrade3"->{
  Cell[123417, 4141, 106, 1, 65, "Subsection",
   CellTags->"ExStrategicTrade3"]},
 "c:44"->{
  Cell[156667, 5244, 59, 1, 51, "Section",
   CellTags->"c:44"]},
 "c:45"->{
  Cell[156751, 5249, 49, 1, 44, "Subsubsection",
   CellTags->"c:45"]},
 "c:46"->{
  Cell[158391, 5316, 52, 1, 44, "Subsubsection",
   CellTags->"c:46"]},
 "c:47"->{
  Cell[167903, 5652, 64, 1, 44, "Subsubsection",
   CellTags->"c:47"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:40", 231678, 7677},
 {"c:41", 231752, 7680},
 {"c:42", 231832, 7683},
 {"c:43", 231983, 7688},
 {"c:51", 232136, 7693},
 {"ExStrategicTrade1", 232225, 7696},
 {"ExStrategicTrade2", 232330, 7699},
 {"ExStrategicTrade3", 232435, 7702},
 {"c:44", 232529, 7705},
 {"c:45", 232606, 7708},
 {"c:46", 232689, 7711},
 {"c:47", 232772, 7714}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 1131, 28, 430, "Title"],
Cell[CellGroupData[{
Cell[1746, 55, 410, 9, 43, "Input"],
Cell[2159, 66, 806, 17, 51, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3002, 88, 32, 0, 92, "Section"],
Cell[CellGroupData[{
Cell[3059, 92, 60, 0, 65, "Subsection"],
Cell[3122, 94, 375, 10, 43, "Input"],
Cell[3500, 106, 99, 3, 43, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[3636, 114, 31, 0, 65, "Subsection"],
Cell[3670, 116, 146, 3, 43, "Input"],
Cell[3819, 121, 111, 3, 32, "Text"],
Cell[3933, 126, 724, 24, 71, "Input"],
Cell[4660, 152, 127, 3, 32, "Text"],
Cell[4790, 157, 213, 6, 43, "Input"],
Cell[5006, 165, 199, 6, 49, "Input"],
Cell[5208, 173, 186, 6, 46, "Input"],
Cell[5397, 181, 196, 6, 46, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[5642, 193, 61, 1, 51, "Section",
 CellTags->"c:40"],
Cell[CellGroupData[{
Cell[5728, 198, 73, 1, 44, "Subsubsection",
 CellTags->"c:41"],
Cell[5804, 201, 106, 3, 32, "Text"],
Cell[5913, 206, 214, 7, 43, "Input"],
Cell[6130, 215, 106, 5, 32, "Text"],
Cell[6239, 222, 176, 6, 43, "Input"],
Cell[6418, 230, 50, 0, 32, "Text"],
Cell[6471, 232, 237, 8, 43, "Input"],
Cell[6711, 242, 121, 5, 32, "Text"],
Cell[CellGroupData[{
Cell[6857, 251, 276, 7, 43, "Input"],
Cell[7136, 260, 363, 10, 38, "Output"]
}, Closed]],
Cell[7514, 273, 123, 5, 32, "Text"],
Cell[CellGroupData[{
Cell[7662, 282, 390, 10, 43, "Input"],
Cell[8055, 294, 307, 7, 38, "Output"]
}, Closed]],
Cell[8377, 304, 145, 5, 32, "Text"],
Cell[CellGroupData[{
Cell[8547, 313, 283, 9, 43, "Input"],
Cell[8833, 324, 317, 8, 55, "Output"]
}, Closed]],
Cell[9165, 335, 58, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[9248, 339, 158, 5, 43, "Input"],
Cell[9409, 346, 254, 6, 38, "Output"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[9712, 358, 70, 1, 44, "Subsubsection",
 CellTags->"c:42"],
Cell[9785, 361, 124, 4, 33, "Text"],
Cell[CellGroupData[{
Cell[9934, 369, 193, 6, 43, "Input"],
Cell[10130, 377, 266, 6, 38, "Output"]
}, Closed]],
Cell[10411, 386, 136, 3, 32, "Text"],
Cell[CellGroupData[{
Cell[10572, 393, 283, 8, 43, "Input"],
Cell[10858, 403, 348, 9, 54, "Output"]
}, Closed]],
Cell[11221, 415, 109, 5, 32, "Text"],
Cell[CellGroupData[{
Cell[11355, 424, 298, 9, 43, "Input"],
Cell[11656, 435, 833, 24, 57, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[12526, 464, 276, 9, 43, "Input"],
Cell[12805, 475, 443, 12, 57, "Output"]
}, Closed]],
Cell[13263, 490, 263, 11, 33, "Text"],
Cell[CellGroupData[{
Cell[13551, 505, 577, 19, 48, "Input"],
Cell[14131, 526, 2278, 67, 61, "Output"]
}, Closed]],
Cell[16424, 596, 173, 8, 33, "Text"],
Cell[CellGroupData[{
Cell[16622, 608, 153, 5, 43, "Input"],
Cell[16778, 615, 254, 5, 38, "Output"]
}, Closed]],
Cell[17047, 623, 18, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[17090, 627, 286, 9, 43, "Input"],
Cell[17379, 638, 2835, 82, 61, "Output"]
}, Closed]],
Cell[20229, 723, 27, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[20281, 727, 192, 6, 43, "Input"],
Cell[20476, 735, 2746, 80, 61, "Output"]
}, Closed]],
Cell[23237, 818, 123, 5, 33, "Text"],
Cell[CellGroupData[{
Cell[23385, 827, 172, 4, 43, "Input"],
Cell[23560, 833, 1196, 36, 67, "Output"]
}, Closed]],
Cell[24771, 872, 134, 5, 33, "Text"],
Cell[CellGroupData[{
Cell[24930, 881, 208, 6, 43, "Input"],
Cell[25141, 889, 713, 20, 62, "Output"]
}, Closed]],
Cell[25869, 912, 76, 4, 33, "Text"],
Cell[CellGroupData[{
Cell[25970, 920, 271, 8, 43, "Input"],
Cell[26244, 930, 1162, 33, 67, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[27443, 968, 248, 8, 43, "Input"],
Cell[27694, 978, 1008, 28, 67, "Output"]
}, Closed]],
Cell[28717, 1009, 43, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[28785, 1013, 310, 10, 43, "Input"],
Cell[29098, 1025, 1249, 35, 67, "Output"]
}, Closed]],
Cell[30362, 1063, 98, 2, 32, "Text"],
Cell[CellGroupData[{
Cell[30485, 1069, 380, 11, 43, "Input"],
Cell[30868, 1082, 2187, 68, 127, "Output"]
}, Closed]],
Cell[33070, 1153, 140, 6, 33, "Text"],
Cell[CellGroupData[{
Cell[33235, 1163, 290, 8, 43, "Input"],
Cell[33528, 1173, 1494, 47, 203, "Output"]
}, Closed]],
Cell[35037, 1223, 21, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[35083, 1227, 227, 7, 43, "Input"],
Cell[35313, 1236, 584, 18, 78, "Output"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[35946, 1260, 70, 1, 44, "Subsubsection",
 CellTags->"c:43"],
Cell[36019, 1263, 59, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[36103, 1267, 290, 7, 43, "Input"],
Cell[36396, 1276, 456, 14, 78, "Output"]
}, Closed]],
Cell[36867, 1293, 47, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[36939, 1297, 191, 5, 43, "Input"],
Cell[37133, 1304, 439, 13, 78, "Output"]
}, Closed]],
Cell[37587, 1320, 87, 2, 32, "Text"],
Cell[CellGroupData[{
Cell[37699, 1326, 141, 4, 43, "Input"],
Cell[37843, 1332, 460, 12, 67, "Output"]
}, Closed]],
Cell[38318, 1347, 53, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[38396, 1351, 170, 4, 43, "Input"],
Cell[38569, 1357, 238, 5, 55, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[38868, 1369, 79, 1, 51, "Section",
 CellTags->"c:51"],
Cell[CellGroupData[{
Cell[38972, 1374, 94, 1, 65, "Subsection",
 CellTags->"ExStrategicTrade1"],
Cell[39069, 1377, 40, 0, 32, "Text"],
Cell[39112, 1379, 541, 19, 98, "Input"],
Cell[39656, 1400, 50, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[39731, 1404, 276, 7, 43, "Input"],
Cell[40010, 1413, 355, 10, 38, "Output"]
}, Closed]],
Cell[40380, 1426, 203, 6, 33, "Text"],
Cell[CellGroupData[{
Cell[40608, 1436, 649, 21, 48, "Input"],
Cell[41260, 1459, 2354, 69, 61, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[43651, 1533, 172, 4, 43, "Input"],
Cell[43826, 1539, 727, 23, 64, "Output"]
}, Closed]],
Cell[44568, 1565, 118, 4, 33, "Text"],
Cell[CellGroupData[{
Cell[44711, 1573, 405, 13, 71, "Input"],
Cell[45119, 1588, 575, 17, 60, "Output"]
}, Closed]],
Cell[45709, 1608, 55, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[45789, 1612, 321, 10, 43, "Input"],
Cell[46113, 1624, 672, 19, 59, "Output"]
}, Closed]],
Cell[46800, 1646, 235, 8, 33, "Text"],
Cell[CellGroupData[{
Cell[47060, 1658, 456, 14, 71, "Input"],
Cell[47519, 1674, 696, 20, 59, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[48252, 1699, 466, 14, 43, "Input"],
Cell[48721, 1715, 952, 26, 59, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[49710, 1746, 302, 9, 43, "Input"],
Cell[50015, 1757, 879, 25, 60, "Output"]
}, Closed]],
Cell[50909, 1785, 134, 6, 33, "Text"],
Cell[CellGroupData[{
Cell[51068, 1795, 286, 9, 43, "Input"],
Cell[51357, 1806, 3164, 91, 61, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[54558, 1902, 192, 6, 43, "Input"],
Cell[54753, 1910, 3071, 89, 61, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[57861, 2004, 209, 6, 43, "Input"],
Cell[58073, 2012, 1602, 48, 73, "Output"]
}, Closed]],
Cell[59690, 2063, 34, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[59749, 2067, 243, 7, 43, "Input"],
Cell[59995, 2076, 1026, 30, 70, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[61058, 2111, 274, 8, 43, "Input"],
Cell[61335, 2121, 1663, 46, 67, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[63035, 2172, 219, 7, 43, "Input"],
Cell[63257, 2181, 1427, 39, 67, "Output"]
}, Closed]],
Cell[64699, 2223, 51, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[64775, 2227, 279, 8, 43, "Input"],
Cell[65057, 2237, 2107, 59, 67, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[67201, 2301, 699, 22, 75, "Input"],
Cell[67903, 2325, 5157, 145, 201, "Output"]
}, Closed]],
Cell[73075, 2473, 124, 5, 33, "Text"],
Cell[73202, 2480, 220, 7, 43, "Input"],
Cell[73425, 2489, 157, 6, 33, "Text"],
Cell[CellGroupData[{
Cell[73607, 2499, 445, 14, 48, "Input"],
Cell[74055, 2515, 1033, 30, 84, "Output"]
}, Closed]],
Cell[75103, 2548, 43, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[75171, 2552, 616, 19, 61, "Input"],
Cell[75790, 2573, 537, 14, 73, "Output"]
}, Closed]],
Cell[76342, 2590, 208, 8, 33, "Text"],
Cell[76553, 2600, 453, 15, 87, "Input"],
Cell[77009, 2617, 247, 9, 33, "Text"],
Cell[CellGroupData[{
Cell[77281, 2630, 624, 19, 48, "Input"],
Cell[77908, 2651, 210, 4, 38, "Output"]
}, Closed]],
Cell[78133, 2658, 51, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[78209, 2662, 417, 12, 57, "Input"],
Cell[78629, 2676, 185, 3, 38, "Output"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[78863, 2685, 98, 1, 65, "Subsection",
 CellTags->"ExStrategicTrade2"],
Cell[78964, 2688, 1284, 41, 87, "Text"],
Cell[CellGroupData[{
Cell[80273, 2733, 33, 0, 44, "Subsubsection"],
Cell[80309, 2735, 541, 19, 98, "Input"],
Cell[80853, 2756, 42, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[80920, 2760, 276, 7, 43, "Input"],
Cell[81199, 2769, 359, 10, 38, "Output"]
}, Closed]],
Cell[81573, 2782, 94, 4, 33, "Text"],
Cell[81670, 2788, 185, 6, 43, "Input"],
Cell[81858, 2796, 65, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[81948, 2800, 732, 22, 48, "Input"],
Cell[82683, 2824, 2466, 73, 87, "Output"]
}, Closed]],
Cell[85164, 2900, 134, 5, 33, "Text"],
Cell[CellGroupData[{
Cell[85323, 2909, 256, 7, 43, "Input"],
Cell[85582, 2918, 2690, 79, 87, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[88309, 3002, 211, 6, 43, "Input"],
Cell[88523, 3010, 2648, 78, 87, "Output"]
}, Closed]],
Cell[91186, 3091, 136, 4, 33, "Text"],
Cell[CellGroupData[{
Cell[91347, 3099, 184, 4, 43, "Input"],
Cell[91534, 3105, 953, 29, 67, "Output"]
}, Closed]],
Cell[92502, 3137, 56, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[92583, 3141, 276, 7, 43, "Input"],
Cell[92862, 3150, 351, 10, 38, "Output"]
}, Closed]],
Cell[93228, 3163, 103, 4, 33, "Text"],
Cell[CellGroupData[{
Cell[93356, 3171, 485, 13, 43, "Input"],
Cell[93844, 3186, 639, 18, 65, "Output"]
}, Closed]],
Cell[94498, 3207, 145, 5, 32, "Text"],
Cell[CellGroupData[{
Cell[94668, 3216, 320, 10, 43, "Input"],
Cell[94991, 3228, 830, 23, 73, "Output"]
}, Closed]],
Cell[95836, 3254, 124, 4, 33, "Text"],
Cell[95963, 3260, 215, 7, 43, "Input"],
Cell[96181, 3269, 193, 7, 33, "Text"],
Cell[CellGroupData[{
Cell[96399, 3280, 283, 8, 43, "Input"],
Cell[96685, 3290, 858, 24, 73, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[97580, 3319, 628, 18, 48, "Input"],
Cell[98211, 3339, 2580, 67, 67, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[100828, 3411, 392, 12, 43, "Input"],
Cell[101223, 3425, 1135, 31, 73, "Output"]
}, Closed]],
Cell[102373, 3459, 466, 16, 57, "Text"],
Cell[CellGroupData[{
Cell[102864, 3479, 295, 9, 43, "Input"],
Cell[103162, 3490, 2943, 85, 63, "Output"]
}, Closed]],
Cell[106120, 3578, 35, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[106180, 3582, 200, 6, 43, "Input"],
Cell[106383, 3590, 2869, 83, 63, "Output"]
}, Closed]],
Cell[109267, 3676, 128, 6, 33, "Text"],
Cell[CellGroupData[{
Cell[109420, 3686, 190, 4, 43, "Input"],
Cell[109613, 3692, 1437, 44, 71, "Output"]
}, Closed]],
Cell[111065, 3739, 42, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[111132, 3743, 269, 7, 43, "Input"],
Cell[111404, 3752, 831, 24, 65, "Output"]
}, Closed]],
Cell[112250, 3779, 24, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[112299, 3783, 606, 18, 48, "Input"],
Cell[112908, 3803, 1595, 43, 67, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[114540, 3851, 302, 9, 43, "Input"],
Cell[114845, 3862, 1409, 41, 73, "Output"]
}, Closed]],
Cell[116269, 3906, 51, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[116345, 3910, 284, 8, 43, "Input"],
Cell[116632, 3920, 2351, 67, 73, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[119020, 3992, 678, 20, 48, "Input"],
Cell[119701, 4014, 1251, 37, 82, "Output"]
}, Closed]],
Cell[120967, 4054, 50, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[121042, 4058, 215, 6, 45, "Input"],
Cell[121260, 4066, 956, 28, 84, "Output"]
}, Closed]],
Cell[122231, 4097, 133, 4, 33, "Text"],
Cell[CellGroupData[{
Cell[122389, 4105, 117, 2, 43, "Input"],
Cell[122509, 4109, 638, 18, 70, "Output"]
}, Closed]],
Cell[123162, 4130, 206, 5, 34, "Text"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[123417, 4141, 106, 1, 65, "Subsection",
 CellTags->"ExStrategicTrade3"],
Cell[CellGroupData[{
Cell[123548, 4146, 33, 0, 44, "Subsubsection"],
Cell[123584, 4148, 214, 7, 43, "Input"],
Cell[123801, 4157, 122, 4, 33, "Text"],
Cell[123926, 4163, 264, 9, 43, "Input"],
Cell[124193, 4174, 50, 0, 32, "Text"],
Cell[124246, 4176, 237, 8, 43, "Input"],
Cell[124486, 4186, 121, 5, 32, "Text"],
Cell[CellGroupData[{
Cell[124632, 4195, 276, 7, 43, "Input"],
Cell[124911, 4204, 451, 13, 38, "Output"]
}, Closed]],
Cell[125377, 4220, 161, 7, 33, "Text"],
Cell[CellGroupData[{
Cell[125563, 4231, 433, 11, 43, "Input"],
Cell[125999, 4244, 378, 10, 38, "Output"]
}, Closed]],
Cell[126392, 4257, 40, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[126457, 4261, 278, 9, 43, "Input"],
Cell[126738, 4272, 391, 11, 57, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[127166, 4288, 456, 14, 71, "Input"],
Cell[127625, 4304, 429, 11, 56, "Output"]
}, Closed]],
Cell[128069, 4318, 24, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[128118, 4322, 434, 13, 43, "Input"],
Cell[128555, 4337, 656, 17, 59, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[129248, 4359, 302, 9, 43, "Input"],
Cell[129553, 4370, 608, 17, 59, "Output"]
}, Closed]],
Cell[130176, 4390, 191, 6, 33, "Text"],
Cell[CellGroupData[{
Cell[130392, 4400, 577, 19, 48, "Input"],
Cell[130972, 4421, 2286, 67, 61, "Output"]
}, Closed]],
Cell[133273, 4491, 446, 17, 33, "Text"],
Cell[CellGroupData[{
Cell[133744, 4512, 286, 9, 43, "Input"],
Cell[134033, 4523, 3786, 109, 61, "Output"]
}, Closed]],
Cell[137834, 4635, 30, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[137889, 4639, 200, 6, 43, "Input"],
Cell[138092, 4647, 3549, 102, 61, "Output"]
}, Closed]],
Cell[141656, 4752, 48, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[141729, 4756, 217, 6, 43, "Input"],
Cell[141949, 4764, 1487, 45, 67, "Output"]
}, Closed]],
Cell[143451, 4812, 34, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[143510, 4816, 238, 7, 43, "Input"],
Cell[143751, 4825, 974, 28, 67, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[144762, 4858, 283, 9, 46, "Input"],
Cell[145048, 4869, 2417, 62, 67, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[147502, 4936, 297, 9, 43, "Input"],
Cell[147802, 4947, 1395, 39, 67, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[149234, 4991, 284, 8, 43, "Input"],
Cell[149521, 5001, 1786, 51, 67, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[151344, 5057, 583, 18, 48, "Input"],
Cell[151930, 5077, 1032, 31, 103, "Output"]
}, Closed]],
Cell[152977, 5111, 52, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[153054, 5115, 148, 4, 43, "Input"],
Cell[153205, 5121, 919, 27, 78, "Output"]
}, Closed]],
Cell[154139, 5151, 40, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[154204, 5155, 289, 7, 43, "Input"],
Cell[154496, 5164, 526, 16, 78, "Output"]
}, Closed]],
Cell[155037, 5183, 48, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[155110, 5187, 195, 5, 43, "Input"],
Cell[155308, 5194, 492, 14, 96, "Output"]
}, Closed]],
Cell[155815, 5211, 283, 8, 32, "Text"],
Cell[CellGroupData[{
Cell[156123, 5223, 165, 4, 43, "Input"],
Cell[156291, 5229, 241, 5, 55, "Output"]
}, Closed]],
Cell[156547, 5237, 59, 0, 32, "Text"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[156667, 5244, 59, 1, 51, "Section",
 CellTags->"c:44"],
Cell[CellGroupData[{
Cell[156751, 5249, 49, 1, 44, "Subsubsection",
 CellTags->"c:45"],
Cell[156803, 5252, 882, 33, 69, "Text"],
Cell[157688, 5287, 666, 24, 32, "Text"]
}, Closed]],
Cell[CellGroupData[{
Cell[158391, 5316, 52, 1, 44, "Subsubsection",
 CellTags->"c:46"],
Cell[158446, 5319, 428, 14, 55, "Text"],
Cell[158877, 5335, 237, 6, 43, "Input"],
Cell[159117, 5343, 2176, 74, 191, "Input"],
Cell[161296, 5419, 388, 12, 45, "Input"],
Cell[161687, 5433, 89, 2, 32, "Text"],
Cell[161779, 5437, 390, 11, 46, "Input"],
Cell[CellGroupData[{
Cell[162194, 5452, 213, 7, 43, "Input"],
Cell[162410, 5461, 401, 11, 38, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[162848, 5477, 141, 4, 43, "Input"],
Cell[162992, 5483, 386, 10, 38, "Output"]
}, Closed]],
Cell[163393, 5496, 47, 0, 32, "Text"],
Cell[163443, 5498, 464, 15, 47, "Input"],
Cell[163910, 5515, 114, 3, 32, "Text"],
Cell[164027, 5520, 1877, 57, 219, "Input"],
Cell[165907, 5579, 297, 9, 43, "Input"],
Cell[166207, 5590, 513, 18, 33, "Text"],
Cell[166723, 5610, 466, 14, 45, "Input"],
Cell[167192, 5626, 674, 21, 37, "Text"]
}, Closed]],
Cell[CellGroupData[{
Cell[167903, 5652, 64, 1, 44, "Subsubsection",
 CellTags->"c:47"],
Cell[167970, 5655, 737, 27, 37, "Text"],
Cell[CellGroupData[{
Cell[168732, 5686, 349, 10, 43, "Input"],
Cell[169084, 5698, 806, 22, 62, "Output"]
}, Closed]],
Cell[169905, 5723, 270, 7, 32, "Text"],
Cell[170178, 5732, 634, 19, 46, "Input"],
Cell[170815, 5753, 261, 9, 34, "Text"],
Cell[171079, 5764, 756, 28, 57, "Text"],
Cell[CellGroupData[{
Cell[171860, 5796, 499, 15, 69, "Input"],
Cell[172362, 5813, 604, 17, 59, "Output"]
}, Closed]],
Cell[172981, 5833, 1375, 54, 57, "Text"],
Cell[174359, 5889, 461, 17, 33, "Text"],
Cell[174823, 5908, 640, 20, 60, "Text"]
}, Closed]],
Cell[CellGroupData[{
Cell[175500, 5933, 42, 0, 44, "Subsubsection"],
Cell[175545, 5935, 308, 9, 37, "Text"],
Cell[CellGroupData[{
Cell[175878, 5948, 8958, 220, 741, "Input"],
Cell[184839, 6170, 573, 15, 38, "Output"]
}, Closed]],
Cell[185427, 6188, 519, 13, 43, "Input"],
Cell[CellGroupData[{
Cell[185971, 6205, 201, 6, 43, "Input"],
Cell[186175, 6213, 3192, 73, 225, "Output"]
}, Closed]],
Cell[189382, 6289, 107, 2, 43, "Input"],
Cell[189492, 6293, 938, 27, 98, "Input"],
Cell[CellGroupData[{
Cell[190455, 6324, 1257, 34, 98, "Input"],
Cell[191715, 6360, 3061, 57, 364, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[194837, 6424, 93, 2, 51, "Section"],
Cell[194933, 6428, 213, 6, 33, "Text"],
Cell[195149, 6436, 214, 7, 43, "Input"],
Cell[195366, 6445, 106, 5, 32, "Text"],
Cell[195475, 6452, 236, 8, 43, "Input"],
Cell[195714, 6462, 73, 0, 32, "Text"],
Cell[195790, 6464, 286, 10, 43, "Input"],
Cell[196079, 6476, 121, 5, 32, "Text"],
Cell[CellGroupData[{
Cell[196225, 6485, 300, 8, 43, "Input"],
Cell[196528, 6495, 438, 12, 38, "Output"]
}, Closed]],
Cell[196981, 6510, 91, 2, 32, "Text"],
Cell[197075, 6514, 239, 8, 43, "Input"],
Cell[197317, 6524, 116, 5, 32, "Text"],
Cell[CellGroupData[{
Cell[197458, 6533, 513, 14, 43, "Input"],
Cell[197974, 6549, 452, 12, 38, "Output"]
}, Closed]],
Cell[198441, 6564, 32, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[198498, 6568, 30, 0, 65, "Subsection"],
Cell[198531, 6570, 74, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[198630, 6574, 510, 16, 47, "Input"],
Cell[199143, 6592, 529, 15, 57, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[199709, 6612, 70, 1, 44, "Subsubsection",
 CellTags->"c:42"],
Cell[199782, 6615, 125, 4, 33, "Text"],
Cell[199910, 6621, 239, 8, 45, "Input"],
Cell[200152, 6631, 137, 3, 32, "Text"],
Cell[CellGroupData[{
Cell[200314, 6638, 338, 11, 43, "Input"],
Cell[200655, 6651, 572, 16, 57, "Output"]
}, Closed]],
Cell[201242, 6670, 78, 4, 33, "Text"],
Cell[CellGroupData[{
Cell[201345, 6678, 298, 9, 43, "Input"],
Cell[201646, 6689, 833, 24, 57, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[202516, 6718, 276, 9, 43, "Input"],
Cell[202795, 6729, 452, 12, 57, "Output"]
}, Closed]],
Cell[203262, 6744, 263, 11, 33, "Text"],
Cell[CellGroupData[{
Cell[203550, 6759, 577, 19, 48, "Input"],
Cell[204130, 6780, 2282, 67, 61, "Output"]
}, Closed]],
Cell[206427, 6850, 173, 8, 33, "Text"],
Cell[CellGroupData[{
Cell[206625, 6862, 153, 5, 43, "Input"],
Cell[206781, 6869, 279, 6, 38, "Output"]
}, Closed]],
Cell[207075, 6878, 18, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[207118, 6882, 286, 9, 43, "Input"],
Cell[207407, 6893, 2938, 84, 61, "Output"]
}, Closed]],
Cell[210360, 6980, 27, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[210412, 6984, 192, 6, 43, "Input"],
Cell[210607, 6992, 2813, 81, 61, "Output"]
}, Closed]],
Cell[213435, 7076, 123, 5, 33, "Text"],
Cell[CellGroupData[{
Cell[213583, 7085, 172, 4, 43, "Input"],
Cell[213758, 7091, 1280, 37, 67, "Output"]
}, Closed]],
Cell[215053, 7131, 134, 5, 33, "Text"],
Cell[CellGroupData[{
Cell[215212, 7140, 208, 6, 43, "Input"],
Cell[215423, 7148, 780, 21, 62, "Output"]
}, Closed]],
Cell[216218, 7172, 76, 4, 33, "Text"],
Cell[CellGroupData[{
Cell[216319, 7180, 271, 8, 43, "Input"],
Cell[216593, 7190, 1208, 33, 67, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[217838, 7228, 248, 8, 43, "Input"],
Cell[218089, 7238, 1044, 28, 67, "Output"]
}, Closed]],
Cell[219148, 7269, 43, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[219216, 7273, 310, 10, 43, "Input"],
Cell[219529, 7285, 1277, 35, 67, "Output"]
}, Closed]],
Cell[220821, 7323, 98, 2, 32, "Text"],
Cell[CellGroupData[{
Cell[220944, 7329, 380, 11, 43, "Input"],
Cell[221327, 7342, 2476, 80, 127, "Output"]
}, Closed]],
Cell[223818, 7425, 140, 6, 33, "Text"],
Cell[CellGroupData[{
Cell[223983, 7435, 290, 8, 43, "Input"],
Cell[224276, 7445, 1647, 53, 203, "Output"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[225972, 7504, 70, 1, 44, "Subsubsection",
 CellTags->"c:43"],
Cell[226045, 7507, 58, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[226128, 7511, 377, 10, 43, "Input"],
Cell[226508, 7523, 478, 15, 78, "Output"]
}, Closed]],
Cell[227001, 7541, 67, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[227093, 7545, 241, 7, 43, "Input"],
Cell[227337, 7554, 436, 14, 78, "Output"]
}, Closed]],
Cell[227788, 7571, 87, 2, 32, "Text"],
Cell[CellGroupData[{
Cell[227900, 7577, 141, 4, 43, "Input"],
Cell[228044, 7583, 469, 12, 67, "Output"]
}, Closed]],
Cell[228528, 7598, 53, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[228606, 7602, 170, 4, 43, "Input"],
Cell[228779, 7608, 247, 5, 55, "Output"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
