(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    438738,       9202]
NotebookOptionsPosition[    426659,       8851]
NotebookOutlinePosition[    429309,       8913]
CellTagsIndexPosition[    429266,       8910]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "TradingStrategiesII\n",
 StyleBox["Empirical Market Microstructure",
  FontSlant->"Italic"],
 " \n\t(2006, Oxford University Press)\nCompanion ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook\n\nJoel Hasbrouck\n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Copyright", " ", "2007"}], ",", " ", 
    RowBox[{"Joel", " ", 
     RowBox[{"Hasbrouck", ".", " ", "All"}], " ", "rights", " ", 
     RowBox[{"reserved", "."}]}]}], TraditionalForm]],
  FontSize->14,
  FontSlant->"Italic"],
 "\n",
 StyleBox["This notebook covers order submission strategies based on \
diffusion barrier models (Chapter 15, section 15.2).",
  FontSize->14]
}], "Title",
 CellChangeTimes->{{3.3896255910914*^9, 3.3896255932033997`*^9}, {
   3.3897167078988237`*^9, 3.389716768500824*^9}, 3.3897219191158237`*^9, {
   3.3897220399168243`*^9, 3.3897220640418243`*^9}, {3.3900309756364307`*^9, 
   3.39003097613043*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Text", "  ", "@", " ", 
  RowBox[{"Style", "[", 
   RowBox[{
    RowBox[{"\"\<Notebook evaluated \>\"", "<>", 
     RowBox[{"DateString", "[", "\"\<DateTime\>\"", "]"}]}], ",", 
    "\"\<Subtitle\>\""}], "]"}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896127180972*^9, 3.3896127205282*^9}, 
   3.389716999411824*^9, {3.3897170351038237`*^9, 3.389717047196824*^9}}],

Cell[BoxData[
 InterpretationBox[Cell[BoxData[
   StyleBox["\<\"Notebook evaluated Friday 1 June 2007 21:07:10\"\>", 
    "Subtitle",
    StripOnInput->False]], "Text", "TR"],
  Text[
   Style["Notebook evaluated Friday 1 June 2007 21:07:10", 
    "Subtitle"]]]], "Output",
 CellMargins->{{18, Inherited}, {Inherited, 0}},
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3896127211071997`*^9, {3.3896127536242*^9, 3.3896127555652*^9}, 
   3.3896128616452*^9, 3.389623031447*^9, 3.3896232934164*^9, 
   3.389716955274824*^9, 3.3897170008718243`*^9, {3.3897170377738237`*^9, 
   3.3897170482808237`*^9}, 3.389735230721224*^9},
 Background->RGBColor[0.866667, 0.733333, 1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Preliminaries", "Section"],

Cell[CellGroupData[{

Cell["Other initializations", "Subsection"],

Cell[BoxData[
 RowBox[{"<<", "PlotLegends`"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896137404351997`*^9, 3.3896137460622*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"baseStyle", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
     RowBox[{"FontSize", "\[Rule]", "12"}]}], "}"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389734314469224*^9, 3.389734329719224*^9}}],

Cell[BoxData[
 RowBox[{"<<", "Notation`"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389722102682824*^9, 3.389722105170824*^9}}],

Cell["\<\
The following commands define symbolizations that are convenient for labeling \
things.\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["Anything_", "Rule"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";", 
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["Anything_", "Rules"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell["\<\
The following command allows script capital E to be entered as \[EscapeKey]E\
\[EscapeKey].\
\>", "Text",
 CellChangeTimes->{{3.3900310045724306`*^9, 3.3900310054554305`*^9}, {
  3.3900311221234303`*^9, 3.3900311368294306`*^9}}],

Cell[BoxData[
 RowBox[{"AddInputAlias", "[", 
  RowBox[{
   TagBox["\[ScriptCapitalE]",
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], ",", "\"\<E\>\""}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"AddInputAlias", "[", 
  RowBox[{
   TagBox["\[ScriptL]",
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], ",", "\"\<ll\>\""}], "]"}]], "Input",\

 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["\[Gamma]", "_"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";"}]], "Input",
 CellLabelAutoDelete->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Additional Notations", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["Pr", "_"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["f", "_"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TagBox[
    SubscriptBox["E\[Delta]", "_"],
    NotationBoxTag,
    BaseStyle->"NotationTemplateStyle"], "]"}], ";"}]}], "Input",
 CellLabelAutoDelete->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["\[Phi][x], \[CapitalPhi][X], etc.", "Subsection"],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"\[Phi]", "[", "x", "]"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"\[CapitalPhi]", "[", "x", "]"}]]],
 " are often used to denote the density and distribution functions for the \
standard normal distribution."
}], "Text"],

Cell[BoxData[
 RowBox[{"\n", 
  RowBox[{
   RowBox[{
    SubscriptBox["Normal", "Rules"], "=", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"\[Phi]", "[", "x_", "]"}], "\[RuleDelayed]", 
       RowBox[{"PDF", "[", 
        RowBox[{
         RowBox[{"NormalDistribution", "[", 
          RowBox[{"0", ",", "1"}], "]"}], ",", "x"}], "]"}]}], ",", 
      RowBox[{
       RowBox[{"\[CapitalPhi]", "[", "x_", "]"}], "\[RuleDelayed]", 
       RowBox[{"CDF", "[", 
        RowBox[{
         RowBox[{"NormalDistribution", "[", 
          RowBox[{"0", ",", "1"}], "]"}], ",", "x"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"\[Phi]", "[", 
        RowBox[{"x_", ",", "\[Mu]_", ",", "var_"}], "]"}], "\[RuleDelayed]", 
       RowBox[{"PDF", "[", 
        RowBox[{
         RowBox[{"NormalDistribution", "[", 
          RowBox[{"\[Mu]", ",", 
           SqrtBox["var"]}], "]"}], ",", "x"}], "]"}]}], ",", 
      RowBox[{
       RowBox[{"\[CapitalPhi]", "[", 
        RowBox[{"x_", ",", "\[Mu]_", ",", "var_"}], "]"}], "\[RuleDelayed]", 
       RowBox[{"CDF", "[", 
        RowBox[{
         RowBox[{"NormalDistribution", "[", 
          RowBox[{"\[Mu]", ",", 
           SqrtBox["var"]}], "]"}], ",", "x"}], "]"}]}]}], "}"}]}], 
   ";"}]}]], "Input",
 CellLabelAutoDelete->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graph depicting execution mechanism", "Section"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SeedRandom", "[", "1234", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"L", "=", "7.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", "50"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"FoldList", "[", 
      RowBox[{"Plus", ",", "10", ",", "#"}], "]"}], "&"}], "/@", 
    RowBox[{"(", 
     RowBox[{".1", "+", 
      RowBox[{"RandomReal", "[", 
       RowBox[{
        RowBox[{"NormalDistribution", "[", 
         RowBox[{"0", ",", "1"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "n"}], "}"}]}], "]"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExecTime", "=", 
   RowBox[{"First", " ", "@@", " ", 
    RowBox[{"Position", "[", 
     RowBox[{
      RowBox[{"p", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", 
      RowBox[{"First", "[", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"p", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"#", "\[LessEqual]", "L"}], "&"}]}], "]"}], "]"}]}], 
     "]"}]}]}], ";"}]}], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389722507034224*^9, 3.3897225092082243`*^9}, 
   3.389722669909224*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"p", ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "\"\<t\>\""}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ExecTime", ",", "\"\<Execution\>\""}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"n", "+", "1"}], ",", "\"\<t+1\>\""}], "}"}]}], "}"}], ",", 
      
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"L", ",", "\"\<L\>\""}], "}"}], "}"}], ",", "None", ",", 
      "None"}], "}"}]}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Time\>\"", ",", "\"\<Ask price\>\""}], "}"}]}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "L"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"n", "+", "1"}], ",", "L"}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<Path A\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", 
          RowBox[{"L", "+", "9"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<Path B\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", 
          RowBox[{"L", "+", "4"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", 
      RowBox[{"PointSize", "[", "0.02`", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"ExecTime", ",", "L"}], "}"}], "]"}]}], "}"}]}], ",", 
   RowBox[{"BaseStyle", "\[Rule]", "baseStyle"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3897221435628242`*^9, 3.3897223552478237`*^9}, {
  3.389722522172224*^9, 3.389722522537224*^9}, {3.389722575967224*^9, 
  3.389722606553224*^9}, {3.389734340115224*^9, 3.389734346502224*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1., 10.}, {2., 9.591664497055556}, {3., 9.621062638953347}, {4.,
      8.127166155855972}, {5., 9.763760028296888}, {6., 12.54177931605168}, {
     7., 11.324948731455716`}, {8., 10.330383795326622`}, {9., 
     10.573331701834931`}, {10., 10.777497257738625`}, {11., 
     9.204387917407281}, {12., 9.340139345530584}, {13., 9.610325506078185}, {
     14., 10.645007699166012`}, {15., 9.918143472943061}, {16., 
     9.927180488913857}, {17., 11.060589125752038`}, {18., 
     10.797060465197745`}, {19., 11.085651367006111`}, {20., 
     11.04950908656938}, {21., 11.065559255004507`}, {22., 
     11.72358989183566}, {23., 9.662308316221996}, {24., 9.772287880674753}, {
     25., 9.021256157350827}, {26., 8.213619225173918}, {27., 
     7.313096616262126}, {28., 7.902854609337151}, {29., 8.385410194043528}, {
     30., 8.033851800504726}, {31., 9.274368638453451}, {32., 
     9.521536518587489}, {33., 10.30757465828823}, {34., 
     11.687590556186816`}, {35., 10.576126296551436`}, {36., 
     10.096060409895538`}, {37., 8.989510711021104}, {38., 
     9.646406188345622}, {39., 9.773783849612268}, {40., 9.45950555402603}, {
     41., 10.3867925975176}, {42., 10.584224187953653`}, {43., 
     9.77429319267319}, {44., 10.86232006304629}, {45., 
     11.122159080998342`}, {46., 10.48816316315605}, {47., 
     9.932698884956272}, {48., 9.58733868950825}, {49., 
     10.053581333686788`}, {50., 9.898273685360353}, {51., 
     10.248586134948747`}}]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], 
    LineBox[{{1., 10.}, {2., 10.431323309099577`}, {3., 
     10.846007096973764`}, {4., 12.661775604071757`}, {5., 
     12.614128838796535`}, {6., 13.09160156769839}, {7., 13.70877298340055}, {
     8., 13.835892488291787`}, {9., 14.379908052522136`}, {10., 
     16.191565258317635`}, {11., 16.81778849372267}, {12., 
     17.531227698425656`}, {13., 18.218285974334933`}, {14., 
     18.744960712404325`}, {15., 17.965459790514306`}, {16., 
     18.085885793284053`}, {17., 18.368919434778892`}, {18., 
     20.681829291462325`}, {19., 20.78022777765129}, {20., 
     20.51447303294272}, {21., 19.21360749554311}, {22., 
     18.161333197095164`}, {23., 17.771867843692934`}, {24., 
     17.668402978303398`}, {25., 17.893628311532822`}, {26., 
     16.936957847683306`}, {27., 17.00079054647647}, {28., 
     15.751066624724624`}, {29., 16.116292152573234`}, {30., 
     16.397356707068344`}, {31., 16.326029364639986`}, {32., 
     15.972483533863413`}, {33., 16.264780149589644`}, {34., 
     16.660604935107575`}, {35., 17.047694606532477`}, {36., 
     16.070729850129474`}, {37., 15.591835738120398`}, {38., 
     16.89166083471754}, {39., 19.02791150538436}, {40., 
     17.902213194520613`}, {41., 19.60921603349672}, {42., 
     20.294839336565992`}, {43., 19.263220250673136`}, {44., 
     19.92922373022366}, {45., 19.80967225479852}, {46., 
     19.066757393366334`}, {47., 19.280342722317723`}, {48., 
     20.291971412459382`}, {49., 18.0759354550718}, {50., 
     19.666778822537314`}, {51., 21.0175247695607}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 8.},
  Background->GrayLevel[1],
  BaseStyle->{FontFamily -> "Times", FontSize -> 12},
  Epilog->{
    LineBox[{{1, 7.5}, {51, 7.5}}], 
    InsetBox[
     FormBox["\"Path A\"", TraditionalForm], {50, 16.5}, {1, 0}], 
    InsetBox[
     FormBox["\"Path B\"", TraditionalForm], {50, 11.5}, {1, 0}], 
    PointSize[0.02], 
    PointBox[{27, 7.5}]},
  Frame->True,
  FrameLabel->{
    FormBox["\"Time\"", TraditionalForm], 
    FormBox["\"Ask price\"", TraditionalForm]},
  FrameTicks->{{{1, 
      FormBox["\"t\"", TraditionalForm]}, {27, 
      FormBox["\"Execution\"", TraditionalForm]}, {51, 
      FormBox["\"t+1\"", TraditionalForm]}}, {{7.5, 
      FormBox["\"L\"", TraditionalForm]}}, None, None},
  PlotRange->{{0., 51.}, {7.313096616262126, 21.0175247695607}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3897223825748243`*^9, 3.389722423214224*^9, {3.389722512022224*^9, 
   3.389722523285224*^9}, {3.389722577453224*^9, 3.3897226070062237`*^9}, 
   3.389722673821224*^9, 3.389734352487224*^9, 3.389734652382224*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"L", ",", "n", ",", "p", ",", "ExecTime"}], "]"}], ";"}]], "Input",\

 CellLabelAutoDelete->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Barrier-diffusion model: Results from Lancaster (1997)", "Section"],

Cell["\<\
Lancaster, Tony, 1997. The Econometric Analysis of Transition Data (Cambridge \
University Press, Cambridge).\
\>", "Text"],

Cell[TextData[{
 "In Lancaster's framework, the particle starts at zero; the barrier is ",
 Cell[BoxData[
  RowBox[{"\[Alpha]", ">", "0"}]]],
 ". The survivor function (his equation 7.9) is:"
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["S", "Rule"], "=", 
   RowBox[{
    RowBox[{"S", "[", 
     RowBox[{"t_", ",", "\[Mu]_", ",", "\[Sigma]_", ",", "\[Alpha]_"}], "]"}],
     "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"\[CapitalPhi]", "[", 
      FractionBox[
       RowBox[{"\[Alpha]", "-", 
        RowBox[{"\[Mu]", " ", "t"}]}], 
       RowBox[{"\[Sigma]", 
        SqrtBox["t"]}]], "]"}], "-", 
     RowBox[{
      RowBox[{"Exp", "[", 
       FractionBox[
        RowBox[{"2", " ", "\[Mu]", " ", "\[Alpha]"}], 
        SuperscriptBox["\[Sigma]", "2"]], "]"}], 
      RowBox[{"\[CapitalPhi]", "[", 
       FractionBox[
        RowBox[{
         RowBox[{"-", "\[Alpha]"}], "-", 
         RowBox[{"\[Mu]", " ", "t"}]}], 
        RowBox[{"\[Sigma]", 
         SqrtBox["t"]}]], "]"}]}]}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell["\<\
Distribution of \[Delta] given that barrier \[Alpha] has not yet been hit:\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["g", "Rule"], "=", 
   RowBox[{
    RowBox[{"g", "[", 
     RowBox[{
     "\[Delta]_", ",", "t_", ",", "\[Mu]_", ",", "\[Sigma]_", ",", 
      "\[Alpha]_"}], "]"}], "\[RuleDelayed]", 
    FractionBox[
     RowBox[{
      RowBox[{"\[Phi]", "[", 
       FractionBox[
        RowBox[{"\[Delta]", "-", 
         RowBox[{"\[Mu]", " ", "t"}]}], 
        RowBox[{"\[Sigma]", " ", 
         SqrtBox["t"]}]], "]"}], "-", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"2", " ", "\[Mu]", " ", "\[Alpha]"}], 
         SuperscriptBox["\[Sigma]", "2"]]], " ", 
       RowBox[{"\[Phi]", "[", 
        FractionBox[
         RowBox[{"\[Delta]", "-", 
          RowBox[{"2", " ", "\[Alpha]"}], "-", 
          RowBox[{"t", " ", "\[Mu]"}]}], 
         RowBox[{"\[Sigma]", " ", 
          SqrtBox["t"]}]], "]"}]}]}], 
     RowBox[{"\[Sigma]", " ", 
      SqrtBox["t"], " ", 
      RowBox[{"S", "[", 
       RowBox[{"t", ",", "\[Mu]", ",", "\[Sigma]", ",", "\[Alpha]"}], 
       "]"}]}]]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell["\<\
Expectation of \[Delta] given that the barrier \[Alpha] has not yet been hit:\
\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["E\[Delta]Cond", "Rule"], "=", 
   RowBox[{
    RowBox[{"E\[Delta]Cond", "[", 
     RowBox[{"t_", ",", "\[Mu]_", ",", "\[Sigma]_", ",", "\[Alpha]_"}], "]"}],
     "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"\[Mu]", " ", "t"}], " ", "-", 
     RowBox[{"2", " ", "\[Alpha]", " ", 
      RowBox[{"Exp", "[", 
       FractionBox[
        RowBox[{"2", " ", "\[Mu]", " ", "\[Alpha]"}], 
        SuperscriptBox["\[Sigma]", "2"]], "]"}], 
      FractionBox[
       RowBox[{"\[CapitalPhi]", "[", 
        FractionBox[
         RowBox[{
          RowBox[{"-", "\[Alpha]"}], "-", 
          RowBox[{"\[Mu]", " ", "t"}]}], 
         RowBox[{"\[Sigma]", 
          SqrtBox["t"]}]], "]"}], 
       RowBox[{"S", "[", 
        RowBox[{"t", ",", "\[Mu]", ",", "\[Sigma]", ",", "\[Alpha]"}], 
        "]"}]]}]}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Reworking of Lancaster results for (buy) limit order analysis in unit time \
interval\
\>", "Section"],

Cell[TextData[{
 Cell[BoxData["\[ScriptL]"]],
 " is the limit price position relative to the current price: ",
 Cell[BoxData[
  RowBox[{"\[ScriptL]", "=", 
   RowBox[{"L", "-", "p"}]}]]],
 ". (Note ",
 Cell[BoxData[
  RowBox[{"\[ScriptL]", "<", "0"}]]],
 ". Execution probabilities for buy and sell orders are:"
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["Pr", "Rules"], "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"PrNoHit", "[", 
       RowBox[{"\[ScriptL]_", ",", "\[Mu]_", ",", "\[Sigma]_"}], "]"}], 
      "\[RuleDelayed]", " ", 
      RowBox[{"S", "[", 
       RowBox[{"1", ",", 
        RowBox[{"-", "\[Mu]"}], ",", "\[Sigma]", ",", 
        RowBox[{"-", "\[ScriptL]"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"PrHit", "[", 
       RowBox[{"\[ScriptL]_", ",", "\[Mu]_", ",", "\[Sigma]_"}], "]"}], 
      "\[RuleDelayed]", " ", 
      RowBox[{"1", "-", 
       RowBox[{"S", "[", 
        RowBox[{"1", ",", 
         RowBox[{"-", "\[Mu]"}], ",", "\[Sigma]", ",", 
         RowBox[{"-", "\[ScriptL]"}]}], "]"}]}]}]}], "}"}]}], ";"}]], "Input",\

 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell["Plots", "Subsection"],

Cell[CellGroupData[{

Cell["Probability of no hit", "Subsubsection",
 CellChangeTimes->{{3.389732572766224*^9, 3.3897325780502243`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"PrNoHit", "[", 
       RowBox[{"\[ScriptL]", ",", "0", ",", "1"}], "]"}], "/.", 
      "\[InvisibleSpace]", 
      SubscriptBox["Pr", "Rules"]}], "/.", "\[InvisibleSpace]", 
     SubscriptBox["S", "Rule"]}], "/.", "\[InvisibleSpace]", 
    SubscriptBox["Normal", "Rules"]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[ScriptL]", ",", 
     RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\[ScriptL]", ",", "PrNoHit"}], "}"}]}], ",", 
   RowBox[{"BaseStyle", "\[Rule]", "baseStyle"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3897316700062237`*^9, 3.3897316751822243`*^9}, 
   3.389732621136224*^9, 3.3897343694732237`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVlHs01AkUx3+i9ehhqD2MR+z2IFQYIa87hsijBkubzSmVmpPJq6dd1kpb
oeOg0FazJZvNIE27Kq/tjoxnsxOR92PMyxBGJxOJ7Owf93zP53z+uN9z/7jf
HI0LOb6CIIh9qvk/b5qtUi4vK7DAc5Z1s1cKVYt6vOQlBboYngiM7JFCb5/h
jU8LKp/FEFt2S8Eob4vdB6UCr+8nt1R3SoGlRYuRvVOg90XnU/0CKRS+T5Ty
exQY5cAwM2iUQmmD7O2txwr0aS22S3kihTrGy2eUwwpcy3ygqZ4pheiJlUoh
Zxptf6N3GFKkoCt0yjReO40RUznyEKEEBnaK0q7GTmF0QOk2dpYE7JoM50/V
T2Jo4Z6QvfYS+LnVnTdiNomTz+mN5wbEEKKpWM2Pf4feQxnWRUlioBcbVo/z
JlDjh3W5XcZioD2zrcvbNIFG7mSegisCVHvrWn1+HH/qi9hXFSECey5Dn9kl
R858kcm9pVHgD58O3LdTjqXGIbUf747CjJOOeln6GDqUFYrKHUdBRyOHlD8m
w/lVvgelnUKo0Cm6Pe8sw2QFW+7OEMKPCTbpWVlSdAjqsFpWjoBLQDH/8ZQE
Kzf200K3jsDlw6VZAVQJmhu06kXuGYYm2e/FZ++K8X0j8ajszBDklpi6GChE
uPrvvVNemYNwqe1r+3c0EY55Mdc6FQ0A8/BiamDRKHKe6ybsbO6Hoe1xgRaz
QvTLaNRc19MHuxPaY7ODhRghqK84OdsLbIvQ8eCoESxMOFP5cV0vDIyaTV/Q
GUZWj/i+9oYeWLjYUljVPIihvzbGhDp2g83NjMDJkwOo55tkJ3R+C+WnXDFN
vx9bZIeSWty7gGzZNkJ504up10fJD4I74daBhE8953tw5r7fwhX6G/gqTskt
sO/G9W52Bg0RHVC/O5peNduFrP1qlyxi2iEnd66bf6cTOeaenEGBAAIajqxe
DH+DguV/GUwxH8jREpcNS+04k33tecarNiiZurr9WexrTNROtzrR1QJ1Vy3P
KRV8tL1mt6tW0gQfVy08MnJtQ67N63xWCw+0Iy7TzlU2Y68WuyZK8BK8Cjxb
n87xkNSewax7yAWj4JGhWt+XmMwyzbyg/w/kPY5hTV9DJP0imD5mXA2euSlH
7ExqMH5y7uznV5VQqKM+PKz1FElU+kR5AwdcLvufN9DlYGSHKG8Niw3UkjGp
U0gxztOjSI1q90E4QWPZpBRgkNJx69L7XAgX1DSbib2RKKyjHCulQsX4+NyN
bBUbHqHUMKigsZJsqeWm4oIv9nqbqcBxvZA+k+eFBMk/KgUAtNgUv3ofGhKD
uyMdrdwhVjM8vzEUkKDOhf257AxWp93uBIgdkBAKdl0ptYXuktufKW4qzmly
cthsC2kj8wdN8ilIcGOZPNgBfYFPTaZ87JFI1TmWbLUNSPQIN9OwHSrmBE8u
WwK/Gmh/iDchUULexi81h00WiyvO5m9EIp4XFEQ1g6S8qgZv32+RsN3jq2Vt
CqHDRzP5YWaqPtYOiQQZdP18ckIk61X7EtccKCPBi42oN+urj0RkvKa5zRro
X4zbYv29ruoeog/ZatqQz/jO5olUQ+XZ/LhyAmS7Mg/Jw5dfqL7VaVT/5FH0
ICYqVj6r4of+9ypmPGo3FHXJpyQviNQMny9/CT38j8s7uONhKk8kKZKCPf4D
IxKCoA==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\[ScriptL]", TraditionalForm], 
    FormBox["PrNoHit", TraditionalForm]},
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Times", FontSize -> 12},
  ImageSize->{231.333333333332, Automatic},
  PlotRange->{{-1, 0}, {0., 0.6826894822607297}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3897227107602243`*^9, 3.3897326036942244`*^9, 3.389732665811224*^9, 
   3.389732795070224*^9, {3.389734450344224*^9, 3.389734478413224*^9}, {
   3.389734665929224*^9, 3.389734694384224*^9}, 3.389735022898224*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"lineStyles", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
       RowBox[{"Dashing", "[", 
        RowBox[{".01", "r"}], "]"}], ",", 
       RowBox[{"AbsoluteThickness", "[", 
        RowBox[{".5", "r"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "0", ",", "2"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896149201127996`*^9, 3.3896149841478*^9}, {
   3.389619683251*^9, 3.3896196876140003`*^9}, 3.389621668238*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"legendLines", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
        RowBox[{"Dashing", "[", 
         RowBox[{".1", "r"}], "]"}], ",", 
        RowBox[{"AbsoluteThickness", "[", 
         RowBox[{".5", "r"}], "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "0", ",", "2"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896149201127996`*^9, 3.3896149841478*^9}, {
  3.389619683251*^9, 3.3896196876140003`*^9}, {3.389619814413*^9, 
  3.3896199705290003`*^9}, {3.389620788172*^9, 3.389620837962*^9}, {
  3.3896208788570004`*^9, 3.389620902436*^9}, {3.3896210739440002`*^9, 
  3.38962107709*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"legendText", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Style", "[", 
      RowBox[{
       RowBox[{"\"\<\[Mu]\[Rule]\>\"", "<>", 
        RowBox[{"ToString", "[", "#", "]"}]}], ",", "Black", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}]}], "]"}], "&"}], 
    " ", "/@", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0.1", ",", "0.2"}], "}"}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389620914783*^9, 3.3896209204820004`*^9}, {
   3.389620988039*^9, 3.389621025764*^9}, 3.389621081079*^9, 
   3.389621619785*^9, {3.389732359838224*^9, 3.389732441608224*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"legendEntries", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"legendLines", ",", "legendText"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389621033892*^9, 3.3896210839779997`*^9}}],

Cell["\<\
When \[Mu] increases, the probability of no hit increases:\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"PrNoHit", "[", 
              RowBox[{"\[ScriptL]", ",", "\[Mu]", ",", "1"}], "]"}], "/.", 
             "\[InvisibleSpace]", 
             SubscriptBox["Pr", "Rules"]}], "/.", "\[InvisibleSpace]", 
            SubscriptBox["S", "Rule"]}], "/.", "\[InvisibleSpace]", 
           SubscriptBox["Normal", "Rules"]}], "/.", "\[InvisibleSpace]", 
          RowBox[{"\[Mu]", "\[Rule]", "#1"}]}], "&"}], ")"}], "/@", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0.1`", ",", "0.2`"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[ScriptL]", ",", 
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "lineStyles"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\[ScriptL]", ",", "PrNoHit"}], "}"}]}], ",", 
     RowBox[{"BaseStyle", "\[Rule]", "baseStyle"}]}], "]"}]}], ";"}]], "Input",\

 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389722742887224*^9, 3.389722743970224*^9}, {
   3.389732466750224*^9, 3.3897324686022243`*^9}, {3.389732641702224*^9, 
   3.389732655501224*^9}, 3.389732696488224*^9, 3.389734374713224*^9, 
   3.389734703100224*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShowLegend", "[", 
  RowBox[{"p1", ",", 
   RowBox[{"{", 
    RowBox[{"legendEntries", ",", 
     RowBox[{"LegendPosition", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", ".4"}]}], "}"}]}], ",", 
     RowBox[{"LegendSize", "\[Rule]", "0.6"}], ",", 
     RowBox[{"LegendShadow", "\[Rule]", "None"}]}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896199844309998`*^9, 3.389619996865*^9}, {
  3.389621094799*^9, 3.389621098097*^9}, {3.389621182734*^9, 
  3.389621187608*^9}, {3.3896212580950003`*^9, 3.389621276164*^9}, {
  3.389621319869*^9, 3.3896213638640003`*^9}, {3.3896216388050003`*^9, 
  3.3896216436809998`*^9}, {3.3897325365432243`*^9, 3.389732547526224*^9}}],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    GraphicsBox[{{}, {}, 
      {GrayLevel[0], AbsoluteThickness[0], Dashing[0], 
       LineBox[CompressedData["
1:eJwVlHs01AkUx3+i9ehhqD2MR+z2IFQYIa87hsijBkubzSmVmpPJq6dd1kpb
oeOg0FazJZvNIE27Kq/tjoxnsxOR92PMyxBGJxOJ7Owf93zP53z+uN9z/7jf
HI0LOb6CIIh9qvk/b5qtUi4vK7DAc5Z1s1cKVYt6vOQlBboYngiM7JFCb5/h
jU8LKp/FEFt2S8Eob4vdB6UCr+8nt1R3SoGlRYuRvVOg90XnU/0CKRS+T5Ty
exQY5cAwM2iUQmmD7O2txwr0aS22S3kihTrGy2eUwwpcy3ygqZ4pheiJlUoh
Zxptf6N3GFKkoCt0yjReO40RUznyEKEEBnaK0q7GTmF0QOk2dpYE7JoM50/V
T2Jo4Z6QvfYS+LnVnTdiNomTz+mN5wbEEKKpWM2Pf4feQxnWRUlioBcbVo/z
JlDjh3W5XcZioD2zrcvbNIFG7mSegisCVHvrWn1+HH/qi9hXFSECey5Dn9kl
R858kcm9pVHgD58O3LdTjqXGIbUf747CjJOOeln6GDqUFYrKHUdBRyOHlD8m
w/lVvgelnUKo0Cm6Pe8sw2QFW+7OEMKPCTbpWVlSdAjqsFpWjoBLQDH/8ZQE
Kzf200K3jsDlw6VZAVQJmhu06kXuGYYm2e/FZ++K8X0j8ajszBDklpi6GChE
uPrvvVNemYNwqe1r+3c0EY55Mdc6FQ0A8/BiamDRKHKe6ybsbO6Hoe1xgRaz
QvTLaNRc19MHuxPaY7ODhRghqK84OdsLbIvQ8eCoESxMOFP5cV0vDIyaTV/Q
GUZWj/i+9oYeWLjYUljVPIihvzbGhDp2g83NjMDJkwOo55tkJ3R+C+WnXDFN
vx9bZIeSWty7gGzZNkJ504up10fJD4I74daBhE8953tw5r7fwhX6G/gqTskt
sO/G9W52Bg0RHVC/O5peNduFrP1qlyxi2iEnd66bf6cTOeaenEGBAAIajqxe
DH+DguV/GUwxH8jREpcNS+04k33tecarNiiZurr9WexrTNROtzrR1QJ1Vy3P
KRV8tL1mt6tW0gQfVy08MnJtQ67N63xWCw+0Iy7TzlU2Y68WuyZK8BK8Cjxb
n87xkNSewax7yAWj4JGhWt+XmMwyzbyg/w/kPY5hTV9DJP0imD5mXA2euSlH
7ExqMH5y7uznV5VQqKM+PKz1FElU+kR5AwdcLvufN9DlYGSHKG8Niw3UkjGp
U0gxztOjSI1q90E4QWPZpBRgkNJx69L7XAgX1DSbib2RKKyjHCulQsX4+NyN
bBUbHqHUMKigsZJsqeWm4oIv9nqbqcBxvZA+k+eFBMk/KgUAtNgUv3ofGhKD
uyMdrdwhVjM8vzEUkKDOhf257AxWp93uBIgdkBAKdl0ptYXuktufKW4qzmly
cthsC2kj8wdN8ilIcGOZPNgBfYFPTaZ87JFI1TmWbLUNSPQIN9OwHSrmBE8u
WwK/Gmh/iDchUULexi81h00WiyvO5m9EIp4XFEQ1g6S8qgZv32+RsN3jq2Vt
CqHDRzP5YWaqPtYOiQQZdP18ckIk61X7EtccKCPBi42oN+urj0RkvKa5zRro
X4zbYv29ruoeog/ZatqQz/jO5olUQ+XZ/LhyAmS7Mg/Jw5dfqL7VaVT/5FH0
ICYqVj6r4of+9ypmPGo3FHXJpyQviNQMny9/CT38j8s7uONhKk8kKZKCPf4D
IxKCoA==
        "]]}, 
      {GrayLevel[0], AbsoluteThickness[0.5], Dashing[0.01], 
       LineBox[CompressedData["
1:eJwVzVlQkwcUBeAf1BoClkitArIoRqGVIgTcIHJJZKnCiIBWsLSIlaqsahVb
QYp2GAiOCmNAUepEEAVRpLKUTS+QyNZUFkPYs+cnLCFWwQVjbfpw58z3cM5d
fTApNMaYIIhdhvs/r9qbzn38qMNbn6yX2otJqNMvFaR+0GEtP9FtVkTC4JDl
lXfzOjQp1R/peE6CNXed26s5HUo5s5nHekkopLATyCkdrtnqm4FCEnj//KwW
DujwUrgsNZxPwj0+2V/wUIdrXxpFJleS0HS4tdY9SoeUjjMN0dkkxE4umpNV
zmDI0gLfqE0kmMs2Z6/8dAYVRmEUOqmGkY2K85mJWkyhrSgS5qnBrc3ybXzL
NO5vfCdqYarhbOc2gdR+GtuK+i/JxlUQulhnJjw2hYvc2AdfclQQXGJZPyGY
RLnuq+ut61XArnVt4tInkVmaP0PvUwIa9XvVJ0/gDwGSMbMkJTCaD1vEiTRY
VW0++pimBKHkRNCujRqE0VULbjxSwIvN1AXlWeN47fUhbv5OBVAX5tDyxkn0
ZdxZ1TYuhwpq0fW3W0g8ks471nJGDr8cd866eFGNHi5qQfcSOXgGlggfalWo
6XrMP3dHBhlR9y4G+qhwV3UH66aHDNrI30tO3lSinWMayz1XCrmltp4rdArk
LL9Q9WOxBH7r+pwxxVbgPpGI2FI7BnFR+vSgIjnG3I4bKe8fhTGXpCDHWRkq
gfa+QjICfsd7Ei+HyNBcMV78bHYYyhz3TIQckmLaUZX2V7NhGJHbz5ymSvDK
Jq/ytUuGYP5cB6+ufRS/i1rGa1s5CM5XOUHTR0fwX10vR24xAPfjvfC8xTBm
OblaXTIVg5VTl9S9bxDZdz0Fyz/rh4Lw4+8GkgewO3gD/6qxCD5JmmvOZ4jx
/a0dnASj59DiFxtcNytCp1xrlzbjPsjJfSMW3niOznaujvemeiCQH22mj+hD
ugVPFNfZDVaxKk+7Dz1Y2HjtrI7zN5RqM11qE7uRGv2o8EHcX9CU6XRqTifE
eKe6KF5YJ7w2nX9g7dWF35TIL8eYtINJZAb7VHU7RgqCKl7JBbA9n9VZ80aA
qZovCscyW8E6RDrWGNCKJ/gO92M8moH7MKFw5gIiZTLcLonaBKzctGg3mwbM
iajqt/X/E3jUBRIJpQYPxKrsjISPwDNjZ/IK80rcPbfsp6eC++BTOq7eHFqC
lbdrXkzSi0E2yS50TsvHZslj06htXIh41tBur/RF4sCW0JViNlRMTLy5ctng
I3H1gmw2LFxk5URhGixoWZ4IbKj0Op31grsdCcpQVXMpCyhl7jta/NlIxFef
jknxgcTFEXlP9wASg/FB+1lM+PIE80ag0gOJjgDvWDEDxKXX37szDbbU5jUA
A85L335rk+eORI90iFrmBkNBNTZafwYS6RXrylNcgRYcybTduwEJQnu3n+UM
wnpgFyvpSLi2zAvFDkB31BufzFtj6E+7x5WthhRuHd83wAEJWoOfSeoq2CM5
mC3ca2/YSyY5bBsw3+GfE6pahgSvferkgAU8WYNLZwMskJDt1lSk0mBYn7Ru
/T5zJHy+du7dbgZ5h8Oc/1AvNPwPN60dNAZya/b3moiPT4h0jm2wv9676HbC
oUTN7BOCKJhwHXnp3WhXJNJoVQa3zjnIFN47YzS9zRN7DSby/fhh3v8BR+aK
3Q==
        "]]}, 
      {GrayLevel[0], AbsoluteThickness[1.], Dashing[0.02], 
       LineBox[CompressedData["
1:eJwVyXk41Akcx/Ff0eaoxKqkCYW0GdeM1rm+jKsyEUux2RWPKGWoRzqWnpDI
bsXmKGofq7Sji1o8lHzHUY5mJbmPMcbM/GaI6ZjJ0bRWf3ye9/N6Ppsi4gIO
LiUIwndxX1tgqKlYWJBhlJeE/O85CTVK7eakLzKMb7U+z28moX9A7+rcvAwP
bRpRaWwiQT93i81HhQzhQuiD8w0k3FBjxIonZbj3cDdb7RkJxe9Pibh9Mnx8
r8hVs5KEu03inuvlMmw4YD45/xcJddGN1fQwGdY8/XYiLZmEmIllCn7FNHY5
Uu6KqCRo8e2yNqyaxo93xsLLR8UwtF2QmsGawoDV++vM/hCDzQu92aMNb1E3
MWel0kkMyW0/NI8avsV8i3s6RVIRBCyXreDGT6IwjH/Z4rII/Er1aqXNE0iz
Px/rQBMBo9q6LtdkAt+/Xll2ZlAIuKTHqTZRiuei5Obmp4VA40TrHOmWIOdl
j9sOihC4vONM3+0SDK9cp7Ibx+GdnYbKvUwSOfxYU7fgcdBQzV6dR4pxtppa
oP1JAA81Sgpn7cUY/ZipF3NRAKePUTMvXRKhaVqUKJkiAEefUm75lBAFbidQ
WDkG6WF3L/m4CrFEnxcVyBiDF+KbpQl/jqOr5SqroB4+5LA3Oq6TCZDKiqbM
h/IhrX0NbZIhQOIUI123bRSOhCnPMUvG8EEK1ddfyIMRyzimmZyP3oEixjg5
Ap7HOllX/Pmo/amSsWZ2GMrMAqX+kaP4bAc920R9GIbGDKdPavDww5mEiNIl
QzCf0lpc0zKM9605txqWDwK14CLz7eEhTGIzh6/J++H+USdM1RnEOZ+gYANB
H6zf2j5K7+rH3SZR6u68XrgefGyuL7EPCz00zXw5PfBNnIKTT+tF64gOccqj
bmjwjPGrkXfjntDp7MTbbyA7Z6aXW/QG61U8/76S1AU+TeErlCFduMePLu+I
fA3rY4SOBl86sYD/fU2BTSewpzIsq1mv8MB1VaaxQQfUZWw9oZBxUTlGO1Q3
8hI+ac4/0Hdqx9Dhnay1B9tAPTSdcaKyBVMlgcxWrRZwz3drq5ppxl7tmC6L
lGbQ9x8deerdiPWXEyNdZhogtzz2xvRviEZGGlkOpghuOWfDbShPcMctdZ1N
ZC0Ua6jweGpVWLE2df6JohIc03clrtOqwHhDH69+7QpwZZMiu4BS5Nv/1BjL
KgX+BOMG9Ww+GrXvm7v9Tz6EdDxpMRz3QII7Er+N6gkPpdKZq1cWndRrk9zn
AarL1m9Vc/763x9+leoBFU4nM9/luiOR/UGWMOAOamX0nQ1eDCSsRSvqLzCA
tTwk73kgIPHuo+u1RoBtx52LfMZtkbg2+3M5dTv0sgs/050XHXxnn1+aLaSO
zu6n5NGRqNE1lQ3QYYBZRZnyoiERb+tkmUGD1X6hzhuDrJBwVSsLbLICbi0w
bo2bING59qSthSmYmCmXJuQZI8F/LGANGsOvuTVNHt6bF92jYGdshkBeRBY3
yBAJo0hT+2ZD0NrplR0g1EWCU7hbabEG6o1RW+6tg0Rx0M0jmTowqIzbYr5P
C4lz3qcqn2tBXvSP1EciVSSIz//GWC0DsUPWL5KQhXqC+I6b0brgUnI7NpIl
kS+6yt6OpnB5alDSLZkSLtqhqcVO5LLroOQ1Rxq0aOL3DXZ7Xf4H75aFLQ==

        "]]}},
     AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
     Axes->True,
     AxesLabel->{
       FormBox["\[ScriptL]", TraditionalForm], 
       FormBox["PrNoHit", TraditionalForm]},
     AxesOrigin->{0, 0},
     BaseStyle->{FontFamily -> "Times", FontSize -> 12},
     PlotRange->{{-1, 0}, {0., 0.7429194001617361}},
     PlotRangeClipping->True,
     PlotRangePadding->{
       Scaled[0.02], 
       Scaled[0.02]}], {-1, -0.6180339887498948}, {
    Left, Bottom}, {2, 1.2360679774997896`}], InsetBox[
    GraphicsBox[{{{InsetBox[
         GraphicsBox[
          {GrayLevel[0], AbsoluteThickness[1.], Dashing[0.2], 
           LineBox[{{0, 0}, {2, 0}}]}], {0.08, 0.08}, {Left, Bottom}, {1, 1}],
         InsetBox[
         StyleBox["\<\"\[Mu]\[Rule]0.2\"\>",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0],
          BackFaceColor->GrayLevel[0],
          GraphicsColor->GrayLevel[0],
          FontFamily->"Times",
          FontColor->GrayLevel[0]], {1.21, 0.58}, {-1, 0}, Automatic, {1, 
         0}]}, {InsetBox[
         GraphicsBox[
          {GrayLevel[0], AbsoluteThickness[0.5], Dashing[0.1], 
           LineBox[{{0, 0}, {2, 0}}]}], {0.08, 1.24}, {Left, Bottom}, {1, 1}],
         InsetBox[
         StyleBox["\<\"\[Mu]\[Rule]0.1\"\>",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0],
          BackFaceColor->GrayLevel[0],
          GraphicsColor->GrayLevel[0],
          FontFamily->"Times",
          FontColor->GrayLevel[0]], {1.21, 1.74}, {-1, 0}, Automatic, {1, 
         0}]}, {InsetBox[
         GraphicsBox[
          {GrayLevel[0], AbsoluteThickness[0], Dashing[0], 
           LineBox[{{0, 0}, {2, 0}}]}], {0.08, 2.4}, {Left, Bottom}, {1, 1}], 
        InsetBox[
         StyleBox["\<\"\[Mu]\[Rule]0\"\>",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0],
          BackFaceColor->GrayLevel[0],
          GraphicsColor->GrayLevel[0],
          FontFamily->"Times",
          FontColor->GrayLevel[0]], {1.21, 2.9}, {-1, 0}, Automatic, {1, 
         0}]}}, {}},
     AspectRatio->1.0952380952380953`,
     PlotRange->{{-0.1, 3.26}, {-0.1, 3.5799999999999996`}}], {1, -0.4}, {
    Left, Bottom}, {0.5478260869565218, 0.6000000000000001}]},
  AspectRatio->Automatic,
  Background->None,
  ColorOutput->Automatic,
  ImageSize->Automatic,
  PlotRange->All]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.389732603830224*^9, 3.3897326661312237`*^9, 3.3897327017272243`*^9, 
   3.389732795698224*^9, 3.389734450970224*^9, {3.389734666471224*^9, 
   3.3897346949662237`*^9}, 3.3897350235252237`*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJztXQuQZUV5PtzX3JnZmd3ltSAIy5KE5SEPMRGIwCaCEHkIGMRCiCwsDykQ
iucmURdFi1SEYqMYjKAMIm5Ao3E1S1IECUXwEYkkRQTCmhJMGSwrCdGiQkkw
k/v9/b/63D7n9N29s1Jlpmpmzu1z+u///f/9d5++J62+6qLzL1191bvOW738
uCtWX37Ru867cvmbLrti0NTerihauxfFdtPLC1zPF4X8mS/mX3qW/uyBP2j+
RWpYRv96xaY1Rfxz+Lpi80vPtuh2u5jfeCa1XrCRPg3ausX8E+uKI/T5M4tN
g9bX1Nxr18DafNOh0ehH3PRQceAWwoqfD/dGxatLbZ3B34eK9YcrOw5oBNON
wKAFnO1RS5vIQht+/zMIYBcZnUGiWyeBUZDExODvXHGBAx+eCSjsn/FMSqIC
W6Sg/Zh6oH3AVsIW+owFBmdL8a6Q0taxoR0pY1v+BtBNkpvkNjIn7tLybWvm
6NN+mc91ZQyhcNAe6Sv33X/M8HLxm6yTQHP3CcdxUQyTwpnF+icaOd5XioKw
AaZdeEEGge+b+VwvgWYrQc5+mfC6CZxjj3MokZmLX9fjwj9dVlKz22eLfTLh
9V2b9P9JYLexloU7+JlIeLJ2nVgayN69coxeNIaDkwLTi7xMoEycr5j3HuMZ
KlegY6IsDNenxy7w3WKLe/V4RjP/daga348zjC9XuRuem1AnNVDaww/VGGsB
qBlGnXyCOoyGk6iWN5AS880ZNMCajKQU1HSbs7cTpy9r5l4zEmf76lJEMhZb
CVwuM9RmHTO2lLFTvo299n9tO8YGUnqOsUxOQCdXdaPYM+DApoHKtdjh+gRk
NHkzWsSViLsjM5fkHtpymLsQEbmUvqFNVDA3IvcSOB84UrTssjOo0NUGGFOJ
52rYOelBZKSUTc+Vlcw/R335uf0z4U1EJAbtODCzr7AzKObA3zt25o6v/n7j
Og1ZrRIfHYt3joYs9MdYvfVzrAl5pjQV9H1y5lMaLsy58ky2vt9U2c/nz4t6
KpcgEeGo+Xx6rqyvjtApZbBFiaHyQOLepNwTYl2EObCm33RSoF5Y6X6LEvp1
QM3zfbWeWHH4PofxzBLMZSKhOJTe6x45O+AXqlTs+BeX8RsoxOaNc4T7PVl9
Y7fzuYY+s4qmo3nNnO92Vui2/HubH0HXgx/71n3FknK3wF6mbkfiCB4+FX+m
Ix0KbpWf3C2B0swvWNvsKwgXNu1zP3nbh1+YnprEPfzu8tz3Hy2WRj5nIMY1
lC7f8/+SfCVKkp3tUQ89cO/PWq3WT3u97ilf/Pwn6Jntw73CV/82rQlO8E+r
xXnkVrQdlWh7Pf2dOOzrD//5Hef8zukfveTic763fM/dycHMw6UOfnZgpTMf
PvBta+bGgOX7Em2/Sn97/Rd/8vSyH/7ro1854bd+8+KPfeR6tMIEWokuS5WX
ljrLRHJDwJK86G8HQgD6mT332O3Hs7Mz16177+WU2xBEFYoU6WBmHLU+6wCd
Fp4DoLdv+MxH8enrh73+tcff9+U7JfOLEAwctEwJEWXDELz22hs+eO2XTj7x
WLh5SfAjOA+4Pm8JfFry/I8ev2HtNRe/5/r3X3n7eavPeLHfn3hw1dGHNXU/
OQge3XH1N0cfddgL09NTeH5AyiHkbZpgnBRgnHPH7Tc+uXKfvY+5/767f7hs
5x3xPJQJ7JHsqhLGCQEGWLfyyce/inGB02MHH7Qf+lx+843vC8GLQPiebzYK
8PTHLzz/HcS4QetFt97yoVUP3n+PpB+Vox8fmIjR7zv+uFV7PrP5EVD/xVNO
Pg5wFzd0f5PJAMRiSIAC8UB8aUP3Y8N9dH1ul112IlXaqaHPG+m6jyHBd2LE
X2ycw3DgHzgB490+ybLQuQs9g85gQAz88QsHjqf1/JIls0VbLJ9+lzQgs4qu
p4DMhre/7WSxBQgRiHz4qisuRF9cQzQ7NIA7OoATKYIm0qHBNf5jCPTFf3ze
sQFc8HeTMHFgICDBJlzD58FacJ8nLNWw3mCqLmoK7wRFAWyCya6JTEdg7JSU
w6/T9QyeBATBCDK5+fJ3nydEj7goV7m+mHJJHp3Dw33EJmg/AyOCi1GXd3RV
bbhWUTl+CEKTYAdIh2Dwi88knMFdqBjwS64SVE96R8Pj1+h6FmPBLMidQ8sH
Zo3PEA9EBV8HxWFBa6JfV/gfBY3XBXZgKE++mAH0DSgFdpDVdsGuSGOqqkxb
jk8btgPPQZ+CmDvAz1t4uSQwMhpdQLvfDX6I+Uh4aKcDfXh5kRF+4XZ97Emt
mIyLJwcHFITv4orFE4pPYH7gEtg61i0MWgeF+9BUJAH0iXHA+LdedMFZ5FxS
1bFxqS8XuqEqCCakutt72GO22lBOmBTWizOFdXpnSnjMZHg1Wx4Zrl31k+6c
i4JQAvWfvCIP/YSJiuGI/4CEGJt0ISSqtWdyYmXQLwlQ4L4ZZR+MQLQRnUW0
hhuDa4M/2acBOt8HZOkiax3gs88cVyZAXa3KH5UrjnEj/HJ4BJCJP+zwAv6T
8D+SYYiAoeQYRRV738TI10SsDOz1w+4dhhUfK26lZc3wPKDNuTiMhtHJ8vdX
tdCxnIL5sVbETCT3xQ4Brk0V9pAEHdcmDOaNDvZyQ5jc5HzIcQ6vBDXF9nhm
cYHqefA9lkjQZ51gjWFHzk5DGLdBtUS6wrlMScN5Tpgmwc+pwj0z2zDuYGK9
8SFbFJwr1jM6nQxvsDVbWDyprzbBIz6R9bDgJQ2nCMGwITiQ36gM3oMrrm7f
iRRgvdJEC7Vj2Dji6dzdlBC4Q6z4H0jtw07FQeMXNg2y4BJhXClK1yYwi7CN
StQx9a0El+rinF9+3tVRxUUOUKNxlZdV/MxEFfa16hBOCT1h6OhJvTv0t41e
SiXrAtxJ/FwvAaAd/krW4QFEG4wC+b0orXA2Mk062zXTyVxY9/sWdnFcChzr
QJ+h55LPMyi49JKVdyBzmeojRL4uIf9tz0EuroLElALVKtoW7E3wLOS1HvAF
GNJUOMChsI4ghGAEJXNsRYZBHiXlKNeW0PUezJMgZPnV3lyyUjsDljmyeHoN
c1eZ8ZIishQVA4sAWqPT6BRNv1vjE7xdp7x+7rQgtSDvadrRVBhXUsE6NoHu
+kw3lErL/ZBcQMEwCBhUq+mYdqNySwFjlbqfP/KjjGF912PDixEIVVSmmw9J
NqsrEIFuSq7YNhUQlhV7ydhjyCs6Cb4H6seyFjtMOEUDnX/yth3EcEkkhSGI
CkALac5eGRhtTcqR4sJHFMGR11u9a5qNlY/COKuNp9i7K4R1qeKu8Fo3hqQj
RamfroTEhxIRaCjUEcLqmIOFM6V5GRczyhOiFUrO6MlD01SN0zL48lJNhSwZ
KHjUwEw/wdo704elIjYxeKjOMmnSBVLkfSeMV5q0dQ1JLVOOio0PfhMNjGJG
Ah/gQUzpGl7a58BMHFKRqqk+yjjCjjWB6ZiXQ1IrrvegUdFwwaUJDTeklMbB
lq41w94wu3DpAQSnTmprNk/lYUezWEHBK5D24cwPzyFtgaYD9XFvRGpCl/sA
VZVp11imKAeyKMv3VQ66n7O7KDO80GNDhaWiI8sxYm+MIswA3HP1g664NAk1
ZJ51e3oafH+NZf5vuAWHiRFpJGY4mIk2chhOY6GawBhyf3M15JfDLSSEeJIg
swuIggzzAZ5dRVUD9iVDBFcyDXXhSzKY4m3VUH5qZGuq5SYXskZQnFEW5oth
eGArygXL7dnwYA8V5lwGrMWuU6tR+m8DgXkUgeD9RD4AQ41qoLwQbiHowfl7
pyhpHEEObR0kOT5QnlYNObzk0Ckv7fSMId5nsSZLKRcANRi9tXqQsCuMYoQa
Rd/UsZSjtcWOKZacXpbV84aaOAYAXmpj6GLL6dUo/UeAUq4pTpj56jxodTWU
fzeHpPk+l1zF2oU/51ZD+ZH1EFYAoousqvzMIXxWc3tHE2SahiuInoHVx3um
BVKxBUfOSkCuLxM/ZwzRZdd+7BJpYB5Qggx+4VLOVmHX1IR/YKIDfCmn8jDA
X/1bYBcFB1l80uBwjDC0cm7TG5rbsJeWxN6/aZSKZzXF5h8YtiqZSfOZZT8K
5gA0aXyYwebMURKbb10ITm0fT5FRU9f+fpAFFB9KJlVFsoEWRMBFi2jXwjEe
Xk0qkZuDjb1YPtLiPU88nwmcAPXgAgiGxjvlh4eguv+pJbXIzfKATB39P4dK
e2qtdFfPkDYCsWp439yXxo3TEiAaJwaeGzRVujrB03GX21OLn0zsv5gDRfTC
JxeUohh9Qia9+lKpqim1pxRgW1bgE8R/11Qf8UuWFCbMnSGfUw1zeYXUHnJ5
oku/0e54f6+itLpwNfcavoTJN+V+iDqULvaNV1IYhm9nvsBNIHGTbPPEkXQl
WadJlOq7yAnRLr+IjcyXrmxhl18qW/OcUHaT4Bd2zZUkXEozHmmlR/G7Jhe0
hl8jkqcCxhCJZO/g86RJCubrUpSuVPWFT5R2nTSiB2+KsNtiCaCJKy3oI2/Z
Q/TSHY+neMJy36q/qbrmn2LAtlgvqGHAd8ItyB2yJp132RjMkTKYafPnivpb
1NqatqwEn1M++mFALt0mhuQuRNTQ8ripOOiQiSqTA/vUjQ3vVLlVv4gUn0lS
XRPMXchoxJxKPrK9RCwIlOiEhxStBcKuqERky7cQMTL/EEDDaWmqMmlqokWN
fqwmlKCn0Kor8qdSG0bj2xYvZMkWAZMxQehACKEEq28xRJbsgVUKmQc88DZm
auVJCD7rNGpi2BVqAetK1V0G+q2ABhgkDwHrlOnwLBDClXIF9PLqaoy/GTCR
LBs9Kct2ZSgYall9pDpIKnRNNfhv2OMIarTsOWkS8BH7g9VQvhZ6gF2ydgAO
MC5RkPlQNZS/NTvG2BjTST7io9MG1cv3lOXysCmvOgBGSYpj5ONYjfAcFF+E
/d5qTHkKgd4SVEE7A0dVHlrjgYveQupgUeo9Ewb+oLEfV8gk0XuRmV1Jnboe
c1XhddUjfNVcjNYnpgy8Tl0ds3TH4Purwf51QBwgxA8Dk0kTK2iREt0iUw4F
dF018PtNC8BfClhsYfBAJV3f6hOfhqrff2UaBz9Dn3ZOkHBJhjMe4UyjmkWD
ICOqKIHNUsZloUFYYFTZXCBI0tlLGYktPOqnBrFNZndaAZ4yDwH2SYDp1yjw
JcKlhswg92ScdjXGXwm3ok3KTj+1XFthzO8W+LkHadSf6VLD2o2GgLzeAwRd
zqA9mOMygwFdYOtlmbjmHH9ixQhet/2SORFNIabMV0K0sjozbUqie20uHxG3
uhNEapj4hdiVUAKzyNrgoAil6zLRaThuowaTzwf195Mz8ZzFzZnqX3c0RePQ
lPXQZNj5e8l6KA64uACREmprPRpbeMxDDWr3xP6DZLHIvJruRJg07kmtW2P6
2gw3XHFcwpDrD+9FUn4nUoLT5fdrZW+hpxi3gQqAIOZRhPg95UbeoQQpDtWv
Rdwd7vrMAYwiU6PaNO9Ake0/4p3/ODFSzXLEZ8zbgEgiftqGli1WYAzTBRHq
ppJb60YbXjf4NGFPrq0tKQXdcdEfBBEaGxKwa4r5czHDJLH4y0ooYym5/0oY
/I4wCpaddO2WaZKMmaqI3IYgpHOWT6mObqNSeHgRorg9kAVc5W0aeT9WVEDU
QjIytlJ5s1BCPJH7qRpxLWRd+5cCNbeZYQM9rOfgesb8j6bCnAXJkp5E/rkE
AduiNs0EfCLcgmNWJ+4Cq7xzIWel+L3N6EOmdGcNCQtYRWYKgjOg7EBekrO5
c0f0DPoEO3dRGviTN74rgf8pBhV5jyxQtOiC1B1XC9Dcjppl4+BCln6Zjx8z
K5PFOH1ZmbmGNlggTZi/rA6EeSXFBdH4lm3lxdUCNLej5okSDxaiIMy8usW0
SFcoU7PRTQnN2hZlW0Yz1M8o1xfjtsS5IyFCdqu5ug8shXh6b4KA3HorIxEe
p42ostoF/XFbWeEOEaes4NORnd+y2JXCI7d6ynhwNgzIup+Bz0KI9vK5CaVE
G8w3KX34XCUaWbHvRuMwnApNGzhUwJEielAOssjkhjAhoeLP1OLqCqOcG/xh
oZFJYr6lnB2wW4qgQMeVhjQTukUGGWmzB9lZ7mYPTo//wHQBV6AbvGHp4KNa
1V0Z3K7cx+Eme15R5H4NhjeYlHSCMGMKpZXFDV7/srZpGEo1w/NL1mCKTHUh
ItYTSA36JOdksIODxemGrD/JNNrpBF+61YhdHzCQNEFehOBt9VAlnZrzEVAS
UcWuSNUUu+wdxnbAUA3bPhBuyRtuPpTJ5j36FNq64hABSlcIbhsRNX8S+lB1
Y52pEYRFVSG2SNkBLa89OZzQFM0Db8/ESSswT5SWz5wl17AvlK87ci4DMMR/
Fi7SJ00GZo3TmvB+ciQse0Mn+fP9mi27vx8QlLkzsAGCS8zNao8vZOo/L69E
rBo8W3PiT5iUU11BJ2HOqYNN9BJsKj+422OQ8f6It8oalK413UHclxMLPGoS
+EnHGTVRP0qKP5vhaHWzdel7E/y2G18GCbWHrkyLJDcnliw2limL2GVAprLz
BewkDdugrqlqbbA7tPuswV1cWURhSCQ3Y4JTB8ynHIjnFWdGBv1w9Qi8rgio
YDQJhHc2AywEAiUGgSU5kQo9Ug35MmMt3EQ0rWbWAjk1Thq1hdtfqwZ6aSwv
2alF9sb4QTZaNH66LHBeIYh2bM6YV5Gg5RZzAE9DxqPVqIWlSsoNYHX0ie0e
6luat3a8oCDXv6+GfKEZD8RNRz/IyxNMNJihq2isCrgv+7tVYN+uHuZ8461U
D0q87QhIqIopIpkDUkI0y76x4rGmkdrQT+XsYlNEXfdiHy4qRJj8YzXYc81p
6AEhDoTm1P9WVop3GsPgnbx2CeXCDSkCOn+qaDxZjdrZNgK6ADoYZcbQotQ7
9sU88wB3oZNSl3yqepiwiVxrf2AwkE0xIbR1RellMxip6T9Xj3BmuAVx6DsM
s+alQIWsrc+YPsm0RZchNlePcEboJpuRpTxKNLGSyAleJKBZo1m2QOD6u2Uh
n266KgKWJafCVcdUAk+JOx/DV/bUZAxvNcuSjUtAbTZWO3mnJyC1MN9cUxOH
eHcvkNNNoOzbICOVhZtCyxYltH+TMRrXN7rUpP9hHxfFLjmNDhiwBQiXndr2
vNoConiAbygyeUu1md/lkEL6RLMUYaXuWZg1/QBm8ubNTDXyePTvRkMq7zk/
b6C3wFrh4ATgqf6Z1ULe+HN+vCPFKUHy0TEg6b8Fo4bDx6cdI/sTOEFVC377
P8rVR8O08VslaiztOPOvutNhscUBuGq4aajHTALRxzMRzf12hhqWhqUsymNk
7QNC5c3y0GON7YuGnRmu/ynTwlJfcjBVjdhvmDXJeg4CCOWEroBT9gOCHRIZ
7we+4zEa8bsDamZE4RROygjkFEY9V40FjlAGe5FtDs7mZW3Y2/yTGbEhdQr/
0GlrR5q4JKoiLdveJBsn7cGuoJbivZ5W5RmeCtWdcV+jbm+w0TW5c8VSPZrM
v/efghPO6aJkHxhLyOfT6OUdM6gosgx3nF2c6/1P9QjhfMtorispu5zQp4mH
sw5J8+TMy5erR6Dze1o0tWvLlLWcC8kBPbgOxPUkKEquB6Hi9stlBTjEmCGT
ClBCuSGfhy91RySBQGTWjE6q5LrPYb6akoNM1XAlbm+JsVB7zIf9iHwMdVsR
onv4u131MHxsgbyo6AOVHEocNsChbddqOPz6vFAZ3qqgbayBDsQUABLOutmZ
zjb9ORCpMVbGmij9nGMghVcTZF7JW8UAacem6lhevKEe35W3fPBJN3wsNq8O
QUjRMYh3QhTLa5G9xYpnavzy3ubxhCh5Ad3bhZ7t4sKeqFO4HjSnzoHnYfYK
w0h9EJSpc1hs8oN1kwXxUdDRHtSmMejrL1rEMBIuZO6UsyNxBAO76nOsz/hb
c7jy7rFpyKwqiLsXRf35sOYI8DxdxaXU/8Lka16Ph0oN9ipTVHShJH+pWbos
zoBJ7ExkdVvCpbwbZSN5lXuVMUCNdok5K4wJgYBX7InxUXRZ3Gjxs3Ave04m
Lzb6U25qzozZ18xLzXVHcxPqZsPBDFv5niWnEjXohKNAo6ILBEEcXsagst92
dAdjNA6pOxjd5JhUCrYJXVc71NSsIYXzX/wkgqiZFK8wpoNyqjSw4nt19EXO
GJ3cI3KcIIYO7AmOpCNHbciiH+un+Fr8AsfgP3Av9wvZJhOiqeEJfwejuGBy
N+S76JWv0lEAIyESLRSx3tRMUYItd/3edzDDGLBixHGD8jQu/jgfBf/qV3lw
DS6EKT/adohg58zeH9JJj59bZqw4rjTBwAGSsrbowbZuGFaZ5B7R3PX483MR
D/1z3tMGC+7J+w1SdRPvSkjslOG//AKP/OhRaO5bSWsOCHPOxL63AG27KurD
04O+J5J/Ojxu5s73yq+A8tE7+FUYN4JP2FE+L98ZkOy2W2yANAthOSPRjpPR
I5r0uCd7KZISOrIsVlZ+dAIvw2BoW7XlfNgm918B3wu/cA1HJYxEyyi6aVWU
daK0/Gf7DdEuxuVPW4w3i/k8pz+0OJ3c8NKJhhnYVDClKRol9VKoz6wGz3za
EXu02nu0Tzuue5RyMee94lda4n0xgonRbrspUseOVcOajPBAi/8s3y935xBZ
cdG5n0lTZ0gWNq7bvCzi9/41kGnBKSIpCgwTaZL4mbvGREo7Yl/B+8EdrkNL
HdXfCflKoCeMNeXiCJ7179ZENP3cSCokvE1E4c00N5hvwG9xRGKkZTp2iUQX
4mMvNHxI3kKKLcBYVqS28K93rx0csWYALzITT6+kC+Wd2glv4nnkip3lrcr4
CefcTrs+w5XJUekNvF7qxjE46rWGZCe02vjDW4bT5/bKj89z8+Taibzo4Dp1
4O1cFrn+yzXdTqmuUrZ+TQpLo2o6E/PU9/7mSaRTthj9HnGfi66Z64wBO6+7
efYxtMuLX850XpnAxdgFa1DsGuJkz/ddM4xdKqeRBNxbXi+lgVFcTGygi1MG
b2gtHSiRr3Q1M/A+0X+335VRWBi+P1pyV2z3f7PUREI=\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dependence on \[Sigma]", "Subsubsection",
 CellChangeTimes->{{3.3897325935512238`*^9, 3.389732596891224*^9}}],

Cell["\<\
When \[Sigma] increases, the probability of no hit decreases:\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"PrNoHit", "[", 
              RowBox[{"\[ScriptL]", ",", "0", ",", "\[Sigma]"}], "]"}], "/.", 
             "\[InvisibleSpace]", 
             SubscriptBox["Pr", "Rules"]}], "/.", "\[InvisibleSpace]", 
            SubscriptBox["S", "Rule"]}], "/.", "\[InvisibleSpace]", 
           SubscriptBox["Normal", "Rules"]}], "/.", "\[InvisibleSpace]", 
          RowBox[{"\[Sigma]", "\[Rule]", "#1"}]}], "&"}], ")"}], "/@", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "4"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[ScriptL]", ",", 
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "lineStyles"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\[ScriptL]", ",", "PrNoHit"}], "}"}]}], ",", 
     RowBox[{"BaseStyle", "\[Rule]", "baseStyle"}]}], "]"}]}], ";"}]], "Input",\

 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.3897227682482243`*^9, {3.389732861787224*^9, 3.389732877089224*^9}, {
   3.389732937857224*^9, 3.3897329387812243`*^9}, 3.389732971924224*^9, 
   3.389734397902224*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"legendText", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Style", "[", 
      RowBox[{
       RowBox[{"\"\<\[Sigma]=\>\"", "<>", 
        RowBox[{"ToString", "[", "#", "]"}]}], ",", "Black", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}]}], "]"}], "&"}], 
    " ", "/@", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "4"}], "}"}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389620914783*^9, 3.3896209204820004`*^9}, {
   3.389620988039*^9, 3.389621025764*^9}, 3.389621081079*^9, 
   3.389621619785*^9, {3.389732359838224*^9, 3.389732441608224*^9}, {
   3.3897329168262243`*^9, 3.3897329247672243`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"legendEntries", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"legendLines", ",", "legendText"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389621033892*^9, 3.3896210839779997`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShowLegend", "[", 
  RowBox[{"p2", ",", 
   RowBox[{"{", 
    RowBox[{"legendEntries", ",", 
     RowBox[{"LegendPosition", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", ".4"}]}], "}"}]}], ",", 
     RowBox[{"LegendSize", "\[Rule]", "0.6"}], ",", 
     RowBox[{"LegendShadow", "\[Rule]", "None"}]}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896199844309998`*^9, 3.389619996865*^9}, {
  3.389621094799*^9, 3.389621098097*^9}, {3.389621182734*^9, 
  3.389621187608*^9}, {3.3896212580950003`*^9, 3.389621276164*^9}, {
  3.389621319869*^9, 3.3896213638640003`*^9}, {3.3896216388050003`*^9, 
  3.3896216436809998`*^9}, {3.3897325365432243`*^9, 3.389732547526224*^9}, {
  3.389732950324224*^9, 3.389732950436224*^9}}],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    GraphicsBox[{{}, {}, 
      {GrayLevel[0], AbsoluteThickness[0], Dashing[0], 
       LineBox[CompressedData["
1:eJwVlHs01AkUx3+i9ehhqD2MR+z2IFQYIa87hsijBkubzSmVmpPJq6dd1kpb
oeOg0FazJZvNIE27Kq/tjoxnsxOR92PMyxBGJxOJ7Owf93zP53z+uN9z/7jf
HI0LOb6CIIh9qvk/b5qtUi4vK7DAc5Z1s1cKVYt6vOQlBboYngiM7JFCb5/h
jU8LKp/FEFt2S8Eob4vdB6UCr+8nt1R3SoGlRYuRvVOg90XnU/0CKRS+T5Ty
exQY5cAwM2iUQmmD7O2txwr0aS22S3kihTrGy2eUwwpcy3ygqZ4pheiJlUoh
Zxptf6N3GFKkoCt0yjReO40RUznyEKEEBnaK0q7GTmF0QOk2dpYE7JoM50/V
T2Jo4Z6QvfYS+LnVnTdiNomTz+mN5wbEEKKpWM2Pf4feQxnWRUlioBcbVo/z
JlDjh3W5XcZioD2zrcvbNIFG7mSegisCVHvrWn1+HH/qi9hXFSECey5Dn9kl
R858kcm9pVHgD58O3LdTjqXGIbUf747CjJOOeln6GDqUFYrKHUdBRyOHlD8m
w/lVvgelnUKo0Cm6Pe8sw2QFW+7OEMKPCTbpWVlSdAjqsFpWjoBLQDH/8ZQE
Kzf200K3jsDlw6VZAVQJmhu06kXuGYYm2e/FZ++K8X0j8ajszBDklpi6GChE
uPrvvVNemYNwqe1r+3c0EY55Mdc6FQ0A8/BiamDRKHKe6ybsbO6Hoe1xgRaz
QvTLaNRc19MHuxPaY7ODhRghqK84OdsLbIvQ8eCoESxMOFP5cV0vDIyaTV/Q
GUZWj/i+9oYeWLjYUljVPIihvzbGhDp2g83NjMDJkwOo55tkJ3R+C+WnXDFN
vx9bZIeSWty7gGzZNkJ504up10fJD4I74daBhE8953tw5r7fwhX6G/gqTskt
sO/G9W52Bg0RHVC/O5peNduFrP1qlyxi2iEnd66bf6cTOeaenEGBAAIajqxe
DH+DguV/GUwxH8jREpcNS+04k33tecarNiiZurr9WexrTNROtzrR1QJ1Vy3P
KRV8tL1mt6tW0gQfVy08MnJtQ67N63xWCw+0Iy7TzlU2Y68WuyZK8BK8Cjxb
n87xkNSewax7yAWj4JGhWt+XmMwyzbyg/w/kPY5hTV9DJP0imD5mXA2euSlH
7ExqMH5y7uznV5VQqKM+PKz1FElU+kR5AwdcLvufN9DlYGSHKG8Niw3UkjGp
U0gxztOjSI1q90E4QWPZpBRgkNJx69L7XAgX1DSbib2RKKyjHCulQsX4+NyN
bBUbHqHUMKigsZJsqeWm4oIv9nqbqcBxvZA+k+eFBMk/KgUAtNgUv3ofGhKD
uyMdrdwhVjM8vzEUkKDOhf257AxWp93uBIgdkBAKdl0ptYXuktufKW4qzmly
cthsC2kj8wdN8ilIcGOZPNgBfYFPTaZ87JFI1TmWbLUNSPQIN9OwHSrmBE8u
WwK/Gmh/iDchUULexi81h00WiyvO5m9EIp4XFEQ1g6S8qgZv32+RsN3jq2Vt
CqHDRzP5YWaqPtYOiQQZdP18ckIk61X7EtccKCPBi42oN+urj0RkvKa5zRro
X4zbYv29ruoeog/ZatqQz/jO5olUQ+XZ/LhyAmS7Mg/Jw5dfqL7VaVT/5FH0
ICYqVj6r4of+9ypmPGo3FHXJpyQviNQMny9/CT38j8s7uONhKk8kKZKCPf4D
IxKCoA==
        "]]}, 
      {GrayLevel[0], AbsoluteThickness[0.5], Dashing[0.01], 
       LineBox[CompressedData["
1:eJwVz3k41AkYB/BfmsLI0WwbWlelKCpHpWXyDsnRzCZDT2yeLW0eXcZVUqyo
5GgtnoZW2fIoNeTskVz1jvv6bU2TYSrHYNzHqCXHkp39433e5/N83+d9n3fj
qQC2rwJBEIfl9X+/q68ys7wsw9ni76I7osVQtri2LmJJhgzNjD9pUWIQf9C6
M78gw84Ddk9/ihTDBu5W839mZMhSkebUXhVDhpK9/+CYDJ2X0x0KQ8SQ+Tls
gOyQofISXXDTVwy5tYOi9EIZku6qDttcxFDlV1NqeUKGXA2/ymMaYjg3umpG
UjSJxt5nyvK5HaAusUr4QW0SO9Xx5CODDvi0p+96LGcCybTHfZ4F7WDeoDV3
oXocx/kNtBbzdviteX9dj/446kREsRReiYCtKFtDBo7hmdu963r3i8A1W6t8
pG4UcdHl2zV+G9iXmlVxDUfRoML47RpmG+AKkU156AhunFc22db6Hiz4frTz
bcO47ndup5P7eyC7g1mH9wxjhLNakmuXEKasqCufxQ1hoMjUX+gtBColWSN1
aBBffs3XC5e+gwJq1r25fYNI93SL+8PnHVwJMo1LTBxAw2uxskSJAKyZ2WTh
hBQFIcukyE8AMSdyE5kMKR4R3RmbbHoLDYN/ZV980I96tz5XDQnfQApP11pT
1ocC6vmzVxr/hhst31uM2fdhcl08ez2fhPMnFqNYWb34RkP5Ca+5Fbp2BrCM
piVIC2xUq3jVAgeDBJwkNwnu1WTW99U0Q46Rx4jb6R7cJIpJ+Jlsgk+9+pOX
qd0YzOe00PmNsBDdlFnW2Ik8K8F9Tn0DmN6NZ42f/YST8eWhCyX1kHfBBq/T
PiLvSaWzlFcH2sYtPZZCMXouVmq6F9RCumfQfEdoB0rErSz1BzWwOmCGn2bR
jpKEvRT/h9VQffCca9l0G8ZZWbf6ZPMhOWW2nbz/Hh1WW8bsM0Fg1vqsWfQS
YhElks3c9Qq0z0mt9ZYEKLmnn9elWAm8ididpZy3SO9K8WVQyqEq1vjSjIxE
wYMLKpuoL+GrykL+BpsWPBm/PuSmtASUvWPsL5U0YqCBE1L6n8OBNLvmF7N1
KPny+qZiaRFscOvpqnSqQX6x6QRnSz5wC/0zJm8jekp0rdKMcsAuJdLHXKcC
m6ga7CHhY8ikruzuVnqBYSof5piNmWAdcyhUU70IGQGqNKeH6cDgDQ1YsbPR
LE/4tFQhBSSj9hmmkWl4skZb0+FLNHi9qWjU73dAgjJl92uuGRSMjMzeSZKb
P86o8DMDyiptYyW63CVDsHaLGRTZXI6b4h5AgigOj4RdoJRj6VLtaC+fZ4Xs
3b4DOIpeqfUegETZF58ny8awPZh+n9m/G4mm4/tv5RpAO+/ev5Z0uYcJm91b
DOB6z9xxnVRLJIqcg+pAHz6wXuhMOFogEUj6RWzXBQ1Xb7ru0V1IRBV6jC9r
AVkO9o/6DeX3l3aQuRpgaLSocDF1s9w27CMMdQjnltU6OG1CIjPMWclEFTy6
TyWQR/Xl+djuMEIZ1F0ck9nSdfJ9xaqezwh4vRnXTjvRkGBUKRqYLtl+XAzY
anJMXf4PbTppxbxtqp+7afEARZ6/JAPypmwHf0z4Zdhr+TVBqAXjyhHbrMf+
pznD03LnHnpYILGt1MtqG56Qyn3b8dtzge0h3+F3/JGjchNXZeF2tv8Bq3V/
XA==
        "]]}, 
      {GrayLevel[0], AbsoluteThickness[1.], Dashing[0.02], 
       LineBox[CompressedData["
1:eJwVzns01AkUB/CfRyXSDFvrlWa2p5UtDMsazWUwNhwk2mydJavDqoittIft
qF0lbRtFeskcSx55TIpmJHcw5tGZ3VRClBl5zXgN21iPprW//eOeez7ne+49
389iksIO6RMEEUzO/7uAZjK7tKTBrGBW6HNfGfB1ZqL0jxqUip+PKtgy6Hlt
eXVhUYPfXtGmT3nJwDpvi9P7WQ0m9qmKTHbK4LYR++jIOOmduVI/VxlwZ04N
y7s1SP11Zalgswwq20Ze3ajVoOP+3otFy2XQFNfawIjSYH+qmU2sVAoJY8tm
lbwpjO6VBYZ7S4GidMu2WT2FvJgPo5Q2CfS5vjt7PnES63oOzdH9JeAktpw/
0jKB9Ch1a5ZQDD/LdooUtAlU6qWZSdhiCFuhWSU/No7uo/TqvY3tEFJqKVCL
xpAfUB3h6dIO7AbHprxNY0h3/zTY4JEIUO8VU3BSjdE2eyRrd4jAWRhnfrhT
hdQaQ3cKrw3k/SlBwa4qvNLcvTyB0QbTbsYG97JGsbmrzNOkqhWMDXOo+aMj
KFYsmhd+0Qo1xsU3591H0Gu+5PPkkhb4Kdkh69KlYbQ/90tLmW0LeASWymsn
hzAj1C2wp0gImVGVlwK9hpBfNTjEsRCCeKSw9PidQeyAO1XxOxByy209LDTv
kFc2oC+wboZfnq51Hme/Q+5ex8NvjJ/A4ShdRlDxAHbYlcavNm2Ct9uTgrZq
lUjVBWTXLjSCX3JH4uXdSvRtNXGInxdAxdZw9e5YBXKLtzUu0/Ghb4A2lWrc
j45x0XGmY49g8YyUy5e8wdCYHA/mWAM4FFwImvihD3VZUtqzznqoOsLEs+a9
yCt4sjJI9BCs7J4qGC960OVJ5pCu/QHc2Je80H2yG48JN0ipdXWwPGlWeM25
C6d7fGaiePehxS8hhK/tRN57iz/vPuBBTu5cl/zWS1RVrGkqZNdCYNvBVbrI
F3idc6IgjV0NVglDHus/duA8r5uwsrgH5ZPntzckPkOu256FUGoFNJ23OzGr
kSN9hvnht0/K4B+TxWpr5lMUtpkuZo2XwMoDmewTDyUYvW+RxlAVg881b1n9
nAjtalKxUMAF692Kt4/9WzGjUOztaF8IebVHb09dRBTSbY+X2N8A79zTB53W
NaJQztEUd+YB19igv9+oHqf1XmoZ0hzwyAw4aUHhodI7//e13AvgVT467BZW
ivS8H83e658B5Rj7tsPpa+gVMvAi4u9kiPyrUUIb9EVCme73fSUdatTquauX
SXNDfBvj6GC4zMrOyJM0scHHbDMdeMzUrOk8HySE2WdOAw2MKhi7WjhsJDJW
n/rS3hYSV0Tmt4cDEjkzsXeXLME+xfNW4KALeQ+sc5VU6Cq/+YHhSTrjGdNl
MxXOKub3r8tnkDmmiIACr4Pq101ynMk+uvh0e1OghhzwtI3YgQQ9KWJiyQjk
AmD/MbiJzF23yysJ2LRVp388fyPZ53pYqNcSKy2P3+brv4H81/610baPrPD+
mGx5BI20jespYoFF2cXJCRtaQ1pouu/eNKt5I5pp/c1Jd6ygO0yyenVJW7Z9
QyH7rdde1lOz8uP2ONwfNiT9WJ5UpWSNfJX9nSpyqZkgzFLQ4DWruORobKJK
S7oqoKimg/V4fXGnanKIdDbn3zohK+CQ6rlQHUGaSNekObH+A6Cxe7A=
        "]]}},
     AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
     Axes->True,
     AxesLabel->{
       FormBox["\[ScriptL]", TraditionalForm], 
       FormBox["PrNoHit", TraditionalForm]},
     AxesOrigin->{0, 0},
     BaseStyle->{FontFamily -> "Times", FontSize -> 12},
     PlotRange->{{-1, 0}, {0., 0.6826894822607297}},
     PlotRangeClipping->True,
     PlotRangePadding->{
       Scaled[0.02], 
       Scaled[0.02]}], {-1, -0.6180339887498948}, {
    Left, Bottom}, {2, 1.2360679774997896`}], InsetBox[
    GraphicsBox[{{{InsetBox[
         GraphicsBox[
          {GrayLevel[0], AbsoluteThickness[1.], Dashing[0.2], 
           LineBox[{{0, 0}, {2, 0}}]}], {0.08, 0.08}, {Left, Bottom}, {1, 1}],
         InsetBox[
         StyleBox["\<\"\[Sigma]=4\"\>",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0],
          BackFaceColor->GrayLevel[0],
          GraphicsColor->GrayLevel[0],
          FontFamily->"Times",
          FontColor->GrayLevel[0]], {1.21, 0.58}, {-1, 0}, Automatic, {1, 
         0}]}, {InsetBox[
         GraphicsBox[
          {GrayLevel[0], AbsoluteThickness[0.5], Dashing[0.1], 
           LineBox[{{0, 0}, {2, 0}}]}], {0.08, 1.24}, {Left, Bottom}, {1, 1}],
         InsetBox[
         StyleBox["\<\"\[Sigma]=2\"\>",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0],
          BackFaceColor->GrayLevel[0],
          GraphicsColor->GrayLevel[0],
          FontFamily->"Times",
          FontColor->GrayLevel[0]], {1.21, 1.74}, {-1, 0}, Automatic, {1, 
         0}]}, {InsetBox[
         GraphicsBox[
          {GrayLevel[0], AbsoluteThickness[0], Dashing[0], 
           LineBox[{{0, 0}, {2, 0}}]}], {0.08, 2.4}, {Left, Bottom}, {1, 1}], 
        InsetBox[
         StyleBox["\<\"\[Sigma]=1\"\>",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0],
          BackFaceColor->GrayLevel[0],
          GraphicsColor->GrayLevel[0],
          FontFamily->"Times",
          FontColor->GrayLevel[0]], {1.21, 2.9}, {-1, 0}, Automatic, {1, 
         0}]}}, {}},
     AspectRatio->1.0952380952380953`,
     PlotRange->{{-0.1, 3.26}, {-0.1, 3.5799999999999996`}}], {1, -0.4}, {
    Left, Bottom}, {0.5478260869565218, 0.6000000000000001}]},
  AspectRatio->Automatic,
  Background->None,
  ColorOutput->Automatic,
  ImageSize->Automatic,
  PlotRange->All]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389732958921224*^9, 3.389734451486224*^9, 
  3.389734666946224*^9, 3.3897347189402237`*^9, 3.389735024014224*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Distribution of terminal price given no execution: ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["p", 
    RowBox[{"t", "+", "\[CapitalDelta]t"}]], "=", 
   RowBox[{
    SubscriptBox["p", "t"], "+", "\[Delta]"}]}]]],
 ":"
}], "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["f\[Delta]", "Rule"], "=", 
   RowBox[{
    RowBox[{"f\[Delta]", "[", 
     RowBox[{
     "\[Delta]_", ",", "\[ScriptL]_", ",", "\[Mu]_", ",", "\[Sigma]_"}], 
     "]"}], "\[RuleDelayed]", 
    RowBox[{"g", "[", 
     RowBox[{
      RowBox[{"-", "\[Delta]"}], ",", "1", ",", 
      RowBox[{"-", "\[Mu]"}], ",", "\[Sigma]", ",", 
      RowBox[{"-", "\[ScriptL]"}]}], "]"}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell["Plots for various limit orders ...", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"p3", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"f\[Delta]", "[", 
               RowBox[{"\[Delta]", ",", "\[ScriptL]", ",", "0", ",", "1"}], 
               "]"}], "/.", "\[InvisibleSpace]", 
              SubscriptBox["f\[Delta]", "Rule"]}], "/.", "\[InvisibleSpace]", 
             
             SubscriptBox["g", "Rule"]}], "/.", "\[InvisibleSpace]", 
            SubscriptBox["S", "Rule"]}], "/.", "\[InvisibleSpace]", 
           SubscriptBox["Normal", "Rules"]}], "/.", "\[InvisibleSpace]", 
          RowBox[{"\[ScriptL]", "\[Rule]", "#1"}]}], "&"}], ")"}], "/@", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "0.5`"}], ",", 
         RowBox[{"-", "0.1`"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Delta]", ",", 
       RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "lineStyles"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\[Delta]", ",", "\"\<f(\[Delta]|No Hit)\>\""}], "}"}]}], ",", 
     
     RowBox[{"BaseStyle", "\[Rule]", "baseStyle"}]}], "]"}]}], ";"}]], "Input",\

 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.389722805472224*^9, {3.389732998655224*^9, 3.389733000905224*^9}, {
   3.389733206912224*^9, 3.389733208596224*^9}, 3.389733295185224*^9, 
   3.389734404431224*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"legendText", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Style", "[", 
      RowBox[{
       RowBox[{"ToString", "[", "#", "]"}], ",", "Black", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}]}], "]"}], "&"}], 
    " ", "/@", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "0.5`"}], ",", 
      RowBox[{"-", "0.1`"}]}], "}"}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389620914783*^9, 3.3896209204820004`*^9}, {
   3.389620988039*^9, 3.389621025764*^9}, 3.389621081079*^9, 
   3.389621619785*^9, {3.389732359838224*^9, 3.389732441608224*^9}, {
   3.3897329168262243`*^9, 3.3897329247672243`*^9}, {3.389733181488224*^9, 
   3.3897331962812243`*^9}, {3.3897332476832237`*^9, 3.389733248785224*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"legendEntries", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"legendLines", ",", "legendText"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389621033892*^9, 3.3896210839779997`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShowLegend", "[", 
  RowBox[{"p3", ",", 
   RowBox[{"{", 
    RowBox[{"legendEntries", ",", 
     RowBox[{"LegendPosition", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", ".4"}]}], "}"}]}], ",", 
     RowBox[{"LegendSize", "\[Rule]", "0.6"}], ",", 
     RowBox[{"LegendShadow", "\[Rule]", "None"}], ",", 
     RowBox[{"LegendLabel", "\[Rule]", "\"\<\[ScriptL]\>\""}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896199844309998`*^9, 3.389619996865*^9}, {
  3.389621094799*^9, 3.389621098097*^9}, {3.389621182734*^9, 
  3.389621187608*^9}, {3.3896212580950003`*^9, 3.389621276164*^9}, {
  3.389621319869*^9, 3.3896213638640003`*^9}, {3.3896216388050003`*^9, 
  3.3896216436809998`*^9}, {3.3897325365432243`*^9, 3.389732547526224*^9}, {
  3.389732950324224*^9, 3.389732950436224*^9}, {3.389733230014224*^9, 
  3.389733261329224*^9}}],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    GraphicsBox[{{}, {}, 
      {GrayLevel[0], AbsoluteThickness[0], Dashing[0], 
       LineBox[CompressedData["
1:eJwV13c8Vf8fB3BSKiJEskrDCpUyynpLxtfIzCjZZFSIaFCEjCJECd8yQ3Zc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        "]]}, 
      {GrayLevel[0], AbsoluteThickness[0.5], Dashing[0.01], 
       LineBox[CompressedData["
1:eJwV1nc8Vf8fB3CrYWRUFCkhyiojpPBGoRBltYxKKTN7VIgUlU3Dygp9JVLI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        "]]}, 
      {GrayLevel[0], AbsoluteThickness[1.], Dashing[0.02], 
       LineBox[CompressedData["
1:eJwV13k0VtsbB3A0CCVDknkIiRINQrpPISIlkiFDpERCtwwZIiXcilR0yZB0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        "]]}},
     AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
     Axes->True,
     AxesLabel->{
       FormBox["\[Delta]", TraditionalForm], 
       FormBox["\"f(\[Delta]|No Hit)\"", TraditionalForm]},
     AxesOrigin->{0, 0},
     BaseStyle->{FontFamily -> "Times", FontSize -> 12},
     PlotRange->{{-1, 2}, {-0.5990888644649357, 0.605521237719339}},
     PlotRangeClipping->True,
     PlotRangePadding->{
       Scaled[0.02], 
       Scaled[0.02]}], {-1, -0.6180339887498948}, {
    Left, Bottom}, {2, 1.2360679774997896`}], InsetBox[
    GraphicsBox[{{{InsetBox[
         GraphicsBox[
          {GrayLevel[0], AbsoluteThickness[1.], Dashing[0.2], 
           LineBox[{{0, 0}, {2, 0}}]}], {0.08, 0.08}, {Left, Bottom}, {1, 1}],
         InsetBox[
         StyleBox["\<\"-0.1\"\>",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0],
          BackFaceColor->GrayLevel[0],
          GraphicsColor->GrayLevel[0],
          FontFamily->"Times",
          FontColor->GrayLevel[0]], {1.21, 0.58}, {-1, 0}, Automatic, {1, 
         0}]}, {InsetBox[
         GraphicsBox[
          {GrayLevel[0], AbsoluteThickness[0.5], Dashing[0.1], 
           LineBox[{{0, 0}, {2, 0}}]}], {0.08, 1.24}, {Left, Bottom}, {1, 1}],
         InsetBox[
         StyleBox["\<\"-0.5\"\>",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0],
          BackFaceColor->GrayLevel[0],
          GraphicsColor->GrayLevel[0],
          FontFamily->"Times",
          FontColor->GrayLevel[0]], {1.21, 1.74}, {-1, 0}, Automatic, {1, 
         0}]}, {InsetBox[
         GraphicsBox[
          {GrayLevel[0], AbsoluteThickness[0], Dashing[0], 
           LineBox[{{0, 0}, {2, 0}}]}], {0.08, 2.4}, {Left, Bottom}, {1, 1}], 
        InsetBox[
         StyleBox["\<\"-1\"\>",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0],
          BackFaceColor->GrayLevel[0],
          GraphicsColor->GrayLevel[0],
          FontFamily->"Times",
          FontColor->GrayLevel[0]], {1.21, 2.9}, {-1, 0}, Automatic, {1, 
         0}]}}, InsetBox["\<\"\[ScriptL]\"\>", {1.58, 3.9799999999999995`}, \
{0, 0}]},
     AspectRatio->1.392857142857143,
     PlotRange->{{-0.1, 3.26}, {-0.1, 4.58}}], {1, -0.4}, {
    Left, Bottom}, {0.4307692307692308, 0.6000000000000001}]},
  AspectRatio->Automatic,
  Background->None,
  ColorOutput->Automatic,
  ImageSize->Automatic,
  PlotRange->All]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389732958921224*^9, 3.389733232679224*^9, 
  3.3897332768262243`*^9, 3.389734667544224*^9, 3.389735024594224*^9}]
}, Open  ]],

Cell["\<\
When \[Mu] increases, the distribution shifts to the right\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"p4", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"f\[Delta]", "[", 
               RowBox[{"\[Delta]", ",", 
                RowBox[{"-", "0.5`"}], ",", "\[Mu]", ",", "1"}], "]"}], "/.", 
              "\[InvisibleSpace]", 
              SubscriptBox["f\[Delta]", "Rule"]}], "/.", "\[InvisibleSpace]", 
             
             SubscriptBox["g", "Rule"]}], "/.", "\[InvisibleSpace]", 
            SubscriptBox["S", "Rule"]}], "/.", "\[InvisibleSpace]", 
           SubscriptBox["Normal", "Rules"]}], "/.", "\[InvisibleSpace]", 
          RowBox[{"\[Mu]", "\[Rule]", "#1"}]}], "&"}], ")"}], "/@", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "4"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Delta]", ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", "4"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "lineStyles"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\[Delta]", ",", "\"\<f(\[Delta]|No Hit)\>\""}], "}"}]}], ",", 
     
     RowBox[{
     "PlotLabel", "\[Rule]", "\"\<Limit price position \[ScriptL]=-1/2\>\""}],
      ",", 
     RowBox[{"BaseStyle", "\[Rule]", "baseStyle"}]}], "]"}]}], ";"}]], "Input",\

 CellLabelAutoDelete->True,
 CellChangeTimes->{
  3.389722850402224*^9, {3.389733322486224*^9, 3.389733340786224*^9}, 
   3.389734412961224*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"legendText", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Style", "[", 
      RowBox[{
       RowBox[{"ToString", "[", "#", "]"}], ",", "Black", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}]}], "]"}], "&"}], 
    " ", "/@", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "4"}], "}"}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389620914783*^9, 3.3896209204820004`*^9}, {
   3.389620988039*^9, 3.389621025764*^9}, 3.389621081079*^9, 
   3.389621619785*^9, {3.389732359838224*^9, 3.389732441608224*^9}, {
   3.3897329168262243`*^9, 3.3897329247672243`*^9}, {3.389733181488224*^9, 
   3.3897331962812243`*^9}, {3.3897332476832237`*^9, 3.389733248785224*^9}, 
   3.389733364196224*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"legendEntries", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"legendLines", ",", "legendText"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389621033892*^9, 3.3896210839779997`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShowLegend", "[", 
  RowBox[{"p4", ",", 
   RowBox[{"{", 
    RowBox[{"legendEntries", ",", 
     RowBox[{"LegendPosition", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", ".4"}]}], "}"}]}], ",", 
     RowBox[{"LegendSize", "\[Rule]", "0.6"}], ",", 
     RowBox[{"LegendShadow", "\[Rule]", "None"}], ",", 
     RowBox[{"LegendLabel", "\[Rule]", "\"\<\[Mu]\>\""}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896199844309998`*^9, 3.389619996865*^9}, {
  3.389621094799*^9, 3.389621098097*^9}, {3.389621182734*^9, 
  3.389621187608*^9}, {3.3896212580950003`*^9, 3.389621276164*^9}, {
  3.389621319869*^9, 3.3896213638640003`*^9}, {3.3896216388050003`*^9, 
  3.3896216436809998`*^9}, {3.3897325365432243`*^9, 3.389732547526224*^9}, {
  3.389732950324224*^9, 3.389732950436224*^9}, {3.389733230014224*^9, 
  3.389733261329224*^9}, {3.3897333688402243`*^9, 3.389733373110224*^9}}],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    GraphicsBox[{{}, {}, 
      {GrayLevel[0], AbsoluteThickness[0], Dashing[0], 
       LineBox[CompressedData["
1:eJwV13c8Vf8fB3DZ696rUpIRaVglpWt7f4okexPK+NqrjCgrRBQZqYzslJFV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        "]]}, 
      {GrayLevel[0], AbsoluteThickness[0.5], Dashing[0.01], 
       LineBox[CompressedData["
1:eJwV13k0Ve0XB3BDZLouUsZImqSkyVh9j1IJyVAaRGXMS5QU3UTGCBUVJRJe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        "]]}, 
      {GrayLevel[0], AbsoluteThickness[1.], Dashing[0.02], 
       LineBox[CompressedData["
1:eJwV13k0VV8bB3AypHLvRYNIZErSQIUMnecYkkwhcxkyhlJkijKTUIaEZJYI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        "]]}},
     AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
     Axes->True,
     AxesLabel->{
       FormBox["\[Delta]", TraditionalForm], 
       FormBox["\"f(\[Delta]|No Hit)\"", TraditionalForm]},
     AxesOrigin->{0, 0},
     BaseStyle->{FontFamily -> "Times", FontSize -> 12},
     PlotLabel->FormBox[
      "\"Limit price position \[ScriptL]=-1/2\"", TraditionalForm],
     PlotRange->NCache[{{
         Rational[-1, 2], 4}, {0., 0.5822111420458796}}, {{-0.5, 4}, {0., 
        0.5822111420458796}}],
     PlotRangeClipping->True,
     PlotRangePadding->{
       Scaled[0.02], 
       Scaled[0.02]}], {-1, -0.6180339887498948}, {
    Left, Bottom}, {2, 1.2360679774997896`}], InsetBox[
    GraphicsBox[{{{InsetBox[
         GraphicsBox[
          {GrayLevel[0], AbsoluteThickness[1.], Dashing[0.2], 
           LineBox[{{0, 0}, {2, 0}}]}], {0.08, 0.08}, {Left, Bottom}, {1, 1}],
         InsetBox[
         StyleBox["\<\"4\"\>",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0],
          BackFaceColor->GrayLevel[0],
          GraphicsColor->GrayLevel[0],
          FontFamily->"Times",
          FontColor->GrayLevel[0]], {1.21, 0.58}, {-1, 0}, Automatic, {1, 
         0}]}, {InsetBox[
         GraphicsBox[
          {GrayLevel[0], AbsoluteThickness[0.5], Dashing[0.1], 
           LineBox[{{0, 0}, {2, 0}}]}], {0.08, 1.24}, {Left, Bottom}, {1, 1}],
         InsetBox[
         StyleBox["\<\"1\"\>",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0],
          BackFaceColor->GrayLevel[0],
          GraphicsColor->GrayLevel[0],
          FontFamily->"Times",
          FontColor->GrayLevel[0]], {1.21, 1.74}, {-1, 0}, Automatic, {1, 
         0}]}, {InsetBox[
         GraphicsBox[
          {GrayLevel[0], AbsoluteThickness[0], Dashing[0], 
           LineBox[{{0, 0}, {2, 0}}]}], {0.08, 2.4}, {Left, Bottom}, {1, 1}], 
        InsetBox[
         StyleBox["\<\"0\"\>",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0],
          BackFaceColor->GrayLevel[0],
          GraphicsColor->GrayLevel[0],
          FontFamily->"Times",
          FontColor->GrayLevel[0]], {1.21, 2.9}, {-1, 0}, Automatic, {1, 
         0}]}}, InsetBox["\<\"\[Mu]\"\>", {1.58, 3.9799999999999995`}, \
{0, 0}]},
     AspectRatio->1.392857142857143,
     PlotRange->{{-0.1, 3.26}, {-0.1, 4.58}}], {1, -0.4}, {
    Left, Bottom}, {0.4307692307692308, 0.6000000000000001}]},
  AspectRatio->Automatic,
  Background->None,
  ColorOutput->Automatic,
  ImageSize->Automatic,
  PlotRange->All]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389732958921224*^9, 3.389733232679224*^9, 
  3.3897332768262243`*^9, 3.389733379441224*^9, 3.389734668002224*^9, 
  3.389735025089224*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
When \[Sigma] increases, the distribution also shifts upwards\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"p5", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"f\[Delta]", "[", 
               RowBox[{"\[Delta]", ",", 
                RowBox[{"-", "0.5`"}], ",", "0", ",", "\[Sigma]"}], "]"}], "/.",
               "\[InvisibleSpace]", 
              SubscriptBox["f\[Delta]", "Rule"]}], "/.", "\[InvisibleSpace]", 
             
             SubscriptBox["g", "Rule"]}], "/.", "\[InvisibleSpace]", 
            SubscriptBox["S", "Rule"]}], "/.", "\[InvisibleSpace]", 
           SubscriptBox["Normal", "Rules"]}], "/.", "\[InvisibleSpace]", 
          RowBox[{"\[Sigma]", "\[Rule]", "#1"}]}], "&"}], ")"}], "/@", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "4"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Delta]", ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", "2"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "lineStyles"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\[Delta]", ",", "\"\<f(\[Delta]|No Hit)\>\""}], "}"}]}], ",", 
     
     RowBox[{
     "PlotLabel", "\[Rule]", "\"\<Limit price position \[ScriptL]=-1/2\>\""}],
      ",", 
     RowBox[{"BaseStyle", "\[Rule]", "baseStyle"}]}], "]"}]}], ";"}]], "Input",\

 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3897228877092237`*^9, 3.3897228884912243`*^9}, {
   3.389733400726224*^9, 3.389733435093224*^9}, 3.389734421411224*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"legendText", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Style", "[", 
      RowBox[{
       RowBox[{"ToString", "[", "#", "]"}], ",", "Black", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}]}], "]"}], "&"}], 
    " ", "/@", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "4"}], "}"}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389620914783*^9, 3.3896209204820004`*^9}, {
   3.389620988039*^9, 3.389621025764*^9}, 3.389621081079*^9, 
   3.389621619785*^9, {3.389732359838224*^9, 3.389732441608224*^9}, {
   3.3897329168262243`*^9, 3.3897329247672243`*^9}, {3.389733181488224*^9, 
   3.3897331962812243`*^9}, {3.3897332476832237`*^9, 3.389733248785224*^9}, 
   3.389733364196224*^9, 3.389733447460224*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"legendEntries", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"legendLines", ",", "legendText"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389621033892*^9, 3.3896210839779997`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShowLegend", "[", 
  RowBox[{"p5", ",", 
   RowBox[{"{", 
    RowBox[{"legendEntries", ",", 
     RowBox[{"LegendPosition", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", ".4"}]}], "}"}]}], ",", 
     RowBox[{"LegendSize", "\[Rule]", "0.6"}], ",", 
     RowBox[{"LegendShadow", "\[Rule]", "None"}], ",", 
     RowBox[{"LegendLabel", "\[Rule]", "\"\<\[Sigma]\>\""}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896199844309998`*^9, 3.389619996865*^9}, {
  3.389621094799*^9, 3.389621098097*^9}, {3.389621182734*^9, 
  3.389621187608*^9}, {3.3896212580950003`*^9, 3.389621276164*^9}, {
  3.389621319869*^9, 3.3896213638640003`*^9}, {3.3896216388050003`*^9, 
  3.3896216436809998`*^9}, {3.3897325365432243`*^9, 3.389732547526224*^9}, {
  3.389732950324224*^9, 3.389732950436224*^9}, {3.389733230014224*^9, 
  3.389733261329224*^9}, {3.3897333688402243`*^9, 3.389733373110224*^9}, {
  3.3897334524472237`*^9, 3.389733458254224*^9}}],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    GraphicsBox[{{}, {}, 
      {GrayLevel[0], AbsoluteThickness[0], Dashing[0], 
       LineBox[CompressedData["
1:eJwV1nk4VO0bB3AhqbcUbaQsQ6uytBA1vtpLRcmSlCVJ9UpK1lAKSVG2SLYU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        "]]}, 
      {GrayLevel[0], AbsoluteThickness[0.5], Dashing[0.01], 
       LineBox[CompressedData["
1:eJwV1nc4lW0YAHArJFR8mWVFn4aRHepuIKOyJauSjKyibUQiDfpQ9ihFyCgl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        "]]}, 
      {GrayLevel[0], AbsoluteThickness[1.], Dashing[0.02], 
       LineBox[CompressedData["
1:eJwVx3k41HkcwHEm6Zqe0CkbucqT5lGtBx18UHrcSbEk5Qqddh1rMtG6o1jn
jGE0tYs02JwzjsxPmtQ4ImfHZITBTlOOyc389rt/vJ/389L0CXK+QpCTk3NE
/X9pvjEfx4VYk7DiKxf0zaiT7r1BUiHWkc5jTcjWg4nFHaFwTIjFvLDeVinb
BVGjTbNYhxBjWmaQqTI92Khvq/VHnhDzju8LTJSZgFbtRYqcsRAj3g/9ECGz
BqfuaJL8rUGs9XxbiJfMDUoV29MJAgEmFf3LJ8gCYXvWHr5f6Acsxffm8vUN
EeDgtbMq6XQ/ZqgQrRnlEgu2m6+nFur1YIUtziUX4pLgW+N8uUVqJyYhxlhv
UksD0eBVVqMZH5v9foTVYZIJJ2xcoxcCmjF/a4f+HioVjoklYZY+HGy/Ie2y
7jAdQiIYAaacQgzXZ4Q2TjPAdGIw91h7PITzMzd/1HgEOxf4Glad/4CrfBiZ
X/wYVmmK64b7GuCMfgcd3/830LroX84+5YG9ndWUx6sCSB+4fIH0oxU2qWen
5J4qAmpr35LOSBdsITcH7fvyBB6+0fzlxIlekI+XX9gY8hQGEl/JpXsMQO+Q
2dWxMRZ4aZUeT+B+hKNtpZTO30thd5T4Ze34Z1BqOaJeM1EGGR9rvluxhqBO
nXywOOwZVMfzCdVuwzD28lp0AaUcbiknNZqLR6C9tGExj1QBXRvFTfn5Itha
csPAT1IBbaNz11QNx8HTq/imP6MS/N66MujNE1B/hXNAdLoKCnTddoiDxbCi
nJF4e7UKIj3XGrsrSiDYlxTyoLAacML5RzkN3+BImsGWPe41oF47myYInISf
Z3nESkU2iIs0s5h3pqCcSH25p4gNdD1VhTqXaXh3PyHSxIkD2bn+r733zkB4
YJaxq4QDl7M83xLHZyAuzjO2K6YWVk8VLjK5Utj30HztAe06mBBZkpsTfwDF
9UbcXE0dPDE9rNbhPQv16dqixbP1UBkfphxAmgPuyqd51lA9PHDxtVszOwf3
BTo/sa82wDHB46eJHfNA/tRLUV9uAMNzRh55tAWw66ZInt99DoRotcO04EXQ
tGRnrSc2AtOIZZttswQ6lLLhkxmNcE+QytFSWQZd4g6VM0QuWB3lWed8XYaS
ieEx7RQuOCacIeWzV8BpylxpFwGDfR5xLgWRq9B17UpQ7m8YdI9t+CvTRQai
0Z2T68YxaPURWaho4KASLiUy9ZqAmq2seHsRh4cPoN/FqwkGE5o1M5GVHcu9
LyLrkkNMy5B5S6rffJCrL/SFfkF+v/39ml+RezToIzZLONCd8UPJyEqsvS92
L+NwQLSYxEVO5hrceb6Cww0/ptF+7ybofjZE60fOSSa9ICGrPk6vmkIeyqu2
M0QujpWKdVZxiL9b5mWB/Nqa456CbGlnm+yBrNBjZnxJhsNaqYHgT2R73qQz
GTmQb+9PRc6seXQrA/lNss8UA1krh1DUguzxlqzAQjb3bNlmgOMw4OZ0kId8
zzH8kA1yW4IhuxW5E/TsfZGLmcrm75AvaSXH0pDVMtjnBpGLth5nViCXXo/6
PIr8XUFS34Z8+BAEfEU2mmP0i5AThQtT08iR4w4zOHL77ZKIBeT/AFRqkSs=

        "]]}},
     AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
     Axes->True,
     AxesLabel->{
       FormBox["\[Delta]", TraditionalForm], 
       FormBox["\"f(\[Delta]|No Hit)\"", TraditionalForm]},
     AxesOrigin->{0, 0},
     BaseStyle->{FontFamily -> "Times", FontSize -> 12},
     PlotLabel->FormBox[
      "\"Limit price position \[ScriptL]=-1/2\"", TraditionalForm],
     PlotRange->NCache[{{
         Rational[-1, 2], 2}, {0., 0.5822111511748433}}, {{-0.5, 2}, {0., 
        0.5822111511748433}}],
     PlotRangeClipping->True,
     PlotRangePadding->{
       Scaled[0.02], 
       Scaled[0.02]}], {-1, -0.6180339887498948}, {
    Left, Bottom}, {2, 1.2360679774997896`}], InsetBox[
    GraphicsBox[{{{InsetBox[
         GraphicsBox[
          {GrayLevel[0], AbsoluteThickness[1.], Dashing[0.2], 
           LineBox[{{0, 0}, {2, 0}}]}], {0.08, 0.08}, {Left, Bottom}, {1, 1}],
         InsetBox[
         StyleBox["\<\"4\"\>",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0],
          BackFaceColor->GrayLevel[0],
          GraphicsColor->GrayLevel[0],
          FontFamily->"Times",
          FontColor->GrayLevel[0]], {1.21, 0.58}, {-1, 0}, Automatic, {1, 
         0}]}, {InsetBox[
         GraphicsBox[
          {GrayLevel[0], AbsoluteThickness[0.5], Dashing[0.1], 
           LineBox[{{0, 0}, {2, 0}}]}], {0.08, 1.24}, {Left, Bottom}, {1, 1}],
         InsetBox[
         StyleBox["\<\"2\"\>",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0],
          BackFaceColor->GrayLevel[0],
          GraphicsColor->GrayLevel[0],
          FontFamily->"Times",
          FontColor->GrayLevel[0]], {1.21, 1.74}, {-1, 0}, Automatic, {1, 
         0}]}, {InsetBox[
         GraphicsBox[
          {GrayLevel[0], AbsoluteThickness[0], Dashing[0], 
           LineBox[{{0, 0}, {2, 0}}]}], {0.08, 2.4}, {Left, Bottom}, {1, 1}], 
        InsetBox[
         StyleBox["\<\"1\"\>",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0],
          BackFaceColor->GrayLevel[0],
          GraphicsColor->GrayLevel[0],
          FontFamily->"Times",
          FontColor->GrayLevel[0]], {1.21, 2.9}, {-1, 0}, Automatic, {1, 
         0}]}}, InsetBox["\<\"\[Sigma]\"\>", {1.58, 3.9799999999999995`}, \
{0, 0}]},
     AspectRatio->1.392857142857143,
     PlotRange->{{-0.1, 3.26}, {-0.1, 4.58}}], {1, -0.4}, {Left, Bottom}, 
    {0.4307692307692308, 0.6000000000000001}]},
  AspectRatio->Automatic,
  Background->None,
  ColorOutput->Automatic,
  ImageSize->Automatic,
  PlotRange->All]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389732958921224*^9, 3.389733232679224*^9, 
  3.3897332768262243`*^9, 3.389733379441224*^9, 3.389733468463224*^9, 
  3.389734668554224*^9, 3.389735025677224*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzlXXusZWV135zHPfcxDFcYYaoIwwzIUx6OVBxRqFVeKlIUC1O1gzNOARUQ
DUVFx1rRtjIFUy1WqwxWY2pNtKNiCK1G26qxD9NoIS1pyKiJSU01bf/QjNXb
+1vrW6+9195n3zuDRb3JPfec7+y9Xt9a61trfevb9/lXv+6aV7z66tddu/3q
DRfedPWN11y7/bUbLrjhpuWh4SFVNTi6qg45akOF90tVJS9L1dL+ffRyDF4w
/Is0sJ7+jKulB3ZVWyr52Vrduzw6pO9mqqW9W2l05959NLK0/wvVnU9b/ho/
Qze8r3rhwQV3fLnl3h1V/Hnaruqh/fsG9PUwQBx2UNAL3IoIPK5Q4CGO6HWm
2rL7C3qdA9lF4Ld5Uo6iP5Pl1z3VTk8IQeFLB3JNSqy/hqmT7y9/BGGfIPNR
WMP4KJmjQQ8ajm+FtXK6Npaxh3ZvVoEPyyyVua/PUh8Sv+Vnq+hAgeapqHbs
oU/zwpGj9vIDuDeT9lxPeJuSew9NcGxykhN9HujY1urOB/aJOvfC+00W2ZGK
iqUL0MMwSYx+IZnMyw7g3kypZnvCy0S2NsHhRSZjfXEU8cxVfiZYXyeZVzFS
BBrr52aamPkaGNz6awkXfe/NFG62J7zpChdx3LtjsyrXpCeOunL1ZFG8Aq5b
qXj8vY+UeFIczkYfIfHMFNk/9IAoHOuuX6/6iqsPrIMtvrkeOJ/oYRUXNfNI
inMmrEH8Q99ffnDAPPEREWIruhODX/MUrlx+U1wjgx2FaVy+9kUHdvtJB3lB
mMvRnJyAnOmJpsjpKP9Vxwo7cWOy/FxxAPdmEprrCS+T0HyCQ5flvbvU6Q9q
90I8k554g8i6Y7hZsfkQjdfM8oBAsBDGlV/Mq5qP6gK/seP++W7UnJ3Mlltt
QTXtJBSTHlSUWFfTxcSZzpfv6tkVZu6Fq7xPFwUX8c93wMquX+iAv1FdfhRu
gTfXgarkaj1z7mcVx+CJWCbgQb6keH+uSOxn6X83uF6ZvELmjj0PTLtzEoJx
P+0Qyr9Mu70jli9j32AQj2M613/nm//wX2vXHvrVs59yxlt2venGbXf/6e3n
f/7+P3/yCjF4pfuGWyKWAGEDXhaSKzvufjxLA3c+99N/effd2152xen//I/3
gbYb77j9zSc9+PXPSWKJa7525hmnfP788855xy03X3fNXe++DdfN/uC//00S
2cDI7C/Y2NyjiJaDPXaYsxqfZPm1OKgU3Q71IRUqGggzIHVhc6exj1754kuh
UoRuQK/DL5/z1LMUxaaEnKckY2f3vC4bW6RX84I796orEWfg2ILmf+KySy8U
tm55x9t++zvr1z/2os9+6h5Zhhe//x9fh3Wc8+W/+WQpAEzuuPH67bgf7N51
zc6XwMLUgn6pJ6mv6nnd4d6NlBkqrBzNXwEtyKRPhRWQA/JonBP4EZwVSMf4
9xcX15ZJ0lvd7QBJE+4oCFR9r1BFrqg4t+Ksn8Bfnfm1v/8sBFNmRPVGQayN
Ana6NMEEAB1+oUPQLbjbDQ8/9Hd8H1HzPRUNi2UpJUKVkIgYfPaiC8+vUXIE
Y8UYVAKYIKMHTzpxE9AQF3wz4E1axTETEnoOV4gylq+s2xAuHC/gizqGSSg1
ZKiiSAHXgnLQMmwloBk/QfGLPR9jIoE8C8VKkYI6lr/B9GNeIA0sJ5AIKCiV
XcGOS6786If/iOyDgoAvBXQAjdsJRfGsYAa2Rp9OiNzAnsonug5oWRPx7RcZ
9oZEaGVacC3uAc4Ce85LCiokbAGXGgmr3hhKIOoGNTTc9zHuYw03jIj4mk/o
2aRqOm+Cf3jDsUczb/yqBkK/eP1M4BAmq1AXDAt0miR+XKILXFIZ4fvLPvHx
9wknbIMzmEMwDU+ASYAwIBTC/nHGfpzJUqEW7IAExQRlQmXAXlJd72hkOcB9
kduPBXyYb0iJPq0xbtVYj03wUWQ2ABfFO4MpH+OAf8iZ5Yhr9jS4VAM4zMaw
MhDmoxOsfO8E13kD+cHsLMVXbrUYmnUI1+9l/BttjpXD4qpBj6xGYO3xCQlP
NAEp+UMjSzyH9x5QBybhPYEEkA8y6dOiiUBV73GqzE9iLfLKJSs/fBrzPIK8
8RWAgn7CeTvjPIfhAwIuIdqPSvgr1wG68NGuSL/HsEuMIXpNn3j5GkHEkIEo
2ZEJyi18qbg+gMFvUSzwiwkW9wLqcRlPHq55c6ACzJOZ4NM6Mx+drccmJPwq
kwAKIU/ggtMojOsk2WSTINVqiIybmYxnGEolI1vLLzL/pBM+0gk3N8zOCl+8
lhGUigbWTJi7M39yPnBSuA/yeUyCl5egCcQBMYo6iVcmD86iHwMFxsWX8eTi
u2sDKZg5XEuf1pt9qcgXla+tpirwUd4rU5ghVLqIyIIGvG5jzMUMwz3sRbo2
iEeavF/wxvdBWLIt27JrO5PI76U2b6KtEqECohiNz/XMAbyEqS+rL8Y1TpIc
Yfrm6bznAkapKz1dbwWxLBV5BaOBykGtvRuFxuNzibro7VDyVDO3ywMPwEuR
u/PjU7fqRkaE2kiN9jSPeo05zrpzohWvZqOgOdroxUF78D3PzX6/Y9RdM5US
7t23XVqd1UErW+tI7AzChikXVYFYhQWQLnEek4trntMgVQMfJXVKGVxIvest
z6XOgTNfdF1K6q1ME4xJdEKicagxiagWx+B78fegmUhmR16Vyn2Iy9askGRc
d/by6Hk33M5jI1D8dpMpiJC1v6gA5RhRBUagT1wXCCI6zwp0QrTqSFdDp1xX
NB2i0RguyxpuNw+i15V0XnLc+rJbhwcJmO/DKzMjJXWL3/fbbvUB8ATNBR3s
ExKe3k0ugxaIkegQlg4Il3kbcbjLvNHiCiLZCZoDwCtHedUvr9AgE/aCgQ8S
sj9oCiU5KKagkKZa4RRKwi6pQhQ3GZSduOAwozq5Y0Km7TVknE1MyZSTv2DS
4EqFPNgt6U/xN1A22IfYNqQiOQjTuybQiwnX8Jnp7V6amK58K6HQLD4PS2J1
rxmB1q9KIKBJqlN48CY+h+ssRPQhTPQp5nF0HVxQgtq2BWIpn4RNFNxnyqMr
X8kqJJOctvKALalUV2wWMa/7n0A4kh5NSnlhnQl6usQpOmaEq4dDiZZ9zgNs
Sl0RZlhfiw5LngAlgLy+64gZADAvOpM6CYAFL0AT+FWWr6xvssbRAlbyES8t
KNqn1dUVHWHd38zoT2USwZCK6vjEZgc22ZptlPAZ2gFvDyJAWC+EkIaWZjKE
Y/O5ms79E8mKlI3chAapn5mOcgDST0gQlXATHMB+qSjDUCkFQUZAGD/tfUX5
GdNr7CA8k5GeZjqpSmZ1kuJkQiT9FWYC04Bx/AWDf9yuZuQwg5qNE/0bJADY
imYo73C6Rk5v5+4vDDrl6VjTQDqreBePCwlC8clb/63pERSVpvW90XzZt/Nr
05DG/IVFmMZhAFCWiLDQSQ+g7+SqsVgVHrN9tAWbNKguCY+rdLSWEcLlT3h/
nzpva+tpwfQkg0oFenzamGBfTFTmr3kMTEJvSU/vF63G+kVrWjaHp/OdIYnJ
CmyLNoegjnzE/WbCump8rhgtizZl9AyzaAW/QS1i0b4FYDJDh0jZFkSyBb6l
FRGWCPUQWfnusSY9jSQ+ZVLWEt0XxRokxQ2SPMOg9MEGiYMyktxeswYwTspa
LCTEKQXVmeaqVIpZnfBIY0KrKJ80WcLN0acfBbDwJnp5a/mRPa/aJVU1B8Q4
4VNBRtj4qpPkAlv2cmi/4GOme1ro+DGDZacz1LUPn45RXeIq5sibCij8iOGQ
IY7CFB6kQ+uswquRWUiH+WuS9iHzPnBpFtyVOOkc0djWCsm40QCNRWamLC5+
7zLbs95gCgi6SMx3m1uSKcV7Iou9YPVku008V68+7qxH3zqI6/3Yw9CwkJF/
vCm1atX7eUzqJHwtTW+gHaLW6co6Grp6oqZ1QLfTShU/aCnCMky7W8C0KkPk
chBT9jrHLl3pl1wlHcdJWXys+7FllgkPV70pPU9pYpcyA5rJ2Oj77vZj60Wv
tfJSmYCT4BGQwb9hXmBh7zLLirnzJMjGKpdT8uXYSh0aZoNsTjEVgQqRDO7k
MZCFwMUslYVbtuNH7CB6tmI3G00DGWWdla1BShz+wMZ0V4DImA8iwThV/x/+
qxt6tnY3mjYTWkayxMJZYZZ+39yi+g9PztnBm6rmZoobKQltkYGSskntd6al
VlT9Ll+P97ZliNeSK3OFYkQ+60tvOb1+dMib+liF1d2GmJFY+hMwaah2kRt6
K7lPrgIsvzvUEzRL2cwnPn59m+OcUTPu7N2jy4iUs01IPgwmob2pzeNwUmxr
TpKHa3tj3iKXGdPTTObQGsQumJ83tPmYQsVTzfY1Dl+fgN9i3EDOxOEtPCaJ
pcFeDLDxfX0XJMB+ZqUuW0gH/JtMy2wrFmO8e1M4jhWmbBvtPB4DeJBOGlsK
5iGuJNiH+8mh7zXiz3YFn81jUvQiGl/JY4jDNdh40Kt++RklwcNZAT3sXPXq
KNW6Z5vfxHRTefc6I1iB/Wsw//Yl/6yGPLV+kMmT9wqoWAK+pSlgu/koxF0k
1occBV0LeaQAbENypGQdFEjoBLPG7L7cdBTvyEv+u6NALJ6tVlQ66E+2B3qp
YYObATaImbesqHin0frDOs3mPNhLVU/nr6AlinFdgu0FRhUkS9o6sAnXe1/M
Y9L7RuOca464CugKyjzsqwu4hIa5yjDyVQa8p+FBExxgZMt7ZBJLlqpQxiSf
IKCyFESKlR7mUg4WIHtRgr4p2Nwq7gsABPgKUxwoBAljYMDU811qwtU+i28p
O7Y0FwTnGju6zh2RsHOVaQgMUnaan29Trux8O2DjtS1ik4JhK7bfZGxgDLML
0GDmQrtdleRhFV736looeIaJUQPBbIt+mxka5EJ26poWNfnlXaehdCfQJwuV
O9fYSBHsTY0so4h3b2kZg7+mmperh2oU83QzWhUSa1jrYltUmxepobXOLP9m
bQTsiEfSmCTNSeeYNpqPxuuxAbwEfgaeoHN35iwmxQdkkuBgBQA7ZxkQILIW
I84/O9PckleSlL/2rovpGyvA8dxkp7GzwIxX11lopW8Rkb1akI0ZONVURuMH
LlxSx4CvQoFD3Ep50H8yNxxerPJUtVN+H5bKIpVxxX0sQ2nZ4y0Mnm3ZBpT6
jGtM1ttdpx5UlCaHi90j2VGR/v0CVXqNJPoZmAqq8gZZZJn1TAi3l3i/xDWO
VtNSkluNbt31GZgLwrVgHeOFQGmzIltZbxasRHM77MS3uuE72VunwqJbfDAG
WeD9D5nf9j3QmZDtLPHmDCia1G6BKmT8cnIz8U3l0iJbJw5GLnueeF+Gwbds
/YCvBdMGTCW5Vg6RRyJV/EIcjmvZKXaApYNR2pjcxjquInn/pCagKbm62xBW
CWSPDyBJURHhnVFnZbO0kIh5FpE4nY37g3ypbHHi932v2H6VC1MSoUoHZ413
2SMFggwwnEtNqLJk+QS6r7gGtn5oXjCSV/WqdG2mWx9g3ZJZf9k9H/zD765b
d7gstvS3NAv4GSFB0vDYO0Vb6vHpqFVxojXtJfUYVuqsjJu0gPPBqDxWrT1x
VUoIXjRUk+uSumAiUsq2bDcBYydN8xSxLuIMAXBcE/b0leEDJsvYWntS9M7T
+hpGQZ7L0cjuPSmtGQ3vt9VJ0y+i4RRPQ/dqWY6MU3vHd+653GWmJTZbppPm
gFA7jLbKO4xdBQ7X+UDaB+4GJbpwvjvl9E9MW3QhJbwcO1QX2Pd6T3aIqsDR
ZkWlv8DhRjPa31Rbn0/g3GWzH6thpwc4IZnvgAN5INyxIt/pga9gsRlfZTc6
bL8SnDMacLSFak5n9T3GtUbcdHfZNL8w2jz9ZoXvd8frbJZKrl/afOGQldLM
vlmv4j7/D4tutHSnbg4YMCdafmrFMIAa70/8VSkWXJIo1TgBVmrpcGO68f6j
drAXmw6qtDOdf5fNqSbWHWAvsUnUBWOsU3yHGS5FM/j043Zgz7UZqJ+yCzTe
YdepnnMBSFdkaRwb0BsCgncHMjwMw9lzOSIbMGUlL2Njt820qg1XkTRaE4Wl
A1gMBO8OZHgYhqezERSxgw3p3DM7zsE+zyZPndiUHs3oXA6ZChuuQOsgGex3
GsnqcN12aAq7FOeCOxI9p00caiqqtTT8RA2i2ZNX4E7fEY7xMfuC2areQVJc
n2xDZr2WZXMHymbdQnjN4vBCXv/cNyOz0TVUAr+QWS7hRH0l8T7NeNwdPNeT
Mn1Tdy5HTcIsnYCKE1fyGRrdMze8XCrpHdiFx2SVH24Km/hCBigQrSMayrTA
V8TdjTr+KcGtagb3bTktDXLIvP5tJvoYoZy/MhL0UUAdTVVF2aT2bj1sb+Mv
kP/GHaRVEtHVb+XOqKkgCn4puxj+Z60MP/vU1qYrJ3+N4cs+Z6hfpqh7NQvk
nVcOr1r/79hcWBkCY8+OJtevTzpvxHJ41XkWvDA37dlo4u32OvNi5rETqzwL
iBorl9mR04y7GCOcTnQuz6m54SSHWJNIwbZmOQZTU7rVpjIuhxwNl2bCsTc/
PXVednJDT1fz3tCYDE2Fz8f1tAVrW9IXtyLELyF8IyPUjkxFeJG/N+3+DcXU
m82FxQztEgdnaFs9tAbp8l/uxlTFubmknYqYwfLYTUZFdKTPa4czNKNHNk5S
cfvBiJVtP/j5U+kJ4QrbcdwoITiXtsMZmwqofK43euAxjZ4XTIUD+WiI8+pI
o1n70TX3UtFEkW6HEvxp9dl0h89VYa+zMSimNdYoFjLYUJAJzuS0dq4miXFd
GzXB6jJPcGYrXIySsVOn4guHIK/hMfhu8Gf55jHKi5UVRp7nwl8HvlnDp8ew
d5JVc6N7OMEQmPQbwYoU0zkdaUntoW6qvjtMDa0jDK8bBLbbJfXho1RyOvDN
G5PqLLabGUbTPS5RkBClJ0rjnz4gRkNqeLU5CDuqhtfjPVflR7om7PFM+8rZ
nB4x+4qeM5xFZAsmJLwjLdtm/iT6yV9nsg5on2rKU3YzGtcYPVASorEczsWK
Elf2qzyNq3smbkZDOYkZ2lFcw0Q8ulxo6BtNZQ+ZzUoxa81Y1GdfZZ4qbsP+
Ro2GVTyqNZPDWjMgTWKuNB2yFR5jL1kdDf5ZpUQDBRWEmWoLV5jJwbzM879s
Zfj6PFA0k8Gi6YLWuEqnB/QgZjaroqn1WZlZue8xJn6IhMRfnqkqZSojZ9vK
VLPliZdZlbZ0MUAztVB4mWls1M5t0UpX80zJjIYjjG0dK00rmJUYKL+8vzeb
8nTGTEnWmTi0RsRx5kicLVYlfTQME9aZH3Q949DyhHWmDrrsXWzaCQ9qj3fg
NpN0+TzS5k5bdC8wOHhnjzvYORVO6Dx+jlkQFk2LEH+rHc568zy6S/IrLFA5
/i+dMQTqmnZQ5RliWDh0gTvPyISIuKKKseva4TzO7gFJpHbn2hwLu3oK4pUO
FEEqz52RRy/Qp9LRg89QHPOmr2onpERn8swh+lRsS3bdTe+vnwaHysJir3jP
HUMjKSNI6wNBu6Ed2rFmjZrzuBMg2hFJcF7TDmdDRC9NG6W1XHbA8UklfVM7
tI0mF/UH7MP1iCs+2eEBfHpdfeY2maTEydJT/EyzYsX35naCSs+MnNGVhxhs
MulBUmazr28HxdvUY19i1MajJxiP0AfZSrEHcL2hHS7LZwSWRGagi+1orMe1
l7g5xSb11naQHEjPyKE3uQ8uC395jZ2IpwF44cgOYOHTrvrM8KbgWPwE+IMM
6O5yaEwOr7jWnwVfjpPGCryHDVIvRpGlYX5rO3Os5YvSUiLTKq0evhwo3SGC
t6HKb29HQ99/5eB8T+9dfvnoHSinJCrfcPlMGcMCLTsVGPtIvMenr/4B1JJO
bvZwpMUMrx9mOJuTe+aTsackYwTnzxjOk5UHLPMxDcjg+J42D+dkT28JB7ii
EvYC6NcHWRzrNZ4kXB7SF8nez0cDJaP045ohu+xp6GD4H9eeVvl9KiZ3VPn8
dzn24rR4ntBFUKXq4TjeIqfHY/7iBXVKHfPy5IaNlJDztz4weZjM0cDPUaz7
h6eK+pPgEraxII3k+j4pxtphzdVbA8Pnh/buCQG1n38SzYfaRRNKO5XPD7qf
CD3oKR+GP+tm1njQmTVxN3t6Imnt/zlmkoso7hHFa1YoGp/JtXarOnEV0QwT
qQzDrOK2rcvfOck0/kVV0tN4kEXjRX+wRRNgd4um/kA0vs1vvAXx/HSl4/zy
KqXTLJ1Nkc5hQTrBbPSWmnTaJqX+LzceJcoD/KMy612P026IZqEmGkmk/dGM
ehFyEr2jUyZtEaztW/BJ+QV3j2+9WJ27OTmIjX8Ggi14XF0xygMc0ydytzvj
GSciI3vn3n1dC3psouUJyf7NSbvSjMIatvyeY4pJjbl9K1qqxl6ocS84WTIz
aYxVGnfuMNaGiSgWe7I7k4wNa7TXI5RT/T31HQ8X/tkB460N2E3eYuluGe7o
ILDVXLPaI9RTHWn1M9KeXGtNNtvpYsvWSKIjssVkKFtTgqkQle5ol2iTLaka
5s0f2TmcoXq09EnmEd/erdpC7AxEdn4aJWK+Zk2QhHciLTH2WBH6oFeF4jbg
fCZ0mjcdJYHvNT9nJ2LN1JpPUD89+MWamrvNRZ/RPVqy0Z/hgZfWzN40Jfas
n9rzOoLNLV7lTKctZVCxM5OxW2raSkkrxg5dGZzXJ26G4KxZHRzvXQ8ITt0t
Fjgn1vgu62DFrXzNU6Q++xbDD3NQfNzU6wK8UT2qGrjbZZijH3ui8pZlD71F
oI79STz6tVrBOGpHwDwOKEQKepjfwZTwI+56+B3DFtIimFEKJlnqd+8hwSkL
gb0VCK+L2yil9u/Y8d+bziNfGyMdrB17Gv8xrVI6ZlJcWviJT1YY642mjv/L
2nuyiDTmHFmI03isH0Or9/L6afBZSb1T2uLaFpAz4VKemV0gjkPVORfGJme1
0/8j5XORdkacc5R1NauSZI9vnKyYtMOD46hXkrJcoZn/kIQ6ZTnfJsv88rle
RGWyzWY59noWVLs5GJE+GlVXlwd4z11vOPdq7S3hRzW1jjIPUXi2S92iq02d
rvWxO2776D7gLSTSGybXZVIet+LwhWAal/qwj+DUw83E0rLl+LMrJM5Pn1QX
fQ5i6hO7+Hyc2HciRh3XNemIuVDX4+f8UcLZhjGRWOr/T9DPhY/9gwYXg8tq
YXUnHLW1PAfamap5+keHpqaHSvx1csLAowi+kOcga05ZHvZGL4o6WRExoWIk
6VbzMgoWhg0iwrLQTy27WHVEdAsulG+mKqUEDn7Fn6XXmG0+pkt5XdDu88WQ
MA86tXWup5x+GtpZ/llFcy4arCfzlZ4OqA+v7Ys13lYNG3NI10lMGypzK1yg
WhUwktBQwEQ+LQpoD4xvVgoy1xg0s7hBPxa065CfQ+1KrnE0ZFuEh/XF10+v
4g6E+/G68GhQrbka33BE63o6tmEis/hvx8PJ/tB7uPQzo3V9hKsrbrviZXvT
EEameK0os2mfSSlzybRPdrtiuP8PxfP+HSWYRn9/0ClXCcoeVXQAOtWaQz/S
OpVsrfXQqcbaEMtg8gzq5OhCTzKa53HLcdXm/qjeNukpkPaArSfWnrrlEl/X
BZDVafpGbZ5DWUNjXMw4ftKpiM1wMlYAwv58vQTRnu1PKxM1VNLtADGqBgXZ
Zm79n8Tl2Pz+rB5kqdVhiptymtjIAWa7CJ1NCXWZrSTEXe1CXsvSo9jtUuwl
gizt9nM4tYFnPogA4Gg3RyuUiXr6+k194x3XdavnRKYreeKTsMpLy9plaLvM
+7ql4V4XZPqzKEWTpL8uLFg4QuKkyzZ8aBVj3qqgFFGFtLVG3pivBVfiLnZs
rTLcYcJr2/5VFcd8xhYzhMr544UV0d0o/mWGF7KSubhN42C6rc+U17qcux7w
NVBeptMVZY8Cl23rOhWQExieBEl4N3bptFvnZ4PYGcWPV+9y52sOwu+uJgHV
fGO/piX+0mOJTmqSyUWMTCuDPyzvOpVr4wPlGqhHNfj6o+XdfP9mfipdMZoY
TsVT313nDTb9L0WtUeuo6E+zKygk7Bliydeixwm9G2Xpa9aiSm5yXKcKmuVH
FWQGulVQA1un+NuTsROFQHf22vVkb0gI9M+SUN0s69moTg2D7KZVagq+VrA9
GTvR+w661Yy0ndCZkBy6xTj0EsmclfmpExzt4AQnyJ01gv3YSY3biYhjUh9Y
o9lvr9sSnW1GlepytkGtm5JusW88gId5Ojwf3pgPn5sPtzi+C2oLly24M41O
wTIblk2auZZA4uyfPgOXe+3yTQbl/5McjOaO6pD/A+1DmFk=\
\>"]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Expectation of ",
 Cell[BoxData["\[Delta]"]],
 " conditional on not hitting barrier"
}], "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["E\[Delta]", "Rule"], "=", 
   RowBox[{
    RowBox[{"E\[Delta]NoHit", "[", 
     RowBox[{"\[ScriptL]_", ",", "\[Mu]_", ",", "\[Sigma]_"}], "]"}], 
    "\[RuleDelayed]", 
    RowBox[{"-", 
     RowBox[{"E\[Delta]Cond", "[", 
      RowBox[{"1", ",", 
       RowBox[{"-", "\[Mu]"}], ",", "\[Sigma]", ",", 
       RowBox[{"-", "\[ScriptL]"}]}], "]"}]}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"E\[Delta]NoHit", "[", 
     RowBox[{"\[ScriptL]", ",", "\[Mu]", ",", "\[Sigma]"}], "]"}], "/.", 
    SubscriptBox["E\[Delta]", "Rule"]}], "/.", 
   SubscriptBox["E\[Delta]Cond", "Rule"]}], "/.", 
  RowBox[{"\[ScriptL]", "\[Rule]", 
   RowBox[{"L", "-", 
    SubscriptBox["p", "t"]}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"\[Mu]", "-", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox["\[ExponentialE]", 
     FractionBox[
      RowBox[{"2", " ", "\[Mu]", " ", 
       RowBox[{"(", 
        RowBox[{"L", "-", 
         SubscriptBox["p", "t"]}], ")"}]}], 
      SuperscriptBox["\[Sigma]", "2"]]], " ", 
    RowBox[{"(", 
     RowBox[{"L", "-", 
      SubscriptBox["p", "t"]}], ")"}], " ", 
    RowBox[{"\[CapitalPhi]", "[", 
     FractionBox[
      RowBox[{"L", "+", "\[Mu]", "-", 
       SubscriptBox["p", "t"]}], "\[Sigma]"], "]"}]}], 
   RowBox[{"S", "[", 
    RowBox[{"1", ",", 
     RowBox[{"-", "\[Mu]"}], ",", "\[Sigma]", ",", 
     RowBox[{
      RowBox[{"-", "L"}], "+", 
      SubscriptBox["p", "t"]}]}], "]"}]]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389722711545224*^9, 3.389733524192224*^9, 
  3.3897346685842237`*^9, 3.389734774596224*^9, 3.3897350257082243`*^9}]
}, Open  ]],

Cell["When \[Mu] increases, so does E\[Delta]:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"p6", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"E\[Delta]NoHit", "[", 
               RowBox[{"\[ScriptL]", ",", "\[Mu]", ",", "1"}], "]"}], "/.", 
              "\[InvisibleSpace]", 
              SubscriptBox["E\[Delta]", "Rule"]}], "/.", "\[InvisibleSpace]", 
             
             SubscriptBox["E\[Delta]Cond", "Rule"]}], "/.", 
            "\[InvisibleSpace]", 
            SubscriptBox["S", "Rule"]}], "/.", "\[InvisibleSpace]", 
           SubscriptBox["Normal", "Rules"]}], "/.", "\[InvisibleSpace]", 
          RowBox[{"\[Mu]", "\[Rule]", "#1"}]}], "&"}], ")"}], "/@", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "2"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[ScriptL]", ",", 
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "lineStyles"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\[ScriptL]", ",", "\"\<\[ScriptCapitalE](\[Delta]|No Hit)\>\""}], 
       "}"}]}], ",", 
     RowBox[{"BaseStyle", "\[Rule]", "baseStyle"}]}], "]"}]}], ";"}]], "Input",\

 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389733509651224*^9, 3.3897335348522243`*^9}, {
  3.389734757862224*^9, 3.3897347646422243`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"legendText", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Style", "[", 
      RowBox[{
       RowBox[{"ToString", "[", "#", "]"}], ",", "Black", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}]}], "]"}], "&"}], 
    " ", "/@", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2"}], "}"}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389620914783*^9, 3.3896209204820004`*^9}, {
   3.389620988039*^9, 3.389621025764*^9}, 3.389621081079*^9, 
   3.389621619785*^9, {3.389732359838224*^9, 3.389732441608224*^9}, {
   3.3897329168262243`*^9, 3.3897329247672243`*^9}, {3.389733181488224*^9, 
   3.3897331962812243`*^9}, {3.3897332476832237`*^9, 3.389733248785224*^9}, 
   3.389733364196224*^9, 3.389733447460224*^9, 3.389733560252224*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"legendEntries", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"legendLines", ",", "legendText"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389621033892*^9, 3.3896210839779997`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShowLegend", "[", 
  RowBox[{"p6", ",", 
   RowBox[{"{", 
    RowBox[{"legendEntries", ",", 
     RowBox[{"LegendPosition", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", ".4"}]}], "}"}]}], ",", 
     RowBox[{"LegendSize", "\[Rule]", "0.6"}], ",", 
     RowBox[{"LegendShadow", "\[Rule]", "None"}], ",", 
     RowBox[{"LegendLabel", "\[Rule]", "\"\<\[Mu]\>\""}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896199844309998`*^9, 3.389619996865*^9}, {
  3.389621094799*^9, 3.389621098097*^9}, {3.389621182734*^9, 
  3.389621187608*^9}, {3.3896212580950003`*^9, 3.389621276164*^9}, {
  3.389621319869*^9, 3.3896213638640003`*^9}, {3.3896216388050003`*^9, 
  3.3896216436809998`*^9}, {3.3897325365432243`*^9, 3.389732547526224*^9}, {
  3.389732950324224*^9, 3.389732950436224*^9}, {3.389733230014224*^9, 
  3.389733261329224*^9}, {3.3897333688402243`*^9, 3.389733373110224*^9}, {
  3.3897334524472237`*^9, 3.389733458254224*^9}, {3.389733569186224*^9, 
  3.3897335776682243`*^9}}],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    GraphicsBox[{{}, {}, 
      {GrayLevel[0], AbsoluteThickness[0], Dashing[0], 
       LineBox[CompressedData["
1:eJwVx3841AccwHFx5Rwiy+LSZBE1ae70MK59dH4tZ8yvYiwx5qk4Y6L86CnN
upQn8mtSPbqx0A/2DBO6T46EXa0Q/TrOOecO90POj6TZd3+8n/fzsopJCorT
1tLS8if6/2WW+vOrqyosiU+upKEQWlY2dGV9UOHjMhvORr4QXrw0K3q3rMLv
fq6tWOgSArV4u+PcvAqjjK282/qEcJXMTJROq9DtUH+N95AQKmdPTAiGVdjO
D6uOUwihrlP6vLxehZHW3Zldm0egPZ7fTI9SISXFv2rtyRE4OrV2XtSgRPfV
nPTLXqNgJHLO27xeiVx2sahdRwSv94hzzrEVGPQt/e/tsSJw7DZbSuiYwdk2
m2seT0SQ3bu3a9RyBv0SwspaaWMQpKsyEPw4jTbPC4d33hiDgGqze/KuKdSY
2uywNxIDs/nz9mLrKdT9EPExLV0MuOa52700OS59kxrDkYuB9iDe5NigDJU3
jdL+Ch0HwUiKn/8eGVrF3F+07BgHtTNF5xZnEp+V7fbd5SwBCqnAuGRSisEq
vSb8XQJ3KdwrSy5SZLFu2jGsJuBksj0nP38C23LTD+pXTIArq1pQr5CgC7ll
Qm+9FHKj6vJZ7hJk5g2t+FyUQrf0WnXq9XH880lz+XmdSSis2eK6SSXGYEOv
uoBfJuFsnyltmilGkgvnkBdZBseiVk77ccdQw3jcJMuRgdAhyc9WI8JMdWdF
nJ4cvJKfsi8FivB+t8I9liOHWtsQeWDsKBr3ZPFd103B6zFLZTplBL8fMzyx
t2AKls/0VLY8eoMOLqROtsk02Jed95s58hqDGqgOxjem4XaCG+aYvMLWnuXe
Gw4zYG7XN0rvf4Fskesew8YZKA9LfjecNoxOWYE8hrcC1iXNPyilDeH1Kuor
6lMFdHgdDWjRDCItr/nW5TAlFBQuDgkqBvCwpfaBrUolsDqjDVbC+zHyfEIz
JVMF5kclrp98eIpLHY1mNylqqFGcc2hm/4NfH8i4Ex2shvZzdsfnVQLs2fVD
dFiFGhb0l+9Q3frwjYhVbj2lBr3IXObxxkdYaNAqOew0Cx6l+3qbFruQkiVm
F+fOAjVwVNjmw8fBTv+zxkOzUFyfeFV5AfEE7/22Aau3sK/wVLSjRSua3748
3Zz6FiopOiMj5CaMyL64VcB/C665vmmbjBqw3LSgctVoDtxrJiecg6rRkRbh
kh07B6Ip5lX7U6VIn9thQWqcg/AnrY8sxz1R7/rD/gWKBu7K5YtFlzxxuDPP
Y42+Bkhrze3IDE9EXlCjPuEGt3SOutgDz3hOl2wlTK6l7+/wZqIw+8twX8Js
3fCShyGAedxE0TXCO1MYFaxxJ6znKtWeBhoYqrnyns5wwj75+pgAwjmjSxEW
JXR8R6YNhBN+6ddkofCm4cWB001swsYBkYwtobsx5YJ7xq+EBfeA+du4NbLq
vyLNELa2XdFOLdmGZzJKjy8Qzixu6fT0+RSpdpNSLUMNhIzE5AlCLbFoU2Gv
KWGj/d4FQZKNqPuR7iUgzNuGGzQ+JhhWdUzLl/CrlaTtnx00wp30geQQwiXx
wfZ/TJDQOrMu5Ahh6Rd5h2Thqzx3LrX7J8LcqsRYtkzDs2XlO58i3PYJd1Cm
kPAEfO1aDmHfONmzB/JQ3r+yDGoR4f8AOAeQ9Q==
        "]]}, 
      {GrayLevel[0], AbsoluteThickness[0.5], Dashing[0.01], 
       LineBox[CompressedData["
1:eJwVx30w1AkYwPEtiqREd9kkij3kXOXtvDZPLVGoro0pZSpGjPcoct2dC71s
jEtlNdLLnjKzuvJyg4jzUFTc6lUJtRZr28XuZve3L/Yl97s/vvOdz/q4DMax
hRQKZTfZ/79mv1Q5Py9DqVOKIiNWDi16y+5fDTLclNfZ/4b0hyHq1TmtDP0s
Gxq94+RgU+bkrlDKsEWQyNGRvmFKTxNOy9CwaoczM14O7NncSe6gDI13NBTe
SZTDvSfCdxV1MvTV2XRMpMmhPfFxs+cRGXYxeMeLTssheWqRkl8vxX/XiQU1
5XKw4PsUrVkuRa36+XBfgxxGvMcLLqRL8KCECPPtl4P7U6omtWsGl7lczJye
lsNvvVu6R+1ncDwqgXJ6iQIYJjJz7vFpXOZlyCp0VcCeamqruHsKB71/atOF
K4DevLm9jDaFX9b8qaalKgAXvAtozRFjQs+CfotSBXh0JlqlDIiws2Y4tfxv
BXB5WRG7vUXo/unwrdh3CvjiY2b0F/MzRq40L/TWK8DMuHQF67MQ2Q+P38xZ
T0CtWdV1ja8QI6/k3tWGEfBzphuzpGQS2e6L5ydPEuAfXs2tkwiQSB/LXXqT
gHNH7pWEbxVgs2HWurOXgKfCm9Unb03g84f85SyCgMuctf7WsnE0+9qY8CNN
CYV933pM08cxZr/XGr9IJaQc0Z+JqBrDRs4fbMcCJXzamBHhTPAxkDEj39Ck
hO2Zr9Iv7eXjwbcjCbpJJdQ4R4r3xo/ii+whMbFKBSNj9tJTZjz0HXMdOLBL
Bdr85+yWZx/x6IcGk4h8FbhduxgxkzSCq1IePhU/UsH91AAssBpGr9+VoleE
Cla79I16vvmAC/s5NBM3NVQcyJwbzBnExT2u035Jalicoews93iPLQ7Ur9fv
qKFre/KeFmIAg/5pnDLiqaH0svo9t/ItbjaXvG6100D4k1hzffQbpBa7pByK
0cDqZIG/neEVUr2vlRSzNcCRXNjYnP4SW7soP5wd00D7BZdspYyLworu2QyH
OVAt1T6wCehDf1vqiYDkOVgSc46e3fgMk054KJi1cxBUvq23Sd2NA6zk3Zq5
ObDZO/qpLfQx5s7UWedu10JZXdoNaTFiyM74B5tKtLDtcl6su+0jPMvY0nXo
oxbYZkY8nmkTSilbkyqcdeB/LizH2qIeD594aVuZpYOtnM+TPoxqlN79LjS2
Rwf8KfoNt7xyTKgfXSddqYfoF4+e2U8E4/3m2fwzyXqoFYvVVy8FYx7PUl5E
2njRahfTwGAcyvGJY5GuDzjF/FIWhBTKVfo90qY1nju7QugYllRsNEA63SSa
1RMJKK/OP++cogfXrMDK8AkvtGsrLH1B+j3nus4z0AtXOjIWDJEuGNUcsmV5
otTEKWuC9FBEk60kxAMXUXn7NKRX7IkJXBu1CWmsS9YOqXrgtgL9zgQNQwj1
7WzSNGf9wpMsR0w9u9byDOlfylqeBIc6oA9zR0ER6UheXBE3yh6bh2rjb5O2
2BlSyhB8g1R++4Ze0h2OaEmEWmG3alnlW9LD+gyn7/dbIF6JN+eRZiXuc2uY
NEadkYNMTlroV3RYFD3f8dHAPGogXXU3LT5dRHS47FK+NknTQ5td1YBIIui4
IksIsiIddkz0ulMc1REIjCZb0v8BQICvMQ==
        "]]}, 
      {GrayLevel[0], AbsoluteThickness[1.], Dashing[0.02], 
       LineBox[CompressedData["
1:eJwVx3k4lAkcwPH3nZGYlGPbjVnSIWNq1jofhX38jKNEKanWZqk2axNDcnVp
UzaUpGaU0iabfRwd7MYSO79ciZ0uyRCZyYwx4xo9O3Lk2Hf/+D7f57Nyf3RA
GI0giK1U//+q+aLx+Xk11kjP1NoCAVUzho0nZtWom0be41Lu7DK+MjWtxq+G
Mm7voMzkW9r+O65GllNjTjzlPB1ulGJIjcEcZXk15fwPSf0isRpH2GWlXHcC
ShoUb3IfqFGiZ/rnbi4BteH1lfahaoxilsJFTwIiBheMS8tG0ZCX/ofAhwB9
qVPGl0tG0ff0LMnfSkC3Y1/KOd4IHvIfCGvcQYDtE+PJyLphHGLGif8OIuBk
yzeNEvNh5BjVxBWFEhCwUK0nihlCLw67K/5HAvwLjatVjYPIZ++qzowigFtp
U8u3GER54k9mWXEEIPnGpTpBhcBYkp97ggC7x+FGh9qVWH5rzuH8WQJEvbF+
Wx2V+JnJp731FwgYc2LQS9MG8GKTewonhwCG1iUDwYACs3y0ZLG3CLjPKLg+
uV6BGSv+OaZfQsDRw5y0zMx+/OArMDOsIMDZt1D0YESO83na2u+RgNTQkkxf
kKMmZpODs4iAJ4qbhXG/ynB6iZtqTycB2UVmzsvUffiszvGVjYKAM62f2w1x
+/DOmHbxSQ0Bh0JnfvYreI8yTXjuKRoJ76yj/VgaKbaLOW4xRiR4HX7Jy9ou
RaGjtsfiVSQUswJV2w9IsLOhp8XAjoTu9+ajiYxe7F5taObuScL06af5Vc09
6N3lFKK1iwTO1XS/4YPd+FAZnMSKIOFupAumGL3F3tOPQjqTSTCxapXYt3Vi
pDzdY/YyCbnfHp4SJ4jxdsvl+uZiErSjxx/n2HVg/y1dzUckoc4rwr9K045N
Sa2Rgg4SLmVPdIhuvMaJ9f6j5mMk+Dbs05sJakO/EpZEqUMDkwi58/LZl+hc
+lbaYUGDopFz1pW8F5j0bspS7UaD2nNW8eNqEco1bosT99Dg46Lpe0yXVnzx
OtE36hgNdINTufEPm3G55sWTkGs08Mhxb6mYaMSPq+b2TlXTgLld8q5mYz3G
/uU6taaHBvwHUXmj5xGVx55bG8/SwD07eZ+t6SP8gv108dxKOuQz6L29OhVY
vpRtkulFB+fUzQnL9MswTxgbFn+QDlA00O8UUIjFlglbrmXTQTrIzeMk5+AP
jJgtVlV0CHr+qNlc5ol3N2xir5PR4b5KNXElyxOPt0n22lDWWmBipePqiZsY
J645Ui5zSUwb43ug8a76hUBZp9jep86bi5zQXxSBlHkLgwRNgW5Y6Th8J5ny
2ljXG74yBzwzbr2mjXJH0fVP9q4O6BX+3fdiyimSyT2mAnu8kJgh6KHc5Vdh
OuJth1NHJhcMUDbwD3Y12/k1WkgWDXyiLKp24/4ms8CIowYla+R0sGDN0OIE
q1FPnNq3lvJxflWD58ZVyHo9z7ShHNi7P0O00xx1i8kLzpT1fbwvBciXIrvJ
ledPWbgaDTUbjTBkmfj3QMpvZ6It1+3WR2O9BEkQZUH4Dk55vxYyn9VtO0BZ
sSEjRBk0L7x5lZd+kHLBnagDPKVGWE6uqOdRrlle0K4ckQvnmB3TRyhvDlO+
eqzaKdw2d8r+KOX/ADEHZME=
        "]]}},
     AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
     Axes->True,
     AxesLabel->{
       FormBox["\[ScriptL]", TraditionalForm], 
       FormBox["\"\[ScriptCapitalE](\[Delta]|No Hit)\"", TraditionalForm]},
     AxesOrigin->{0, 0.5},
     BaseStyle->{FontFamily -> "Times", FontSize -> 12},
     PlotRange->{{-1, 0}, {0.4647947851968806, 2.486559297889279}},
     PlotRangeClipping->True,
     PlotRangePadding->{
       Scaled[0.02], 
       Scaled[0.02]}], {-1, -0.6180339887498948}, {
    Left, Bottom}, {2, 1.2360679774997896`}], InsetBox[
    GraphicsBox[{{{InsetBox[
         GraphicsBox[
          {GrayLevel[0], AbsoluteThickness[1.], Dashing[0.2], 
           LineBox[{{0, 0}, {2, 0}}]}], {0.08, 0.08}, {Left, Bottom}, {1, 1}],
         InsetBox[
         StyleBox["\<\"2\"\>",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0],
          BackFaceColor->GrayLevel[0],
          GraphicsColor->GrayLevel[0],
          FontFamily->"Times",
          FontColor->GrayLevel[0]], {1.21, 0.58}, {-1, 0}, Automatic, {1, 
         0}]}, {InsetBox[
         GraphicsBox[
          {GrayLevel[0], AbsoluteThickness[0.5], Dashing[0.1], 
           LineBox[{{0, 0}, {2, 0}}]}], {0.08, 1.24}, {Left, Bottom}, {1, 1}],
         InsetBox[
         StyleBox["\<\"1\"\>",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0],
          BackFaceColor->GrayLevel[0],
          GraphicsColor->GrayLevel[0],
          FontFamily->"Times",
          FontColor->GrayLevel[0]], {1.21, 1.74}, {-1, 0}, Automatic, {1, 
         0}]}, {InsetBox[
         GraphicsBox[
          {GrayLevel[0], AbsoluteThickness[0], Dashing[0], 
           LineBox[{{0, 0}, {2, 0}}]}], {0.08, 2.4}, {Left, Bottom}, {1, 1}], 
        InsetBox[
         StyleBox["\<\"0\"\>",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0],
          BackFaceColor->GrayLevel[0],
          GraphicsColor->GrayLevel[0],
          FontFamily->"Times",
          FontColor->GrayLevel[0]], {1.21, 2.9}, {-1, 0}, Automatic, {1, 
         0}]}}, InsetBox["\<\"\[Mu]\"\>", {1.58, 3.9799999999999995`}, \
{0, 0}]},
     AspectRatio->1.392857142857143,
     PlotRange->{{-0.1, 3.26}, {-0.1, 4.58}}], {1, -0.4}, {
    Left, Bottom}, {0.4307692307692308, 0.6000000000000001}]},
  AspectRatio->Automatic,
  Background->None,
  ColorOutput->Automatic,
  ImageSize->Automatic,
  PlotRange->All]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389732958921224*^9, 3.389733232679224*^9, 
  3.3897332768262243`*^9, 3.389733379441224*^9, 3.389733468463224*^9, 
  3.3897335828012238`*^9, 3.3897346690172243`*^9, 3.3897347749982243`*^9, 
  3.389735026264224*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Analysis of pure barrier model (i.e., without ",
 Cell[BoxData["c"]],
 ")"
}], "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{"AllRules", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["S", "Rule"], ",", 
      SubscriptBox["g", "Rule"], ",", 
      SubscriptBox["E\[Delta]", "Rule"], ",", 
      SubscriptBox["Pr", "Rules"], ",", 
      SubscriptBox["f\[Delta]", 
       RowBox[{" ", "Rule"}]], ",", 
      SubscriptBox["E\[Delta]Cond", "Rule"], ",", 
      SubscriptBox["Normal", "Rules"]}], "}"}], "//", "Flatten"}]}], 
  ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"va", "[", 
    RowBox[{"\[ScriptL]_", ",", 
     RowBox[{"\[Mu]_:", "0"}], ",", 
     RowBox[{"\[Sigma]_:", "1"}]}], "]"}], ":=", 
   RowBox[{"\[ScriptL]", " ", 
    RowBox[{"PrHit", "[", 
     RowBox[{"\[ScriptL]", ",", "\[Mu]", ",", "\[Sigma]"}], "]"}]}]}], 
  ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"vb", "[", 
   RowBox[{"\[ScriptL]_", ",", 
    RowBox[{"\[Mu]_:", "0"}], ",", 
    RowBox[{"\[Sigma]_:", "1"}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{"E\[Delta]NoHit", "[", 
    RowBox[{"\[ScriptL]", ",", "\[Mu]", ",", "\[Sigma]"}], "]"}], 
   RowBox[{"PrNoHit", "[", 
    RowBox[{"\[ScriptL]", ",", "\[Mu]", ",", "\[Sigma]"}], "]"}]}]}]], "Input",\

 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", 
   RowBox[{"\[ScriptL]_", ",", 
    RowBox[{"\[Mu]_:", "0"}], ",", 
    RowBox[{"\[Sigma]_:", "1"}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{"va", "[", 
    RowBox[{"\[ScriptL]", ",", "\[Mu]", ",", "\[Sigma]"}], "]"}], "+", 
   RowBox[{"vb", "[", 
    RowBox[{"\[ScriptL]", ",", "\[Mu]", ",", "\[Sigma]"}], "]"}]}]}]], "Input",\

 CellLabelAutoDelete->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{"GraphStyle", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Thickness", "[", 
      RowBox[{".003", " ", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1", ",", "3"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xyLabels", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<\[ScriptL]\>\"", ",", "\"\<Ev)\>\""}], "}"}]}], 
  ";"}]}], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"p7", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"va", "[", 
          RowBox[{"\[ScriptL]", ",", "0", ",", "1"}], "]"}], ",", 
         RowBox[{"vb", "[", 
          RowBox[{"\[ScriptL]", ",", "0", ",", "1"}], "]"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{"\[ScriptL]", ",", "0", ",", "1"}], "]"}]}], "}"}], "//.", 
       "\[InvisibleSpace]", "AllRules"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[ScriptL]", ",", 
       RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "lineStyles"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\[ScriptL]", ",", "\"\<Value\>\""}], "}"}]}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "0"}], "}"}]}], ",", 
     RowBox[{"BaseStyle", "\[Rule]", "baseStyle"}]}], "]"}]}], ";"}]], "Input",\

 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3897336089262238`*^9, 3.3897336406902237`*^9}, 
   3.389733725927224*^9, {3.389734784779224*^9, 3.3897347913592243`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"legendText", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Style", "[", 
      RowBox[{
       RowBox[{"ToString", "[", "#", "]"}], ",", "Black", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}]}], "]"}], "&"}], 
    " ", "/@", 
    RowBox[{"{", 
     RowBox[{"\"\<va\>\"", ",", "\"\<vb\>\"", ",", "\"\<vc\>\""}], "}"}]}]}], 
  ";"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389620914783*^9, 3.3896209204820004`*^9}, {
   3.389620988039*^9, 3.389621025764*^9}, 3.389621081079*^9, 
   3.389621619785*^9, {3.389732359838224*^9, 3.389732441608224*^9}, {
   3.3897329168262243`*^9, 3.3897329247672243`*^9}, {3.389733181488224*^9, 
   3.3897331962812243`*^9}, {3.3897332476832237`*^9, 3.389733248785224*^9}, 
   3.389733364196224*^9, 3.389733447460224*^9, 3.389733560252224*^9, {
   3.389733666114224*^9, 3.389733676014224*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"legendEntries", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"legendLines", ",", "legendText"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389621033892*^9, 3.3896210839779997`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShowLegend", "[", 
  RowBox[{"p7", ",", 
   RowBox[{"{", 
    RowBox[{"legendEntries", ",", 
     RowBox[{"LegendPosition", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", ".4"}]}], "}"}]}], ",", 
     RowBox[{"LegendSize", "\[Rule]", "0.6"}], ",", 
     RowBox[{"LegendShadow", "\[Rule]", "None"}]}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896199844309998`*^9, 3.389619996865*^9}, {
  3.389621094799*^9, 3.389621098097*^9}, {3.389621182734*^9, 
  3.389621187608*^9}, {3.3896212580950003`*^9, 3.389621276164*^9}, {
  3.389621319869*^9, 3.3896213638640003`*^9}, {3.3896216388050003`*^9, 
  3.3896216436809998`*^9}, {3.3897325365432243`*^9, 3.389732547526224*^9}, {
  3.389732950324224*^9, 3.389732950436224*^9}, {3.389733230014224*^9, 
  3.389733261329224*^9}, {3.3897333688402243`*^9, 3.389733373110224*^9}, {
  3.3897334524472237`*^9, 3.389733458254224*^9}, {3.389733569186224*^9, 
  3.3897335776682243`*^9}, {3.389733734904224*^9, 3.3897337469332237`*^9}}],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    GraphicsBox[{{}, {}, 
      {GrayLevel[0], AbsoluteThickness[0], Dashing[0], 
       LineBox[CompressedData["
1:eJwV1nlYjF8UB/AkUrRItGhRQrKkQipZRkqSSCQipbSXPf2QEiKRtGkVKq0S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        "]]}, 
      {GrayLevel[0], AbsoluteThickness[0.5], Dashing[0.01], 
       LineBox[CompressedData["
1:eJwV1ndcTW8cB/A0pGhINLSFhFIhlXp0iySJRENKKe1h64eUUFKSFi2h0pTR
1PgWpa11jxWNO8+9TQ2U1O/x13m9X697zrnn+zzP5/tVdg2wdufl4eERXcTD
8++apLh0emFhASy5+RkdFmWofG55/ZW/CzB541ZMnnUZ+vxFOm5mdgG26Z/o
vWVfhmTj12lNTi+AEp94pIlHGUpdQvFjDS2AMtPapP16Gcr4cYnZ9mkBrsRf
V1V5U4by3rGIh0UL8NPVMK5rQzmq8nhbquO8AC7NV/X3iFQgb67A9MCLeTj/
aJ3bKpFKJDagG7ladB5m+II4zYuqUe822vVw/79QHBL3NWsRIK330r996+bA
s+/vf98e16KrzYb1/YpzEO9Ync6tqEPWgmPL2gL/wNnmO/zLp94iqyzpCk79
LAy/TmwL165HlNItVfGqs2Au8npj08kGBIsIg4oLM/DgW6BkRel7pF3rIeFD
/Q1TJ8ZCImcaUVvfmf0Htv0G36elGTT9ZjSuK8yXH/ELfGvTah6mtCBh/nvi
Ceyf8CT+GF2U3YqeCz9J/r3jJ6QsowlLWbWjoNObIqKjp8HrjrKvedEHpG+R
1VY0MgX+2xZSX051oJvOedEWu6ZgsOTNOG9OJ3rPSss6lz4Jr5a1vrTf04Vi
c+T1pcYmwMHT2e7KcBcKa1mpPUSZgB/Tqx7mRHQjH+e5kP1PfoCw//KeDxI9
6LtGwP71U+PA3E250pPeg3af7vSPOTQOZlrBhZxVVJS73oZzyG0MXjVeEzcM
paLeQcXRi8Kj8DqsvHEzi4ocb3DHfQVGIeFCzEQ4m4q+rSuZdOEZBc8tpjqD
JLbPvhmLnyNAqjRM3Ruior7pc/xKtBFQf5joxxynIppQi2xTxQi8tx4ZdPlD
RVytc2bSXiMgVFWgmS1GIG+q0T4RtxE4tpdwoIkTaOiCkCWv8wiENUGMvASB
hivTrYdtRkAs8MjKWEkCje5uPl67awR+xHy/4StDoAl7hXOe0iNQdVEhY0qF
QLOhTRnljcMQVL5CzmwbgaxuXQwwfjsMKy4637+8nUCZkeuMWqqGQblL+Mtz
XQJZxt3o7X05DC7y0cRyfQJlZO5atZAyDPL0pKvNRgTa01h+Z3fgMJzp85Vb
MCNQ3LLcC93SwyAj2qcWYk8gUtxu97EVw9B9sbE82oFAO1cKSjJEhiHDx0so
+RiBWPLuL6d5h2H/8QHu8+ME0tdUHpYeGQJ5sd6MZhcCDRx66OJcNwSOfdPe
b70ItCnp9v5hryHI9tJaXHOJQNedbLLvug2BT1ZwTHoQgT6vVeTRch4CdxcW
cfU/At0oLn593mYIhK3WP9hxhUDfuvplF4yGILT1GDP9GoGilm3nLJccglgP
Uk/jFoFoPTwmxaJDMPOrw3EWe0dKa+pRoSH4u8xuW0M4gRgbXA6mzHOBW+ct
YHsbf49ZVJkqhwsfr4VI+kTh9Qil3dSt4QIlMe6mzX0CUcwL+7+Uc+GgrEPL
0jgCPRC/pHflNRccEk2q67BNH4mM1OZwQfvZo/wNCQRKrdphsy+OC3EMxzRO
EoH2/7qrctyTC+XfSJ8NaQQq8DWA6xJc6GC/9M3KJlDys+qwUBEuFJr3qas9
I1AEDe0NWcIFVzHJ0lzsk3amXVfnObAxdqV2bg6BZE0t6Ze4HDhZU1/yMI9A
4audBQPecqBI6mzirucEOnd0sNWvmgMegUG/irBdY0/e8y3nwDtugKJCEYGM
BD1lvJ9zIP9z9tuf2FMTgRvdkzkQER5j8fAl/n3LdatjZzjgqERb/rSYQAcF
BCQd/DhQ8UOteB7baFf4ZztPDtzk3SNlX0IgmdI7LkedOGB/4oqCcCmBOh/H
nz20jwOLL29ad7yMQDXfVu04uJsDsmUX659jF0g9nDuwiwOMzVFKC9jh0Wk3
92/nQNi+SPHUcvz8oOwkMxUOaLzb3PC+Au+XYjXHPfIcuGu70kz0Df7+sTyl
3dIcCFGvCLPBnnYryqWIckBbsmjjd+yCg+WVhrMk7GnK3thfiet7Rz9k5zQJ
nkrvLslV4fe9rzI1GCeB03P3qh2268669h0sEs6zCgvasGXUWvp1ukkYlHBK
zKomUG/9lsD3bSSEjpcT37DTXJJ47BtJcI63jZGoIZByiptycBUJGV7+AUHY
dN3Wl+JlJORVjsTnYWdRtShPX5JwciVof8XeILrg2pRNQvuWU8RWwHmQ5z7p
8JiEcgWTL87YhWZtYSMpJJC+IYdvY2uFPsyUiCXBOF499xP2pDzPtqw7JLzP
Tg+bwy55c6pB9xYJJ6JCuxVrCaQ3pcNyvExCgO2TVhfsP/eSL4ydJ2HsBvtc
CHb15kWC1wNJeL0y714a9rUWjyRJHxLglZ9CBbaxx4f1z9xJWCtYKt+Dzce/
rVzvBAkKtYvvDmE3ZKTsbXMggS+a7s9bRyDzr55eP6xIOLbxYMhG7KUXO2bC
9pFAP8UuMsRuX7E9ctVuEh5Fyhw4gB3zIlU2F5EQfcjb4Tj2IUu+fAN9EtSC
jlO9sVdwvQw+bCXBp+5C5QVs4lZn6wlNEmjDemKh2ElrdB0nN5BQVqvecRvb
vjZt+KYqCXX87bP3sFcf578qrUhCVFhmbCL29xlvkXwZEtyEt8UlYz9K7Eoz
lCTB14t3IRXbRWeHRqcoCeln71HTsNd0pte4CpHQP++64p+ZvgJW03wkLGP8
ffPv/mdCvv3h82zgW2C0/Hu+V3Z3gOwMG/I0Uimx2BtN9HgKJ9kgcuSZciT2
SP+je2iUDU62kR7//n/RlcXK3SQb/sg3r7iIfVrG76UbnQ0x8ey1Ptg6pT3G
v77j+/O80v7VZ9pav/v2ZzbUHewJ+le/srEMV7keNrgF57z5V9+gKMHJ5+1s
UNjk5/yv/gYb/MOMm9iQdDTLQwr7bwN1BfUtG/jnqd2LsMHVIPNUNRuM1oVk
cPF6hi483jpTxoaSj+qdXdgmqUsa7rxiQ7ysvUsZtoBewBGFQja08MQcTsG+
fWbnBZMnbBjkVbF3wrYQe7r4YyobmqzCfQyxRQqEkjyT2LD2Mf93WexY5sey
6Cg2jPfZ9nbi/frQ7vTMpwtsyL9D6G7AnvCMmXp/mg0ug0OH5vH52B9UOFbi
y4a5Uee/Xdg8yRxmnCsbXiV/WHwe+1SvS7fVATbkdtZ/zsXnsXboWruRORuG
vBvPnMWWnUtr2mzKhkMkb4oBdrvc15ql+mzwc78f34jP91Yn6/zGtWy4v3al
8gecD3f9A7NLldgQd2VAOQqbDL77OGs1G7ybawv3Yqc8akkKW86GB4ka7tU4
X3gHKTfQXxaorK43S8D51HlS53gZlQV/JEVuzOP8Uz93yC67gwVEi7xgFvaN
GwGHE1pYUJM8L7oPWzcr3/xsLQvUyUf5MTg/01lrtmsWsOB0j5+IEM5XHy9J
sWdhLBDgyV9d/IJA9UHawonBLIiVplZRsBUiDwrcDGKBHDvqWwfO7+68qD+u
ASy4pKuQyMR5v2OYn1Q4xgKnKiprvoBAiwOmaxO1WZChY/GMxP3DhaJp9mgz
C+jh7lUu2FUrvdqfqbFAPFLO/gvuN2eqvn0pV2BBxF3O+nrcn/qE6ie+CrNA
7z8Qj8jEeZN5X1WRzoTFV32qmx4RSPxSW976PiZIJHgqqWN7WyzW2vKFCX5P
1QQi0wmkNBFkaNzBBMNfl6134/4XhVyOnqxkgtRSvYncZAK5fdWMeBbHhE9Z
vlPquH9CoZfoi7tM0JHpNTsXj9cz9Gl8+W0mvA/eIVWF+23neqnHzdeY0DZp
oWaG+7PB+fmKIR8mmBfkClnEEEhCvH1I05QJoeE/Lwrh/l6329uqfIoBEtmD
QU6XCTT+X8RjmzEGDA6ubXbF84XSi+zJcQ4DVlR3Grvj+SNYlp60oZ8Bp9TC
Ct0u4nlm7NhAcjMDCob/c7E8S6DiB5anr6YzYCvzM7XBm0A5Q1viKHsZ0CQf
V2xlR6BPSlbMPgoD0lL1LKVtcf2P+uleNmTAvpLHPP1HCORem9v7WpsBC/OM
klOHCaSSoKK6Vp4BP2KDLZ0P4PnBSLJEcIIO9Br71ikTAt2L/fWxLYUOUksk
PhVuJpCtfntcQyIdXGunfxzahPcD/cnBmlg6TFr220+p4/639UBLUTgdDpcc
ENuqRqCmT5nV98/SoTzUd/EjPD8uyFtn2lnQ4cGUDlVFikD+eQWnGbM0+PIw
3q1/noq2Hb6u8X2aBnW/t/ju/0tFc39sh4hxGmz1MSwpw/NtpCWfeyOLBjpZ
24Vv/6airHF7u7xuGpxMTitZNYHn5e2CKDCPBkaSc3XfGVRk8c5l2Zw9Db6t
sdSSbqYiVvvqhAgbGuhxjReta6Si658J+ZVWNADb2VKtBioqHzHX1DClQcFv
sotSR0Wq0trWJzRocKJGtcKigormfXkf1PPSQEYhkvyVQ0WvVj1dE50/CBJm
xnmlt6hIxpuhr/B3ACjsmNFiAyraTx7REPw9AJHpcnRXPSoKPtWoPD4xAMdP
v+GI6lIRwzVvyVtyAEyW1G100aaiF8cCP7pTByD+hUrQqBoV7bWcO12YPwAP
Yl5w81dS0YUtkrk7HQZAs+VnWdFID8oZCdco9e+H5q02OY1JPUg88MnGSrd+
sCHlbgsk9KBLE1VqtQ79cID/d5Dx/R5k/uuHSsuefpj0fBz5OqoHcXkcpfoU
+iFGkXQKCe1BmyW38Czu6INzfCVRVd496JX+564jmn3gWK3TVmXQg6rC1c5P
j32Dypie262futHPpbOFsgZfYfWUVIEMvQsJOd6knC/+BLWZbVI7ezuRSaJx
c8kvKhw2TKyMUe9Asof6v1eadYOClH60nG0bii/ySx290wGU5JTmBo9mZBwb
7KIl1wK2YnkzLfQGlCHM19e3pAHErqiqzZq/Rfo3912QEquF1hm9B7s5VWhX
Dpupa10CH/tqe4fZr9EAl5K6KTgbVnz4usKjOAvZf3jTqEi3Ab1GDbei7zbo
OYfzKy7GBvJ9ZWoPRNogfgEZtSU7beD77Vm/ke026IXBxYjx+MOANmSA2r3D
aEmujnndHmt4MXxJP4lijfwF7RMabKzg2vpauWcHrJD6mZ0pFnRTSIvhc4ob
MEUfc5L/6Ow0hcmJc3HZeqboev/vY3IJJhCt3uNbft8EfdlfIjeyhwJOkkeX
fjalIHErx53yRxDsjRgaFbFGqK0CUZ7St0Kbyw5pM9pWpLp+jvdcgg507Srh
ocTroMvx5e9MzbRhaeVSLf092simzzWy7YgmrJ+P7Da10URi5nvuWTNUQfjM
54BMuiqqWQPLp8xUQKXFp8bfTAV9nQtYt9FWEe5muul5HFVECR6HN71kSkLP
4EtxB6YkYulFOpH2YvBGlnH0lr0YepLp5+ZP8sOOTVqtFJIfVSo8oZIjUzVt
owlz3SNTRvvcya5ajnuNs91YA74a/Q8T8zfR
        "]]}, 
      {GrayLevel[0], AbsoluteThickness[1.], Dashing[0.02], 
       LineBox[CompressedData["
1:eJxF0nlIk3EcBvDlkWtKHhQeqesQlRLLLbHcG+q80A3FOSlJEkWRPOaBR1GJ
GaIZ4sRN8yjGylA7NEjRHG7mlTI6xCM13fKYm+fMTeecWtHe7/vCy8uH53mf
3x/veyY+nZFogMPhwv7e/57VRFP14eGhEKe/OnSWfff3UfMEPyZtKne1mO04
zh5baqxfj6emyVYw8zbvLIonMDf3ysZqWjALkj61k2NR1wuSl43V0tYD2DeX
epWeOn4A+bTnXGExax/e9xiw0aT26MAPhq71SYiYGSYbZuKMPdgLb7DpVPRp
Iae2XxJwnFA/RYRHxiidubuQk0RJVimjGrB4Nose5qmBvtKLYPi6ZAdyghHb
gru0DX5H4NdqrmC+m+lWUlamBnvTGsQtayq92UhRbHMZzRc1DxmQPWvIfr4F
/YpGB2/rjd9oX/Bo+CRphYo5JVZXQOdvQn/GPZ3uolKCAzO/scojlNBvcmEq
IhI24PzpX8T1PMI69LUPP/M6BlfBbtWP6au3V8BvUinCQqtlsK3rsIQ8IgfX
3Mjcnchdgv2j6WpRFUkG5/cEJod3qBagz67YGRfXzYNpvXFmuug5bD95wdtx
XwpuXCt2b2dJYE9Q7Jqj3vgJ+bap9q0dZQp8LKaImvNhAuxf5TfUtjMKtouQ
zHQFj4A5LWn160++gv0q8uM87If1LkB4BMPZWXw/9j2LQnOtzUV6Zwh8G5cW
vRhtqBHpMrXeLf8V9KO/fBwkzjOx/0Wh2Kksx2xkbOuKR1BbCFopeSVKTiTk
+CZySE8QA8wyieb2M8NRI+ezkDrafADk4421e2QEc6FEc9Oe6w/9SXqb/VoQ
FXKL8BjEIcpHbyVF3OlDfTF/GXInF51BNpcMvsfp6A0IJoGZs/Gl4qiLeksp
5iFBbMaCE+Td54SWquCzkE/p0p0vXCdCzk2KdHu/eAIsu1p6Sx5tDua/TEtg
yY3AXY78Ufmaqvu/WimhifLvIkWi3qe7/gBF7YMY
        "]]}},
     AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
     Axes->True,
     AxesLabel->{
       FormBox["\[ScriptL]", TraditionalForm], 
       FormBox["\"Value\"", TraditionalForm]},
     AxesOrigin->{-2, 0},
     BaseStyle->{FontFamily -> "Times", FontSize -> 12},
     PlotRange->{All, All},
     PlotRangeClipping->True,
     PlotRangePadding->{Automatic, Automatic}], {-1, -0.6180339887498948}, {
    Left, Bottom}, {2, 1.2360679774997896`}], InsetBox[
    GraphicsBox[{{{InsetBox[
         GraphicsBox[
          {GrayLevel[0], AbsoluteThickness[1.], Dashing[0.2], 
           LineBox[{{0, 0}, {2, 0}}]}], {0.08, 0.08}, {Left, Bottom}, {1, 1}],
         InsetBox[
         StyleBox["\<\"vc\"\>",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0],
          BackFaceColor->GrayLevel[0],
          GraphicsColor->GrayLevel[0],
          FontFamily->"Times",
          FontColor->GrayLevel[0]], {1.21, 0.58}, {-1, 0}, Automatic, {1, 
         0}]}, {InsetBox[
         GraphicsBox[
          {GrayLevel[0], AbsoluteThickness[0.5], Dashing[0.1], 
           LineBox[{{0, 0}, {2, 0}}]}], {0.08, 1.24}, {Left, Bottom}, {1, 1}],
         InsetBox[
         StyleBox["\<\"vb\"\>",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0],
          BackFaceColor->GrayLevel[0],
          GraphicsColor->GrayLevel[0],
          FontFamily->"Times",
          FontColor->GrayLevel[0]], {1.21, 1.74}, {-1, 0}, Automatic, {1, 
         0}]}, {InsetBox[
         GraphicsBox[
          {GrayLevel[0], AbsoluteThickness[0], Dashing[0], 
           LineBox[{{0, 0}, {2, 0}}]}], {0.08, 2.4}, {Left, Bottom}, {1, 1}], 
        InsetBox[
         StyleBox["\<\"va\"\>",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0],
          BackFaceColor->GrayLevel[0],
          GraphicsColor->GrayLevel[0],
          FontFamily->"Times",
          FontColor->GrayLevel[0]], {1.21, 2.9}, {-1, 0}, Automatic, {1, 
         0}]}}, {}},
     AspectRatio->1.0952380952380953`,
     PlotRange->{{-0.1, 3.26}, {-0.1, 3.5799999999999996`}}], {1, -0.4}, {
    Left, Bottom}, {0.5478260869565218, 0.6000000000000001}]},
  AspectRatio->Automatic,
  Background->None,
  ColorOutput->Automatic,
  ImageSize->Automatic,
  PlotRange->All]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389732958921224*^9, 3.389733232679224*^9, 
  3.3897332768262243`*^9, 3.389733379441224*^9, 3.389733468463224*^9, 
  3.3897335828012238`*^9, 3.389733750449224*^9, 3.389734815639224*^9, 
  3.3897350487812243`*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["With non-zero drift:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"va", "[", 
         RowBox[{"\[ScriptL]", ",", "\[Mu]", ",", "1"}], "]"}], ",", 
        RowBox[{"vb", "[", 
         RowBox[{"\[ScriptL]", ",", "\[Mu]", ",", "1"}], "]"}], ",", 
        RowBox[{"v", "[", 
         RowBox[{"\[ScriptL]", ",", "\[Mu]", ",", "1"}], "]"}]}], "}"}], "//.",
       "AllRules"}], "/.", 
     RowBox[{"\[Mu]", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "]"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389733774290224*^9, 3.389733776350224*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"p7", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", "f", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[ScriptL]", ",", 
       RowBox[{"-", "5"}], ",", "0"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "lineStyles"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\[ScriptL]", ",", "\"\<Value (with \[Mu]=-1)\>\""}], "}"}]}], 
     ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "0"}], "}"}]}], ",", 
     RowBox[{"BaseStyle", "\[Rule]", "baseStyle"}]}], "]"}]}], ";"}]], "Input",\

 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3897336089262238`*^9, 3.3897336406902237`*^9}, 
   3.389733725927224*^9, {3.3897338216972237`*^9, 3.3897338626942244`*^9}, {
   3.389733921143224*^9, 3.389733921563224*^9}, {3.389734802845224*^9, 
   3.3897348084002237`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShowLegend", "[", 
  RowBox[{"p7", ",", 
   RowBox[{"{", 
    RowBox[{"legendEntries", ",", 
     RowBox[{"LegendPosition", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", ".4"}]}], "}"}]}], ",", 
     RowBox[{"LegendSize", "\[Rule]", "0.6"}], ",", 
     RowBox[{"LegendShadow", "\[Rule]", "None"}]}], "}"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3896199844309998`*^9, 3.389619996865*^9}, {
  3.389621094799*^9, 3.389621098097*^9}, {3.389621182734*^9, 
  3.389621187608*^9}, {3.3896212580950003`*^9, 3.389621276164*^9}, {
  3.389621319869*^9, 3.3896213638640003`*^9}, {3.3896216388050003`*^9, 
  3.3896216436809998`*^9}, {3.3897325365432243`*^9, 3.389732547526224*^9}, {
  3.389732950324224*^9, 3.389732950436224*^9}, {3.389733230014224*^9, 
  3.389733261329224*^9}, {3.3897333688402243`*^9, 3.389733373110224*^9}, {
  3.3897334524472237`*^9, 3.389733458254224*^9}, {3.389733569186224*^9, 
  3.3897335776682243`*^9}, {3.389733734904224*^9, 3.3897337469332237`*^9}}],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    GraphicsBox[{{}, {}, 
      {GrayLevel[0], AbsoluteThickness[0], Dashing[0], 
       LineBox[CompressedData["
1:eJwVl3c8lt8bx5WR/Swio6ESishIVGYolFlIyh4lo0RlK4lImSmyI7IL8e06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        "]]}, 
      {GrayLevel[0], AbsoluteThickness[0.5], Dashing[0.01], 
       LineBox[CompressedData["
1:eJwV1nc81d8bAPCKjGvdQRSSKFtlh5wIaWgPGhpGkswmEUUhxLdkVPZ2sxoS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        "]]}, 
      {GrayLevel[0], AbsoluteThickness[1.], Dashing[0.02], 
       LineBox[CompressedData["
1:eJwV13k4lN8XAHDLGAxjtrSIVMjeFyGksiWtyhYK2aVC2vwoidKqRJYSSpKk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        "]]}},
     AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
     Axes->True,
     AxesLabel->{
       FormBox["\[ScriptL]", TraditionalForm], 
       FormBox["\"Value (with \[Mu]=-1)\"", TraditionalForm]},
     AxesOrigin->{-2, 0},
     BaseStyle->{FontFamily -> "Times", FontSize -> 12},
     PlotRange->{All, All},
     PlotRangeClipping->True,
     PlotRangePadding->{Automatic, Automatic}], {-1, -0.6180339887498948}, {
    Left, Bottom}, {2, 1.2360679774997896`}], InsetBox[
    GraphicsBox[{{{InsetBox[
         GraphicsBox[
          {GrayLevel[0], AbsoluteThickness[1.], Dashing[0.2], 
           LineBox[{{0, 0}, {2, 0}}]}], {0.08, 0.08}, {Left, Bottom}, {1, 1}],
         InsetBox[
         StyleBox["\<\"vc\"\>",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0],
          BackFaceColor->GrayLevel[0],
          GraphicsColor->GrayLevel[0],
          FontFamily->"Times",
          FontColor->GrayLevel[0]], {1.21, 0.58}, {-1, 0}, Automatic, {1, 
         0}]}, {InsetBox[
         GraphicsBox[
          {GrayLevel[0], AbsoluteThickness[0.5], Dashing[0.1], 
           LineBox[{{0, 0}, {2, 0}}]}], {0.08, 1.24}, {Left, Bottom}, {1, 1}],
         InsetBox[
         StyleBox["\<\"vb\"\>",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0],
          BackFaceColor->GrayLevel[0],
          GraphicsColor->GrayLevel[0],
          FontFamily->"Times",
          FontColor->GrayLevel[0]], {1.21, 1.74}, {-1, 0}, Automatic, {1, 
         0}]}, {InsetBox[
         GraphicsBox[
          {GrayLevel[0], AbsoluteThickness[0], Dashing[0], 
           LineBox[{{0, 0}, {2, 0}}]}], {0.08, 2.4}, {Left, Bottom}, {1, 1}], 
        InsetBox[
         StyleBox["\<\"va\"\>",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0],
          BackFaceColor->GrayLevel[0],
          GraphicsColor->GrayLevel[0],
          FontFamily->"Times",
          FontColor->GrayLevel[0]], {1.21, 2.9}, {-1, 0}, Automatic, {1, 
         0}]}}, {}},
     AspectRatio->1.0952380952380953`,
     PlotRange->{{-0.1, 3.26}, {-0.1, 3.5799999999999996`}}], {1, -0.4}, {
    Left, Bottom}, {0.5478260869565218, 0.6000000000000001}]},
  AspectRatio->Automatic,
  Background->None,
  ColorOutput->Automatic,
  ImageSize->Automatic,
  PlotRange->All]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389732958921224*^9, 3.389733232679224*^9, 
  3.3897332768262243`*^9, 3.389733379441224*^9, 3.389733468463224*^9, 
  3.3897335828012238`*^9, 3.389733750449224*^9, 3.3897338752492237`*^9, 
  3.389733928625224*^9, 3.389734816119224*^9, 3.389735049262224*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"v", ",", "f"}], "]"}]], "Input",
 CellLabelAutoDelete->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Analysis with exponential c", "Section"],

Cell[CellGroupData[{

Cell["Distribution", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["fc", "Rule"], "=", 
   RowBox[{
    RowBox[{"fc", "[", 
     RowBox[{"c_", ",", "\[Lambda]_"}], "]"}], "\[RuleDelayed]", 
    RowBox[{"PDF", "[", 
     RowBox[{
      RowBox[{"ExponentialDistribution", "[", "\[Lambda]", "]"}], ",", "c"}], 
     "]"}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"AllRules", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["S", "Rule"], ",", 
      SubscriptBox["g", "Rule"], ",", 
      SubscriptBox["E\[Delta]", "Rule"], ",", 
      SubscriptBox["Pr", "Rules"], ",", 
      SubscriptBox["E\[Delta]Cond", "Rule"], ",", 
      SubscriptBox["Normal", "Rules"], ",", 
      SubscriptBox["fc", "Rule"]}], "}"}], "//", "Flatten"}]}], 
  ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"ModelAssumptions", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[ScriptL]", "\[Element]", "Reals"}], ",", 
     RowBox[{"\[ScriptL]", "<", "0"}], ",", 
     RowBox[{"\[Lambda]", "\[Element]", "Reals"}], ",", 
     RowBox[{"\[Lambda]", ">", "0"}], ",", 
     RowBox[{"\[Sigma]", "\[Element]", "Reals"}], ",", 
     RowBox[{"\[Sigma]", ">", "0"}], ",", 
     RowBox[{"c", "\[Element]", "Reals"}], ",", 
     RowBox[{"c", "\[GreaterEqual]", "0"}]}], "}"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Objective functions ",
 StyleBox["(This may take a minute or two to evaluate, due to the complexity \
of the integrals.)",
  FontSlant->"Italic"]
}], "Subsection"],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{
    RowBox[{"va", "[", 
     RowBox[{
     "\[ScriptL]_", ",", "\[Lambda]_", ",", "\[Mu]_", ",", "\[Sigma]_"}], 
     "]"}], ":=", 
    RowBox[{"Evaluate", "[", 
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"\[ScriptL]", " ", 
         RowBox[{"fc", "[", 
          RowBox[{"c", ",", "\[Lambda]"}], "]"}]}], "/.", "AllRules"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", 
         RowBox[{"-", "\[ScriptL]"}], ",", "\[Infinity]"}], "}"}], ",", 
       RowBox[{"Assumptions", "\[Rule]", "ModelAssumptions"}]}], "]"}], 
     "]"}]}], ";"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"vb", "[", 
    RowBox[{
    "\[ScriptL]_", ",", "\[Lambda]_", ",", "\[Mu]_", ",", "\[Sigma]_"}], 
    "]"}], ":=", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"\[ScriptL]", " ", 
        RowBox[{"fc", "[", 
         RowBox[{"c", ",", "\[Lambda]"}], "]"}], " ", 
        RowBox[{"PrHit", "[", 
         RowBox[{
          RowBox[{"\[ScriptL]", "+", "c"}], ",", "\[Mu]", ",", "\[Sigma]"}], 
         "]"}]}], "//.", "AllRules"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "0", ",", 
        RowBox[{"-", "\[ScriptL]"}]}], "}"}], ",", 
      RowBox[{"Assumptions", "\[Rule]", "ModelAssumptions"}]}], "]"}], 
    "]"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"vc", "[", 
    RowBox[{
     RowBox[{"\[ScriptL]_", "?", "NumberQ"}], ",", "\[Omega]_", ",", 
     "\[Lambda]_", ",", "\[Mu]_", ",", "\[Sigma]_"}], "]"}], ":=", 
   RowBox[{"NIntegrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"E\[Delta]NoHit", "[", 
          RowBox[{
           RowBox[{"\[ScriptL]", "+", "c"}], ",", "\[Mu]", ",", "\[Sigma]"}], 
          "]"}], "+", "\[Omega]"}], ")"}], 
       RowBox[{"PrNoHit", "[", 
        RowBox[{
         RowBox[{"\[ScriptL]", "+", "c"}], ",", "\[Mu]", ",", "\[Sigma]"}], 
        "]"}], " ", 
       RowBox[{"fc", "[", 
        RowBox[{"c", ",", "\[Lambda]"}], "]"}]}], "//.", "AllRules"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "0", ",", 
       RowBox[{"-", "\[ScriptL]"}]}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"v", "[", 
    RowBox[{
     RowBox[{"\[ScriptL]_", "?", "NumberQ"}], ",", 
     RowBox[{"\[Omega]_:", "0"}], ",", 
     RowBox[{"\[Lambda]_:", "5"}], ",", 
     RowBox[{"\[Mu]_:", "0"}], ",", 
     RowBox[{"\[Sigma]_:", "1"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"va", "[", 
     RowBox[{"\[ScriptL]", ",", "\[Lambda]", ",", "\[Mu]", ",", "\[Sigma]"}], 
     "]"}], "+", 
    RowBox[{"vb", "[", 
     RowBox[{"\[ScriptL]", ",", "\[Lambda]", ",", "\[Mu]", ",", "\[Sigma]"}], 
     "]"}], "+", 
    RowBox[{"vc", "[", 
     RowBox[{
     "\[ScriptL]", ",", "\[Omega]", ",", "\[Lambda]", ",", "\[Mu]", ",", 
      "\[Sigma]"}], "]"}]}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell["\<\
The following are not necessary to solve the optimization, but are useful \
descriptive constructs:\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PrNoHit", "[", 
   RowBox[{
    RowBox[{"\[ScriptL]_", "?", "NumberQ"}], ",", "\[Lambda]_", ",", 
    RowBox[{"\[Mu]_:", "0"}], ",", 
    RowBox[{"\[Sigma]_:", "1"}]}], "]"}], ":=", 
  RowBox[{"NIntegrate", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"PrNoHit", "[", 
         RowBox[{
          RowBox[{"\[ScriptL]", "+", "c"}], ",", "\[Mu]", ",", "\[Sigma]"}], 
         "]"}], " ", 
        RowBox[{"fc", "[", 
         RowBox[{"c", ",", "\[Lambda]"}], "]"}]}], "//.", "AllRules"}], "//", 
      "Simplify"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "0", ",", 
      RowBox[{"-", "\[ScriptL]"}]}], "}"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrNoHit", "[", 
  RowBox[{
   RowBox[{"-", ".1"}], ",", "5", ",", "0", ",", "1"}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData["0.016984759670448876`"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389733983003224*^9, 3.3897350892012243`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"PrHit", "[", 
   RowBox[{
    RowBox[{"\[ScriptL]_", "?", "NumberQ"}], ",", "\[Lambda]_", ",", 
    RowBox[{"\[Mu]_:", "0"}], ",", 
    RowBox[{"\[Sigma]_:", "1"}]}], "]"}], ":=", 
  RowBox[{"1", "-", 
   RowBox[{"PrNoHit", "[", 
    RowBox[{"\[ScriptL]", ",", "\[Lambda]", ",", "\[Mu]", ",", "\[Sigma]"}], 
    "]"}]}]}]], "Input",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrHit", "[", 
  RowBox[{
   RowBox[{"-", ".1"}], ",", "5", ",", "0", ",", "1"}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData["0.9830152403295511`"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389733983053224*^9, 3.389735089273224*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"PrHit", "[", 
    RowBox[{"\[ScriptL]", ",", "5", ",", "0.1`", ",", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[ScriptL]", ",", 
     RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
   RowBox[{"BaseStyle", "\[Rule]", "baseStyle"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389734882431224*^9, 3.3897348881942244`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd0nk0lWsbBnBJhgaSSsrYMRwSqZDQbUhFKnOGZEilyDbnIKRt02TIzDEk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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Times", FontSize -> 12},
  ImageSize->{237.333333333333, Automatic},
  PlotRange->{{-3, 0}, {0., 0.9999999999999916}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389733986435224*^9, 3.389735092712224*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"E\[Delta]NoHit", "[", 
   RowBox[{
    RowBox[{"\[ScriptL]_", "?", "NumberQ"}], ",", "\[Lambda]_", ",", "\[Mu]_",
     ",", "\[Sigma]_"}], "]"}], ":=", 
  FractionBox[
   RowBox[{"NIntegrate", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"E\[Delta]NoHit", "[", 
         RowBox[{
          RowBox[{"c", "+", "\[ScriptL]"}], ",", "\[Mu]", ",", "\[Sigma]"}], 
         "]"}], " ", 
        RowBox[{"fc", "[", 
         RowBox[{"c", ",", "\[Lambda]"}], "]"}]}], "//.", "\[InvisibleSpace]",
        "AllRules"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "0", ",", 
       RowBox[{"-", "\[ScriptL]"}]}], "}"}]}], "]"}], 
   RowBox[{"NIntegrate", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"fc", "[", 
        RowBox[{"c", ",", "\[Lambda]"}], "]"}], "//.", "AllRules"}], "]"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "0", ",", 
       RowBox[{"-", "\[ScriptL]"}]}], "}"}]}], "]"}]]}]], "Input",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"E\[Delta]NoHit", "[", 
  RowBox[{
   RowBox[{"-", ".001"}], ",", "5", ",", "0", ",", "1"}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData["1.2528137903645473`"], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389733986526224*^9, 3.3897350927562237`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"E\[Delta]NoHit", "[", 
    RowBox[{"\[ScriptL]", ",", "5", ",", "0", ",", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[ScriptL]", ",", 
     RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
   RowBox[{"BaseStyle", "\[Rule]", "baseStyle"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389734893187224*^9, 3.3897348986232243`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVz3k41Akcx3EGTTRyZQcd0uPKUWlT1Oq7tNgnkUoGJXe5xuRqHYnq2Ry7
YpzZljZKKlehUtb315CUUSo9Q8qtcTNj5Bixv/3j87yf158fLW/WUT+KhISE
A7n/+4DRPLeyQiW6c2dMGmzYkBInn7lxmUo4cFIijx1hg3fR0W37lqhE0mDD
8ZETbFCe+ux7bp5KMKIfzuqEsiHiiuDd+DSVSPiR863/OhvMajRKO/uoRACt
Qz1EyAZUZnpWNVCJjLFf+Z1FGdDaqvTqdCKVGOga62CrZUEbq/FxiTSVUMiY
YYzn5gJt+O6drJRVhHNNXET0kevgV7K1cEh5FVE/veuCMPQGFGcpP1ViyxB7
XpQav/65EDQZ2z7w6TKE+aWduttHb0GCdZVsXpY0odpvgXL6JbAc+/5ghYo0
scJdsrJ+dh9qkrRTWdelCHGdrYZ8WAUce94zLqcuRRyyG/8aN/sADNpa7R1v
UAi9qwlFBtbVsEnPuXZRj0KYRbVWnuQ8goW7tlYJxZLEhWTLg/m1tSAvFcyt
MJYktDSeRZ14XgerkxbCn96TIB7Ui6QaDAnQOq6la2AgQaQsnVeKpHNgcHru
YaLvCharrBfvX90ITmnxTqGeyxgkmbk+xKEJdn8Kni9nfsec5tF+UW4zfD1v
xCs8vYTG3xcHXlm2wLuKzS2evmIsucN0C1N8A8ZpMc/DwhdRZ1eQuYDZBi5N
xcK9IQu4LrCT91LuPYjumukyYuaRJ47cLnfrA7RsXAmx+GMOXenye7h2HyF0
JFfYmfgNrdNbZHp38CDJKyfqdfYsRhU0bnaX7wSmyRnz0DQRlodbc/MNuyCV
HazQnzqDW0OD1LmuX0CzgMcvzhei0Z96abToHoinqIq18gT4hGP2XnWqFxxV
nigKbk/jvza2UXS1fnjqr/nbOtYUKlKiNQd/GYBQt3CrqoAJlOEYubhnD8Ka
2xnKi1fGsMNkOWqcNwSWN5xdymJH8B99Wf0vFnxwEw4Vrs7kY9u+dR//zhiG
Eb9u+nzVEFLOqlsFDo2AanIsxal0AH20/RpZLmOgLTMoYLzsQ+/acsUt1eNQ
4NVflh7eg4+aU8RqRpPQu/CGmxfUhX2d2u2cvCngHzg6Kyzh4eicz5biiGnQ
n9gkq5P9ARUkBmmaugJwT5e2d0h9i6dy+D6MJgEcaGaZFP3QjBaH/rLa4C4E
87iujmNixALFiLqAeSFImuyMvNldidYbOOVpCTNQE3TtfoWTB/KHL5rekRVB
t0rPjDvvFOq124w+Ir2qTucnmtspjNnbV9BE2plWxfX3cEenCznUr6S/lbZO
aAWewDPVFJ62nAh2T1J2ZMUz0LS7j1lIOqTvk7/A6TA+s6yNzV8jgnoT/wV7
Nwf8rGRsWEZ67aXZ5Hse9njI7dynOtLlWxTv+wTa4aR9stln0lM+1hMf423R
9FKlUIMmgl6ux0DEccBWFWmPa6QTmDHS2zwtcJj2dk0J6c1rs3X4gfuw0Z/1
5DFpr8Ovz7gm7MFi7x1KPNIvigI6Yp234+/pVYSqPPlvqEBjMsgQ6XIGwTqk
bXTbT3pe1EPHnki6KemrR+I4yS6aWH0tlelEWqGdbxNymY6pN13VfElrld3K
uX1SAUd2iznhpG19Z/Z/8V2p97IMY14mPW8Xku/IOlufWGlPzyT9H2tYe7s=

     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Times", FontSize -> 12},
  ImageSize->{221.99999999999986`, Automatic},
  PlotRange->{{-3, 0}, {0., 1.2533141050617205`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389733987450224*^9, 3.3897350936892242`*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Explore the value function", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "[", 
  RowBox[{"-", "0.1"}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"-", "0.07817307911056298`"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389734022481224*^9, 3.3897350937152243`*^9}]
}, Open  ]],

Cell["The value function (with default parameter values);", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"v", "[", "\[ScriptL]", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[ScriptL]", ",", 
     RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
   RowBox[{"BaseStyle", "\[Rule]", "baseStyle"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389734910112224*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nc8le8bB3Aykq1kRIimpEKJFFllJTqlpJSSUFZRaZMvTSmEIiUykpG9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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Times", FontSize -> 12},
  ImageSize->{261.33333333333303`, Automatic},
  PlotRange->{{-2, 0}, {-0.1569607311437585, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389734024430224*^9, 3.389735095967224*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"v", "[", "\[ScriptL]", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[ScriptL]", ",", 
     RowBox[{"-", ".5"}]}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", "Gradient"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.15696073906419805`"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[ScriptL]", "\[Rule]", 
     RowBox[{"-", "0.4550495981101262`"}]}], "}"}]}], "}"}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389734024938224*^9, 3.389735096186224*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General backwards recursive solution", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"LimitSolve", "[", 
   RowBox[{"T_", ",", 
    RowBox[{"\[Lambda]_:", "5"}], ",", 
    RowBox[{"\[Mu]_:", "0"}], ",", 
    RowBox[{"\[Sigma]_:", "1"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Omega]", "=", "0"}], ",", 
      RowBox[{"r", "=", 
       RowBox[{"{", "}"}]}], ",", "s", ",", "vOpt", ",", "\[ScriptL]Opt", ",",
       "ProbExec", ",", "EPriceNoExec"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"s", "=", 
         RowBox[{"FindMinimum", "[", 
          RowBox[{
           RowBox[{"v", "[", 
            RowBox[{
            "\[ScriptL]", ",", "\[Omega]", ",", "\[Lambda]", ",", "\[Mu]", 
             ",", "\[Sigma]"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"\[ScriptL]", ",", 
             RowBox[{"-", "0.01"}]}], "}"}], ",", 
           RowBox[{"Method", "->", "\"\<Gradient\>\""}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"Print", "[", 
           RowBox[{
           "\"\<t:\>\"", ",", "t", ",", "\"\< Solution:\>\"", ",", " ", "s"}],
            "]"}], ";"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"vOpt", " ", "=", " ", 
         RowBox[{"s", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"\[ScriptL]Opt", "=", 
         RowBox[{"\[ScriptL]", "/.", 
          RowBox[{"s", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "1"}], "]"}], "]"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"ProbExec", " ", "=", " ", 
         RowBox[{"PrHit", "[", 
          RowBox[{
          "\[ScriptL]Opt", ",", "\[Lambda]", ",", "\[Mu]", ",", "\[Sigma]"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"EPriceNoExec", " ", "=", " ", 
         RowBox[{"E\[Delta]NoHit", "[", 
          RowBox[{
          "\[ScriptL]Opt", ",", "\[Lambda]", ",", "\[Mu]", ",", "\[Sigma]"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"r", "=", 
         RowBox[{"Append", "[", 
          RowBox[{"r", ",", 
           RowBox[{"{", 
            RowBox[{
            "t", ",", "vOpt", ",", "\[ScriptL]Opt", ",", "ProbExec", ",", 
             "EPriceNoExec"}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"\[Omega]", "=", "vOpt"}], ";"}], ",", "\[IndentingNewLine]", 
       
       RowBox[{"{", 
        RowBox[{"t", ",", "T", ",", "1", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "\[IndentingNewLine]", "]"}], ";", 
     "\[IndentingNewLine]", "r"}]}], "\[IndentingNewLine]", "]"}]}]], "Input",\

 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"r", "=", 
    RowBox[{"LimitSolve", "[", "5", "]"}]}], ")"}], "//", 
  "TableForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[GridBox[{
    {"5", 
     RowBox[{"-", "0.15696073635575364`"}], 
     RowBox[{"-", "0.4549485335438222`"}], "0.7848647728055367`", 
     "0.9688081075153009`"},
    {"4", 
     RowBox[{"-", "0.202964277392955`"}], 
     RowBox[{"-", "0.7434954084397349`"}], "0.588816166878767`", 
     "0.7631238817006324`"},
    {"3", 
     RowBox[{"-", "0.22495651699633665`"}], 
     RowBox[{"-", "0.9844993797794874`"}], "0.43964557362619217`", 
     "0.6007578282052193`"},
    {"2", 
     RowBox[{"-", "0.23844442986589715`"}], 
     RowBox[{"-", "1.1930127975930487`"}], "0.32936153895099274`", 
     "0.4749077581212834`"},
    {"1", 
     RowBox[{"-", "0.24800099504760056`"}], 
     RowBox[{"-", "1.3638834133613635`"}], "0.2535657746209542`", 
     "0.3840191988862409`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.3897340424072237`*^9, 3.3897350977482243`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphs", "Section"],

Cell[CellGroupData[{

Cell["Plots of value functions by \[ScriptL]", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"r", "=", 
    RowBox[{"LimitSolve", "[", "5", "]"}]}], ")"}], "//", 
  "TableForm"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 TagBox[GridBox[{
    {"5", 
     RowBox[{"-", "0.15696073635575364`"}], 
     RowBox[{"-", "0.4549485335438222`"}], "0.7848647728055367`", 
     "0.9688081075153009`"},
    {"4", 
     RowBox[{"-", "0.202964277392955`"}], 
     RowBox[{"-", "0.7434954084397349`"}], "0.588816166878767`", 
     "0.7631238817006324`"},
    {"3", 
     RowBox[{"-", "0.22495651699633665`"}], 
     RowBox[{"-", "0.9844993797794874`"}], "0.43964557362619217`", 
     "0.6007578282052193`"},
    {"2", 
     RowBox[{"-", "0.23844442986589715`"}], 
     RowBox[{"-", "1.1930127975930487`"}], "0.32936153895099274`", 
     "0.4749077581212834`"},
    {"1", 
     RowBox[{"-", "0.24800099504760056`"}], 
     RowBox[{"-", "1.3638834133613635`"}], "0.2535657746209542`", 
     "0.3840191988862409`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389735138463224*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"optCoordinates", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "3"}], "]"}], "]"}], ",", 
       RowBox[{"r", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "2"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "r", "]"}]}], "}"}]}], "]"}]}], ";"}]], "Input",\

 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"graphNotes", "=", 
   RowBox[{"Prepend", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"Point", "[", "#", "]"}], "&"}], "/@", "optCoordinates"}], 
      ")"}], ",", 
     RowBox[{"PointSize", "[", "0.02", "]"}]}], "]"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Omega]", "=", 
   RowBox[{"Prepend", "[", 
    RowBox[{
     RowBox[{"Drop", "[", 
      RowBox[{
       RowBox[{"r", "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", "2"}], "]"}], "]"}], ",", 
       RowBox[{"-", "1"}]}], "]"}], ",", "0"}], "]"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"graphText", "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Text", "[", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"t\",
FontSlant->\"Italic\"]\)=5\>\"", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{
           RowBox[{"-", "3"}], ",", 
           RowBox[{
            RowBox[{"\[Omega]", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "-", ".005"}]}], "]"}]}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"t\",
FontSlant->\"Italic\"]\)=4\>\"", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{
           RowBox[{"-", "3"}], ",", 
           RowBox[{"\[Omega]", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"t\",
FontSlant->\"Italic\"]\)=3\>\"", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{
           RowBox[{"-", "3"}], ",", 
           RowBox[{"\[Omega]", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"t\",
FontSlant->\"Italic\"]\)=2\>\"", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{
           RowBox[{"-", "3"}], ",", 
           RowBox[{"\[Omega]", "[", 
            RowBox[{"[", "4", "]"}], "]"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"t\",
FontSlant->\"Italic\"]\)=1\>\"", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", 
         RowBox[{
          RowBox[{"v", "[", 
           RowBox[{
            RowBox[{"-", "3"}], ",", 
            RowBox[{"\[Omega]", "[", 
             RowBox[{"[", "5", "]"}], "]"}]}], "]"}], "-", ".005"}]}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], "]"}]}], "}"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"graphAdd", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"graphNotes", ",", "graphText"}], "]"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "\[ScriptL]Label", "=", 
   "\"\<Limit price differential, \!\(\*SubscriptBox[\"\[ScriptL]\", 
StyleBox[\"t\",
FontSlant->\"Italic\"]]\)\!\(\*
StyleBox[\"=\",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[SubscriptBox[\"L\", \"t\"],
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"-\",
FontSlant->\"Italic\"]\)\!\(\*
StyleBox[SubscriptBox[
StyleBox[\"p\",
FontSlant->\"Italic\"], 
StyleBox[\"t\",
FontSlant->\"Italic\"]],
FontSlant->\"Italic\"]\)\>\""}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"ValueLabel", "=", "\"\<Value relative to current price, \!\(\*
StyleBox[SubscriptBox[\"v\", \"t\"],
FontSlant->\"Italic\"]\)\>\""}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"v", "[", 
        RowBox[{"\[ScriptL]", ",", "#1"}], "]"}], "&"}], ")"}], "/@", 
     RowBox[{"Prepend", "[", 
      RowBox[{
       RowBox[{"Drop", "[", 
        RowBox[{
         RowBox[{"r", "\[LeftDoubleBracket]", 
          RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}], ",", 
         RowBox[{"-", "1"}]}], "]"}], ",", "0"}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[ScriptL]", ",", 
     RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "3.5`"}], ",", "0"}], "}"}], ",", "Automatic"}], "}"}]}],
    ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\[ScriptL]Label", ",", "ValueLabel", ",", "\"\< \>\"", ",", 
      "\"\< \>\""}], "}"}]}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", 
        RowBox[{"-", "3"}], ",", 
        RowBox[{"-", "0.5`"}]}], "]"}], ",", 
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", 
        RowBox[{"-", "0.2`"}], ",", 
        RowBox[{"-", "0.05`"}]}], "]"}], ",", "None", ",", "None"}], "}"}]}], 
   ",", 
   RowBox[{"Epilog", "\[Rule]", "graphAdd"}], ",", 
   RowBox[{"BaseStyle", "\[Rule]", "baseStyle"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389734924207224*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k0VXsbB/BCqGQOScpQQkK5ElGpuK9Eg3AzR5IMoSSZGgxJZi6JlBIZ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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c81e0bB3CVIiNFUhoyIiOlnnpaUir12EURWYVsKUVLkl3SkJSMKDMR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     "]]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k0VV8bB/BESEikiUKJQiSlUTMVFUmIkAxJpn6pDBlfIokUKqGiZMyU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     "]]}, 
   {Hue[0.37820393249936934`, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c8lV8cB3AhMkIkiQaVhIqUkTQUFRlJSIhSqcz4mRnJzqioNEiRyCg0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     "]]}, 
   {Hue[0.6142719099991583, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c8VW8cB3CjrFRGUVLIKho/KlKJiJYVQlYZkTJKJWUkZTVoWMlISZJN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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  Background->GrayLevel[1],
  BaseStyle->{FontFamily -> "Times", FontSize -> 12},
  Epilog->{
    PointSize[0.02], 
    PointBox[{-0.4549485335438222, -0.15696073635575364`}], 
    PointBox[{-0.7434954084397349, -0.202964277392955}], 
    PointBox[{-0.9844993797794874, -0.22495651699633665`}], 
    PointBox[{-1.1930127975930487`, -0.23844442986589715`}], 
    PointBox[{-1.3638834133613635`, -0.24800099504760056`}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]\\)=5\"", 
      TraditionalForm], {-3, -0.007648461919293132}, {1, 0}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]\\)=4\"", 
      TraditionalForm], {-3, -0.15863138593073361`}, {1, 0}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]\\)=3\"", 
      TraditionalForm], {-3, -0.20433891082990455`}, {1, 0}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]\\)=2\"", 
      TraditionalForm], {-3, -0.22618963833036415`}, {1, 0}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]\\)=1\"", 
      TraditionalForm], {-3, -0.24459076136184438`}, {1, 0}]},
  Frame->True,
  FrameLabel->{
    FormBox[
    "\"Limit price differential, \\!\\(\\*SubscriptBox[\\\"\[ScriptL]\\\", \
\\n StyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]]\\)\\!\\(\\*\\nStyleBox[\
\\\"=\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[SubscriptBox[\\\
\"L\\\", \\\"t\\\"],\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[\\\"-\
\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[SubscriptBox[\\n  \
StyleBox[\\\"p\\\",\\nFontSlant->\\\"Italic\\\"], \\n  \
StyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]],\\nFontSlant->\\\"Italic\\\"\
]\\)\"", TraditionalForm], 
    FormBox[
    "\"Value relative to current price, \
\\!\\(\\*\\nStyleBox[SubscriptBox[\\\"v\\\", \
\\\"t\\\"],\\nFontSlant->\\\"Italic\\\"]\\)\"", TraditionalForm], 
    FormBox["\" \"", TraditionalForm], 
    FormBox["\" \"", TraditionalForm]},
  FrameTicks->{{{0., 
      FormBox["0.`", TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {-1., 
      FormBox[
       RowBox[{"-", "1.`"}], TraditionalForm]}, {-1.5, 
      FormBox[
       RowBox[{"-", "1.5`"}], TraditionalForm]}, {-2., 
      FormBox[
       RowBox[{"-", "2.`"}], TraditionalForm]}, {-2.5, 
      FormBox[
       RowBox[{"-", "2.5`"}], TraditionalForm]}, {-3., 
      FormBox[
       RowBox[{"-", "3.`"}], TraditionalForm]}}, {{0., 
      FormBox["0.`", TraditionalForm]}, {-0.05, 
      FormBox[
       RowBox[{"-", "0.05`"}], TraditionalForm]}, {-0.1, 
      FormBox[
       RowBox[{"-", "0.1`"}], TraditionalForm]}, {-0.15000000000000002`, 
      FormBox[
       RowBox[{"-", "0.15000000000000002`"}], TraditionalForm]}, {-0.2, 
      FormBox[
       RowBox[{"-", "0.2`"}], TraditionalForm]}}, None, None},
  PlotRange->{{-3.5, 0}, {-0.24800099501223793`, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, 
    Scaled[0.02]}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389734107357224*^9, 3.389735153378224*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plots by \[Mu]", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Mu]Vals", "=", 
   RowBox[{"Range", "[", 
    RowBox[{"0", ",", ".1", ",", ".01"}], "]"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"r", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"LimitSolve", "[", 
      RowBox[{"5", ",", "5", ",", "#"}], "]"}], "&"}], "/@", " ", 
    "\[Mu]Vals"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"MatrixForm", "[", 
   RowBox[{"r", ",", 
    RowBox[{"TableDirections", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Column", ",", "Column", ",", "Row"}], "}"}]}]}], "]"}], 
  ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Interpolation", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\[Mu]Vals", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{"r", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "j", ",", "3"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"Length", "[", "\[Mu]Vals", "]"}]}], "}"}]}], "]"}], "]"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "5"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"graphText", "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Text", "[", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"t\",
FontSlant->\"Italic\"]\)=5\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"r", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "1", ",", "3"}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"t\",
FontSlant->\"Italic\"]\)=4\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"r", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "2", ",", "3"}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"t\",
FontSlant->\"Italic\"]\)=3\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"r", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "3", ",", "3"}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"t\",
FontSlant->\"Italic\"]\)=2\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"r", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "4", ",", "3"}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"t\",
FontSlant->\"Italic\"]\)=1\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{
          RowBox[{"r", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "5", ",", "3"}], "]"}], "]"}], "-", ".005"}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], "]"}]}], "}"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Mu]Label", "=", "\"\<Price drift, \!\(\*
StyleBox[\"\[Mu]\",
FontSlant->\"Italic\"]\)\>\""}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pA", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"f", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
        "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0.`", ",", "0.1`"}], "}"}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.02`"}], ",", "0.1`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.5`"}], ",", "0"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"Axes", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"True", ",", "None"}], "}"}]}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\[Mu]Label", ",", "\[ScriptL]Label", ",", 
       "\"\<Panel A. Buy limit price placement and drift\>\"", ",", "None"}], 
      "}"}]}], ",", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Range", "[", 
        RowBox[{"0", ",", "0.1`", ",", "0.02`"}], "]"}], ",", 
       RowBox[{"Range", "[", 
        RowBox[{"0", ",", 
         RowBox[{"-", "1.4`"}], ",", 
         RowBox[{"-", "0.2`"}]}], "]"}], ",", "None", ",", "None"}], "}"}]}], 
    ",", 
    RowBox[{"Epilog", "\[Rule]", "graphText"}], ",", 
    RowBox[{"BaseStyle", "\[Rule]", "baseStyle"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389734142464224*^9, 3.3897341449472237`*^9}, {
   3.389734196597224*^9, 3.389734197214224*^9}, 3.389734932225224*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVx384FHYcwPHrks0mq1ycI3XrLP2YVBtZnn2kVJdS06IaS3UdeqpDSlvy
a6qrCCHlRyvpx0Xc4XAe9WFYm7rkdL/vJFGii6sLSey7P97P+3kxd/P891Ip
FIof6f8X9kmipaeYPxpY86PPzNbjPurM+nIaBVyKWK8bHPU4RP9dmEabBv8o
Q3gfZunRs6jEOY42B2IrM3PCHPT49FUz5zDNFWaW3Tm41k6PohQZNZLmBSKq
udtn1npkdKjaDtI2w9XBLvs0cz0+Mg+SHKCFgHITS40GHdKebdye2hAB4nAU
n6rRYeTSvOdTeo6Cjft0TfIpHTpGnzW08hIgr+uG1HqbDkcjd02UNCbD2cSY
Pm8nHZbOt6LnSfkQUlXICR/SYqBZ+xo7l1Ro2voddUWTFvP4tja0u+mwIPOK
4GSmFof7XS1Z985DFNvITedq8VFIwNTYvizYOL6pGty0mLH0ZYbOeAHsAy2s
eRZajChojJwycBGUjIPTe/UabLErCTpimwee7rIRVpkGp72baBlgFMCGo/6+
7//QYJt+52oR+09YXvDMo2SrBpXCEymzqq/ADva5F23OGvRkZtS8qLoK8Ky7
+MCEGoNzv+7b8rAQiuv9vCZkanzfEB7s03oNpO4FCqNAjb5v3RSal0WwYe49
5+7janQZEMT+/PE64Jk6ltUWNZ7MlXH8x27AT/SuhpiFasz3S/Q3zbgFER9X
yY0UNTqLehIZtgLIf2DyyFOr0LtzoINlcxsaKQyBf4UK7egJK9sXFEOU9xKW
wxkVho4390z5tgSGMg6rzDgqPGTISNOtvgNm5V+p5q1QoaVgcmhOYCnE6yWh
x6xVyLBemKAILINv6PcXjr1R4jvv/a06NyHUTjrv+Oq+ErPaC+LTa4RA3e77
uv2aEmPXF66pchfBnmO6OGmCEhubw6eVNohgL31/6vxflOhDt/wY6l0Ong/3
zvZbrkQnXmTvO2k5fKhcNOfJDCV6FYiGVm6uAMcbg2XzBhVYKGqypz6uANnG
+rVHHilwT0vuqqwdlRDW6JjsdVuBO2t9U3q1lZDUYah4wFdgbSkqrcLEcPoJ
j/Kco8Cg0+Y/3DSKwYfe7zK8UoEeK5zvToqqguWLur8oZSow2mi5yuVTFfRR
A96MjsuxL+7hK4f4aqgX3irVd8jx5ttfbx4frwa534DgGsqxcV9lqJBfA8c9
8k0Wl+XIqO1ed91CAnOeTkoajJPj46mqRfuzJWBz6Hx9fLAcOWZhXbHE9Nzd
zceIR0aHc1KJF99b1hJDzOy1nVxGnPVJ1c4jjvorUG0knr198cudxLQY5YmY
CxLYkvSllRfxtk5FR1KOBD5kJwZRiF8ruFmZxL8FR+4aC5JjgnSIXUTcz9zN
HSEW1NqIm4mLrq6JGCQezQo4+/lFCayPtU/uJM5nK9zPEScXmIrriV29uIbL
xOJlJmEdcZPbUGEZ8b9/m8Q1xIa5NlZtxJnPR1BI/OP41m7rSxLIHrZ8coVY
Zuq5xCKui6ap84m5/Yc3fU98941Dx0XiNFV2bQAxW+3am07ManWKCCWWsT0N
KcQ1zWKno8RLqte95RNvqPPR8om5zIDhZOLOcnn6JeIDfM5YAvF/liSj1A==

     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwVyX88E3gcx3G3qNzJw9Uy9FPxeFR3VO7iKvlMJqTksTquTrUkKnOzIh7d
wnr0Qw+cHyn5sauGtIiN+TGP3Cexu1JaKb9usx+YMcdOih4q3ff+eD9ej+fj
7RjOYR6jmJmZBZH9X6FRFtd+2dHryragxdI2A56kLH5YTTWDA+Hv7EKeGHDK
7qw4k2oDRa0e3u//MqBnScWaJOpK8HPhf/aUG1AzIo+Ip24AH8pTt8doQEl6
B4VLpcNr5iGuXmpAB3XPy1+owRAVdMtj600DPp8bJouhsuBjVcLGvXEGpOp2
789ojoXi4FizTfYG5LoVDljoE6G+zEfM/XMIl8eljSk4KcCiMwXshCGc4R75
XNFyAXiSr/kWTkNYudbarrA9Fab8wy7u7tFjqPmrHfauGZATsPDLpFQ9FqbS
bKlNWcDVPOft99Tj9OgGK6c/ciCOmVviNT2Iz1khC3jGXJj+WbPxUOUgZrsZ
slUT16Gm+lQsgz2IsYIWroXpBtwz+XWucBnENvuKsDO0QkiL+YERbhxAm8nP
bSYHAVBX3K0R3x/Al32HGZKAmxA2g+28mAHsFl9MX1Z/C/b7H9Ua1g+gp2N2
w1DdbZhVBpZ2TffjwYJVxr3PhLD2u/HexAf9+K75xEFfRTEoCngRrEv9GPjG
vetvQwn4fhV523F3P7qaRLx9H0ohzmOeOcO2Hy8VdEQwP94BI3YKGIM6LAri
M98uvAtWLsKVzCodrpHo+Q40EVCewLhlsg63a01qJ9t7cES0kv40WIf2dine
r9aVQ9DRq+z2FTqMmpXrLVwqgD3amWI/qcXTY9mZKsZ9eNuac7+mRYtWojlR
eaGVsKxcxnG5rkWHRd+kdIVWgcfrovxf2Vqc3M5WqNzFUErr4S+hazH3lSA5
q0EMefH/bjlP0yJvp3BHnYcExBzrsyatBlvkJ2wqmyWwy1p9TZOhQV87qw9R
26vBr+bYEqO3Bp053OHJ9mpIZtWOfz+hRrpAMuUdXANTgg730DI1CiWtSygv
asAn41zbTpYaj7YV+OQekEKPZUx9A1WNhxsD04eVUiie/BQkVPRhYyV2Wx+v
BdrpTvnmS30YdmXulrKJWhgeuhd8Bfpw89Y1TV+cqgP+/I781lkVxk1Y+bh+
qoPAGVHTQ5kKjUnPRpYm10M5RHtGnlVh2ZtDZedm68EGdiq9tqmw5aQ0Spza
AI9HOQNDH5To0DjoX2opA+P0WLcClfhiQc+37Gsy8GdxSq4mKzHC/Hg/j9hv
6TbzdOL3M9N5GcRpZtYRF4gdh2lzqoibvGWr44lPPQrtnSB+U7qpOISYmtB9
MeG6DHLG5UJ74p+0XerzeTJI9GeU3ExS4j9dkblXiU9+OmN+gzilfSqghPhW
b0VEFrGo0bZWTiydt8qZTzyTG5I2/wb5N7vdCScuCujy+I34wtjIXWfiDfTI
sd+J9Qv3WC4nbnWfElYRzz9cf8KWeGy1rfVL4oTo7HXziL1mfxxclC+DRfui
K4bPKbHjrT7fiVhUOWKlI44cjd+zibh5fXRML3Fmz7XGEOLQ0gTXNmInhXNs
FLE8n5L5iLhBXuucSJwnzTI1Eu964KtMJX70zjG4hlhb3ZmVT0w/WCcuJ/4P
PpekiQ==
     "]]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], LineBox[CompressedData["
1:eJwVy3k4FHgcx3HRpGOynswyZsoaETp0bWxlfd2bDvWodWxDtWHStmWK9EhC
KlsKrSMkmlgNwrjHLl/n7pN1hHJsZpoxxrimCS27bOyvPz7P+3n98WF9f8HN
T11NTc2V7FN5Y8Kgttssm33PHEO3RqrwrPrndSU0NaB8uapm+poKZ+ihxXE0
bShc45tVFapC6+wCs3CaIbQwffc5Bqnw7WizbzBtGzjz6hinOSoUxHapc2m2
YMqnlNQeUiFD3Nd5nnYEAuTx0xMMFbYvYwt/pJ2Ej66WKwwr3yFNesjrXn0g
nP0ias/7YSVyd6TLKPIrwI403XzYQokGQXeVHRciIH+Jqn151ATOcU8tFjRG
Q56O5+WQl+NYaK5FT2+LAUPfoj+oO8fRY2m3s77FPTiwRLNUPWEM02P0dGk1
8bDslkag7twozo5voxrXPoBhfHHHNGgU20+6rw4bSwTbXfFOr0ZHMGGHImFg
MhnKvXsP3zk/goEZjVyK6iH4DuQP0ecV2KJfwL6slw51my7Z3L2hQO3pxRYV
IwNaul5PLNIV2Ck64ShwyYRYb8rOkLxh7C2+GbuuMgv4vG98OPbDaM1KqBqu
eAINzN/ZJ+Vy9E4zGjvayoMXzOx1adFy/Ls+wNup4ylEy9baKLbI8cCUZc9f
imxwzvdxiuoeQgsVP+zYfA7s71+vuSp8CG+ldfm6/fcLtHjWHLfbPoSPXCPd
Pqx5BteUBsGaUhmaCeSRDD0+6LPmO1sfytBeohIb6+ZBkU7aButjMtSnR9h1
b8yH4oXzRVZUGXIWmuWULQXgddwod++fg3hJmRA34PgcBHue39e/PYhUvgYn
xaMQZsZNKQHOg8jQ2RTR41EEhZ0fvu5fNYjT9uc6BiyLIWM2592udikmdmdc
j68qhjmvKVO/ZCmG7ec5V1gJYPsxaLU6JcXG5gDtwnoBvH9vmG9qLkUnOnWe
Y18Ci7QKN9sZCZpc4I5Mt5VAsJao936dBG0zBDN2R0qBxy7jvoiTIE/QxFR/
WQqMldoOO05J8HRLmkPid2Wgmxn7ZHarBE9UH4gdeVMGhvUuMiMNCVYXYq/W
mXIoduiqvJH7Ftk/LduTO1kOp4tCL4kOvsXde81qllysALOmdGuvOTEGTVId
LD5WQJONyWdLn4pxLLx1dO31SohYHic8c1SMuVM+udcWKiHsat1NuqYYG8+W
cYpjqiC8tY+5oUKEjOqhfTkrhJC20mnB8ZwIX67u23wuSQilnuY+inUi9F16
ZjCMuMHckSEm/mduNuUesfYGv55XxKwRPY0iYpssoWsD8cUGj/7JT//UAsgg
poX03gxJFoJfSrXRUWJPSY84KkUIztzLytq1Ipzo8U/8mZia5J5XThzRNuOS
TVw6aM0pIOZX65Y3E4fMM6WpxHOJ7neXPxRCAcv4dRDxI5ceq/vEFlbs2o3E
22z9lY+JZdOPr7KImyxneEXELf2Kr+jEyvW6Wp3E6qzYUgqxzcK3QzqpQlCk
G/AlTBF2fZCnGhP/m/XAv5fYfzz48C5ieTvVuJ04ri+p2p3YMEcn81di4w6T
QA6x16EsdglxVXO5yRViO4OdDD7xwd+c3sQQt+m19mYSS0pex6cST+3+ISmZ
+H/01JDy
     "]]}, 
   {Hue[0.37820393249936934`, 0.6, 0.6], LineBox[CompressedData["
1:eJwVx308E3gcwHGkThfaK2vGObWOHiUvvUquXn3zVDmhS9F56XKleShn65Dr
ljxVrihqeVq60gqX2ORpqvuW5bq6ydOFYjNsHqaZbaLodL/74/P6vN6MQzF7
jhgZGBj4kf5/kUoU23SOsXUV2K/Io+kxymjx40qqAbjPuLg+tNDjJP2k4BKV
Aq+8o437KHrcwi9bmUhdCq3sukaHBXrsHWkMi6M6QUeV7bjkkw6FGW1GbOo2
mPHM/3PdiA6tZV2tP1J3Qz6nLjPxoQ5fzgsRRVNDoeGx41LXIzqk9vl+l/mE
BWnz+b8whVpkO/MG5ioT4N1stNsNqhZtYy+om2OSQMSQnG1LG8dp9g+fysRp
4G8oUfMGNVi+ypzOa0qH67fOa8+NjGGQcft2K8dMOHie1eSsUiMv3ZJGfZQF
PjPOz44YqnFq1MnU7o/LkNBgyKK4vMWXoYFmHBUXcgcSc6OjRjHbeSi7R5sD
+/k714pqVcgqFLPnavJAfLfGRmShwhdWZSHxljywnqKLfaNHkKL/9EJjXQir
lTk0RfcwtkoPegq9fwP16l2BWTuGsVNwJuPL2hsQXBrxQfBoCLcwsusGa27C
9veUhVGeQ3igYJkqQFIE3DtxFs5/DeK7J5EHvJpvwaK04zlngwfRR7ex480Q
H8Z+3uTNHFGio6aUs3fmNoSEFop2n1bi2YK2sD0f78DloxomjaHEa37JeyYW
lUDXApq8HhW4UqhMtrYshTII8zWKVKC7XCOzo/0O7WKr4kOWCrSiJ7m1r74L
Jv6v9gY1DGD4bKNy7toycPaTKLziB/AndfalHs97EJe6EB1WDKBp6Zzw3KBy
oCYlOJX09KO1xZqkjqAKUC376JeS349692PNPRsFwDF7YLI2oB+57YWns+oE
wOC+UfZY9CPnm6LtNS5C4H0mOSPr7ENxYySl/IkQfOOf75vI60MvuulMuHsl
CDKski1C+9A+hj2sb6qE1Pcb9EF2fbitUDjptvs+2Cpi2/aOybFI+PQLo5b7
YNiylKutl+PhFwUe3OAqmJk2T+xOk+PBep+M4e4qMOyxDhEFyLG+HDvNI6rh
5g4P2rslcgz5dd7XxdpqyGJTYjZJe9F188pHhsdrYFPF63vlqb0YqzX1cPy3
BoKli59ttu9FVaJkxOZ0LfhslTGPNcuwWPd98anZWkjg2eRFnZKhOKoqXJBe
B/8EHr5buVyG1vWKnbfni8BknVnJ804ptph1ORy7KgLV8lUpAWlSDDOO6OcQ
F8RVFnsTv5+eys0kvuLo0QTEjGHLORXEa3pP0h2IjzcEvdYSB7l6VBgTU090
njmRIwLdUxdZdaoU98s7ZCm5InjQXuFGJ37bweReIS7wXx5hTpzUNOnNJ55Y
z79oTFxaT6tuJO7ZUNM9niLFaW7gBZM8EYzarI9/TnzNu8PlIvG3R7PKThI7
bWOqrxN/HnGqnUX8dONkUQVxoIQ9zSRWf0UzbyWO/Ju1M4B46+w+hUW+CMZu
PlOsIW6bUObbEfNfaxYsI2aOxvlvIE5IWLKeTnyp62p9ILHbKDfZmNiu2Z4V
TmyFb0qmk6VY11htn0Dc8WFFyzjxrode3enEkTzO1CCxvPJVVj6x+FaXrZT4
P8Whoq4=
     "]]}, 
   {Hue[0.6142719099991583, 0.6, 0.6], LineBox[CompressedData["
1:eJwV0H88E3gcx3EpHulwqmXSjzulzl3ScqXfPqg8clGdijqUK1lcnR9RHj2E
un4QHevIj1GdFLKwaWNKHz/ao7tpft9QNpuZzRDD1j0k7nt/vB+vx/Pft82p
MO8zhgYGBgfI/m++hh8lumXjHEI131bUpsNQwyW1HIoB/D1z0TipSYd6q8vl
qRQLWHGzdzZUqMOdBSy7OMrXkNTaGu1Yr8PeQUFQNIUGDOW6s81sHbJT2gwj
KC6Ah7c7uTJ0aC3tav2Vcgi+b++bMPxRh03G/vzzlEAorLgoHm+fRIrc6/id
unCIFhxtmdMxgRGOTIWRMgberhJ+XvBxHFdGJY80hyVA5uzp+lCHcZyK+HmW
1XAdjq2GJN4ZLZZ+a27FFCXC3ZrD9QH8MfSd1+6+1OEOqN6Ix96bjSEzkWpJ
qUkD833z4+tUH/DjEM3U9tVdiB7y5h2VjWBToI9ZrCYddpmceZj7bhgZjipG
j/Ye3Opcdv7V1BCG5zVEGI1mQYlZQoeGNoTCpSz/i1QmnLZtLHpD16DFxKxw
1DoPNB32mxe+GMRWyck9bI8HcOPkriwwG8TO8hspKyofQqN90RHROTXutGFU
DfD+hA1+9iUJchUG5KzSHH6bD70iD0fmERXq6kIC9jY/gm9oKy8Vdw/g/nEn
8TtVAaT4YkiL3wA6jBbHHvn0GLp/G4ATA0q8mdMW5D39BHo8vxIp45SYe+Cq
9+SiIhiYaL7eRFGiHVt51ZpaDJGLRl7pef3oJhuV2lo+BZsHzsm6E/241CrB
tf27EvD2D3RPnNuP9BmB0mg9C7KDRF12HAVeGGGk9ux5BhYe98u0AQo0LZ5L
z/Qtha0ZXtf05gq0XrwuQexbBvUvgtqn3/ThhNu55h6ncnAN6VvSc6UP09vz
4tOqymH7vci4gB19GPtDvjtvCxt85bTHqdNybBCEWJTWsYEbyLmvrpbjXivT
T3Q3DoweW6t4GS/HNWER6gkRB1xzIpcJXOXoksfWux6qAFacbViviRzz2a+X
GbZUQHyjl6yxQ4anhTm70396Tv4PajHKk+HJ6v0p6vfPYZTmyToUKsPqUuw0
P8uFDSXDawc3ydA/yXh7oZYLQruNJgsNZbhth13NnEgeUG77XZ5T1ItRWtPd
Dp95QP1iC33KvRc1cW8Hl8dXApd/0OHTBykWjp8ovDJTCX85eSoXMKXYEPqc
Xp5YBVdLl2tj3KRoXd2/77EJH6ixg5yF4xJsMeuyP5fBh+DkyTCXPAkGzTvb
F0u84olzuBPxv1MfM+8Q221khNsT26ipc8uIjbIORlgRR9b7dmuJ/Qo3XhjL
lSDlUueNS/f4EFV7O+Yh8TGZWHotkw/HY9OSDIiHxcHpfxB/eUt9W8+UYIJI
71FAfMrAI2WYuLjakisgLnFendpFPJXukzw/iw971DszyolzPcRbfifOUMx7
FEhMcwkeuU9c2aoo8CF+7aTPLyNmrm984kk8strSvJU40qHi6VZi55mj/Yuz
+SDxVnMsiNsmldm2xGnPFnCNiYOHog9uJs6M3lw5nSPB1K6Mah/iX7wKXqiJ
bZvXhNOJlweoa6TEVQLumhji4e5NtR3Eni/3vk8kbmxIqhcSyzj/pGUTs6xV
r2uJ/wNCEq+B
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, None},
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Times", FontSize -> 12},
  Epilog->{
    InsetBox[
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]\\)=5\"", 
      TraditionalForm], {0, -0.45505010297249854`}, {1, 0}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]\\)=4\"", 
      TraditionalForm], {0, -0.7434940846054533}, {1, 0}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]\\)=3\"", 
      TraditionalForm], {0, -0.9845197356749291}, {1, 0}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]\\)=2\"", 
      TraditionalForm], {0, -1.1930162445449497`}, {1, 0}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]\\)=1\"", 
      TraditionalForm], {0, -1.3689300280808312`}, {1, 0}]},
  Frame->True,
  FrameLabel->{
    FormBox[
    "\"Price drift, \
\\!\\(\\*\\nStyleBox[\\\"\[Mu]\\\",\\nFontSlant->\\\"Italic\\\"]\\)\"", 
     TraditionalForm], 
    FormBox[
    "\"Limit price differential, \\!\\(\\*SubscriptBox[\\\"\[ScriptL]\\\", \
\\n StyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]]\\)\\!\\(\\*\\nStyleBox[\
\\\"=\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[SubscriptBox[\\\
\"L\\\", \\\"t\\\"],\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[\\\"-\
\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[SubscriptBox[\\n  \
StyleBox[\\\"p\\\",\\nFontSlant->\\\"Italic\\\"], \\n  \
StyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]],\\nFontSlant->\\\"Italic\\\"\
]\\)\"", TraditionalForm], 
    FormBox[
    "\"Panel A. Buy limit price placement and drift\"", TraditionalForm], 
    None},
  FrameTicks->{{{0., 
      FormBox["0.`", TraditionalForm]}, {0.02, 
      FormBox["0.02`", TraditionalForm]}, {0.04, 
      FormBox["0.04`", TraditionalForm]}, {0.06, 
      FormBox["0.06`", TraditionalForm]}, {0.08, 
      FormBox["0.08`", TraditionalForm]}, {0.1, 
      FormBox["0.1`", TraditionalForm]}}, {{0., 
      FormBox["0.`", TraditionalForm]}, {-0.2, 
      FormBox[
       RowBox[{"-", "0.2`"}], TraditionalForm]}, {-0.4, 
      FormBox[
       RowBox[{"-", "0.4`"}], TraditionalForm]}, {-0.6000000000000001, 
      FormBox[
       RowBox[{"-", "0.6000000000000001`"}], TraditionalForm]}, {-0.8, 
      FormBox[
       RowBox[{"-", "0.8`"}], TraditionalForm]}, {-1., 
      FormBox[
       RowBox[{"-", "1.`"}], TraditionalForm]}, {-1.2000000000000002`, 
      FormBox[
       RowBox[{"-", "1.2000000000000002`"}], TraditionalForm]}, {-1.4, 
      FormBox[
       RowBox[{"-", "1.4`"}], TraditionalForm]}}, None, None},
  PlotRange->{{-0.02, 0.1}, {-1.5, 0}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389734169928224*^9, 3.389734198071224*^9}, 
   3.3897351683192244`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plots by \[Sigma]", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Sigma]Vals", "=", 
   RowBox[{"Range", "[", 
    RowBox[{".1", ",", "1.2", ",", ".1"}], "]"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"r", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"LimitSolve", "[", 
      RowBox[{"5", ",", "5", ",", "0", ",", "#"}], "]"}], "&"}], "/@", " ", 
    "\[Sigma]Vals"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Interpolation", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\[Sigma]Vals", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{"r", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "j", ",", "3"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"Length", "[", "\[Sigma]Vals", "]"}]}], "}"}]}], "]"}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "5"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"graphText", "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Text", "[", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"t\",
FontSlant->\"Italic\"]\)=5\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"1.2", ",", 
         RowBox[{"r", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"Length", "[", "r", "]"}], ",", "1", ",", "3"}], "]"}], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"t\",
FontSlant->\"Italic\"]\)=4\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"1.2", ",", 
         RowBox[{"r", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"Length", "[", "r", "]"}], ",", "2", ",", "3"}], "]"}], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"t\",
FontSlant->\"Italic\"]\)=3\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"1.2", ",", 
         RowBox[{"r", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"Length", "[", "r", "]"}], ",", "3", ",", "3"}], "]"}], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"t\",
FontSlant->\"Italic\"]\)=2\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"1.2", ",", 
         RowBox[{"r", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"Length", "[", "r", "]"}], ",", "4", ",", "3"}], "]"}], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"t\",
FontSlant->\"Italic\"]\)=1\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"1.2", ",", 
         RowBox[{"r", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"Length", "[", "r", "]"}], ",", "5", ",", "3"}], "]"}], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "]"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Sigma]Label", "=", "\"\<Price volatility, \!\(\*
StyleBox[\"\[Sigma]\",
FontSlant->\"Italic\"]\)\>\""}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pB", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"f", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
        "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0.1`", ",", "1.2`"}], "}"}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1.4`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.7`"}], ",", "0"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\[Sigma]Label", ",", "\[ScriptL]Label", ",", 
       "\"\<Panel B. Buy limit price placement and volatility\>\"", ",", 
       "None"}], "}"}]}], ",", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Range", "[", 
        RowBox[{"0", ",", "1.2`", ",", "0.2`"}], "]"}], ",", 
       RowBox[{"Range", "[", 
        RowBox[{"0", ",", 
         RowBox[{"-", "1.4`"}], ",", 
         RowBox[{"-", "0.2`"}]}], "]"}], ",", "None", ",", "None"}], "}"}]}], 
    ",", 
    RowBox[{"Epilog", "\[Rule]", "graphText"}], ",", 
    RowBox[{"BaseStyle", "\[Rule]", "baseStyle"}]}], "]"}]}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.3897342241972237`*^9, 3.389734225599224*^9}, 
   3.389734937753224*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVx3k4FHgYwHFsKFm0SSYzydAqNNUWkW3f2JLKTbap3PUoReShlFjHI4qs
2S6bznHkCLE7xcqbKcky6xozYy5yNeSm2oTd3/7xfb7PxyjwtMcxFSUlJRfS
/89JWjSbnV0FHxpjvhR+bMaLnABtTlkV7OcvM6TONaPvUK1Je30VlO8P8MlQ
5qGRa4yrxlQVqIXcNQvV5GH+qrHc8/uqIQNFGnQ6D588Eboe/lINTuzUOX9n
Hr7uLsqj+tTA00/F0VvZPJywdXe/twaBvZbjZe30N5qz4oMOZHJh2bZQR3Fp
Cxp/q9GRcrgeYs038waiWvFBCfVFMeUNDF+KD+jSaMN1TX41nsub4LR+jHJy
XhtGpnmHmop5sLDKVXpvYzv2j9fqQVgrXPdL5TTUtqP7tRuWRxVtsHVBjbFo
dwfeX/yGYbi3AzgV8Rn8mg6ceZNVdruBDzeNQzKl1nw0Y/6hUWohgMor97l1
BXxk9+aYVF8WQvC0bqWlTicaPaO+vqTWBbvKQ/PpFzsxweej3fvjYqgL4zKs
uztxwOX4bp0hCQS5tsf27xZgus1d9Y2BMvil3cBLq0CAejMbcvvq5JAXbqOR
vyBAz3mz/hLDHggXmonZh4SYrjjZV9HWAwaP1/M1S4XY8PlcfjbrLXiF5THL
VUXIVlc4zrv2gv0+2onVTBFGzCeJipX6QNOMV8LNFaEdZcTc9kUfGL+86vJo
RoQqtIRTKyL7Ie4Gk+eyowuP0s6ln6IPgPKQUTY3sQsbf7QNz+0ZgFktSqRN
cxcaepjbmbIGwSuEtoOuLcazKe86L3u8gzP3Wr5W9hZjxFPVfSe1FcDPanQY
zhbjkVa34huogEDNQpZAKMa92sdbH8YNgaUWPTCZIkFTq5Lez5uGwernnZm3
D0iwgOnB53UPg0nEbyu9MyW4nv0qLfHOe1htbn+6pFmCOfwgi0SXEbjVV6jO
WSTFZRYtrECtUQDfKouVO6V49mTwYEbdKBycHfTfHi3F+IIAilXEGLwbfU7x
LZJi2pJ1OrhxHBgbCp4q9Uox2dNghvV2HL6fKptgrJBhXcAoz9h9AkIrYsP2
OMlQRz8uq6ZsAv6lpf7QkCDDg/Z5TbPqk6A7cWaBVinDB/EVwYXBk/DZOdX5
K4UM+zZ5n59/MQm7mr/xF+nLMaqnaC5TfwoYmrfVtznKcQl7oId1dgqii9wq
tC/I8XoXx9a2dQqObd9DUSmSI9047B/PTdPQKLGu85HK8RHVLsqP2OSRbm0Q
MUNPdyqEWD1xrPoEsc2S6vcJxGG+Ob9HEbuNq3aXEX+o6inIII7780790s3T
8GB+6dXnxGJPHuslMa1+5CBNJkd/5/vaLcRODpcPGBMPOkSmi4ntO9d6rCee
tKGkTBKnUX/ab0m8eM2xGMPvpoHr9nCHM7HVyJzfBeKr7hKji8Q1Ay3SFGK9
cubqJGL77odMFnEyVbAqjdi53dGzkNjAsHH5deKjz645CIlDmm6qPiYefhL8
spf4ULaaSiVxePH2nWPEdlGRC8+IY+/22KhumYZP3ns+vSJWuVXJ0SFuOlI6
/RdxalbKFirxnfDlE63EWleY5abEYazoEQHxr8kWG7YQ23GFCinxfxd7mzo=

     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwVx31cDHYcwPHTnB7Qw8JLnB6t0gOdm7xy2+srNq+wHq4buomUyGTltEao
lF6XLNGVrDmhIikOUXrQt+RIrXXSlY7cddc96eG6rs0yZb/98Xl9Xm+nqPjQ
PSYUCiWI9P8FJ2d+KCysBc74I+9aigSTqyOtqoW1YFfbah9NleBOXePSLlEt
2DevzrC0kKBTcFKwxXgteE5BZaStBK8vGi09uqkOWqbVB2e4SvDu3d7g7f/W
wTHjVLvrZgk+ld28RtvRAPmfRE/MzktwjMliXXZEuMXjCpa59aAnP3X3lrOP
Iex4Qn9qeC+6uFq85G0XAXeOC9/y51d4tZLWVGHXCt1RgWmxyX3o3h7RwLZt
h2m/b3rT86SYkLX1JzdpB3QnHZ3sP/MaB/WNCyBODP02lhqPvDfIyi9YFa19
AVcFGd45Wf14xax1ucPGl9A6+Us2fe9bnGjNFV581g2OPgnJLRtl6MF5YHHb
qweqhrVDzRZyLFEIltad7oWql1t2iffL0ekh7WnmrD5oNwQttOyUY9qOv/2H
9knBmRUfHrBsAFVB+7611r2Gz8w6ioSZA5jtV2S6IqofbK9Fc2YODOCCCe9S
ZfNbCK/v/vMUXYHsKY/BSgc5fAxslFvzFJitjVXeeyGHuV5+DuVdCnw2eeR6
IX8A3LlttotclFhiqg2YClZAdeoq+9J4JXKnTr6qoCihLeWH5k/3lehvN+zJ
bFJCyPsAoe+0Ek2WpB2YnzAI303asHDtIEYvOZJ9wFkFi/94rww5MYjP1zMP
lspVAB/ur85oGUSHUE9/N74a1mxI19+mqPAwTyM5HaqBlMbNjDh/FXJrqJti
rbSgSKRCfKoKw8UhFQWohbnHqif0NSrcaLVPXJyigxqrorZuowrdfCsVkz7v
YJpdKM3xUGMZJ7S7Q/YOLhfknVococZlJU+y0i8NgcUXbfX6AjUKund7pQcN
w7M5z+8Yn6vRxquTH2U5AsWPvhJ5UzR4ODZGfaZ5BPrU827J6BpMLYu08+WO
glNyE6UsUoNZ5u7WuEIP9zIFu+PzNZjBXjzBH9DD46Ya0/7HGmyOHOlwYY0B
1yBeWmXUoPXClNwG4RiMzYjPuemsxbB119o/mBpAkrQjpydQi1dT78WUxxhg
bl/KTsfjWlT6bD061WSAbWN0pUmZFhPlNz+eXTgO39vFfa4Sa9G8RCXnHx6H
/ENhb9jTWjzfV81kisdhxYVDdJm7Dp1d4v5h+xiBfY5xkb1Nhzdo/okRxOYH
XHw4xMsXzBvfTxzmP1+0k9jPvG4ojXh+3/Toj8QheqpMSLwLdetOEKfUXxLN
phtBmmQ/VEksZXfwW4hTmTO/nhWmw12BV6w6iXMSGF2zidUbErKlxLKy6Bgb
YoOfHc9ALKB25NKIzRz3JDmsNMLrCw/UK4l9hz9GHCOe46E+F0HcoOp8wyNe
47PKdQ/xOlkxh0/8icGr308c2BXALicu+XK5OpE4+mH+hl7icloBM5v43d2Y
FgWx0uYvcS7xwYo1a0eJI6hb914gPl4k96MyjMDVLMktJjb5rarampjek+F6
g/hULo9BI85sGam/RWz5K+eOG/FpYRirijgvw8ubQRz4u0j9kPg/QoSd5A==

     "]]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], LineBox[CompressedData["
1:eJwVx3k4FHgYwHGpaKaD1rJmGw9SFOOK1cq2b3Q8pIjZ2p1op3FO0eGxbWlL
KQ85e0xqKTocITbLrtkMjxelLHkachczzAxjmMvoUp72t398n+/zsQ47ERyp
r6enF0D6/wWXl8zn59dDR0XpzSz5IJ7nc4z41fXQEjtoIVYO4s9TTet62uqh
grbl3ibdIFoHJgRSZ+tB8SavbGBhEO9/rSo5u1sA2eaMKmuTIaypGQgM+SgA
DkXCrts6hE9FD0rphxqBURPTOcQbQo1XUNAdK4R1Q+VJlK3D6MC7EL7/aivo
gtJ55n+8Qhtb6suUkDbIyk+KbdAfwXtV9OZKWjtYpDsqOgNGcUMnu5Fp0gno
LfzMrxVhfNqBY3bDXZBOuT81fU6MUnWTGRwXgsQqs23EfgyDcm98EyHvhuzd
9jf53WN4d1m7k6XfS2BsLn/ifGQc59pzqm896wX/O6ZFgQYStGfVUR8y+uH4
kpObC3MlWDxesE6QPgAu57dTXelStH5Ef5pqMAQNHWx3WqUUkw699Z7mDsPw
kby6vxkylAVwdxpPvYIif9EOZp0MMz1vGzqHjYDheltzweYJNJtzLJG0jALN
1c/d/eEEMhfspVWWYth4Trf4ssMkZspjJLXdYuCsyTZuKZzEZx/O3M/njQG7
rVTxu5kciw3lvguB4xCyVlAblS7HuIXLg5V6Enh+sWDRijk5etNmHLyaJcDe
cK3VM2IK9S2SYk3jpaBZ7NLV2TGFERZnMmPXykC6isYMc1Tgv9u9TpaIZRAq
qNXfekOBlsEO3na8CWhiOCZ891aBp1Mm+9KDJ+HxIm41N3Qa4/5ZujvGSA6Q
0bG/v2kaQ4X7Km+gHEQGw28otBn0M+IKixKnIPqgibVLwgzaeVSNf3BRgNOx
nluJ3TNYxgru7RIpYD/LtazeVokbi5+kXSqcBlnJpcHWJCUW9IYzLgXMQMiW
lU6RfUpczXjBC1ulhMrk2bd1Tio8HRM9kdWihC73ohj5RRVeKOPQPOJU0K58
HhAhVGEaZYMxOquBu2PkYex6NSYz18zxxtRQ8r6v91G8Gls4yi6bIA0YfPKb
83+mRmPzxJzGag1QK+gfbVdo8Cef0s55Qy18lWuyLc1Vg/cu1EZXRGuhL6p8
bw1LgxKXA2cXmrXwhXXryrFEDZ4SP/h01XwWMui+XFqxBinFMjHv9Cz0X/x2
3rlDg9eH+F5ewlnwiUtlJas0uNbm+Humiw7Gs8bOdppqsZzufYpNXL9c7iAk
djL7cvYocfZh1eteYk+KYDqJ2P/q/PejxPvUS0XVxKJFqxdriRMbCtuWu+og
ztsjw8xMi8PMLt5j4saDYbc4xIf33jV6QVzfFr4ninhiV3zmMHHOssiFo8Ra
T1qKllhtGs3+hXiZVWSC5SYdrN93xCaV2GPmE/s34lTfqMoq4kbZi9cpxAnu
kaE1xD6iIhaPmP8+fCWfeG+PL7OCeCOVcwKJIx7l7hogFgSx3HqIFTXRj8eJ
m/V+lPYTn6zcsk1F7Hvlh+uviM/dFnsuddPBO6vAd1Ji/by/+MbEjE17yqeI
r+SkuNGJP6/xY6mIV2Ww/rQj/nV0J1VHfC2Z4ehGnJfg0/CO+D/nu5at
     "]]}, 
   {Hue[0.37820393249936934`, 0.6, 0.6], LineBox[CompressedData["
1:eJwVy3k4FHgcx3HJVCZPdIlNkdq0EbU6Vp58d1S6aBzTobRKisUmK0fFKJWr
aTWzUjYsRkosolWsx5dldMzOjqaxbcYxjHEfc1Fk1v764/O8n9cfn1V+oZ5n
dHV0dA6SfW7mNb2pjIwq8BJRP35okmBs5SnDytIq2KHno4r5S4LfDdSuEfGq
oMKUHa4rkuAq+kU6VVUFgtDJeYbtEiz4YjT/0v5qYLvqXbBVS/DJk3f045+q
YXbfgpEb5m3Y1Pn4gdmJGhhMO3o5LboNFY4eHr9aIGTH8W6a2LSjNSfu9KHU
P+Hu65RvOio7cPVa6tuE4zxwvUhj+htLMbfYrK7I9CUkWoQ20YVSXMf3rfFa
zIf2/J3ejfe6MDz58A9WrQJwoLn/Usboxp6xWmM41wyxWa/pO8xl6JGWvsW/
/w1kNIU+0shkmDPvpa35vrfATsuZDLnXg5qX7NL7L8QQtGhCNsSQ43rv36kl
Nv9AHi1L5DyrF7ndmWuqU95BbEN8ubygF1c9N2tKnPMedtMpW2Yd6cOrJyZo
Q4GtUJheUSb/0Ifyg4G7jQYkIOB3+dbn9SPLIXuunV870PWE3vZ7BtBYsyFf
Vt8BKSGGufz2AfTSru8pNpfCst3n4+nMQWT1B8vK30ghMog3+nThEL6YjC7I
4HTBVNccSWvJEHLn9u/V0rtB5Kw9/NRlGMO01/4t0pFB1raTqQzRMNJMh60d
62RwNnG6pipgBHVXXA1ZGt4DrMDlrUHKEfRfEc0KsZRDUNem2X9HjuKrnY7n
86VysI5+1tlCGUNzT2uaFacXrBRu/PbkMYxK6GtJ8ewDty2XWbz5Cgx7Rtkf
bNgPhf6firPdFejT7F6Ujv3AOMBb5nxbgfsMA5vzmAPA5V6JLBMr0Gprcffk
xkEoSPLPX7ZEiQ+9PcWCzkFoDjk20eyhxK+4jcnxWUOwWfyb+EiaEjPFp23i
Dw5DcUhc4xyREhfaCDl+C0Zg5aFryitLVBgVHNB7q34EYp2m7Jw8VRj38JTp
1rBRSFw/LIz/SYXJ+uuM0G4M4D+tKk+owuteyzWcrjGg1sYkbjdQY/2pEcFq
DwXkLnq4p9xNjUYmTHZNqQIszmrvt91S41HnB/ypuUrAal39kldqzI0rDygM
UMK2TAPdVKoGZRsPX9LWKWHaxM7Dfo8GI6SPp1NNVGC0si6pMV6D+ly5lBOl
Ar8ZS587DRq8877S0bFZBbnHxREHdMbRcvW5j14b1WDGtFz7vfM4PjKjRfgS
825TF4cR2xovUQURhxtoZqKJHfSrh64Sq53475OI3cconaXEx9gptx4RM//I
4s3fpAaKynW8j7jVS8BpINZpkfLO7hzHk245hkLimaUT5eeIe13CWa3EvXUG
OZHESgfTBCUxi+F0KYF4nsWZi+Zfk/+FctsC4q3D076XiQUZHXflxDVyYVsC
8fMY6o0RYufOPG8O8cyrbT+OE7uJ9noVEtdw010pu8bR/3mayzviWsaZWV8S
Dz4JaOgmdr+ZOWpDfL5o+7ejxFE2LZLNxDHZUgeKvRpyS/ZX7iLWvVdRaURc
nprIdSVOYifYmxFHSHi3GcQLbnqXWREr2RSmD/HP12022BNvqHAJ9if+H7Kq
pdU=
     "]]}, 
   {Hue[0.6142719099991583, 0.6, 0.6], LineBox[CompressedData["
1:eJwVx3k4FHgYwHG169x2TbV5oumRo9WhKJvFtF7sk6fsMs1MB7WyJCOVY6Uk
kg7lqBipFF1CIVItObaXmGJrmCLK1hjGMMxgLmMo2d/+8X2+z8ciKIK5Z7aO
jo4P6f/nnvx6KienGs6l8sPYcwWYUBloXFleDa0TnvoaEwHuGnpq/YZbDW4f
pJdPUwVoQT9CN1JWQ9lASlaRjQALzUbvxHnVwCHd7H7NzwKsqOii7/xUA0Nn
u6KehQnweU9xAdW/DmqvnPc15ApQTmMwbixB8GS/Yv4U34MrOYm7t154Bi49
RXuWpArR6gej9uSdXAgS789i+PTirVJqfYlpMygo/hkf5/XhspcBdaz5LyGM
4pZ0QtqH0SnbDth08+DCh9yRuioR9o89NYFwPnySJbars/uRcfHSumDJawij
Pj5+P0KMNw2aV5tvagddRrGlzGkA1c2Z5ddedIC9N7ODNWcQV/j9ZVRm2wmH
jF1i5K2DmN+Xa12T2gUZtFsblqVJ0OIJ9fkZvffAzdprcHLLECb5a9ylod3A
2BDSGf7tMIp9QjdQhv6FuzvW6r1/M4zpztf17YI+Qm3e9kdTmVI0Ua+6I2oQ
gCkzpm3GXYas6RX9peZCiJxFbyr8IsN0yT7Rw9dCGBl0rWsuHcEXk7GFOZxe
8NLoLk1gj2K+vmTjNL0PkuQHI8epYxg1ffJdiY4IuDvuxzY2jaG7qWwlrV4E
Vk5nrAvXy3H24qT9C6L7wdvlTD0jQ47Bi2PT91uK4ehEXGh7rxxbfqFF3hGK
4YsTn17rrEBz5kp3G84AKMq63vmlKfBw8uDbVOYgtOzy7osSKTCqStdrn7EE
HDY6+152VuLv/M0ll1AC210bJh+kKHGTcSj/9rEhWG7HW7BdqEQbx9K+Sfth
MGK1rTdbo8IiP2YHr2cYuKY+1quPq3B5flPKiTwpKMyCldK3Kszt2G17wkcG
JjcTAgaWqnGubRsn6LsROF0BbgXxajy8jz1wrmEEGjurZ/7mqTGxKNDUMWoU
/tldtHnr4nFMMVxGQbsxyCl90d8SPY6nWIvUnN4xmF+8RXC9aRwbAkd4Vgw5
2B6Q2JpRNUhZeCyzrlwO7d1VNm5/atDXo+DllL4C8maFTOk1avBW4kP2PbYC
uEvt5q5bNIEi+21x0/UKEEdFb3EKn8AYYfHnCwuV0MJ/vW5X/QQa5ouFnMNK
8Lya45tgpsXs95U0Gl8JIbyYtIIILVpahWtZ9iqIrDK0cuNp8S7VPSaA+Mdr
/L2/Eq82+V4ZRnx6JvfBNmJnwxppEjHFy9P1APHmMd2ecuIqSbffVeJjtXnc
b9aowGfnHI6auJvF4zQS/3Y+Q+9eqxb/8L5p3EZsUKDv85h4wDM6vZs41vVU
NhIrnE2TFcRPJs9ZdxIbLNlzxHytCm5kiTy+atOio+xzwFFi8+DLx/2J68Rt
H5KJ7ctCmkOJPXpu+3GIDeJplIPE3m82su4Rb80fv5FKHPzkomcXsYdlKVYR
D1ewG/uIo9OL9BuJI0tc3EaJNXF36a3E8deFzroOKnAU1/T0E8++8qiSQmwS
+MpGTnw2M9mBSpweKIr4RPxdmt8DG+LigZkqPb4Ws07ZrnIgTpRb6Mwj/g+t
ZK/6
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Times", FontSize -> 12},
  Epilog->{
    InsetBox[
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]\\)=5\"", 
      TraditionalForm], {1.2, -0.4822914413947892}, {-1, 0}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]\\)=4\"", 
      TraditionalForm], {1.2, -0.7920803608390656}, {-1, 0}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]\\)=3\"", 
      TraditionalForm], {1.2, -1.0681073580705875`}, {-1, 0}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]\\)=2\"", 
      TraditionalForm], {1.2, -1.3291973450569934`}, {-1, 0}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]\\)=1\"", 
      TraditionalForm], {1.2, -1.5507984386784197`}, {-1, 0}]},
  Frame->True,
  FrameLabel->{
    FormBox[
    "\"Price volatility, \\!\\(\\*\\nStyleBox[\\\"\[Sigma]\\\",\\nFontSlant->\
\\\"Italic\\\"]\\)\"", TraditionalForm], 
    FormBox[
    "\"Limit price differential, \\!\\(\\*SubscriptBox[\\\"\[ScriptL]\\\", \
\\n StyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]]\\)\\!\\(\\*\\nStyleBox[\
\\\"=\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[SubscriptBox[\\\
\"L\\\", \\\"t\\\"],\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[\\\"-\
\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[SubscriptBox[\\n  \
StyleBox[\\\"p\\\",\\nFontSlant->\\\"Italic\\\"], \\n  \
StyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]],\\nFontSlant->\\\"Italic\\\"\
]\\)\"", TraditionalForm], 
    FormBox[
    "\"Panel B. Buy limit price placement and volatility\"", TraditionalForm],
     None},
  FrameTicks->{{{0., 
      FormBox["0.`", TraditionalForm]}, {0.2, 
      FormBox["0.2`", TraditionalForm]}, {0.4, 
      FormBox["0.4`", TraditionalForm]}, {0.6000000000000001, 
      FormBox["0.6000000000000001`", TraditionalForm]}, {0.8, 
      FormBox["0.8`", TraditionalForm]}, {1., 
      FormBox["1.`", TraditionalForm]}, {1.2, 
      FormBox["1.2`", TraditionalForm]}}, {{0., 
      FormBox["0.`", TraditionalForm]}, {-0.2, 
      FormBox[
       RowBox[{"-", "0.2`"}], TraditionalForm]}, {-0.4, 
      FormBox[
       RowBox[{"-", "0.4`"}], TraditionalForm]}, {-0.6000000000000001, 
      FormBox[
       RowBox[{"-", "0.6000000000000001`"}], TraditionalForm]}, {-0.8, 
      FormBox[
       RowBox[{"-", "0.8`"}], TraditionalForm]}, {-1., 
      FormBox[
       RowBox[{"-", "1.`"}], TraditionalForm]}, {-1.2000000000000002`, 
      FormBox[
       RowBox[{"-", "1.2000000000000002`"}], TraditionalForm]}, {-1.4, 
      FormBox[
       RowBox[{"-", "1.4`"}], TraditionalForm]}}, None, None},
  PlotRange->{{0, 1.4}, {-1.7, 0}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{3.389734257108224*^9, 3.389735182094224*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Combine the graphs", "Subsubsection",
 CellChangeTimes->{{3.389734233471224*^9, 3.389734236375224*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"GraphicsRow", "[", 
    RowBox[{"{", 
     RowBox[{"pA", ",", "pB"}], "}"}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"GrayLevel", "[", "1", "]"}]}]}], "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389734280922224*^9, 3.3897342816492243`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVx384FHYcwPHrks0mq1ycI3XrLP2YVBtZnn2kVJdS06IaS3UdeqpDSlvy
a6qrCCHlRyvpx0Xc4XAe9WFYm7rkdL/vJFGii6sLSey7P97P+3kxd/P891Ip
FIof6f8X9kmipaeYPxpY86PPzNbjPurM+nIaBVyKWK8bHPU4RP9dmEabBv8o
Q3gfZunRs6jEOY42B2IrM3PCHPT49FUz5zDNFWaW3Tm41k6PohQZNZLmBSKq
udtn1npkdKjaDtI2w9XBLvs0cz0+Mg+SHKCFgHITS40GHdKebdye2hAB4nAU
n6rRYeTSvOdTeo6Cjft0TfIpHTpGnzW08hIgr+uG1HqbDkcjd02UNCbD2cSY
Pm8nHZbOt6LnSfkQUlXICR/SYqBZ+xo7l1Ro2voddUWTFvP4tja0u+mwIPOK
4GSmFof7XS1Z985DFNvITedq8VFIwNTYvizYOL6pGty0mLH0ZYbOeAHsAy2s
eRZajChojJwycBGUjIPTe/UabLErCTpimwee7rIRVpkGp72baBlgFMCGo/6+
7//QYJt+52oR+09YXvDMo2SrBpXCEymzqq/ADva5F23OGvRkZtS8qLoK8Ky7
+MCEGoNzv+7b8rAQiuv9vCZkanzfEB7s03oNpO4FCqNAjb5v3RSal0WwYe49
5+7janQZEMT+/PE64Jk6ltUWNZ7MlXH8x27AT/SuhpiFasz3S/Q3zbgFER9X
yY0UNTqLehIZtgLIf2DyyFOr0LtzoINlcxsaKQyBf4UK7egJK9sXFEOU9xKW
wxkVho4390z5tgSGMg6rzDgqPGTISNOtvgNm5V+p5q1QoaVgcmhOYCnE6yWh
x6xVyLBemKAILINv6PcXjr1R4jvv/a06NyHUTjrv+Oq+ErPaC+LTa4RA3e77
uv2aEmPXF66pchfBnmO6OGmCEhubw6eVNohgL31/6vxflOhDt/wY6l0Ong/3
zvZbrkQnXmTvO2k5fKhcNOfJDCV6FYiGVm6uAMcbg2XzBhVYKGqypz6uANnG
+rVHHilwT0vuqqwdlRDW6JjsdVuBO2t9U3q1lZDUYah4wFdgbSkqrcLEcPoJ
j/Kco8Cg0+Y/3DSKwYfe7zK8UoEeK5zvToqqguWLur8oZSow2mi5yuVTFfRR
A96MjsuxL+7hK4f4aqgX3irVd8jx5ttfbx4frwa534DgGsqxcV9lqJBfA8c9
8k0Wl+XIqO1ed91CAnOeTkoajJPj46mqRfuzJWBz6Hx9fLAcOWZhXbHE9Nzd
zceIR0aHc1KJF99b1hJDzOy1nVxGnPVJ1c4jjvorUG0knr198cudxLQY5YmY
CxLYkvSllRfxtk5FR1KOBD5kJwZRiF8ruFmZxL8FR+4aC5JjgnSIXUTcz9zN
HSEW1NqIm4mLrq6JGCQezQo4+/lFCayPtU/uJM5nK9zPEScXmIrriV29uIbL
xOJlJmEdcZPbUGEZ8b9/m8Q1xIa5NlZtxJnPR1BI/OP41m7rSxLIHrZ8coVY
Zuq5xCKui6ap84m5/Yc3fU98941Dx0XiNFV2bQAxW+3am07ManWKCCWWsT0N
KcQ1zWKno8RLqte95RNvqPPR8om5zIDhZOLOcnn6JeIDfM5YAvF/liSj1A==

         "]]}, 
       {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwVyX88E3gcx3G3qNzJw9Uy9FPxeFR3VO7iKvlMJqTksTquTrUkKnOzIh7d
wnr0Qw+cHyn5sauGtIiN+TGP3Cexu1JaKb9usx+YMcdOih4q3ff+eD9ej+fj
7RjOYR6jmJmZBZH9X6FRFtd+2dHryragxdI2A56kLH5YTTWDA+Hv7EKeGHDK
7qw4k2oDRa0e3u//MqBnScWaJOpK8HPhf/aUG1AzIo+Ip24AH8pTt8doQEl6
B4VLpcNr5iGuXmpAB3XPy1+owRAVdMtj600DPp8bJouhsuBjVcLGvXEGpOp2
789ojoXi4FizTfYG5LoVDljoE6G+zEfM/XMIl8eljSk4KcCiMwXshCGc4R75
XNFyAXiSr/kWTkNYudbarrA9Fab8wy7u7tFjqPmrHfauGZATsPDLpFQ9FqbS
bKlNWcDVPOft99Tj9OgGK6c/ciCOmVviNT2Iz1khC3jGXJj+WbPxUOUgZrsZ
slUT16Gm+lQsgz2IsYIWroXpBtwz+XWucBnENvuKsDO0QkiL+YERbhxAm8nP
bSYHAVBX3K0R3x/Al32HGZKAmxA2g+28mAHsFl9MX1Z/C/b7H9Ua1g+gp2N2
w1DdbZhVBpZ2TffjwYJVxr3PhLD2u/HexAf9+K75xEFfRTEoCngRrEv9GPjG
vetvQwn4fhV523F3P7qaRLx9H0ohzmOeOcO2Hy8VdEQwP94BI3YKGIM6LAri
M98uvAtWLsKVzCodrpHo+Q40EVCewLhlsg63a01qJ9t7cES0kv40WIf2dine
r9aVQ9DRq+z2FTqMmpXrLVwqgD3amWI/qcXTY9mZKsZ9eNuac7+mRYtWojlR
eaGVsKxcxnG5rkWHRd+kdIVWgcfrovxf2Vqc3M5WqNzFUErr4S+hazH3lSA5
q0EMefH/bjlP0yJvp3BHnYcExBzrsyatBlvkJ2wqmyWwy1p9TZOhQV87qw9R
26vBr+bYEqO3Bp053OHJ9mpIZtWOfz+hRrpAMuUdXANTgg730DI1CiWtSygv
asAn41zbTpYaj7YV+OQekEKPZUx9A1WNhxsD04eVUiie/BQkVPRhYyV2Wx+v
BdrpTvnmS30YdmXulrKJWhgeuhd8Bfpw89Y1TV+cqgP+/I781lkVxk1Y+bh+
qoPAGVHTQ5kKjUnPRpYm10M5RHtGnlVh2ZtDZedm68EGdiq9tqmw5aQ0Spza
AI9HOQNDH5To0DjoX2opA+P0WLcClfhiQc+37Gsy8GdxSq4mKzHC/Hg/j9hv
6TbzdOL3M9N5GcRpZtYRF4gdh2lzqoibvGWr44lPPQrtnSB+U7qpOISYmtB9
MeG6DHLG5UJ74p+0XerzeTJI9GeU3ExS4j9dkblXiU9+OmN+gzilfSqghPhW
b0VEFrGo0bZWTiydt8qZTzyTG5I2/wb5N7vdCScuCujy+I34wtjIXWfiDfTI
sd+J9Qv3WC4nbnWfElYRzz9cf8KWeGy1rfVL4oTo7HXziL1mfxxclC+DRfui
K4bPKbHjrT7fiVhUOWKlI44cjd+zibh5fXRML3Fmz7XGEOLQ0gTXNmInhXNs
FLE8n5L5iLhBXuucSJwnzTI1Eu964KtMJX70zjG4hlhb3ZmVT0w/WCcuJ/4P
PpekiQ==
         "]]}, 
       {Hue[0.14213595499957954`, 0.6, 0.6], LineBox[CompressedData["
1:eJwVy3k4FHgcx3HRpGOynswyZsoaETp0bWxlfd2bDvWodWxDtWHStmWK9EhC
KlsKrSMkmlgNwrjHLl/n7pN1hHJsZpoxxrimCS27bOyvPz7P+3n98WF9f8HN
T11NTc2V7FN5Y8Kgttssm33PHEO3RqrwrPrndSU0NaB8uapm+poKZ+ihxXE0
bShc45tVFapC6+wCs3CaIbQwffc5Bqnw7WizbzBtGzjz6hinOSoUxHapc2m2
YMqnlNQeUiFD3Nd5nnYEAuTx0xMMFbYvYwt/pJ2Ej66WKwwr3yFNesjrXn0g
nP0ias/7YSVyd6TLKPIrwI403XzYQokGQXeVHRciIH+Jqn151ATOcU8tFjRG
Q56O5+WQl+NYaK5FT2+LAUPfoj+oO8fRY2m3s77FPTiwRLNUPWEM02P0dGk1
8bDslkag7twozo5voxrXPoBhfHHHNGgU20+6rw4bSwTbXfFOr0ZHMGGHImFg
MhnKvXsP3zk/goEZjVyK6iH4DuQP0ecV2KJfwL6slw51my7Z3L2hQO3pxRYV
IwNaul5PLNIV2Ck64ShwyYRYb8rOkLxh7C2+GbuuMgv4vG98OPbDaM1KqBqu
eAINzN/ZJ+Vy9E4zGjvayoMXzOx1adFy/Ls+wNup4ylEy9baKLbI8cCUZc9f
imxwzvdxiuoeQgsVP+zYfA7s71+vuSp8CG+ldfm6/fcLtHjWHLfbPoSPXCPd
Pqx5BteUBsGaUhmaCeSRDD0+6LPmO1sfytBeohIb6+ZBkU7aButjMtSnR9h1
b8yH4oXzRVZUGXIWmuWULQXgddwod++fg3hJmRA34PgcBHue39e/PYhUvgYn
xaMQZsZNKQHOg8jQ2RTR41EEhZ0fvu5fNYjT9uc6BiyLIWM2592udikmdmdc
j68qhjmvKVO/ZCmG7ec5V1gJYPsxaLU6JcXG5gDtwnoBvH9vmG9qLkUnOnWe
Y18Ci7QKN9sZCZpc4I5Mt5VAsJao936dBG0zBDN2R0qBxy7jvoiTIE/QxFR/
WQqMldoOO05J8HRLmkPid2Wgmxn7ZHarBE9UH4gdeVMGhvUuMiMNCVYXYq/W
mXIoduiqvJH7Ftk/LduTO1kOp4tCL4kOvsXde81qllysALOmdGuvOTEGTVId
LD5WQJONyWdLn4pxLLx1dO31SohYHic8c1SMuVM+udcWKiHsat1NuqYYG8+W
cYpjqiC8tY+5oUKEjOqhfTkrhJC20mnB8ZwIX67u23wuSQilnuY+inUi9F16
ZjCMuMHckSEm/mduNuUesfYGv55XxKwRPY0iYpssoWsD8cUGj/7JT//UAsgg
poX03gxJFoJfSrXRUWJPSY84KkUIztzLytq1Ipzo8U/8mZia5J5XThzRNuOS
TVw6aM0pIOZX65Y3E4fMM6WpxHOJ7neXPxRCAcv4dRDxI5ceq/vEFlbs2o3E
22z9lY+JZdOPr7KImyxneEXELf2Kr+jEyvW6Wp3E6qzYUgqxzcK3QzqpQlCk
G/AlTBF2fZCnGhP/m/XAv5fYfzz48C5ieTvVuJ04ri+p2p3YMEcn81di4w6T
QA6x16EsdglxVXO5yRViO4OdDD7xwd+c3sQQt+m19mYSS0pex6cST+3+ISmZ
+H/01JDy
         "]]}, 
       {Hue[0.37820393249936934`, 0.6, 0.6], LineBox[CompressedData["
1:eJwVx308E3gcwHGkThfaK2vGObWOHiUvvUquXn3zVDmhS9F56XKleShn65Dr
ljxVrihqeVq60gqX2ORpqvuW5bq6ydOFYjNsHqaZbaLodL/74/P6vN6MQzF7
jhgZGBj4kf5/kUoU23SOsXUV2K/Io+kxymjx40qqAbjPuLg+tNDjJP2k4BKV
Aq+8o437KHrcwi9bmUhdCq3sukaHBXrsHWkMi6M6QUeV7bjkkw6FGW1GbOo2
mPHM/3PdiA6tZV2tP1J3Qz6nLjPxoQ5fzgsRRVNDoeGx41LXIzqk9vl+l/mE
BWnz+b8whVpkO/MG5ioT4N1stNsNqhZtYy+om2OSQMSQnG1LG8dp9g+fysRp
4G8oUfMGNVi+ypzOa0qH67fOa8+NjGGQcft2K8dMOHie1eSsUiMv3ZJGfZQF
PjPOz44YqnFq1MnU7o/LkNBgyKK4vMWXoYFmHBUXcgcSc6OjRjHbeSi7R5sD
+/k714pqVcgqFLPnavJAfLfGRmShwhdWZSHxljywnqKLfaNHkKL/9EJjXQir
lTk0RfcwtkoPegq9fwP16l2BWTuGsVNwJuPL2hsQXBrxQfBoCLcwsusGa27C
9veUhVGeQ3igYJkqQFIE3DtxFs5/DeK7J5EHvJpvwaK04zlngwfRR7ex480Q
H8Z+3uTNHFGio6aUs3fmNoSEFop2n1bi2YK2sD0f78DloxomjaHEa37JeyYW
lUDXApq8HhW4UqhMtrYshTII8zWKVKC7XCOzo/0O7WKr4kOWCrSiJ7m1r74L
Jv6v9gY1DGD4bKNy7toycPaTKLziB/AndfalHs97EJe6EB1WDKBp6Zzw3KBy
oCYlOJX09KO1xZqkjqAKUC376JeS349692PNPRsFwDF7YLI2oB+57YWns+oE
wOC+UfZY9CPnm6LtNS5C4H0mOSPr7ENxYySl/IkQfOOf75vI60MvuulMuHsl
CDKski1C+9A+hj2sb6qE1Pcb9EF2fbitUDjptvs+2Cpi2/aOybFI+PQLo5b7
YNiylKutl+PhFwUe3OAqmJk2T+xOk+PBep+M4e4qMOyxDhEFyLG+HDvNI6rh
5g4P2rslcgz5dd7XxdpqyGJTYjZJe9F188pHhsdrYFPF63vlqb0YqzX1cPy3
BoKli59ttu9FVaJkxOZ0LfhslTGPNcuwWPd98anZWkjg2eRFnZKhOKoqXJBe
B/8EHr5buVyG1vWKnbfni8BknVnJ804ptph1ORy7KgLV8lUpAWlSDDOO6OcQ
F8RVFnsTv5+eys0kvuLo0QTEjGHLORXEa3pP0h2IjzcEvdYSB7l6VBgTU090
njmRIwLdUxdZdaoU98s7ZCm5InjQXuFGJ37bweReIS7wXx5hTpzUNOnNJ55Y
z79oTFxaT6tuJO7ZUNM9niLFaW7gBZM8EYzarI9/TnzNu8PlIvG3R7PKThI7
bWOqrxN/HnGqnUX8dONkUQVxoIQ9zSRWf0UzbyWO/Ju1M4B46+w+hUW+CMZu
PlOsIW6bUObbEfNfaxYsI2aOxvlvIE5IWLKeTnyp62p9ILHbKDfZmNiu2Z4V
TmyFb0qmk6VY11htn0Dc8WFFyzjxrode3enEkTzO1CCxvPJVVj6x+FaXrZT4
P8Whoq4=
         "]]}, 
       {Hue[0.6142719099991583, 0.6, 0.6], LineBox[CompressedData["
1:eJwV0H88E3gcx3EpHulwqmXSjzulzl3ScqXfPqg8clGdijqUK1lcnR9RHj2E
un4QHevIj1GdFLKwaWNKHz/ao7tpft9QNpuZzRDD1j0k7nt/vB+vx/Pft82p
MO8zhgYGBgfI/m++hh8lumXjHEI131bUpsNQwyW1HIoB/D1z0TipSYd6q8vl
qRQLWHGzdzZUqMOdBSy7OMrXkNTaGu1Yr8PeQUFQNIUGDOW6s81sHbJT2gwj
KC6Ah7c7uTJ0aC3tav2Vcgi+b++bMPxRh03G/vzzlEAorLgoHm+fRIrc6/id
unCIFhxtmdMxgRGOTIWRMgberhJ+XvBxHFdGJY80hyVA5uzp+lCHcZyK+HmW
1XAdjq2GJN4ZLZZ+a27FFCXC3ZrD9QH8MfSd1+6+1OEOqN6Ix96bjSEzkWpJ
qUkD833z4+tUH/DjEM3U9tVdiB7y5h2VjWBToI9ZrCYddpmceZj7bhgZjipG
j/Ye3Opcdv7V1BCG5zVEGI1mQYlZQoeGNoTCpSz/i1QmnLZtLHpD16DFxKxw
1DoPNB32mxe+GMRWyck9bI8HcOPkriwwG8TO8hspKyofQqN90RHROTXutGFU
DfD+hA1+9iUJchUG5KzSHH6bD70iD0fmERXq6kIC9jY/gm9oKy8Vdw/g/nEn
8TtVAaT4YkiL3wA6jBbHHvn0GLp/G4ATA0q8mdMW5D39BHo8vxIp45SYe+Cq
9+SiIhiYaL7eRFGiHVt51ZpaDJGLRl7pef3oJhuV2lo+BZsHzsm6E/241CrB
tf27EvD2D3RPnNuP9BmB0mg9C7KDRF12HAVeGGGk9ux5BhYe98u0AQo0LZ5L
z/Qtha0ZXtf05gq0XrwuQexbBvUvgtqn3/ThhNu55h6ncnAN6VvSc6UP09vz
4tOqymH7vci4gB19GPtDvjtvCxt85bTHqdNybBCEWJTWsYEbyLmvrpbjXivT
T3Q3DoweW6t4GS/HNWER6gkRB1xzIpcJXOXoksfWux6qAFacbViviRzz2a+X
GbZUQHyjl6yxQ4anhTm70396Tv4PajHKk+HJ6v0p6vfPYZTmyToUKsPqUuw0
P8uFDSXDawc3ydA/yXh7oZYLQruNJgsNZbhth13NnEgeUG77XZ5T1ItRWtPd
Dp95QP1iC33KvRc1cW8Hl8dXApd/0OHTBykWjp8ovDJTCX85eSoXMKXYEPqc
Xp5YBVdLl2tj3KRoXd2/77EJH6ixg5yF4xJsMeuyP5fBh+DkyTCXPAkGzTvb
F0u84olzuBPxv1MfM+8Q221khNsT26ipc8uIjbIORlgRR9b7dmuJ/Qo3XhjL
lSDlUueNS/f4EFV7O+Yh8TGZWHotkw/HY9OSDIiHxcHpfxB/eUt9W8+UYIJI
71FAfMrAI2WYuLjakisgLnFendpFPJXukzw/iw971DszyolzPcRbfifOUMx7
FEhMcwkeuU9c2aoo8CF+7aTPLyNmrm984kk8strSvJU40qHi6VZi55mj/Yuz
+SDxVnMsiNsmldm2xGnPFnCNiYOHog9uJs6M3lw5nSPB1K6Mah/iX7wKXqiJ
bZvXhNOJlweoa6TEVQLumhji4e5NtR3Eni/3vk8kbmxIqhcSyzj/pGUTs6xV
r2uJ/wNCEq+B
         "]]}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, None},
      AxesOrigin->{0, 0},
      BaseStyle->{FontFamily -> "Times", FontSize -> 12},
      Epilog->{
        InsetBox[
         FormBox[
         "\"\\!\\(\\*\\nStyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]\\)=5\
\"", TraditionalForm], {0, -0.45505010297249854`}, {1, 0}], 
        InsetBox[
         FormBox[
         "\"\\!\\(\\*\\nStyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]\\)=4\
\"", TraditionalForm], {0, -0.7434940846054533}, {1, 0}], 
        InsetBox[
         FormBox[
         "\"\\!\\(\\*\\nStyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]\\)=3\
\"", TraditionalForm], {0, -0.9845197356749291}, {1, 0}], 
        InsetBox[
         FormBox[
         "\"\\!\\(\\*\\nStyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]\\)=2\
\"", TraditionalForm], {0, -1.1930162445449497`}, {1, 0}], 
        InsetBox[
         FormBox[
         "\"\\!\\(\\*\\nStyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]\\)=1\
\"", TraditionalForm], {0, -1.3689300280808312`}, {1, 0}]},
      Frame->True,
      FrameLabel->{
        FormBox[
        "\"Price drift, \
\\!\\(\\*\\nStyleBox[\\\"\[Mu]\\\",\\nFontSlant->\\\"Italic\\\"]\\)\"", 
         TraditionalForm], 
        FormBox[
        "\"Limit price differential, \
\\!\\(\\*SubscriptBox[\\\"\[ScriptL]\\\", \\n \
StyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]]\\)\\!\\(\\*\\nStyleBox[\\\"=\
\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[SubscriptBox[\\\"L\\\
\", \\\"t\\\"],\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[\\\"-\\\",\
\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[SubscriptBox[\\n  \
StyleBox[\\\"p\\\",\\nFontSlant->\\\"Italic\\\"], \\n  \
StyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]],\\nFontSlant->\\\"Italic\\\"\
]\\)\"", TraditionalForm], 
        FormBox[
        "\"Panel A. Buy limit price placement and drift\"", TraditionalForm], 
        None},
      FrameTicks->{{{0., 
          FormBox["0.`", TraditionalForm]}, {0.02, 
          FormBox["0.02`", TraditionalForm]}, {0.04, 
          FormBox["0.04`", TraditionalForm]}, {0.06, 
          FormBox["0.06`", TraditionalForm]}, {0.08, 
          FormBox["0.08`", TraditionalForm]}, {0.1, 
          FormBox["0.1`", TraditionalForm]}}, {{0., 
          FormBox["0.`", TraditionalForm]}, {-0.2, 
          FormBox[
           RowBox[{"-", "0.2`"}], TraditionalForm]}, {-0.4, 
          FormBox[
           RowBox[{"-", "0.4`"}], TraditionalForm]}, {-0.6000000000000001, 
          FormBox[
           RowBox[{"-", "0.6000000000000001`"}], TraditionalForm]}, {-0.8, 
          FormBox[
           RowBox[{"-", "0.8`"}], TraditionalForm]}, {-1., 
          FormBox[
           RowBox[{"-", "1.`"}], TraditionalForm]}, {-1.2000000000000002`, 
          FormBox[
           RowBox[{"-", "1.2000000000000002`"}], TraditionalForm]}, {-1.4, 
          FormBox[
           RowBox[{"-", "1.4`"}], TraditionalForm]}}, None, None},
      PlotRange->{{-0.02, 0.1}, {-1.5, 0}},
      PlotRangeClipping->True,
      PlotRangePadding->{Automatic, Automatic}], {192., -116.80842387373012`},
      ImageScaled[{0.5, 0.5}], {360., 222.49223594996212`}], InsetBox[
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVx3k4FHgYwHFsKFm0SSYzydAqNNUWkW3f2JLKTbap3PUoReShlFjHI4qs
2S6bznHkCLE7xcqbKcky6xozYy5yNeSm2oTd3/7xfb7PxyjwtMcxFSUlJRfS
/89JWjSbnV0FHxpjvhR+bMaLnABtTlkV7OcvM6TONaPvUK1Je30VlO8P8MlQ
5qGRa4yrxlQVqIXcNQvV5GH+qrHc8/uqIQNFGnQ6D588Eboe/lINTuzUOX9n
Hr7uLsqj+tTA00/F0VvZPJywdXe/twaBvZbjZe30N5qz4oMOZHJh2bZQR3Fp
Cxp/q9GRcrgeYs038waiWvFBCfVFMeUNDF+KD+jSaMN1TX41nsub4LR+jHJy
XhtGpnmHmop5sLDKVXpvYzv2j9fqQVgrXPdL5TTUtqP7tRuWRxVtsHVBjbFo
dwfeX/yGYbi3AzgV8Rn8mg6ceZNVdruBDzeNQzKl1nw0Y/6hUWohgMor97l1
BXxk9+aYVF8WQvC0bqWlTicaPaO+vqTWBbvKQ/PpFzsxweej3fvjYqgL4zKs
uztxwOX4bp0hCQS5tsf27xZgus1d9Y2BMvil3cBLq0CAejMbcvvq5JAXbqOR
vyBAz3mz/hLDHggXmonZh4SYrjjZV9HWAwaP1/M1S4XY8PlcfjbrLXiF5THL
VUXIVlc4zrv2gv0+2onVTBFGzCeJipX6QNOMV8LNFaEdZcTc9kUfGL+86vJo
RoQqtIRTKyL7Ie4Gk+eyowuP0s6ln6IPgPKQUTY3sQsbf7QNz+0ZgFktSqRN
cxcaepjbmbIGwSuEtoOuLcazKe86L3u8gzP3Wr5W9hZjxFPVfSe1FcDPanQY
zhbjkVa34huogEDNQpZAKMa92sdbH8YNgaUWPTCZIkFTq5Lez5uGwernnZm3
D0iwgOnB53UPg0nEbyu9MyW4nv0qLfHOe1htbn+6pFmCOfwgi0SXEbjVV6jO
WSTFZRYtrECtUQDfKouVO6V49mTwYEbdKBycHfTfHi3F+IIAilXEGLwbfU7x
LZJi2pJ1OrhxHBgbCp4q9Uox2dNghvV2HL6fKptgrJBhXcAoz9h9AkIrYsP2
OMlQRz8uq6ZsAv6lpf7QkCDDg/Z5TbPqk6A7cWaBVinDB/EVwYXBk/DZOdX5
K4UM+zZ5n59/MQm7mr/xF+nLMaqnaC5TfwoYmrfVtznKcQl7oId1dgqii9wq
tC/I8XoXx9a2dQqObd9DUSmSI9047B/PTdPQKLGu85HK8RHVLsqP2OSRbm0Q
MUNPdyqEWD1xrPoEsc2S6vcJxGG+Ob9HEbuNq3aXEX+o6inIII7780790s3T
8GB+6dXnxGJPHuslMa1+5CBNJkd/5/vaLcRODpcPGBMPOkSmi4ntO9d6rCee
tKGkTBKnUX/ab0m8eM2xGMPvpoHr9nCHM7HVyJzfBeKr7hKji8Q1Ay3SFGK9
cubqJGL77odMFnEyVbAqjdi53dGzkNjAsHH5deKjz645CIlDmm6qPiYefhL8
spf4ULaaSiVxePH2nWPEdlGRC8+IY+/22KhumYZP3ns+vSJWuVXJ0SFuOlI6
/RdxalbKFirxnfDlE63EWleY5abEYazoEQHxr8kWG7YQ23GFCinxfxd7mzo=

         "]]}, 
       {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwVx31cDHYcwPHTnB7Qw8JLnB6t0gOdm7xy2+srNq+wHq4buomUyGTltEao
lF6XLNGVrDmhIikOUXrQt+RIrXXSlY7cddc96eG6rs0yZb/98Xl9Xm+nqPjQ
PSYUCiWI9P8FJ2d+KCysBc74I+9aigSTqyOtqoW1YFfbah9NleBOXePSLlEt
2DevzrC0kKBTcFKwxXgteE5BZaStBK8vGi09uqkOWqbVB2e4SvDu3d7g7f/W
wTHjVLvrZgk+ld28RtvRAPmfRE/MzktwjMliXXZEuMXjCpa59aAnP3X3lrOP
Iex4Qn9qeC+6uFq85G0XAXeOC9/y51d4tZLWVGHXCt1RgWmxyX3o3h7RwLZt
h2m/b3rT86SYkLX1JzdpB3QnHZ3sP/MaB/WNCyBODP02lhqPvDfIyi9YFa19
AVcFGd45Wf14xax1ucPGl9A6+Us2fe9bnGjNFV581g2OPgnJLRtl6MF5YHHb
qweqhrVDzRZyLFEIltad7oWql1t2iffL0ekh7WnmrD5oNwQttOyUY9qOv/2H
9knBmRUfHrBsAFVB+7611r2Gz8w6ioSZA5jtV2S6IqofbK9Fc2YODOCCCe9S
ZfNbCK/v/vMUXYHsKY/BSgc5fAxslFvzFJitjVXeeyGHuV5+DuVdCnw2eeR6
IX8A3LlttotclFhiqg2YClZAdeoq+9J4JXKnTr6qoCihLeWH5k/3lehvN+zJ
bFJCyPsAoe+0Ek2WpB2YnzAI303asHDtIEYvOZJ9wFkFi/94rww5MYjP1zMP
lspVAB/ur85oGUSHUE9/N74a1mxI19+mqPAwTyM5HaqBlMbNjDh/FXJrqJti
rbSgSKRCfKoKw8UhFQWohbnHqif0NSrcaLVPXJyigxqrorZuowrdfCsVkz7v
YJpdKM3xUGMZJ7S7Q/YOLhfknVococZlJU+y0i8NgcUXbfX6AjUKund7pQcN
w7M5z+8Yn6vRxquTH2U5AsWPvhJ5UzR4ODZGfaZ5BPrU827J6BpMLYu08+WO
glNyE6UsUoNZ5u7WuEIP9zIFu+PzNZjBXjzBH9DD46Ya0/7HGmyOHOlwYY0B
1yBeWmXUoPXClNwG4RiMzYjPuemsxbB119o/mBpAkrQjpydQi1dT78WUxxhg
bl/KTsfjWlT6bD061WSAbWN0pUmZFhPlNz+eXTgO39vFfa4Sa9G8RCXnHx6H
/ENhb9jTWjzfV81kisdhxYVDdJm7Dp1d4v5h+xiBfY5xkb1Nhzdo/okRxOYH
XHw4xMsXzBvfTxzmP1+0k9jPvG4ojXh+3/Toj8QheqpMSLwLdetOEKfUXxLN
phtBmmQ/VEksZXfwW4hTmTO/nhWmw12BV6w6iXMSGF2zidUbErKlxLKy6Bgb
YoOfHc9ALKB25NKIzRz3JDmsNMLrCw/UK4l9hz9GHCOe46E+F0HcoOp8wyNe
47PKdQ/xOlkxh0/8icGr308c2BXALicu+XK5OpE4+mH+hl7icloBM5v43d2Y
FgWx0uYvcS7xwYo1a0eJI6hb914gPl4k96MyjMDVLMktJjb5rarampjek+F6
g/hULo9BI85sGam/RWz5K+eOG/FpYRirijgvw8ubQRz4u0j9kPg/QoSd5A==

         "]]}, 
       {Hue[0.14213595499957954`, 0.6, 0.6], LineBox[CompressedData["
1:eJwVx3k4FHgYwHGpaKaD1rJmGw9SFOOK1cq2b3Q8pIjZ2p1op3FO0eGxbWlL
KQ85e0xqKTocITbLrtkMjxelLHkachczzAxjmMvoUp72t398n+/zsQ47ERyp
r6enF0D6/wWXl8zn59dDR0XpzSz5IJ7nc4z41fXQEjtoIVYO4s9TTet62uqh
grbl3ibdIFoHJgRSZ+tB8SavbGBhEO9/rSo5u1sA2eaMKmuTIaypGQgM+SgA
DkXCrts6hE9FD0rphxqBURPTOcQbQo1XUNAdK4R1Q+VJlK3D6MC7EL7/aivo
gtJ55n+8Qhtb6suUkDbIyk+KbdAfwXtV9OZKWjtYpDsqOgNGcUMnu5Fp0gno
LfzMrxVhfNqBY3bDXZBOuT81fU6MUnWTGRwXgsQqs23EfgyDcm98EyHvhuzd
9jf53WN4d1m7k6XfS2BsLn/ifGQc59pzqm896wX/O6ZFgQYStGfVUR8y+uH4
kpObC3MlWDxesE6QPgAu57dTXelStH5Ef5pqMAQNHWx3WqUUkw699Z7mDsPw
kby6vxkylAVwdxpPvYIif9EOZp0MMz1vGzqHjYDheltzweYJNJtzLJG0jALN
1c/d/eEEMhfspVWWYth4Trf4ssMkZspjJLXdYuCsyTZuKZzEZx/O3M/njQG7
rVTxu5kciw3lvguB4xCyVlAblS7HuIXLg5V6Enh+sWDRijk5etNmHLyaJcDe
cK3VM2IK9S2SYk3jpaBZ7NLV2TGFERZnMmPXykC6isYMc1Tgv9u9TpaIZRAq
qNXfekOBlsEO3na8CWhiOCZ891aBp1Mm+9KDJ+HxIm41N3Qa4/5ZujvGSA6Q
0bG/v2kaQ4X7Km+gHEQGw28otBn0M+IKixKnIPqgibVLwgzaeVSNf3BRgNOx
nluJ3TNYxgru7RIpYD/LtazeVokbi5+kXSqcBlnJpcHWJCUW9IYzLgXMQMiW
lU6RfUpczXjBC1ulhMrk2bd1Tio8HRM9kdWihC73ohj5RRVeKOPQPOJU0K58
HhAhVGEaZYMxOquBu2PkYex6NSYz18zxxtRQ8r6v91G8Gls4yi6bIA0YfPKb
83+mRmPzxJzGag1QK+gfbVdo8Cef0s55Qy18lWuyLc1Vg/cu1EZXRGuhL6p8
bw1LgxKXA2cXmrXwhXXryrFEDZ4SP/h01XwWMui+XFqxBinFMjHv9Cz0X/x2
3rlDg9eH+F5ewlnwiUtlJas0uNbm+Humiw7Gs8bOdppqsZzufYpNXL9c7iAk
djL7cvYocfZh1eteYk+KYDqJ2P/q/PejxPvUS0XVxKJFqxdriRMbCtuWu+og
ztsjw8xMi8PMLt5j4saDYbc4xIf33jV6QVzfFr4ninhiV3zmMHHOssiFo8Ra
T1qKllhtGs3+hXiZVWSC5SYdrN93xCaV2GPmE/s34lTfqMoq4kbZi9cpxAnu
kaE1xD6iIhaPmP8+fCWfeG+PL7OCeCOVcwKJIx7l7hogFgSx3HqIFTXRj8eJ
m/V+lPYTn6zcsk1F7Hvlh+uviM/dFnsuddPBO6vAd1Ji/by/+MbEjE17yqeI
r+SkuNGJP6/xY6mIV2Ww/rQj/nV0J1VHfC2Z4ehGnJfg0/CO+D/nu5at
         "]]}, 
       {Hue[0.37820393249936934`, 0.6, 0.6], LineBox[CompressedData["
1:eJwVy3k4FHgcx3HJVCZPdIlNkdq0EbU6Vp58d1S6aBzTobRKisUmK0fFKJWr
aTWzUjYsRkosolWsx5dldMzOjqaxbcYxjHEfc1Fk1v764/O8n9cfn1V+oZ5n
dHV0dA6SfW7mNb2pjIwq8BJRP35okmBs5SnDytIq2KHno4r5S4LfDdSuEfGq
oMKUHa4rkuAq+kU6VVUFgtDJeYbtEiz4YjT/0v5qYLvqXbBVS/DJk3f045+q
YXbfgpEb5m3Y1Pn4gdmJGhhMO3o5LboNFY4eHr9aIGTH8W6a2LSjNSfu9KHU
P+Hu65RvOio7cPVa6tuE4zxwvUhj+htLMbfYrK7I9CUkWoQ20YVSXMf3rfFa
zIf2/J3ejfe6MDz58A9WrQJwoLn/Usboxp6xWmM41wyxWa/pO8xl6JGWvsW/
/w1kNIU+0shkmDPvpa35vrfATsuZDLnXg5qX7NL7L8QQtGhCNsSQ43rv36kl
Nv9AHi1L5DyrF7ndmWuqU95BbEN8ubygF1c9N2tKnPMedtMpW2Yd6cOrJyZo
Q4GtUJheUSb/0Ifyg4G7jQYkIOB3+dbn9SPLIXuunV870PWE3vZ7BtBYsyFf
Vt8BKSGGufz2AfTSru8pNpfCst3n4+nMQWT1B8vK30ghMog3+nThEL6YjC7I
4HTBVNccSWvJEHLn9u/V0rtB5Kw9/NRlGMO01/4t0pFB1raTqQzRMNJMh60d
62RwNnG6pipgBHVXXA1ZGt4DrMDlrUHKEfRfEc0KsZRDUNem2X9HjuKrnY7n
86VysI5+1tlCGUNzT2uaFacXrBRu/PbkMYxK6GtJ8ewDty2XWbz5Cgx7Rtkf
bNgPhf6firPdFejT7F6Ujv3AOMBb5nxbgfsMA5vzmAPA5V6JLBMr0Gprcffk
xkEoSPLPX7ZEiQ+9PcWCzkFoDjk20eyhxK+4jcnxWUOwWfyb+EiaEjPFp23i
Dw5DcUhc4xyREhfaCDl+C0Zg5aFryitLVBgVHNB7q34EYp2m7Jw8VRj38JTp
1rBRSFw/LIz/SYXJ+uuM0G4M4D+tKk+owuteyzWcrjGg1sYkbjdQY/2pEcFq
DwXkLnq4p9xNjUYmTHZNqQIszmrvt91S41HnB/ypuUrAal39kldqzI0rDygM
UMK2TAPdVKoGZRsPX9LWKWHaxM7Dfo8GI6SPp1NNVGC0si6pMV6D+ly5lBOl
Ar8ZS587DRq8877S0bFZBbnHxREHdMbRcvW5j14b1WDGtFz7vfM4PjKjRfgS
825TF4cR2xovUQURhxtoZqKJHfSrh64Sq53475OI3cconaXEx9gptx4RM//I
4s3fpAaKynW8j7jVS8BpINZpkfLO7hzHk245hkLimaUT5eeIe13CWa3EvXUG
OZHESgfTBCUxi+F0KYF4nsWZi+Zfk/+FctsC4q3D076XiQUZHXflxDVyYVsC
8fMY6o0RYufOPG8O8cyrbT+OE7uJ9noVEtdw010pu8bR/3mayzviWsaZWV8S
Dz4JaOgmdr+ZOWpDfL5o+7ejxFE2LZLNxDHZUgeKvRpyS/ZX7iLWvVdRaURc
nprIdSVOYifYmxFHSHi3GcQLbnqXWREr2RSmD/HP12022BNvqHAJ9if+H7Kq
pdU=
         "]]}, 
       {Hue[0.6142719099991583, 0.6, 0.6], LineBox[CompressedData["
1:eJwVx3k4FHgYwHG169x2TbV5oumRo9WhKJvFtF7sk6fsMs1MB7WyJCOVY6Uk
kg7lqBipFF1CIVItObaXmGJrmCLK1hjGMMxgLmMo2d/+8X2+z8ciKIK5Z7aO
jo4P6f/nnvx6KienGs6l8sPYcwWYUBloXFleDa0TnvoaEwHuGnpq/YZbDW4f
pJdPUwVoQT9CN1JWQ9lASlaRjQALzUbvxHnVwCHd7H7NzwKsqOii7/xUA0Nn
u6KehQnweU9xAdW/DmqvnPc15ApQTmMwbixB8GS/Yv4U34MrOYm7t154Bi49
RXuWpArR6gej9uSdXAgS789i+PTirVJqfYlpMygo/hkf5/XhspcBdaz5LyGM
4pZ0QtqH0SnbDth08+DCh9yRuioR9o89NYFwPnySJbars/uRcfHSumDJawij
Pj5+P0KMNw2aV5tvagddRrGlzGkA1c2Z5ddedIC9N7ODNWcQV/j9ZVRm2wmH
jF1i5K2DmN+Xa12T2gUZtFsblqVJ0OIJ9fkZvffAzdprcHLLECb5a9ylod3A
2BDSGf7tMIp9QjdQhv6FuzvW6r1/M4zpztf17YI+Qm3e9kdTmVI0Ua+6I2oQ
gCkzpm3GXYas6RX9peZCiJxFbyr8IsN0yT7Rw9dCGBl0rWsuHcEXk7GFOZxe
8NLoLk1gj2K+vmTjNL0PkuQHI8epYxg1ffJdiY4IuDvuxzY2jaG7qWwlrV4E
Vk5nrAvXy3H24qT9C6L7wdvlTD0jQ47Bi2PT91uK4ehEXGh7rxxbfqFF3hGK
4YsTn17rrEBz5kp3G84AKMq63vmlKfBw8uDbVOYgtOzy7osSKTCqStdrn7EE
HDY6+152VuLv/M0ll1AC210bJh+kKHGTcSj/9rEhWG7HW7BdqEQbx9K+Sfth
MGK1rTdbo8IiP2YHr2cYuKY+1quPq3B5flPKiTwpKMyCldK3Kszt2G17wkcG
JjcTAgaWqnGubRsn6LsROF0BbgXxajy8jz1wrmEEGjurZ/7mqTGxKNDUMWoU
/tldtHnr4nFMMVxGQbsxyCl90d8SPY6nWIvUnN4xmF+8RXC9aRwbAkd4Vgw5
2B6Q2JpRNUhZeCyzrlwO7d1VNm5/atDXo+DllL4C8maFTOk1avBW4kP2PbYC
uEvt5q5bNIEi+21x0/UKEEdFb3EKn8AYYfHnCwuV0MJ/vW5X/QQa5ouFnMNK
8Lya45tgpsXs95U0Gl8JIbyYtIIILVpahWtZ9iqIrDK0cuNp8S7VPSaA+Mdr
/L2/Eq82+V4ZRnx6JvfBNmJnwxppEjHFy9P1APHmMd2ecuIqSbffVeJjtXnc
b9aowGfnHI6auJvF4zQS/3Y+Q+9eqxb/8L5p3EZsUKDv85h4wDM6vZs41vVU
NhIrnE2TFcRPJs9ZdxIbLNlzxHytCm5kiTy+atOio+xzwFFi8+DLx/2J68Rt
H5KJ7ctCmkOJPXpu+3GIDeJplIPE3m82su4Rb80fv5FKHPzkomcXsYdlKVYR
D1ewG/uIo9OL9BuJI0tc3EaJNXF36a3E8deFzroOKnAU1/T0E8++8qiSQmwS
+MpGTnw2M9mBSpweKIr4RPxdmt8DG+LigZkqPb4Ws07ZrnIgTpRb6Mwj/g+t
ZK/6
         "]]}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->True,
      AxesOrigin->{0, 0},
      BaseStyle->{FontFamily -> "Times", FontSize -> 12},
      Epilog->{
        InsetBox[
         FormBox[
         "\"\\!\\(\\*\\nStyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]\\)=5\
\"", TraditionalForm], {1.2, -0.4822914413947892}, {-1, 0}], 
        InsetBox[
         FormBox[
         "\"\\!\\(\\*\\nStyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]\\)=4\
\"", TraditionalForm], {1.2, -0.7920803608390656}, {-1, 0}], 
        InsetBox[
         FormBox[
         "\"\\!\\(\\*\\nStyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]\\)=3\
\"", TraditionalForm], {1.2, -1.0681073580705875`}, {-1, 0}], 
        InsetBox[
         FormBox[
         "\"\\!\\(\\*\\nStyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]\\)=2\
\"", TraditionalForm], {1.2, -1.3291973450569934`}, {-1, 0}], 
        InsetBox[
         FormBox[
         "\"\\!\\(\\*\\nStyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]\\)=1\
\"", TraditionalForm], {1.2, -1.5507984386784197`}, {-1, 0}]},
      Frame->True,
      FrameLabel->{
        FormBox[
        "\"Price volatility, \
\\!\\(\\*\\nStyleBox[\\\"\[Sigma]\\\",\\nFontSlant->\\\"Italic\\\"]\\)\"", 
         TraditionalForm], 
        FormBox[
        "\"Limit price differential, \
\\!\\(\\*SubscriptBox[\\\"\[ScriptL]\\\", \\n \
StyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]]\\)\\!\\(\\*\\nStyleBox[\\\"=\
\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[SubscriptBox[\\\"L\\\
\", \\\"t\\\"],\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[\\\"-\\\",\
\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[SubscriptBox[\\n  \
StyleBox[\\\"p\\\",\\nFontSlant->\\\"Italic\\\"], \\n  \
StyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]],\\nFontSlant->\\\"Italic\\\"\
]\\)\"", TraditionalForm], 
        FormBox[
        "\"Panel B. Buy limit price placement and volatility\"", 
         TraditionalForm], None},
      FrameTicks->{{{0., 
          FormBox["0.`", TraditionalForm]}, {0.2, 
          FormBox["0.2`", TraditionalForm]}, {0.4, 
          FormBox["0.4`", TraditionalForm]}, {0.6000000000000001, 
          FormBox["0.6000000000000001`", TraditionalForm]}, {0.8, 
          FormBox["0.8`", TraditionalForm]}, {1., 
          FormBox["1.`", TraditionalForm]}, {1.2, 
          FormBox["1.2`", TraditionalForm]}}, {{0., 
          FormBox["0.`", TraditionalForm]}, {-0.2, 
          FormBox[
           RowBox[{"-", "0.2`"}], TraditionalForm]}, {-0.4, 
          FormBox[
           RowBox[{"-", "0.4`"}], TraditionalForm]}, {-0.6000000000000001, 
          FormBox[
           RowBox[{"-", "0.6000000000000001`"}], TraditionalForm]}, {-0.8, 
          FormBox[
           RowBox[{"-", "0.8`"}], TraditionalForm]}, {-1., 
          FormBox[
           RowBox[{"-", "1.`"}], TraditionalForm]}, {-1.2000000000000002`, 
          FormBox[
           RowBox[{"-", "1.2000000000000002`"}], TraditionalForm]}, {-1.4, 
          FormBox[
           RowBox[{"-", "1.4`"}], TraditionalForm]}}, None, None},
      PlotRange->{{0, 1.4}, {-1.7, 0}},
      PlotRangeClipping->True,
      PlotRangePadding->{Automatic, Automatic}], {576., -116.80842387373012`},
      ImageScaled[{0.5, 0.5}], {360., 222.49223594996212`}]}, {}},
  Background->GrayLevel[1],
  ContentSelectable->True,
  ImageSize->{641.9999999999989, Automatic},
  PlotRangePadding->{6, 5}]], "Output",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389734269206224*^9, 3.3897342823152237`*^9}, 
   3.389735182252224*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plots by \[Lambda] (not used in book)", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Lambda]Vals", "=", 
   RowBox[{"Range", "[", 
    RowBox[{"1", ",", "6", ",", ".2"}], "]"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"r", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"LimitSolve", "[", 
      RowBox[{"5", ",", "#"}], "]"}], "&"}], "/@", " ", "\[Lambda]Vals"}]}], 
  ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Interpolation", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\[Lambda]Vals", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{"r", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "j", ",", "3"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"Length", "[", "\[Lambda]Vals", "]"}]}], "}"}]}], "]"}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "5"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"graphText", "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Text", "[", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"t\",
FontSlant->\"Italic\"]\)=5\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", 
         RowBox[{"r", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"Length", "[", "r", "]"}], ",", "1", ",", "3"}], "]"}], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"t\",
FontSlant->\"Italic\"]\)=4\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", 
         RowBox[{"r", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"Length", "[", "r", "]"}], ",", "2", ",", "3"}], "]"}], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"t\",
FontSlant->\"Italic\"]\)=3\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", 
         RowBox[{"r", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"Length", "[", "r", "]"}], ",", "3", ",", "3"}], "]"}], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"t\",
FontSlant->\"Italic\"]\)=2\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", 
         RowBox[{
          RowBox[{"r", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"Length", "[", "r", "]"}], ",", "4", ",", "3"}], "]"}], 
           "]"}], "-", ".05"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"t\",
FontSlant->\"Italic\"]\)=1\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", 
         RowBox[{
          RowBox[{"r", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"Length", "[", "r", "]"}], ",", "5", ",", "3"}], "]"}], 
           "]"}], "-", ".1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "]"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabelAutoDelete->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
       "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "6"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "7"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", "3.5`"}]}], "}"}]}], "}"}]}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\[Lambda], c density parameter\>\"", ",", "\[ScriptL]Label", ",", 
      "None", ",", "None"}], "}"}]}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Range", "[", 
       RowBox[{"1", ",", "6", ",", "1"}], "]"}], ",", 
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", 
        RowBox[{"-", "3"}], ",", 
        RowBox[{"-", "1"}]}], "]"}], ",", "None", ",", "None"}], "}"}]}], ",",
    
   RowBox[{"Epilog", "\[Rule]", "graphText"}], ",", 
   RowBox[{"BaseStyle", "\[Rule]", "baseStyle"}]}], "]"}]], "Input",
 CellLabelAutoDelete->True,
 CellChangeTimes->{{3.389734949419224*^9, 3.389734974646224*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVznk41fkeB/BjjRTn4JzfaEGyjKUjJFzV72u5OBGmsUyS7KJGKLI0Tbl4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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwVzns0lGkAx/Exg8Ylt2FeyilqSi4plqiY93HZIspl3cNpDDkoSqmwRYmo
RAjlxLahsyTUWveeQS4hQlmbKaR3EI0x7o3LPv74nd/5/PfV9AtzDiCTSCQv
tI2XNPDfSiIJ8KaYndz2IySOEbVPxUZSgPdO8FM6LUkc9pCFQqqsAD/qaJrx
nknicJK3S2ioCfAyYXDS0AESJ+r7Jz5uKMCDSz3E1bRInOmnTo0x/gKcrpqn
t7yJxBmg40HrbQKcdgSkdWSuw79W1CrX7s/gwdKhiR7la3De+HzOu19n8Y/D
DMnc+RX4yeHi7lruHC4dh7v1pYrgych205KQBTyzY+Tmqu9PGK/QmB6mvoTz
nckcTZNlaJMY8MCxbBmvD0ugG1kswZdni4bETovwFKeEIOC4CKv9LMsraau4
xKlp1dKoBehlmqB9N38NZ45Pb7Z+Mw976o0jsnVJQNtHm9opNw8bHNb2RC2Q
gH/gy12s8DkYG3ROw7deDAwLKp6Sv81C2qFfzHQekIG4CI/d7TILhT/tiuN9
KSDBsaZpsV8IC8IrmG9NxQHVpRyfchdCrfA2FXl5CSB2uW279ugMnGcZgG/9
EsDrrHnLw99nYBZ18t6TUklw0TA6rYQ2A+Pzfu7nR24C/PGGZbVKATz6w2tx
hysVSIkXajI8BHCg0V/MS08KmCbGbnqxPg0rEt/4asxLgUKFz0tU9jQ8LREx
3NUlDTLpAxynBj5kh0dXyD6SATwGV8g24MN9gbpd9ixZMGgd/ymo6AfsVtKT
iTi4GWR90CP7bPsBa1/cyNGjyIGytMBF8ydTMFpMx7Hzsxy4bRmZf2z7FJTm
RtmE/i0PlL4MhskVTMILfQrtDkwFMNlFNowxmYR2GbI3uEUKYK/u41Fm83do
e/zV6H4FRZA+dqszz/c71G/XD0y4oAiOSe3hpa9OwKt/9q44DCmC41UGUutZ
E1AYrmk2YqUESnizKTfNJmBPbnYyr0wJXLdfrfqHOw77G2sSX9FpYFD72XXb
hHHYVFRecD2KBoSzvs1uRuNwC//9hyYeDbgOxy96fhmDWdo5Je/slMHhuoCl
iNQxeI2TnG1XrQw+qN9TamaOQfutrgXtDBXgcqlVmSzkQRDaelIxSQWEyO2K
O/OcB3PV/Rid8ypA+eO5CQqLB3c2Pcs8cZIOTuiSPR3VeTBlb6NO72s6UGo/
PxcwSMCAWfGetzoYWNhj2BryiIDeRdZd3noY6JsUuN16SEAX1s2O6b0YwNy7
vJ5mE9C6m9KiYoCBORlKAzeTgIxici3LBANcw11013QCfvMjFSxbYUAmo9/T
+y4B2b2iK9o+GIh7yBS1XSMgq1yokZSCAS+fYhvTAAK2SEXzze9jwCKNX+rv
T0A9P0qdMA0DopWI1vtsAi4pKbt7Z2JAPJ4izWcR8N5F4+R9jzGA/7s4/cKX
gDUmV5Y/FmFg1PJgv7MHAZVfr/bsaMGAlm59k5Y9AVvbqXF1KxhQ/Vo1pHuA
gMFWI6lvkf+oPUvRQparq87tR+7KdtHagexWElwjQO71qwpTRealdM4wVjEQ
6zZAlkAWd009lYwc9ybK8IsxAS2HMKbvGgYeiZwqU5F57gK7EOSMNNuRO8i3
37d5XkGecr4gcwu5tyEyIg053MXn1FVkVv7g8xbk7ug7ssHIsUF5W/etY+Ar
2ynUCpnx9bK2GbLFtjM5TOQ2L0cTW2SucnXbQWQFe7Hf2MjRtRM79yPn6bNv
ZyH7yRdy1Tf6nh3OzkfO63SWUd3o265cWI6c0G1wiIasr9jc0IFMLU7Iltro
S3rcPYC8Hr/SKo58iXzpM4HsXpy/uG5EwC3RJyaFyObqMVoi5Nezu5fXkYf/
u+O+gPw/g2LUPA==
     "]]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], LineBox[CompressedData["
1:eJwV0nk41dkfB/DrXrIO13bPtEwUU3ZJJdW4H4SKsVMhdS01yVKiwZUSGpmU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     "]]}, 
   {Hue[0.37820393249936934`, 0.6, 0.6], LineBox[CompressedData["
1:eJwVzn881HcAx/G7c1+dOO5wd4XVhZVfiWI1mu9HNbHjqB76cZrlV43aKcbC
lGoaHtQto1s/aMXIUi55tKQ+X6cfXH7mEk0P1ZbWlH3vl8s5d/v44/14P57/
vZYkpm9OoVEoFCHa3Fv6JztTKCQueetH0o5iRABjkBNuSeI+Lhmv2fkYkTQW
ypLYkDgIiyHdDmIEUbYY4y8k8TAvN7BJjBG5/z6bxFeS+GLlC2m/CCP+u7RJ
fjiZxPe219/YFYARw1w81dxJ4v9UDN5rfUsnLhsX3jT9pMLt5CNy/U46oQs8
cLbncw1e6TC0TBhtQTyL/nbp7VEtrryTzw7OoRFxOYo1jXun8GhoVtzvoBKF
LHl5ussH3FoiVKZyqER4UUpFTNM0HjxSvLG8kEJc/6ZhjLp7Br+24en1q2oz
vJW4TnbTYRanhUpOJc2YoGjNcc/SGhN+bmfzzXceJjhwJzBL6k0BvU4uKVHb
Z2F7tMkjd4oCtrq20WdqjLAgdT8//g4VXCjZ3+lHM0KHoFVrvSpoIBZb0Wsb
PwPVBsHvhfEW4KJSvKW0zwBrM1pCutbQgVT0wHolboDLMjo5dnYYMCdOjnS1
TkNdgj/4ewgDEZdFDFnYNDzNmDjx6zVLQO1snFjS/wEWVhv8JnPmAf86i6iW
PR/gxvcivWssA4wteOChMOrhsDyZKvKxAlXM+pYTv+hhS9G9eL7OClx8Ir5y
I1QPd2NZL3p754PMbRbb/d5MwaSMvBabM9ag5ILC+KhyCq7Y490bmWADsl07
IiWCKdhn72Od9SkTnL/XY391VgdvXz161sfCFnzpu3rVhj90MI/qFdP93Bac
V1lJd+7XwfmjueHiG3YAC9IunfDRwcxBliI6hAXwoAXsGlILBT/bHB1tYIHv
E34ImJZpYURU819+LDYYqDfMH8vRQl+F757jmWxQXhJ6zrRBC/MvPjZGj7GB
s9J26ClTC9UZS9a+XG8PRq3LD301qoEDVdKy8SZ70N2e9qS/XgOH5K1FzVwH
ED6QbD6Wq4EdDbLaI7kO4PZ7hkebUAOdJvuVHeMOgCvSO83yNfC059nGHoEj
eLdyZuStXg0PEWVSwS1H4Lc1kYL1qGGkc2ytwp0Dhva9a42qUUMgfhjHLuaA
c2cMadWH1bDKJdG9W8cBArPbJfEONXTrqKsUxnGB1XVCOm+1Gp5cLvd6fJcL
vF/lL9rBVcMUDX2gy4sHFn2Ux2jQqGCCTM0vPskDpa9dPZoGVfChgnGszcgD
An5MBUemgmnrX0q6kDeT29PZyLZtt6qGkN+U7YpgIm9tTGslkZn++2bpyOMn
u1XuszyQZZ+Vom1SQXqsZFcZ8jznqMBB5HVjvJB4Ew88Y3KUEuTxbaRgLzI/
SN9YilzS37njIHK67/CPRciP23OyTiFniyuDC5ATav688gB520b6pXTkgtRq
5xVmHmgOrD0gRHZ/9Z3nWuS+nkzBF8idopjVEcj+3qEfhyGzIqlbkpC5gcPD
nyFX+yaVnEYuLdDjy+f66oKlNci0kLaFnnN9ix1/kyHHwcMad2Rf9v32R8hW
TIs6l7m+4vN9w8iWI/KCBcjZtOznr5E/+fqIyBHZKU84oUYWt4YEsJDvapZO
m5EL+gxMG+T/ARXseNs=
     "]]}, 
   {Hue[0.6142719099991583, 0.6, 0.6], LineBox[CompressedData["
1:eJwVzn8w1Hkcx/FdLJvQrrV20E1EOhIqJnWu76c1ZrF7u47QrUn5lWhCOpWt
7rRFfiQ/qluXOUb5cSmiMo7K52sprE2ojB+bH8neXa5aP/aXrL2PP97znsfM
64+nQ0xKSLwBgUDgolv7xjvi7AgEBXbmavyRyk0muBf5NT3AWIHpDs3vDLU1
wWMn91OKzBQYZitNJdNNcLxgE8neRoGFi0edL5ia4IKPY5+xnQrMXebPKlQa
41/u/Cj+NU6BvSiebjwgNcZHrLFEfY8COzbhMhN+3hi/u2LTslo8jzlKrar6
Z0m40vtk2Uv/RUzeEOD31wsjfIz3s/MT2RJmDefTmB8M8cgMiU/9cRVms3C3
OG2LIZ5FEV9P2ajBjklMEmaTDfCAnPibwY1a7HCu/yPTUSL+8ETdJPHoV2zo
QJDLRRYRb41hNrXQdNiJj26Nrd0EnO+T7XK1ahUzlN3P40cS8MFn3uml2wig
MmWs/s6UHnbwVr8VqAiAj80+wFz0MDMx1T7qGRG8ldR6BV9ahbS9u3xdbxqA
Xcy5e/kyHVxYZt/LijIEMdVvSb4cHaxOa97X62MEsuXpM7ltK3BrWg99wwYS
YG885XrYewUqo3eAD8MkAP/WsIgdX6GIPHet8oExYKyT5IuCvsKsimXPzxkm
wJUbYVD/fhmyPvHVm8PIoNYj813D2WU4Io4j8t3WgSOs/NRm62XYnNMVZa9c
ByITQ/NCcC08Skqf6u83Bcu0PrOmBC2MTTvXbHZrPagoSXwZYqOFHgnb+jnR
ZsCctdTOHdDAV5Zu69P3mANB6TDPKksDnzQIy9wMLYDlQ8OtUUwNPEd0DZa+
swBwkdJYoVNDU5kgIPnxBlA8VHpS+EwNT72mSHj7KGDUr6cr57Iasm+YCWV1
FNCy8L26JlANA394NONJoQIVcXR8P10N3SXuCdmnqGDA/N9D2z+o4IXbQyu8
SSrQFjKfhzep4EKag++0nyWorgkSUS6r4GB5aYG80RIIM2vBnjAVHBa35Tyy
poFuj5zbGdtUsLOuqfqigAaeF3NtA41U0PbzwJtOOQ3M2tXp/hxXQpFLWf1L
thXwDAy0P9+ihL/gBaXsVivQdkMssChRQo5dWLXEiQ7OyhjR8mQlBMndkdRc
OhiRklk3eUpYvjHGSaqkg9yDar3AQwkdO2t/40ZaA86x6fZhSyUs3C52HWq3
BlVT2JVU9RKMXzQa7HVlAJ/sCF7P2BKMblqwzy1kAMWU3GFvxxLslpAvPV1h
gEk8wGGlZgkm+U0X9SI7pmxhaJEtnraWDyO/CSKbq5DD65PaFMiSvCnNF2R5
oXTeSccAuz3GB2aQjcKKjhQgx9lpL/YhMycZ+6JWGaB5/cg/t9b2EQr2cWRF
gWBShJw30PPTWWQqcBy+gTzUkZFeghzudaXzGnJ01fj9F8iMw7+XC5EzEyvs
PPQM0N0vD0tCdnp/xsUX+fHB/zgJyD384N2ByF00jV8cMoVDDI1FLv9m884o
5Ar32DwRcpwQtwhZ66v9rrQKWSRSk3hrfZusapqQCya8dGxkd+rzjj5kcwPx
nP9aX+4fr0aQ4QR1hol82uD0u1lk4aeEMQzZ9hx3bgE5yb1r0Be5fdFZq0e+
Wuncuwf5f9DMhD8=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{1., 0},
  BaseStyle->{FontFamily -> "Times", FontSize -> 12},
  Epilog->{
    InsetBox[
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]\\)=5\"", 
      TraditionalForm], {6, -0.4033800616907799}, {-1, 0}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]\\)=4\"", 
      TraditionalForm], {6, -0.6627151165568845}, {-1, 0}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]\\)=3\"", 
      TraditionalForm], {6, -0.8932188747954372}, {-1, 0}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]\\)=2\"", 
      TraditionalForm], {6, -1.1554802380614522`}, {-1, 0}], 
    InsetBox[
     FormBox[
     "\"\\!\\(\\*\\nStyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]\\)=1\"", 
      TraditionalForm], {6, -1.390582446603287}, {-1, 0}]},
  Frame->True,
  FrameLabel->{
    FormBox["\"\[Lambda], c density parameter\"", TraditionalForm], 
    FormBox[
    "\"Limit price differential, \\!\\(\\*SubscriptBox[\\\"\[ScriptL]\\\", \
\\n StyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]]\\)\\!\\(\\*\\nStyleBox[\
\\\"=\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[SubscriptBox[\\\
\"L\\\", \\\"t\\\"],\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[\\\"-\
\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[SubscriptBox[\\n  \
StyleBox[\\\"p\\\",\\nFontSlant->\\\"Italic\\\"], \\n  \
StyleBox[\\\"t\\\",\\nFontSlant->\\\"Italic\\\"]],\\nFontSlant->\\\"Italic\\\"\
]\\)\"", TraditionalForm], None, None},
  FrameTicks->{{{1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}, {4, 
      FormBox["4", TraditionalForm]}, {5, 
      FormBox["5", TraditionalForm]}, {6, 
      FormBox["6", TraditionalForm]}}, {{0, 
      FormBox["0", TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}}, None, None},
  PlotRange->{{1, 7}, {0, -3.5}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.389735217191224*^9},
 CellLabel->"Out[107]=",
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->None,
WindowSize->{1578, 1026},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Visible->True,
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
ShowSelection->True,
InputAliases->{"intt" -> RowBox[{"\[Integral]", 
     RowBox[{"\[SelectionPlaceholder]", 
       RowBox[{"\[DifferentialD]", "\[Placeholder]"}]}]}], "dintt" -> 
  RowBox[{
     SubsuperscriptBox[
     "\[Integral]", "\[SelectionPlaceholder]", "\[Placeholder]"], 
     RowBox[{"\[Placeholder]", 
       RowBox[{"\[DifferentialD]", "\[Placeholder]"}]}]}], "sumt" -> RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"\[SelectionPlaceholder]", "=", "\[Placeholder]"}], 
      "\[Placeholder]"], "\[Placeholder]"}], "prodt" -> RowBox[{
     UnderoverscriptBox["\[Product]", 
      RowBox[{"\[SelectionPlaceholder]", "=", "\[Placeholder]"}], 
      "\[Placeholder]"], "\[Placeholder]"}], "dt" -> RowBox[{
     SubscriptBox["\[PartialD]", "\[Placeholder]"], " ", 
     "\[SelectionPlaceholder]"}], "notation" -> RowBox[{"Notation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], " ", 
       "\[DoubleLongLeftRightArrow]", " ", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "notation>" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], " ", 
       "\[DoubleLongRightArrow]", " ", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "notation<" -> 
  RowBox[{"Notation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], " ", 
       "\[DoubleLongLeftArrow]", " ", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "symb" -> 
  RowBox[{"Symbolize", "[", 
     TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], "]"}], 
  "infixnotation" -> RowBox[{"InfixNotation", "[", 
     RowBox[{
       TagBox["\[SelectionPlaceholder]", "NotationTemplateTag"], ",", 
       "\[Placeholder]"}], "]"}], "addia" -> RowBox[{"AddInputAlias", "[", 
     RowBox[{"\"\[SelectionPlaceholder]\"", "\[Rule]", 
       TagBox["\[Placeholder]", "NotationTemplateTag"]}], "]"}], "pattwraper" -> 
  TagBox["\[SelectionPlaceholder]", "NotationPatternTag"], "madeboxeswraper" -> 
  TagBox["\[SelectionPlaceholder]", "NotationMadeBoxesTag"], "E" -> 
  "\[ScriptCapitalE]", "ll" -> "\[ScriptL]"},
Magnification->1.5,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->"EMMStyle02.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 931, 25, 430, "Title"],
Cell[CellGroupData[{
Cell[1546, 52, 410, 9, 43, "Input"],
Cell[1959, 63, 674, 15, 51, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2670, 83, 32, 0, 92, "Section"],
Cell[CellGroupData[{
Cell[2727, 87, 43, 0, 65, "Subsection"],
Cell[2773, 89, 150, 3, 43, "Input"],
Cell[2926, 94, 311, 8, 43, "Input"],
Cell[3240, 104, 147, 3, 43, "Input"],
Cell[3390, 109, 111, 3, 32, "Text"],
Cell[3504, 114, 369, 12, 43, "Input"],
Cell[3876, 128, 238, 5, 32, "Text"],
Cell[4117, 135, 213, 6, 43, "Input"],
Cell[4333, 143, 209, 7, 43, "Input"],
Cell[4545, 152, 211, 7, 46, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4793, 164, 42, 0, 65, "Subsection"],
Cell[4838, 166, 535, 19, 104, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5410, 190, 55, 0, 65, "Subsection"],
Cell[5468, 192, 260, 8, 33, "Text"],
Cell[5731, 202, 1342, 37, 148, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7122, 245, 54, 0, 92, "Section"],
Cell[7179, 247, 1265, 39, 152, "Input"],
Cell[CellGroupData[{
Cell[8469, 290, 2213, 60, 125, "Input"],
Cell[10685, 352, 18380, 315, 383, 4075, 78, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[29080, 670, 157, 5, 43, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29274, 680, 73, 0, 92, "Section"],
Cell[29350, 682, 133, 3, 32, "Text"],
Cell[29486, 687, 203, 5, 33, "Text"],
Cell[29692, 694, 853, 27, 77, "Input"],
Cell[30548, 723, 98, 2, 32, "Text"],
Cell[30649, 727, 1117, 34, 108, "Input"],
Cell[31769, 763, 103, 3, 32, "Text"],
Cell[31875, 768, 896, 26, 90, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32808, 799, 112, 3, 92, "Section"],
Cell[32923, 804, 323, 10, 33, "Text"],
Cell[33249, 816, 845, 24, 98, "Input"],
Cell[CellGroupData[{
Cell[34119, 844, 27, 0, 65, "Subsection"],
Cell[CellGroupData[{
Cell[34171, 848, 114, 1, 44, "Subsubsection"],
Cell[CellGroupData[{
Cell[34310, 853, 812, 21, 43, "Input"],
Cell[35125, 876, 2528, 50, 260, "Output"]
}, Open  ]],
Cell[37668, 929, 602, 16, 43, "Input"],
Cell[38273, 947, 1054, 28, 43, "Input"],
Cell[39330, 977, 641, 16, 43, "Input"],
Cell[39974, 995, 282, 8, 43, "Input"],
Cell[40259, 1005, 82, 2, 32, "Text"],
Cell[40344, 1009, 1402, 35, 71, "Input"],
Cell[CellGroupData[{
Cell[41771, 1048, 755, 16, 43, "Input"],
Cell[42529, 1066, 17384, 314, 285, 7886, 156, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[59962, 1386, 115, 1, 44, "Subsubsection"],
Cell[60080, 1389, 85, 2, 32, "Text"],
Cell[60168, 1393, 1357, 35, 71, "Input"],
Cell[61528, 1430, 688, 17, 43, "Input"],
Cell[62219, 1449, 282, 8, 43, "Input"],
Cell[CellGroupData[{
Cell[62526, 1461, 804, 17, 43, "Input"],
Cell[63333, 1480, 8031, 158, 285, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[71425, 1645, 256, 9, 66, "Subsection"],
Cell[71684, 1656, 472, 14, 43, "Input"],
Cell[CellGroupData[{
Cell[72181, 1674, 59, 0, 44, "Subsubsection"],
Cell[72243, 1676, 1586, 42, 71, "Input"],
Cell[73832, 1720, 814, 20, 43, "Input"],
Cell[74649, 1742, 282, 8, 43, "Input"],
Cell[CellGroupData[{
Cell[74956, 1754, 925, 20, 43, "Input"],
Cell[75884, 1776, 19314, 343, 297, "Output"]
}, Open  ]],
Cell[95213, 2122, 82, 2, 32, "Text"],
Cell[95298, 2126, 1589, 43, 107, "Input"],
Cell[96890, 2171, 768, 18, 43, "Input"],
Cell[97661, 2191, 282, 8, 43, "Input"],
Cell[CellGroupData[{
Cell[97968, 2203, 968, 20, 43, "Input"],
Cell[98939, 2225, 37539, 644, 297, 26378, 459, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[136493, 2872, 85, 2, 32, "Text"],
Cell[136581, 2876, 1620, 42, 107, "Input"],
Cell[138204, 2920, 790, 18, 43, "Input"],
Cell[138997, 2940, 282, 8, 43, "Input"],
Cell[CellGroupData[{
Cell[139304, 2952, 1022, 21, 43, "Input"],
Cell[140329, 2975, 25801, 453, 297, 15053, 275, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[166191, 3435, 120, 4, 66, "Subsection"],
Cell[166314, 3441, 449, 13, 43, "Input"],
Cell[CellGroupData[{
Cell[166788, 3458, 385, 11, 43, "Input"],
Cell[167176, 3471, 908, 26, 86, "Output"]
}, Open  ]],
Cell[168099, 3500, 56, 0, 32, "Text"],
Cell[168158, 3502, 1476, 39, 71, "Input"],
Cell[169637, 3543, 812, 18, 43, "Input"],
Cell[170452, 3563, 282, 8, 43, "Input"],
Cell[CellGroupData[{
Cell[170759, 3575, 1070, 22, 43, "Input"],
Cell[171832, 3599, 16209, 293, 297, 7844, 154, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[188102, 3899, 107, 4, 92, "Section"],
Cell[188212, 3905, 499, 15, 43, "Input"],
Cell[188714, 3922, 354, 11, 43, "Input"],
Cell[189071, 3935, 413, 12, 43, "Input"],
Cell[189487, 3949, 400, 12, 43, "Input"],
Cell[189890, 3963, 453, 15, 71, "Input"],
Cell[190346, 3980, 1246, 32, 71, "Input"],
Cell[191595, 4014, 892, 20, 43, "Input"],
Cell[192490, 4036, 282, 8, 43, "Input"],
Cell[CellGroupData[{
Cell[192797, 4048, 1051, 20, 43, "Input"],
Cell[193851, 4070, 22661, 398, 285, 14668, 265, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[216527, 4471, 36, 0, 32, "Text"],
Cell[216566, 4473, 651, 18, 43, "Input"],
Cell[217220, 4493, 983, 25, 71, "Input"],
Cell[CellGroupData[{
Cell[218228, 4522, 1051, 20, 43, "Input"],
Cell[219282, 4544, 27206, 471, 285, "Output"]
}, Open  ]],
Cell[246503, 5018, 109, 3, 43, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[246649, 5026, 46, 0, 92, "Section"],
Cell[CellGroupData[{
Cell[246720, 5030, 34, 0, 65, "Subsection"],
Cell[246757, 5032, 352, 11, 43, "Input"],
Cell[247112, 5045, 469, 14, 43, "Input"],
Cell[247584, 5061, 541, 13, 43, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[248162, 5079, 181, 5, 65, "Subsection"],
Cell[248346, 5086, 674, 20, 43, "Input"],
Cell[249023, 5108, 779, 23, 43, "Input"],
Cell[249805, 5133, 908, 26, 43, "Input"],
Cell[250716, 5161, 731, 21, 43, "Input"],
Cell[251450, 5184, 123, 3, 32, "Text"],
Cell[251576, 5189, 793, 23, 71, "Input"],
Cell[CellGroupData[{
Cell[252394, 5216, 151, 4, 43, "Input"],
Cell[252548, 5222, 142, 2, 38, "Output"]
}, Open  ]],
Cell[252705, 5227, 395, 11, 43, "Input"],
Cell[CellGroupData[{
Cell[253125, 5242, 149, 4, 43, "Input"],
Cell[253277, 5248, 138, 2, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[253452, 5255, 411, 10, 43, "Input"],
Cell[253866, 5267, 9237, 160, 255, 4113, 74, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[263118, 5430, 1071, 32, 71, "Input"],
Cell[CellGroupData[{
Cell[264214, 5466, 160, 4, 43, "Input"],
Cell[264377, 5472, 140, 2, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[264554, 5479, 417, 10, 55, "Input"],
Cell[264974, 5491, 7141, 126, 247, 2157, 42, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[272164, 5623, 48, 0, 71, "Subsection"],
Cell[CellGroupData[{
Cell[272237, 5627, 102, 3, 55, "Input"],
Cell[272342, 5632, 158, 3, 50, "Output"]
}, Open  ]],
Cell[272515, 5638, 67, 0, 32, "Text"],
Cell[CellGroupData[{
Cell[272607, 5642, 333, 9, 55, "Input"],
Cell[272943, 5653, 6608, 115, 269, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[279588, 5773, 285, 8, 55, "Input"],
Cell[279876, 5783, 306, 8, 50, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[280231, 5797, 58, 0, 71, "Subsection"],
Cell[280292, 5799, 2748, 70, 407, "Input"],
Cell[CellGroupData[{
Cell[283065, 5873, 175, 6, 55, "Input"],
Cell[283243, 5881, 1341, 36, 123, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[284645, 5924, 25, 0, 98, "Section"],
Cell[CellGroupData[{
Cell[284695, 5928, 63, 0, 44, "Subsubsection"],
Cell[CellGroupData[{
Cell[284783, 5932, 175, 6, 55, "Input"],
Cell[284961, 5940, 1315, 36, 123, "Output"]
}, Open  ]],
Cell[286291, 5979, 496, 17, 55, "Input"],
Cell[286790, 5998, 341, 11, 55, "Input"],
Cell[287134, 6011, 340, 11, 55, "Input"],
Cell[287477, 6024, 2568, 79, 191, "Input"],
Cell[290048, 6105, 176, 5, 55, "Input"],
Cell[290227, 6112, 524, 19, 55, "Input"],
Cell[290754, 6133, 212, 5, 55, "Input"],
Cell[CellGroupData[{
Cell[290991, 6142, 1673, 49, 110, "Input"],
Cell[292667, 6193, 40223, 690, 378, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[332939, 6889, 39, 0, 44, "Subsubsection"],
Cell[332981, 6891, 174, 5, 55, "Input"],
Cell[333158, 6898, 235, 8, 55, "Input"],
Cell[333396, 6908, 256, 8, 55, "Input"],
Cell[333655, 6918, 673, 21, 55, "Input"],
Cell[334331, 6941, 2087, 62, 191, "Input"],
Cell[336421, 7005, 175, 5, 55, "Input"],
Cell[CellGroupData[{
Cell[336621, 7014, 1729, 47, 110, "Input"],
Cell[338353, 7063, 11716, 222, 394, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[350118, 7291, 42, 0, 44, "Subsubsection"],
Cell[350163, 7293, 178, 5, 55, "Input"],
Cell[350344, 7300, 248, 8, 55, "Input"],
Cell[350595, 7310, 680, 21, 55, "Input"],
Cell[351278, 7333, 2474, 80, 191, "Input"],
Cell[353755, 7415, 186, 5, 43, "Input"],
Cell[CellGroupData[{
Cell[353966, 7424, 1560, 43, 110, "Input"],
Cell[355529, 7469, 11730, 220, 389, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[367308, 7695, 109, 1, 44, "Subsubsection"],
Cell[CellGroupData[{
Cell[367442, 7700, 345, 9, 43, "Input"],
Cell[367790, 7711, 24179, 450, 334, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[392018, 8167, 62, 0, 44, "Subsubsection"],
Cell[392083, 8169, 176, 5, 43, "Input"],
Cell[392262, 8176, 227, 8, 43, "Input"],
Cell[392492, 8186, 682, 21, 43, "Input"],
Cell[393177, 8209, 2537, 82, 179, "Input"],
Cell[CellGroupData[{
Cell[395739, 8295, 1414, 40, 98, "Input"],
Cell[397156, 8337, 29451, 508, 383, 13112, 238, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
