#!/usr/bin/env python
import pygtk
pygtk.require('2.0')

import gtk, gnomeapplet, gobject

import sys, os, fcntl,re, time, subprocess

TEXT_COLOR = "white"
PANEL_IS_VERTICAL = True

# Written by Manuel Arriaga <manuelarriaga@gmail.com>. Most of the code in this file (and the associated
# .server file) is borrowed from the example available at
#
# http://saravananthirumuruganathan.wordpress.com/2010/01/15/creating-gnome-panel-applets-in-python/

class XmonadWorkspacesApplet(gnomeapplet.Applet):

	# Do non-blocking read from the FIFO to which xmonad writes the currently visible workspaces
	# [from http://stackoverflow.com/questions/375427/non-blocking-read-on-a-subprocess-pipe-in-python]
	
	def non_block_read(self):
	
		fd = self.pipe_to_xmonad.fileno()
		fl = fcntl.fcntl(fd, fcntl.F_GETFL)
		fcntl.fcntl(fd, fcntl.F_SETFL, fl | os.O_NONBLOCK)
		input = ''
		try: input = self.pipe_to_xmonad.read()
		except: pass
		
		return input

	# Displays the listof workspaces in the GUI. Uses set_markup to use HTML
	def displayWorkspaceList(self):

		input = self.non_block_read()
		lines = input.split("\n")
		lines.reverse() # we want to begin our search at the most recently printed line (we iterate over the entire list in reverse order, rather than just use the last line, because xmonad seems to on occasion also spit out lines that are not just a list of workspaces)
		
		for line in lines:
			
			# the lines we are interested in have the format "[1 2] (...)" or "[1 2 3] (...)", where the digits are the workspace ID numbers, possibly followed by additional screen ids (listing non-empty invisible workspaces, which we are not interested in)
			if line.startswith('['):
				
				line = line[1:line.index(']')] # remove square brackets and dump what follows
				
				if PANEL_IS_VERTICAL: line = re.sub("\s", "\n", line)
					
				self.label.set_markup('<span foreground="%s">%s</span>' % (TEXT_COLOR, line) )
				break

		return True

	def __init__(self,applet,iid):

		self.pipe_to_xmonad = subprocess.Popen("xmonad", shell=True, stdout=subprocess.PIPE).stdout
		
		time.sleep(0.2)

		self.timeout_interval = 300
		self.applet = applet

		self.label = gtk.Label("")
		self.applet.add(self.label)

		self.applet.show_all()
		gobject.timeout_add(self.timeout_interval, self.displayWorkspaceList)

#Register the applet datatype
gobject.type_register(XmonadWorkspacesApplet)

def xmonad_workspaces_factory(applet,iid):
	XmonadWorkspacesApplet(applet,iid)
	return gtk.TRUE

#Very useful if I want to debug. To run in debug mode python xmonad-workspaces-applet.py -d
if len(sys.argv) == 2:
	if sys.argv[1] == "-d": #Debug mode
		main_window = gtk.Window(gtk.WINDOW_TOPLEVEL)
		main_window.set_title("Xmonad Workspaces Applet")
		main_window.connect("destroy", gtk.main_quit)
		app = gnomeapplet.Applet()
		xmonad_workspaces_factory(app,None)
		app.reparent(main_window)
		main_window.show_all()
		gtk.main()
		sys.exit()

#If called via gnome panel, run it in the proper way
if __name__ == '__main__':
	gnomeapplet.bonobo_factory("OAFIID:GNOME_Xmonad_Workspaces_Factory", XmonadWorkspacesApplet.__gtype__, "hello", "0", xmonad_workspaces_factory)
