*******************************************************************
******************* TABLE 6, 8, and 10: extensive - Entry *********
*******************************************************************
* The commented code was used to create the analysis dataset form the original ones (originals not included)

/*

clear all
set mem 150g
set matsize 11000
set maxvar 20000
cd "S:\Peru"

use growth_temp_hc4_stata11.dta, clear  
compress
drop pcf continues2 fexposure wexposure wexposure1 wexposure2 wexposure3 firmSUB10p_2006 continues enters exits continuesB continuesA saldotot_dollar saldotot_sol  paycash_WKG transair_WKG wexposure4 wexposure5 wexposure6 wexposure7 wexposure8 fexposure_dollar fexposure_sol fexposure_sol wexposure_dollar wexposure_sol wexposure2_dollar wexposure2_sol firmSUB_2006 firmSUB50p_2006 firmSUB50p_07 fob_exits-saldotot_continuesA

drop if etime==4 | etime==.

*Selection 1: this has all the firms that export at any time in the sample period (over 11K firms) --> larger than intensive margin
*To reduce the number we keep only those with positive debt in all periods (this leaves 5051 firms)
egen minsaldo_byruc=min(saldotot), by(ruc)
drop if minsaldo_byruc==0 | minsaldo_byruc==.
drop minsaldo_byruc

*Selection 2: we want to condition on exporters in the Pre period (we miss all first time exporters from entry)
egen meanfobinPre_byruc=mean(fob*(etime==2)), by(ruc)
drop if meanfobinPre_byruc==0
drop meanfobinPre_byruc

*Selection 3: product-destinations where there is no entry in the pre and post period only affect the denominator
egen pd=group(part country_code)
egen count_pd=sum((fob>0)*(etime>=2 & etime<=3)), by(pd) 
drop if count_pd==0
drop pd count_pd


*Here is where we define where firms may entry from (destination: fp country_code etime ; product: fd part etime)
compress
egen int pd=group(part country_code )
fillin pd ruc etime


foreach var of varlist fexposure* wexposure*  {
	sort ruc `var'
	by ruc: replace `var'=`var'[1]
}

foreach var of varlist distanceinkm part country_code  {
	sort pd `var'
	by pd: replace `var'=`var'[1]
}

foreach var of varlist saldotot nbanks frac_dollartot {
	sort ruc etime `var'
	by ruc etime: replace `var'=`var'[1]
}
foreach var of varlist fob peso paycash_WFOB transair_WFOB {
	replace `var'=0 if _fillin==1
}

drop  _fillin

egen double fpd=group(ruc pd)
tsset fpd etime

*ENTRY*
*Exports today (conditional on not exporting yesterday):
gen byte enter = fob>0 if l.fob==0
gen byte enter2year = (fob>0 | f.fob>0) if l.fob==0

*Exports tomorrow (conditional on not exporting today):
gen Lpaycash_WFOB=l.paycash_WFOB
gen Ltransair_WFOB=l.transair_WFOB
drop if etime==1 | etime==4
drop fpd
egen int pdt=group(part country_code  etime)
foreach var of varlist fob peso  saldotot  {
	gen l`var'=ln(`var')
	drop `var'
}
gen byte post=etime==3
foreach var of varlist  fexposure_2006 wexposure1_2006 wexposure2_2006 wexposure3_2006 {
gen `var'_post=`var'*post
}
egen int iruc=group(ruc)
xtset pdt 

*save extensive_HC4_entry.dta, replace


drop etime  paycash_WFOB transair_WFOB  wexposure1_07 wexposure2_07 wexposure3_07 frac_dollar  paycredit transair  nbanks pd 
keep if enter<.  
drop ruc
compress
*Restricting entry to 2-digit products where the firm already exports
gen byte part2=cond(part<1000,int(part/10),int(part/100))	
gen byte entrysample=lfob<. if post==0
gsort iruc part2 -entrysample
by iruc part2: replace entrysample=entrysample[1]
keep if entrysample==1
drop entrysample part2
egen int ft=group(iruc post)
replace enter=enter*100

save "C:\Users\dp2239\Documents\Academic\Data\Peru\Data_RESTUD\data_entry_HS4.dta"


*/





use "data_entry_HS4.dta", clear



*Manual 2SLS regression (Table 6)
*First stage (not in the paper)
felsdvreg lsaldotot fexposure_2006_post, ivar(pdt) jvar(iruc) xb(xb) peff(phat) feff(fhat) res(res) mover(mover) mnum(mnum) pobs(pobs) group(group) 
generate lsaldotothat=xb+fhat+phat
*2S w SE: cluster pdt (table 6, column 4)
felsdvreg enter lsaldotothat, ivar(pdt) jvar(iruc) xb(xb) peff(peff) feff(feff) hat(lsaldotothat) orig(lsaldotot) res(res) mover(mover) mnum(mnum) pobs(pobs) group(group) cluster(pdt) noadji noadjj



*IV robustness to polynomial instrument (Table 8)
*First stage 
felsdvreg lsaldotot wexposure1_2006_post wexposure2_2006_post wexposure3_2006_post, ivar(pdt) jvar(iruc) xb(xb) peff(phat) feff(fhat) res(res) mover(mover) mnum(mnum) pobs(pobs) group(group) 
capture drop lsaldotothat
generate lsaldotothat=xb+fhat+phat
*2S w SE: cluster pdt
felsdvreg enter lsaldotothat, ivar(pdt) jvar(iruc) xb(xb) peff(peff) feff(feff) hat(lsaldotothat) orig(lsaldotot) res(res) mover(mover) mnum(mnum) pobs(pobs) group(group) cluster(pdt) noadji noadjj



*Homogeneous only (Table 8)
rename part part4
sort part4
merge m:1 part4 using "homogeneous_part4.dta"
drop  rauchconservative rauchliberal
drop if _merge==2
drop _merge
rename part4 part
*First stage 
felsdvreg lsaldotot fexposure_2006_post if homogen_rc==0, ivar(pdt) jvar(iruc) xb(xb) peff(phat) feff(fhat) res(res) mover(mover) mnum(mnum) pobs(pobs) group(group) 
capture drop lsaldotothat
generate lsaldotothat=xb+fhat+phat if homogen_rc==0
*2S w SE: cluster pdt
felsdvreg enter lsaldotothat if homogen_rc==0, ivar(pdt) jvar(iruc) xb(xb) peff(peff) feff(feff) hat(lsaldotothat) orig(lsaldotot) res(res) mover(mover) mnum(mnum) pobs(pobs) group(group) cluster(pdt) noadji noadjj



*With Instrument created using Dec 2007 exposures (Table 8)
 gen fexposure_07_post=fexposure_07*post
*First stage 
felsdvreg lsaldotot fexposure_07_post, ivar(pdt) jvar(iruc) xb(xb) peff(phat) feff(fhat) res(res) mover(mover) mnum(mnum) pobs(pobs) group(group) 
capture drop lsaldotothat
generate lsaldotothat=xb+fhat+phat
*2S w SE: cluster pdt
felsdvreg enter lsaldotothat, ivar(pdt) jvar(iruc) xb(xb) peff(peff) feff(feff) hat(lsaldotothat) orig(lsaldotot) res(res) mover(mover) mnum(mnum) pobs(pobs) group(group) cluster(pdt) noadji noadjj




*IV with controls: (Table 8)
foreach var in fob peso  {
	gen `var'=exp(l`var')
	replace `var'=0 if l`var'==.
}
egen pesototal=sum(peso) if post==0, by(iruc post)
gen byte fob2_dum=fob>0 if fob<.
egen mc=max(fob2_dum) if post==0, by(iruc country_code post)
egen mp=max(fob2_dum) if post==0, by(iruc part post)
egen byte tag_fct=tag(iruc country_code post)  if post==0
egen byte tag_fpt=tag(iruc part post)  if post==0
egen ncount=sum(mc*tag_fct) if post==0 , by(iruc post)
egen npart=sum(mp*tag_fpt) if post==0 , by(iruc post)
drop mc mp fob2_dum tag_fct tag_fpt fob peso
foreach var of varlist pesototal  ncount npart {
	sort iruc `var'
	by iruc: replace `var'=`var'[1]
}

foreach var of varlist pesototal  ncount npart  {
	gen l`var'_post=ln(`var')*post
}
gen frac_dollartot_post=frac_dollartot*post
*First stage 
felsdvreg lsaldotot fexposure_2006_post lpesototal_post lnpart_post lncount_post frac_dollartot_post, ivar(pdt) jvar(iruc) xb(xb) peff(phat) feff(fhat) res(res) mover(mover) mnum(mnum) pobs(pobs) group(group) 
capture drop lsaldotothat
generate lsaldotothat=xb+fhat+phat
*2S w SE: cluster pdt
felsdvreg enter lsaldotothat lpesototal_post lnpart_post lncount_post frac_dollartot_post, ivar(pdt) jvar(iruc) xb(xb) peff(peff) feff(feff) hat(lsaldotothat) orig(lsaldotot) res(res) mover(mover) mnum(mnum) pobs(pobs) group(group) cluster(pdt) noadji noadjj
drop lpesototal_post lnpart_post lncount_post 









****CROSS SECTIONAL CUTS*********


	
*By DISTANCE (Table 9)
sort  country_code distanceinkm
by   country_code: gen distance= distanceinkm[1]
egen tag_fdt=tag(iruc part post)
sum distance if post==0 & tag_fdt==1
gen Ndistance=(distance-r(mean))/r(sd)
foreach var of varlist lsaldotot fexposure_2006 {
	gen `var'_Ndistance=`var'*Ndistance
	gen `var'_Ndistance_post=`var'*Ndistance*post
}
*First stage 1
felsdvreg lsaldotot fexposure_2006_post fexposure_2006_Ndistance_post, ivar(pdt) jvar(iruc) xb(xb) peff(phat) feff(fhat) res(res) mover(mover) mnum(mnum) pobs(pobs) group(group) 
capture drop lsaldotothat
generate lsaldotothat=xb+fhat+phat
*First stage 2
felsdvreg lsaldotot_Ndistance fexposure_2006_post fexposure_2006_Ndistance_post, ivar(pdt) jvar(iruc) xb(xb) peff(phat) feff(fhat) res(res) mover(mover) mnum(mnum) pobs(pobs) group(group) 
capture drop lsaldotot_Ndistancehat
generate lsaldotot_Ndistancehat=xb+fhat+phat
*2nd stage
felsdvreg enter lsaldotothat lsaldotot_Ndistancehat, ivar(pdt) jvar(iruc) xb(xb) peff(peff) feff(feff) hat(lsaldotothat lsaldotot_Ndistancehat) orig(lsaldotot lsaldotot_Ndistance) res(res) mover(mover) mnum(mnum) pobs(pobs) group(group) 
*DISTANCE w/o FE
xtset iruc
xtivreg enter  post (lsaldotot lsaldotot_Ndistance= fexposure_2006_post fexposure_2006_Ndistance_post ), fe





	
*By EXTERNAL FINANCE DEPENDENCE (Table 10)
rename part part4
sort  part4
*drop _merge
merge m:1 part4 using "externaldep_avg_part4.dta", keepusing(extfin tang tcred)
drop if _merge==2
drop _merge
rename part4 part
sum extfin
gen Nextfin=(extfin-r(mean))/r(sd)
foreach var of varlist lsaldotot fexposure_2006 {
	gen `var'_Nextfin=`var'*Nextfin
	gen `var'_Nextfin_post=`var'*Nextfin*post
}
*First stage 1
felsdvreg lsaldotot fexposure_2006_post fexposure_2006_Nextfin_post, ivar(pdt) jvar(iruc) xb(xb) peff(phat) feff(fhat) res(res) mover(mover) mnum(mnum) pobs(pobs) group(group) 
capture drop lsaldotothat
generate lsaldotothat=xb+fhat+phat
*First stage 2
felsdvreg lsaldotot_Nextfin fexposure_2006_post fexposure_2006_Nextfin_post, ivar(pdt) jvar(iruc) xb(xb) peff(phat) feff(fhat) res(res) mover(mover) mnum(mnum) pobs(pobs) group(group) 
capture drop lsaldotot_Nextfinhat
generate lsaldotot_Nextfinhat=xb+fhat+phat
*2nd stage
felsdvreg enter lsaldotothat lsaldotot_Nextfinhat, ivar(pdt) jvar(iruc) xb(xb) peff(peff) feff(feff) hat(lsaldotothat lsaldotot_Ndistancehat) orig(lsaldotot lsaldotot_Ndistance) res(res) mover(mover) mnum(mnum) pobs(pobs) group(group) 
*without FE
xtset iruc
xtivreg enter  post (lsaldotot lsaldotot_Nextfin= fexposure_2006_post fexposure_2006_Nextfin_post), fe






