*Note: this includes the ID tests that use the same dataset as the main test. Data for the other tests available from the authors upon request.

cd "C:\Users\dp2239\Documents\Academic\Data\Peru\Data_RESTUD"

******************************************************************
******************* FIGURE 1: aggregate time series **************
******************************************************************

/*
*cd "/Users/dp2239/Documents/Academic/Data/Peru/SUB_PRIME"
use exports_longrun.dta, clear
drop month month_year year
merge 1:1 periodo using foreignliab_longrun.dta, keep(match)
drop _merge
merge 1:1 periodo using exchange_rate_1991_2012.dta, keep(match)
drop _merge
merge 1:1 periodo using totalloans.dta, 

*Creting scaled variables
gen foreignliab_USD=(adeudosexterior/exchrate)/1000
gen fob_USD=(exports_all/exchrate)
gen foreignliab_USD_000000=(1000*adeudosexterior/exchrate)/1000000
gen fob_USD_000000=(1000000*exports_all)/1000000
gen foreignliab_000000=(1000*adeudosexterior)/1000000
gen fob_000000=(1000000*exports_all*exchrate)/1000000

*Sample period: two tears
keep if periodo>568 & periodo<=568+25

save "C:\Users\dp2239\Documents\Academic\Data\Peru\Data_RESTUD\data_figure_01.dta", replace
*/

use "data_figure_01.dta"

*Plots:
twoway (line foreignliab_USD_000000 periodo, xline(582.5)) , xtitle("Month") ytitle("Total Bank Foreign Liabilities (Millions of US$)" )  
twoway (line fob_USD_000000 periodo, xline(582.5) ) , xtitle("Month") ytitle("Total Export FOB Value (Millions of US$)" ) 




*******************************************************************
******************* TABLE 2: firm statistics **********************
*******************************************************************
* The commented code was used to create the analysis dataset form the original ones (originals not included)

/*
clear all
cd "/Users/dp2239/Documents/Academic/Data/Peru/SUB_PRIME"
use exports_firmprodcount_subprime_DP, replace		
format periodo %tm
gen int year=yofd(dofm(periodo))
gen byte post = period>=582

*Firm exposure definitions
foreach bank in SUB {
	egen byte firm`bank'06=max(id_bank`bank') if period<=576, by(ruc)
	egen byte firm`bank'_2006=min(firm`bank'06), by(ruc)
	replace firm`bank'_2006=0 if firm`bank'_2006==.
	drop firm`bank'06
}
egen fexposure06=max(fexposure) if period<=576, by(ruc) 
egen fexposure_2006=min(fexposure06), by(ruc)
replace fexposure_2006=0 if fexposure_2006==.
gen byte firmSUB10p_2006 = fexposure_2006>=.1
gen byte firmSUB50p_2006 = fexposure_2006>=.50
drop fexposure06
foreach var of varlist  wexposure wexposure_dollar wexposure_sol wexposure2 wexposure2_dollar wexposure2_sol {
	egen `var'06=mean(`var') if period<=576, by(ruc) 
	egen `var'_2006=min(`var'06), by(ruc)
	replace `var'_2006=0 if `var'_2006==.
	drop `var'06
}
gen dollar_frac=saldo_dollar/saldo
egen dollar_ftot=mean(dollar_frac), by(ruc post)
replace dollar_ftot=0 if dollar_ftot==.
rename nbanks nb
egen nbanks=mean(nb), by(ruc post)
egen saldotot=mean(saldo), by(ruc post)
replace saldotot=0 if saldotot==.
egen saldotot_dollar=mean(saldo_dollar), by(ruc post)
replace saldotot_dollar=0 if saldotot_dollar==.
egen saldotot_sol=mean(saldo_sol), by(ruc post)
replace saldotot_sol=0 if saldotot_sol==.
egen fobtotal=sum(fob_dolpol), by(ruc post)
egen pesototal=sum(peso_neto), by(ruc post)
tostring part_nandi, g(part_text)
gen part=substr(part_text,1,4) if length(part_text)==10
replace part=substr(part_text,1,3) if length(part_text)==9
destring part, replace
gen paycash_WFOB=paycash*fob_dolpol
gen transair_WFOB=transair*fob_dolpol
gen paycash_WKG=paycash*peso_neto
gen transair_WKG=transair*peso_neto
drop if ruc==.

collapse (sum) fob=fob_dolpol peso=peso_neto paycash_* transair_* (mean) firm* fexposure* wexposure* saldo* dollar_* nbanks fobtotal pesototal distance , by(ruc part country_code  period)
egen pcf=group(ruc part country_code)
drop if pcf==.				/*This doesn't matter for exit, but for entry, it drops those that borrow and don't trade*/
xtset pcf period

*Here we define the estimation period
*For now we are doing the year before and the year after
*Here we drop all months outside the sample period
keep if period >=582-12 & period<=582+11
gen byte post=period>=582

collapse (sum) fob peso  paycash_* transair_* (count) ship_freq = fob (mean) ship_sizefob = fob ship_sizepeso = peso firm* fexposure* wexposure* saldo* dollar_* nbanks fobtotal pesototal distance , by(ruc part country_code  post)
egen pcf=group(ruc part country_code)
drop if pcf==.
gen paycash_FOB=paycash_WFOB
gen transair_FOB=transair_WFOB
replace paycash_WFOB=paycash_WFOB/fob
replace transair_WFOB=transair_WFOB/fob
replace paycash_WKG=paycash_WKG/peso
replace transair_WKG=transair_WKG/peso
foreach bank in SUB SUB10p {
	gen byte firm`bank'_2006_post=firm`bank'_2006*post
}
gen  fexposure_2006_post=fexposure_2006*post
sort ruc fob
by ruc: gen cmax=country_code[_N]
by ruc: gen pmax=part[_N]
egen pc=group(part country_code)
egen pct=group(part country_code post)
egen wdistance=sum(distance*peso/pesototal), by(ruc post)
foreach var of varlist fob peso {
	egen `var'totalb=sum(`var'), by(ruc post)
}
foreach var in saldo saldotot fobtotal  pesototal  distance wdistance  {
	gen l`var'=ln(`var')
}
xtset pcf post
egen byte tag_f=tag(ruc) if d.saldotot<.

*Measuring the change in the number of products, destinations, and product x destinations
egen byte tag_fct=tag(ruc country_code post) /* if _fillin<. */
egen byte tag_fpt=tag(ruc part post) /* if _fillin<. */
egen byte tag_ft=tag(ruc  post) /* if _fillin<. */

*gen byte fob2_dum=fob2>0 if fob2<.
gen byte fob2_dum=fob>0 if fob<.
egen npartcoun=sum(fob2_dum), by(ruc post)
egen ncount_byp=sum(fob2_dum), by(ruc part post)
egen npart_byc=sum(fob2_dum), by(ruc country_code post)
egen mc=max(fob2_dum), by(ruc country_code post)
egen mp=max(fob2_dum), by(ruc part post)
egen ncount=sum(mc*tag_fct) , by(ruc post)
egen npart=sum(mp*tag_fpt) , by(ruc post)
drop mc mp

foreach var of varlist npartcoun ncount npart  {
	gen l`var'=ln(`var')
}


*Classifying firms along different dimensions

*Merging with NAICS definitions
rename part part4
sort  part4
*merge m:1 part4 using "C:\Users\dp2239\Documents\Academic\Data\Peru\concordance\concordance_exports_naics2_part4.dta", update
merge m:1 part4 using "/Users/dp2239/Documents/Academic/Data/Peru/concordance/concordance_exports_naics2_part4.dta", update
drop if _merge==2
drop _merge*

*Merging with External Finance Dependence, tangible assets, and trede credit from Chor-Manova
sort  part4
*merge m:1 part4 using "C:\Users\dp2239\Documents\Academic\Data\Peru\concordance\externaldep_avg_part4.dta", keepusing(extfin tang tcred)
merge m:1 part4 using "\Users\dp2239\Documents\Academic\Data\Peru\concordance\externaldep_avg_part4.dta", keepusing(extfin tang tcred)
drop if _merge==2
drop _merge

*Merging with downstream indicators, from Levchenko
sort  part4
*merge m:1 part4 using "C:\Users\dp2239\Documents\Academic\Data\Peru\concordance\concordance_exports_downstream.dta"
merge m:1 part4 using "\Users\dp2239\Documents\Academic\Data\Peru\concordance\concordance_exports_downstream.dta"
drop if _merge==2
drop _merge

*Merging country GDP level and growth
sort country
decode country_code, gen( country)
*merge m:1 country using "C:\Users\dp2239\Documents\Academic\Data\Peru\Otros Indicadores\country_gdp.dta"
merge m:1 country using "\Users\dp2239\Documents\Academic\Data\Peru\Otros Indicadores - gravity\country_gdp.dta"
drop country _merge

*Merging Rauch Homogeneous definition
sort part4
merge m:1 part4 using "\Users\dp2239\Documents\Academic\Data\Peru\concordance\homogeneous_part4.dta"
drop  rauchconservative rauchliberal
drop if _merge==2
drop _merge


*Exchange rate in June 2008 = 2.85
xtset pcf post

foreach var of varlist fob ship_sizefob paycash_FOB transair_FOB  {
	gen `var'US1000=`var'/(2.85*1000)
}
foreach var of varlist peso ship_sizepeso  {
	gen `var'1000=`var'/1000
}
merge m:1 ruc using foreign.dta
drop if _merge==2
gen multinational=foreign==1

drop wexposure1-wexposure8

save "C:\Users\dp2239\Documents\Academic\Data\Peru\Data_RESTUD\data_table_02_firmstats.dta", replace

*Garbling the firm and bank ids:
egen iruc=group(ruc)
foreach var of varlist ruc  {
drop `var'
rename i`var' `var'
}

save "C:\Users\dp2239\Documents\Academic\Data\Peru\Data_RESTUD\data_table_02_firmstats.dta", replace


*/

use "data_table_02_firmstats.dta", clear


***TABLE FIRM-product-destination STATISTICS***
tabstat fobUS1000 peso1000 distanceinkm ship_sizefobUS1000 ship_sizepeso1000 ship_freq paycash_FOBUS1000 transair_FOBUS1000 multinational if post==0, s(mean sd median p1 p99 n)  c(s)
*Only those that HAVE DEBT in the post period in the post period
tabstat fobUS1000 peso1000 distanceinkm paycash_FOBUS1000 transair_FOBUS1000 ship_sizefobUS1000 ship_sizepeso1000 ship_freq  multinational if post==0 & saldotot>0 & f.saldotot>0, s(mean sd median p1 p99 n)  c(s) by(firmSUB50p_2006)
*mean differences between the population and the study sample
foreach var of varlist fobUS1000 peso1000 distanceinkm paycash_FOBUS1000 transair_FOBUS1000 ship_sizefobUS1000 ship_sizepeso1000 ship_freq  multinational {
gen `var'_sample=`var' if f.saldotot>0
}
foreach var of varlist fobUS1000 peso1000 distanceinkm paycash_FOBUS1000 transair_FOBUS1000 ship_sizefobUS1000 ship_sizepeso1000 ship_freq {
ttest `var'==`var'_sample if post==0, unpaired unequal
}
*mean differences "exposed" and "not exposed"
foreach var of varlist fobUS1000 peso1000 distanceinkm paycash_FOBUS1000 transair_FOBUS1000 ship_sizefobUS1000 ship_sizepeso1000 ship_freq {
ttest `var' if post==0 & f.saldotot>0, by(firmSUB50p_2006)
}



***TABLE FIRM STATISTICS***
keep if tag_ft==1
*Exchange rate in June 2008 = 2.85
foreach var of varlist saldotot fobtotal ship_sizefob   {
	gen `var'0=`var'/(1000*2.85)
}
foreach var of varlist  pesototal ship_sizepeso {
	gen `var'0=`var'/(1000)
}
tsset ruc post
tabstat saldotot0 nbanks dollar_frac fobtotal0 pesototal0 ncount distanceinkm npart npartcoun  ship_sizefob0 ship_sizepeso0 ship_freq multinational fexposure_2006 wexposure_2006 if post==0, s(mean sd median p1 p99 n)  c(s)
*Only those that HAVE DEBT in the post period in the post period
tabstat saldotot0 nbanks dollar_frac fobtotal0 pesototal0 ncount distanceinkm npart npartcoun  ship_sizefob0 ship_sizepeso0 ship_freq multinational fexposure_2006  wexposure_2006 if post==0 & saldotot<. & f.saldotot>0, s(mean sd median p1 p99 n)  c(s) by(firmSUB50p_2006)
*mean differences between the population and the study sample
drop *_sample
foreach var of varlist saldotot0 nbanks dollar_frac fobtotal0 pesototal0 ncount npart npartcoun multinational  fexposure_2006 wexposure_2006 {
gen `var'_sample=`var' if f.saldotot>0
}
foreach var of varlist saldotot0 nbanks dollar_frac fobtotal0 pesototal0 ncount npart npartcoun multinational  fexposure_2006 wexposure_2006 {
ttest `var'==`var'_sample if post==0, unpaired unequal
}
*mean differences "have debt" and "do not" NOT LIKE THIS: POPULATION VERSUS OUR SAMPLE
gen DFsaldo=f.saldotot>0
foreach var of varlist saldotot0 nbanks dollar_frac fobtotal0 pesototal0 ncount npart npartcoun multinational  fexposure_2006 wexposure_2006 {
ttest `var' if post==0 , by(DFsaldo)
}
*Conditioning: HAVE DEBT IN POST + >1 BANK
tabstat saldotot0 nbanks dollar_frac fobtotal0 pesototal0 ncount npart npartcoun multinational  firmSUB50p_2006 fexposure_2006 wexposure_2006 if post==0 & f.saldotot>0 &  nbanks>1 & nbanks<. , s(mean sd median p1 p99 n)  c(s) by(firmSUB50p_2006)






************************************************************************
******************* TABLE 3: within-firm estimate **********************
************************************************************************
* The commented code was used to create the analysis dataset form the original ones (originals not included)
/*
clear all
cd "/Users/dp2239/Documents/Academic/Data/Peru/SUB_PRIME"
use accounts_exporters_subprime_DP.dta, clear
sort codent
cd "/Users/dp2239/Documents/Academic/Data/Peru"
merge m:1 codent using "bankexposure_new3.dta", keepusing(exposure_subprime) keep(master match) nogen
cd "/Users/dp2239/Documents/Academic/Data/Peru/SUB_PRIME"
/* Variable Definitions */		/* Note: period==576 is  Jan 2008 */

replace exposure_subprime=0 if exposure_subprime==.
format periodo %tm
gen float year=yofd(dofm(periodo))
gen byte post = period>=582		/* July 2008 */
egen fm=group(ruc periodo)
gen ldebt = ln(saldo)
gen ldebt_sol = ln(saldo_sol)
gen ldebt_dollar = ln(saldo_dollar)
gen lfob = ln(fob_dolpol)
gen lpeso = ln(peso_neto)

egen saldotot=sum(saldo), by(ruc periodo)
egen saldo_wexposed=sum(saldo*id_bankSUB), by(ruc periodo)
gen fexposure=saldo_wexposed/saldotot
gen wexposure=saldo*exposure_subprime/saldotot

*Collapsing by firm-bank-post:
drop if codent==.											
keep if period >=582-12 & period<=582+11
collapse (mean) saldo* ldebt* id_bank* exposure_subprime fexposure wexposure  (sum) fob_dolpol peso_neto, by(ruc codent post)
capture drop *_sol *_dollar

save "C:\Users\dp2239\Documents\Academic\Data\Peru\Data_RESTUD\data_withinfirm.dta"

*Garbling the firm and bank ids:
egen iruc=group(ruc)
egen icodent=group(codent)
foreach var of varlist ruc codent {
drop `var'
rename i`var' `var'
}

save "C:\Users\dp2239\Documents\Academic\Data\Peru\Data_RESTUD\data_withinfirm.dta", replace

*/

use "data_withinfirm.dta", clear

egen fb=group(ruc codent)
xtset fb post
egen fm=group(ruc post)
gen lsaldo=ln(saldo)
xtset fb post
gen lpeso=ln(peso_neto)
xtset fb post

* Main within firm specification: 
areg d.lsaldo   exposure_subprime , r cl(codent) a(ruc)
areg d.lsaldo   id_bankSUB  , r cl(codent) a(ruc)


	
	

*********************************************************************************************
******************* FIGURE 2: bank credit and foreign funding (bank-firm data) **************
*********************************************************************************************
	
use "data_withinfirm.dta", clear

egen fb=group(ruc codent)
xtset fb post
egen fm=group(ruc post)
gen lsaldo=ln(saldo)
xtset fb post


*Shape of the relationship between the post-pre change in lending and exposure to the crisis
gen Dlsaldo=d.lsaldo
areg Dlsaldo  , a(ruc)
predict Dlsaldo_hat, xbd
gen e_Dlsaldo=Dlsaldo-Dlsaldo_hat
 twoway lpolyci Dlsaldo exposure_subprime if exposure_subprime<.17, ytitle("Post - Pre Change in ln(Debt)") xtitle("Fraction of Assets Funded with Foreign Liabilities") 
 twoway lpolyci Dlsaldo_hat exposure_subprime if exposure_subprime<.17, ytitle("Post - Pre Change in ln(Debt), Firm FE Removed") xtitle("Fraction of Assets Funded with Foreign Liabilities")

 
 
 
***************************************************************
******************* TABLE 4: first stage **********************
***************************************************************

*Original data
/*
use SUBPRIME_fpd_temp_1yw.dta , clear

*Garbling the firm and bank ids:
egen iruc=group(ruc)
foreach var of varlist ruc  {
drop `var'
rename i`var' `var'
}


save "C:\Users\dp2239\Documents\Academic\Data\Peru\Data_RESTUD\data_intensive_1y_HS4.dta", replace



*/

use "data_intensive_1y_HS4.dta", clear

areg  d.lsaldotot fexposure_2006 if d.lpeso<., r cl(pc) a(pc)
areg  d.lsaldotot wexposure1_2006 if d.lpeso<., r cl(pc) a(pc)
areg  d.lsaldotot wexposure1_2006 wexposure2_2006 wexposure3_2006 if d.lpeso<., r cl(pc) a(pc)





**********************************************************************
******************* LASSO (used to select instruments) ****************
**********************************************************************

clear
set maxvar 10000
set matsize 10000
use "data_intensive_1y_HS4.dta", clear
gen Dlsaldotot=d.lsaldotot
keep if d.lsaldotot<.
drop saldo_g10- air_g10 
foreach num of numlist 1(1)8 {
	gen wexposure_2006_`num'=wexposure_2006^`num'
	gen fexposure_2006_`num'=fexposure_2006^`num'
}
*for the full list
local biglist = "firmSUB50p_2006 fexposure_2006 wexposure1_2006 wexposure2_2006 wexposure3_2006 wexposure4_2006 wexposure5_2006 wexposure6_2006 wexposure7_2006 wexposure8_2006"

xi i.pc
* The LASSO code obtained from Hansen's web page: http://faculty.chicagobooth.edu/christian.hansen/research/
lassoShooting Dlsaldotot `biglist'  , controls(_I*) lasiter(100) verbose(1) fdisplay(1) 
local zselected `r(selected)' 
di "`zselected'" 

***TEST!***



***************************************************************
******************* TABLE 5, column 1: OLS ********************
***************************************************************

use "data_intensive_1y_HS4.dta", clear

areg d.lpeso d.lsaldotot, r cl(pc) a(pc)


*******************************************************************************
******************* IV intensive margin (Tables 5, 7, and 8) **********************
*******************************************************************************

use "data_intensive_1y_HS4.dta", clear
foreach var of varlist lsaldotot  lfob* lpeso*  ship_freq lship_freq* lship_sizefob* lship_sizepeso* paycash_WFOB transair_WFOB {
	gen D`var'=d.`var'
}
gen Llnpartcoun=l.lnpartcoun
gen Llnpart=l.lnpart
gen Llncount=l.lncount
gen lpesototal=ln(pesototal)
gen Llpesototal=l.lpesototal
gen Llsaldotot=l.lsaldotot
gen Lfrac_dollar=l.frac_dollar 
gen Lfrac_dollartot=l.frac_dollartot
gen unitprice=fob_dolpol/peso_neto
gen Lunitprice=l.unitprice
keep if post==1 & Dlpeso<. & Dlsaldotot<.
xtset pc ruc

*******Table 5, column 2 ***************
*Instrument: fraction of debt from exposed banks (discrete exposed bank definition)  
xtivreg Dlpeso (Dlsaldotot = fexposure_2006), fe 

*******Table 7 (Export arrangements) ***************
foreach var of varlist Dlship_freq Dlship_sizepeso Dlship_sizefob Dpaycash_WFOB Dtransair_WFOB {
	xtivreg `var' (Dlsaldotot = fexposure_2006), fe 
}

*******Table 8 (test with FOB instead of volume) ***************
xtivreg Dlfob (Dlsaldotot = fexposure_2006), fe 

*******Table 8 (robustness to instrument) ***************
*Instrument: 3rd degree polynomial of continuous exposure measure - fraction of debt at bank x fraction of bank's foreign liabilities
foreach num of numlist 1(1)3 {
	gen wexposure_2006_`num'=wexposure_2006^`num'
}
xtivreg Dlpeso (Dlsaldotot = wexposure1_2006 wexposure2_2006 wexposure3_2006  ), fe 

*******Table 8 (Using instrument with exposures in December 2007) ***************
xtivreg Dlpeso (Dlsaldotot = fexposure_07 ), fe 

*******Table 8 (Firm Level controls (size, dollar liabilities, number of products and destimations) , and unit price) ***************
xtivreg Dlpeso Llpesototal Llnpart Llncount Lfrac_dollartot Lunitprice (Dlsaldotot = fexposure_2006), fe 



**************************************************************************************************************
******************* IV intensive margin: Selection regressions (Table 5, columns 3 through 7 *****************
**************************************************************************************************************

use "data_intensive_1y_HS4.dta" , clear
foreach var of varlist lsaldotot  lfob* lpeso*  ship_freq lship_freq* lship_sizefob* lship_sizepeso* paycash_WFOB transair_WFOB {
	gen D`var'=d.`var'
}
gen Llnpartcoun=l.lnpartcoun
gen Llnpart=l.lnpart
gen Llncount=l.lncount
gen lpesototal=ln(pesototal)
gen Llpesototal=l.lpesototal
gen Llsaldotot=l.lsaldotot
gen Lfrac_dollar=l.frac_dollar 
gen Lfrac_dollartot=l.frac_dollartot
gen unitprice=fob_dolpol/peso_neto
gen Lunitprice=l.unitprice

*for the selection estimations:
gen byte exportsinpost=f.fob_dolpol<. if post==0
gen int part3=cond(part4<1000,part4,int(part4/10))
gen int part2=cond(part4<1000,int(part4/10),int(part4/100))
egen p2d=group(part2 country_code)

*For the selection equation...
probit exportsinpost lpeso lpesototal lsaldotot fexposure_2006  i.p2d  
predict probability if post==0
gen Lprobability=l.probability

*SELECTION REGRESSIONS
keep if post==1 & Dlpeso<. & Dlsaldotot<.
xtset pc ruc
centile Lprobability, c(20 40 60 80)
foreach num of numlist `r(c_1)' `r(c_2)' `r(c_3)' `r(c_4)'  {
di `num'
xtivreg Dlpeso (Dlsaldotot = fexposure_2006  ) if Lprobability>`num' & Lprobability<. & post==1, fe 
}





****************************************************************************************************************
******************* TABLE 10: elasticity by product characteristics (intensive only) **********************
****************************************************************************************************************
* Split by RAJAN-ZINGALES external fin dependence

use "data_intensive_1y_HS4.dta" , clear
foreach var of varlist lsaldotot  lfob lpeso lncount_byp lnpart_byc lavgdist_byp {
	gen D`var'=d.`var'
}
sum extfin
gen Nextfin=(extfin-r(mean))/r(sd)
foreach var of varlist  fexposure_2006 {
	gen `var'_Nextfin=`var'*Nextfin
}

gen Dlsaldotot_Nextfin=Dlsaldotot*Nextfin
keep if extfin<.
keep if post==1 
xtset pc ruc

xtivreg Dlpeso (Dlsaldotot Dlsaldotot_Nextfin= fexposure_2006  fexposure_2006_Nextfin), fe 





*******************************************************************
******************* TABLE 9: estimation bias **********************
*******************************************************************

	
	
* Size split by DISTANCE
use "data_intensive_1y_HS4.dta" , clear
foreach var of varlist lsaldotot  lfob lpeso lncount_byp lnpart_byc lavgdist_byp {
	gen D`var'=d.`var'
}


rename firmSUB50p_2006 firmSUB50p
quietly sum distanceinkm
gen Ndistance=(distanceinkm-r(mean))/r(sd)
gen firmSUB50p_Ndistance=firmSUB50p*Ndistance
foreach var of varlist  fexposure_2006  {
	gen `var'_Ndistance=`var'*Ndistance
}
gen Dlsaldotot_Ndistance=Dlsaldotot*Ndistance
keep if Ndistance<.
keep if post==1 
set more off
xtset pc ruc

*w/o FE
xtivreg Dlpeso (Dlsaldotot Dlsaldotot_Ndistance= fexposure_2006 fexposure_2006_Ndistance)
*Prod-Dest FE
xtivreg Dlpeso (Dlsaldotot Dlsaldotot_Ndistance= fexposure_2006 fexposure_2006_Ndistance), fe 


	

* Split by fraction of the export FLOW that was shipped by Air
use "data_intensive_1y_HS4.dta" , clear
foreach var of varlist lsaldotot  lfob lpeso lncount_byp lnpart_byc lavgdist_byp {
	gen D`var'=d.`var'
}
rename firmSUB50p_2006 firmSUB50p
sum transair_WFOB
gen Ntransair_WFOB=(transair_WFOB-r(mean))/r(sd)
gen firmSUB50p_Ntransair_WFOB=firmSUB50p*Ntransair_WFOB
foreach var of varlist  fexposure_2006  {
	gen `var'_Ntransair_WFOB=`var'*Ntransair_WFOB
}
gen Dlsaldotot_Ntransair_WFOB=Dlsaldotot*Ntransair_WFOB
keep if Ntransair_WFOB<.
keep if post==1 
set more off
xtset pc ruc

*w/o FE
xtivreg Dlpeso Ntransair_WFOB (Dlsaldotot Dlsaldotot_Ntransair_WFOB= fexposure_2006 fexposure_2006_Ntransair_WFOB)
*Prod-Dest FE
xtivreg Dlpeso Ntransair_WFOB (Dlsaldotot Dlsaldotot_Ntransair_WFOB= fexposure_2006 fexposure_2006_Ntransair_WFOB), fe 


	
* Split by fraction of the export FLOW that was paid CASH
use "data_intensive_1y_HS4.dta" , clear
foreach var of varlist lsaldotot  lfob lpeso lncount_byp lnpart_byc lavgdist_byp {
	gen D`var'=d.`var'
}
rename firmSUB50p_2006 firmSUB50p
sum paycash_WFOB
gen Npaycash_WFOB=(paycash_WFOB-r(mean))/r(sd)
gen firmSUB50p_Npaycash_WFOB=firmSUB50p*Npaycash_WFOB
foreach var of varlist  fexposure_2006 {
	gen `var'_Npaycash_WFOB=`var'*Npaycash_WFOB
}
gen Dlsaldotot_Npaycash_WFOB=Dlsaldotot*Npaycash_WFOB
keep if Npaycash_WFOB<.
keep if post==1 
set more off
xtset pc ruc

*w/o FE
xtivreg Dlpeso Npaycash_WFOB (Dlsaldotot Dlsaldotot_Npaycash_WFOB= fexposure_2006 fexposure_2006_Npaycash_WFOB)
*Prod-Dest FE
xtivreg Dlpeso Npaycash_WFOB (Dlsaldotot Dlsaldotot_Npaycash_WFOB= fexposure_2006 fexposure_2006_Npaycash_WFOB), fe 


	

	
	
******************************	
******FOR THE APPENDIX********
******************************



***Bootstrap clustered by RUC:
use "data_intensive_1y_HS4.dta" , clear
foreach var of varlist lsaldotot  lpeso*   {
	gen D`var'=d.`var'
}
keep if post==1 & Dlpeso<. & Dlsaldotot<.
keep  ruc country_code part4 Dlsaldotot Dlpeso  fexposure_2006
egen pd=group(country_code part4)
xtset pd

*Continuous Instrument 
*xtivreg Dlpeso (Dlsaldotot = fexposure_2006), fe 
*	outreg2  using "FINTRADE_fpclevel_1303.xls", append ct(IV (frac) - d.lpeso) bdec(3) aster(coef) se e( r2 r2_a df_r df_a )

*Step 1
xtivreg Dlpeso (Dlsaldotot = fexposure_2006), fe 
matrix observe = ( _b[Dlsaldotot] )

*Step 2
capture program drop myboot
program define myboot, rclass
 preserve 
  bsample, cluster(ruc)
  xtivreg Dlpeso (Dlsaldotot = fexposure_2006), fe
  return scalar beta = _b[Dlsaldotot]
 restore
end

*Step 3
simulate beta=r(beta), reps(1000) seed(12345): myboot

*Step 4
bstat , stat(observe) n(1000)

estat bootstrap, all

/*
Bootstrap results                               Number of obs      =      1000
                                                Replications       =      1000

------------------------------------------------------------------------------
             |   Observed   Bootstrap                         Normal-based
             |      Coef.   Std. Err.      z    P>|z|     [95% Conf. Interval]
-------------+----------------------------------------------------------------
        beta |   .1952584   .1029017     1.90   0.058    -.0064252     .396942
------------------------------------------------------------------------------

*/






	

* Split by NUMBER OF LENDERS
use "data_intensive_1y_HS4.dta" , clear
foreach var of varlist lsaldotot  lfob lpeso  {
	gen D`var'=d.`var'
}
rename firmSUB50p_2006 firmSUB50p
gen manybanks=nbanks_g10==4
gen fexposure_2006_manybanks=fexposure_2006*manybanks
gen Dlsaldotot_manybanks=Dlsaldotot*manybanks
keep if nbanks_g10<.
keep if post==1 
set more off
egen pc_manybanks=group( country_code part4 manybanks)
xtset pc_manybanks ruc
xtivreg Dlpeso (Dlsaldotot Dlsaldotot_manybanks= fexposure_2006 fexposure_2006_manybanks), fe 

	

	
* Split by TRADE CREDIT USE IN THE INDUSTRY 
use "data_intensive_1y_HS4.dta" , clear
foreach var of varlist lsaldotot  lfob lpeso  {
	gen D`var'=d.`var'
}
sum tcred
gen Ntcred=(tcred-r(mean))/r(sd)
foreach var of varlist  fexposure_2006 {
	gen `var'_Ntcred=`var'*Ntcred
}
gen Dlsaldotot_Ntcred=Dlsaldotot*Ntcred
keep if tcred<.
keep if post==1 
set more off
xtset pc ruc
*Prod-Dest FE
xtivreg Dlpeso (Dlsaldotot Dlsaldotot_Ntcred= fexposure_2006 fexposure_2006_Ntcred), fe 
	
	
	

* Split by HOMOGENEOUS 
use "data_intensive_1y_HS4.dta" , clear
foreach var of varlist lsaldotot  lfob lpeso  {
	gen D`var'=d.`var'
}
rename firmSUB50p_2006 firmSUB50p
gen fexposure_2006_homogen=fexposure_2006*homogen_rc
gen Dlsaldotot_homogen=Dlsaldotot*homogen_rc
keep if homogen_rc<.
keep if post==1 
set more off
egen pc_homogen=group( country_code part4 homogen_rc)
xtset pc_homogen ruc
xtivreg Dlpeso (Dlsaldotot Dlsaldotot_homogen = fexposure_2006 fexposure_2006_homogen), fe 


	
*Only subsample of homogeneous goods
xtivreg Dlpeso (Dlsaldotot = fexposure_2006 ) if homogen_rc==0, fe 
xtivreg Dlpeso (Dlsaldotot =  wexposure_2006 wexposure2_2006 wexposure3_2006 ) if homogen_rc==0, fe 
	
	
	
	
******END OF APPENDIX ********



	
	











